/**
 * Skill Generation Utilities
 *
 * Shared utilities for generating skill and command files.
 */
import { getOpsxExploreCommandTemplate, type SkillTemplate } from '../templates/skill-templates.js';
import type { CommandContent } from '../command-generation/index.js';
/**
 * Skill template with directory name mapping.
 */
export interface SkillTemplateEntry {
    template: SkillTemplate;
    dirName: string;
}
/**
 * Command template with ID mapping.
 */
export interface CommandTemplateEntry {
    template: ReturnType<typeof getOpsxExploreCommandTemplate>;
    id: string;
}
/**
 * Gets all skill templates with their directory names.
 */
export declare function getSkillTemplates(): SkillTemplateEntry[];
/**
 * Gets all command templates with their IDs.
 */
export declare function getCommandTemplates(): CommandTemplateEntry[];
/**
 * Converts command templates to CommandContent array.
 */
export declare function getCommandContents(): CommandContent[];
/**
 * Generates skill file content with YAML frontmatter.
 *
 * @param template - The skill template
 * @param generatedByVersion - The OpenSpec version to embed in the file
 */
export declare function generateSkillContent(template: SkillTemplate, generatedByVersion: string): string;
//# sourceMappingURL=skill-generation.d.ts.map