interface Choice {
    name: string;
    value: string;
    description?: string;
    configured?: boolean;
    configuredLabel?: string;
    preSelected?: boolean;
}
interface Config {
    message: string;
    choices: Choice[];
    pageSize?: number;
    validate?: (selected: string[]) => boolean | string;
}
/**
 * A searchable multi-select prompt with visible search box,
 * selected items display, and intuitive keyboard navigation.
 *
 * - Type to filter choices
 * - ↑↓ to navigate
 * - Enter to add highlighted item
 * - Backspace to remove last selected item (or delete search char)
 * - Tab to confirm selections
 */
export declare function searchableMultiSelect(config: Config): Promise<string[]>;
export default searchableMultiSelect;
//# sourceMappingURL=searchable-multi-select.d.ts.map