/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.jsondiagram;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.FileFormatOption;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.command.Command;
import net.sourceforge.plantuml.command.CommandControl;
import net.sourceforge.plantuml.command.CommonCommands;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.core.DiagramDescription;
import net.sourceforge.plantuml.core.ImageData;
import net.sourceforge.plantuml.core.UmlSource;
import net.sourceforge.plantuml.json.JsonArray;
import net.sourceforge.plantuml.json.JsonValue;
import net.sourceforge.plantuml.jsondiagram.SmetanaForJson;
import net.sourceforge.plantuml.jsondiagram.StyleExtractor;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.hand.UGraphicHandwritten;
import net.sourceforge.plantuml.klimt.font.FontConfiguration;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.font.UFont;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.preproc.PreprocessingArtifact;
import net.sourceforge.plantuml.skin.UmlDiagramType;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.yaml.Highlighted;

public class JsonDiagram
extends TitledDiagram {
    private final JsonValue root;
    private final List<Highlighted> highlighted;
    private final boolean handwritten;

    public JsonDiagram(UmlSource source, UmlDiagramType type, JsonValue json, List<Highlighted> highlighted, StyleExtractor styleExtractor, PreprocessingArtifact preprocessing) {
        super(source, type, null, preprocessing);
        this.handwritten = styleExtractor.isHandwritten();
        if (json != null && (json.isString() || json.isBoolean() || json.isNumber() || json.isNull())) {
            this.root = new JsonArray();
            ((JsonArray)this.root).add(json);
        } else if (json != null && (json.isArray() && json.asArray().isEmpty() || json.isObject() && json.asObject().isEmpty())) {
            this.root = new JsonArray();
            ((JsonArray)this.root).add("");
        } else {
            this.root = json;
        }
        this.highlighted = highlighted;
        String scale = styleExtractor.getScale();
        if (scale != null) {
            ArrayList<Command> cmds = new ArrayList<Command>();
            CommonCommands.addCommonScaleCommands(cmds);
            BlocLines lines = BlocLines.singleString(scale);
            for (Command cmd : cmds) {
                if (cmd.isValid(lines) != CommandControl.OK) continue;
                ((SingleLineCommand2)cmd).execute(this, lines, ParserPass.ONE);
            }
        }
    }

    @Override
    public DiagramDescription getDescription() {
        if (this.getUmlDiagramType() == UmlDiagramType.YAML) {
            return new DiagramDescription("(Yaml)");
        }
        if (this.getUmlDiagramType() == UmlDiagramType.HCL) {
            return new DiagramDescription("(HCL)");
        }
        return new DiagramDescription("(Json)");
    }

    @Override
    protected ImageData exportDiagramNow(OutputStream os, int index, FileFormatOption fileFormatOption) throws IOException {
        return this.createImageBuilder(fileFormatOption).drawable(this.getTextMainBlock(fileFormatOption)).write(os);
    }

    private void drawInternal(UGraphic ug) {
        if (this.handwritten) {
            ug = new UGraphicHandwritten(ug);
        }
        if (this.root == null) {
            Display display = Display.getWithNewlines(this.getSkinParam().getPragma(), "Your data does not sound like " + (Object)((Object)this.getUmlDiagramType()) + " data");
            FontConfiguration fontConfiguration = FontConfiguration.blackBlueTrue(UFont.courier(14));
            TextBlock result = display.create(fontConfiguration, HorizontalAlignment.LEFT, this.getSkinParam());
            result = TextBlockUtils.withMargin(result, 5.0, 2.0);
            result.drawU(ug);
        } else {
            new SmetanaForJson(ug, this.getSkinParam()).drawMe(this.root, this.highlighted);
        }
    }

    @Override
    protected TextBlock getTextMainBlock(final FileFormatOption fileFormatOption) {
        return new AbstractTextBlock(){

            @Override
            public void drawU(UGraphic ug) {
                JsonDiagram.this.drawInternal(ug);
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return TextBlockUtils.getMinMax(JsonDiagram.this.getTextMainBlock(fileFormatOption), stringBounder, true).getDimension();
            }
        };
    }
}

