/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.font;

import java.awt.Font;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class FontStack {
    private final List<Font> fonts = new ArrayList<Font>();
    private final String fullDefinition;

    public FontStack(String fullDefinition) {
        this.fullDefinition = fullDefinition;
    }

    private List<Font> getFonts() {
        if (this.fonts.size() == 0) {
            for (String name : this.fullDefinition.split(",")) {
                name = FontStack.trimWhitespaceOrDoubleQuote(name);
                Font font = Font.decode(name);
                this.fonts.add(font);
            }
        }
        return this.fonts;
    }

    public int canDisplayUpTo(int index, String text) {
        return this.getFonts().get(index).canDisplayUpTo(text);
    }

    public Font getFont(String text, int style, int size) {
        if (this.getFonts().size() > 1 && text != null) {
            for (Font font : this.getFonts()) {
                if (font.canDisplayUpTo(text) != -1) continue;
                return font.deriveFont(style, size);
            }
        }
        return this.getFonts().get(0).deriveFont(style, size);
    }

    private static boolean isWhitespaceOrDoubleQuote(char c) {
        return Character.isWhitespace(c) || c == '\"';
    }

    private static String trimWhitespaceOrDoubleQuote(String s) {
        int start;
        int end = s.length();
        for (start = 0; start < end && FontStack.isWhitespaceOrDoubleQuote(s.charAt(start)); ++start) {
        }
        while (end > start && FontStack.isWhitespaceOrDoubleQuote(s.charAt(end - 1))) {
            --end;
        }
        return s.substring(start, end);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FontStack)) {
            return false;
        }
        FontStack other = (FontStack)obj;
        return Objects.equals(this.fullDefinition, other.fullDefinition);
    }

    public int hashCode() {
        return Objects.hash(this.fullDefinition);
    }

    public String toString() {
        return "FontStack[" + this.fullDefinition + "]";
    }

    public String getFullDefinition() {
        return this.fullDefinition;
    }
}

