/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.creole;

import java.util.List;
import java.util.Objects;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.creole.Neutron;
import net.sourceforge.plantuml.klimt.creole.SheetBlock1;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.creole.atom.Atom;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.drawing.UGraphicStencil;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.geom.XRectangle2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.svek.Ports;
import net.sourceforge.plantuml.svek.WithPorts;

public final class SheetBlock2
extends AbstractTextBlock
implements TextBlock,
Atom,
WithPorts {
    private final SheetBlock1 block;
    private final UStroke defaultStroke;
    private final Stencil stencil;

    public SheetBlock2 enlargeMe(final double delta1, final double delta2) {
        Stencil newStencil = new Stencil(){

            @Override
            public double getStartingX(StringBounder stringBounder, double y) {
                return SheetBlock2.this.stencil.getStartingX(stringBounder, y) - delta1;
            }

            @Override
            public double getEndingX(StringBounder stringBounder, double y) {
                return SheetBlock2.this.stencil.getEndingX(stringBounder, y) + delta2;
            }
        };
        return new SheetBlock2(this.block, newStencil, this.defaultStroke);
    }

    public SheetBlock2(SheetBlock1 block, Stencil stencil, UStroke defaultStroke) {
        this.block = block;
        this.stencil = Objects.requireNonNull(stencil);
        this.defaultStroke = defaultStroke;
    }

    private HorizontalAlignment getHorizontalAlignment() {
        return this.block.getHorizontalAlignment();
    }

    public String toString() {
        return this.block.toString();
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        return this.block.calculateDimension(stringBounder);
    }

    @Override
    public void drawU(UGraphic ug) {
        if (this.stencil != null) {
            ug = UGraphicStencil.create(ug, this.stencil, this.defaultStroke);
        }
        if (this.getHorizontalAlignment() == HorizontalAlignment.CENTER && this.block.getMinimumWidth() > 0.0) {
            double width = this.calculateDimension(ug.getStringBounder()).getWidth();
            double dx = (this.block.getMinimumWidth() - width) / 2.0;
            ug = ug.apply(UTranslate.dx(dx));
        }
        this.block.drawU(ug);
    }

    @Override
    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public XRectangle2D getInnerPosition(CharSequence member, StringBounder stringBounder) {
        return this.block.getInnerPosition(member, stringBounder);
    }

    @Override
    public Ports getPorts(StringBounder stringBounder) {
        return new Ports();
    }

    @Override
    public List<Neutron> getNeutrons() {
        throw new UnsupportedOperationException();
    }
}

