#!/bin/bash
# Test suite for Tcl examples.
#
# Copyright (C) 2004-2018 Alan W. Irwin
# Copyright (C) 2004 Rafael Laboissiere
# Copyright (C) 2004 Andrew Ross
#
# This file is part of PLplot.
#
# PLplot is free software; you can redistribute it and/or modify
# it under the terms of the GNU Library General Public License as published
# by the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# PLplot is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU Library General Public License for more details.
#
# You should have received a copy of the GNU Library General Public License
# along with PLplot; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA

# This is called from plplot-test.sh with $tcldir, $device, $dsuffix,
# $options, and possibly $verbose_test defined.

PLATFORM=UNIX

# Put pltcl on the PATH.
PLTCL_DIR="/opt/local/bin"
if [ "$PLATFORM" = "CYGWIN" -o "$PLATFORM" = "MSYS" -o "$PLATFORM" = "MINGW" ] ; then
    # Convert from "<drive_letter>:/" to "/<drive_letter>/" form.
    re='^([a-zA-Z]):/(.*)'
    if [[ "$PLTCL_DIR" =~ $re ]] ; then
	PLTCL_DIR=/"${BASH_REMATCH[1]}/${BASH_REMATCH[2]}"
    fi
fi

PATH="$PLTCL_DIR":"$PATH"
if [ "$PLATFORM" = "MSVC" ] ; then
    cp test_tcl_caller.bat "$tcldir"
fi
lang="t"

if [ "$PLATFORM" = "CYGWIN" -o "$PLATFORM" = "MSYS" -o "$PLATFORM" = "MINGW" ] ; then
    cd "${OUTPUT_DIR}"
    # On the above Windows platforms (but apparently not MSVC) this
    # sed stanza is needed to converts from leading slash form to
    # drive-letter form.  This distinction matters for all prompted
    # filenames (e.g., example 14) but does not matter for -o options.
    results="$(pwd |sed 's?^/\(.\)/?\1:/?')"
    cd "$tcldir"
else
    cd "${OUTPUT_DIR}"
    results="$(pwd)"
    cd "$tcldir"
fi
export results

if [ "$verbose_test" ] ; then
    echo "/opt/local/bin/pltcl demo of plot"
fi
"/opt/local/bin/pltcl" -dev $device -o "$results/plot%n.$dsuffix" $options <<EOF 2> "tcl_${device}_test.error"
plinit
source plot.tcl
plot stats.log {1 4}
plot stats.log
plot r.dat
plot plot.dat
exit
EOF
status_code=$?
cat "tcl_${device}_test.error"
if [ "$status_code" -ne 0 ] ; then
    exit $status_code
fi
# Look for any PLPLOT ERROR messages from plwarn that do not result in an
# exit code.
is_error=`grep -l 'PLPLOT ERROR' "tcl_${device}_test.error"`
if [ -n "$is_error" ] ; then
    exit 1
fi
if [ "$verbose_test" ] ; then
    echo "/opt/local/bin/pltcl demo of plgrid"
fi
"/opt/local/bin/pltcl" -dev $device -o "$results/plgrid%n.$dsuffix" $options <<EOF 2> "tcl_${device}_test.error"
plinit
source plgrid.tcl
plgrid
exit
EOF
status_code=$?
cat "tcl_${device}_test.error"
if [ "$status_code" -ne 0 ] ; then
    exit $status_code
fi
# Look for any PLPLOT ERROR messages from plwarn that do not result in an
# exit code.
is_error=`grep -l 'PLPLOT ERROR' "tcl_${device}_test.error"`
if [ -n "$is_error" ] ; then
    exit 1
fi
for index in 00 01 02 03 04 05 06 07 08 09 10 11 12 13 15 16 18 19 20 21 22 23 24 25 26 27 28 30 31 33 ${critical_examples} ; do
    if [ "$verbose_test" ] ; then
	echo "x${index}"
    fi
    if [ "$index" = "14" ] ; then
	echo "${results}"/x${index}a${lang}%n.$dsuffix | \
	    /bin/bash x${index} -dev $device \
	    -o "$results"/x${index}${lang}%n.$dsuffix \
	    $options "" 2> "tcl_${device}_test.error" >| "${results}"/x${index}${lang}_${dsuffix}.txt
	status_code=$?
    else
	/bin/bash x${index} -dev $device \
	    -o "$results"/x${index}${lang}%n.$dsuffix \
	    $options "" 2> "tcl_${device}_test.error" >| "${results}"/x${index}${lang}_${dsuffix}.txt
	status_code=$?
    fi
    cat "tcl_${device}_test.error"
    if [ "$status_code" -ne 0 ] ; then
	exit $status_code
    fi
  # Look for any PLPLOT ERROR messages from plwarn that do not result in an
  # exit code.
    is_error=`grep -l 'PLPLOT ERROR' "tcl_${device}_test.error"`
    if [ -n "$is_error" ] ; then
	exit 1
    fi
done
