#! /usr/bin/env python

'''
Python Interface to SAGA Tools Library
----------
- Category : Import/Export
- Name     : Web Services
- ID       : io_webservices

Description
----------
Web Services
'''

from PySAGA.helper import Tool_Wrapper

def Geocoding(
    ADDRESSES=None,
    LOCATIONS=None,
    FIELD=None,
    ADDRESS=None,
    PROVIDER=None,
    API_KEY=None,
    METADATA=None,
    CRS_STRING=None, Verbose=2):
    '''
    Geocoding
    ----------
    [io_webservices.0]\n
    Geocoding of addresses using geocoding services.\n
    Arguments
    ----------
    - ADDRESSES [`optional input table`] : Address List
    - LOCATIONS [`output shapes`] : Locations
    - FIELD [`table field`] : Address Field
    - ADDRESS [`text`] : Single Address. Default: Bundesstrasse 55, Hamburg, Germany
    - PROVIDER [`choice`] : Service Provider. Available Choices: [0] Nominatim (OpenStreetMap) [1] The Data Science Toolkit [2] Google [3] Bing [4] MapQuest Default: 0
    - API_KEY [`text`] : API Key
    - METADATA [`boolean`] : Store Metadata. Default: 0
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '0', 'Geocoding')
    if Tool.is_Okay():
        Tool.Set_Input ('ADDRESSES', ADDRESSES)
        Tool.Set_Output('LOCATIONS', LOCATIONS)
        Tool.Set_Option('FIELD', FIELD)
        Tool.Set_Option('ADDRESS', ADDRESS)
        Tool.Set_Option('PROVIDER', PROVIDER)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('METADATA', METADATA)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_0(
    ADDRESSES=None,
    LOCATIONS=None,
    FIELD=None,
    ADDRESS=None,
    PROVIDER=None,
    API_KEY=None,
    METADATA=None,
    CRS_STRING=None, Verbose=2):
    '''
    Geocoding
    ----------
    [io_webservices.0]\n
    Geocoding of addresses using geocoding services.\n
    Arguments
    ----------
    - ADDRESSES [`optional input table`] : Address List
    - LOCATIONS [`output shapes`] : Locations
    - FIELD [`table field`] : Address Field
    - ADDRESS [`text`] : Single Address. Default: Bundesstrasse 55, Hamburg, Germany
    - PROVIDER [`choice`] : Service Provider. Available Choices: [0] Nominatim (OpenStreetMap) [1] The Data Science Toolkit [2] Google [3] Bing [4] MapQuest Default: 0
    - API_KEY [`text`] : API Key
    - METADATA [`boolean`] : Store Metadata. Default: 0
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '0', 'Geocoding')
    if Tool.is_Okay():
        Tool.Set_Input ('ADDRESSES', ADDRESSES)
        Tool.Set_Output('LOCATIONS', LOCATIONS)
        Tool.Set_Option('FIELD', FIELD)
        Tool.Set_Option('ADDRESS', ADDRESS)
        Tool.Set_Option('PROVIDER', PROVIDER)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('METADATA', METADATA)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def SRTM_CGIAR_CSI(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    DELARCHIVE=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    SRTM (CGIAR CSI)
    ----------
    [io_webservices.1]\n
    This tool provides easy-to-use access to the 'NASA Shuttle Radar Topography Mission Global 3 arc second' elevation data (about 90 meter resolution) as provided by the CGIAR CSI server. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the CGIAR CSI server.\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : Grid
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped.
    - DELARCHIVE [`boolean`] : Delete Archive Files. Default: 1 Do not keep archive files after download
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 270360.000000
    - XMAX [`floating point number`] : East. Default: 931320.000000
    - YMIN [`floating point number`] : South. Default: 5225850.000000
    - YMAX [`floating point number`] : North. Default: 6111540.000000
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 90.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '1', 'SRTM (CGIAR CSI)')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('DELARCHIVE', DELARCHIVE)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_1(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    DELARCHIVE=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    SRTM (CGIAR CSI)
    ----------
    [io_webservices.1]\n
    This tool provides easy-to-use access to the 'NASA Shuttle Radar Topography Mission Global 3 arc second' elevation data (about 90 meter resolution) as provided by the CGIAR CSI server. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the CGIAR CSI server.\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : Grid
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped.
    - DELARCHIVE [`boolean`] : Delete Archive Files. Default: 1 Do not keep archive files after download
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 270360.000000
    - XMAX [`floating point number`] : East. Default: 931320.000000
    - YMIN [`floating point number`] : South. Default: 5225850.000000
    - YMAX [`floating point number`] : North. Default: 6111540.000000
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 90.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '1', 'SRTM (CGIAR CSI)')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('DELARCHIVE', DELARCHIVE)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def Global_OpenTopography(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    DEMTYPE=None,
    API_KEY=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    BUFFER=None,
    CELLSIZEDEF=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    Global OpenTopography
    ----------
    [io_webservices.4]\n
    Download and optionally project global digital elevation model (DEM) data for the area of your interest provided by the OpenTopography project. The download needs a personal [API key] which can be obtained easily after login at the OpenTopography Data Portal.\n
    Available DEM products are:\n
    (-) SRTM GL3 90m\n
    (-) SRTM GL1 30m\n
    (-) SRTM GL1 Ellipsoidal 30m\n
    (-) ALOS World 3D 30m\n
    (-) ALOS World 3D Ellipsoidal, 30m\n
    (-) Global Bathymetry SRTM15+ V2.1 500m\n
    (-) NASADEM Global DEM\n
    (-) Copernicus Global DSM 30m\n
    (-) Copernicus Global DSM 90m\n
    (-) EU DTM 30m\n
    (-) GEDI_L3 DTM 1000m\n
    (-) Global Ice Bathymetry 500m\n
    (-) Global Sub-Ice Bathymetry 500m\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : Grid
    - DEMTYPE [`choice`] : DEM Type. Available Choices: [0] SRTM GL3 90m [1] SRTM GL1 30m [2] SRTM GL1 Ellipsoidal 30m [3] ALOS World 3D 30m [4] ALOS World 3D Ellipsoidal, 30m [5] Global Bathymetry SRTM15+ V2.1 500m [6] NASADEM Global DEM [7] Copernicus Global DSM 30m [8] Copernicus Global DSM 90m [9] EU DTM 30m [10] GEDI_L3 DTM 1000m [11] Global Ice Bathymetry 500m [12] Global Sub-Ice Bathymetry 500m Default: 3
    - API_KEY [`text`] : API Key
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 538350.000000
    - XMAX [`floating point number`] : East. Default: 598020.000000
    - YMIN [`floating point number`] : South. Default: 5906910.000000
    - YMAX [`floating point number`] : North. Default: 5965170.000000
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZEDEF [`choice`] : Take Cellsize. Available Choices: [0] data type resolution [1] user defined Default: 0
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 90.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '4', 'Global OpenTopography')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('DEMTYPE', DEMTYPE)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZEDEF', CELLSIZEDEF)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_4(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    DEMTYPE=None,
    API_KEY=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    BUFFER=None,
    CELLSIZEDEF=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    Global OpenTopography
    ----------
    [io_webservices.4]\n
    Download and optionally project global digital elevation model (DEM) data for the area of your interest provided by the OpenTopography project. The download needs a personal [API key] which can be obtained easily after login at the OpenTopography Data Portal.\n
    Available DEM products are:\n
    (-) SRTM GL3 90m\n
    (-) SRTM GL1 30m\n
    (-) SRTM GL1 Ellipsoidal 30m\n
    (-) ALOS World 3D 30m\n
    (-) ALOS World 3D Ellipsoidal, 30m\n
    (-) Global Bathymetry SRTM15+ V2.1 500m\n
    (-) NASADEM Global DEM\n
    (-) Copernicus Global DSM 30m\n
    (-) Copernicus Global DSM 90m\n
    (-) EU DTM 30m\n
    (-) GEDI_L3 DTM 1000m\n
    (-) Global Ice Bathymetry 500m\n
    (-) Global Sub-Ice Bathymetry 500m\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : Grid
    - DEMTYPE [`choice`] : DEM Type. Available Choices: [0] SRTM GL3 90m [1] SRTM GL1 30m [2] SRTM GL1 Ellipsoidal 30m [3] ALOS World 3D 30m [4] ALOS World 3D Ellipsoidal, 30m [5] Global Bathymetry SRTM15+ V2.1 500m [6] NASADEM Global DEM [7] Copernicus Global DSM 30m [8] Copernicus Global DSM 90m [9] EU DTM 30m [10] GEDI_L3 DTM 1000m [11] Global Ice Bathymetry 500m [12] Global Sub-Ice Bathymetry 500m Default: 3
    - API_KEY [`text`] : API Key
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 538350.000000
    - XMAX [`floating point number`] : East. Default: 598020.000000
    - YMIN [`floating point number`] : South. Default: 5906910.000000
    - YMAX [`floating point number`] : North. Default: 5965170.000000
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZEDEF [`choice`] : Take Cellsize. Available Choices: [0] data type resolution [1] user defined Default: 0
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 90.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '4', 'Global OpenTopography')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('DEMTYPE', DEMTYPE)
        Tool.Set_Option('API_KEY', API_KEY)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZEDEF', CELLSIZEDEF)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def USGS_Earthquake_Catalog(
    SHAPES=None,
    GRID=None,
    EARTHQUAKES=None,
    DATE_START=None,
    DATE_END=None,
    MAGNITUDE=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    BUFFER=None,
    CRS_STRING=None, Verbose=2):
    '''
    USGS Earthquake Catalog
    ----------
    [io_webservices.5]\n
    Request earthquake data from the USGS Earthquake Catalog.\n
    Arguments
    ----------
    - SHAPES [`input shapes`] : Shapes
    - GRID [`optional input grid`] : Grid
    - EARTHQUAKES [`output shapes`] : Earthquakes
    - DATE_START [`date`] : Start. Default: 2026-01-08
    - DATE_END [`date`] : End. Default: 2026-01-15
    - MAGNITUDE [`value range`] : Magnitude
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: -180.000000
    - XMAX [`floating point number`] : East. Default: 180.000000
    - YMIN [`floating point number`] : South. Default: -90.000000
    - YMAX [`floating point number`] : North. Default: 90.000000
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '5', 'USGS Earthquake Catalog')
    if Tool.is_Okay():
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Output('EARTHQUAKES', EARTHQUAKES)
        Tool.Set_Option('DATE_START', DATE_START)
        Tool.Set_Option('DATE_END', DATE_END)
        Tool.Set_Option('MAGNITUDE', MAGNITUDE)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_5(
    SHAPES=None,
    GRID=None,
    EARTHQUAKES=None,
    DATE_START=None,
    DATE_END=None,
    MAGNITUDE=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    BUFFER=None,
    CRS_STRING=None, Verbose=2):
    '''
    USGS Earthquake Catalog
    ----------
    [io_webservices.5]\n
    Request earthquake data from the USGS Earthquake Catalog.\n
    Arguments
    ----------
    - SHAPES [`input shapes`] : Shapes
    - GRID [`optional input grid`] : Grid
    - EARTHQUAKES [`output shapes`] : Earthquakes
    - DATE_START [`date`] : Start. Default: 2026-01-08
    - DATE_END [`date`] : End. Default: 2026-01-15
    - MAGNITUDE [`value range`] : Magnitude
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: -180.000000
    - XMAX [`floating point number`] : East. Default: 180.000000
    - YMIN [`floating point number`] : South. Default: -90.000000
    - YMAX [`floating point number`] : North. Default: 90.000000
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '5', 'USGS Earthquake Catalog')
    if Tool.is_Okay():
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Output('EARTHQUAKES', EARTHQUAKES)
        Tool.Set_Option('DATE_START', DATE_START)
        Tool.Set_Option('DATE_END', DATE_END)
        Tool.Set_Option('MAGNITUDE', MAGNITUDE)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def DGM1_Bayern(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    DGM1 Bayern
    ----------
    [io_webservices.6]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenData server of the 'Bayrische Vermessungsverwaltung (Bavaria)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '6', 'DGM1 Bayern')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_6(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    DGM1 Bayern
    ----------
    [io_webservices.6]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenData server of the 'Bayrische Vermessungsverwaltung (Bavaria)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '6', 'DGM1 Bayern')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def DGM1_MecklenburgVorpommern(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    DGM1 Mecklenburg-Vorpommern
    ----------
    [io_webservices.7]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeodata server of 'Mecklenburg-Western Pomerania (Mecklenburg-Vorpommern, MV)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The licensee is obligated to provide a clearly visible source reference for each public reproduction, distribution or presentation of the geodata, as well as for each publication or external use of any processing or modification, which must be designed as follows: © GeoBasis-DE/M-V (year of last data delivery)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '7', 'DGM1 Mecklenburg-Vorpommern')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_7(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    DGM1 Mecklenburg-Vorpommern
    ----------
    [io_webservices.7]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeodata server of 'Mecklenburg-Western Pomerania (Mecklenburg-Vorpommern, MV)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The licensee is obligated to provide a clearly visible source reference for each public reproduction, distribution or presentation of the geodata, as well as for each publication or external use of any processing or modification, which must be designed as follows: © GeoBasis-DE/M-V (year of last data delivery)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '7', 'DGM1 Mecklenburg-Vorpommern')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def DGM1_Niedersachsen(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Niedersachsen
    ----------
    [io_webservices.8]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeodata server of 'Lower Saxony (Niedersachsen)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    [License]\n
    The geodata (open geodata) listed on this LGLN ​​website can be used in accordance with the General Terms and Conditions of Use (GTC). The relevant terms of use can be found [here](https://www.lgln.niedersachsen.de/startseite/wir_uber_uns_amp_organisation/allgemeine_geschafts_und_nutzungsbedingungen_agnb/allgemeine-geschafts-und-nutzungsbedingungen-agnb-97401.html) under "7 Use of Open Geodata" of the GTC.\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '8', 'DGM1 Niedersachsen')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_8(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Niedersachsen
    ----------
    [io_webservices.8]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeodata server of 'Lower Saxony (Niedersachsen)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    [License]\n
    The geodata (open geodata) listed on this LGLN ​​website can be used in accordance with the General Terms and Conditions of Use (GTC). The relevant terms of use can be found [here](https://www.lgln.niedersachsen.de/startseite/wir_uber_uns_amp_organisation/allgemeine_geschafts_und_nutzungsbedingungen_agnb/allgemeine-geschafts-und-nutzungsbedingungen-agnb-97401.html) under "7 Use of Open Geodata" of the GTC.\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '8', 'DGM1 Niedersachsen')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def DGM1_NordrheinWestfalen(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Nordrhein-Westfalen
    ----------
    [io_webservices.9]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeodata server of 'North Rhine-Westphalia (Nordrhein-Westfalen, NRW)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [Data licence Germany - Zero - Version 2.0](https://www.govdata.de/dl-de/zero-2-0).\n
    Any use is permitted without restrictions or conditions. The data and meta-data provided may, for commercial and non-commercial use, in particular\n
    1. be copied, printed, presented, altered, processed and transmitted to third parties;\n
    2. be merged with own data and with the data of others and be combined to form new and independent datasets;\n
    3. be integrated in internal and external business processes, products and applications in public and non-public electronic networks.\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '9', 'DGM1 Nordrhein-Westfalen')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_9(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Nordrhein-Westfalen
    ----------
    [io_webservices.9]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeodata server of 'North Rhine-Westphalia (Nordrhein-Westfalen, NRW)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [Data licence Germany - Zero - Version 2.0](https://www.govdata.de/dl-de/zero-2-0).\n
    Any use is permitted without restrictions or conditions. The data and meta-data provided may, for commercial and non-commercial use, in particular\n
    1. be copied, printed, presented, altered, processed and transmitted to third parties;\n
    2. be merged with own data and with the data of others and be combined to form new and independent datasets;\n
    3. be integrated in internal and external business processes, products and applications in public and non-public electronic networks.\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '9', 'DGM1 Nordrhein-Westfalen')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def DGM1_RheinlandPfalz(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    DGM1 Rheinland-Pfalz
    ----------
    [io_webservices.10]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenData server of the 'Landesamt für Vermessung und Geobasisinformation Rheinland-Pfalz (Rhineland-Palatinate)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY-SA 4.0](creativecommons.org/licenses/by-sa/4.0/)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '10', 'DGM1 Rheinland-Pfalz')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_10(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    DGM1 Rheinland-Pfalz
    ----------
    [io_webservices.10]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenData server of the 'Landesamt für Vermessung und Geobasisinformation Rheinland-Pfalz (Rhineland-Palatinate)'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY-SA 4.0](creativecommons.org/licenses/by-sa/4.0/)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '10', 'DGM1 Rheinland-Pfalz')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def DGM1_SchleswigHolstein(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Schleswig-Holstein
    ----------
    [io_webservices.11]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeodata server of 'Schleswig-Holstein'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '11', 'DGM1 Schleswig-Holstein')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_11(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Schleswig-Holstein
    ----------
    [io_webservices.11]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeodata server of 'Schleswig-Holstein'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '11', 'DGM1 Schleswig-Holstein')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def DGM1_Sachsen(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Sachsen
    ----------
    [io_webservices.12]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeoData server of the 'Landesamt für Geobasisinformation Sachsen'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '12', 'DGM1 Sachsen')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_12(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Sachsen
    ----------
    [io_webservices.12]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeoData server of the 'Landesamt für Geobasisinformation Sachsen'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '12', 'DGM1 Sachsen')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def DGM1_Thüringen(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None,
    PERIOD=None, Verbose=2):
    '''
    DGM1 Thüringen
    ----------
    [io_webservices.13]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeoData server of the 'Landesamt für Geobasisinformation Thüringen'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)
    - PERIOD [`choice`] : Period. Available Choices: [0] 2014-2019 [1] 2020-2025 Default: 0 The catalogue 2020-2025 is still under construction.

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '13', 'DGM1 Thüringen')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        Tool.Set_Option('PERIOD', PERIOD)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_13(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None,
    PERIOD=None, Verbose=2):
    '''
    DGM1 Thüringen
    ----------
    [io_webservices.13]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeoData server of the 'Landesamt für Geobasisinformation Thüringen'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)
    - PERIOD [`choice`] : Period. Available Choices: [0] 2014-2019 [1] 2020-2025 Default: 0 The catalogue 2020-2025 is still under construction.

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '13', 'DGM1 Thüringen')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        Tool.Set_Option('PERIOD', PERIOD)
        return Tool.Execute(Verbose)
    return False

def DGM1_Brandenburg(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Brandenburg
    ----------
    [io_webservices.14]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeoData server of the 'Landesvermessung und Geobasisinformation Brandenburg'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '14', 'DGM1 Brandenburg')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_14(
    GRID=None,
    SHAPES=None,
    RESULT=None,
    TILES=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZE=None,
    CRS_STRING=None,
    DATASET=None, Verbose=2):
    '''
    DGM1 Brandenburg
    ----------
    [io_webservices.14]\n
    This tool provides easy-to-use access to the ''Digitales Geländemodell 1m (DGM1)'' elevation data from the OpenGeoData server of the 'Landesvermessung und Geobasisinformation Brandenburg'. It uses a local database in the chosen directory which provides the original tiles. If the tiles covering the requested area are not found in this directory the tool tries to download these from the server.\n
    The data is licensed under [CC BY 4.0](https://creativecommons.org/licenses/by/4.0/deed.de)\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - RESULT [`output data object`] : DGM1
    - TILES [`file path`] : Local Tiles Directory. Download location for tiles. If requested tile is already present download will be skipped. Takes user's temporary directory if empty.
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 0.000000
    - XMAX [`floating point number`] : East. Default: 1000.000000
    - YMIN [`floating point number`] : South. Default: 0.000000
    - YMAX [`floating point number`] : North. Default: 1000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 1001
    - NY [`integer number`] : Rows. Minimum: 1 Default: 1001
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.100000 Default: 1.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").
    - DATASET [`choice`] : Data Set. Available Choices: [0] DGM [1] DOM Default: 0 Download Digital Terrain Model (DGM) or Digital Surface Model (DOM)

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '14', 'DGM1 Brandenburg')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('RESULT', RESULT)
        Tool.Set_Option('TILES', TILES)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        Tool.Set_Option('DATASET', DATASET)
        return Tool.Execute(Verbose)
    return False

def CHELSA__Global_Climate_Data(
    GRID=None,
    SHAPES=None,
    GRIDS=None,
    OUTPUT=None,
    MEMTYPE=None,
    FOLDER=None,
    FORMAT=None,
    DATASET=None,
    DAILY_FROM=None,
    DAILY_TO=None,
    YEAR_FROM=None,
    YEAR_TO=None,
    PERIOD=None,
    MODEL=None,
    SCENARIO=None,
    CENTURY=None,
    CENTURY_FROM=None,
    CENTURY_TO=None,
    CENTURY_STEP=None,
    VAR_DAILY=None,
    VAR_MONTHLY=None,
    VAR_CLIMATE=None,
    VAR_BIOCLIM=None,
    VAR_T21K=None,
    VAR_T21K_BIOCLIM=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZEDEF=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    CHELSA - Global Climate Data
    ----------
    [io_webservices.15]\n
    Download, project and optionally resample climate data provided by [CHELSA](https://www.chelsa-climate.org/) ('Climatologies at High resolution for the Earth's Land Surface Areas') for the area of your interest.\n
    ____________\n
    Provided Variables\n
    <h5>Daily</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    clt	Total Cloud Cover Percentage	%	Total cloud area fraction (reported as a percentage) for the whole atmospheric column as seen from the surface or the top of the atmosphere. Includes both large-scale and convective cloud.\n
    hurs	Near-Surface Relative Humidity	%	The relative humidity with respect to liquid water for T> 0 C and with respect to ice for T\n
    pr	Precipitation	kg/m²	includes both liquid and solid phases\n
    ps	Surface Air Pressure	hPa	surface pressure (not mean sea-level pressure)\n
    rsds	Surface Downwelling Shortwave Flux in Air	W/m²	Surface solar irradiance for UV calculations.\n
    sfcWind	Near-Surface Wind Speed	m/s	near-surface (usually 10 meters) wind speed.\n
    tas	Daily Mean Near-Surface Air Temperature	°C	near-surface (usually 2 meter) air temperature\n
    tasmax	Daily Maximum Near-Surface Air Temperature	°C	maximum near-surface (usually 2 meter) air temperature\n
    tasmin	Daily Minimum Near-Surface Air Temperature	°C	minimum near-surface (usually 2 meter) air temperature\n
    tz	Air Temperature Lapse Rate	°C/100m	Rate of change in air temperature with altitude\n
    ============\n
    <h5>Monthly</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    clt	Total Cloud Cover Percentage	%	Total cloud area fraction (reported as a percentage) for the whole atmospheric column as seen from the surface or the top of the atmosphere. Includes both large-scale and convective cloud.\n
    cmi	Monthly Climate Moisture Index	kg/m²	Monthly ratio of precipitation to potential evapotranspiration; indicator of climatic water availability\n
    hurs	Near-Surface Relative Humidity	%	The relative humidity with respect to liquid water for T> 0 C and with respect to ice for T\n
    pet	Monthly Potential Evapotranspiration	kg/m²	Total potential evapotranspiration for the month assuming unlimited water availability calculated based on Penman Monteith\n
    pr	Precipitation	kg/m²	includes both liquid and solid phases\n
    rsds	Surface Downwelling Shortwave Flux in Air	W/m²	Surface solar irradiance for UV calculations.\n
    sfcWind	Near-Surface Wind Speed	m/s	near-surface (usually 10 meters) wind speed.\n
    spei12	Standardized Precipitation Evapotranspiration Index		Standardized index of climatic water balance (precipitation minus potential evapotranspiration) over a given integration period here 12 months expressed in standard deviations from the long term mean, used to characterize drought severity and duration\n
    spi12	Standardized Precipitation Index		Standardized index of precipitation anomalies over a given integration period here 12 months expressed in standard deviations from the long-term mean; used to characterize drought severity and duration without accounting for evapotranspiration\n
    tas	Daily Mean Near-Surface Air Temperature	°C	near-surface (usually 2 meter) air temperature\n
    tasmax	Daily Maximum Near-Surface Air Temperature	°C	maximum near-surface (usually 2 meter) air temperature\n
    tasmin	Daily Minimum Near-Surface Air Temperature	°C	minimum near-surface (usually 2 meter) air temperature\n
    vpd	Vapor Pressure Deficit	Pa	Difference between the saturation vapor pressure and actual vapor pressure representing atmospheric drying power\n
    ============\n
    <h5>Climatology</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    clt	Total Cloud Cover Percentage	%	Total cloud area fraction (reported as a percentage) for the whole atmospheric column as seen from the surface or the top of the atmosphere. Includes both large-scale and convective cloud.\n
    cmi	Monthly Climate Moisture Index	kg/m²	Monthly ratio of precipitation to potential evapotranspiration; indicator of climatic water availability\n
    hurs	Near-Surface Relative Humidity	%	The relative humidity with respect to liquid water for T> 0 C and with respect to ice for T\n
    pet	Monthly Potential Evapotranspiration	kg/m²	Total potential evapotranspiration for the month assuming unlimited water availability calculated based on Penman Monteith\n
    pr	Precipitation	kg/m²	includes both liquid and solid phases\n
    rsds	Surface Downwelling Shortwave Flux in Air	W/m²	Surface solar irradiance for UV calculations.\n
    sfcWind	Near-Surface Wind Speed	m/s	near-surface (usually 10 meters) wind speed.\n
    tas	Daily Mean Near-Surface Air Temperature	°C	near-surface (usually 2 meter) air temperature\n
    tasmax	Daily Maximum Near-Surface Air Temperature	°C	maximum near-surface (usually 2 meter) air temperature\n
    tasmin	Daily Minimum Near-Surface Air Temperature	°C	minimum near-surface (usually 2 meter) air temperature\n
    vpd	Vapor Pressure Deficit	Pa	Difference between the saturation vapor pressure and actual vapor pressure representing atmospheric drying power\n
    ============\n
    <h5>Bioclimatological Indicators</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    bio01	Mean Annual Near-Surface Air Temperature	°C	Mean annual temperature calculated as the average of mean monthly temperatures over the year\n
    bio02	Mean Diurnal Near-Surface Air Temperature Range	°C	Mean diurnal temperature range computed as the average of monthly (tasmax − tasmin)\n
    bio03	Isothermality	%	Isothermality: 100 × (bio02 ÷ bio07); compares day–night variability to annual temperature range\n
    bio04	Temperature Seasonality	°C	Temperature seasonality given by the standard deviation of mean monthly temperatures\n
    bio05	Mean Daily Maximum Near-Surface Air Temperature of the Warmest Month	°C	Highest monthly mean of daily maximum temperatures (tasmax) across the year; indicates peak thermal conditions\n
    bio06	Mean Daily Minimum Near-Surface Air Temperature of the Coldest Month	°C	Lowest monthly mean of daily minimum temperatures (tasmin) across the year; characterizes winter cold intensity\n
    bio07	Annual Daily Mean Near-Surface Air Temperature Range	°C	Annual temperature range calculated as bio05 − bio06; measures amplitude between warmest and coldest months\n
    bio08	Mean Daily Near-Surface Air Temperature of the Wettest Quarter	°C	Average monthly mean temperature over the wettest 3-month period of the year\n
    bio09	Mean Daily Near-Surface Air Temperature of the Driest Quarter	°C	Average monthly mean temperature over the driest 3-month period of the year\n
    bio10	Mean Daily Mean Near-Surface Air Temperature of the Warmest Quarter	°C	Average monthly mean temperature over the warmest 3-month period of the year\n
    bio11	Mean Daily Mean Near-Surface Air Temperature of the Quarter	°C	Average monthly mean temperature over the coldest 3-month period of the year\n
    bio12	Annual Precipitation	kg/m²	Sum of monthly precipitation totals across the year\n
    bio13	Precipitation of the Wettest Month	kg/m²	Maximum monthly precipitation total\n
    bio14	Precipitation of the Driest Month	kg/m²	Minimum monthly precipitation total\n
    bio15	Precipitation Seasonality	%	Coefficient of variation (100 × SD ÷ mean) of monthly precipitation totals\n
    bio16	Mean Monthly Precipitation of the Wettest Quarter	kg/m²	Average monthly precipitation during the wettest 3-month period of the year\n
    bio17	Mean Monthly Precipitation of the Driest Quarter	kg/m²	Average monthly precipitation during the driest 3-month period of the year\n
    bio18	Mean Monthly Precipitation of the Warmest Quarter	kg/m²	Average monthly precipitation during the warmest 3-month period of the year\n
    bio19	Mean Monthly Precipitation of the Coldest Quarter	kg/m²	Average monthly precipitation during the coldest 3-month period of the year\n
    fcf	Frost Change Frequency	days	Number of freeze–thaw transitions per year\n
    fgd	First Day of the Growing Season (TREELIM)	day of year	Day of the year number marking the first occurrence of growing season conditions\n
    gdd0	Growing Degree Days Heat Sum above 0 °C	°C	Sum of daily mean temperatures above 0 °C accumulated over the year\n
    gdd10	Growing Degree Days Heat Sum above 10 °C	°C	Sum of daily mean temperatures above 10 °C accumulated over the year\n
    gdd5	Growing Degree Days Heat Sum above 5 °C	°C	Sum of daily mean temperatures above 5 °C accumulated over the year\n
    gdgfgd10	First Growing Degree Day above 10 °C	day of year	Day of the year number of the first occurrence of a daily mean temperature above 10 °C\n
    gdgfgd5	First Growing Degree Day above 5 °C	day of year	Day of the year number of the first occurrence of a daily mean temperature above 5 °C\n
    gsl	Growing Season Length	days	Number of days between the first and last occurrence of growing season conditions\n
    gsp	Accumulated Precipiation Amount over Growing Season Days	kg/m²	Total precipitation accumulated during the growing season period\n
    gst	Mean Temperature of Growing Season Days	°C	Average daily mean temperature over all growing season days\n
    kg0	Köppen-Geiger Climate Classification	category	Köppen–Geiger climate classification\n
    kg1	Köppen-Geiger Climate Classification (without As/Aw)	category	Köppen–Geiger climate classification without As/Aw differenciation\n
    kg2	Köppen-Geiger Climate Classification (Peel et al. 2007)	category	Köppen–Geiger climate classification after href="https://doi.org/10.5194/hess-11-1633-2007">Peel et al. 2007\n
    kg3	Wissmann Climate Classification	category	Climate classification after Wissmann 1939\n
    kg4	Thornthwaite Climate Classification	category	Climate classification after Thornthwaite 1931\n
    kg5	Troll-Paffen Climate Classification	category	Climate classification after Troll-Paffen\n
    lgd	Last Day of the Growing Season (TREELIM)	day of year	Day of the year number of the last occurrence of growing season conditions\n
    ngd0	Number of Growing Degree Days above 0 °C	number of days	Total number of days in a year with mean daily temperature above 0 °C\n
    ngd10	Number of Growing Degree Days above 10 °C	number of days	Total number of days in a year with mean daily temperature above 10 °C\n
    ngd5	Number of Growing Degree Days above 5 °C	number of days	Total number of days in a year with mean daily temperature above 5 °C\n
    npp	Net Primary Production on Land as Carbon Mass Flux	gC/m²/yr	Production of carbon' means the production of biomass expressed as the mass of carbon which it contains. Net primary production is the excess of gross primary production (rate of synthesis of biomass from inorganic precursors) by autotrophs ('producers') for example photosynthesis in plants or phytoplankton over the rate at which the autotrophs themselves respire some of this biomass. 'Productivity' means production per unit area. The phrase 'expressed_as' is used in the construction A_expressed_as_B where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A neglecting all other chemical constituents of A.\n
    scd	Snow Cover Days	days	Number of days per year with snow cover present at the surface\n
    swe	Snow Water Equivalent	kg/m²/yr	Total water equivalent of snowpack accumulated over the year\n
    ============\n
    <h5>TraCE21k-centennial</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    pr	Precipitation	kg/m²	includes both liquid and solid phases\n
    tasmax	Daily Maximum Near-Surface Air Temperature	°C	maximum near-surface (usually 2 meter) air temperature\n
    tasmin	Daily Minimum Near-Surface Air Temperature	°C	minimum near-surface (usually 2 meter) air temperature\n
    tz	Air Temperature Lapse Rate	°C/100m	Rate of change in air temperature with altitude\n
    ============\n
    <h5>TraCE21k-centennial-bioclim</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    bio01	Mean Annual Near-Surface Air Temperature	°C	Mean annual temperature calculated as the average of mean monthly temperatures over the year\n
    bio02	Mean Diurnal Near-Surface Air Temperature Range	°C	Mean diurnal temperature range computed as the average of monthly (tasmax − tasmin)\n
    bio03	Isothermality	%	Isothermality: 100 × (bio02 ÷ bio07); compares day–night variability to annual temperature range\n
    bio04	Temperature Seasonality	°C	Temperature seasonality given by the standard deviation of mean monthly temperatures\n
    bio05	Mean Daily Maximum Near-Surface Air Temperature of the Warmest Month	°C	Highest monthly mean of daily maximum temperatures (tasmax) across the year; indicates peak thermal conditions\n
    bio06	Mean Daily Minimum Near-Surface Air Temperature of the Coldest Month	°C	Lowest monthly mean of daily minimum temperatures (tasmin) across the year; characterizes winter cold intensity\n
    bio07	Annual Daily Mean Near-Surface Air Temperature Range	°C	Annual temperature range calculated as bio05 − bio06; measures amplitude between warmest and coldest months\n
    bio08	Mean Daily Near-Surface Air Temperature of the Wettest Quarter	°C	Average monthly mean temperature over the wettest 3-month period of the year\n
    bio09	Mean Daily Near-Surface Air Temperature of the Driest Quarter	°C	Average monthly mean temperature over the driest 3-month period of the year\n
    bio10	Mean Daily Mean Near-Surface Air Temperature of the Warmest Quarter	°C	Average monthly mean temperature over the warmest 3-month period of the year\n
    bio11	Mean Daily Mean Near-Surface Air Temperature of the Quarter	°C	Average monthly mean temperature over the coldest 3-month period of the year\n
    bio12	Annual Precipitation	kg/m²	Sum of monthly precipitation totals across the year\n
    bio13	Precipitation of the Wettest Month	kg/m²	Maximum monthly precipitation total\n
    bio14	Precipitation of the Driest Month	kg/m²	Minimum monthly precipitation total\n
    bio15	Precipitation Seasonality	%	Coefficient of variation (100 × SD ÷ mean) of monthly precipitation totals\n
    bio16	Mean Monthly Precipitation of the Wettest Quarter	kg/m²	Average monthly precipitation during the wettest 3-month period of the year\n
    bio17	Mean Monthly Precipitation of the Driest Quarter	kg/m²	Average monthly precipitation during the driest 3-month period of the year\n
    bio18	Mean Monthly Precipitation of the Warmest Quarter	kg/m²	Average monthly precipitation during the warmest 3-month period of the year\n
    bio19	Mean Monthly Precipitation of the Coldest Quarter	kg/m²	Average monthly precipitation during the coldest 3-month period of the year\n
    glz	Ice Sheet Surface Altitude	m	Elevation of the ice sheet surface above sea level\n
    orog	Surface Altitude	m	The surface called 'surface' means the lower boundary of the atmosphere. Altitude is the (geometric) height above the geoid which is the reference geopotential surface. The geoid is similar to mean sea level.\n
    scd	Snow Cover Days	days	Number of days per year with snow cover present at the surface\n
    ============\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - GRIDS [`output grid list`] : Grids
    - OUTPUT [`choice`] : Output. Available Choices: [0] files [1] memory Default: 1
    - MEMTYPE [`choice`] : Type. Available Choices: [0] single grids [1] grid collection Default: 1
    - FOLDER [`file path`] : Folder
    - FORMAT [`choice`] : Format. Available Choices: [0] GeoTIFF (*.tif) [1] SAGA Compressed Grid File (*.sg-grd-z) Default: 1
    - DATASET [`choice`] : Data Set. Available Choices: [0] daily [1] monthly [2] climatology [3] bioclim [4] TraCE21k-cenntenial [5] TraCE21k-cenntenial-bioclim Default: 2
    - DAILY_FROM [`date`] : From Day. Default: 1979-01-01
    - DAILY_TO [`date`] : To Day. Default: 2024-12-31
    - YEAR_FROM [`integer number`] : From Year. Minimum: 1979 Maximum: 2021 Default: 1979
    - YEAR_TO [`integer number`] : To Year. Minimum: 1979 Maximum: 2021 Default: 2021
    - PERIOD [`choice`] : Period. Available Choices: [0] 1981-2010 [1] 2011-2040 [2] 2041-2070 [3] 2071-2100 Default: 0
    - MODEL [`choice`] : Model. Available Choices: [0] GFDL-ESM4 [1] IPSL-CM6A-LR [2] MPI-ESM1-2-HR [3] MRI-ESM2-0 [4] UKESM1-0-LL Default: 2
    - SCENARIO [`choice`] : Scenario. Available Choices: [0] ssp126 [1] ssp370 [2] ssp585 Default: 2
    - CENTURY [`integer number`] : Century. Minimum: -200 Maximum: 20 Default: -200
    - CENTURY_FROM [`integer number`] : From Century. Minimum: -200 Maximum: 20 Default: -200
    - CENTURY_TO [`integer number`] : To Century. Minimum: -200 Maximum: 20 Default: 20
    - CENTURY_STEP [`integer number`] : Step. Minimum: 1 Maximum: 55 Default: 1
    - VAR_DAILY [`choice`] : Variable. Available Choices: [0] Total Cloud Cover Percentage [1] Near-Surface Relative Humidity [2] Precipitation [3] Surface Air Pressure [4] Surface Downwelling Shortwave Flux in Air [5] Near-Surface Wind Speed [6] Daily Mean Near-Surface Air Temperature [7] Daily Maximum Near-Surface Air Temperature [8] Daily Minimum Near-Surface Air Temperature [9] Air Temperature Lapse Rate Default: 0
    - VAR_MONTHLY [`choice`] : Variable. Available Choices: [0] Total Cloud Cover Percentage [1] Monthly Climate Moisture Index [2] Near-Surface Relative Humidity [3] Monthly Potential Evapotranspiration [4] Precipitation [5] Surface Downwelling Shortwave Flux in Air [6] Near-Surface Wind Speed [7] Standardized Precipitation Evapotranspiration Index [8] Standardized Precipitation Index [9] Daily Mean Near-Surface Air Temperature [10] Daily Maximum Near-Surface Air Temperature [11] Daily Minimum Near-Surface Air Temperature [12] Vapor Pressure Deficit Default: 0
    - VAR_CLIMATE [`choice`] : Variable. Available Choices: [0] Total Cloud Cover Percentage [1] Monthly Climate Moisture Index [2] Near-Surface Relative Humidity [3] Monthly Potential Evapotranspiration [4] Precipitation [5] Surface Downwelling Shortwave Flux in Air [6] Near-Surface Wind Speed [7] Daily Mean Near-Surface Air Temperature [8] Daily Maximum Near-Surface Air Temperature [9] Daily Minimum Near-Surface Air Temperature [10] Vapor Pressure Deficit Default: 0
    - VAR_BIOCLIM [`choice`] : Variable. Available Choices: [0] Mean Annual Near-Surface Air Temperature [1] Mean Diurnal Near-Surface Air Temperature Range [2] Isothermality [3] Temperature Seasonality [4] Mean Daily Maximum Near-Surface Air Temperature of the Warmest Month [5] Mean Daily Minimum Near-Surface Air Temperature of the Coldest Month [6] Annual Daily Mean Near-Surface Air Temperature Range [7] Mean Daily Near-Surface Air Temperature of the Wettest Quarter [8] Mean Daily Near-Surface Air Temperature of the Driest Quarter [9] Mean Daily Mean Near-Surface Air Temperature of the Warmest Quarter [10] Mean Daily Mean Near-Surface Air Temperature of the Quarter [11] Annual Precipitation [12] Precipitation of the Wettest Month [13] Precipitation of the Driest Month [14] Precipitation Seasonality [15] Mean Monthly Precipitation of the Wettest Quarter [16] Mean Monthly Precipitation of the Driest Quarter [17] Mean Monthly Precipitation of the Warmest Quarter [18] Mean Monthly Precipitation of the Coldest Quarter [19] Frost Change Frequency [20] First Day of the Growing Season (TREELIM) [21] Growing Degree Days Heat Sum above 0 °C [22] Growing Degree Days Heat Sum above 10 °C [23] Growing Degree Days Heat Sum above 5 °C [24] First Growing Degree Day above 10 °C [25] First Growing Degree Day above 5 °C [26] Growing Season Length [27] Accumulated Precipiation Amount over Growing Season Days [28] Mean Temperature of Growing Season Days [29] Köppen-Geiger Climate Classification [30] Köppen-Geiger Climate Classification (without As/Aw) [31] Köppen-Geiger Climate Classification (Peel et al. 2007) [32] Wissmann Climate Classification [33] Thornthwaite Climate Classification [34] Troll-Paffen Climate Classification [35] Last Day of the Growing Season (TREELIM) [36] Number of Growing Degree Days above 0 °C [37] Number of Growing Degree Days above 10 °C [38] Number of Growing Degree Days above 5 °C [39] Net Primary Production on Land as Carbon Mass Flux [40] Snow Cover Days [41] Snow Water Equivalent [42] [all] Default: 0
    - VAR_T21K [`choice`] : Variable. Available Choices: [0] Precipitation [1] Daily Maximum Near-Surface Air Temperature [2] Daily Minimum Near-Surface Air Temperature [3] Air Temperature Lapse Rate Default: 0
    - VAR_T21K_BIOCLIM [`choice`] : Variable. Available Choices: [0] Mean Annual Near-Surface Air Temperature [1] Mean Diurnal Near-Surface Air Temperature Range [2] Isothermality [3] Temperature Seasonality [4] Mean Daily Maximum Near-Surface Air Temperature of the Warmest Month [5] Mean Daily Minimum Near-Surface Air Temperature of the Coldest Month [6] Annual Daily Mean Near-Surface Air Temperature Range [7] Mean Daily Near-Surface Air Temperature of the Wettest Quarter [8] Mean Daily Near-Surface Air Temperature of the Driest Quarter [9] Mean Daily Mean Near-Surface Air Temperature of the Warmest Quarter [10] Mean Daily Mean Near-Surface Air Temperature of the Quarter [11] Annual Precipitation [12] Precipitation of the Wettest Month [13] Precipitation of the Driest Month [14] Precipitation Seasonality [15] Mean Monthly Precipitation of the Wettest Quarter [16] Mean Monthly Precipitation of the Driest Quarter [17] Mean Monthly Precipitation of the Warmest Quarter [18] Mean Monthly Precipitation of the Coldest Quarter [19] Ice Sheet Surface Altitude [20] Surface Altitude [21] Snow Cover Days Default: 0
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 260000.000000
    - XMAX [`floating point number`] : East. Default: 941000.000000
    - YMIN [`floating point number`] : South. Default: 5215000.000000
    - YMAX [`floating point number`] : North. Default: 6121000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 682
    - NY [`integer number`] : Rows. Minimum: 1 Default: 907
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZEDEF [`choice`] : Take Cellsize. Available Choices: [0] data type resolution [1] user defined Default: 0
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 1000.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '15', 'CHELSA - Global Climate Data')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('GRIDS', GRIDS)
        Tool.Set_Option('OUTPUT', OUTPUT)
        Tool.Set_Option('MEMTYPE', MEMTYPE)
        Tool.Set_Option('FOLDER', FOLDER)
        Tool.Set_Option('FORMAT', FORMAT)
        Tool.Set_Option('DATASET', DATASET)
        Tool.Set_Option('DAILY_FROM', DAILY_FROM)
        Tool.Set_Option('DAILY_TO', DAILY_TO)
        Tool.Set_Option('YEAR_FROM', YEAR_FROM)
        Tool.Set_Option('YEAR_TO', YEAR_TO)
        Tool.Set_Option('PERIOD', PERIOD)
        Tool.Set_Option('MODEL', MODEL)
        Tool.Set_Option('SCENARIO', SCENARIO)
        Tool.Set_Option('CENTURY', CENTURY)
        Tool.Set_Option('CENTURY_FROM', CENTURY_FROM)
        Tool.Set_Option('CENTURY_TO', CENTURY_TO)
        Tool.Set_Option('CENTURY_STEP', CENTURY_STEP)
        Tool.Set_Option('VAR_DAILY', VAR_DAILY)
        Tool.Set_Option('VAR_MONTHLY', VAR_MONTHLY)
        Tool.Set_Option('VAR_CLIMATE', VAR_CLIMATE)
        Tool.Set_Option('VAR_BIOCLIM', VAR_BIOCLIM)
        Tool.Set_Option('VAR_T21K', VAR_T21K)
        Tool.Set_Option('VAR_T21K_BIOCLIM', VAR_T21K_BIOCLIM)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZEDEF', CELLSIZEDEF)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

def run_tool_io_webservices_15(
    GRID=None,
    SHAPES=None,
    GRIDS=None,
    OUTPUT=None,
    MEMTYPE=None,
    FOLDER=None,
    FORMAT=None,
    DATASET=None,
    DAILY_FROM=None,
    DAILY_TO=None,
    YEAR_FROM=None,
    YEAR_TO=None,
    PERIOD=None,
    MODEL=None,
    SCENARIO=None,
    CENTURY=None,
    CENTURY_FROM=None,
    CENTURY_TO=None,
    CENTURY_STEP=None,
    VAR_DAILY=None,
    VAR_MONTHLY=None,
    VAR_CLIMATE=None,
    VAR_BIOCLIM=None,
    VAR_T21K=None,
    VAR_T21K_BIOCLIM=None,
    EXTENT=None,
    GRID_SYSTEM=None,
    XMIN=None,
    XMAX=None,
    YMIN=None,
    YMAX=None,
    NX=None,
    NY=None,
    BUFFER=None,
    CELLSIZEDEF=None,
    CELLSIZE=None,
    CRS_STRING=None, Verbose=2):
    '''
    CHELSA - Global Climate Data
    ----------
    [io_webservices.15]\n
    Download, project and optionally resample climate data provided by [CHELSA](https://www.chelsa-climate.org/) ('Climatologies at High resolution for the Earth's Land Surface Areas') for the area of your interest.\n
    ____________\n
    Provided Variables\n
    <h5>Daily</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    clt	Total Cloud Cover Percentage	%	Total cloud area fraction (reported as a percentage) for the whole atmospheric column as seen from the surface or the top of the atmosphere. Includes both large-scale and convective cloud.\n
    hurs	Near-Surface Relative Humidity	%	The relative humidity with respect to liquid water for T> 0 C and with respect to ice for T\n
    pr	Precipitation	kg/m²	includes both liquid and solid phases\n
    ps	Surface Air Pressure	hPa	surface pressure (not mean sea-level pressure)\n
    rsds	Surface Downwelling Shortwave Flux in Air	W/m²	Surface solar irradiance for UV calculations.\n
    sfcWind	Near-Surface Wind Speed	m/s	near-surface (usually 10 meters) wind speed.\n
    tas	Daily Mean Near-Surface Air Temperature	°C	near-surface (usually 2 meter) air temperature\n
    tasmax	Daily Maximum Near-Surface Air Temperature	°C	maximum near-surface (usually 2 meter) air temperature\n
    tasmin	Daily Minimum Near-Surface Air Temperature	°C	minimum near-surface (usually 2 meter) air temperature\n
    tz	Air Temperature Lapse Rate	°C/100m	Rate of change in air temperature with altitude\n
    ============\n
    <h5>Monthly</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    clt	Total Cloud Cover Percentage	%	Total cloud area fraction (reported as a percentage) for the whole atmospheric column as seen from the surface or the top of the atmosphere. Includes both large-scale and convective cloud.\n
    cmi	Monthly Climate Moisture Index	kg/m²	Monthly ratio of precipitation to potential evapotranspiration; indicator of climatic water availability\n
    hurs	Near-Surface Relative Humidity	%	The relative humidity with respect to liquid water for T> 0 C and with respect to ice for T\n
    pet	Monthly Potential Evapotranspiration	kg/m²	Total potential evapotranspiration for the month assuming unlimited water availability calculated based on Penman Monteith\n
    pr	Precipitation	kg/m²	includes both liquid and solid phases\n
    rsds	Surface Downwelling Shortwave Flux in Air	W/m²	Surface solar irradiance for UV calculations.\n
    sfcWind	Near-Surface Wind Speed	m/s	near-surface (usually 10 meters) wind speed.\n
    spei12	Standardized Precipitation Evapotranspiration Index		Standardized index of climatic water balance (precipitation minus potential evapotranspiration) over a given integration period here 12 months expressed in standard deviations from the long term mean, used to characterize drought severity and duration\n
    spi12	Standardized Precipitation Index		Standardized index of precipitation anomalies over a given integration period here 12 months expressed in standard deviations from the long-term mean; used to characterize drought severity and duration without accounting for evapotranspiration\n
    tas	Daily Mean Near-Surface Air Temperature	°C	near-surface (usually 2 meter) air temperature\n
    tasmax	Daily Maximum Near-Surface Air Temperature	°C	maximum near-surface (usually 2 meter) air temperature\n
    tasmin	Daily Minimum Near-Surface Air Temperature	°C	minimum near-surface (usually 2 meter) air temperature\n
    vpd	Vapor Pressure Deficit	Pa	Difference between the saturation vapor pressure and actual vapor pressure representing atmospheric drying power\n
    ============\n
    <h5>Climatology</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    clt	Total Cloud Cover Percentage	%	Total cloud area fraction (reported as a percentage) for the whole atmospheric column as seen from the surface or the top of the atmosphere. Includes both large-scale and convective cloud.\n
    cmi	Monthly Climate Moisture Index	kg/m²	Monthly ratio of precipitation to potential evapotranspiration; indicator of climatic water availability\n
    hurs	Near-Surface Relative Humidity	%	The relative humidity with respect to liquid water for T> 0 C and with respect to ice for T\n
    pet	Monthly Potential Evapotranspiration	kg/m²	Total potential evapotranspiration for the month assuming unlimited water availability calculated based on Penman Monteith\n
    pr	Precipitation	kg/m²	includes both liquid and solid phases\n
    rsds	Surface Downwelling Shortwave Flux in Air	W/m²	Surface solar irradiance for UV calculations.\n
    sfcWind	Near-Surface Wind Speed	m/s	near-surface (usually 10 meters) wind speed.\n
    tas	Daily Mean Near-Surface Air Temperature	°C	near-surface (usually 2 meter) air temperature\n
    tasmax	Daily Maximum Near-Surface Air Temperature	°C	maximum near-surface (usually 2 meter) air temperature\n
    tasmin	Daily Minimum Near-Surface Air Temperature	°C	minimum near-surface (usually 2 meter) air temperature\n
    vpd	Vapor Pressure Deficit	Pa	Difference between the saturation vapor pressure and actual vapor pressure representing atmospheric drying power\n
    ============\n
    <h5>Bioclimatological Indicators</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    bio01	Mean Annual Near-Surface Air Temperature	°C	Mean annual temperature calculated as the average of mean monthly temperatures over the year\n
    bio02	Mean Diurnal Near-Surface Air Temperature Range	°C	Mean diurnal temperature range computed as the average of monthly (tasmax − tasmin)\n
    bio03	Isothermality	%	Isothermality: 100 × (bio02 ÷ bio07); compares day–night variability to annual temperature range\n
    bio04	Temperature Seasonality	°C	Temperature seasonality given by the standard deviation of mean monthly temperatures\n
    bio05	Mean Daily Maximum Near-Surface Air Temperature of the Warmest Month	°C	Highest monthly mean of daily maximum temperatures (tasmax) across the year; indicates peak thermal conditions\n
    bio06	Mean Daily Minimum Near-Surface Air Temperature of the Coldest Month	°C	Lowest monthly mean of daily minimum temperatures (tasmin) across the year; characterizes winter cold intensity\n
    bio07	Annual Daily Mean Near-Surface Air Temperature Range	°C	Annual temperature range calculated as bio05 − bio06; measures amplitude between warmest and coldest months\n
    bio08	Mean Daily Near-Surface Air Temperature of the Wettest Quarter	°C	Average monthly mean temperature over the wettest 3-month period of the year\n
    bio09	Mean Daily Near-Surface Air Temperature of the Driest Quarter	°C	Average monthly mean temperature over the driest 3-month period of the year\n
    bio10	Mean Daily Mean Near-Surface Air Temperature of the Warmest Quarter	°C	Average monthly mean temperature over the warmest 3-month period of the year\n
    bio11	Mean Daily Mean Near-Surface Air Temperature of the Quarter	°C	Average monthly mean temperature over the coldest 3-month period of the year\n
    bio12	Annual Precipitation	kg/m²	Sum of monthly precipitation totals across the year\n
    bio13	Precipitation of the Wettest Month	kg/m²	Maximum monthly precipitation total\n
    bio14	Precipitation of the Driest Month	kg/m²	Minimum monthly precipitation total\n
    bio15	Precipitation Seasonality	%	Coefficient of variation (100 × SD ÷ mean) of monthly precipitation totals\n
    bio16	Mean Monthly Precipitation of the Wettest Quarter	kg/m²	Average monthly precipitation during the wettest 3-month period of the year\n
    bio17	Mean Monthly Precipitation of the Driest Quarter	kg/m²	Average monthly precipitation during the driest 3-month period of the year\n
    bio18	Mean Monthly Precipitation of the Warmest Quarter	kg/m²	Average monthly precipitation during the warmest 3-month period of the year\n
    bio19	Mean Monthly Precipitation of the Coldest Quarter	kg/m²	Average monthly precipitation during the coldest 3-month period of the year\n
    fcf	Frost Change Frequency	days	Number of freeze–thaw transitions per year\n
    fgd	First Day of the Growing Season (TREELIM)	day of year	Day of the year number marking the first occurrence of growing season conditions\n
    gdd0	Growing Degree Days Heat Sum above 0 °C	°C	Sum of daily mean temperatures above 0 °C accumulated over the year\n
    gdd10	Growing Degree Days Heat Sum above 10 °C	°C	Sum of daily mean temperatures above 10 °C accumulated over the year\n
    gdd5	Growing Degree Days Heat Sum above 5 °C	°C	Sum of daily mean temperatures above 5 °C accumulated over the year\n
    gdgfgd10	First Growing Degree Day above 10 °C	day of year	Day of the year number of the first occurrence of a daily mean temperature above 10 °C\n
    gdgfgd5	First Growing Degree Day above 5 °C	day of year	Day of the year number of the first occurrence of a daily mean temperature above 5 °C\n
    gsl	Growing Season Length	days	Number of days between the first and last occurrence of growing season conditions\n
    gsp	Accumulated Precipiation Amount over Growing Season Days	kg/m²	Total precipitation accumulated during the growing season period\n
    gst	Mean Temperature of Growing Season Days	°C	Average daily mean temperature over all growing season days\n
    kg0	Köppen-Geiger Climate Classification	category	Köppen–Geiger climate classification\n
    kg1	Köppen-Geiger Climate Classification (without As/Aw)	category	Köppen–Geiger climate classification without As/Aw differenciation\n
    kg2	Köppen-Geiger Climate Classification (Peel et al. 2007)	category	Köppen–Geiger climate classification after href="https://doi.org/10.5194/hess-11-1633-2007">Peel et al. 2007\n
    kg3	Wissmann Climate Classification	category	Climate classification after Wissmann 1939\n
    kg4	Thornthwaite Climate Classification	category	Climate classification after Thornthwaite 1931\n
    kg5	Troll-Paffen Climate Classification	category	Climate classification after Troll-Paffen\n
    lgd	Last Day of the Growing Season (TREELIM)	day of year	Day of the year number of the last occurrence of growing season conditions\n
    ngd0	Number of Growing Degree Days above 0 °C	number of days	Total number of days in a year with mean daily temperature above 0 °C\n
    ngd10	Number of Growing Degree Days above 10 °C	number of days	Total number of days in a year with mean daily temperature above 10 °C\n
    ngd5	Number of Growing Degree Days above 5 °C	number of days	Total number of days in a year with mean daily temperature above 5 °C\n
    npp	Net Primary Production on Land as Carbon Mass Flux	gC/m²/yr	Production of carbon' means the production of biomass expressed as the mass of carbon which it contains. Net primary production is the excess of gross primary production (rate of synthesis of biomass from inorganic precursors) by autotrophs ('producers') for example photosynthesis in plants or phytoplankton over the rate at which the autotrophs themselves respire some of this biomass. 'Productivity' means production per unit area. The phrase 'expressed_as' is used in the construction A_expressed_as_B where B is a chemical constituent of A. It means that the quantity indicated by the standard name is calculated solely with respect to the B contained in A neglecting all other chemical constituents of A.\n
    scd	Snow Cover Days	days	Number of days per year with snow cover present at the surface\n
    swe	Snow Water Equivalent	kg/m²/yr	Total water equivalent of snowpack accumulated over the year\n
    ============\n
    <h5>TraCE21k-centennial</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    pr	Precipitation	kg/m²	includes both liquid and solid phases\n
    tasmax	Daily Maximum Near-Surface Air Temperature	°C	maximum near-surface (usually 2 meter) air temperature\n
    tasmin	Daily Minimum Near-Surface Air Temperature	°C	minimum near-surface (usually 2 meter) air temperature\n
    tz	Air Temperature Lapse Rate	°C/100m	Rate of change in air temperature with altitude\n
    ============\n
    <h5>TraCE21k-centennial-bioclim</h5>\n
    ============\n
    Key	Name	Unit	Description\n
    bio01	Mean Annual Near-Surface Air Temperature	°C	Mean annual temperature calculated as the average of mean monthly temperatures over the year\n
    bio02	Mean Diurnal Near-Surface Air Temperature Range	°C	Mean diurnal temperature range computed as the average of monthly (tasmax − tasmin)\n
    bio03	Isothermality	%	Isothermality: 100 × (bio02 ÷ bio07); compares day–night variability to annual temperature range\n
    bio04	Temperature Seasonality	°C	Temperature seasonality given by the standard deviation of mean monthly temperatures\n
    bio05	Mean Daily Maximum Near-Surface Air Temperature of the Warmest Month	°C	Highest monthly mean of daily maximum temperatures (tasmax) across the year; indicates peak thermal conditions\n
    bio06	Mean Daily Minimum Near-Surface Air Temperature of the Coldest Month	°C	Lowest monthly mean of daily minimum temperatures (tasmin) across the year; characterizes winter cold intensity\n
    bio07	Annual Daily Mean Near-Surface Air Temperature Range	°C	Annual temperature range calculated as bio05 − bio06; measures amplitude between warmest and coldest months\n
    bio08	Mean Daily Near-Surface Air Temperature of the Wettest Quarter	°C	Average monthly mean temperature over the wettest 3-month period of the year\n
    bio09	Mean Daily Near-Surface Air Temperature of the Driest Quarter	°C	Average monthly mean temperature over the driest 3-month period of the year\n
    bio10	Mean Daily Mean Near-Surface Air Temperature of the Warmest Quarter	°C	Average monthly mean temperature over the warmest 3-month period of the year\n
    bio11	Mean Daily Mean Near-Surface Air Temperature of the Quarter	°C	Average monthly mean temperature over the coldest 3-month period of the year\n
    bio12	Annual Precipitation	kg/m²	Sum of monthly precipitation totals across the year\n
    bio13	Precipitation of the Wettest Month	kg/m²	Maximum monthly precipitation total\n
    bio14	Precipitation of the Driest Month	kg/m²	Minimum monthly precipitation total\n
    bio15	Precipitation Seasonality	%	Coefficient of variation (100 × SD ÷ mean) of monthly precipitation totals\n
    bio16	Mean Monthly Precipitation of the Wettest Quarter	kg/m²	Average monthly precipitation during the wettest 3-month period of the year\n
    bio17	Mean Monthly Precipitation of the Driest Quarter	kg/m²	Average monthly precipitation during the driest 3-month period of the year\n
    bio18	Mean Monthly Precipitation of the Warmest Quarter	kg/m²	Average monthly precipitation during the warmest 3-month period of the year\n
    bio19	Mean Monthly Precipitation of the Coldest Quarter	kg/m²	Average monthly precipitation during the coldest 3-month period of the year\n
    glz	Ice Sheet Surface Altitude	m	Elevation of the ice sheet surface above sea level\n
    orog	Surface Altitude	m	The surface called 'surface' means the lower boundary of the atmosphere. Altitude is the (geometric) height above the geoid which is the reference geopotential surface. The geoid is similar to mean sea level.\n
    scd	Snow Cover Days	days	Number of days per year with snow cover present at the surface\n
    ============\n
    Arguments
    ----------
    - GRID [`input grid`] : Grid
    - SHAPES [`input shapes`] : Shapes
    - GRIDS [`output grid list`] : Grids
    - OUTPUT [`choice`] : Output. Available Choices: [0] files [1] memory Default: 1
    - MEMTYPE [`choice`] : Type. Available Choices: [0] single grids [1] grid collection Default: 1
    - FOLDER [`file path`] : Folder
    - FORMAT [`choice`] : Format. Available Choices: [0] GeoTIFF (*.tif) [1] SAGA Compressed Grid File (*.sg-grd-z) Default: 1
    - DATASET [`choice`] : Data Set. Available Choices: [0] daily [1] monthly [2] climatology [3] bioclim [4] TraCE21k-cenntenial [5] TraCE21k-cenntenial-bioclim Default: 2
    - DAILY_FROM [`date`] : From Day. Default: 1979-01-01
    - DAILY_TO [`date`] : To Day. Default: 2024-12-31
    - YEAR_FROM [`integer number`] : From Year. Minimum: 1979 Maximum: 2021 Default: 1979
    - YEAR_TO [`integer number`] : To Year. Minimum: 1979 Maximum: 2021 Default: 2021
    - PERIOD [`choice`] : Period. Available Choices: [0] 1981-2010 [1] 2011-2040 [2] 2041-2070 [3] 2071-2100 Default: 0
    - MODEL [`choice`] : Model. Available Choices: [0] GFDL-ESM4 [1] IPSL-CM6A-LR [2] MPI-ESM1-2-HR [3] MRI-ESM2-0 [4] UKESM1-0-LL Default: 2
    - SCENARIO [`choice`] : Scenario. Available Choices: [0] ssp126 [1] ssp370 [2] ssp585 Default: 2
    - CENTURY [`integer number`] : Century. Minimum: -200 Maximum: 20 Default: -200
    - CENTURY_FROM [`integer number`] : From Century. Minimum: -200 Maximum: 20 Default: -200
    - CENTURY_TO [`integer number`] : To Century. Minimum: -200 Maximum: 20 Default: 20
    - CENTURY_STEP [`integer number`] : Step. Minimum: 1 Maximum: 55 Default: 1
    - VAR_DAILY [`choice`] : Variable. Available Choices: [0] Total Cloud Cover Percentage [1] Near-Surface Relative Humidity [2] Precipitation [3] Surface Air Pressure [4] Surface Downwelling Shortwave Flux in Air [5] Near-Surface Wind Speed [6] Daily Mean Near-Surface Air Temperature [7] Daily Maximum Near-Surface Air Temperature [8] Daily Minimum Near-Surface Air Temperature [9] Air Temperature Lapse Rate Default: 0
    - VAR_MONTHLY [`choice`] : Variable. Available Choices: [0] Total Cloud Cover Percentage [1] Monthly Climate Moisture Index [2] Near-Surface Relative Humidity [3] Monthly Potential Evapotranspiration [4] Precipitation [5] Surface Downwelling Shortwave Flux in Air [6] Near-Surface Wind Speed [7] Standardized Precipitation Evapotranspiration Index [8] Standardized Precipitation Index [9] Daily Mean Near-Surface Air Temperature [10] Daily Maximum Near-Surface Air Temperature [11] Daily Minimum Near-Surface Air Temperature [12] Vapor Pressure Deficit Default: 0
    - VAR_CLIMATE [`choice`] : Variable. Available Choices: [0] Total Cloud Cover Percentage [1] Monthly Climate Moisture Index [2] Near-Surface Relative Humidity [3] Monthly Potential Evapotranspiration [4] Precipitation [5] Surface Downwelling Shortwave Flux in Air [6] Near-Surface Wind Speed [7] Daily Mean Near-Surface Air Temperature [8] Daily Maximum Near-Surface Air Temperature [9] Daily Minimum Near-Surface Air Temperature [10] Vapor Pressure Deficit Default: 0
    - VAR_BIOCLIM [`choice`] : Variable. Available Choices: [0] Mean Annual Near-Surface Air Temperature [1] Mean Diurnal Near-Surface Air Temperature Range [2] Isothermality [3] Temperature Seasonality [4] Mean Daily Maximum Near-Surface Air Temperature of the Warmest Month [5] Mean Daily Minimum Near-Surface Air Temperature of the Coldest Month [6] Annual Daily Mean Near-Surface Air Temperature Range [7] Mean Daily Near-Surface Air Temperature of the Wettest Quarter [8] Mean Daily Near-Surface Air Temperature of the Driest Quarter [9] Mean Daily Mean Near-Surface Air Temperature of the Warmest Quarter [10] Mean Daily Mean Near-Surface Air Temperature of the Quarter [11] Annual Precipitation [12] Precipitation of the Wettest Month [13] Precipitation of the Driest Month [14] Precipitation Seasonality [15] Mean Monthly Precipitation of the Wettest Quarter [16] Mean Monthly Precipitation of the Driest Quarter [17] Mean Monthly Precipitation of the Warmest Quarter [18] Mean Monthly Precipitation of the Coldest Quarter [19] Frost Change Frequency [20] First Day of the Growing Season (TREELIM) [21] Growing Degree Days Heat Sum above 0 °C [22] Growing Degree Days Heat Sum above 10 °C [23] Growing Degree Days Heat Sum above 5 °C [24] First Growing Degree Day above 10 °C [25] First Growing Degree Day above 5 °C [26] Growing Season Length [27] Accumulated Precipiation Amount over Growing Season Days [28] Mean Temperature of Growing Season Days [29] Köppen-Geiger Climate Classification [30] Köppen-Geiger Climate Classification (without As/Aw) [31] Köppen-Geiger Climate Classification (Peel et al. 2007) [32] Wissmann Climate Classification [33] Thornthwaite Climate Classification [34] Troll-Paffen Climate Classification [35] Last Day of the Growing Season (TREELIM) [36] Number of Growing Degree Days above 0 °C [37] Number of Growing Degree Days above 10 °C [38] Number of Growing Degree Days above 5 °C [39] Net Primary Production on Land as Carbon Mass Flux [40] Snow Cover Days [41] Snow Water Equivalent [42] [all] Default: 0
    - VAR_T21K [`choice`] : Variable. Available Choices: [0] Precipitation [1] Daily Maximum Near-Surface Air Temperature [2] Daily Minimum Near-Surface Air Temperature [3] Air Temperature Lapse Rate Default: 0
    - VAR_T21K_BIOCLIM [`choice`] : Variable. Available Choices: [0] Mean Annual Near-Surface Air Temperature [1] Mean Diurnal Near-Surface Air Temperature Range [2] Isothermality [3] Temperature Seasonality [4] Mean Daily Maximum Near-Surface Air Temperature of the Warmest Month [5] Mean Daily Minimum Near-Surface Air Temperature of the Coldest Month [6] Annual Daily Mean Near-Surface Air Temperature Range [7] Mean Daily Near-Surface Air Temperature of the Wettest Quarter [8] Mean Daily Near-Surface Air Temperature of the Driest Quarter [9] Mean Daily Mean Near-Surface Air Temperature of the Warmest Quarter [10] Mean Daily Mean Near-Surface Air Temperature of the Quarter [11] Annual Precipitation [12] Precipitation of the Wettest Month [13] Precipitation of the Driest Month [14] Precipitation Seasonality [15] Mean Monthly Precipitation of the Wettest Quarter [16] Mean Monthly Precipitation of the Driest Quarter [17] Mean Monthly Precipitation of the Warmest Quarter [18] Mean Monthly Precipitation of the Coldest Quarter [19] Ice Sheet Surface Altitude [20] Surface Altitude [21] Snow Cover Days Default: 0
    - EXTENT [`choice`] : Extent. Available Choices: [0] user defined [1] shapes extent [2] grid system extent [3] grid system Default: 0
    - GRID_SYSTEM [`grid system`] : Grid System
    - XMIN [`floating point number`] : West. Default: 260000.000000
    - XMAX [`floating point number`] : East. Default: 941000.000000
    - YMIN [`floating point number`] : South. Default: 5215000.000000
    - YMAX [`floating point number`] : North. Default: 6121000.000000
    - NX [`integer number`] : Columns. Minimum: 1 Default: 682
    - NY [`integer number`] : Rows. Minimum: 1 Default: 907
    - BUFFER [`floating point number`] : Buffer. Minimum: 0.000000 Default: 0.000000 add buffer (map units) to extent
    - CELLSIZEDEF [`choice`] : Take Cellsize. Available Choices: [0] data type resolution [1] user defined Default: 0
    - CELLSIZE [`floating point number`] : Cellsize. Minimum: 0.000100 Default: 1000.000000
    - CRS_STRING [`text`] : Coordinate System Definition. Supported formats comprise PROJ and WKT strings, object codes (e.g. "EPSG:4326").

    - Verbose [`integer number`] : Verbosity level, 0=silent, 1=tool name and success notification, 2=complete tool output.\n
    Returns
    ----------
    `boolean` : `True` on success, `False` on failure.
    '''
    Tool = Tool_Wrapper('io_webservices', '15', 'CHELSA - Global Climate Data')
    if Tool.is_Okay():
        Tool.Set_Input ('GRID', GRID)
        Tool.Set_Input ('SHAPES', SHAPES)
        Tool.Set_Output('GRIDS', GRIDS)
        Tool.Set_Option('OUTPUT', OUTPUT)
        Tool.Set_Option('MEMTYPE', MEMTYPE)
        Tool.Set_Option('FOLDER', FOLDER)
        Tool.Set_Option('FORMAT', FORMAT)
        Tool.Set_Option('DATASET', DATASET)
        Tool.Set_Option('DAILY_FROM', DAILY_FROM)
        Tool.Set_Option('DAILY_TO', DAILY_TO)
        Tool.Set_Option('YEAR_FROM', YEAR_FROM)
        Tool.Set_Option('YEAR_TO', YEAR_TO)
        Tool.Set_Option('PERIOD', PERIOD)
        Tool.Set_Option('MODEL', MODEL)
        Tool.Set_Option('SCENARIO', SCENARIO)
        Tool.Set_Option('CENTURY', CENTURY)
        Tool.Set_Option('CENTURY_FROM', CENTURY_FROM)
        Tool.Set_Option('CENTURY_TO', CENTURY_TO)
        Tool.Set_Option('CENTURY_STEP', CENTURY_STEP)
        Tool.Set_Option('VAR_DAILY', VAR_DAILY)
        Tool.Set_Option('VAR_MONTHLY', VAR_MONTHLY)
        Tool.Set_Option('VAR_CLIMATE', VAR_CLIMATE)
        Tool.Set_Option('VAR_BIOCLIM', VAR_BIOCLIM)
        Tool.Set_Option('VAR_T21K', VAR_T21K)
        Tool.Set_Option('VAR_T21K_BIOCLIM', VAR_T21K_BIOCLIM)
        Tool.Set_Option('EXTENT', EXTENT)
        Tool.Set_Option('GRID_SYSTEM', GRID_SYSTEM)
        Tool.Set_Option('XMIN', XMIN)
        Tool.Set_Option('XMAX', XMAX)
        Tool.Set_Option('YMIN', YMIN)
        Tool.Set_Option('YMAX', YMAX)
        Tool.Set_Option('NX', NX)
        Tool.Set_Option('NY', NY)
        Tool.Set_Option('BUFFER', BUFFER)
        Tool.Set_Option('CELLSIZEDEF', CELLSIZEDEF)
        Tool.Set_Option('CELLSIZE', CELLSIZE)
        Tool.Set_Option('CRS_STRING', CRS_STRING)
        return Tool.Execute(Verbose)
    return False

