from _typeshed import Incomplete
from collections.abc import Iterable
from typing import ClassVar, Final, overload

from docutils import nodes
from docutils.transforms import Transform

__docformat__: Final = "reStructuredText"

class PropagateTargets(Transform):
    default_priority: ClassVar[int]
    def apply(self) -> None: ...

class AnonymousHyperlinks(Transform):
    default_priority: ClassVar[int]
    def apply(self) -> None: ...

class IndirectHyperlinks(Transform):
    default_priority: ClassVar[int]
    def apply(self) -> None: ...
    def resolve_indirect_target(self, target: nodes.Element) -> None: ...
    def nonexistent_indirect_target(self, target: nodes.Element) -> None: ...
    def circular_indirect_reference(self, target: nodes.Element) -> None: ...
    def indirect_target_error(self, target: nodes.Element, explanation) -> None: ...
    def resolve_indirect_references(self, target: nodes.Element) -> None: ...

class ExternalTargets(Transform):
    default_priority: ClassVar[int]
    def apply(self) -> None: ...

class InternalTargets(Transform):
    default_priority: ClassVar[int]
    def apply(self) -> None: ...
    def resolve_reference_ids(self, target: nodes.Element) -> None: ...

class Footnotes(Transform):
    default_priority: ClassVar[int]
    autofootnote_labels: list[str] | None
    symbols: ClassVar[list[str]]
    def apply(self) -> None: ...
    def number_footnotes(self, startnum: int) -> int: ...
    def number_footnote_references(self, startnum: int) -> None: ...
    def symbolize_footnotes(self) -> None: ...
    def resolve_footnotes_and_citations(self) -> None: ...
    @overload
    def resolve_references(self, note: nodes.footnote, reflist: Iterable[nodes.footnote_reference]) -> None: ...
    @overload
    def resolve_references(self, note: nodes.citation, reflist: Iterable[nodes.citation_reference]) -> None: ...
    @overload
    def resolve_references(self, note: nodes.title, reflist: Iterable[nodes.title_reference]) -> None: ...

class CircularSubstitutionDefinitionError(Exception): ...

class Substitutions(Transform):
    default_priority: ClassVar[int]
    def apply(self) -> None: ...

class TargetNotes(Transform):
    default_priority: ClassVar[int]
    classes: Incomplete
    def __init__(self, document: nodes.document, startnode: nodes.Node) -> None: ...
    def apply(self) -> None: ...
    def make_target_footnote(self, refuri: str, refs: list[Incomplete], notes: dict[Incomplete, Incomplete]): ...

class DanglingReferences(Transform):
    default_priority: ClassVar[int]
    def apply(self) -> None: ...

class DanglingReferencesVisitor(nodes.SparseNodeVisitor):
    document: nodes.document
    def __init__(self, document: nodes.document, unknown_reference_resolvers) -> None: ...
    def unknown_visit(self, node: nodes.Node) -> None: ...
    def visit_reference(self, node: nodes.reference) -> None: ...
    def visit_footnote_reference(self, node: nodes.footnote_reference) -> None: ...
    def visit_citation_reference(self, node: nodes.citation_reference) -> None: ...
