private rule architecture {
	meta:
		bits = 32
		endianness = "little"
		architecture = "x86"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "_wcsncpy_s"
		size = 201
		refs = "002c __errno 003b __invalid_parameter"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 08 57 33 FF 39 7D 14 75 10 3B F7 75 10 39 7D 0C 75 12 33 C0 5F 5E 5B 5D C3 3B F7 74 07 8B 5D 0C 3B DF 77 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB D5 39 7D 14 75 05 66 89 3E EB C9 8B 55 10 3B D7 75 05 66 89 3E EB CF 83 7D 14 FF 8B C6 75 14 0F B7 0A 66 89 08 40 40 42 42 66 3B CF 74 24 4B 75 EE EB 1F 0F B7 0A 66 89 08 40 40 42 42 66 3B CF 74 08 4B 74 05 FF 4D 14 75 E9 39 7D 14 75 03 66 89 38 3B DF 0F 85 7A FF FF FF 83 7D 14 FF 75 10 8B 45 0C 6A 50 66 89 7C 46 FE 58 E9 66 FF FF FF 66 89 3E E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 E9 6C FF FF FF }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "__alloca_probe_16"
		size = 44
		refs = "0012 __chkstk"
	strings:
		$1 = { 51 8D 4C 24 08 2B C8 83 E1 0F 03 C1 1B C9 0B C1 59 E9 ?? ?? ?? ?? 51 8D 4C 24 08 2B C8 83 E1 07 03 C1 1B C9 0B C1 59 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "__twoToTOS"
		size = 21
	strings:
		$1 = { D9 C0 D9 FC DC E1 D9 C9 D9 E0 D9 F0 D9 E8 DE C1 D9 FD DD D9 C3 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "__load_CW"
		size = 23
	strings:
		$1 = { 8B 54 24 04 81 E2 00 03 00 00 83 CA 7F 66 89 54 24 06 D9 6C 24 06 C3 }
	condition:
		$1
}

rule file_2_2_0 {
	meta:
		name = "__convertTOStoQNaN"
		size = 25
		refs = "000f One"
	strings:
		$1 = { A9 00 00 08 00 74 06 B8 07 00 00 00 C3 DC 05 ?? ?? ?? ?? B8 01 00 00 00 C3 }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "__fload_withFB"
		size = 67
	strings:
		$1 = { 8B 42 04 25 00 00 F0 7F 3D 00 00 F0 7F 74 03 DD 02 C3 8B 42 04 83 EC 0A 0D 00 00 FF 7F 89 44 24 06 8B 42 04 8B 0A 0F A4 C8 0B C1 E1 0B 89 44 24 04 89 0C 24 DB 2C 24 83 C4 0A A9 00 00 00 00 8B 42 04 C3 }
	condition:
		$1
}

rule file_2_4_0 {
	meta:
		name = "__checkTOS_withFB"
		size = 22
	strings:
		$1 = { 8B 44 24 08 25 00 00 F0 7F 3D 00 00 F0 7F 74 01 C3 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_2_6_0 {
	meta:
		name = "__math_exit"
		size = 42
		refs = "001f __startOneArgErrorHandling"
	strings:
		$1 = { 66 8B 04 24 66 3D 7F 02 74 1E 66 83 E0 20 74 15 9B DF E0 66 83 E0 20 74 0C B8 08 00 00 00 E8 ?? ?? ?? ?? 5A C3 D9 2C 24 5A C3 }
	condition:
		$1
}

rule file_2_7_0 {
	meta:
		name = "__check_overflow_exit"
		size = 20
	strings:
		$1 = { 83 EC 08 DD 14 24 8B 44 24 04 83 C4 08 25 00 00 F0 7F EB 14 }
	condition:
		$1
}

rule file_2_8_0 {
	meta:
		name = "__check_range_exit"
		size = 163
		refs = "003f __startOneArgErrorHandling 0046 __startTwoArgErrorHandling 0053 IeeeAdjU 0063 DblMin 0074 _zero 007c IeeeAdjO 008c DblMax 009d _infinity"
	strings:
		$1 = { 83 EC 08 DD 14 24 8B 44 24 04 83 C4 08 25 00 00 F0 7F 74 3D 3D 00 00 F0 7F 74 5F 66 8B 04 24 66 3D 7F 02 74 2A 66 83 E0 20 75 21 9B DF E0 66 83 E0 20 74 18 B8 08 00 00 00 83 FA 1D 74 07 E8 ?? ?? ?? ?? 5A C3 E8 ?? ?? ?? ?? 5A C3 D9 2C 24 5A C3 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E B8 04 00 00 00 73 C7 DC 0D ?? ?? ?? ?? EB BF DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E B8 03 00 00 00 76 9E DC 0D ?? ?? ?? ?? EB 96 }
	condition:
		$1
}

rule file_4_0_0 {
	meta:
		name = "_cmpResult"
		size = 18
	strings:
		$1 = { 85 C0 74 0D 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 C3 }
	condition:
		$1
}

rule file_4_1_0 {
	meta:
		name = "_cmpBYTE"
		size = 24
	strings:
		$1 = { 0F B6 00 0F B6 09 2B C1 74 0D 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 C3 }
	condition:
		$1
}

rule file_4_2_0 {
	meta:
		name = "_cmpWORD"
		size = 64
	strings:
		$1 = { 66 8B 06 66 3B 01 74 35 0F B6 11 0F B6 C0 2B C2 74 11 33 D2 85 C0 0F 9F C2 8D 54 12 FF 8B C2 85 C0 75 1C 0F B6 46 01 0F B6 49 01 2B C1 74 10 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_4_3_0 {
	meta:
		name = "_cmpDWORD"
		size = 120
	strings:
		$1 = { 8B 06 3B 01 74 6F 0F B6 11 0F B6 C0 2B C2 74 11 33 D2 85 C0 0F 9F C2 8D 54 12 FF 8B C2 85 C0 75 56 0F B6 46 01 0F B6 51 01 2B C2 74 11 33 D2 85 C0 0F 9F C2 8D 54 12 FF 8B C2 85 C0 75 39 0F B6 46 02 0F B6 51 02 2B C2 74 11 33 D2 85 C0 0F 9F C2 8D 54 12 FF 8B C2 85 C0 75 1C 0F B6 46 03 0F B6 49 03 2B C1 74 10 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_4_4_0 {
	meta:
		name = "_unaligned_memcmp"
		size = 5264
		refs = "0480 $LN1372 1410 $LN61 1414 $LN1182 1418 $LN1190 141c $LN1198 1420 $LN1174 1424 $LN1181 1428 $LN1189 142c $LN1197 1430 $LN1173 1434 $LN1180 1438 $LN1188 143c $LN1196 1440 $LN1172 1444 $LN1179 1448 $LN1187 144c $LN1195 1450 $LN1171 1454 $LN1178 1458 $LN1186 145c $LN1194 1460 $LN1170 1464 $LN1177 1468 $LN1185 146c $LN1193 1470 $LN1169 1474 $LN1176 1478 $LN1184 147c $LN1192 1480 $LN60 1484 $LN45 1488 $LN30 148c $LN15"
	strings:
		$1 = { 56 57 8B F8 E9 5E 04 00 00 8B 01 3B 02 74 78 0F B6 F0 0F B6 02 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 12 08 00 00 0F B6 71 01 0F B6 42 01 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 F3 07 00 00 0F B6 71 02 0F B6 42 02 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D4 07 00 00 0F B6 71 03 0F B6 42 03 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 AD 07 00 00 8B 41 04 3B 42 04 74 79 0F B6 F0 0F B6 42 04 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 87 07 00 00 0F B6 71 05 0F B6 42 05 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 68 07 00 00 0F B6 71 06 0F B6 42 06 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 49 07 00 00 0F B6 71 07 0F B6 42 07 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 22 07 00 00 8B 41 08 3B 42 08 74 79 0F B6 F0 0F B6 42 08 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 FC 06 00 00 0F B6 71 09 0F B6 42 09 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 DD 06 00 00 0F B6 71 0A 0F B6 42 0A 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 BE 06 00 00 0F B6 71 0B 0F B6 42 0B 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 97 06 00 00 8B 41 0C 3B 42 0C 74 79 0F B6 F0 0F B6 42 0C 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 71 06 00 00 0F B6 71 0D 0F B6 42 0D 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 52 06 00 00 0F B6 71 0E 0F B6 42 0E 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 33 06 00 00 0F B6 71 0F 0F B6 42 0F 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 0C 06 00 00 8B 41 10 3B 42 10 74 79 0F B6 F0 0F B6 42 10 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 E6 05 00 00 0F B6 71 11 0F B6 42 11 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 C7 05 00 00 0F B6 71 12 0F B6 42 12 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 A8 05 00 00 0F B6 71 13 0F B6 42 13 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 81 05 00 00 8B 41 14 3B 42 14 74 79 0F B6 F0 0F B6 42 14 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 5B 05 00 00 0F B6 71 15 0F B6 42 15 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 3C 05 00 00 0F B6 71 16 0F B6 42 16 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 1D 05 00 00 0F B6 71 17 0F B6 42 17 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 F6 04 00 00 8B 41 18 3B 42 18 74 79 0F B6 F0 0F B6 42 18 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D0 04 00 00 0F B6 71 19 0F B6 42 19 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B1 04 00 00 0F B6 71 1A 0F B6 42 1A 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 92 04 00 00 0F B6 71 1B 0F B6 42 1B 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 6B 04 00 00 8B 41 1C 3B 42 1C 74 79 0F B6 F0 0F B6 42 1C 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 45 04 00 00 0F B6 71 1D 0F B6 42 1D 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 26 04 00 00 0F B6 71 1E 0F B6 42 1E 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 07 04 00 00 0F B6 71 1F 0F B6 42 1F 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 E0 03 00 00 83 C1 20 83 C2 20 83 EF 20 83 FF 20 0F 83 99 FB FF FF 03 CF 03 D7 83 FF 1F 0F 87 BF 03 00 00 FF 24 BD ?? ?? ?? ?? 8B 41 E4 3B 42 E4 74 7A 0F B6 42 E4 0F B6 71 E4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 93 03 00 00 0F B6 71 E5 0F B6 42 E5 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 74 03 00 00 0F B6 71 E6 0F B6 42 E6 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 55 03 00 00 0F B6 71 E7 0F B6 42 E7 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 2E 03 00 00 8B 41 E8 3B 42 E8 74 79 0F B6 F0 0F B6 42 E8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 08 03 00 00 0F B6 71 E9 0F B6 42 E9 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 E9 02 00 00 0F B6 71 EA 0F B6 42 EA 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 CA 02 00 00 0F B6 71 EB 0F B6 42 EB 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 A3 02 00 00 8B 41 EC 3B 42 EC 74 79 0F B6 F0 0F B6 42 EC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 7D 02 00 00 0F B6 71 ED 0F B6 42 ED 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 5E 02 00 00 0F B6 71 EE 0F B6 42 EE 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 3F 02 00 00 0F B6 71 EF 0F B6 42 EF 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 18 02 00 00 8B 41 F0 3B 42 F0 74 79 0F B6 F0 0F B6 42 F0 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 F2 01 00 00 0F B6 71 F1 0F B6 42 F1 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D3 01 00 00 0F B6 71 F2 0F B6 42 F2 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B4 01 00 00 0F B6 71 F3 0F B6 42 F3 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 8D 01 00 00 8B 41 F4 3B 42 F4 74 79 0F B6 F0 0F B6 42 F4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 67 01 00 00 0F B6 71 F5 0F B6 42 F5 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 48 01 00 00 0F B6 71 F6 0F B6 42 F6 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 29 01 00 00 0F B6 71 F7 0F B6 42 F7 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 02 01 00 00 8B 41 F8 3B 42 F8 74 79 0F B6 F0 0F B6 42 F8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 DC 00 00 00 0F B6 71 F9 0F B6 42 F9 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 BD 00 00 00 0F B6 71 FA 0F B6 42 FA 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 9E 00 00 00 0F B6 71 FB 0F B6 42 FB 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 75 7B 8B 41 FC 3B 42 FC 74 6B 0F B6 F0 0F B6 42 FC 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 59 0F B6 71 FD 0F B6 42 FD 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 3E 0F B6 71 FE 0F B6 42 FE 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 23 0F B6 41 FF 0F B6 4A FF 2B C1 74 11 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 EB 02 33 C0 85 C0 75 02 33 C0 5F 5E C3 8B 41 E3 3B 42 E3 74 6D 0F B6 F0 0F B6 42 E3 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 DB 0F B6 71 E4 0F B6 42 E4 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 C0 0F B6 71 E5 0F B6 42 E5 2B F0 74 0F 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 75 A5 0F B6 71 E6 0F B6 42 E6 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 75 82 8B 41 E7 3B 42 E7 74 7A 0F B6 42 E7 0F B6 71 E7 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 5B FF FF FF 0F B6 71 E8 0F B6 42 E8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 3C FF FF FF 0F B6 71 E9 0F B6 42 E9 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 1D FF FF FF 0F B6 71 EA 0F B6 42 EA 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 F6 FE FF FF 8B 41 EB 3B 42 EB 74 79 0F B6 F0 0F B6 42 EB 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D0 FE FF FF 0F B6 71 EC 0F B6 42 EC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B1 FE FF FF 0F B6 71 ED 0F B6 42 ED 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 92 FE FF FF 0F B6 71 EE 0F B6 42 EE 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 6B FE FF FF 8B 41 EF 3B 42 EF 74 79 0F B6 F0 0F B6 42 EF 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 45 FE FF FF 0F B6 71 F0 0F B6 42 F0 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 26 FE FF FF 0F B6 71 F1 0F B6 42 F1 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 07 FE FF FF 0F B6 71 F2 0F B6 42 F2 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 E0 FD FF FF 8B 41 F3 3B 42 F3 74 79 0F B6 F0 0F B6 42 F3 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 BA FD FF FF 0F B6 71 F4 0F B6 42 F4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 9B FD FF FF 0F B6 71 F5 0F B6 42 F5 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 7C FD FF FF 0F B6 71 F6 0F B6 42 F6 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 55 FD FF FF 8B 41 F7 3B 42 F7 74 79 0F B6 F0 0F B6 42 F7 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 2F FD FF FF 0F B6 71 F8 0F B6 42 F8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 10 FD FF FF 0F B6 71 F9 0F B6 42 F9 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 F1 FC FF FF 0F B6 71 FA 0F B6 42 FA 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 CA FC FF FF 8B 41 FB 3B 42 FB 74 79 0F B6 F0 0F B6 42 FB 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 A4 FC FF FF 0F B6 71 FC 0F B6 42 FC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 85 FC FF FF 0F B6 71 FD 0F B6 42 FD 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 66 FC FF FF 0F B6 71 FE 0F B6 42 FE 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 3F FC FF FF 0F B6 41 FF 0F B6 4A FF 2B C1 0F 84 2F FC FF FF 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 E9 1D FC FF FF 8B 41 E2 3B 42 E2 74 79 0F B6 F0 0F B6 42 E2 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 F7 FB FF FF 0F B6 71 E3 0F B6 42 E3 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 D8 FB FF FF 0F B6 71 E4 0F B6 42 E4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B9 FB FF FF 0F B6 71 E5 0F B6 42 E5 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 92 FB FF FF 8B 41 E6 3B 42 E6 74 7A 0F B6 42 E6 0F B6 71 E6 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 6B FB FF FF 0F B6 71 E7 0F B6 42 E7 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 4C FB FF FF 0F B6 71 E8 0F B6 42 E8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 2D FB FF FF 0F B6 71 E9 0F B6 42 E9 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 06 FB FF FF 8B 41 EA 3B 42 EA 74 79 0F B6 F0 0F B6 42 EA 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 E0 FA FF FF 0F B6 71 EB 0F B6 42 EB 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 C1 FA FF FF 0F B6 71 EC 0F B6 42 EC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 A2 FA FF FF 0F B6 71 ED 0F B6 42 ED 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 7B FA FF FF 8B 41 EE 3B 42 EE 74 79 0F B6 F0 0F B6 42 EE 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 55 FA FF FF 0F B6 71 EF 0F B6 42 EF 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 36 FA FF FF 0F B6 71 F0 0F B6 42 F0 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 17 FA FF FF 0F B6 71 F1 0F B6 42 F1 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 F0 F9 FF FF 8B 41 F2 3B 42 F2 74 79 0F B6 F0 0F B6 42 F2 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 CA F9 FF FF 0F B6 71 F3 0F B6 42 F3 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 AB F9 FF FF 0F B6 71 F4 0F B6 42 F4 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 8C F9 FF FF 0F B6 71 F5 0F B6 42 F5 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 65 F9 FF FF 8B 41 F6 3B 42 F6 74 79 0F B6 F0 0F B6 42 F6 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 3F F9 FF FF 0F B6 71 F7 0F B6 42 F7 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 20 F9 FF FF 0F B6 71 F8 0F B6 42 F8 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 01 F9 FF FF 0F B6 71 F9 0F B6 42 F9 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 DA F8 FF FF 8B 41 FA 3B 42 FA 74 79 0F B6 F0 0F B6 42 FA 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 B4 F8 FF FF 0F B6 71 FB 0F B6 42 FB 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 95 F8 FF FF 0F B6 71 FC 0F B6 42 FC 2B F0 74 13 33 C0 85 F6 0F 9F C0 8D 44 00 FF 85 C0 0F 85 76 F8 FF FF 0F B6 71 FD 0F B6 42 FD 2B F0 74 0D 33 C0 85 F6 0F 9F C0 8D 44 00 FF 8B F0 8B C6 EB 02 33 C0 85 C0 0F 85 4F F8 FF FF 66 8B 41 FE 66 3B 42 FE 0F 84 3F F8 FF FF E9 ED 03 }
	condition:
		$1
}

rule file_4_5_0 {
	meta:
		name = "_memcmp"
		size = 5760
		refs = "04c8 $LN1307 1600 $LN132 1604 $LN103 1608 $LN88 160c $LN73 1610 $LN120 1614 $LN105 1618 $LN90 161c $LN75 1620 $LN122 1624 $LN107 1628 $LN92 162c $LN77 1630 $LN124 1634 $LN109 1638 $LN94 163c $LN79 1640 $LN126 1644 $LN111 1648 $LN96 164c $LN81 1650 $LN128 1654 $LN113 1658 $LN98 165c $LN83 1660 $LN130 1664 $LN115 1668 $LN100 166c $LN85 1670 $LN131 1674 $LN116 1678 $LN101 167c $LN86"
	strings:
		$1 = { 55 8B EC 56 57 8B 7D 10 8B C7 83 E8 00 0F 84 E5 15 00 00 48 0F 84 CD 15 00 00 48 0F 84 98 15 00 00 48 0F 84 49 15 00 00 48 0F 84 B9 14 00 00 8B 4D 0C 8B 45 08 53 6A 20 5A E9 72 04 00 00 8B 30 3B 31 74 7C 0F B6 30 0F B6 19 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 69 04 00 00 0F B6 70 01 0F B6 59 01 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 48 04 00 00 0F B6 70 02 0F B6 59 02 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 27 04 00 00 0F B6 70 03 0F B6 59 03 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 02 04 00 00 8B 70 04 3B 71 04 74 7E 0F B6 70 04 0F B6 59 04 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 D9 03 00 00 0F B6 70 05 0F B6 59 05 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 B8 03 00 00 0F B6 70 06 0F B6 59 06 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 97 03 00 00 0F B6 70 07 0F B6 59 07 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 72 03 00 00 8B 70 08 3B 71 08 74 7E 0F B6 70 08 0F B6 59 08 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 49 03 00 00 0F B6 70 09 0F B6 59 09 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 28 03 00 00 0F B6 70 0A 0F B6 59 0A 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 07 03 00 00 0F B6 70 0B 0F B6 59 0B 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 E2 02 00 00 8B 70 0C 3B 71 0C 74 7E 0F B6 70 0C 0F B6 59 0C 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 B9 02 00 00 0F B6 70 0D 0F B6 59 0D 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 98 02 00 00 0F B6 70 0E 0F B6 59 0E 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 77 02 00 00 0F B6 70 0F 0F B6 59 0F 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 52 02 00 00 8B 70 10 3B 71 10 74 7E 0F B6 59 10 0F B6 70 10 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 29 02 00 00 0F B6 70 11 0F B6 59 11 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 08 02 00 00 0F B6 70 12 0F B6 59 12 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 E7 01 00 00 0F B6 70 13 0F B6 59 13 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 C2 01 00 00 8B 70 14 3B 71 14 74 7E 0F B6 70 14 0F B6 59 14 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 99 01 00 00 0F B6 70 15 0F B6 59 15 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 78 01 00 00 0F B6 70 16 0F B6 59 16 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 57 01 00 00 0F B6 70 17 0F B6 59 17 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 32 01 00 00 8B 70 18 3B 71 18 74 7E 0F B6 70 18 0F B6 59 18 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 09 01 00 00 0F B6 70 19 0F B6 59 19 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 E8 00 00 00 0F B6 70 1A 0F B6 59 1A 2B F3 74 15 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 0F 85 C7 00 00 00 0F B6 70 1B 0F B6 59 1B 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 0F 85 A2 00 00 00 8B 70 1C 3B 71 1C 74 72 0F B6 70 1C 0F B6 59 1C 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 75 7D 0F B6 70 1D 0F B6 59 1D 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 75 60 0F B6 70 1E 0F B6 59 1E 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 85 F6 75 43 0F B6 70 1F 0F B6 59 1F 2B F3 74 11 33 DB 85 F6 0F 9F C3 8D 5C 1B FF 8B F3 EB 02 33 F6 85 F6 75 22 03 C2 03 CA 2B FA 3B FA 0F 83 86 FB FF FF 03 C7 03 CF 83 FF 1F 0F 87 DA 03 00 00 FF 24 BD ?? ?? ?? ?? 8B C6 E9 CE 03 00 00 8B 50 E4 3B 51 E4 74 71 0F B6 F2 0F B6 51 E4 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 75 D5 0F B6 70 E5 0F B6 51 E5 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 75 B8 0F B6 70 E6 0F B6 51 E6 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 75 9B 0F B6 70 E7 0F B6 51 E7 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 76 FF FF FF 8B 50 E8 3B 51 E8 74 7D 0F B6 F2 0F B6 51 E8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 4E FF FF FF 0F B6 70 E9 0F B6 51 E9 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 2D FF FF FF 0F B6 70 EA 0F B6 51 EA 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 0C FF FF FF 0F B6 70 EB 0F B6 51 EB 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 E7 FE FF FF 8B 50 EC 3B 51 EC 74 7D 0F B6 F2 0F B6 51 EC 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 BF FE FF FF 0F B6 70 ED 0F B6 51 ED 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 9E FE FF FF 0F B6 70 EE 0F B6 51 EE 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 7D FE FF FF 0F B6 70 EF 0F B6 51 EF 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 58 FE FF FF 8B 50 F0 3B 51 F0 74 7D 0F B6 F2 0F B6 51 F0 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 30 FE FF FF 0F B6 70 F1 0F B6 51 F1 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 0F FE FF FF 0F B6 70 F2 0F B6 51 F2 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 EE FD FF FF 0F B6 70 F3 0F B6 51 F3 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 C9 FD FF FF 8B 50 F4 3B 51 F4 74 7E 0F B6 51 F4 0F B6 70 F4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 A0 FD FF FF 0F B6 70 F5 0F B6 51 F5 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 7F FD FF FF 0F B6 70 F6 0F B6 51 F6 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 5E FD FF FF 0F B6 70 F7 0F B6 51 F7 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 39 FD FF FF 8B 50 F8 3B 51 F8 74 7D 0F B6 F2 0F B6 51 F8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 11 FD FF FF 0F B6 70 F9 0F B6 51 F9 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 F0 FC FF FF 0F B6 70 FA 0F B6 51 FA 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 CF FC FF FF 0F B6 70 FB 0F B6 51 FB 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 AA FC FF FF 8B 50 FC 3B 51 FC 74 6F 0F B6 F2 0F B6 51 FC 2B F2 74 0F 33 D2 85 F6 0F 9F C2 8D 54 12 FF 85 D2 75 36 0F B6 70 FD 0F B6 51 FD 2B F2 74 0F 33 D2 85 F6 0F 9F C2 8D 54 12 FF 85 D2 75 1B 0F B6 70 FE 0F B6 51 FE 2B F2 74 13 33 D2 85 F6 0F 9F C2 8D 54 12 FF 85 D2 74 04 8B C2 EB 1D 0F B6 40 FF 0F B6 49 FF 2B C1 74 11 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 EB 02 33 C0 85 C0 75 02 33 C0 5B E9 53 0D 00 00 8B 50 E3 3B 51 E3 74 7D 0F B6 F2 0F B6 51 E3 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 FD FB FF FF 0F B6 70 E4 0F B6 51 E4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 DC FB FF FF 0F B6 70 E5 0F B6 51 E5 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 BB FB FF FF 0F B6 70 E6 0F B6 51 E6 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 96 FB FF FF 8B 50 E7 3B 51 E7 74 7D 0F B6 F2 0F B6 51 E7 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 6E FB FF FF 0F B6 70 E8 0F B6 51 E8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 4D FB FF FF 0F B6 70 E9 0F B6 51 E9 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 2C FB FF FF 0F B6 70 EA 0F B6 51 EA 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 07 FB FF FF 8B 50 EB 3B 51 EB 74 7D 0F B6 F2 0F B6 51 EB 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 DF FA FF FF 0F B6 70 EC 0F B6 51 EC 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 BE FA FF FF 0F B6 70 ED 0F B6 51 ED 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 9D FA FF FF 0F B6 70 EE 0F B6 51 EE 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 78 FA FF FF 8B 50 EF 3B 51 EF 74 7D 0F B6 F2 0F B6 51 EF 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 50 FA FF FF 0F B6 70 F0 0F B6 51 F0 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 2F FA FF FF 0F B6 70 F1 0F B6 51 F1 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 0E FA FF FF 0F B6 70 F2 0F B6 51 F2 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 E9 F9 FF FF 8B 50 F3 3B 51 F3 74 7D 0F B6 F2 0F B6 51 F3 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 C1 F9 FF FF 0F B6 70 F4 0F B6 51 F4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 A0 F9 FF FF 0F B6 70 F5 0F B6 51 F5 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 7F F9 FF FF 0F B6 70 F6 0F B6 51 F6 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 5A F9 FF FF 8B 50 F7 3B 51 F7 74 7E 0F B6 51 F7 0F B6 70 F7 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 31 F9 FF FF 0F B6 70 F8 0F B6 51 F8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 10 F9 FF FF 0F B6 70 F9 0F B6 51 F9 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 EF F8 FF FF 0F B6 70 FA 0F B6 51 FA 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 CA F8 FF FF 8B 50 FB 3B 51 FB 74 7D 0F B6 F2 0F B6 51 FB 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 A2 F8 FF FF 0F B6 70 FC 0F B6 51 FC 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 81 F8 FF FF 0F B6 70 FD 0F B6 51 FD 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 60 F8 FF FF 0F B6 70 FE 0F B6 51 FE 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 3B F8 FF FF 0F B6 49 FF 0F B6 40 FF 2B C1 0F 84 00 FC FF FF 33 C9 85 C0 0F 9F C1 8D 4C 09 FF 8B C1 E9 EE FB FF FF 8B 50 E2 3B 51 E2 74 7D 0F B6 F2 0F B6 51 E2 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 F1 F7 FF FF 0F B6 70 E3 0F B6 51 E3 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 D0 F7 FF FF 0F B6 70 E4 0F B6 51 E4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 AF F7 FF FF 0F B6 70 E5 0F B6 51 E5 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 8A F7 FF FF 8B 50 E6 3B 51 E6 74 7D 0F B6 F2 0F B6 51 E6 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 62 F7 FF FF 0F B6 70 E7 0F B6 51 E7 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 41 F7 FF FF 0F B6 70 E8 0F B6 51 E8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 20 F7 FF FF 0F B6 70 E9 0F B6 51 E9 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 FB F6 FF FF 8B 50 EA 3B 51 EA 74 7D 0F B6 F2 0F B6 51 EA 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 D3 F6 FF FF 0F B6 70 EB 0F B6 51 EB 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 B2 F6 FF FF 0F B6 70 EC 0F B6 51 EC 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 91 F6 FF FF 0F B6 70 ED 0F B6 51 ED 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 6C F6 FF FF 8B 50 EE 3B 51 EE 74 7D 0F B6 F2 0F B6 51 EE 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 44 F6 FF FF 0F B6 70 EF 0F B6 51 EF 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 23 F6 FF FF 0F B6 70 F0 0F B6 51 F0 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 02 F6 FF FF 0F B6 70 F1 0F B6 51 F1 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 DD F5 FF FF 8B 50 F2 3B 51 F2 74 7D 0F B6 F2 0F B6 51 F2 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 B5 F5 FF FF 0F B6 70 F3 0F B6 51 F3 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 94 F5 FF FF 0F B6 70 F4 0F B6 51 F4 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 73 F5 FF FF 0F B6 70 F5 0F B6 51 F5 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 EB 02 33 F6 85 F6 0F 85 4E F5 FF FF 8B 50 F6 3B 51 F6 74 7E 0F B6 51 F6 0F B6 70 F6 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 25 F5 FF FF 0F B6 51 F7 0F B6 70 F7 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 04 F5 FF FF 0F B6 51 F8 0F B6 70 F8 2B F2 74 15 33 D2 85 F6 0F 9F C2 8D 54 12 FF 8B F2 85 F6 0F 85 E3 F4 FF FF 0F B6 51 F9 0F B6 70 F9 2B F2 74 11 33 D2 85 F6 0F 9F C2 8D 54 12 FF }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
		size = 130
		refs = "0010 __getptd 0026 ___ptlocinfo 002e ___globallocalestatus 0038 ___updatetlocinfo 0043 ___ptmbcinfo 0058 ___updatetmbcinfo"
	strings:
		$1 = { 8B 44 24 04 85 C0 56 8B F1 C6 46 0C 00 75 63 E8 ?? ?? ?? ?? 89 46 08 8B 48 6C 89 0E 8B 48 68 89 4E 04 8B 0E 3B 0D ?? ?? ?? ?? 74 12 8B 0D ?? ?? ?? ?? 85 48 70 75 07 E8 ?? ?? ?? ?? 89 06 8B 46 04 3B 05 ?? ?? ?? ?? 74 16 8B 46 08 8B 0D ?? ?? ?? ?? 85 48 70 75 08 E8 ?? ?? ?? ?? 89 46 04 8B 46 08 F6 40 70 02 75 14 83 48 70 02 C6 46 0C 01 EB 0A 8B 08 89 0E 8B 40 04 89 46 04 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_5_3_0 {
	meta:
		name = "__mbschr_l"
		size = 186
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c __errno 002c __invalid_parameter 0051 _strchr"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 08 33 DB 3B C3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 74 56 8B 75 F4 39 5E 08 75 3A FF 75 0C 50 E8 ?? ?? ?? ?? 59 59 EB 41 0F B6 D1 F6 44 32 1D 04 74 1A 40 8A 10 3A D3 74 3E 0F B7 C9 0F B6 D2 C1 E1 08 0B CA 39 4D 0C 75 0B 48 EB 1D 0F B7 D1 39 55 0C 74 0D 40 66 0F B6 08 0F B7 C9 66 3B CB 75 C7 0F B7 C9 39 4D 0C 75 0E 38 5D FC 74 17 8B 4D F8 83 61 70 FD EB 0E 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5E 5B C9 C3 }
	condition:
		$1
}

rule file_5_4_0 {
	meta:
		name = "__mbschr"
		size = 19
		refs = "000b __mbschr_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_696_2_0 {
	meta:
		name = "__aligned_malloc"
		size = 19
		refs = "000b __aligned_offset_malloc"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_30_4_0 {
	meta:
		name = "__atodbl"
		size = 19
		refs = "000b __atodbl_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_30_8_0 {
	meta:
		name = "__atoflt"
		size = 19
		refs = "000b __atoflt_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_30_6_0 {
	meta:
		name = "__atoldbl"
		size = 19
		refs = "000b __atoldbl_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_850_0_0 {
	meta:
		name = "__execvp"
		size = 19
		refs = "000b __execvpe"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_305_1_0 {
	meta:
		name = "__getws_s"
		size = 19
		refs = "000b __getws_helper"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_68_4_0 {
	meta:
		name = "__ismbslead"
		size = 19
		refs = "000b __ismbslead_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_359_4_0 {
	meta:
		name = "__ismbstrail"
		size = 19
		refs = "000b __ismbstrail_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_754_4_0 {
	meta:
		name = "__mbbtype"
		size = 19
		refs = "000b __mbbtype_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_609_4_0 {
	meta:
		name = "__mbsbtype"
		size = 19
		refs = "000b __mbsbtype_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_631_4_0 {
	meta:
		name = "__mbscmp"
		size = 19
		refs = "000b __mbscmp_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_749_4_0 {
	meta:
		name = "__mbscoll"
		size = 19
		refs = "000b __mbscoll_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_210_4_0 {
	meta:
		name = "__mbscspn"
		size = 19
		refs = "000b __mbscspn_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_146_4_0 {
	meta:
		name = "__mbsdec"
		size = 19
		refs = "000b __mbsdec_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_839_4_0 {
	meta:
		name = "__mbsicmp"
		size = 19
		refs = "000b __mbsicmp_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_670_4_0 {
	meta:
		name = "__mbsicoll"
		size = 19
		refs = "000b __mbsicoll_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_233_4_0 {
	meta:
		name = "__mbslwr_s"
		size = 19
		refs = "000b __mbslwr_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_272_4_0 {
	meta:
		name = "__mbsnbcnt"
		size = 19
		refs = "000b __mbsnbcnt_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_87_4_0 {
	meta:
		name = "__mbsnccnt"
		size = 19
		refs = "000b __mbsnccnt_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_705_1_0 {
	meta:
		name = "__mbsninc"
		size = 19
		refs = "000b __mbsninc_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_814_4_0 {
	meta:
		name = "__mbsnlen"
		size = 19
		refs = "000b __mbsnlen_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_457_4_0 {
	meta:
		name = "__mbspbrk"
		size = 19
		refs = "000b __mbspbrk_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_639_4_0 {
	meta:
		name = "__mbsrchr"
		size = 19
		refs = "000b __mbsrchr_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_390_4_0 {
	meta:
		name = "__mbsset"
		size = 19
		refs = "000b __mbsset_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_556_4_0 {
	meta:
		name = "__mbsspn"
		size = 19
		refs = "000b __mbsspn_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_659_4_0 {
	meta:
		name = "__mbsspnp"
		size = 19
		refs = "000b __mbsspnp_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_367_4_0 {
	meta:
		name = "__mbsstr"
		size = 19
		refs = "000b __mbsstr_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_314_1_0 {
	meta:
		name = "__mbstok"
		size = 19
		refs = "000b __mbstok_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_396_4_0 {
	meta:
		name = "__mbstrnlen"
		size = 19
		refs = "000b __mbstrnlen_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_533_4_0 {
	meta:
		name = "__mbsupr_s"
		size = 19
		refs = "000b __mbsupr_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_246_7_0 {
	meta:
		name = "__strlwr_s"
		size = 19
		refs = "000b __strlwr_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_108_7_0 {
	meta:
		name = "__strupr_s"
		size = 19
		refs = "000b __strupr_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_852_7_0 {
	meta:
		name = "__wcslwr_s"
		size = 19
		refs = "000b __wcslwr_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_848_7_0 {
	meta:
		name = "__wcsupr_s"
		size = 19
		refs = "000b __wcsupr_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "__wexecvp"
		size = 19
		refs = "000b __wexecvpe"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_268_1_0 {
	meta:
		name = "_gets_s"
		size = 19
		refs = "000b __gets_helper"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_861_4_0 {
	meta:
		name = "_strcoll"
		size = 19
		refs = "000b __strcoll_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_163_4_0 {
	meta:
		name = "_strtod"
		size = 19
		refs = "000b __strtod_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_528_4_0 {
	meta:
		name = "_wcstod"
		size = 19
		refs = "000b __wcstod_l"
	strings:
		$1 = { 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "__heapchk"
		size = 141
		refs = "0003 __sehtable$__heapchk 0008 __SEH_prolog4 0014 ___active_heap 001e __lock 0028 ___sbh_heap_check 0045 __crtheap 004b __imp__HeapValidate@12 0055 __imp__GetLastError@0 0061 ___doserrno 0068 __errno 0077 __unlock 0088 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A FE 5E 89 75 E4 83 3D ?? ?? ?? ?? 03 75 24 6A 04 E8 ?? ?? ?? ?? 59 83 65 FC 00 E8 ?? ?? ?? ?? 85 C0 7D 07 C7 45 E4 FC FF FF FF 89 75 FC E8 35 00 00 00 6A 00 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 31 FF 15 ?? ?? ?? ?? 6A 78 5E 3B C6 75 1D E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 28 00 00 00 EB 10 6A 04 E8 ?? ?? ?? ?? 59 C3 C7 45 E4 FC FF FF FF 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "__gmtime32_s"
		size = 301
		refs = "0013 __errno 0022 __invalid_parameter 0039 _memset 00ab __lpdays 00c0 __days"
	strings:
		$1 = { 55 8B EC 51 53 56 8B 75 08 33 DB 3B F3 89 5D FC 75 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 F9 00 00 00 6A 24 68 FF 00 00 00 56 E8 ?? ?? ?? ?? 8B 45 0C 83 C4 0C 3B C3 74 CB 8B 08 3B CB 7D 0C E8 ?? ?? ?? ?? 6A 16 5E 89 30 EB D0 8B C1 99 57 BF 80 1F 86 07 F7 FF 8B D0 69 D2 80 E0 79 F8 03 CA 8D 14 85 46 00 00 00 B8 80 33 E1 01 3B C8 7C 1F 2B C8 42 3B C8 7C 18 2B C8 B8 00 85 E2 01 42 3B C8 7C 05 42 2B C8 EB 07 C7 45 FC 01 00 00 00 8B C1 89 56 14 99 BF 80 51 01 00 F7 FF BF ?? ?? ?? ?? 89 46 1C 69 C0 80 AE FE FF 03 C8 39 5D FC 75 05 BF ?? ?? ?? ?? 8B 46 1C 33 D2 42 39 47 04 7D 0A 8B D8 42 39 1C 97 7C FA 33 DB 4A 89 56 10 2B 04 97 BF 80 51 01 00 89 46 0C 8B 45 0C 8B 00 99 F7 FF 6A 07 5F 6A 3C 89 5E 20 83 C0 04 99 F7 FF 8B C1 BF 10 0E 00 00 89 56 18 99 F7 FF 5F 89 46 08 69 C0 F0 F1 FF FF 03 C8 8B C1 99 F7 FF 5F 89 46 04 6B C0 3C 2B C8 89 0E 33 C0 5E 5B C9 C3 }
	condition:
		$1
}

rule file_8_1_0 {
	meta:
		name = "___getgmtimebuf"
		size = 72
		refs = "0003 __getptd_noexit 000e __errno 0025 __malloc_crt"
	strings:
		$1 = { 51 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 29 83 7E 44 00 75 20 6A 24 E8 ?? ?? ?? ?? 85 C0 59 89 46 44 75 11 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 8B 44 24 04 EB 03 8B 46 44 5E 59 C3 }
	condition:
		$1
}

rule file_8_2_0 {
	meta:
		name = "__gmtime32"
		size = 36
		refs = "0002 ___getgmtimebuf 0014 __gmtime32_s"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 02 5E C3 FF 74 24 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E C3 }
	condition:
		$1
}

rule file_774_1_0 {
	meta:
		name = "__gmtime64"
		size = 36
		refs = "0002 ___getgmtimebuf 0014 __gmtime64_s"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 02 5E C3 FF 74 24 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E C3 }
	condition:
		$1
}

rule file_560_2_0 {
	meta:
		name = "__localtime32"
		size = 36
		refs = "0002 ___getgmtimebuf 0014 __localtime32_s"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 02 5E C3 FF 74 24 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E C3 }
	condition:
		$1
}

rule file_590_2_0 {
	meta:
		name = "__localtime64"
		size = 36
		refs = "0002 ___getgmtimebuf 0014 __localtime64_s"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 02 5E C3 FF 74 24 08 56 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 59 23 C6 5E C3 }
	condition:
		$1
}

rule file_9_0_0 {
	meta:
		name = "__invoke_watson_if_error"
		size = 34
		refs = "0019 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 7D 08 00 74 17 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_9_1_0 {
	meta:
		name = "_TranslateName"
		size = 96
		refs = "002e __stricmp"
	strings:
		$1 = { 55 8B EC 33 C0 53 33 DB 40 39 5D 0C 7C 46 56 57 85 C0 74 3E 8B 45 0C 03 C3 99 2B C2 8B F0 8B 45 08 D1 FE 8D 3C F0 FF 37 8B 45 10 FF 30 E8 ?? ?? ?? ?? 85 C0 59 59 75 0A 8B 4D 10 83 C7 04 89 39 EB 0B 7D 06 4E 89 75 0C EB 03 8D 5E 01 3B 5D 0C 7E BE 5F 5E 33 C9 85 C0 0F 94 C1 5B 8B C1 5D C3 }
	condition:
		$1
}

rule file_9_2_0 {
	meta:
		name = "_GetLcidFromDefault"
		size = 20
		refs = "0009 __imp__GetUserDefaultLCID@0"
	strings:
		$1 = { 81 4E 08 04 01 00 00 FF 15 ?? ?? ?? ?? 89 46 1C 89 46 18 C3 }
	condition:
		$1
}

rule file_9_3_0 {
	meta:
		name = "_ProcessCodePage"
		size = 119
		refs = "0007 ___security_cookie 001d ??_C@_03DFHEHBHG@ACP?$AA@ 0023 _strcmp 002e ??_C@_03NFKLAGEF@OCP?$AA@ 0058 __imp__GetLocaleInfoA@16 0065 _atol 0071 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B F1 85 F6 74 31 80 3E 00 74 2C 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 1B 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 25 6A 08 8D 45 F4 50 6A 0B EB 0B 6A 08 8D 45 F4 50 68 04 10 00 00 FF 77 1C FF 15 ?? ?? ?? ?? 85 C0 74 0A 8D 75 F4 56 E8 ?? ?? ?? ?? 59 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_9_4_0 {
	meta:
		name = "_TestDefaultCountry"
		size = 30
		refs = "000a ___rglangidNotDefault"
	strings:
		$1 = { 33 C0 66 8B 4C 24 04 66 3B 88 ?? ?? ?? ?? 74 0B 40 40 83 F8 14 72 EB 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_9_5_0 {
	meta:
		name = "_LcidFromHexString"
		size = 50
	strings:
		$1 = { 56 33 F6 EB 23 8A C1 2C 61 42 3C 05 77 05 80 C1 D9 EB 0B 8A C1 2C 41 3C 05 77 03 80 C1 F9 0F BE C1 C1 E6 04 8D 74 06 D0 8A 0A 84 C9 75 D7 8B C6 5E C3 }
	condition:
		$1
}

rule file_9_6_0 {
	meta:
		name = "_GetPrimaryLen"
		size = 27
	strings:
		$1 = { 33 C0 8A 0A 42 80 F9 41 7C 05 80 F9 5A 7E 08 80 E9 61 80 F9 19 77 03 40 EB E8 C3 }
	condition:
		$1
}

rule file_9_7_0 {
	meta:
		name = "_CountryEnumProc@4"
		size = 150
		refs = "0007 ___security_cookie 0016 __getptd 0025 _LcidFromHexString 0046 __imp__GetLocaleInfoA@16 005c __stricmp 0068 _TestDefaultCountry 008e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 7D 08 E8 ?? ?? ?? ?? 8B F0 8B D7 81 C6 9C 00 00 00 E8 ?? ?? ?? ?? 8B F8 6A 78 8D 45 84 50 8B 46 14 F7 D8 1B C0 25 05 F0 FF FF 05 02 10 00 00 50 57 FF 15 ?? ?? ?? ?? 85 C0 75 06 21 46 08 40 EB 32 8D 45 84 50 FF 76 04 E8 ?? ?? ?? ?? 85 C0 59 59 75 15 57 E8 ?? ?? ?? ?? 85 C0 59 74 0A 83 4E 08 04 89 7E 1C 89 7E 18 8B 46 08 C1 E8 02 F7 D0 83 E0 01 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C2 04 00 }
	condition:
		$1
}

rule file_9_8_0 {
	meta:
		name = "_TestDefaultLanguage"
		size = 114
		refs = "0007 ___security_cookie 002b __imp__GetLocaleInfoA@16 003b _LcidFromHexString 0050 _GetPrimaryLen 0058 _strlen 006c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 6A 78 8D 45 84 50 8B 45 08 25 FF 03 00 00 6A 01 0D 00 04 00 00 50 8B F1 FF 15 ?? ?? ?? ?? 85 C0 75 04 33 C0 EB 2E 8D 55 84 E8 ?? ?? ?? ?? 39 45 08 74 1E 83 7D 0C 00 74 18 8B 36 57 8B D6 E8 ?? ?? ?? ?? 56 8B F8 E8 ?? ?? ?? ?? 59 3B F8 5F 74 D1 33 C0 40 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_9_9_0 {
	meta:
		name = "_LangCountryEnumProc@4"
		size = 464
		refs = "0007 ___security_cookie 0017 __getptd 0026 _LcidFromHexString 002c __imp__GetLocaleInfoA@16 0065 __stricmp 00c4 __strnicmp 00d9 _strlen 00f2 _TestDefaultCountry 019b _TestDefaultLanguage 01c8 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B 7D 08 E8 ?? ?? ?? ?? 8B F0 8B D7 81 C6 9C 00 00 00 E8 ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 8B F8 6A 78 8D 45 84 50 8B 46 14 F7 D8 1B C0 25 05 F0 FF FF 05 02 10 00 00 50 57 FF D3 85 C0 75 0C 83 66 08 00 33 C0 40 E9 62 01 00 00 8D 45 84 50 FF 76 04 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 91 00 00 00 6A 78 8D 45 84 50 8B 46 10 F7 D8 1B C0 25 02 F0 FF FF 05 01 10 00 00 50 57 FF D3 85 C0 74 BF 8D 45 84 50 FF 36 E8 ?? ?? ?? ?? 85 C0 59 59 75 0C 81 4E 08 04 03 00 00 89 7E 18 EB 52 F6 46 08 02 75 4F 8B 46 0C 85 C0 74 2C 50 8D 45 84 50 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 19 FF 36 83 4E 08 02 89 7E 1C E8 ?? ?? ?? ?? 3B 46 0C 59 75 21 89 7E 18 EB 1C 8B 56 08 F6 C2 01 75 14 57 E8 ?? ?? ?? ?? 85 C0 59 74 09 83 CA 01 89 56 08 89 7E 1C 8B 4E 08 B8 00 03 00 00 23 C8 3B C8 0F 84 9E 00 00 00 6A 78 8D 45 84 50 8B 46 10 F7 D8 1B C0 25 02 F0 FF FF 05 01 10 00 00 50 57 FF D3 85 C0 0F 84 18 FF FF FF 8D 45 84 50 FF 36 E8 ?? ?? ?? ?? 59 33 DB 85 C0 59 75 2F 81 4E 08 00 02 00 00 39 5E 10 8B 46 08 74 0A 0D 00 01 00 00 89 46 08 EB 47 39 5E 0C 74 3B FF 36 E8 ?? ?? ?? ?? 3B 46 0C 59 75 2E 6A 01 EB 1C 39 5E 10 75 34 39 5E 0C 74 2F 8D 45 84 50 FF 36 E8 ?? ?? ?? ?? 85 C0 59 59 75 1E 53 57 8B CE E8 ?? ?? ?? ?? 85 C0 59 59 74 0F 81 4E 08 00 01 00 00 39 5E 18 75 03 89 7E 18 8B 46 08 C1 E8 02 F7 D0 83 E0 01 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C2 04 00 }
	condition:
		$1
}

rule file_9_10_0 {
	meta:
		name = "_LanguageEnumProc@4"
		size = 191
		refs = "0007 ___security_cookie 0016 __getptd 0025 _LcidFromHexString 0046 __imp__GetLocaleInfoA@16 005b __stricmp 0090 _TestDefaultLanguage 00b7 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 8B 7D 08 E8 ?? ?? ?? ?? 8B F0 8B D7 81 C6 9C 00 00 00 E8 ?? ?? ?? ?? 8B F8 6A 78 8D 45 84 50 8B 46 10 F7 D8 1B C0 25 02 F0 FF FF 05 01 10 00 00 50 57 FF 15 ?? ?? ?? ?? 85 C0 75 06 21 46 08 40 EB 5B 8D 45 84 50 FF 36 E8 ?? ?? ?? ?? 85 C0 59 59 75 09 39 46 10 75 30 6A 01 EB 1E 83 7E 10 00 75 30 83 7E 0C 00 74 2A 8D 45 84 50 FF 36 E8 ?? ?? ?? ?? 85 C0 59 59 75 19 50 57 8B CE E8 ?? ?? ?? ?? 85 C0 59 59 74 0A 83 4E 08 04 89 7E 18 89 7E 1C 8B 46 08 C1 E8 02 F7 D0 83 E0 01 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C2 04 00 }
	condition:
		$1
}

rule file_9_11_0 {
	meta:
		name = "_GetLcidFromCountry"
		size = 44
		refs = "0004 _strlen 0014 _CountryEnumProc@4 001d __imp__EnumSystemLocalesA@8"
	strings:
		$1 = { FF 76 04 E8 ?? ?? ?? ?? 83 E8 03 F7 D8 59 1B C0 6A 01 40 68 ?? ?? ?? ?? 89 46 14 FF 15 ?? ?? ?? ?? F6 46 08 04 75 04 83 66 08 00 C3 }
	condition:
		$1
}

rule file_9_12_0 {
	meta:
		name = "_GetLcidFromLangCountry"
		size = 101
		refs = "0003 _strlen 0039 _GetPrimaryLen 0040 _LangCountryEnumProc@4 0049 __imp__EnumSystemLocalesA@8"
	strings:
		$1 = { FF 36 E8 ?? ?? ?? ?? FF 76 04 83 E8 03 F7 D8 1B C0 40 89 46 10 E8 ?? ?? ?? ?? 83 E8 03 F7 D8 1B C0 83 66 18 00 40 83 7E 10 00 59 59 89 46 14 74 05 6A 02 58 EB 07 8B 16 E8 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 89 46 0C FF 15 ?? ?? ?? ?? 8B 46 08 66 A9 00 01 74 0A 66 A9 00 02 74 04 A8 07 75 04 83 66 08 00 C3 }
	condition:
		$1
}

rule file_9_13_0 {
	meta:
		name = "_GetLcidFromLanguage"
		size = 60
		refs = "0003 _strlen 001d _GetPrimaryLen 0024 _LanguageEnumProc@4 002d __imp__EnumSystemLocalesA@8"
	strings:
		$1 = { FF 36 E8 ?? ?? ?? ?? 83 E8 03 F7 D8 1B C0 40 59 89 46 10 74 05 6A 02 58 EB 07 8B 16 E8 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 89 46 0C FF 15 ?? ?? ?? ?? F6 46 08 04 75 04 83 66 08 00 C3 }
	condition:
		$1
}

rule file_9_14_0 {
	meta:
		name = "___get_qualified_locale"
		size = 483
		refs = "0005 __getptd 003d ___rg_country 0042 _TranslateName 0061 _GetLcidFromLangCountry 0068 _GetLcidFromLanguage 0075 ___rg_language 00a9 _strlen 00b9 _CountryEnumProc@4 00c2 __imp__EnumSystemLocalesA@8 00da __imp__GetUserDefaultLCID@0 00fe _ProcessCodePage 012a __imp__IsValidCodePage@4 013d __imp__IsValidLocale@8 0173 __imp__GetLocaleInfoA@16 017a ??_C@_0BC@NFIEMBLL@Norwegian?9Nynorsk?$AA@ 0182 _strcpy_s 0195 __invoke_watson 01d0 __itoa_s"
	strings:
		$1 = { 53 55 56 57 E8 ?? ?? ?? ?? 8B 6C 24 14 8B F0 33 DB 81 C6 9C 00 00 00 3B EB 75 0C 81 4E 08 04 01 00 00 E9 B1 00 00 00 8D 45 40 3B C3 8D 7E 04 89 2E 89 07 74 14 38 18 74 10 57 6A 16 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 8B 06 3B C3 89 5E 08 74 4B 38 18 74 47 8B 07 3B C3 74 0B 38 18 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 39 5E 08 75 7C 56 6A 40 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 5F 8B 3F 3B FB 74 0B 38 1F 74 07 E8 ?? ?? ?? ?? EB 4E E8 ?? ?? ?? ?? EB 47 8B 3F 3B FB 74 2E 38 1F 74 2A 57 E8 ?? ?? ?? ?? 83 E8 03 F7 D8 59 1B C0 6A 01 40 68 ?? ?? ?? ?? 89 46 14 FF 15 ?? ?? ?? ?? F6 46 08 04 75 18 89 5E 08 EB 13 C7 46 08 04 01 00 00 FF 15 ?? ?? ?? ?? 89 46 18 89 46 1C 39 5E 08 0F 84 EF 00 00 00 8B CD 81 C5 80 00 00 00 F7 D9 1B C9 23 CD 8B FE E8 ?? ?? ?? ?? 8B D8 85 DB 0F 84 D0 00 00 00 81 FB E8 FD 00 00 0F 84 C4 00 00 00 81 FB E9 FD 00 00 0F 84 B8 00 00 00 0F B7 C3 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 A6 00 00 00 6A 01 FF 76 18 FF 15 ?? ?? ?? ?? 85 C0 0F 84 93 00 00 00 8B 44 24 18 85 C0 74 13 66 8B 4E 18 66 89 08 66 8B 4E 1C 66 89 48 02 66 89 58 04 8B 7C 24 1C 85 FF 74 6B 66 81 38 14 08 8B 2D ?? ?? ?? ?? 75 25 68 ?? ?? ?? ?? 6A 40 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 22 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 EB 11 6A 40 57 68 01 10 00 00 FF 76 18 FF D5 85 C0 74 2D 6A 40 8D 47 40 50 68 02 10 00 00 FF 76 1C FF D5 85 C0 74 19 6A 0A 6A 10 81 C7 80 00 00 00 57 53 E8 ?? ?? ?? ?? 83 C4 10 33 C0 40 EB 02 33 C0 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "__wspawnle"
		size = 92
		refs = "000e __errno 001e __invalid_parameter 0052 __wspawnve"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2F 66 39 31 74 DE 8B 45 10 3B C6 74 D7 66 39 30 74 D2 8D 45 10 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_608_0_0 {
	meta:
		name = "__wspawnlpe"
		size = 92
		refs = "000e __errno 001e __invalid_parameter 0052 __wspawnvpe"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 2F 66 39 31 74 DE 8B 45 10 3B C6 74 D7 66 39 30 74 D2 8D 45 10 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 45 10 50 51 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_11_3_0 {
	meta:
		name = "__mbstrlen_l"
		size = 164
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 _strlen 0048 __imp__MultiByteToWideChar@24 0051 __errno 007a __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 83 B8 AC 00 00 00 01 75 18 FF 75 08 E8 ?? ?? ?? ?? 80 7D FC 00 59 74 76 8B 4D F8 83 61 70 FD C9 C3 53 56 8B 75 08 33 DB 53 53 6A FF 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 75 1C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF EB 34 57 33 FF EB 1A 8D 4D F0 0F B6 C0 51 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 05 46 38 1E 74 08 47 46 8A 06 3A C3 75 E0 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_11_4_0 {
	meta:
		name = "__mbstrlen"
		size = 28
		refs = "0002 ___locale_changed 000a _strlen 0015 __mbstrlen_l"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 05 E9 ?? ?? ?? ?? 6A 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_12_0_0 {
	meta:
		name = "__sse2_mathfcns_init"
		size = 20
		refs = "0002 ___use_sse2_mathfcns 0008 __get_sse2_info"
	strings:
		$1 = { 83 25 ?? ?? ?? ?? 00 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_12_1_0 {
	meta:
		name = "__set_SSE2_enable"
		size = 20
		refs = "000a ___sse2_available 000f ___use_sse2_mathfcns"
	strings:
		$1 = { 8B 44 24 04 F7 D8 1B C0 23 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_13_0_0 {
	meta:
		name = "__getdrive"
		size = 198
		refs = "000f ___security_cookie 0024 __imp__GetCurrentDirectoryA@8 0049 __calloc_crt 0056 __errno 0088 _toupper 00a7 _free 00ba @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 6C FF FF FF 81 EC 14 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 90 00 00 00 83 65 84 00 53 56 57 8B 3D ?? ?? ?? ?? 8D 5D 88 8B C3 50 68 05 01 00 00 FF D7 8B F0 81 FE 04 01 00 00 7E 38 8D 46 01 6A 01 50 89 45 80 E8 ?? ?? ?? ?? 8B D8 85 DB 59 59 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 F6 EB 13 85 F6 C7 45 84 01 00 00 00 74 08 53 FF 75 80 FF D7 8B F0 33 FF 85 F6 74 17 80 7B 01 3A 75 1C 0F B6 03 50 E8 ?? ?? ?? ?? 8B F8 59 83 EF 40 EB 0B E8 ?? ?? ?? ?? C7 00 0C 00 00 00 83 7D 84 00 74 07 53 E8 ?? ?? ?? ?? 59 8B 8D 90 00 00 00 8B C7 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 81 C5 94 00 00 00 C9 C3 }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "__chdrive"
		size = 161
		refs = "0003 __sehtable$__chdrive 0008 __SEH_prolog4 0019 ___doserrno 0024 __errno 0036 __invalid_parameter 0045 __lock 0065 __imp__SetCurrentDirectoryA@4 0074 __imp__GetLastError@0 007a __dosmaperr 0093 __SEH_epilog4 009b __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 7D 08 01 7C 06 83 7D 08 1F 7E 2A E8 ?? ?? ?? ?? C7 00 0F 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 33 DB 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 50 6A 07 E8 ?? ?? ?? ?? 59 33 DB 89 5D FC 8B 45 08 83 C0 40 88 45 E4 C6 45 E5 3A 88 5D E6 8D 45 E4 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 89 5D E0 EB 11 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 4D E0 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "__read_nolock"
		size = 1442
		refs = "001b ___doserrno 0023 __errno 003e __nhandle 005c __invalid_parameter 007a ___pioinfo 0181 __imp__ReadFile@20 020c __malloc_crt 02af __imp__GetLastError@0 02ef __lseeki64_nolock 0363 __lookuptrailbytes 03e9 __imp__MultiByteToWideChar@24 03fc __dosmaperr 040f _free"
	strings:
		$1 = { 55 8B EC 83 EC 1C 8B 55 10 56 8B 75 08 6A FE 58 3B F0 89 45 EC 89 55 E4 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 6A 05 00 00 57 33 FF 3B F7 7C 08 3B 35 ?? ?? ?? ?? 72 27 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 33 05 00 00 8B C6 83 E6 1F 6B F6 28 C1 F8 05 53 8D 1C 85 ?? ?? ?? ?? 8B 03 03 C6 8A 48 04 F6 C1 01 75 17 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E9 47 01 00 00 3B D7 89 7D F0 0F 84 EF 04 00 00 F6 C1 02 0F 85 E6 04 00 00 8B 4D 0C 3B CF 0F 84 16 01 00 00 8A 40 24 02 C0 D0 F8 88 45 FE 0F BE C0 48 0F 84 FA 00 00 00 48 75 12 8B C2 F7 D0 A8 01 0F 84 F3 00 00 00 83 E2 FE 89 55 10 89 4D F4 8B 0B 8B 45 F4 8D 3C 0E F6 47 04 48 74 76 8A 4F 05 80 F9 0A 74 6E 33 D2 39 55 10 74 67 88 08 8B 0B 40 FF 4D 10 38 55 FE C7 45 F0 01 00 00 00 C6 44 0E 05 0A 74 4E 8B 0B 8A 4C 0E 25 80 F9 0A 74 43 39 55 10 74 3E 88 08 8B 0B 40 FF 4D 10 80 7D FE 01 C7 45 F0 02 00 00 00 C6 44 0E 25 0A 75 24 8B 0B 8A 4C 0E 26 80 F9 0A 74 19 39 55 10 74 14 88 08 8B 0B 40 FF 4D 10 C7 45 F0 03 00 00 00 C6 44 0E 26 0A 6A 00 8D 4D E8 51 FF 75 10 50 8B 03 FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D8 03 00 00 8B 7D E8 85 FF 0F 8C CD 03 00 00 3B 7D 10 0F 87 C4 03 00 00 8B 03 01 7D F0 8D 44 06 04 F6 00 80 0F 84 52 02 00 00 80 7D FE 02 0F 84 72 02 00 00 85 FF 74 79 8B 4D F4 80 39 0A 75 71 80 08 04 EB 6F 8B C2 F7 D0 A8 01 75 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB 3B 8B C2 6A 04 59 D1 E8 3B C1 89 4D 10 72 03 89 45 10 FF 75 10 E8 ?? ?? ?? ?? 3B C7 59 89 45 F4 0F 85 D0 FE FF FF E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 83 C8 FF E9 63 03 00 00 80 20 FB 8B 7D F4 8B 45 F0 03 C7 3B F8 89 7D 10 89 45 F0 0F 83 D0 00 00 00 8B 4D 10 8A 01 3C 1A 0F 84 AE 00 00 00 3C 0D 74 0C 88 07 47 41 89 4D 10 E9 90 00 00 00 8B 45 F0 48 3B C8 73 17 8D 41 01 80 38 0A 75 0A 41 41 89 4D 10 C6 07 0A EB 75 89 45 10 EB 6D FF 45 10 6A 00 8D 45 E8 50 6A 01 8D 45 FF 50 8B 03 FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 85 C0 75 45 83 7D E8 00 74 3F 8B 03 F6 44 06 04 48 74 14 80 7D FF 0A 74 B9 C6 07 0D 8B 03 8A 4D FF 88 4C 06 05 EB 25 3B 7D F4 75 06 80 7D FF 0A 74 A0 6A 01 6A FF 6A FF FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 80 7D FF 0A 74 04 C6 07 0D 47 8B 45 F0 39 45 10 0F 82 47 FF FF FF EB 15 8B 03 8D 44 06 04 F6 00 40 75 05 80 08 02 EB 05 8A 01 88 07 47 8B C7 2B 45 F4 80 7D FE 01 89 45 F0 0F 85 D0 00 00 00 85 C0 0F 84 C8 00 00 00 4F 8A 0F 84 C9 78 06 47 E9 86 00 00 00 33 C0 40 0F B6 C9 EB 0F 83 F8 04 7F 13 3B 7D F4 72 0E 4F 0F B6 0F 40 80 B9 ?? ?? ?? ?? 00 74 E8 8A 17 0F B6 CA 0F BE 89 ?? ?? ?? ?? 85 C9 75 0D E8 ?? ?? ?? ?? C7 00 2A 00 00 00 EB 7A 41 3B C8 75 04 03 F8 EB 40 8B 0B 03 CE F6 41 04 48 74 24 47 83 F8 02 88 51 05 7C 09 8A 17 8B 0B 88 54 0E 25 47 83 F8 03 75 09 8A 17 8B 0B 88 54 0E 26 47 2B F8 EB 12 F7 D8 99 6A 01 52 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B 45 E4 2B 7D F4 D1 E8 50 FF 75 0C 57 FF 75 F4 6A 00 68 E9 FD 00 00 FF 15 ?? ?? ?? ?? 85 C0 89 45 F0 75 34 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 83 4D EC FF 8B 45 F4 3B 45 0C 74 07 50 E8 ?? ?? ?? ?? 59 8B 45 EC 83 F8 FE 0F 85 7D 01 00 00 8B 45 F0 E9 75 01 00 00 03 C0 89 45 F0 EB D6 85 FF 74 0E 8B 4D F4 66 83 39 0A 75 05 80 08 04 EB 03 80 20 FB 8B 7D F4 8B 45 F0 03 C7 3B F8 89 7D 10 89 45 F0 0F 83 00 01 00 00 8B 45 10 0F B7 08 66 83 F9 1A 0F 84 D8 00 00 00 66 83 F9 0D 74 0F 66 89 0F 47 47 40 40 89 45 10 E9 B5 00 00 00 8B 4D F0 83 C1 FE 3B C1 73 21 8D 48 02 66 83 39 0A 75 10 83 C0 04 89 45 10 66 C7 07 0A 00 E9 90 00 00 00 89 4D 10 E9 83 00 00 00 83 45 10 02 6A 00 8D 45 E8 50 6A 02 8D 45 F8 50 8B 03 FF 34 06 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 85 C0 75 5A 83 7D E8 00 74 54 8B 03 F6 44 06 04 48 74 27 66 83 7D F8 0A 74 AF 66 C7 07 0D 00 8B 03 8A 4D F8 88 4C 06 05 8B 03 8A 4D F9 88 4C 06 25 8B 03 C6 44 06 26 0A EB 29 3B 7D F4 75 07 66 83 7D F8 0A 74 83 6A 01 6A FF 6A FE FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 66 83 7D F8 0A 74 07 66 C7 07 0D 00 47 47 8B 45 F0 39 45 10 0F 82 1A FF FF FF EB 18 8B 0B 8D 74 0E 04 F6 06 40 75 05 80 0E 02 EB 08 66 8B 00 66 89 07 47 47 2B 7D F4 89 7D F0 E9 A0 FE FF FF FF 15 ?? ?? ?? ?? 6A 05 5E 3B C6 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 30 E9 78 FE FF FF 83 F8 6D 0F 85 68 FE FF FF 83 65 EC 00 E9 6A FE FF FF 33 C0 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_14_1_0 {
	meta:
		name = "__read"
		size = 220
		refs = "0003 __sehtable$__read 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 009b __read_nolock 00cd __SEH_epilog4 00d6 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 9D 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F 6B F6 28 8B 0B 0F B6 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 16 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_790_1_0 {
	meta:
		name = "__locking"
		size = 220
		refs = "0003 __sehtable$__locking 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 009b __locking_nolock 00cd __SEH_epilog4 00d6 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 9D 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F 6B F6 28 8B 0B 0F B6 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 16 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_759_1_0 {
	meta:
		name = "__lseek"
		size = 220
		refs = "0003 __sehtable$__lseek 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 009b __lseek_nolock 00cd __SEH_epilog4 00d6 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 9D 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F 6B F6 28 8B 0B 0F B6 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 16 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_868_1_0 {
	meta:
		name = "__write"
		size = 220
		refs = "0003 __sehtable$__write 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 009b __write_nolock 00cd __SEH_epilog4 00d6 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 9D 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F 6B F6 28 8B 0B 0F B6 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 16 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "__SEH_prolog4"
		size = 69
		refs = "0001 __except_handler4 001e ___security_cookie"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 A1 ?? ?? ?? ?? 31 45 FC 33 C5 50 89 65 E8 FF 75 F8 8B 45 FC C7 45 FC FE FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_15_1_0 {
	meta:
		name = "__SEH_epilog4"
		size = 20
	strings:
		$1 = { 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5F 5E 5B 8B E5 5D 51 C3 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "__getbuf"
		size = 68
		refs = "0002 __cflush 000c __malloc_crt"
	strings:
		$1 = { FF 05 ?? ?? ?? ?? 68 00 10 00 00 E8 ?? ?? ?? ?? 85 C0 59 8B 4C 24 04 89 41 08 74 0D 83 49 0C 08 C7 41 18 00 10 00 00 EB 11 83 49 0C 04 8D 41 14 89 41 08 C7 41 18 02 00 00 00 8B 41 08 83 61 04 00 89 01 C3 }
	condition:
		$1
}

rule file_17_0_0 {
	meta:
		name = "_wprintf"
		size = 175
		refs = "0003 __sehtable$_wprintf 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0038 ___iob_func 0045 __lock_file2 0057 __stbuf 006f __woutput_l 0080 __ftbuf 0097 __SEH_epilog4 00a8 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5F E8 ?? ?? ?? ?? 6A 20 5B 03 C3 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 75 FC E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 59 8B F8 8D 45 0C 50 56 FF 75 08 E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 89 45 E4 E8 ?? ?? ?? ?? 03 C3 50 57 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_887_0_0 {
	meta:
		name = "_printf"
		size = 175
		refs = "0003 __sehtable$_printf 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0038 ___iob_func 0045 __lock_file2 0057 __stbuf 006f __output_l 0080 __ftbuf 0097 __SEH_epilog4 00a8 __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5F E8 ?? ?? ?? ?? 6A 20 5B 03 C3 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 75 FC E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 59 8B F8 8D 45 0C 50 56 FF 75 08 E8 ?? ?? ?? ?? 03 C3 50 E8 ?? ?? ?? ?? 89 45 E4 E8 ?? ?? ?? ?? 03 C3 50 57 E8 ?? ?? ?? ?? 83 C4 18 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "__wprintf_l"
		size = 22
		refs = "000e __vwprintf_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_599_10_0 {
	meta:
		name = "__cprintf_l"
		size = 22
		refs = "000e __vcprintf_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_827_11_0 {
	meta:
		name = "__cprintf_p_l"
		size = 22
		refs = "000e __vcprintf_p_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_833_10_0 {
	meta:
		name = "__cprintf_s_l"
		size = 22
		refs = "000e __vcprintf_s_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_175_9_0 {
	meta:
		name = "__cwprintf_l"
		size = 22
		refs = "000e __vcwprintf_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_821_9_0 {
	meta:
		name = "__cwprintf_p_l"
		size = 22
		refs = "000e __vcwprintf_p_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_615_9_0 {
	meta:
		name = "__cwprintf_s_l"
		size = 22
		refs = "000e __vcwprintf_s_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_887_1_0 {
	meta:
		name = "__printf_l"
		size = 22
		refs = "000e __vprintf_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_887_4_0 {
	meta:
		name = "__printf_p_l"
		size = 22
		refs = "000e __vprintf_p_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_887_2_0 {
	meta:
		name = "__printf_s_l"
		size = 22
		refs = "000e __vprintf_s_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_249_10_0 {
	meta:
		name = "__scprintf_l"
		size = 22
		refs = "000e __vscprintf_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_249_11_0 {
	meta:
		name = "__scprintf_p_l"
		size = 22
		refs = "000e __vscprintf_p_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_244_10_0 {
	meta:
		name = "__scwprintf_l"
		size = 22
		refs = "000e __vscwprintf_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_244_11_0 {
	meta:
		name = "__scwprintf_p_l"
		size = 22
		refs = "000e __vscwprintf_p_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_17_4_0 {
	meta:
		name = "__wprintf_p_l"
		size = 22
		refs = "000e __vwprintf_p_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_17_2_0 {
	meta:
		name = "__wprintf_s_l"
		size = 22
		refs = "000e __vwprintf_s_l"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_17_3_0 {
	meta:
		name = "_wprintf_s"
		size = 20
		refs = "000c __vwprintf_s_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_599_11_0 {
	meta:
		name = "__cprintf"
		size = 20
		refs = "000c __vcprintf_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_827_12_0 {
	meta:
		name = "__cprintf_p"
		size = 20
		refs = "000c __vcprintf_p_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_833_11_0 {
	meta:
		name = "__cprintf_s"
		size = 20
		refs = "000c __vcprintf_s_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_175_10_0 {
	meta:
		name = "__cwprintf"
		size = 20
		refs = "000c __vcwprintf_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_821_10_0 {
	meta:
		name = "__cwprintf_p"
		size = 20
		refs = "000c __vcwprintf_p_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_615_10_0 {
	meta:
		name = "__cwprintf_s"
		size = 20
		refs = "000c __vcwprintf_s_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_887_5_0 {
	meta:
		name = "__printf_p"
		size = 20
		refs = "000c __vprintf_p_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_17_5_0 {
	meta:
		name = "__wprintf_p"
		size = 20
		refs = "000c __vwprintf_p_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_887_3_0 {
	meta:
		name = "_printf_s"
		size = 20
		refs = "000c __vprintf_s_l"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "_strncat"
		size = 309
	strings:
		$1 = { 8B 4C 24 0C 57 85 C9 0F 84 B7 00 00 00 8B 7C 24 08 56 F7 C7 03 00 00 00 53 74 11 8A 07 83 C7 01 84 C0 74 39 F7 C7 03 00 00 00 75 EF 8B 07 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C7 04 A9 00 01 01 81 74 E8 8B 47 FC 84 C0 74 21 84 E4 74 18 A9 00 00 FF 00 74 0C A9 00 00 00 FF 75 CF 83 EF 01 EB 0D 83 EF 02 EB 08 83 EF 03 EB 03 83 EF 04 8B 74 24 14 F7 C6 03 00 00 00 75 09 8B D9 C1 E9 02 75 5C EB 22 8A 16 83 C6 01 84 D2 74 3D 88 17 83 C7 01 83 E9 01 74 29 F7 C6 03 00 00 00 75 E5 8B D9 C1 E9 02 75 38 8B CB 83 E1 03 74 13 8A 16 83 C6 01 88 17 83 C7 01 84 D2 74 07 83 E9 01 75 ED 88 0F 5B 5E 8B 44 24 08 5F C3 88 17 8B 44 24 10 5B 5E 5F C3 89 17 83 C7 04 83 E9 01 74 C8 BA FF FE FE 7E 8B 06 03 D0 83 F0 FF 33 C2 8B 16 83 C6 04 A9 00 01 01 81 74 DC 84 D2 74 CE 84 F6 74 2A F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 75 C4 89 17 8B 44 24 10 5B 5E 5F C3 66 89 17 33 D2 8B 44 24 10 88 57 02 5B 5E 5F C3 66 89 17 8B 44 24 10 5B 5E 5F C3 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "_wcsncpy"
		size = 61
	strings:
		$1 = { 8B 4C 24 0C 85 C9 56 57 8B 7C 24 0C 8B F7 74 28 8B 54 24 10 0F B7 02 66 89 07 47 47 42 42 66 85 C0 74 03 49 75 EE 85 C9 74 0E 49 74 0B 33 C0 D1 E9 F3 AB 13 C9 66 F3 AB 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_22_0_0 {
	meta:
		name = "?set_terminate@@YAP6AXXZP6AXXZ@Z"
		size = 25
		refs = "0002 __getptd"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B 70 78 E8 ?? ?? ?? ?? 8B 4C 24 08 89 48 78 8B C6 5E C3 }
	condition:
		$1
}

rule file_22_2_0 {
	meta:
		name = "?set_unexpected@@YAP6AXXZP6AXXZ@Z"
		size = 25
		refs = "0002 __getptd"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B 70 7C E8 ?? ?? ?? ?? 8B 4C 24 08 89 48 7C 8B C6 5E C3 }
	condition:
		$1
}

rule file_22_4_0 {
	meta:
		name = "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"
		size = 31
		refs = "0002 __getptd"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B B0 80 00 00 00 E8 ?? ?? ?? ?? 8B 4C 24 08 89 88 80 00 00 00 8B C6 5E C3 }
	condition:
		$1
}

rule file_22_5_0 {
	meta:
		name = "?__set_inconsistency@@YAP6AXXZP6AXXZ@Z"
		size = 34
		refs = "0003 ?__pInconsistency@@3P6AXXZA 0008 __decode_pointer 0013 __encode_pointer"
	strings:
		$1 = { 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 74 24 0C 8B F0 E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_539_2_0 {
	meta:
		name = "__set_invalid_parameter_handler"
		size = 34
		refs = "0003 ___pInvalidArgHandler 0008 __decode_pointer 0013 __encode_pointer"
	strings:
		$1 = { 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 74 24 0C 8B F0 E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_179_1_0 {
	meta:
		name = "__set_purecall_handler"
		size = 34
		refs = "0003 ___pPurecall 0008 __decode_pointer 0013 __encode_pointer"
	strings:
		$1 = { 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 74 24 0C 8B F0 E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? 8B C6 5E C3 }
	condition:
		$1
}

rule file_22_6_0 {
	meta:
		name = "?set_terminate@@YAP6AXXZH@Z"
		size = 19
		refs = "000a ?set_terminate@@YAP6AXXZP6AXXZ@Z"
	strings:
		$1 = { 83 7C 24 04 00 75 09 6A 00 E8 ?? ?? ?? ?? 59 C3 33 C0 C3 }
	condition:
		$1
}

rule file_22_8_0 {
	meta:
		name = "?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZH@Z"
		size = 19
		refs = "000a ?_set_se_translator@@YAP6AXIPAU_EXCEPTION_POINTERS@@@ZP6AXI0@Z@Z"
	strings:
		$1 = { 83 7C 24 04 00 75 09 6A 00 E8 ?? ?? ?? ?? 59 C3 33 C0 C3 }
	condition:
		$1
}

rule file_22_7_0 {
	meta:
		name = "?set_unexpected@@YAP6AXXZH@Z"
		size = 19
		refs = "000a ?set_unexpected@@YAP6AXXZP6AXXZ@Z"
	strings:
		$1 = { 83 7C 24 04 00 75 09 6A 00 E8 ?? ?? ?? ?? 59 C3 33 C0 C3 }
	condition:
		$1
}

rule file_23_3_0 {
	meta:
		name = "__mbccpy_s_l"
		size = 278
		refs = "0020 __errno 002f __invalid_parameter 0067 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0074 __ismbblead_l"
	strings:
		$1 = { 55 8B EC 8B 45 10 83 EC 10 53 33 DB 3B C3 56 74 02 89 18 8B 75 08 3B F3 74 05 39 5D 0C 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 D5 00 00 00 57 8B 7D 14 3B FB 75 1B 88 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 EB 79 FF 75 18 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 74 38 5F 01 75 29 8B 45 10 3B C3 88 1E 74 06 C7 00 01 00 00 00 E8 ?? ?? ?? ?? 6A 2A 59 89 08 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C1 EB 65 6A 02 59 39 4D 0C 73 29 88 1E E8 ?? ?? ?? ?? 6A 22 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C6 EB 34 8A 07 88 06 8A 47 01 88 46 01 8B 45 10 3B C3 74 15 89 08 EB 11 8A 07 88 06 8B 45 10 3B C3 74 06 C7 00 01 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_24_0_0 {
	meta:
		name = "__fstat64"
		size = 877
		refs = "0003 __sehtable$__fstat64 0008 __SEH_prolog4 0020 ___doserrno 0027 __errno 0037 __invalid_parameter 004b _memset 0074 __nhandle 0096 ___pioinfo 00b3 ___lock_fhandle 00e7 __SEH_epilog4 00f0 __imp__GetFileType@4 0112 __imp__GetLastError@0 0118 __dosmaperr 0178 __imp__PeekNamedPipe@24 01be __imp__GetFileInformationByHandle@8 01fe __imp__FileTimeToLocalFileTime@8 0214 __imp__FileTimeToSystemTime@8 0241 ___loctotime64_t 033a __allmul 0367 __unlock_fhandle"
	strings:
		$1 = { 6A 5C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 0C 3B F7 0F 95 C0 3B C7 75 27 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A0 00 00 00 6A 38 57 56 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 F9 FE 75 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB D0 3B CF 7C 08 3B 0D ?? ?? ?? ?? 72 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB A3 8B C1 C1 F8 05 8D 04 85 ?? ?? ?? ?? 89 45 0C 8B D9 83 E3 1F 6B DB 28 8B 00 0F B6 44 18 04 83 E0 01 74 C9 51 E8 ?? ?? ?? ?? 59 89 7D FC 8B 45 0C 8B 00 03 C3 F6 40 04 01 75 24 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 80 02 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 30 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 98 00 00 00 83 F8 02 74 18 83 F8 03 74 13 3B C7 74 B8 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B4 33 D2 83 F8 02 0F 95 C2 4A B9 00 10 00 00 23 D1 03 D1 66 89 56 06 8B 4D 08 89 0E 89 4E 10 66 C7 46 08 01 00 66 89 7E 04 66 89 7E 0C 66 89 7E 0A 89 7E 30 89 7E 34 89 7E 28 89 7E 2C 89 7E 20 89 7E 24 83 F8 02 74 29 57 8D 45 0C 50 57 57 57 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 3B C7 74 0F 8B 45 0C 99 89 46 18 89 56 1C E9 48 FF FF FF 89 7E 18 89 7E 1C E9 3D FF FF FF 66 89 7E 06 66 89 7E 0C 66 89 7E 0A 66 89 7E 04 66 C7 46 08 01 00 8D 45 94 50 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 85 C0 0F 84 46 FF FF FF 66 8B 46 06 F6 45 94 01 74 06 66 0D 24 01 EB 04 66 0D B6 01 66 89 46 06 39 7D A8 75 0D 39 7D AC 75 08 89 7E 28 89 7E 2C EB 5A 8D 45 D8 50 8D 45 A8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 C9 FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 B3 FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 28 89 56 2C 39 7D A0 75 13 39 7D A4 75 0E 8B 46 28 89 46 20 8B 46 2C 89 46 24 EB 5A 8D 45 D8 50 8D 45 A0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 57 FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 41 FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 89 56 24 39 7D 98 75 13 39 7D 9C 75 0E 8B 46 28 89 46 30 8B 46 2C 89 46 34 EB 5A 8D 45 D8 50 8D 45 98 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 E5 FD FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 CF FD FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 30 89 56 34 6A 01 57 57 FF 75 B4 E8 ?? ?? ?? ?? 8B 4D B8 33 DB 03 C1 13 D3 89 46 18 89 56 1C 66 8B 46 06 66 0D 00 80 66 89 46 06 89 3E 89 7E 10 E9 74 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_wcscat"
		size = 42
	strings:
		$1 = { 8B 44 24 04 66 83 38 00 8B D0 74 08 42 42 66 83 3A 00 75 F8 56 8B 74 24 0C 0F B7 0E 66 89 0A 42 42 46 46 66 85 C9 75 F1 5E C3 }
	condition:
		$1
}

rule file_25_1_0 {
	meta:
		name = "_wcscpy"
		size = 28
	strings:
		$1 = { 8B 4C 24 04 8B 54 24 08 0F B7 02 66 89 01 41 41 42 42 66 85 C0 75 F1 8B 44 24 04 C3 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "___tlregdtor"
		size = 102
		refs = "0001 __tls_index 0008 __tls_array 0012 _dtor_list 001c _dtor_list_head 002d __malloc_crt"
	strings:
		$1 = { A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 56 8B 34 81 8B 86 ?? ?? ?? ?? 85 C0 75 08 8D 86 ?? ?? ?? ?? EB 25 83 38 1E 75 29 68 80 00 00 00 E8 ?? ?? ?? ?? 85 C0 59 75 05 83 C8 FF 5E C3 8B 8E ?? ?? ?? ?? 83 20 00 89 48 04 83 20 00 89 86 ?? ?? ?? ?? 8B B6 ?? ?? ?? ?? 8B 06 8B 4C 24 08 89 4C 86 08 FF 06 33 C0 5E C3 }
	condition:
		$1
}

rule file_26_1_0 {
	meta:
		name = "___dyn_tls_dtor@12"
		size = 96
		refs = "000f __tls_index 0016 __tls_array 0020 _dtor_list 004c _free"
	strings:
		$1 = { 83 7C 24 08 03 74 07 83 7C 24 08 00 75 4C A1 ?? ?? ?? ?? 64 8B 0D ?? ?? ?? ?? 8B 04 81 56 8B B0 ?? ?? ?? ?? 85 F6 74 31 53 57 8B 3E 4F 78 14 8D 5C BE 08 8B 03 85 C0 74 02 FF D0 4F 83 EB 04 85 FF 7D F0 8B 7E 04 85 FF 74 07 56 E8 ?? ?? ?? ?? 59 85 FF 8B F7 75 D3 5F 5B 5E 33 C0 40 C2 0C 00 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "__MarkAllocaS"
		size = 18
	strings:
		$1 = { 8B 44 24 04 85 C0 74 09 8B 4C 24 08 89 08 83 C0 08 C3 }
	condition:
		$1
}

rule file_28_1_0 {
	meta:
		name = "__freea"
		size = 27
		refs = "0015 _free"
	strings:
		$1 = { 8B 44 24 04 85 C0 74 12 83 E8 08 81 38 DD DD 00 00 75 07 50 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_28_5_0 {
	meta:
		name = "?strncnt@@YAHPBDH@Z"
		size = 26
	strings:
		$1 = { 8B 4C 24 04 EB 07 49 80 38 00 74 06 40 85 C9 75 F5 49 8B 44 24 04 2B C1 48 C3 }
	condition:
		$1
}

rule file_28_6_0 {
	meta:
		name = "?__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDH1HH@Z"
		size = 905
		refs = "0007 ___security_cookie 001a ?f_use@?1??__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDH1HH@Z@4HA 002d ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0039 __imp__CompareStringW@24 004f __imp__GetLastError@0 011c __imp__GetCPInfo@8 0191 __imp__MultiByteToWideChar@24 01cd __alloca_probe_16 01e1 _malloc 02ac __freea 02e4 ___ansicp 0309 ___convertcp 0339 _free 035d __imp__CompareStringA@24 0383 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 2C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 14 53 56 57 33 FF 39 3D ?? ?? ?? ?? 8B DA 8B F1 89 5D DC 89 45 E4 75 38 6A 01 B8 ?? ?? ?? ?? 50 6A 01 50 57 57 FF 15 ?? ?? ?? ?? 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 39 7D 10 7E 41 8B 4D 10 8B C3 49 80 38 00 74 08 40 3B CF 75 F5 83 C9 FF 83 C8 FF 2B C1 01 45 10 8B 55 18 3B D7 7E 2C 8B 45 E4 8B CA 49 80 38 00 74 08 40 3B CF 75 F5 83 C9 FF 83 C8 FF 2B C1 03 D0 89 55 18 EB 12 83 7D 10 FF 7D D4 33 C0 E9 C2 02 00 00 83 FA FF 7C F4 8B 0D ?? ?? ?? ?? 83 F9 02 0F 84 F9 01 00 00 3B CF 0F 84 F1 01 00 00 33 C0 40 3B C8 75 D6 39 7D 1C 89 7D D8 75 08 8B 0E 8B 49 04 89 4D 1C 39 7D 10 74 08 3B D7 0F 85 9A 00 00 00 39 55 10 75 08 6A 02 58 E9 75 02 00 00 3B D0 0F 8F 6D 02 00 00 39 45 10 7E 04 6A 03 EB E9 8D 45 E8 50 FF 75 1C FF 15 ?? ?? ?? ?? 85 C0 74 8A 39 7D 10 7E 29 83 7D E8 02 72 E0 80 7D EE 00 8D 45 EE 74 D7 8A 50 01 84 D2 74 D0 8A 0B 3A 08 72 04 3A CA 76 B1 40 40 80 38 00 75 E8 EB BD 39 7D 18 7E 38 83 7D E8 02 73 08 33 C0 40 E9 12 02 00 00 80 7D EE 00 8D 45 EE 74 EF 8A 50 01 84 D2 74 E8 8B 4D E4 8A 09 3A 08 72 08 3A CA 0F 86 74 FF FF FF 40 40 80 38 00 75 E1 EB CE 8B 35 ?? ?? ?? ?? 57 57 FF 75 10 53 6A 09 FF 75 1C FF D6 8B D8 3B DF 89 5D D4 0F 84 FF FE FF FF 85 DB BF 00 04 00 00 7E 40 6A E0 33 D2 58 F7 F3 83 F8 02 72 34 8D 44 1B 08 3B C7 77 13 E8 ?? ?? ?? ?? 8B C4 85 C0 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 85 C0 59 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 E0 EB 04 83 65 E0 00 83 7D E0 00 0F 84 A8 FE FF FF 53 FF 75 E0 FF 75 10 FF 75 DC 6A 01 FF 75 1C FF D6 85 C0 0F 84 92 00 00 00 6A 00 6A 00 FF 75 18 FF 75 E4 6A 09 FF 75 1C FF D6 8B D8 85 DB 74 7B 7E 42 6A E0 33 D2 58 F7 F3 83 F8 02 72 36 8D 44 1B 08 3B C7 77 16 E8 ?? ?? ?? ?? 8B FC 85 FF 74 5A C7 07 CC CC 00 00 83 C7 08 EB 1A 50 E8 ?? ?? ?? ?? 85 C0 59 74 09 C7 00 DD DD 00 00 83 C0 08 8B F8 EB 02 33 FF 85 FF 74 31 53 57 FF 75 18 FF 75 E4 6A 01 FF 75 1C FF D6 85 C0 74 17 53 57 FF 75 D4 FF 75 E0 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 89 45 D8 57 E8 ?? ?? ?? ?? 59 FF 75 E0 E8 ?? ?? ?? ?? 8B 45 D8 59 E9 B5 00 00 00 33 FF 33 DB 39 7D 08 75 08 8B 06 8B 40 14 89 45 08 39 7D 1C 75 08 8B 06 8B 40 04 89 45 1C FF 75 08 E8 ?? ?? ?? ?? 8B F0 83 FE FF 59 0F 84 BA FD FF FF 3B 75 1C 74 50 6A 00 6A 00 8D 45 10 50 FF 75 DC 56 FF 75 1C E8 ?? ?? ?? ?? 8B D8 83 C4 18 85 DB 0F 84 94 FD FF FF 6A 00 6A 00 8D 45 18 50 FF 75 E4 56 FF 75 1C E8 ?? ?? ?? ?? 8B F8 83 C4 18 85 FF 75 0C 53 E8 ?? ?? ?? ?? 59 E9 6B FD FF FF 89 5D DC 89 7D E4 FF 75 18 FF 75 E4 FF 75 10 FF 75 DC FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 DB 8B F0 74 0E 53 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 8B C6 8D 65 C8 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_28_7_0 {
	meta:
		name = "___crtCompareStringA"
		size = 64
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ?__crtCompareStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDH1HH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 24 8B 55 14 FF 75 20 8D 4D F0 FF 75 1C FF 75 18 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 18 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_29_0_0 {
	meta:
		name = "__ftol"
		size = 39
	strings:
		$1 = { 55 8B EC 83 C4 F4 9B D9 7D FE 9B 66 8B 45 FE 80 CC 0C 66 89 45 FC D9 6D FC DF 7D F4 D9 6D FE 8B 45 F4 8B 55 F8 C9 C3 }
	condition:
		$1
}

rule file_30_3_0 {
	meta:
		name = "__atodbl_l"
		size = 166
		refs = "0007 ___security_cookie 0020 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0038 ___strgtold12_l 0045 __ld12tod 00a0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 57 FF 75 10 8B 7D 0C 8D 4D DC E8 ?? ?? ?? ?? 8D 45 DC 50 33 DB 53 53 53 53 57 8D 45 D8 50 8D 45 F0 50 E8 ?? ?? ?? ?? 89 45 EC 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 F6 45 EC 03 75 2B 83 F8 01 75 11 38 5D E8 74 07 8B 45 E4 83 60 70 FD 6A 03 58 EB 2F 83 F8 02 75 1C 38 5D E8 74 07 8B 45 E4 83 60 70 FD 6A 04 EB E8 F6 45 EC 01 75 EA F6 45 EC 02 75 CE 38 5D E8 74 07 8B 45 E4 83 60 70 FD 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_30_7_0 {
	meta:
		name = "__atoflt_l"
		size = 166
		refs = "0007 ___security_cookie 0020 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0038 ___strgtold12_l 0045 __ld12tof 00a0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 57 FF 75 10 8B 7D 0C 8D 4D DC E8 ?? ?? ?? ?? 8D 45 DC 50 33 DB 53 53 53 53 57 8D 45 D8 50 8D 45 F0 50 E8 ?? ?? ?? ?? 89 45 EC 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 F6 45 EC 03 75 2B 83 F8 01 75 11 38 5D E8 74 07 8B 45 E4 83 60 70 FD 6A 03 58 EB 2F 83 F8 02 75 1C 38 5D E8 74 07 8B 45 E4 83 60 70 FD 6A 04 EB E8 F6 45 EC 01 75 EA F6 45 EC 02 75 CE 38 5D E8 74 07 8B 45 E4 83 60 70 FD 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_30_5_0 {
	meta:
		name = "__atoldbl_l"
		size = 167
		refs = "0007 ___security_cookie 0020 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0039 ___strgtold12_l 0046 __ld12told 00a1 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 8B 75 08 57 FF 75 10 8B 7D 0C 8D 4D DC E8 ?? ?? ?? ?? 8D 45 DC 50 33 DB 53 53 53 6A 01 57 8D 45 D8 50 8D 45 F0 50 E8 ?? ?? ?? ?? 89 45 EC 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 F6 45 EC 03 75 2B 83 F8 01 75 11 38 5D E8 74 07 8B 45 E4 83 60 70 FD 6A 03 58 EB 2F 83 F8 02 75 1C 38 5D E8 74 07 8B 45 E4 83 60 70 FD 6A 04 EB E8 F6 45 EC 01 75 EA F6 45 EC 02 75 CE 38 5D E8 74 07 8B 45 E4 83 60 70 FD 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_31_0_0 {
	meta:
		name = "__close_nolock"
		size = 148
		refs = "0008 __get_osfhandle 0016 ___pioinfo 004d __imp__CloseHandle@4 0057 __imp__GetLastError@0 0063 __free_osfhnd 0085 __dosmaperr"
	strings:
		$1 = { 56 8B 74 24 08 57 56 E8 ?? ?? ?? ?? 83 F8 FF 59 74 4D 83 FE 01 A1 ?? ?? ?? ?? 75 06 F6 40 54 01 75 0B 83 FE 02 75 1C F6 40 2C 01 74 16 6A 02 E8 ?? ?? ?? ?? 6A 01 8B F8 E8 ?? ?? ?? ?? 3B C7 59 59 74 1C 56 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 75 0A FF 15 ?? ?? ?? ?? 8B F8 EB 02 33 FF 56 E8 ?? ?? ?? ?? 8B C6 83 E6 1F 6B F6 28 C1 F8 05 85 FF 8B 04 85 ?? ?? ?? ?? 59 C6 44 30 04 00 74 0C 57 E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_31_1_0 {
	meta:
		name = "__close"
		size = 205
		refs = "0003 __sehtable$__close 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 0095 __close_nolock 00be __SEH_epilog4 00c7 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 8E 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F 6B F6 28 8B 0B 0F B6 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 0E FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 EB 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "___addl"
		size = 33
	strings:
		$1 = { 8B 54 24 04 56 8B 74 24 0C 8D 0C 32 33 C0 3B CA 72 04 3B CE 73 03 33 C0 40 8B 54 24 10 89 0A 5E C3 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "___add_12"
		size = 109
	strings:
		$1 = { 8B 44 24 04 8B 08 53 56 57 8B 7C 24 14 8B 17 8D 34 11 33 DB 3B F1 72 04 3B F2 73 03 33 DB 43 85 DB 89 30 74 1E 8B 48 04 8D 51 01 33 F6 3B D1 72 05 83 FA 01 73 03 33 F6 46 85 F6 89 50 04 74 03 FF 40 08 8B 48 04 8B 57 04 8D 34 11 33 DB 3B F1 72 04 3B F2 73 03 33 DB 43 85 DB 89 70 04 74 03 FF 40 08 8B 4F 08 01 48 08 5F 5E 5B C3 }
	condition:
		$1
}

rule file_32_2_0 {
	meta:
		name = "___shl_12"
		size = 46
	strings:
		$1 = { 8B 44 24 04 56 8B 30 8B CE 03 F6 57 8B 78 04 C1 E9 1F 89 30 8D 34 3F 0B F1 8B 48 08 8B D7 C1 EA 1F 03 C9 0B CA 5F 89 70 04 89 48 08 5E C3 }
	condition:
		$1
}

rule file_32_3_0 {
	meta:
		name = "___mtold12"
		size = 460
		refs = "0007 ___security_cookie 01c6 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 53 56 33 F6 39 75 0C 57 C7 45 E8 4E 40 00 00 89 30 89 70 04 89 70 08 0F 86 46 01 00 00 8B 10 8B 58 04 8B F0 8D 7D F0 A5 A5 A5 8B CA C1 E9 1F 8D 3C 12 8D 14 1B 0B D1 8B 48 08 8B F3 C1 EE 1F 03 C9 0B CE 89 7D EC 8B F7 83 65 EC 00 8B DA C1 EB 1F 03 C9 C1 EF 1F 0B CB 8B 5D F0 03 F6 03 D2 0B D7 8D 3C 1E 3B FE 89 30 89 50 04 89 48 08 72 04 3B FB 73 07 C7 45 EC 01 00 00 00 33 DB 39 5D EC 89 38 74 1A 8D 72 01 3B F2 72 05 83 FE 01 73 03 33 DB 43 85 DB 89 70 04 74 04 41 89 48 08 8B 48 04 8B 55 F4 8D 1C 11 33 F6 3B D9 72 04 3B DA 73 03 33 F6 46 85 F6 89 58 04 74 03 FF 40 08 8B 4D F8 01 48 08 83 65 EC 00 8D 0C 3F 8B D7 C1 EA 1F 8D 3C 1B 0B FA 8B 50 08 8B F3 C1 EE 1F 8D 1C 12 8B 55 08 0B DE 89 08 89 78 04 89 58 08 0F BE 12 8D 34 11 3B F1 89 55 F0 72 04 3B F2 73 07 C7 45 EC 01 00 00 00 83 7D EC 00 89 30 74 1C 8D 4F 01 33 D2 3B CF 72 05 83 F9 01 73 03 33 D2 42 85 D2 89 48 04 74 04 43 89 58 08 FF 4D 0C FF 45 08 83 7D 0C 00 0F 87 E4 FE FF FF 33 F6 EB 26 8B 48 04 8B D1 C1 EA 10 89 50 08 8B 10 8B FA C1 E1 10 C1 EF 10 0B CF C1 E2 10 81 45 E8 F0 FF 00 00 89 48 04 89 10 39 70 08 74 D5 BB 00 80 00 00 85 58 08 75 30 8B 30 8B 78 04 81 45 E8 FF FF 00 00 8B CE 03 F6 C1 E9 1F 89 30 8D 34 3F 0B F1 8B 48 08 8B D7 C1 EA 1F 03 C9 0B CA 85 CB 89 70 04 89 48 08 74 D0 66 8B 4D E8 66 89 48 0A 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_33_1_0 {
	meta:
		name = "__invoke_watson_if_oneof"
		size = 49
		refs = "0025 __invoke_watson"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 85 F6 74 21 3B 75 0C 74 05 3B 75 10 75 17 FF 75 24 FF 75 20 FF 75 1C FF 75 18 FF 75 14 E8 ?? ?? ?? ?? 83 C4 14 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_33_2_0 {
	meta:
		name = "__spawnvpe"
		size = 630
		refs = "0017 __errno 0027 __invalid_parameter 0088 __spawnve 00af __mbschr 00be ??_C@_04HBHDLLBA@PATH?$AA@ 00c8 __dupenv_s 00e2 __invoke_watson 00ff __calloc_crt 0127 _strlen 013a __mbsrchr 0145 ??_C@_01KICIPPFI@?2?$AA@ 0150 _strcat_s 0230 __getpath 025b _free"
	strings:
		$1 = { 55 8B EC 83 EC 10 8B 45 0C 53 33 DB 56 33 F6 3B C3 89 5D FC 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3C 02 00 00 38 18 74 DC 57 8B 7D 10 3B FB 74 0A 8B 07 3B C3 74 04 38 18 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 05 02 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 F0 E8 ?? ?? ?? ?? FF 75 14 89 18 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 89 45 F4 0F 85 A7 01 00 00 E8 ?? ?? ?? ?? 83 38 02 0F 85 99 01 00 00 6A 2F FF 75 0C E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 85 01 00 00 68 ?? ?? ?? ?? 8D 45 FC 53 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 1B 83 F8 16 0F 85 66 01 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E9 54 01 00 00 39 5D FC 0F 84 4B 01 00 00 6A 01 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 3B F3 59 59 0F 84 33 01 00 00 68 03 01 00 00 56 FF 75 FC E9 12 01 00 00 38 1E 0F 84 1D 01 00 00 56 E8 ?? ?? ?? ?? 8D 7C 30 FF 8A 07 3C 5C 59 75 23 6A 5C 56 E8 ?? ?? ?? ?? 3B F8 59 59 74 3D 68 ?? ?? ?? ?? 68 04 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 0C EB 28 3C 2F 74 24 68 ?? ?? ?? ?? 68 04 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? FF 75 0C 8B F8 E8 ?? ?? ?? ?? 03 F8 B8 04 01 00 00 3B F8 59 59 0F 83 A0 00 00 00 FF 75 0C 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? FF 75 14 89 18 FF 75 10 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 89 45 F4 75 61 E8 ?? ?? ?? ?? 83 38 02 74 3B 6A 5C 56 E8 ?? ?? ?? ?? 3B F0 59 59 74 0E 6A 2F 56 E8 ?? ?? ?? ?? 3B F0 59 59 75 3B 8D 7E 01 6A 5C 57 E8 ?? ?? ?? ?? 3B F8 59 59 74 0E 6A 2F 57 E8 ?? ?? ?? ?? 3B F8 59 59 75 1C 68 03 01 00 00 56 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 89 45 F8 0F 85 DB FE FF FF E8 ?? ?? ?? ?? 39 18 75 0A E8 ?? ?? ?? ?? 8B 4D F0 89 08 3B F3 74 07 56 E8 ?? ?? ?? ?? 59 39 5D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_34_1_0 {
	meta:
		name = "_parse_cmdline"
		size = 398
		refs = "0061 __ismbblead"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B D8 33 C0 39 45 08 8B F1 8B 4D 0C 89 07 C7 01 01 00 00 00 74 09 8B 55 08 83 45 08 04 89 1A 3B D8 74 05 8A 16 88 13 43 FF 07 89 45 F8 80 3E 22 75 12 33 C0 39 45 F8 C6 45 FF 22 0F 94 C0 46 89 45 F8 EB 34 FF 07 85 DB 74 05 8A 06 88 03 43 8A 06 88 45 FF 0F B6 C0 50 46 E8 ?? ?? ?? ?? 85 C0 59 74 0C FF 07 85 DB 74 05 8A 06 88 03 43 46 80 7D FF 00 8B 4D 0C 74 34 83 7D F8 00 75 AF 80 7D FF 20 74 06 80 7D FF 09 75 A3 85 DB 74 04 C6 43 FF 00 83 65 F8 00 80 3E 00 0F 84 D8 00 00 00 8A 06 3C 20 74 04 3C 09 75 06 46 EB F3 4E EB E3 80 3E 00 0F 84 BF 00 00 00 83 7D 08 00 74 09 8B 45 08 83 45 08 04 89 18 FF 01 85 DB 74 05 8A 06 88 03 43 FF 07 33 D2 42 33 C9 EB 02 46 41 80 3E 5C 74 F9 80 3E 22 75 33 F6 C1 01 75 1F 83 7D F8 00 74 0C 8D 46 01 80 38 22 75 04 8B F0 EB 0D 33 C0 33 D2 39 45 F8 0F 94 C0 89 45 F8 D1 E9 EB 0B 49 85 DB 74 04 C6 03 5C 43 FF 07 85 C9 75 F1 8A 06 84 C0 74 41 39 4D F8 75 08 3C 20 74 38 3C 09 74 34 85 D2 74 2A 0F BE C0 50 E8 ?? ?? ?? ?? 85 DB 59 74 13 85 C0 74 08 8A 06 88 03 43 46 FF 07 8A 06 88 03 43 EB 07 85 C0 74 03 46 FF 07 FF 07 46 E9 6F FF FF FF 85 DB 74 04 C6 03 00 43 FF 07 8B 4D 0C E9 1F FF FF FF 8B 45 08 85 C0 5E 5B 74 03 83 20 00 FF 01 C9 C3 }
	condition:
		$1
}

rule file_34_2_0 {
	meta:
		name = "___setargv"
		size = 188
		refs = "000c ___mbctype_initialized 0013 ___initmbctable 001d ?_pgmname@?1??__setargv@@9@9 002c __imp__GetModuleFileNameA@12 0031 __acmdln 0039 __pgmptr 0055 _parse_cmdline 007b __malloc_crt 009f ___argc 00a5 ___argv 00aa __cwild"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 33 FF 39 3D ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 68 04 01 00 00 BE ?? ?? ?? ?? 56 57 C6 05 ?? ?? ?? ?? 00 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B C7 89 35 ?? ?? ?? ?? 74 07 80 38 00 8B D8 75 02 8B DE 8D 45 FC 50 57 8D 7D F8 33 C0 8B CB E8 ?? ?? ?? ?? 8B 45 FC 3D FF FF FF 3F 59 59 73 4F 8B 4D F8 83 F9 FF 73 47 8B F8 C1 E7 02 8D 04 0F 3B C1 72 3B 50 E8 ?? ?? ?? ?? 8B F0 85 F6 59 74 2E 8D 45 FC 50 8D 04 37 56 8D 7D F8 8B CB E8 ?? ?? ?? ?? 8B 45 FC 59 48 59 A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? F7 D8 1B C0 EB 03 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "__wexeclpe"
		size = 89
		refs = "000c __errno 001c __invalid_parameter 0050 __wexecvpe"
	strings:
		$1 = { 8B 4C 24 04 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E C3 66 39 31 74 DE 8B 44 24 0C 3B C6 74 D6 66 39 30 74 D1 8D 44 24 0C 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 44 24 10 50 51 E8 ?? ?? ?? ?? 83 C4 0C 5E C3 }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "__rt_probe_read4@4"
		size = 75
		refs = "0003 __sehtable$__rt_probe_read4@4 0008 __SEH_prolog4 0044 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 8B 45 08 8B 00 C7 45 E4 01 00 00 00 EB 1B 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 83 65 E4 00 C7 45 FC FE FF FF FF 8B 45 E4 E8 ?? ?? ?? ?? C2 04 00 }
	condition:
		$1
}

rule file_39_3_0 {
	meta:
		name = "__isleadbyte_l"
		size = 54
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 0F B6 45 08 8B 4D F0 8B 89 C8 00 00 00 0F B7 04 41 25 00 80 00 00 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_39_5_0 {
	meta:
		name = "__iswalpha_l"
		size = 22
		refs = "000e __iswctype_l"
	strings:
		$1 = { FF 74 24 08 68 03 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_6_0 {
	meta:
		name = "_iswalpha"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 03 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_39_7_0 {
	meta:
		name = "__iswupper_l"
		size = 19
		refs = "000b __iswctype_l"
	strings:
		$1 = { FF 74 24 08 6A 01 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_9_0 {
	meta:
		name = "__iswlower_l"
		size = 19
		refs = "000b __iswctype_l"
	strings:
		$1 = { FF 74 24 08 6A 02 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_11_0 {
	meta:
		name = "__iswdigit_l"
		size = 19
		refs = "000b __iswctype_l"
	strings:
		$1 = { FF 74 24 08 6A 04 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_13_0 {
	meta:
		name = "__iswxdigit_l"
		size = 22
		refs = "000e __iswctype_l"
	strings:
		$1 = { FF 74 24 08 68 80 00 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_14_0 {
	meta:
		name = "_iswxdigit"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 80 00 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_39_15_0 {
	meta:
		name = "__iswspace_l"
		size = 19
		refs = "000b __iswctype_l"
	strings:
		$1 = { FF 74 24 08 6A 08 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_17_0 {
	meta:
		name = "__iswpunct_l"
		size = 19
		refs = "000b __iswctype_l"
	strings:
		$1 = { FF 74 24 08 6A 10 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_19_0 {
	meta:
		name = "__iswalnum_l"
		size = 22
		refs = "000e __iswctype_l"
	strings:
		$1 = { FF 74 24 08 68 07 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_20_0 {
	meta:
		name = "_iswalnum"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 07 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_39_21_0 {
	meta:
		name = "__iswprint_l"
		size = 22
		refs = "000e __iswctype_l"
	strings:
		$1 = { FF 74 24 08 68 57 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_22_0 {
	meta:
		name = "_iswprint"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 57 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_39_23_0 {
	meta:
		name = "__iswgraph_l"
		size = 22
		refs = "000e __iswctype_l"
	strings:
		$1 = { FF 74 24 08 68 17 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_24_0 {
	meta:
		name = "_iswgraph"
		size = 17
		refs = "000a _iswctype"
	strings:
		$1 = { 68 17 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_39_25_0 {
	meta:
		name = "__iswcntrl_l"
		size = 19
		refs = "000b __iswctype_l"
	strings:
		$1 = { FF 74 24 08 6A 20 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_39_28_0 {
	meta:
		name = "__iswcsym_l"
		size = 38
		refs = "000e __iswctype_l"
	strings:
		$1 = { FF 74 24 08 68 07 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 09 66 83 7C 24 04 5F 74 01 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_39_29_0 {
	meta:
		name = "___iswcsym"
		size = 33
		refs = "000a _iswctype"
	strings:
		$1 = { 68 07 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 85 C0 59 59 75 09 66 83 7C 24 04 5F 74 01 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_39_30_0 {
	meta:
		name = "__iswcsymf_l"
		size = 38
		refs = "000e __iswctype_l"
	strings:
		$1 = { FF 74 24 08 68 03 01 00 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 09 66 83 7C 24 04 5F 74 01 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_39_31_0 {
	meta:
		name = "___iswcsymf"
		size = 33
		refs = "000a _iswctype"
	strings:
		$1 = { 68 03 01 00 00 FF 74 24 08 E8 ?? ?? ?? ?? 85 C0 59 59 75 09 66 83 7C 24 04 5F 74 01 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "_IsRootUNCName"
		size = 120
		refs = "0002 _strlen"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 83 F8 05 59 72 69 8A 06 3C 5C 74 04 3C 2F 75 5F 8A 46 01 3C 5C 74 04 3C 2F 75 54 8A 46 02 3C 5C 74 4D 3C 2F 74 49 8D 46 03 8A 08 32 D2 3A CA 74 3E 80 F9 5C 74 0C 80 F9 2F 74 07 40 8A 08 3A CA 75 EF 38 10 74 29 40 38 10 74 24 8A 08 3A CA 74 1A 80 F9 5C 74 0C 80 F9 2F 74 07 40 8A 08 3A CA 75 EF 38 10 74 05 38 50 01 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "__fullpath_helper"
		size = 60
		refs = "000d __fullpath 0019 __errno"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 22 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 5D C3 6A 00 FF 75 0C 6A 00 E8 ?? ?? ?? ?? 8B 4D 14 83 C4 0C 89 01 5D C3 }
	condition:
		$1
}

rule file_280_1_0 {
	meta:
		name = "__wfullpath_helper"
		size = 60
		refs = "000d __wfullpath 0019 __errno"
	strings:
		$1 = { 55 8B EC FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 22 E8 ?? ?? ?? ?? 83 38 22 74 04 33 C0 5D C3 6A 00 FF 75 0C 6A 00 E8 ?? ?? ?? ?? 8B 4D 14 83 C4 0C 89 01 5D C3 }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "__stat64"
		size = 875
		refs = "000f ___security_cookie 0034 ___doserrno 003b __errno 004b __invalid_parameter 005c ??_C@_02EAOCEIGI@?$DP?$CK?$AA@ 0062 __mbspbrk 0098 __mbctolower 00a3 __getdrive 00b1 __imp__FindFirstFileA@8 00c2 ??_C@_03LLEJOLGL@?4?1?2?$AA@ 00e3 __fullpath 0112 _strlen 011d _IsRootUNCName 0128 __imp__GetDriveTypeA@4 013a _free 015e ___loctotime64_t 01b4 __imp__FileTimeToLocalFileTime@8 01ca __imp__FileTimeToSystemTime@8 02ed __imp__FindClose@4 02f6 ___dtoxmode 030e __allmul 033c __imp__GetLastError@0 0342 __dosmaperr 035f @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 18 FE FF FF 81 EC 68 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 E4 01 00 00 53 56 8B B5 F0 01 00 00 33 DB 3B F3 57 8B BD F4 01 00 00 89 75 88 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 F9 02 00 00 3B FB 74 D8 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 CE 02 00 00 80 7E 01 3A 75 1A 8A 06 3A C3 74 05 38 5E 02 74 D9 0F BE C0 50 E8 ?? ?? ?? ?? 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 45 80 8D 45 A0 50 56 FF 15 ?? ?? ?? ?? 83 F8 FF 89 45 9C 0F 85 D7 00 00 00 68 ?? ?? ?? ?? 56 89 5D 9C E8 ?? ?? ?? ?? 85 C0 59 59 74 97 68 04 01 00 00 8D 85 E0 00 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 75 1C E8 ?? ?? ?? ?? 83 38 22 0F 85 70 FF FF FF 53 56 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 9C 8B F0 3B F3 74 71 56 E8 ?? ?? ?? ?? 83 F8 03 59 74 09 E8 ?? ?? ?? ?? 85 C0 74 5C 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 50 39 5D 9C 74 09 FF 75 9C E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 6A 01 68 BC 07 00 00 C7 45 A0 10 00 00 00 89 5D BC 89 5D C0 88 5D CC E8 ?? ?? ?? ?? 8B 75 88 8B CA 83 C4 1C 89 47 28 89 57 2C 89 47 20 89 4F 24 89 47 30 89 4F 34 E9 70 01 00 00 39 5D 9C 0F 84 E2 FE FF FF FF 75 9C E8 ?? ?? ?? ?? 59 E9 D4 FE FF FF 39 5D B4 75 0D 39 5D B8 75 08 89 5F 28 89 5F 2C EB 5A 8D 45 84 50 8D 45 B4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 7A 01 00 00 8D 45 8C 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 64 01 00 00 0F B7 45 98 6A FF 50 0F B7 45 96 50 0F B7 45 94 50 0F B7 45 92 50 0F B7 45 8E 50 0F B7 45 8C 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 28 89 57 2C 39 5D AC 75 13 39 5D B0 75 0E 8B 47 28 89 47 20 8B 47 2C 89 47 24 EB 5A 8D 45 84 50 8D 45 AC 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 08 01 00 00 8D 45 8C 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 F2 00 00 00 0F B7 45 98 6A FF 50 0F B7 45 96 50 0F B7 45 94 50 0F B7 45 92 50 0F B7 45 8E 50 0F B7 45 8C 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 89 57 24 39 5D A4 75 13 39 5D A8 75 0E 8B 47 28 89 47 30 8B 47 2C 89 47 34 EB 5A 8D 45 84 50 8D 45 A4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 96 00 00 00 8D 45 8C 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 80 00 00 00 0F B7 45 98 6A FF 50 0F B7 45 96 50 0F B7 45 94 50 0F B7 45 92 50 0F B7 45 8E 50 0F B7 45 8C 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 30 89 57 34 FF 75 9C FF 15 ?? ?? ?? ?? 56 FF 75 A0 E8 ?? ?? ?? ?? 59 59 6A 01 53 53 FF 75 BC 66 89 47 06 66 C7 47 08 01 00 E8 ?? ?? ?? ?? 8B 4D C0 33 F6 03 C1 89 47 18 8B 45 80 13 D6 48 89 07 89 47 10 89 57 1C 66 89 5F 04 66 89 5F 0C 66 89 5F 0A 33 C0 EB 19 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF 75 9C FF 15 ?? ?? ?? ?? 83 C8 FF 8B 8D E4 01 00 00 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 81 C5 E8 01 00 00 C9 C3 }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "__EH_prolog"
		size = 31
	strings:
		$1 = { 6A FF 50 64 A1 00 00 00 00 50 8B 44 24 0C 64 89 25 00 00 00 00 89 6C 24 0C 8D 6C 24 0C 50 C3 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__vswprintf_helper"
		size = 246
		refs = "000f __errno 001f __invalid_parameter 00b5 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 33 DB 39 5D 14 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 C5 00 00 00 56 8B 75 0C 57 8B 7D 10 3B FB 74 24 3B F3 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 93 00 00 00 81 FF FF FF FF 3F C7 45 EC 42 00 00 00 89 75 E8 89 75 E0 76 09 C7 45 E4 FF FF FF 7F EB 06 8D 04 3F 89 45 E4 FF 75 1C 8D 45 E0 FF 75 18 FF 75 14 50 FF 55 08 83 C4 10 3B F3 89 45 14 74 55 3B C3 7C 42 FF 4D E4 78 0A 8B 45 E0 88 18 FF 45 E0 EB 11 8D 45 E0 50 53 E8 ?? ?? ?? ?? 83 F8 FF 59 59 74 22 FF 4D E4 78 07 8B 45 E0 88 18 EB 11 8D 45 E0 50 53 E8 ?? ?? ?? ?? 83 F8 FF 59 59 74 05 8B 45 14 EB 0F 33 C0 39 5D E4 66 89 5C 7E FE 0F 9D C0 48 48 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_42_1_0 {
	meta:
		name = "__vswprintf_c"
		size = 39
		refs = "0013 __woutput_l 0018 __vswprintf_helper"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF C3 }
	condition:
		$1
}

rule file_236_1_0 {
	meta:
		name = "__vsnprintf_c"
		size = 39
		refs = "0013 __output_l 0018 __vsnprintf_helper"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF C3 }
	condition:
		$1
}

rule file_236_7_0 {
	meta:
		name = "__vsprintf_p"
		size = 39
		refs = "0013 __output_p_l 0018 __vsnprintf_helper"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF C3 }
	condition:
		$1
}

rule file_42_7_0 {
	meta:
		name = "__vswprintf_p"
		size = 39
		refs = "0013 __woutput_p_l 0018 __vswprintf_helper"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF C3 }
	condition:
		$1
}

rule file_42_2_0 {
	meta:
		name = "__vswprintf_c_l"
		size = 40
		refs = "0013 __woutput_l 0018 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_236_2_0 {
	meta:
		name = "__vsnprintf_c_l"
		size = 40
		refs = "0013 __output_l 0018 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_236_8_0 {
	meta:
		name = "__vsprintf_p_l"
		size = 40
		refs = "0013 __output_p_l 0018 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_42_8_0 {
	meta:
		name = "__vswprintf_p_l"
		size = 40
		refs = "0013 __woutput_p_l 0018 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 85 C0 7D 03 83 C8 FF 5D C3 }
	condition:
		$1
}

rule file_42_3_0 {
	meta:
		name = "__vswprintf_s_l"
		size = 135
		refs = "000c __errno 001c __invalid_parameter 0050 __woutput_s_l 0055 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 10 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5C 57 8B 7D 08 3B FE 74 05 39 75 0C 77 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 31 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 3B C6 7D 03 66 89 37 83 F8 FE 75 1B E8 ?? ?? ?? ?? C7 00 22 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5F 5E 5D C3 }
	condition:
		$1
}

rule file_42_4_0 {
	meta:
		name = "_vswprintf_s"
		size = 27
		refs = "0013 __vswprintf_s_l"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_618_3_0 {
	meta:
		name = "?vswprintf@@YAHPAGIPBGPAD@Z"
		size = 27
		refs = "0013 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_618_1_0 {
	meta:
		name = "?vswprintf@@YAHPA_WIPB_WPAD@Z"
		size = 27
		refs = "0013 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_787_1_0 {
	meta:
		name = "__vsnprintf"
		size = 27
		refs = "0013 __vsnprintf_l"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_195_1_0 {
	meta:
		name = "__vsnwprintf"
		size = 27
		refs = "0013 __vsnwprintf_l"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_236_4_0 {
	meta:
		name = "_vsprintf_s"
		size = 27
		refs = "0013 __vsprintf_s_l"
	strings:
		$1 = { FF 74 24 10 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_42_5_0 {
	meta:
		name = "__vsnwprintf_s_l"
		size = 263
		refs = "000d __errno 001d __invalid_parameter 007d __woutput_s_l 0082 __vswprintf_helper"
	strings:
		$1 = { 55 8B EC 51 53 33 DB 39 5D 14 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D8 00 00 00 39 5D 10 56 8B 75 08 57 75 10 3B F3 75 10 39 5D 0C 75 12 33 C0 E9 BC 00 00 00 3B F3 74 07 8B 7D 0C 3B FB 77 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 91 00 00 00 E8 ?? ?? ?? ?? 3B 7D 10 FF 75 1C FF 75 18 FF 75 14 76 2D 8B 38 8B 45 10 40 50 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 83 F8 FE 75 4D E8 ?? ?? ?? ?? 83 38 22 75 67 E8 ?? ?? ?? ?? 89 38 EB 5E 8B 00 57 56 68 ?? ?? ?? ?? 89 45 FC E8 ?? ?? ?? ?? 83 C4 18 83 F8 FE 66 89 5C 7E FE 75 1C 83 7D 10 FF 75 1A E8 ?? ?? ?? ?? 83 38 22 75 30 E8 ?? ?? ?? ?? 8B 4D FC 89 08 EB 24 3B C3 7D 23 83 F8 FE 66 89 1E 75 18 E8 ?? ?? ?? ?? C7 00 22 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_42_6_0 {
	meta:
		name = "__vsnwprintf_s"
		size = 30
		refs = "0015 __vsnwprintf_s_l"
	strings:
		$1 = { 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_165_18_0 {
	meta:
		name = "__strftime_l"
		size = 30
		refs = "0015 __Strftime_l"
	strings:
		$1 = { 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_236_6_0 {
	meta:
		name = "__vsnprintf_s"
		size = 30
		refs = "0015 __vsnprintf_s_l"
	strings:
		$1 = { 55 8B EC FF 75 18 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_43_1_0 {
	meta:
		name = "_wadd"
		size = 59
		refs = "0003 __malloc_crt 001a _arghead 0025 _argend"
		altNames = "_add"
	strings:
		$1 = { 6A 08 E8 ?? ?? ?? ?? 85 C0 59 75 04 83 C8 FF C3 8B 4C 24 04 83 60 04 00 83 3D ?? ?? ?? ?? 00 89 08 74 0B 8B 0D ?? ?? ?? ?? 89 41 04 EB 05 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_43_2_0 {
	meta:
		name = "_wsort"
		size = 53
		refs = "000f __wcsicmp"
	strings:
		$1 = { 57 8B F8 85 FF 74 2C 56 EB 21 FF 37 FF 36 E8 ?? ?? ?? ?? 85 C0 59 59 7D 08 8B 0E 8B 07 89 0F 89 06 8B 76 04 85 F6 75 E2 8B 7F 04 8B 77 04 85 F6 75 D8 5E 5F C3 }
	condition:
		$1
}

rule file_930_2_0 {
	meta:
		name = "_sort"
		size = 53
		refs = "000f __mbsicmp"
	strings:
		$1 = { 57 8B F8 85 FF 74 2C 56 EB 21 FF 37 FF 36 E8 ?? ?? ?? ?? 85 C0 59 59 7D 08 8B 0E 8B 07 89 0F 89 06 8B 76 04 85 F6 75 E2 8B 7F 04 8B 77 04 85 F6 75 D8 5E 5F C3 }
	condition:
		$1
}

rule file_43_3_0 {
	meta:
		name = "_wfind"
		size = 140
		refs = "0009 ?findbuf@?1??wfind@@9@9 0016 __malloc_crt 0028 ?_WildFindHandle@?1??wfind@@9@9 0033 __imp__FindClose@4 004a __imp__FindFirstFileW@8 006f __imp__FindNextFileW@8"
	strings:
		$1 = { 83 7C 24 04 00 74 5A 83 3D ?? ?? ?? ?? 00 75 17 68 54 03 00 00 E8 ?? ?? ?? ?? 85 C0 59 A3 ?? ?? ?? ?? 75 03 33 C0 C3 A1 ?? ?? ?? ?? 85 C0 74 0E 50 FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 FF 35 ?? ?? ?? ?? FF 74 24 08 FF 15 ?? ?? ?? ?? 83 F8 FF A3 ?? ?? ?? ?? 74 CC A1 ?? ?? ?? ?? 83 C0 2C C3 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 E1 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 25 ?? ?? ?? ?? 00 EB 98 }
	condition:
		$1
}

rule file_43_4_0 {
	meta:
		name = "_wmatch"
		size = 485
		refs = "006f _wfind 0081 _argend 0089 ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 0091 _wcscmp 00a0 ??_C@_15DDHGOCBH@?$AA?4?$AA?4?$AA?$AA@ 00cf __wcsdup 00dd _wadd 00f6 _wcslen 0113 __calloc_crt 0126 _wcsncpy_s 0139 __invoke_watson 014b _wcscpy_s 01a0 _arghead 01af __wcsicmp"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 56 8B 75 0C 33 DB 3B F3 89 5D F8 75 08 83 C8 FF E9 C5 01 00 00 57 8B 7D 08 EB 1A 0F B7 06 66 3D 5C 00 74 15 66 3D 2F 00 74 0F 66 3D 3A 00 74 0F 4E 4E 89 75 0C 3B F7 75 E2 66 83 3E 3A 75 0B 8D 47 02 3B F0 0F 85 88 01 00 00 0F B7 06 66 3D 5C 00 74 0C 66 3D 2F 00 74 06 66 3D 3A 00 75 07 8B DE 2B DF D1 FB 43 57 E8 ?? ?? ?? ?? 85 C0 59 89 45 FC 0F 84 5A 01 00 00 8B 3D ?? ?? ?? ?? 89 7D F4 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 85 C0 59 59 0F 84 DE 00 00 00 68 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 85 C0 59 59 0F 84 C7 00 00 00 0F B7 06 66 3D 5C 00 74 33 66 3D 3A 00 74 2D 66 3D 2F 00 74 27 FF 75 FC E8 ?? ?? ?? ?? 85 C0 59 89 45 08 74 0F 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 90 00 00 00 83 C8 FF E9 EE 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 85 DB 59 8D 74 18 01 7C E7 81 FE FF FF FF 7F 73 DF 3B F3 72 DB 6A 02 56 E8 ?? ?? ?? ?? 8B F8 85 FF 59 59 74 CB 53 FF 75 08 56 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 FF 75 FC 2B F3 8D 04 5F 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 85 C0 59 0F 85 76 FF FF FF 8B 75 0C 8B 7D F4 FF 45 F8 6A 00 E8 ?? ?? ?? ?? 85 C0 59 89 45 FC 0F 85 F8 FE FF FF 39 45 F8 74 41 85 FF 74 05 8B 77 04 EB 06 8B 35 ?? ?? ?? ?? 85 F6 74 2A EB 21 FF 36 FF 37 E8 ?? ?? ?? ?? 85 C0 59 59 7D 08 8B 0F 8B 06 89 0E 89 07 8B 7F 04 85 FF 75 E2 8B 76 04 8B 7E 04 85 FF 75 D8 33 C0 EB 0A 8B 7D 08 57 E8 ?? ?? ?? ?? 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_43_5_0 {
	meta:
		name = "__wcwild"
		size = 187
		refs = "0003 ___wargv 000c _argend 0012 _arghead 001e ??_C@_15EAECJAPL@?$AA?$CK?$AA?$DP?$AA?$AA@ 0024 _wcspbrk 0032 _wmatch 003c _wadd 0069 __calloc_crt 0075 ___argc 00a5 _free"
	strings:
		$1 = { 56 8B 35 ?? ?? ?? ?? 57 33 FF 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 30 83 06 02 8B 06 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 3B C7 59 59 74 0B 50 FF 36 E8 ?? ?? ?? ?? 59 EB 07 FF 36 E8 ?? ?? ?? ?? 85 C0 59 75 10 83 C6 04 39 3E 75 CC A1 ?? ?? ?? ?? 33 F6 EB 09 83 C8 FF EB 5E 8B 40 04 46 3B C7 75 F8 8D 46 01 50 6A 04 E8 ?? ?? ?? ?? 3B C7 59 59 74 E2 89 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 3B F7 A3 ?? ?? ?? ?? 8B CE 74 0E 8B 11 89 10 8B 49 04 83 C0 04 3B CF 75 F2 3B F7 89 38 8B C6 74 16 8B 76 04 50 E8 ?? ?? ?? ?? 3B F7 59 8B C6 75 F0 89 35 ?? ?? ?? ?? 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "__wchmod"
		size = 109
		refs = "000a ___doserrno 0011 __errno 0021 __invalid_parameter 0033 __imp__GetFileAttributesW@4 003e __imp__GetLastError@0 0044 __dosmaperr 0061 __imp__SetFileAttributesW@8"
	strings:
		$1 = { 56 33 F6 39 74 24 08 75 24 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E C3 FF 74 24 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB DD F6 44 24 0C 80 74 05 83 E0 FE EB 03 83 C8 01 50 FF 74 24 0C FF 15 ?? ?? ?? ?? 85 C0 74 D3 33 C0 5E C3 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "__chmod"
		size = 109
		refs = "000a ___doserrno 0011 __errno 0021 __invalid_parameter 0033 __imp__GetFileAttributesA@4 003e __imp__GetLastError@0 0044 __dosmaperr 0061 __imp__SetFileAttributesA@8"
	strings:
		$1 = { 56 33 F6 39 74 24 08 75 24 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E C3 FF 74 24 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB DD F6 44 24 0C 80 74 05 83 E0 FE EB 03 83 C8 01 50 FF 74 24 0C FF 15 ?? ?? ?? ?? 85 C0 74 D3 33 C0 5E C3 }
	condition:
		$1
}

rule file_45_0_0 {
	meta:
		name = "__wrename"
		size = 46
		refs = "000a __imp__MoveFileW@8 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_89_0_0 {
	meta:
		name = "_rename"
		size = 46
		refs = "000a __imp__MoveFileA@8 0014 __imp__GetLastError@0 0022 __dosmaperr"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_46_0_0 {
	meta:
		name = "__chkesp"
		size = 24
	strings:
		$1 = { 75 01 C3 55 8B EC 83 EC 00 50 52 53 56 57 CC 5F 5E 5B 5A 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "__local_unwind4"
		size = 144
		refs = "0015 __unwind_handler4 0021 ___security_cookie 006f __NLG_Notify 007c __NLG_Call"
	strings:
		$1 = { 53 56 57 8B 54 24 10 8B 44 24 14 8B 4C 24 18 55 52 50 51 51 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 A1 ?? ?? ?? ?? 33 C4 89 44 24 08 64 89 25 00 00 00 00 8B 44 24 30 8B 58 08 8B 4C 24 2C 33 19 8B 70 0C 83 FE FE 74 3B 8B 54 24 34 83 FA FE 74 04 3B F2 76 2E 8D 34 76 8D 5C B3 10 8B 0B 89 48 0C 83 7B 04 00 75 CC 68 01 01 00 00 8B 43 08 E8 ?? ?? ?? ?? B9 01 00 00 00 8B 43 08 E8 ?? ?? ?? ?? EB B0 64 8F 05 00 00 00 00 83 C4 18 5F 5E 5B C3 }
	condition:
		$1
}

rule file_47_1_0 {
	meta:
		name = "__unwind_handler4"
		size = 70
		refs = "001c @__security_check_cookie@4"
	strings:
		$1 = { 8B 4C 24 04 F7 41 04 06 00 00 00 B8 01 00 00 00 74 33 8B 44 24 08 8B 48 08 33 C8 E8 ?? ?? ?? ?? 55 8B 68 18 FF 70 0C FF 70 10 FF 70 14 E8 3E FF FF FF 83 C4 0C 5D 8B 44 24 08 8B 54 24 10 89 02 B8 03 00 00 00 C3 }
	condition:
		$1
}

rule file_47_2_0 {
	meta:
		name = "__seh_longjmp_unwind4@4"
		size = 28
	strings:
		$1 = { 55 8B 4C 24 08 8B 29 FF 71 1C FF 71 18 FF 71 28 E8 15 FF FF FF 83 C4 0C 5D C2 04 00 }
	condition:
		$1
}

rule file_47_3_0 {
	meta:
		name = "@_EH4_CallFilterFunc@8"
		size = 23
	strings:
		$1 = { 55 56 57 53 8B EA 33 C0 33 DB 33 D2 33 F6 33 FF FF D1 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_47_4_0 {
	meta:
		name = "@_EH4_TransferToHandler@8"
		size = 25
		refs = "0009 __NLG_Notify"
	strings:
		$1 = { 8B EA 8B F1 8B C1 6A 01 E8 ?? ?? ?? ?? 33 C0 33 DB 33 C9 33 D2 33 FF FF E6 }
	condition:
		$1
}

rule file_47_5_0 {
	meta:
		name = "@_EH4_GlobalUnwind@4"
		size = 26
		refs = "000b ReturnPoint 0011 _RtlUnwind@16"
	strings:
		$1 = { 55 8B EC 53 56 57 6A 00 6A 00 68 ?? ?? ?? ?? 51 E8 ?? ?? ?? ?? 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_47_6_0 {
	meta:
		name = "@_EH4_LocalUnwind@16"
		size = 23
	strings:
		$1 = { 55 8B 6C 24 08 52 51 FF 74 24 14 E8 B4 FE FF FF 83 C4 0C 5D C2 08 00 }
	condition:
		$1
}

rule file_48_0_0 {
	meta:
		name = "__wexecv"
		size = 77
		refs = "000c __errno 001c __invalid_parameter 0044 __wexecve"
	strings:
		$1 = { 8B 54 24 04 56 33 F6 3B D6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E C3 66 39 32 74 DE 8B 4C 24 0C 3B CE 74 D6 8B 01 3B C6 74 D0 66 39 30 74 CB 56 51 52 E8 ?? ?? ?? ?? 83 C4 0C 5E C3 }
	condition:
		$1
}

rule file_49_0_0 {
	meta:
		name = "__wcsset_s"
		size = 86
		refs = "0015 __errno 0024 __invalid_parameter"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 57 74 08 8B 54 24 10 3B D6 77 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 24 66 39 30 8B C8 74 12 4A 74 0F 66 8B 7C 24 14 66 89 39 41 41 66 39 31 75 EE 3B D6 75 05 66 89 30 EB C3 33 C0 5F 5E C3 }
	condition:
		$1
}

rule file_50_0_0 {
	meta:
		name = "_store_dt"
		size = 26
	strings:
		$1 = { 56 99 6A 0A 5E F7 FE 5E 83 C0 30 66 89 01 41 41 83 C2 30 66 89 11 8D 41 02 C3 }
	condition:
		$1
}

rule file_50_1_0 {
	meta:
		name = "__wasctime_s"
		size = 454
		refs = "0013 __errno 0022 __invalid_parameter 00a5 __days 012c ___dnames 0138 ___mnames 015b _store_dt"
	strings:
		$1 = { 8B 4C 24 04 56 57 33 FF 3B CF 74 06 39 7C 24 10 77 1E E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 93 01 00 00 83 7C 24 10 1A 66 89 39 72 D8 8B 74 24 14 3B F7 74 D0 39 7E 14 7C CB 53 8B 5E 10 3B DF 7C 28 83 FB 0B 7F 23 8B 46 08 3B C7 7C 1C 83 F8 17 7F 17 8B 46 04 3B C7 7C 10 83 F8 3B 7F 0B 8B 06 3B C7 7C 05 83 F8 3B 7E 1E E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 2D 01 00 00 8B 56 0C 83 FA 01 55 7C 63 8B C3 C1 E0 02 8B A8 ?? ?? ?? ?? 2B A8 ?? ?? ?? ?? 3B EA 7D 42 8B 46 14 05 6C 07 00 00 8B D0 81 E2 03 00 00 80 89 44 24 14 79 05 4A 83 CA FC 42 75 0E 6A 64 99 5D F7 FD 85 D2 75 10 8B 44 24 14 99 BD 90 01 00 00 F7 FD 85 D2 75 17 83 FB 01 75 12 83 7E 0C 1D 7F 0C 8B 46 18 3B C7 7C 05 83 F8 06 7E 1E E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 A2 00 00 00 6B C0 03 6B DB 03 33 D2 66 0F BE AC 10 ?? ?? ?? ?? 66 89 29 66 0F BE AC 13 ?? ?? ?? ?? 66 89 69 08 42 41 41 83 FA 03 7C DF 6A 20 5B 66 89 19 83 C1 08 66 89 19 8B 46 0C 83 C1 02 E8 ?? ?? ?? ?? 66 89 18 8D 48 02 8B 46 08 E8 ?? ?? ?? ?? 66 C7 00 3A 00 8D 48 02 8B 46 04 E8 ?? ?? ?? ?? 66 C7 00 3A 00 8D 48 02 8B 06 E8 ?? ?? ?? ?? 8B C8 66 89 19 8B 46 14 99 6A 64 5B F7 FB 83 C1 02 83 C0 13 E8 ?? ?? ?? ?? 8B C8 8B 46 14 99 53 5E F7 FE 8B C2 E8 ?? ?? ?? ?? 66 C7 00 0A 00 66 89 78 02 33 C0 5D 5B 5F 5E C3 }
	condition:
		$1
}

rule file_50_2_0 {
	meta:
		name = "__wasctime"
		size = 71
		refs = "0003 _buf 0008 __getptd_noexit 001d __calloc_crt 0035 __wasctime_s"
	strings:
		$1 = { 56 57 BF ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 85 F6 74 1B 83 7E 40 00 75 12 6A 02 6A 1A E8 ?? ?? ?? ?? 85 C0 59 59 89 46 40 74 03 8B 7E 40 FF 74 24 0C 6A 1A 57 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 C7 5F 5E C3 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "__wutime64"
		size = 127
		refs = "000c __errno 001c __invalid_parameter 0038 __wsopen_s 004b __futime64 0068 __close"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 54 56 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 E0 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 FF FF 59 59 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 83 FF FF 59 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_204_1_0 {
	meta:
		name = "__utime32"
		size = 127
		refs = "000c __errno 001c __invalid_parameter 0038 __sopen_s 004b __futime32 0068 __close"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 54 56 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 E0 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 FF FF 59 59 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 83 FF FF 59 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "__utime64"
		size = 127
		refs = "000c __errno 001c __invalid_parameter 0038 __sopen_s 004b __futime64 0068 __close"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 54 56 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 E0 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 FF FF 59 59 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 83 FF FF 59 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_925_0_0 {
	meta:
		name = "__wutime32"
		size = 127
		refs = "000c __errno 001c __invalid_parameter 0038 __wsopen_s 004b __futime32 0068 __close"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 54 56 6A 40 68 02 80 00 00 FF 75 08 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 E0 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B F8 83 FF FF 59 59 75 09 E8 ?? ?? ?? ?? 8B 30 EB 03 8B 75 08 FF 75 08 E8 ?? ?? ?? ?? 83 FF FF 59 75 07 E8 ?? ?? ?? ?? 89 30 8B C7 5F 5E 5D C3 }
	condition:
		$1
}

rule file_52_0_0 {
	meta:
		name = "_xtoa@16"
		size = 64
	strings:
		$1 = { 83 7C 24 08 00 74 06 C6 01 2D 41 F7 D8 56 8B F1 33 D2 F7 74 24 08 83 FA 09 76 05 80 C2 57 EB 03 80 C2 30 88 11 41 85 C0 77 E6 C6 01 00 49 8A 16 8A 01 88 11 49 88 06 46 3B F1 72 F2 5E C2 08 00 }
	condition:
		$1
}

rule file_52_1_0 {
	meta:
		name = "__itoa"
		size = 40
		refs = "001f _xtoa@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 8B 45 08 75 0A 85 C0 7D 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 4D 0C E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_103_1_0 {
	meta:
		name = "__itow"
		size = 40
		refs = "001f _xtow@16"
	strings:
		$1 = { 55 8B EC 83 7D 10 0A 8B 45 08 75 0A 85 C0 7D 06 6A 01 6A 0A EB 05 6A 00 FF 75 10 8B 4D 0C E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_52_2_0 {
	meta:
		name = "__ltoa"
		size = 37
		refs = "001c _xtoa@16"
	strings:
		$1 = { 55 8B EC 33 C0 83 7D 10 0A 75 06 39 45 08 7D 01 40 8B 4D 0C 50 FF 75 10 8B 45 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_103_2_0 {
	meta:
		name = "__ltow"
		size = 37
		refs = "001c _xtow@16"
	strings:
		$1 = { 55 8B EC 33 C0 83 7D 10 0A 75 06 39 45 08 7D 01 40 8B 4D 0C 50 FF 75 10 8B 45 08 E8 ?? ?? ?? ?? 8B 45 0C 5D C3 }
	condition:
		$1
}

rule file_52_3_0 {
	meta:
		name = "__ultoa"
		size = 24
		refs = "000f _xtoa@16"
	strings:
		$1 = { 8B 4C 24 08 8B 44 24 04 6A 00 FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_103_3_0 {
	meta:
		name = "__ultow"
		size = 24
		refs = "000f _xtow@16"
	strings:
		$1 = { 8B 4C 24 08 8B 44 24 04 6A 00 FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 08 C3 }
	condition:
		$1
}

rule file_52_4_0 {
	meta:
		name = "@x64toa@20"
		size = 109
		refs = "002f __aulldvrm"
	strings:
		$1 = { 55 8B EC 51 51 53 8B 5D 08 56 33 C9 39 4D 14 8B F0 8B 45 0C 57 74 0A C6 06 2D 46 F7 DB 13 C1 F7 D8 8B FE 89 4D 0C FF 75 0C FF 75 10 50 53 E8 ?? ?? ?? ?? 83 F9 09 89 5D FC 8B D8 8B C2 76 05 80 C1 57 EB 03 80 C1 30 88 0E 46 85 C0 77 D8 72 04 85 DB 77 D2 C6 06 00 4E 8A 0F 8A 06 88 0E 4E 88 07 47 3B FE 72 F2 5F 5E 5B C9 C2 10 00 }
	condition:
		$1
}

rule file_52_5_0 {
	meta:
		name = "__i64toa"
		size = 49
		refs = "0028 @x64toa@20"
	strings:
		$1 = { 55 8B EC 33 C0 83 7D 14 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 50 FF 75 14 8B 45 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_103_5_0 {
	meta:
		name = "__i64tow"
		size = 49
		refs = "0028 @x64tow@20"
	strings:
		$1 = { 55 8B EC 33 C0 83 7D 14 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 50 FF 75 14 8B 45 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_52_6_0 {
	meta:
		name = "__ui64toa"
		size = 27
		refs = "0012 @x64toa@20"
	strings:
		$1 = { 55 8B EC 8B 45 10 6A 00 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_103_6_0 {
	meta:
		name = "__ui64tow"
		size = 27
		refs = "0012 @x64tow@20"
	strings:
		$1 = { 55 8B EC 8B 45 10 6A 00 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 8B 45 10 5D C3 }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "__wspawnl"
		size = 79
		refs = "000c __errno 001c __invalid_parameter 0046 __wspawnve"
	strings:
		$1 = { 8B 4C 24 08 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E C3 66 39 31 74 DE 8B 44 24 10 3B C6 74 D6 66 39 30 74 D1 56 8D 44 24 14 50 51 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_54_3_0 {
	meta:
		name = "__mbsncpy_s_l"
		size = 521
		refs = "0033 __errno 0042 __invalid_parameter 0086 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 009b _strncpy_s 00dd __ismbblead_l"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 33 DB 39 5D 14 56 89 5D F8 75 13 8B 75 08 3B F3 75 14 39 5D 0C 75 14 33 C0 E9 E0 01 00 00 39 5D 08 74 08 8B 75 08 39 5D 0C 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 B5 01 00 00 39 5D 14 75 04 88 1E EB C5 57 8B 7D 10 3B FB 75 1E 88 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 54 01 00 00 FF 75 18 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 39 58 08 75 25 FF 75 14 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 10 38 5D F4 0F 84 59 01 00 00 8B 4D F0 83 61 70 FD E9 4D 01 00 00 83 7D 14 FF 8B 45 0C 89 45 FC 75 11 8A 07 88 06 46 47 3A C3 74 66 FF 4D FC 75 F1 EB 5F 8D 45 E8 50 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 20 8D 47 01 38 18 74 2F 83 7D FC 02 76 35 8A 0F 88 0E 46 8B F8 8A 07 88 06 46 47 83 6D FC 02 EB 0F 8A 07 88 06 46 47 3A C3 74 1B FF 4D FC 74 16 FF 4D 14 75 B9 EB 0F 88 1E 46 C7 45 F8 01 00 00 00 EB 03 89 5D FC 39 5D 14 75 02 88 1E 39 5D FC 0F 85 9B 00 00 00 83 7D 14 FF 75 69 39 5D F8 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 45 0C 83 F8 01 8B 7D 08 76 39 8D 74 07 FE 3B F7 89 75 14 72 1E 8D 45 E8 50 8B 45 14 0F B6 00 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 08 FF 4D 14 39 7D 14 73 E2 8B C6 2B 45 14 A8 01 74 04 88 1E EB 07 8B 45 0C 88 5C 07 FF 38 5D F4 74 07 8B 45 F0 83 60 70 FD 6A 50 58 EB 59 8B 45 08 88 18 E8 ?? ?? ?? ?? 6A 22 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B C6 EB 2D 39 5D F8 74 1A E8 ?? ?? ?? ?? 6A 2A 59 89 08 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B C1 EB 0E 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "___lconv_init"
		size = 45
		refs = "0003 ___lconv_c"
	strings:
		$1 = { 0C FF A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? A2 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_57_1_0 {
	meta:
		name = "__CIfmod"
		size = 40
		refs = "0001 __OP_FMODjmptab 0006 __cintrindisp2 000e __adjust_fdiv 001a __adj_fprem"
	strings:
		$1 = { BA ?? ?? ?? ?? E9 ?? ?? ?? ?? D9 C9 83 3D ?? ?? ?? ?? 01 74 04 D9 F8 EB 05 E8 ?? ?? ?? ?? 9B DF E0 9B 9E 7A E7 DD D9 C3 }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "??__D@YGXPAX0IHP6EX00@ZP6EX0@Z@Z"
		size = 105
		refs = "0003 __sehtable$??__D@YGXPAX0IHP6EX00@ZP6EX0@Z@Z 0008 __SEH_prolog4 004a __SEH_epilog4 0064 ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 89 45 E0 89 45 FC 89 45 E4 33 F6 46 8B 45 E4 3B 45 14 7D 18 56 FF 75 0C 8B 4D 08 FF 55 18 8B 45 10 01 45 08 01 45 0C FF 45 E4 EB E0 89 75 E0 C7 45 FC FE FF FF FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 18 00 83 7D E0 00 75 11 FF 75 1C FF 75 E4 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_59_0_0 {
	meta:
		name = "___security_init_cookie"
		size = 148
		refs = "0007 ___security_cookie 002a ___security_cookie_complement 0037 __imp__GetSystemTimeAsFileTime@4 0043 __imp__GetCurrentProcessId@0 004b __imp__GetCurrentThreadId@0 0053 __imp__GetTickCount@0 005f __imp__QueryPerformanceCounter@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 83 65 F8 00 83 65 FC 00 53 57 BF 4E E6 40 BB 3B C7 BB 00 00 FF FF 74 0D 85 C3 74 09 F7 D0 A3 ?? ?? ?? ?? EB 60 56 8D 45 F8 50 FF 15 ?? ?? ?? ?? 8B 75 FC 33 75 F8 FF 15 ?? ?? ?? ?? 33 F0 FF 15 ?? ?? ?? ?? 33 F0 FF 15 ?? ?? ?? ?? 33 F0 8D 45 F0 50 FF 15 ?? ?? ?? ?? 8B 45 F4 33 45 F0 33 F0 3B F7 75 07 BE 4F E6 40 BB EB 0B 85 F3 75 07 8B C6 C1 E0 10 0B F0 89 35 ?? ?? ?? ?? F7 D6 89 35 ?? ?? ?? ?? 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_60_0_0 {
	meta:
		name = "__wctime32_s"
		size = 111
		refs = "0017 __errno 0026 __invalid_parameter 0051 __localtime32_s 0064 __wasctime_s"
	strings:
		$1 = { 55 8B EC 83 EC 24 56 57 8B 7D 08 33 F6 3B FE 74 05 39 75 0C 77 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 3A 8B 45 10 3B C6 66 89 37 74 DB 39 30 7D 0C E8 ?? ?? ?? ?? 6A 16 5F 89 38 EB E2 50 8D 45 DC 50 E8 ?? ?? ?? ?? 3B C6 59 59 75 10 8D 45 DC 50 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E C9 C3 }
	condition:
		$1
}

rule file_60_1_0 {
	meta:
		name = "__wctime32"
		size = 90
		refs = "0011 __errno 0021 __invalid_parameter 0044 __localtime32_s 0053 __wasctime"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 24 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C9 C3 39 30 7D 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB EA 50 8D 45 DC 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 DA 8D 45 DC 50 E8 ?? ?? ?? ?? 59 EB D0 }
	condition:
		$1
}

rule file_256_1_0 {
	meta:
		name = "__ctime32"
		size = 90
		refs = "0011 __errno 0021 __invalid_parameter 0044 __localtime32_s 0053 _asctime"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 24 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C9 C3 39 30 7D 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB EA 50 8D 45 DC 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 DA 8D 45 DC 50 E8 ?? ?? ?? ?? 59 EB D0 }
	condition:
		$1
}

rule file_61_3_0 {
	meta:
		name = "__mbsnbset_l"
		size = 227
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002b __strnset 0054 __errno 0064 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 08 FF 75 14 8D 4D F0 89 75 08 E8 ?? ?? ?? ?? 8B 45 F4 33 DB 39 58 08 75 24 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D FC 0F 84 A4 00 00 00 8B 4D F8 83 61 70 FD E9 98 00 00 00 3B F3 57 8B 7D 10 75 2C 3B FB 74 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 63 8B 4D 0C 8B C1 C1 E8 08 3A C3 74 44 3A CB 8A D1 75 2B E8 ?? ?? ?? ?? C7 00 16 00 00 00 B0 20 8A D0 EB 1A 4F 38 1E 74 2C 8B CF 4F 85 C9 74 14 8D 4E 01 38 19 74 0D 88 06 8B F1 88 16 46 3B FB 75 E2 EB 11 C6 06 20 EB 0C 4F 38 1E 74 07 88 0E 46 3B FB 75 F4 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B 45 08 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_61_4_0 {
	meta:
		name = "__mbsnbset"
		size = 23
		refs = "000f __mbsnbset_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_29_1_1 {
	meta:
		name = "__Stoll"
		size = 23
		refs = "000f __Stollx"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_28_1_1 {
	meta:
		name = "__Stoul"
		size = 23
		refs = "000f __Stoulx"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_66_1_1 {
	meta:
		name = "__Stoull"
		size = 23
		refs = "000f __Stoullx"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_696_5_0 {
	meta:
		name = "__aligned_realloc"
		size = 23
		refs = "000f __aligned_offset_realloc"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_610_9_0 {
	meta:
		name = "__fassign"
		size = 23
		refs = "000f __fassign_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_559_0_0 {
	meta:
		name = "__mbscat_s"
		size = 23
		refs = "000f __mbscat_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_475_0_0 {
	meta:
		name = "__mbscpy_s"
		size = 23
		refs = "000f __mbscpy_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_831_4_0 {
	meta:
		name = "__mbsnbcat"
		size = 23
		refs = "000f __mbsnbcat_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_916_4_0 {
	meta:
		name = "__mbsnbcmp"
		size = 23
		refs = "000f __mbsnbcmp_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_517_4_0 {
	meta:
		name = "__mbsnbcoll"
		size = 23
		refs = "000f __mbsnbcoll_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_489_4_0 {
	meta:
		name = "__mbsnbcpy"
		size = 23
		refs = "000f __mbsnbcpy_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_94_4_0 {
	meta:
		name = "__mbsnbicmp"
		size = 23
		refs = "000f __mbsnbicmp_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_741_4_0 {
	meta:
		name = "__mbsnbicoll"
		size = 23
		refs = "000f __mbsnbicoll_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_709_4_0 {
	meta:
		name = "__mbsncat"
		size = 23
		refs = "000f __mbsncat_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_450_4_0 {
	meta:
		name = "__mbsncmp"
		size = 23
		refs = "000f __mbsncmp_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_924_4_0 {
	meta:
		name = "__mbsncoll"
		size = 23
		refs = "000f __mbsncoll_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_543_4_0 {
	meta:
		name = "__mbsncpy"
		size = 23
		refs = "000f __mbsncpy_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_692_4_0 {
	meta:
		name = "__mbsnicmp"
		size = 23
		refs = "000f __mbsnicmp_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_446_4_0 {
	meta:
		name = "__mbsnicoll"
		size = 23
		refs = "000f __mbsnicoll_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_633_4_0 {
	meta:
		name = "__mbsnset"
		size = 23
		refs = "000f __mbsnset_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "__mbsset_s"
		size = 23
		refs = "000f __mbsset_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_353_4_0 {
	meta:
		name = "__mbstok_s"
		size = 23
		refs = "000f __mbstok_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_862_0_0 {
	meta:
		name = "__spawnvp"
		size = 23
		refs = "000f __spawnvpe"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "__wspawnvp"
		size = 23
		refs = "000f __wspawnvpe"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_824_4_0 {
	meta:
		name = "_mbtowc"
		size = 23
		refs = "000f __mbtowc_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_728_4_0 {
	meta:
		name = "_strxfrm"
		size = 23
		refs = "000f __strxfrm_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_550_6_0 {
	meta:
		name = "_wcstombs"
		size = 23
		refs = "000f __wcstombs_l_helper"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_482_4_0 {
	meta:
		name = "_wcsxfrm"
		size = 23
		refs = "000f __wcsxfrm_l"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_63_0_0 {
	meta:
		name = "?swprintf@@YAHPAGIPBGZZ"
		size = 28
		refs = "0014 ?_vswprintf_l@@YAHPA_WIPB_WPAUlocaleinfo_struct@@PAD@Z"
	strings:
		$1 = { 8D 44 24 10 50 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_249_6_0 {
	meta:
		name = "__sprintf_p"
		size = 28
		refs = "0014 __vsprintf_p_l"
	strings:
		$1 = { 8D 44 24 10 50 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_244_4_0 {
	meta:
		name = "__swprintf_p"
		size = 28
		refs = "0014 __vswprintf_p_l"
	strings:
		$1 = { 8D 44 24 10 50 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_249_2_0 {
	meta:
		name = "_sprintf_s"
		size = 28
		refs = "0014 __vsprintf_s_l"
	strings:
		$1 = { 8D 44 24 10 50 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_279_2_0 {
	meta:
		name = "_swprintf"
		size = 28
		refs = "0014 __vswprintf_c_l"
	strings:
		$1 = { 8D 44 24 10 50 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_244_2_0 {
	meta:
		name = "_swprintf_s"
		size = 28
		refs = "0014 __vswprintf_s_l"
	strings:
		$1 = { 8D 44 24 10 50 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_63_1_0 {
	meta:
		name = "?swprintf@@YAHPA_WIPB_WZZ"
		size = 129
		refs = "003f __woutput_l 005d __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 89 45 E8 89 45 E0 8B 45 0C 3D FF FF FF 3F C7 45 EC 42 00 00 00 76 09 C7 45 E4 FF FF FF 7F EB 05 03 C0 89 45 E4 53 56 8D 45 14 50 33 DB 53 FF 75 10 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 0A 8B 45 E0 88 18 FF 45 E0 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_65_0_0 {
	meta:
		name = "_realloc"
		size = 539
		refs = "0003 __sehtable$_realloc 0008 __SEH_prolog4 0017 _malloc 002a _free 0036 ___active_heap 0052 __lock 005c ___sbh_find_block 006e ___sbh_threshold 0078 ___sbh_resize_block 008a ___sbh_alloc_block 00a6 _memcpy 00b6 ___sbh_free_block 00d9 __crtheap 00df __imp__HeapAlloc@12 0136 __imp__HeapReAlloc@16 0147 __unlock 015a __newmode 0162 __callnewh 0170 __errno 017d __imp__GetLastError@0 0183 __get_errno_from_oserr 01ee __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 5D 08 85 DB 75 0E FF 75 0C E8 ?? ?? ?? ?? 59 E9 CC 01 00 00 8B 75 0C 85 F6 75 0C 53 E8 ?? ?? ?? ?? 59 E9 B7 01 00 00 83 3D ?? ?? ?? ?? 03 0F 85 93 01 00 00 33 FF 89 7D E4 83 FE E0 0F 87 8A 01 00 00 6A 04 E8 ?? ?? ?? ?? 59 89 7D FC 53 E8 ?? ?? ?? ?? 59 89 45 E0 3B C7 0F 84 9E 00 00 00 3B 35 ?? ?? ?? ?? 77 49 56 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 05 89 5D E4 EB 35 56 E8 ?? ?? ?? ?? 59 89 45 E4 3B C7 74 27 8B 43 FC 48 3B C6 72 02 8B C6 50 53 FF 75 E4 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 89 45 E0 53 50 E8 ?? ?? ?? ?? 83 C4 18 39 7D E4 75 48 3B F7 75 06 33 F6 46 89 75 0C 83 C6 0F 83 E6 F0 89 75 0C 56 57 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 3B C7 74 20 8B 43 FC 48 3B C6 72 02 8B C6 50 53 FF 75 E4 E8 ?? ?? ?? ?? 53 FF 75 E0 E8 ?? ?? ?? ?? 83 C4 14 C7 45 FC FE FF FF FF E8 2E 00 00 00 83 7D E0 00 75 31 85 F6 75 01 46 83 C6 0F 83 E6 F0 89 75 0C 56 53 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 EB 12 8B 75 0C 8B 5D 08 6A 04 E8 ?? ?? ?? ?? 59 C3 8B 7D E4 85 FF 0F 85 BF 00 00 00 39 3D ?? ?? ?? ?? 74 2C 56 E8 ?? ?? ?? ?? 59 85 C0 0F 85 D2 FE FF FF E8 ?? ?? ?? ?? 39 7D E0 75 6C 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 06 EB 5F 85 FF 0F 85 83 00 00 00 E8 ?? ?? ?? ?? 39 7D E0 74 68 C7 00 0C 00 00 00 EB 71 85 F6 75 01 46 56 53 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 56 39 05 ?? ?? ?? ?? 74 34 56 E8 ?? ?? ?? ?? 59 85 C0 74 1F 83 FE E0 76 CD 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? E9 7C FF FF FF 85 FF 75 16 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 06 59 8B C7 EB D2 }
	condition:
		$1
}

rule file_65_1_0 {
	meta:
		name = "__recalloc"
		size = 71
		refs = "0019 __errno 0029 __invalid_parameter 003f _realloc"
	strings:
		$1 = { 8B 4C 24 08 56 33 F6 3B CE 76 29 6A E0 33 D2 58 F7 F1 3B 44 24 10 73 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C3 0F AF 4C 24 10 51 FF 74 24 0C E8 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_67_0_0 {
	meta:
		name = "__EH_prolog2"
		size = 55
	strings:
		$1 = { 51 8B 4C 24 08 89 5C 24 08 8D 5C 24 08 F7 D9 23 E1 8B 4B F8 89 2C 24 8B EC 6A FF 50 64 A1 00 00 00 00 50 64 89 25 00 00 00 00 51 8B 43 FC 8B 4B 04 89 4D 04 59 50 C3 }
	condition:
		$1
}

rule file_68_3_0 {
	meta:
		name = "__ismbslead_l"
		size = 168
		refs = "0012 __errno 0022 __invalid_parameter 0056 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 44 57 8B 7D 0C 3B FB 75 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 1F FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 39 59 08 75 2F 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 8A 06 3A C3 74 E7 0F B6 C0 F6 44 08 1D 04 74 0B 8B C6 46 3B C7 74 0B 38 1E 74 D2 46 3B F7 76 E0 EB CB 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF EB C8 }
	condition:
		$1
}

rule file_69_5_0 {
	meta:
		name = "?wcsncnt@@YAHPB_WH@Z"
		size = 28
	strings:
		$1 = { 8B 4C 24 04 EB 09 49 66 83 38 00 74 07 40 40 85 C9 75 F3 49 8B 44 24 04 2B C1 48 C3 }
	condition:
		$1
}

rule file_69_6_0 {
	meta:
		name = "?__crtCompareStringW_stat@@YAHPAUlocaleinfo_struct@@KKPB_WH1HH@Z"
		size = 592
		refs = "0007 ___security_cookie 0016 ?f_use@?1??__crtCompareStringW_stat@@YAHPAUlocaleinfo_struct@@KKPB_WH1HH@Z@4HA 001d __imp__CompareStringW@24 0028 ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0046 __imp__GetLastError@0 0065 ?wcsncnt@@YAHPB_WH@Z 00e0 ___ansicp 00f4 __imp__WideCharToMultiByte@32 0131 __alloca_probe_16 0145 _malloc 0208 __imp__CompareStringA@24 0211 __freea 024a @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 33 F6 39 35 ?? ?? ?? ?? 57 8B 3D ?? ?? ?? ?? 8B D9 75 34 6A 01 B8 ?? ?? ?? ?? 50 6A 01 50 56 56 FF D7 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 39 75 14 7E 0F FF 75 14 8B 45 10 E8 ?? ?? ?? ?? 59 89 45 14 39 75 1C 7E 0F FF 75 1C 8B 45 18 E8 ?? ?? ?? ?? 59 89 45 1C 39 75 14 0F 84 9A 01 00 00 39 75 1C 0F 84 91 01 00 00 A1 ?? ?? ?? ?? 83 F8 01 75 19 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF D7 E9 88 01 00 00 83 F8 02 74 04 3B C6 75 52 39 75 08 89 75 F0 75 08 8B 03 8B 40 14 89 45 08 39 75 20 75 08 8B 03 8B 40 04 89 45 20 FF 75 08 E8 ?? ?? ?? ?? 39 45 20 59 74 08 83 F8 FF 74 03 89 45 20 8B 3D ?? ?? ?? ?? 56 56 56 56 FF 75 14 FF 75 10 56 FF 75 20 FF D7 8B D8 3B DE 89 5D EC 75 07 33 C0 E9 26 01 00 00 7E 42 6A E0 33 D2 58 F7 F3 83 F8 01 72 36 8D 43 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C6 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 3B C6 59 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 F8 EB 03 89 75 F8 39 75 F8 74 AD 56 56 53 FF 75 F8 FF 75 14 FF 75 10 56 FF 75 20 FF D7 85 C0 0F 84 98 00 00 00 56 56 56 56 FF 75 1C FF 75 18 56 FF 75 20 FF D7 8B C8 3B CE 89 4D F4 74 7F 7E 41 6A E0 33 D2 58 F7 F1 83 F8 01 72 35 8D 41 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C6 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 3B C6 59 74 09 C7 00 DD DD 00 00 83 C0 08 8B D8 EB 02 33 DB 3B DE 74 36 56 56 FF 75 F4 53 FF 75 1C FF 75 18 56 FF 75 20 FF D7 85 C0 74 19 FF 75 F4 53 FF 75 EC FF 75 F8 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 89 45 F0 53 E8 ?? ?? ?? ?? 59 FF 75 F8 E8 ?? ?? ?? ?? 8B 45 F0 59 EB 1A 8B 45 14 2B 45 1C 75 05 6A 02 58 EB 0D 33 C9 3B C6 0F 9D C1 8D 4C 09 01 8B C1 8D 65 E0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_69_7_0 {
	meta:
		name = "___crtCompareStringW"
		size = 64
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ?__crtCompareStringW_stat@@YAHPAUlocaleinfo_struct@@KKPB_WH1HH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 24 8D 4D F0 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 1C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_879_6_0 {
	meta:
		name = "___crtGetStringTypeA"
		size = 64
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ?__crtGetStringTypeA_stat@@YAHPAUlocaleinfo_struct@@KPBDHPAGHHH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 24 8D 4D F0 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 1C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_473_8_0 {
	meta:
		name = "___crtLCMapStringW"
		size = 64
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ?__crtLCMapStringW_stat@@YAHPAUlocaleinfo_struct@@KKPB_WHPA_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 24 8D 4D F0 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 1C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_74_0_0 {
	meta:
		name = "__SEH_prolog4_GS"
		size = 72
		refs = "0001 __except_handler4 001e ___security_cookie"
	strings:
		$1 = { 68 ?? ?? ?? ?? 64 FF 35 00 00 00 00 8B 44 24 10 89 6C 24 10 8D 6C 24 10 2B E0 53 56 57 A1 ?? ?? ?? ?? 31 45 FC 33 C5 89 45 E4 50 89 65 E8 FF 75 F8 8B 45 FC C7 45 FC FE FF FF FF 89 45 F8 8D 45 F0 64 A3 00 00 00 00 C3 }
	condition:
		$1
}

rule file_75_3_0 {
	meta:
		name = "___check_float_string"
		size = 84
		refs = "0014 __calloc_crt 0036 _memcpy 0041 __recalloc_crt"
	strings:
		$1 = { 8B 06 39 44 24 04 75 48 8B 0F 3B 4C 24 08 6A 02 50 75 2C E8 ?? ?? ?? ?? 85 C0 59 59 89 07 75 03 33 C0 C3 8B 44 24 0C C7 00 01 00 00 00 FF 36 FF 74 24 0C FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D4 89 07 D1 26 33 C0 40 C3 }
	condition:
		$1
}

rule file_75_5_0 {
	meta:
		name = "__hextodec"
		size = 24
		refs = "0005 _isdigit"
	strings:
		$1 = { 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 0F BE C3 75 06 83 E0 DF 83 E8 07 C3 }
	condition:
		$1
}

rule file_75_6_0 {
	meta:
		name = "__inc"
		size = 22
		refs = "0010 __filbuf"
	strings:
		$1 = { FF 4A 04 78 09 8B 0A 0F B6 01 41 89 0A C3 52 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_75_8_0 {
	meta:
		name = "__whiteout"
		size = 37
		refs = "0008 __inc 0018 _isspace"
	strings:
		$1 = { 53 8B 54 24 08 FF 06 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 0E 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 75 E0 8B C3 5B C3 }
	condition:
		$1
}

rule file_75_9_0 {
	meta:
		name = "__input_l"
		size = 3149
		refs = "000f ___security_cookie 0056 __errno 0066 __invalid_parameter 0085 __fileno 00a8 ___pioinfo 00be ___badioinfo 011e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 013d _isspace 0150 __whiteout 015f __ungetc_nolock 01b7 _isdigit 02e2 __inc 03ce ___check_float_string 05f3 __cfltcvt_tab 05f8 __decode_pointer 06cc _isleadbyte 0700 __mbtowc_l 0788 _memset 09d0 __allmul 09e0 _isxdigit 0bfc _free 0c41 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 74 FE FF FF 81 EC FC 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 88 01 00 00 8B 85 A0 01 00 00 53 56 8B B5 94 01 00 00 33 DB 57 8B BD 98 01 00 00 3B FB 89 45 A8 8D 45 08 89 75 EC 89 7D D8 89 45 DC C7 45 B4 5E 01 00 00 89 5D BC 89 5D A4 89 5D FC 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 C0 0B 00 00 3B F3 74 DC F6 46 0C 40 0F 85 91 00 00 00 56 E8 ?? ?? ?? ?? 83 F8 FF 59 74 2E 56 E8 ?? ?? ?? ?? 83 F8 FE 59 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 56 8D 3C 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 1F 6B C0 28 03 07 59 59 EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 75 8D 56 E8 ?? ?? ?? ?? 83 F8 FF 59 74 2E 56 E8 ?? ?? ?? ?? 83 F8 FE 59 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 56 8D 3C 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 1F 6B C0 28 03 07 59 59 EB 05 B8 ?? ?? ?? ?? F6 40 24 80 0F 85 44 FF FF FF 8B 7D D8 FF B5 9C 01 00 00 8D 4D 94 E8 ?? ?? ?? ?? 8A 07 84 C0 88 5D EB 89 5D 04 89 5D C4 0F 84 F0 0A 00 00 8B 7D D8 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 74 33 FF 75 EC FF 4D 04 8D 75 04 E8 ?? ?? ?? ?? 83 F8 FF 59 74 0B FF 75 EC 50 E8 ?? ?? ?? ?? 59 59 47 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 75 F1 E9 45 0A 00 00 80 3F 25 0F 85 E4 09 00 00 33 C0 89 45 AC 88 45 C3 89 45 E4 89 45 D4 89 45 F4 88 45 E8 88 45 E9 88 45 F3 88 45 03 88 45 EA 88 45 FB C6 45 F2 01 89 45 B8 33 F6 47 0F B6 1F 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 15 8B 45 F4 FF 45 D4 6B C0 0A 8D 44 18 D0 89 45 F4 E9 A0 00 00 00 83 FB 4E 7F 71 0F 84 95 00 00 00 83 FB 2A 74 61 83 FB 46 0F 84 87 00 00 00 83 FB 49 74 0A 83 FB 4C 75 62 FE 45 F2 EB 78 8A 4F 01 80 F9 36 75 15 8D 47 02 80 38 34 75 0D FF 45 B8 8B F8 89 75 CC 89 75 D0 EB 5B 80 F9 33 75 0C 8D 47 02 80 38 32 75 04 8B F8 EB 4A 80 F9 64 74 45 80 F9 69 74 40 80 F9 6F 74 3B 80 F9 78 74 36 80 F9 58 75 16 EB 2F FE 45 F3 EB 2A 83 FB 68 74 1F 83 FB 6C 74 0A 83 FB 77 74 10 FE 45 03 EB 16 8D 47 01 80 38 6C 74 A6 FE 45 F2 FE 45 FB EB 06 FE 4D F2 FE 4D FB 80 7D 03 00 0F 84 2F FF FF FF 80 7D F3 00 89 7D D8 75 0E 8B 45 A8 8B 30 89 45 90 83 C0 04 89 45 A8 80 7D FB 00 89 75 C8 C6 45 03 00 75 12 8A 07 3C 53 74 08 3C 43 C6 45 FB FF 75 04 C6 45 FB 01 0F B6 1F 83 CB 20 83 FB 6E 89 5D E0 74 35 83 FB 63 74 13 83 FB 7B 74 0E FF 75 EC 8D 75 04 E8 ?? ?? ?? ?? 59 EB 0B 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 83 F8 FF 89 45 FC 0F 84 00 09 00 00 8B 75 C8 8B 7D D8 8B 4D D4 85 C9 74 0A 83 7D F4 00 0F 84 C1 08 00 00 83 FB 6F 0F 8F 03 04 00 00 0F 84 28 06 00 00 83 FB 63 0F 84 E6 02 00 00 6A 64 58 3B D8 0F 84 14 06 00 00 0F 8E 0D 04 00 00 83 FB 67 7E 38 83 FB 69 74 1B 83 FB 6E 0F 85 FA 03 00 00 80 7D F3 00 8B 7D 04 0F 84 E8 07 00 00 E9 03 08 00 00 89 45 E0 8B 5D FC 83 FB 2D 0F 85 C2 04 00 00 C6 45 E9 01 E9 BE 04 00 00 33 DB 83 7D FC 2D 75 09 8B 45 DC C6 00 2D 43 EB 06 83 7D FC 2B 75 11 FF 4D F4 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 89 45 FC 83 7D D4 00 75 04 83 4D F4 FF 0F B6 45 FC EB 47 8B 45 F4 FF 4D F4 85 C0 74 48 8A 45 FC 8B 4D DC FF 45 E4 88 04 0B 8D 45 BC 50 8D 45 08 50 43 53 8D 7D DC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 15 08 00 00 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 89 45 FC 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 75 AE 8B 45 94 8B 80 BC 00 00 00 8B 00 8A 00 3A 45 FC 88 45 E8 0F 85 9D 00 00 00 8B 45 F4 FF 4D F4 85 C0 0F 84 8F 00 00 00 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 8B 4D DC 89 45 FC 8A 45 E8 88 04 0B 8D 45 BC 50 8D 45 08 50 43 53 8D 7D DC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 9B 07 00 00 0F B6 45 FC EB 47 8B 45 F4 FF 4D F4 85 C0 74 48 8B 45 DC 8A 4D FC FF 45 E4 88 0C 03 8D 45 BC 50 8D 45 08 50 43 53 8D 7D DC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 5F 07 00 00 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 89 45 FC 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 75 AE 83 7D E4 00 0F 84 F6 00 00 00 83 7D FC 65 74 0A 83 7D FC 45 0F 85 E6 00 00 00 8B 45 F4 FF 4D F4 85 C0 0F 84 D8 00 00 00 8B 45 DC C6 04 03 65 8D 45 BC 50 8D 45 08 50 43 53 8D 7D DC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 F4 06 00 00 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 83 F8 2D 89 45 FC 75 23 8B 45 DC C6 04 03 2D 8D 45 BC 50 8D 45 08 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 C0 06 00 00 EB 06 83 7D FC 2B 75 1D 8B 45 F4 FF 4D F4 85 C0 75 05 21 45 F4 EB 0E 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 89 45 FC 0F B6 45 FC EB 47 8B 45 F4 FF 4D F4 85 C0 74 48 8B 45 DC 8A 4D FC FF 45 E4 88 0C 03 8D 45 BC 50 8D 45 08 50 43 53 8D 7D DC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 5F 06 00 00 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 89 45 FC 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 75 AE FF 4D 04 83 7D FC FF 74 0D FF 75 EC FF 75 FC E8 ?? ?? ?? ?? 59 59 83 7D E4 00 0F 84 23 06 00 00 80 7D F3 00 0F 85 81 05 00 00 8B 45 DC FF 45 C4 8D 4D 94 51 50 FF 75 C8 C6 04 03 00 0F BE 45 F2 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 83 C4 10 E9 53 05 00 00 85 C9 75 0A FF 45 F4 C7 45 D4 01 00 00 00 80 7D FB 00 7E 04 C6 45 EA 01 FF 4D 04 83 7D FC FF 8B FE 74 0D FF 75 EC FF 75 FC E8 ?? ?? ?? ?? 59 59 83 7D D4 00 74 0E 8B 45 F4 FF 4D F4 85 C0 0F 84 B9 02 00 00 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 83 F8 FF 89 45 FC 0F 84 8F 02 00 00 83 FB 63 74 49 83 FB 73 75 13 83 F8 09 7C 09 83 F8 0D 0F 8E 77 02 00 00 83 F8 20 75 31 83 FB 7B 0F 85 69 02 00 00 0F BE 5D E8 33 D2 8B C8 83 E1 07 42 D3 E2 8B C8 C1 F9 03 0F BE 8C 0D 68 01 00 00 33 CB 85 D1 8B 5D E0 0F 84 41 02 00 00 80 7D F3 00 0F 85 31 02 00 00 80 7D EA 00 0F 84 1C 02 00 00 88 45 B0 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 74 0E 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 88 45 B1 8D 45 94 50 8B 45 94 C7 45 A4 3F 00 00 00 FF B0 AC 00 00 00 8D 45 B0 50 8D 45 A4 50 E8 ?? ?? ?? ?? 66 8B 45 A4 83 C4 10 66 89 06 46 46 E9 CE 01 00 00 8B C3 83 E8 70 0F 84 1C 02 00 00 83 E8 03 0F 84 EC FE FF FF 48 48 0F 84 0F 02 00 00 83 E8 03 0F 84 20 FC FF FF 83 E8 03 74 24 0F B6 07 3B 45 FC 0F 85 7F 04 00 00 FE 4D EB 80 7D F3 00 0F 85 02 04 00 00 8B 45 90 89 45 A8 E9 F7 03 00 00 80 7D FB 00 7E 04 C6 45 EA 01 47 80 3F 5E 8B F7 75 07 8D 77 01 C6 45 E8 FF 6A 20 8D 85 68 01 00 00 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 80 3E 5D 75 0C B2 5D 46 C6 85 73 01 00 00 20 EB 6F 8A 55 C3 EB 6A 46 3C 2D 75 48 84 D2 74 44 8A 0E 80 F9 5D 74 3D 46 3A D1 73 04 8A C1 EB 04 8A C2 8A D1 3A D0 77 28 2A C2 FE C0 0F B6 FA 0F B6 D0 8B CF 83 E1 07 8B C7 B3 01 D2 E3 C1 E8 03 8D 84 05 68 01 00 00 08 18 47 4A 75 E5 8B 5D E0 32 D2 EB 1D 0F B6 C8 8A D0 8B C1 83 E1 07 B3 01 D2 E3 C1 E8 03 8D 84 05 68 01 00 00 08 18 8B 5D E0 8A 06 3C 5D 75 90 84 C0 0F 84 D5 03 00 00 89 75 D8 8B 75 C8 E9 F7 FD FF FF 83 FB 2B 75 1F FF 4D F4 75 0A 85 C9 74 06 C6 45 03 01 EB 10 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 8B D8 89 5D FC 83 FB 30 0F 85 1D 01 00 00 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 8B D8 80 FB 78 89 5D FC 74 47 80 FB 58 74 42 83 7D E0 78 C7 45 E4 01 00 00 00 74 1A 83 7D D4 00 74 08 FF 4D F4 75 03 FE 45 03 C7 45 E0 6F 00 00 00 E9 DC 00 00 00 FF 4D 04 83 FB FF 74 0B FF 75 EC 53 E8 ?? ?? ?? ?? 59 59 6A 30 5B E9 BE 00 00 00 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 83 7D D4 00 8B D8 89 5D FC 74 0D 83 6D F4 02 83 7D F4 01 7D 03 FE 45 03 C7 45 E0 78 00 00 00 E9 92 00 00 00 88 06 46 89 75 C8 E9 4C FD FF FF 47 E9 46 FD FF FF FF 4D 04 83 F8 FF 74 0B FF 75 EC 50 E8 ?? ?? ?? ?? 59 59 3B FE 0F 84 E6 02 00 00 80 7D F3 00 0F 85 44 02 00 00 FF 45 C4 83 FB 63 0F 84 38 02 00 00 80 7D EA 00 8B 45 C8 74 09 66 83 20 00 E9 26 02 00 00 C6 00 00 E9 1E 02 00 00 C6 45 F2 01 8B 5D FC 83 FB 2D 75 06 C6 45 E9 01 EB 05 83 FB 2B 75 1F FF 4D F4 75 0A 85 C9 74 06 C6 45 03 01 EB 10 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 8B D8 89 5D FC 83 7D B8 00 0F 84 FB 00 00 00 80 7D 03 00 0F 85 CC 00 00 00 83 7D E0 78 74 4F 83 7D E0 70 74 49 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 9B 00 00 00 83 7D E0 6F 75 1B 83 FB 38 0F 8D 8C 00 00 00 8B 45 D0 8B 75 CC 0F A4 F0 03 C1 E6 03 89 45 D0 EB 4B 6A 00 6A 0A FF 75 D0 FF 75 CC E8 ?? ?? ?? ?? 8B F0 89 55 D0 EB 35 0F B6 FB 57 E8 ?? ?? ?? ?? 85 C0 59 74 56 8B 45 D0 8B 75 CC 0F A4 F0 04 57 C1 E6 04 89 45 D0 E8 ?? ?? ?? ?? 85 C0 59 0F BE DB 75 06 83 E3 DF 83 EB 07 89 5D FC FF 45 E4 8D 43 D0 99 03 F0 11 55 D0 83 7D D4 00 89 75 CC 74 05 FF 4D F4 74 28 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 8B D8 89 5D FC E9 47 FF FF FF FF 4D 04 83 FB FF 74 0B FF 75 EC 53 E8 ?? ?? ?? ?? 59 59 80 7D E9 00 8B 7D AC 0F 84 BB 00 00 00 8B 45 CC 8B 4D D0 F7 D8 83 D1 00 F7 D9 89 45 CC 89 4D D0 E9 A3 00 00 00 80 7D 03 00 8B 7D AC 0F 85 8E 00 00 00 83 7D E0 78 74 29 83 7D E0 70 74 23 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 61 83 7D E0 6F 75 0A 83 FB 38 7D 56 C1 E7 03 EB 2D 6B FF 0A EB 28 0F B6 F3 56 E8 ?? ?? ?? ?? 85 C0 59 74 3E 56 C1 E7 04 E8 ?? ?? ?? ?? 85 C0 59 0F BE DB 75 06 83 E3 DF 83 EB 07 89 5D FC FF 45 E4 83 7D D4 00 8D 7C 1F D0 74 05 FF 4D F4 74 25 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 8B D8 89 5D FC EB 85 FF 4D 04 83 FB FF 74 0B FF 75 EC 53 E8 ?? ?? ?? ?? 59 59 80 7D E9 00 74 02 F7 DF 83 7D E0 46 75 04 83 65 E4 00 83 7D E4 00 0F 84 C4 00 00 00 80 7D F3 00 75 26 FF 45 C4 8B 75 C8 83 7D B8 00 74 0D 8B 45 CC 89 06 8B 45 D0 89 46 04 EB 0D 80 7D F2 00 74 04 89 3E EB 03 66 89 3E 8B 7D D8 FE 45 EB 47 89 7D D8 EB 42 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 8B D8 0F B6 07 47 3B C3 89 5D FC 89 7D D8 75 5F 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 19 8B 55 EC FF 45 04 E8 ?? ?? ?? ?? 0F B6 0F 47 3B C8 89 7D D8 75 2B FF 4D 04 83 7D FC FF 75 10 80 3F 25 75 3F 8B 45 D8 80 78 01 6E 75 36 8B F8 8A 07 84 C0 0F 85 70 F5 FF FF EB 28 83 7D FC FF EB 13 83 F8 FF 74 0B FF 75 EC 50 E8 ?? ?? ?? ?? 59 59 83 FB FF 74 0D FF 75 EC FF 75 FC E8 ?? ?? ?? ?? 59 59 83 7D BC 01 75 09 FF 75 DC E8 ?? ?? ?? ?? 59 83 7D FC FF 75 1E 8B 45 C4 85 C0 75 08 38 45 EB 75 03 83 C8 FF 80 7D A0 00 74 19 8B 4D 9C 83 61 70 FD EB 10 80 7D A0 00 74 07 8B 45 9C 83 60 70 FD 8B 45 C4 8B 8D 88 01 00 00 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 81 C5 8C 01 00 00 C9 C3 }
	condition:
		$1
}

rule file_76_0_0 {
	meta:
		name = "__freebuf"
		size = 44
		refs = "0014 _free"
	strings:
		$1 = { 56 8B 74 24 08 8B 46 0C A8 83 74 1E A8 08 74 1A FF 76 08 E8 ?? ?? ?? ?? 81 66 0C F7 FB FF FF 33 C0 59 89 06 89 46 08 89 46 04 5E C3 }
	condition:
		$1
}

rule file_77_0_0 {
	meta:
		name = "_vscanf"
		size = 134
		refs = "0003 __sehtable$_vscanf 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0038 ___iob_func 003f __lock_file2 0070 __SEH_epilog4 007f __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 38 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 89 75 FC FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 50 FF 55 08 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 33 F6 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "_vwscanf"
		size = 134
		refs = "0003 __sehtable$_vwscanf 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0038 ___iob_func 003f __lock_file2 0070 __SEH_epilog4 007f __unlock_file2"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 38 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 89 75 FC FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 50 FF 55 08 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 33 F6 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_77_1_0 {
	meta:
		name = "_scanf"
		size = 25
		refs = "000c __input_l 0011 _vscanf"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_77_3_0 {
	meta:
		name = "_scanf_s"
		size = 25
		refs = "000c __input_s_l 0011 _vscanf"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_172_1_0 {
	meta:
		name = "_wscanf"
		size = 25
		refs = "000c __winput_l 0011 _vwscanf"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_172_3_0 {
	meta:
		name = "_wscanf_s"
		size = 25
		refs = "000c __winput_s_l 0011 _vwscanf"
	strings:
		$1 = { 8D 44 24 08 50 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_77_2_0 {
	meta:
		name = "__scanf_l"
		size = 27
		refs = "000e __input_l 0013 _vscanf"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_77_4_0 {
	meta:
		name = "__scanf_s_l"
		size = 27
		refs = "000e __input_s_l 0013 _vscanf"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_172_2_0 {
	meta:
		name = "__wscanf_l"
		size = 27
		refs = "000e __winput_l 0013 _vwscanf"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_172_4_0 {
	meta:
		name = "__wscanf_s_l"
		size = 27
		refs = "000e __winput_s_l 0013 _vwscanf"
	strings:
		$1 = { 8D 44 24 0C 50 FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_80_0_0 {
	meta:
		name = "_frexp"
		size = 218
		refs = "0011 __errno 0021 __invalid_parameter 003c __ctrlfp 005e __sptype 0080 __handle_qnan1 008b __d_ind 0096 __real@3ff0000000000000 00af __except1 00bf __decomp"
	strings:
		$1 = { 55 8B EC 51 51 53 57 8B 7D 10 33 DB 3B FB 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? D9 EE 83 C4 14 E9 A7 00 00 00 56 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? DD 45 08 89 45 10 8B 45 0E 66 25 F0 7F 66 3D F0 7F 59 59 75 63 83 0F FF 51 51 DD 1C 24 E8 ?? ?? ?? ?? 3B C3 59 59 7E 29 83 F8 02 7E 1C 83 F8 03 75 1F FF 75 10 DD 45 08 51 51 DD 1C 24 6A 17 E8 ?? ?? ?? ?? 83 C4 10 EB 4C DD 05 ?? ?? ?? ?? EB 09 DD 45 08 DC 05 ?? ?? ?? ?? FF 75 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 17 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 1D 57 51 51 DD 1C 24 E8 ?? ?? ?? ?? 56 DD 5D F8 FF 75 10 E8 ?? ?? ?? ?? DD 45 F8 83 C4 14 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_81_0_0 {
	meta:
		name = "__wgetpath"
		size = 174
		refs = "0020 __errno"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 6A 02 59 6A 3B 5A EB 02 03 F1 66 39 16 74 F9 FF 4D 10 89 75 08 75 10 E8 ?? ?? ?? ?? 8B 7D 0C C7 00 22 00 00 00 EB 6C 0F B7 06 66 85 C0 8B 7D 0C 53 74 5A 6A 22 5B 66 3B C2 74 50 03 F1 66 3B C3 74 16 66 89 07 03 F9 FF 4D 10 75 35 89 75 08 E8 ?? ?? ?? ?? 89 18 EB 3A 0F B7 06 66 85 C0 74 2D 66 3B C3 74 14 66 89 07 03 F9 03 F1 FF 4D 10 74 DB 0F B7 06 66 85 C0 75 E7 66 83 3E 00 74 0E 03 F1 0F B7 06 66 85 C0 75 AD EB 02 03 F1 66 39 16 74 F9 5B 8B 45 08 66 83 27 00 2B C6 F7 D8 1B C0 5F 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "__mbclen_l"
		size = 40
		refs = "000e __ismbblead_l"
	strings:
		$1 = { 56 8B 74 24 08 0F B6 06 FF 74 24 0C 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 0B 80 7E 01 00 74 05 6A 02 58 5E C3 33 C0 40 5E C3 }
	condition:
		$1
}

rule file_82_1_0 {
	meta:
		name = "__mbclen"
		size = 35
		refs = "000a __ismbblead"
	strings:
		$1 = { 56 8B 74 24 08 0F B6 06 50 E8 ?? ?? ?? ?? 85 C0 59 74 0B 80 7E 01 00 74 05 6A 02 58 5E C3 33 C0 40 5E C3 }
	condition:
		$1
}

rule file_83_0_0 {
	meta:
		name = "__wfdopen"
		size = 404
		refs = "0003 __sehtable$__wfdopen 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 0056 __nhandle 0077 ___pioinfo 00b1 __commode 0146 __getstream 0168 __cflush 0184 __SEH_epilog4 018e __unlock_file"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C9 8B 45 0C 33 FF 3B C7 0F 95 C1 3B CF 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 48 01 00 00 8B 4D 08 83 F9 FE 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB E4 3B CF 7C 08 3B 0D ?? ?? ?? ?? 72 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB BE 8B D1 C1 FA 05 83 E1 1F 6B C9 28 8B 14 95 ?? ?? ?? ?? 0F B6 4C 0A 04 33 D2 42 23 CA 74 D5 EB 02 40 40 66 83 38 20 74 F8 0F B7 08 83 F9 61 74 0E 83 F9 72 74 19 83 F9 77 0F 85 75 FF FF FF 6A 02 5B 33 F6 89 7D 0C 0B 1D ?? ?? ?? ?? EB 68 8B DA EB EF 3B D7 74 6E 0F B7 C9 83 E9 20 74 58 83 E9 0B 74 42 83 E9 37 74 11 49 74 2B 83 E9 0B 74 17 83 E9 06 0F 85 3A FF FF FF 39 7D 0C 75 2B C7 45 0C 01 00 00 00 EB 2F 3B F7 75 1E 33 F6 46 81 E3 FF BF FF FF EB 20 3B F7 75 0F 33 F6 46 81 CB 00 40 00 00 EB 11 84 DB 79 04 33 D2 EB 09 83 E3 FC 81 CB 80 00 00 00 40 40 0F B7 08 66 3B CF 75 92 EB 02 40 40 66 83 38 20 74 F8 33 C9 66 39 38 0F 94 C1 8B C1 3B C7 0F 84 D7 FE FF FF E8 ?? ?? ?? ?? 8B F0 89 75 0C 3B F7 75 10 E8 ?? ?? ?? ?? C7 00 18 00 00 00 E9 D1 FE FF FF 89 7D FC FF 05 ?? ?? ?? ?? 89 5E 0C 8B 45 08 89 46 10 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "__ms_p5_test_fdiv"
		size = 60
		refs = "0008 __real@4147ffff80000000 0011 __real@4150017ec0000000"
	strings:
		$1 = { 55 8B EC 83 EC 18 DD 05 ?? ?? ?? ?? DD 5D F0 DD 05 ?? ?? ?? ?? DD 5D E8 DD 45 E8 DC 75 F0 DC 4D F0 DC 6D E8 DD 5D F8 D9 E8 DC 5D F8 DF E0 F6 C4 05 7A 05 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "__ms_p5_mp_test_fdiv"
		size = 41
		refs = "0001 ??_C@_08CPNIBGIE@KERNEL32?$AA@ 0007 __imp__GetModuleHandleA@4 0010 ??_C@_0BK@NHEOCAHP@IsProcessorFeaturePresent?$AA@ 0017 __imp__GetProcAddress@8 0025 __ms_p5_test_fdiv"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 15 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 05 6A 00 FF D0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_86_0_0 {
	meta:
		name = "__putws"
		size = 231
		refs = "0003 __sehtable$__putws 0008 __SEH_prolog4 0023 __errno 0033 __invalid_parameter 0042 ___iob_func 004d __lock_file2 0060 __stbuf 0081 __fputwc_nolock 00b9 __ftbuf 00cf __SEH_epilog4 00e0 __unlock_file2"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE FF FF 00 00 89 75 E4 33 C0 33 DB 39 5D 08 0F 95 C0 3B C3 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 8D 00 00 00 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 89 5D FC E8 ?? ?? ?? ?? 83 C0 20 50 E8 ?? ?? ?? ?? 59 89 45 E0 8B 45 08 0F B7 00 66 3B C3 74 1F 0F B7 F8 E8 ?? ?? ?? ?? 83 C0 20 50 57 E8 ?? ?? ?? ?? 59 59 83 45 08 02 66 3B C6 74 1C EB D6 E8 ?? ?? ?? ?? 83 C0 20 50 6A 0A E8 ?? ?? ?? ?? 59 59 66 3B C6 74 03 89 5D E4 E8 ?? ?? ?? ?? 83 C0 20 50 FF 75 E0 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? 83 C0 20 50 6A 01 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_87_3_0 {
	meta:
		name = "__mbsnccnt_l"
		size = 137
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0024 __errno 0034 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 08 8B 75 0C 33 DB 3B CB 75 2C 3B F3 74 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 3A 33 C0 3B F3 74 28 57 8A 11 4E 3A D3 74 1F 8B 7D F4 0F B6 D2 F6 44 3A 1D 04 74 0C 8B D6 4E 85 D2 74 0B 41 38 19 74 06 40 41 3B F3 75 DA 5F 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "__cgets_s"
		size = 261
		refs = "0003 __sehtable$__cgets_s 0008 __SEH_prolog4 0020 ___doserrno 0027 __errno 0036 __invalid_parameter 0065 __lock 007d __cgetws_s 00a0 _wctomb_s 00c5 ___console_wchar_buffer 00cb ___console_wchar_buffer_used 00f5 __SEH_epilog4 00ff __unlock"
	strings:
		$1 = { 6A 1C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E0 33 C9 8B 45 08 3B C3 0F 95 C1 3B CB 75 23 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E9 B0 00 00 00 33 D2 8B 4D 0C 3B D1 1B D2 F7 DA 74 D0 88 18 33 C0 8B 75 10 3B F3 0F 95 C0 3B C3 74 C0 8D 79 FF 6A 03 E8 ?? ?? ?? ?? 59 89 5D FC 89 1E 89 5D D8 8D 45 D8 50 6A 02 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E0 3B C3 75 48 89 5D DC 66 39 5D E4 74 3F FF 75 E4 57 FF 75 08 8D 45 DC 50 E8 ?? ?? ?? ?? 83 C4 10 89 45 E0 3B C3 75 11 8B 45 DC 01 45 08 01 06 2B F8 89 7D D4 75 B2 EB 14 66 8B 45 E4 66 A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 01 00 00 00 C7 45 FC FE FF FF FF E8 1D 00 00 00 8B 45 08 88 18 8B 75 E0 3B F3 74 07 E8 ?? ?? ?? ?? 89 30 8B C6 E8 ?? ?? ?? ?? C3 33 DB 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_88_1_0 {
	meta:
		name = "__cgets"
		size = 91
		refs = "0013 ___doserrno 001a __errno 002a __invalid_parameter 0042 __cgets_s"
	strings:
		$1 = { 55 8B EC 51 56 8B 75 08 57 33 FF 3B F7 89 7D FC 75 23 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 22 0F BE 06 8D 4D FC 51 50 8D 7E 02 57 E8 ?? ?? ?? ?? 8A 4D FC 83 C4 0C F7 D8 1B C0 F7 D0 88 4E 01 23 C7 5F 5E C9 C3 }
	condition:
		$1
}

rule file_91_5_0 {
	meta:
		name = "_fast_error_exit"
		size = 36
		refs = "0002 ___error_mode 000a __FF_MSGBANNER 0013 __NMSG_WRITE 001d ___crtExitProcess"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 01 75 05 E8 ?? ?? ?? ?? FF 74 24 04 E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_91_6_0 {
	meta:
		name = "_check_managed_app"
		size = 65
		refs = "0003 ___ImageBase"
	strings:
		$1 = { 66 81 3D ?? ?? ?? ?? 4D 5A 75 33 A1 ?? ?? ?? ?? 81 B8 ?? ?? ?? ?? 50 45 00 00 75 22 66 81 B8 ?? ?? ?? ?? 0B 01 75 17 83 B8 ?? ?? ?? ?? 0E 76 0E 33 C9 39 88 ?? ?? ?? ?? 0F 95 C1 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_91_7_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 480
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 0016 __imp__GetStartupInfoA@4 002b __imp__GetProcessHeap@0 0034 __imp__HeapAlloc@12 0041 _fast_error_exit 0050 __imp__GetVersionExA@4 0060 __imp__HeapFree@12 00aa __osplatform 00af __winver 00b5 __winmajor 00bb __winminor 00c1 __osver 00c6 _check_managed_app 00d2 __heap_init 00e4 __mtinit 00f5 __RTC_Initialize 00fd __ioinit 0108 __amsg_exit 010f __imp__GetCommandLineA@0 0114 __acmdln 0119 ___crtGetEnvironmentStringsA 011e __aenvptr 0123 __setargv 0134 __setenvp 0146 __cinit 0157 __wincmdln 016e ___ImageBase 0173 _WinMain@16 0182 _exit 0187 __cexit 019a __XcptFilter 01b2 __exit 01b7 __c_exit 01db __SEH_epilog4"
	strings:
		$1 = { 6A 60 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 8D 45 90 50 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF BF 94 00 00 00 57 6A 00 8B 1D ?? ?? ?? ?? FF D3 50 FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 0D 6A 12 E8 ?? ?? ?? ?? 59 E9 8A 01 00 00 89 3E 56 FF 15 ?? ?? ?? ?? 56 6A 00 85 C0 75 0E FF D3 50 FF 15 ?? ?? ?? ?? E9 6C 01 00 00 8B 46 10 89 45 E0 8B 46 04 89 45 DC 8B 46 08 89 45 D8 8B 7E 0C 81 E7 FF 7F 00 00 FF D3 50 FF 15 ?? ?? ?? ?? 8B 75 E0 83 FE 02 74 06 81 CF 00 80 00 00 8B 4D DC 8B C1 C1 E0 08 8B 55 D8 03 C2 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 33 DB 43 53 E8 ?? ?? ?? ?? 59 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 89 5D FC E8 ?? ?? ?? ?? 85 C0 7D 08 6A 1B E8 ?? ?? ?? ?? 59 FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 7D 08 6A 09 E8 ?? ?? ?? ?? 59 53 E8 ?? ?? ?? ?? 59 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 84 5D BC 74 06 0F B7 4D C0 EB 03 6A 0A 59 51 50 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E4 83 7D E0 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2E 8B 45 EC 8B 08 8B 09 89 4D D4 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 45 D4 89 45 E4 83 7D E0 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E4 EB 13 33 C0 40 C3 8B 65 E8 C7 45 FC FE FF FF FF B8 FF 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_92_1_0 {
	meta:
		name = "__getenv_helper_nolock"
		size = 129
		refs = "0002 ___env_initialized 000a __environ 001c __wenviron 0023 ___wtomb_environ 003f _strlen 005f __mbsnbicoll"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 56 8B 35 ?? ?? ?? ?? 75 04 33 C0 5E C3 85 F6 53 57 75 1B 39 35 ?? ?? ?? ?? 74 51 E8 ?? ?? ?? ?? 85 C0 75 48 8B 35 ?? ?? ?? ?? 85 F6 74 3E 8B 5C 24 10 85 DB 74 36 53 E8 ?? ?? ?? ?? 59 8B F8 EB 25 50 E8 ?? ?? ?? ?? 3B C7 59 76 17 8B 06 80 3C 38 3D 75 0F 57 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 83 C6 04 8B 06 85 C0 75 D5 33 C0 5F 5B 5E C3 8B 06 8D 44 38 01 EB F4 }
	condition:
		$1
}

rule file_92_2_0 {
	meta:
		name = "__getenv_s_helper"
		size = 147
		refs = "000e __errno 001d __invalid_parameter 0048 __getenv_helper_nolock 0055 _strlen 0074 _strcpy_s 0085 __invoke_watson"
	strings:
		$1 = { 55 8B EC 53 56 8B F0 33 DB 3B F3 75 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 67 8B 45 08 3B C3 89 1E 74 07 39 5D 0C 77 07 EB D5 39 5D 0C 75 D0 3B C3 74 02 88 18 57 FF 75 10 E8 ?? ?? ?? ?? 8B F8 3B FB 59 74 39 57 E8 ?? ?? ?? ?? 40 39 5D 0C 59 89 06 74 2A 3B 45 0C 76 05 6A 22 58 EB 22 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_92_3_0 {
	meta:
		name = "__dupenv_s_helper"
		size = 162
		refs = "000d __errno 001c __invalid_parameter 003b __getenv_helper_nolock 0049 _strlen 0054 _calloc 007b _strcpy_s 008c __invoke_watson"
	strings:
		$1 = { 55 8B EC 51 56 57 33 FF 3B DF 75 1B E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 77 8B 45 08 3B C7 89 3B 74 02 89 38 39 7D 0C 74 D5 FF 75 0C E8 ?? ?? ?? ?? 3B C7 59 89 45 FC 74 55 50 E8 ?? ?? ?? ?? 8B F0 46 6A 01 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 89 03 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 29 FF 75 FC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 3B C7 74 02 89 30 33 C0 5F 5E C9 C3 }
	condition:
		$1
}

rule file_92_4_0 {
	meta:
		name = "_getenv"
		size = 131
		refs = "0003 __sehtable$_getenv 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0040 _strnlen 0051 __lock 005d __getenv_helper_nolock 0075 __SEH_epilog4 007d __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 3E BF FF 7F 00 00 57 FF 75 08 E8 ?? ?? ?? ?? 59 59 3B C7 1B C0 F7 D8 74 CC 6A 07 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_152_4_0 {
	meta:
		name = "__wgetenv"
		size = 131
		refs = "0003 __sehtable$__wgetenv 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 0040 _wcsnlen 0051 __lock 005d __wgetenv_helper_nolock 0075 __SEH_epilog4 007d __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 3E BF FF 7F 00 00 57 FF 75 08 E8 ?? ?? ?? ?? 59 59 3B C7 1B C0 F7 D8 74 CC 6A 07 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_92_5_0 {
	meta:
		name = "_getenv_s"
		size = 216
		refs = "0003 __sehtable$_getenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0037 __invalid_parameter 006f __getenv_helper_nolock 007c _strlen 009f _strcpy_s 00b0 __invoke_watson 00ca __SEH_epilog4 00d2 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 DB 89 5D FC 33 C0 8B 7D 08 3B FB 0F 95 C0 3B C3 75 1C E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 89 75 E4 EB 77 89 1F 8B 4D 0C 3B CB 74 09 39 5D 10 77 09 3B CB 75 0A 39 5D 10 75 05 33 C0 40 EB 02 33 C0 3B C3 74 C2 3B CB 74 02 88 19 FF 75 14 E8 ?? ?? ?? ?? 59 8B F0 3B F3 74 3D 56 E8 ?? ?? ?? ?? 59 40 89 07 39 5D 10 74 2E 3B 45 10 76 09 C7 45 E4 22 00 00 00 EB 23 56 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 89 5D E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_92_6_0 {
	meta:
		name = "__dupenv_s"
		size = 230
		refs = "0003 __sehtable$__dupenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0037 __invalid_parameter 0061 __getenv_helper_nolock 006f _strlen 007a _calloc 00a4 _strcpy_s 00b5 __invoke_watson 00d8 __SEH_epilog4 00e0 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC 33 C0 8B 5D 08 3B DE 0F 95 C0 3B C6 75 1F E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 89 7D E4 E9 82 00 00 00 89 33 8B 45 0C 3B C6 74 02 89 30 33 C0 39 75 10 0F 95 C0 3B C6 74 CA FF 75 10 E8 ?? ?? ?? ?? 59 89 45 E0 3B C6 74 58 50 E8 ?? ?? ?? ?? 8B F8 47 6A 01 57 E8 ?? ?? ?? ?? 83 C4 0C 89 03 3B C6 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 E4 EB 2A FF 75 E0 57 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B 45 0C 3B C6 74 02 89 38 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_94_3_0 {
	meta:
		name = "__mbsnbicmp_l"
		size = 562
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 003e __strnicmp 0060 __errno 0070 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 FF 75 14 8D 4D E8 E8 ?? ?? ?? ?? 33 DB 39 5D 10 75 13 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 E9 BB 01 00 00 8B 45 EC 39 58 08 75 26 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F4 0F 84 99 01 00 00 8B 4D F0 83 61 70 FD E9 8D 01 00 00 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD B8 FF FF FF 7F E9 5A 01 00 00 57 8B 7D 0C 3B FB 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD B8 FF FF FF 7F E9 23 01 00 00 56 8B 4D 08 66 0F B6 09 FF 4D 10 FF 45 08 0F B7 C9 89 4D F8 0F B6 C9 F6 44 01 1D 04 0F 84 90 00 00 00 39 5D 10 75 23 0F B6 0F F6 44 01 1D 04 89 5D F8 0F 85 DC 00 00 00 66 8B F3 0F B7 C9 89 4D FC 66 8B 4D FC E9 B7 00 00 00 8B 4D 08 8A 09 3A CB 75 05 89 5D F8 EB 75 33 D2 8A 75 F8 FF 45 08 8A D1 0F B7 CA 66 8B F1 66 3B 70 10 89 4D F8 72 2F 66 3B 70 12 77 29 66 03 70 14 33 DB 66 0F B6 0F 0F B7 C9 89 4D FC 0F B6 C9 47 F6 44 01 1D 04 0F 84 A3 00 00 00 39 5D 10 75 3D 89 5D FC EB A1 66 3B 70 16 72 D5 66 3B 70 18 77 CF 66 03 70 1A EB C9 0F B7 55 F8 8D 0C 02 F6 41 1D 10 74 14 66 0F B6 89 1D 01 00 00 0F B7 C9 89 4D F8 66 8B 75 F8 EB AA 0F B7 CA EB F2 8A 0F FF 4D 10 3A CB 74 BA 33 D2 8A 75 FC 47 8A D1 0F B7 CA 66 3B 48 10 89 4D FC 72 32 66 3B 48 12 77 2C 66 03 48 14 33 DB 66 3B CE 75 55 66 3B F3 74 09 39 5D 10 0F 85 ED FE FF FF 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 5E 5F 5B C9 C3 66 3B 48 16 72 D2 66 3B 48 18 77 CC 66 03 48 1A EB C6 0F B7 55 FC 8D 0C 02 F6 41 1D 10 74 0D 66 0F B6 89 1D 01 00 00 E9 E8 FE FF FF 0F B7 CA E9 E3 FE FF FF 1B C0 83 E0 02 48 38 5D F4 74 BC 8B 4D F0 83 61 70 FD EB B3 }
	condition:
		$1
}

rule file_95_0_0 {
	meta:
		name = "__swab"
		size = 83
		refs = "000c __errno 001c __invalid_parameter"
	strings:
		$1 = { 8B 4C 24 04 56 33 F6 3B CE 75 1A E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 5E C3 8B 44 24 0C 3B C6 74 DE 8B 54 24 10 3B D6 7C D6 83 FA 01 7E 17 8D 72 FE D1 EE 46 53 8A 11 41 8A 19 41 88 18 40 88 10 40 4E 75 F1 5B 5E C3 }
	condition:
		$1
}

rule file_97_0_0 {
	meta:
		name = "?_open@@YAHPBDHH@Z"
		size = 43
		refs = "0016 __sopen_helper"
	strings:
		$1 = { 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_97_2_0 {
	meta:
		name = "?_wopen@@YAHPB_WHH@Z"
		size = 43
		refs = "0016 __wsopen_helper"
	strings:
		$1 = { 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 10 6A 40 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_97_1_0 {
	meta:
		name = "?_sopen@@YAHPBDHHH@Z"
		size = 44
		refs = "0017 __sopen_helper"
	strings:
		$1 = { 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_97_3_0 {
	meta:
		name = "?_wsopen@@YAHPB_WHHH@Z"
		size = 44
		refs = "0017 __wsopen_helper"
	strings:
		$1 = { 55 8B EC 51 6A 00 8D 45 FC 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 05 83 C8 FF C9 C3 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_99_0_0 {
	meta:
		name = "__execlpe"
		size = 87
		refs = "000c __errno 001c __invalid_parameter 004e __execvpe"
	strings:
		$1 = { 8B 4C 24 04 53 33 DB 3B CB 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5B C3 38 19 74 DF 8B 44 24 0C 3B C3 74 D7 38 18 74 D3 8D 44 24 0C 8B 10 83 C0 04 85 D2 75 F7 FF 30 8D 44 24 10 50 51 E8 ?? ?? ?? ?? 83 C4 0C 5B C3 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "__fcloseall"
		size = 159
		refs = "0003 __sehtable$__fcloseall 0008 __SEH_prolog4 0014 __lock 0024 __nstream 0030 ___piob 0044 _fclose 0064 __imp__DeleteCriticalSection@4 0071 _free 0091 __SEH_epilog4 0099 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 6A 01 E8 ?? ?? ?? ?? 59 89 5D FC 6A 03 5F 89 7D E0 3B 3D ?? ?? ?? ?? 7D 57 8B F7 C1 E6 02 A1 ?? ?? ?? ?? 03 C6 39 18 74 44 8B 00 F6 40 0C 83 74 0F 50 E8 ?? ?? ?? ?? 59 83 F8 FF 74 03 FF 45 E4 83 FF 14 7C 28 A1 ?? ?? ?? ?? 8B 04 06 83 C0 20 50 FF 15 ?? ?? ?? ?? A1 ?? ?? ?? ?? FF 34 06 E8 ?? ?? ?? ?? 59 A1 ?? ?? ?? ?? 89 1C 06 47 EB 9E C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 01 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "__snwprintf"
		size = 173
		refs = "000f __errno 001f __invalid_parameter 006b __woutput_l 0089 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 33 DB 39 5D 10 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 7F 8B 4D 0C 3B CB 8B 45 08 74 04 3B C3 74 D5 81 F9 FF FF FF 3F C7 45 EC 42 00 00 00 89 45 E8 89 45 E0 76 09 C7 45 E4 FF FF FF 7F EB 06 8D 04 09 89 45 E4 56 8D 45 14 50 53 FF 75 10 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 0A 8B 45 E0 88 18 FF 45 E0 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_101_1_0 {
	meta:
		name = "__snwprintf_l"
		size = 29
		refs = "0014 __vsnwprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_834_1_0 {
	meta:
		name = "__snprintf_c_l"
		size = 29
		refs = "0014 __vsnprintf_c_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_454_1_0 {
	meta:
		name = "__snprintf_l"
		size = 29
		refs = "0014 __vsnprintf_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_249_7_0 {
	meta:
		name = "__sprintf_p_l"
		size = 29
		refs = "0014 __vsprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_249_3_0 {
	meta:
		name = "__sprintf_s_l"
		size = 29
		refs = "0014 __vsprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_403_1_0 {
	meta:
		name = "__swprintf_c_l"
		size = 29
		refs = "0014 __vswprintf_c_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_244_7_0 {
	meta:
		name = "__swprintf_p_l"
		size = 29
		refs = "0014 __vswprintf_p_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_244_5_0 {
	meta:
		name = "__swprintf_s_l"
		size = 29
		refs = "0014 __vswprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "___libm_sse2_sincosf"
		size = 517
		refs = "0023 _PI32INV 002f _SHIFTER 003f _P_1 004b _P_2 0064 _SC_4 006a _Ctable 007f _P_3 00a0 _SC_2 00f2 _SC_3 00fe _SC_1 0186 _ONE 0194 _ALL_ONES 01a5 _TWO_POW_55 01b5 _TWO_POW_M55 01da _cos 01ee _sin"
	strings:
		$1 = { F3 0F 5A C0 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 53 01 00 00 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 59 C8 66 0F 28 15 ?? ?? ?? ?? F2 0F 2D D1 66 0F 58 CA 66 0F 28 1D ?? ?? ?? ?? 66 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D9 81 C2 00 76 1C 00 66 0F 28 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 06 03 C2 66 0F 59 D1 66 0F 5C C3 66 0F 59 0D ?? ?? ?? ?? 66 0F 5C E3 66 0F 28 78 10 66 0F 28 DC 66 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? 66 0F 59 FC 66 0F 5C DC 66 0F 59 E8 66 0F 59 C0 66 0F 5C DA 66 0F 28 10 66 0F 5C CB 66 0F 28 58 30 66 0F 58 D3 66 0F 5C FA 66 0F 59 CF 66 0F 28 78 10 66 0F 59 D4 66 0F 59 F0 66 0F 59 DC 66 0F 59 D0 66 0F 59 F8 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 66 0F 28 C3 66 0F 58 58 10 66 0F 58 F5 F2 0F 10 EE 66 0F 15 F6 66 0F 14 ED 66 0F 59 F7 66 0F 59 D5 66 0F 28 FC 66 0F 58 E3 66 0F 28 68 10 66 0F 5C EB 66 0F 5C DC 66 0F 58 48 20 66 0F 58 E8 66 0F 58 DF 66 0F 58 CD 66 0F 58 CB 66 0F 58 CA 66 0F 58 CE 66 0F 58 CC F2 0F 10 C1 66 0F 15 C9 F2 0F 5A C0 F2 0F 5A C9 C3 7F 52 F2 0F 10 C8 66 0F C5 C0 03 66 0D 00 80 66 0F C4 C8 03 F2 0F 58 0D ?? ?? ?? ?? 66 3D 10 80 7D 11 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 F2 0F 5A C9 C3 F2 0F 10 1D ?? ?? ?? ?? F2 0F 59 D8 F2 0F 5C C3 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 F2 0F 5A C9 C3 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 5C 24 18 F3 0F 7E 44 24 10 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 66 0F 6E 04 24 66 0F 6E 4C 24 18 8B 64 24 08 C3 }
	condition:
		$1
}

rule file_103_0_0 {
	meta:
		name = "_xtow@16"
		size = 78
	strings:
		$1 = { 83 7C 24 08 00 74 0A 66 C7 01 2D 00 83 C1 02 F7 D8 56 8B F1 33 D2 F7 74 24 08 83 FA 09 76 05 83 C2 57 EB 03 83 C2 30 66 89 11 41 41 85 C0 77 E4 66 83 21 00 49 49 66 8B 16 0F B7 01 66 89 11 49 66 89 06 49 46 46 3B F1 72 EC 5E C2 08 00 }
	condition:
		$1
}

rule file_103_4_0 {
	meta:
		name = "@x64tow@20"
		size = 118
		refs = "002e __aulldvrm"
	strings:
		$1 = { 55 8B EC 83 7D 14 00 53 8B 5D 08 56 8B F0 8B 45 0C 57 74 0F 66 C7 06 2D 00 83 C6 02 F7 DB 83 D0 00 F7 D8 8B FE 33 C9 51 FF 75 10 50 53 E8 ?? ?? ?? ?? 83 F9 09 89 5D 0C 8B D8 8B C2 76 05 83 C1 57 EB 03 83 C1 30 66 89 0E 46 46 85 C0 77 D6 72 04 85 DB 77 D0 66 83 26 00 4E 4E 66 8B 0F 0F B7 06 66 89 0E 4E 66 89 07 4E 47 47 3B FE 72 EC 5F 5E 5B 5D C2 10 00 }
	condition:
		$1
}

rule file_104_0_0 {
	meta:
		name = "__splitpath_s"
		size = 545
		refs = "00a3 _strncpy_s 00d6 __ismbblead 01d4 __errno 01e7 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 51 53 8B 5D 08 56 57 33 FF 3B DF 89 7D FC 0F 84 9D 00 00 00 8B 4D 0C 3B CF 75 0B 39 7D 10 0F 85 8D 00 00 00 EB 09 39 7D 10 0F 84 82 00 00 00 39 7D 14 75 07 39 7D 18 75 78 EB 05 39 7D 18 74 71 39 7D 1C 75 07 39 7D 20 75 67 EB 05 39 7D 20 74 60 39 7D 24 75 56 39 7D 28 75 56 80 3B 5C 75 15 80 7B 01 5C 75 0F 80 7B 02 3F 75 09 80 7B 03 5C 75 03 83 C3 04 33 C0 40 8B F3 80 3E 00 74 06 48 46 3B C7 77 F5 80 3E 3A 75 33 3B CF 74 19 83 7D 10 03 0F 82 FC 00 00 00 6A 02 53 FF 75 10 51 E8 ?? ?? ?? ?? 83 C4 10 8D 5E 01 EB 18 39 7D 28 75 AA C7 45 FC 01 00 00 00 E9 D7 00 00 00 3B CF 74 03 C6 01 00 21 7D 08 80 3B 00 8B F3 74 58 0F BE 06 50 E8 ?? ?? ?? ?? 85 C0 59 74 03 46 EB 16 8A 06 3C 2F 74 0D 3C 5C 74 09 3C 2E 75 08 89 75 08 EB 03 8D 7E 01 46 80 3E 00 75 D3 85 FF 74 27 83 7D 14 00 74 1D 8B C7 2B C3 39 45 18 0F 86 80 00 00 00 50 53 FF 75 18 FF 75 14 E8 ?? ?? ?? ?? 83 C4 10 8B DF EB 0A 8B 45 14 85 C0 74 03 C6 00 00 8B 45 08 85 C0 74 4A 3B C3 72 46 83 7D 1C 00 74 17 2B C3 39 45 20 76 4A 50 53 FF 75 20 FF 75 1C E8 ?? ?? ?? ?? 83 C4 10 83 7D 24 00 0F 84 B5 00 00 00 2B 75 08 39 75 28 76 28 56 FF 75 08 FF 75 28 FF 75 24 E8 ?? ?? ?? ?? 83 C4 10 E9 96 00 00 00 83 7D 1C 00 0F 84 82 00 00 00 2B F3 39 75 20 77 6B 33 FF 8B 45 0C 3B C7 74 08 39 7D 10 76 03 C6 00 00 8B 45 14 3B C7 74 08 39 7D 18 76 03 C6 00 00 8B 45 1C 3B C7 74 08 39 7D 20 76 03 C6 00 00 8B 45 24 3B C7 74 08 39 7D 28 76 03 C6 00 00 E8 ?? ?? ?? ?? 3B DF 75 16 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 2A 39 7D FC 75 E5 6A 22 59 89 08 8B C1 EB 1C 56 53 FF 75 20 FF 75 1C E8 ?? ?? ?? ?? 83 C4 10 8B 45 24 85 C0 74 03 C6 00 00 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "__fseek_nolock"
		size = 135
		refs = "000f __errno 002c __ftell_nolock 003a __flush 006b __fileno 0072 __lseek"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 8B 46 0C A8 83 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF EB 66 83 E0 EF 83 7D 10 01 89 46 0C 75 0E 56 E8 ?? ?? ?? ?? 01 45 0C 83 65 10 00 59 56 E8 ?? ?? ?? ?? 8B 46 0C 84 C0 59 79 08 83 E0 FC 89 46 0C EB 15 A8 01 74 11 A8 08 74 0D 66 A9 00 04 75 07 C7 46 18 00 02 00 00 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 33 C9 83 C4 0C 83 F8 FF 0F 95 C1 49 8B C1 5E 5D C3 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "_fseek"
		size = 133
		refs = "0003 __sehtable$_fseek 0008 __SEH_prolog4 001b __errno 002b __invalid_parameter 004c __lock_file 005c __fseek_nolock 0076 __SEH_epilog4 007f __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 08 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 3E 8B 7D 10 3B FE 74 0A 83 FF 01 74 05 83 FF 02 75 D2 FF 75 08 E8 ?? ?? ?? ?? 59 89 75 FC 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_107_3_0 {
	meta:
		name = "__mbbtombc_l"
		size = 160
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 003e _mbbtable 006c _mbctable"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 74 12 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 8B 45 08 C9 C3 8B 45 08 8D 48 E0 83 F9 5E 77 0A 0F B7 04 45 ?? ?? ?? ?? EB 4D 3D DC 00 00 00 75 14 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD B8 8F 83 00 00 C9 C3 8D 88 5F FF FF FF 83 F9 3E 77 27 8A 0D ?? ?? ?? ?? 33 D2 EB 0F 0F B6 C9 3B C1 74 0E 8A 0C 95 ?? ?? ?? ?? 42 84 C9 75 ED EB 08 0F B7 04 95 ?? ?? ?? ?? 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_107_5_0 {
	meta:
		name = "__mbctombb_l"
		size = 189
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 003b _mbbtable 0056 _mbctable"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 74 12 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 8B 45 08 C9 C3 8B 45 08 53 33 DB 33 C9 0F B7 14 4D ?? ?? ?? ?? 3B C2 74 50 41 83 F9 5E 7E EE 3D 96 83 00 00 56 57 77 5A 33 FF 38 1D ?? ?? ?? ?? 74 50 33 D2 0F B7 B2 ?? ?? ?? ?? 8B C8 2B CE 74 39 33 F0 66 F7 C6 00 FF 75 0F 3B CB 7E 0B 0F BE 92 ?? ?? ?? ?? 2B CA 78 21 47 8B D7 C1 E2 02 38 9A ?? ?? ?? ?? 75 CD EB 19 38 5D FC 8D 41 20 74 1F 8B 4D F8 83 61 70 FD EB 16 0F B6 04 BD ?? ?? ?? ?? 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_108_5_0 {
	meta:
		name = "?_strupr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
		size = 380
		refs = "0007 ___security_cookie 0019 __errno 0028 __invalid_parameter 0039 _strnlen 0087 ___crtLCMapStringA 00dc __alloca_probe_16 00f0 _malloc 0149 _strcpy_s 0164 __freea 0176 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 33 DB 3B FB 56 75 1C E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 35 01 00 00 FF 75 08 57 E8 ?? ?? ?? ?? 3B 45 08 59 59 72 04 88 1F EB D0 8B 55 0C 8B 02 8B 48 14 3B CB 75 20 38 1F 8B CF 74 13 8A 01 3C 61 7C 08 3C 7A 7F 04 2C 20 88 01 41 38 19 75 ED 33 C0 E9 F7 00 00 00 6A 01 FF 70 04 BE 00 02 00 00 53 53 6A FF 57 56 51 52 E8 ?? ?? ?? ?? 8B C8 83 C4 24 3B CB 89 4D F4 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 BD 00 00 00 39 4D 08 73 0E 88 1F E8 ?? ?? ?? ?? 6A 22 E9 5E FF FF FF 3B CB 7E 45 6A E0 33 D2 58 F7 F1 83 F8 01 72 39 8D 41 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 3B C3 59 74 09 C7 00 DD DD 00 00 83 C0 08 8B 4D F4 89 45 F8 EB 03 89 5D F8 39 5D F8 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 83 8B 55 0C 8B 02 6A 01 FF 70 04 51 FF 75 F8 6A FF 57 56 FF 70 14 52 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 13 FF 75 F8 FF 75 08 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 0C E8 ?? ?? ?? ?? 6A 2A 59 89 08 8B F1 FF 75 F8 E8 ?? ?? ?? ?? 59 8B C6 8D 65 EC 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_108_6_0 {
	meta:
		name = "__strupr_s_l"
		size = 51
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001d ?_strupr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 57 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 7D 08 8D 45 F0 50 FF 75 0C E8 ?? ?? ?? ?? 80 7D FC 00 59 59 5F 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_108_8_0 {
	meta:
		name = "__strupr_l"
		size = 23
		refs = "000b __strupr_s_l"
	strings:
		$1 = { FF 74 24 08 6A FF FF 74 24 0C E8 ?? ?? ?? ?? 8B 44 24 10 83 C4 0C C3 }
	condition:
		$1
}

rule file_246_8_0 {
	meta:
		name = "__strlwr_l"
		size = 23
		refs = "000b __strlwr_s_l"
	strings:
		$1 = { FF 74 24 08 6A FF FF 74 24 0C E8 ?? ?? ?? ?? 8B 44 24 10 83 C4 0C C3 }
	condition:
		$1
}

rule file_852_8_0 {
	meta:
		name = "__wcslwr_l"
		size = 23
		refs = "000b __wcslwr_s_l"
	strings:
		$1 = { FF 74 24 08 6A FF FF 74 24 0C E8 ?? ?? ?? ?? 8B 44 24 10 83 C4 0C C3 }
	condition:
		$1
}

rule file_848_8_0 {
	meta:
		name = "__wcsupr_l"
		size = 23
		refs = "000b __wcsupr_s_l"
	strings:
		$1 = { FF 74 24 08 6A FF FF 74 24 0C E8 ?? ?? ?? ?? 8B 44 24 10 83 C4 0C C3 }
	condition:
		$1
}

rule file_108_9_0 {
	meta:
		name = "__strupr"
		size = 98
		refs = "0005 ___locale_changed 0014 __errno 0024 __invalid_parameter 0055 __strupr_s_l"
	strings:
		$1 = { 53 33 DB 39 1D ?? ?? ?? ?? 75 42 8B 44 24 08 3B C3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5B C3 38 18 8B D0 74 2B 8A 0A 80 F9 61 7C 0A 80 F9 7A 7F 05 80 E9 20 88 0A 42 38 1A 75 EA 5B C3 53 6A FF FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 14 83 C4 0C 5B C3 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "_wcscat_s"
		size = 122
		refs = "0016 __errno 0025 __invalid_parameter"
	strings:
		$1 = { 8B 54 24 04 53 56 33 F6 3B D6 57 74 08 8B 5C 24 14 3B DE 77 1B E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 46 8B 7C 24 18 3B FE 75 05 66 89 32 EB D8 8B CA 66 39 31 74 05 41 41 4B 75 F6 3B DE 74 EB 0F B7 07 66 89 01 41 41 47 47 66 3B C6 74 03 4B 75 EE 3B DE 75 11 66 89 32 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F9 EB AB 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule file_112_0_0 {
	meta:
		name = "_vwprintf_helper"
		size = 144
		refs = "0003 __sehtable$_vwprintf_helper 0008 __SEH_prolog4 000d ___iob_func 0028 __errno 0038 __invalid_parameter 0046 __lock_file 0050 __stbuf 0069 __ftbuf 0080 __SEH_epilog4 008a __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 83 C6 20 89 75 E4 33 C0 33 FF 39 7D 0C 0F 95 C0 3B C7 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 3B 56 E8 ?? ?? ?? ?? 59 89 7D FC 56 E8 ?? ?? ?? ?? 8B F8 FF 75 14 FF 75 10 FF 75 0C 56 FF 55 08 89 45 E0 56 57 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 8B 75 E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_459_0_0 {
	meta:
		name = "_vprintf_helper"
		size = 144
		refs = "0003 __sehtable$_vprintf_helper 0008 __SEH_prolog4 000d ___iob_func 0028 __errno 0038 __invalid_parameter 0046 __lock_file 0050 __stbuf 0069 __ftbuf 0080 __SEH_epilog4 008a __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 83 C6 20 89 75 E4 33 C0 33 FF 39 7D 0C 0F 95 C0 3B C7 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 3B 56 E8 ?? ?? ?? ?? 59 89 7D FC 56 E8 ?? ?? ?? ?? 8B F8 FF 75 14 FF 75 10 FF 75 0C 56 FF 55 08 89 45 E0 56 57 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 8B 75 E4 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_112_1_0 {
	meta:
		name = "__vwprintf_l"
		size = 26
		refs = "000d __woutput_l 0012 _vwprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_459_1_0 {
	meta:
		name = "__vprintf_l"
		size = 26
		refs = "000d __output_l 0012 _vprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_459_3_0 {
	meta:
		name = "__vprintf_p_l"
		size = 26
		refs = "000d __output_p_l 0012 _vprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_459_2_0 {
	meta:
		name = "__vprintf_s_l"
		size = 26
		refs = "000d __output_s_l 0012 _vprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_341_4_0 {
	meta:
		name = "__vscprintf_l"
		size = 26
		refs = "000d __output_l 0012 __vscprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_341_6_0 {
	meta:
		name = "__vscprintf_p_l"
		size = 26
		refs = "000d __output_p_l 0012 __vscprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_606_5_0 {
	meta:
		name = "__vscwprintf_l"
		size = 26
		refs = "000d __woutput_l 0012 __vscwprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_606_7_0 {
	meta:
		name = "__vscwprintf_p_l"
		size = 26
		refs = "000d __woutput_p_l 0012 __vscwprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_112_3_0 {
	meta:
		name = "__vwprintf_p_l"
		size = 26
		refs = "000d __woutput_p_l 0012 _vwprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_112_2_0 {
	meta:
		name = "__vwprintf_s_l"
		size = 26
		refs = "000d __woutput_s_l 0012 _vwprintf_helper"
	strings:
		$1 = { FF 74 24 0C FF 74 24 0C FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_112_4_0 {
	meta:
		name = "_vwprintf"
		size = 24
		refs = "000b __woutput_l 0010 _vwprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_459_6_0 {
	meta:
		name = "__vprintf_p"
		size = 24
		refs = "000b __output_p_l 0010 _vprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_341_3_0 {
	meta:
		name = "__vscprintf"
		size = 24
		refs = "000b __output_l 0010 __vscprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_341_5_0 {
	meta:
		name = "__vscprintf_p"
		size = 24
		refs = "000b __output_p_l 0010 __vscprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_606_4_0 {
	meta:
		name = "__vscwprintf"
		size = 24
		refs = "000b __woutput_l 0010 __vscwprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_606_6_0 {
	meta:
		name = "__vscwprintf_p"
		size = 24
		refs = "000b __woutput_p_l 0010 __vscwprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_112_6_0 {
	meta:
		name = "__vwprintf_p"
		size = 24
		refs = "000b __woutput_p_l 0010 _vwprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_459_4_0 {
	meta:
		name = "_vprintf"
		size = 24
		refs = "000b __output_l 0010 _vprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_459_5_0 {
	meta:
		name = "_vprintf_s"
		size = 24
		refs = "000b __output_s_l 0010 _vprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_112_5_0 {
	meta:
		name = "_vwprintf_s"
		size = 24
		refs = "000b __woutput_s_l 0010 _vwprintf_helper"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_113_2_0 {
	meta:
		name = "__ctrlfp"
		size = 39
	strings:
		$1 = { 55 8B EC 51 9B D9 7D FC 8B 45 0C 8B 4D 08 23 4D 0C F7 D0 23 45 FC 0B C1 0F B7 C0 89 45 0C D9 6D 0C 0F BF 45 FC C9 C3 }
	condition:
		$1
}

rule file_113_3_0 {
	meta:
		name = "__set_statfp"
		size = 86
		refs = "000d _over 0032 _under"
	strings:
		$1 = { 51 51 8A 4C 24 0C F6 C1 01 74 0B DB 2D ?? ?? ?? ?? DB 5C 24 0C 9B F6 C1 08 74 10 9B DF E0 DB 2D ?? ?? ?? ?? DD 1C 24 9B 9B DF E0 F6 C1 10 74 0A DB 2D ?? ?? ?? ?? DD 1C 24 9B F6 C1 04 74 09 D9 EE D9 E8 DE F1 DD D8 9B F6 C1 20 74 06 D9 EB DD 1C 24 9B 59 59 C3 }
	condition:
		$1
}

rule file_113_4_0 {
	meta:
		name = "___get_fpsr_sse2"
		size = 28
		refs = "0006 ___sse2_available"
	strings:
		$1 = { 55 8B EC 51 83 3D ?? ?? ?? ?? 00 74 06 0F AE 5D FC EB 04 83 65 FC 00 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_113_5_0 {
	meta:
		name = "___set_fpsr_sse2"
		size = 114
		refs = "0003 __sehtable$___set_fpsr_sse2 0008 __SEH_prolog4 0010 ___sse2_available 001e ?__DAZ_ENABLED@?1??__set_fpsr_sse2@@9@9 006d __SEH_epilog4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 39 05 ?? ?? ?? ?? 74 56 F6 45 08 40 74 48 39 05 ?? ?? ?? ?? 74 40 89 45 FC 0F AE 55 08 EB 2E 8B 45 EC 8B 00 8B 00 3D 05 00 00 C0 74 0A 3D 1D 00 00 C0 74 03 33 C0 C3 33 C0 40 C3 8B 65 E8 83 25 ?? ?? ?? ?? 00 83 65 08 BF 0F AE 55 08 C7 45 FC FE FF FF FF EB 08 83 65 08 BF 0F AE 55 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_113_6_0 {
	meta:
		name = "___fclrf_sse2"
		size = 24
		refs = "0003 ___sse2_available"
	strings:
		$1 = { 51 83 3D ?? ?? ?? ?? 00 74 0C 0F AE 1C 24 83 24 24 C0 0F AE 14 24 59 C3 }
	condition:
		$1
}

rule file_113_7_0 {
	meta:
		name = "___statfp_sse2"
		size = 19
		refs = "0004 ___sse2_available 000b ___get_fpsr_sse2"
	strings:
		$1 = { 33 C0 39 05 ?? ?? ?? ?? 74 08 E8 ?? ?? ?? ?? 83 E0 3F C3 }
	condition:
		$1
}

rule file_113_8_0 {
	meta:
		name = "___clrfp_sse2"
		size = 24
		refs = "0004 ___sse2_available 000b ___get_fpsr_sse2 0013 ___fclrf_sse2"
	strings:
		$1 = { 33 C0 39 05 ?? ?? ?? ?? 74 0D E8 ?? ?? ?? ?? 83 E0 3F E9 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_113_9_0 {
	meta:
		name = "___ctrlfp_sse2"
		size = 52
		refs = "0005 ___sse2_available 000c ___get_fpsr_sse2 002b ___set_fpsr_sse2"
	strings:
		$1 = { 56 33 F6 39 35 ?? ?? ?? ?? 74 25 E8 ?? ?? ?? ?? 8B 4C 24 08 23 4C 24 0C 8B F0 8B 44 24 0C F7 D0 0D 7F 80 FF FF 23 C6 0B C1 50 E8 ?? ?? ?? ?? 59 8B C6 5E C3 }
	condition:
		$1
}

rule file_113_10_0 {
	meta:
		name = "___set_statfp_sse2"
		size = 22
		refs = "0001 ___get_fpsr_sse2 0010 ___set_fpsr_sse2"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 4C 24 04 83 E1 3F 0B C1 50 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "_swap_c"
		size = 40
		altNames = "_swap"
	strings:
		$1 = { 3B C1 56 8B F2 74 1F 85 F6 74 1B 53 8D 64 24 00 8A 19 8A 10 88 18 83 EE 01 88 11 83 C0 01 83 C1 01 85 F6 75 EB 5B 5E C3 }
	condition:
		$1
}

rule file_118_1_0 {
	meta:
		name = "_shortsort_s"
		size = 135
	strings:
		$1 = { 8B 4C 24 04 55 8B 6C 24 0C 3B E9 76 78 53 8B 5C 24 14 56 8D 04 19 57 89 44 24 18 EB 03 8D 49 00 8B 74 24 18 3B F5 8B F9 77 24 8D 9B 00 00 00 00 8B 4C 24 24 57 56 51 FF 54 24 2C 83 C4 0C 85 C0 7E 02 8B FE 03 F3 3B F5 76 E6 8B 4C 24 14 3B FD 8B F3 8B C5 74 26 85 DB 74 22 8B CF 2B CD 8B FF 8A 18 8A 14 01 88 1C 01 83 EE 01 88 10 83 C0 01 85 F6 75 EC 8B 5C 24 1C 8B 4C 24 14 2B EB 3B E9 77 9E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_118_2_0 {
	meta:
		name = "_qsort_s"
		size = 883
		refs = "001f __errno 005a __invalid_parameter 013c _shortsort_s 0175 _swap_c"
	strings:
		$1 = { 81 EC 00 01 00 00 53 8B 9C 24 08 01 00 00 85 DB 57 8B BC 24 10 01 00 00 75 44 85 FF 74 40 E8 ?? ?? ?? ?? 5F C7 00 16 00 00 00 5B 81 C4 00 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 E9 ?? ?? ?? ?? 56 8B B4 24 18 01 00 00 85 F6 77 41 E8 ?? ?? ?? ?? 5E 5F C7 00 16 00 00 00 5B 81 C4 00 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 E9 ?? ?? ?? ?? 83 BC 24 1C 01 00 00 00 75 41 E8 ?? ?? ?? ?? 5E 5F C7 00 16 00 00 00 5B 81 C4 00 01 00 00 C7 44 24 14 00 00 00 00 C7 44 24 10 00 00 00 00 C7 44 24 0C 00 00 00 00 C7 44 24 08 00 00 00 00 C7 44 24 04 00 00 00 00 E9 ?? ?? ?? ?? 83 FF 02 0F 82 6A 02 00 00 83 C7 FF 0F AF FE 03 FB C7 44 24 18 00 00 00 00 89 5C 24 0C 89 7C 24 10 55 8B C7 2B C3 33 D2 F7 F6 83 C0 01 83 F8 08 77 20 8B 84 24 24 01 00 00 8B 8C 24 20 01 00 00 50 51 56 57 53 E8 ?? ?? ?? ?? 83 C4 14 E9 F7 01 00 00 8B AC 24 24 01 00 00 D1 E8 0F AF C6 03 C3 8B F0 56 53 55 FF 94 24 2C 01 00 00 83 C4 0C 85 C0 7E 10 8B 94 24 1C 01 00 00 8B CE 8B C3 E8 ?? ?? ?? ?? 57 53 55 FF 94 24 2C 01 00 00 83 C4 0C 85 C0 7E 10 8B 94 24 1C 01 00 00 8B CF 8B C3 E8 ?? ?? ?? ?? 57 56 55 FF 94 24 2C 01 00 00 83 C4 0C 85 C0 7E 15 8B 94 24 1C 01 00 00 8B CF 8B C6 E8 ?? ?? ?? ?? EB 03 8D 49 00 3B F3 76 2C 03 9C 24 1C 01 00 00 3B DE 73 21 56 53 55 FF 94 24 2C 01 00 00 83 C4 0C 85 C0 7E E4 3B F3 77 2C EB 0A 8D A4 24 00 00 00 00 8D 49 00 03 9C 24 1C 01 00 00 3B 5C 24 14 77 13 56 53 55 FF 94 24 2C 01 00 00 83 C4 0C 85 C0 7E E2 8B FF 2B BC 24 1C 01 00 00 3B FE 76 11 56 57 55 FF 94 24 2C 01 00 00 83 C4 0C 85 C0 7F E4 3B DF 77 45 8B 8C 24 1C 01 00 00 8B C7 74 2B 8B EB 2B EF 90 0F B6 14 28 88 54 24 1B 0F B6 10 88 14 28 0F B6 54 24 1B 83 E9 01 88 10 83 C0 01 85 C9 75 E1 8B AC 24 24 01 00 00 3B F7 0F 85 52 FF FF FF 8B F3 E9 4B FF FF FF 03 BC 24 1C 01 00 00 3B F7 73 20 2B BC 24 1C 01 00 00 3B FE 76 15 56 57 55 FF 94 24 2C 01 00 00 83 C4 0C 85 C0 74 E4 3B F7 72 20 2B BC 24 1C 01 00 00 8B 44 24 10 3B F8 76 15 56 57 55 FF 94 24 2C 01 00 00 83 C4 0C 85 C0 74 E0 8B 44 24 10 8B 54 24 14 8B CA 8B F7 2B CB 2B F0 3B F1 7C 32 3B C7 73 16 8B 4C 24 1C 89 44 8C 20 89 BC 8C 98 00 00 00 83 C1 01 89 4C 24 1C 3B DA 73 46 8B 7C 24 14 8B B4 24 1C 01 00 00 89 5C 24 10 E9 12 FE FF FF 3B DA 73 16 8B 4C 24 1C 89 5C 8C 20 89 94 8C 98 00 00 00 83 C1 01 89 4C 24 1C 3B C7 73 14 8B 5C 24 10 8B B4 24 1C 01 00 00 89 7C 24 14 E9 E0 FD FF FF 8B B4 24 1C 01 00 00 8B 44 24 1C 83 E8 01 89 44 24 1C 78 1C 8B 54 84 20 8B 84 84 98 00 00 00 89 54 24 10 89 44 24 14 8B F8 8B DA E9 B0 FD FF FF 5D 5E 5F 5B 81 C4 00 01 00 00 C3 }
	condition:
		$1
}

rule file_120_4_0 {
	meta:
		name = "___check_float_string"
		size = 87
		refs = "0014 __calloc_crt 0039 _memcpy 0044 __recalloc_crt"
	strings:
		$1 = { 8B 06 39 44 24 04 75 4B 8B 0F 3B 4C 24 08 6A 04 50 75 2F E8 ?? ?? ?? ?? 85 C0 59 59 89 07 75 03 33 C0 C3 8B 44 24 0C C7 00 01 00 00 00 8B 06 03 C0 50 FF 74 24 0C FF 37 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 D1 89 07 D1 26 33 C0 40 C3 }
	condition:
		$1
}

rule file_120_6_0 {
	meta:
		name = "__hextodec"
		size = 44
		refs = "0014 _isdigit"
	strings:
		$1 = { 66 F7 C7 00 FF 56 75 19 0F B7 F7 8B C6 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 85 C0 59 74 04 8B C6 5E C3 0F B7 C7 83 E0 DF 83 E8 07 5E C3 }
	condition:
		$1
}

rule file_120_9_0 {
	meta:
		name = "__whiteout"
		size = 37
		refs = "0004 __getwche_nolock 0016 _iswctype"
	strings:
		$1 = { 56 FF 07 E8 ?? ?? ?? ?? 0F B7 F0 66 81 FE FF FF 74 0E 6A 08 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 E1 66 8B C6 5E C3 }
	condition:
		$1
}

rule file_120_10_0 {
	meta:
		name = "__cprinput_s_l"
		size = 3243
		refs = "000f ___security_cookie 004e __errno 005e __invalid_parameter 0077 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0095 _iswctype 00a6 __whiteout 00ac __un_inc 011d _isdigit 0258 __getwche_nolock 039a ___check_float_string 03de __mbtowc_l 05e6 __malloc_crt 0602 _wcstombs_s 061d __invoke_watson 0634 __cfltcvt_tab 0639 __decode_pointer 0642 _free 07b0 _memset 0925 _wctomb_s 0a37 __allmul 0a4f _isxdigit 0a6e __hextodec 0c9f @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 30 FD FF FF 81 EC 44 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 CC 02 00 00 8B 85 DC 02 00 00 53 33 DB 57 8B F9 3B FB 89 45 AC 8D 45 10 89 7D C8 89 45 F0 C7 45 B8 5E 01 00 00 89 5D BC 89 5D B4 89 5D 9C 89 5D 00 89 5D A0 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 27 0C 00 00 FF B5 D8 02 00 00 8D 4D 8C E8 ?? ?? ?? ?? 0F B7 07 66 3B C3 88 5D F5 89 5D 08 89 5D C4 0F 84 F4 0B 00 00 56 6A 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 2D FF 4D 08 8D 7D 08 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 7D C8 59 47 47 0F B7 07 6A 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 ED E9 FB 0A 00 00 8B 7D C8 66 83 3F 25 0F 85 F3 0A 00 00 33 F6 89 75 D0 89 75 C0 89 75 EC 89 75 D4 89 75 F8 89 75 CC C6 45 DF 00 C6 45 F4 00 C6 45 FF 00 C6 45 0F 00 C6 45 F6 00 C6 45 07 00 C6 45 F7 01 89 75 E8 47 47 0F B7 1F 66 F7 C3 00 FF 75 23 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 15 8B 45 F8 FF 45 D4 6B C0 0A 8D 44 18 D0 89 45 F8 E9 AE 00 00 00 83 FB 4E 7F 7E 0F 84 A3 00 00 00 83 FB 2A 74 6E 83 FB 46 0F 84 95 00 00 00 83 FB 49 74 0D 83 FB 4C 75 6F FE 45 F7 E9 83 00 00 00 0F B7 4F 02 66 83 F9 36 75 16 8D 47 04 66 83 38 34 75 0D FF 45 E8 8B F8 89 75 E0 89 75 E4 EB 63 66 83 F9 33 75 0D 8D 47 04 66 83 38 32 75 04 8B F8 EB 50 66 83 F9 64 74 4A 66 83 F9 69 74 44 66 83 F9 6F 74 3E 66 83 F9 78 74 38 66 83 F9 58 75 16 EB 30 FE 45 FF EB 2B 83 FB 68 74 20 83 FB 6C 74 0A 83 FB 77 74 11 FE 45 0F EB 17 8D 47 02 66 83 38 6C 74 9E FE 45 F7 FE 45 07 EB 06 FE 4D F7 FE 4D 07 80 7D 0F 00 0F 84 19 FF FF FF 80 7D FF 00 89 7D C8 75 10 8B 45 AC 8B 18 89 45 A8 83 C0 04 89 45 AC EB 02 33 DB 80 7D 07 00 89 5D D8 C6 45 0F 00 75 17 0F B7 07 66 3D 53 00 74 0A 66 3D 43 00 C6 45 07 01 75 04 C6 45 07 FF 0F B7 37 83 CE 20 83 FE 6E 89 75 B0 74 35 83 FE 63 74 0F 83 FE 7B 74 0A 8D 7D 08 E8 ?? ?? ?? ?? EB 08 FF 45 08 E8 ?? ?? ?? ?? 0F B7 C0 66 3D FF FF 89 45 00 0F 84 D9 09 00 00 8B 5D D8 8B 7D C8 8B 75 B0 8B 4D D4 85 C9 74 0A 83 7D F8 00 0F 84 B6 09 00 00 80 7D FF 00 75 32 83 FE 63 74 0A 83 FE 73 74 05 83 FE 7B 75 23 8B 45 A8 8B 18 83 C0 04 89 45 A8 83 C0 04 89 45 AC 8B 40 FC 83 F8 01 89 5D D8 89 45 CC 0F 82 37 09 00 00 83 FE 6F 0F 8F 53 04 00 00 0F 84 CE 06 00 00 83 FE 63 0F 84 78 03 00 00 83 FE 64 0F 84 BC 06 00 00 0F 8E 5F 04 00 00 83 FE 67 7E 39 83 FE 69 74 1B 83 FE 6E 0F 85 4C 04 00 00 80 7D FF 00 8B 45 08 0F 84 9A 08 00 00 E9 B5 08 00 00 6A 64 5E 8B 5D 00 66 83 FB 2D 0F 85 5D 05 00 00 C6 45 F4 01 E9 5A 05 00 00 33 DB 66 83 7D 00 2D 75 0B 8B 45 F0 66 C7 00 2D 00 43 EB 07 66 83 7D 00 2B 75 11 FF 4D F8 FF 45 08 E8 ?? ?? ?? ?? 0F B7 C0 89 45 00 83 7D D4 00 75 04 83 4D F8 FF 66 F7 45 00 00 FF 75 5C 0F B6 45 00 50 E8 ?? ?? ?? ?? 85 C0 59 74 4D 8B 45 F8 FF 4D F8 85 C0 74 43 66 0F BE 45 00 8B 4D F0 FF 45 EC 66 89 04 59 8D 45 BC 50 8D 45 10 50 43 53 8D 7D F0 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 9C 08 00 00 FF 45 08 E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 89 45 00 74 A4 8D 45 8C 50 8B 45 8C C7 45 A4 2E 00 00 00 FF B0 AC 00 00 00 8B 80 BC 00 00 00 FF 30 8D 45 A4 50 E8 ?? ?? ?? ?? 0F B7 45 A4 0F BE 4D 00 83 C4 10 3B C1 0F 85 AA 00 00 00 8B 45 F8 FF 4D F8 85 C0 0F 84 9C 00 00 00 FF 45 08 E8 ?? ?? ?? ?? 8B 4D F0 0F B7 C0 89 45 00 66 8B 45 A4 66 89 04 59 8D 45 BC 50 8D 45 10 50 43 53 8D 7D F0 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 09 08 00 00 66 F7 45 00 00 FF 75 5B 0F B6 45 00 50 E8 ?? ?? ?? ?? 85 C0 59 74 4C 8B 45 F8 FF 4D F8 85 C0 74 42 8B 45 F0 66 8B 4D 00 FF 45 EC 66 89 0C 58 8D 45 BC 50 8D 45 10 50 43 53 8D 7D F0 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 BA 07 00 00 FF 45 08 E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 89 45 00 74 A5 83 7D EC 00 0F 84 09 01 00 00 66 83 7D 00 65 74 0B 66 83 7D 00 45 0F 85 F7 00 00 00 8B 45 F8 FF 4D F8 85 C0 0F 84 E9 00 00 00 8B 45 F0 66 C7 04 58 65 00 8D 45 BC 50 8D 45 10 50 43 53 8D 7D F0 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 53 07 00 00 FF 45 08 E8 ?? ?? ?? ?? 0F B7 C0 66 3D 2D 00 89 45 00 75 25 8B 45 F0 66 C7 04 58 2D 00 8D 45 BC 50 8D 45 10 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 1C 07 00 00 EB 07 66 83 7D 00 2B 75 1D 8B 45 F8 FF 4D F8 85 C0 75 05 21 45 F8 EB 0E FF 45 08 E8 ?? ?? ?? ?? 0F B7 C0 89 45 00 66 F7 45 00 00 FF 75 5B 0F B6 45 00 50 E8 ?? ?? ?? ?? 85 C0 59 74 4C 8B 45 F8 FF 4D F8 85 C0 74 42 8B 45 F0 66 8B 4D 00 FF 45 EC 66 89 0C 58 8D 45 BC 50 8D 45 10 50 43 53 8D 7D F0 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 A7 06 00 00 FF 45 08 E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 89 45 00 74 A5 FF 75 00 FF 4D 08 E8 ?? ?? ?? ?? 83 7D EC 00 59 0F 84 7D 06 00 00 80 7D FF 00 0F 85 ED 05 00 00 8B 7D B8 8B 45 F0 FF 45 C4 66 83 24 58 00 8D 7C 3F 02 57 E8 ?? ?? ?? ?? 8B F0 85 F6 59 0F 84 50 06 00 00 8D 47 FF 50 FF 75 F0 57 56 33 FF 57 E8 ?? ?? ?? ?? 83 C4 14 3B C7 74 17 83 F8 16 74 05 83 F8 22 75 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8D 45 8C 50 0F BE 45 F7 56 FF 75 D8 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 56 E8 ?? ?? ?? ?? 83 C4 14 E9 71 05 00 00 85 C9 75 0A FF 45 F8 C7 45 D4 01 00 00 00 80 7D 07 00 7E 04 C6 45 F6 01 FF 75 00 FF 4D 08 8B FB E8 ?? ?? ?? ?? 83 FE 63 59 74 03 FF 4D CC 83 7D D4 00 74 0E 8B 45 F8 FF 4D F8 85 C0 0F 84 CE 02 00 00 FF 45 08 E8 ?? ?? ?? ?? 83 FE 63 0F B7 D0 89 55 00 74 4C 83 FE 73 75 16 66 83 FA 09 72 0A 66 83 FA 0D 0F 86 9C 02 00 00 66 83 FA 20 75 31 83 FE 7B 0F 85 8D 02 00 00 0F B7 C2 8B C8 33 F6 83 E1 07 46 D3 E6 8B 4D B4 C1 E8 03 0F BE 04 08 0F BE 4D DF 33 C1 85 F0 0F 84 68 02 00 00 8B 75 B0 80 7D FF 00 0F 85 54 02 00 00 83 7D CC 00 0F 84 1D 05 00 00 80 7D F6 00 0F 84 0A 02 00 00 66 89 13 43 43 89 5D D8 E9 5F FF FF FF 8B C6 83 E8 70 0F 84 72 02 00 00 83 E8 03 0F 84 2E FF FF FF 48 48 0F 84 65 02 00 00 83 E8 03 0F 84 CE FB FF FF 83 E8 03 74 24 8B 45 00 66 39 07 0F 85 C1 04 00 00 FE 4D F5 80 7D FF 00 0F 85 62 04 00 00 8B 45 A8 89 45 AC E9 57 04 00 00 80 7D 07 00 7E 04 C6 45 F6 01 47 47 66 83 3F 5E 75 07 83 C7 02 C6 45 DF FF 8B 5D B4 85 DB 75 1F 68 00 20 00 00 E8 ?? ?? ?? ?? 85 C0 59 89 45 B4 0F 84 A7 04 00 00 C7 45 9C 01 00 00 00 8B D8 68 00 20 00 00 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 59 66 39 0F 75 09 47 89 4D C0 47 C6 43 0B 20 0F B7 07 66 3B C1 0F 84 8B 00 00 00 0F B7 C0 47 47 66 3D 2D 00 75 5A 8B 55 C0 66 85 D2 74 52 0F B7 0F 66 83 F9 5D 74 49 0F B7 C9 47 47 66 3B D1 73 05 0F B7 C1 EB 09 0F B7 C2 0F B7 D1 89 55 C0 66 3B D0 77 26 2B 45 C0 0F B7 75 C0 40 0F B7 C0 89 45 E8 8B CE 83 E1 07 8B C6 B2 01 D2 E2 C1 E8 03 03 C3 08 10 46 FF 4D E8 75 E8 83 65 C0 00 EB 19 0F B7 C8 89 4D C0 0F B7 C8 8B C1 83 E1 07 B2 01 C1 E8 03 D2 E2 03 C3 08 10 0F B7 07 66 3D 5D 00 0F 85 75 FF FF FF 66 83 3F 00 0F 84 DC 03 00 00 8B 5D D8 8B 75 B0 89 7D C8 E9 EF FD FF FF 66 83 FB 2B 75 1D FF 4D F8 75 0A 85 C9 74 06 C6 45 0F 01 EB 0E FF 45 08 E8 ?? ?? ?? ?? 0F B7 D8 89 5D 00 66 83 FB 30 0F 85 29 01 00 00 FF 45 08 E8 ?? ?? ?? ?? 0F B7 D8 66 83 FB 78 89 5D 00 74 36 66 83 FB 58 74 30 83 FE 78 C7 45 EC 01 00 00 00 74 12 83 7D D4 00 74 08 FF 4D F8 75 03 FE 45 0F 6A 6F EB 35 FF 4D 08 53 E8 ?? ?? ?? ?? 59 6A 30 5B E9 DC 00 00 00 FF 45 08 E8 ?? ?? ?? ?? 83 7D D4 00 0F B7 D8 89 5D 00 74 0D 83 6D F8 02 83 7D F8 01 7D 03 FE 45 0F 6A 78 5E E9 B6 00 00 00 83 65 E8 00 52 FF 75 CC 8D 45 E8 53 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 22 0F 84 EB 02 00 00 8B 45 E8 85 C0 0F 8E 3C FD FF FF 03 D8 29 45 CC 89 5D D8 E9 2F FD FF FF 47 47 E9 28 FD FF FF FF 4D 08 52 E8 ?? ?? ?? ?? 59 3B FB 0F 84 DF 02 00 00 80 7D FF 00 0F 85 4F 02 00 00 FF 45 C4 83 7D B0 63 0F 84 42 02 00 00 80 7D F6 00 8B 45 D8 74 09 66 83 20 00 E9 30 02 00 00 C6 00 00 E9 28 02 00 00 C6 45 F7 01 8B 5D 00 66 83 FB 2D 75 06 C6 45 F4 01 EB 06 66 83 FB 2B 75 1D FF 4D F8 75 0A 85 C9 74 06 C6 45 0F 01 EB 0E FF 45 08 E8 ?? ?? ?? ?? 0F B7 D8 89 5D 00 83 7D E8 00 0F 84 FB 00 00 00 80 7D 0F 00 0F 85 CF 00 00 00 83 FE 78 74 5D 83 FE 70 74 58 66 F7 C3 00 FF 0F 85 B0 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 9E 00 00 00 83 FE 6F 75 1F 66 83 FB 38 0F 83 8F 00 00 00 8B 45 E0 8B 4D E4 0F A4 C1 03 C1 E0 03 89 45 E0 89 4D E4 EB 4C 6A 00 6A 0A FF 75 E4 FF 75 E0 E8 ?? ?? ?? ?? 89 45 E0 89 55 E4 EB 35 66 F7 C3 00 FF 75 5C 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 4E 8B 45 E0 8B 4D E4 0F A4 C1 04 C1 E0 04 8B FB 89 45 E0 89 4D E4 E8 ?? ?? ?? ?? 0F B7 D8 89 5D 00 FF 45 EC 0F B7 C3 83 E8 30 99 01 45 E0 11 55 E4 83 7D D4 00 74 05 FF 4D F8 74 1D FF 45 08 E8 ?? ?? ?? ?? 0F B7 D8 89 5D 00 E9 3B FF FF FF FF 4D 08 53 E8 ?? ?? ?? ?? 59 80 7D F4 00 0F 84 C3 00 00 00 8B 45 E0 8B 4D E4 F7 D8 83 D1 00 F7 D9 89 45 E0 89 4D E4 E9 AB 00 00 00 80 7D 0F 00 0F 85 98 00 00 00 83 FE 78 74 35 83 FE 70 74 30 66 F7 C3 00 FF 75 7D 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 6F 83 FE 6F 75 0E 66 83 FB 38 73 64 8B 45 D0 C1 E0 03 EB 31 8B 45 D0 6B C0 0A EB 29 66 F7 C3 00 FF 75 4D 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 3F C1 65 D0 04 8B FB E8 ?? ?? ?? ?? 0F B7 D8 8B 45 D0 89 5D 00 FF 45 EC 83 7D D4 00 0F B7 CB 8D 44 08 D0 89 45 D0 74 05 FF 4D F8 74 1D FF 45 08 E8 ?? ?? ?? ?? 0F B7 D8 89 5D 00 E9 72 FF FF FF FF 4D 08 53 E8 ?? ?? ?? ?? 59 80 7D F4 00 74 03 F7 5D D0 83 FE 46 75 04 83 65 EC 00 83 7D EC 00 0F 84 B5 00 00 00 80 7D FF 00 75 29 FF 45 C4 8B 5D D8 8B 45 D0 83 7D E8 00 74 0D 8B 45 E0 89 03 8B 45 E4 89 43 04 EB 0D 80 7D F7 00 74 04 89 03 EB 03 66 89 03 FE 45 F5 8B 7D C8 47 47 89 7D C8 EB 1B FF 45 08 E8 ?? ?? ?? ?? 66 8B 0F 0F B7 C0 47 47 66 3B C8 89 45 00 89 7D C8 75 55 0F B7 07 66 85 C0 0F 85 9E F4 FF FF EB 50 80 7D 07 00 7E 06 66 83 23 00 EB 03 C6 03 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 34 50 E8 ?? ?? ?? ?? C7 45 A0 01 00 00 00 EB 24 E8 ?? ?? ?? ?? 80 7D F6 00 C7 00 0C 00 00 00 74 06 66 83 27 00 EB 0E C6 07 00 EB 09 FF 75 00 E8 ?? ?? ?? ?? 59 83 7D 9C 01 5E 75 09 FF 75 B4 E8 ?? ?? ?? ?? 59 83 7D BC 01 75 09 FF 75 F0 E8 ?? ?? ?? ?? 59 83 7D A0 01 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 80 7D 98 00 74 07 8B 45 94 83 60 70 FD 8B 45 C4 8B 8D CC 02 00 00 5F 33 CD 5B E8 ?? ?? ?? ?? 81 C5 D0 02 00 00 C9 C3 }
	condition:
		$1
}

rule file_120_11_0 {
	meta:
		name = "__cwscanf_s"
		size = 19
		refs = "000c __cprinput_s_l"
		altNames = "__cscanf_s"
	strings:
		$1 = { 8B 4C 24 04 8D 44 24 08 50 6A 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_123_10_0 {
	meta:
		name = "__cscanf"
		size = 19
		refs = "000c __cprinput_l"
	strings:
		$1 = { 8B 4C 24 04 8D 44 24 08 50 6A 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_142_11_0 {
	meta:
		name = "__cwscanf"
		size = 19
		refs = "000c __cprinput_l"
	strings:
		$1 = { 8B 4C 24 04 8D 44 24 08 50 6A 00 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_120_12_0 {
	meta:
		name = "__cwscanf_s_l"
		size = 21
		refs = "000e __cprinput_s_l"
		altNames = "__cscanf_s_l"
	strings:
		$1 = { 8B 4C 24 04 8D 44 24 0C 50 FF 74 24 0C E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_123_11_0 {
	meta:
		name = "__cscanf_l"
		size = 21
		refs = "000e __cprinput_l"
	strings:
		$1 = { 8B 4C 24 04 8D 44 24 0C 50 FF 74 24 0C E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_142_12_0 {
	meta:
		name = "__cwscanf_l"
		size = 21
		refs = "000e __cprinput_l"
	strings:
		$1 = { 8B 4C 24 04 8D 44 24 0C 50 FF 74 24 0C E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_121_0_0 {
	meta:
		name = "_atan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __atan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_250_0_0 {
	meta:
		name = "_acos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __acos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_534_0_0 {
	meta:
		name = "_asin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __asin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "_cos"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __cos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_439_0_0 {
	meta:
		name = "_log"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "_log10"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __log10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_612_0_0 {
	meta:
		name = "_sin"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __sin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_693_0_0 {
	meta:
		name = "_tan"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 003b __tan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 55 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_121_1_0 {
	meta:
		name = "__CIatan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIatan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_250_1_0 {
	meta:
		name = "__CIacos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIacos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_534_1_0 {
	meta:
		name = "__CIasin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIasin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_166_1_0 {
	meta:
		name = "__CIcos"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIcos_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_439_1_0 {
	meta:
		name = "__CIlog"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_214_1_0 {
	meta:
		name = "__CIlog10"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIlog10_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_808_1_0 {
	meta:
		name = "__CIpow"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIpow_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_612_1_0 {
	meta:
		name = "__CIsin"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIsin_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_693_1_0 {
	meta:
		name = "__CItan"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CItan_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 32 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 05 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_121_2_0 {
	meta:
		name = "__CIatan_default"
		size = 159
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 0038 ___fastflag 003f __fast_exit 004a _NAME_ 004f __math_exit 0054 __convertTOStoQNaN 006c __piby2 0099 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 36 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 E8 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 26 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? A9 00 00 00 80 74 BF D9 E0 EB BB B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0F 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "___libm_sse2_cos"
		size = 427
		refs = "001b _PI32INV 0027 _SHIFTER 0037 _P_1 0043 _P_2 0060 _SC_4 0066 _Ctable 007b _P_3 00a0 _SC_2 00e5 _SC_3 00f1 _SC_1 0161 _ONE 0191 _cos 01a6 _NEG_ZERO"
	strings:
		$1 = { 66 0F C5 C0 03 66 25 FF 7F 66 2D 30 30 66 3D C5 10 0F 87 36 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F2 0F 59 C8 F2 0F 10 15 ?? ?? ?? ?? F2 0F 2D D1 F2 0F 58 CA F2 0F 10 1D ?? ?? ?? ?? F2 0F 5C CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 D9 66 0F 14 C9 81 C2 10 76 1C 00 F2 0F 10 E0 83 E2 3F 66 0F 28 2D ?? ?? ?? ?? 8D 05 ?? ?? ?? ?? C1 E2 05 03 C2 66 0F 59 D1 F2 0F 5C C3 F2 0F 59 0D ?? ?? ?? ?? F2 0F 5C E3 F2 0F 10 78 08 66 0F 14 C0 F2 0F 10 DC F2 0F 5C E2 66 0F 59 E8 66 0F 5C C2 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FC F2 0F 5C DC 66 0F 59 E8 66 0F 59 C0 F2 0F 5C DA 66 0F 28 10 F2 0F 5C CB F2 0F 10 58 18 F2 0F 58 D3 F2 0F 5C FA F2 0F 59 D4 66 0F 59 F0 F2 0F 59 DC 66 0F 59 D0 66 0F 59 C0 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 20 66 0F 58 35 ?? ?? ?? ?? 66 0F 59 E8 F2 0F 10 C3 F2 0F 58 58 08 66 0F 59 CF F2 0F 10 FC F2 0F 58 E3 66 0F 58 F5 F2 0F 10 68 08 F2 0F 5C EB F2 0F 5C DC F2 0F 58 48 10 66 0F 59 F2 F2 0F 58 E8 F2 0F 58 DF F2 0F 58 CD F2 0F 58 CB F2 0F 58 CE 66 0F 15 F6 F2 0F 58 CE F2 0F 58 E1 66 0F 28 C4 C3 7F 1F 66 0F C5 C0 03 66 25 FF 7F 66 0F C4 C0 03 F2 0F 10 0D ?? ?? ?? ?? F2 0F 5C C8 66 0F 28 C1 C3 66 0F C5 C0 03 25 F0 7F 00 00 3D F0 7F 00 00 74 23 8B C4 83 EC 20 83 E4 F0 89 44 24 08 66 0F D6 04 24 E8 ?? ?? ?? ?? DD 1C 24 F3 0F 7E 04 24 8B 64 24 08 C3 F2 0F 59 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_123_8_0 {
	meta:
		name = "__whiteout"
		size = 33
		refs = "0004 __getche_nolock 0014 _isspace"
	strings:
		$1 = { 53 FF 06 E8 ?? ?? ?? ?? 8B D8 83 FB FF 74 0E 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 75 E4 8B C3 5B C3 }
	condition:
		$1
}

rule file_123_9_0 {
	meta:
		name = "__cprinput_l"
		size = 2741
		refs = "000f ___security_cookie 0045 __errno 0055 __invalid_parameter 006e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 008e _isspace 009e __whiteout 00a4 __un_inc 00fb _isdigit 021c __getche_nolock 0306 ___check_float_string 050f __cfltcvt_tab 0514 __decode_pointer 05d2 _isleadbyte 0603 __mbtowc_l 0689 _memset 089e __allmul 08ae _isxdigit 0a89 _free 0aa9 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 78 FE FF FF 81 EC F8 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 84 01 00 00 8B 85 94 01 00 00 56 57 33 FF 8B F1 3B F7 89 45 A4 8D 45 04 89 45 E4 C7 45 B8 5E 01 00 00 89 7D C8 89 7D A8 89 7D 00 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 3A 0A 00 00 FF B5 90 01 00 00 8D 4D 90 E8 ?? ?? ?? ?? 8A 06 84 C0 C6 45 EE 00 89 7D FC 89 7D C4 0F 84 08 0A 00 00 8B FE 53 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 74 26 FF 4D FC 8D 75 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 47 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 75 F1 E9 9A 09 00 00 80 3F 25 0F 85 5B 09 00 00 33 C0 89 45 AC 88 45 C3 89 45 DC 89 45 D8 89 45 F4 88 45 F0 88 45 EF 88 45 F2 88 45 E3 88 45 F1 88 45 FB C6 45 F3 01 89 45 BC 33 F6 47 0F B6 1F 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 15 8B 45 F4 FF 45 D8 6B C0 0A 8D 44 18 D0 89 45 F4 E9 A0 00 00 00 83 FB 4E 7F 71 0F 84 95 00 00 00 83 FB 2A 74 61 83 FB 46 0F 84 87 00 00 00 83 FB 49 74 0A 83 FB 4C 75 62 FE 45 F3 EB 78 8A 4F 01 80 F9 36 75 15 8D 47 02 80 38 34 75 0D FF 45 BC 8B F8 89 75 CC 89 75 D0 EB 5B 80 F9 33 75 0C 8D 47 02 80 38 32 75 04 8B F8 EB 4A 80 F9 64 74 45 80 F9 69 74 40 80 F9 6F 74 3B 80 F9 78 74 36 80 F9 58 75 16 EB 2F FE 45 F2 EB 2A 83 FB 68 74 1F 83 FB 6C 74 0A 83 FB 77 74 10 FE 45 E3 EB 16 8D 47 01 80 38 6C 74 A6 FE 45 F3 FE 45 FB EB 06 FE 4D F3 FE 4D FB 80 7D E3 00 0F 84 2F FF FF FF 80 7D F2 00 89 7D B4 75 0E 8B 45 A4 8B 30 89 45 A0 83 C0 04 89 45 A4 32 DB 38 5D FB 89 75 D4 75 12 8A 07 3C 53 74 08 3C 43 C6 45 FB FF 75 04 C6 45 FB 01 0F B6 07 83 C8 20 83 F8 6E 89 45 E8 74 2E 83 F8 63 74 0F 83 F8 7B 74 0A 8D 75 FC E8 ?? ?? ?? ?? EB 08 FF 45 FC E8 ?? ?? ?? ?? 83 F8 FF 89 45 00 0F 84 52 08 00 00 8B 75 D4 8B 7D B4 8B 4D D8 85 C9 74 0A 83 7D F4 00 0F 84 20 08 00 00 8B 45 E8 83 F8 6F 0F 8F C9 03 00 00 0F 84 C4 05 00 00 83 F8 63 0F 84 C5 02 00 00 6A 64 5A 3B C2 0F 84 B0 05 00 00 0F 8E D1 03 00 00 83 F8 67 7E 36 83 F8 69 74 1B 83 F8 6E 0F 85 BE 03 00 00 80 7D F2 00 8B 7D FC 0F 84 69 07 00 00 E9 84 07 00 00 89 55 E8 83 7D 00 2D 0F 85 82 04 00 00 C6 45 EF 01 E9 7F 04 00 00 33 DB 83 7D 00 2D 75 09 8B 45 E4 C6 00 2D 43 EB 06 83 7D 00 2B 75 0E FF 4D F4 FF 45 FC E8 ?? ?? ?? ?? 89 45 00 83 7D D8 00 75 04 83 4D F4 FF 0F B6 45 00 EB 44 8B 45 F4 FF 4D F4 85 C0 74 45 8A 45 00 8B 4D E4 FF 45 DC 88 04 0B 8D 45 C8 50 8D 45 04 50 43 53 8D 7D E4 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 69 07 00 00 FF 45 FC E8 ?? ?? ?? ?? 89 45 00 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 75 B1 8B 45 90 8B 80 BC 00 00 00 8B 00 8A 00 3A 45 00 88 45 F0 0F 85 97 00 00 00 8B 45 F4 FF 4D F4 85 C0 0F 84 89 00 00 00 FF 45 FC E8 ?? ?? ?? ?? 8B 4D E4 89 45 00 8A 45 F0 88 04 0B 8D 45 C8 50 8D 45 04 50 43 53 8D 7D E4 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 F5 06 00 00 0F B6 45 00 EB 44 8B 45 F4 FF 4D F4 85 C0 74 45 8B 45 E4 8A 4D 00 FF 45 DC 88 0C 03 8D 45 C8 50 8D 45 04 50 43 53 8D 7D E4 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 B9 06 00 00 FF 45 FC E8 ?? ?? ?? ?? 89 45 00 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 75 B1 83 7D DC 00 0F 84 ED 00 00 00 83 7D 00 65 74 0A 83 7D 00 45 0F 85 DD 00 00 00 8B 45 F4 FF 4D F4 85 C0 0F 84 CF 00 00 00 8B 45 E4 C6 04 03 65 8D 45 C8 50 8D 45 04 50 43 53 8D 7D E4 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 51 06 00 00 FF 45 FC E8 ?? ?? ?? ?? 83 F8 2D 89 45 00 75 23 8B 45 E4 C6 04 03 2D 8D 45 C8 50 8D 45 04 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 20 06 00 00 EB 06 83 7D 00 2B 75 1A 8B 45 F4 FF 4D F4 85 C0 75 05 21 45 F4 EB 0B FF 45 FC E8 ?? ?? ?? ?? 89 45 00 0F B6 45 00 EB 44 8B 45 F4 FF 4D F4 85 C0 74 45 8B 45 E4 8A 4D 00 FF 45 DC 88 0C 03 8D 45 C8 50 8D 45 04 50 43 53 8D 7D E4 8D 75 B8 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 C2 05 00 00 FF 45 FC E8 ?? ?? ?? ?? 89 45 00 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 75 B1 FF 75 00 FF 4D FC E8 ?? ?? ?? ?? 83 7D DC 00 59 0F 84 93 05 00 00 80 7D F2 00 0F 85 23 05 00 00 8B 45 E4 FF 45 C4 8D 4D 90 51 50 FF 75 D4 C6 04 03 00 0F BE 45 F3 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 83 C4 10 E9 F5 04 00 00 85 C9 75 0A FF 45 F4 C7 45 D8 01 00 00 00 80 7D FB 00 7E 04 C6 45 F1 01 FF 75 00 FF 4D FC 8B FE E8 ?? ?? ?? ?? 59 83 7D D8 00 74 0E 8B 45 F4 FF 4D F4 85 C0 0F 84 7F 02 00 00 FF 45 FC E8 ?? ?? ?? ?? 83 7D E8 63 89 45 00 74 48 83 7D E8 73 75 13 83 F8 09 7C 09 83 F8 0D 0F 8E 50 02 00 00 83 F8 20 75 2F 83 7D E8 7B 0F 85 41 02 00 00 0F BE 5D F0 33 D2 8B C8 83 E1 07 42 D3 E2 8B C8 C1 F9 03 0F BE 8C 0D 64 01 00 00 33 CB 85 D1 0F 84 1C 02 00 00 80 7D F2 00 0F 85 0C 02 00 00 80 7D F1 00 0F 84 F7 01 00 00 88 45 B0 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 74 0B FF 45 FC E8 ?? ?? ?? ?? 88 45 B1 8D 45 90 50 8B 45 90 C7 45 A8 3F 00 00 00 FF B0 AC 00 00 00 8D 45 B0 50 8D 45 A8 50 E8 ?? ?? ?? ?? 66 8B 45 A8 83 C4 10 66 89 06 46 46 E9 AC 01 00 00 83 E8 70 0F 84 F4 01 00 00 83 E8 03 0F 84 07 FF FF FF 48 48 0F 84 E7 01 00 00 83 E8 03 0F 84 5C FC FF FF 83 E8 03 74 24 0F B6 07 3B 45 00 0F 85 17 04 00 00 FE 4D EE 80 7D F2 00 0F 85 BF 03 00 00 8B 45 A0 89 45 A4 E9 B4 03 00 00 80 7D FB 00 7E 04 C6 45 F1 01 47 80 3F 5E 8B F7 75 07 8D 77 01 C6 45 F0 FF 6A 20 8D 85 64 01 00 00 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 80 3E 5D 75 0C B2 5D 46 C6 85 6F 01 00 00 20 EB 69 8A 55 C3 EB 64 46 3C 2D 75 45 84 D2 74 41 8A 0E 80 F9 5D 74 3A 46 3A D1 73 04 8A C1 EB 04 8A C2 8A D1 3A D0 77 25 2A C2 FE C0 0F B6 FA 0F B6 D0 8B CF 83 E1 07 8B C7 B3 01 D2 E3 C1 E8 03 8D 84 05 64 01 00 00 08 18 47 4A 75 E5 32 D2 EB 1A 0F B6 C8 8A D0 8B C1 83 E1 07 B3 01 C1 E8 03 D2 E3 8D 84 05 64 01 00 00 08 18 8A 06 3C 5D 75 96 84 C0 0F 84 66 03 00 00 89 75 B4 8B 75 D4 E9 18 FE FF FF 83 7D 00 2B 75 18 FF 4D F4 75 08 85 C9 74 04 B3 01 EB 0B FF 45 FC E8 ?? ?? ?? ?? 89 45 00 6A 30 5E 39 75 00 0F 85 F6 00 00 00 FF 45 FC E8 ?? ?? ?? ?? 3C 78 89 45 00 74 3C 3C 58 74 38 83 7D E8 78 C7 45 DC 01 00 00 00 74 19 83 7D D8 00 74 07 FF 4D F4 75 02 FE C3 C7 45 E8 6F 00 00 00 E9 BD 00 00 00 FF 4D FC 50 E8 ?? ?? ?? ?? 59 89 75 00 E9 AB 00 00 00 FF 45 FC E8 ?? ?? ?? ?? 83 7D D8 00 89 45 00 74 0C 83 6D F4 02 83 7D F4 01 7D 02 FE C3 C7 45 E8 78 00 00 00 E9 82 00 00 00 88 06 46 89 75 D4 E9 7D FD FF FF 47 E9 77 FD FF FF FF 4D FC 50 E8 ?? ?? ?? ?? 59 3B FE 0F 84 9A 02 00 00 80 7D F2 00 0F 85 2A 02 00 00 FF 45 C4 83 7D E8 63 0F 84 1D 02 00 00 80 7D F1 00 8B 45 D4 74 09 66 83 20 00 E9 0B 02 00 00 C6 00 00 E9 03 02 00 00 C6 45 F3 01 83 7D 00 2D 75 06 C6 45 EF 01 EB 06 83 7D 00 2B 75 18 FF 4D F4 75 08 85 C9 74 04 B3 01 EB 0B FF 45 FC E8 ?? ?? ?? ?? 89 45 00 83 7D BC 00 0F 84 EF 00 00 00 84 DB 0F 85 C2 00 00 00 83 7D E8 78 74 4D 83 7D E8 70 74 47 0F B6 45 00 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 97 00 00 00 83 7D E8 6F 75 19 83 7D 00 38 0F 8D 87 00 00 00 8B 75 CC 8B 5D D0 0F A4 F3 03 C1 E6 03 EB 49 6A 00 6A 0A FF 75 D0 FF 75 CC E8 ?? ?? ?? ?? 8B F0 8B DA EB 34 0F B6 7D 00 57 E8 ?? ?? ?? ?? 85 C0 59 74 54 8B 75 CC 8B 5D D0 0F A4 F3 04 57 C1 E6 04 E8 ?? ?? ?? ?? 85 C0 0F BE 45 00 59 75 06 83 E0 DF 83 E8 07 89 45 00 8B 45 00 FF 45 DC 83 C0 D0 99 03 F0 13 DA 83 7D D8 00 89 75 CC 89 5D D0 74 05 FF 4D F4 74 1C FF 45 FC E8 ?? ?? ?? ?? 89 45 00 E9 4A FF FF FF FF 75 00 FF 4D FC E8 ?? ?? ?? ?? 59 80 7D EF 00 8B 7D AC 0F 84 B4 00 00 00 8B 45 CC 8B 4D D0 F7 D8 83 D1 00 F7 D9 89 45 CC 89 4D D0 E9 9C 00 00 00 84 DB 8B 7D AC 0F 85 89 00 00 00 83 7D E8 78 74 2B 83 7D E8 70 74 25 0F B6 45 00 50 E8 ?? ?? ?? ?? 85 C0 59 74 62 83 7D E8 6F 75 0B 83 7D 00 38 7D 56 C1 E7 03 EB 2F 6B FF 0A EB 2A 0F B6 75 00 56 E8 ?? ?? ?? ?? 85 C0 59 74 3D 56 C1 E7 04 E8 ?? ?? ?? ?? 85 C0 0F BE 45 00 59 75 06 83 E0 DF 83 E8 07 89 45 00 FF 45 DC 83 7D D8 00 8B 45 00 8D 7C 07 D0 74 05 FF 4D F4 74 19 FF 45 FC E8 ?? ?? ?? ?? 89 45 00 EB 83 FF 75 00 FF 4D FC E8 ?? ?? ?? ?? 59 80 7D EF 00 74 02 F7 DF 83 7D E8 46 75 04 83 65 DC 00 83 7D DC 00 0F 84 92 00 00 00 80 7D F2 00 75 26 FF 45 C4 8B 75 D4 83 7D BC 00 74 0D 8B 45 CC 89 06 8B 45 D0 89 46 04 EB 0D 80 7D F3 00 74 04 89 3E EB 03 66 89 3E 8B 7D B4 FE 45 EE 47 EB 36 FF 45 FC E8 ?? ?? ?? ?? 8B D8 0F B6 07 47 3B C3 89 5D 00 75 37 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 13 FF 45 FC E8 ?? ?? ?? ?? 0F B6 0F 47 3B C8 75 1C FF 4D FC 8A 07 84 C0 0F 85 28 F6 FF FF EB 1B FF 75 00 E8 ?? ?? ?? ?? EB 10 53 EB F6 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 59 83 7D C8 01 5B 75 09 FF 75 E4 E8 ?? ?? ?? ?? 59 80 7D 9C 00 74 07 8B 45 98 83 60 70 FD 8B 45 C4 8B 8D 84 01 00 00 5F 33 CD 5E E8 ?? ?? ?? ?? 81 C5 88 01 00 00 C9 C3 }
	condition:
		$1
}

rule file_129_0_0 {
	meta:
		name = "_ValidateLocalCookies"
		size = 36
		refs = "0010 @__security_check_cookie@4"
	strings:
		$1 = { 8B 07 83 F8 FE 74 0D 8B 4F 04 03 CE 33 0C 30 E8 ?? ?? ?? ?? 8B 4F 0C 8B 47 08 03 CE 33 0C 30 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_129_1_0 {
	meta:
		name = "__except_handler4"
		size = 406
		refs = "000f ___security_cookie 0034 @__security_check_cookie@4 008a @_EH4_CallFilterFunc@8 00f3 __pDestructExceptionObject 0100 __IsNonwritableInCurrentImage 0120 @_EH4_GlobalUnwind@4 0138 @_EH4_LocalUnwind@16 0171 @_EH4_TransferToHandler@8"
	strings:
		$1 = { 83 EC 14 53 8B 5C 24 20 55 56 8B 73 08 33 35 ?? ?? ?? ?? 57 8B 06 83 F8 FE C6 44 24 13 00 C7 44 24 18 01 00 00 00 8D 7B 10 74 0D 8B 4E 04 03 CF 33 0C 38 E8 ?? ?? ?? ?? 8B 4E 0C 8B 46 08 03 CF 33 0C 38 E8 ?? ?? ?? ?? 8B 44 24 28 F6 40 04 66 0F 85 1F 01 00 00 8B 6B 0C 83 FD FE 8B 4C 24 30 8D 54 24 1C 89 44 24 1C 89 4C 24 20 89 53 FC 74 5E 8D 44 6D 00 8B 4C 86 14 85 C9 8D 5C 86 10 8B 03 89 44 24 14 74 16 8B D7 E8 ?? ?? ?? ?? 85 C0 C6 44 24 13 01 7C 44 7F 4C 8B 44 24 14 83 F8 FE 8B E8 75 CD 80 7C 24 13 00 74 24 8B 06 83 F8 FE 74 0D 8B 4E 04 03 CF 33 0C 38 E8 ?? ?? ?? ?? 8B 4E 0C 8B 46 08 03 CF 33 0C 38 E8 ?? ?? ?? ?? 8B 44 24 18 5F 5E 5D 5B 83 C4 14 C3 C7 44 24 18 00 00 00 00 EB C6 8B 4C 24 28 81 39 63 73 6D E0 75 2A 83 3D ?? ?? ?? ?? 00 74 21 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 10 8B 54 24 28 6A 01 52 FF 15 ?? ?? ?? ?? 83 C4 08 8B 4C 24 2C E8 ?? ?? ?? ?? 8B 44 24 2C 39 68 0C 74 13 68 ?? ?? ?? ?? 57 8B D5 8B C8 E8 ?? ?? ?? ?? 8B 44 24 2C 8B 4C 24 14 89 48 0C 8B 06 83 F8 FE 74 0D 8B 4E 04 03 CF 33 0C 38 E8 ?? ?? ?? ?? 8B 4E 0C 8B 56 08 03 CF 33 0C 3A E8 ?? ?? ?? ?? 8B 4B 08 8B D7 E9 ?? ?? ?? ?? 83 7B 0C FE 0F 84 50 FF FF FF 68 ?? ?? ?? ?? 57 8B CB BA FE FF FF FF E8 ?? ?? ?? ?? E9 15 FF FF FF }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "_fix_grouping"
		size = 51
	strings:
		$1 = { 32 D2 38 11 74 17 53 56 8A 01 3C 30 7C 10 3C 39 7F 0C 2C 30 88 01 41 38 11 75 ED 5E 5B C3 3C 3B 75 F4 8B C1 8D 70 01 8A 1E 88 18 8B C6 38 10 75 F3 EB E4 }
	condition:
		$1
}

rule file_130_1_0 {
	meta:
		name = "___free_lconv_num"
		size = 64
		refs = "000d ___lconv_c 0015 _free"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 74 35 8B 06 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 04 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 76 08 3B 35 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_130_2_0 {
	meta:
		name = "___init_numeric"
		size = 456
		refs = "0027 ___lconv_c 0035 __calloc_crt 005a __malloc_crt 006c _free 00bd ___getlocaleinfo 00f8 ___free_lconv_num 0174 __imp__InterlockedDecrement@4"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 8B 5D 08 56 33 F6 39 73 1C 57 89 5D E8 89 75 EC 75 17 39 73 18 75 12 89 75 FC 89 75 F8 C7 45 08 ?? ?? ?? ?? E9 3A 01 00 00 6A 30 6A 01 E8 ?? ?? ?? ?? 8B F8 3B FE 59 59 89 7D 08 75 08 33 C0 40 E9 77 01 00 00 8B B3 BC 00 00 00 6A 0C 59 6A 04 F3 A5 E8 ?? ?? ?? ?? 33 F6 3B C6 59 89 45 F8 75 0B FF 75 08 E8 ?? ?? ?? ?? 59 EB D1 89 30 39 73 1C 0F 84 BB 00 00 00 6A 04 E8 ?? ?? ?? ?? 3B C6 59 89 45 FC 75 1C 33 F6 46 FF 75 08 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 59 59 8B C6 E9 1A 01 00 00 89 30 8B 75 08 0F B7 7B 3E 56 6A 0E 57 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 89 45 F4 8D 46 04 50 6A 0F 57 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 09 45 F4 8D 46 08 50 6A 10 57 89 45 F0 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 3C 0B 45 F4 74 0C 56 E8 ?? ?? ?? ?? 59 83 CE FF EB 8E 8B 45 F0 8B 00 EB 12 8A 08 80 F9 30 7C 12 80 F9 39 7F 0D 80 E9 30 88 08 40 80 38 00 75 E9 EB 37 80 F9 3B 75 F3 8B F0 8D 7E 01 8A 0F 88 0E 8B F7 80 3E 00 75 F2 EB E2 8B 0D ?? ?? ?? ?? 8B 45 08 89 08 8B 0D ?? ?? ?? ?? 89 48 04 8B 0D ?? ?? ?? ?? 89 75 FC 89 48 08 8B 45 F8 33 C9 41 89 08 8B 45 FC 85 C0 74 02 89 08 8B 83 B4 00 00 00 85 C0 8B 35 ?? ?? ?? ?? 74 03 50 FF D6 8B 83 B0 00 00 00 85 C0 74 1F 50 FF D6 85 C0 75 18 FF B3 B0 00 00 00 E8 ?? ?? ?? ?? FF B3 BC 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 45 FC 89 83 B4 00 00 00 8B 45 F8 89 83 B0 00 00 00 8B 45 08 89 83 BC 00 00 00 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_131_0_0 {
	meta:
		name = "__getwch_nolock"
		size = 369
		refs = "0008 _wchbuf 002b __coninpfh 0033 ___initconin 0053 __imp__GetConsoleMode@8 0059 __imp__SetConsoleMode@8 006b _bUseW 0082 __imp__ReadConsoleInputW@16 0099 __imp__GetLastError@0 00d6 __imp__ReadConsoleInputA@16 0118 __getextendedkeycode 0164 __imp__GetConsoleCP@0 016b __imp__MultiByteToWideChar@24"
	strings:
		$1 = { 55 8B EC 83 EC 24 66 A1 ?? ?? ?? ?? 53 33 DB 66 3D FF FF 89 5D F8 74 11 66 81 0D ?? ?? ?? ?? FF FF 0F B7 C0 E9 22 01 00 00 83 3D ?? ?? ?? ?? FE 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 F8 FF 75 09 66 0D FF FF E9 01 01 00 00 56 57 8D 4D F0 51 50 FF 15 ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 53 FF 35 ?? ?? ?? ?? FF D7 33 F6 46 39 1D ?? ?? ?? ?? 74 54 8D 45 F4 50 56 8D 45 DC 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 24 83 3D ?? ?? ?? ?? 02 0F 85 B7 00 00 00 FF 15 ?? ?? ?? ?? 83 F8 78 0F 85 A8 00 00 00 89 1D ?? ?? ?? ?? EB 06 89 35 ?? ?? ?? ?? 39 5D F4 0F 84 91 00 00 00 39 1D ?? ?? ?? ?? 75 1E 8D 45 F4 50 56 8D 45 DC 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 70 39 5D F4 74 6B 66 39 75 DC 75 80 39 5D E0 0F 84 77 FF FF FF 39 1D ?? ?? ?? ?? 74 0F 66 39 5D EA 0F B7 45 EA 89 45 F8 75 33 EB 0A 8A 45 EA 3A C3 88 45 FF 75 44 8D 45 E0 50 E8 ?? ?? ?? ?? 3B C3 59 0F 84 44 FF FF FF 66 0F B6 08 0F B7 C9 89 4D F8 66 0F B6 40 01 66 A3 ?? ?? ?? ?? FF 75 F0 FF 35 ?? ?? ?? ?? FF D7 66 8B 45 F8 5F 5E 5B C9 C3 C7 45 F8 FF FF 00 00 EB E3 56 8D 45 F8 50 56 8D 45 FF 50 53 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? EB C9 }
	condition:
		$1
}

rule file_131_1_0 {
	meta:
		name = "__getwche_nolock"
		size = 65
		refs = "0002 _wchbuf 001b __getwch_nolock 002b __putwch_nolock"
	strings:
		$1 = { 66 A1 ?? ?? ?? ?? 66 3D FF FF 74 0D 0F B7 C0 66 81 0D ?? ?? ?? ?? FF FF C3 56 E8 ?? ?? ?? ?? 0F B7 F0 66 81 FE FF FF 74 12 56 E8 ?? ?? ?? ?? 66 3D FF FF 59 74 05 66 8B C6 5E C3 66 0D FF FF 5E C3 }
	condition:
		$1
}

rule file_131_2_0 {
	meta:
		name = "__ungetwch_nolock"
		size = 38
		refs = "000e _wchbuf"
	strings:
		$1 = { 66 8B 44 24 04 66 3D FF FF 74 16 66 81 3D ?? ?? ?? ?? FF FF 75 0B 66 25 FF 00 66 A3 ?? ?? ?? ?? C3 66 0D FF FF C3 }
	condition:
		$1
}

rule file_131_3_0 {
	meta:
		name = "__getwch"
		size = 66
		refs = "0003 __sehtable$__getwch 0008 __SEH_prolog4 000f __lock 0019 __getwch_nolock 0034 __SEH_epilog4 003c __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 E8 ?? ?? ?? ?? 0F B7 C0 89 45 E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 66 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_131_4_0 {
	meta:
		name = "__getwche"
		size = 66
		refs = "0003 __sehtable$__getwche 0008 __SEH_prolog4 000f __lock 0019 __getwche_nolock 0034 __SEH_epilog4 003c __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 E8 ?? ?? ?? ?? 0F B7 C0 89 45 E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 66 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_131_5_0 {
	meta:
		name = "__ungetwch"
		size = 72
		refs = "0003 __sehtable$__ungetwch 0008 __SEH_prolog4 000f __lock 001c __ungetwch_nolock 003a __SEH_epilog4 0042 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 0F B7 C0 89 45 E4 C7 45 FC FE FF FF FF E8 0A 00 00 00 66 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_133_1_0 {
	meta:
		name = "?Constructor@HeapManager@@QAEXP6APAXI@ZP6AXPAX@Z@Z"
		size = 27
	strings:
		$1 = { 8B 44 24 04 89 01 8B 44 24 08 89 41 04 33 C0 89 41 10 89 41 08 89 41 0C C2 08 00 }
	condition:
		$1
}

rule file_133_2_0 {
	meta:
		name = "?Destructor@HeapManager@@QAEXXZ"
		size = 38
	strings:
		$1 = { 56 8B F1 83 7E 04 00 74 1B EB 0F 8B 46 0C 8B 00 FF 76 0C 89 46 08 FF 56 04 59 8B 46 08 85 C0 89 46 0C 75 E7 5E C3 }
	condition:
		$1
}

rule file_133_3_0 {
	meta:
		name = "?getNumberOfDimensions@UnDecorator@@CAHXZ"
		size = 99
		refs = "0002 ?gName@UnDecorator@@0PBDB"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 8A 11 84 D2 75 03 33 C0 C3 80 FA 30 7C 13 80 FA 39 7F 0E 0F BE C2 83 E8 2F 41 89 0D ?? ?? ?? ?? C3 33 C0 EB 21 84 D2 74 DD 80 FA 41 7C 2B 80 FA 50 7F 26 0F BE D2 C1 E0 04 41 8D 44 10 BF 89 0D ?? ?? ?? ?? 8A 11 80 FA 40 75 DA 8A 11 41 80 FA 40 89 0D ?? ?? ?? ?? 74 03 83 C8 FF C3 }
	condition:
		$1
}

rule file_133_4_0 {
	meta:
		name = "?getTypeEncoding@UnDecorator@@CAHXZ"
		size = 1140
		refs = "0002 ?gName@UnDecorator@@0PBDB 0083 $LN116 008a $LN118 01d4 ?getTypeEncoding@UnDecorator@@CAHXZ 0329 $LN119 0438 $LN39 043c $LN38 0440 $LN49 0450 $LN15 0454 $LN14 0458 $LN13 045c $LN12 0460 $LN10 0464 $LN11 0468 $LN9 046c $LN8 0470 $LN7"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 53 55 56 57 BE 00 40 00 00 33 C0 80 39 5F 75 09 41 8B C6 89 0D ?? ?? ?? ?? 8A 11 80 FA 41 7C 05 80 FA 5A 7E 6F 80 FA 24 0F 85 C3 02 00 00 32 DB 41 89 0D ?? ?? ?? ?? 0F BE 11 83 FA 42 0F 8F B7 01 00 00 0F 84 A7 01 00 00 85 D2 0F 84 95 01 00 00 83 FA 24 0F 85 2C 01 00 00 8D 51 01 80 3A 50 75 02 8B CA 41 89 0D ?? ?? ?? ?? 0F BE 11 83 C2 BA 83 FA 0B 0F 87 6B 02 00 00 0F B6 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 41 89 0D ?? ?? ?? ?? E9 75 FF FF FF 0F BE 11 83 EA 41 BE 00 80 00 00 41 0B C6 F6 C2 01 89 0D ?? ?? ?? ?? 74 07 0D 00 20 00 00 EB 05 25 FF DF FF FF 83 FA 18 0F 8D 69 03 00 00 85 C6 BB FF 9F FF FF BD FF EF FF FF BF 00 08 00 00 74 06 23 C5 0B C7 EB 02 23 C3 8B CA 83 E1 18 74 40 83 F9 08 74 21 83 F9 10 74 0A B8 FF FF 00 00 E9 33 03 00 00 85 C6 74 07 25 3F FF FF FF EB 33 25 FF E7 FF FF EB 2C 85 C6 74 0A 83 E0 BF 0D 80 00 00 00 EB 1E 25 FF F7 FF FF 0D 00 10 00 00 EB 12 85 C6 74 0A 25 7F FF FF FF 83 C8 40 EB 04 23 C5 0B C7 83 E2 06 83 EA 00 0F 84 E9 02 00 00 4A 4A 74 26 4A 4A 74 13 4A 4A 75 A0 25 FF FC FF FF 0D 00 04 00 00 E9 CE 02 00 00 25 FF F9 FF FF 0D 00 01 00 00 E9 BF 02 00 00 85 C6 74 0F 25 FF FA FF FF 0D 00 02 00 00 E9 AC 02 00 00 23 C3 E9 A5 02 00 00 83 FA 2F 0F 8E 5F FF FF FF 83 FA 35 0F 8E 8B 00 00 00 83 FA 41 0F 85 4D FF FF FF 25 FF F4 FF FF 0D 00 90 00 00 E9 35 01 00 00 41 89 0D ?? ?? ?? ?? 8A 01 3C 30 7C 1F 3C 39 7F 1B 0F BE C0 8D 44 01 D1 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 0D 00 00 01 00 E9 4F 02 00 00 B8 FF FF 00 00 E9 FF 00 00 00 B8 FE FF 00 00 E9 F5 00 00 00 0D 00 98 00 00 E9 EB 00 00 00 83 EA 43 0F 84 DD 00 00 00 4A 0F 84 CA 00 00 00 4A 0F 84 B7 00 00 00 83 EA 0D 0F 85 D4 FE FF FF 41 89 0D ?? ?? ?? ?? B3 01 0F BE 11 BE 00 80 00 00 0B C6 83 EA 30 85 C6 BD FF EF FF FF BF 00 08 00 00 74 06 23 C5 0B C7 EB 05 25 FF 9F FF FF 84 DB 74 0C 25 FF FE FF FF 0D 00 06 00 00 EB 0A 25 FF FD FF FF 0D 00 05 00 00 F6 C2 01 74 07 0D 00 20 00 00 EB 05 25 FF DF FF FF 83 E2 06 83 EA 00 74 38 4A 4A 74 1A 4A 4A 0F 85 66 FE FF FF 85 C6 74 07 25 3F FF FF FF EB 52 25 FF E7 FF FF EB 4B 85 C6 74 0A 83 E0 BF 0D 80 00 00 00 EB 3D 25 FF F7 FF FF 0D 00 10 00 00 EB 31 85 C6 74 0A 25 7F FF FF FF 83 C8 40 EB 23 23 C5 0B C7 EB 1D 25 FF F6 FF FF 0D 00 92 00 00 EB 11 25 FF F5 FF FF 0D 00 91 00 00 EB 05 0D 00 7C 00 00 41 89 0D ?? ?? ?? ?? E9 3A 01 00 00 8A 11 80 FA 30 0F 8C 10 01 00 00 80 FA 38 0F 8F 07 01 00 00 41 0F BE D2 89 0D ?? ?? ?? ?? 8D 4A D0 25 FF 7F FF FF 83 F9 08 0F 87 CE FD FF FF FF 24 8D ?? ?? ?? ?? BE 00 80 00 00 85 C6 74 0C 25 FF FA FF FF 0D 00 02 00 00 EB 05 25 FF 9F FF FF 85 C6 74 0D 25 7F FF FF FF 83 C8 40 E9 D9 00 00 00 25 FF EF FF FF 0D 00 08 00 00 E9 CA 00 00 00 BE 00 80 00 00 85 C6 74 0C 25 FF FA FF FF 0D 00 02 00 00 EB 05 25 FF 9F FF FF 85 C6 74 0D 83 E0 BF 0D 80 00 00 00 E9 9F 00 00 00 25 FF F7 FF FF 0D 00 10 00 00 E9 90 00 00 00 BE 00 80 00 00 85 C6 74 0C 25 FF FA FF FF 0D 00 02 00 00 EB 05 25 FF 9F FF FF 85 C6 74 07 25 3F FF FF FF EB 6B 25 FF E7 FF FF EB 64 25 FF DF FF FF 0B C6 EB 5B 25 FF E3 FF FF 0D 00 60 00 00 EB 4F 25 FF BF FF FF 0D 00 20 00 00 EB 43 25 FF EB FF FF 0D 00 68 00 00 EB 37 25 FF F3 FF FF 0D 00 70 00 00 EB 2B 25 FF FB FF FF 0D 00 78 00 00 EB 1F 80 FA 39 75 0E 41 89 0D ?? ?? ?? ?? B8 FD FF 00 00 EB 0C 33 C0 84 D2 0F 95 C0 05 FE FF 00 00 5F 5E 5D 5B C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 02 00 02 01 02 00 00 01 01 02 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_133_11_0 {
	meta:
		name = "?doThisTypes@UnDecorator@@SAHXZ"
		size = 18
		refs = "0001 ?disableFlags@UnDecorator@@0KA"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 E0 60 33 C9 3C 60 0F 95 C1 8B C1 C3 }
	condition:
		$1
}

rule file_133_21_0 {
	meta:
		name = "?UScore@UnDecorator@@SAPBDW4Tokens@@@Z"
		size = 25
		refs = "0001 ?disableFlags@UnDecorator@@0KA 0010 _tokenTable"
	strings:
		$1 = { A1 ?? ?? ?? ?? F7 D0 A8 01 8B 44 24 04 8B 04 85 ?? ?? ?? ?? 75 02 40 40 C3 }
	condition:
		$1
}

rule file_133_22_0 {
	meta:
		name = "?getMemory@HeapManager@@QAEPAXIH@Z"
		size = 132
		refs = "003b _heap 0040 ?getMemory@HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 83 C7 07 83 E7 F8 83 7C 24 10 00 8B F1 74 06 57 FF 16 59 EB 64 85 FF 77 03 6A 08 5F 8B 46 10 3B C7 53 73 45 BB 00 10 00 00 3B FB 77 38 6A 01 68 04 10 00 00 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 05 83 20 00 EB 02 33 C0 85 C0 74 18 8B 4E 0C 85 C9 74 04 89 01 EB 03 89 46 08 2B DF 89 46 0C 89 5E 10 EB 09 33 C0 EB 0F 2B C7 89 46 10 8B 46 0C 8B 4E 10 8D 44 08 04 5B 5F 5E C2 08 00 }
	condition:
		$1
}

rule file_133_24_0 {
	meta:
		name = "??0DName@@QAE@PAVDNameNode@@@Z"
		size = 18
	strings:
		$1 = { 8B C1 8B 4C 24 04 81 60 04 00 F0 FF FF 89 08 C2 04 00 }
	condition:
		$1
}

rule file_133_25_0 {
	meta:
		name = "??0DName@@QAE@ABV0@@Z"
		size = 156
	strings:
		$1 = { 8B C1 8B 4C 24 04 8B 51 04 C1 E2 1C C1 FA 1C 33 50 04 56 83 E2 0F 31 50 04 8B 51 04 8B 70 04 33 D6 83 E2 10 33 D6 89 50 04 8B 71 04 33 F2 83 E6 20 33 F2 89 70 04 8B 51 04 33 D6 83 E2 40 33 D6 89 50 04 8B 71 04 33 F2 81 E6 80 00 00 00 33 F2 89 70 04 8B 11 89 10 8B D6 33 51 04 81 E2 00 01 00 00 31 50 04 8B 51 04 8B 70 04 33 D6 81 E2 00 02 00 00 33 D6 89 50 04 8B 71 04 33 F2 81 E6 00 04 00 00 33 F2 89 70 04 8B 49 04 33 CE 81 E1 00 08 00 00 33 CE 89 48 04 5E C2 04 00 }
	condition:
		$1
}

rule file_133_40_0 {
	meta:
		name = "??4DName@@QAEAAV0@ABV0@@Z"
		size = 123
	strings:
		$1 = { 8B C1 56 8B 70 04 8B CE C1 E1 1C C1 F9 1C 74 05 83 F9 02 75 62 8B 4C 24 08 8B 51 04 C1 E2 1C C1 FA 1C 33 D6 83 E2 0F 33 D6 89 50 04 8B 71 04 33 F2 83 E6 10 33 F2 89 70 04 8B 51 04 33 D6 83 E2 20 33 D6 89 50 04 8B 71 04 33 F2 83 E6 40 33 F2 89 70 04 8B 51 04 33 D6 81 E2 80 00 00 00 33 D6 89 50 04 8B 71 04 33 F2 81 E6 00 08 00 00 33 F2 89 70 04 8B 09 89 08 5E C2 04 00 }
	condition:
		$1
}

rule file_133_42_0 {
	meta:
		name = "??AReplicator@@QBEABVDName@@H@Z"
		size = 37
	strings:
		$1 = { 8B 54 24 04 83 FA 09 77 16 8B 01 83 F8 FF 74 0A 3B D0 7F 06 8B 44 91 04 EB 08 8D 41 34 EB 03 8D 41 2C C2 04 00 }
	condition:
		$1
}

rule file_133_45_0 {
	meta:
		name = "??YDNameNode@@QAEAAV0@PAV0@@Z"
		size = 41
	strings:
		$1 = { 8B C1 8B 4C 24 04 85 C9 74 1C 8B 50 04 85 D2 74 12 56 EB 02 8B D6 8B 72 04 85 F6 75 F7 89 4A 04 5E EB 03 89 48 04 C2 04 00 }
	condition:
		$1
}

rule file_133_46_0 {
	meta:
		name = "??0charNode@@QAE@D@Z"
		size = 22
		refs = "000c ??_7charNode@@6B@"
	strings:
		$1 = { 8B C1 8A 4C 24 04 83 60 04 00 C7 00 ?? ?? ?? ?? 88 48 08 C2 04 00 }
	condition:
		$1
}

rule file_133_49_0 {
	meta:
		name = "?getString@charNode@@UBEPADPADH@Z"
		size = 27
	strings:
		$1 = { 8B 44 24 04 85 C0 74 0E 83 7C 24 08 00 74 07 8A 49 08 88 08 EB 02 33 C0 C2 08 00 }
	condition:
		$1
}

rule file_133_51_0 {
	meta:
		name = "??0pDNameNode@@QAE@PAVDName@@@Z"
		size = 47
		refs = "000e ??_7pDNameNode@@6B@"
	strings:
		$1 = { 8B 54 24 04 8B C1 83 60 04 00 85 D2 C7 00 ?? ?? ?? ?? 74 15 8B 4A 04 C1 E1 1C C1 F9 1C 83 F9 01 74 05 83 F9 03 75 02 33 D2 89 50 08 C2 04 00 }
	condition:
		$1
}

rule file_133_52_0 {
	meta:
		name = "??0DNameStatusNode@@QAE@W4DNameStatus@@@Z"
		size = 37
		refs = "000f ??_7DNameStatusNode@@6B@"
	strings:
		$1 = { 8B C1 8B 4C 24 04 83 60 04 00 83 F9 02 C7 00 ?? ?? ?? ?? 89 48 08 75 05 6A 04 59 EB 02 33 C9 89 48 0C C2 04 00 }
	condition:
		$1
}

rule file_133_56_0 {
	meta:
		name = "?und_strncpy@@YAPADPADPBDI@Z"
		size = 32
	strings:
		$1 = { 83 7C 24 08 00 8B 4C 24 04 74 10 8A 02 84 C0 88 01 74 08 41 42 FF 4C 24 08 75 F0 8B 44 24 04 C3 }
	condition:
		$1
}

rule file_133_57_0 {
	meta:
		name = "?und_strncmp@@YAIPBD0I@Z"
		size = 37
	strings:
		$1 = { 83 7C 24 04 00 75 0F 33 C0 C3 8A 01 84 C0 74 0C 3A 02 75 08 41 42 FF 4C 24 04 75 EE 0F B6 01 0F B6 0A 2B C1 C3 }
	condition:
		$1
}

rule file_133_58_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ"
		size = 51
		refs = "0027 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C9 B8 00 F0 FF FF 21 45 FC 21 45 F4 51 8D 45 F8 50 51 8D 45 F0 50 FF 75 08 89 4D F8 89 4D F0 E8 ?? ?? ?? ?? 8B 45 08 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_133_59_0 {
	meta:
		name = "?getThisType@UnDecorator@@CA?AVDName@@XZ"
		size = 52
		refs = "0028 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 B8 00 F0 FF FF 21 45 FC 21 45 F4 6A 01 33 C9 8D 45 F8 50 51 8D 45 F0 50 FF 75 08 89 4D F8 89 4D F0 E8 ?? ?? ?? ?? 8B 45 08 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_133_60_0 {
	meta:
		name = "??2@YAPAXIAAVHeapManager@@H@Z"
		size = 19
		refs = "0005 _heap 000e ?getMemory@HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { FF 74 24 0C B9 ?? ?? ?? ?? FF 74 24 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_133_61_0 {
	meta:
		name = "??0DName@@QAE@PAV0@@Z"
		size = 86
		refs = "000f _heap 0014 ?getMemory@HeapManager@@QAEPAXIH@Z 0023 ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 83 7C 24 04 00 56 8B F1 74 38 6A 00 6A 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D FF 74 24 08 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 89 06 F7 D8 1B C0 83 E0 FD 83 C0 03 33 46 04 83 E0 0F 31 46 04 EB 07 83 66 04 F0 83 26 00 81 66 04 0F F0 FF FF 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_62_0 {
	meta:
		name = "??0DName@@QAE@W4DNameStatus@@@Z"
		size = 97
		refs = "0028 _heap 002d ?getMemory@HeapManager@@QAEPAXIH@Z 0039 ??0DNameStatusNode@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 83 FF 01 8B F1 74 09 83 FF 03 74 04 33 C0 EB 02 8B C7 8B 4E 04 33 C8 83 E1 0F 31 4E 04 6A 00 6A 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A 57 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 81 66 04 0F F0 FF FF 85 C0 8B 4E 04 89 06 75 09 83 E1 F3 83 C9 03 89 4E 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_63_0 {
	meta:
		name = "?isValid@DName@@QBEHXZ"
		size = 23
	strings:
		$1 = { 8B 41 04 C1 E0 1C C1 F8 1C 74 08 83 F8 02 74 03 33 C0 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_133_64_0 {
	meta:
		name = "?isEmpty@DName@@QBEHXZ"
		size = 21
		refs = "0006 ?isValid@DName@@QBEHXZ"
	strings:
		$1 = { 83 39 00 74 0C E8 ?? ?? ?? ?? 85 C0 74 03 33 C0 C3 33 C0 40 C3 }
	condition:
		$1
}

rule file_133_65_0 {
	meta:
		name = "?isUDC@DName@@QBEHXZ"
		size = 20
		refs = "0001 ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 08 F6 41 04 20 74 02 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_133_67_0 {
	meta:
		name = "?isUDTThunk@DName@@QBEHXZ"
		size = 20
		refs = "0001 ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { E8 ?? ?? ?? ?? 85 C0 75 08 F6 41 04 40 74 02 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_133_68_0 {
	meta:
		name = "?length@DName@@QBEHXZ"
		size = 37
		refs = "0004 ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { 57 33 FF E8 ?? ?? ?? ?? 85 C0 75 15 56 8B 31 EB 0B 8B 06 8B CE FF 10 8B 76 04 03 F8 85 F6 75 F1 5E 8B C7 5F C3 }
	condition:
		$1
}

rule file_133_69_0 {
	meta:
		name = "?getLastChar@DName@@QBEDXZ"
		size = 56
		refs = "0005 ?isEmpty@DName@@QBEHXZ"
	strings:
		$1 = { 56 57 33 FF E8 ?? ?? ?? ?? 85 C0 75 26 8B 31 85 F6 74 20 8B 06 8B CE FF 10 85 C0 74 02 8B FE 8B 76 04 85 F6 75 ED 85 FF 74 09 8B 07 8B CF 5F 5E FF 60 04 5F 32 C0 5E C3 }
	condition:
		$1
}

rule file_133_70_0 {
	meta:
		name = "?getString@DName@@QBEPADPADH@Z"
		size = 145
		refs = "0008 ?isEmpty@DName@@QBEHXZ 0016 ?length@DName@@QBEHXZ 0021 _heap 0026 ?getMemory@HeapManager@@QAEPAXIH@Z"
	strings:
		$1 = { 55 8B EC 56 57 8B F9 E8 ?? ?? ?? ?? 85 C0 75 6C 39 45 08 75 1E E8 ?? ?? ?? ?? 8B F0 6A 00 46 56 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 45 08 74 57 EB 03 8B 75 0C 8B 45 08 53 8B DE 8B 37 89 45 0C EB 2F 85 DB 7E 2F 8B 06 8B CE FF 10 8B F8 85 FF 74 1C 8B C3 2B C7 79 02 8B FB 8B 06 57 FF 75 0C 8B CE FF 50 08 85 C0 74 05 2B DF 01 7D 0C 8B 76 04 85 F6 75 CD 8B 45 0C 5B EB 09 83 7D 08 00 74 06 8B 45 08 C6 00 00 8B 45 08 5F 5E 5D C2 08 00 }
	condition:
		$1
}

rule file_133_71_0 {
	meta:
		name = "??_5DName@@QAEAAV0@ABV0@@Z"
		size = 53
		refs = "0014 ?isValid@DName@@QBEHXZ"
	strings:
		$1 = { 8B D1 56 8B 72 04 8B C6 83 E0 0F 3C 03 74 20 8B 4C 24 08 E8 ?? ?? ?? ?? 85 C0 75 13 8B 41 04 C1 E0 1C C1 F8 1C 33 C6 83 E0 0F 33 C6 89 42 04 8B C2 5E C2 04 00 }
	condition:
		$1
}

rule file_133_72_0 {
	meta:
		name = "??4DName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 129
		refs = "002e _heap 0036 ?getMemory@HeapManager@@QAEPAXIH@Z 0042 ??0DNameStatusNode@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 83 FF 01 8B F1 74 51 83 FF 03 74 4C 8B 46 04 8B C8 C1 E1 1C C1 F9 1C 74 05 83 F9 02 75 56 6A 00 25 0F F7 FF FF 6A 10 B9 ?? ?? ?? ?? 89 46 04 E8 ?? ?? ?? ?? 85 C0 74 0A 57 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 85 C0 89 06 75 2A 8B 46 04 83 E0 F3 83 C8 03 89 46 04 EB 1C 8B 46 04 83 26 00 8B C8 83 E1 0F 80 F9 03 74 0C 8B C8 33 CF 83 E1 0F 33 C8 89 4E 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_73_0 {
	meta:
		name = "??0Replicator@@QAE@XZ"
		size = 30
		refs = "0009 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 8B F1 6A 03 8D 4E 2C E8 ?? ?? ?? ?? 6A 01 8D 4E 34 E8 ?? ?? ?? ?? 83 0E FF 8B C6 5E C3 }
	condition:
		$1
}

rule file_133_74_0 {
	meta:
		name = "??YReplicator@@QAEAAV0@ABVDName@@@Z"
		size = 71
		refs = "000d ?isEmpty@DName@@QBEHXZ 0019 _heap 001e ?getMemory@HeapManager@@QAEPAXIH@Z 002d ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 56 8B F1 83 3E 09 74 39 8B 4C 24 08 E8 ?? ?? ?? ?? 85 C0 75 2C 50 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0D FF 74 24 08 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 08 FF 06 8B 0E 89 44 8E 04 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_75_0 {
	meta:
		name = "?clone@DNameNode@@QAEPAV1@XZ"
		size = 71
		refs = "0008 _heap 0011 ?getMemory@HeapManager@@QAEPAXIH@Z 003b ??0pDNameNode@@QAE@PAVDName@@@Z"
	strings:
		$1 = { 53 56 57 6A 00 8B F9 BE ?? ?? ?? ?? 6A 0C 8B CE E8 ?? ?? ?? ?? 8B D8 85 DB 74 26 6A 00 6A 08 8B CE E8 ?? ?? ?? ?? 85 C0 74 0B 81 60 04 00 F0 FF FF 89 38 EB 02 33 C0 50 8B CB E8 ?? ?? ?? ?? EB 02 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule file_133_76_0 {
	meta:
		name = "??0pcharNode@@QAE@PBDH@Z"
		size = 101
		refs = "0016 ??_7pcharNode@@6B@ 0037 _heap 003c ?getMemory@HeapManager@@QAEPAXIH@Z 004f ?und_strncpy@@YAPADPADPBDI@Z"
	strings:
		$1 = { 53 8B 5C 24 08 56 57 8B 7C 24 14 33 C0 3B F8 8B F1 89 46 04 C7 06 ?? ?? ?? ?? 75 14 3B D8 74 37 33 FF 38 03 74 06 47 38 04 1F 75 FA 3B F8 74 27 3B D8 74 23 50 57 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 89 46 08 89 7E 0C 74 13 57 50 8B D3 E8 ?? ?? ?? ?? 59 59 EB 06 89 46 08 89 46 0C 5F 8B C6 5E 5B C2 08 00 }
	condition:
		$1
}

rule file_133_77_0 {
	meta:
		name = "?getLastChar@pcharNode@@UBEDXZ"
		size = 18
	strings:
		$1 = { 8B 41 0C 85 C0 74 08 8B 49 08 8A 44 01 FF C3 32 C0 C3 }
	condition:
		$1
}

rule file_133_78_0 {
	meta:
		name = "?getString@pcharNode@@UBEPADPADH@Z"
		size = 49
		refs = "0028 ?und_strncpy@@YAPADPADPBDI@Z"
	strings:
		$1 = { 8B 41 0C 8B 54 24 08 3B D0 7E 02 8B D0 8B 49 08 33 C0 3B C8 74 18 39 44 24 04 74 12 3B D0 74 0E 52 FF 74 24 08 8B D1 E8 ?? ?? ?? ?? 59 59 C2 08 00 }
	condition:
		$1
}

rule file_133_81_0 {
	meta:
		name = "?getString@pDNameNode@@UBEPADPADH@Z"
		size = 29
		refs = "0016 ?getString@DName@@QBEPADPADH@Z"
	strings:
		$1 = { 8B 49 08 33 C0 3B C8 74 11 39 44 24 04 74 0B 39 44 24 08 74 05 E9 ?? ?? ?? ?? C2 08 00 }
	condition:
		$1
}

rule file_133_82_0 {
	meta:
		name = "?getString@DNameStatusNode@@UBEPADPADH@Z"
		size = 51
		refs = "0025 ??_C@_04OKOHEJBO@?5?$DP?$DP?5?$AA@ 002a ?und_strncpy@@YAPADPADPBDI@Z"
	strings:
		$1 = { 8B 41 0C 8B 54 24 08 3B D0 7E 02 8B D0 33 C0 83 79 08 02 75 1B 39 44 24 04 74 15 3B D0 74 11 52 FF 74 24 08 BA ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 C2 08 00 }
	condition:
		$1
}

rule file_133_83_0 {
	meta:
		name = "??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z"
		size = 115
		refs = "0008 ??0Replicator@@QAE@XZ 001a ?name@UnDecorator@@0PBDB 001f ?gName@UnDecorator@@0PBDB 0032 ?maxStringLength@UnDecorator@@0HA 0037 ?outputString@UnDecorator@@0PADA 004d ?disableFlags@UnDecorator@@0KA 0056 ?pZNameList@UnDecorator@@0PAVReplicator@@A 005b ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0062 ?pArgList@UnDecorator@@0PAVReplicator@@A 006a ?fExplicitTemplateParams@UnDecorator@@0_NA"
	strings:
		$1 = { 55 8B EC 56 57 8B F1 E8 ?? ?? ?? ?? 8D 7E 3C 8B CF E8 ?? ?? ?? ?? 8B 45 0C A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8B 45 08 33 C9 3B C1 74 11 8B 55 10 4A 89 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? EB 0C 89 0D ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 8B 45 18 A3 ?? ?? ?? ?? 8B 45 14 89 3D ?? ?? ?? ?? A3 ?? ?? ?? ?? 5F 89 35 ?? ?? ?? ?? 8B C6 88 0D ?? ?? ?? ?? 5E 5D C2 14 00 }
	condition:
		$1
}

rule file_133_84_0 {
	meta:
		name = "?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z"
		size = 47
		refs = "0004 ?gName@UnDecorator@@0PBDB 001a ??0DName@@QAE@PAV0@@Z 0024 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 80 38 40 FF 75 0C 75 10 8B 4D 08 FF 05 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 0A FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_133_86_0 {
	meta:
		name = "??YDName@@QAEAAV0@W4DNameStatus@@@Z"
		size = 121
		refs = "0005 ?isEmpty@DName@@QBEHXZ 0020 _heap 0025 ?getMemory@HeapManager@@QAEPAXIH@Z 0031 ??0DNameStatusNode@@QAE@W4DNameStatus@@@Z 0042 ?clone@DNameNode@@QAEPAV1@XZ 0050 ??YDNameNode@@QAEAAV0@PAV0@@Z 006e ??4DName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 57 8B F1 E8 ?? ?? ?? ?? 85 C0 8B 7C 24 0C 75 5B 83 FF 01 74 56 83 FF 03 74 51 6A 00 6A 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 57 8B C8 E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 85 FF 74 17 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 12 57 8B C8 E8 ?? ?? ?? ?? EB 03 83 26 00 83 3E 00 75 14 8B 46 04 83 E0 F3 83 C8 03 89 46 04 EB 06 57 E8 ?? ?? ?? ?? 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_87_0 {
	meta:
		name = "??4DName@@QAEAAV0@PAV0@@Z"
		size = 104
		refs = "0026 _heap 002e ?getMemory@HeapManager@@QAEPAXIH@Z 003d ??0pDNameNode@@QAE@PAVDName@@@Z 005e ??4DName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 8B F1 8B 46 04 8B C8 C1 E1 1C C1 F9 1C 74 05 83 F9 02 75 4D 83 7C 24 08 00 74 3D 6A 00 25 0F F7 FF FF 6A 0C B9 ?? ?? ?? ?? 89 46 04 E8 ?? ?? ?? ?? 85 C0 74 0D FF 74 24 08 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 85 C0 89 06 75 17 8B 46 04 83 E0 F3 83 C8 03 89 46 04 EB 09 6A 03 8B CE E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_88_0 {
	meta:
		name = "?doPchar@DName@@AAEXPBDH@Z"
		size = 166
		refs = "002c ??4DName@@QAEAAV0@W4DNameStatus@@@Z 004a _heap 0053 ?getMemory@HeapManager@@QAEPAXIH@Z 0063 ??0pcharNode@@QAE@PBDH@Z 008e ??_7charNode@@6B@"
	strings:
		$1 = { 56 8B F1 8B 46 04 8B C8 C1 E1 1C C1 F9 1C 83 F9 01 0F 84 8B 00 00 00 83 F9 03 0F 84 82 00 00 00 53 33 DB 39 1E 74 0B 6A 03 8B CE E8 ?? ?? ?? ?? EB 6F 57 8B 7C 24 10 3B FB 74 5C 8B 4C 24 14 3B CB 74 54 2B CB 74 2D 49 53 B9 ?? ?? ?? ?? 74 2C 6A 10 E8 ?? ?? ?? ?? 3B C3 74 0E FF 74 24 14 8B C8 57 E8 ?? ?? ?? ?? EB 02 33 C0 3B C3 89 06 75 2F 8B 46 04 83 E0 F3 83 C8 03 EB 21 6A 0C E8 ?? ?? ?? ?? 3B C3 74 E2 8A 0F 89 58 04 C7 00 ?? ?? ?? ?? 88 48 08 EB D4 83 E0 F1 83 C8 01 89 46 04 5F 5B 5E C2 08 00 }
	condition:
		$1
}

rule file_133_89_0 {
	meta:
		name = "??0DName@@QAE@D@Z"
		size = 38
		refs = "001c ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 56 8B F1 83 26 00 81 66 04 00 F0 FF FF 80 7C 24 08 00 74 0C 6A 01 8D 44 24 0C 50 E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_90_0 {
	meta:
		name = "??0DName@@QAE@PBD@Z"
		size = 49
		refs = "0027 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 8B 44 24 04 56 8B F1 81 66 04 00 F0 FF FF 33 D2 3B C2 89 16 74 15 33 C9 38 10 74 06 41 38 14 01 75 FA 51 50 8B CE E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_91_0 {
	meta:
		name = "??0DName@@QAE@AAPBDD@Z"
		size = 208
		refs = "006a ?disableFlags@UnDecorator@@0KA 0084 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 55 8B EC 53 56 8B F1 81 66 04 00 F0 FF FF 8B 46 04 33 DB 57 8B 7D 08 89 1E 8B 0F 3B CB 0F 84 86 00 00 00 38 19 0F 84 9D 00 00 00 8B 17 8A 02 3A 45 0C 74 4B 3C 5F 74 3C 3C 24 74 38 3C 3C 74 34 3C 3E 74 30 3C 2D 74 2C 3C 61 7C 04 3C 7A 7E 24 3C 41 7C 04 3C 5A 7E 1C 3C 30 7C 04 3C 39 7E 14 3C 80 72 04 3C FE 76 0C F7 05 ?? ?? ?? ?? 00 00 01 00 74 32 43 42 8B C2 89 17 80 38 00 75 AC 53 51 8B CE E8 ?? ?? ?? ?? 8B 07 8A 08 84 C9 74 31 40 3A 4D 0C 89 07 74 23 8B 46 04 83 E0 F3 83 C8 03 83 26 00 EB 09 8B 46 04 83 E0 F1 83 C8 01 89 46 04 5F 8B C6 5E 5B 5D C2 08 00 83 66 04 F0 EB F1 8B 46 04 A8 0F 75 EA 83 E0 F2 83 C8 02 EB DF }
	condition:
		$1
}

rule file_133_92_0 {
	meta:
		name = "??0DName@@QAE@_K@Z"
		size = 105
		refs = "0007 ___security_cookie 0032 __aulldvrm 0052 ?doPchar@DName@@AAEXPBDH@Z 0061 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B F9 83 27 00 81 67 04 00 F0 FF FF 8D 75 F8 C6 45 F8 00 6A 00 6A 0A FF 75 0C 4E FF 75 08 E8 ?? ?? ?? ?? 80 C1 30 89 45 08 0B C2 89 5D E0 88 0E 89 55 0C 75 DE 8D 45 F8 2B C6 50 56 8B CF E8 ?? ?? ?? ?? 8B 4D FC 8B C7 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C2 08 00 }
	condition:
		$1
}

rule file_133_93_0 {
	meta:
		name = "??0DName@@QAE@_J@Z"
		size = 151
		refs = "0007 ___security_cookie 0054 __aulldvrm 0081 ?doPchar@DName@@AAEXPBDH@Z 008f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 28 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 56 8B F1 81 66 04 00 F0 FF FF 33 C9 3B C1 57 8D 7D F9 89 0E 88 4D F9 88 4D E3 7F 17 7C 05 39 4D 08 73 10 8B 55 08 F7 DA 13 C1 C6 45 E3 01 F7 D8 89 55 08 53 EB 02 33 C9 51 6A 0A 50 FF 75 08 4F E8 ?? ?? ?? ?? 80 C1 30 89 45 08 88 0F 8B 4D 08 8B C2 0B C8 89 5D DC 75 DD 80 7D E3 00 5B 74 04 4F C6 07 2D 8D 45 F9 2B C7 50 57 8B CE E8 ?? ?? ?? ?? 8B 4D FC 5F 8B C6 33 CD 5E E8 ?? ?? ?? ?? C9 C2 08 00 }
	condition:
		$1
}

rule file_133_94_0 {
	meta:
		name = "??HDName@@QBE?AV0@W4DNameStatus@@@Z"
		size = 46
		refs = "0009 ??0DName@@QAE@ABV0@@Z 0010 ?isEmpty@DName@@QBEHXZ 001d ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0024 ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 56 8B 74 24 08 51 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 FF 74 24 0C 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B C6 5E C2 08 00 }
	condition:
		$1
}

rule file_133_110_0 {
	meta:
		name = "??HDName@@QBE?AV0@D@Z"
		size = 46
		refs = "0009 ??0DName@@QAE@ABV0@@Z 0010 ?isEmpty@DName@@QBEHXZ 001d ??4DName@@QAEAAV0@D@Z 0024 ??YDName@@QAEAAV0@D@Z"
	strings:
		$1 = { 56 8B 74 24 08 51 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 FF 74 24 0C 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B C6 5E C2 08 00 }
	condition:
		$1
}

rule file_133_102_0 {
	meta:
		name = "??HDName@@QBE?AV0@PAV0@@Z"
		size = 46
		refs = "0009 ??0DName@@QAE@ABV0@@Z 0010 ?isEmpty@DName@@QBEHXZ 001d ??4DName@@QAEAAV0@PAV0@@Z 0024 ??YDName@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 56 8B 74 24 08 51 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 FF 74 24 0C 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B C6 5E C2 08 00 }
	condition:
		$1
}

rule file_133_111_0 {
	meta:
		name = "??HDName@@QBE?AV0@PBD@Z"
		size = 46
		refs = "0009 ??0DName@@QAE@ABV0@@Z 0010 ?isEmpty@DName@@QBEHXZ 001d ??4DName@@QAEAAV0@PBD@Z 0024 ??YDName@@QAEAAV0@PBD@Z"
	strings:
		$1 = { 56 8B 74 24 08 51 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 FF 74 24 0C 74 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 8B C6 5E C2 08 00 }
	condition:
		$1
}

rule file_133_95_0 {
	meta:
		name = "??YDName@@QAEAAV0@ABV0@@Z"
		size = 98
		refs = "000b ?isEmpty@DName@@QBEHXZ 0020 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0031 ??4DName@@QAEAAV0@ABV0@@Z 003a ?clone@DNameNode@@QAEPAV1@XZ 0049 ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 8B F1 8B CF E8 ?? ?? ?? ?? 85 C0 8B CE 74 11 8B 47 04 C1 E0 1C C1 F8 1C 50 E8 ?? ?? ?? ?? EB 35 E8 ?? ?? ?? ?? 85 C0 74 08 57 E8 ?? ?? ?? ?? EB 24 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 0B FF 37 8B C8 E8 ?? ?? ?? ?? EB 0C 8B 46 04 83 E0 F3 83 C8 03 89 46 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_96_0 {
	meta:
		name = "??YDName@@QAEAAV0@PAV0@@Z"
		size = 139
		refs = "000d ?isEmpty@DName@@QBEHXZ 0017 ??4DName@@QAEAAV0@PAV0@@Z 002f ??YDName@@QAEAAV0@W4DNameStatus@@@Z 003a _heap 003f ?getMemory@HeapManager@@QAEPAXIH@Z 004b ??0pDNameNode@@QAE@PAVDName@@@Z 005c ?clone@DNameNode@@QAEPAV1@XZ 006a ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 85 FF 8B F1 74 78 E8 ?? ?? ?? ?? 85 C0 74 08 57 E8 ?? ?? ?? ?? EB 67 8B 47 04 C1 E0 1C C1 F8 1C 74 0D 83 F8 02 74 08 50 E8 ?? ?? ?? ?? EB 4F 6A 00 6A 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 57 8B C8 E8 ?? ?? ?? ?? 8B F8 EB 02 33 FF 85 FF 74 17 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 12 57 8B C8 E8 ?? ?? ?? ?? EB 03 83 26 00 83 3E 00 75 0C 8B 46 04 83 E0 F3 83 C8 03 89 46 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_97_0 {
	meta:
		name = "??4DName@@QAEAAV0@D@Z"
		size = 28
		refs = "0012 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 56 6A 01 8D 44 24 0C 8B F1 81 66 04 0F F7 FF FF 50 E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_98_0 {
	meta:
		name = "??4DName@@QAEAAV0@PBD@Z"
		size = 42
		refs = "0020 ?doPchar@DName@@AAEXPBDH@Z"
	strings:
		$1 = { 8B 44 24 04 56 8B F1 81 66 04 0F F7 FF FF 33 C9 38 08 74 07 41 80 3C 01 00 75 F9 51 50 8B CE E8 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_99_0 {
	meta:
		name = "?getCallingConvention@UnDecorator@@CA?AVDName@@XZ"
		size = 166
		refs = "0006 ?gName@UnDecorator@@0PBDB 0027 ?disableFlags@UnDecorator@@0KA 0075 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 0081 ??4DName@@QAEAAV0@PBD@Z 008d ??0DName@@QAE@ABV0@@Z 009d ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 83 00 00 00 0F BE C0 83 E8 41 FF 05 ?? ?? ?? ?? 83 F8 0C 77 6E 8B 0D ?? ?? ?? ?? 83 65 F8 00 81 65 FC 00 F0 FF FF D1 E9 F7 D1 F6 C1 01 74 46 83 E0 FE 83 E8 00 74 2B 6A 02 59 2B C1 74 21 2B C1 74 19 2B C1 74 11 2B C1 74 09 83 E8 04 75 26 6A 06 EB 11 6A 05 EB 0D 6A 03 EB 09 6A 04 EB 05 51 EB 02 6A 01 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? EB 0E 6A 01 EB 02 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_100_0 {
	meta:
		name = "?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ"
		size = 55
		refs = "0004 ?gName@UnDecorator@@0PBDB 0020 ??_C@_06EEGAIFAK@?$HLflat?$HN?$AA@ 0025 ??0DName@@QAE@PBD@Z 002e ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8A 00 84 C0 8B 4D 08 74 1A 3C 41 74 04 6A 01 EB 14 FF 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 07 6A 02 E8 ?? ?? ?? ?? 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_133_101_0 {
	meta:
		name = "??HDName@@QBE?AV0@ABV0@@Z"
		size = 81
		refs = "0009 ??0DName@@QAE@ABV0@@Z 0010 ?isEmpty@DName@@QBEHXZ 001d ??4DName@@QAEAAV0@ABV0@@Z 003d ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0047 ??YDName@@QAEAAV0@ABV0@@Z"
	strings:
		$1 = { 56 8B 74 24 08 51 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 74 0B FF 74 24 0C E8 ?? ?? ?? ?? EB 28 8B 4C 24 0C E8 ?? ?? ?? ?? 85 C0 74 13 8B 41 04 C1 E0 1C C1 F8 1C 50 8B CE E8 ?? ?? ?? ?? EB 08 51 8B CE E8 ?? ?? ?? ?? 8B C6 5E C2 08 00 }
	condition:
		$1
}

rule file_133_103_0 {
	meta:
		name = "??YDName@@QAEAAV0@D@Z"
		size = 106
		refs = "000d ?isEmpty@DName@@QBEHXZ 0017 ??4DName@@QAEAAV0@D@Z 0020 ?clone@DNameNode@@QAEPAV1@XZ 002f _heap 0034 ?getMemory@HeapManager@@QAEPAXIH@Z 0042 ??_7charNode@@6B@ 0051 ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 53 8B 5C 24 08 84 DB 56 8B F1 74 57 E8 ?? ?? ?? ?? 85 C0 74 08 53 E8 ?? ?? ?? ?? EB 46 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 2D 6A 00 6A 0C B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0F 83 60 04 00 C7 00 ?? ?? ?? ?? 88 58 08 EB 02 33 C0 8B 0E 50 E8 ?? ?? ?? ?? EB 0C 8B 46 04 83 E0 F3 83 C8 03 89 46 04 8B C6 5E 5B C2 04 00 }
	condition:
		$1
}

rule file_133_104_0 {
	meta:
		name = "??YDName@@QAEAAV0@PBD@Z"
		size = 108
		refs = "0012 ?isEmpty@DName@@QBEHXZ 001c ??4DName@@QAEAAV0@PBD@Z 0025 ?clone@DNameNode@@QAEPAV1@XZ 0034 _heap 0039 ?getMemory@HeapManager@@QAEPAXIH@Z 0047 ??0pcharNode@@QAE@PBDH@Z 0053 ??YDNameNode@@QAEAAV0@PAV0@@Z"
	strings:
		$1 = { 56 57 8B 7C 24 0C 85 FF 8B F1 74 59 80 3F 00 74 54 E8 ?? ?? ?? ?? 85 C0 74 08 57 E8 ?? ?? ?? ?? EB 43 8B 0E E8 ?? ?? ?? ?? 85 C0 89 06 74 2A 6A 00 6A 10 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0C 6A 00 57 8B C8 E8 ?? ?? ?? ?? EB 02 33 C0 8B 0E 50 E8 ?? ?? ?? ?? EB 0C 8B 46 04 83 E0 F3 83 C8 03 89 46 04 5F 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_133_105_0 {
	meta:
		name = "?getArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 224
		refs = "002a ?gName@UnDecorator@@0PBDB 0053 ??YDName@@QAEAAV0@D@Z 0071 ?pArgList@UnDecorator@@0PAVReplicator@@A 007b ??AReplicator@@QBEABVDName@@H@Z 0093 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 00b5 ??YReplicator@@QAEAAV0@ABVDName@@@Z 00c0 ??YDName@@QAEAAV0@ABV0@@Z 00d5 ??YDName@@QAEAAV0@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 8B 75 08 83 26 00 57 BF 00 F0 FF FF 21 7E 04 8B 46 04 A8 0F C7 45 FC 01 00 00 00 0F 85 B2 00 00 00 53 A1 ?? ?? ?? ?? 8A 08 80 F9 40 0F 84 A0 00 00 00 80 F9 5A 0F 84 97 00 00 00 83 7D FC 00 74 06 83 65 FC 00 EB 0E 6A 2C 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 08 84 C9 74 6E 0F BE C9 83 E9 30 83 F9 09 77 14 40 51 8B 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 3B 83 65 F4 00 21 7D F8 8B D8 8D 45 F4 50 8D 45 EC 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B C3 83 F8 01 59 59 7E 14 8B 0D ?? ?? ?? ?? 83 39 09 74 09 8D 45 EC 50 E8 ?? ?? ?? ?? 8D 45 EC 50 8B CE E8 ?? ?? ?? ?? F6 46 04 0F 0F 84 5B FF FF FF EB 09 6A 02 8B CE E8 ?? ?? ?? ?? 5B 5F 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_133_106_0 {
	meta:
		name = "?getVdispMapType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 79
		refs = "000f ??0DName@@QAE@ABV0@@Z 0014 ??_C@_05JIBOFOHK@?$HLfor?5?$AA@ 001b ??YDName@@QAEAAV0@PBD@Z 0024 ?getScope@UnDecorator@@CA?AVDName@@XZ 002d ??YDName@@QAEAAV0@ABV0@@Z 0036 ??YDName@@QAEAAV0@D@Z 003b ?gName@UnDecorator@@0PBDB"
	strings:
		$1 = { 55 8B EC 51 51 56 8B 75 08 FF 75 0C 8B CE E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 59 50 8B CE E8 ?? ?? ?? ?? 6A 7D 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 75 06 FF 05 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_133_107_0 {
	meta:
		name = "??H@YA?AVDName@@DABV0@@Z"
		size = 34
		refs = "0012 ??0DName@@QAE@D@Z 0019 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 10 8D 4D F8 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_109_0 {
	meta:
		name = "??H@YA?AVDName@@PBDABV0@@Z"
		size = 34
		refs = "0012 ??0DName@@QAE@PBD@Z 0019 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 10 8D 4D F8 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_108_0 {
	meta:
		name = "??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
		size = 34
		refs = "0012 ??0DName@@QAE@W4DNameStatus@@@Z 0019 ??HDName@@QBE?AV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 FF 75 10 8D 4D F8 FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_112_0 {
	meta:
		name = "?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
		size = 321
		refs = "0009 ?gName@UnDecorator@@0PBDB 001b ??_C@_0BN@IBLMMFAP@?$GAnon?9type?9template?9parameter?$AA@ 0031 ??0DName@@QAE@W4DNameStatus@@@Z 005b ??0DName@@QAE@_K@Z 0068 ??H@YA?AVDName@@PBDABV0@@Z 007e ??0DName@@QAE@ABV0@@Z 00ae __allmul 00e9 ??0DName@@QAE@_J@Z"
	strings:
		$1 = { 55 8B EC 83 EC 1C 56 8B 35 ?? ?? ?? ?? 33 C9 80 3E 51 89 4D FC 75 0E 46 C7 45 FC ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 8A 06 3A C1 75 0F 8B 4D 08 6A 02 E8 ?? ?? ?? ?? E9 01 01 00 00 3C 30 7C 49 3C 39 7F 45 0F BE 06 83 E8 2F 99 46 39 4D FC 52 89 35 ?? ?? ?? ?? 50 74 1A 8D 4D F4 E8 ?? ?? ?? ?? 50 FF 75 FC 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C EB 08 8D 4D E4 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? E9 B4 00 00 00 53 57 33 FF EB 39 84 C0 74 5E 3C 41 7C 66 3C 50 7F 62 0F BE C0 83 E8 41 6A 00 99 6A 10 8B D8 57 8B C2 51 89 45 F8 E8 ?? ?? ?? ?? 03 D8 8B 45 F8 13 C2 46 8B F8 89 35 ?? ?? ?? ?? 8A 06 8B CB 3C 40 75 C3 8A 06 46 3C 40 89 35 ?? ?? ?? ?? 75 24 33 C0 38 45 0C 57 51 74 29 39 45 FC 74 1A 8D 4D E4 E8 ?? ?? ?? ?? EB 27 6A 02 8B 4D 08 E8 ?? ?? ?? ?? EB 3E 6A 01 EB F2 8D 4D F4 E8 ?? ?? ?? ?? EB 27 39 45 FC 74 1A 8D 4D E4 E8 ?? ?? ?? ?? 50 FF 75 FC 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C EB 08 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? 5F 5B 8B 45 08 5E C9 C3 }
	condition:
		$1
}

rule file_133_113_0 {
	meta:
		name = "?getEnumType@UnDecorator@@CA?AVDName@@XZ"
		size = 212
		refs = "0007 ?gName@UnDecorator@@0PBDB 002e $LN21 0033 ??_C@_05CIHEBHNO@char?5?$AA@ 003a ??_C@_06EHJMALKF@short?5?$AA@ 0041 ??_C@_04LAHKHJMA@int?5?$AA@ 0048 ??_C@_05CJIMAING@long?5?$AA@ 0050 ??4DName@@QAEAAV0@PBD@Z 007b ??_C@_09EBBEKKIH@unsigned?5?$AA@ 0081 ??H@YA?AVDName@@PBDABV0@@Z 008d ??4DName@@QAEAAV0@ABV0@@Z 0099 ??0DName@@QAE@ABV0@@Z 00a9 ??0DName@@QAE@W4DNameStatus@@@Z 00b4 $LN10 00bc $LN9 00c4 $LN11 00c8 $LN7 00cc $LN6"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 8A 00 83 65 F8 00 81 65 FC 00 F0 FF FF 84 C0 0F 84 83 00 00 00 0F BE C0 83 C0 D0 83 F8 07 77 74 FF 24 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB 13 68 ?? ?? ?? ?? EB 0C 68 ?? ?? ?? ?? EB 05 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 00 FF 05 ?? ?? ?? ?? 83 E8 31 74 0C 48 48 74 08 48 48 74 04 48 48 75 1E 8D 45 F8 50 8D 45 F0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? EB 0E 6A 01 EB 02 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_133_114_0 {
	meta:
		name = "?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 196
		refs = "0004 ?gName@UnDecorator@@0PBDB 0020 ?getArgumentList@UnDecorator@@CA?AVDName@@XZ 0044 ??0DName@@QAE@W4DNameStatus@@@Z 004b ?disableFlags@UnDecorator@@0KA 005d ??_C@_04EENFHACM@?0?4?4?4?$AA@ 0064 ??_C@_0M@ELJOJFFH@?0?$DMellipsis?$DO?$AA@ 0071 ??HDName@@QBE?AV0@PBD@Z 007a ??0DName@@QAE@ABV0@@Z 009e ??_C@_03KHICJKCI@?4?4?4?$AA@ 00a5 ??_C@_0L@EGPHHEKN@?$DMellipsis?$DO?$AA@ 00b3 ??_C@_04GKJNKENE@void?$AA@ 00bb ??0DName@@QAE@PBD@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 0F BE 00 83 EC 10 83 E8 58 0F 84 95 00 00 00 48 48 74 70 8D 45 F8 50 E8 ?? ?? ?? ?? F6 45 FC 0F 59 75 5B A1 ?? ?? ?? ?? 8A 00 84 C0 74 50 3C 40 74 46 3C 5A 74 0C 8B 4D 08 6A 01 E8 ?? ?? ?? ?? EB 75 A1 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? C1 E8 12 F7 D0 A8 01 B8 ?? ?? ?? ?? 75 05 B8 ?? ?? ?? ?? 50 8D 45 F0 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 50 E8 ?? ?? ?? ?? EB 3F FF 05 ?? ?? ?? ?? 8D 45 F8 EB EA A1 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? C1 E8 12 F7 D0 A8 01 B8 ?? ?? ?? ?? 75 05 B8 ?? ?? ?? ?? 50 EB 0B FF 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_115_0 {
	meta:
		name = "?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
		size = 126
		refs = "0004 ?gName@UnDecorator@@0PBDB 002e ??0DName@@QAE@ABV0@@Z 003b ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 0044 ??_C@_07HDJPLPEK@?5throw?$CI?$AA@ 004a ??H@YA?AVDName@@PBDABV0@@Z 0067 ??0DName@@QAE@PBD@Z 006e ??HDName@@QBE?AV0@W4DNameStatus@@@Z 0075 ??HDName@@QBE?AV0@D@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8A 00 83 EC 10 84 C0 74 42 3C 5A 8D 45 F8 75 1C 8B 4D 08 FF 05 ?? ?? ?? ?? 83 65 F8 00 81 65 FC 00 F0 FF FF 50 E8 ?? ?? ?? ?? EB 45 6A 29 FF 75 08 50 E8 ?? ?? ?? ?? 50 8D 45 F0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 EB 1F 6A 29 FF 75 08 8D 45 F0 6A 02 50 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_116_0 {
	meta:
		name = "?getExtendedDataIndirectType@UnDecorator@@CA?AVDName@@AADAA_NH@Z"
		size = 293
		refs = "0008 ?gName@UnDecorator@@0PBDB 005d ??4DName@@QAEAAV0@D@Z 0068 ??0DName@@QAE@_K@Z 0075 ??HDName@@QBE?AV0@ABV0@@Z 007e ??4DName@@QAEAAV0@ABV0@@Z 008c ??HDName@@QBE?AV0@D@Z 00d7 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 28 8B 15 ?? ?? ?? ?? 83 65 F8 00 56 BE 00 F0 FF FF 21 75 FC 42 89 15 ?? ?? ?? ?? 0F BE 02 8B C8 83 E9 41 0F 84 CC 00 00 00 49 0F 84 B3 00 00 00 49 0F 84 A4 00 00 00 0F BE 4A 01 83 C0 D0 C1 E0 04 42 8D 74 08 D0 42 83 FE 01 89 15 ?? ?? ?? ?? 76 2B 6A 2C 8D 4D F8 E8 ?? ?? ?? ?? 6A 00 56 8D 4D F0 E8 ?? ?? ?? ?? 50 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 6A 3E 8D 45 E0 50 8D 4D F8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 24 75 08 FF 05 ?? ?? ?? ?? EB 17 6A 5E 8D 45 D8 50 8D 4D F8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 FF 05 ?? ?? ?? ?? 81 4D FC 00 04 00 00 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 EB 42 8B 45 0C C6 00 25 EB 2B 8B 45 10 6A 3E 8D 4D F8 C6 00 01 E8 ?? ?? ?? ?? EB 19 83 7D 14 00 75 13 8B 45 0C 80 38 26 0F 95 C1 FE C9 80 E1 C7 80 C1 5E 88 08 8B 45 08 FF 05 ?? ?? ?? ?? 83 20 00 21 70 04 5E C9 C3 }
	condition:
		$1
}

rule file_133_117_0 {
	meta:
		name = "?getArrayType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 351
		refs = "0004 ?gName@UnDecorator@@0PBDB 0016 ?getNumberOfDimensions@UnDecorator@@CAHXZ 0038 ??0DName@@QAE@D@Z 003f ??HDName@@QBE?AV0@W4DNameStatus@@@Z 0046 ??HDName@@QBE?AV0@D@Z 004f ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0071 ??_C@_02GPECMEKF@?$FL?$FN?$AA@ 0079 ??YDName@@QAEAAV0@PBD@Z 008b ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0097 ??H@YA?AVDName@@DABV0@@Z 00aa ??YDName@@QAEAAV0@ABV0@@Z 00b5 ?isEmpty@DName@@QBEHXZ 00ea ??HDName@@QBE?AV0@ABV0@@Z 00f3 ??4DName@@QAEAAV0@ABV0@@Z 0100 ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0115 ??0DName@@QAE@ABV0@@Z 013c ??_C@_02GOGNNPBN@?$CJ?$FL?$AA@ 0156 ??HDName@@QBE?AV0@PBD@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 28 80 38 00 57 0F 84 0A 01 00 00 E8 ?? ?? ?? ?? 8B F8 85 FF 7D 04 33 FF 85 FF 75 35 8D 45 F0 6A 5D 50 8D 45 F8 6A 02 50 6A 5B 8D 4D E8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 5F C9 C3 83 65 F8 00 81 65 FC 00 F0 FF FF 56 8B 75 0C F6 46 04 80 74 0D 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 6A 5D 8D 45 E8 50 8D 45 E0 6A 00 50 4F E8 ?? ?? ?? ?? 50 8D 45 D8 6A 5B 50 E8 ?? ?? ?? ?? 83 C4 14 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 85 FF 75 CB 8B CE E8 ?? ?? ?? ?? 85 C0 75 3A F6 46 04 80 8D 45 F8 50 8D 45 D8 50 75 1E 6A 29 8D 45 E0 50 56 8D 45 E8 6A 28 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 8D 45 F0 50 E8 ?? ?? ?? ?? 81 4D F4 80 00 00 00 59 59 8B 4D 08 8D 45 F0 50 E8 ?? ?? ?? ?? 5E E9 36 FF FF FF 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 8D 45 D8 6A 5D 50 8D 45 E0 0F 85 F7 FE FF FF 6A 02 50 68 ?? ?? ?? ?? 8D 45 E8 50 51 8D 45 F0 6A 28 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? E9 DD FE FF FF }
	condition:
		$1
}

rule file_133_118_0 {
	meta:
		name = "?getLexicalFrame@UnDecorator@@CA?AVDName@@XZ"
		size = 49
		refs = "0012 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 001e ??H@YA?AVDName@@DABV0@@Z 0028 ??HDName@@QBE?AV0@D@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 27 FF 75 08 8D 45 F8 6A 00 50 E8 ?? ?? ?? ?? 50 8D 45 F0 6A 60 50 E8 ?? ?? ?? ?? 83 C4 14 8B C8 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_119_0 {
	meta:
		name = "?getDisplacement@UnDecorator@@CA?AVDName@@XZ"
		size = 18
		refs = "0007 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
	strings:
		$1 = { 6A 01 FF 74 24 08 E8 ?? ?? ?? ?? 8B 44 24 0C 59 59 C3 }
	condition:
		$1
}

rule file_133_120_0 {
	meta:
		name = "?getCallIndex@UnDecorator@@CA?AVDName@@XZ"
		size = 18
		refs = "0007 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z"
		altNames = "?getGuardNumber@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 6A 00 FF 74 24 08 E8 ?? ?? ?? ?? 8B 44 24 0C 59 59 C3 }
	condition:
		$1
}

rule file_133_122_0 {
	meta:
		name = "?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 336
		refs = "0010 ??0DName@@QAE@ABV0@@Z 0017 ?isValid@DName@@QBEHXZ 0024 ?gName@UnDecorator@@0PBDB 0036 ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ 004a ??HDName@@QBE?AV0@D@Z 0051 ??HDName@@QBE?AV0@ABV0@@Z 0059 ??4DName@@QAEAAV0@ABV0@@Z 007b ??_C@_05JIBOFOHK@?$HLfor?5?$AA@ 009b ?getScope@UnDecorator@@CA?AVDName@@XZ 00a7 ??H@YA?AVDName@@DABV0@@Z 00b9 ??YDName@@QAEAAV0@ABV0@@Z 00e0 ??_C@_02MDINNEEG@s?5?$AA@ 00e5 ??YDName@@QAEAAV0@PBD@Z 010c ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0115 ??YDName@@QAEAAV0@D@Z 013c ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 8B 75 08 FF 75 0C 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 0F 84 08 01 00 00 A1 ?? ?? ?? ?? 80 38 00 0F 84 FA 00 00 00 8D 45 F8 50 E8 ?? ?? ?? ?? 59 56 8D 45 F0 50 6A 20 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 0F 84 DF 00 00 00 A1 ?? ?? ?? ?? 80 38 40 0F 84 A9 00 00 00 68 ?? ?? ?? ?? EB 63 A1 ?? ?? ?? ?? 8A 00 84 C0 74 68 3C 40 74 64 6A 27 8D 45 E8 50 8D 45 F0 50 E8 ?? ?? ?? ?? 50 8D 45 F8 6A 60 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 80 3A 40 75 07 42 89 15 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 74 0F 80 3A 40 74 0A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 75 8D 8B CE E8 ?? ?? ?? ?? 85 C0 74 1A A1 ?? ?? ?? ?? 80 38 00 75 07 6A 02 E8 ?? ?? ?? ?? 6A 7D 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 75 28 FF 05 ?? ?? ?? ?? EB 20 E8 ?? ?? ?? ?? 85 C0 74 17 56 8D 45 E8 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B CE E8 ?? ?? ?? ?? 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_133_123_0 {
	meta:
		name = "?getStringEncoding@UnDecorator@@CA?AVDName@@PADH@Z"
		size = 160
		refs = "000d ??0DName@@QAE@PBD@Z 0012 ?gName@UnDecorator@@0PBDB 0040 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 008b ??0DName@@QAE@ABV0@@Z 0097 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 FF 05 ?? ?? ?? ?? 3C 40 75 6F A1 ?? ?? ?? ?? 8A 00 FF 05 ?? ?? ?? ?? 3C 5F 75 5E FF 05 ?? ?? ?? ?? 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 08 83 C4 10 84 C9 74 16 80 F9 40 74 0C 40 A3 ?? ?? ?? ?? 8A 08 84 C9 75 EF 80 38 00 75 0A 48 A3 ?? ?? ?? ?? 6A 02 EB 16 8B 4D 08 40 A3 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? EB 0A 6A 01 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_124_0 {
	meta:
		name = "?getSignedDimension@UnDecorator@@CA?AVDName@@XZ"
		size = 80
		refs = "0006 ?gName@UnDecorator@@0PBDB 0016 ??0DName@@QAE@W4DNameStatus@@@Z 002d ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0038 ??H@YA?AVDName@@DABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 8A 00 84 C0 75 0C 8B 4D 08 6A 02 E8 ?? ?? ?? ?? EB 2F 3C 3F 6A 00 75 1F FF 05 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 50 6A 2D FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 EB 0A FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_125_0 {
	meta:
		name = "?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ"
		size = 699
		refs = "000c ___security_cookie 0016 ?gName@UnDecorator@@0PBDB 005b ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 006e ?isValid@DName@@QBEHXZ 0094 ?getString@DName@@QBEPADPADH@Z 00a1 ??0DName@@QAE@W4DNameStatus@@@Z 00d7 ??0DName@@QAE@PBD@Z 00de ??HDName@@QBE?AV0@D@Z 00e5 ??HDName@@QBE?AV0@ABV0@@Z 00ff ??_C@_04HIBGFPH@NULL?$AA@ 0114 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 011c ??_C@_01HNPIGOCE@?$CG?$AA@ 016f ?getZName@UnDecorator@@CA?AVDName@@_N@Z 0186 ??0DName@@QAE@ABV0@@Z 019b ?disableFlags@UnDecorator@@0KA 01b7 _atol 01be ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 01d2 ??_C@_01GEODFPGF@?8?$AA@ 01de ??_C@_0BE@EODMJLIF@?$GAtemplate?9parameter?$AA@ 01e7 ??H@YA?AVDName@@PBDABV0@@Z 01f1 ??HDName@@QBE?AV0@PBD@Z 01fb ??_C@_0BN@IBLMMFAP@?$GAnon?9type?9template?9parameter?$AA@ 020a ??0DName@@QAE@D@Z 0227 ??YDName@@QAEAAV0@ABV0@@Z 0231 ??YDName@@QAEAAV0@D@Z 02b2 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC D0 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 70 A1 ?? ?? ?? ?? 53 8A 18 FF 05 ?? ?? ?? ?? 56 0F BE F3 83 FE 44 57 8B 7D 7C 0F 8F 0E 01 00 00 0F 84 55 01 00 00 83 EE 00 0F 84 F2 00 00 00 83 EE 30 0F 84 DE 00 00 00 4E 0F 84 9B 00 00 00 4E 75 46 8D 45 F4 50 E8 ?? ?? ?? ?? 8D 45 68 50 E8 ?? ?? ?? ?? 59 59 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 0F 84 C1 00 00 00 8D 4D 68 E8 ?? ?? ?? ?? 85 C0 0F 84 B1 00 00 00 6A 64 8D 45 FD 50 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 75 0E 6A 01 8B CF E8 ?? ?? ?? ?? E9 FD 01 00 00 8A 45 FD 3C 2D 88 45 FC 75 0C 8A 45 FE 88 45 FD C6 45 FE 2E EB 04 C6 45 FD 2E 8D 45 68 50 57 6A 65 8D 45 CC 50 8D 45 FC 50 8D 4D A4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 B9 01 00 00 A1 ?? ?? ?? ?? 80 38 40 75 17 FF 05 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? E9 98 01 00 00 8D 45 DC 50 E8 ?? ?? ?? ?? 59 50 57 68 ?? ?? ?? ?? 8D 4D BC E8 ?? ?? ?? ?? EB B8 57 E8 ?? ?? ?? ?? E9 71 01 00 00 FF 0D ?? ?? ?? ?? 6A 02 E9 5C FF FF FF 83 FE 45 0F 84 55 01 00 00 0F 8E 4B FF FF FF 83 FE 4A 0F 8E AA 00 00 00 83 FE 51 74 30 83 FE 52 0F 85 34 FF FF FF 8D 45 68 6A 00 50 E8 ?? ?? ?? ?? 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 45 68 50 8B CF E8 ?? ?? ?? ?? E9 18 01 00 00 8D 45 F4 50 E8 ?? ?? ?? ?? 66 F7 05 ?? ?? ?? ?? 00 40 59 74 2A 6A 10 8D 45 60 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 45 60 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 59 59 74 06 50 E9 35 FF FF FF 80 FB 44 68 ?? ?? ?? ?? 8D 45 F4 57 50 75 1D 68 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? E9 AD 00 00 00 68 ?? ?? ?? ?? 8D 45 AC EB E1 6A 7B 8D 4D F4 E8 ?? ?? ?? ?? 80 FB 48 7C 22 80 FB 4A 7F 1D 8D 45 E4 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 6A 2C 8D 4D F4 E8 ?? ?? ?? ?? 83 EE 46 74 29 4E 74 09 4E 74 40 4E 74 20 4E 75 4D 8D 45 D4 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 6A 2C 8D 4D F4 E8 ?? ?? ?? ?? 8D 45 C4 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 6A 2C 8D 4D F4 E8 ?? ?? ?? ?? 8D 45 B4 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 6A 7D 57 8D 4D F4 E8 ?? ?? ?? ?? EB 07 57 E8 ?? ?? ?? ?? 59 8B 4D 70 8B C7 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 83 C5 74 C9 C3 }
	condition:
		$1
}

rule file_133_126_0 {
	meta:
		name = "?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z"
		size = 217
		refs = "0004 ?gName@UnDecorator@@0PBDB 0029 ?isEmpty@DName@@QBEHXZ 0035 ??_C@_04GKJNKENE@void?$AA@ 003a ??0DName@@QAE@PBD@Z 0045 ??_C@_05BEFAKPML@void?5?$AA@ 004d ??H@YA?AVDName@@PBDABV0@@Z 0065 ?getArrayType@UnDecorator@@CA?AVDName@@ABV2@@Z 0077 ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 008c ??_C@_0M@EALIELKG@cli?3?3array?$DM?$AA@ 009d ??_C@_0O@GKABPPIF@cli?3?3pin_ptr?$DM?$AA@ 00b2 ??4DName@@QAEAAV0@ABV0@@Z 00be ??0DName@@QAE@ABV0@@Z 00cd ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 10 80 38 00 0F 84 B0 00 00 00 83 7D 10 00 74 39 80 38 58 75 34 8B 4D 0C 40 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 12 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 91 00 00 00 51 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? EB 7E 80 38 59 75 15 FF 75 0C 40 FF 75 08 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 EB 67 56 8B 75 0C 8D 45 F8 56 50 E8 ?? ?? ?? ?? 8B 46 04 66 A9 00 04 59 59 5E 74 0B 8D 45 F8 50 68 ?? ?? ?? ?? EB 0F 66 A9 00 02 74 1E 8D 45 F8 50 68 ?? ?? ?? ?? 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? EB 10 FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_127_0 {
	meta:
		name = "?getVbTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 20
		refs = "0009 ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 E8 ?? ?? ?? ?? 8B 44 24 0C 59 59 C3 }
	condition:
		$1
}

rule file_133_128_0 {
	meta:
		name = "?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ"
		size = 440
		refs = "0007 ___security_cookie 0022 ?fGetTemplateArgumentList@UnDecorator@@0_NA 003a ?gName@UnDecorator@@0PBDB 0062 ??YDName@@QAEAAV0@D@Z 007c ?pTemplateArgList@UnDecorator@@0PAVReplicator@@A 0086 ??AReplicator@@QBEABVDName@@H@Z 00a4 ??_C@_04GKJNKENE@void?$AA@ 00ac ??4DName@@QAEAAV0@PBD@Z 00c9 ?getTemplateConstant@UnDecorator@@CA?AVDName@@XZ 00dc ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 00e3 ?disableFlags@UnDecorator@@0KA 00f6 ?getString@DName@@QBEPADPADH@Z 00ff _atol 0106 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 0114 ??_C@_01GEODFPGF@?8?$AA@ 0124 ??_C@_0BE@EODMJLIF@?$GAtemplate?9parameter?$AA@ 012a ??H@YA?AVDName@@PBDABV0@@Z 0134 ??HDName@@QBE?AV0@PBD@Z 015c ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0167 ??4DName@@QAEAAV0@ABV0@@Z 0187 ??YReplicator@@QAEAAV0@ABVDName@@@Z 0192 ??YDName@@QAEAAV0@ABV0@@Z 01b2 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 60 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 8B 75 08 83 26 00 57 BF 00 F0 FF FF 21 7E 04 C6 05 ?? ?? ?? ?? 01 F6 46 04 0F C7 45 E0 01 00 00 00 0F 85 69 01 00 00 53 A1 ?? ?? ?? ?? 8A 08 84 C9 0F 84 58 01 00 00 80 F9 40 0F 84 4F 01 00 00 83 7D E0 00 74 06 83 65 E0 00 EB 0E 6A 2C 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 10 0F BE CA 83 E9 30 83 F9 09 77 17 40 51 8B 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 FF 00 00 00 83 65 E4 00 21 7D E8 80 FA 58 8B D8 75 18 40 A3 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? E9 B6 00 00 00 80 FA 24 75 18 40 38 10 74 13 A3 ?? ?? ?? ?? 8D 45 A0 50 E8 ?? ?? ?? ?? E9 8F 00 00 00 80 FA 3F 75 75 8D 45 D8 50 E8 ?? ?? ?? ?? 66 F7 05 ?? ?? ?? ?? 00 40 59 74 4E 6A 10 8D 45 EC 50 8D 4D D8 E8 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 59 59 74 03 50 EB 95 68 ?? ?? ?? ?? 8D 45 C8 50 8D 45 D8 50 8D 45 B8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? EB 28 68 ?? ?? ?? ?? 8D 45 A8 50 8D 45 D8 50 8D 45 C0 EB D7 83 65 D0 00 21 7D D4 8D 45 D0 50 8D 45 B0 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D E4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B C3 83 F8 01 7E 14 8B 0D ?? ?? ?? ?? 83 39 09 74 09 8D 45 E4 50 E8 ?? ?? ?? ?? 8D 45 E4 50 8B CE E8 ?? ?? ?? ?? F6 46 04 0F 0F 84 99 FE FF FF 5B 8B 4D FC 5F 8B C6 33 CD C6 05 ?? ?? ?? ?? 00 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_133_129_0 {
	meta:
		name = "?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z"
		size = 1391
		refs = "000c ?gName@UnDecorator@@0PBDB 0065 _nameTable 006d ??4DName@@QAEAAV0@PBD@Z 0075 ?isEmpty@DName@@QBEHXZ 0084 ??_C@_08LHJFAFGD@operator?$AA@ 008a ??H@YA?AVDName@@PBDABV0@@Z 0096 ??4DName@@QAEAAV0@ABV0@@Z 00a2 ??0DName@@QAE@ABV0@@Z 00c0 ?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ 00cc ??H@YA?AVDName@@DABV0@@Z 00d8 ??YDName@@QAEAAV0@ABV0@@Z 00e0 ?getLastChar@DName@@QBEDXZ 00ee ??YDName@@QAEAAV0@D@Z 0122 ?getZName@UnDecorator@@CA?AVDName@@_N@Z 018f ??0DName@@QAE@W4DNameStatus@@@Z 0205 ??0DName@@QAE@PBD@Z 025b ??_C@_08OBABFOLI@?$GAstring?8?$AA@ 0264 ?getStringEncoding@UnDecorator@@CA?AVDName@@PADH@Z 0293 ??_C@_0BG@JNJLAMPM@?$GAanonymous?5namespace?8?$AA@ 02dc _rttiTable 0317 ??HDName@@QBE?AV0@ABV0@@Z 0346 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 034e ??HDName@@QBE?AV0@D@Z 03a7 ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 03d5 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 0420 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 04d3 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 04f8 ?getSymbolName@UnDecorator@@CA?AVDName@@XZ 0507 ??_C@_02OHHJMEON@?8?8?$AA@ 050f ??YDName@@QAEAAV0@PBD@Z"
	strings:
		$1 = { 55 8D 6C 24 94 81 EC A0 00 00 00 A1 ?? ?? ?? ?? 0F BE 10 53 33 DB B9 00 F0 FF FF 21 4D 68 21 4D 58 56 33 F6 40 83 FA 41 89 5D 64 89 5D 54 A3 ?? ?? ?? ?? 0F 8F 5F 01 00 00 0F 84 FC 04 00 00 3B D3 0F 84 3C 01 00 00 83 FA 2F 0F 8E 3A 02 00 00 83 FA 31 7E 5B 83 FA 39 0F 8F 2C 02 00 00 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D 64 E8 ?? ?? ?? ?? 8D 4D 64 E8 ?? ?? ?? ?? 85 C0 75 1D 8B C1 50 8D 45 4C 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D 64 E8 ?? ?? ?? ?? 8D 45 64 8B 4D 74 50 E8 ?? ?? ?? ?? 8B 45 74 5E 5B 83 C5 6C C9 C3 21 4D 58 38 5D 78 89 5D 54 74 5F 8D 45 14 50 E8 ?? ?? ?? ?? 50 8D 45 CC 6A 3C 50 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D 54 E8 ?? ?? ?? ?? 8D 4D 54 E8 ?? ?? ?? ?? 3C 3E 75 0A 6A 20 8D 4D 54 E8 ?? ?? ?? ?? 6A 3E 8D 4D 54 E8 ?? ?? ?? ?? 8B 45 7C 3B C3 74 03 C6 00 01 A1 ?? ?? ?? ?? 38 18 75 05 8D 45 54 EB 89 40 A3 ?? ?? ?? ?? 8B F0 8D 45 34 53 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D 64 E8 ?? ?? ?? ?? 8D 4D 64 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 75 20 80 7E FF 31 75 1A 8B C1 50 8D 45 E4 6A 7E 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D 64 E8 ?? ?? ?? ?? 8D 4D 54 E8 ?? ?? ?? ?? 85 C0 0F 85 27 FF FF FF 8B C1 50 8D 4D 64 E8 ?? ?? ?? ?? E9 17 FF FF FF 48 A3 ?? ?? ?? ?? 6A 02 8B 4D 74 E8 ?? ?? ?? ?? E9 0E FF FF FF 83 FA 42 0F 84 97 03 00 00 0F 8E E3 00 00 00 83 FA 5A 0F 8E 8B 03 00 00 83 FA 5F 0F 85 D1 00 00 00 0F BE 08 40 83 F9 4F A3 ?? ?? ?? ?? 0F 8F CE 00 00 00 83 F9 44 0F 8D 44 03 00 00 83 F9 39 7F 67 74 43 3B CB 74 A4 83 F9 2F 0F 8E A2 00 00 00 83 F9 36 7E 21 83 F9 38 0F 8F 94 00 00 00 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8B 4D 74 E8 ?? ?? ?? ?? E9 98 FE FF FF 0F BE 40 FF FF 34 85 ?? ?? ?? ?? E9 4B FE FF FF 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D 5C E8 ?? ?? ?? ?? 81 4D 60 00 08 00 00 8D 45 5C E9 5D FE FF FF 83 F9 3F 74 2F 83 F9 40 7E 40 83 F9 42 0F 8E C5 02 00 00 83 F9 43 75 32 6A 01 68 ?? ?? ?? ?? 8D 45 5C 50 E8 ?? ?? ?? ?? 83 C4 0C 81 4D 60 00 01 00 00 EB C4 0F BE 08 40 3B CB A3 ?? ?? ?? ?? 0F 84 FE FE FF FF 83 F9 30 74 07 6A 01 E9 FA FE FF FF 53 68 ?? ?? ?? ?? EB C6 83 F9 54 0F 8F AD 01 00 00 83 F9 53 0F 8D 6D 02 00 00 83 E9 50 0F 84 52 01 00 00 49 0F 84 B6 FD FF FF 49 75 CC 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D 64 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 00 FF 34 85 ?? ?? ?? ?? 8D 4D 54 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 0F BE 00 FF 05 ?? ?? ?? ?? 83 F8 30 0F 84 D0 00 00 00 83 F8 31 74 27 83 C0 CE 83 F8 02 77 14 8D 45 54 50 FF 75 74 8D 4D 64 E8 ?? ?? ?? ?? E9 86 FD FF FF FF 0D ?? ?? ?? ?? E9 5E FE FF FF 8D 45 54 50 8D 45 5C 50 8D 4D 64 E8 ?? ?? ?? ?? 6A 2C 8D 45 24 50 8D 45 F4 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D 5C E8 ?? ?? ?? ?? 6A 2C 8D 45 44 50 8D 45 D4 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D 5C E8 ?? ?? ?? ?? 6A 2C 8D 45 04 50 8D 45 3C 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D 5C E8 ?? ?? ?? ?? 6A 29 8D 45 2C 50 8D 45 1C 53 50 E8 ?? ?? ?? ?? 59 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D 5C E8 ?? ?? ?? ?? 6A 27 FF 75 74 8D 4D 5C E8 ?? ?? ?? ?? E9 D7 FC FF FF 8D 45 5C 53 50 E8 ?? ?? ?? ?? 59 59 8D 45 54 50 FF 75 74 8D 45 64 50 8D 45 0C 50 6A 20 8D 45 FC 50 8D 4D 5C E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E9 10 FF FF FF 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D 64 E8 ?? ?? ?? ?? 53 8D 45 EC 53 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D 54 E8 ?? ?? ?? ?? 8D 4D 54 E8 ?? ?? ?? ?? 85 C0 0F 85 CC FE FF FF F6 45 58 40 0F 84 C2 FE FF FF E9 3B FE FF FF 83 F9 55 0F 8C 32 FE FF FF 83 F9 56 0F 8E C7 00 00 00 83 F9 57 0F 8E 20 FE FF FF 83 F9 59 0F 8E A5 00 00 00 83 F9 5F 0F 85 0E FE FF FF 0F BE 08 40 83 F9 41 A3 ?? ?? ?? ?? 0F 8C FC FD FF FF 83 F9 44 7E 0E 83 F9 46 7E 19 83 F9 4A 0F 8F E9 FD FF FF 0F BE 40 FF FF 34 85 ?? ?? ?? ?? E9 50 FD FF FF 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D 5C E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 3F 75 25 8D 45 DC 50 E8 ?? ?? ?? ?? 59 50 8D 4D 5C E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 75 1B FF 05 ?? ?? ?? ?? EB 13 8D 45 4C 50 E8 ?? ?? ?? ?? 59 50 8D 4D 5C E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D 5C E8 ?? ?? ?? ?? E9 20 FD FF FF 0F BE 40 FF FF 34 85 ?? ?? ?? ?? E9 D9 FC FF FF 0F BE 40 FF FF 34 85 ?? ?? ?? ?? E9 31 FB FF FF 33 F6 46 0F BE 40 FF FF 34 85 ?? ?? ?? ?? 8D 4D 64 E8 ?? ?? ?? ?? 3B F3 0F 84 1B FB FF FF 8D 4D 64 E8 ?? ?? ?? ?? 85 C0 0F 85 34 FB FF FF 83 4D 68 20 E9 2B FB FF FF }
	condition:
		$1
}

rule file_133_130_0 {
	meta:
		name = "?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z"
		size = 339
		refs = "0006 ?gName@UnDecorator@@0PBDB 0026 ?pTemplateArgList@UnDecorator@@0PAVReplicator@@A 002d ?pArgList@UnDecorator@@0PAVReplicator@@A 0036 ?pZNameList@UnDecorator@@0PAVReplicator@@A 0043 ??0Replicator@@QAE@XZ 0099 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 00a9 ?getZName@UnDecorator@@CA?AVDName@@_N@Z 00b4 ??4DName@@QAEAAV0@ABV0@@Z 00bc ?isEmpty@DName@@QBEHXZ 00c6 ?fExplicitTemplateParams@UnDecorator@@0_NA 00d6 ?getTemplateArgumentList@UnDecorator@@CA?AVDName@@XZ 00e2 ??H@YA?AVDName@@DABV0@@Z 00ee ??YDName@@QAEAAV0@ABV0@@Z 00f6 ?getLastChar@DName@@QBEDXZ 0104 ??YDName@@QAEAAV0@D@Z 0138 ??0DName@@QAE@ABV0@@Z 0147 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8D 6C 24 90 A1 ?? ?? ?? ?? 81 EC D0 00 00 00 80 38 3F 0F 85 28 01 00 00 80 78 01 24 0F 85 1E 01 00 00 53 8B 1D ?? ?? ?? ?? 56 8B 35 ?? ?? ?? ?? 40 40 57 8B 3D ?? ?? ?? ?? 8D 4D DC A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8D 4D 18 E8 ?? ?? ?? ?? 8D 4D A0 E8 ?? ?? ?? ?? 83 65 64 00 81 65 68 00 F0 FF FF 8D 45 DC A3 ?? ?? ?? ?? 8D 45 18 A3 ?? ?? ?? ?? 8D 45 A0 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 3F C6 45 6F 00 75 1A FF 05 ?? ?? ?? ?? 8D 45 6F 50 8D 45 5C 6A 01 50 E8 ?? ?? ?? ?? 83 C4 0C EB 0D 8D 45 5C 6A 01 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D 64 E8 ?? ?? ?? ?? 8D 4D 64 E8 ?? ?? ?? ?? 85 C0 74 07 C6 05 ?? ?? ?? ?? 01 80 7D 6F 00 75 4D 8D 45 5C 50 E8 ?? ?? ?? ?? 50 8D 45 54 6A 3C 50 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D 64 E8 ?? ?? ?? ?? 8D 4D 64 E8 ?? ?? ?? ?? 3C 3E 75 0A 6A 20 8D 4D 64 E8 ?? ?? ?? ?? 6A 3E 8D 4D 64 E8 ?? ?? ?? ?? 80 7D 7C 00 74 06 FF 05 ?? ?? ?? ?? 8B 4D 78 8D 45 64 50 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 89 1D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5F 5E 5B EB 0A 8B 4D 78 6A 01 E8 ?? ?? ?? ?? 8B 45 78 83 C5 70 C9 C3 }
	condition:
		$1
}

rule file_133_131_0 {
	meta:
		name = "?getZName@UnDecorator@@CA?AVDName@@_N@Z"
		size = 490
		refs = "0007 ___security_cookie 0011 ?gName@UnDecorator@@0PBDB 002d ?pZNameList@UnDecorator@@0PAVReplicator@@A 0037 ??AReplicator@@QBEABVDName@@H@Z 003f ??0DName@@QAE@ABV0@@Z 0061 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 006c ??4DName@@QAEAAV0@ABV0@@Z 0099 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 00a5 ??_C@_0BE@JAEOCHPE@template?9parameter?9?$AA@ 00cf ??_C@_0O@KHGCOMHP@generic?9type?9?$AA@ 0106 ?getSignedDimension@UnDecorator@@CA?AVDName@@XZ 010d ?disableFlags@UnDecorator@@0KA 0120 ?getString@DName@@QBEPADPADH@Z 0129 _atol 0130 ?m_pGetParameter@UnDecorator@@0P6APADJ@ZA 013f ??4DName@@QAEAAV0@PBD@Z 0146 ??_C@_01NLNLIGKH@?$GA?$AA@ 0150 ??_C@_01GEODFPGF@?8?$AA@ 0181 ??H@YA?AVDName@@PBDABV0@@Z 018b ??HDName@@QBE?AV0@PBD@Z 0194 ??YDName@@QAEAAV0@ABV0@@Z 01a5 ??0DName@@QAE@AAPBDD@Z 01ca ??YReplicator@@QAEAAV0@ABVDName@@@Z 01e4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 38 A1 ?? ?? ?? ?? 33 C5 89 45 FC A1 ?? ?? ?? ?? 8A 10 0F BE CA 56 8B 75 08 83 E9 30 83 F9 09 89 75 D8 77 21 40 51 8B 0D ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 8B C6 E9 93 01 00 00 83 65 E4 00 81 65 E8 00 F0 FF FF 80 FA 3F 75 48 8D 45 DC 6A 00 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D E4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 08 40 80 F9 40 A3 ?? ?? ?? ?? 0F 84 2E 01 00 00 48 33 C9 A3 ?? ?? ?? ?? 38 08 0F 94 C1 41 51 8D 4D E4 E8 ?? ?? ?? ?? E9 12 01 00 00 53 57 B9 ?? ?? ?? ?? 6A 12 8B F9 8B F0 5B 8A 16 84 D2 74 09 3A 17 75 05 46 47 4B 75 F1 0F B6 16 0F B6 37 2B D6 75 05 83 C0 13 EB 2C B9 ?? ?? ?? ?? 6A 0C 8B F9 8B F0 5B 8A 16 84 D2 74 09 3A 17 75 05 46 47 4B 75 F1 0F B6 16 0F B6 37 2B D6 0F 85 A3 00 00 00 83 C0 0D A3 ?? ?? ?? ?? 8D 45 DC 50 8B F1 E8 ?? ?? ?? ?? 66 F7 05 ?? ?? ?? ?? 00 40 59 74 4B 6A 10 8D 45 EC 50 8D 4D DC E8 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 59 59 8D 4D E4 74 08 50 E8 ?? ?? ?? ?? EB 6D 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 C8 50 8D 45 DC 50 8D 45 D0 EB 1D 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D0 50 8D 45 DC 50 8D 45 C8 56 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D E4 E8 ?? ?? ?? ?? EB 18 6A 40 68 ?? ?? ?? ?? 8D 4D D0 E8 ?? ?? ?? ?? 50 8D 4D E4 E8 ?? ?? ?? ?? 5F 5B 80 7D 0C 00 74 14 8B 0D ?? ?? ?? ?? 83 39 09 74 09 8D 45 E4 50 E8 ?? ?? ?? ?? 8B 4D D8 8D 45 E4 50 E8 ?? ?? ?? ?? 8B 45 D8 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_133_132_0 {
	meta:
		name = "?getScopedName@UnDecorator@@CA?AVDName@@XZ"
		size = 228
		refs = "001c ?getZName@UnDecorator@@CA?AVDName@@_N@Z 0026 ??4DName@@QAEAAV0@ABV0@@Z 002f ??_C@_02MOLJINC@?3?3?$AA@ 0036 ?gName@UnDecorator@@0PBDB 0053 ?getScope@UnDecorator@@CA?AVDName@@XZ 005b ??HDName@@QBE?AV0@PBD@Z 0062 ??HDName@@QBE?AV0@ABV0@@Z 00a3 ?isEmpty@DName@@QBEHXZ 00ae ??4DName@@QAEAAV0@W4DNameStatus@@@Z 00c4 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 8B 75 08 83 26 00 81 66 04 00 F0 FF FF 57 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 59 59 50 8B CE E8 ?? ?? ?? ?? F6 46 04 0F BF ?? ?? ?? ?? 75 39 A1 ?? ?? ?? ?? 8A 00 84 C0 74 2E 3C 40 74 35 56 8D 45 F8 50 57 8D 45 F0 50 8D 45 E8 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 3C 40 75 08 FF 05 ?? ?? ?? ?? EB 5D 84 C0 74 1B 8B 46 04 83 26 00 8B C8 83 E1 0F 80 F9 03 74 49 83 E0 F1 83 C8 01 89 46 04 EB 3E 8B CE E8 ?? ?? ?? ?? 85 C0 74 09 6A 02 E8 ?? ?? ?? ?? EB 2A 56 8D 45 E8 50 57 8D 45 F0 50 6A 02 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_133_134_0 {
	meta:
		name = "?getECSUDataType@UnDecorator@@CA?AVDName@@XZ"
		size = 256
		refs = "0004 ?disableFlags@UnDecorator@@0KA 0024 ?gName@UnDecorator@@0PBDB 005b ??_C@_0N@DLIEFKNA@cointerface?5?$AA@ 0062 ??_C@_08KOFANOFK@coclass?5?$AA@ 006f ?getEnumType@UnDecorator@@CA?AVDName@@XZ 0078 ??_C@_05LJGMCFOG@enum?5?$AA@ 007e ??H@YA?AVDName@@PBDABV0@@Z 008a ??4DName@@QAEAAV0@ABV0@@Z 0091 ??_C@_06LJBABKPM@class?5?$AA@ 0098 ??_C@_07DIBCDNGL@struct?5?$AA@ 009f ??_C@_06MOJHIBMG@union?5?$AA@ 00a7 ??4DName@@QAEAAV0@PBD@Z 00c7 ?getScopedName@UnDecorator@@CA?AVDName@@XZ 00d4 ??YDName@@QAEAAV0@ABV0@@Z 00e0 ??0DName@@QAE@ABV0@@Z 00f0 ??_C@_0P@GCIFDJCJ@?$GAunknown?5ecsu?8?$AA@ 00f5 ??0DName@@QAE@PBD@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 83 EC 18 53 8B C8 C1 E9 0F 33 DB F7 D1 43 23 CB 56 74 06 66 A9 00 10 74 02 33 DB A1 ?? ?? ?? ?? 0F BE 00 83 65 F8 00 BE 00 F0 FF FF 21 75 FC FF 05 ?? ?? ?? ?? 83 E8 00 0F 84 A0 00 00 00 83 E8 54 74 53 48 74 49 48 74 3F 48 74 14 48 74 0A 48 75 51 68 ?? ?? ?? ?? EB 42 68 ?? ?? ?? ?? EB 3B 8D 45 F0 50 8B D9 E8 ?? ?? ?? ?? 50 8D 45 E8 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D F8 E8 ?? ?? ?? ?? EB 1B 68 ?? ?? ?? ?? EB 0C 68 ?? ?? ?? ?? EB 05 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 83 65 F0 00 21 75 F4 85 DB 74 0C 8D 45 F8 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 59 8D 45 F8 50 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F0 50 E8 ?? ?? ?? ?? EB 13 8B 4D 08 FF 0D ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 5E 5B C9 C3 }
	condition:
		$1
}

rule file_133_135_0 {
	meta:
		name = "?getSymbolName@UnDecorator@@CA?AVDName@@XZ"
		size = 70
		refs = "0004 ?gName@UnDecorator@@0PBDB 0019 ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 002c ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 003b ?getZName@UnDecorator@@CA?AVDName@@_N@Z"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 80 38 3F 75 28 40 80 38 24 75 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? EB 20 6A 00 6A 00 FF 75 08 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C EB 0C 6A 01 FF 75 08 E8 ?? ?? ?? ?? 59 59 8B 45 08 5D C3 }
	condition:
		$1
}

rule file_133_136_0 {
	meta:
		name = "?getBasedType@UnDecorator@@CA?AVDName@@XZ"
		size = 146
		refs = "0009 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 0015 ??0DName@@QAE@PBD@Z 001a ?gName@UnDecorator@@0PBDB 0040 ??0DName@@QAE@W4DNameStatus@@@Z 004b ?getScopedName@UnDecorator@@CA?AVDName@@XZ 0055 ??YDName@@QAEAAV0@ABV0@@Z 005c ??_C@_04GKJNKENE@void?$AA@ 0064 ??YDName@@QAEAAV0@PBD@Z 0070 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0075 ??_C@_02KCKGHPCA@?$CJ?5?$AA@ 0089 ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 E8 ?? ?? ?? ?? 83 C4 04 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 74 47 0F BE 08 40 83 E9 30 A3 ?? ?? ?? ?? 74 2A 49 49 74 11 83 E9 03 75 3A 8B 4D 08 6A 01 E8 ?? ?? ?? ?? EB 47 8D 45 F0 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? EB 19 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? EB 0A 6A 02 8D 4D F8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_137_0 {
	meta:
		name = "?composeDeclaration@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 2882
		refs = "0015 ?getTypeEncoding@UnDecorator@@CAHXZ 001f ?isUDC@DName@@QBEHXZ 0034 ??0DName@@QAE@W4DNameStatus@@@Z 004e ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 0069 ??0DName@@QAE@ABV0@@Z 00fd ?disableFlags@UnDecorator@@0KA 011a ?getBasedType@UnDecorator@@CA?AVDName@@XZ 0126 ??H@YA?AVDName@@DABV0@@Z 0132 ??4DName@@QAEAAV0@ABV0@@Z 0147 ??_5DName@@QAEAAV0@ABV0@@Z 017b ?getDimension@UnDecorator@@CA?AVDName@@_N@Z 0193 ??HDName@@QBE?AV0@D@Z 019a ??HDName@@QBE?AV0@ABV0@@Z 01a3 ??YDName@@QAEAAV0@ABV0@@Z 01ac ?getVCallThunkType@UnDecorator@@CA?AVDName@@XZ 01ba ??_C@_03OPGICMGF@?$HN?8?5?$AA@ 01d7 ??HDName@@QBE?AV0@PBD@Z 01e5 ??_C@_02IGFCGPIL@?$HN?8?$AA@ 01ed ??YDName@@QAEAAV0@PBD@Z 01f6 ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 033f ?getThisType@UnDecorator@@CA?AVDName@@XZ 03b2 ?isEmpty@DName@@QBEHXZ 0408 ?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z 0411 ??_C@_01CLKCMJKC@?5?$AA@ 0417 ??H@YA?AVDName@@PBDABV0@@Z 043a _heap 043f ?getMemory@HeapManager@@QAEPAXIH@Z 04c4 ??_C@_0N@CBHHHENL@?$GAvtordispex?$HL?$AA@ 050f ??_C@_0L@GHPFDFH@?$GAvtordisp?$HL?$AA@ 052f ??_C@_0L@HNGCOGAE@?$GAadjustor?$HL?$AA@ 0560 ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 05b4 ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ 062f ?getVfTableType@UnDecorator@@CA?AVDName@@ABV2@@Z 06ab ?getVdispMapType@UnDecorator@@CA?AVDName@@ABV2@@Z 06fe ??_C@_0CB@KJDOOODE@?$GAlocal?5static?5destructor?5helper?8@ 0753 ??_C@_0DB@ILEFOCIJ@?$GAtemplate?5static?5data?5member?5con@ 07a5 ??_C@_0DA@HGFJFBBE@?$GAtemplate?5static?5data?5member?5des@ 0849 ?getExternalDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 08d6 ??_C@_07PGOEDBHP@static?5?$AA@ 09b0 ??_C@_08NIEOINHE@virtual?5?$AA@ 0a19 ??_C@_09LAPHOOG@private?3?5?$AA@ 0a5b ??_C@_0M@GAIFPFIP@protected?3?5?$AA@ 0a96 ??_C@_08GPDDCMKI@public?3?5?$AA@ 0af2 ??_C@_08KJLFOPNE@?$FLthunk?$FN?3?$AA@ 0b18 ??_C@_0M@DHNBOJMP@extern?5?$CCC?$CC?5?$AA@"
	strings:
		$1 = { 55 8B EC 83 EC 6C 83 65 DC 00 56 BE 00 F0 FF FF 21 75 E0 57 E8 ?? ?? ?? ?? 8B 4D 0C 8B F8 E8 ?? ?? ?? ?? 81 FF FF FF 00 00 89 45 E8 75 0F 8B 4D 08 6A 01 E8 ?? ?? ?? ?? E9 FE 0A 00 00 81 FF FE FF 00 00 75 15 FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E9 E1 0A 00 00 81 FF FD FF 00 00 75 10 FF 75 0C 8B 4D 08 E8 ?? ?? ?? ?? E9 C9 0A 00 00 89 7D FC 81 65 FC 00 80 00 00 53 BB 00 10 00 00 B9 00 1B 00 00 0F 84 73 05 00 00 33 C0 89 7D F0 81 65 F0 00 18 00 00 81 7D F0 00 08 00 00 0F 94 C0 33 D2 89 45 F8 3B C2 8B C7 74 07 25 00 04 00 00 EB 02 23 C3 3B C2 74 0C 8B C7 23 C1 3B C3 0F 84 39 05 00 00 39 55 F8 8B C7 74 07 25 00 04 00 00 EB 02 23 C3 3B C2 74 1A 8B C7 23 C1 3D 00 11 00 00 0F 84 16 05 00 00 3D 00 12 00 00 0F 84 0B 05 00 00 66 F7 C7 00 40 74 51 A1 ?? ?? ?? ?? 8B C8 D1 E9 F7 D1 F6 C1 01 74 2C C1 E8 03 F7 D0 A8 01 74 23 8D 45 B4 50 E8 ?? ?? ?? ?? 50 8D 45 BC 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 50 8D 4D DC E8 ?? ?? ?? ?? EB 13 8D 45 B4 50 E8 ?? ?? ?? ?? 59 50 8D 4D DC E8 ?? ?? ?? ?? 33 D2 8B 4D F8 3B CA 8B C7 74 07 25 00 04 00 00 EB 02 23 C3 3B C2 0F 84 F3 00 00 00 81 7D F0 00 18 00 00 0F 85 E6 00 00 00 8D 45 B4 6A 00 50 E8 ?? ?? ?? ?? 59 59 8B 4D 0C 8D 45 B4 50 8D 45 BC 50 6A 7B 8D 45 C4 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D DC E8 ?? ?? ?? ?? 8D 45 B4 50 E8 ?? ?? ?? ?? 85 1D ?? ?? ?? ?? 59 75 2B 68 ?? ?? ?? ?? 8D 45 BC 50 8D 45 B4 50 8D 45 C4 6A 2C 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 8D 45 B4 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 59 8B C8 D1 E9 F7 D1 F6 C1 01 0F 84 49 06 00 00 8B C8 C1 E9 04 F7 D1 F6 C1 01 0F 84 39 06 00 00 85 C3 0F 85 31 06 00 00 8D 45 DC 50 8D 45 BC 50 6A 20 8D 45 C4 50 8D 45 B4 50 8D 45 CC 6A 20 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 F5 05 00 00 21 75 C8 21 75 D0 21 75 F0 21 75 C0 21 75 D8 3B CA 89 55 C4 89 55 CC 89 55 EC 89 55 BC 89 55 D4 8B C7 74 07 25 00 04 00 00 EB 02 23 C3 3B C2 0F 84 8C 00 00 00 3B CA 74 6D 8B C7 25 00 07 00 00 3D 00 06 00 00 75 34 8D 45 B4 6A 01 50 E8 ?? ?? ?? ?? 59 59 8D 45 B4 50 8D 4D C4 E8 ?? ?? ?? ?? 8D 45 B4 6A 01 50 E8 ?? ?? ?? ?? 59 59 8D 45 B4 50 8D 4D CC E8 ?? ?? ?? ?? EB 12 3B CA 74 27 8B C7 25 00 07 00 00 3D 00 05 00 00 75 19 8D 45 B4 6A 01 50 E8 ?? ?? ?? ?? 59 59 8D 45 B4 50 8D 4D EC E8 ?? ?? ?? ?? 8D 45 B4 6A 01 50 E8 ?? ?? ?? ?? 59 59 8D 45 B4 50 8D 4D BC E8 ?? ?? ?? ?? 33 D2 39 55 F8 74 3E 8B C7 25 00 07 00 00 3D 00 02 00 00 74 30 A1 ?? ?? ?? ?? 83 E0 60 3C 60 8D 45 B4 50 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D D4 E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D D4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B C8 D1 E9 F7 D1 F6 C1 01 74 2D C1 E8 04 F7 D0 A8 01 74 24 8D 45 DC 50 8D 45 B4 50 8D 45 AC 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D DC E8 ?? ?? ?? ?? EB 13 8D 45 AC 50 E8 ?? ?? ?? ?? 59 50 8D 4D DC E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 3B 8D 4D DC E8 ?? ?? ?? ?? 85 C0 75 24 85 1D ?? ?? ?? ?? 75 1C FF 75 0C 8D 45 AC 6A 20 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D DC E8 ?? ?? ?? ?? EB 0B FF 75 0C 8D 4D DC E8 ?? ?? ?? ?? 21 75 B8 33 DB 39 5D E8 89 5D B4 53 74 34 8D 45 AC 50 E8 ?? ?? ?? ?? 50 8D 45 E4 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 14 50 8D 4D DC E8 ?? ?? ?? ?? 66 F7 05 ?? ?? ?? ?? 00 10 74 35 E9 F7 06 00 00 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 09 21 18 21 70 04 8B D8 EB 02 33 DB 8D 45 AC 53 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D B4 E8 ?? ?? ?? ?? 8B 75 F8 85 F6 8B C7 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 0F 84 D1 00 00 00 85 F6 0F 84 A2 00 00 00 8B C7 25 00 07 00 00 3D 00 06 00 00 75 55 6A 2C 8D 45 AC 50 8D 45 EC 50 8D 45 E4 50 6A 2C 8D 45 F4 50 8D 45 CC 50 8D 45 A4 50 6A 2C 8D 45 9C 50 8D 45 C4 50 8D 45 94 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 2D 85 F6 74 3B 8B C7 25 00 07 00 00 3D 00 05 00 00 75 2D 6A 2C 8D 45 94 50 8D 45 EC 50 8D 45 9C 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D DC E8 ?? ?? ?? ?? EB 0D 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 94 50 8D 4D BC E8 ?? ?? ?? ?? 50 8D 4D DC E8 ?? ?? ?? ?? 6A 29 8D 45 94 50 8D 45 9C 50 E8 ?? ?? ?? ?? 50 8D 45 A4 6A 28 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? 50 8D 4D DC E8 ?? ?? ?? ?? 85 F6 74 1A 8B C7 25 00 07 00 00 3D 00 02 00 00 74 0C 8D 45 D4 50 8D 4D DC E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 F7 D0 A8 01 8D 45 94 50 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D DC E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D DC E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 02 F7 D0 A8 01 0F 84 73 02 00 00 85 DB 0F 84 6B 02 00 00 8D 45 DC 50 8B CB E8 ?? ?? ?? ?? 8D 45 B4 E9 4F 02 00 00 FF 75 0C 8D 4D DC E8 ?? ?? ?? ?? 8B 45 FC 85 C0 B9 00 7C 00 00 0F 85 9A 00 00 00 8B D7 23 D1 81 FA 00 68 00 00 75 13 8D 45 DC 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 00 05 00 00 85 C0 75 77 8B D7 23 D1 81 FA 00 70 00 00 74 DD 85 C0 75 67 8B D7 23 D1 81 FA 00 60 00 00 75 3D 50 8D 45 B4 50 E8 ?? ?? ?? ?? 59 59 68 ?? ?? ?? ?? FF 75 08 8D 45 B4 50 8D 45 94 50 6A 7B 8D 45 9C 50 8D 4D DC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? E9 A3 04 00 00 85 C0 75 1A 8B D7 23 D1 3B D1 75 0E 8D 45 DC 50 FF 75 08 E8 ?? ?? ?? ?? EB 82 85 C0 74 0E 8B C7 25 00 18 00 00 2D 00 08 00 00 EB 07 8B C7 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C7 74 07 25 00 04 00 00 EB 02 23 C3 85 C0 BE 00 1B 00 00 74 20 8B 45 FC 8B D7 23 D6 2B D3 F7 DA 1B D2 42 F7 D8 1B C0 85 C2 74 0A 68 ?? ?? ?? ?? E9 A2 00 00 00 83 7D FC 00 8B C7 74 0C 25 00 18 00 00 2D 00 08 00 00 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C7 74 07 25 00 04 00 00 EB 02 23 C3 85 C0 74 21 8B 45 FC 8B D7 23 D6 81 EA 00 11 00 00 F7 DA 1B D2 42 F7 D8 1B C0 85 C2 74 07 68 ?? ?? ?? ?? EB 50 83 7D FC 00 8B C7 74 0C 25 00 18 00 00 2D 00 08 00 00 EB 05 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C7 74 07 25 00 04 00 00 EB 02 23 C3 85 C0 74 29 8B 45 FC 8B D7 23 D6 81 EA 00 12 00 00 F7 DA 1B D2 42 F7 D8 1B C0 85 C2 74 0F 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? EB 15 83 7D FC 00 75 15 8B C7 23 C1 3D 00 78 00 00 0F 84 66 03 00 00 83 7D FC 00 74 0E 8B C7 25 00 18 00 00 2D 00 08 00 00 EB 07 8B C7 25 00 60 00 00 F7 D8 1B C0 40 85 C0 8B C7 74 07 25 00 04 00 00 EB 02 23 C3 85 C0 74 45 8B 4D FC 8B C7 23 C6 33 D2 3D 00 11 00 00 0F 94 C2 F7 D9 1B C9 85 CA 75 15 8B 4D FC 33 D2 3D 00 12 00 00 0F 94 C2 F7 D9 1B C9 85 CA 74 17 8D 45 DC 50 8D 45 94 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C EB 0F 8D 45 DC 50 8D 45 94 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D DC E8 ?? ?? ?? ?? 33 D2 39 55 FC 8B C7 BE 00 18 00 00 BB 00 08 00 00 B9 00 60 00 00 74 06 23 C6 2B C3 EB 02 23 C1 F7 D8 1B C0 40 3B C2 0F 84 2F 02 00 00 A1 ?? ?? ?? ?? C1 E8 09 F7 D0 A8 01 0F 84 34 01 00 00 39 55 FC 8B C7 74 06 23 C6 2B C3 EB 02 23 C1 F7 D8 1B C0 40 3B C2 74 42 39 55 FC 74 13 8B C7 25 00 07 00 00 2D 00 02 00 00 F7 D8 1B C0 40 EB 03 33 C0 40 3B C2 74 23 8D 45 DC 50 8D 45 94 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D DC E8 ?? ?? ?? ?? B9 00 60 00 00 8B 55 FC 85 D2 74 1E 8B C7 25 00 07 00 00 3D 00 01 00 00 0F 84 9E 00 00 00 85 D2 74 08 8B C7 23 C6 2B C3 EB 04 8B C7 23 C1 F7 D8 1B C0 40 85 C0 8B C7 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 0F 84 92 00 00 00 85 D2 8B C7 74 06 23 C6 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 0E 8B C7 25 00 07 00 00 3D 00 05 00 00 74 4A 85 D2 8B C7 74 06 23 C6 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 0E 8B C7 25 00 07 00 00 3D 00 06 00 00 74 25 85 D2 8B C7 74 06 23 C6 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 31 8B C7 25 00 07 00 00 3D 00 04 00 00 75 23 8D 45 DC 50 8D 45 94 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D DC E8 ?? ?? ?? ?? B9 00 60 00 00 A1 ?? ?? ?? ?? C1 E8 07 F7 D0 A8 01 0F 84 D7 00 00 00 8B 55 FC 85 D2 8B C7 74 06 23 C6 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 28 85 D2 8B C7 74 0A 24 C0 2C 40 F6 D8 1B C0 EB 08 23 C6 2B C3 F7 D8 1B C0 40 85 C0 74 0B 8D 45 DC 50 68 ?? ?? ?? ?? EB 7B 85 D2 8B C7 74 06 23 C6 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 2B 85 D2 8B C7 74 0A 24 C0 2C 80 F6 D8 1B C0 EB 0B 23 C6 2D 00 10 00 00 F7 D8 1B C0 40 85 C0 74 0B 8D 45 DC 50 68 ?? ?? ?? ?? EB 39 85 D2 8B C7 74 06 23 C6 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 74 3C 85 D2 8B C7 74 08 24 C0 F6 D8 1B C0 EB 06 23 C6 F7 D8 1B C0 40 85 C0 74 23 8D 45 DC 50 68 ?? ?? ?? ?? 8D 45 94 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D DC E8 ?? ?? ?? ?? B9 00 60 00 00 83 7D FC 00 8B C7 74 06 23 C6 2B C3 EB 02 23 C1 F7 D8 1B C0 40 85 C0 8B C7 74 07 25 00 04 00 00 EB 05 25 00 10 00 00 85 C0 74 29 66 F7 05 ?? ?? ?? ?? 00 10 75 1E 8D 45 DC 50 8D 45 94 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D DC E8 ?? ?? ?? ?? F7 C7 00 00 01 00 74 1E 8D 45 DC 50 8D 45 94 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D DC E8 ?? ?? ?? ?? 8B 4D 08 8D 45 DC 50 E8 ?? ?? ?? ?? 5B 8B 45 08 5F 5E C9 C3 }
	condition:
		$1
}

rule file_133_138_0 {
	meta:
		name = "?getDecoratedName@UnDecorator@@CA?AVDName@@XZ"
		size = 529
		refs = "000e ?disableFlags@UnDecorator@@0KA 0026 ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 003a ??0DName@@QAE@ABV0@@Z 0044 ?gName@UnDecorator@@0PBDB 0067 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0085 ?getSymbolName@UnDecorator@@CA?AVDName@@XZ 008e ?isEmpty@DName@@QBEHXZ 00b0 ?isValid@DName@@QBEHXZ 00dc ?getScope@UnDecorator@@CA?AVDName@@XZ 00ef ?fExplicitTemplateParams@UnDecorator@@0_NA 0105 ??HDName@@QBE?AV0@ABV0@@Z 010e ??4DName@@QAEAAV0@ABV0@@Z 0148 ??_C@_02MOLJINC@?3?3?$AA@ 0151 ??HDName@@QBE?AV0@PBD@Z 01e1 ?composeDeclaration@UnDecorator@@CA?AVDName@@ABV2@@Z 0206 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 BE 00 20 00 00 85 35 ?? ?? ?? ?? 57 74 2E 81 25 ?? ?? ?? ?? FF DF FF FF 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 09 35 ?? ?? ?? ?? 59 59 8D 45 F0 8B 4D 08 50 E8 ?? ?? ?? ?? E9 C7 01 00 00 A1 ?? ?? ?? ?? 8A 08 80 F9 3F 0F 85 A9 01 00 00 40 A3 ?? ?? ?? ?? 38 08 75 23 38 48 01 75 1E 8D 45 F0 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 59 EB 06 40 A3 ?? ?? ?? ?? 80 38 00 75 F5 EB B2 8D 45 F8 50 E8 ?? ?? ?? ?? 59 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 0B F6 45 FC 20 74 05 33 FF 47 EB 02 33 FF 8B 75 FC C1 EE 0B 8D 4D F8 83 E6 01 E8 ?? ?? ?? ?? 85 C0 75 08 8D 45 F8 E9 75 FF FF FF A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 96 00 00 00 3C 40 0F 84 8E 00 00 00 8D 45 F0 50 E8 ?? ?? ?? ?? 59 8D 4D F0 E8 ?? ?? ?? ?? 85 C0 75 78 38 05 ?? ?? ?? ?? 74 47 A2 ?? ?? ?? ?? 8B C1 50 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 74 49 8D 45 E8 50 E8 ?? ?? ?? ?? 59 50 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F8 50 8D 45 E8 50 8D 45 E0 EB 0B 8D 45 F8 50 8D 45 E0 50 8D 45 E8 68 ?? ?? ?? ?? 50 8D 4D F0 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 85 FF 74 10 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 75 04 83 4D FC 20 85 F6 BA 00 08 00 00 74 03 09 55 FC 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 0F 85 23 FF FF FF 66 F7 45 FC 00 01 0F 85 17 FF FF FF A1 ?? ?? ?? ?? 8A 00 84 C0 74 0E 3C 40 74 04 6A 01 EB 4E FF 05 ?? ?? ?? ?? 66 F7 05 ?? ?? ?? ?? 00 10 74 27 85 FF 75 23 85 55 FC 75 1E 21 7D F0 81 65 F4 00 F0 FF FF 8D 45 F0 50 8D 45 E0 50 E8 ?? ?? ?? ?? 59 59 E9 CC FE FF FF 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 0E 84 C9 75 B0 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 5F 5E C9 C3 }
	condition:
		$1
}

rule file_133_139_0 {
	meta:
		name = "?getScope@UnDecorator@@CA?AVDName@@XZ"
		size = 651
		refs = "0025 ??_C@_02MOLJINC@?3?3?$AA@ 0030 ?gName@UnDecorator@@0PBDB 0048 ?fExplicitTemplateParams@UnDecorator@@0_NA 0050 ?fGetTemplateArgumentList@UnDecorator@@0_NA 005d ?isEmpty@DName@@QBEHXZ 006c ??H@YA?AVDName@@PBDABV0@@Z 0077 ??4DName@@QAEAAV0@ABV0@@Z 0088 ??H@YA?AVDName@@DABV0@@Z 00df ?getLexicalFrame@UnDecorator@@CA?AVDName@@XZ 0100 ?getZName@UnDecorator@@CA?AVDName@@_N@Z 0109 ??HDName@@QBE?AV0@D@Z 0110 ??HDName@@QBE?AV0@ABV0@@Z 0144 ?getOperatorName@UnDecorator@@CA?AVDName@@_NPA_N@Z 0183 ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 01aa ??0DName@@QAE@AAPBDD@Z 01b3 ??_C@_0BG@JNJLAMPM@?$GAanonymous?5namespace?8?$AA@ 01ca ?pZNameList@UnDecorator@@0PAVReplicator@@A 01d8 ??YReplicator@@QAEAAV0@ABVDName@@@Z 0251 ??4DName@@QAEAAV0@W4DNameStatus@@@Z 0267 ??0DName@@QAE@W4DNameStatus@@@Z 026e ??HDName@@QBE?AV0@PBD@Z"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC 98 00 00 00 53 56 8B 75 7C 81 66 04 00 F0 FF FF 8B 46 04 33 DB A8 0F 57 89 1E 88 5D 7F BF ?? ?? ?? ?? 0F 85 EB 01 00 00 A1 ?? ?? ?? ?? 8A 00 3A C3 0F 84 DC 01 00 00 3C 40 0F 84 D4 01 00 00 38 1D ?? ?? ?? ?? 74 0C 38 1D ?? ?? ?? ?? 0F 84 27 02 00 00 8B CE E8 ?? ?? ?? ?? 85 C0 75 35 56 8D 45 E4 57 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B CE E8 ?? ?? ?? ?? 38 5D 7F 74 1A 56 8D 45 FC 6A 5B 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B CE E8 ?? ?? ?? ?? 88 5D 7F 8B 0D ?? ?? ?? ?? 80 39 3F 0F 85 46 01 00 00 41 89 0D ?? ?? ?? ?? 0F BE 01 83 E8 24 0F 84 22 01 00 00 48 0F 84 DC 00 00 00 83 E8 1A 74 5D 48 48 0F 84 CF 00 00 00 83 E8 08 56 74 12 8D 45 EC 50 8D 45 DC 50 E8 ?? ?? ?? ?? E9 18 01 00 00 8D 45 F4 50 6A 5D 8D 45 34 50 8D 45 04 41 6A 01 50 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? C6 45 7F 01 E9 EB 00 00 00 8D 41 01 80 38 5F 75 46 80 79 02 3F 75 40 A3 ?? ?? ?? ?? 56 8D 45 24 50 53 8D 45 4C 53 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 40 0F 85 A8 00 00 00 FF 05 ?? ?? ?? ?? E9 9D 00 00 00 56 8D 45 14 50 6A 27 8D 45 44 50 8D 45 3C 50 E8 ?? ?? ?? ?? 50 8D 45 2C 6A 60 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? EB 62 6A 40 68 ?? ?? ?? ?? 8D 4D 6C E8 ?? ?? ?? ?? 56 8D 45 1C 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8B CE E8 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 83 39 09 74 3D 8D 45 6C 50 E8 ?? ?? ?? ?? EB 32 8D 45 0C 56 49 50 89 0D ?? ?? ?? ?? 8D 45 64 EB 08 8D 45 54 56 50 8D 45 5C 6A 01 50 E8 ?? ?? ?? ?? 59 59 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? F6 46 04 0F 0F 84 15 FE FF FF A1 ?? ?? ?? ?? 8A 00 3A C3 74 1E 3C 40 74 58 8B 46 04 8B C8 83 E1 0F 80 F9 03 89 1E 74 49 83 E0 F1 83 C8 01 89 46 04 EB 3E 8B CE E8 ?? ?? ?? ?? 85 C0 74 09 6A 02 E8 ?? ?? ?? ?? EB 2A 56 8D 45 5C 50 57 8D 45 54 50 6A 02 8D 4D 64 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 5F 8B C6 5E 5B 83 C5 74 C9 C3 }
	condition:
		$1
}

rule file_133_140_0 {
	meta:
		name = "?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 833
		refs = "0004 ?gName@UnDecorator@@0PBDB 001a ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 003b ??0DName@@QAE@W4DNameStatus@@@Z 00bc ??0DName@@QAE@ABV0@@Z 00d3 ??_C@_02MOLJINC@?3?3?$AA@ 00d9 ??H@YA?AVDName@@PBDABV0@@Z 00e5 ??4DName@@QAEAAV0@ABV0@@Z 0100 ?getScope@UnDecorator@@CA?AVDName@@XZ 010c ??H@YA?AVDName@@DABV0@@Z 0116 ??HDName@@QBE?AV0@ABV0@@Z 0147 ?disableFlags@UnDecorator@@0KA 015d ?getThisType@UnDecorator@@CA?AVDName@@XZ 018e ?getBasedType@UnDecorator@@CA?AVDName@@XZ 01be ??_5DName@@QAEAAV0@ABV0@@Z 020e ?getCallingConvention@UnDecorator@@CA?AVDName@@XZ 023c ?isEmpty@DName@@QBEHXZ 025f ??HDName@@QBE?AV0@D@Z 0271 _heap 0276 ?getMemory@HeapManager@@QAEPAXIH@Z 0290 ?getReturnType@UnDecorator@@CA?AVDName@@PAV2@@Z 02a1 ?getArgumentTypes@UnDecorator@@CA?AVDName@@XZ 02c0 ??YDName@@QAEAAV0@ABV0@@Z 02f3 ?getThrowTypes@UnDecorator@@CA?AVDName@@XZ"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8A 08 83 EC 30 84 C9 75 15 FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E9 16 03 00 00 80 F9 36 7C 05 80 F9 39 7E 14 80 F9 5F 74 0F 8B 4D 08 6A 01 E8 ?? ?? ?? ?? E9 F8 02 00 00 53 0F BE D9 83 EB 36 40 83 FB 29 A3 ?? ?? ?? ?? 75 31 8A 08 84 C9 74 16 0F BE D9 83 EB 3D 40 83 FB 04 A3 ?? ?? ?? ?? 7C 23 83 FB 07 EB 1C FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E9 B4 02 00 00 85 DB 7C 05 83 FB 03 7E 03 83 CB FF 83 FB FF 75 0F 8B 4D 08 6A 01 E8 ?? ?? ?? ?? E9 94 02 00 00 83 65 F0 00 56 57 FF 75 0C BE 00 F0 FF FF 21 75 F4 8D 4D F8 E8 ?? ?? ?? ?? 8B FB 83 E7 02 0F 84 A0 00 00 00 8D 45 F8 50 8D 45 E0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 8D 45 F8 50 74 25 8D 45 E0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 50 8D 45 D0 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? EB 0E 8D 45 D0 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 89 00 00 00 3C 40 75 7E A1 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 83 E0 60 3C 60 8D 45 D0 50 74 57 E8 ?? ?? ?? ?? 59 50 8D 4D F0 E8 ?? ?? ?? ?? F6 C3 04 0F 84 80 00 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 74 60 8D 45 F8 50 8D 45 D0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 50 8D 45 E0 6A 20 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 41 E8 ?? ?? ?? ?? 59 50 8D 4D F0 E8 ?? ?? ?? ?? EB A7 6A 01 E9 66 01 00 00 8D 45 F8 50 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C E9 58 01 00 00 8D 45 D0 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 74 24 8D 45 F8 50 8D 45 D0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? EB 13 8D 45 D0 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 28 6A 29 8D 45 D0 50 8D 45 F8 50 8D 45 D8 6A 28 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? 6A 00 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 0A 83 20 00 21 70 04 8B F0 EB 02 33 F6 8D 45 E8 56 50 E8 ?? ?? ?? ?? 59 59 6A 29 8D 45 D0 50 8D 45 D8 50 E8 ?? ?? ?? ?? 50 8D 45 E0 6A 28 50 E8 ?? ?? ?? ?? 83 C4 10 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 83 E0 60 3C 60 74 10 85 FF 74 0C 8D 45 F0 50 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C1 E8 08 F7 D0 A8 01 8D 45 D0 50 74 11 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? EB 0F E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 85 F6 74 19 8D 45 F8 50 8B CE E8 ?? ?? ?? ?? 8B 4D 08 8D 45 E8 50 E8 ?? ?? ?? ?? EB 0A 6A 03 8B 4D 08 E8 ?? ?? ?? ?? 5F 5E 5B 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_141_0 {
	meta:
		name = "?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z"
		size = 1252
		refs = "0007 ?gName@UnDecorator@@0PBDB 003d ?getExtendedDataIndirectType@UnDecorator@@CA?AVDName@@AADAA_NH@Z 0048 ?isEmpty@DName@@QBEHXZ 0057 ??0DName@@QAE@ABV0@@Z 00a1 ?disableFlags@UnDecorator@@0KA 00c4 ?UScore@UnDecorator@@SAPBDW4Tokens@@@Z 00d9 ??HDName@@QBE?AV0@D@Z 00e0 ??HDName@@QBE?AV0@PBD@Z 00e9 ??4DName@@QAEAAV0@ABV0@@Z 0187 ??4DName@@QAEAAV0@PBD@Z 01f7 ??0DName@@QAE@D@Z 0207 ??HDName@@QBE?AV0@ABV0@@Z 0295 ??_C@_02MOLJINC@?3?3?$AA@ 029b ??H@YA?AVDName@@PBDABV0@@Z 02c2 ?getScope@UnDecorator@@CA?AVDName@@XZ 02d4 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 02ff ??_5DName@@QAEAAV0@ABV0@@Z 0314 ??YDName@@QAEAAV0@W4DNameStatus@@@Z 0354 ?getBasedType@UnDecorator@@CA?AVDName@@XZ 0392 ??_C@_09GAIEOBLP@volatile?5?$AA@ 03b5 ??_C@_06LIJLOJAG@const?5?$AA@ 0403 ??H@YA?AVDName@@DABV0@@Z 0448 ??YDName@@QAEAAV0@ABV0@@Z 04d8 ??0DName@@QAE@W4DNameStatus@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 54 A1 ?? ?? ?? ?? 8A 00 53 56 BE 00 F0 FF FF 21 75 E0 57 33 FF 84 C0 89 7D DC C6 45 FF 00 0F 84 3C 04 00 00 3C 24 75 33 FF 75 18 8D 45 FF 50 8D 45 10 50 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 10 8D 4D E4 E8 ?? ?? ?? ?? 85 C0 75 10 8B C1 8B 4D 08 50 E8 ?? ?? ?? ?? E9 7C 04 00 00 A1 ?? ?? ?? ?? 8A 00 33 C9 3C 41 0F 9C C1 21 75 F0 0F BE D8 6A 20 89 7D EC 49 83 E1 2B 83 C1 16 2B D9 21 75 E8 89 7D E4 5E 8B C3 83 E8 04 0F 84 AA 00 00 00 48 74 5B 83 E8 03 0F 85 41 01 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 0F 84 DA 00 00 00 8D 4D EC E8 ?? ?? ?? ?? 85 C0 6A 08 0F 85 B7 00 00 00 E8 ?? ?? ?? ?? 83 C4 04 50 8D 45 D4 50 8D 45 CC 56 50 8D 4D EC E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 4D EC 50 E8 ?? ?? ?? ?? E9 99 00 00 00 A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 0F 84 88 00 00 00 8D 4D E4 E8 ?? ?? ?? ?? 85 C0 6A 09 75 23 E8 ?? ?? ?? ?? 83 C4 04 50 8D 45 C4 50 56 8D 45 BC 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 8D 4D E4 EB B3 E8 ?? ?? ?? ?? 8D 4D E4 EB 44 A1 ?? ?? ?? ?? 8B C8 D1 E9 F7 D1 F6 C1 01 74 3D C1 E8 11 F7 D0 A8 01 74 34 8D 4D EC E8 ?? ?? ?? ?? 85 C0 6A 07 75 15 E8 ?? ?? ?? ?? 83 C4 04 50 8D 45 B4 50 8D 45 AC E9 59 FF FF FF E8 ?? ?? ?? ?? 8D 4D EC 83 C4 04 50 E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 24 75 27 FF 75 18 8D 45 FF 50 8D 45 10 50 8D 45 F4 50 E8 ?? ?? ?? ?? 83 C4 10 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 0F 84 9B 02 00 00 A1 ?? ?? ?? ?? 8A 00 33 C9 3C 41 0F 9C C1 0F BE D8 49 83 E1 2B 83 C1 16 2B D9 E9 A8 FE FF FF FF 05 ?? ?? ?? ?? 83 FB 1F 0F 87 90 00 00 00 FF 75 10 8D 4D F4 E8 ?? ?? ?? ?? 8D 45 F4 50 8D 45 AC 50 8D 4D DC E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 4D EC E8 ?? ?? ?? ?? 85 C0 75 24 8B C1 50 8D 45 AC 50 56 8D 45 B4 50 8D 4D F4 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 85 C0 75 22 8D 45 F4 50 8D 45 AC 50 56 8D 45 B4 50 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? F6 C3 10 0F 84 AD 00 00 00 39 7D 18 74 07 6A 01 E9 4D 02 00 00 80 7D 10 00 74 59 8D 45 F4 50 8D 45 AC 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 80 38 00 8D 45 F4 50 8D 45 AC 74 14 50 8D 45 B4 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? EB 0B 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? EB 1D A1 ?? ?? ?? ?? 80 38 00 74 1E 8D 45 AC 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 84 C0 75 0C 6A 02 8D 4D F4 E8 ?? ?? ?? ?? EB 0E FF 05 ?? ?? ?? ?? 3C 40 0F 85 58 FF FF FF A1 ?? ?? ?? ?? D1 E8 F7 D0 A8 01 8B C3 74 34 83 E0 0C 3C 0C 75 47 39 7D 18 0F 85 39 FF FF FF 8D 45 F4 50 8D 45 AC 50 8D 45 B4 50 E8 ?? ?? ?? ?? 59 8B C8 E8 ?? ?? ?? ?? 50 8D 4D F4 E8 ?? ?? ?? ?? EB 1A 83 E0 0C 3C 0C 75 13 8D 45 AC 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? F6 C3 02 74 1E 8D 45 F4 50 8D 45 AC 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? F6 C3 01 74 1E 8D 45 F4 50 8D 45 AC 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? 39 7D 18 75 7C 8B 55 0C 8B CA E8 ?? ?? ?? ?? 85 C0 75 4B 8B 5A 04 F6 C3 10 75 34 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 28 52 8D 45 AC 50 56 8D 45 B4 50 51 8D 45 BC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 29 84 DB 52 79 17 8D 4D F4 E8 ?? ?? ?? ?? EB 23 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 17 51 8D 45 AC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? 83 4D F8 10 80 7D FF 00 74 07 81 4D F8 00 02 00 00 8D 45 F4 E9 ED FB FF FF 39 7D 18 75 68 8B 55 0C 8B CA E8 ?? ?? ?? ?? 85 C0 75 4B F6 42 04 10 75 35 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 29 52 FF 75 08 8D 45 AC 6A 20 50 51 8D 45 B4 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 8B C8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? EB 29 52 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 19 8B 4D 14 E8 ?? ?? ?? ?? 85 C0 75 03 51 EB E2 6A 02 8B 4D 08 E8 ?? ?? ?? ?? 8B 45 08 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_133_142_0 {
	meta:
		name = "??BUnDecorator@@QAEPADXZ"
		size = 332
		refs = "001a ?name@UnDecorator@@0PBDB 0030 ?gName@UnDecorator@@0PBDB 003a ?getDecoratedName@UnDecorator@@CA?AVDName@@XZ 0043 ??_C@_04HEJADOOB@CV?3?5?$AA@ 0049 ??H@YA?AVDName@@PBDABV0@@Z 005d ?getTemplateName@UnDecorator@@CA?AVDName@@_N@Z 0068 ??4DName@@QAEAAV0@ABV0@@Z 00b0 ?disableFlags@UnDecorator@@0KA 00da ??4DName@@QAEAAV0@PBD@Z 00df ?outputString@UnDecorator@@0PADA 00eb ?length@DName@@QBEHXZ 00f1 ?maxStringLength@UnDecorator@@0HA 00fe _heap 0117 ?getString@DName@@QBEPADPADH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 83 65 F8 00 83 65 F0 00 B8 00 F0 FF FF 21 45 FC 21 45 F4 A1 ?? ?? ?? ?? 85 C0 74 74 80 38 3F 75 5C 8A 40 01 3C 40 75 24 83 05 ?? ?? ?? ?? 02 8D 45 E8 50 E8 ?? ?? ?? ?? 50 8D 45 E0 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 EB 3B 3C 24 75 2D 8D 45 E0 6A 00 50 E8 ?? ?? ?? ?? 59 59 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 FC 24 0F 3C 01 75 21 A1 ?? ?? ?? ?? 83 65 FC F0 A3 ?? ?? ?? ?? 8D 45 E0 50 E8 ?? ?? ?? ?? 59 50 8D 4D F8 E8 ?? ?? ?? ?? 8B 45 FC C1 E0 1C C1 F8 1C 83 F8 03 75 04 33 C0 C9 C3 83 F8 01 74 23 66 F7 05 ?? ?? ?? ?? 00 10 75 0A A1 ?? ?? ?? ?? 80 38 00 75 0E 8D 45 F8 50 8D 4D F0 E8 ?? ?? ?? ?? EB 0E FF 35 ?? ?? ?? ?? 8D 4D F0 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 85 C0 75 25 8D 4D F0 E8 ?? ?? ?? ?? 40 A3 ?? ?? ?? ?? 83 C0 07 83 E0 F8 50 FF 15 ?? ?? ?? ?? 85 C0 59 A3 ?? ?? ?? ?? 74 3E FF 35 ?? ?? ?? ?? 8D 4D F0 50 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B D0 EB 17 80 F9 20 75 0E 40 88 0A 42 EB 01 40 80 38 20 74 FA EB 04 88 0A 42 40 8A 08 84 C9 75 E3 8A C1 88 02 A1 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_133_143_0 {
	meta:
		name = "?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z"
		size = 278
		refs = "0006 ?gName@UnDecorator@@0PBDB 0028 ??0DName@@QAE@D@Z 0030 ?isEmpty@DName@@QBEHXZ 0053 ??YDName@@QAEAAV0@ABV0@@Z 0073 ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z 008f ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 00a5 ?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z 00b4 ??0DName@@QAE@W4DNameStatus@@@Z 00bf ??YDName@@QAEAAV0@D@Z 010d ??0DName@@QAE@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 8A 00 84 C0 0F 84 9A 00 00 00 3C 36 7C 04 3C 39 7E 04 3C 5F 75 5F 56 FF 75 14 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 8B 75 10 75 1C 8B CE E8 ?? ?? ?? ?? 85 C0 75 06 F6 46 04 10 75 0B FF 75 0C 8D 4D F8 E8 ?? ?? ?? ?? 8B CE E8 ?? ?? ?? ?? 85 C0 75 09 56 8D 4D F8 E8 ?? ?? ?? ?? 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 5E E9 92 00 00 00 6A 00 FF 75 0C 8D 45 F8 FF 75 14 FF 75 10 50 E8 ?? ?? ?? ?? 33 C0 80 7D 14 2A 0F 94 C0 50 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 EB 63 6A 02 8D 4D F8 E8 ?? ?? ?? ?? FF 75 14 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 09 51 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 10 E8 ?? ?? ?? ?? 85 C0 75 21 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 0A 6A 20 8D 4D F8 E8 ?? ?? ?? ?? FF 75 10 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 08 8D 45 F8 50 E8 ?? ?? ?? ?? 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_144_0 {
	meta:
		name = "?getPointerType@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 27
		refs = "000f ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z"
	strings:
		$1 = { 6A 2A FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 14 83 C4 10 C3 }
	condition:
		$1
}

rule file_133_145_0 {
	meta:
		name = "?getPointerTypeArray@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 27
		refs = "000f ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 14 83 C4 10 C3 }
	condition:
		$1
}

rule file_133_146_0 {
	meta:
		name = "?getReferenceType@UnDecorator@@CA?AVDName@@ABV2@0@Z"
		size = 27
		refs = "000f ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z"
	strings:
		$1 = { 6A 26 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 14 83 C4 10 C3 }
	condition:
		$1
}

rule file_133_147_0 {
	meta:
		name = "___unDName"
		size = 163
		refs = "0006 __sehtable$___unDName 000b __SEH_prolog4 001f __mtinitlocknum 002b __lock 0035 _heap 0069 ??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z 0074 ??BUnDecorator@@QAEPADXZ 0081 ?Destructor@HeapManager@@QAEXXZ 0095 __SEH_epilog4 009d __unlock"
	strings:
		$1 = { 68 84 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 14 33 F6 3B FE 75 04 33 C0 EB 78 6A 05 E8 ?? ?? ?? ?? 59 85 C0 74 F0 6A 05 E8 ?? ?? ?? ?? 59 89 75 FC 89 3D ?? ?? ?? ?? 8B 45 18 A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 0F B7 45 1C 50 56 FF 75 10 FF 75 0C FF 75 08 8D 8D 6C FF FF FF E8 ?? ?? ?? ?? 8D 8D 6C FF FF FF E8 ?? ?? ?? ?? 89 45 E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 05 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_133_148_0 {
	meta:
		name = "___unDNameEx"
		size = 163
		refs = "0006 __sehtable$___unDNameEx 000b __SEH_prolog4 001f __mtinitlocknum 002b __lock 0035 _heap 0069 ??0UnDecorator@@QAE@PADPBDHP6APADJ@ZK@Z 0074 ??BUnDecorator@@QAEPADXZ 0081 ?Destructor@HeapManager@@QAEXXZ 0095 __SEH_epilog4 009d __unlock"
	strings:
		$1 = { 68 84 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 14 33 F6 3B FE 75 04 33 C0 EB 78 6A 05 E8 ?? ?? ?? ?? 59 85 C0 74 F0 6A 05 E8 ?? ?? ?? ?? 59 89 75 FC 89 3D ?? ?? ?? ?? 8B 45 18 A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? FF 75 20 FF 75 1C FF 75 10 FF 75 0C FF 75 08 8D 8D 6C FF FF FF E8 ?? ?? ?? ?? 8D 8D 6C FF FF FF E8 ?? ?? ?? ?? 89 45 E4 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 05 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_133_149_0 {
	meta:
		name = "?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 884
		refs = "0004 ?gName@UnDecorator@@0PBDB 0048 $LN77 004d ??_C@_04ENMBGAPA@char?$AA@ 0057 ??_C@_05BFKKPKCG@short?$AA@ 0061 ??_C@_03JBIPMCLC@int?$AA@ 006b ??_C@_04GOKPGOLB@long?$AA@ 0075 ??_C@_05KNFBNCOH@float?$AA@ 00e5 ??_C@_06EBGKOKIG@__int8?$AA@ 00f6 ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 00fc ??_C@_06GCICPBLB@__w64?5?$AA@ 0104 ??H@YA?AVDName@@PBDABV0@@Z 0111 ??_C@_07ICFHOGAF@__int16?$AA@ 012a ??_C@_07LFCOJCAC@__int64?$AA@ 0134 ??_C@_07OFLPPHGP@__int32?$AA@ 013e ??_C@_08GAHOLHEO@__int128?$AA@ 016d ?getECSUDataType@UnDecorator@@CA?AVDName@@XZ 0177 ??4DName@@QAEAAV0@ABV0@@Z 017f ?isEmpty@DName@@QBEHXZ 0193 ??0DName@@QAE@ABV0@@Z 019d ??_C@_07NFANNNEC@UNKNOWN?$AA@ 01a4 ??_C@_07CLGGIAMF@wchar_t?$AA@ 01de ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z 01ec ??_C@_02GPECMEKF@?$FL?$FN?$AA@ 01f4 ??YDName@@QAEAAV0@PBD@Z 01fe ??_C@_04DDKJGDCM@bool?$AA@ 0206 ??4DName@@QAEAAV0@PBD@Z 021c ??_C@_05CJIMAING@long?5?$AA@ 0229 ??_C@_06BNJCAIGJ@double?$AA@ 027b ??_C@_09EBBEKKIH@unsigned?5?$AA@ 0297 ??_C@_07EDHNAJHC@signed?5?$AA@ 02c8 ??H@YA?AVDName@@DABV0@@Z 02d4 ??YDName@@QAEAAV0@ABV0@@Z 02ef ??_C@_05BNCCCJPP@const?$AA@ 0301 ??_C@_09EFNPDFFP@?5volatile?$AA@ 0315 ??_C@_08PABEKFH@volatile?$AA@ 0341 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z 0350 $LN44 035c $LN43 0364 $LN42 036c $LN41"
	strings:
		$1 = { 55 8B EC A1 ?? ?? ?? ?? 8A 00 83 EC 24 84 C0 53 56 57 0F 84 20 03 00 00 FF 05 ?? ?? ?? ?? 83 65 F4 00 0F B6 F8 BE 00 F0 FF FF 21 75 F8 8B C7 83 CB FF 83 F8 4D 7F 47 74 3B 83 E8 43 83 F8 08 0F 87 CE 01 00 00 FF 24 85 ?? ?? ?? ?? 68 ?? ?? ?? ?? E9 AC 01 00 00 68 ?? ?? ?? ?? E9 A2 01 00 00 68 ?? ?? ?? ?? E9 98 01 00 00 68 ?? ?? ?? ?? E9 8E 01 00 00 68 ?? ?? ?? ?? E9 84 01 00 00 83 F8 4E 0F 84 A1 01 00 00 83 F8 4F 0F 84 8B 01 00 00 0F 8E 7D 01 00 00 83 F8 53 0F 8E 6D 01 00 00 83 F8 5F 0F 85 6B 01 00 00 A1 ?? ?? ?? ?? 8A 00 FF 05 ?? ?? ?? ?? 88 45 FF 0F B6 C0 83 F8 4D 0F 8F 83 00 00 00 83 F8 4C 7D 74 83 F8 47 7F 4C 83 F8 46 7D 3D 83 F8 24 74 16 83 C0 BC 83 F8 01 0F 87 B8 00 00 00 68 ?? ?? ?? ?? E9 14 01 00 00 FF 75 0C 8D 45 E4 50 E8 ?? ?? ?? ?? 50 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 E9 38 02 00 00 68 ?? ?? ?? ?? E9 E8 00 00 00 83 F8 48 7C 7D 83 F8 49 7E 0F 83 F8 4B 7F 73 68 ?? ?? ?? ?? E9 CF 00 00 00 68 ?? ?? ?? ?? E9 C5 00 00 00 68 ?? ?? ?? ?? E9 BB 00 00 00 83 F8 4E 0F 84 AD 00 00 00 83 F8 4F 74 55 83 F8 57 74 49 83 C0 A8 83 F8 01 77 3A 8D 45 EC FF 0D ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 50 8D 4D F4 E8 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 85 C0 0F 84 B3 00 00 00 8D 45 F4 8B 4D 08 50 E8 ?? ?? ?? ?? E9 AC 01 00 00 68 ?? ?? ?? ?? EB 5F 68 ?? ?? ?? ?? EB 58 6A FE 5B FF 75 0C 83 65 F4 00 21 75 F8 8D 4D EC E8 ?? ?? ?? ?? 83 FB FE 0F 85 15 01 00 00 81 4D F0 80 00 00 00 6A 00 8D 45 EC 50 8D 45 F4 50 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 10 F6 45 E8 80 75 0D 68 ?? ?? ?? ?? 8D 4D E4 E8 ?? ?? ?? ?? 8D 45 E4 EB 91 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? EB 32 8B DF 83 E3 03 EB 22 8D 45 DC E9 4A FF FF FF 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 83 FB FF 0F 85 6F FF FF FF 8B C7 83 E8 43 74 4D 6A 02 59 2B C1 74 38 2B C1 74 34 2B C1 74 30 2B C1 74 2C 83 E8 14 75 53 0F B6 45 FF 83 E8 45 74 10 2B C1 74 0C 2B C1 74 08 2B C1 74 04 2B C1 75 3A 8D 45 F4 50 68 ?? ?? ?? ?? 8D 45 DC EB 1A 8D 45 F4 50 68 ?? ?? ?? ?? 8D 45 E4 EB 0C 8D 45 F4 50 68 ?? ?? ?? ?? 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 0F 85 CB FE FF FF 51 8D 45 DC 6A 20 50 E8 ?? ?? ?? ?? 83 C4 0C 50 8D 4D F4 E8 ?? ?? ?? ?? E9 AE FE FF FF 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 74 38 F6 C3 01 74 21 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? F6 C3 02 74 21 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? EB 12 F6 C3 02 74 0D 68 ?? ?? ?? ?? 8D 4D F4 E8 ?? ?? ?? ?? 6A 2A 8D 45 EC 50 8D 45 F4 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 10 FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5F 5E 5B C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_133_150_0 {
	meta:
		name = "?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 318
		refs = "0009 ?gName@UnDecorator@@0PBDB 0039 ?getBasicDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0045 ??_C@_08PABEKFH@volatile?$AA@ 004d ??4DName@@QAEAAV0@PBD@Z 0055 ?isEmpty@DName@@QBEHXZ 0063 ??YDName@@QAEAAV0@D@Z 006e ??0DName@@QAE@ABV0@@Z 008a ?getPtrRefType@UnDecorator@@CA?AVDName@@ABV2@0D@Z 00ab ??0DName@@QAE@W4DNameStatus@@@Z 00e9 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 010b ?getPtrRefDataType@UnDecorator@@CA?AVDName@@ABV2@H@Z 011f ?getFunctionIndirectType@UnDecorator@@CA?AVDName@@ABV2@@Z 0131 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 8B 35 ?? ?? ?? ?? 0F BE 06 33 D2 B9 00 F0 FF FF 21 4D FC 2B C2 89 55 F8 0F 84 03 01 00 00 83 E8 24 74 6C 83 E8 1D 74 38 48 74 12 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 F4 00 00 00 68 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 8B 4D 0C E8 ?? ?? ?? ?? 85 C0 75 0A 6A 20 8D 4D F8 E8 ?? ?? ?? ?? FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 83 4D F4 10 6A 26 8D 45 F0 50 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 E9 A2 00 00 00 8A 46 01 3C 24 74 17 3A C2 0F 84 83 00 00 00 8B 4D 08 6A 01 E8 ?? ?? ?? ?? E9 84 00 00 00 46 46 89 35 ?? ?? ?? ?? 0F BE 06 2B C2 74 65 83 E8 41 74 49 48 74 30 48 75 D7 21 4D F4 52 8D 45 F0 50 52 FF 75 0C 8D 45 E8 46 50 89 35 ?? ?? ?? ?? 89 55 F0 E8 ?? ?? ?? ?? 50 FF 75 08 E8 ?? ?? ?? ?? 83 C4 1C EB 3D 6A 01 FF 75 0C 46 FF 75 08 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 24 FF 75 0C 46 FF 75 08 89 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? E9 15 FF FF FF FF 75 0C 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 5E C9 C3 }
	condition:
		$1
}

rule file_133_151_0 {
	meta:
		name = "?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z"
		size = 177
		refs = "000d ??0DName@@QAE@PAV0@@Z 0012 ?gName@UnDecorator@@0PBDB 002e ?getPrimaryDataType@UnDecorator@@CA?AVDName@@ABV2@@Z 0040 ?isEmpty@DName@@QBEHXZ 004c ??_C@_04GKJNKENE@void?$AA@ 0051 ??0DName@@QAE@PBD@Z 005c ??_C@_05BEFAKPML@void?5?$AA@ 0064 ??H@YA?AVDName@@PBDABV0@@Z 0089 ?getDataIndirectType@UnDecorator@@CA?AVDName@@ABV2@D0H@Z 0095 ??4DName@@QAEAAV0@ABV0@@Z 00a5 ??H@YA?AVDName@@W4DNameStatus@@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 FF 75 0C 8D 4D F8 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8A 00 33 C9 3A C1 74 7D 3C 3F 74 48 3C 58 74 10 8D 45 F8 50 FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 76 FF 05 ?? ?? ?? ?? 8D 4D F8 E8 ?? ?? ?? ?? 85 C0 74 0F 8B 4D 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 55 8D 45 F8 50 68 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? EB 3F FF 05 ?? ?? ?? ?? 81 65 F4 00 F0 FF FF 51 8D 45 F0 50 51 8D 45 F8 50 8D 45 E8 50 89 4D F0 E8 ?? ?? ?? ?? 83 C4 14 50 8D 4D F8 E8 ?? ?? ?? ?? EB 8B 8D 45 F8 50 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 C9 C3 }
	condition:
		$1
}

rule file_133_152_0 {
	meta:
		name = "?getExternalDataType@UnDecorator@@CA?AVDName@@ABV2@@Z"
		size = 100
		refs = "000d _heap 0012 ?getMemory@HeapManager@@QAEPAXIH@Z 002a ?getDataType@UnDecorator@@CA?AVDName@@PAV2@@Z 0033 ?getDataIndirectType@UnDecorator@@CA?AVDName@@XZ 004b ??HDName@@QBE?AV0@D@Z 0052 ??HDName@@QBE?AV0@ABV0@@Z 005a ??4DName@@QAEAAV0@ABV0@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 33 F6 56 6A 08 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 3B C6 74 0B 81 60 04 00 F0 FF FF 89 30 8B F0 56 FF 75 08 E8 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 83 C4 0C FF 75 0C 8D 45 F0 50 6A 20 8D 45 E8 50 8D 4D F8 E8 ?? ?? ?? ?? 8B C8 E8 ?? ?? ?? ?? 50 8B CE E8 ?? ?? ?? ?? 8B 45 08 5E C9 C3 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "__ioinit"
		size = 576
		refs = "0003 __sehtable$__ioinit 0008 __SEH_prolog4 0017 __imp__GetStartupInfoA@4 0029 __calloc_crt 0038 ___pioinfo 003e __nhandle 012d __imp__GetFileType@4 0160 ___crtInitCritSecAndSpinCount 01b7 __imp__GetStdHandle@4 0221 __imp__SetHandleCount@4 023b __SEH_epilog4"
	strings:
		$1 = { 6A 54 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D FC 8D 45 9C 50 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF 6A 28 6A 20 5E 56 E8 ?? ?? ?? ?? 59 59 3B C7 0F 84 00 02 00 00 A3 ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 8D 88 00 05 00 00 EB 29 C6 40 04 00 83 08 FF C6 40 05 0A 89 78 08 C6 40 24 00 C6 40 25 0A C6 40 26 0A 83 C0 28 8B 0D ?? ?? ?? ?? 81 C1 00 05 00 00 3B C1 72 D3 66 39 7D CE 0F 84 FD 00 00 00 8B 45 D0 3B C7 0F 84 F2 00 00 00 8B 38 8D 58 04 8D 04 3B 89 45 E4 B8 00 08 00 00 3B F8 7C 02 8B F8 33 F6 46 EB 52 6A 28 6A 20 E8 ?? ?? ?? ?? 59 59 85 C0 74 4D 8D 0C B5 ?? ?? ?? ?? 89 01 83 05 ?? ?? ?? ?? 20 8D 90 00 05 00 00 EB 26 C6 40 04 00 83 08 FF C6 40 05 0A 83 60 08 00 80 60 24 80 C6 40 25 0A C6 40 26 0A 83 C0 28 8B 11 81 C2 00 05 00 00 3B C2 72 D6 46 39 3D ?? ?? ?? ?? 7C A6 EB 06 8B 3D ?? ?? ?? ?? 83 65 E0 00 85 FF 7E 6D 8B 45 E4 8B 08 83 F9 FF 74 56 83 F9 FE 74 51 8A 03 A8 01 74 4B A8 08 75 0B 51 FF 15 ?? ?? ?? ?? 85 C0 74 3C 8B 75 E0 8B C6 C1 F8 05 83 E6 1F 6B F6 28 03 34 85 ?? ?? ?? ?? 8B 45 E4 8B 00 89 06 8A 03 88 46 04 68 A0 0F 00 00 8D 46 0C 50 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 C9 00 00 00 FF 46 08 FF 45 E0 43 83 45 E4 04 39 7D E0 7C 93 33 DB 8B F3 6B F6 28 03 35 ?? ?? ?? ?? 8B 06 83 F8 FF 74 0B 83 F8 FE 74 06 80 4E 04 80 EB 72 C6 46 04 81 85 DB 75 05 6A F6 58 EB 0A 8B C3 48 F7 D8 1B C0 83 C0 F5 50 FF 15 ?? ?? ?? ?? 8B F8 83 FF FF 74 43 85 FF 74 3F 57 FF 15 ?? ?? ?? ?? 85 C0 74 34 89 3E 25 FF 00 00 00 83 F8 02 75 06 80 4E 04 40 EB 09 83 F8 03 75 04 80 4E 04 08 68 A0 0F 00 00 8D 46 0C 50 E8 ?? ?? ?? ?? 59 59 85 C0 74 37 FF 46 08 EB 0A 80 4E 04 40 C7 06 FE FF FF FF 43 83 FB 03 0F 8C 67 FF FF FF FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 EB 11 33 C0 40 C3 8B 65 E8 C7 45 FC FE FF FF FF 83 C8 FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "__ioterm"
		size = 76
		refs = "0003 ___pioinfo 0021 __imp__DeleteCriticalSection@4 0036 _free"
	strings:
		$1 = { 56 57 BE ?? ?? ?? ?? 8B 3E 85 FF 74 31 8D 87 00 05 00 00 EB 1A 83 7F 08 00 74 0A 8D 47 0C 50 FF 15 ?? ?? ?? ?? 8B 06 83 C7 28 05 00 05 00 00 3B F8 72 E2 FF 36 E8 ?? ?? ?? ?? 83 26 00 59 83 C6 04 81 FE ?? ?? ?? ?? 7C BE 5F 5E C3 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "__fdopen"
		size = 390
		refs = "0003 __sehtable$__fdopen 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 0056 __nhandle 0077 ___pioinfo 00ab __commode 0138 __getstream 015a __cflush 0176 __SEH_epilog4 0180 __unlock_file"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 4D 0C 33 FF 3B CF 0F 95 C0 3B C7 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 3A 01 00 00 8B 45 08 83 F8 FE 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB E4 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB BE 8B D0 C1 FA 05 83 E0 1F 6B C0 28 8B 14 95 ?? ?? ?? ?? 0F B6 44 02 04 33 F6 46 23 C6 74 D5 EB 01 41 80 39 20 74 FA 8A 01 3C 61 74 0C 3C 72 74 18 3C 77 0F 85 7B FF FF FF 6A 02 5B 33 D2 89 7D 0C 0B 1D ?? ?? ?? ?? EB 68 8B DE EB EF 3B F7 74 6A 0F BE C0 83 E8 20 74 58 83 E8 0B 74 42 83 E8 37 74 11 48 74 2B 83 E8 0B 74 17 83 E8 06 0F 85 40 FF FF FF 39 7D 0C 75 2B C7 45 0C 01 00 00 00 EB 2F 3B D7 75 1E 33 D2 42 81 E3 FF BF FF FF EB 20 3B D7 75 0F 33 D2 42 81 CB 00 40 00 00 EB 11 84 DB 79 04 33 F6 EB 09 83 E3 FC 81 CB 80 00 00 00 41 8A 01 84 C0 75 95 EB 01 41 80 39 20 74 FA 33 C0 38 01 0F 94 C0 3B C7 0F 84 E5 FE FF FF E8 ?? ?? ?? ?? 8B F0 89 75 0C 3B F7 75 10 E8 ?? ?? ?? ?? C7 00 18 00 00 00 E9 DF FE FF FF 89 7D FC FF 05 ?? ?? ?? ?? 89 5E 0C 8B 45 08 89 46 10 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B C6 E8 ?? ?? ?? ?? C3 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_136_0_0 {
	meta:
		name = "_vscan_fn"
		size = 97
		refs = "000e __errno 001e __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 34 39 75 0C 74 DE 89 45 E8 89 45 E0 B8 FF FF FF 7F 3B C8 C7 45 EC 49 00 00 00 89 45 E4 77 03 89 4D E4 FF 75 14 8D 45 E0 FF 75 10 FF 75 0C 50 FF 55 08 83 C4 10 5E C9 C3 }
	condition:
		$1
}

rule file_136_1_0 {
	meta:
		name = "__snscanf"
		size = 33
		refs = "0014 __input_l 0019 _vscan_fn"
	strings:
		$1 = { 8B 4C 24 08 8D 44 24 10 50 8B 44 24 08 6A 00 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_136_3_0 {
	meta:
		name = "__snscanf_s"
		size = 33
		refs = "0014 __input_s_l 0019 _vscan_fn"
	strings:
		$1 = { 8B 4C 24 08 8D 44 24 10 50 8B 44 24 08 6A 00 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_564_1_0 {
	meta:
		name = "__snwscanf"
		size = 33
		refs = "0014 __winput_l 0019 _vscan_fn"
	strings:
		$1 = { 8B 4C 24 08 8D 44 24 10 50 8B 44 24 08 6A 00 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_564_3_0 {
	meta:
		name = "__snwscanf_s"
		size = 33
		refs = "0014 __winput_s_l 0019 _vscan_fn"
	strings:
		$1 = { 8B 4C 24 08 8D 44 24 10 50 8B 44 24 08 6A 00 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_136_2_0 {
	meta:
		name = "__snscanf_l"
		size = 34
		refs = "0014 __input_l 0019 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8D 45 18 50 FF 75 14 8B 45 08 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_136_4_0 {
	meta:
		name = "__snscanf_s_l"
		size = 34
		refs = "0014 __input_s_l 0019 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8D 45 18 50 FF 75 14 8B 45 08 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_564_2_0 {
	meta:
		name = "__snwscanf_l"
		size = 34
		refs = "0014 __winput_l 0019 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8D 45 18 50 FF 75 14 8B 45 08 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_564_4_0 {
	meta:
		name = "__snwscanf_s_l"
		size = 34
		refs = "0014 __winput_s_l 0019 _vscan_fn"
	strings:
		$1 = { 55 8B EC 8B 4D 0C 8D 45 18 50 FF 75 14 8B 45 08 FF 75 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5D C3 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "__rmdir"
		size = 42
		refs = "0006 __imp__RemoveDirectoryA@4 0010 __imp__GetLastError@0 001e __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_911_0_0 {
	meta:
		name = "__wremove"
		size = 42
		refs = "0006 __imp__DeleteFileW@4 0010 __imp__GetLastError@0 001e __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_812_0_0 {
	meta:
		name = "__wrmdir"
		size = 42
		refs = "0006 __imp__RemoveDirectoryW@4 0010 __imp__GetLastError@0 001e __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_726_0_0 {
	meta:
		name = "_remove"
		size = 42
		refs = "0006 __imp__DeleteFileA@4 0010 __imp__GetLastError@0 001e __dosmaperr"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "___wtomb_environ"
		size = 149
		refs = "000c __wenviron 001b __imp__WideCharToMultiByte@32 0035 __calloc_crt 005a ___crtsetenv 006d _free"
	strings:
		$1 = { 55 8B EC 51 51 53 56 33 F6 57 8B 3D ?? ?? ?? ?? 89 75 FC 8B 07 3B C6 74 65 8B 1D ?? ?? ?? ?? 56 56 56 56 6A FF 50 56 56 FF D3 3B C6 89 45 F8 74 54 6A 01 50 E8 ?? ?? ?? ?? 3B C6 59 59 89 45 FC 74 43 56 56 FF 75 F8 50 6A FF FF 37 56 56 FF D3 85 C0 74 36 8D 45 FC 56 50 E8 ?? ?? ?? ?? 85 C0 59 59 7D 11 39 75 FC 74 0C FF 75 FC E8 ?? ?? ?? ?? 59 89 75 FC 83 C7 04 8B 07 3B C6 75 A1 33 C0 5F 5E 5B C9 C3 83 C8 FF EB F6 FF 75 FC E8 ?? ?? ?? ?? 59 EB F0 }
	condition:
		$1
}

rule file_140_3_0 {
	meta:
		name = "__ismbclegal_l"
		size = 69
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 08 C1 E8 08 0F B6 C8 8B 45 F4 F6 44 01 1D 04 74 10 0F B6 4D 08 F6 44 01 1D 08 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_142_10_0 {
	meta:
		name = "__cprinput_l"
		size = 3053
		refs = "000f ___security_cookie 0048 __errno 0058 __invalid_parameter 0071 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0090 _iswctype 00a1 __whiteout 00a7 __un_inc 0109 _isdigit 024a __getwche_nolock 0355 ___check_float_string 0399 __mbtowc_l 05a1 __malloc_crt 05bd _wcstombs_s 05d8 __invoke_watson 05ef __cfltcvt_tab 05f4 __decode_pointer 05fd _free 0759 _memset 08c0 _wctomb_s 09e7 __allmul 09ff _isxdigit 0a1e __hextodec 0be1 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 38 FD FF FF 81 EC 38 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 C4 02 00 00 8B 85 D4 02 00 00 56 57 33 FF 8B F1 3B F7 89 45 B0 8D 45 08 89 45 EC C7 45 C4 5E 01 00 00 89 7D C0 89 7D B8 89 7D A8 89 7D FC 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 6F 0B 00 00 FF B5 D0 02 00 00 8D 4D 90 E8 ?? ?? ?? ?? 0F B7 06 66 3B C7 C6 45 F3 00 89 7D 00 89 7D BC 0F 84 3B 0B 00 00 53 6A 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 2A FF 4D 00 8D 7D 00 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 46 46 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 ED E9 CC 0A 00 00 66 83 3E 25 0F 85 AA 0A 00 00 33 C0 89 45 C8 89 45 A0 89 45 E4 89 45 E0 89 45 F8 88 45 D7 88 45 F2 88 45 F6 88 45 07 88 45 F4 88 45 F7 C6 45 F5 01 89 45 CC 46 46 0F B7 1E 66 F7 C3 00 FF 75 23 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 15 8B 45 F8 FF 45 E0 6B C0 0A 8D 44 18 D0 89 45 F8 E9 B4 00 00 00 83 FB 4E 0F 8F 80 00 00 00 0F 84 A5 00 00 00 83 FB 2A 74 70 83 FB 46 0F 84 97 00 00 00 83 FB 49 74 0D 83 FB 4C 75 71 FE 45 F5 E9 85 00 00 00 0F B7 4E 02 66 83 F9 36 75 18 8D 46 04 66 83 38 34 75 0F FF 45 CC 83 65 D8 00 83 65 DC 00 8B F0 EB 63 66 83 F9 33 75 0D 8D 46 04 66 83 38 32 75 04 8B F0 EB 50 66 83 F9 64 74 4A 66 83 F9 69 74 44 66 83 F9 6F 74 3E 66 83 F9 78 74 38 66 83 F9 58 75 16 EB 30 FE 45 F6 EB 2B 83 FB 68 74 20 83 FB 6C 74 0A 83 FB 77 74 11 FE 45 07 EB 17 8D 46 02 66 83 38 6C 74 9C FE 45 F5 FE 45 F7 EB 06 FE 4D F5 FE 4D F7 80 7D 07 00 0F 84 13 FF FF FF 80 7D F6 00 89 75 B4 75 10 8B 45 B0 8B 38 89 45 A4 83 C0 04 89 45 B0 EB 02 33 FF 80 7D F7 00 89 7D D0 C6 45 07 00 75 17 0F B7 06 66 3D 53 00 74 0A 66 3D 43 00 C6 45 F7 01 75 04 C6 45 F7 FF 0F B7 06 83 C8 20 83 F8 6E 89 45 E8 74 32 83 F8 63 74 0F 83 F8 7B 74 0A 8D 7D 00 E8 ?? ?? ?? ?? EB 08 FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 66 3D FF FF 89 45 FC 0F 84 49 09 00 00 8B 7D D0 8B 75 B4 83 7D E0 00 74 0A 83 7D F8 00 0F 84 2A 09 00 00 8B 4D E8 6A 6F 5B 3B CB 0F 8F 40 04 00 00 0F 84 BC 06 00 00 83 F9 63 0F 84 78 03 00 00 6A 64 58 3B C8 0F 84 A8 06 00 00 0F 8E 4A 04 00 00 83 F9 67 7E 37 83 F9 69 74 1B 83 F9 6E 0F 85 37 04 00 00 80 7D F6 00 8B 75 00 0F 84 8C 08 00 00 E9 A7 08 00 00 89 45 E8 66 83 7D FC 2D 0F 85 31 05 00 00 C6 45 F2 01 E9 2F 05 00 00 33 DB 66 83 7D FC 2D 75 0B 8B 45 EC 66 C7 00 2D 00 43 EB 07 66 83 7D FC 2B 75 11 FF 4D F8 FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 89 45 FC 83 7D E0 00 75 04 83 4D F8 FF 66 F7 45 FC 00 FF 75 5C 0F B6 45 FC 50 E8 ?? ?? ?? ?? 85 C0 59 74 4D 8B 45 F8 FF 4D F8 85 C0 74 43 66 0F BE 45 FC 8B 4D EC FF 45 E4 66 89 04 59 8D 45 C0 50 8D 45 08 50 43 53 8D 7D EC 8D 75 C4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 43 08 00 00 FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 89 45 FC 74 A4 8D 45 90 50 8B 45 90 C7 45 AC 2E 00 00 00 FF B0 AC 00 00 00 8B 80 BC 00 00 00 FF 30 8D 45 AC 50 E8 ?? ?? ?? ?? 0F B7 45 AC 0F BE 4D FC 83 C4 10 3B C1 0F 85 AA 00 00 00 8B 45 F8 FF 4D F8 85 C0 0F 84 9C 00 00 00 FF 45 00 E8 ?? ?? ?? ?? 8B 4D EC 0F B7 C0 89 45 FC 66 8B 45 AC 66 89 04 59 8D 45 C0 50 8D 45 08 50 43 53 8D 7D EC 8D 75 C4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 B0 07 00 00 66 F7 45 FC 00 FF 75 5B 0F B6 45 FC 50 E8 ?? ?? ?? ?? 85 C0 59 74 4C 8B 45 F8 FF 4D F8 85 C0 74 42 8B 45 EC 66 8B 4D FC FF 45 E4 66 89 0C 58 8D 45 C0 50 8D 45 08 50 43 53 8D 7D EC 8D 75 C4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 61 07 00 00 FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 89 45 FC 74 A5 83 7D E4 00 0F 84 09 01 00 00 66 83 7D FC 65 74 0B 66 83 7D FC 45 0F 85 F7 00 00 00 8B 45 F8 FF 4D F8 85 C0 0F 84 E9 00 00 00 8B 45 EC 66 C7 04 58 65 00 8D 45 C0 50 8D 45 08 50 43 53 8D 7D EC 8D 75 C4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 FA 06 00 00 FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 66 3D 2D 00 89 45 FC 75 25 8B 45 EC 66 C7 04 58 2D 00 8D 45 C0 50 8D 45 08 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 C3 06 00 00 EB 07 66 83 7D FC 2B 75 1D 8B 45 F8 FF 4D F8 85 C0 75 05 21 45 F8 EB 0E FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 89 45 FC 66 F7 45 FC 00 FF 75 5B 0F B6 45 FC 50 E8 ?? ?? ?? ?? 85 C0 59 74 4C 8B 45 F8 FF 4D F8 85 C0 74 42 8B 45 EC 66 8B 4D FC FF 45 E4 66 89 0C 58 8D 45 C0 50 8D 45 08 50 43 53 8D 7D EC 8D 75 C4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 4E 06 00 00 FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 89 45 FC 74 A5 FF 75 FC FF 4D 00 E8 ?? ?? ?? ?? 83 7D E4 00 59 0F 84 24 06 00 00 80 7D F6 00 0F 85 E1 05 00 00 8B 75 C4 8B 45 EC FF 45 BC 66 83 24 58 00 8D 74 36 02 56 E8 ?? ?? ?? ?? 8B F8 85 FF 59 0F 84 F7 05 00 00 8D 46 FF 50 FF 75 EC 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 17 83 F8 16 74 05 83 F8 22 75 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8D 45 90 50 0F BE 45 F5 57 FF 75 D0 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 65 05 00 00 83 7D E0 00 75 0A FF 45 F8 C7 45 E0 01 00 00 00 80 7D F7 00 7E 04 C6 45 F4 01 FF 75 FC FF 4D 00 8B F7 E8 ?? ?? ?? ?? 59 83 7D E0 00 74 0E 8B 45 F8 FF 4D F8 85 C0 0F 84 C2 02 00 00 FF 45 00 E8 ?? ?? ?? ?? 83 7D E8 63 0F B7 D0 89 55 FC 74 4B 83 7D E8 73 75 16 66 83 FA 09 72 0A 66 83 FA 0D 0F 86 8E 02 00 00 66 83 FA 20 75 2F 83 7D E8 7B 0F 85 7E 02 00 00 0F B7 C2 8B C8 33 DB 83 E1 07 43 D3 E3 8B 4D B8 C1 E8 03 0F BE 04 08 0F BE 4D D7 33 C1 85 D8 0F 84 59 02 00 00 80 7D F6 00 0F 85 48 02 00 00 80 7D F4 00 0F 84 FA 01 00 00 66 89 17 47 47 E9 2C 02 00 00 8B C1 83 E8 70 0F 84 73 02 00 00 83 E8 03 0F 84 43 FF FF FF 48 48 0F 84 66 02 00 00 83 E8 03 0F 84 E3 FB FF FF 83 E8 03 74 25 66 8B 45 FC 66 39 06 0F 85 A5 04 00 00 FE 4D F3 80 7D F6 00 0F 85 68 04 00 00 8B 45 A4 89 45 B0 E9 5D 04 00 00 80 7D F7 00 7E 04 C6 45 F4 01 46 46 66 83 3E 5E 75 07 83 C6 02 C6 45 D7 FF 83 7D B8 00 75 1D 68 00 20 00 00 E8 ?? ?? ?? ?? 85 C0 59 89 45 B8 0F 84 61 04 00 00 C7 45 A8 01 00 00 00 8B 5D B8 68 00 20 00 00 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 66 83 3E 5D 75 0B 6A 5D 46 5F 46 C6 43 0B 20 EB 77 8B 7D A0 EB 72 0F B7 C0 46 46 66 3D 2D 00 75 51 66 85 FF 74 4C 0F B7 0E 66 83 F9 5D 74 43 0F B7 C9 46 46 66 3B F9 73 05 0F B7 C1 EB 06 0F B7 C7 0F B7 F9 66 3B F8 77 22 2B C7 40 0F B7 D7 0F B7 F8 8B 4D B8 8B C2 C1 E8 03 03 C1 8B CA 83 E1 07 B3 01 D2 E3 08 18 42 4F 75 E7 8B 5D B8 33 FF EB 16 0F B7 C8 0F B7 F8 8B C1 83 E1 07 B2 01 C1 E8 03 D2 E2 03 C3 08 10 0F B7 06 66 3D 5D 00 75 85 66 83 3E 00 0F 84 AC 03 00 00 8B 7D D0 89 75 B4 E9 1D FE FF FF 66 83 7D FC 2B 75 1F FF 4D F8 75 0C 83 7D E0 00 74 06 C6 45 07 01 EB 0E FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 89 45 FC 6A 30 5F 66 39 7D FC 0F 85 3E 01 00 00 FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 6A 78 5E 66 3B C6 89 45 FC 74 3A 66 3D 58 00 74 34 39 75 E8 C7 45 E4 01 00 00 00 74 16 83 7D E0 00 74 08 FF 4D F8 75 03 FE 45 07 89 5D E8 E9 00 01 00 00 FF 4D 00 50 E8 ?? ?? ?? ?? 59 89 7D FC E9 EE 00 00 00 FF 45 00 E8 ?? ?? ?? ?? 83 7D E0 00 0F B7 C0 89 45 FC 74 0D 83 6D F8 02 83 7D F8 01 7D 03 FE 45 07 89 75 E8 E9 C5 00 00 00 52 6A 05 8D 45 CC 57 33 DB 50 89 5D CC E8 ?? ?? ?? ?? 83 C4 10 3B C3 74 20 83 F8 16 74 09 83 F8 22 0F 85 58 FD FF FF 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E9 46 FD FF FF 03 7D CC 89 7D D0 E9 3B FD FF FF 46 46 E9 34 FD FF FF FF 4D 00 52 E8 ?? ?? ?? ?? 59 3B F7 0F 84 98 02 00 00 80 7D F6 00 0F 85 55 02 00 00 FF 45 BC 83 7D E8 63 0F 84 48 02 00 00 80 7D F4 00 8B 45 D0 74 09 66 83 20 00 E9 36 02 00 00 C6 00 00 E9 2E 02 00 00 C6 45 F5 01 66 83 7D FC 2D 75 06 C6 45 F2 01 EB 07 66 83 7D FC 2B 75 1F FF 4D F8 75 0C 83 7D E0 00 74 06 C6 45 07 01 EB 0E FF 45 00 E8 ?? ?? ?? ?? 0F B7 C0 89 45 FC 83 7D CC 00 0F 84 04 01 00 00 80 7D 07 00 0F 85 D5 00 00 00 8B 5D FC 83 7D E8 78 74 5F 83 7D E8 70 74 59 66 F7 C3 00 FF 0F 85 B1 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 9F 00 00 00 83 7D E8 6F 75 1F 66 83 FB 38 0F 83 8F 00 00 00 8B 45 D8 8B 4D DC 0F A4 C1 03 C1 E0 03 89 45 D8 89 4D DC EB 4C 6A 00 6A 0A FF 75 DC FF 75 D8 E8 ?? ?? ?? ?? 89 45 D8 89 55 DC EB 35 66 F7 C3 00 FF 75 5C 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 4E 8B 45 D8 8B 4D DC 0F A4 C1 04 C1 E0 04 8B FB 89 45 D8 89 4D DC E8 ?? ?? ?? ?? 0F B7 D8 89 5D FC FF 45 E4 0F B7 C3 83 E8 30 99 01 45 D8 11 55 DC 83 7D E0 00 74 05 FF 4D F8 74 1D FF 45 00 E8 ?? ?? ?? ?? 0F B7 D8 89 5D FC E9 38 FF FF FF FF 4D 00 53 E8 ?? ?? ?? ?? 59 80 7D F2 00 8B 75 C8 0F 84 C5 00 00 00 8B 45 D8 8B 4D DC F7 D8 83 D1 00 F7 D9 89 45 D8 89 4D DC E9 AD 00 00 00 80 7D 07 00 8B 75 C8 0F 85 98 00 00 00 8B 5D FC 83 7D E8 78 74 31 83 7D E8 70 74 2B 66 F7 C3 00 FF 75 78 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 6A 83 7D E8 6F 75 0B 66 83 FB 38 73 5E C1 E6 03 EB 2E 6B F6 0A EB 29 66 F7 C3 00 FF 75 4D 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 3F C1 65 C8 04 8B FB E8 ?? ?? ?? ?? 8B 75 C8 0F B7 D8 89 5D FC FF 45 E4 83 7D E0 00 0F B7 C3 8D 74 06 D0 89 75 C8 74 05 FF 4D F8 74 1D FF 45 00 E8 ?? ?? ?? ?? 0F B7 D8 89 5D FC E9 75 FF FF FF FF 4D 00 53 E8 ?? ?? ?? ?? 59 80 7D F2 00 74 02 F7 DE 83 7D E8 46 75 04 83 65 E4 00 83 7D E4 00 74 65 80 7D F6 00 75 26 FF 45 BC 8B 7D D0 83 7D CC 00 74 0D 8B 45 D8 89 07 8B 45 DC 89 47 04 EB 0D 80 7D F5 00 74 04 89 37 EB 03 66 89 37 FE 45 F3 8B 75 B4 46 46 EB 18 FF 45 00 E8 ?? ?? ?? ?? 66 8B 0E 0F B7 C0 46 46 66 3B C8 89 45 FC 75 0E 0F B7 06 66 85 C0 0F 85 F0 F4 FF FF EB 09 FF 75 FC E8 ?? ?? ?? ?? 59 83 7D A8 01 5B 75 09 FF 75 B8 E8 ?? ?? ?? ?? 59 83 7D C0 01 75 09 FF 75 EC E8 ?? ?? ?? ?? 59 80 7D 9C 00 74 07 8B 45 98 83 60 70 FD 8B 45 BC 8B 8D C4 02 00 00 5F 33 CD 5E E8 ?? ?? ?? ?? 81 C5 C8 02 00 00 C9 C3 }
	condition:
		$1
}

rule file_144_0_0 {
	meta:
		name = "_strcpy_s"
		size = 101
		refs = "0016 __errno 0025 __invalid_parameter"
	strings:
		$1 = { 8B 4C 24 04 53 33 DB 3B CB 56 57 74 08 8B 7C 24 14 3B FB 77 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 31 8B 74 24 18 3B F3 75 04 88 19 EB D9 8B D1 8A 06 88 02 42 46 3A C3 74 03 4F 75 F3 3B FB 75 10 88 19 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB C0 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule file_145_5_0 {
	meta:
		name = "?__crtGetLocaleInfoA_stat@@YAHPAUlocaleinfo_struct@@KKPADHH@Z"
		size = 317
		refs = "0006 ___security_cookie 0010 ?f_use@?1??__crtGetLocaleInfoA_stat@@YAHPAUlocaleinfo_struct@@KKPADHH@Z@4HA 0017 __imp__GetLocaleInfoW@16 003a __imp__GetLastError@0 00ab __alloca_probe_16 00c2 _malloc 0108 __imp__WideCharToMultiByte@32 0110 __freea 0127 __imp__GetLocaleInfoA@16 0137 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 51 51 A1 ?? ?? ?? ?? 33 C5 89 45 FC A1 ?? ?? ?? ?? 53 8B 1D ?? ?? ?? ?? 56 57 33 FF 33 F6 47 3B C6 75 2C 56 56 57 56 FF D3 85 C0 74 08 89 3D ?? ?? ?? ?? EB 2F FF 15 ?? ?? ?? ?? 83 F8 78 75 0A 6A 02 58 A3 ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? 83 F8 02 0F 84 BE 00 00 00 3B C6 0F 84 B6 00 00 00 3B C7 75 23 39 75 1C 75 0B 8B 45 08 8B 00 8B 40 04 89 45 1C 56 56 FF 75 10 FF 75 0C FF D3 8B C8 3B CE 89 4D F8 75 07 33 C0 E9 9A 00 00 00 7E 45 6A E0 33 D2 58 F7 F1 83 F8 02 72 39 8D 44 09 08 3D 00 04 00 00 77 16 E8 ?? ?? ?? ?? 8B FC 3B FE 74 D5 C7 07 CC CC 00 00 83 C7 08 EB 1A 50 E8 ?? ?? ?? ?? 3B C6 59 74 09 C7 00 DD DD 00 00 83 C0 08 8B F8 EB 02 33 FF 3B FE 74 AC FF 75 F8 57 FF 75 10 FF 75 0C FF D3 85 C0 74 20 39 75 18 56 56 75 04 56 56 EB 06 FF 75 18 FF 75 14 6A FF 57 56 FF 75 1C FF 15 ?? ?? ?? ?? 8B F0 57 E8 ?? ?? ?? ?? 59 8B C6 EB 12 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 15 ?? ?? ?? ?? 8D 65 EC 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_145_6_0 {
	meta:
		name = "___crtGetLocaleInfoA"
		size = 59
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ?__crtGetLocaleInfoA_stat@@YAHPAUlocaleinfo_struct@@KKPADHH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 1C 8D 45 F0 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 18 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_494_6_0 {
	meta:
		name = "___crtGetLocaleInfoW"
		size = 59
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 ?__crtGetLocaleInfoW_stat@@YAHPAUlocaleinfo_struct@@KKPA_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 1C 8D 45 F0 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 50 E8 ?? ?? ?? ?? 83 C4 18 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_146_3_0 {
	meta:
		name = "__mbsdec_l"
		size = 151
		refs = "000f __errno 001f __invalid_parameter 005c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 33 DB 39 5D 08 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 6A 56 8B 75 0C 3B F3 75 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 05 39 75 08 72 04 33 C0 EB 3E FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 39 59 08 8D 46 FF 74 1C 48 39 45 08 77 0A 0F B6 10 F6 44 0A 1D 04 75 F0 8B CE 2B C8 83 E1 01 2B F1 4E 8B C6 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_147_0_0 {
	meta:
		name = "_xtoa_s@20"
		size = 219
		refs = "000f __errno 001e __invalid_parameter"
	strings:
		$1 = { 55 8B EC 51 53 56 8B F1 33 DB 3B F3 75 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 A9 00 00 00 39 5D 08 57 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 84 00 00 00 33 C9 39 5D 10 88 1E 0F 95 C1 41 39 4D 08 77 09 E8 ?? ?? ?? ?? 6A 22 EB D0 8B 4D 0C 83 C1 FE 83 F9 22 77 BE 39 5D 10 89 5D FC 8B CE 74 0F C6 06 2D 8D 4E 01 C7 45 FC 01 00 00 00 F7 D8 8B F9 33 D2 F7 75 0C 83 FA 09 76 05 80 C2 57 EB 03 80 C2 30 88 11 41 FF 45 FC 33 DB 3B C3 76 08 8B 55 08 39 55 FC 72 DA 8B 45 FC 3B 45 08 72 04 88 1E EB 9F 88 19 49 8A 17 8A 01 88 11 49 88 07 47 3B F9 72 F2 33 C0 5F 5E 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_147_1_0 {
	meta:
		name = "__itoa_s"
		size = 40
		refs = "0022 _xtoa_s@20"
	strings:
		$1 = { 55 8B EC 83 7D 14 0A 8B 45 08 75 0A 85 C0 7D 06 6A 01 6A 0A EB 05 6A 00 FF 75 14 FF 75 10 8B 4D 0C E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_147_2_0 {
	meta:
		name = "__ltoa_s"
		size = 37
		refs = "001f _xtoa_s@20"
	strings:
		$1 = { 55 8B EC 33 C0 83 7D 14 0A 75 06 39 45 08 7D 01 40 8B 4D 0C 50 FF 75 14 8B 45 08 FF 75 10 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_147_3_0 {
	meta:
		name = "__ultoa_s"
		size = 24
		refs = "0013 _xtoa_s@20"
	strings:
		$1 = { 8B 4C 24 08 8B 44 24 04 6A 00 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_147_4_0 {
	meta:
		name = "@x64toa_s@24"
		size = 246
		refs = "000f __errno 001e __invalid_parameter 0087 __aulldvrm"
	strings:
		$1 = { 55 8B EC 83 EC 0C 53 33 DB 3B FB 56 75 1E E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 C4 00 00 00 39 5D 10 76 DD 33 C0 39 5D 18 88 1F 0F 95 C0 40 39 45 10 77 09 E8 ?? ?? ?? ?? 6A 22 EB CB 8B 45 14 83 C0 FE 83 F8 22 77 B9 39 5D 18 8B 55 08 8B 45 0C 89 5D FC 8B F7 74 13 F7 DA 13 C3 C6 07 2D 8D 77 01 C7 45 FC 01 00 00 00 F7 D8 89 75 18 89 5D 0C FF 75 0C FF 75 14 50 52 E8 ?? ?? ?? ?? 83 F9 09 89 5D F8 8B DA 8B D0 8B C3 76 05 80 C1 57 EB 03 80 C1 30 88 0E 8B 4D FC 46 41 85 C0 89 4D FC 77 04 85 D2 76 08 3B 4D 10 72 C6 8B 4D FC 3B 4D 10 72 16 C6 07 00 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 33 DB E9 42 FF FF FF C6 06 00 4E 8B 45 18 8A 10 8A 0E 88 16 4E 88 08 40 3B C6 89 45 18 72 EC 33 C0 5E 5B C9 C2 14 00 }
	condition:
		$1
}

rule file_147_5_0 {
	meta:
		name = "__i64toa_s"
		size = 51
		refs = "002c @x64toa_s@24"
	strings:
		$1 = { 55 8B EC 33 C0 83 7D 18 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 57 8B 7D 10 50 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5F 5D C3 }
	condition:
		$1
}

rule file_502_5_0 {
	meta:
		name = "__i64tow_s"
		size = 51
		refs = "002c @x64tow_s@24"
	strings:
		$1 = { 55 8B EC 33 C0 83 7D 18 0A 75 0F 39 45 0C 7F 0A 7C 05 39 45 08 73 03 33 C0 40 57 8B 7D 10 50 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5F 5D C3 }
	condition:
		$1
}

rule file_147_6_0 {
	meta:
		name = "__ui64toa_s"
		size = 29
		refs = "0016 @x64toa_s@24"
	strings:
		$1 = { 55 8B EC 57 8B 7D 10 6A 00 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5F 5D C3 }
	condition:
		$1
}

rule file_502_6_0 {
	meta:
		name = "__ui64tow_s"
		size = 29
		refs = "0016 @x64tow_s@24"
	strings:
		$1 = { 55 8B EC 57 8B 7D 10 6A 00 FF 75 18 FF 75 14 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 5F 5D C3 }
	condition:
		$1
}

rule file_148_0_0 {
	meta:
		name = "__get_daylight"
		size = 52
		refs = "000c __errno 001c __invalid_parameter 002a __daylight"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E C3 }
	condition:
		$1
}

rule file_148_1_0 {
	meta:
		name = "__get_dstbias"
		size = 52
		refs = "000c __errno 001c __invalid_parameter 002a __dstbias"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E C3 }
	condition:
		$1
}

rule file_222_2_0 {
	meta:
		name = "__get_fmode"
		size = 52
		refs = "000c __errno 001c __invalid_parameter 002a __fmode"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E C3 }
	condition:
		$1
}

rule file_148_2_0 {
	meta:
		name = "__get_timezone"
		size = 52
		refs = "000c __errno 001c __invalid_parameter 002a __timezone"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E C3 }
	condition:
		$1
}

rule file_148_3_0 {
	meta:
		name = "__get_tzname"
		size = 162
		refs = "002e __errno 003d __invalid_parameter 006b __tzname 0072 _strlen 0096 _strcpy_s"
	strings:
		$1 = { 55 8B EC 8B 45 0C 53 33 DB 3B C3 56 74 3A 39 5D 10 76 3A 3B C3 74 02 88 18 57 8B 7D 08 3B FB 74 0C 8B 45 14 3B C3 74 40 83 F8 01 74 3B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 55 39 5D 10 74 C6 E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 36 8D 34 85 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? 40 39 5D 0C 59 89 07 75 04 33 C0 EB 1A 3B 45 10 76 05 6A 22 58 EB 10 FF 36 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_149_1_0 {
	meta:
		name = "_wcomexecmd"
		size = 120
		refs = "000e __errno 001e __invalid_parameter 0041 __wcenvarg 005a __wdospawn 0064 _free"
	strings:
		$1 = { 55 8B EC 51 51 56 33 F6 39 75 0C 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4B 39 75 10 74 DE FF 75 0C 8D 45 F8 50 8D 45 FC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D8 FF 75 F8 FF 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_783_1_0 {
	meta:
		name = "_comexecmd"
		size = 120
		refs = "000e __errno 001e __invalid_parameter 0041 __cenvarg 005a __dospawn 0064 _free"
	strings:
		$1 = { 55 8B EC 51 51 56 33 F6 39 75 0C 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4B 39 75 10 74 DE FF 75 0C 8D 45 F8 50 8D 45 FC 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 83 C4 14 83 F8 FF 74 D8 FF 75 F8 FF 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? FF 75 FC 8B F0 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 83 C4 18 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_149_2_0 {
	meta:
		name = "__wspawnve"
		size = 542
		refs = "0015 __errno 0025 __invalid_parameter 0050 _wcsrchr 0075 _wcschr 0083 _wcslen 0090 __calloc_crt 00a5 ??_C@_15PCEAIKAA@?$AA?4?$AA?2?$AA?$AA@ 00ac _wcscpy_s 00bd __invoke_watson 00ca _wcscat_s 010b __waccess_s 0126 _wcomexecmd 01a0 _ext_strings 0200 _free"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 8B 5D 0C 57 33 FF 3B DF 89 5D FC 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E6 01 00 00 66 39 3B 74 DB 8B 45 10 3B C7 74 D4 8B 00 3B C7 74 CE 66 39 38 74 C9 56 6A 5C 53 E8 ?? ?? ?? ?? 6A 2F 53 8B F0 E8 ?? ?? ?? ?? 83 C4 10 3B C7 0F 85 81 00 00 00 3B F7 0F 85 83 00 00 00 6A 3A 53 E8 ?? ?? ?? ?? 8B F0 3B F7 59 59 75 73 53 E8 ?? ?? ?? ?? 8B F0 83 C6 03 6A 02 56 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 3B DF 89 5D FC 0F 84 AF 00 00 00 68 ?? ?? ?? ?? 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 75 0C 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8D 73 04 8B 5D 0C EB 0A 3B F7 74 04 3B C6 76 02 8B F0 83 4D F4 FF 6A 2E 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 2F 57 FF 75 FC E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 EF 00 00 00 FF 75 14 FF 75 10 FF 75 FC FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 E9 D3 00 00 00 FF 75 FC E8 ?? ?? ?? ?? 8B F0 83 C6 05 6A 02 56 E8 ?? ?? ?? ?? 8B D8 83 C4 0C 3B DF 75 08 83 C8 FF E9 BE 00 00 00 FF 75 FC 56 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 FF 75 FC E8 ?? ?? ?? ?? 8D 04 43 59 89 45 F0 E8 ?? ?? ?? ?? 8B 00 89 45 EC 8B 45 F0 2B C3 89 75 F8 D1 F8 29 45 F8 BE ?? ?? ?? ?? FF 36 FF 75 F8 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 57 53 E8 ?? ?? ?? ?? 85 C0 59 59 74 0D 83 EE 04 81 FE ?? ?? ?? ?? 7D C7 EB 1F E8 ?? ?? ?? ?? FF 75 14 8B 4D EC FF 75 10 89 08 53 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 45 F4 53 E8 ?? ?? ?? ?? 8B 5D 0C 59 39 5D FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "__isctype_l"
		size = 182
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0043 __isleadbyte_l 0084 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 FF 75 10 8D 4D E8 E8 ?? ?? ?? ?? 8B 5D 08 8D 43 01 3D 00 01 00 00 77 0F 8B 45 E8 8B 80 C8 00 00 00 0F B7 04 58 EB 75 89 5D 08 C1 7D 08 08 8D 45 E8 50 8B 45 08 25 FF 00 00 00 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 12 8A 45 08 6A 02 88 45 F8 88 5D F9 C6 45 FA 00 59 EB 0A 33 C9 88 5D F8 C6 45 F9 00 41 8B 45 E8 6A 01 FF 70 14 FF 70 04 8D 45 FC 50 51 8D 45 F8 50 8D 45 E8 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 75 10 38 45 F4 74 07 8B 45 F0 83 60 70 FD 33 C0 EB 14 0F B7 45 FC 23 45 0C 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_150_4_0 {
	meta:
		name = "__isctype"
		size = 47
		refs = "0002 ___locale_changed 000f ___initiallocinfo 0027 __isctype_l"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 75 13 8B 44 24 04 8B 0D ?? ?? ?? ?? 0F B7 04 41 23 44 24 08 C3 6A 00 FF 74 24 0C FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_152_1_0 {
	meta:
		name = "__wgetenv_helper_nolock"
		size = 149
		refs = "0002 ___env_initialized 000a __wenviron 001c __environ 0023 ___crtGetEnvironmentStringsW 0028 __wenvptr 002d __wsetenvp 0036 ___mbtow_environ 0052 _wcslen 0073 __wcsnicoll"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 56 8B 35 ?? ?? ?? ?? 75 04 33 C0 5E C3 85 F6 53 57 75 2E 39 35 ?? ?? ?? ?? 74 65 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 09 E8 ?? ?? ?? ?? 85 C0 75 49 8B 35 ?? ?? ?? ?? 85 F6 74 3F 8B 5C 24 10 85 DB 74 37 53 E8 ?? ?? ?? ?? 59 8B F8 EB 26 50 E8 ?? ?? ?? ?? 3B C7 59 76 18 8B 06 66 83 3C 78 3D 75 0F 57 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 83 C6 04 8B 06 85 C0 75 D4 33 C0 5F 5B 5E C3 8B 06 8D 44 78 02 EB F4 }
	condition:
		$1
}

rule file_152_2_0 {
	meta:
		name = "__wgetenv_s_helper"
		size = 148
		refs = "000e __errno 001d __invalid_parameter 0049 __wgetenv_helper_nolock 0056 _wcslen 0075 _wcscpy_s 0086 __invoke_watson"
	strings:
		$1 = { 55 8B EC 56 57 8B F8 33 F6 3B FE 75 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 68 8B 45 08 3B C6 89 37 74 07 39 75 0C 77 07 EB D5 39 75 0C 75 D0 3B C6 74 03 66 89 30 53 FF 75 10 E8 ?? ?? ?? ?? 8B D8 3B DE 59 74 39 53 E8 ?? ?? ?? ?? 40 39 75 0C 59 89 07 74 2A 3B 45 0C 76 05 6A 22 58 EB 22 53 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_152_3_0 {
	meta:
		name = "__wdupenv_s_helper"
		size = 162
		refs = "000d __errno 001c __invalid_parameter 003b __wgetenv_helper_nolock 0049 _wcslen 0054 _calloc 007b _wcscpy_s 008c __invoke_watson"
	strings:
		$1 = { 55 8B EC 51 56 57 33 FF 3B DF 75 1B E8 ?? ?? ?? ?? 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 77 8B 45 08 3B C7 89 3B 74 02 89 38 39 7D 0C 74 D5 FF 75 0C E8 ?? ?? ?? ?? 3B C7 59 89 45 FC 74 55 50 E8 ?? ?? ?? ?? 8B F0 46 6A 02 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 89 03 75 14 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 EB 29 FF 75 FC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 3B C7 74 02 89 30 33 C0 5F 5E C9 C3 }
	condition:
		$1
}

rule file_152_5_0 {
	meta:
		name = "__wgetenv_s"
		size = 217
		refs = "0003 __sehtable$__wgetenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0037 __invalid_parameter 0070 __wgetenv_helper_nolock 007d _wcslen 00a0 _wcscpy_s 00b1 __invoke_watson 00cb __SEH_epilog4 00d3 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC 33 C0 8B 5D 08 3B DE 0F 95 C0 3B C6 75 1C E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 89 7D E4 EB 78 89 33 8B 4D 0C 3B CE 74 09 39 75 10 77 09 3B CE 75 0A 39 75 10 75 05 33 C0 40 EB 02 33 C0 3B C6 74 C2 3B CE 74 03 66 89 31 FF 75 14 E8 ?? ?? ?? ?? 59 8B F8 3B FE 74 3D 57 E8 ?? ?? ?? ?? 59 40 89 03 39 75 10 74 2E 3B 45 10 76 09 C7 45 E4 22 00 00 00 EB 23 57 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_152_6_0 {
	meta:
		name = "__wdupenv_s"
		size = 230
		refs = "0003 __sehtable$__wdupenv_s 0008 __SEH_prolog4 000f __lock 0028 __errno 0037 __invalid_parameter 0061 __wgetenv_helper_nolock 006f _wcslen 007a _calloc 00a4 _wcscpy_s 00b5 __invoke_watson 00d8 __SEH_epilog4 00e0 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 33 F6 89 75 FC 33 C0 8B 5D 08 3B DE 0F 95 C0 3B C6 75 1F E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 89 7D E4 E9 82 00 00 00 89 33 8B 45 0C 3B C6 74 02 89 30 33 C0 39 75 10 0F 95 C0 3B C6 74 CA FF 75 10 E8 ?? ?? ?? ?? 59 89 45 E0 3B C6 74 58 50 E8 ?? ?? ?? ?? 8B F8 47 6A 02 57 E8 ?? ?? ?? ?? 83 C4 0C 89 03 3B C6 75 17 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 E4 EB 2A FF 75 E0 57 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B 45 0C 3B C6 74 02 89 38 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_153_3_0 {
	meta:
		name = "__wcscoll_l"
		size = 164
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001a __errno 002a __invalid_parameter 005a _wcscmp 007a ___crtCompareStringW"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 5D 39 5D 0C 74 D0 8B 45 F0 8B 48 10 3B CB 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 33 FF 70 08 8D 45 F0 6A FF FF 75 0C 6A FF FF 75 08 68 00 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_861_3_0 {
	meta:
		name = "__strcoll_l"
		size = 164
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001a __errno 002a __invalid_parameter 005a _strcmp 007a ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 5D 39 5D 0C 74 D0 8B 45 F0 8B 48 10 3B CB 75 0F FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 33 FF 70 08 8D 45 F0 6A FF FF 75 0C 6A FF FF 75 08 68 00 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 9F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_153_4_0 {
	meta:
		name = "_wcscoll"
		size = 80
		refs = "0008 ___locale_changed 0014 __errno 0024 __invalid_parameter 003a _wcscmp 0046 __wcscoll_l"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 30 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 1B 39 75 0C 74 DC 5E 5D E9 ?? ?? ?? ?? 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5E 5D C3 }
	condition:
		$1
}

rule file_242_5_0 {
	meta:
		name = "__stricmp"
		size = 80
		refs = "0008 ___locale_changed 0014 __errno 0024 __invalid_parameter 003a ___ascii_stricmp 0046 __stricmp_l"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 30 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 1B 39 75 0C 74 DC 5E 5D E9 ?? ?? ?? ?? 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 5E 5D C3 }
	condition:
		$1
}

rule file_155_0_0 {
	meta:
		name = "_vfprintf_helper"
		size = 334
		refs = "0003 __sehtable$_vfprintf_helper 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 0050 __lock_file 0064 __fileno 0086 ___pioinfo 009d ___badioinfo 010f __stbuf 0128 __ftbuf 013f __SEH_epilog4 0148 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C0 8B 75 0C 3B F3 0F 95 C0 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 FF 00 00 00 33 C0 39 5D 10 0F 95 C0 3B C3 74 D4 89 75 0C 56 E8 ?? ?? ?? ?? 59 89 5D FC F6 46 0C 40 0F 85 A6 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 8D 3C 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 07 EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 75 45 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 8D 3C 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 07 EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 4D E4 FF 39 5D E4 75 22 56 E8 ?? ?? ?? ?? 8B F8 FF 75 18 FF 75 14 FF 75 10 56 FF 55 08 89 45 E4 56 57 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_155_1_0 {
	meta:
		name = "__vfprintf_l"
		size = 30
		refs = "0011 __output_l 0016 _vfprintf_helper"
	strings:
		$1 = { FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_155_3_0 {
	meta:
		name = "__vfprintf_p_l"
		size = 30
		refs = "0011 __output_p_l 0016 _vfprintf_helper"
	strings:
		$1 = { FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_155_2_0 {
	meta:
		name = "__vfprintf_s_l"
		size = 30
		refs = "0011 __output_s_l 0016 _vfprintf_helper"
	strings:
		$1 = { FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_239_1_0 {
	meta:
		name = "__vfwprintf_l"
		size = 30
		refs = "0011 __woutput_l 0016 _vfwprintf_helper"
	strings:
		$1 = { FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_239_3_0 {
	meta:
		name = "__vfwprintf_p_l"
		size = 30
		refs = "0011 __woutput_p_l 0016 _vfwprintf_helper"
	strings:
		$1 = { FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_239_2_0 {
	meta:
		name = "__vfwprintf_s_l"
		size = 30
		refs = "0011 __woutput_s_l 0016 _vfwprintf_helper"
	strings:
		$1 = { FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_155_4_0 {
	meta:
		name = "_vfprintf"
		size = 28
		refs = "000f __output_l 0014 _vfprintf_helper"
	strings:
		$1 = { FF 74 24 0C 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_155_6_0 {
	meta:
		name = "__vfprintf_p"
		size = 28
		refs = "000f __output_p_l 0014 _vfprintf_helper"
	strings:
		$1 = { FF 74 24 0C 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_239_6_0 {
	meta:
		name = "__vfwprintf_p"
		size = 28
		refs = "000f __woutput_p_l 0014 _vfwprintf_helper"
	strings:
		$1 = { FF 74 24 0C 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_155_5_0 {
	meta:
		name = "_vfprintf_s"
		size = 28
		refs = "000f __output_s_l 0014 _vfprintf_helper"
	strings:
		$1 = { FF 74 24 0C 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_239_4_0 {
	meta:
		name = "_vfwprintf"
		size = 28
		refs = "000f __woutput_l 0014 _vfwprintf_helper"
	strings:
		$1 = { FF 74 24 0C 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_239_5_0 {
	meta:
		name = "_vfwprintf_s"
		size = 28
		refs = "000f __woutput_s_l 0014 _vfwprintf_helper"
	strings:
		$1 = { FF 74 24 0C 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_156_0_0 {
	meta:
		name = "___mbtow_environ"
		size = 133
		refs = "0009 __environ 001b __imp__MultiByteToWideChar@24 0033 __calloc_crt 0056 ___crtwsetenv 007e _free"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B 35 ?? ?? ?? ?? 33 DB 89 5D FC 8B 06 3B C3 57 74 50 8B 3D ?? ?? ?? ?? 53 53 6A FF 50 53 53 FF D7 3B C3 89 45 F8 74 41 6A 02 50 E8 ?? ?? ?? ?? 3B C3 59 59 89 45 FC 74 30 FF 75 F8 50 6A FF FF 36 53 53 FF D7 85 C0 74 2A 8D 45 FC 53 50 E8 ?? ?? ?? ?? 85 C0 59 59 7C 15 83 C6 04 8B 06 3B C3 75 B6 33 C0 5F 5E 5B C9 C3 83 C8 FF EB F6 39 5D FC 74 F6 FF 75 FC E8 ?? ?? ?? ?? 59 EB EB }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "__wspawnlp"
		size = 78
		refs = "000c __errno 001c __invalid_parameter 0045 __wspawnvp"
	strings:
		$1 = { 8B 4C 24 08 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E C3 66 39 31 74 DE 8B 44 24 10 3B C6 74 D6 66 39 30 74 D1 8D 44 24 10 50 51 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 0C 5E C3 }
	condition:
		$1
}

rule file_161_0_0 {
	meta:
		name = "__memccpy"
		size = 91
	strings:
		$1 = { 8B 4C 24 10 53 85 C9 74 46 8A 7C 24 10 56 F7 C1 01 00 00 00 8B 44 24 0C 8B 74 24 10 74 13 8A 1E 83 C6 01 88 18 83 C0 01 3A DF 74 2C 83 E9 01 74 1D 8A 1E 83 C6 02 3A DF 74 19 88 18 8A 5E FF 88 58 01 83 C0 02 3A DF 74 0F 83 E9 02 75 E3 5E 33 C0 5B C3 88 18 83 C0 01 5E 5B C3 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "__fstat64i32"
		size = 849
		refs = "0003 __sehtable$__fstat64i32 0008 __SEH_prolog4 0020 ___doserrno 0027 __errno 0037 __invalid_parameter 004b _memset 0074 __nhandle 0096 ___pioinfo 00b3 ___lock_fhandle 00e7 __SEH_epilog4 00f0 __imp__GetFileType@4 0112 __imp__GetLastError@0 0118 __dosmaperr 0180 __imp__PeekNamedPipe@24 01b7 __imp__GetFileInformationByHandle@8 01f7 __imp__FileTimeToLocalFileTime@8 020d __imp__FileTimeToSystemTime@8 023a ___loctotime64_t 034b __unlock_fhandle"
	strings:
		$1 = { 6A 5C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 0C 3B F7 0F 95 C0 3B C7 75 27 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A0 00 00 00 6A 30 57 56 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 F9 FE 75 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB D0 3B CF 7C 08 3B 0D ?? ?? ?? ?? 72 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB A3 8B C1 C1 F8 05 8D 04 85 ?? ?? ?? ?? 89 45 0C 8B D9 83 E3 1F 6B DB 28 8B 00 0F B6 44 18 04 83 E0 01 74 C9 51 E8 ?? ?? ?? ?? 59 89 7D FC 8B 45 0C 8B 00 03 C3 F6 40 04 01 75 24 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 64 02 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 30 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 91 00 00 00 83 F8 02 74 18 83 F8 03 74 13 3B C7 74 B8 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B4 33 D2 83 F8 02 0F 95 C2 4A B9 00 10 00 00 23 D1 03 D1 66 89 56 06 8B 4D 08 89 0E 89 4E 10 66 C7 46 08 01 00 66 89 7E 04 66 89 7E 0C 66 89 7E 0A 89 7E 28 89 7E 2C 89 7E 20 89 7E 24 89 7E 18 89 7E 1C 83 F8 02 75 08 89 7E 14 E9 69 FF FF FF 57 8D 45 0C 50 57 57 57 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? F7 D8 1B C0 23 45 0C 89 46 14 E9 44 FF FF FF 66 89 7E 06 66 89 7E 0C 66 89 7E 0A 66 89 7E 04 66 C7 46 08 01 00 8D 45 94 50 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 85 C0 0F 84 4D FF FF FF 66 8B 46 06 F6 45 94 01 74 06 66 0D 24 01 EB 04 66 0D B6 01 66 89 46 06 39 7D A8 75 0D 39 7D AC 75 08 89 7E 20 89 7E 24 EB 5A 8D 45 D8 50 8D 45 A8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D0 FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BA FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 89 56 24 39 7D A0 75 13 39 7D A4 75 0E 8B 46 20 89 46 18 8B 46 24 89 46 1C EB 5A 8D 45 D8 50 8D 45 A0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 5E FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 48 FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 18 89 56 1C 39 7D 98 75 13 39 7D 9C 75 0E 8B 46 20 89 46 28 8B 46 24 89 46 2C EB 5A 8D 45 D8 50 8D 45 98 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 EC FD FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D6 FD FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 28 89 56 2C 8B 45 B8 89 46 14 66 8B 46 06 66 0D 00 80 66 89 46 06 89 3E 89 7E 10 E9 90 FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_163_3_0 {
	meta:
		name = "__strtod_l"
		size = 283
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0027 __errno 0039 __invalid_parameter 006a __isctype_l 0094 _strlen 00a0 __fltin2 00d2 __HUGE"
	strings:
		$1 = { 55 8B EC 83 EC 30 53 8B 5D 08 56 57 FF 75 10 8D 4D E8 8B F3 E8 ?? ?? ?? ?? 8B 7D 0C 85 FF 74 02 89 1F 85 DB 75 2D E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD D9 EE E9 C3 00 00 00 8B 45 E8 83 B8 AC 00 00 00 01 7E 14 8D 45 E8 50 0F B6 06 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C EB 10 0F B6 0E 8B 80 C8 00 00 00 0F B6 04 48 83 E0 08 85 C0 74 03 46 EB C9 8D 45 E8 50 6A 00 6A 00 56 E8 ?? ?? ?? ?? 59 50 8D 45 D0 56 50 E8 ?? ?? ?? ?? 83 C4 18 85 FF 8B C8 74 07 8B 41 04 03 C6 89 07 8B 01 66 A9 40 02 74 0D 85 FF D9 EE DD 5D F8 74 41 89 1F EB 3D A8 81 74 0F 80 3E 2D DD 05 ?? ?? ?? ?? 75 16 D9 E0 EB 12 66 A9 00 01 74 1E D9 EE DC 51 10 DF E0 F6 C4 44 7A 10 DD 5D F8 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 08 DD D8 DD 41 10 DD 5D F8 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD DD 45 F8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_164_0_0 {
	meta:
		name = "__trandisp1"
		size = 103
		refs = "0029 XAMtoTagTab"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 9B 8A 8D 61 FF FF FF D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 }
	condition:
		$1
}

rule file_164_1_0 {
	meta:
		name = "__trandisp2"
		size = 355
		refs = "0029 XAMtoTagTab 00d1 One 0145 __indefinite"
	strings:
		$1 = { 80 7A 0E 05 75 11 66 8B 9D 5C FF FF FF 80 CF 02 80 E7 FE B3 3F EB 04 66 BB 3F 13 66 89 9D 5E FF FF FF D9 AD 5E FF FF FF BB ?? ?? ?? ?? D9 E5 89 95 6C FF FF FF 9B DD BD 60 FF FF FF C6 85 70 FF FF FF 00 D9 C9 8A 8D 61 FF FF FF D9 E5 9B DD BD 60 FF FF FF D9 C9 8A AD 61 FF FF FF D0 E5 D0 FD D0 C5 8A C5 24 0F D7 8A E0 D0 E1 D0 F9 D0 C1 8A C1 24 0F D7 D0 E4 D0 E4 0A C4 0F BE C0 81 E1 04 04 00 00 8B DA 03 D8 83 C3 10 FF 23 E8 C1 00 00 00 D9 C9 DD D8 C3 E8 B7 00 00 00 EB F6 DD D8 DD D8 D9 EE C3 DD D8 DD D8 D9 E8 C3 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 08 C6 85 70 FF FF FF 07 C3 C6 85 70 FF FF FF 01 DC 05 ?? ?? ?? ?? C3 D9 C9 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 07 EB 07 C6 85 70 FF FF FF 01 DE C1 C3 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 20 D9 C9 DB BD 62 FF FF FF DB AD 62 FF FF FF F6 85 69 FF FF FF 40 74 09 C6 85 70 FF FF FF 07 EB 07 C6 85 70 FF FF FF 01 DE C1 C3 DD D8 DD D8 DB 2D ?? ?? ?? ?? 80 BD 70 FF FF FF 00 7F 07 C6 85 70 FF FF FF 01 0A C9 C3 0A C9 74 02 D9 E0 C3 }
	condition:
		$1
}

rule file_165_6_0 {
	meta:
		name = "__Getdays_l"
		size = 254
		refs = "0012 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002d _strlen 0055 __malloc_crt 0081 _strcpy_s 0094 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 FF 75 08 8D 4D E8 33 DB E8 ?? ?? ?? ?? 8B 45 E8 8B B8 D4 00 00 00 89 5D FC 8B 75 FC C1 E6 02 FF 74 3E 1C E8 ?? ?? ?? ?? FF 34 3E 89 45 F8 E8 ?? ?? ?? ?? 03 C3 FF 45 FC 83 7D FC 07 59 59 8B 4D F8 8D 5C 08 02 72 D2 8D 43 01 50 E8 ?? ?? ?? ?? 8B F0 85 F6 59 89 75 F8 0F 84 82 00 00 00 83 65 FC 00 8B 45 FC C6 06 3A FF 34 87 8B 45 F8 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 03 F0 8B 45 FC C6 06 3A FF 74 87 1C 8B 45 F8 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 03 F0 FF 45 FC 83 7D FC 07 59 72 85 C6 06 00 80 7D F4 00 5F 5E 5B 74 07 8B 45 F0 83 60 70 FD 8B 45 F8 C9 C3 }
	condition:
		$1
}

rule file_165_8_0 {
	meta:
		name = "__Getmonths_l"
		size = 254
		refs = "0012 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0030 _strlen 005c __malloc_crt 0087 _strcpy_s 009a __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 FF 75 08 8D 4D E4 33 DB E8 ?? ?? ?? ?? 8B 45 E4 8B B8 D4 00 00 00 8D 77 38 89 75 FC C7 45 F8 0C 00 00 00 FF 76 30 E8 ?? ?? ?? ?? FF 36 89 45 F4 E8 ?? ?? ?? ?? 8B 75 FC 59 59 8B 4D F4 03 C3 83 C6 04 FF 4D F8 8D 5C 08 02 89 75 FC 75 D5 8D 43 01 50 E8 ?? ?? ?? ?? 8B F0 85 F6 59 89 75 FC 74 7F 83 C7 68 C7 45 F8 0C 00 00 00 8B 45 FC C6 06 3A FF 77 D0 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 03 F0 8B 45 FC C6 06 3A FF 37 46 2B C6 8D 44 18 01 50 56 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 03 F0 83 C7 04 FF 4D F8 59 75 8E C6 06 00 80 7D F0 00 5F 5E 5B 74 07 8B 45 EC 83 60 70 FD 8B 45 FC C9 C3 }
	condition:
		$1
}

rule file_165_10_0 {
	meta:
		name = "__Gettnames_l"
		size = 853
		refs = "0012 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002d _strlen 00d9 __malloc_crt 00f8 _memcpy 0125 _strcpy_s 0138 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 24 53 56 57 FF 75 08 8D 4D DC 33 FF E8 ?? ?? ?? ?? 8B 45 DC 8B B0 D4 00 00 00 89 7D FC 8B 5D FC C1 E3 02 FF 74 33 1C E8 ?? ?? ?? ?? FF 34 33 89 45 EC E8 ?? ?? ?? ?? 03 C7 FF 45 FC 83 7D FC 07 59 59 8B 4D EC 8D 7C 08 02 72 D2 8D 46 38 89 45 F0 C7 45 F4 0C 00 00 00 8B 5D F0 FF 73 30 E8 ?? ?? ?? ?? FF 33 89 45 EC E8 ?? ?? ?? ?? 83 45 F0 04 59 59 8B 4D EC 03 C7 FF 4D F4 8D 7C 08 02 75 D7 FF B6 9C 00 00 00 E8 ?? ?? ?? ?? FF B6 98 00 00 00 8B D8 E8 ?? ?? ?? ?? FF B6 A0 00 00 00 03 C7 8D 7C 18 02 E8 ?? ?? ?? ?? FF B6 A4 00 00 00 8D 7C 07 01 E8 ?? ?? ?? ?? FF B6 A8 00 00 00 8D 7C 07 01 E8 ?? ?? ?? ?? 8D 84 07 B9 00 00 00 50 89 45 F8 E8 ?? ?? ?? ?? 8B D8 83 C4 18 85 DB 0F 84 57 02 00 00 68 B8 00 00 00 56 53 8D BB B8 00 00 00 E8 ?? ?? ?? ?? 83 65 FC 00 8D 46 1C 89 5D F0 83 C4 0C 29 75 F0 89 45 F4 8B 45 FC 89 3C 83 8B 45 F4 FF 70 E4 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8B 4D F0 8D 7C 07 01 8B 45 F4 89 3C 01 FF 30 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? FF 45 FC 83 45 F4 04 83 7D FC 07 59 8D 7C 07 01 0F 82 7B FF FF FF 8D 43 68 89 45 FC 8D 46 38 89 45 F4 C7 45 EC 0C 00 00 00 EB 03 8B 45 F4 8B 4D F0 89 3C 08 FF 30 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B 45 FC 89 38 8B 45 F4 FF 70 30 8B C3 2B C7 03 45 F8 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 83 45 F4 04 83 45 FC 04 FF 4D EC 59 8D 7C 07 01 75 80 8B C3 2B C7 03 45 F8 89 BB 98 00 00 00 FF B6 98 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B C3 2B C7 03 45 F8 89 BB 9C 00 00 00 FF B6 9C 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B C3 2B C7 03 45 F8 89 BB A0 00 00 00 FF B6 A0 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 7C 07 01 8B C3 2B C7 03 45 F8 89 BB A4 00 00 00 FF B6 A4 00 00 00 50 57 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 8D 44 07 01 8B CB 2B C8 03 4D F8 89 83 A8 00 00 00 FF B6 A8 00 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 80 7D E8 00 74 07 8B 45 E4 83 60 70 FD 5F 5E 8B C3 5B C9 C3 }
	condition:
		$1
}

rule file_165_12_0 {
	meta:
		name = "?_store_str@@YAXPADPAPADPAI@Z"
		size = 32
	strings:
		$1 = { 83 38 00 56 8B F2 74 16 57 8A 16 84 D2 74 0E 8B 39 88 17 FF 01 46 FF 08 83 38 00 75 EC 5F 5E C3 }
	condition:
		$1
}

rule file_165_13_0 {
	meta:
		name = "?_store_number@@YAXHPAPADPAI@Z"
		size = 54
	strings:
		$1 = { 83 3E 01 8B 0F 53 76 19 6A 0A 99 5B F7 FB 80 C2 30 88 11 41 FF 0E 85 C0 8B 16 7E 05 83 FA 01 77 E7 8B 07 89 0F 49 8A 18 8A 11 88 19 49 88 10 40 3B C1 72 F2 5B C3 }
	condition:
		$1
}

rule file_165_14_0 {
	meta:
		name = "?_store_num@@YAXHHPAPADPAII@Z"
		size = 121
	strings:
		$1 = { 55 8B EC 51 53 56 8B F2 33 D2 39 55 08 89 55 FC 74 35 83 39 01 8B 37 76 19 6A 0A 99 5B F7 FB 80 C2 30 88 16 46 FF 09 85 C0 8B 11 7E 05 83 FA 01 77 E7 8B 07 89 37 4E 8A 10 8A 0E 88 16 4E 88 08 40 3B C6 72 F2 EB 2E 3B 31 73 28 4E 8D 56 01 85 D2 74 17 6A 0A 99 5B F7 FB 8B 1F 80 C2 30 FF 45 FC 88 14 1E 4E 83 FE FF 75 E9 8B 45 FC 01 07 29 01 EB 02 89 11 5E 5B C9 C3 }
	condition:
		$1
}

rule file_165_15_0 {
	meta:
		name = "?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
		size = 987
		refs = "022d __errno 0246 ?_store_num@@YAXHHPAPADPAII@Z 0265 ?_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPADPAIPAU__lc_time_data@@@Z 02dc __invalid_parameter 0323 ___tzset 0328 ___tzname 03cf ?_store_str@@YAXPADPAPADPAI@Z"
	strings:
		$1 = { 55 8B EC 51 53 0F BE C0 83 F8 59 56 57 8B D9 8B F2 0F 8F AE 01 00 00 0F 84 85 01 00 00 83 F8 49 0F 8F CB 00 00 00 0F 84 98 00 00 00 83 E8 04 0F 84 9E 03 00 00 83 E8 09 0F 84 95 03 00 00 83 E8 18 74 70 83 E8 1C 74 49 48 74 24 83 E8 06 0F 85 8F 02 00 00 8B 46 08 33 FF 3B C7 0F 8C 6A 02 00 00 83 F8 17 0F 8F 61 02 00 00 E9 CB 01 00 00 8B 76 10 33 FF 3B F7 0F 8C 4F 02 00 00 83 FE 0B 0F 8F 46 02 00 00 8B 55 10 8B 54 B2 68 E9 3A 03 00 00 8B 76 18 33 FF 3B F7 0F 8C 2D 02 00 00 83 FE 06 0F 8F 24 02 00 00 8B 55 10 8B 54 B2 1C E9 18 03 00 00 8B 03 C6 00 25 8B 45 0C FF 03 FF 08 E9 0F 03 00 00 8B 46 08 33 FF 3B C7 0F 8C FA 01 00 00 83 F8 17 0F 8F F1 01 00 00 99 6A 0C 59 F7 F9 8B C2 3B C7 0F 85 50 01 00 00 51 58 E9 49 01 00 00 83 E8 4D 0F 84 A3 00 00 00 6A 06 59 2B C1 0F 84 84 00 00 00 48 48 74 34 48 48 74 12 48 0F 85 CF 01 00 00 FF 75 10 FF 75 0C E9 68 01 00 00 8B 46 18 33 FF 3B C7 0F 8C 9F 01 00 00 3B C1 0F 8F 97 01 00 00 3B C7 74 1C 8D 48 FF EB 17 8B 46 18 33 FF 3B C7 0F 8C 81 01 00 00 3B C1 0F 8F 79 01 00 00 8B C8 8B 46 1C 3B C7 0F 8C 6C 01 00 00 3D 6D 01 00 00 0F 8F 61 01 00 00 3B C1 7D 07 33 C0 E9 C5 00 00 00 6A 07 99 5E F7 FE 3B D1 0F 8C B7 00 00 00 40 E9 B1 00 00 00 8B 06 33 FF 3B C7 0F 8C 36 01 00 00 83 F8 3B E9 C7 FE FF FF 8B 46 04 EB E9 33 FF 39 7E 14 0F 8C 1E 01 00 00 8B 46 14 99 6A 64 59 F7 F9 FF 75 14 6A 04 83 C0 13 6B C0 64 03 C2 EB 7A 83 F8 6D 0F 8F 3D 01 00 00 0F 84 21 01 00 00 83 E8 5A 0F 84 45 01 00 00 83 E8 07 0F 84 D7 00 00 00 48 0F 84 B6 00 00 00 48 74 60 48 74 2C 83 E8 06 0F 85 E7 00 00 00 8B 76 1C 33 FF 3B F7 0F 8C C2 00 00 00 81 FE 6D 01 00 00 0F 8F B6 00 00 00 FF 75 14 8D 46 01 6A 03 EB 20 8B 76 0C 83 FE 01 7C 05 83 FE 1F 7E 0C E8 ?? ?? ?? ?? 33 FF E9 98 00 00 00 8B C6 FF 75 14 6A 02 5A 8B 4D 0C 8B FB E8 ?? ?? ?? ?? 59 E9 83 01 00 00 FF 75 10 33 FF 39 7D 14 FF 75 0C 53 56 74 41 6A 01 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 73 8B 45 0C 39 38 74 6C 8B 03 FF 75 10 C6 00 20 8B 45 0C FF 03 FF 08 50 53 56 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 85 C0 0F 85 35 01 00 00 EB 43 57 EB BE 8B 76 10 33 FF 3B F7 7C 1F 83 FE 0B 7F 1A 8B 55 10 8B 54 B2 38 E9 0E 01 00 00 8B 76 18 33 FF 3B F7 7C 05 83 FE 06 7E 1F E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 EC 00 00 00 8B 55 10 8B 14 B2 E9 D6 00 00 00 8B 76 10 33 FF 3B F7 7C CD 83 FE 0B 7F C8 8D 46 01 E9 2F FF FF FF 83 E8 70 0F 84 8B 00 00 00 83 E8 07 74 65 48 74 46 48 74 26 48 75 C1 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D0 33 C0 39 46 20 8B CB 0F 95 C0 8B D8 8B 14 9A 89 45 FC E9 86 00 00 00 8B 46 14 33 FF 3B C7 0F 8C 79 FF FF FF FF 75 14 99 6A 64 59 F7 F9 8B C2 E9 DB FE FF FF FF 75 10 33 FF 39 7D 14 FF 75 0C 53 56 74 07 6A 01 E9 13 FF FF FF 57 E9 0D FF FF FF 8B 46 18 33 FF 3B C7 0F 8C 40 FF FF FF 83 F8 06 0F 8F 37 FF FF FF FF 75 14 33 D2 42 E9 A1 FE FF FF 8B 76 08 33 FF 3B F7 0F 8C 1F FF FF FF 83 FE 17 0F 8F 16 FF FF FF 83 FE 0B 8B 55 10 7F 08 8B 92 98 00 00 00 EB 06 8B 92 9C 00 00 00 8B 45 0C E8 ?? ?? ?? ?? 33 C0 40 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_165_16_0 {
	meta:
		name = "?_store_winword@@YAHPAUlocaleinfo_struct@@HPBUtm@@PAPADPAIPAU__lc_time_data@@@Z"
		size = 1309
		refs = "0007 ___security_cookie 004d __imp__GetDateFormatA@24 0054 __imp__GetTimeFormatA@24 0061 __errno 0071 __invalid_parameter 00bc __days 0173 __alloca_probe_16 0187 _malloc 01de __freea 0251 __isleadbyte_l 029c @__security_check_cookie@4 02e8 ??_C@_05JAMEPDIN@am?1pm?$AA@ 02ee ___ascii_stricmp 02fe ??_C@_03EBAPMIKO@a?1p?$AA@ 0506 ?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 53 8B 5D 1C 56 33 F6 2B C6 57 74 13 48 74 08 8B BB A8 00 00 00 EB 0E 8B BB A4 00 00 00 EB 06 8B BB A0 00 00 00 83 BB B0 00 00 00 01 8B 4D 10 0F 84 A0 01 00 00 83 7D 0C 02 A1 ?? ?? ?? ?? 75 05 A1 ?? ?? ?? ?? 39 71 14 89 45 F0 7D 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 11 02 00 00 8B 41 10 3B C6 7C DA 83 F8 0B 7F D5 8B 41 08 3B C6 7C CE 83 F8 17 7F C9 8B 41 04 3B C6 7C C2 83 F8 3B 7F BD 8B 01 3B C6 7C B7 83 F8 3B 7F B2 83 79 0C 01 7C AC 8B 51 10 C1 E2 02 8B 82 ?? ?? ?? ?? 2B 82 ?? ?? ?? ?? 3B 41 0C 7D 48 8B 41 14 8B D0 81 E2 03 00 00 80 79 05 4A 83 CA FC 42 75 0A 6A 64 99 5B F7 FB 85 D2 75 13 8B 41 14 99 BB 90 01 00 00 F7 FB 85 D2 0F 85 64 FF FF FF 83 79 10 02 0F 85 5A FF FF FF 83 79 0C 1D 0F 8F 50 FF FF FF 8B 5D 1C 66 8B 41 14 66 05 6C 07 66 89 45 DC 66 8B 41 10 66 40 66 89 45 DE 66 8B 41 0C 66 89 45 E2 66 8B 41 08 66 89 45 E4 66 8B 41 04 56 66 89 45 E6 66 8B 01 56 57 66 89 45 E8 8D 45 DC 50 56 FF B3 AC 00 00 00 66 89 75 EA FF 55 F0 3B C6 89 45 EC 0F 84 80 00 00 00 83 C0 08 3D 00 04 00 00 7F 13 E8 ?? ?? ?? ?? 8B C4 3B C6 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 3B C6 59 74 09 C7 00 DD DD 00 00 83 C0 08 3B C6 89 45 F8 74 48 FF 75 EC 89 45 F4 50 57 8D 45 DC 50 56 FF B3 AC 00 00 00 FF 55 F0 48 3B C6 7E 1F 8B 7D 18 8B 4D 14 39 37 76 15 8B 5D F4 8B 11 8A 1B 88 1A FF 01 FF 45 F4 FF 0F 48 3B C6 7F E7 FF 75 F8 E8 ?? ?? ?? ?? 59 E9 A5 00 00 00 8A 07 84 C0 0F 84 9B 00 00 00 8B 5D 18 8B 75 14 83 3B 00 0F 84 8C 00 00 00 33 D2 89 55 F8 8B CF 41 42 38 01 74 FA 89 4D F4 0F BE C8 83 F9 64 0F 8F 99 01 00 00 0F 84 65 01 00 00 83 F9 27 0F 84 EF 00 00 00 83 F9 41 0F 84 B2 00 00 00 83 F9 48 0F 84 8E 00 00 00 83 F9 4D 74 5F 83 F9 61 0F 84 9B 00 00 00 FF 75 08 51 E8 ?? ?? ?? ?? 85 C0 59 59 74 1D 83 3B 01 76 18 8D 47 01 80 38 00 0F 84 0C FE FF FF 8A 17 8B 0E 88 11 FF 06 FF 0B 8B F8 8A 0F 8B 06 88 08 FF 06 47 FF 0B 8A 07 84 C0 0F 85 6B FF FF FF 33 C0 40 8D 65 D0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 8B C2 48 74 17 48 74 1B 48 74 0A 48 75 9C B0 42 E9 3F 02 00 00 B0 62 E9 38 02 00 00 C7 45 F8 01 00 00 00 B0 6D E9 2A 02 00 00 8B C2 48 74 08 48 74 0C E9 73 FF FF FF C7 45 F8 01 00 00 00 B0 48 E9 0F 02 00 00 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 85 C0 59 59 75 05 83 C7 05 EB 14 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 85 C0 59 59 75 06 83 C7 03 89 7D F4 B0 70 E9 DB 01 00 00 03 FA F6 C2 01 0F 84 5D FF FF FF 8A 07 84 C0 0F 84 5D FF FF FF 83 3B 00 0F 84 4A FF FF FF 3C 27 74 45 FF 75 08 0F BE C0 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 1D 83 3B 01 76 18 8D 47 01 80 38 00 0F 84 18 FD FF FF 8A 17 8B 0E 88 11 FF 06 FF 0B 8B F8 8B 06 8A 0F 88 08 FF 06 47 FF 0B 8A 07 84 C0 75 B3 E9 01 FF FF FF 47 E9 FB FE FF FF 8B C2 48 74 1B 48 74 1F 48 74 0E 48 0F 85 B2 FE FF FF B0 41 E9 55 01 00 00 B0 61 E9 4E 01 00 00 C7 45 F8 01 00 00 00 B0 64 E9 40 01 00 00 8B C1 83 E8 68 0F 84 1F 01 00 00 83 E8 05 0F 84 FE 00 00 00 83 E8 06 0F 84 DD 00 00 00 48 74 25 83 E8 05 0F 85 6D FE FF FF 8B C2 48 48 74 0F 48 48 0F 85 5F FE FF FF B0 59 E9 02 01 00 00 B0 79 E9 FB 00 00 00 8B 45 10 83 78 08 0B 8B 45 1C 7F 08 8B B8 98 00 00 00 EB 06 8B B8 9C 00 00 00 83 FA 01 0F 85 8A 00 00 00 83 3B 00 0F 86 81 00 00 00 0F BE 07 FF 75 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 1D 83 3B 01 76 18 8D 47 01 80 38 00 0F 84 2E FC FF FF 8A 17 8B 0E 88 11 FF 06 FF 0B 8B F8 8B 06 8A 0F 88 08 FF 06 FF 0B E9 B0 00 00 00 83 3B 00 0F 86 A7 00 00 00 FF 75 08 0F BE C0 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 1D 83 3B 01 76 18 8D 47 01 80 38 00 0F 84 E7 FB FF FF 8A 17 8B 0E 88 11 FF 06 FF 0B 8B F8 8A 0F 8B 06 88 08 FF 06 47 FF 0B 8A 07 84 C0 75 B7 EB 65 8B C2 48 74 08 48 74 0C E9 8F FD FF FF C7 45 F8 01 00 00 00 B0 53 EB 2E 8B C2 48 74 08 48 74 0C E9 77 FD FF FF C7 45 F8 01 00 00 00 B0 4D EB 16 8B C2 48 74 08 48 74 0C E9 5F FD FF FF C7 45 F8 01 00 00 00 B0 49 FF 75 F8 8B 55 10 FF 75 1C 8B CE 53 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 63 FB FF FF 8B 7D F4 E9 66 FD FF FF }
	condition:
		$1
}

rule file_165_17_0 {
	meta:
		name = "__Strftime_l"
		size = 431
		refs = "0019 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 __errno 0035 __invalid_parameter 00c1 __isleadbyte_l 011c ?_expandtime@@YAHPAUlocaleinfo_struct@@DPBUtm@@PAPADPAIPAU__lc_time_data@@I@Z"
	strings:
		$1 = { 55 8B EC 83 EC 20 8B 45 08 53 FF 75 1C 33 DB 8D 4D E0 89 5D F8 89 45 F0 E8 ?? ?? ?? ?? 8B 45 08 3B C3 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 E9 5D 01 00 00 57 8B 7D 0C 3B FB 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 E9 29 01 00 00 56 8B 75 10 3B F3 88 18 0F 84 F4 00 00 00 8B 45 18 3B C3 75 09 8B 45 E0 8B 80 D4 00 00 00 3B FB 89 45 F4 89 7D FC 0F 86 9F 00 00 00 8A 06 3A C3 74 79 3C 25 74 41 8D 4D E0 0F BE C0 51 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 1E 33 C9 41 39 4D FC 76 16 8D 46 01 38 18 74 70 8A 0E 8B 55 08 88 0A FF 45 08 FF 4D FC 8B F0 8A 06 8B 4D 08 88 01 FF 45 08 46 FF 4D FC EB 2F 8B 55 14 3B D3 74 69 46 33 C0 80 3E 23 75 02 40 46 50 FF 75 F4 8D 45 FC 50 8D 45 E0 50 8A 06 8D 4D 08 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 4F 46 39 5D FC 77 81 39 5D FC 76 1B 8B 45 08 88 18 2B 7D FC 38 5D EC 8B C7 74 69 8B 4D E8 83 61 70 FD EB 60 89 4D F8 39 5D F8 8B 45 F0 88 18 75 2D 39 5D FC 77 28 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 33 E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 26 39 5D FC 76 D2 C7 45 F8 01 00 00 00 EB C9 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D EC 74 07 8B 45 E8 83 60 70 FD 33 C0 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_165_19_0 {
	meta:
		name = "_strftime"
		size = 29
		refs = "0015 __Strftime_l"
	strings:
		$1 = { 6A 00 6A 00 FF 74 24 18 FF 74 24 18 FF 74 24 18 FF 74 24 18 E8 ?? ?? ?? ?? 83 C4 18 C3 }
	condition:
		$1
}

rule file_165_20_0 {
	meta:
		name = "__Strftime"
		size = 30
		refs = "0015 __Strftime_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_610_17_0 {
	meta:
		name = "__cftoa"
		size = 30
		refs = "0015 __cftoa_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_610_15_0 {
	meta:
		name = "__cftoe"
		size = 30
		refs = "0015 __cftoe_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_610_22_0 {
	meta:
		name = "__cftog"
		size = 30
		refs = "0015 __cftog_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_771_7_0 {
	meta:
		name = "_mbstowcs_s"
		size = 30
		refs = "0015 __mbstowcs_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_550_8_0 {
	meta:
		name = "_wcstombs_s"
		size = 30
		refs = "0015 __wcstombs_s_l"
	strings:
		$1 = { 55 8B EC 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_166_2_0 {
	meta:
		name = "__CIcos_default"
		size = 174
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002e __DEFAULT_CW_in_mem 003c ___fastflag 0043 __fast_exit 004e _NAME_ 0053 __math_exit 0059 __pi_by_2_to_61 006e __convertTOStoQNaN 0086 __indefinite 00a8 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 50 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? D9 FF 9B DF E0 9E 7A 1D 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? DB 2D ?? ?? ?? ?? D9 C9 D9 F5 9B DF E0 9E 7A F8 DD D9 D9 FF EB CD E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 12 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "__waccess_s"
		size = 135
		refs = "000a ___doserrno 0011 __errno 0021 __invalid_parameter 003d __imp__GetFileAttributesW@4 0048 __imp__GetLastError@0 004e __dosmaperr"
	strings:
		$1 = { 56 33 F6 39 74 24 08 75 24 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 F7 44 24 0C F9 FF FF FF 75 D2 FF 74 24 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 00 5E C3 A8 10 75 23 A8 01 74 1F F6 44 24 0C 02 74 18 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB D0 33 C0 5E C3 }
	condition:
		$1
}

rule file_598_0_0 {
	meta:
		name = "__access_s"
		size = 135
		refs = "000a ___doserrno 0011 __errno 0021 __invalid_parameter 003d __imp__GetFileAttributesA@4 0048 __imp__GetLastError@0 004e __dosmaperr"
	strings:
		$1 = { 56 33 F6 39 74 24 08 75 24 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 F7 44 24 0C F9 FF FF FF 75 D2 FF 74 24 08 FF 15 ?? ?? ?? ?? 83 F8 FF 75 16 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 00 5E C3 A8 10 75 23 A8 01 74 1F F6 44 24 0C 02 74 18 E8 ?? ?? ?? ?? C7 00 05 00 00 00 E8 ?? ?? ?? ?? C7 00 0D 00 00 00 EB D0 33 C0 5E C3 }
	condition:
		$1
}

rule file_167_1_0 {
	meta:
		name = "__waccess"
		size = 20
		refs = "0009 __waccess_s"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 E8 ?? ?? ?? ?? 59 F7 D8 59 1B C0 C3 }
	condition:
		$1
}

rule file_598_1_0 {
	meta:
		name = "__access"
		size = 20
		refs = "0009 __access_s"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 E8 ?? ?? ?? ?? 59 F7 D8 59 1B C0 C3 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "_fsetpos"
		size = 66
		refs = "000a __errno 001a __invalid_parameter 0039 __fseeki64"
	strings:
		$1 = { 56 33 F6 39 74 24 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E C3 8B 44 24 0C 3B C6 74 DB 56 FF 70 04 FF 30 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_170_0_0 {
	meta:
		name = "_fgetpos"
		size = 107
		refs = "000a __errno 001a __invalid_parameter 0051 __ftelli64"
	strings:
		$1 = { 57 33 FF 39 7C 24 08 75 1D E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5F C3 56 8B 74 24 10 3B F7 75 1D E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 1C FF 74 24 0C E8 ?? ?? ?? ?? 59 8B C8 89 06 23 CA 83 C8 FF 3B C8 89 56 04 74 02 33 C0 5E 5F C3 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "?set_new_handler@@YAP6AXXZP6AXXZ@Z"
		size = 38
		refs = "000a ??_C@_1BI@FINJKBPN@?$AAs?$AAe?$AAt?$AAn?$AAe?$AAw?$AAh?$AA?4?$AAc?$AAp?$AAp?$AA?$AA@ 000f ??_C@_1BG@DCNCEIOF@?$AAn?$AAe?$AAw?$AA_?$AAp?$AA?5?$AA?$DN?$AA?$DN?$AA?5?$AA0?$AA?$AA@ 0014 __wassert 001e ?_set_new_handler@@YAP6AHI@ZP6AHI@Z@Z"
	strings:
		$1 = { 83 7C 24 04 00 74 14 6A 3A 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 6A 00 E8 ?? ?? ?? ?? 59 33 C0 C3 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "__fstat32i64"
		size = 838
		refs = "0003 __sehtable$__fstat32i64 0008 __SEH_prolog4 0020 ___doserrno 0027 __errno 0037 __invalid_parameter 004b _memset 0074 __nhandle 0096 ___pioinfo 00b3 ___lock_fhandle 00e7 __SEH_epilog4 00f0 __imp__GetFileType@4 0112 __imp__GetLastError@0 0118 __dosmaperr 016f __imp__PeekNamedPipe@24 01b5 __imp__GetFileInformationByHandle@8 01f2 __imp__FileTimeToLocalFileTime@8 0208 __imp__FileTimeToSystemTime@8 0235 ___loctotime32_t 0313 __allmul 0340 __unlock_fhandle"
	strings:
		$1 = { 6A 5C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 33 C0 8B 75 0C 3B F7 0F 95 C0 3B C7 75 27 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 16 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A0 00 00 00 6A 30 57 56 E8 ?? ?? ?? ?? 83 C4 0C 8B 4D 08 83 F9 FE 75 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB D0 3B CF 7C 08 3B 0D ?? ?? ?? ?? 72 14 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB A3 8B C1 C1 F8 05 8D 04 85 ?? ?? ?? ?? 89 45 0C 8B D9 83 E3 1F 6B DB 28 8B 00 0F B6 44 18 04 83 E0 01 74 C9 51 E8 ?? ?? ?? ?? 59 89 7D FC 8B 45 0C 8B 00 03 C3 F6 40 04 01 75 24 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 59 02 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 30 FF 15 ?? ?? ?? ?? 25 FF 7F FF FF 83 F8 01 0F 84 8F 00 00 00 83 F8 02 74 18 83 F8 03 74 13 3B C7 74 B8 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB B4 33 D2 83 F8 02 0F 95 C2 4A B9 00 10 00 00 23 D1 03 D1 66 89 56 06 8B 4D 08 89 0E 89 4E 10 66 C7 46 08 01 00 66 89 7E 04 66 89 7E 0C 66 89 7E 0A 89 7E 28 89 7E 24 89 7E 20 83 F8 02 74 29 57 8D 45 0C 50 57 57 57 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 3B C7 74 0F 8B 45 0C 99 89 46 18 89 56 1C E9 51 FF FF FF 89 7E 18 89 7E 1C E9 46 FF FF FF 66 89 7E 06 66 89 7E 0C 66 89 7E 0A 66 89 7E 04 66 C7 46 08 01 00 8D 45 94 50 8B 45 0C 8B 00 FF 34 18 FF 15 ?? ?? ?? ?? 85 C0 0F 84 4F FF FF FF 66 8B 46 06 F6 45 94 01 74 06 66 0D 24 01 EB 04 66 0D B6 01 66 89 46 06 39 7D A8 75 0A 39 7D AC 75 05 89 7E 24 EB 57 8D 45 D8 50 8D 45 A8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 D5 FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 BF FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 24 39 7D A0 75 0A 39 7D A4 75 05 8B 46 24 EB 54 8D 45 D8 50 8D 45 A0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 6F FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 59 FE FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 20 39 7D 98 75 0A 39 7D 9C 75 05 8B 46 24 EB 54 8D 45 D8 50 8D 45 98 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 09 FE FF FF 8D 45 C8 50 8D 45 D8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 F3 FD FF FF 6A FF 0F B7 45 D4 50 0F B7 45 D2 50 0F B7 45 D0 50 0F B7 45 CE 50 0F B7 45 CA 50 0F B7 45 C8 50 E8 ?? ?? ?? ?? 83 C4 1C 89 46 28 6A 01 57 57 FF 75 B4 E8 ?? ?? ?? ?? 8B 4D B8 33 DB 03 C1 13 D3 89 46 18 89 56 1C 66 8B 46 06 66 0D 00 80 66 89 46 06 89 3E 89 7E 10 E9 9B FD FF FF FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_175_3_0 {
	meta:
		name = "_write_char"
		size = 23
		refs = "0005 __putwch_nolock"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? 66 3D FF FF 59 75 04 83 0E FF C3 FF 06 C3 }
	condition:
		$1
}

rule file_175_4_0 {
	meta:
		name = "_write_multi_char"
		size = 33
		refs = "000e _write_char"
	strings:
		$1 = { 56 8B F0 EB 13 FF 74 24 08 FF 4C 24 10 E8 ?? ?? ?? ?? 83 3E FF 59 74 07 83 7C 24 0C 00 7F E6 5E C3 }
	condition:
		$1
}

rule file_175_5_0 {
	meta:
		name = "_write_string"
		size = 57
		refs = "0011 _write_char 001e __errno"
	strings:
		$1 = { 56 57 8B F0 8B F9 EB 27 0F B7 07 FF 4C 24 0C 50 E8 ?? ?? ?? ?? 47 47 83 3E FF 59 75 12 E8 ?? ?? ?? ?? 83 38 2A 75 0F 6A 3F E8 ?? ?? ?? ?? 59 83 7C 24 0C 00 7F D2 5F 5E C3 }
	condition:
		$1
}

rule file_175_7_0 {
	meta:
		name = "_get_int64_arg"
		size = 16
		altNames = "_get_crtdouble_arg"
	strings:
		$1 = { 8B 44 24 04 83 00 08 8B 08 8B 41 F8 8B 51 FC C3 }
	condition:
		$1
}

rule file_175_8_0 {
	meta:
		name = "__vcwprintf_l"
		size = 2288
		refs = "000f ___security_cookie 004e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0057 __errno 0067 __invalid_parameter 00be ___lookuptable 00e3 $LN243 02ad _write_char 0367 ___nullstring 038f __isleadbyte_l 03fb __mbtowc_l 0460 _strlen 04bd __get_printf_count_output 053a __malloc_crt 0583 __cfltcvt_tab 0588 __decode_pointer 06f4 __aulldvrm 073f ___wnullstring 07b7 _write_multi_char 07c7 _write_string 086d _free 08c4 @__security_check_cookie@4 08d0 $NORMAL_STATE$25906 08d4 $LN131 08d8 $LN130 08dc $LN122 08e0 $LN118 08e4 $LN117 08e8 $LN113 08ec $LN97"
	strings:
		$1 = { 55 8D AC 24 10 FC FF FF 81 EC 70 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 EC 03 00 00 53 8B 9D 00 04 00 00 56 8B B5 F8 03 00 00 57 FF B5 FC 03 00 00 33 FF 8D 4D 9C 89 5D D8 89 7D B0 89 7D E8 89 7D C4 89 7D E4 89 7D CC 89 7D AC 89 7D C8 E8 ?? ?? ?? ?? 3B F7 75 2D E8 ?? ?? ?? ?? 57 57 57 57 C7 00 16 00 00 00 57 E8 ?? ?? ?? ?? 83 C4 14 80 7D A8 00 74 07 8B 45 A4 83 60 70 FD 83 C8 FF E9 35 08 00 00 0F B7 0E 33 D2 66 3B CF 89 7D D0 89 7D E0 89 7D B8 89 4D DC 0F 84 0B 08 00 00 6A 02 5F 03 F7 83 7D D0 00 89 75 B4 0F 8C F9 07 00 00 8D 41 E0 66 3D 58 00 77 0F 0F B7 C1 0F B6 80 ?? ?? ?? ?? 83 E0 0F EB 02 33 C0 0F BE 84 C2 ?? ?? ?? ?? C1 F8 04 83 F8 07 89 45 94 0F 87 96 07 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 4D E4 FF 89 45 90 89 45 AC 89 45 C4 89 45 CC 89 45 E8 89 45 C8 E9 72 07 00 00 0F B7 C1 83 E8 20 74 3E 83 E8 03 74 2D 83 E8 08 74 1F 2B C7 74 12 83 E8 03 0F 85 53 07 00 00 83 4D E8 08 E9 4A 07 00 00 83 4D E8 04 E9 41 07 00 00 83 4D E8 01 E9 38 07 00 00 81 4D E8 80 00 00 00 E9 2C 07 00 00 09 7D E8 E9 24 07 00 00 66 83 F9 2A 75 22 83 C3 04 89 5D D8 8B 5B FC 85 DB 89 5D C4 0F 8D 0A 07 00 00 83 4D E8 04 F7 DB 89 5D C4 E9 FC 06 00 00 8B 45 C4 6B C0 0A 0F B7 C9 8D 44 08 D0 89 45 C4 E9 E7 06 00 00 83 65 E4 00 E9 DE 06 00 00 66 83 F9 2A 75 1D 83 C3 04 89 5D D8 8B 5B FC 85 DB 89 5D E4 0F 8D C4 06 00 00 83 4D E4 FF E9 BB 06 00 00 8B 45 E4 6B C0 0A 0F B7 C9 8D 44 08 D0 89 45 E4 E9 A6 06 00 00 0F B7 C1 83 F8 49 74 48 83 F8 68 74 3A 83 F8 6C 74 15 83 F8 77 0F 85 8B 06 00 00 81 4D E8 00 08 00 00 E9 7F 06 00 00 66 83 3E 6C 75 11 03 F7 81 4D E8 00 10 00 00 89 75 B4 E9 68 06 00 00 83 4D E8 10 E9 5F 06 00 00 83 4D E8 20 E9 56 06 00 00 0F B7 06 66 3D 36 00 75 19 66 83 7E 02 34 75 12 83 C6 04 81 4D E8 00 80 00 00 89 75 B4 E9 34 06 00 00 66 3D 33 00 75 19 66 83 7E 02 32 75 12 83 C6 04 81 65 E8 FF 7F FF FF 89 75 B4 E9 15 06 00 00 66 3D 64 00 0F 84 0B 06 00 00 66 3D 69 00 0F 84 01 06 00 00 66 3D 6F 00 0F 84 F7 05 00 00 66 3D 75 00 0F 84 ED 05 00 00 66 3D 78 00 0F 84 E3 05 00 00 66 3D 58 00 0F 84 D9 05 00 00 83 65 94 00 51 8D 75 D0 C7 45 C8 01 00 00 00 E8 ?? ?? ?? ?? E9 BF 05 00 00 0F B7 C1 83 F8 64 0F 8F A8 01 00 00 0F 84 21 02 00 00 83 F8 53 0F 8F D7 00 00 00 74 5F 83 E8 41 74 10 2B C7 74 41 2B C7 74 08 2B C7 0F 85 7D 04 00 00 83 C1 20 C7 45 90 01 00 00 00 89 4D DC 83 4D E8 40 83 7D E4 00 8D 7D EC B8 00 02 00 00 89 7D D4 89 45 E0 0F 8D FC 01 00 00 C7 45 E4 06 00 00 00 E9 3D 02 00 00 66 F7 45 E8 30 08 0F 85 9D 00 00 00 83 4D E8 20 E9 94 00 00 00 66 F7 45 E8 30 08 75 04 83 4D E8 20 8B 7D E4 83 FF FF 75 05 BF FF FF FF 7F 83 C3 04 F6 45 E8 20 89 5D D8 8B 5B FC 89 5D D4 0F 84 D8 03 00 00 85 DB 75 09 8B 1D ?? ?? ?? ?? 89 5D D4 83 65 E0 00 85 FF 8B F3 0F 8E E9 03 00 00 8A 06 84 C0 0F 84 DF 03 00 00 8D 4D 9C 0F B6 C0 51 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 01 46 46 FF 45 E0 39 7D E0 7C D9 E9 BD 03 00 00 83 E8 58 0F 84 44 02 00 00 2B C7 74 68 83 E8 07 0F 84 37 FF FF FF 2B C7 0F 85 9F 03 00 00 0F B7 03 83 C3 04 33 F6 46 F6 45 E8 20 89 75 C8 89 5D D8 89 45 98 74 2D 88 45 BC 8D 45 9C 50 8B 45 9C C6 45 BD 00 FF B0 AC 00 00 00 8D 45 BC 50 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 09 89 75 AC EB 04 66 89 45 EC 8D 45 EC 89 45 D4 89 75 E0 E9 48 03 00 00 8B 03 83 C3 04 85 C0 89 5D D8 74 2D 8B 48 04 85 C9 74 26 66 F7 45 E8 00 08 0F BF 00 89 4D D4 74 0F 99 2B C2 C7 45 C8 01 00 00 00 E9 13 03 00 00 83 65 C8 00 E9 0C 03 00 00 A1 ?? ?? ?? ?? 89 45 D4 50 E8 ?? ?? ?? ?? 59 E9 F8 02 00 00 83 F8 70 0F 8F 8B 01 00 00 0F 84 75 01 00 00 83 F8 65 0F 8C E3 02 00 00 83 F8 67 0F 8E 6A FE FF FF 83 F8 69 74 59 83 F8 6E 74 1F 83 F8 6F 0F 85 C7 02 00 00 F6 45 E8 80 C7 45 DC 08 00 00 00 74 49 81 4D E8 00 02 00 00 EB 40 8B 33 83 C3 04 89 5D D8 E8 ?? ?? ?? ?? 85 C0 0F 84 C8 03 00 00 F6 45 E8 20 74 09 66 8B 45 D0 66 89 06 EB 05 8B 45 D0 89 06 C7 45 AC 01 00 00 00 E9 7A 03 00 00 83 4D E8 40 C7 45 DC 0A 00 00 00 8B 4D E8 66 85 C9 0F 89 48 01 00 00 8B 03 8B 53 04 83 C3 08 E9 70 01 00 00 75 0F 66 83 F9 67 75 45 C7 45 E4 01 00 00 00 EB 3C 39 45 E4 7E 03 89 45 E4 81 7D E4 A3 00 00 00 7E 2B 8B 75 E4 81 C6 5D 01 00 00 56 E8 ?? ?? ?? ?? 85 C0 59 8B 4D DC 89 45 B8 74 0A 8B F8 89 45 D4 89 75 E0 EB 07 C7 45 E4 A3 00 00 00 8B 03 83 C3 08 89 45 88 8B 43 FC 89 45 8C 8D 45 9C 50 FF 75 90 0F BE C1 FF 75 E4 89 5D D8 50 FF 75 E0 8D 45 88 57 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 8B 75 E8 83 C4 1C 81 E6 80 00 00 00 74 1B 83 7D E4 00 75 15 8D 45 9C 50 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 66 83 7D DC 67 75 19 85 F6 75 15 8D 45 9C 50 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 3F 2D 75 0B 81 4D E8 00 01 00 00 47 89 7D D4 57 E9 71 FE FF FF C7 45 E4 08 00 00 00 C7 45 B0 07 00 00 00 EB 21 83 E8 73 0F 84 37 FD FF FF 2B C7 0F 84 DE FE FF FF 83 E8 03 0F 85 4D 01 00 00 C7 45 B0 27 00 00 00 F6 45 E8 80 C7 45 DC 10 00 00 00 0F 84 C4 FE FF FF 8B 45 B0 83 C0 51 66 C7 45 C0 30 00 66 89 45 C2 89 7D CC E9 AC FE FF FF 66 F7 C1 00 10 0F 85 AD FE FF FF 83 C3 04 F6 C1 20 74 15 F6 C1 40 89 5D D8 74 06 0F BF 43 FC EB 04 0F B7 43 FC 99 EB 10 F6 C1 40 8B 43 FC 74 03 99 EB 02 33 D2 89 5D D8 F6 C1 40 74 18 85 D2 7F 14 7C 04 85 C0 73 0E F7 D8 83 D2 00 F7 DA 81 4D E8 00 01 00 00 66 F7 45 E8 00 90 8B DA 8B F0 75 02 33 DB 83 7D E4 00 7D 09 C7 45 E4 01 00 00 00 EB 11 83 65 E8 F7 B8 00 02 00 00 39 45 E4 7E 03 89 45 E4 8B C6 0B C3 75 04 83 65 CC 00 8D BD EB 01 00 00 8B 45 E4 FF 4D E4 85 C0 7F 06 8B C6 0B C3 74 24 8B 45 DC 99 52 50 53 56 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 5D 84 8B F0 8B DA 7E 03 03 4D B0 88 0F 4F EB CC 8D 85 EB 01 00 00 2B C7 47 66 F7 45 E8 00 02 89 45 E0 89 7D D4 74 3F 85 C0 74 05 80 3F 30 74 36 4F 89 7D D4 C6 07 30 40 EB 29 85 DB 75 09 8B 1D ?? ?? ?? ?? 89 5D D4 C7 45 C8 01 00 00 00 8B C3 EB 09 4F 66 83 38 00 74 06 40 40 85 FF 75 F3 2B C3 D1 F8 89 45 E0 83 7D AC 00 0F 85 F4 00 00 00 8B 45 E8 A8 40 74 2B 66 A9 00 01 74 08 66 C7 45 C0 2D 00 EB 16 A8 01 74 08 66 C7 45 C0 2B 00 EB 0A A8 02 74 0D 66 C7 45 C0 20 00 C7 45 CC 01 00 00 00 8B 5D C4 2B 5D E0 2B 5D CC F6 45 E8 0C 75 0D 53 6A 20 8D 45 D0 E8 ?? ?? ?? ?? 59 59 FF 75 CC 8D 45 D0 8D 4D C0 E8 ?? ?? ?? ?? F6 45 E8 08 59 74 13 F6 45 E8 04 75 0D 53 6A 30 8D 45 D0 E8 ?? ?? ?? ?? 59 59 83 7D C8 00 75 50 83 7D E0 00 7E 4A 8B 45 E0 8B 7D D4 89 45 DC FF 4D DC 8D 45 9C 50 8B 45 9C FF B0 AC 00 00 00 8D 45 98 57 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 89 45 84 7E 17 FF 75 98 8D 75 D0 E8 ?? ?? ?? ?? 03 7D 84 83 7D DC 00 59 7F C7 EB 15 83 4D D0 FF EB 0F FF 75 E0 8B 4D D4 8D 45 D0 E8 ?? ?? ?? ?? 59 83 7D D0 00 7C 13 F6 45 E8 04 74 0D 53 6A 20 8D 45 D0 E8 ?? ?? ?? ?? 59 59 83 7D B8 00 74 0D FF 75 B8 E8 ?? ?? ?? ?? 83 65 B8 00 59 8B 75 B4 0F B7 06 66 85 C0 89 45 DC 74 24 8B 55 94 8B 5D D8 8B C8 E9 0C F8 FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E9 BE F7 FF FF 80 7D A8 00 74 07 8B 45 A4 83 60 70 FD 8B 45 D0 8B 8D EC 03 00 00 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 81 C5 F0 03 00 00 C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_11_0 {
	meta:
		name = "__vcwprintf"
		size = 19
		refs = "000b __vcwprintf_l"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_599_12_0 {
	meta:
		name = "__vcprintf"
		size = 19
		refs = "000b __vcprintf_l"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_827_13_0 {
	meta:
		name = "__vcprintf_p"
		size = 19
		refs = "000b __vcprintf_p_l"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_833_12_0 {
	meta:
		name = "__vcprintf_s"
		size = 19
		refs = "000b __vcprintf_s_l"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_821_11_0 {
	meta:
		name = "__vcwprintf_p"
		size = 19
		refs = "000b __vcwprintf_p_l"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_615_11_0 {
	meta:
		name = "__vcwprintf_s"
		size = 19
		refs = "000b __vcwprintf_s_l"
	strings:
		$1 = { FF 74 24 08 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_177_3_0 {
	meta:
		name = "__wcsicmp_l"
		size = 271
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001d __errno 002d __invalid_parameter 00cd __towlower_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 5D 08 33 F6 3B DE 75 2F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 C0 00 00 00 57 8B 7D 0C 3B FE 75 2F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 88 00 00 00 8B 45 F0 39 70 14 75 3A 0F B7 03 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 0F B7 F0 0F B7 07 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 43 43 47 47 66 85 F6 0F B7 C0 74 38 66 3B F0 74 C8 EB 31 0F B7 03 8D 4D F0 51 50 E8 ?? ?? ?? ?? 0F B7 F0 0F B7 07 8D 4D F0 51 43 50 43 E8 ?? ?? ?? ?? 83 C4 10 47 47 66 85 F6 0F B7 C0 74 05 66 3B F0 74 CF 0F B7 C8 0F B7 C6 2B C1 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_177_4_0 {
	meta:
		name = "__wcsicmp"
		size = 145
		refs = "0005 ___locale_changed 0015 __errno 0025 __invalid_parameter 0087 __wcsicmp_l"
	strings:
		$1 = { 56 33 F6 39 35 ?? ?? ?? ?? 57 75 71 8B 7C 24 0C 3B FE 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 5B 8B 54 24 10 3B D6 74 D9 0F B7 07 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 0F B7 C8 0F B7 02 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 47 47 42 42 66 3B CE 0F B7 C0 74 05 66 3B C8 74 C8 0F B7 D0 0F B7 C1 2B C2 EB 11 56 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E C3 }
	condition:
		$1
}

rule file_330_4_0 {
	meta:
		name = "__wcsicoll"
		size = 145
		refs = "0005 ___locale_changed 0015 __errno 0025 __invalid_parameter 0087 __wcsicoll_l"
	strings:
		$1 = { 56 33 F6 39 35 ?? ?? ?? ?? 57 75 71 8B 7C 24 0C 3B FE 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 5B 8B 54 24 10 3B D6 74 D9 0F B7 07 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 0F B7 C8 0F B7 02 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 47 47 42 42 66 3B CE 0F B7 C0 74 05 66 3B C8 74 C8 0F B7 D0 0F B7 C1 2B C2 EB 11 56 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E C3 }
	condition:
		$1
}

rule file_178_1_0 {
	meta:
		name = "__setenvp"
		size = 219
		refs = "0005 ___mbctype_initialized 000e ___initmbctable 0014 __aenvptr 002d _strlen 0041 __calloc_crt 004d __environ 007f _strcpy_s 0090 __invoke_watson 00a7 _free 00b5 ___env_initialized"
	strings:
		$1 = { 53 33 DB 39 1D ?? ?? ?? ?? 56 57 75 05 E8 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 33 FF 3B F3 75 18 83 C8 FF E9 9B 00 00 00 3C 3D 74 01 47 56 E8 ?? ?? ?? ?? 59 8D 74 06 01 8A 06 3A C3 75 EA 6A 04 47 57 E8 ?? ?? ?? ?? 8B F8 3B FB 59 59 89 3D ?? ?? ?? ?? 74 CB 8B 35 ?? ?? ?? ?? 55 EB 40 56 E8 ?? ?? ?? ?? 8B E8 45 80 3E 3D 59 74 2F 6A 01 55 E8 ?? ?? ?? ?? 3B C3 59 59 89 07 74 4A 56 55 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C7 04 03 F5 38 1E 75 BC FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 1F C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 59 5D 5F 5E 5B C3 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 83 C8 FF EB E4 }
	condition:
		$1
}

rule file_179_0_0 {
	meta:
		name = "__purecall"
		size = 42
		refs = "0002 ___pPurecall 0007 __decode_pointer 0015 __NMSG_WRITE 001e __set_abort_behavior 0026 _abort"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 02 FF D0 6A 19 E8 ?? ?? ?? ?? 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 0C E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_180_3_0 {
	meta:
		name = "?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
		size = 416
		refs = "0032 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0093 __imp__MultiByteToWideChar@24 00b6 __errno 00f8 __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 33 C9 3B F1 57 8B F8 74 03 66 89 0E 3B D9 0F 84 78 01 00 00 39 4D 0C 0F 84 6F 01 00 00 38 0B 0F 84 67 01 00 00 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 83 78 14 00 75 2E 85 F6 74 07 66 0F B6 03 66 89 06 8B 45 08 85 C0 74 06 C7 00 01 00 00 00 80 7D FC 00 0F 84 3A 01 00 00 8B 45 F8 83 60 70 FD E9 2E 01 00 00 83 3F 00 74 7D 8A 0B 88 4F 01 83 B8 AC 00 00 00 01 7E 32 33 C9 85 F6 0F 95 C1 51 56 6A 02 57 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 74 17 83 27 00 8B 45 08 85 C0 74 B2 8B 4D F0 8B 89 AC 00 00 00 89 08 EB A5 83 27 00 E8 ?? ?? ?? ?? 85 F6 C7 00 2A 00 00 00 74 04 66 83 26 00 8B 45 08 85 C0 74 03 83 08 FF E8 ?? ?? ?? ?? 80 7D FC 00 8B 00 0F 84 BA 00 00 00 8B 4D F8 83 61 70 FD E9 AE 00 00 00 8D 45 F0 50 0F B6 03 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 5A 8B 4D F0 8B 81 AC 00 00 00 39 45 0C 73 1A 8A 03 88 07 8B 45 08 85 C0 0F 84 38 FF FF FF C7 00 FE FF FF FF E9 2D FF FF FF 83 F8 01 7E 1E 33 D2 85 F6 0F 95 C2 52 56 50 53 6A 09 FF 71 04 FF 15 ?? ?? ?? ?? 85 C0 0F 85 51 FF FF FF 80 7B 01 00 0F 85 47 FF FF FF E9 56 FF FF FF 33 C0 85 F6 0F 95 C0 33 FF 47 50 8B 45 F0 56 57 53 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 0F 84 35 FF FF FF 8B 45 08 85 C0 0F 84 CC FE FF FF 89 38 E9 C5 FE FF FF 8B 45 08 3B C1 74 02 89 08 33 C0 5F C9 C3 }
	condition:
		$1
}

rule file_180_4_0 {
	meta:
		name = "_btowc"
		size = 81
		refs = "0037 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 0C 83 F8 FF 75 06 66 0D FF FF C9 C3 83 65 F4 00 83 65 F8 00 83 4D FC FF 53 56 88 45 0B 6A 00 8D 45 FC 6A 01 50 8D 45 F4 8D 5D 0B 8D 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 5E 5B B8 FF FF 00 00 7C 04 0F B7 45 F8 C9 C3 }
	condition:
		$1
}

rule file_180_5_0 {
	meta:
		name = "_mbrlen"
		size = 51
		refs = "0010 ?mbst@?1??mbrlen@@9@4HA 0025 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 51 8B 45 10 83 4D FC FF 85 C0 75 05 B8 ?? ?? ?? ?? 53 8B 5D 08 56 6A 00 FF 75 0C 8D 4D FC 51 33 F6 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 0C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_180_6_0 {
	meta:
		name = "_mbrtowc"
		size = 78
		refs = "0019 ?mbst@?1??mbrtowc@@9@4HA 0035 ??_C@_00CNPNBAHC@?$AA@ 0040 ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 51 83 4D FC FF 8B 45 14 53 8B 5D 0C 85 DB 56 74 13 85 C0 75 05 B8 ?? ?? ?? ?? 8B 75 08 6A 00 FF 75 10 EB 14 85 C0 75 05 B8 ?? ?? ?? ?? 6A 00 6A 01 BB ?? ?? ?? ?? 33 F6 8D 4D FC 51 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 0C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_180_7_0 {
	meta:
		name = "__mbsrtowcs_helper"
		size = 232
		refs = "0011 __errno 0021 __invalid_parameter 003e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 004a ?mbst@?5??_mbsrtowcs_helper@@9@4HA 006c ?_mbrtowc_s_l@@YAHPAHPA_WPBDI0PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 8B 45 0C 83 EC 18 56 33 F6 3B C6 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B5 00 00 00 53 8B 18 56 8D 4D E8 89 75 FC 89 75 F8 E8 ?? ?? ?? ?? 39 75 14 75 07 C7 45 14 ?? ?? ?? ?? 39 75 08 74 41 39 75 10 76 77 8B 75 08 8D 45 E8 50 8D 45 FC 68 FF FF FF 7F 50 8B 45 14 E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 7C 4E 74 52 FF 45 F8 03 5D FC 83 45 08 02 FF 4D 10 75 CE EB 43 74 46 FF 45 F8 03 5D FC 8D 45 E8 50 8D 45 FC 68 FF FF FF 7F 50 8B 45 14 8D 75 0C E8 ?? ?? ?? ?? 83 C4 0C 83 7D FC 00 7D D7 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 83 C8 FF EB 1D 83 4D F8 FF EB 02 33 DB 8B 45 0C 89 18 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 8B 45 F8 5B 5E C9 C3 }
	condition:
		$1
}

rule file_180_9_0 {
	meta:
		name = "_mbsrtowcs_s"
		size = 162
		refs = "0026 __errno 0035 __invalid_parameter 005c __mbsrtowcs_helper"
	strings:
		$1 = { 55 8B EC 53 8B 5D 08 56 33 F6 3B DE 57 74 03 83 0B FF 8B 7D 0C 3B FE 75 07 39 75 10 74 25 EB 05 39 75 10 77 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 5D 66 89 37 39 75 14 74 DD 8B 45 18 3B 45 10 76 03 8B 45 10 FF 75 1C 50 FF 75 14 57 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 10 3B FE 74 03 66 89 37 E8 ?? ?? ?? ?? 8B 00 EB 25 40 3B FE 74 18 39 45 10 73 0E 66 89 37 76 0E E8 ?? ?? ?? ?? 6A 22 EB 9C 66 89 74 47 FE 3B DE 74 02 89 03 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_181_0_0 {
	meta:
		name = "__futime64"
		size = 432
		refs = "000f __errno 0027 __nhandle 003b ___pioinfo 0057 __invalid_parameter 0073 __time64 0090 __localtime64_s 00e0 __imp__SystemTimeToFileTime@8 0108 __imp__LocalFileTimeToFileTime@8 0189 __get_osfhandle 0191 __imp__SetFileTime@16"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 5C 83 F8 FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF C9 C3 57 33 FF 3B C7 7C 21 3B 05 ?? ?? ?? ?? 73 19 8B C8 83 E0 1F 6B C0 28 C1 F9 05 8B 0C 8D ?? ?? ?? ?? F6 44 01 04 01 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 47 01 00 00 53 8B 5D 0C 3B DF 75 19 8D 45 D0 50 E8 ?? ?? ?? ?? 8B 45 D0 89 45 C8 8B 45 D4 59 89 45 CC 8D 5D C8 8D 43 08 50 8D 45 A4 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 FF 00 00 00 8B 45 B8 05 6C 07 00 00 66 89 45 D8 8B 45 B4 40 66 89 45 DA 66 8B 45 B0 66 89 45 DE 66 8B 45 AC 66 89 45 E0 66 8B 45 A8 66 89 45 E2 66 8B 45 A4 56 8B 35 ?? ?? ?? ?? 66 89 45 E4 8D 45 F8 50 8D 45 D8 50 66 89 7D E6 FF D6 85 C0 0F 84 9F 00 00 00 8D 45 F0 50 8D 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 89 00 00 00 8D 45 A4 53 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 79 8B 45 B8 05 6C 07 00 00 66 89 45 D8 8B 45 B4 40 66 89 45 DA 66 8B 45 B0 66 89 45 DE 66 8B 45 AC 66 89 45 E0 66 8B 45 A8 66 89 45 E2 66 8B 45 A4 66 89 45 E4 8D 45 F8 50 8D 45 D8 50 66 89 7D E6 FF D6 85 C0 74 33 8D 45 E8 50 8D 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 74 21 8D 45 F0 50 8D 45 E8 50 57 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5E 5B 5F C9 C3 }
	condition:
		$1
}

rule file_183_1_0 {
	meta:
		name = "__get_sys_err_msg"
		size = 35
		refs = "000a ___sys_nerr 001a ___sys_errlist"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 7C 09 E8 ?? ?? ?? ?? 3B 30 7C 07 E8 ?? ?? ?? ?? 8B 30 E8 ?? ?? ?? ?? 8B 04 B0 5E C3 }
	condition:
		$1
}

rule file_183_2_0 {
	meta:
		name = "__wperror"
		size = 301
		refs = "0003 __sehtable$__wperror 0008 __SEH_prolog4 0038 _wcstombs_s 0053 __invoke_watson 0065 __calloc_crt 00a6 _free 00ac __SEH_epilog4 00ba ___lock_fhandle 00c8 _strlen 00d0 __write_nolock 00d6 ??_C@_02LMMGGCAJ@?3?5?$AA@ 00ea __errno 00f1 __get_sys_err_msg 0108 ??_C@_01EEMJAFIK@?6?$AA@ 0127 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 02 5B 89 5D E0 33 FF 89 7D E4 8B 45 08 3B C7 0F 84 8F 00 00 00 66 39 38 0F 84 86 00 00 00 68 FF FF FF 7F 50 57 57 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 14 3B C7 74 17 83 F8 16 74 05 83 F8 22 75 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 39 7D E4 74 4C 6A 01 FF 75 E4 E8 ?? ?? ?? ?? 59 59 8B F0 3B F7 74 3A 6A FF FF 75 08 FF 75 E4 56 57 E8 ?? ?? ?? ?? 83 C4 14 8B D8 3B DF 74 2C 83 FB 16 74 05 83 FB 22 75 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 3B DF 74 11 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C3 33 F6 EB 03 6A 02 5B 53 E8 ?? ?? ?? ?? 59 89 7D FC 3B F7 74 1D 56 E8 ?? ?? ?? ?? 50 56 53 E8 ?? ?? ?? ?? 53 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 1C 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 50 56 53 E8 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 83 C4 24 C7 45 FC FE FF FF FF E8 02 00 00 00 EB 88 FF 75 E0 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_184_0_0 {
	meta:
		name = "__copysign"
		size = 38
	strings:
		$1 = { 55 8B EC 51 51 D9 EE 8B 45 08 DD 5D F8 89 45 F8 8B 45 14 33 45 0C 25 FF FF FF 7F 33 45 14 89 45 FC DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_184_1_0 {
	meta:
		name = "__chgsign"
		size = 43
	strings:
		$1 = { 55 8B EC 51 51 D9 EE 8B 45 08 DD 5D F8 89 45 F8 8B 45 0C 8B C8 F7 D1 33 C8 81 E1 FF FF FF 7F F7 D0 33 C8 89 4D FC DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_184_2_0 {
	meta:
		name = "__scalb"
		size = 22
		refs = "000e _ldexp"
	strings:
		$1 = { FF 74 24 0C DD 44 24 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_184_3_0 {
	meta:
		name = "__logb"
		size = 227
		refs = "0012 __ctrlfp 0030 __sptype 0050 __handle_qnan1 006d __real@3ff0000000000000 0083 __except1 009e __d_inf 00bf __decomp"
	strings:
		$1 = { 55 8B EC 51 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B F8 8B 45 0E 66 25 F0 7F 66 3D F0 7F 59 59 75 65 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 85 C0 59 59 7E 2D 83 F8 02 7E 1D 83 F8 03 75 23 DD 45 08 57 51 51 DD 1C 24 6A 25 E8 ?? ?? ?? ?? 83 C4 10 E9 83 00 00 00 56 57 E8 ?? ?? ?? ?? 59 59 EB 75 DD 45 08 57 DC 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 25 6A 08 E8 ?? ?? ?? ?? 83 C4 1C EB 53 D9 EE DD 45 08 DD E1 DF E0 DD D9 F6 C4 44 7A 19 DD 05 ?? ?? ?? ?? 57 83 EC 10 D9 E0 DD 5C 24 08 DD 1C 24 6A 25 6A 04 EB CD 8D 45 FC 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 FC DD D8 48 89 45 0C DB 45 0C 56 57 DD 5D 08 E8 ?? ?? ?? ?? 83 C4 14 DD 45 08 5F 5E C9 C3 }
	condition:
		$1
}

rule file_184_4_0 {
	meta:
		name = "__nextafter"
		size = 661
		refs = "001a __ctrlfp 0094 __except2 01c6 __decomp 01dc __set_exp 0289 __handle_qnan2"
	strings:
		$1 = { 55 8B EC 83 EC 0C D9 EE 53 56 DD 5D F4 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B 7D 0E 8B 55 08 59 89 45 FC 59 B9 F0 7F 00 00 8B C7 66 23 C1 66 3B C1 74 0B 8B 45 16 66 23 C1 66 3B C1 75 74 B8 F8 7F 00 00 23 F8 66 3B F9 BB FF FF 07 00 75 09 85 5D 0C 75 19 85 D2 75 15 8B 75 16 23 F0 66 3B F1 75 39 85 5D 14 75 06 83 7D 10 00 74 2E FF 75 FC DD 45 08 DC 45 10 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 6A 08 E8 ?? ?? ?? ?? 83 C4 24 E9 F0 01 00 00 66 3B F8 0F 84 CA 01 00 00 66 3B F0 0F 84 C1 01 00 00 BE FF FF 00 00 DD 45 08 D9 C0 DD 45 10 DD E1 DF E0 DD D9 F6 C4 44 7A 17 56 DD D9 FF 75 FC DD D8 E8 ?? ?? ?? ?? DD 45 08 59 59 E9 AF 01 00 00 D9 EE D9 C0 DD EB DF E0 F6 C4 44 7A 21 D9 C9 C7 45 F4 01 00 00 00 D8 D2 DF E0 F6 C4 41 75 06 83 65 F8 00 EB 07 C7 45 F8 00 00 00 80 D9 C9 D8 D2 DF E0 F6 C4 05 7A 0D D9 C9 D8 D2 DF E0 F6 C4 05 7B 16 D9 C9 D8 D2 DF E0 F6 C4 41 75 29 D9 C9 D8 D2 DF E0 F6 C4 41 75 1C 85 D2 DD D9 8B 45 0C DD D9 8D 7A FF DD D8 89 7D F4 89 45 F8 75 52 48 89 45 F8 EB 4C D9 C9 D8 D2 DF E0 F6 C4 05 7A 0D D9 C9 D8 D2 DF E0 F6 C4 41 74 16 D9 C9 D8 DA DF E0 F6 C4 41 75 24 DE D9 DF E0 F6 C4 05 7A 1F EB 06 DD D9 DD D9 DD D8 8B 45 0C 8D 7A 01 85 FF 89 7D F4 89 45 F8 75 0A 40 EB B6 DD D9 DD D8 8B 7D F4 8B 45 F8 8B D0 C1 EA 10 66 85 D1 75 55 A9 FF FF 0F 00 75 04 85 FF 74 4A DD 45 F4 8D 45 F8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 F8 83 C4 0C 05 00 06 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C FF 75 FC 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 6A 12 E9 90 FE FF FF 3D 00 00 F0 7F 75 04 85 FF 74 0B 3D 00 00 F0 FF 75 4E 85 FF 75 4A DD 45 F4 8D 45 F8 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 45 F8 83 C4 0C 05 00 FA FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C FF 75 FC 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 6A 11 E9 30 FE FF FF 56 FF 75 FC E8 ?? ?? ?? ?? DD 45 F4 59 59 EB 1D FF 75 FC DD 45 10 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 6A 26 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_184_5_0 {
	meta:
		name = "__finite"
		size = 21
	strings:
		$1 = { 66 8B 44 24 0A 66 25 F0 7F 33 C9 66 3D F0 7F 0F 95 C1 8B C1 C3 }
	condition:
		$1
}

rule file_184_6_0 {
	meta:
		name = "__isnan"
		size = 46
	strings:
		$1 = { 8B 44 24 0A B9 F8 7F 00 00 23 C1 66 3D F0 7F 75 11 F7 44 24 08 FF FF 07 00 75 0C 83 7C 24 04 00 75 05 66 3B C1 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_184_7_0 {
	meta:
		name = "__fpclass"
		size = 148
		refs = "001d __sptype"
	strings:
		$1 = { 55 8B EC 8B 45 0E B9 F0 7F 00 00 8B D0 23 D1 66 3B D1 75 2D DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 48 59 59 74 14 48 74 0C 48 74 05 33 C0 40 5D C3 6A 02 EB 02 6A 04 58 5D C3 B8 00 02 00 00 5D C3 25 00 80 00 00 66 85 D2 8B C8 75 1D F7 45 0C FF FF 0F 00 75 06 83 7D 08 00 74 0E F7 D8 1B C0 83 E0 90 05 80 00 00 00 5D C3 D9 EE DC 5D 08 DF E0 F6 C4 44 8B C1 7A 0C F7 D8 1B C0 83 E0 E0 83 C0 40 5D C3 F7 D8 1B C0 25 08 FF FF FF 05 00 01 00 00 5D C3 }
	condition:
		$1
}

rule file_185_3_0 {
	meta:
		name = "_write_char"
		size = 37
		refs = "0012 __fputwc_nolock"
	strings:
		$1 = { F6 40 0C 40 74 06 83 78 08 00 74 16 50 FF 74 24 08 E8 ?? ?? ?? ?? 66 3D FF FF 59 59 75 04 83 0E FF C3 FF 06 C3 }
	condition:
		$1
}

rule file_185_4_0 {
	meta:
		name = "_write_multi_char"
		size = 37
		refs = "0012 _write_char"
	strings:
		$1 = { 55 8B EC 56 8B F0 EB 14 FF 75 08 8B 45 10 FF 4D 0C E8 ?? ?? ?? ?? 83 3E FF 59 74 06 83 7D 0C 00 7F E6 5E 5D C3 }
	condition:
		$1
}

rule file_185_5_0 {
	meta:
		name = "_write_string"
		size = 79
		refs = "0025 _write_char 0032 __errno"
	strings:
		$1 = { F6 47 0C 40 53 56 8B F0 8B D9 74 39 83 7F 08 00 75 33 8B 44 24 0C 01 06 EB 32 0F B7 03 FF 4C 24 0C 50 8B C7 E8 ?? ?? ?? ?? 43 43 83 3E FF 59 75 14 E8 ?? ?? ?? ?? 83 38 2A 75 11 6A 3F 8B C7 E8 ?? ?? ?? ?? 59 83 7C 24 0C 00 7F CE 5E 5B C3 }
	condition:
		$1
}

rule file_185_8_0 {
	meta:
		name = "__woutput_s_l"
		size = 2336
		refs = "000f ___security_cookie 0057 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0060 __errno 0072 __invalid_parameter 00e3 ___lookuptable_s 0115 $LN267 02d3 _write_char 038d ___nullstring 03b6 __isleadbyte_l 0422 __mbtowc_l 0487 _strlen 04e0 __get_printf_count_output 055d __malloc_crt 05a9 __cfltcvt_tab 05ae __decode_pointer 071b __aulldvrm 0769 ___wnullstring 07e8 _write_multi_char 07fc _write_string 08a4 _free 08f1 @__security_check_cookie@4 0900 $NORMAL_STATE$25883 0904 $LN132 0908 $LN131 090c $LN123 0910 $LN119 0914 $LN118 0918 $LN114 091c $LN98"
	strings:
		$1 = { 55 8D AC 24 0C FC FF FF 81 EC 74 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 F0 03 00 00 53 8B 9D 08 04 00 00 56 8B B5 FC 03 00 00 33 C0 57 FF B5 04 04 00 00 8B BD 00 04 00 00 8D 4D A8 89 75 B8 89 5D DC 89 45 A0 89 45 EC 89 45 C8 89 45 E8 89 45 D0 89 45 A4 89 45 CC E8 ?? ?? ?? ?? 85 F6 75 2F E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 80 7D B4 00 74 07 8B 45 B0 83 60 70 FD 83 C8 FF E9 57 08 00 00 33 F6 3B FE 75 12 E8 ?? ?? ?? ?? 56 56 56 56 C7 00 16 00 00 00 56 EB CB 0F B7 0F 66 3B CE 89 75 D4 89 75 E0 89 75 C0 89 75 9C 89 4D D8 0F 84 14 08 00 00 6A 02 5E 03 FE 33 C0 39 45 D4 89 7D 94 0F 8C F1 07 00 00 8D 51 E0 66 83 FA 58 77 0D 0F B7 C1 0F B6 80 ?? ?? ?? ?? 83 E0 0F 8B 55 C0 6B C0 09 0F B6 84 10 ?? ?? ?? ?? 6A 08 C1 E8 04 5A 3B C2 89 45 C0 0F 84 56 FF FF FF 83 F8 07 0F 87 9B 07 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 4D E8 FF 89 45 98 89 45 A4 89 45 C8 89 45 D0 89 45 EC 89 45 CC E9 7D 07 00 00 0F B7 C1 83 E8 20 74 3C 83 E8 03 74 2B 2B C2 74 1E 2B C6 74 11 83 E8 03 0F 85 59 07 00 00 09 55 EC E9 57 07 00 00 83 4D EC 04 E9 4E 07 00 00 83 4D EC 01 E9 45 07 00 00 81 4D EC 80 00 00 00 E9 39 07 00 00 09 75 EC E9 31 07 00 00 66 83 F9 2A 75 1F 8B 03 83 C3 04 85 C0 89 5D DC 89 45 C8 0F 8D 18 07 00 00 83 4D EC 04 F7 5D C8 E9 0C 07 00 00 8B 45 C8 6B C0 0A 0F B7 C9 8D 44 08 D0 89 45 C8 E9 F7 06 00 00 83 65 E8 00 E9 EE 06 00 00 66 83 F9 2A 75 1C 8B 03 83 C3 04 85 C0 89 5D DC 89 45 E8 0F 8D D5 06 00 00 83 4D E8 FF E9 CC 06 00 00 8B 45 E8 6B C0 0A 0F B7 C9 8D 44 08 D0 89 45 E8 E9 B7 06 00 00 0F B7 C1 83 F8 49 74 45 83 F8 68 74 37 83 F8 6C 74 15 83 F8 77 0F 85 9C 06 00 00 81 4D EC 00 08 00 00 E9 90 06 00 00 66 83 3F 6C 75 0E 03 FE 81 4D EC 00 10 00 00 E9 7C 06 00 00 83 4D EC 10 E9 73 06 00 00 83 4D EC 20 E9 6A 06 00 00 0F B7 07 66 3D 36 00 75 16 66 83 7F 02 34 75 0F 83 C7 04 81 4D EC 00 80 00 00 E9 4B 06 00 00 66 3D 33 00 75 16 66 83 7F 02 32 75 0F 83 C7 04 81 65 EC FF 7F FF FF E9 2F 06 00 00 66 3D 64 00 0F 84 25 06 00 00 66 3D 69 00 0F 84 1B 06 00 00 66 3D 6F 00 0F 84 11 06 00 00 66 3D 75 00 0F 84 07 06 00 00 66 3D 78 00 0F 84 FD 05 00 00 66 3D 58 00 0F 84 F3 05 00 00 83 65 C0 00 8B 45 B8 51 8D 75 D4 C7 45 CC 01 00 00 00 E8 ?? ?? ?? ?? 59 E9 D6 05 00 00 0F B7 C1 83 F8 64 0F 8F A8 01 00 00 0F 84 1D 02 00 00 83 F8 53 0F 8F D7 00 00 00 74 5F 83 E8 41 74 10 2B C6 74 41 2B C6 74 08 2B C6 0F 85 82 04 00 00 83 C1 20 C7 45 98 01 00 00 00 89 4D D8 83 4D EC 40 83 7D E8 00 8D 75 F0 B8 00 02 00 00 89 75 E4 89 45 E0 0F 8D F8 01 00 00 C7 45 E8 06 00 00 00 E9 3C 02 00 00 66 F7 45 EC 30 08 0F 85 9D 00 00 00 83 4D EC 20 E9 94 00 00 00 66 F7 45 EC 30 08 75 04 83 4D EC 20 8B 7D E8 83 FF FF 75 05 BF FF FF FF 7F 83 C3 04 F6 45 EC 20 89 5D DC 8B 5B FC 89 5D E4 0F 84 DC 03 00 00 85 DB 75 08 A1 ?? ?? ?? ?? 89 45 E4 83 65 E0 00 85 FF 8B 75 E4 0F 8E EE 03 00 00 8A 06 84 C0 0F 84 E4 03 00 00 8D 4D A8 0F B6 C0 51 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 01 46 46 FF 45 E0 39 7D E0 7C D9 E9 C2 03 00 00 83 E8 58 0F 84 3F 02 00 00 2B C6 74 68 83 E8 07 0F 84 37 FF FF FF 2B C6 0F 85 A4 03 00 00 0F B7 03 83 C3 04 33 F6 46 F6 45 EC 20 89 75 CC 89 5D DC 89 45 90 74 2D 88 45 BC 8D 45 A8 50 8B 45 A8 C6 45 BD 00 FF B0 AC 00 00 00 8D 45 BC 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 7D 09 89 75 A4 EB 04 66 89 45 F0 8D 45 F0 89 45 E4 89 75 E0 E9 4D 03 00 00 8B 03 83 C3 04 85 C0 89 5D DC 74 2D 8B 48 04 85 C9 74 26 66 F7 45 EC 00 08 0F BF 00 89 4D E4 74 0F 99 2B C2 C7 45 CC 01 00 00 00 E9 18 03 00 00 83 65 CC 00 E9 11 03 00 00 A1 ?? ?? ?? ?? 89 45 E4 50 E8 ?? ?? ?? ?? 59 E9 FD 02 00 00 83 F8 70 0F 8F 86 01 00 00 0F 84 74 01 00 00 83 F8 65 0F 8C E8 02 00 00 83 F8 67 0F 8E 6A FE FF FF 83 F8 69 74 55 83 F8 6E 74 1B 83 F8 6F 0F 85 CC 02 00 00 F6 45 EC 80 89 55 D8 74 49 81 4D EC 00 02 00 00 EB 40 8B 33 83 C3 04 89 5D DC E8 ?? ?? ?? ?? 85 C0 0F 84 73 FB FF FF F6 45 EC 20 74 09 66 8B 45 D4 66 89 06 EB 05 8B 45 D4 89 06 C7 45 A4 01 00 00 00 E9 8E 03 00 00 83 4D EC 40 C7 45 D8 0A 00 00 00 66 F7 45 EC 00 80 0F 84 47 01 00 00 03 DA 8B 43 F8 8B 53 FC E9 73 01 00 00 75 0F 66 83 F9 67 75 48 C7 45 E8 01 00 00 00 EB 3F 39 45 E8 7E 03 89 45 E8 81 7D E8 A3 00 00 00 7E 2E 8B 7D E8 81 C7 5D 01 00 00 57 E8 ?? ?? ?? ?? 85 C0 59 8B 4D D8 6A 08 89 45 9C 5A 74 0A 89 45 E4 89 7D E0 8B F0 EB 07 C7 45 E8 A3 00 00 00 03 DA 8B 43 F8 89 45 88 8B 43 FC 89 45 8C 8D 45 A8 50 FF 75 98 0F BE C1 FF 75 E8 89 5D DC 50 FF 75 E0 8D 45 88 56 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 8B 5D EC 83 C4 1C 81 E3 80 00 00 00 74 1B 83 7D E8 00 75 15 8D 45 A8 50 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 66 83 7D D8 67 75 19 85 DB 75 15 8D 45 A8 50 56 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 3E 2D 75 0B 81 4D EC 00 01 00 00 46 89 75 E4 56 E9 72 FE FF FF 89 55 E8 C7 45 A0 07 00 00 00 EB 21 83 E8 73 0F 84 3C FD FF FF 2B C6 0F 84 DF FE FF FF 83 E8 03 0F 85 57 01 00 00 C7 45 A0 27 00 00 00 F6 45 EC 80 C7 45 D8 10 00 00 00 0F 84 C5 FE FF FF 8B 45 A0 83 C0 51 66 C7 45 C4 30 00 66 89 45 C6 89 75 D0 E9 AD FE FF FF 66 F7 45 EC 00 10 0F 85 AD FE FF FF 83 C3 04 F6 45 EC 20 74 16 F6 45 EC 40 89 5D DC 74 06 0F BF 43 FC EB 04 0F B7 43 FC 99 EB 11 F6 45 EC 40 8B 43 FC 74 03 99 EB 02 33 D2 89 5D DC F6 45 EC 40 74 18 85 D2 7F 14 7C 04 85 C0 73 0E F7 D8 83 D2 00 F7 DA 81 4D EC 00 01 00 00 66 F7 45 EC 00 90 8B DA 8B F8 75 02 33 DB 83 7D E8 00 7D 09 C7 45 E8 01 00 00 00 EB 11 83 65 EC F7 B8 00 02 00 00 39 45 E8 7E 03 89 45 E8 8B C7 0B C3 75 04 83 65 D0 00 8D B5 EF 01 00 00 8B 45 E8 FF 4D E8 85 C0 7F 06 8B C7 0B C3 74 24 8B 45 D8 99 52 50 53 57 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 5D 84 8B F8 8B DA 7E 03 03 4D A0 88 0E 4E EB CC 8D 85 EF 01 00 00 2B C6 46 66 F7 45 EC 00 02 89 45 E0 89 75 E4 74 44 85 C0 74 07 8B CE 80 39 30 74 39 FF 4D E4 8B 4D E4 C6 01 30 40 EB 2A 85 DB 75 08 A1 ?? ?? ?? ?? 89 45 E4 8B 45 E4 C7 45 CC 01 00 00 00 EB 09 4F 66 83 38 00 74 06 03 C6 85 FF 75 F3 2B 45 E4 D1 F8 89 45 E0 83 7D A4 00 0F 85 FF 00 00 00 8B 45 EC A8 40 74 2B 66 A9 00 01 74 08 66 C7 45 C4 2D 00 EB 16 A8 01 74 08 66 C7 45 C4 2B 00 EB 0A A8 02 74 0D 66 C7 45 C4 20 00 C7 45 D0 01 00 00 00 8B 5D C8 8B 75 E0 2B DE 2B 5D D0 F6 45 EC 0C 75 11 FF 75 B8 8D 45 D4 53 6A 20 E8 ?? ?? ?? ?? 83 C4 0C FF 75 D0 8B 7D B8 8D 45 D4 8D 4D C4 E8 ?? ?? ?? ?? F6 45 EC 08 59 74 15 F6 45 EC 04 75 0F 57 53 6A 30 8D 45 D4 E8 ?? ?? ?? ?? 83 C4 0C 83 7D CC 00 75 4E 85 F6 7E 4A 8B 7D E4 89 75 D8 FF 4D D8 8D 45 A8 50 8B 45 A8 FF B0 AC 00 00 00 8D 45 90 57 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 89 45 84 7E 1A FF 75 90 8B 45 B8 8D 75 D4 E8 ?? ?? ?? ?? 03 7D 84 83 7D D8 00 59 7F C4 EB 13 83 4D D4 FF EB 0D 8B 4D E4 56 8D 45 D4 E8 ?? ?? ?? ?? 59 83 7D D4 00 7C 17 F6 45 EC 04 74 11 FF 75 B8 8D 45 D4 53 6A 20 E8 ?? ?? ?? ?? 83 C4 0C 83 7D 9C 00 74 0D FF 75 9C E8 ?? ?? ?? ?? 83 65 9C 00 59 8B 7D 94 8B 5D DC 0F B7 07 66 85 C0 89 45 D8 74 07 8B C8 E9 FC F7 FF FF 83 7D C0 00 74 0A 83 7D C0 07 0F 85 8A F7 FF FF 80 7D B4 00 74 07 8B 45 B0 83 60 70 FD 8B 45 D4 8B 8D F0 03 00 00 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 81 C5 F4 03 00 00 C9 C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_186_3_0 {
	meta:
		name = "__ismbcl0_l"
		size = 87
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 29 8B 4D 08 C1 E9 08 0F B6 C9 F6 44 01 1D 04 74 19 0F B6 4D 08 F6 44 01 1D 08 74 0E 81 7D 08 9F 88 00 00 73 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_186_5_0 {
	meta:
		name = "__ismbcl1_l"
		size = 93
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 2F 8B 4D 08 8B D1 C1 EA 08 0F B6 D2 F6 44 02 1D 04 74 1D 0F B6 D1 F6 44 02 1D 08 74 13 81 C1 61 77 FF FF 81 F9 D3 0F 00 00 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_186_7_0 {
	meta:
		name = "__ismbcl2_l"
		size = 93
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 2F 8B 4D 08 8B D1 C1 EA 08 0F B6 D2 F6 44 02 1D 04 74 1D 0F B6 D1 F6 44 02 1D 08 74 13 81 C1 61 67 FF FF 81 F9 05 52 00 00 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "__putw"
		size = 177
		refs = "0003 __sehtable$__putw 0008 __SEH_prolog4 0027 __errno 0037 __invalid_parameter 0048 __lock_file 006f __flsbuf 007d _ferror 00a1 __SEH_epilog4 00ab __unlock_file"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 E4 04 00 00 00 8D 7D 08 33 C0 8B 75 0C 33 DB 3B F3 0F 95 C0 3B C3 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5D 89 75 0C 56 E8 ?? ?? ?? ?? 59 89 5D FC 8B 45 E4 FF 4D E4 85 C0 74 21 FF 4E 04 78 0A 8B 06 8A 0F 88 08 FF 06 EB 0C 56 0F BE 07 50 E8 ?? ?? ?? ?? 59 59 47 89 7D DC EB D5 56 E8 ?? ?? ?? ?? 59 85 C0 74 05 83 C8 FF EB 03 8B 45 08 89 45 E0 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_189_1_0 {
	meta:
		name = "___getlocaleinfo"
		size = 346
		refs = "000c ___security_cookie 0047 ___crtGetLocaleInfoA 0056 __imp__GetLastError@0 0080 __calloc_crt 00c5 _free 00d6 @__security_check_cookie@4 00e7 _strncpy_s 00f8 __invoke_watson 0118 ?wcbuffer@?4??__getlocaleinfo@@9@9 0125 ___crtGetLocaleInfoW 0139 _isdigit"
	strings:
		$1 = { 55 8D 6C 24 9C 81 EC 94 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 60 8B 45 6C 53 56 8B 75 7C 33 DB 83 7D 70 01 57 89 45 D8 89 75 D0 0F 85 DF 00 00 00 53 68 80 00 00 00 8D 7D E0 8B CF 51 FF 75 78 89 5D DC FF 75 74 50 E8 ?? ?? ?? ?? 8B F0 83 C4 18 3B F3 75 57 FF 15 ?? ?? ?? ?? 83 F8 7A 75 6B 53 53 53 FF 75 78 FF 75 74 FF 75 D8 E8 ?? ?? ?? ?? 83 C4 18 3B C3 89 45 D4 74 50 33 F6 46 56 50 E8 ?? ?? ?? ?? 8B F8 3B FB 59 59 74 3E 53 FF 75 D4 89 75 DC 57 FF 75 78 FF 75 74 FF 75 D8 E8 ?? ?? ?? ?? 8B F0 83 C4 18 3B F3 74 18 6A 01 56 E8 ?? ?? ?? ?? 3B C3 59 59 8B 4D D0 89 01 75 21 39 5D DC 74 07 57 E8 ?? ?? ?? ?? 59 83 C8 FF 8B 4D 60 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 83 C5 64 C9 C3 8D 4E FF 51 57 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 39 5D DC 74 07 57 E8 ?? ?? ?? ?? 59 33 C0 EB BE 39 5D 70 75 B6 53 6A 04 BF ?? ?? ?? ?? 57 FF 75 78 FF 75 74 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 9A 88 1E 8A 1F 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 C9 8A 06 B1 0A F6 E9 02 C3 2C 30 47 47 81 FF ?? ?? ?? ?? 88 06 7C DA EB B1 }
	condition:
		$1
}

rule file_191_3_0 {
	meta:
		name = "_write_char"
		size = 51
		refs = "0022 __flsbuf"
	strings:
		$1 = { F6 41 0C 40 74 06 83 79 08 00 74 24 FF 49 04 78 0B 8B 11 88 02 FF 01 0F B6 C0 EB 0C 0F BE C0 51 50 E8 ?? ?? ?? ?? 59 59 83 F8 FF 75 03 09 06 C3 FF 06 C3 }
	condition:
		$1
}

rule file_191_4_0 {
	meta:
		name = "_write_multi_char"
		size = 36
		refs = "0012 _write_char"
	strings:
		$1 = { 55 8B EC 56 8B F0 EB 13 8B 4D 10 8A 45 08 FF 4D 0C E8 ?? ?? ?? ?? 83 3E FF 74 06 83 7D 0C 00 7F E7 5E 5D C3 }
	condition:
		$1
}

rule file_191_5_0 {
	meta:
		name = "_write_string"
		size = 74
		refs = "0023 _write_char 002e __errno"
	strings:
		$1 = { F6 47 0C 40 53 56 8B F0 8B D9 74 34 83 7F 08 00 75 2E 8B 44 24 0C 01 06 EB 2D 8A 03 FF 4C 24 0C 8B CF E8 ?? ?? ?? ?? 43 83 3E FF 75 13 E8 ?? ?? ?? ?? 83 38 2A 75 10 8B CF B0 3F E8 ?? ?? ?? ?? 83 7C 24 0C 00 7F D3 5E 5B C3 }
	condition:
		$1
}

rule file_191_9_0 {
	meta:
		name = "__output_s_l"
		size = 2480
		refs = "000f ___security_cookie 0057 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0061 __errno 0071 __invalid_parameter 009c __fileno 00c5 ___pioinfo 00dd ___badioinfo 017e ___lookuptable_s 01b2 $LN278 035e __isleadbyte_l 0372 _write_char 0445 ___wnullstring 0499 _wctomb_s 0501 ___nullstring 050a _strlen 0563 __get_printf_count_output 05df __malloc_crt 062b __cfltcvt_tab 0630 __decode_pointer 0793 __aulldvrm 0861 _write_multi_char 0875 _write_string 0921 _free 0984 @__security_check_cookie@4 0990 $NORMAL_STATE$25383 0994 $LN131 0998 $LN130 099c $LN122 09a0 $LN118 09a4 $LN117 09a8 $LN113 09ac $LN97"
	strings:
		$1 = { 55 8D AC 24 08 FE FF FF 81 EC 78 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 F4 01 00 00 8B 85 00 02 00 00 53 8B 9D 04 02 00 00 56 33 F6 57 8B BD 0C 02 00 00 FF B5 08 02 00 00 8D 4D A4 89 45 D0 89 7D D4 89 75 9C 89 75 E8 89 75 C0 89 75 E0 89 75 C4 89 75 98 89 75 BC E8 ?? ?? ?? ?? 39 75 D0 75 2D E8 ?? ?? ?? ?? 56 56 56 56 C7 00 16 00 00 00 56 E8 ?? ?? ?? ?? 83 C4 14 80 7D B0 00 74 07 8B 45 AC 83 60 70 FD 83 C8 FF E9 EB 08 00 00 8B 45 D0 F6 40 0C 40 0F 85 A4 00 00 00 50 E8 ?? ?? ?? ?? 83 F8 FF 59 74 36 FF 75 D0 E8 ?? ?? ?? ?? 83 F8 FE 59 74 28 FF 75 D0 E8 ?? ?? ?? ?? FF 75 D0 C1 F8 05 8D 34 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 1F 6B C0 28 03 06 59 59 33 F6 EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 0F 85 75 FF FF FF FF 75 D0 E8 ?? ?? ?? ?? 83 F8 FF 59 74 36 FF 75 D0 E8 ?? ?? ?? ?? 83 F8 FE 59 74 28 FF 75 D0 E8 ?? ?? ?? ?? FF 75 D0 C1 F8 05 8D 34 85 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 E0 1F 6B C0 28 03 06 59 59 33 F6 EB 05 B8 ?? ?? ?? ?? F6 40 24 80 0F 85 22 FF FF FF 3B DE 0F 84 1A FF FF FF 8A 13 84 D2 89 75 CC 89 75 D8 89 75 B8 89 75 A0 88 55 E7 0F 84 09 08 00 00 43 33 C0 39 45 CC 89 5D B4 0F 8C E9 07 00 00 8A CA 80 E9 20 80 F9 58 77 0D 0F BE C2 0F B6 80 ?? ?? ?? ?? 83 E0 0F 8B 4D B8 6B C0 09 0F B6 84 08 ?? ?? ?? ?? 6A 08 C1 E8 04 5E 3B C6 89 45 B8 0F 84 9C 07 00 00 6A 07 59 3B C1 0F 87 7B 07 00 00 FF 24 85 ?? ?? ?? ?? 33 C0 83 4D E0 FF 89 45 8C 89 45 98 89 45 C0 89 45 C4 89 45 E8 89 45 BC E9 57 07 00 00 0F BE C2 83 E8 20 74 3C 83 E8 03 74 2B 2B C6 74 1E 48 48 74 11 83 E8 03 0F 85 39 07 00 00 09 75 E8 E9 31 07 00 00 83 4D E8 04 E9 28 07 00 00 83 4D E8 01 E9 1F 07 00 00 81 4D E8 80 00 00 00 E9 13 07 00 00 83 4D E8 02 E9 0A 07 00 00 80 FA 2A 75 20 83 C7 04 89 7D D4 8B 7F FC 85 FF 89 7D C0 0F 8D F1 06 00 00 83 4D E8 04 F7 5D C0 E9 E5 06 00 00 8B 45 C0 6B C0 0A 0F BE CA 8D 44 08 D0 89 45 C0 E9 D0 06 00 00 83 65 E0 00 E9 C7 06 00 00 80 FA 2A 75 1D 83 C7 04 89 7D D4 8B 7F FC 85 FF 89 7D E0 0F 8D AE 06 00 00 83 4D E0 FF E9 A5 06 00 00 8B 45 E0 6B C0 0A 0F BE CA 8D 44 08 D0 89 45 E0 E9 90 06 00 00 80 FA 49 74 46 80 FA 68 74 38 80 FA 6C 74 15 80 FA 77 0F 85 78 06 00 00 81 4D E8 00 08 00 00 E9 6C 06 00 00 80 3B 6C 75 10 43 81 4D E8 00 10 00 00 89 5D B4 E9 57 06 00 00 83 4D E8 10 E9 4E 06 00 00 83 4D E8 20 E9 45 06 00 00 8A 03 3C 36 75 17 80 7B 01 34 75 11 43 43 81 4D E8 00 80 00 00 89 5D B4 E9 28 06 00 00 3C 33 75 17 80 7B 01 32 75 11 43 43 81 65 E8 FF 7F FF FF 89 5D B4 E9 0D 06 00 00 3C 64 0F 84 05 06 00 00 3C 69 0F 84 FD 05 00 00 3C 6F 0F 84 F5 05 00 00 3C 75 0F 84 ED 05 00 00 3C 78 0F 84 E5 05 00 00 3C 58 0F 84 DD 05 00 00 83 65 B8 00 83 65 BC 00 8D 45 A4 50 0F B6 C2 50 E8 ?? ?? ?? ?? 59 85 C0 8A 45 E7 59 74 19 8B 4D D0 8D 75 CC E8 ?? ?? ?? ?? 8A 03 43 84 C0 89 5D B4 0F 84 BC 05 00 00 8B 4D D0 8D 75 CC E8 ?? ?? ?? ?? E9 96 05 00 00 0F BE C2 83 F8 64 0F 8F 74 01 00 00 0F 84 E9 01 00 00 83 F8 53 0F 8F AC 00 00 00 74 5B 83 E8 41 74 10 48 48 74 41 48 48 74 08 48 48 0F 85 4C 04 00 00 80 C2 20 C7 45 8C 01 00 00 00 88 55 E7 83 4D E8 40 83 7D E0 00 8D 5D EC B8 00 02 00 00 89 5D DC 89 45 94 0F 8D C4 01 00 00 C7 45 E0 06 00 00 00 E9 07 02 00 00 66 F7 45 E8 30 08 75 75 81 4D E8 00 08 00 00 EB 6C 66 F7 45 E8 30 08 75 07 81 4D E8 00 08 00 00 8B 4D E0 83 F9 FF 75 05 B9 FF FF FF 7F 83 C7 04 66 F7 45 E8 10 08 89 7D D4 8B 7F FC 89 7D DC 0F 84 B0 03 00 00 85 FF 75 08 A1 ?? ?? ?? ?? 89 45 DC 8B 45 DC C7 45 BC 01 00 00 00 E9 8A 03 00 00 83 E8 58 0F 84 34 02 00 00 48 48 74 5D 2B C1 0F 84 63 FF FF FF 48 48 0F 85 9A 03 00 00 83 C7 04 66 F7 45 E8 10 08 89 7D D4 74 27 0F B7 47 FC 50 68 00 02 00 00 8D 45 EC 50 8D 45 D8 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 16 C7 45 98 01 00 00 00 EB 0D 8A 47 FC 88 45 EC C7 45 D8 01 00 00 00 8D 45 EC 89 45 DC E9 4D 03 00 00 8B 07 83 C7 04 85 C0 89 7D D4 74 2F 8B 48 04 85 C9 74 28 66 F7 45 E8 00 08 0F BF 00 89 4D DC 74 11 99 2B C2 D1 F8 C7 45 BC 01 00 00 00 E9 18 03 00 00 83 65 BC 00 E9 0F 03 00 00 A1 ?? ?? ?? ?? 89 45 DC 50 E8 ?? ?? ?? ?? 59 E9 FB 02 00 00 83 F8 70 0F 8F 80 01 00 00 0F 84 72 01 00 00 83 F8 65 0F 8C E6 02 00 00 83 F8 67 0F 8E 9E FE FF FF 83 F8 69 74 55 83 F8 6E 74 1B 83 F8 6F 0F 85 CA 02 00 00 F6 45 E8 80 89 75 D8 74 49 81 4D E8 00 02 00 00 EB 40 8B 37 83 C7 04 89 7D D4 E8 ?? ?? ?? ?? 85 C0 0F 84 D1 03 00 00 F6 45 E8 20 74 09 66 8B 45 CC 66 89 06 EB 05 8B 45 CC 89 06 C7 45 98 01 00 00 00 E9 88 03 00 00 83 4D E8 40 C7 45 D8 0A 00 00 00 8B 4D E8 66 85 C9 0F 89 41 01 00 00 03 FE 8B 47 F8 8B 57 FC E9 69 01 00 00 75 0E 80 FA 67 75 48 C7 45 E0 01 00 00 00 EB 3F 39 45 E0 7E 03 89 45 E0 81 7D E0 A3 00 00 00 7E 2E 8B 75 E0 81 C6 5D 01 00 00 56 E8 ?? ?? ?? ?? 85 C0 8A 55 E7 59 89 45 A0 6A 08 74 0A 89 45 DC 89 75 94 8B D8 EB 07 C7 45 E0 A3 00 00 00 5E 03 FE 8B 47 F8 89 45 80 8B 47 FC 89 45 84 8D 45 A4 50 FF 75 8C 0F BE C2 FF 75 E0 89 7D D4 50 FF 75 94 8D 45 80 53 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 8B 7D E8 83 C4 1C 81 E7 80 00 00 00 74 1B 83 7D E0 00 75 15 8D 45 A4 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 7D E7 67 75 19 85 FF 75 15 8D 45 A4 50 53 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 59 59 80 3B 2D 75 0B 81 4D E8 00 01 00 00 43 89 5D DC 53 E9 74 FE FF FF 89 75 E0 89 4D 9C EB 21 83 E8 73 0F 84 75 FD FF FF 48 48 0F 84 E5 FE FF FF 83 E8 03 0F 85 5B 01 00 00 C7 45 9C 27 00 00 00 F6 45 E8 80 C7 45 D8 10 00 00 00 0F 84 CB FE FF FF 8A 45 9C 04 51 C6 45 C8 30 88 45 C9 C7 45 C4 02 00 00 00 E9 B3 FE FF FF 66 F7 C1 00 10 0F 85 B4 FE FF FF 83 C7 04 F6 C1 20 74 15 F6 C1 40 89 7D D4 74 06 0F BF 47 FC EB 04 0F B7 47 FC 99 EB 10 F6 C1 40 8B 47 FC 74 03 99 EB 02 33 D2 89 7D D4 F6 C1 40 74 18 85 D2 7F 14 7C 04 85 C0 73 0E F7 D8 83 D2 00 F7 DA 81 4D E8 00 01 00 00 66 F7 45 E8 00 90 8B DA 8B F8 75 02 33 DB 83 7D E0 00 7D 09 C7 45 E0 01 00 00 00 EB 11 83 65 E8 F7 B8 00 02 00 00 39 45 E0 7E 03 89 45 E0 8B C7 0B C3 75 04 83 65 C4 00 8D B5 EB 01 00 00 8B 45 E0 FF 4D E0 85 C0 7F 06 8B C7 0B C3 74 24 8B 45 D8 99 52 50 53 57 E8 ?? ?? ?? ?? 83 C1 30 83 F9 39 89 5D 94 8B F8 8B DA 7E 03 03 4D 9C 88 0E 4E EB CC 8D 85 EB 01 00 00 2B C6 46 66 F7 45 E8 00 02 89 45 D8 89 75 DC 74 4D 85 C0 74 07 8B CE 80 39 30 74 42 FF 4D DC 8B 4D DC C6 01 30 40 EB 33 49 66 83 38 00 74 06 40 40 85 C9 75 F3 2B 45 DC D1 F8 EB 1F 85 FF 75 08 A1 ?? ?? ?? ?? 89 45 DC 8B 45 DC EB 07 49 80 38 00 74 05 40 85 C9 75 F5 2B 45 DC 89 45 D8 83 7D 98 00 0F 85 FB 00 00 00 8B 45 E8 A8 40 74 25 66 A9 00 01 74 06 C6 45 C8 2D EB 12 A8 01 74 06 C6 45 C8 2B EB 08 A8 02 74 0B C6 45 C8 20 C7 45 C4 01 00 00 00 8B 5D C0 2B 5D D8 2B 5D C4 F6 45 E8 0C 75 11 FF 75 D0 8D 45 CC 53 6A 20 E8 ?? ?? ?? ?? 83 C4 0C FF 75 C4 8B 7D D0 8D 45 CC 8D 4D C8 E8 ?? ?? ?? ?? F6 45 E8 08 59 74 15 F6 45 E8 04 75 0F 57 53 6A 30 8D 45 CC E8 ?? ?? ?? ?? 83 C4 0C 83 7D BC 00 8B 45 D8 74 51 85 C0 7E 4D 8B 75 DC 89 45 94 0F B7 06 FF 4D 94 50 6A 06 8D 85 EC 01 00 00 50 8D 45 88 46 50 46 E8 ?? ?? ?? ?? 83 C4 10 85 C0 75 1F 39 45 88 74 1A FF 75 88 8D 45 CC 8D 8D EC 01 00 00 E8 ?? ?? ?? ?? 83 7D 94 00 59 75 C1 EB 13 83 4D CC FF EB 0D 8B 4D DC 50 8D 45 CC E8 ?? ?? ?? ?? 59 83 7D CC 00 7C 15 F6 45 E8 04 74 0F 57 53 6A 20 8D 45 CC E8 ?? ?? ?? ?? 83 C4 0C 83 7D A0 00 74 0D FF 75 A0 E8 ?? ?? ?? ?? 83 65 A0 00 59 8B 5D B4 8A 03 84 C0 88 45 E7 74 21 8B 7D D4 8A D0 E9 1F F8 FF FF E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E9 19 F7 FF FF 33 F6 39 75 B8 74 0A 83 7D B8 07 0F 85 F8 F6 FF FF 80 7D B0 00 74 07 8B 45 AC 83 60 70 FD 8B 45 CC 8B 8D F4 01 00 00 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 81 C5 F8 01 00 00 C9 C3 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_194_2_0 {
	meta:
		name = "___shr_12"
		size = 45
	strings:
		$1 = { 8B 44 24 04 8B 50 08 8B 48 04 56 57 8B F9 8B F2 D1 E9 C1 E6 1F 0B CE 89 48 04 8B 08 C1 E7 1F D1 E9 0B CF D1 EA 5F 89 50 08 89 08 5E C3 }
	condition:
		$1
}

rule file_194_3_0 {
	meta:
		name = "___ld12mul"
		size = 628
		refs = "0007 ___security_cookie 026e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 30 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 0C 0F B7 52 0A 8B 45 08 33 C9 53 56 89 4D E0 89 4D F0 89 4D F4 89 4D F8 0F B7 48 0A 8B F2 BB FF 7F 00 00 33 F1 23 CB 23 D3 57 8D 3C 0A 0F B7 FF 81 E6 00 80 00 00 66 3B CB 89 7D E4 0F 83 F6 01 00 00 66 3B D3 0F 83 ED 01 00 00 66 81 FF FD BF 0F 87 E2 01 00 00 66 81 FF BF 3F 77 0F 33 C9 89 48 08 89 48 04 89 08 E9 E7 01 00 00 66 85 C9 BB FF FF FF 7F 75 1D 47 85 58 08 89 7D E4 75 14 33 C9 39 48 04 75 0D 39 08 75 09 66 89 48 0A E9 C0 01 00 00 66 85 D2 75 17 8B 4D 0C 47 85 59 08 89 7D E4 75 0B 83 79 04 00 75 05 83 39 00 74 AE 83 65 D4 00 8D 5D F4 C7 45 E8 05 00 00 00 8B 4D D4 8B 55 E8 03 C9 85 D2 89 55 D0 7E 56 8B 55 0C 83 C2 08 03 C8 89 55 D8 89 4D DC 8B 4D DC 8B 55 D8 0F B7 12 0F B7 09 83 65 EC 00 0F AF CA 8B 53 FC 8D 3C 0A 3B FA 72 04 3B F9 73 07 C7 45 EC 01 00 00 00 83 7D EC 00 89 7B FC 74 03 66 FF 03 83 45 DC 02 83 6D D8 02 FF 4D D0 83 7D D0 00 7F BB 8B 7D E4 43 43 FF 45 D4 FF 4D E8 83 7D E8 00 7F 8D 81 C7 02 C0 00 00 66 85 FF 7E 3C F7 45 F8 00 00 00 80 75 2E 8B 4D F0 8B 5D F4 8B 55 F4 D1 65 F0 C1 E9 1F 03 DB 0B D9 8B 4D F8 C1 EA 1F 03 C9 0B CA 81 C7 FF FF 00 00 66 85 FF 89 5D F4 89 4D F8 7F C9 66 85 FF 7F 53 81 C7 FF FF 00 00 66 85 FF 7D 48 8B CF F7 D9 0F B7 C9 89 4D EC 03 F9 F6 45 F0 01 74 03 FF 45 E0 8B 4D F8 8B 5D F4 8B 55 F4 D1 6D F8 C1 E1 1F D1 EB 0B D9 8B 4D F0 C1 E2 1F D1 E9 0B CA FF 4D EC 89 5D F4 89 4D F0 75 CF 83 7D E0 00 74 05 66 83 4D F0 01 66 81 7D F0 00 80 77 11 8B 4D F0 81 E1 FF FF 01 00 81 F9 00 80 01 00 75 33 83 7D F2 FF 75 2A 83 65 F2 00 83 7D F6 FF 75 1B 83 65 F6 00 66 81 7D FA FF FF 75 09 66 C7 45 FA 00 80 47 EB 0E 66 FF 45 FA EB 08 FF 45 F6 EB 03 FF 45 F2 66 81 FF FF 7F 73 1B 66 8B 4D F2 66 89 08 8B 4D F4 89 48 02 8B 4D F8 0B FE 89 48 06 66 89 78 0A EB 1B 66 F7 DE 1B F6 83 60 04 00 81 E6 00 00 00 80 81 C6 00 80 FF 7F 83 20 00 89 70 08 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_194_4_0 {
	meta:
		name = "___multtenpow12"
		size = 778
		refs = "0007 ___security_cookie 0015 __pow10pos 0030 __pow10neg 0304 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 44 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 B9 ?? ?? ?? ?? 83 E9 60 33 DB 39 5D 0C 89 4D D8 0F 84 D3 02 00 00 7D 0E F7 5D 0C B9 ?? ?? ?? ?? 83 E9 60 89 4D D8 39 5D 10 75 03 66 89 18 39 5D 0C 0F 84 B2 02 00 00 56 57 8B 4D 0C 83 45 D8 54 C1 7D 0C 03 83 E1 07 3B CB 0F 84 8F 02 00 00 6B C9 0C 03 4D D8 8B F1 66 81 3E 00 80 89 75 CC 72 11 8D 7D E4 A5 A5 8D 4D E4 A5 FF 4D E6 89 4D CC 8B F1 0F B7 7E 0A 0F B7 50 0A 89 5D D0 89 5D F0 89 5D F4 89 5D F8 8B CF BB FF 7F 00 00 33 CA 23 D3 23 FB 8D 1C 17 0F B7 DB 81 E1 00 80 00 00 66 81 FA FF 7F 89 5D E0 0F 83 16 02 00 00 66 81 FF FF 7F 0F 83 0B 02 00 00 66 81 FB FD BF 0F 87 00 02 00 00 66 81 FB BF 3F 77 0A 33 DB 89 58 08 E9 05 02 00 00 33 DB 66 3B D3 75 1E FF 45 E0 F7 40 08 FF FF FF 7F 75 12 39 58 04 75 0D 39 18 75 09 66 89 58 0A E9 E5 01 00 00 66 3B FB 75 15 FF 45 E0 F7 46 08 FF FF FF 7F 75 09 39 5E 04 75 04 39 1E 74 B9 89 5D C8 8D 5D F4 C7 45 DC 05 00 00 00 8B 55 C8 8B 7D DC 03 D2 85 FF 89 7D D4 7E 53 83 C6 08 03 D0 89 75 C0 89 55 C4 8B 55 C4 8B 75 C0 0F B7 36 0F B7 12 8B 7B FC 0F AF D6 83 65 BC 00 8D 34 17 3B F7 72 04 3B F2 73 07 C7 45 BC 01 00 00 00 83 7D BC 00 89 73 FC 74 03 66 FF 03 83 45 C4 02 83 6D C0 02 FF 4D D4 83 7D D4 00 7F BB 8B 75 CC 43 43 FF 45 C8 FF 4D DC 83 7D DC 00 7F 90 81 45 E0 02 C0 00 00 66 83 7D E0 00 7E 40 F7 45 F8 00 00 00 80 75 30 8B 7D F4 8B 55 F0 81 45 E0 FF FF 00 00 D1 65 F0 C1 EA 1F 8B F7 03 FF 0B FA 8B 55 F8 C1 EE 1F 03 D2 0B D6 66 83 7D E0 00 89 7D F4 89 55 F8 7F C7 66 83 7D E0 00 7F 53 81 45 E0 FF FF 00 00 66 83 7D E0 00 7D 45 8B 55 E0 F7 DA 0F B7 DA 01 5D E0 F6 45 F0 01 74 03 FF 45 D0 8B 55 F8 8B 7D F4 8B 75 F4 D1 6D F8 C1 E2 1F D1 EF 0B FA 8B 55 F0 C1 E6 1F D1 EA 0B D6 4B 89 7D F4 89 55 F0 75 D1 83 7D D0 00 74 05 66 83 4D F0 01 66 81 7D F0 00 80 77 11 8B 55 F0 81 E2 FF FF 01 00 81 FA 00 80 01 00 75 35 83 7D F2 FF 75 2C 83 65 F2 00 83 7D F6 FF 75 1D 83 65 F6 00 66 81 7D FA FF FF 75 0B FF 45 E0 66 C7 45 FA 00 80 EB 0E 66 FF 45 FA EB 08 FF 45 F6 EB 03 FF 45 F2 8B 55 E0 66 81 FA FF 7F 72 1F 66 F7 D9 1B C9 83 60 04 00 81 E1 00 00 00 80 81 C1 00 80 FF 7F 83 20 00 89 48 08 33 DB EB 36 66 8B 75 F2 66 89 30 8B 75 F4 89 70 02 8B 75 F8 0B D1 89 70 06 66 89 50 0A EB E1 66 F7 D9 1B C9 81 E1 00 00 00 80 81 C1 00 80 FF 7F 89 48 08 33 DB 89 58 04 89 18 39 5D 0C 0F 85 52 FD FF FF 5F 5E 8B 4D FC 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_194_5_0 {
	meta:
		name = "___strgtold12_l"
		size = 1732
		refs = "0007 ___security_cookie 004a __errno 005a __invalid_parameter 0094 $LN278 0327 ___mtold12 0364 __pow10pos 037b __pow10neg 068b @__security_check_cookie@4 0694 $LN119 0698 $LN108 069c $LN97 06a0 $LN88 06a4 $LN75 06a8 $LN61 06ac $LN58 06b0 $LN43 06b4 $LN49 06b8 $LN36 06bc $LN257 06c0 $LN28"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 33 DB 56 33 F6 89 45 84 8B 45 0C 46 33 C9 39 5D 24 57 89 45 90 8D 7D E0 89 5D 8C 89 75 98 89 5D B4 89 5D A8 89 5D A4 89 5D A0 89 5D 9C 89 5D B0 89 5D 94 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 1A 06 00 00 8B 55 10 89 55 AC 8A 02 3C 20 74 0C 3C 09 74 08 3C 0A 74 04 3C 0D 75 03 42 EB EB B3 30 8A 02 42 83 F9 0B 0F 87 2F 02 00 00 FF 24 8D ?? ?? ?? ?? 8A C8 80 E9 31 80 F9 08 77 06 6A 03 59 4A EB DD 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 75 05 6A 05 59 EB C7 0F BE C0 83 E8 2B 74 1D 48 48 74 0D 83 E8 03 0F 85 8B 01 00 00 8B CE EB AE 6A 02 59 C7 45 8C 00 80 00 00 EB A2 83 65 8C 00 6A 02 59 EB 99 8A C8 80 E9 31 80 F9 08 89 75 A8 76 A9 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 75 04 6A 04 EB AD 3C 2B 74 28 3C 2D 74 24 3A C3 74 B9 3C 43 0F 8E 3C 01 00 00 3C 45 7E 10 3C 63 0F 8E 30 01 00 00 3C 65 0F 8F 28 01 00 00 6A 06 EB 81 4A 6A 0B E9 79 FF FF FF 8A C8 80 E9 31 80 F9 08 0F 86 52 FF FF FF 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 0F 84 54 FF FF FF 3A C3 0F 84 66 FF FF FF 8B 55 AC E9 14 01 00 00 89 75 A8 EB 1A 3C 39 7F 1A 83 7D B4 19 73 0A FF 45 B4 2A C3 88 07 47 EB 03 FF 45 B0 8A 02 42 3A C3 7D E2 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 3A 01 0F 84 5D FF FF FF 3C 2B 74 89 3C 2D 74 85 E9 60 FF FF FF 83 7D B4 00 89 75 A8 89 75 A4 75 26 EB 06 FF 4D B0 8A 02 42 3A C3 74 F6 EB 18 3C 39 7F D5 83 7D B4 19 73 0B FF 45 B4 2A C3 88 07 47 FF 4D B0 8A 02 42 3A C3 7D E4 EB BB 2A C3 3C 09 89 75 A4 0F 87 6E FF FF FF 6A 04 E9 9E FE FF FF 8D 4A FE 89 4D AC 8A C8 80 E9 31 80 F9 08 77 07 6A 09 E9 87 FE FF FF 0F BE C0 83 E8 2B 74 20 48 48 74 10 83 E8 03 0F 85 3B FF FF FF 6A 08 E9 82 FE FF FF 83 4D 98 FF 6A 07 59 E9 40 FE FF FF 6A 07 E9 6F FE FF FF 89 75 A0 EB 03 8A 02 42 3A C3 74 F9 2C 31 3C 08 76 B8 4A EB 28 8A C8 80 E9 31 80 F9 08 76 AB 3A C3 EB BD 83 7D 20 00 74 47 0F BE C0 83 E8 2B 8D 4A FF 89 4D AC 74 C2 48 48 74 B2 8B D1 83 7D A8 00 8B 45 90 89 10 0F 84 A5 03 00 00 6A 18 58 39 45 B4 76 10 80 7D F7 05 7C 03 FE 45 F7 4F FF 45 B0 89 45 B4 83 7D B4 00 0F 86 AA 03 00 00 EB 59 6A 0A 59 4A 83 F9 0A 0F 85 BC FD FF FF EB BE 89 75 A0 33 C9 EB 19 3C 39 7F 20 6B C9 0A 0F BE F0 8D 4C 31 D0 81 F9 50 14 00 00 7F 09 8A 02 42 3A C3 7D E3 EB 05 B9 51 14 00 00 89 4D 9C EB 0B 3C 39 0F 8F 5B FF FF FF 8A 02 42 3A C3 7D F1 E9 4F FF FF FF FF 4D B4 FF 45 B0 4F 80 3F 00 74 F4 8D 45 C4 50 FF 75 B4 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 45 9C 33 C9 83 C4 0C 39 4D 98 7D 02 F7 D8 03 45 B0 39 4D A0 75 03 03 45 18 39 4D A4 75 03 2B 45 1C 3D 50 14 00 00 0F 8F EE 02 00 00 3D B0 EB FF FF 0F 8C FA 02 00 00 BE ?? ?? ?? ?? 83 EE 60 3B C1 89 45 AC 0F 84 B5 02 00 00 7D 0D F7 D8 BE ?? ?? ?? ?? 89 45 AC 83 EE 60 39 4D 14 75 04 66 89 4D C4 39 4D AC 0F 84 94 02 00 00 8B 45 AC C1 7D AC 03 83 C6 54 83 E0 07 85 C0 89 75 B4 0F 84 72 02 00 00 6B C0 0C 03 C6 8B D8 66 81 3B 00 80 89 5D 90 72 14 8B F3 8D 7D B8 A5 A5 A5 FF 4D BA 8B 75 B4 8D 5D B8 89 5D 90 0F B7 53 0A 8B 4D CE 33 C0 89 45 B0 89 45 D4 89 45 D8 89 45 DC 8B C2 BF FF 7F 00 00 33 C1 23 CF 23 D7 25 00 80 00 00 66 81 F9 FF 7F 8D 3C 0A 0F B7 FF 0F 83 FB 01 00 00 66 81 FA FF 7F 0F 83 F0 01 00 00 66 81 FF FD BF 0F 87 E5 01 00 00 66 81 FF BF 3F 77 0D 33 C0 89 45 C8 89 45 C4 E9 E8 01 00 00 66 85 C9 75 1F 47 F7 45 CC FF FF FF 7F 75 15 83 7D C8 00 75 0F 83 7D C4 00 75 09 66 21 4D CE E9 C7 01 00 00 33 C9 66 3B D1 75 21 47 F7 43 08 FF FF FF 7F 75 17 39 4B 04 75 12 39 0B 75 0E 89 4D CC 89 4D C8 89 4D C4 E9 9F 01 00 00 21 4D 98 8D 75 D8 C7 45 A8 05 00 00 00 8B 4D 98 8B 55 A8 03 C9 85 D2 89 55 9C 7E 55 8D 4C 0D C4 83 C3 08 89 4D A4 89 5D A0 8B 4D A0 8B 55 A4 0F B7 12 0F B7 09 83 65 88 00 0F AF CA 8B 56 FC 8D 1C 0A 3B DA 72 04 3B D9 73 07 C7 45 88 01 00 00 00 83 7D 88 00 89 5E FC 74 03 66 FF 06 83 45 A4 02 83 6D A0 02 FF 4D 9C 83 7D 9C 00 7F BB 8B 5D 90 46 46 FF 45 98 FF 4D A8 83 7D A8 00 7F 8E 81 C7 02 C0 00 00 66 85 FF 7E 3B F7 45 DC 00 00 00 80 75 2D 8B 75 D8 8B 4D D4 D1 65 D4 C1 E9 1F 8B D6 03 F6 0B F1 8B 4D DC C1 EA 1F 03 C9 0B CA 81 C7 FF FF 00 00 66 85 FF 89 75 D8 89 4D DC 7F CA 66 85 FF 7F 4E 81 C7 FF FF 00 00 66 85 FF 7D 43 8B CF F7 D9 0F B7 F1 03 FE F6 45 D4 01 74 03 FF 45 B0 8B 4D DC 8B 5D D8 8B 55 D8 D1 6D DC C1 E1 1F D1 EB 0B D9 8B 4D D4 C1 E2 1F D1 E9 0B CA 4E 89 5D D8 89 4D D4 75 D1 83 7D B0 00 74 05 66 83 4D D4 01 66 81 7D D4 00 80 77 11 8B 4D D4 81 E1 FF FF 01 00 81 F9 00 80 01 00 75 33 83 7D D6 FF 75 2A 83 65 D6 00 83 7D DA FF 75 1B 83 65 DA 00 66 81 7D DE FF FF 75 09 66 C7 45 DE 00 80 47 EB 0E 66 FF 45 DE EB 08 FF 45 DA EB 03 FF 45 D6 66 81 FF FF 7F 8B 75 B4 73 1C 66 8B 4D D6 66 89 4D C4 8B 4D D8 89 4D C6 8B 4D DC 0B F8 89 4D CA 66 89 7D CE EB 1A 66 F7 D8 1B C0 83 65 C8 00 25 00 00 00 80 05 00 80 FF 7F 83 65 C4 00 89 45 CC 83 7D AC 00 0F 85 6C FD FF FF 8B 45 CC 0F B7 4D C4 8B 75 C6 8B 55 CA C1 E8 10 EB 2F C7 45 94 04 00 00 00 EB 1E 33 F6 B8 FF 7F 00 00 BA 00 00 00 80 33 C9 C7 45 94 02 00 00 00 EB 0F C7 45 94 01 00 00 00 33 C9 33 C0 33 D2 33 F6 8B 7D 84 0B 45 8C 66 89 0F 66 89 47 0A 8B 45 94 89 77 02 89 57 06 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_194_6_0 {
	meta:
		name = "___STRINGTOLD_L"
		size = 89
		refs = "0007 ___security_cookie 002e ___strgtold12_l 003a __ld12told 0053 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 18 8B 4D 10 8B 45 0C 56 8B 75 08 57 52 33 D2 52 52 52 FF 75 14 51 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_324_6_0 {
	meta:
		name = "___WSTRINGTOLD_L"
		size = 89
		refs = "0007 ___security_cookie 002e ___wstrgtold12_l 003a __ld12told 0053 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 55 18 8B 4D 10 8B 45 0C 56 8B 75 08 57 52 33 D2 52 52 52 FF 75 14 51 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B F8 8D 45 F0 56 50 E8 ?? ?? ?? ?? 83 C4 28 83 F8 01 75 03 83 CF 02 8B 4D FC 8B C7 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_195_0_0 {
	meta:
		name = "__vsnwprintf_l"
		size = 210
		refs = "000f __errno 001f __invalid_parameter 008b __woutput_l 00ad __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 33 DB 39 5D 10 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 A1 00 00 00 8B 45 0C 3B C3 56 8B 75 08 74 21 3B F3 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 74 3D FF FF FF 3F C7 45 EC 42 00 00 00 89 75 E8 89 75 E0 76 09 C7 45 E4 FF FF FF 7F EB 05 03 C0 89 45 E4 57 FF 75 18 8D 45 E0 FF 75 14 FF 75 10 50 E8 ?? ?? ?? ?? 83 C4 10 3B F3 8B F8 74 35 FF 4D E4 78 0A 8B 45 E0 88 18 FF 45 E0 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "_has_osfxsr_set"
		size = 80
		refs = "0003 __sehtable$_has_osfxsr_set 0008 __SEH_prolog4 004b __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 66 0F 28 C1 C7 45 E4 01 00 00 00 EB 23 8B 45 EC 8B 00 8B 00 3D 05 00 00 C0 74 0A 3D 1D 00 00 C0 74 03 33 C0 C3 33 C0 40 C3 8B 65 E8 83 65 E4 00 C7 45 FC FE FF FF FF 8B 45 E4 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_196_1_0 {
	meta:
		name = "__get_sse2_info"
		size = 96
		refs = "004e _has_osfxsr_set"
	strings:
		$1 = { 55 8B EC 83 EC 18 33 C0 53 89 45 FC 89 45 F4 89 45 F8 53 9C 58 8B C8 35 00 00 20 00 50 9D 9C 5A 2B D1 74 1F 51 9D 33 C0 0F A2 89 45 F4 89 5D E8 89 55 EC 89 4D F0 B8 01 00 00 00 0F A2 89 55 FC 89 45 F8 5B F7 45 FC 00 00 00 04 74 0E E8 ?? ?? ?? ?? 85 C0 74 05 33 C0 40 EB 02 33 C0 5B C9 C3 }
	condition:
		$1
}

rule file_197_1_0 {
	meta:
		name = "_shortsort"
		size = 135
	strings:
		$1 = { 8B 4C 24 04 55 8B 6C 24 0C 3B E9 76 78 53 8B 5C 24 14 56 8D 04 19 57 89 44 24 18 EB 03 8D 49 00 8B 74 24 18 3B F5 8B F9 77 1F 8D 9B 00 00 00 00 57 56 FF 54 24 28 83 C4 08 85 C0 7E 02 8B FE 03 F3 3B F5 76 EB 8B 4C 24 14 3B FD 8B F3 8B C5 74 2B 85 DB 74 27 8B CF 2B CD 8D A4 24 00 00 00 00 8A 18 8A 14 01 88 1C 01 83 EE 01 88 10 83 C0 01 85 F6 75 EC 8B 5C 24 1C 8B 4C 24 14 2B EB 3B E9 77 9E 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_197_2_0 {
	meta:
		name = "_qsort"
		size = 679
		refs = "001f __errno 0034 __invalid_parameter 00bf _shortsort 0110 _swap"
	strings:
		$1 = { 81 EC 00 01 00 00 53 8B 9C 24 08 01 00 00 85 DB 56 8B B4 24 10 01 00 00 75 2A 85 F6 74 26 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 5E 5B 81 C4 00 01 00 00 C3 55 8B AC 24 18 01 00 00 85 ED 76 0A 83 BC 24 1C 01 00 00 00 75 27 E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 5D 5E 5B 81 C4 00 01 00 00 C3 83 FE 02 0F 82 13 02 00 00 83 C6 FF 0F AF F5 03 F3 C7 44 24 18 00 00 00 00 89 5C 24 0C 89 74 24 10 57 8B C6 2B C3 33 D2 F7 F5 83 C0 01 83 F8 08 77 3D 8B 84 24 20 01 00 00 50 55 56 53 E8 ?? ?? ?? ?? 83 C4 10 8B 44 24 1C 83 E8 01 89 44 24 1C 0F 88 C5 01 00 00 8B 54 84 20 8B 84 84 98 00 00 00 89 54 24 10 89 44 24 14 8B F0 8B DA EB B3 D1 E8 0F AF C5 03 C3 8B F8 57 53 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E 0B 8B D5 8B CF 8B C3 E8 ?? ?? ?? ?? 56 53 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E 0B 8B D5 8B CE 8B C3 E8 ?? ?? ?? ?? 56 57 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E 11 8B D5 8B CE 8B C7 E8 ?? ?? ?? ?? 8D 9B 00 00 00 00 3B FB 76 1C 03 DD 3B DF 73 16 57 53 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E EA 3B FB 77 1A 8B FF 03 DD 3B 5C 24 14 77 10 57 53 FF 94 24 28 01 00 00 83 C4 08 85 C0 7E E8 2B F5 3B F7 76 10 57 56 FF 94 24 28 01 00 00 83 C4 08 85 C0 7F EA 3B DE 77 43 8B CD 8B C6 74 2E 8B EB 2B EE 8D 64 24 00 0F B6 14 28 88 54 24 1B 0F B6 10 88 14 28 0F B6 54 24 1B 83 E9 01 88 10 83 C0 01 85 C9 75 E1 8B AC 24 1C 01 00 00 3B FE 0F 85 72 FF FF FF 8B FB E9 6B FF FF FF 03 F5 3B FE 73 25 EB 03 8D 49 00 2B F5 3B F7 76 1A 57 56 FF 94 24 28 01 00 00 83 C4 08 85 C0 74 EA 3B FE 72 20 8D 9B 00 00 00 00 8B 44 24 10 2B F5 3B F0 76 14 57 56 FF 94 24 28 01 00 00 83 C4 08 85 C0 74 E6 8B 44 24 10 8B 54 24 14 8B CA 8B FE 2B CB 2B F8 3B F9 7C 2F 3B C6 73 16 8B 4C 24 1C 89 44 8C 20 89 B4 8C 98 00 00 00 83 C1 01 89 4C 24 1C 3B DA 0F 83 66 FE FF FF 8B 74 24 14 89 5C 24 10 E9 36 FE FF FF 3B DA 73 16 8B 4C 24 1C 89 5C 8C 20 89 94 8C 98 00 00 00 83 C1 01 89 4C 24 1C 3B C6 0F 83 37 FE FF FF 8B 5C 24 10 89 74 24 14 E9 07 FE FF FF 5F 5D 5E 5B 81 C4 00 01 00 00 C3 }
	condition:
		$1
}

rule file_198_3_0 {
	meta:
		name = "__ismbcupper_l"
		size = 168
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0068 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 14 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 6D 66 83 65 FC 00 33 C0 57 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 83 78 08 00 5F 75 11 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 33 C0 C9 C3 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CB 66 83 7D FE 00 75 0B F6 45 FC 01 74 05 33 C0 40 EB 14 33 C0 EB 10 8B 45 F0 8A 44 08 1D 24 10 2C 10 F6 D8 1B C0 40 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_199_1_0 {
	meta:
		name = "___free_lconv_mon"
		size = 137
		refs = "000e ___lconv_c 0016 _free"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 74 7E 8B 46 0C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 10 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 14 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 18 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 1C 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 20 3B 05 ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 8B 76 24 3B 35 ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 5E C3 }
	condition:
		$1
}

rule file_199_2_0 {
	meta:
		name = "___init_monetary"
		size = 708
		refs = "0028 ___lconv_c 0036 __calloc_crt 004d __malloc_crt 005b _free 00a1 ___getlocaleinfo 01cf ___free_lconv_mon 0274 __imp__InterlockedDecrement@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 08 57 33 FF 39 7E 18 89 7D FC 89 75 F0 89 7D F4 75 15 39 7E 1C 75 10 89 7D FC 89 7D F8 BB ?? ?? ?? ?? E9 36 02 00 00 6A 30 6A 01 E8 ?? ?? ?? ?? 8B D8 3B DF 59 59 75 08 33 C0 40 E9 75 02 00 00 6A 04 E8 ?? ?? ?? ?? 3B C7 59 89 45 F8 75 09 53 E8 ?? ?? ?? ?? 59 EB E0 89 38 39 7E 18 0F 84 B9 01 00 00 6A 04 E8 ?? ?? ?? ?? 3B C7 59 89 45 FC 75 11 53 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? 59 EB D2 89 38 0F B7 76 38 8D 43 0C 50 6A 15 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 8B F8 8D 43 10 50 6A 14 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 14 50 6A 16 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 18 50 6A 17 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 83 C4 50 0B F8 8D 43 1C 50 6A 18 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 20 50 6A 50 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 24 50 6A 51 56 8D 45 F0 6A 01 50 E8 ?? ?? ?? ?? 0B F8 8D 43 28 50 6A 1A 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 83 C4 50 0B F8 8D 43 29 50 6A 19 56 6A 00 8D 45 F0 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2A 50 6A 54 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2B 50 6A 55 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2C 50 6A 56 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 83 C4 50 0B F8 8D 43 2D 50 6A 57 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2E 50 6A 52 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 0B F8 8D 43 2F 50 6A 53 56 8D 45 F0 6A 00 50 E8 ?? ?? ?? ?? 83 C4 3C 0B C7 74 24 53 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? FF 75 F8 E8 ?? ?? ?? ?? FF 75 FC E8 ?? ?? ?? ?? 83 C4 10 E9 51 FE FF FF 8B 43 1C EB 12 8A 08 80 F9 30 7C 12 80 F9 39 7F 0D 80 E9 30 88 08 40 80 38 00 75 E9 EB 23 80 F9 3B 75 F3 8B F0 8D 7E 01 8A 0F 88 0E 8B F7 80 3E 00 75 F2 EB E2 6A 0C 59 BE ?? ?? ?? ?? 8B FB F3 A5 8B 45 08 8B 75 08 05 BC 00 00 00 8B 08 8B 09 89 0B 8B 08 8B 49 04 89 4B 04 8B 00 8B 40 08 8B 4D F8 89 43 08 33 C0 40 33 FF 39 7D FC 89 01 74 05 8B 4D FC 89 01 8B 86 B8 00 00 00 3B C7 74 07 50 FF 15 ?? ?? ?? ?? 8B 86 B0 00 00 00 3B C7 74 23 50 FF 15 ?? ?? ?? ?? 85 C0 75 18 FF B6 BC 00 00 00 E8 ?? ?? ?? ?? FF B6 B0 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 45 FC 89 86 B8 00 00 00 8B 45 F8 89 86 B0 00 00 00 89 9E BC 00 00 00 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_200_1_0 {
	meta:
		name = "__unloaddll"
		size = 23
		refs = "0006 __imp__FreeLibrary@4 0010 __imp__GetLastError@0"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 85 C0 75 06 FF 25 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_201_0_0 {
	meta:
		name = "__putenv_helper"
		size = 527
		refs = "000a ___env_initialized 0024 __errno 0034 __invalid_parameter 004d __mbschr 0068 _strnlen 0074 _strlen 007f __calloc_crt 0095 _strcpy_s 0129 ___crtsetenv 0146 __wenviron 0152 __imp__MultiByteToWideChar@24 01a9 _wcslen 01d3 _free 01eb ___crtwsetenv"
	strings:
		$1 = { 55 8B EC 51 51 56 33 F6 39 35 ?? ?? ?? ?? 89 75 F8 75 08 83 C8 FF E9 F1 01 00 00 53 8B 5D 08 3B DE 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 C8 01 00 00 39 75 0C 57 75 58 6A 3D 53 E8 ?? ?? ?? ?? 3B C6 59 59 74 1B 8B C8 2B CB BF FF 7F 00 00 3B CF 7D 5F 40 57 50 E8 ?? ?? ?? ?? 3B C7 59 59 73 51 53 E8 ?? ?? ?? ?? 8B F8 47 6A 01 57 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 89 45 F8 0F 84 72 01 00 00 53 57 50 E8 ?? ?? ?? ?? 83 C4 0C E9 81 00 00 00 BF FF 7F 00 00 57 53 E8 ?? ?? ?? ?? 57 FF 75 0C 8B D8 E8 ?? ?? ?? ?? 83 C4 10 3B DF 73 04 3B C7 72 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 23 01 00 00 8D 7C 18 02 6A 01 57 E8 ?? ?? ?? ?? 3B C6 59 59 89 45 F8 0F 84 0A 01 00 00 FF 75 08 57 50 E8 ?? ?? ?? ?? 8B 45 F8 FF 75 0C C6 04 03 3D 8B 45 F8 43 2B FB 03 D8 57 53 E8 ?? ?? ?? ?? 8B 5D 08 83 C4 18 8D 45 F8 6A 01 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 11 39 75 F8 0F 84 C7 00 00 00 FF 75 F8 E9 B9 00 00 00 39 35 ?? ?? ?? ?? 0F 84 B8 00 00 00 8B 3D ?? ?? ?? ?? 56 56 6A FF 53 56 56 89 75 FC FF D7 8B D8 3B DE 74 70 39 75 0C 74 13 56 56 6A FF FF 75 0C 56 56 FF D7 3B C6 74 5C 8D 5C 03 01 6A 02 53 E8 ?? ?? ?? ?? 3B C6 59 59 89 45 FC 74 72 53 50 6A FF FF 75 08 56 56 FF D7 85 C0 74 2F 39 75 0C 74 40 FF 75 FC E8 ?? ?? ?? ?? 59 8B 4D FC 66 C7 04 41 3D 00 8B 4D FC 40 2B D8 53 8D 04 41 50 6A FF FF 75 0C 56 56 FF D7 85 C0 75 16 FF 75 FC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 EB 1E 8D 45 FC 56 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 13 39 75 FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 83 C8 FF EB 02 33 C0 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_201_1_0 {
	meta:
		name = "__putenv"
		size = 69
		refs = "0003 __sehtable$__putenv 0008 __SEH_prolog4 000f __lock 001e __putenv_helper 0037 __SEH_epilog4 003f __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_602_1_0 {
	meta:
		name = "__wputenv"
		size = 69
		refs = "0003 __sehtable$__wputenv 0008 __SEH_prolog4 000f __lock 001e __wputenv_helper 0037 __SEH_epilog4 003f __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 07 E8 ?? ?? ?? ?? 59 83 65 FC 00 6A 00 FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_201_2_0 {
	meta:
		name = "__putenv_s"
		size = 121
		refs = "0003 __sehtable$__putenv_s 0008 __SEH_prolog4 001b __errno 002a __invalid_parameter 0038 __lock 0047 __putenv_helper 006b __SEH_epilog4 0073 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1B E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 35 6A 07 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 E8 ?? ?? ?? ?? 8B 30 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_602_2_0 {
	meta:
		name = "__wputenv_s"
		size = 121
		refs = "0003 __sehtable$__wputenv_s 0008 __SEH_prolog4 001b __errno 002a __invalid_parameter 0038 __lock 0047 __wputenv_helper 006b __SEH_epilog4 0073 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 33 F6 39 75 0C 0F 95 C0 3B C6 75 1B E8 ?? ?? ?? ?? 6A 16 5F 89 38 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 35 6A 07 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 85 C0 74 07 E8 ?? ?? ?? ?? 8B 30 89 75 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 07 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_wait_a_bit"
		size = 33
		refs = "0008 __imp__Sleep@4 0014 __maxwait"
	strings:
		$1 = { 56 8B 74 24 08 56 FF 15 ?? ?? ?? ?? 81 C6 E8 03 00 00 3B 35 ?? ?? ?? ?? 76 03 83 CE FF 8B C6 5E C3 }
	condition:
		$1
}

rule file_202_2_0 {
	meta:
		name = "__malloc_crt"
		size = 64
		refs = "0009 _malloc 0016 __maxwait 001f __imp__Sleep@4"
	strings:
		$1 = { 56 57 33 F6 FF 74 24 0C E8 ?? ?? ?? ?? 8B F8 85 FF 59 75 27 39 05 ?? ?? ?? ?? 76 1F 56 FF 15 ?? ?? ?? ?? 8D 86 E8 03 00 00 3B 05 ?? ?? ?? ?? 76 03 83 C8 FF 83 F8 FF 8B F0 75 C9 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_202_3_0 {
	meta:
		name = "__calloc_crt"
		size = 72
		refs = "000f __calloc_impl 001e __maxwait 0027 __imp__Sleep@4"
	strings:
		$1 = { 56 57 33 F6 6A 00 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 27 39 05 ?? ?? ?? ?? 76 1F 56 FF 15 ?? ?? ?? ?? 8D 86 E8 03 00 00 3B 05 ?? ?? ?? ?? 76 03 83 C8 FF 83 F8 FF 8B F0 75 C1 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_202_4_0 {
	meta:
		name = "__realloc_crt"
		size = 75
		refs = "000d _realloc 0021 __maxwait 002a __imp__Sleep@4"
	strings:
		$1 = { 56 57 33 F6 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 8B F8 85 FF 59 59 75 2D 39 44 24 10 74 27 39 05 ?? ?? ?? ?? 76 1F 56 FF 15 ?? ?? ?? ?? 8D 86 E8 03 00 00 3B 05 ?? ?? ?? ?? 76 03 83 C8 FF 83 F8 FF 8B F0 75 BE 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_202_5_0 {
	meta:
		name = "__recalloc_crt"
		size = 80
		refs = "0011 __recalloc 0026 __maxwait 002f __imp__Sleep@4"
	strings:
		$1 = { 56 57 33 F6 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 85 FF 75 2D 39 44 24 14 74 27 39 05 ?? ?? ?? ?? 76 1F 56 FF 15 ?? ?? ?? ?? 8D 86 E8 03 00 00 3B 05 ?? ?? ?? ?? 76 03 83 C8 FF 83 F8 FF 8B F0 75 B9 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "__execle"
		size = 87
		refs = "0010 __errno 0020 __invalid_parameter 004e __execve"
	strings:
		$1 = { 8B 54 24 04 53 33 DB 3B D3 8D 44 24 0C 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5B C3 38 1A 74 DF 8B 4C 24 0C 3B CB 74 D7 38 19 74 D3 8B 08 83 C0 04 85 C9 75 F7 FF 30 8D 44 24 10 50 52 E8 ?? ?? ?? ?? 83 C4 0C 5B C3 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "__futime32"
		size = 426
		refs = "000f __errno 0027 __nhandle 003b ___pioinfo 0057 __invalid_parameter 0073 __time32 008a __localtime32_s 00da __imp__SystemTimeToFileTime@8 0102 __imp__LocalFileTimeToFileTime@8 0183 __get_osfhandle 018b __imp__SetFileTime@16"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 54 83 F8 FE 75 10 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF C9 C3 57 33 FF 3B C7 7C 21 3B 05 ?? ?? ?? ?? 73 19 8B C8 83 E0 1F 6B C0 28 C1 F9 05 8B 0C 8D ?? ?? ?? ?? F6 44 01 04 01 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 09 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 41 01 00 00 53 8B 5D 0C 3B DF 75 13 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 59 89 45 F8 8D 5D F8 8D 43 04 50 8D 45 AC 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 13 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 FF 00 00 00 8B 45 C0 05 6C 07 00 00 66 89 45 D0 8B 45 BC 40 66 89 45 D2 66 8B 45 B8 66 89 45 D6 66 8B 45 B4 66 89 45 D8 66 8B 45 B0 66 89 45 DA 66 8B 45 AC 56 8B 35 ?? ?? ?? ?? 66 89 45 DC 8D 45 F0 50 8D 45 D0 50 66 89 7D DE FF D6 85 C0 0F 84 9F 00 00 00 8D 45 E8 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 89 00 00 00 8D 45 AC 53 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 79 8B 45 C0 05 6C 07 00 00 66 89 45 D0 8B 45 BC 40 66 89 45 D2 66 8B 45 B8 66 89 45 D6 66 8B 45 B4 66 89 45 D8 66 8B 45 B0 66 89 45 DA 66 8B 45 AC 66 89 45 DC 8D 45 F0 50 8D 45 D0 50 66 89 7D DE FF D6 85 C0 74 33 8D 45 E0 50 8D 45 F0 50 FF 15 ?? ?? ?? ?? 85 C0 74 21 8D 45 E8 50 8D 45 E0 50 57 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF 15 ?? ?? ?? ?? 85 C0 74 04 33 C0 EB 0E E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF 5E 5B 5F C9 C3 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "___libm_sse2_log10"
		size = 574
		refs = "0024 _emask 002c _CC 0034 _One 003c _Magic 0044 _hi_mask 0062 _CB_Tbl 006a _T_Tbl 00cc _coeff 00f8 _LOG10_2 0104 _place_LR 015e _Zero 01b2 _Infs 01e1 _Two52"
	strings:
		$1 = { 83 EC 0C BA 00 00 00 00 66 0F 13 44 24 04 66 0F 28 E8 66 0F 14 C0 66 0F 73 D5 34 66 0F C5 CD 00 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C3 66 0F 58 E0 66 0F C5 C4 00 25 F0 07 00 00 66 0F 28 A0 ?? ?? ?? ?? 66 0F 28 B8 ?? ?? ?? ?? 66 0F 54 F0 66 0F 5C C6 66 0F 59 F4 66 0F 5C F2 F2 0F 58 FE 66 0F 59 C4 66 0F 28 E0 66 0F 58 C6 81 E1 FF 0F 00 00 83 E9 01 81 F9 FD 07 00 00 0F 87 B1 00 00 00 81 E9 FE 03 00 00 03 CA F2 0F 2A F1 66 0F 14 F6 C1 E1 0A 03 C1 B9 10 00 00 00 BA 00 00 00 00 83 F8 00 0F 44 D1 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 DB 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? F2 0F 59 DB 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 F5 66 0F 28 AA ?? ?? ?? ?? 66 0F 54 E5 66 0F 58 FE 66 0F 58 FC 66 0F 59 C8 F2 0F 59 D8 66 0F 58 CA 66 0F 28 15 ?? ?? ?? ?? 66 0F 59 D0 66 0F 28 F7 66 0F 15 F6 66 0F 59 CB 66 0F 28 C1 66 0F 58 CA 66 0F 15 C0 83 C4 0C F2 0F 58 C1 F2 0F 58 C6 F2 0F 58 C7 C3 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? F2 0F C2 C8 00 66 0F C5 C1 00 83 F8 00 77 54 83 F9 FF 74 67 81 F9 FE 07 00 00 77 75 66 0F 12 44 24 04 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? 66 0F 54 C1 66 0F 56 C2 F2 0F C2 D0 00 66 0F C5 C2 00 83 F8 00 74 0C 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 44 24 04 83 C4 0C F2 0F 58 C0 C3 83 C4 0C 66 0F 12 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 0D ?? ?? ?? ?? F2 0F 59 C1 BA CC FF FF FF E9 1B FE FF FF 83 C1 01 81 E1 FF 07 00 00 81 F9 FF 07 00 00 73 0C 83 C4 0C 66 0F 57 C0 F2 0F 5E C0 C3 66 0F 12 54 24 04 66 0F 12 44 24 04 66 0F 7E D0 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF 0F 00 0B C1 83 F8 00 74 CE 83 C4 0C F2 0F 58 C0 C3 }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "__wcsdup"
		size = 83
		refs = "0014 _wcslen 001f _calloc 0030 _wcscpy_s 0041 __invoke_watson"
	strings:
		$1 = { 53 8B 5C 24 08 55 33 ED 3B DD 75 04 33 C0 EB 40 56 57 53 E8 ?? ?? ?? ?? 8B F0 46 6A 02 56 E8 ?? ?? ?? ?? 8B F8 83 C4 0C 3B FD 74 20 53 56 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 55 55 55 55 55 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 02 33 C0 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "__getpath"
		size = 147
		refs = "001a __errno"
	strings:
		$1 = { 55 8B EC 56 8B 75 08 57 B1 3B EB 01 46 38 0E 74 FB FF 4D 10 89 75 08 75 10 E8 ?? ?? ?? ?? 8B 7D 0C C7 00 22 00 00 00 EB 58 8A 06 84 C0 8B 7D 0C 53 74 49 6A 22 5B 3A C1 74 41 3A C3 74 15 88 07 47 46 FF 4D 10 75 2C 89 75 08 E8 ?? ?? ?? ?? 89 18 EB 2D 46 8A 06 84 C0 74 22 3A C3 74 0F 88 07 47 46 FF 4D 10 74 E0 8A 06 84 C0 75 ED 80 3E 00 74 0A 46 8A 06 84 C0 75 BD EB 01 46 38 0E 74 FB 5B 8B 45 08 2B C6 F7 D8 C6 07 00 1B C0 5F 23 C6 5E 5D C3 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "___libm_sse2_powf"
		size = 1715
		refs = "0004 _dword_mask 000f _SIGMASK 001b _EXPMASK 0048 _cv 0093 _B_table 009b _SCALE5 00c4 _T_tbl 00e9 _Shifter 0161 _cev 01a9 _exp2_tbl 01f6 _ABSVALMASK 02bf _NEG_ZEROD 0357 _ABSVALS 039b _ONEMASK 0437 _NEG_ZERO 0443 _NEG_INF 0492 _sNaN 0533 _INF"
	strings:
		$1 = { F3 0F 10 3D ?? ?? ?? ?? 83 EC 0C 66 0F 12 2D ?? ?? ?? ?? 66 0F DB C7 66 0F 12 1D ?? ?? ?? ?? 66 0F DB CF F3 0F 11 44 24 04 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB F3 0F 11 4C 24 08 66 0F 28 35 ?? ?? ?? ?? 66 0F 28 15 ?? ?? ?? ?? F3 0F 5A C9 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B CA 81 F9 00 80 00 00 0F 83 7D 01 00 00 BA 3F 3F 00 00 B9 00 00 00 00 66 0F 6E C2 83 E0 7F 83 C0 01 25 FE 00 00 00 66 0F 12 3C 85 ?? ?? ?? ?? F2 0F 59 0D ?? ?? ?? ?? F2 0F 10 DF 66 0F 73 D7 1A 66 0F 73 F7 1A 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 04 85 ?? ?? ?? ?? F2 0F 5C DF F2 0F 59 FD F2 0F 59 EB F2 0F 5C 3D ?? ?? ?? ?? F2 0F 58 EF 66 0F 70 FD 44 66 0F 12 1D ?? ?? ?? ?? F2 0F 58 C5 66 0F 59 F7 66 0F 59 FF F2 0F 58 C4 F2 0F 59 D7 F2 0F 58 C2 66 0F 70 D2 EE F2 0F 58 F2 F2 0F 59 C1 F2 0F 59 FF 66 0F C5 D0 03 F2 0F 10 E0 F2 0F 58 C3 F2 0F 5C C3 66 0F 59 F7 B8 D0 41 00 00 81 E2 F0 7F 00 00 2B C2 81 EA 60 3E 00 00 0B D0 81 FA 00 00 00 80 0F 83 F8 04 00 00 F2 0F 2D C0 F2 0F 5C E0 66 0F 70 FE EE F2 0F 58 F7 66 0F 28 3D ?? ?? ?? ?? F2 0F 59 CE 66 0F 28 15 ?? ?? ?? ?? 66 0F 57 F6 F2 0F 58 E1 66 0F 70 EC 44 BA BF 0F 00 00 2B D0 05 A0 0F 00 00 0B D0 2D A0 0F 00 00 81 FA 00 00 00 80 0F 83 D9 03 00 00 8B D0 D1 FA 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 81 C9 F0 3F 00 00 83 E2 F0 03 CA 66 0F C4 F1 03 83 C4 0C 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 66 0F 5A C0 C3 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E CA F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 66 0F 73 D0 20 66 0F 7E C1 81 F9 00 00 F0 7F 0F 83 D4 00 00 00 0B D1 83 FA 00 0F 84 20 03 00 00 66 0F 7E E2 81 FA FF FF 7F 7F 0F 86 DC 00 00 00 66 0F 73 F3 34 66 0F 56 FB B9 F3 03 00 00 66 0F 6E D9 66 0F 73 D0 14 66 0F FA C3 66 0F EF DB 66 0F EE C3 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 83 38 01 00 00 81 F9 FF 00 00 00 0F 85 EF 01 00 00 66 0F 12 1D ?? ?? ?? ?? F2 0F 10 C1 F2 0F 10 F9 66 0F 54 C3 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 05 ?? ?? ?? ?? 66 0F 73 D0 34 66 0F FA C3 66 0F 12 1D ?? ?? ?? ?? 66 0F F3 F8 66 0F 76 FB 66 0F D7 CF 81 E1 FF 00 00 00 81 C1 01 7F 00 00 81 E1 00 80 00 00 81 FA 00 00 80 00 72 32 BA 3F BF 00 00 E9 8C FD FF FF 66 0F 7E E2 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 77 05 E9 91 01 00 00 83 C4 0C F3 0F 10 C4 F3 0F 58 C0 C3 B9 00 00 00 00 66 0F 57 C0 BA 80 5F 00 00 66 0F C4 C2 01 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? F3 0F 59 E0 66 0F 7E E2 81 E2 FF FF FF 7F 83 FA 00 74 26 66 0F C5 C4 01 0F 28 C4 0F 54 25 ?? ?? ?? ?? 66 0F 73 F0 1D 66 0F 54 E8 66 0F 56 EB BA 3F 5F 00 00 E9 0D FD FF FF 8B 54 24 08 81 E2 00 00 00 80 83 FA 00 74 23 C1 E1 10 66 0F 7E E2 23 D1 81 CA 00 00 80 7F 66 0F 6E C2 83 C4 0C F3 0F 10 2D ?? ?? ?? ?? F3 0F 5E EC C3 C1 E1 10 66 0F 7E E2 23 D1 83 FA 00 75 7E 83 C4 0C 0F 57 C0 C3 66 0F 7E E2 81 FA 00 00 80 7F 0F 84 99 00 00 00 81 E2 FF FF FF 7F 81 FA 00 00 80 7F 0F 87 2F FF FF FF 81 F9 FF 00 00 00 75 65 F2 0F 10 E9 F2 0F 10 D1 B9 F4 03 00 00 66 0F 6E D9 66 0F 54 2D ?? ?? ?? ?? 66 0F 73 D5 34 66 0F FA EB 66 0F EF DB 66 0F F3 D5 66 0F 76 D3 66 0F D7 C2 25 FF 00 00 00 3D FF 00 00 00 74 27 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 74 0C 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 D1 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F C5 C1 03 25 00 80 00 00 83 F8 00 0F 84 B7 00 00 00 83 C4 0C 0F 57 C0 C3 66 0F 7E E0 3D 00 00 00 80 0F 84 E7 FE FF FF 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? F3 0F 59 C0 C3 8B 44 24 08 8B C8 25 FF FF FF 7F 3D 00 00 80 7F 0F 87 87 00 00 00 81 E1 00 00 00 80 66 0F 7E E2 81 F2 00 00 80 BF 83 FA 00 74 30 83 F9 00 74 49 66 0F 7E E0 25 FF FF FF 7F 3D 00 00 80 3F 73 14 83 F8 00 75 4C B9 00 00 80 3F 66 0F 6E E9 F3 0F 5E EC EB 3D 83 C4 0C 0F 57 C0 C3 83 EC 10 0F AE 5C 24 0C 83 64 24 0C DE 0F AE 54 24 0C 83 C4 1C F3 0F 10 05 ?? ?? ?? ?? C3 66 0F C5 C4 01 25 80 7F 00 00 3D 80 3F 00 00 73 07 83 C4 0C 0F 57 C0 C3 83 C4 0C F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 4C 24 08 83 C4 0C F3 0F 58 C9 F3 0F 10 C1 C3 66 0F 7E E0 F3 0F 10 05 ?? ?? ?? ?? 83 F8 00 74 17 66 0F 7E E0 0F 57 D2 F3 0F 58 E2 25 FF FF FF 7F 3D 00 00 80 7F 77 00 83 C4 0C C3 3D 00 20 00 00 0F 8D 92 00 00 00 3D 00 E0 FF FF 0F 8E 9E 00 00 00 66 0F 57 C9 8B D0 C1 FA 05 83 E0 1F 66 0F 12 1C C5 ?? ?? ?? ?? 8B C2 D1 FA 2B C2 C1 E2 04 05 FF 03 00 00 C1 E0 04 81 C9 F0 3F 00 00 03 CA 66 0F C4 F1 03 66 0F C4 C8 03 66 0F 59 FD F2 0F 59 ED F2 0F 59 E3 66 0F 58 D7 F2 0F 59 DE F2 0F 59 E6 F2 0F 59 EA 66 0F 70 C2 EE F2 0F 58 C5 F2 0F 59 C4 F2 0F 58 C3 F2 0F 59 C1 66 0F 5A C0 66 0F C5 C0 01 25 FF 7F 00 00 3D 80 7F 00 00 73 05 83 F8 10 72 00 83 C4 0C C3 83 C4 0C 81 C9 7F 7F 00 00 66 0F 57 C0 66 0F C4 C1 01 F3 0F 58 C0 C3 83 C4 0C B8 00 00 80 00 66 0F 6E E8 F3 0F 59 ED 66 0F 57 C0 66 0F C4 C1 01 C3 8B 54 24 04 F3 0F 10 64 24 04 81 FA 00 00 80 3F 0F 84 9C FE FF FF 8B 44 24 08 F3 0F 10 4C 24 08 25 FF FF FF 7F 3D 00 00 80 7F 0F 83 27 FE FF FF 83 F8 00 0F 84 CD FE FF FF 66 0F C5 D0 03 8B C2 81 E2 F0 7F 00 00 81 FA 60 3E 00 00 76 10 25 00 80 00 00 83 F8 00 0F 84 73 FF FF FF EB 88 83 C4 0C C1 E1 10 81 C9 00 00 80 3F 66 0F 6E C1 C3 }
	condition:
		$1
}

rule file_209_3_0 {
	meta:
		name = "?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
		size = 503
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 __errno 0036 __invalid_parameter 007a __iswctype_l 00a3 __wchartodigit"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 57 FF 75 08 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 10 8B 7D 0C 33 DB 3B C3 74 02 89 38 3B FB 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 E9 A3 01 00 00 39 5D 14 74 0C 83 7D 14 02 7C CA 83 7D 14 24 7F C4 56 0F B7 37 89 5D FC 83 C7 02 EB 05 0F B7 37 47 47 8D 45 E8 50 6A 08 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 E8 66 83 FE 2D 75 06 83 4D 18 02 EB 06 66 83 FE 2B 75 05 0F B7 37 47 47 39 5D 14 75 33 56 E8 ?? ?? ?? ?? 85 C0 59 74 09 C7 45 14 0A 00 00 00 EB 46 0F B7 07 66 3D 78 00 74 0F 66 3D 58 00 74 09 C7 45 14 08 00 00 00 EB 2E C7 45 14 10 00 00 00 83 7D 14 10 75 21 56 E8 ?? ?? ?? ?? 85 C0 59 75 16 0F B7 07 66 3D 78 00 74 06 66 3D 58 00 75 07 47 47 0F B7 37 47 47 83 C8 FF 33 D2 F7 75 14 89 55 F8 8B D8 56 E8 ?? ?? ?? ?? 83 F8 FF 59 75 27 66 83 FE 41 72 06 66 83 FE 5A 76 09 8D 46 9F 66 3D 19 00 77 31 8D 46 9F 66 3D 19 00 0F B7 C6 77 03 83 E8 20 83 C0 C9 3B 45 14 73 1A 83 4D 18 08 39 5D FC 72 29 75 05 3B 45 F8 76 22 83 4D 18 04 83 7D 10 00 75 24 8B 45 18 4F 4F A8 08 75 22 83 7D 10 00 74 03 8B 7D 0C 83 65 FC 00 EB 5E 8B 4D FC 0F AF 4D 14 03 C8 89 4D FC 0F B7 37 47 47 EB 83 A8 04 BE FF FF FF 7F 75 1B A8 01 75 3E 83 E0 02 74 09 81 7D FC 00 00 00 80 77 09 85 C0 75 2C 39 75 FC 76 27 E8 ?? ?? ?? ?? F6 45 18 01 C7 00 22 00 00 00 74 06 83 4D FC FF EB 10 8A 45 18 24 02 F6 D8 1B C0 F7 D8 03 C6 89 45 FC 8B 45 10 85 C0 5E 74 02 89 38 F6 45 18 02 74 03 F7 5D FC 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 8B 45 FC 5F 5B C9 C3 }
	condition:
		$1
}

rule file_209_4_0 {
	meta:
		name = "_wcstol"
		size = 41
		refs = "0007 ___locale_changed 0018 ___initiallocalestructinfo 0020 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 50 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_468_4_0 {
	meta:
		name = "__strtoi64"
		size = 41
		refs = "0007 ___locale_changed 0018 ___initiallocalestructinfo 0020 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 50 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_524_4_0 {
	meta:
		name = "__wcstoi64"
		size = 41
		refs = "0007 ___locale_changed 0018 ___initiallocalestructinfo 0020 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 50 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_789_4_0 {
	meta:
		name = "_strtol"
		size = 41
		refs = "0007 ___locale_changed 0018 ___initiallocalestructinfo 0020 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 33 C0 39 05 ?? ?? ?? ?? 50 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 01 50 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_209_5_0 {
	meta:
		name = "__wcstol_l"
		size = 27
		refs = "0013 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_468_5_0 {
	meta:
		name = "__strtoi64_l"
		size = 27
		refs = "0013 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_789_5_0 {
	meta:
		name = "__strtol_l"
		size = 27
		refs = "0013 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_524_5_0 {
	meta:
		name = "__wcstoi64_l"
		size = 27
		refs = "0013 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 6A 00 FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_209_6_0 {
	meta:
		name = "_wcstoul"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_468_6_0 {
	meta:
		name = "__strtoui64"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_524_6_0 {
	meta:
		name = "__wcstoui64"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_789_6_0 {
	meta:
		name = "_strtoul"
		size = 42
		refs = "0005 ___locale_changed 0018 ___initiallocalestructinfo 0021 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 55 8B EC 83 3D ?? ?? ?? ?? 00 6A 01 FF 75 10 FF 75 0C FF 75 08 75 07 68 ?? ?? ?? ?? EB 02 6A 00 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_209_7_0 {
	meta:
		name = "__wcstoul_l"
		size = 27
		refs = "0013 ?wcstoxl@@YAKPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 6A 01 FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_468_7_0 {
	meta:
		name = "__strtoui64_l"
		size = 27
		refs = "0013 ?strtoxq@@YA_KPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 6A 01 FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_789_7_0 {
	meta:
		name = "__strtoul_l"
		size = 27
		refs = "0013 ?strtoxl@@YAKPAUlocaleinfo_struct@@PBDPAPBDHH@Z"
	strings:
		$1 = { 6A 01 FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_524_7_0 {
	meta:
		name = "__wcstoui64_l"
		size = 27
		refs = "0013 ?wcstoxq@@YA_KPAUlocaleinfo_struct@@PB_WPAPB_WHH@Z"
	strings:
		$1 = { 6A 01 FF 74 24 10 FF 74 24 10 FF 74 24 10 FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_210_3_0 {
	meta:
		name = "__mbscspn_l"
		size = 197
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0024 _strcspn 0037 __errno 0047 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 F4 33 DB 39 5E 08 75 12 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 E9 86 00 00 00 8B 45 08 3B C3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 63 39 5D 0C 74 D3 38 18 74 4B 57 8B 4D 0C EB 28 8A 11 0F B6 FA F6 44 37 1D 04 74 17 3A 10 75 08 8A 51 01 3A 50 01 74 14 8D 51 01 38 1A 74 0D 8B CA EB 04 3A 10 74 05 41 38 19 75 D4 38 19 75 14 0F B6 08 F6 44 31 1D 04 74 05 40 38 18 74 05 40 38 18 75 B7 5F 2B 45 08 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_212_3_0 {
	meta:
		name = "__towupper_l"
		size = 174
		refs = "001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0053 __iswctype_l 008c ___crtLCMapStringW"
	strings:
		$1 = { 55 8B EC B8 FF FF 00 00 83 EC 14 66 39 45 08 0F 84 97 00 00 00 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 45 EC 8B 48 14 33 DB 3B CB 75 14 8B 45 08 8D 48 9F 66 83 F9 19 77 03 83 C0 E0 0F B7 C0 EB 5E 66 81 7D 08 00 01 73 29 8D 45 EC 50 6A 02 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F B7 45 08 74 3D 8B 4D EC 8B 89 D0 00 00 00 66 0F B6 04 01 EB CA FF 70 04 8D 45 FC 6A 01 50 6A 01 8D 45 08 50 68 00 02 00 00 51 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 0F B7 45 08 74 04 0F B7 45 FC 38 5D F8 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_213_2_0 {
	meta:
		name = "_idtab"
		size = 94
		refs = "0002 ___idpairs 0008 ___idtabsiz 003b __recalloc_crt"
	strings:
		$1 = { 8B 0D ?? ?? ?? ?? 8B 15 ?? ?? ?? ?? 56 8B C1 8D 34 D1 EB 07 39 38 74 07 83 C0 08 3B C6 72 F5 3B C6 5E 72 39 85 FF 75 33 8D 42 01 3B C2 72 2C 3D FF FF FF 1F 73 25 6A 08 50 51 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 15 8B 0D ?? ?? ?? ?? FF 05 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8D 04 C8 C3 33 C0 C3 }
	condition:
		$1
}

rule file_213_3_0 {
	meta:
		name = "__popen"
		size = 1324
		refs = "0006 __sehtable$__popen 000b __SEH_prolog4 0032 __errno 0042 __invalid_parameter 00b1 __pipe 00e1 __mtinitlocknum 00ee __close 0104 __lock 0114 __imp__GetCurrentProcess@0 0138 ___pioinfo 0142 __imp__DuplicateHandle@28 0168 __fdopen 017d _idtab 018d ??_C@_07CFPBBAOO@COMSPEC?$AA@ 0197 __dupenv_s 01af __invoke_watson 01ce __get_osver 01dc ??_C@_0M@BOIIGAL@command?4com?$AA@ 01e5 ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 01f6 _memset 0238 _strlen 024a ??_C@_04NPFIMJFF@?5?1c?5?$AA@ 025c __calloc_crt 0274 _strcpy_s 0292 _strcat_s 02d9 __access_s 02fd __imp__CreateProcessA@40 0326 _free 034d ??_C@_04HBHDLLBA@PATH?$AA@ 03aa __getpath 03dc __mbsrchr 03ec ??_C@_01KICIPPFI@?2?$AA@ 049b __imp__CloseHandle@4 04d3 _fclose 051e __SEH_epilog4 0526 __unlock"
	strings:
		$1 = { 68 A4 00 00 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 33 F6 89 5D CC 89 5D D0 88 5D E0 88 5D E1 88 5D E2 89 5D C0 33 C0 39 5D 08 0F 95 C0 3B C3 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 CD 04 00 00 33 C9 8B 45 0C 3B C3 0F 95 C1 3B CB 74 D3 B2 20 EB 01 40 38 10 74 FB 8A 08 80 F9 77 74 05 80 F9 72 75 BE 88 4D E0 40 38 10 74 FB 8A 00 3A C3 74 08 3C 74 74 04 3C 62 75 A8 88 45 E1 3C 74 75 07 BE 00 40 00 00 EB 09 3C 62 75 05 BE 00 80 00 00 81 CE 80 00 00 00 56 68 00 04 00 00 8D 45 B4 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 0F 84 59 04 00 00 33 F6 46 80 7D E0 77 75 0B 89 5D E4 89 5D C4 89 75 C8 EB 09 89 75 E4 89 75 C4 89 5D C8 6A 09 E8 ?? ?? ?? ?? 59 85 C0 75 17 FF 75 B4 E8 ?? ?? ?? ?? FF 75 B8 E8 ?? ?? ?? ?? 59 59 E9 48 FF FF FF 6A 09 E8 ?? ?? ?? ?? 59 89 5D FC 89 75 AC 89 75 A8 FF 15 ?? ?? ?? ?? 8B 7D C4 8D 7C BD B4 8B 0F 6A 02 56 53 8D 55 BC 52 50 8B D1 C1 FA 05 83 E1 1F 6B C9 28 8B 14 95 ?? ?? ?? ?? FF 34 0A 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 94 03 00 00 FF 37 E8 ?? ?? ?? ?? 8B 45 C4 89 5C 85 A8 8D 45 E0 50 8B 45 C8 FF 74 85 B4 E8 ?? ?? ?? ?? 83 C4 0C 89 45 CC 3B C3 0F 84 68 03 00 00 33 FF E8 ?? ?? ?? ?? 89 45 A4 3B C3 0F 84 43 03 00 00 68 ?? ?? ?? ?? 53 8D 45 D0 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 3B F3 74 16 83 FE 16 75 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 3B F3 75 0C 8B 45 D0 3B C3 74 05 89 45 DC EB 23 89 5D D8 8D 45 D8 50 E8 ?? ?? ?? ?? 59 66 F7 45 D8 00 80 C7 45 DC ?? ?? ?? ?? 75 07 C7 45 DC ?? ?? ?? ?? 6A 44 5E 56 53 8D 85 4C FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 89 B5 4C FF FF FF C7 85 78 FF FF FF 00 01 00 00 A1 ?? ?? ?? ?? 39 5D E4 8B 4D BC 74 02 8B 08 89 4D 84 83 7D E4 01 8B 4D BC 74 03 8B 48 28 89 4D 88 8B 40 50 89 45 8C FF 75 DC E8 ?? ?? ?? ?? 8B F0 FF 75 08 E8 ?? ?? ?? ?? 8D 3C 06 BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 8D 7C 38 01 6A 01 57 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 3B C3 0F 84 61 02 00 00 FF 75 DC 57 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 56 57 FF 75 E4 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 75 08 57 FF 75 E4 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? 8B 00 89 45 D8 53 FF 75 DC E8 ?? ?? ?? ?? 59 59 85 C0 75 26 8D 45 90 50 8D 85 4C FF FF FF 50 53 53 53 6A 01 53 53 FF 75 E4 FF 75 DC FF 15 ?? ?? ?? ?? 89 45 C0 E9 7B 01 00 00 89 5D 08 6A 01 BF 04 01 00 00 57 E8 ?? ?? ?? ?? 59 59 8B F0 89 75 B0 3B F3 75 28 53 E8 ?? ?? ?? ?? FF 75 E4 E8 ?? ?? ?? ?? FF 75 D0 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 8B 4D D8 89 08 E9 83 01 00 00 68 ?? ?? ?? ?? 53 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 D4 3B C3 74 12 83 F8 16 75 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 39 5D D4 74 23 FF 75 08 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? FF 75 E4 E8 ?? ?? ?? ?? FF 75 D0 E8 ?? ?? ?? ?? 83 C4 10 EB 9E 8B 45 08 68 03 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 89 45 A0 3B C3 0F 84 B8 00 00 00 38 1E 0F 84 B0 00 00 00 56 E8 ?? ?? ?? ?? 59 8D 44 30 FF 89 45 D4 8A 00 3C 5C 75 0F 6A 5C 56 E8 ?? ?? ?? ?? 59 59 39 45 D4 EB 02 3C 2F 74 20 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 75 DC E8 ?? ?? ?? ?? 56 89 45 D4 E8 ?? ?? ?? ?? 59 59 8B 4D D4 03 C8 8B 75 B0 3B CF 73 4A FF 75 DC 57 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 53 56 E8 ?? ?? ?? ?? 59 59 85 C0 75 70 8D 45 90 50 8D 85 4C FF FF FF 50 53 53 53 6A 01 53 53 FF 75 E4 56 FF 15 ?? ?? ?? ?? 89 45 C0 FF 75 08 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 FF 75 E4 E8 ?? ?? ?? ?? FF 75 D0 E8 ?? ?? ?? ?? 59 59 FF 75 BC 8B 35 ?? ?? ?? ?? FF D6 FF 75 94 FF D6 E8 ?? ?? ?? ?? 8B 4D D8 89 08 8B 45 A4 39 5D C0 74 15 8B 4D 90 89 48 04 8B 4D CC 89 08 EB 49 8B 45 A0 E9 D5 FE FF FF 89 18 FF 75 CC E8 ?? ?? ?? ?? 59 8B 45 C8 89 5C 85 A8 89 5D CC 8B 45 C4 C1 E0 02 39 5C 05 A8 74 0A FF 74 05 B4 E8 ?? ?? ?? ?? 59 8B 45 C8 C1 E0 02 39 5C 05 A8 74 0A FF 74 05 B4 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 CC E8 ?? ?? ?? ?? C3 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_213_4_0 {
	meta:
		name = "__pclose"
		size = 211
		refs = "0003 __sehtable$__pclose 0008 __SEH_prolog4 0021 __errno 0031 __invalid_parameter 0043 __mtinitlocknum 004f __lock 0058 _idtab 0071 _fclose 008d __cwait 00c5 __SEH_epilog4 00cd __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D E4 FF 33 C0 8B 7D 08 33 DB 3B FB 0F 95 C0 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 84 00 00 00 6A 09 E8 ?? ?? ?? ?? 59 85 C0 74 EC 6A 09 E8 ?? ?? ?? ?? 59 89 5D FC E8 ?? ?? ?? ?? 8B F0 3B F3 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB 46 57 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 38 E8 ?? ?? ?? ?? 89 18 6A 01 FF 76 04 8D 45 08 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 0A E8 ?? ?? ?? ?? 83 38 04 75 06 8B 45 08 89 45 E4 E8 ?? ?? ?? ?? 89 38 89 1E 89 5E 04 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 09 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_214_2_0 {
	meta:
		name = "__CIlog10_default"
		size = 213
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0032 __DEFAULT_CW_in_mem 004c ___fastflag 0053 __fast_exit 0059 LOG_name 0063 __math_exit 0089 __indefinite 0095 __convertTOStoQNaN 00ad __minfinity 00cf __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 4C 8B 44 24 0C 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? A9 00 00 F0 7F 74 5E A9 00 00 00 80 75 41 D9 EC D9 C9 D9 F1 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1B 00 00 00 E9 ?? ?? ?? ?? A9 00 00 00 80 75 17 EB D4 A9 FF FF 0F 00 75 1D 83 7C 24 08 00 75 16 25 00 00 00 80 74 C5 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 EB 22 E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 C5 83 7C 24 08 00 75 BE DD D8 DB 2D ?? ?? ?? ?? B8 02 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1B 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_217_1_0 {
	meta:
		name = "_perror"
		size = 142
		refs = "0003 __sehtable$_perror 0008 __SEH_prolog4 0014 ___lock_fhandle 002b _strlen 0033 __write_nolock 0039 ??_C@_02LMMGGCAJ@?3?5?$AA@ 0047 __errno 004e __get_sys_err_msg 0065 ??_C@_01EEMJAFIK@?6?$AA@ 007f __SEH_epilog4 0088 __unlock_fhandle"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 02 5E 89 75 E4 56 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 7D 08 85 FF 74 22 80 3F 00 74 1D 57 E8 ?? ?? ?? ?? 50 57 56 E8 ?? ?? ?? ?? 56 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 1C E8 ?? ?? ?? ?? FF 30 E8 ?? ?? ?? ?? 8B F8 57 E8 ?? ?? ?? ?? 50 57 56 E8 ?? ?? ?? ?? 6A 01 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 20 C7 45 FC FE FF FF FF E8 06 00 00 00 E8 ?? ?? ?? ?? C3 FF 75 E4 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "?DebuggerProbe@@YAHK@Z"
		size = 80
		refs = "0003 __sehtable$?DebuggerProbe@@YAHK@Z 0008 __SEH_prolog4 0032 __imp__RaiseException@16 004b __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 88 45 E7 C7 45 CC 01 10 00 00 89 4D D0 8D 4D E7 89 4D D4 89 45 FC 8D 4D CC 51 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 07 83 C8 FF C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "?DebuggerRuntime@@YAHKHPAXPB_W@Z"
		size = 98
		refs = "0003 __sehtable$?DebuggerRuntime@@YAHKHPAXPB_W@Z 0008 __SEH_prolog4 0044 __imp__RaiseException@16 005d __SEH_epilog4"
	strings:
		$1 = { 6A 24 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 88 45 E7 C7 45 CC 02 10 00 00 89 4D D0 8B 4D 08 89 4D D4 8B 4D 0C 89 4D D8 8D 4D E7 89 4D DC 8B 4D 10 89 4D E0 89 45 FC 8D 4D CC 51 6A 06 50 68 88 13 6D 40 FF 15 ?? ?? ?? ?? EB 07 83 C8 FF C3 8B 65 E8 C7 45 FC FE FF FF FF 0F B6 45 E7 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_219_3_0 {
	meta:
		name = "?failwithmessage@@YAXPAXHHPBD@Z"
		size = 494
		refs = "000f ___security_cookie 002f ?_RTC_GetErrorFuncW@@YAP6AHHPB_WH00ZZPBX@Z 003d ?_RTC_GetErrorFunc@@YAP6AHHPBDH00ZZPBX@Z 004c __imp__MultiByteToWideChar@24 0076 ??_C@_1GM@OLMCBDMB@?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAE?$AAr?$AAr?$AAo?$AAr?$AA?4?$AA?6?$AA?$AN?$AA?5?$AAU?$AAn?$AAa?$AAb?$AAl?$AAe?$AA?5?$AAt?$AAo@ 0080 ?DebuggerProbe@@YAHK@Z 0095 __RTC_NoFalsePositives 009a ?DebuggerRuntime@@YAHKHPAXPB_W@Z 00c3 __imp__IsDebuggerPresent@0 00f0 ?_RTC_GetSrcLine@@YAHPAEPA_WKPAH1K@Z 010a ??_C@_1EA@NFKNIFJP@?$AAR?$AAu?$AAn?$AA?9?$AAT?$AAi?$AAm?$AAe?$AA?5?$AAC?$AAh?$AAe?$AAc?$AAk?$AA?5?$AAF?$AAa?$AAi?$AAl?$AAu?$AAr?$AAe?$AA?5?$AA?$CD?$AA?$CF?$AAd?$AA?5?$AA?9?$AA?5?$AA?$CF?$AAs?$AA?$AA@ 0129 __imp__WideCharToMultiByte@32 016b ??_C@_0BB@PFFGGCJP@Unknown?5Filename?$AA@ 01a6 ??_C@_0BE@GNBOBNCK@Unknown?5Module?5Name?$AA@ 01b4 ??_C@_0CA@IODNCDPG@Run?9Time?5Check?5Failure?5?$CD?$CFd?5?9?5?$CFs?$AA@ 01d2 __imp__DebugBreak@0 01e2 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 44 F2 FF FF 81 EC 3C 0E 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 B8 0D 00 00 53 56 8B F1 57 8B FA 33 DB 56 89 75 88 89 7D 80 89 5D 84 E8 ?? ?? ?? ?? 3B C3 59 89 45 8C 75 0A 56 E8 ?? ?? ?? ?? 59 89 45 84 53 53 6A FF 57 8B 3D ?? ?? ?? ?? 53 BE E9 FD 00 00 56 FF D7 3D 00 02 00 00 73 15 50 8D 45 90 50 6A FF FF 75 80 53 56 FF D7 85 C0 8D 7D 90 75 05 BF ?? ?? ?? ?? B9 02 10 00 00 E8 ?? ?? ?? ?? 85 C0 74 25 8B 8D C8 0D 00 00 57 FF 75 88 FF 34 8D ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 2D 01 00 00 32 C0 EB 02 B0 01 39 5D 84 75 09 39 5D 8C 0F 84 13 01 00 00 3A C3 74 0E FF 15 ?? ?? ?? ?? 85 C0 0F 85 01 01 00 00 B8 04 01 00 00 50 8D 8D A8 09 00 00 51 8D 4D 88 51 50 8D 85 B0 0B 00 00 50 8B 45 88 83 C0 FB 50 E8 ?? ?? ?? ?? 83 C4 18 39 5D 8C 74 2B 57 FF B5 C8 0D 00 00 8D 85 A8 09 00 00 68 ?? ?? ?? ?? 50 FF 75 88 8D 85 B0 0B 00 00 50 FF B5 C4 0D 00 00 FF 55 8C E9 A1 00 00 00 8B 3D ?? ?? ?? ?? 53 53 53 53 6A FF 8D 85 B0 0B 00 00 50 53 56 FF D7 3B C3 74 26 53 53 50 8D 85 90 03 00 00 50 6A FF 8D 85 B0 0B 00 00 50 53 56 FF D7 85 C0 74 0B 8D 85 90 03 00 00 89 45 8C EB 07 C7 45 8C ?? ?? ?? ?? 53 53 53 53 6A FF 8D 85 A8 09 00 00 50 53 56 FF D7 3B C3 74 21 53 53 50 8D 85 A0 07 00 00 50 6A FF 8D 85 A8 09 00 00 50 53 56 FF D7 85 C0 8D 85 A0 07 00 00 75 05 B8 ?? ?? ?? ?? FF 75 80 FF B5 C8 0D 00 00 68 ?? ?? ?? ?? 50 FF 75 88 FF 75 8C FF B5 C4 0D 00 00 FF 55 84 83 C4 1C 83 F8 01 75 06 FF 15 ?? ?? ?? ?? 8B 8D B8 0D 00 00 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 81 C5 BC 0D 00 00 C9 C3 }
	condition:
		$1
}

rule file_219_4_0 {
	meta:
		name = "?_RTC_Failure@@YAXPAXH@Z"
		size = 56
		refs = "000c ?_RTC_ErrorLevels@@3PAHA 0013 __RTC_ErrorMessages 0031 ?failwithmessage@@YAXPAXHHPBD@Z"
	strings:
		$1 = { 8B 4C 24 08 83 F9 04 77 10 8B 04 8D ?? ?? ?? ?? 8B 14 8D ?? ?? ?? ?? EB 0C 8B 15 ?? ?? ?? ?? 33 C0 6A 05 40 59 83 F8 FF 74 0D 51 8B 4C 24 08 50 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_219_5_0 {
	meta:
		name = "?_RTC_StackFailure@@YAXPAXPBD@Z"
		size = 241
		refs = "000a ___security_cookie 0015 ?_RTC_ErrorLevels@@3PAHA 005a _stack_premsg 0094 _stack_postmsg 00c8 ??_C@_0CG@IAFNJNEE@Stack?5corrupted?5near?5unknown?5var@ 00dd ?failwithmessage@@YAXPAXHHPBD@Z 00eb @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 08 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 45 08 56 8B 75 0C 89 85 F8 FB FF FF 0F 84 B7 00 00 00 80 3E 00 53 0F 84 90 00 00 00 8B CE 8D 51 01 8A 01 41 84 C0 75 F9 2B CA 83 C1 2D 81 F9 00 04 00 00 77 77 8D 9D FC FB FF FF 33 C9 8A 81 ?? ?? ?? ?? 88 84 0D FC FB FF FF 41 84 C0 75 EE 8B C6 8B D6 8A 08 40 84 C9 75 F9 57 8D BD FC FB FF FF 2B C2 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 B8 ?? ?? ?? ?? F3 A4 8B C8 8A 10 40 84 D2 75 F9 8D BD FC FB FF FF 2B C1 8B F1 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 5F EB 05 BB ?? ?? ?? ?? 8B 8D F8 FB FF FF 6A 02 FF 35 ?? ?? ?? ?? 8B D3 E8 ?? ?? ?? ?? 59 59 5B 8B 4D FC 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_219_6_0 {
	meta:
		name = "?_getMemBlockDataString@@YAXPAD00I@Z"
		size = 101
		refs = "0032 ??_C@_05MKKEDADM@?$CF?42X?5?$AA@ 003b ?wsprintffp@@3P6AHPADPBDZZA"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 53 56 89 45 FC 8B 45 10 57 8B 7D 08 33 F6 2B C7 89 45 F8 8B 4D 14 83 F9 10 72 03 6A 10 59 3B F1 73 25 8A 1C 38 0F B6 C3 50 68 ?? ?? ?? ?? FF 75 FC FF 15 ?? ?? ?? ?? 83 45 FC 03 8B 45 F8 83 C4 0C 88 1F 46 47 EB CC 8B 45 08 C6 04 06 00 6B F6 03 8B 45 0C 5F C6 04 06 00 5E 5B C9 C3 }
	condition:
		$1
}

rule file_219_7_0 {
	meta:
		name = "?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
		size = 285
		refs = "000a ___security_cookie 0016 ?_RTC_ErrorLevels@@3PAHA 0032 ??_C@_0L@GMPLCCII@user32?4dll?$AA@ 0038 __imp__LoadLibraryA@4 0045 ??_C@_09FOPFMPEJ@wsprintfA?$AA@ 004c __imp__GetProcAddress@8 0053 ?wsprintffp@@3P6AHPADPBDZZA 0069 ??_C@_08OMAHNMHJ@?6Data?3?5?$DM?$AA@ 0074 ??_C@_0CK@DKGBICFE@?6Allocation?5number?5within?5this?5f@ 007a ??_C@_07DFDJCKFN@?6Size?3?5?$AA@ 0083 ??_C@_0N@MHFFIMFG@?6Address?3?50x?$AA@ 0088 ??_C@_0EI@CLEPFNGI@Stack?5area?5around?5_alloca?5memory@ 0093 ??_C@_0BC@KIBAILCI@?$CFs?$CFs?$CFp?$CFs?$CFld?$CFs?$CFd?$CFs?$AA@ 00ab ?_getMemBlockDataString@@YAXPAD00I@Z 00b3 ??_C@_01EEMJAFIK@?6?$AA@ 00bc ??_C@_02LLMPMKNF@?$DO?5?$AA@ 00c5 ??_C@_08KJEDNCKC@?$CFs?$CFs?$CFs?$CFs?$AA@ 00d2 __imp__lstrlenA@4 00f4 ?failwithmessage@@YAXPAXHHPBD@Z 0101 ??_C@_0EJ@LJKNEOLN@Stack?5area?5around?5_alloca?5memory@ 0117 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 8B 1D ?? ?? ?? ?? 83 FB FF 56 8B 75 0C 57 8B 7D 08 89 BD BC FE FF FF 0F 84 DD 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 84 B9 00 00 00 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 F6 A3 ?? ?? ?? ?? 0F 84 A0 00 00 00 85 C0 0F 84 98 00 00 00 8B 4E 0C 68 ?? ?? ?? ?? FF 75 10 83 E9 24 68 ?? ?? ?? ?? 51 68 ?? ?? ?? ?? 8D 7E 20 57 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 8D C0 FE FF FF 68 ?? ?? ?? ?? 51 FF D0 8B 46 0C 83 E8 24 50 57 8D 45 B4 50 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 38 68 ?? ?? ?? ?? 8D 45 B4 50 68 ?? ?? ?? ?? 8D 45 E8 50 68 ?? ?? ?? ?? 8D 85 C0 FE FF FF 50 FF 15 ?? ?? ?? ?? 8D 84 05 C0 FE FF FF 50 FF 15 ?? ?? ?? ?? 8B 8D BC FE FF FF 6A 04 53 8D 95 C0 FE FF FF E8 ?? ?? ?? ?? 83 C4 20 EB 11 6A 04 53 BA ?? ?? ?? ?? 8B CF E8 ?? ?? ?? ?? 59 59 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_219_8_0 {
	meta:
		name = "__RTC_UninitUse"
		size = 224
		refs = "000a ___security_cookie 0015 ?_RTC_ErrorLevels@@3PAHA 0050 _uninit_premsg 0088 _uninit_postmsg 00bc ??_C@_0DA@BEGFPCGG@A?5variable?5is?5being?5used?5without@ 00cc ?failwithmessage@@YAXPAXHHPBD@Z 00da @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 04 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 83 3D ?? ?? ?? ?? FF 8B 45 08 0F 84 B1 00 00 00 85 C0 53 56 0F 84 8E 00 00 00 8B C8 8D 71 01 8A 19 41 84 DB 75 F9 2B CE 83 C1 36 81 F9 00 04 00 00 77 75 8D 95 FC FB FF FF 33 C9 8A 99 ?? ?? ?? ?? 88 9C 0D FC FB FF FF 41 84 DB 75 EE 8B F0 8A 08 40 84 C9 75 F9 57 8D BD FC FB FF FF 2B C6 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 B8 ?? ?? ?? ?? F3 A4 8B C8 8A 18 40 84 DB 75 F9 8D BD FC FB FF FF 2B C1 8B F1 4F 8A 4F 01 47 84 C9 75 F8 8B C8 C1 E9 02 F3 A5 8B C8 83 E1 03 F3 A4 5F EB 05 BA ?? ?? ?? ?? 8B 4D 04 6A 03 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_220_0_0 {
	meta:
		name = "__execlp"
		size = 71
		refs = "000c __errno 001c __invalid_parameter 003f __execvp"
	strings:
		$1 = { 8B 4C 24 04 53 33 DB 3B CB 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5B C3 38 19 74 DF 8B 44 24 0C 3B C3 74 D7 38 18 74 D3 8D 44 24 0C 50 51 E8 ?? ?? ?? ?? 59 59 5B C3 }
	condition:
		$1
}

rule file_222_0_0 {
	meta:
		name = "__setmode_nolock"
		size = 188
		refs = "0019 ___pioinfo"
	strings:
		$1 = { 55 8B EC 8B 55 08 8B C2 C1 F8 05 83 E2 1F 6B D2 28 53 8B 5D 0C 56 8D 34 85 ?? ?? ?? ?? 8B 06 8D 0C 10 0F B6 41 04 25 80 00 00 00 89 45 08 8A 41 24 02 C0 0F BE C0 57 BF 00 40 00 00 D1 F8 3B DF 74 50 81 FB 00 80 00 00 74 42 81 FB 00 00 01 00 74 26 81 FB 00 00 02 00 74 1E 81 FB 00 00 04 00 75 3D 80 49 04 80 8B 0E 8D 4C 11 24 8A 11 80 E2 81 80 CA 01 88 11 EB 27 80 49 04 80 8B 0E 8D 4C 11 24 8A 11 80 E2 82 80 CA 02 EB E8 80 61 04 7F EB 0D 80 49 04 80 8B 0E 8D 4C 11 24 80 21 80 83 7D 08 00 75 07 B8 00 80 00 00 EB 0B F7 D8 1B C0 25 00 C0 00 00 03 C7 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_222_1_0 {
	meta:
		name = "__set_fmode"
		size = 70
		refs = "001a __errno 002c __invalid_parameter 0039 __fmode 003f __imp__InterlockedExchange@8"
	strings:
		$1 = { 8B 44 24 04 3D 00 40 00 00 74 2C 3D 00 80 00 00 74 25 3D 00 00 01 00 74 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 C3 50 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_222_3_0 {
	meta:
		name = "__setmode"
		size = 247
		refs = "0003 __sehtable$__setmode 0008 __SEH_prolog4 0033 __errno 0045 __invalid_parameter 0071 __nhandle 008c ___pioinfo 00a6 ___lock_fhandle 00be __setmode_nolock 00e8 __SEH_epilog4 00f1 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 0C 3D 00 40 00 00 74 3E 3D 00 80 00 00 74 37 3D 00 00 01 00 74 30 3D 00 00 04 00 74 29 3D 00 00 02 00 74 22 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 DB 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 93 00 00 00 8B 45 08 83 F8 FE 75 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB E3 33 DB 3B C3 7C 08 3B 05 ?? ?? ?? ?? 72 0D E8 ?? ?? ?? ?? C7 00 09 00 00 00 EB BB 8B C8 C1 F9 05 8D 3C 8D ?? ?? ?? ?? 8B F0 83 E6 1F 6B F6 28 8B 0F 0F B6 4C 31 04 83 E1 01 74 D3 50 E8 ?? ?? ?? ?? 59 89 5D FC 8B 07 F6 44 30 04 01 74 12 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 E4 EB 0F E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "__ZeroTail"
		size = 69
	strings:
		$1 = { 8B 44 24 08 99 6A 1F 59 23 D1 03 C2 8B 54 24 08 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 2B CA 83 CA FF D3 E2 8B 4C 24 04 F7 D2 85 14 81 74 09 33 C0 C3 83 3C 81 00 75 F7 40 83 F8 03 7C F4 33 C0 40 C3 }
	condition:
		$1
}

rule file_223_2_0 {
	meta:
		name = "__IncMan"
		size = 106
	strings:
		$1 = { 8B 44 24 08 53 56 57 99 6A 1F 59 23 D1 03 C2 8B 54 24 14 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 8B 7C 24 10 2B CA 33 D2 42 D3 E2 8B 0C 87 33 DB 8D 34 11 3B F1 72 04 3B F2 73 03 33 DB 43 89 34 87 EB 1B 85 DB 74 1A 8B 0C 87 8D 51 01 33 DB 3B D1 72 05 83 FA 01 73 03 33 DB 43 89 14 87 48 79 E2 5F 5E 8B C3 5B C3 }
	condition:
		$1
}

rule file_223_3_0 {
	meta:
		name = "__RoundMan"
		size = 238
	strings:
		$1 = { 55 8B EC 51 51 83 65 FC 00 53 56 57 8B 7D 0C 4F 8D 4F 01 8B C1 99 83 E2 1F 03 C2 8B D8 8B C1 C1 FB 05 25 1F 00 00 80 79 05 48 83 C8 E0 40 8B 75 08 6A 1F 59 2B C8 33 C0 40 D3 E0 89 4D F8 85 04 9E 0F 84 81 00 00 00 83 CA FF D3 E2 8B C3 F7 D2 85 14 86 EB 04 83 3C 86 00 75 08 40 83 F8 03 7C F4 EB 65 8B C7 99 6A 1F 59 23 D1 03 C2 C1 F8 05 81 E7 1F 00 00 80 79 05 4F 83 CF E0 47 83 65 0C 00 33 D2 2B CF 42 D3 E2 8B 0C 86 8D 3C 11 3B F9 72 04 3B FA 73 07 C7 45 0C 01 00 00 00 8B 4D 0C 89 3C 86 EB 1D 85 C9 74 1C 8B 0C 86 8D 51 01 33 FF 3B D1 72 05 83 FA 01 73 03 33 FF 47 89 14 86 8B CF 48 79 E0 89 4D FC 8B 4D F8 83 C8 FF D3 E0 6A 03 59 21 04 9E 43 3B D9 7D 0B 8D 34 9E 2B CB 33 C0 8B FE F3 AB 8B 45 FC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_223_4_0 {
	meta:
		name = "__CopyMan"
		size = 27
	strings:
		$1 = { 8B 44 24 08 8B 4C 24 04 6A 03 5A 2B C8 56 8B 30 89 34 01 83 C0 04 4A 75 F5 5E C3 }
	condition:
		$1
}

rule file_223_6_0 {
	meta:
		name = "__IsZeroMan"
		size = 25
	strings:
		$1 = { 33 C0 8B 4C 24 04 83 3C 81 00 75 0A 40 83 F8 03 7C F0 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_223_7_0 {
	meta:
		name = "__ShrMan"
		size = 152
	strings:
		$1 = { 55 8B EC 8B 45 0C 99 83 E2 1F 83 EC 0C 03 C2 8B 55 0C 56 C1 F8 05 81 E2 1F 00 00 80 57 79 05 4A 83 CA E0 42 83 65 F8 00 83 65 0C 00 8B 7D 08 83 CE FF 8B CA D3 E6 C7 45 FC 20 00 00 00 29 55 FC 53 F7 D6 8B 4D 0C 8B 1C 8F 23 DE 89 5D F4 8B 1C 8F 8B CA D3 EB 8B 4D 0C 0B 5D F8 89 1C 8F 8B 5D F4 8B 4D FC D3 E3 FF 45 0C 83 7D 0C 03 89 5D F8 7C D1 6A 02 59 8B D1 2B D0 8D 14 97 5B 3B C8 7C 07 8B 32 89 34 8F EB 04 83 24 8F 00 49 83 EA 04 85 C9 7D E9 5F 5E C9 C3 }
	condition:
		$1
}

rule file_223_8_0 {
	meta:
		name = "__ld12cvt"
		size = 1321
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 45 08 0F B7 48 0A 53 8B D9 81 E1 00 80 00 00 89 4D EC 8B 48 06 89 4D E0 8B 48 02 0F B7 00 81 E3 FF 7F 00 00 81 EB FF 3F 00 00 C1 E0 10 81 FB 01 C0 FF FF 56 57 89 4D E4 89 45 E8 75 19 33 F6 33 C0 39 74 85 E0 0F 85 1E 01 00 00 40 83 F8 03 7C F0 E9 89 04 00 00 8B 45 10 83 65 08 00 8D 75 E0 8D 7D D4 A5 A5 A5 8B 70 08 4E 8D 4E 01 8B C1 99 83 E2 1F 03 C2 C1 F8 05 8B D1 81 E2 1F 00 00 80 89 5D F0 89 45 F4 79 05 4A 83 CA E0 42 8D 7C 85 E0 6A 1F 33 C0 59 2B CA 40 D3 E0 89 4D F8 85 07 0F 84 8D 00 00 00 8B 45 F4 83 CA FF D3 E2 F7 D2 85 54 85 E0 EB 05 83 7C 85 E0 00 75 08 40 83 F8 03 7C F3 EB 6E 8B C6 99 6A 1F 59 23 D1 03 C2 C1 F8 05 81 E6 1F 00 00 80 79 05 4E 83 CE E0 46 83 65 FC 00 2B CE 33 D2 42 D3 E2 8D 4C 85 E0 8B 31 03 F2 89 75 08 8B 31 39 75 08 72 22 39 55 08 EB 1B 85 C9 74 2B 83 65 FC 00 8D 4C 85 E0 8B 11 8D 72 01 3B F2 89 75 08 72 05 83 FE 01 73 07 C7 45 FC 01 00 00 00 48 8B 55 08 89 11 8B 4D FC 79 D1 89 4D 08 8B 4D F8 83 C8 FF D3 E0 6A 03 59 21 07 8B 45 F4 40 3B C1 7D 0A 8D 7C 85 E0 2B C8 33 C0 F3 AB 33 F6 39 75 08 74 01 43 8B 4D 10 8B 41 04 8B D0 2B 51 08 3B DA 7D 0D 33 C0 8D 7D E0 AB AB AB E9 0F 02 00 00 3B D8 0F 8F 0F 02 00 00 2B 45 F0 8D 75 D4 8B C8 8D 7D E0 A5 99 83 E2 1F 03 C2 A5 8B D1 C1 F8 05 81 E2 1F 00 00 80 A5 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CF FF 8B CA D3 E7 C7 45 FC 20 00 00 00 29 55 FC F7 D7 8B 5D 08 8D 5C 9D E0 8B 33 8B CE 23 CF 89 4D F0 8B CA D3 EE 8B 4D FC 0B 75 F4 89 33 8B 75 F0 D3 E6 FF 45 08 83 7D 08 03 89 75 F4 7C D3 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 8B 45 10 8B 70 08 4E 8D 4E 01 8B C1 99 83 E2 1F 03 C2 C1 F8 05 8B D1 81 E2 1F 00 00 80 89 45 F4 79 05 4A 83 CA E0 42 6A 1F 59 2B CA 33 D2 42 D3 E2 8D 5C 85 E0 89 4D F0 85 13 0F 84 82 00 00 00 83 CA FF D3 E2 F7 D2 85 54 85 E0 EB 05 83 7C 85 E0 00 75 08 40 83 F8 03 7C F3 EB 66 8B C6 99 6A 1F 59 23 D1 03 C2 C1 F8 05 81 E6 1F 00 00 80 79 05 4E 83 CE E0 46 83 65 08 00 33 D2 2B CE 42 D3 E2 8D 4C 85 E0 8B 31 8D 3C 16 3B FE 72 04 3B FA 73 07 C7 45 08 01 00 00 00 89 39 8B 4D 08 EB 1F 85 C9 74 1E 8D 4C 85 E0 8B 11 8D 72 01 33 FF 3B F2 72 05 83 FE 01 73 03 33 FF 47 89 31 8B CF 48 79 DE 8B 4D F0 83 C8 FF D3 E0 21 03 8B 45 F4 40 83 F8 03 7D 0D 6A 03 59 8D 7C 85 E0 2B C8 33 C0 F3 AB 8B 45 10 8B 48 0C 41 8B C1 99 83 E2 1F 03 C2 8B D1 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CF FF 8B CA D3 E7 C7 45 FC 20 00 00 00 29 55 FC F7 D7 8B 5D 08 8D 5C 9D E0 8B 33 8B CE 23 CF 89 4D F0 8B CA D3 EE 8B 4D FC 0B 75 F4 89 33 8B 75 F0 D3 E6 FF 45 08 83 7D 08 03 89 75 F4 7C D3 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 33 F6 6A 02 58 E9 54 01 00 00 3B 19 0F 8C AC 00 00 00 33 C0 8D 7D E0 AB AB AB 81 4D E0 00 00 00 80 8B C1 8B 48 0C 8B C1 99 83 E2 1F 03 C2 8B D1 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CE FF 8B CA D3 E6 C7 45 FC 20 00 00 00 29 55 FC F7 D6 8B 5D 08 8D 5C 9D E0 8B 3B 8B CF 23 CE 89 4D F0 8B CA D3 EF 8B 4D FC 0B 7D F4 89 3B 8B 7D F0 D3 E7 FF 45 08 83 7D 08 03 89 7D F4 7C D3 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 8B 45 10 8B 70 14 03 30 33 C0 40 E9 A0 00 00 00 81 65 E0 FF FF FF 7F 8B C1 8B 48 0C 8B 70 14 8B C1 99 83 E2 1F 03 C2 03 F3 8B D8 8B D1 C1 FB 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CF FF 8B CA D3 E7 C7 45 FC 20 00 00 00 29 55 FC F7 D7 8B 45 08 8B 44 85 E0 8B C8 23 CF 89 4D F0 8B CA D3 E8 8B 4D 08 0B 45 F4 89 44 8D E0 8B 45 F0 8B 4D FC D3 E0 FF 45 08 83 7D 08 03 89 45 F4 7C D0 8B D3 6A 02 C1 E2 02 8D 45 E8 59 2B C2 3B CB 7C 08 8B 10 89 54 8D E0 EB 05 83 64 8D E0 00 49 83 E8 04 85 C9 7D E7 33 C0 8B 55 10 6A 1F 59 2B 4A 0C D3 E6 8B 4D EC F7 D9 1B C9 81 E1 00 00 00 80 0B F1 8B 4A 10 0B 75 E0 83 F9 40 75 0D 8B 4D 0C 8B 55 E4 89 71 04 89 11 EB 0A 83 F9 20 75 05 8B 4D 0C 89 31 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_223_9_0 {
	meta:
		name = "__ld12tod"
		size = 1346
		refs = "007a _DoubleFormat"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 45 08 0F B7 48 0A 53 8B D9 81 E1 00 80 00 00 89 4D EC 8B 48 06 89 4D E0 8B 48 02 0F B7 00 81 E3 FF 7F 00 00 81 EB FF 3F 00 00 C1 E0 10 81 FB 01 C0 FF FF 57 89 4D E4 89 45 E8 75 27 33 DB 33 C0 39 5C 85 E0 75 0D 40 83 F8 03 7C F4 33 C0 E9 A5 04 00 00 33 C0 8D 7D E0 AB AB 6A 02 AB 58 E9 95 04 00 00 83 65 08 00 56 8D 75 E0 8D 7D D4 A5 A5 A5 8B 35 ?? ?? ?? ?? 4E 8D 4E 01 8B C1 99 83 E2 1F 03 C2 C1 F8 05 8B D1 81 E2 1F 00 00 80 89 5D F0 89 45 F4 79 05 4A 83 CA E0 42 8D 7C 85 E0 6A 1F 33 C0 59 2B CA 40 D3 E0 89 4D F8 85 07 0F 84 8D 00 00 00 8B 45 F4 83 CA FF D3 E2 F7 D2 85 54 85 E0 EB 05 83 7C 85 E0 00 75 08 40 83 F8 03 7C F3 EB 6E 8B C6 99 6A 1F 59 23 D1 03 C2 C1 F8 05 81 E6 1F 00 00 80 79 05 4E 83 CE E0 46 83 65 FC 00 2B CE 33 D2 42 D3 E2 8D 4C 85 E0 8B 31 03 F2 89 75 08 8B 31 39 75 08 72 22 39 55 08 EB 1B 85 C9 74 2B 83 65 FC 00 8D 4C 85 E0 8B 11 8D 72 01 3B F2 89 75 08 72 05 83 FE 01 73 07 C7 45 FC 01 00 00 00 48 8B 55 08 89 11 8B 4D FC 79 D1 89 4D 08 8B 4D F8 83 C8 FF D3 E0 21 07 8B 45 F4 40 83 F8 03 7D 0D 6A 03 59 8D 7C 85 E0 2B C8 33 C0 F3 AB 83 7D 08 00 74 01 43 A1 ?? ?? ?? ?? 8B C8 2B 0D ?? ?? ?? ?? 3B D9 7D 0D 33 C0 8D 7D E0 AB AB AB E9 0D 02 00 00 3B D8 0F 8F 0F 02 00 00 2B 45 F0 8D 75 D4 8B C8 8D 7D E0 A5 99 83 E2 1F 03 C2 A5 8B D1 C1 F8 05 81 E2 1F 00 00 80 A5 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CF FF 8B CA D3 E7 C7 45 FC 20 00 00 00 29 55 FC F7 D7 8B 5D 08 8D 5C 9D E0 8B 33 8B CE 23 CF 89 4D F0 8B CA D3 EE 8B 4D FC 0B 75 F4 89 33 8B 75 F0 D3 E6 FF 45 08 83 7D 08 03 89 75 F4 7C D3 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 8B 35 ?? ?? ?? ?? 4E 8D 4E 01 8B C1 99 83 E2 1F 03 C2 C1 F8 05 8B D1 81 E2 1F 00 00 80 89 45 F4 79 05 4A 83 CA E0 42 6A 1F 59 2B CA 33 D2 42 D3 E2 8D 5C 85 E0 89 4D F0 85 13 0F 84 82 00 00 00 83 CA FF D3 E2 F7 D2 85 54 85 E0 EB 05 83 7C 85 E0 00 75 08 40 83 F8 03 7C F3 EB 66 8B C6 99 6A 1F 59 23 D1 03 C2 C1 F8 05 81 E6 1F 00 00 80 79 05 4E 83 CE E0 46 83 65 08 00 33 D2 2B CE 42 D3 E2 8D 4C 85 E0 8B 31 8D 3C 16 3B FE 72 04 3B FA 73 07 C7 45 08 01 00 00 00 89 39 8B 4D 08 EB 1F 85 C9 74 1E 8D 4C 85 E0 8B 11 8D 72 01 33 FF 3B F2 72 05 83 FE 01 73 03 33 FF 47 89 31 8B CF 48 79 DE 8B 4D F0 83 C8 FF D3 E0 21 03 8B 45 F4 40 83 F8 03 7D 0D 6A 03 59 8D 7C 85 E0 2B C8 33 C0 F3 AB 8B 0D ?? ?? ?? ?? 41 8B C1 99 83 E2 1F 03 C2 8B D1 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CF FF 8B CA D3 E7 C7 45 FC 20 00 00 00 29 55 FC F7 D7 8B 5D 08 8D 5C 9D E0 8B 33 8B CE 23 CF 89 4D F0 8B CA D3 EE 8B 4D FC 0B 75 F4 89 33 8B 75 F0 D3 E6 FF 45 08 83 7D 08 03 89 75 F4 7C D3 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 6A 02 33 DB 58 E9 5A 01 00 00 3B 1D ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F 8C AD 00 00 00 33 C0 8D 7D E0 AB AB AB 81 4D E0 00 00 00 80 8B C1 99 83 E2 1F 03 C2 8B D1 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CF FF 8B CA D3 E7 C7 45 FC 20 00 00 00 29 55 FC F7 D7 8B 5D 08 8D 5C 9D E0 8B 33 8B CE 23 CF 89 4D F0 8B CA D3 EE 8B 4D FC 0B 75 F4 89 33 8B 75 F0 D3 E6 FF 45 08 83 7D 08 03 89 75 F4 7C D3 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8D 1C 01 33 C0 40 E9 9B 00 00 00 A1 ?? ?? ?? ?? 81 65 E0 FF FF FF 7F 03 D8 8B C1 99 83 E2 1F 03 C2 8B D1 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CE FF 8B CA D3 E6 C7 45 FC 20 00 00 00 29 55 FC F7 D6 8B 4D 08 8B 7C 8D E0 8B CF 23 CE 89 4D F0 8B CA D3 EF 8B 4D 08 0B 7D F4 89 7C 8D E0 8B 7D F0 8B 4D FC D3 E7 FF 45 08 83 7D 08 03 89 7D F4 7C D0 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 33 C0 5E 6A 1F 59 2B 0D ?? ?? ?? ?? D3 E3 8B 4D EC F7 D9 1B C9 81 E1 00 00 00 80 0B D9 8B 0D ?? ?? ?? ?? 0B 5D E0 83 F9 40 75 0D 8B 4D 0C 8B 55 E4 89 59 04 89 11 EB 0A 83 F9 20 75 05 8B 4D 0C 89 19 5F 5B C9 C3 }
	condition:
		$1
}

rule file_223_10_0 {
	meta:
		name = "__ld12tof"
		size = 1346
		refs = "007a _FloatFormat"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 45 08 0F B7 48 0A 53 8B D9 81 E1 00 80 00 00 89 4D EC 8B 48 06 89 4D E0 8B 48 02 0F B7 00 81 E3 FF 7F 00 00 81 EB FF 3F 00 00 C1 E0 10 81 FB 01 C0 FF FF 57 89 4D E4 89 45 E8 75 27 33 DB 33 C0 39 5C 85 E0 75 0D 40 83 F8 03 7C F4 33 C0 E9 A5 04 00 00 33 C0 8D 7D E0 AB AB 6A 02 AB 58 E9 95 04 00 00 83 65 08 00 56 8D 75 E0 8D 7D D4 A5 A5 A5 8B 35 ?? ?? ?? ?? 4E 8D 4E 01 8B C1 99 83 E2 1F 03 C2 C1 F8 05 8B D1 81 E2 1F 00 00 80 89 5D F0 89 45 F4 79 05 4A 83 CA E0 42 8D 7C 85 E0 6A 1F 33 C0 59 2B CA 40 D3 E0 89 4D F8 85 07 0F 84 8D 00 00 00 8B 45 F4 83 CA FF D3 E2 F7 D2 85 54 85 E0 EB 05 83 7C 85 E0 00 75 08 40 83 F8 03 7C F3 EB 6E 8B C6 99 6A 1F 59 23 D1 03 C2 C1 F8 05 81 E6 1F 00 00 80 79 05 4E 83 CE E0 46 83 65 FC 00 2B CE 33 D2 42 D3 E2 8D 4C 85 E0 8B 31 03 F2 89 75 08 8B 31 39 75 08 72 22 39 55 08 EB 1B 85 C9 74 2B 83 65 FC 00 8D 4C 85 E0 8B 11 8D 72 01 3B F2 89 75 08 72 05 83 FE 01 73 07 C7 45 FC 01 00 00 00 48 8B 55 08 89 11 8B 4D FC 79 D1 89 4D 08 8B 4D F8 83 C8 FF D3 E0 21 07 8B 45 F4 40 83 F8 03 7D 0D 6A 03 59 8D 7C 85 E0 2B C8 33 C0 F3 AB 83 7D 08 00 74 01 43 A1 ?? ?? ?? ?? 8B C8 2B 0D ?? ?? ?? ?? 3B D9 7D 0D 33 C0 8D 7D E0 AB AB AB E9 0D 02 00 00 3B D8 0F 8F 0F 02 00 00 2B 45 F0 8D 75 D4 8B C8 8D 7D E0 A5 99 83 E2 1F 03 C2 A5 8B D1 C1 F8 05 81 E2 1F 00 00 80 A5 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CF FF 8B CA D3 E7 C7 45 FC 20 00 00 00 29 55 FC F7 D7 8B 5D 08 8D 5C 9D E0 8B 33 8B CE 23 CF 89 4D F0 8B CA D3 EE 8B 4D FC 0B 75 F4 89 33 8B 75 F0 D3 E6 FF 45 08 83 7D 08 03 89 75 F4 7C D3 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 8B 35 ?? ?? ?? ?? 4E 8D 4E 01 8B C1 99 83 E2 1F 03 C2 C1 F8 05 8B D1 81 E2 1F 00 00 80 89 45 F4 79 05 4A 83 CA E0 42 6A 1F 59 2B CA 33 D2 42 D3 E2 8D 5C 85 E0 89 4D F0 85 13 0F 84 82 00 00 00 83 CA FF D3 E2 F7 D2 85 54 85 E0 EB 05 83 7C 85 E0 00 75 08 40 83 F8 03 7C F3 EB 66 8B C6 99 6A 1F 59 23 D1 03 C2 C1 F8 05 81 E6 1F 00 00 80 79 05 4E 83 CE E0 46 83 65 08 00 33 D2 2B CE 42 D3 E2 8D 4C 85 E0 8B 31 8D 3C 16 3B FE 72 04 3B FA 73 07 C7 45 08 01 00 00 00 89 39 8B 4D 08 EB 1F 85 C9 74 1E 8D 4C 85 E0 8B 11 8D 72 01 33 FF 3B F2 72 05 83 FE 01 73 03 33 FF 47 89 31 8B CF 48 79 DE 8B 4D F0 83 C8 FF D3 E0 21 03 8B 45 F4 40 83 F8 03 7D 0D 6A 03 59 8D 7C 85 E0 2B C8 33 C0 F3 AB 8B 0D ?? ?? ?? ?? 41 8B C1 99 83 E2 1F 03 C2 8B D1 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CF FF 8B CA D3 E7 C7 45 FC 20 00 00 00 29 55 FC F7 D7 8B 5D 08 8D 5C 9D E0 8B 33 8B CE 23 CF 89 4D F0 8B CA D3 EE 8B 4D FC 0B 75 F4 89 33 8B 75 F0 D3 E6 FF 45 08 83 7D 08 03 89 75 F4 7C D3 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 6A 02 33 DB 58 E9 5A 01 00 00 3B 1D ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 0F 8C AD 00 00 00 33 C0 8D 7D E0 AB AB AB 81 4D E0 00 00 00 80 8B C1 99 83 E2 1F 03 C2 8B D1 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CF FF 8B CA D3 E7 C7 45 FC 20 00 00 00 29 55 FC F7 D7 8B 5D 08 8D 5C 9D E0 8B 33 8B CE 23 CF 89 4D F0 8B CA D3 EE 8B 4D FC 0B 75 F4 89 33 8B 75 F0 D3 E6 FF 45 08 83 7D 08 03 89 75 F4 7C D3 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 A1 ?? ?? ?? ?? 8B 0D ?? ?? ?? ?? 8D 1C 01 33 C0 40 E9 9B 00 00 00 A1 ?? ?? ?? ?? 81 65 E0 FF FF FF 7F 03 D8 8B C1 99 83 E2 1F 03 C2 8B D1 C1 F8 05 81 E2 1F 00 00 80 79 05 4A 83 CA E0 42 83 65 F4 00 83 65 08 00 83 CE FF 8B CA D3 E6 C7 45 FC 20 00 00 00 29 55 FC F7 D6 8B 4D 08 8B 7C 8D E0 8B CF 23 CE 89 4D F0 8B CA D3 EF 8B 4D 08 0B 7D F4 89 7C 8D E0 8B 7D F0 8B 4D FC D3 E7 FF 45 08 83 7D 08 03 89 7D F4 7C D0 8B F0 6A 02 C1 E6 02 8D 4D E8 5A 2B CE 3B D0 7C 08 8B 31 89 74 95 E0 EB 05 83 64 95 E0 00 4A 83 E9 04 85 D2 7D E7 33 C0 5E 6A 1F 59 2B 0D ?? ?? ?? ?? D3 E3 8B 4D EC F7 D9 1B C9 81 E1 00 00 00 80 0B D9 8B 0D ?? ?? ?? ?? 0B 5D E0 83 F9 40 75 0D 8B 4D 0C 8B 55 E4 89 59 04 89 11 EB 0A 83 F9 20 75 05 8B 4D 0C 89 19 5F 5B C9 C3 }
	condition:
		$1
}

rule file_223_11_0 {
	meta:
		name = "__ld12told"
		size = 194
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 4D 08 0F B7 51 0A 83 65 F8 00 53 8B 59 06 56 8B 71 02 0F B7 09 57 8B FA 81 E2 00 80 00 00 8B C2 C1 E1 10 BA 00 00 00 80 81 E7 FF 7F 00 00 85 CA 89 5D EC 89 4D F4 74 5F F7 C1 FF FF FF 7F 74 57 8D 4E 01 33 DB 3B CE 72 05 83 F9 01 73 03 33 DB 43 83 65 08 00 89 4D F0 8B CB 85 C9 74 33 8B 4D 08 83 65 FC 00 8D 4C 8D EC 8B 31 8D 5E 01 3B DE 72 05 83 FB 01 73 07 C7 45 FC 01 00 00 00 FF 4D 08 89 19 8B 4D FC 79 D2 85 C9 74 05 8B DA 47 EB 03 8B 5D EC 8B 75 F0 66 81 FF FF 7F 75 07 C7 45 F8 01 00 00 00 8B 4D 0C 0B C7 5F 89 31 5E 89 59 04 66 89 41 08 8B 45 F8 5B C9 C3 }
	condition:
		$1
}

rule file_224_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsA"
		size = 309
		refs = "0003 ?f_use@?1??__crtGetEnvironmentStringsA@@9@9 000d __imp__GetEnvironmentStringsW@0 0032 __imp__GetLastError@0 007c __imp__WideCharToMultiByte@32 009b __malloc_crt 00be _free 00ce __imp__FreeEnvironmentStringsW@4 00e0 __imp__GetEnvironmentStrings@0 0111 __imp__FreeEnvironmentStringsA@4 011e _memcpy"
	strings:
		$1 = { 51 51 A1 ?? ?? ?? ?? 53 55 56 57 8B 3D ?? ?? ?? ?? 33 DB 33 F6 3B C3 6A 02 5D 75 2D FF D7 8B F0 3B F3 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 22 FF 15 ?? ?? ?? ?? 83 F8 78 75 09 8B C5 A3 ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? 83 F8 01 0F 85 84 00 00 00 3B F3 75 0F FF D7 8B F0 3B F3 75 07 33 C0 E9 C9 00 00 00 66 39 1E 8B C6 74 0E 03 C5 66 39 18 75 F9 03 C5 66 39 18 75 F2 8B 3D ?? ?? ?? ?? 53 53 53 2B C6 53 D1 F8 40 50 56 53 53 89 44 24 34 FF D7 8B E8 3B EB 74 32 55 E8 ?? ?? ?? ?? 3B C3 59 89 44 24 10 74 23 53 53 55 50 FF 74 24 24 56 53 53 FF D7 85 C0 75 0E FF 74 24 10 E8 ?? ?? ?? ?? 59 89 5C 24 10 8B 5C 24 10 56 FF 15 ?? ?? ?? ?? 8B C3 EB 58 3B C5 74 04 3B C3 75 80 FF 15 ?? ?? ?? ?? 8B F0 3B F3 0F 84 70 FF FF FF 38 1E 74 0A 40 38 18 75 FB 40 38 18 75 F6 2B C6 40 8B E8 55 E8 ?? ?? ?? ?? 8B F8 3B FB 59 75 0C 56 FF 15 ?? ?? ?? ?? E9 44 FF FF FF 55 56 57 E8 ?? ?? ?? ?? 83 C4 0C 56 FF 15 ?? ?? ?? ?? 8B C7 5F 5E 5D 5B 59 59 C3 }
	condition:
		$1
}

rule file_226_0_0 {
	meta:
		name = "__chkstk"
		size = 43
	strings:
		$1 = { 51 8D 4C 24 04 2B C8 1B C0 F7 D0 23 C8 8B C4 25 00 F0 FF FF 3B C8 72 0A 8B C1 59 94 8B 00 89 04 24 C3 2D 00 10 00 00 85 00 EB E9 }
	condition:
		$1
}

rule file_227_0_0 {
	meta:
		name = "___report_gsfailure"
		size = 260
		refs = "000a _GS_ContextRecord 008b _GS_ExceptionRecord 00a4 ___security_cookie 00af ___security_cookie_complement 00bb __imp__IsDebuggerPresent@0 00c0 _DebuggerWasPresent 00c7 __crt_debugger_hook 00d0 __imp__SetUnhandledExceptionFilter@4 00d5 _GS_ExceptionPointers 00db __imp__UnhandledExceptionFilter@4 00f7 __imp__GetCurrentProcess@0 00fe __imp__TerminateProcess@8"
	strings:
		$1 = { 55 8B EC 81 EC 28 03 00 00 A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 1D ?? ?? ?? ?? 89 35 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 66 8C 15 ?? ?? ?? ?? 66 8C 0D ?? ?? ?? ?? 66 8C 1D ?? ?? ?? ?? 66 8C 05 ?? ?? ?? ?? 66 8C 25 ?? ?? ?? ?? 66 8C 2D ?? ?? ?? ?? 9C 8F 05 ?? ?? ?? ?? 8B 45 00 A3 ?? ?? ?? ?? 8B 45 04 A3 ?? ?? ?? ?? 8D 45 08 A3 ?? ?? ?? ?? 8B 85 E0 FC FF FF C7 05 ?? ?? ?? ?? 01 00 01 00 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? 09 04 00 C0 C7 05 ?? ?? ?? ?? 01 00 00 00 A1 ?? ?? ?? ?? 89 85 D8 FC FF FF A1 ?? ?? ?? ?? 89 85 DC FC FF FF FF 15 ?? ?? ?? ?? A3 ?? ?? ?? ?? 6A 01 E8 ?? ?? ?? ?? 59 6A 00 FF 15 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 75 08 6A 01 E8 ?? ?? ?? ?? 59 68 09 04 00 C0 FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "__putch_nolock"
		size = 120
		refs = "0008 __getptd 0030 _isleadbyte 004d _mbtowc 005d __putwch_nolock"
	strings:
		$1 = { 55 8B EC 51 53 56 57 E8 ?? ?? ?? ?? 8B F0 66 83 7E 52 01 8A 45 08 8D 7E 4C 8A D8 75 05 88 47 01 EB 02 88 07 66 83 7E 52 00 75 16 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 74 08 66 C7 46 52 01 00 EB 2F 0F B7 46 52 40 50 8D 45 FC 57 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 74 0F FF 75 FC E8 ?? ?? ?? ?? 66 3D FF FF 59 75 03 80 CB FF 66 83 66 52 00 5F 5E 0F B6 C3 5B C9 C3 }
	condition:
		$1
}

rule file_228_1_0 {
	meta:
		name = "__putch"
		size = 66
		refs = "0003 __sehtable$__putch 0008 __SEH_prolog4 000f __lock 001c __putch_nolock 0034 __SEH_epilog4 003c __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 03 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_229_0_0 {
	meta:
		name = "_fwprintf"
		size = 148
		refs = "0003 __sehtable$_fwprintf 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 004a __lock_file 0054 __stbuf 0064 __woutput_l 006e __ftbuf 0085 __SEH_epilog4 008e __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 7D 08 33 F6 3B FE 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4B 33 C0 39 75 0C 0F 95 C0 3B C6 74 D7 89 7D 08 57 E8 ?? ?? ?? ?? 59 89 75 FC 57 E8 ?? ?? ?? ?? 8B D8 8D 45 10 50 56 FF 75 0C 57 E8 ?? ?? ?? ?? 89 45 E4 57 53 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_229_1_0 {
	meta:
		name = "__fwprintf_l"
		size = 26
		refs = "0012 __vfwprintf_l"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_244_1_0 {
	meta:
		name = "___swprintf_l"
		size = 26
		refs = "0012 ___vswprintf_l"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_509_1_0 {
	meta:
		name = "__fprintf_l"
		size = 26
		refs = "0012 __vfprintf_l"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_509_4_0 {
	meta:
		name = "__fprintf_p_l"
		size = 26
		refs = "0012 __vfprintf_p_l"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_509_2_0 {
	meta:
		name = "__fprintf_s_l"
		size = 26
		refs = "0012 __vfprintf_s_l"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_229_4_0 {
	meta:
		name = "__fwprintf_p_l"
		size = 26
		refs = "0012 __vfwprintf_p_l"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_229_2_0 {
	meta:
		name = "__fwprintf_s_l"
		size = 26
		refs = "0012 __vfwprintf_s_l"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_249_1_0 {
	meta:
		name = "__sprintf_l"
		size = 26
		refs = "0012 __vsprintf_l"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_229_3_0 {
	meta:
		name = "_fwprintf_s"
		size = 24
		refs = "0010 __vfwprintf_s_l"
	strings:
		$1 = { 8D 44 24 0C 50 6A 00 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_509_5_0 {
	meta:
		name = "__fprintf_p"
		size = 24
		refs = "0010 __vfprintf_p_l"
	strings:
		$1 = { 8D 44 24 0C 50 6A 00 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_229_5_0 {
	meta:
		name = "__fwprintf_p"
		size = 24
		refs = "0010 __vfwprintf_p_l"
	strings:
		$1 = { 8D 44 24 0C 50 6A 00 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_509_3_0 {
	meta:
		name = "_fprintf_s"
		size = 24
		refs = "0010 __vfprintf_s_l"
	strings:
		$1 = { 8D 44 24 0C 50 6A 00 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "___ascii_memicmp"
		size = 89
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 45 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 83 C6 01 8A 07 83 C7 01 3A E0 74 18 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 07 83 E9 01 75 D5 EB 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "_memmove"
		size = 869
		refs = "002a ___sse2_available 0043 __VEC_memcpy 005f TrailUpVec 0078 LeadUpVec 0087 UnwindUpVec 008c LeadUp1 0090 LeadUp2 0094 LeadUp3 0108 UnwindUp0 010c UnwindUp1 0110 UnwindUp2 0114 UnwindUp3 0118 UnwindUp4 011c UnwindUp5 0120 UnwindUp6 0124 UnwindUp7 0174 TrailUp0 0178 TrailUp1 017c TrailUp2 0180 TrailUp3 01e6 TrailDownVec 01f1 UnwindDownVec 020c LeadDownVec 0218 LeadDown1 021c LeadDown2 0220 LeadDown3 02a4 UnwindDown7 02a8 UnwindDown6 02ac UnwindDown5 02b0 UnwindDown4 02b4 UnwindDown3 02b8 UnwindDown2 02bc UnwindDown1 02c0 UnwindDown0 0310 TrailDown0 0314 TrailDown1 0318 TrailDown2 031c TrailDown3"
		altNames = "_memcpy"
	strings:
		$1 = { 55 8B EC 57 56 8B 75 0C 8B 4D 10 8B 7D 08 8B C1 8B D1 03 C6 3B FE 76 08 3B F8 0F 82 A4 01 00 00 81 F9 00 01 00 00 72 1F 83 3D ?? ?? ?? ?? 00 74 16 57 56 83 E7 0F 83 E6 0F 3B FE 5E 5F 75 08 5E 5F 5D E9 ?? ?? ?? ?? F7 C7 03 00 00 00 75 15 C1 E9 02 83 E2 03 83 F9 08 72 2A F3 A5 FF 24 95 ?? ?? ?? ?? 90 8B C7 BA 03 00 00 00 83 E9 04 72 0C 83 E0 03 03 C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 23 D1 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 C1 E9 02 88 47 02 83 C6 03 83 C7 03 83 F9 08 72 CC F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 23 D1 8A 06 88 07 8A 46 01 C1 E9 02 88 47 01 83 C6 02 83 C7 02 83 F9 08 72 A6 F3 A5 FF 24 95 ?? ?? ?? ?? 90 23 D1 8A 06 88 07 83 C6 01 C1 E9 02 83 C7 01 83 F9 08 72 88 F3 A5 FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E E4 89 44 8F E4 8B 44 8E E8 89 44 8F E8 8B 44 8E EC 89 44 8F EC 8B 44 8E F0 89 44 8F F0 8B 44 8E F4 89 44 8F F4 8B 44 8E F8 89 44 8F F8 8B 44 8E FC 89 44 8F FC 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 08 5E 5F C9 C3 90 8A 06 88 07 8B 45 08 5E 5F C9 C3 90 8A 06 88 07 8A 46 01 88 47 01 8B 45 08 5E 5F C9 C3 8D 49 00 8A 06 88 07 8A 46 01 88 47 01 8A 46 02 88 47 02 8B 45 08 5E 5F C9 C3 90 8D 74 31 FC 8D 7C 39 FC F7 C7 03 00 00 00 75 24 C1 E9 02 83 E2 03 83 F9 08 72 0D FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8B FF F7 D9 FF 24 8D ?? ?? ?? ?? 8D 49 00 8B C7 BA 03 00 00 00 83 F9 04 72 0C 83 E0 03 2B C8 FF 24 85 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8A 46 03 23 D1 88 47 03 83 EE 01 C1 E9 02 83 EF 01 83 F9 08 72 B2 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 8A 46 03 23 D1 88 47 03 8A 46 02 C1 E9 02 88 47 02 83 EE 02 83 EF 02 83 F9 08 72 88 FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 90 8A 46 03 23 D1 88 47 03 8A 46 02 88 47 02 8A 46 01 C1 E9 02 88 47 01 83 EE 03 83 EF 03 83 F9 08 0F 82 56 FF FF FF FD F3 A5 FC FF 24 95 ?? ?? ?? ?? 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 44 8E 1C 89 44 8F 1C 8B 44 8E 18 89 44 8F 18 8B 44 8E 14 89 44 8F 14 8B 44 8E 10 89 44 8F 10 8B 44 8E 0C 89 44 8F 0C 8B 44 8E 08 89 44 8F 08 8B 44 8E 04 89 44 8F 04 8D 04 8D 00 00 00 00 03 F0 03 F8 FF 24 95 ?? ?? ?? ?? 8B FF ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 45 08 5E 5F C9 C3 90 8A 46 03 88 47 03 8B 45 08 5E 5F C9 C3 8D 49 00 8A 46 03 88 47 03 8A 46 02 88 47 02 8B 45 08 5E 5F C9 C3 90 8A 46 03 88 47 03 8A 46 02 88 47 02 8A 46 01 88 47 01 8B 45 08 5E 5F C9 C3 }
	condition:
		$1
}

rule file_232_3_0 {
	meta:
		name = "__mbscat_s_l"
		size = 447
		refs = "0018 __errno 0027 __invalid_parameter 0045 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0059 _strcat_s 00d2 __ismbblead_l"
	strings:
		$1 = { 55 8B EC 83 EC 1C 53 56 57 8B 7D 08 33 DB 3B FB 74 05 39 5D 0C 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 85 01 00 00 39 5D 10 75 04 88 1F EB D9 FF 75 14 8D 4D E4 E8 ?? ?? ?? ?? 8B 45 E8 39 58 08 75 24 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F0 0F 84 51 01 00 00 8B 4D EC 83 61 70 FD E9 45 01 00 00 8B 45 0C 89 5D F8 8B F7 89 45 08 38 1E 74 06 46 FF 4D 08 75 F6 39 5D 08 75 2A 88 1F E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 38 5D F0 74 81 8B 45 EC 83 60 70 FD E9 75 FF FF FF 8D 46 FF 3B C7 89 45 F4 89 45 FC 72 21 8D 45 E4 50 8B 45 FC 0F B6 00 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 08 FF 4D FC 39 7D FC 73 E2 8B 45 F4 8B C8 2B 4D FC F6 C1 01 74 0E FF 45 08 8B F0 C7 45 F8 01 00 00 00 88 1E 8B 4D 10 8A 01 88 06 46 41 3A C3 89 4D 10 74 05 FF 4D 08 75 EB 39 5D 08 75 54 38 19 75 42 4E 3B F7 89 75 08 72 1E 8D 45 E4 50 8B 45 08 0F B6 00 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 08 FF 4D 08 39 7D 08 73 E2 8B C6 2B 45 08 A8 01 74 13 88 1E E8 ?? ?? ?? ?? 8B C8 6A 2A 58 89 01 E9 01 FF FF FF 88 1F E8 ?? ?? ?? ?? 6A 22 E9 2B FF FF FF 83 C6 FE 3B F7 89 75 08 72 1E 8D 45 E4 50 8B 45 08 0F B6 00 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 08 FF 4D 08 39 7D 08 73 E2 8B C6 2B 45 08 A8 01 74 09 88 1E C7 45 F8 01 00 00 00 39 5D F8 75 A2 38 5D F0 74 07 8B 45 EC 83 60 70 FD 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_233_3_0 {
	meta:
		name = "__mbslwr_s_l"
		size = 259
		refs = "0024 _strnlen 0039 __errno 0048 __invalid_parameter 005d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0097 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 57 8B 7D 08 33 DB 3B FB 74 21 39 5D 0C 76 21 3B FB 0F 84 B8 00 00 00 FF 75 0C 57 E8 ?? ?? ?? ?? 3B 45 0C 59 59 72 27 88 1F EB 05 39 5D 0C 74 DF E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 83 00 00 00 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 8B F7 38 1E 74 62 8A 0F 8B 55 F0 0F B6 C1 03 C2 8A 50 1D F6 C2 04 74 39 8B 45 F0 6A 01 FF 70 04 8D 4D FC 6A 02 51 6A 02 57 68 00 01 00 00 FF 70 0C 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C4 24 3B C3 74 3C 8B 4D FC 88 0E 46 47 83 F8 01 7E 16 88 2E EB 11 F6 C2 10 74 08 8A 80 1D 01 00 00 EB 02 8A C1 88 06 46 47 38 1F 75 9E 38 5D F8 88 1E 74 07 8B 45 F4 83 60 70 FD 33 C0 5F 5E 5B C9 C3 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 45 08 88 18 E8 ?? ?? ?? ?? 38 5D F8 8B 00 74 DF 8B 4D F4 83 61 70 FD EB D6 }
	condition:
		$1
}

rule file_233_5_0 {
	meta:
		name = "__mbslwr_l"
		size = 36
		refs = "0012 __mbslwr_s_l"
	strings:
		$1 = { 8B 44 24 04 FF 74 24 08 F7 D8 1B C0 50 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 44 24 04 C3 }
	condition:
		$1
}

rule file_533_5_0 {
	meta:
		name = "__mbsupr_l"
		size = 36
		refs = "0012 __mbsupr_s_l"
	strings:
		$1 = { 8B 44 24 04 FF 74 24 08 F7 D8 1B C0 50 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 44 24 04 C3 }
	condition:
		$1
}

rule file_233_6_0 {
	meta:
		name = "__mbslwr"
		size = 33
		refs = "0010 __mbslwr_s_l"
	strings:
		$1 = { 56 8B 74 24 08 8B C6 F7 D8 6A 00 1B C0 50 56 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 C6 5E C3 }
	condition:
		$1
}

rule file_533_6_0 {
	meta:
		name = "__mbsupr"
		size = 33
		refs = "0010 __mbsupr_s_l"
	strings:
		$1 = { 56 8B 74 24 08 8B C6 F7 D8 6A 00 1B C0 50 56 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 F7 D0 23 C6 5E C3 }
	condition:
		$1
}

rule file_234_2_0 {
	meta:
		name = "___crtInitCritSecNoSpinCount@8"
		size = 16
		refs = "0006 __imp__InitializeCriticalSection@4"
	strings:
		$1 = { FF 74 24 04 FF 15 ?? ?? ?? ?? 33 C0 40 C2 08 00 }
	condition:
		$1
}

rule file_234_3_0 {
	meta:
		name = "___crtInitCritSecAndSpinCount"
		size = 197
		refs = "0003 __sehtable$___crtInitCritSecAndSpinCount 0008 __SEH_prolog4 0013 ___pfnInitCritSecAndSpinCount 0018 __decode_pointer 0028 __get_osplatform 0037 __invoke_watson 0045 ??_C@_0N@MDJJJHMB@kernel32?4dll?$AA@ 004b __imp__GetModuleHandleA@4 0054 ??_C@_0CG@PKBDLMEO@InitializeCriticalSectionAndSpin@ 005b __imp__GetProcAddress@8 0066 ___crtInitCritSecNoSpinCount@8 006c __encode_pointer 00ad __imp__SetLastError@4 00c0 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B F0 3B F7 75 53 8D 45 E4 50 E8 ?? ?? ?? ?? 59 3B C7 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 7D E4 01 74 21 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 3B C7 74 12 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 8B F0 3B F7 75 05 BE ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 89 7D FC FF 75 0C FF 75 08 FF D6 89 45 E0 EB 2F 8B 45 EC 8B 00 8B 00 89 45 DC 33 C9 3D 17 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 81 7D DC 17 00 00 C0 75 08 6A 08 FF 15 ?? ?? ?? ?? 83 65 E0 00 C7 45 FC FE FF FF FF 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_235_0_0 {
	meta:
		name = "___libm_sse2_tanf"
		size = 416
		refs = "001b _PI_32_RECIP 0027 _BIT_31 003b _SHIFTER_16 0047 _SHIFTER 007a _PP_1 0086 _P_1 0092 _PP_2 009e _P_2 00a8 _Ctable 00e4 _ONE 015b _ONE_P230 018a _tan"
	strings:
		$1 = { 66 0F C5 C0 01 66 25 FF 7F 66 2D 80 00 66 3D FF 46 0F 87 3A 01 00 00 F2 0F 10 0D ?? ?? ?? ?? F3 0F 59 C8 66 0F 28 3D ?? ?? ?? ?? F3 0F 2D D1 66 0F 54 F8 F3 0F 5A C0 F2 0F 10 25 ?? ?? ?? ?? F3 0F 58 E1 F3 0F 58 0D ?? ?? ?? ?? F3 0F 5C 25 ?? ?? ?? ?? F3 0F 5C 0D ?? ?? ?? ?? 66 0F 28 EF 66 0F 73 F7 20 66 0F 73 F5 1D 66 0F 57 FD 81 C2 00 76 1C 00 83 E2 1F F2 0F 10 2D ?? ?? ?? ?? 66 0F 57 EF F2 0F 10 15 ?? ?? ?? ?? 66 0F 57 D7 F2 0F 10 35 ?? ?? ?? ?? 66 0F 57 F7 F2 0F 10 1D ?? ?? ?? ?? 66 0F 57 DF 8D 05 ?? ?? ?? ?? C1 E2 03 03 C2 C1 E2 03 03 C2 66 0F 73 F4 1D 66 0F 73 F1 1D F2 0F 59 EC F2 0F 59 D1 F2 0F 59 F4 F2 0F 59 D9 F2 0F 58 E8 F2 0F 58 D0 F2 0F 58 EE F2 0F 58 D3 F2 0F 10 3D ?? ?? ?? ?? F2 0F 5E FD F2 0F 59 78 40 F2 0F 10 58 38 F2 0F 59 DA F2 0F 10 60 18 F2 0F 59 E2 F2 0F 10 68 28 F2 0F 59 EA F2 0F 10 70 08 F2 0F 59 F2 F2 0F 59 D2 F2 0F 58 58 30 F2 0F 58 60 10 F2 0F 58 68 20 F2 0F 58 30 F2 0F 59 DA F2 0F 59 E2 F2 0F 59 D2 F2 0F 58 DD F2 0F 58 E6 F2 0F 59 DA F2 0F 58 DC F2 0F 5C DF F2 0F 5A C3 C3 7F 11 F3 0F 5A C0 F2 0F 59 05 ?? ?? ?? ?? F2 0F 5A C0 C3 66 0F 7E C0 25 00 00 80 7F 3D 00 00 80 7F 74 27 8B C4 83 EC 20 83 E4 F0 89 44 24 08 F3 0F 5A C0 66 0F D6 04 24 E8 ?? ?? ?? ?? D9 1C 24 F3 0F 10 04 24 8B 64 24 08 C3 F3 0F 5C C0 C3 }
	condition:
		$1
}

rule file_236_0_0 {
	meta:
		name = "__vsnprintf_helper"
		size = 202
		refs = "000f __errno 001f __invalid_parameter 00a7 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 33 DB 39 5D 14 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 99 00 00 00 56 8B 75 0C 57 8B 7D 10 3B FB 74 21 3B F3 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 6A B8 FF FF FF 7F 3B F8 89 45 E4 77 03 89 7D E4 FF 75 1C 8D 45 E0 FF 75 18 C7 45 EC 42 00 00 00 FF 75 14 89 75 E8 50 89 75 E0 FF 55 08 83 C4 10 3B F3 89 45 14 74 34 3B C3 7C 22 FF 4D E4 78 07 8B 45 E0 88 18 EB 11 8D 45 E0 50 53 E8 ?? ?? ?? ?? 83 F8 FF 59 59 74 05 8B 45 14 EB 0E 33 C0 39 5D E4 88 5C 3E FF 0F 9D C0 48 48 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_236_3_0 {
	meta:
		name = "__vsprintf_s_l"
		size = 134
		refs = "000c __errno 001c __invalid_parameter 0050 __output_s_l 0055 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC 53 33 DB 39 5D 10 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 5B 56 8B 75 08 3B F3 74 05 39 5D 0C 77 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB 30 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 3B C3 7D 02 88 1E 83 F8 FE 75 1B E8 ?? ?? ?? ?? C7 00 22 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E 5B 5D C3 }
	condition:
		$1
}

rule file_236_5_0 {
	meta:
		name = "__vsnprintf_s_l"
		size = 261
		refs = "000d __errno 001d __invalid_parameter 007d __output_s_l 0082 __vsnprintf_helper"
	strings:
		$1 = { 55 8B EC 51 53 33 DB 39 5D 14 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D6 00 00 00 39 5D 10 56 8B 75 08 57 75 10 3B F3 75 10 39 5D 0C 75 12 33 C0 E9 BA 00 00 00 3B F3 74 07 8B 7D 0C 3B FB 77 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 8F 00 00 00 E8 ?? ?? ?? ?? 3B 7D 10 FF 75 1C FF 75 18 FF 75 14 76 2D 8B 38 8B 45 10 40 50 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 18 83 F8 FE 75 4C E8 ?? ?? ?? ?? 83 38 22 75 65 E8 ?? ?? ?? ?? 89 38 EB 5C 8B 00 57 56 68 ?? ?? ?? ?? 89 45 FC E8 ?? ?? ?? ?? 83 C4 18 83 F8 FE 88 5C 3E FF 75 1C 83 7D 10 FF 75 1A E8 ?? ?? ?? ?? 83 38 22 75 2F E8 ?? ?? ?? ?? 8B 4D FC 89 08 EB 23 3B C3 7D 22 83 F8 FE 88 1E 75 18 E8 ?? ?? ?? ?? C7 00 22 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "__aullrem"
		size = 117
	strings:
		$1 = { 53 8B 44 24 14 0B C0 75 18 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B 44 24 08 F7 F1 8B C2 33 D2 EB 50 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B C8 F7 64 24 14 91 F7 64 24 10 03 D1 72 0E 3B 54 24 0C 77 08 72 0E 3B 44 24 08 76 08 2B 44 24 10 1B 54 24 14 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 5B C2 10 00 }
	condition:
		$1
}

rule file_239_0_0 {
	meta:
		name = "_vfwprintf_helper"
		size = 147
		refs = "0003 __sehtable$_vfwprintf_helper 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 004a __lock_file 0054 __stbuf 006d __ftbuf 0084 __SEH_epilog4 008d __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 7D 0C 33 F6 3B FE 0F 95 C0 3B C6 75 1D E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4A 33 C0 39 75 10 0F 95 C0 3B C6 74 D7 89 7D 0C 57 E8 ?? ?? ?? ?? 59 89 75 FC 57 E8 ?? ?? ?? ?? 8B F0 FF 75 18 FF 75 14 FF 75 10 57 FF 55 08 89 45 E4 57 56 E8 ?? ?? ?? ?? 83 C4 1C C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "__CIatan_pentium4"
		size = 748
		refs = "002a _mabs 0032 _in 0046 _in1 0050 _in0 006e _p01 007a _p23 0086 _p45 0092 _p60 00be _in2 00dc _d01 00e8 _d23 00f4 _d45 0100 _d67 010c _d89 0118 _d1011 0124 _d1213 0130 _d1400 0164 _in3 016e _cnst8 0176 _cntshf 0197 __atan_table 01ab _one 01c6 _onen 0254 _zero 0263 _minval 026b libm_small 029f _mexp 02bd _pi_2d 02df ___libm_error_support"
	strings:
		$1 = { 55 8B EC 83 EC 08 83 E4 F0 DD 1C 24 F3 0F 7E 3C 24 E8 08 00 00 00 C9 C3 F3 0F 7E 7C 24 04 66 0F 14 FF 66 0F 28 D7 66 0F 54 15 ?? ?? ?? ?? 66 0F 2F 15 ?? ?? ?? ?? 0F 8A 86 02 00 00 0F 83 55 02 00 00 66 0F 2F 15 ?? ?? ?? ?? 73 6E 66 0F 2F 15 ?? ?? ?? ?? 0F 82 F6 01 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 0F 83 90 00 00 00 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EF F2 0F 5C FD 66 0F D6 7C 24 04 DD 44 24 04 C3 F3 0F 7E F7 66 0F 57 F2 66 0F 2F 15 ?? ?? ?? ?? 73 4F F3 0F 7E 05 ?? ?? ?? ?? F3 0F 7E 2D ?? ?? ?? ?? F3 0F 7E DA F2 0F 58 D8 66 0F 73 D3 2C 66 0F FA DD 66 0F 7E D8 8D 04 40 F3 0F 7E 2C C5 ?? ?? ?? ?? F3 0F 7E DA F2 0F 5C D5 F2 0F 59 DD F2 0F 58 1D ?? ?? ?? ?? F2 0F 5E D3 66 0F 14 D2 EB 19 B8 00 03 00 00 F3 0F 7E C2 F3 0F 7E 15 ?? ?? ?? ?? F2 0F 5E D0 66 0F 14 D2 F3 0F 7E 04 C5 ?? ?? ?? ?? F3 0F 7E 24 C5 ?? ?? ?? ?? 66 0F 28 CA 66 0F 59 CA 66 0F 28 D9 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? 66 0F 59 EB 66 0F 58 2D ?? ?? ?? ?? F2 0F 59 E9 66 0F 28 DD 66 0F C6 DB 01 F2 0F 58 EB F2 0F 59 EA F2 0F 5C EC F2 0F 5C EA F2 0F 5C C5 66 0F 56 C6 66 0F D6 44 24 04 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 75 05 DD 44 24 04 C3 66 0F 2F 15 ?? ?? ?? ?? 73 1D DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? 83 EC 08 DD 1C 24 DD 04 24 83 C4 08 DC 44 24 04 C3 DD 05 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DC 44 24 04 C3 F3 0F 7E C2 F3 0F 7E 1D ?? ?? ?? ?? 66 0F 54 C3 66 0F 2E C3 7A 15 8B 44 24 08 C1 E8 1F DD 05 ?? ?? ?? ?? DC 04 C5 ?? ?? ?? ?? C3 BA EB 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 90 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "__eof"
		size = 284
		refs = "0003 __sehtable$__eof 0008 __SEH_prolog4 0015 ___doserrno 001d __errno 0037 __nhandle 0055 __invalid_parameter 0066 ___pioinfo 0080 ___lock_fhandle 0099 __lseeki64_nolock 010d __SEH_epilog4 0116 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 DD 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F 6B F6 28 8B 0B 0F B6 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 56 6A 01 57 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B F0 8B DA 23 C3 83 F8 FF 74 4E 6A 02 57 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 8B C8 23 CA 83 F9 FF 74 36 3B F0 75 0D 3B DA 75 09 C7 45 E4 01 00 00 00 EB 29 57 53 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 89 7D E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_242_3_0 {
	meta:
		name = "___ascii_stricmp"
		size = 53
	strings:
		$1 = { 8B 54 24 08 56 8B 74 24 08 57 0F B6 06 8D 48 BF 46 83 F9 19 77 03 83 C0 20 0F B6 0A 8D 79 BF 42 83 FF 19 77 03 83 C1 20 85 C0 74 04 3B C1 74 DA 5F 2B C1 5E C3 }
	condition:
		$1
}

rule file_242_4_0 {
	meta:
		name = "__stricmp_l"
		size = 211
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001a __errno 002a __invalid_parameter 0087 ___ascii_stricmp 009c __tolower_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 33 DB 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 89 00 00 00 57 8B 7D 0C 3B FB 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 55 8B 45 F0 39 58 14 75 0D 57 FF 75 08 E8 ?? ?? ?? ?? 59 59 EB 34 56 8B 45 08 0F B6 00 8D 4D F0 51 50 E8 ?? ?? ?? ?? FF 45 08 8B F0 0F B6 07 8D 4D F0 51 50 E8 ?? ?? ?? ?? 83 C4 10 47 3B F3 74 04 3B F0 74 D2 2B F0 8B C6 5E 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5B C9 C3 }
	condition:
		$1
}

rule file_243_0_0 {
	meta:
		name = "_strspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 72 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "__swprintf"
		size = 150
		refs = "000f __errno 001f __invalid_parameter 0054 __woutput_l 0072 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 33 DB 39 5D 0C 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 68 8B 45 08 3B C3 74 DC 56 89 45 E8 89 45 E0 8D 45 10 50 53 FF 75 0C 8D 45 E0 50 C7 45 EC 42 00 00 00 C7 45 E4 FF FF FF 7F E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 0A 8B 45 E0 88 18 FF 45 E0 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 FF 4D E4 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_244_3_0 {
	meta:
		name = "__snwprintf_s"
		size = 31
		refs = "0016 __vsnwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_249_4_0 {
	meta:
		name = "__snprintf_s"
		size = 31
		refs = "0016 __vsnprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 18 50 6A 00 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_244_6_0 {
	meta:
		name = "__snwprintf_s_l"
		size = 32
		refs = "0017 __vsnwprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 1C 50 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_249_5_0 {
	meta:
		name = "__snprintf_s_l"
		size = 32
		refs = "0017 __vsnprintf_s_l"
	strings:
		$1 = { 55 8B EC 8D 45 1C 50 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 18 5D C3 }
	condition:
		$1
}

rule file_244_8_0 {
	meta:
		name = "__scwprintf"
		size = 17
		refs = "000a __vscwprintf"
		altNames = "__scwprintf_p"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_249_8_0 {
	meta:
		name = "__scprintf"
		size = 17
		refs = "000a __vscprintf"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_249_9_0 {
	meta:
		name = "__scprintf_p"
		size = 17
		refs = "000a __vscprintf_p"
	strings:
		$1 = { 8D 44 24 08 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_246_5_0 {
	meta:
		name = "?_strlwr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
		size = 385
		refs = "0007 ___security_cookie 001d __errno 002c __invalid_parameter 003d _strnlen 008b ___crtLCMapStringA 00e0 __alloca_probe_16 00f4 _malloc 014d _strcpy_s 0168 __freea 017b @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B 7D 08 33 DB 3B FB 75 1C E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 35 01 00 00 FF 75 0C 57 E8 ?? ?? ?? ?? 3B 45 0C 59 59 72 04 88 1F EB D0 8B 55 10 8B 02 8B 48 14 3B CB 75 20 38 1F 8B CF 74 13 8A 01 3C 41 7C 08 3C 5A 7F 04 04 20 88 01 41 38 19 75 ED 33 C0 E9 F7 00 00 00 6A 01 FF 70 04 BE 00 01 00 00 53 53 6A FF 57 56 51 52 E8 ?? ?? ?? ?? 8B C8 83 C4 24 3B CB 89 4D F4 75 17 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 8B 00 E9 BD 00 00 00 39 4D 0C 73 0E 88 1F E8 ?? ?? ?? ?? 6A 22 E9 5E FF FF FF 3B CB 7E 45 6A E0 33 D2 58 F7 F1 83 F8 01 72 39 8D 41 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 3B C3 59 74 09 C7 00 DD DD 00 00 83 C0 08 8B 4D F4 89 45 F8 EB 03 89 5D F8 39 5D F8 75 0D E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 83 8B 55 10 8B 02 6A 01 FF 70 04 51 FF 75 F8 6A FF 57 56 FF 70 14 52 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 13 FF 75 F8 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 EB 0C E8 ?? ?? ?? ?? 6A 2A 59 89 08 8B F1 FF 75 F8 E8 ?? ?? ?? ?? 59 8B C6 8D 65 E8 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_246_6_0 {
	meta:
		name = "__strlwr_s_l"
		size = 50
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001c ?_strlwr_s_l_stat@@YAHPADIPAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_246_9_0 {
	meta:
		name = "__strlwr"
		size = 98
		refs = "0005 ___locale_changed 0014 __errno 0024 __invalid_parameter 0055 __strlwr_s_l"
	strings:
		$1 = { 53 33 DB 39 1D ?? ?? ?? ?? 75 42 8B 44 24 08 3B C3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5B C3 38 18 8B D0 74 2B 8A 0A 80 F9 41 7C 0A 80 F9 5A 7F 05 80 C1 20 88 0A 42 38 1A 75 EA 5B C3 53 6A FF FF 74 24 10 E8 ?? ?? ?? ?? 8B 44 24 14 83 C4 0C 5B C3 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "__splitpath_helper"
		size = 536
		refs = "00a2 __mbsnbcpy_s 00d5 __ismbblead 01cc __errno 01df __invalid_parameter"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 33 FF 8B D8 3B DF 89 7D F8 0F 84 9C 00 00 00 8B 4D 08 3B CF 75 0B 39 7D 0C 0F 85 8C 00 00 00 EB 09 39 7D 0C 0F 84 81 00 00 00 39 7D 10 75 07 39 7D 14 75 77 EB 05 39 7D 14 74 70 39 7D 18 75 07 39 7D 1C 75 66 EB 05 39 7D 1C 74 5F 39 7D 20 75 55 39 7D 24 75 55 80 3B 5C 75 15 80 7B 01 5C 75 0F 80 7B 02 3F 75 09 80 7B 03 5C 75 03 83 C3 04 33 C0 40 8B F3 80 3E 00 74 06 48 46 3B C7 77 F5 80 3E 3A 75 32 3B CF 74 18 83 7D 0C 03 0F 82 F4 00 00 00 6A 02 53 6A FF 51 E8 ?? ?? ?? ?? 83 C4 10 8D 5E 01 EB 18 39 7D 24 75 AB C7 45 F8 01 00 00 00 E9 D0 00 00 00 3B CF 74 03 C6 01 00 21 7D FC 80 3B 00 8B F3 74 53 0F BE 06 50 E8 ?? ?? ?? ?? 85 C0 59 74 03 46 EB 16 8A 06 3C 2F 74 0D 3C 5C 74 09 3C 2E 75 08 89 75 FC EB 03 8D 7E 01 46 80 3E 00 75 D3 85 FF 74 22 83 7D 10 00 74 18 8B C7 2B C3 39 45 14 76 7D 50 53 6A FF FF 75 10 E8 ?? ?? ?? ?? 83 C4 10 8B DF EB 0A 8B 45 10 85 C0 74 03 C6 00 00 8B 45 FC 85 C0 74 48 3B C3 72 44 83 7D 18 00 74 16 2B C3 39 45 1C 76 48 50 53 6A FF FF 75 18 E8 ?? ?? ?? ?? 83 C4 10 83 7D 20 00 0F 84 B3 00 00 00 2B 75 FC 39 75 24 76 27 56 FF 75 FC 6A FF FF 75 20 E8 ?? ?? ?? ?? 83 C4 10 E9 95 00 00 00 83 7D 18 00 0F 84 81 00 00 00 2B F3 39 75 1C 77 6B 33 FF 8B 45 08 3B C7 74 08 39 7D 0C 76 03 C6 00 00 8B 45 10 3B C7 74 08 39 7D 14 76 03 C6 00 00 8B 45 18 3B C7 74 08 39 7D 1C 76 03 C6 00 00 8B 45 20 3B C7 74 08 39 7D 24 76 03 C6 00 00 E8 ?? ?? ?? ?? 3B DF 75 16 6A 16 5E 57 57 57 57 57 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 29 39 7D F8 75 E5 6A 22 59 89 08 8B C1 EB 1B 56 53 6A FF FF 75 18 E8 ?? ?? ?? ?? 83 C4 10 8B 45 20 85 C0 74 03 C6 00 00 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "__splitpath"
		size = 74
		refs = "0041 __splitpath_helper"
	strings:
		$1 = { 55 8B EC 8B 4D 18 F7 D9 1B C9 B8 00 01 00 00 23 C8 51 FF 75 18 8B 4D 14 F7 D9 1B C9 23 C8 51 8B 4D 10 FF 75 14 F7 D9 1B C9 23 C8 8B 45 0C F7 D8 51 FF 75 10 1B C0 83 E0 03 50 FF 75 0C 8B 45 08 E8 ?? ?? ?? ?? 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_668_1_0 {
	meta:
		name = "__wsplitpath"
		size = 74
		refs = "0041 __wsplitpath_helper"
	strings:
		$1 = { 55 8B EC 8B 4D 18 F7 D9 1B C9 B8 00 01 00 00 23 C8 51 FF 75 18 8B 4D 14 F7 D9 1B C9 23 C8 51 8B 4D 10 FF 75 14 F7 D9 1B C9 23 C8 8B 45 0C F7 D8 51 FF 75 10 1B C0 83 E0 03 50 FF 75 0C 8B 45 08 E8 ?? ?? ?? ?? 83 C4 20 5D C3 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "_wcsnlen"
		size = 28
	strings:
		$1 = { 33 C0 39 44 24 08 76 13 8B 4C 24 04 66 83 39 00 74 09 40 41 41 3B 44 24 08 72 F1 C3 }
	condition:
		$1
}

rule file_249_0_0 {
	meta:
		name = "_sprintf"
		size = 123
		refs = "000f __errno 001f __invalid_parameter 0054 __output_l 006f __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 33 DB 39 5D 0C 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4D 8B 45 08 3B C3 74 DC 56 89 45 E8 89 45 E0 8D 45 10 50 53 FF 75 0C 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_250_2_0 {
	meta:
		name = "__CIacos_default"
		size = 203
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 002d __load_CW 004a ___fastflag 0051 __fast_exit 005c _NAME_ 0061 __math_exit 008b __convertTOStoQNaN 00a3 __indefinite 00c5 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 6D 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? 3D 00 00 F0 3F 73 2D D9 E8 D8 C1 D9 E8 D8 E2 DE C9 D9 FA D9 C9 D9 F3 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? 77 38 8B 44 24 0C 8B C8 25 FF FF 0F 00 0B 44 24 08 75 27 81 E1 00 00 00 80 DD D8 74 04 D9 EB EB C2 D9 EE EB BE E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 0D 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_251_0_0 {
	meta:
		name = "__lfind"
		size = 159
		refs = "000c __errno 001c __invalid_parameter"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 08 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 4C 57 8B 7D 10 3B FE 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 27 53 8B 5D 0C 3B DE 75 23 39 37 74 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5B 5F 5E 5D C3 39 75 14 76 DC 39 75 18 74 D7 39 37 76 EB 53 FF 75 08 FF 55 18 85 C0 59 59 74 0A 03 5D 14 46 3B 37 72 EB EB D4 8B C3 EB D2 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "__wctime64_s"
		size = 118
		refs = "0017 __errno 0026 __invalid_parameter 0058 __localtime64_s 006b __wasctime_s"
	strings:
		$1 = { 55 8B EC 83 EC 24 56 57 8B 7D 08 33 F6 3B FE 74 05 39 75 0C 77 1B E8 ?? ?? ?? ?? 6A 16 5F 56 56 56 56 56 89 38 E8 ?? ?? ?? ?? 83 C4 14 8B C7 EB 41 8B 45 10 3B C6 66 89 37 74 DB 39 70 04 7F 12 7C 04 39 30 73 0C E8 ?? ?? ?? ?? 6A 16 5F 89 38 EB DB 50 8D 45 DC 50 E8 ?? ?? ?? ?? 3B C6 59 59 75 10 8D 45 DC 50 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E C9 C3 }
	condition:
		$1
}

rule file_252_1_0 {
	meta:
		name = "__wctime64"
		size = 97
		refs = "0011 __errno 0021 __invalid_parameter 004b __localtime64_s 005a __wasctime"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 24 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C9 C3 39 70 04 7F 13 7C 04 39 30 73 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB E3 50 8D 45 DC 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 D3 8D 45 DC 50 E8 ?? ?? ?? ?? 59 EB C9 }
	condition:
		$1
}

rule file_903_1_0 {
	meta:
		name = "__ctime64"
		size = 97
		refs = "0011 __errno 0021 __invalid_parameter 004b __localtime64_s 005a _asctime"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 24 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C9 C3 39 70 04 7F 13 7C 04 39 30 73 0D E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB E3 50 8D 45 DC 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 D3 8D 45 DC 50 E8 ?? ?? ?? ?? 59 EB C9 }
	condition:
		$1
}

rule file_253_3_0 {
	meta:
		name = "__mbctolower_l"
		size = 164
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0064 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 FF 75 0C 8D 4D E8 E8 ?? ?? ?? ?? 8B 5D 08 81 FB FF 00 00 00 76 61 8B C3 C1 E8 08 0F B6 C8 88 45 FC 8B 45 EC 88 5D FD F6 44 01 1D 04 75 11 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 8B C3 EB 5B 6A 01 FF 70 04 8D 4D F8 6A 02 51 6A 02 8D 4D FC 51 68 00 01 00 00 FF 70 0C 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 C6 0F B6 45 F8 0F B6 4D F9 C1 E0 08 03 C1 EB 16 8B 45 EC 03 C3 F6 40 1D 10 74 09 0F B6 80 1D 01 00 00 EB 02 8B C3 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_254_0_0 {
	meta:
		name = "__onexit_nolock"
		size = 173
		refs = "0007 ___onexitbegin 000c __decode_pointer 0012 ___onexitend 0037 __msize 0059 __realloc_crt 0082 __encode_pointer"
	strings:
		$1 = { 51 53 55 56 57 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 8B F0 89 74 24 18 E8 ?? ?? ?? ?? 8B F8 3B FE 59 59 72 7C 8B DF 2B DE 8D 6B 04 83 FD 04 72 70 56 E8 ?? ?? ?? ?? 8B F0 3B F5 59 73 4A B8 00 08 00 00 3B F0 73 02 8B C6 03 C6 3B C6 72 10 50 FF 74 24 14 E8 ?? ?? ?? ?? 85 C0 59 59 75 17 8D 46 10 3B C6 72 3B 50 FF 74 24 14 E8 ?? ?? ?? ?? 85 C0 59 59 74 2B C1 FB 02 50 8D 3C 98 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? 8B 74 24 18 89 37 83 C7 04 57 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 59 8B C6 EB 02 33 C0 5F 5E 5D 5B 59 C3 }
	condition:
		$1
}

rule file_254_1_0 {
	meta:
		name = "___onexitinit"
		size = 47
		refs = "0006 __calloc_crt 000e __encode_pointer 0018 ___onexitbegin 001d ___onexitend"
	strings:
		$1 = { 56 6A 04 6A 20 E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 83 C4 0C 85 F6 A3 ?? ?? ?? ?? A3 ?? ?? ?? ?? 75 05 6A 18 58 5E C3 83 26 00 33 C0 5E C3 }
	condition:
		$1
}

rule file_254_2_0 {
	meta:
		name = "__onexit"
		size = 60
		refs = "0003 __sehtable$__onexit 0008 __SEH_prolog4 000d __lockexit 0019 __onexit_nolock 0031 __SEH_epilog4 0037 __unlockexit"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_254_3_0 {
	meta:
		name = "_atexit"
		size = 18
		refs = "0005 __onexit"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? F7 D8 1B C0 F7 D8 59 48 C3 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "_free"
		size = 142
		refs = "0003 __sehtable$_free 0008 __SEH_prolog4 0015 ___active_heap 001f __lock 002a ___sbh_find_block 0039 ___sbh_free_block 0059 __unlock 0064 __crtheap 006a __imp__HeapFree@12 0073 __errno 007b __imp__GetLastError@0 0081 __get_errno_from_oserr 0089 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 74 75 83 3D ?? ?? ?? ?? 03 75 43 6A 04 E8 ?? ?? ?? ?? 59 83 65 FC 00 56 E8 ?? ?? ?? ?? 59 89 45 E4 85 C0 74 09 56 50 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF E8 0B 00 00 00 83 7D E4 00 75 37 FF 75 08 EB 0A 6A 04 E8 ?? ?? ?? ?? 59 C3 56 6A 00 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 16 E8 ?? ?? ?? ?? 8B F0 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 89 06 59 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "__ctime32_s"
		size = 110
		refs = "0017 __errno 0026 __invalid_parameter 0050 __localtime32_s 0063 _asctime_s"
	strings:
		$1 = { 55 8B EC 83 EC 24 53 56 8B 75 08 33 DB 3B F3 74 05 39 5D 0C 77 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 39 8B 45 10 3B C3 88 1E 74 DC 39 18 7D 0C E8 ?? ?? ?? ?? 6A 16 5E 89 30 EB E3 50 8D 45 DC 50 E8 ?? ?? ?? ?? 3B C3 59 59 75 10 8D 45 DC 50 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 5E 5B C9 C3 }
	condition:
		$1
}

rule file_257_1_0 {
	meta:
		name = "__set_controlfp"
		size = 111
		refs = "002e ___sse2_available 0054 __controlfp_s 0065 __invoke_watson"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 56 33 F6 81 7D 08 1F 00 09 00 75 35 83 F8 FF 75 30 9B D9 7D FC 8B 4D FC 66 81 E1 3D 1F 66 81 F9 3D 02 75 1D 39 35 ?? ?? ?? ?? 74 38 0F AE 5D F8 8B 4D F8 81 E1 C0 FE 00 00 81 F9 80 1E 00 00 74 23 25 FF FF F7 FF 50 FF 75 08 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 5E C9 C3 }
	condition:
		$1
}

rule file_257_2_0 {
	meta:
		name = "__abstract_cw"
		size = 148
	strings:
		$1 = { 33 C0 F6 C3 01 74 03 6A 10 58 F6 C3 04 74 03 83 C8 08 F6 C3 08 74 03 83 C8 04 F6 C3 10 74 03 83 C8 02 F6 C3 20 74 03 83 C8 01 F6 C3 02 74 05 0D 00 00 08 00 55 0F B7 D3 56 8B CA BE 00 0C 00 00 23 CE 57 BF 00 03 00 00 BD 00 02 00 00 74 21 81 F9 00 04 00 00 74 14 81 F9 00 08 00 00 74 08 3B CE 75 0D 0B C7 EB 09 0B C5 EB 05 0D 00 01 00 00 23 D7 74 0B 3B D5 75 0C 0D 00 00 01 00 EB 05 0D 00 00 02 00 66 F7 C3 00 10 5F 5E 5D 74 05 0D 00 00 04 00 C3 }
	condition:
		$1
}

rule file_257_3_0 {
	meta:
		name = "__hw_cw"
		size = 142
	strings:
		$1 = { 33 C0 F6 C3 10 74 01 40 F6 C3 08 74 03 83 C8 04 F6 C3 04 74 03 83 C8 08 F6 C3 02 74 03 83 C8 10 F6 C3 01 74 03 83 C8 20 F7 C3 00 00 08 00 74 03 83 C8 02 8B CB BA 00 03 00 00 23 CA 56 BE 00 02 00 00 74 23 81 F9 00 01 00 00 74 16 3B CE 74 0B 3B CA 75 13 0D 00 0C 00 00 EB 0C 0D 00 08 00 00 EB 05 0D 00 04 00 00 8B CB 81 E1 00 00 03 00 74 0C 81 F9 00 00 01 00 75 06 0B C6 EB 02 0B C2 F7 C3 00 00 04 00 5E 74 05 0D 00 10 00 00 C3 }
	condition:
		$1
}

rule file_257_4_0 {
	meta:
		name = "__abstract_sw"
		size = 62
		altNames = "___abstract_sw_sse2"
	strings:
		$1 = { 8A 4C 24 04 33 C0 F6 C1 3F 74 32 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 C3 }
	condition:
		$1
}

rule file_257_5_0 {
	meta:
		name = "___abstract_cw_sse2"
		size = 157
	strings:
		$1 = { 33 C0 84 C9 79 03 6A 10 58 53 BB 00 02 00 00 85 CB 56 57 74 03 83 C8 08 66 F7 C1 00 04 74 03 83 C8 04 66 F7 C1 00 08 74 03 83 C8 02 66 F7 C1 00 10 74 03 83 C8 01 BF 00 01 00 00 85 CF 74 05 0D 00 00 08 00 8B D1 BE 00 60 00 00 23 D6 74 21 81 FA 00 20 00 00 74 17 81 FA 00 40 00 00 74 0B 3B D6 75 0D 0D 00 03 00 00 EB 06 0B C3 EB 02 0B C7 5F 81 E1 40 80 00 00 83 E9 40 5E 5B 74 19 81 E9 C0 7F 00 00 74 0B 83 E9 40 75 11 0D 00 00 00 01 C3 0D 00 00 00 03 C3 0D 00 00 00 02 C3 }
	condition:
		$1
}

rule file_257_6_0 {
	meta:
		name = "___hw_cw_sse2"
		size = 160
	strings:
		$1 = { 33 C0 F6 C2 10 74 05 B8 80 00 00 00 F6 C2 08 53 56 57 BB 00 02 00 00 74 02 0B C3 F6 C2 04 74 05 0D 00 04 00 00 F6 C2 02 74 05 0D 00 08 00 00 F6 C2 01 74 05 0D 00 10 00 00 F7 C2 00 00 08 00 BF 00 01 00 00 74 02 0B C7 8B CA BE 00 03 00 00 23 CE 74 1F 3B CF 74 16 3B CB 74 0B 3B CE 75 13 0D 00 60 00 00 EB 0C 0D 00 40 00 00 EB 05 0D 00 20 00 00 B9 00 00 00 03 5F 23 D1 81 FA 00 00 00 01 5E 5B 74 16 81 FA 00 00 00 02 74 0A 3B D1 75 0F 0D 00 80 00 00 C3 83 C8 40 C3 0D 40 80 00 00 C3 }
	condition:
		$1
}

rule file_257_9_0 {
	meta:
		name = "__statusfp"
		size = 144
		refs = "0043 ___sse2_available"
	strings:
		$1 = { 55 8B EC 51 51 56 9B DD 7D FC 8A 45 FC 33 D2 A8 3F BE 00 00 08 00 74 29 A8 01 74 03 6A 10 5A A8 04 74 03 83 CA 08 A8 08 74 03 83 CA 04 A8 10 74 03 83 CA 02 A8 20 74 03 83 CA 01 A8 02 74 02 0B D6 83 3D ?? ?? ?? ?? 00 74 41 0F AE 5D F8 8A 4D F8 33 C0 F6 C1 3F 74 2F F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 02 0B C6 0B C2 EB 02 8B C2 5E C9 C3 }
	condition:
		$1
}

rule file_257_10_0 {
	meta:
		name = "__fpreset"
		size = 54
		refs = "0002 ___pxcptinfoptrs 000b __setdefaultprecision 0015 ___set_fpsr_sse2"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B 30 DB E3 E8 ?? ?? ?? ?? 68 80 1F 00 00 E8 ?? ?? ?? ?? 85 F6 59 74 16 8B 46 04 F7 00 08 00 01 00 74 0B 83 60 20 00 C7 40 24 FF FF 00 00 5E C3 }
	condition:
		$1
}

rule file_257_11_0 {
	meta:
		name = "___statusfp_sse2"
		size = 59
		refs = "0001 ___get_fpsr_sse2"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 A8 3F 74 2D A8 01 74 03 6A 10 59 A8 04 74 03 83 C9 08 A8 08 74 03 83 C9 04 A8 10 74 03 83 C9 02 A8 20 74 03 83 C9 01 A8 02 74 06 81 C9 00 00 08 00 8B C1 C3 }
	condition:
		$1
}

rule file_257_12_0 {
	meta:
		name = "___clearfp_sse2"
		size = 75
	strings:
		$1 = { 51 0F AE 1C 24 83 24 24 C0 0F AE 14 24 8A 0C 24 33 C0 F6 C1 3F 74 32 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 59 C3 }
	condition:
		$1
}

rule file_257_13_0 {
	meta:
		name = "___control87_sse2"
		size = 372
		refs = "00c7 ___hw_cw_sse2 00d1 ___set_fpsr_sse2"
	strings:
		$1 = { 51 53 55 8B 6C 24 10 56 57 8B D8 81 E5 1F 03 08 03 0F AE 5C 24 10 8B 4C 24 10 33 C0 84 C9 79 03 6A 10 58 66 F7 C1 00 02 74 03 83 C8 08 66 F7 C1 00 04 74 03 83 C8 04 66 F7 C1 00 08 74 03 83 C8 02 66 F7 C1 00 10 74 03 83 C8 01 BE 00 01 00 00 85 CE 74 05 0D 00 00 08 00 8B D1 BF 00 60 00 00 23 D7 74 24 81 FA 00 20 00 00 74 1A 81 FA 00 40 00 00 74 0B 3B D7 75 10 0D 00 03 00 00 EB 09 0D 00 02 00 00 EB 02 0B C6 BE 40 80 00 00 23 CE 83 E9 40 74 1B 81 E9 C0 7F 00 00 74 0C 83 E9 40 75 13 0D 00 00 00 01 EB 0C 0D 00 00 00 03 EB 05 0D 00 00 00 02 8B D5 F7 D2 23 D0 23 DD 0B D3 3B D0 0F 84 A8 00 00 00 E8 ?? ?? ?? ?? 50 89 44 24 1C E8 ?? ?? ?? ?? 59 0F AE 5C 24 18 8B 4C 24 18 33 C0 84 C9 79 03 6A 10 58 BD 00 02 00 00 85 CD 74 03 83 C8 08 66 F7 C1 00 04 74 03 83 C8 04 66 F7 C1 00 08 74 03 83 C8 02 66 F7 C1 00 10 74 03 83 C8 01 BB 00 01 00 00 85 CB 74 05 0D 00 00 08 00 8B D1 23 D7 74 21 81 FA 00 20 00 00 74 17 81 FA 00 40 00 00 74 0B 3B D7 75 0D 0D 00 03 00 00 EB 06 0B C5 EB 02 0B C3 23 CE 83 E9 40 74 1B 81 E9 C0 7F 00 00 74 0C 83 E9 40 75 13 0D 00 00 00 01 EB 0C 0D 00 00 00 03 EB 05 0D 00 00 00 02 5F 5E 5D 5B 59 C3 }
	condition:
		$1
}

rule file_257_14_0 {
	meta:
		name = "__statusfp2"
		size = 88
		refs = "004f ___statusfp_sse2"
	strings:
		$1 = { 55 8B EC 8B 55 08 85 D2 74 3C 9B DD 7D 08 8A 45 08 33 C9 A8 3F 74 2D A8 01 74 03 6A 10 59 A8 04 74 03 83 C9 08 A8 08 74 03 83 C9 04 A8 10 74 03 83 C9 02 A8 20 74 03 83 C9 01 A8 02 74 06 81 C9 00 00 08 00 89 0A 56 8B 75 0C 85 F6 74 07 E8 ?? ?? ?? ?? 89 06 5E 5D C3 }
	condition:
		$1
}

rule file_257_15_0 {
	meta:
		name = "__clearfp"
		size = 215
		refs = "000c ___sse2_available"
	strings:
		$1 = { 55 8B EC 51 51 DD 7D FC DB E2 83 3D ?? ?? ?? ?? 00 0F 84 82 00 00 00 8A 45 FC 33 D2 A8 3F 56 BE 00 00 08 00 74 29 A8 01 74 03 6A 10 5A A8 04 74 03 83 CA 08 A8 08 74 03 83 CA 04 A8 10 74 03 83 CA 02 A8 20 74 03 83 CA 01 A8 02 74 02 0B D6 0F AE 5D F8 83 65 F8 C0 0F AE 55 F8 8A 4D F8 33 C0 F6 C1 3F 74 2F F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 02 0B C6 0B C2 5E C9 C3 8A 4D FC 33 C0 F6 C1 3F 74 32 F6 C1 01 74 03 6A 10 58 F6 C1 04 74 03 83 C8 08 F6 C1 08 74 03 83 C8 04 F6 C1 10 74 03 83 C8 02 F6 C1 20 74 03 83 C8 01 F6 C1 02 74 05 0D 00 00 08 00 C9 C3 }
	condition:
		$1
}

rule file_257_16_0 {
	meta:
		name = "___control87_2"
		size = 778
		refs = "00c8 __hw_cw 017a ___sse2_available 0249 ___hw_cw_sse2 0253 ___set_fpsr_sse2"
	strings:
		$1 = { 83 EC 0C 53 55 56 33 D2 39 54 24 24 57 BD 00 03 00 00 BF 00 02 00 00 0F 84 4E 01 00 00 9B D9 7C 24 14 8B 5C 24 14 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 C3 8B C8 BE 00 0C 00 00 23 CE 74 22 81 F9 00 04 00 00 74 14 81 F9 00 08 00 00 74 08 3B CE 75 0E 0B D5 EB 0A 0B D7 EB 06 81 CA 00 01 00 00 23 C5 74 0C 3B C7 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 66 F7 C3 00 10 BF 00 00 04 00 74 02 0B D7 8B 5C 24 24 8B 44 24 20 23 44 24 24 F7 D3 23 DA 0B D8 3B DA 0F 84 9E 00 00 00 E8 ?? ?? ?? ?? 0F B7 C0 89 44 24 10 D9 6C 24 10 9B D9 7C 24 10 8B 54 24 10 33 DB F6 C2 01 74 03 6A 10 5B F6 C2 04 74 03 83 CB 08 F6 C2 08 74 03 83 CB 04 F6 C2 10 74 03 83 CB 02 F6 C2 20 74 03 83 CB 01 F6 C2 02 74 06 81 CB 00 00 08 00 0F B7 CA 8B C1 23 C6 74 24 3D 00 04 00 00 74 17 3D 00 08 00 00 74 08 3B C6 75 12 0B DD EB 0E 81 CB 00 02 00 00 EB 06 81 CB 00 01 00 00 23 CD 74 10 81 F9 00 02 00 00 75 0E 81 CB 00 00 01 00 EB 06 81 CB 00 00 02 00 66 F7 C2 00 10 74 02 0B DF 8B 44 24 28 89 18 83 7C 24 2C 00 0F 84 89 01 00 00 33 F6 39 35 ?? ?? ?? ?? 0F 84 75 01 00 00 8B 7C 24 24 81 E7 1F 03 08 03 0F AE 5C 24 18 8B 44 24 18 84 C0 79 03 6A 10 5E 66 A9 00 02 74 03 83 CE 08 66 A9 00 04 74 03 83 CE 04 66 A9 00 08 74 03 83 CE 02 66 A9 00 10 74 03 83 CE 01 66 A9 00 01 74 06 81 CE 00 00 08 00 8B C8 BD 00 60 00 00 23 CD 74 2A 81 F9 00 20 00 00 74 1C 81 F9 00 40 00 00 74 0C 3B CD 75 16 81 CE 00 03 00 00 EB 0E 81 CE 00 02 00 00 EB 06 81 CE 00 01 00 00 BB 40 80 00 00 23 C3 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CE 00 00 00 01 EB 0E 81 CE 00 00 00 03 EB 06 81 CE 00 00 00 02 8B D7 23 7C 24 20 F7 D2 23 D6 0B D7 3B D6 75 07 8B D6 E9 A9 00 00 00 E8 ?? ?? ?? ?? 50 89 44 24 2C E8 ?? ?? ?? ?? 59 0F AE 5C 24 28 8B 44 24 28 33 D2 84 C0 79 03 6A 10 5A BF 00 02 00 00 85 C7 74 03 83 CA 08 66 A9 00 04 74 03 83 CA 04 66 A9 00 08 74 03 83 CA 02 66 A9 00 10 74 03 83 CA 01 BE 00 01 00 00 85 C6 74 06 81 CA 00 00 08 00 8B C8 23 CD 74 22 81 F9 00 20 00 00 74 18 81 F9 00 40 00 00 74 0C 3B CD 75 0E 81 CA 00 03 00 00 EB 06 0B D7 EB 02 0B D6 23 C3 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CA 00 00 00 01 EB 0E 81 CA 00 00 00 03 EB 06 81 CA 00 00 00 02 8B 44 24 2C 89 10 EB 06 8B 44 24 2C 89 30 5F 5E 33 C0 5D 40 5B 83 C4 0C C3 }
	condition:
		$1
}

rule file_257_17_0 {
	meta:
		name = "__control87"
		size = 771
		refs = "00c1 __hw_cw 016a ___sse2_available 023a ___hw_cw_sse2 0244 ___set_fpsr_sse2"
	strings:
		$1 = { 83 EC 10 53 55 56 57 9B D9 7C 24 14 8B 5C 24 14 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 BF 00 0C 00 00 23 C7 BD 00 03 00 00 BE 00 02 00 00 74 20 3D 00 04 00 00 74 13 3D 00 08 00 00 74 08 3B C7 75 0E 0B D5 EB 0A 0B D6 EB 06 81 CA 00 01 00 00 23 CD 74 0C 3B CE 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 66 F7 C3 00 10 74 06 81 CA 00 00 04 00 8B 74 24 28 8B 4C 24 24 8B C6 F7 D0 23 C2 23 CE 0B C1 3B C2 89 44 24 1C 0F 84 AA 00 00 00 8B D8 E8 ?? ?? ?? ?? 0F B7 C0 89 44 24 10 D9 6C 24 10 9B D9 7C 24 10 8B 5C 24 10 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 23 C7 74 24 3D 00 04 00 00 74 17 3D 00 08 00 00 74 08 3B C7 75 12 0B D5 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 23 CD 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 66 F7 C3 00 10 74 06 81 CA 00 00 04 00 8B C2 89 54 24 1C 83 3D ?? ?? ?? ?? 00 0F 84 86 01 00 00 81 E6 1F 03 08 03 8B FE 0F AE 5C 24 18 8B 44 24 18 33 F6 84 C0 79 03 6A 10 5E 66 A9 00 02 74 03 83 CE 08 66 A9 00 04 74 03 83 CE 04 66 A9 00 08 74 03 83 CE 02 66 A9 00 10 74 03 83 CE 01 66 A9 00 01 74 06 81 CE 00 00 08 00 8B C8 BD 00 60 00 00 23 CD 74 2A 81 F9 00 20 00 00 74 1C 81 F9 00 40 00 00 74 0C 3B CD 75 16 81 CE 00 03 00 00 EB 0E 81 CE 00 02 00 00 EB 06 81 CE 00 01 00 00 BB 40 80 00 00 23 C3 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CE 00 00 00 01 EB 0E 81 CE 00 00 00 03 EB 06 81 CE 00 00 00 02 8B D7 23 7C 24 24 F7 D2 23 D6 0B D7 3B D6 75 07 8B C6 E9 AB 00 00 00 E8 ?? ?? ?? ?? 50 89 44 24 2C E8 ?? ?? ?? ?? 59 0F AE 5C 24 28 8B 44 24 28 33 D2 84 C0 79 03 6A 10 5A BF 00 02 00 00 85 C7 74 03 83 CA 08 66 A9 00 04 74 03 83 CA 04 66 A9 00 08 74 03 83 CA 02 66 A9 00 10 74 03 83 CA 01 BE 00 01 00 00 85 C6 74 06 81 CA 00 00 08 00 8B C8 23 CD 74 22 81 F9 00 20 00 00 74 18 81 F9 00 40 00 00 74 0C 3B CD 75 0E 81 CA 00 03 00 00 EB 06 0B D7 EB 02 0B D6 23 C3 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CA 00 00 00 01 EB 0E 81 CA 00 00 00 03 EB 06 81 CA 00 00 00 02 8B C2 8B 4C 24 1C 8B D0 33 D1 0B C1 F7 C2 1F 03 08 00 74 05 0D 00 00 00 80 5F 5E 5D 5B 83 C4 10 C3 }
	condition:
		$1
}

rule file_257_18_0 {
	meta:
		name = "__controlfp"
		size = 777
		refs = "00ca __hw_cw 0173 ___sse2_available 0243 ___hw_cw_sse2 024d ___set_fpsr_sse2"
	strings:
		$1 = { 83 EC 10 53 55 56 8B 74 24 24 57 81 E6 FF FF F7 FF 9B D9 7C 24 10 8B 5C 24 10 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 BF 00 0C 00 00 23 C7 BD 00 03 00 00 74 24 3D 00 04 00 00 74 17 3D 00 08 00 00 74 08 3B C7 75 12 0B D5 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 23 CD 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 66 F7 C3 00 10 74 06 81 CA 00 00 04 00 8B C6 F7 D0 8B CE 23 4C 24 24 23 C2 0B C1 3B C2 89 44 24 1C 0F 84 AA 00 00 00 8B D8 E8 ?? ?? ?? ?? 0F B7 C0 89 44 24 28 D9 6C 24 28 9B D9 7C 24 28 8B 5C 24 28 33 D2 F6 C3 01 74 03 6A 10 5A F6 C3 04 74 03 83 CA 08 F6 C3 08 74 03 83 CA 04 F6 C3 10 74 03 83 CA 02 F6 C3 20 74 03 83 CA 01 F6 C3 02 74 06 81 CA 00 00 08 00 0F B7 CB 8B C1 23 C7 74 24 3D 00 04 00 00 74 17 3D 00 08 00 00 74 08 3B C7 75 12 0B D5 EB 0E 81 CA 00 02 00 00 EB 06 81 CA 00 01 00 00 23 CD 74 10 81 F9 00 02 00 00 75 0E 81 CA 00 00 01 00 EB 06 81 CA 00 00 02 00 66 F7 C3 00 10 74 06 81 CA 00 00 04 00 8B C2 89 54 24 1C 83 3D ?? ?? ?? ?? 00 0F 84 83 01 00 00 81 E6 1F 03 08 03 8B FE 0F AE 5C 24 18 8B 44 24 18 33 F6 84 C0 79 03 6A 10 5E 66 A9 00 02 74 03 83 CE 08 66 A9 00 04 74 03 83 CE 04 66 A9 00 08 74 03 83 CE 02 66 A9 00 10 74 03 83 CE 01 66 A9 00 01 74 06 81 CE 00 00 08 00 8B C8 BD 00 60 00 00 23 CD 74 2A 81 F9 00 20 00 00 74 1C 81 F9 00 40 00 00 74 0C 3B CD 75 16 81 CE 00 03 00 00 EB 0E 81 CE 00 02 00 00 EB 06 81 CE 00 01 00 00 BB 40 80 00 00 23 C3 83 E8 40 74 1C 2D C0 7F 00 00 74 0D 83 E8 40 75 16 81 CE 00 00 00 01 EB 0E 81 CE 00 00 00 03 EB 06 81 CE 00 00 00 02 8B D7 23 7C 24 24 F7 D2 23 D6 0B D7 3B D6 75 07 8B C6 E9 A8 00 00 00 E8 ?? ?? ?? ?? 50 89 44 24 18 E8 ?? ?? ?? ?? 59 0F AE 5C 24 14 8B 4C 24 14 33 C0 84 C9 79 03 6A 10 58 BF 00 02 00 00 85 CF 74 03 83 C8 08 66 F7 C1 00 04 74 03 83 C8 04 66 F7 C1 00 08 74 03 83 C8 02 66 F7 C1 00 10 74 03 83 C8 01 BE 00 01 00 00 85 CE 74 05 0D 00 00 08 00 8B D1 23 D5 74 21 81 FA 00 20 00 00 74 17 81 FA 00 40 00 00 74 0B 3B D5 75 0D 0D 00 03 00 00 EB 06 0B C7 EB 02 0B C6 23 CB 83 E9 40 74 1B 81 E9 C0 7F 00 00 74 0C 83 E9 40 75 13 0D 00 00 00 01 EB 0C 0D 00 00 00 03 EB 05 0D 00 00 00 02 8B 4C 24 1C 8B D0 33 D1 0B C1 F7 C2 1F 03 08 00 74 05 0D 00 00 00 80 5F 5E 5D 5B 83 C4 10 C3 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "_iszerod"
		size = 24
	strings:
		$1 = { F7 44 24 08 FF FF FF 7F 75 0B 83 7C 24 04 00 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_258_1_0 {
	meta:
		name = "_isinfd"
		size = 26
	strings:
		$1 = { 25 FF FF FF 7F 3D 00 00 F8 7F 75 0B 83 7C 24 04 00 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_258_2_0 {
	meta:
		name = "_issnand"
		size = 40
	strings:
		$1 = { 8B 44 24 08 25 00 00 F8 7F 3D 00 00 F0 7F 75 15 F7 44 24 08 FF FF 07 00 75 07 83 7C 24 04 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_258_3_0 {
	meta:
		name = "_isnand"
		size = 39
	strings:
		$1 = { 8B 4C 24 08 B8 00 00 F0 7F 23 C8 3B C8 75 15 F7 44 24 08 FF FF 0F 00 75 07 83 7C 24 04 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_258_4_0 {
	meta:
		name = "_quietd"
		size = 27
	strings:
		$1 = { 55 8B EC 83 E4 F8 51 51 0D 00 00 08 00 89 0C 24 89 44 24 04 DD 04 24 8B E5 5D C3 }
	condition:
		$1
}

rule file_258_5_0 {
	meta:
		name = "_isdenormald"
		size = 34
	strings:
		$1 = { F7 44 24 08 00 00 F0 7F 75 15 F7 44 24 08 FF FF 0F 00 75 07 83 7C 24 04 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_258_6_0 {
	meta:
		name = "_isdenormalf"
		size = 27
	strings:
		$1 = { F7 44 24 04 00 00 80 7F 75 0E F7 44 24 04 FF FF 7F 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_258_7_0 {
	meta:
		name = "_Fill_FPIEEE_RECORD"
		size = 193
	strings:
		$1 = { 8B 48 20 8B 50 10 33 11 83 E2 03 31 11 8B 50 14 8B 48 20 C1 E2 02 33 11 83 E2 1C 31 11 8B 10 8B 48 20 C1 EA 05 F7 D2 33 51 08 83 E2 01 31 51 08 8B 10 8B 48 20 C1 EA 03 F7 D2 33 51 08 83 E2 02 31 51 08 8B 10 8B 48 20 D1 EA F7 D2 33 51 08 83 E2 04 31 51 08 8B 10 8B 48 20 03 D2 F7 D2 33 51 08 83 E2 08 31 51 08 8B 10 8B 48 20 C1 E2 04 F7 D2 33 51 08 83 E2 10 31 51 08 8B 48 20 83 61 0C FE 8B 48 20 83 61 0C FD 8B 48 20 83 61 0C FB 8B 48 20 83 61 0C F7 8B 48 20 83 61 0C EF 8B 48 20 83 61 04 FE 8B 48 20 83 61 04 FD 8B 48 20 83 61 04 FB 8B 48 20 83 61 04 F7 8B 40 20 83 60 04 EF C3 }
	condition:
		$1
}

rule file_258_8_0 {
	meta:
		name = "_XMMI2_FP_Emulation"
		size = 5476
		refs = "000d ___security_cookie 0066 $LN348 006d $LN435 0098 _isdenormald 00d6 $LN436 0148 __control87 01fe __statusfp 0225 _Fill_FPIEEE_RECORD 024b _isnand 0322 _MIN_DOUBLE_NORMALA 0328 _memcpy 0333 _MAX_DOUBLE_NORMALA 0347 _POSINFDEA 035b _NEGINFDEA 036f _TWO_TO_1536A 0383 _TWO_TO_M1536A 0618 _ZERODA 062b _NZERODA 0704 @__security_check_cookie@4 07f9 $LN349 0800 $LN437 080d _issnand 090e $LN350 0915 $LN438 0955 $LN351 095c $LN439 0ca3 _isdenormalf 1000 _MIN_SINGLE_NORMALA 102e _MAX_SINGLE_NORMALA 1126 _ZEROFA 113d _NZEROFA 14cc $LN332 14d0 $LN21 14d4 $LN55 14d8 $LN257 14dc $LN206 14e0 $LN138 14e4 $LN112 14e8 $LN97 14ec $LN175 14f0 $LN164 1514 $LN326 151c $LN325 1524 $LN324 152c $LN323 1534 $LN251 1538 $LN246 1544 $LN209 1548 $LN210"
	strings:
		$1 = { 55 8B EC 83 E4 F8 81 EC AC 00 00 00 A1 ?? ?? ?? ?? 33 C4 89 84 24 A8 00 00 00 53 56 8B 75 08 57 DB E3 8B 46 20 8B 08 33 4E 10 33 D2 83 E1 03 31 08 8B 4E 14 8B 46 20 C1 E1 02 33 08 89 54 24 54 83 E1 1C 31 08 8B 4E 20 8B 19 C1 EB 05 81 E3 FF 0F 00 00 8D 7B BA 83 FF 1E 89 54 24 58 0F 87 94 06 00 00 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 39 56 0C 8B 59 14 8B 41 10 89 5C 24 14 8B 59 30 89 5C 24 18 8B 59 34 89 44 24 10 89 5C 24 1C 74 3C FF 74 24 14 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 BA 00 00 00 80 74 09 21 54 24 14 83 64 24 10 00 FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 21 54 24 1C 83 64 24 18 00 83 FF 07 77 39 FF 24 BD ?? ?? ?? ?? 8B 01 25 3F 00 FE FF 83 C8 20 EB 24 8B 01 25 5F 00 FE FF 83 C8 40 EB 18 8B 01 25 7F 00 FE FF 83 C8 60 EB 0C 8B 01 25 9F 00 FE FF 0D 80 00 00 00 89 01 8B 46 10 83 E8 00 BF 00 01 00 00 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 13 B8 00 02 00 00 EB 0C 8B C7 EB 08 33 C0 EB 04 8B 44 24 58 0D 1F 00 09 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 59 59 74 7C 48 74 54 48 74 2C 48 0F 85 92 00 00 00 DB E2 DD 44 24 10 DD 44 24 18 DE F9 DD 5C 24 40 DB E2 DD 44 24 10 DD 44 24 18 DE F9 DB BC 24 A8 00 00 00 EB 6D DB E2 DD 44 24 10 DD 44 24 18 DE C9 DD 5C 24 40 DB E2 DD 44 24 10 DD 44 24 18 DE C9 DB BC 24 A8 00 00 00 EB 48 DB E2 DD 44 24 10 DD 44 24 18 DE E9 DD 5C 24 40 DB E2 DD 44 24 10 DD 44 24 18 DE E9 DB BC 24 A8 00 00 00 EB 23 DB E2 DD 44 24 10 DD 44 24 18 DE C1 DD 5C 24 40 DB E2 DD 44 24 10 DD 44 24 18 DE C1 DB BC 24 A8 00 00 00 E8 ?? ?? ?? ?? A8 08 89 44 24 50 74 08 81 64 24 50 FF FF F7 FF 8B 06 33 DB 43 84 C3 75 26 F6 44 24 50 10 74 1F 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 09 5E 04 8B 76 20 83 4E 04 10 8B C3 E9 B6 04 00 00 8B 54 24 14 52 FF 74 24 14 E8 ?? ?? ?? ?? 85 C0 59 59 89 44 24 5C 0F 85 B5 04 00 00 FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 9E 04 00 00 8B 06 A8 02 BA 00 00 08 00 75 13 85 54 24 50 74 0D 8B C6 E8 ?? ?? ?? ?? 83 4E 04 02 EB A8 A8 04 75 22 F6 44 24 50 08 74 1B 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 08 83 4E 04 04 8B 76 20 83 4E 04 08 EB 82 DD 44 24 40 DD 5C 24 38 FF 74 24 3C FF 74 24 3C E8 ?? ?? ?? ?? 85 C0 59 59 74 3B 8B 46 20 09 58 60 DD 44 24 38 8B 46 20 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 8B 46 20 83 48 0C 10 09 5E 04 E9 E7 03 00 00 85 54 24 50 74 04 83 4E 04 02 6A 0A 8D 84 24 A0 00 00 00 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 44 24 70 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 84 24 88 00 00 00 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 84 24 B8 00 00 00 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 84 24 B8 00 00 00 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 6A 0A 8D 84 24 B8 00 00 00 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 48 DB AC 24 A8 00 00 00 DB AC 24 9C 00 00 00 D9 E0 DE D9 9B DD 7C 24 2C D9 EE DB AC 24 A8 00 00 00 DE D9 9B DD 7C 24 28 DB AC 24 A8 00 00 00 D9 EE DE D9 9B DD 7C 24 30 DB AC 24 9C 00 00 00 DB AC 24 A8 00 00 00 DE D9 9B DD 7C 24 34 8B 44 24 2C B9 00 45 00 00 66 23 C1 66 3B C7 75 0C 8B 44 24 28 66 23 C1 66 3B C7 74 18 8B 44 24 30 66 23 C1 66 3B C7 75 10 8B 44 24 34 66 23 C1 66 3B C7 75 04 89 5C 24 54 DB AC 24 A8 00 00 00 DB AC 24 90 00 00 00 DE D9 9B DD 7C 24 2C DB 6C 24 60 D9 E0 DB AC 24 A8 00 00 00 DE D9 9B DD 7C 24 28 DB AC 24 A8 00 00 00 DB 6C 24 60 DE D9 9B DD 7C 24 30 DB 6C 24 6C DB AC 24 A8 00 00 00 DE D9 9B DD 7C 24 34 8B 44 24 2C 66 23 C1 66 3B C7 75 0C 8B 44 24 28 66 23 C1 66 3B C7 74 18 8B 44 24 30 66 23 C1 66 3B C7 75 10 8B 44 24 34 66 23 C1 66 3B C7 75 04 89 5C 24 58 8B 06 A8 10 75 5D 83 7C 24 54 00 74 56 DB AC 24 A8 00 00 00 DB AC 24 84 00 00 00 DE C9 DD 5C 24 40 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 02 8B 46 20 83 4E 04 10 83 48 04 02 8B 46 20 09 58 60 DD 44 24 40 84 5C 24 50 8B 46 20 DD 58 50 0F 84 50 FD FF FF 8B 46 20 09 58 0C 83 4E 04 20 E9 41 FD FF FF A8 08 75 33 83 7C 24 58 00 74 2C DB AC 24 A8 00 00 00 DB 6C 24 78 DE C9 DD 5C 24 40 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 04 8B 46 20 83 4E 04 08 83 48 04 04 EB A0 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 74 39 48 74 26 48 74 13 48 75 3E DD 44 24 10 DD 44 24 18 DE F9 DD 5C 24 38 EB 2E DD 44 24 10 DD 44 24 18 DE C9 DD 5C 24 38 EB 1E DD 44 24 10 DD 44 24 18 DE E9 DD 5C 24 38 EB 0E DD 44 24 10 DD 44 24 18 DE C1 DD 5C 24 38 E8 ?? ?? ?? ?? 8B C8 33 FF 84 CB 74 09 39 7C 24 54 74 03 83 C9 02 F6 06 20 0F 85 9C 00 00 00 84 CB 75 13 39 7E 08 0F 84 8F 00 00 00 39 7C 24 54 0F 84 85 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 39 7C 24 54 74 0B 8B 46 20 83 48 0C 02 83 4E 04 10 39 7C 24 58 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 7E 08 74 32 39 7C 24 54 74 2C D9 EE DC 54 24 38 DF E0 F6 C4 05 7A 0A DD D8 DD 05 ?? ?? ?? ?? EB 11 DC 5C 24 38 DF E0 F6 C4 41 75 0A DD 05 ?? ?? ?? ?? DD 5C 24 38 8B 46 20 DD 44 24 38 DD 58 50 E9 F8 FB FF FF 8B 46 20 09 58 60 F6 C1 02 8B 46 20 74 0A 83 48 0C 02 83 4E 04 10 EB 04 83 60 0C FD F6 C1 04 8B 46 20 74 0A 83 48 0C 04 83 4E 04 08 EB 04 83 60 0C FB 84 CB 8B 46 20 74 09 09 58 0C 83 4E 04 20 EB 04 83 60 0C FE 39 7E 08 74 47 39 7C 24 54 74 41 D9 EE DC 54 24 38 DF E0 F6 C4 05 7A 0A DD D8 DD 05 ?? ?? ?? ?? EB 11 DC 5C 24 38 DF E0 F6 C4 41 75 0A DD 05 ?? ?? ?? ?? DD 5C 24 38 8B 46 20 09 58 0C 83 4E 04 20 8B 46 20 83 48 0C 02 83 4E 04 10 F6 C1 08 DD 44 24 38 8B 46 20 DD 58 50 8B 46 20 74 26 83 48 0C 08 83 4E 04 04 8B 76 20 83 66 0C EF 33 C0 8B 8C 24 B4 00 00 00 5F 5E 5B 33 CC E8 ?? ?? ?? ?? 8B E5 5D C3 83 60 0C F7 EB DC 8B 46 20 09 58 60 83 7C 24 5C 00 74 2B FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 85 C0 59 59 74 18 8B 44 24 10 81 CA 00 00 08 00 89 44 24 18 89 54 24 1C DD 44 24 18 EB 04 DD 44 24 40 8B 46 20 DD 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 F6 44 24 50 10 0F 84 73 FF FF FF E9 7F FB FF FF 39 56 0C 8B 79 14 8B 41 10 8B 59 34 89 7C 24 14 8B 79 30 89 44 24 10 89 7C 24 18 89 5C 24 1C 74 39 FF 74 24 14 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 BA 00 00 00 80 74 09 21 54 24 14 83 64 24 10 00 FF 74 24 1C 57 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 21 54 24 1C 83 64 24 18 00 8B 01 8B 7E 18 25 FF 00 FE FF 33 DB 83 E7 07 0D E0 00 00 00 43 83 FF 07 89 01 77 4D 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 1A FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 06 21 44 24 54 EB 04 89 5C 24 54 E8 ?? ?? ?? ?? A8 10 74 04 89 5C 24 54 33 D2 39 54 24 54 74 08 84 1E 0F 84 CF F9 FF FF FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 2B 01 00 00 FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 14 01 00 00 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 4E 83 4E 04 02 F6 06 02 75 45 8B C6 E8 ?? ?? ?? ?? E9 7C F9 FF FF FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 6A FF FF FF FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 53 FF FF FF 33 D2 89 54 24 54 E9 5C FF FF FF DD 44 24 18 DC 5C 24 10 DF E0 F6 C4 41 75 13 83 FF 07 77 5D 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? DD 44 24 18 DC 5C 24 10 DF E0 F6 C4 05 7A 16 83 FF 03 76 33 83 FF 07 77 36 83 4C 24 18 FF 83 4C 24 1C FF EB 2A DD 44 24 18 DC 5C 24 10 DF E0 F6 C4 44 7A 1B 83 FF 07 77 16 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 89 54 24 18 89 54 24 1C 8B 46 20 DD 44 24 18 09 58 60 8B 46 20 DD 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 E9 77 FD FF FF 83 FF 02 76 0A 83 FF 06 76 42 83 FF 07 75 08 89 54 24 18 89 54 24 1C 8B 46 20 DD 44 24 18 09 58 60 8B 46 20 DD 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 39 54 24 54 E9 94 FD FF FF 83 4C 24 18 FF 83 4C 24 1C FF EB BF 39 56 0C 8B 41 10 8B 79 14 89 44 24 10 8B 41 30 89 44 24 18 8B 41 34 89 7C 24 14 89 44 24 1C 74 40 57 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 08 85 C0 BA 00 00 00 80 74 0B 23 FA 83 64 24 10 00 89 7C 24 14 FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 09 21 54 24 1C 83 64 24 18 00 33 D2 8B C3 83 E8 56 6A 01 5B 74 3D 48 75 61 57 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 18 FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 04 33 FF EB 02 8B FB E8 ?? ?? ?? ?? 33 D2 A8 10 74 2F 8B FB EB 2B 57 FF 74 24 14 E8 ?? ?? ?? ?? 85 C0 59 59 75 EC FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 85 C0 59 59 75 D9 33 FF EB 04 8B 7C 24 54 8B 46 20 8B 08 81 E1 FF 00 FE FF 81 C9 E0 00 00 00 3B FA 89 08 74 08 84 1E 0F 84 43 F7 FF FF FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 A8 00 00 00 FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 91 00 00 00 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 08 85 C0 75 14 FF 74 24 1C FF 74 24 1C E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 70 FD FF FF DD 44 24 18 DC 5C 24 10 DF E0 F6 C4 05 7A 0C 81 66 1C 2A F7 FF FF E9 1B FE FF FF DD 44 24 18 DC 5C 24 10 DF E0 F6 C4 41 75 0C 8B 46 1C 25 2B F7 FF FF 0B C3 EB 1E DD 44 24 18 DC 5C 24 10 DF E0 F6 C4 44 0F 8A ED FD FF FF 8B 46 1C 25 6A F7 FF FF 83 C8 40 89 46 1C E9 DA FD FF FF 8B 46 1C 25 6F F7 FF FF 83 C8 45 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 3B FA E9 A6 FB FF FF 8B 41 10 89 44 24 5C 8B 46 10 83 E8 00 BF 00 01 00 00 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 13 B8 00 02 00 00 EB 0C 8B C7 EB 08 33 C0 EB 04 8B 44 24 58 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 DB 44 24 5C D9 5C 24 0C E8 ?? ?? ?? ?? 33 DB 43 F6 06 20 75 3F 84 C3 74 3B 8B C6 E8 ?? ?? ?? ?? 8B 46 20 8B 08 81 E1 1F 01 FE FF 0B CF 89 08 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 8B 46 20 D9 44 24 0C D9 58 50 E9 CC F5 FF FF 8B 4E 20 09 59 60 D9 44 24 0C 8B 4E 20 D9 59 50 84 C3 8B 46 20 0F 84 F2 FC FF FF 09 58 0C 83 4E 04 20 E9 EA FC FF FF 39 56 0C 8B 41 10 89 44 24 50 74 15 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 81 64 24 50 00 00 00 80 83 EB 61 BF 00 01 00 00 74 0E 4B 75 19 8B 01 25 1F 01 FE FF 0B C7 EB 0C 8B 01 25 5F 05 FE FF 0D 40 05 00 00 89 01 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 83 F8 08 74 05 83 F8 2A EB 0F 8B 46 10 83 E8 00 74 17 48 74 1C 48 74 0A 48 75 12 BF 00 03 00 00 EB 0F BF 00 02 00 00 EB 08 33 FF EB 04 8B 7C 24 58 81 CF 1F 00 0A 00 68 1F 03 0B 00 57 E8 ?? ?? ?? ?? 59 59 DB E2 D9 44 24 50 DB 5C 24 24 E8 ?? ?? ?? ?? 33 DB 43 84 1E 75 08 A8 10 0F 85 D7 F4 FF FF 8B 4E 20 8B 54 24 24 89 51 50 F6 06 20 75 26 84 C3 74 22 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 76 20 09 5E 60 E9 BA F4 FF FF 8B 4E 20 09 59 60 84 C3 8B 4E 20 74 09 09 59 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 E9 BF F9 FF FF 39 56 0C 8B 41 10 8B 79 14 89 44 24 10 89 7C 24 14 74 1A 57 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0C 81 64 24 14 00 00 00 80 89 54 24 10 83 FB 58 BF 00 01 00 00 72 1F 83 FB 59 76 0F 83 FB 5B 76 2C 83 FB 63 74 27 83 FB 64 75 0B 8B 01 25 1F 01 FE FF 0B C7 89 01 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 83 F8 08 74 13 83 F8 2A EB 1D 8B 01 25 5F 05 FE FF 0D 40 05 00 00 EB D9 8B 46 10 83 E8 00 74 17 48 74 1C 48 74 0A 48 75 12 BF 00 03 00 00 EB 0F BF 00 02 00 00 EB 08 33 FF EB 04 8B 7C 24 58 81 CF 1F 00 09 00 68 1F 03 0B 00 57 E8 ?? ?? ?? ?? 59 59 DB E2 DD 44 24 10 DB 5C 24 24 E9 BD FE FF FF 39 56 0C 8B 41 10 89 44 24 50 74 15 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 08 81 64 24 50 00 00 00 80 8B 01 25 1F 01 FE FF 0D 00 01 00 00 89 01 DB E2 D9 44 24 50 DD 5C 24 38 E8 ?? ?? ?? ?? 8B 0E 33 DB 43 84 CB 75 08 A8 10 0F 85 59 F3 FF FF 8B D0 81 E2 00 00 08 00 74 04 83 4E 04 02 F6 C1 02 75 08 85 D2 0F 85 CE F9 FF FF 8B 4E 20 DD 44 24 38 DD 59 50 8B 4E 20 09 59 60 8B 4E 20 E9 9A FE FF FF 39 56 0C 8B 41 10 8B 79 14 89 44 24 10 89 7C 24 14 74 1A 57 50 E8 ?? ?? ?? ?? 83 C4 08 85 C0 74 0C 81 64 24 14 00 00 00 80 89 54 24 10 8B 01 25 1F 01 FE FF BF 00 01 00 00 0B C7 89 01 8B 46 10 83 E8 00 74 17 48 74 1C 48 74 0A 48 75 12 BF 00 03 00 00 EB 0F BF 00 02 00 00 EB 08 33 FF EB 04 8B 7C 24 58 68 1F 03 0B 00 81 CF 1F 00 0A 00 57 E8 ?? ?? ?? ?? 59 59 DB E2 DD 44 24 10 D9 5C 24 0C E8 ?? ?? ?? ?? 33 DB 8B D0 8B 06 43 84 C3 75 09 F6 C2 10 0F 85 8C F2 FF FF 8B CA 81 E1 00 00 08 00 74 04 83 4E 04 02 A8 02 75 08 85 C9 0F 85 02 F9 FF FF FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 26 02 00 00 8B 44 24 14 25 FF FF FF 7F 3D 00 00 F8 7F 75 0B 83 7C 24 10 00 0F 84 0B 02 00 00 85 C0 75 0A 39 44 24 10 0F 84 FD 01 00 00 DB E2 DD 44 24 10 D9 E8 DE C9 DD 5C 24 48 DD 05 }
	condition:
		$1
}

rule file_259_0_0 {
	meta:
		name = "__RTC_CheckEsp"
		size = 35
		refs = "0014 ?_RTC_Failure@@YAXPAXH@Z"
	strings:
		$1 = { 75 01 C3 55 8B EC 83 EC 00 50 52 53 56 57 6A 00 FF 75 04 E8 ?? ?? ?? ?? 59 59 5F 5E 5B 5A 58 8B E5 5D C3 }
	condition:
		$1
}

rule file_259_1_0 {
	meta:
		name = "@_RTC_CheckStackVars@8"
		size = 90
		refs = "003f ?_RTC_StackFailure@@YAXPAXPBD@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B F2 33 DB 39 1E 8B D1 89 55 F8 89 5D FC 7E 3F 57 BF CC CC CC CC 8B 46 04 03 C3 8B 08 39 7C 11 FC 75 0A 8B 40 04 03 C1 39 3C 10 74 14 8B 46 04 FF 74 18 08 FF 75 04 E8 ?? ?? ?? ?? 8B 55 F8 59 59 FF 45 FC 8B 45 FC 83 C3 0C 3B 06 7C C8 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_259_2_0 {
	meta:
		name = "@_RTC_AllocaHelper@12"
		size = 45
	strings:
		$1 = { 56 8B F1 85 F6 74 22 85 D2 74 1E 53 8B 5C 24 0C 85 DB 74 14 57 B0 CC 8B FE 8B CA F3 AA 8B 03 89 46 04 89 56 0C 89 33 5F 5B 5E C2 04 00 }
	condition:
		$1
}

rule file_259_3_0 {
	meta:
		name = "@_RTC_CheckStackVars2@12"
		size = 179
		refs = "0043 ?_RTC_StackFailure@@YAXPAXPBD@Z 0087 ?_RTC_AllocaFailure@@YAXPAXPAU_RTC_ALLOCA_NODE@@H@Z"
	strings:
		$1 = { 55 8B EC 51 51 53 56 8B F2 33 DB 3B F3 8B D1 57 89 55 F8 BF CC CC CC CC 74 3F 39 1E 89 5D FC 7E 38 8B 46 04 03 C3 8B 08 39 7C 11 FC 75 0A 8B 40 04 03 C1 39 3C 10 74 14 8B 46 04 FF 74 03 08 FF 75 04 E8 ?? ?? ?? ?? 8B 55 F8 59 59 FF 45 FC 8B 45 FC 83 C3 0C 3B 06 7C C8 8B 75 08 33 DB 85 F6 8B C6 74 48 8B 40 04 43 85 C0 75 F8 EB 3A 39 3E 75 0F 39 7E 14 75 0A 39 7E 18 75 05 39 7E 1C 74 0D 53 56 FF 75 04 E8 ?? ?? ?? ?? 83 C4 0C 8B 46 0C 39 7C 30 FC 74 0D 53 56 FF 75 04 E8 ?? ?? ?? ?? 83 C4 0C 8B 76 04 4B 85 F6 75 C2 5F 5E 5B C9 C2 04 00 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "___crtGetCommandLineW"
		size = 159
		refs = "0001 ?f_use@?1??__crtGetCommandLineW@@9@9 000d __imp__GetCommandLineW@0 0027 __imp__GetLastError@0 0052 __imp__GetCommandLineA@0 0058 __imp__MultiByteToWideChar@24 0072 __calloc_crt 0093 _free"
	strings:
		$1 = { A1 ?? ?? ?? ?? 53 33 DB 3B C3 56 8B 35 ?? ?? ?? ?? 75 2D FF D6 85 C0 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 20 FF 15 ?? ?? ?? ?? 83 F8 78 75 0C C7 05 ?? ?? ?? ?? 02 00 00 00 EB 12 33 C0 EB 5C 83 F8 01 75 04 FF D6 EB 53 83 F8 02 75 EE 55 57 FF 15 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? 53 53 6A FF 8B E8 55 6A 01 53 FF D6 8B F8 3B FB 74 2A 6A 02 57 E8 ?? ?? ?? ?? 8B D8 85 DB 59 59 74 1A 57 53 6A FF 55 6A 01 6A 00 FF D6 85 C0 74 04 8B C3 EB 09 53 E8 ?? ?? ?? ?? 59 33 C0 5F 5D 5E 5B C3 }
	condition:
		$1
}

rule file_263_0_0 {
	meta:
		name = "_fputc"
		size = 319
		refs = "0003 __sehtable$_fputc 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 0041 __lock_file 0055 __fileno 0077 ___pioinfo 008e ___badioinfo 0116 __flsbuf 012f __SEH_epilog4 0139 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C0 8B 75 0C 3B F3 0F 95 C0 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EF 00 00 00 56 E8 ?? ?? ?? ?? 59 89 5D FC F6 46 0C 40 0F 85 A6 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 8D 3C 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 07 EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 75 45 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 8D 3C 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 07 EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 4D E4 FF 39 5D E4 75 21 FF 4E 04 78 0E 8B 0E 8A 45 08 88 01 0F B6 C0 FF 06 EB 0B 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_263_1_0 {
	meta:
		name = "_putc"
		size = 319
		refs = "0003 __sehtable$_putc 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 0041 __lock_file 0055 __fileno 0077 ___pioinfo 008e ___badioinfo 0116 __flsbuf 012f __SEH_epilog4 0139 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C0 8B 75 0C 3B F3 0F 95 C0 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 EF 00 00 00 56 E8 ?? ?? ?? ?? 59 89 5D FC F6 46 0C 40 0F 85 A6 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 8D 3C 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 07 EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 75 45 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 56 E8 ?? ?? ?? ?? C1 F8 05 8D 3C 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 07 EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 4D E4 FF 39 5D E4 75 21 FF 4E 04 78 0E 8B 0E 8A 45 08 88 01 0F B6 C0 FF 06 EB 0B 56 FF 75 08 E8 ?? ?? ?? ?? 59 59 89 45 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 75 0C 56 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_265_2_0 {
	meta:
		name = "___ansicp"
		size = 71
		refs = "0007 ___security_cookie 0024 __imp__GetLocaleInfoA@16 0036 _atol 0041 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 6A 06 8D 45 F4 50 68 04 10 00 00 FF 75 08 C6 45 FA 00 FF 15 ?? ?? ?? ?? 85 C0 75 05 83 C8 FF EB 0A 8D 45 F4 50 E8 ?? ?? ?? ?? 59 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_265_3_0 {
	meta:
		name = "___convertcp"
		size = 434
		refs = "0007 ___security_cookie 0040 __imp__GetCPInfo@8 004f __imp__MultiByteToWideChar@24 0081 _strlen 00a1 __alloca_probe_16 00d1 _malloc 00f9 _memset 012c __imp__WideCharToMultiByte@32 015c __calloc_crt 017f _free 0198 __freea 01ac @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 10 8B 4D 18 89 45 D8 8B 45 14 53 89 45 D0 8B 00 56 89 45 DC 8B 45 08 57 33 FF 3B 45 0C 89 4D CC 89 7D E0 89 7D D4 0F 84 5F 01 00 00 8B 35 ?? ?? ?? ?? 8D 4D E8 51 50 FF D6 85 C0 8B 1D ?? ?? ?? ?? 74 5E 83 7D E8 01 75 58 8D 45 E8 50 FF 75 0C FF D6 85 C0 74 4B 83 7D E8 01 75 45 8B 75 DC 83 FE FF C7 45 D4 01 00 00 00 75 0C FF 75 D8 E8 ?? ?? ?? ?? 8B F0 59 46 3B F7 7E 5B 81 FE F0 FF FF 7F 77 53 8D 44 36 08 3D 00 04 00 00 77 2F E8 ?? ?? ?? ?? 8B C4 3B C7 74 38 C7 00 CC CC 00 00 EB 2D 57 57 FF 75 DC FF 75 D8 6A 01 FF 75 08 FF D3 8B F0 3B F7 75 C3 33 C0 E9 D1 00 00 00 50 E8 ?? ?? ?? ?? 3B C7 59 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 E4 EB 03 89 7D E4 39 7D E4 74 D8 8D 04 36 50 57 FF 75 E4 E8 ?? ?? ?? ?? 83 C4 0C 56 FF 75 E4 FF 75 DC FF 75 D8 6A 01 FF 75 08 FF D3 85 C0 74 7F 8B 5D CC 3B DF 74 1D 57 57 FF 75 1C 53 56 FF 75 E4 57 FF 75 0C FF 15 ?? ?? ?? ?? 85 C0 74 60 89 5D E0 EB 5B 39 7D D4 8B 1D ?? ?? ?? ?? 75 14 57 57 57 57 56 FF 75 E4 57 FF 75 0C FF D3 8B F0 3B F7 74 3C 56 6A 01 E8 ?? ?? ?? ?? 3B C7 59 59 89 45 E0 74 2B 57 57 56 50 56 FF 75 E4 57 FF 75 0C FF D3 3B C7 75 0E FF 75 E0 E8 ?? ?? ?? ?? 59 89 7D E0 EB 0B 83 7D DC FF 74 05 8B 4D D0 89 01 FF 75 E4 E8 ?? ?? ?? ?? 59 8B 45 E0 8D 65 C0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_266_0_0 {
	meta:
		name = "__flsbuf"
		size = 352
		refs = "000a __fileno 001a __errno 0077 ___iob_func 0092 __isatty 009d __getbuf 00cc __write 0100 ___pioinfo 0107 ___badioinfo 0117 __lseeki64"
	strings:
		$1 = { 55 8B EC 51 56 8B 75 0C 56 E8 ?? ?? ?? ?? 89 45 0C 8B 46 0C A8 82 59 75 17 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 4E 0C 20 83 C8 FF E9 2D 01 00 00 A8 40 74 0D E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB E3 53 33 DB A8 01 74 16 A8 10 89 5E 04 0F 84 85 00 00 00 8B 4E 08 83 E0 FE 89 0E 89 46 0C 8B 46 0C 83 E0 EF 83 C8 02 66 A9 0C 01 89 46 0C 89 5E 04 89 5D FC 75 2C E8 ?? ?? ?? ?? 83 C0 20 3B F0 74 0C E8 ?? ?? ?? ?? 83 C0 40 3B F0 75 0D FF 75 0C E8 ?? ?? ?? ?? 85 C0 59 75 07 56 E8 ?? ?? ?? ?? 59 66 F7 46 0C 08 01 57 0F 84 80 00 00 00 8B 46 08 8B 3E 8D 48 01 89 0E 8B 4E 18 2B F8 49 3B FB 89 4E 04 7E 1D 57 50 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC EB 4D 83 C8 20 89 46 0C 83 C8 FF EB 79 8B 4D 0C 83 F9 FF 74 1B 83 F9 FE 74 16 8B C1 83 E0 1F 6B C0 28 8B D1 C1 FA 05 03 04 95 ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? F6 40 04 20 74 14 6A 02 53 53 51 E8 ?? ?? ?? ?? 23 C2 83 C4 10 83 F8 FF 74 25 8B 46 08 8A 4D 08 88 08 EB 16 33 FF 47 57 8D 45 08 50 FF 75 0C E8 ?? ?? ?? ?? 83 C4 0C 89 45 FC 39 7D FC 74 09 83 4E 0C 20 83 C8 FF EB 08 8B 45 08 25 FF 00 00 00 5F 5B 5E C9 C3 }
	condition:
		$1
}

rule file_268_0_0 {
	meta:
		name = "__gets_helper"
		size = 596
		refs = "0003 __sehtable$__gets_helper 0008 __SEH_prolog4 0025 __errno 0035 __invalid_parameter 004f ___iob_func 0056 __lock_file2 0072 __fileno 0094 ___pioinfo 00ab ___badioinfo 0142 __filbuf 021b ___security_cookie 0220 __local_unwind4 023e __SEH_epilog4 024d __unlock_file2"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 89 45 E4 89 45 DC 33 C9 33 DB 3B C3 0F 95 C1 8B C1 3B C3 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 FA 01 00 00 33 C0 3B 45 0C 1B C0 F7 D8 74 D6 E8 ?? ?? ?? ?? 50 53 E8 ?? ?? ?? ?? 59 59 89 5D FC E8 ?? ?? ?? ?? 8B F8 F6 47 0C 40 0F 85 A5 00 00 00 57 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 57 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 57 E8 ?? ?? ?? ?? C1 F8 05 8D 34 85 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 06 EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 75 45 57 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 57 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 57 E8 ?? ?? ?? ?? C1 F8 05 8D 34 85 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 06 EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 89 5D DC 39 5D DC 0F 84 10 01 00 00 E8 ?? ?? ?? ?? 83 C0 04 FF 08 78 11 E8 ?? ?? ?? ?? 8B D0 8B 0A 0F B6 01 41 89 0A EB 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 45 D8 83 F8 FF 75 0C 89 5D DC 39 5D 10 0F 85 D3 00 00 00 8B 4D 0C 8B 75 E4 83 F9 FF 75 46 83 F8 0A 0F 84 BD 00 00 00 83 F8 FF 0F 84 B4 00 00 00 88 06 46 89 75 E4 E8 ?? ?? ?? ?? 83 C0 04 FF 08 78 11 E8 ?? ?? ?? ?? 8B D0 8B 0A 0F B6 01 41 89 0A EB 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 45 D8 EB BA 89 4D E0 83 F8 0A 74 41 83 F8 FF 74 3C 39 5D E0 76 09 FF 4D E0 88 06 46 89 75 E4 E8 ?? ?? ?? ?? 83 C0 04 FF 08 78 11 E8 ?? ?? ?? ?? 8B D0 8B 0A 0F B6 01 41 89 0A EB 0C E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 89 45 D8 EB BA 39 5D E0 75 32 8B 45 08 88 18 E8 ?? ?? ?? ?? C7 00 22 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 E9 10 FE FF FF 88 1E C7 45 FC FE FF FF FF E8 0B 00 00 00 8B 45 DC E8 ?? ?? ?? ?? C3 33 DB E8 ?? ?? ?? ?? 50 53 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_268_2_0 {
	meta:
		name = "_gets"
		size = 17
		refs = "0009 __gets_helper"
	strings:
		$1 = { 6A 01 6A FF FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_305_2_0 {
	meta:
		name = "__getws"
		size = 17
		refs = "0009 __getws_helper"
	strings:
		$1 = { 6A 01 6A FF FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_269_2_0 {
	meta:
		name = "_system"
		size = 271
		refs = "000b ??_C@_07CFPBBAOO@COMSPEC?$AA@ 001d __dupenv_s 0033 __invoke_watson 0052 __access_s 006a ??_C@_02HNHPBPFE@?1c?$AA@ 0077 __errno 008e __spawnve 00c0 __get_osver 00df ??_C@_0M@BOIIGAL@command?4com?$AA@ 00e8 ??_C@_07INNMNHPJ@cmd?4exe?$AA@ 00f6 __spawnvpe 0104 _free"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 57 33 FF 68 ?? ?? ?? ?? 8D 45 FC 57 50 89 7D FC 89 7D F8 33 F6 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 74 12 83 F8 16 75 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 3B C7 8B 4D FC 89 4D E8 75 1D 3B CF 0F 84 B1 00 00 00 57 51 E8 ?? ?? ?? ?? 8B F0 F7 DE 59 1B F6 59 46 E9 9C 00 00 00 3B CF 53 C7 45 EC ?? ?? ?? ?? 89 45 F0 89 7D F4 74 45 E8 ?? ?? ?? ?? 8B 18 E8 ?? ?? ?? ?? 89 38 57 8D 45 E8 50 FF 75 E8 57 E8 ?? ?? ?? ?? 83 C4 10 8B F0 E8 ?? ?? ?? ?? 83 FE FF 74 04 89 18 EB 5A 83 38 02 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 4B E8 ?? ?? ?? ?? 89 18 8D 45 F8 50 E8 ?? ?? ?? ?? 85 C0 59 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 66 F7 45 F8 00 80 C7 45 E8 ?? ?? ?? ?? 75 07 C7 45 E8 ?? ?? ?? ?? 57 8D 45 E8 50 FF 75 E8 57 E8 ?? ?? ?? ?? 83 C4 10 8B F0 5B FF 75 FC E8 ?? ?? ?? ?? 59 5F 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_322_2_0 {
	meta:
		name = "__wsystem"
		size = 271
		refs = "000b ??_C@_1BA@HMCCKBDK@?$AAC?$AAO?$AAM?$AAS?$AAP?$AAE?$AAC?$AA?$AA@ 001d __wdupenv_s 0033 __invoke_watson 0052 __waccess_s 006a ??_C@_15JBFELBFC@?$AA?1?$AAc?$AA?$AA@ 0077 __errno 008e __wspawnve 00c0 __get_osver 00df ??_C@_1BI@LHBFHNF@?$AAc?$AAo?$AAm?$AAm?$AAa?$AAn?$AAd?$AA?4?$AAc?$AAo?$AAm?$AA?$AA@ 00e8 ??_C@_1BA@DBKIDAPL@?$AAc?$AAm?$AAd?$AA?4?$AAe?$AAx?$AAe?$AA?$AA@ 00f6 __wspawnvpe 0104 _free"
	strings:
		$1 = { 55 8B EC 83 EC 18 56 57 33 FF 68 ?? ?? ?? ?? 8D 45 FC 57 50 89 7D FC 89 7D F8 33 F6 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 74 12 83 F8 16 75 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 45 08 3B C7 8B 4D FC 89 4D E8 75 1D 3B CF 0F 84 B1 00 00 00 57 51 E8 ?? ?? ?? ?? 8B F0 F7 DE 59 1B F6 59 46 E9 9C 00 00 00 3B CF 53 C7 45 EC ?? ?? ?? ?? 89 45 F0 89 7D F4 74 45 E8 ?? ?? ?? ?? 8B 18 E8 ?? ?? ?? ?? 89 38 57 8D 45 E8 50 FF 75 E8 57 E8 ?? ?? ?? ?? 83 C4 10 8B F0 E8 ?? ?? ?? ?? 83 FE FF 74 04 89 18 EB 5A 83 38 02 74 0A E8 ?? ?? ?? ?? 83 38 0D 75 4B E8 ?? ?? ?? ?? 89 18 8D 45 F8 50 E8 ?? ?? ?? ?? 85 C0 59 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 66 F7 45 F8 00 80 C7 45 E8 ?? ?? ?? ?? 75 07 C7 45 E8 ?? ?? ?? ?? 57 8D 45 E8 50 FF 75 E8 57 E8 ?? ?? ?? ?? 83 C4 10 8B F0 5B FF 75 FC E8 ?? ?? ?? ?? 59 5F 8B C6 5E C9 C3 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "__ftelli64_nolock"
		size = 436
		refs = "000e __fileno 0026 __lseeki64 008a ___pioinfo 00bc __errno"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 57 8B 7D 08 57 E8 ?? ?? ?? ?? 33 DB 39 5F 04 59 89 45 FC 7D 03 89 5F 04 6A 01 53 53 50 E8 ?? ?? ?? ?? 8B F2 83 C4 10 3B F3 8B C8 89 4D F0 89 75 F4 7F 11 7C 04 3B CB 73 0B 83 C8 FF 83 CA FF E9 63 01 00 00 8B 57 0C 66 F7 C2 08 01 75 11 8B 47 04 99 2B C8 1B F2 8B C1 8B D6 E9 48 01 00 00 8B 07 8B 4F 08 8B D8 2B D9 F6 C2 03 89 5D F8 74 3F 8B 5D FC 8B 55 FC 83 E3 1F 6B DB 28 C1 FA 05 8B 14 95 ?? ?? ?? ?? F6 44 1A 04 80 74 11 8B D1 EB 09 80 3A 0A 75 03 FF 45 F8 42 3B D0 72 F3 8B 55 F0 0B D6 75 1E 8B 45 F8 33 D2 E9 F8 00 00 00 84 D2 78 EB E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 76 FF FF FF F6 47 0C 01 0F 84 D0 00 00 00 8B 57 04 85 D2 75 08 21 55 F8 E9 C1 00 00 00 8B 75 FC 8B 5D FC 83 E6 1F 6B F6 28 2B C1 03 C2 C1 FB 05 8D 1C 9D ?? ?? ?? ?? 89 45 08 8B 03 F6 44 30 04 80 0F 84 8A 00 00 00 6A 02 6A 00 6A 00 FF 75 FC E8 ?? ?? ?? ?? 83 C4 10 3B 45 F0 75 24 3B 55 F4 75 1F 8B 47 08 8B 4D 08 03 C8 EB 09 80 38 0A 75 03 FF 45 08 40 3B C1 72 F3 66 F7 47 0C 00 20 EB 4B 6A 00 FF 75 F4 FF 75 F0 FF 75 FC E8 ?? ?? ?? ?? 83 C4 10 85 D2 7F 0E 0F 8C DC FE FF FF 85 C0 0F 82 D4 FE FF FF B8 00 02 00 00 39 45 08 77 0F 8B 4F 0C F6 C1 08 74 07 66 F7 C1 00 04 74 03 8B 47 18 89 45 08 8B 03 F6 44 30 04 04 74 03 FF 45 08 8B 45 08 29 45 F0 83 5D F4 00 8B 75 F4 8B 45 F8 33 D2 03 45 F0 13 D6 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_271_1_0 {
	meta:
		name = "__ftelli64"
		size = 74
		refs = "0003 __sehtable$__ftelli64 0008 __SEH_prolog4 0010 __lock_file 001d __ftelli64_nolock 003b __SEH_epilog4 0044 __unlock_file"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E0 89 55 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 8B 55 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_272_3_0 {
	meta:
		name = "__mbsnbcnt_l"
		size = 132
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 __errno 0031 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 0C 33 DB 39 5D 08 75 2C 3B D3 74 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 39 3B D3 8B 45 08 74 23 56 8A 08 4A 3A CB 74 1A 8B 75 F4 0F B6 C9 F6 44 31 1D 04 74 05 40 38 18 74 07 40 3B D3 75 E2 EB 01 48 5E 2B 45 08 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_274_0_0 {
	meta:
		name = "_wcslen"
		size = 22
	strings:
		$1 = { 8B 44 24 04 66 8B 08 40 40 66 85 C9 75 F6 2B 44 24 04 D1 F8 48 C3 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "_wcsstr"
		size = 95
	strings:
		$1 = { 8B 44 24 04 53 8B 5C 24 0C 66 83 3B 00 57 8B F8 74 46 0F B7 08 66 85 C9 74 3C 0F B7 D1 2B C3 66 85 D2 8B 4C 24 10 74 1C 0F B7 11 66 85 D2 74 2B 0F B7 1C 08 0F B7 D2 2B DA 75 09 41 41 66 83 3C 08 00 75 E4 66 83 39 00 74 11 47 47 0F B7 17 40 40 66 85 D2 75 C9 33 C0 5F 5B C3 8B C7 EB F9 }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "___time64_t_from_ft"
		size = 102
		refs = "001b __imp__FileTimeToLocalFileTime@8 002d __imp__FileTimeToSystemTime@8 0056 ___loctotime64_t"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 18 83 38 00 75 06 83 78 04 00 74 4B 8D 4D F8 51 50 FF 15 ?? ?? ?? ?? 85 C0 74 3C 8D 45 E8 50 8D 45 F8 50 FF 15 ?? ?? ?? ?? 85 C0 74 2A 0F B7 45 F4 6A FF 50 0F B7 45 F2 50 0F B7 45 F0 50 0F B7 45 EE 50 0F B7 45 EA 50 0F B7 45 E8 50 E8 ?? ?? ?? ?? 83 C4 1C C9 C3 83 CA FF 8B C2 C9 C3 }
	condition:
		$1
}

rule file_277_2_0 {
	meta:
		name = "__findfirst64i32"
		size = 304
		refs = "000a ___security_cookie 0022 __errno 0032 __invalid_parameter 0050 __imp__FindFirstFileA@8 005d __imp__GetLastError@0 00bf ___time64_t_from_ft 0107 _strcpy_s 0118 __invoke_watson 012a @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 8B 75 0C 57 33 FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 E1 00 00 00 3B C7 74 DC 53 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 8B D8 83 FB FF 75 45 FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 2A 83 F8 08 74 18 83 F8 12 74 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 83 C8 FF E9 97 00 00 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB EB E8 ?? ?? ?? ?? 89 30 EB E2 8B 85 BC FE FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C8 FE FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 D0 FE FF FF 50 89 56 14 E8 ?? ?? ?? ?? 89 46 18 8B 85 DC FE FF FF 89 46 20 8D 85 E8 FE FF FF 50 89 56 1C 68 04 01 00 00 83 C6 24 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C3 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_277_3_0 {
	meta:
		name = "__findnext64i32"
		size = 303
		refs = "000a ___security_cookie 0021 __errno 0033 __invalid_parameter 0059 __imp__FindNextFileA@8 0063 __imp__GetLastError@0 00bf ___time64_t_from_ft 0107 _strcpy_s 0118 __invoke_watson 0129 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 44 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 F8 FF 56 8B 75 0C 57 75 22 E8 ?? ?? ?? ?? 33 FF 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DF 00 00 00 33 FF 3B F7 75 07 E8 ?? ?? ?? ?? EB D8 8D 8D BC FE FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B0 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A3 E8 ?? ?? ?? ?? 89 30 EB 9A 8B 85 BC FE FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 BC FE FF FF 89 06 8D 85 C0 FE FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C8 FE FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 D0 FE FF FF 50 89 56 14 E8 ?? ?? ?? ?? 89 46 18 8B 85 DC FE FF FF 89 46 20 8D 85 E8 FE FF FF 50 89 56 1C 68 04 01 00 00 83 C6 24 56 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "_div"
		size = 26
		altNames = "_ldiv"
	strings:
		$1 = { 8B 44 24 04 99 F7 7C 24 08 83 7C 24 04 00 7D 09 85 D2 7E 05 40 2B 54 24 08 C3 }
	condition:
		$1
}

rule file_279_3_0 {
	meta:
		name = "__wassert"
		size = 2117
		refs = "000f ___security_cookie 003a __get_osplatform 0061 _wcstombs_s 007e __invoke_watson 008b ??_C@_03KHICJKCI@?4?4?4?$AA@ 009b _strcat_s 00a6 ??_C@_0CI@FDIHEIE@Expression?5cannot?5be?5displayed?5o@ 00b0 _strcpy_s 012e ??_C@_0CG@KNFFOMBO@Filename?5cannot?5be?5displayed?5on?5@ 016a __assert 0179 __set_error_mode 0195 ___app_type 01a1 ??_C@_1CE@OJBNHDMO@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?$CB?$AA?$AA@ 01b3 _wcscpy_s 01cd _dblnewline 01da _wcscat_s 01f3 ??_C@_1BE@PHKBBGE@?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$AA@ 022b __imp__GetModuleFileNameW@12 0234 ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 0261 _wcslen 0288 _dotdotdot 0298 _wcsncpy_s 02d4 _newline 02fa ??_C@_1O@HEMHKNDC@?$AAF?$AAi?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 03a1 _wcsncat_s 0545 ??_C@_1O@KCAFKHJE@?$AAL?$AAi?$AAn?$AAe?$AA?3?$AA?5?$AA?$AA@ 059a __itow_s 05da ??_C@_1BK@PEDCIPMA@?$AAE?$AAx?$AAp?$AAr?$AAe?$AAs?$AAs?$AAi?$AAo?$AAn?$AA?3?$AA?5?$AA?$AA@ 06ae ??_C@_1OA@EGMLFBHJ@?$AAF?$AAo?$AAr?$AA?5?$AAi?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAo?$AAn?$AA?5?$AAh?$AAo?$AAw?$AA?5?$AAy?$AAo?$AAu?$AAr?$AA?5?$AAp?$AAr?$AAo?$AAg@ 06fb ??_C@_1HK@POCJMFGK@?$AA?$CI?$AAP?$AAr?$AAe?$AAs?$AAs?$AA?5?$AAR?$AAe?$AAt?$AAr?$AAy?$AA?5?$AAt?$AAo?$AA?5?$AAd?$AAe?$AAb?$AAu?$AAg?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAa?$AAp?$AAp?$AAl?$AAi?$AAc@ 072c ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 0732 ___crtMessageBoxW 0741 _raise 0749 __exit 076a __imp__GetStdHandle@4 0775 __assertstring 0797 _swprintf 07a7 __imp__GetFileType@4 07cf __imp__WriteConsoleW@20 07d8 _abort 07dd ___iob_func 07f7 _setvbuf 0813 _fwprintf 0821 _fflush 0839 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 10 FA FF FF 81 EC 6C 06 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 EC 05 00 00 8B 85 FC 05 00 00 53 56 89 45 94 57 8B BD F8 05 00 00 8D 45 88 33 DB 50 89 7D 8C 89 5D 88 E8 ?? ?? ?? ?? 83 7D 88 01 59 0F 85 2D 01 00 00 3B FB BE 1C 02 00 00 74 78 66 39 1F 74 73 6A FF 57 56 8D 45 98 50 53 E8 ?? ?? ?? ?? 8B F8 83 C4 14 3B FB 74 17 83 FF 16 74 05 83 FF 22 75 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 FF 50 75 17 68 ?? ?? ?? ?? 8D 45 98 56 50 88 9D B0 01 00 00 E8 ?? ?? ?? ?? EB 13 3B FB 74 28 68 ?? ?? ?? ?? 8D 45 98 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 12 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 03 88 5D 98 8B 45 94 3B C3 74 7E 66 39 18 74 79 6A FF 50 56 8D 85 D0 03 00 00 50 53 E8 ?? ?? ?? ?? 8B F8 83 C4 14 3B FB 74 17 83 FF 16 74 05 83 FF 22 75 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 FF 50 75 1A 68 ?? ?? ?? ?? 8D 85 D0 03 00 00 56 50 88 9D E8 05 00 00 E8 ?? ?? ?? ?? EB 13 3B FB 74 2B 68 ?? ?? ?? ?? 8D 45 98 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 15 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 06 88 9D D0 03 00 00 FF B5 00 06 00 00 8D 85 D0 03 00 00 50 8D 45 98 50 E8 ?? ?? ?? ?? 83 C4 0C E9 B7 06 00 00 6A 03 E8 ?? ?? ?? ?? 83 F8 01 59 0F 84 DF 05 00 00 6A 03 E8 ?? ?? ?? ?? 85 C0 59 75 0D 83 3D ?? ?? ?? ?? 01 0F 84 C6 05 00 00 68 ?? ?? ?? ?? BE 1C 02 00 00 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 04 01 00 00 8D 45 A8 50 53 66 89 9D B0 01 00 00 FF 15 ?? ?? ?? ?? 85 C0 75 27 68 ?? ?? ?? ?? 8D 45 A8 68 05 01 00 00 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 7D A8 8B C7 50 E8 ?? ?? ?? ?? 83 C0 0B 83 F8 3C 59 76 42 8B C7 50 E8 ?? ?? ?? ?? 8D BC 45 46 FF FF FF 8D 4D A8 8B C7 2B C1 6A 03 FF 35 ?? ?? ?? ?? D1 F8 B9 05 01 00 00 2B C8 51 57 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 57 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 75 94 E8 ?? ?? ?? ?? 83 C0 08 83 F8 3C 59 FF 75 94 0F 86 C5 01 00 00 E8 ?? ?? ?? ?? 8B F8 8B 45 94 0F B7 44 78 FE 66 3D 5C 00 59 C7 45 90 01 00 00 00 74 26 0F B7 C8 8B 45 94 8D 44 78 FE 66 83 F9 2F 74 16 39 7D 90 73 11 FF 45 90 48 48 0F B7 10 66 83 FA 5C 0F B7 CA 75 E4 8B C7 2B 45 90 83 F8 23 89 45 84 76 67 83 7D 90 11 73 5E 8B 7D 94 6A 31 58 2B 45 90 50 57 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B 45 84 8D 04 47 E9 10 01 00 00 83 F8 23 73 63 D1 6D 90 6A 31 58 2B 45 90 50 FF 75 94 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 2B 7D 90 8B 45 94 8D 04 78 E9 A8 00 00 00 6A 20 FF 75 94 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B 4D 84 8B 45 94 6A 07 8D 04 48 50 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B 45 94 8D 44 78 F2 50 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 85 B4 01 00 00 6A 0A 50 E8 ?? ?? ?? ?? 59 8B CE 2B C8 51 8D 85 B4 01 00 00 50 E8 ?? ?? ?? ?? 59 8D 84 45 B4 01 00 00 50 FF B5 00 06 00 00 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 75 8C E8 ?? ?? ?? ?? 8B F8 8D 85 B4 01 00 00 50 E8 ?? ?? ?? ?? 8D 84 07 B0 00 00 00 59 3B C6 59 8D 85 B4 01 00 00 76 40 50 E8 ?? ?? ?? ?? B9 69 01 00 00 2B C8 51 FF 75 8C 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 EB 03 FF 75 8C 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 35 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 8D 85 B4 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 12 20 01 00 8D 85 B4 01 00 00 68 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 03 75 0F 6A 16 E8 ?? ?? ?? ?? 59 6A 03 E8 ?? ?? ?? ?? 83 F8 04 75 06 CC E9 D5 00 00 00 83 F8 05 0F 85 C7 00 00 00 E9 C7 00 00 00 6A F4 FF 15 ?? ?? ?? ?? 83 F8 FF 89 45 8C BE ?? ?? ?? ?? 74 61 3B C3 74 5D FF B5 00 06 00 00 8D 85 B4 01 00 00 FF 75 94 57 56 68 1C 02 00 00 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 7C 3A FF 75 8C FF 15 ?? ?? ?? ?? 83 F8 02 75 2C 53 8D 45 84 50 8D 85 B4 01 00 00 50 E8 ?? ?? ?? ?? 59 50 8D 85 B4 01 00 00 50 FF 75 8C FF 15 ?? ?? ?? ?? 85 C0 74 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 66 F7 40 4C 0C 01 75 15 53 6A 04 53 E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 10 FF B5 00 06 00 00 FF 75 94 57 56 E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C0 40 50 E8 ?? ?? ?? ?? 83 C4 18 E8 ?? ?? ?? ?? 8B 8D EC 05 00 00 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 81 C5 F0 05 00 00 C9 C3 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "_IsRootUNCName"
		size = 159
		refs = "0002 _wcslen"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 83 F8 05 59 0F 82 8C 00 00 00 0F B7 06 66 3D 5C 00 74 06 66 3D 2F 00 75 7D 0F B7 46 02 66 3D 5C 00 74 06 66 3D 2F 00 75 6D 0F B7 46 04 66 3D 5C 00 74 63 66 3D 2F 00 74 5D 8D 46 06 0F B7 08 33 D2 66 3B CA 74 50 66 83 F9 5C 74 10 66 83 F9 2F 74 0A 40 40 0F B7 08 66 3B CA 75 EA 66 39 10 74 35 83 C0 02 66 39 10 74 2D 0F B7 08 66 3B CA 74 21 66 83 F9 5C 74 10 66 83 F9 2F 74 0A 40 40 0F B7 08 66 3B CA 75 EA 66 39 10 74 06 66 39 50 02 75 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_280_2_0 {
	meta:
		name = "__wstat64"
		size = 880
		refs = "000f ___security_cookie 0034 ___doserrno 003b __errno 004b __invalid_parameter 005c ??_C@_15HEJOKEHO@?$AA?$DP?$AA?$CK?$AA?$AA@ 0062 _wcspbrk 0099 _towlower 00a7 __getdrive 00b5 __imp__FindFirstFileW@8 00c6 ??_C@_17BAAFHAL@?$AA?4?$AA?1?$AA?2?$AA?$AA@ 00e7 __wfullpath 0116 _wcslen 0121 _IsRootUNCName 012c __imp__GetDriveTypeW@4 013e _free 0163 ___loctotime64_t 01b9 __imp__FileTimeToLocalFileTime@8 01cf __imp__FileTimeToSystemTime@8 02f2 __imp__FindClose@4 02fb ___wdtoxmode 0313 __allmul 0341 __imp__GetLastError@0 0347 __dosmaperr 0364 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 04 FC FF FF 81 EC 7C 04 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 F8 03 00 00 53 56 8B B5 04 04 00 00 33 DB 3B F3 57 8B BD 08 04 00 00 89 75 88 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 FE 02 00 00 3B FB 74 D8 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 74 16 E8 ?? ?? ?? ?? 6A 02 5E 89 30 E8 ?? ?? ?? ?? 89 30 E9 D3 02 00 00 66 83 7E 02 3A 75 1D 0F B7 06 66 3B C3 74 06 66 39 5E 04 74 D5 50 E8 ?? ?? ?? ?? 0F B7 C0 59 83 E8 60 EB 05 E8 ?? ?? ?? ?? 89 45 80 8D 45 A0 50 56 FF 15 ?? ?? ?? ?? 83 F8 FF 89 45 9C 0F 85 D8 00 00 00 68 ?? ?? ?? ?? 56 89 5D 9C E8 ?? ?? ?? ?? 85 C0 59 59 74 93 68 04 01 00 00 8D 85 F0 01 00 00 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 75 1C E8 ?? ?? ?? ?? 83 38 22 0F 85 6C FF FF FF 53 56 53 E8 ?? ?? ?? ?? 83 C4 0C 89 45 9C 8B F0 3B F3 74 72 56 E8 ?? ?? ?? ?? 83 F8 03 59 74 09 E8 ?? ?? ?? ?? 85 C0 74 5D 56 FF 15 ?? ?? ?? ?? 83 F8 01 76 51 39 5D 9C 74 09 FF 75 9C E8 ?? ?? ?? ?? 59 6A FF 53 53 53 6A 01 6A 01 68 BC 07 00 00 C7 45 A0 10 00 00 00 89 5D BC 89 5D C0 66 89 5D CC E8 ?? ?? ?? ?? 8B 75 88 8B CA 83 C4 1C 89 47 28 89 57 2C 89 47 20 89 4F 24 89 47 30 89 4F 34 E9 70 01 00 00 39 5D 9C 0F 84 DD FE FF FF FF 75 9C E8 ?? ?? ?? ?? 59 E9 CF FE FF FF 39 5D B4 75 0D 39 5D B8 75 08 89 5F 28 89 5F 2C EB 5A 8D 45 84 50 8D 45 B4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 7A 01 00 00 8D 45 8C 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 64 01 00 00 0F B7 45 98 6A FF 50 0F B7 45 96 50 0F B7 45 94 50 0F B7 45 92 50 0F B7 45 8E 50 0F B7 45 8C 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 28 89 57 2C 39 5D AC 75 13 39 5D B0 75 0E 8B 47 28 89 47 20 8B 47 2C 89 47 24 EB 5A 8D 45 84 50 8D 45 AC 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 08 01 00 00 8D 45 8C 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 F2 00 00 00 0F B7 45 98 6A FF 50 0F B7 45 96 50 0F B7 45 94 50 0F B7 45 92 50 0F B7 45 8E 50 0F B7 45 8C 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 20 89 57 24 39 5D A4 75 13 39 5D A8 75 0E 8B 47 28 89 47 30 8B 47 2C 89 47 34 EB 5A 8D 45 84 50 8D 45 A4 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 96 00 00 00 8D 45 8C 50 8D 45 84 50 FF 15 ?? ?? ?? ?? 85 C0 0F 84 80 00 00 00 0F B7 45 98 6A FF 50 0F B7 45 96 50 0F B7 45 94 50 0F B7 45 92 50 0F B7 45 8E 50 0F B7 45 8C 50 E8 ?? ?? ?? ?? 83 C4 1C 89 47 30 89 57 34 FF 75 9C FF 15 ?? ?? ?? ?? 56 FF 75 A0 E8 ?? ?? ?? ?? 59 59 6A 01 53 53 FF 75 BC 66 89 47 06 66 C7 47 08 01 00 E8 ?? ?? ?? ?? 8B 4D C0 33 F6 03 C1 89 47 18 8B 45 80 13 D6 48 89 07 89 47 10 89 57 1C 66 89 5F 04 66 89 5F 0C 66 89 5F 0A 33 C0 EB 19 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 FF 75 9C FF 15 ?? ?? ?? ?? 83 C8 FF 8B 8D F8 03 00 00 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 81 C5 FC 03 00 00 C9 C3 }
	condition:
		$1
}

rule file_282_0_0 {
	meta:
		name = "_memcpy_s"
		size = 123
		refs = "0018 __errno 0027 __invalid_parameter 0044 _memcpy 0055 _memset"
	strings:
		$1 = { 55 8B EC 56 8B 75 14 57 33 FF 3B F7 75 04 33 C0 EB 65 39 7D 08 75 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 45 39 7D 10 74 16 39 75 0C 72 11 56 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB C1 FF 75 0C 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 39 7D 10 74 B6 39 75 0C 73 0E E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB AD 6A 16 58 5F 5E 5D C3 }
	condition:
		$1
}

rule file_283_0_0 {
	meta:
		name = "_memset"
		size = 122
		refs = "0020 ___sse2_available 0028 __VEC_memzero"
	strings:
		$1 = { 8B 54 24 0C 8B 4C 24 04 85 D2 74 69 33 C0 8A 44 24 08 84 C0 75 16 81 FA 00 01 00 00 72 0E 83 3D ?? ?? ?? ?? 00 74 05 E9 ?? ?? ?? ?? 57 8B F9 83 FA 04 72 31 F7 D9 83 E1 03 74 0C 2B D1 88 07 83 C7 01 83 E9 01 75 F6 8B C8 C1 E0 08 03 C1 8B C8 C1 E0 10 03 C1 8B CA 83 E2 03 C1 E9 02 74 06 F3 AB 85 D2 74 0A 88 07 83 C7 01 83 EA 01 75 F6 8B 44 24 08 5F C3 8B 44 24 04 C3 }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "__mtinitlocks"
		size = 73
		refs = "0005 _lclcritsects 000c __locktable 0027 ___crtInitCritSecAndSpinCount"
	strings:
		$1 = { 56 57 33 F6 BF ?? ?? ?? ?? 83 3C F5 ?? ?? ?? ?? 01 75 1E 8D 04 F5 ?? ?? ?? ?? 89 38 68 A0 0F 00 00 FF 30 83 C7 18 E8 ?? ?? ?? ?? 85 C0 59 59 74 0C 46 83 FE 24 7C D2 33 C0 40 5F 5E C3 83 24 F5 ?? ?? ?? ?? 00 33 C0 EB F1 }
	condition:
		$1
}

rule file_284_1_0 {
	meta:
		name = "__mtdeletelocks"
		size = 85
		refs = "0003 __imp__DeleteCriticalSection@4 0009 __locktable 001f _free"
	strings:
		$1 = { 53 8B 1D ?? ?? ?? ?? 56 BE ?? ?? ?? ?? 57 8B 3E 85 FF 74 13 83 7E 04 01 74 0D 57 FF D3 57 E8 ?? ?? ?? ?? 83 26 00 59 83 C6 08 81 FE ?? ?? ?? ?? 7C DC BE ?? ?? ?? ?? 5F 8B 06 85 C0 74 09 83 7E 04 01 75 03 50 FF D3 83 C6 08 81 FE ?? ?? ?? ?? 7C E6 5E 5B C3 }
	condition:
		$1
}

rule file_284_2_0 {
	meta:
		name = "__unlock"
		size = 21
		refs = "0009 __locktable 000f __imp__LeaveCriticalSection@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 FF 34 C5 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_284_3_0 {
	meta:
		name = "__lockerr_exit"
		size = 24
		refs = "0008 __imp__FatalAppExitA@8 0012 ___crtExitProcess"
	strings:
		$1 = { FF 74 24 04 6A 00 FF 15 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_284_4_0 {
	meta:
		name = "__mtinitlocknum"
		size = 195
		refs = "0003 __sehtable$__mtinitlocknum 0008 __SEH_prolog4 0016 __crtheap 001d __FF_MSGBANNER 0024 __NMSG_WRITE 002e ___crtExitProcess 003a __locktable 0049 __malloc_crt 0055 __errno 0066 __lock 0079 ___crtInitCritSecAndSpinCount 0085 _free 00b5 __SEH_epilog4 00bd __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 47 89 7D E4 33 DB 39 1D ?? ?? ?? ?? 75 18 E8 ?? ?? ?? ?? 6A 1E E8 ?? ?? ?? ?? 68 FF 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 75 08 8D 34 F5 ?? ?? ?? ?? 39 1E 74 04 8B C7 EB 6E 6A 18 E8 ?? ?? ?? ?? 59 8B F8 3B FB 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 51 6A 0A E8 ?? ?? ?? ?? 59 89 5D FC 39 1E 75 2C 68 A0 0F 00 00 57 E8 ?? ?? ?? ?? 59 59 85 C0 75 17 57 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 89 5D E4 EB 0B 89 3E EB 07 57 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 0A E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_284_5_0 {
	meta:
		name = "__lock"
		size = 49
		refs = "000a __locktable 0015 __mtinitlocknum 0021 __amsg_exit 002a __imp__EnterCriticalSection@4"
	strings:
		$1 = { 55 8B EC 8B 45 08 56 8D 34 C5 ?? ?? ?? ?? 83 3E 00 75 13 50 E8 ?? ?? ?? ?? 85 C0 59 75 08 6A 11 E8 ?? ?? ?? ?? 59 FF 36 FF 15 ?? ?? ?? ?? 5E 5D C3 }
	condition:
		$1
}

rule file_285_1_0 {
	meta:
		name = "___crtMessageBoxW"
		size = 414
		refs = "000a __encoded_null 0012 ?pfnMessageBox@?1??__crtMessageBoxW@@9@9 0029 ??_C@_1BG@GOEBHBDC@?$AAU?$AAS?$AAE?$AAR?$AA3?$AA2?$AA?4?$AAD?$AAL?$AAL?$AA?$AA@ 002f __imp__LoadLibraryW@4 0042 __imp__GetProcAddress@8 0047 ??_C@_0M@DLDCCGNP@MessageBoxW?$AA@ 0054 __encode_pointer 005b ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 0070 ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 0076 ?pfnGetActiveWindow@?1??__crtMessageBoxW@@9@9 0083 ?pfnGetLastActivePopup@?1??__crtMessageBoxW@@9@9 008c __get_osplatform 009c __invoke_watson 00aa ??_C@_0BK@DEKFELLI@GetUserObjectInformationW?$AA@ 00bb ?pfnGetUserObjectInformation@?1??__crtMessageBoxW@@9@9 00c2 ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 00d1 ?pfnGetProcessWindowStation@?1??__crtMessageBoxW@@9@9 00eb __decode_pointer 0120 __get_winmajor"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 57 E8 ?? ?? ?? ?? 33 DB 39 1D ?? ?? ?? ?? 89 45 F0 89 5D FC 89 5D F8 89 5D F4 0F 85 AD 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 3B FB 75 07 33 C0 E9 59 01 00 00 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D6 3B C3 74 E7 50 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 50 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 7D F8 02 75 2C 68 ?? ?? ?? ?? 57 FF D6 50 E8 ?? ?? ?? ?? 3B C3 59 A3 ?? ?? ?? ?? 74 14 68 ?? ?? ?? ?? 57 FF D6 50 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 75 F0 3B C6 74 6D 39 35 ?? ?? ?? ?? 74 65 50 E8 ?? ?? ?? ?? 59 FF D0 3B C3 74 25 8D 4D EC 51 6A 0C 8D 4D E0 51 6A 01 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 85 C0 74 06 F6 45 E8 01 75 33 8D 45 F4 50 E8 ?? ?? ?? ?? 85 C0 59 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 7D F4 04 72 09 81 4D 10 00 00 20 00 EB 3A 81 4D 10 00 00 04 00 EB 31 A1 ?? ?? ?? ?? 3B C6 74 28 50 E8 ?? ?? ?? ?? 59 FF D0 3B C3 89 45 FC 74 18 A1 ?? ?? ?? ?? 3B C6 74 0F FF 75 FC 50 E8 ?? ?? ?? ?? 59 FF D0 89 45 FC FF 75 10 FF 75 0C FF 75 08 FF 75 FC FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_364_1_0 {
	meta:
		name = "___crtMessageBoxA"
		size = 414
		refs = "000a __encoded_null 0012 ?pfnMessageBox@?1??__crtMessageBoxA@@9@9 0029 ??_C@_0L@NDEGIDAG@USER32?4DLL?$AA@ 002f __imp__LoadLibraryA@4 0042 __imp__GetProcAddress@8 0047 ??_C@_0M@CHKKJDAI@MessageBoxA?$AA@ 0054 __encode_pointer 005b ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 0070 ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 0076 ?pfnGetActiveWindow@?1??__crtMessageBoxA@@9@9 0083 ?pfnGetLastActivePopup@?1??__crtMessageBoxA@@9@9 008c __get_osplatform 009c __invoke_watson 00aa ??_C@_0BK@CIDNPOGP@GetUserObjectInformationA?$AA@ 00bb ?pfnGetUserObjectInformation@?1??__crtMessageBoxA@@9@9 00c2 ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 00d1 ?pfnGetProcessWindowStation@?1??__crtMessageBoxA@@9@9 00eb __decode_pointer 0120 __get_winmajor"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 56 57 E8 ?? ?? ?? ?? 33 DB 39 1D ?? ?? ?? ?? 89 45 F0 89 5D FC 89 5D F8 89 5D F4 0F 85 AD 00 00 00 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 3B FB 75 07 33 C0 E9 59 01 00 00 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D6 3B C3 74 E7 50 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 50 E8 ?? ?? ?? ?? C7 04 24 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 50 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? 8D 45 F8 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 7D F8 02 75 2C 68 ?? ?? ?? ?? 57 FF D6 50 E8 ?? ?? ?? ?? 3B C3 59 A3 ?? ?? ?? ?? 74 14 68 ?? ?? ?? ?? 57 FF D6 50 E8 ?? ?? ?? ?? 59 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 8B 75 F0 3B C6 74 6D 39 35 ?? ?? ?? ?? 74 65 50 E8 ?? ?? ?? ?? 59 FF D0 3B C3 74 25 8D 4D EC 51 6A 0C 8D 4D E0 51 6A 01 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 85 C0 74 06 F6 45 E8 01 75 33 8D 45 F4 50 E8 ?? ?? ?? ?? 85 C0 59 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 7D F4 04 72 09 81 4D 10 00 00 20 00 EB 3A 81 4D 10 00 00 04 00 EB 31 A1 ?? ?? ?? ?? 3B C6 74 28 50 E8 ?? ?? ?? ?? 59 FF D0 3B C3 89 45 FC 74 18 A1 ?? ?? ?? ?? 3B C6 74 0F FF 75 FC 50 E8 ?? ?? ?? ?? 59 FF D0 89 45 FC FF 75 10 FF 75 0C FF 75 08 FF 75 FC FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_286_0_0 {
	meta:
		name = "_CallDestructExceptionObject"
		size = 52
		refs = "000f __pDestructExceptionObject 001c __IsNonwritableInCurrentImage"
	strings:
		$1 = { 56 8B 74 24 08 81 3E 63 73 6D E0 75 25 83 3D ?? ?? ?? ?? 00 74 1C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 0D FF 74 24 0C 56 FF 15 ?? ?? ?? ?? 59 59 5E C3 }
	condition:
		$1
}

rule file_288_1_0 {
	meta:
		name = "__wfindfirst64"
		size = 323
		refs = "000f ___security_cookie 0030 __errno 0040 __invalid_parameter 005a __imp__FindFirstFileW@8 0068 __imp__GetLastError@0 00bc ___time64_t_from_ft 00ef __allmul 0110 _wcscpy_s 0122 __invoke_watson 0137 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 28 FE FF FF 81 EC 58 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 D4 01 00 00 8B 85 E0 01 00 00 56 8B B5 E4 01 00 00 57 33 FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 DD 00 00 00 3B C7 74 DC 8D 4D 84 51 50 FF 15 ?? ?? ?? ?? 83 F8 FF 89 45 80 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B8 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB AB E8 ?? ?? ?? ?? 89 30 EB A2 8B 45 84 2D 80 00 00 00 F7 D8 1B C0 23 45 84 53 89 06 8D 45 88 50 E8 ?? ?? ?? ?? 89 46 08 8D 45 90 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 45 98 50 89 56 14 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF 75 A0 89 46 18 89 56 1C E8 ?? ?? ?? ?? 8B 4D A4 33 DB 03 C1 89 46 20 13 D3 8D 45 B0 50 89 56 24 68 04 01 00 00 83 C6 28 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 5B 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 45 80 8B 8D D4 01 00 00 5F 33 CD 5E E8 ?? ?? ?? ?? 81 C5 D8 01 00 00 C9 C3 }
	condition:
		$1
}

rule file_288_2_0 {
	meta:
		name = "__wfindnext64"
		size = 333
		refs = "000a ___security_cookie 0024 __errno 0036 __invalid_parameter 005b __imp__FindNextFileW@8 0065 __imp__GetLastError@0 00c1 ___time64_t_from_ft 00fd __allmul 0124 _wcscpy_s 0135 __invoke_watson 0147 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 8B 75 0C 83 CB FF 3B C3 57 75 21 E8 ?? ?? ?? ?? 33 FF 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 8B C3 E9 FA 00 00 00 33 FF 3B F7 75 07 E8 ?? ?? ?? ?? EB D9 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B1 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A4 E8 ?? ?? ?? ?? 89 30 EB 9B 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 B8 FD FF FF 50 89 56 0C E8 ?? ?? ?? ?? 89 46 10 8D 85 C0 FD FF FF 50 89 56 14 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF B5 C8 FD FF FF 89 46 18 89 56 1C E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 DB 03 C1 89 46 20 13 D3 8D 85 D8 FD FF FF 50 89 56 24 68 04 01 00 00 83 C6 28 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_290_0_0 {
	meta:
		name = "__encode_pointer"
		size = 99
		refs = "0003 ___getvalueindex 0009 __imp__TlsGetValue@4 0014 ___flsindex 0035 ??_C@_0N@NHGLKGEC@KERNEL32?4DLL?$AA@ 003b __imp__GetModuleHandleA@4 0044 ??_C@_0O@NLDKAIKN@EncodePointer?$AA@ 004b __imp__GetProcAddress@8"
	strings:
		$1 = { 56 FF 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? FF D6 85 C0 74 21 A1 ?? ?? ?? ?? 83 F8 FF 74 17 50 FF 35 ?? ?? ?? ?? FF D6 FF D0 85 C0 74 08 8B 80 F8 01 00 00 EB 1B 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 1A 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 0A FF 74 24 08 FF D0 89 44 24 08 8B 44 24 08 5E C3 }
	condition:
		$1
}

rule file_290_2_0 {
	meta:
		name = "__decode_pointer"
		size = 99
		refs = "0003 ___getvalueindex 0009 __imp__TlsGetValue@4 0014 ___flsindex 0035 ??_C@_0N@NHGLKGEC@KERNEL32?4DLL?$AA@ 003b __imp__GetModuleHandleA@4 0044 ??_C@_0O@KBPMFGHI@DecodePointer?$AA@ 004b __imp__GetProcAddress@8"
	strings:
		$1 = { 56 FF 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? FF D6 85 C0 74 21 A1 ?? ?? ?? ?? 83 F8 FF 74 17 50 FF 35 ?? ?? ?? ?? FF D6 FF D0 85 C0 74 08 8B 80 FC 01 00 00 EB 1B 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 1A 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 0A FF 74 24 08 FF D0 89 44 24 08 8B 44 24 08 5E C3 }
	condition:
		$1
}

rule file_290_4_0 {
	meta:
		name = "___fls_getvalue@4"
		size = 21
		refs = "0006 ___getvalueindex 000c __imp__TlsGetValue@4"
	strings:
		$1 = { FF 74 24 04 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 C2 04 00 }
	condition:
		$1
}

rule file_290_6_0 {
	meta:
		name = "___set_flsgetvalue"
		size = 42
		refs = "0002 ___getvalueindex 0008 __imp__TlsGetValue@4 0012 _gpFlsGetValue 0017 __decode_pointer 0025 __imp__TlsSetValue@8"
	strings:
		$1 = { FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 19 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_290_7_0 {
	meta:
		name = "___fls_setvalue@8"
		size = 25
		refs = "000a _gpFlsSetValue 000f __decode_pointer"
	strings:
		$1 = { FF 74 24 08 FF 74 24 08 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 C2 08 00 }
	condition:
		$1
}

rule file_290_8_0 {
	meta:
		name = "__mtterm"
		size = 61
		refs = "0001 ___flsindex 000d _gpFlsFree 0012 __decode_pointer 0021 ___getvalueindex 002d __imp__TlsFree@4 0039 __mtdeletelocks"
	strings:
		$1 = { A1 ?? ?? ?? ?? 83 F8 FF 74 16 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 83 0D ?? ?? ?? ?? FF A1 ?? ?? ?? ?? 83 F8 FF 74 0E 50 FF 15 ?? ?? ?? ?? 83 0D ?? ?? ?? ?? FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_290_9_0 {
	meta:
		name = "__initptd"
		size = 180
		refs = "0003 __sehtable$__initptd 0008 __SEH_prolog4 000d ??_C@_0N@NHGLKGEC@KERNEL32?4DLL?$AA@ 0013 __imp__GetModuleHandleA@4 0020 __XcptActTab 002f ??_C@_0O@NLDKAIKN@EncodePointer?$AA@ 0036 __imp__GetProcAddress@8 0043 ??_C@_0O@KBPMFGHI@DecodePointer?$AA@ 0064 ___initialmbcinfo 006e __imp__InterlockedIncrement@4 0075 __lock 0089 ___ptlocinfo 0094 ___addlocaleref 00a6 __SEH_epilog4 00ae __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 45 E4 8B 75 08 C7 46 5C ?? ?? ?? ?? 33 FF 47 89 7E 14 85 C0 74 24 68 ?? ?? ?? ?? 50 8B 1D ?? ?? ?? ?? FF D3 89 86 F8 01 00 00 68 ?? ?? ?? ?? FF 75 E4 FF D3 89 86 FC 01 00 00 89 7E 70 C6 86 C8 00 00 00 43 C6 86 4B 01 00 00 43 B8 ?? ?? ?? ?? 89 46 68 50 FF 15 ?? ?? ?? ?? 6A 0C E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 45 0C 89 46 6C 85 C0 75 08 A1 ?? ?? ?? ?? 89 46 6C FF 76 6C E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 06 00 00 00 E8 ?? ?? ?? ?? C3 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_290_10_0 {
	meta:
		name = "__getptd_noexit"
		size = 131
		refs = "0004 __imp__GetLastError@0 000b ___set_flsgetvalue 0011 ___flsindex 0017 ___getvalueindex 001d __imp__TlsGetValue@4 0031 __calloc_crt 0046 _gpFlsSetValue 004b __decode_pointer 005a __initptd 0062 __imp__GetCurrentThreadId@0 0070 _free 007a __imp__SetLastError@4"
	strings:
		$1 = { 56 57 FF 15 ?? ?? ?? ?? 8B F8 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? FF D0 8B F0 85 F6 75 4E 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 74 3A 56 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 85 C0 74 18 6A 00 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 83 4E 04 FF 89 06 EB 09 56 E8 ?? ?? ?? ?? 59 33 F6 57 FF 15 ?? ?? ?? ?? 5F 8B C6 5E C3 }
	condition:
		$1
}

rule file_290_11_0 {
	meta:
		name = "__getptd"
		size = 24
		refs = "0002 __getptd_noexit 000f __amsg_exit"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 08 6A 10 E8 ?? ?? ?? ?? 59 8B C6 5E C3 }
	condition:
		$1
}

rule file_290_12_0 {
	meta:
		name = "__freefls@4"
		size = 289
		refs = "0003 __sehtable$__freefls@4 0008 __SEH_prolog4 0020 _free 006f __XcptActTab 007f __lock 0092 __imp__InterlockedDecrement@4 009c ___initialmbcinfo 00cd ___removelocaleref 00d4 ___ptlocinfo 00dc ___initiallocinfo 00e9 ___freetlocinfo 0102 __SEH_epilog4 010f __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 0F 84 EA 00 00 00 8B 46 24 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 2C 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 34 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 3C 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 44 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 48 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 8B 46 5C 3D ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 6A 0D E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 7E 68 85 FF 74 1A 57 FF 15 ?? ?? ?? ?? 85 C0 75 0F 81 FF ?? ?? ?? ?? 74 07 57 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 57 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 8B 7E 6C 85 FF 74 23 57 E8 ?? ?? ?? ?? 59 3B 3D ?? ?? ?? ?? 74 14 81 FF ?? ?? ?? ?? 74 0C 83 3F 00 75 07 57 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 1E 00 00 00 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C2 04 00 8B 75 08 6A 0D E8 ?? ?? ?? ?? 59 C3 8B 75 08 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_290_13_0 {
	meta:
		name = "__freeptd"
		size = 105
		refs = "0002 ___flsindex 0015 ___getvalueindex 001b __imp__TlsGetValue@4 0042 _gpFlsSetValue 0047 __decode_pointer 0050 __freefls@4 0064 __imp__TlsSetValue@8"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? FF 74 4C 57 8B 7C 24 08 85 FF 75 26 56 FF 35 ?? ?? ?? ?? 8B 35 ?? ?? ?? ?? FF D6 85 C0 74 12 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? FF D6 FF D0 8B F8 5E 6A 00 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 57 E8 ?? ?? ?? ?? 5F A1 ?? ?? ?? ?? 83 F8 FF 74 09 6A 00 50 FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_290_16_0 {
	meta:
		name = "__mtinit"
		size = 388
		refs = "0002 ??_C@_0N@NHGLKGEC@KERNEL32?4DLL?$AA@ 0008 __imp__GetModuleHandleA@4 0013 __mtterm 001e __imp__GetProcAddress@8 0023 ??_C@_08KNHFBNJ@FlsAlloc?$AA@ 002b ??_C@_0M@GDNOONDI@FlsGetValue?$AA@ 0031 _gpFlsAlloc 0038 ??_C@_0M@JCPCPOEF@FlsSetValue?$AA@ 003e _gpFlsGetValue 0045 ??_C@_07PEJMOBNF@FlsFree?$AA@ 004b _gpFlsSetValue 005a __imp__TlsSetValue@8 005f _gpFlsFree 007c __imp__TlsGetValue@4 0086 __imp__TlsFree@4 0090 ___crtTlsAlloc@4 00a1 __imp__TlsAlloc@0 00a9 ___getvalueindex 00c5 __init_pointers 00d0 __encode_pointer 010d __mtinitlocks 0116 __freefls@4 0121 __decode_pointer 012c ___flsindex 013a __calloc_crt 0163 __initptd 016b __imp__GetCurrentThreadId@0"
	strings:
		$1 = { 57 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 8B F8 85 FF 75 09 E8 ?? ?? ?? ?? 33 C0 5F C3 56 8B 35 ?? ?? ?? ?? 68 ?? ?? ?? ?? 57 FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 68 ?? ?? ?? ?? 57 A3 ?? ?? ?? ?? FF D6 83 3D ?? ?? ?? ?? 00 8B 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 74 16 83 3D ?? ?? ?? ?? 00 74 0D 83 3D ?? ?? ?? ?? 00 74 04 85 C0 75 24 A1 ?? ?? ?? ?? A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? C7 05 ?? ?? ?? ?? ?? ?? ?? ?? 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 83 F8 FF A3 ?? ?? ?? ?? 0F 84 CC 00 00 00 FF 35 ?? ?? ?? ?? 50 FF D6 85 C0 0F 84 BB 00 00 00 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 65 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 83 F8 FF A3 ?? ?? ?? ?? 74 48 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 74 34 56 FF 35 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 85 C0 74 1B 6A 00 56 E8 ?? ?? ?? ?? 59 59 FF 15 ?? ?? ?? ?? 83 4E 04 FF 89 06 33 C0 40 EB 07 E8 ?? ?? ?? ?? 33 C0 5E 5F C3 }
	condition:
		$1
}

rule file_291_6_0 {
	meta:
		name = "?__crtLCMapStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDHPADHHH@Z"
		size = 930
		refs = "0007 ___security_cookie 0016 ?f_use@?1??__crtLCMapStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDHPADHHH@Z@4HA 0026 ??_C@_13NOLLCAOD@?$AA?$AA?$AA?$AA@ 0032 __imp__LCMapStringW@24 0044 __imp__GetLastError@0 00af __imp__MultiByteToWideChar@24 00f4 __alloca_probe_16 0108 _malloc 0218 __imp__WideCharToMultiByte@32 0221 __freea 025b ___ansicp 0286 ___convertcp 0296 __imp__LCMapStringA@24 0301 _memset 0376 _free 039c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 33 DB 39 1D ?? ?? ?? ?? 57 8B F1 75 38 53 53 33 FF 47 57 68 ?? ?? ?? ?? 68 00 01 00 00 53 FF 15 ?? ?? ?? ?? 85 C0 74 08 89 3D ?? ?? ?? ?? EB 15 FF 15 ?? ?? ?? ?? 83 F8 78 75 0A C7 05 ?? ?? ?? ?? 02 00 00 00 39 5D 14 7E 22 8B 4D 14 8B 45 10 49 38 18 74 08 40 3B CB 75 F6 83 C9 FF 8B 45 14 2B C1 48 3B 45 14 7D 01 40 89 45 14 A1 ?? ?? ?? ?? 83 F8 02 0F 84 AB 01 00 00 3B C3 0F 84 A3 01 00 00 83 F8 01 0F 85 CB 01 00 00 39 5D 20 89 5D F8 75 08 8B 06 8B 40 04 89 45 20 8B 35 ?? ?? ?? ?? 33 C0 39 5D 24 53 53 FF 75 14 0F 95 C0 FF 75 10 8D 04 C5 01 00 00 00 50 FF 75 20 FF D6 8B F8 3B FB 0F 84 8E 01 00 00 7E 43 6A E0 33 D2 58 F7 F7 83 F8 02 72 37 8D 44 3F 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 3B C3 59 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 F4 EB 03 89 5D F4 39 5D F4 0F 84 3D 01 00 00 57 FF 75 F4 FF 75 14 FF 75 10 6A 01 FF 75 20 FF D6 85 C0 0F 84 E2 00 00 00 8B 35 ?? ?? ?? ?? 53 53 57 FF 75 F4 FF 75 0C FF 75 08 FF D6 8B C8 3B CB 89 4D F8 0F 84 C1 00 00 00 66 F7 45 0C 00 04 74 29 39 5D 1C 0F 84 B0 00 00 00 3B 4D 1C 0F 8F A7 00 00 00 FF 75 1C FF 75 18 57 FF 75 F4 FF 75 0C FF 75 08 FF D6 E9 90 00 00 00 3B CB 7E 45 6A E0 33 D2 58 F7 F1 83 F8 02 72 39 8D 44 09 08 3D 00 04 00 00 77 16 E8 ?? ?? ?? ?? 8B F4 3B F3 74 6A C7 06 CC CC 00 00 83 C6 08 EB 1A 50 E8 ?? ?? ?? ?? 3B C3 59 74 09 C7 00 DD DD 00 00 83 C0 08 8B F0 EB 02 33 F6 3B F3 74 41 FF 75 F8 56 57 FF 75 F4 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 85 C0 74 22 39 5D 1C 53 53 75 04 53 53 EB 06 FF 75 1C FF 75 18 FF 75 F8 56 53 FF 75 20 FF 15 ?? ?? ?? ?? 89 45 F8 56 E8 ?? ?? ?? ?? 59 FF 75 F4 E8 ?? ?? ?? ?? 8B 45 F8 59 E9 59 01 00 00 39 5D 08 89 5D F4 89 5D F0 75 08 8B 06 8B 40 14 89 45 08 39 5D 20 75 08 8B 06 8B 40 04 89 45 20 FF 75 08 E8 ?? ?? ?? ?? 83 F8 FF 59 89 45 EC 75 07 33 C0 E9 21 01 00 00 3B 45 20 0F 84 DB 00 00 00 53 53 8D 4D 14 51 FF 75 10 50 FF 75 20 E8 ?? ?? ?? ?? 83 C4 18 3B C3 89 45 F4 74 D4 8B 35 ?? ?? ?? ?? 53 53 FF 75 14 50 FF 75 0C FF 75 08 FF D6 3B C3 89 45 F8 75 07 33 F6 E9 B7 00 00 00 7E 3D 83 F8 E0 77 38 83 C0 08 3D 00 04 00 00 77 16 E8 ?? ?? ?? ?? 8B FC 3B FB 74 DD C7 07 CC CC 00 00 83 C7 08 EB 1A 50 E8 ?? ?? ?? ?? 3B C3 59 74 09 C7 00 DD DD 00 00 83 C0 08 8B F8 EB 02 33 FF 3B FB 74 B4 FF 75 F8 53 57 E8 ?? ?? ?? ?? 83 C4 0C FF 75 F8 57 FF 75 14 FF 75 F4 FF 75 0C FF 75 08 FF D6 3B C3 89 45 F8 75 04 33 F6 EB 25 FF 75 1C 8D 45 F8 FF 75 18 50 57 FF 75 20 FF 75 EC E8 ?? ?? ?? ?? 8B F0 89 75 F0 83 C4 18 F7 DE 1B F6 23 75 F8 57 E8 ?? ?? ?? ?? 59 EB 1A FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 8B F0 39 5D F4 74 09 FF 75 F4 E8 ?? ?? ?? ?? 59 8B 45 F0 3B C3 74 0C 39 45 18 74 07 50 E8 ?? ?? ?? ?? 59 8B C6 8D 65 E0 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_291_7_0 {
	meta:
		name = "___crtLCMapStringA"
		size = 67
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002d ?__crtLCMapStringA_stat@@YAHPAUlocaleinfo_struct@@KKPBDHPADHHH@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 08 8D 4D F0 E8 ?? ?? ?? ?? FF 75 28 8D 4D F0 FF 75 24 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "__mkdir"
		size = 44
		refs = "0008 __imp__CreateDirectoryA@8 0012 __imp__GetLastError@0 0020 __dosmaperr"
	strings:
		$1 = { 6A 00 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_863_0_0 {
	meta:
		name = "__wmkdir"
		size = 44
		refs = "0008 __imp__CreateDirectoryW@8 0012 __imp__GetLastError@0 0020 __dosmaperr"
	strings:
		$1 = { 6A 00 FF 74 24 08 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 02 33 C0 85 C0 74 0B 50 E8 ?? ?? ?? ?? 59 83 C8 FF C3 33 C0 C3 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "_vscan_fn"
		size = 104
		refs = "0009 _strlen 0015 __errno 0025 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 20 57 56 E8 ?? ?? ?? ?? 33 FF 3B F7 59 75 1D E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 34 39 7D 0C 74 DE B9 FF FF FF 7F 3B C1 C7 45 EC 49 00 00 00 89 75 E8 89 75 E0 89 4D E4 77 03 89 45 E4 FF 75 14 8D 45 E0 FF 75 10 FF 75 0C 50 FF 55 08 83 C4 10 5F C9 C3 }
	condition:
		$1
}

rule file_293_1_0 {
	meta:
		name = "_sscanf"
		size = 31
		refs = "0011 __input_l 0016 _vscan_fn"
	strings:
		$1 = { 56 8B 74 24 08 8D 44 24 10 50 6A 00 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_293_3_0 {
	meta:
		name = "_sscanf_s"
		size = 31
		refs = "0011 __input_s_l 0016 _vscan_fn"
	strings:
		$1 = { 56 8B 74 24 08 8D 44 24 10 50 6A 00 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_354_1_0 {
	meta:
		name = "_swscanf"
		size = 31
		refs = "0011 __winput_l 0016 _vscan_fn"
	strings:
		$1 = { 56 8B 74 24 08 8D 44 24 10 50 6A 00 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_354_3_0 {
	meta:
		name = "_swscanf_s"
		size = 31
		refs = "0011 __winput_s_l 0016 _vscan_fn"
	strings:
		$1 = { 56 8B 74 24 08 8D 44 24 10 50 6A 00 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_293_2_0 {
	meta:
		name = "__sscanf_l"
		size = 33
		refs = "0013 __input_l 0018 _vscan_fn"
	strings:
		$1 = { 56 8B 74 24 08 8D 44 24 14 50 FF 74 24 14 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_293_4_0 {
	meta:
		name = "__sscanf_s_l"
		size = 33
		refs = "0013 __input_s_l 0018 _vscan_fn"
	strings:
		$1 = { 56 8B 74 24 08 8D 44 24 14 50 FF 74 24 14 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_354_2_0 {
	meta:
		name = "__swscanf_l"
		size = 33
		refs = "0013 __winput_l 0018 _vscan_fn"
	strings:
		$1 = { 56 8B 74 24 08 8D 44 24 14 50 FF 74 24 14 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_354_4_0 {
	meta:
		name = "__swscanf_s_l"
		size = 33
		refs = "0013 __winput_s_l 0018 _vscan_fn"
	strings:
		$1 = { 56 8B 74 24 08 8D 44 24 14 50 FF 74 24 14 FF 74 24 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__lsearch"
		size = 173
		refs = "000c __errno 001c __invalid_parameter 009d _memcpy"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 80 00 00 00 57 8B 7D 10 3B FE 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 5B 53 8B 5D 0C 3B DE 74 0A 39 75 14 76 05 39 75 18 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 2C 39 37 76 15 53 FF 75 08 FF 55 18 85 C0 59 59 74 19 03 5D 14 46 3B 37 72 EB FF 75 14 FF 75 08 53 E8 ?? ?? ?? ?? 83 C4 0C FF 07 8B C3 5B 5F 5E 5D C3 }
	condition:
		$1
}

rule file_295_0_0 {
	meta:
		name = "__difftime32"
		size = 42
		refs = "001c __errno"
	strings:
		$1 = { 55 8B EC 83 7D 0C 00 7C 12 8B 45 08 85 C0 7C 0B 2B 45 0C 89 45 0C DB 45 0C 5D C3 E8 ?? ?? ?? ?? D9 EE C7 00 16 00 00 00 5D C3 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "_rewind"
		size = 197
		refs = "0003 __sehtable$_rewind 0008 __SEH_prolog4 001d __errno 002d __invalid_parameter 0035 __SEH_epilog4 003f __fileno 0047 __lock_file 0052 __flush 0075 ___pioinfo 007c ___badioinfo 009a __lseek 00bf __unlock_file"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 C0 8B 75 08 33 DB 3B F3 0F 95 C0 3B C3 75 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? C3 89 75 08 56 E8 ?? ?? ?? ?? 8B F8 56 E8 ?? ?? ?? ?? 59 59 89 5D FC 56 E8 ?? ?? ?? ?? 59 83 66 0C CF 83 FF FF 74 1B 83 FF FE 74 16 8B CF C1 F9 05 8B C7 83 E0 1F 6B C0 28 03 04 8D ?? ?? ?? ?? EB 05 B8 ?? ?? ?? ?? 8A 48 04 80 E1 FD 88 48 04 8B 46 0C 84 C0 79 06 83 E0 FC 89 46 0C 53 53 57 E8 ?? ?? ?? ?? 83 C4 0C 83 F8 FF 75 04 83 4E 0C 20 C7 45 FC FE FF FF FF E8 05 00 00 00 E9 79 FF FF FF FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_297_0_0 {
	meta:
		name = "__cputs"
		size = 148
		refs = "0003 __sehtable$__cputs 0008 __SEH_prolog4 001e ___doserrno 0025 __errno 0035 __invalid_parameter 0044 __lock 0051 __confh 0058 ___initconout 006a __putch_nolock 0086 __SEH_epilog4 008e __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C0 39 5D 08 0F 95 C0 3B C3 75 24 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 44 6A 03 E8 ?? ?? ?? ?? 59 89 5D FC 6A FE 5E 39 35 ?? ?? ?? ?? 75 05 E8 ?? ?? ?? ?? 8B 45 08 8A 00 3A C3 74 15 0F BE C0 50 E8 ?? ?? ?? ?? 59 FF 45 08 83 F8 FF 75 E5 09 45 E4 89 75 FC E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 03 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "__setjmp3"
		size = 123
		refs = "0028 __except_list"
	strings:
		$1 = { 8B 54 24 04 89 2A 89 5A 04 89 7A 08 89 72 0C 89 62 10 8B 04 24 89 42 14 C7 42 20 30 32 43 56 C7 42 24 00 00 00 00 64 A1 ?? ?? ?? ?? 89 42 18 83 F8 FF 75 09 C7 42 1C FF FF FF FF EB 3B 8B 4C 24 08 0B C9 74 0A 8B 44 24 0C 89 42 24 49 75 08 8B 40 0C 89 42 1C EB 21 8B 44 24 10 89 42 1C 49 74 17 56 57 8D 74 24 1C 8D 7A 28 83 F9 06 76 05 B9 06 00 00 00 F3 A5 5F 5E 2B C0 C3 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "_fgets"
		size = 391
		refs = "0003 __sehtable$_fgets 0008 __SEH_prolog4 0021 __errno 0031 __invalid_parameter 0065 __lock_file 0079 __fileno 009b ___pioinfo 00b4 ___badioinfo 013c __filbuf 0177 __SEH_epilog4 0181 __unlock_file"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 89 45 E4 89 45 E0 33 DB 3B C3 75 24 39 5D 0C 74 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 37 01 00 00 33 C0 39 5D 0C 0F 9D C0 3B C3 74 D5 33 C0 8B 75 10 3B F3 0F 95 C0 3B C3 74 C7 39 5D 0C 74 DA 8B FE 89 7D DC 56 E8 ?? ?? ?? ?? 59 89 5D FC F6 46 0C 40 0F 85 AA 00 00 00 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 30 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 24 56 E8 ?? ?? ?? ?? C1 F8 05 8D 3C 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 07 8B FE EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 75 48 56 E8 ?? ?? ?? ?? 59 83 F8 FF 74 31 56 E8 ?? ?? ?? ?? 59 83 F8 FE 74 25 56 E8 ?? ?? ?? ?? C1 F8 05 8D 3C 85 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 07 8B 7D DC EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 89 5D E0 39 5D E0 74 41 FF 4D 0C 74 37 FF 4F 04 78 0A 8B 0F 0F B6 01 41 89 0F EB 07 57 E8 ?? ?? ?? ?? 59 89 45 D8 83 F8 FF 75 0D 8B 45 E4 3B 45 08 75 14 89 5D E0 EB 11 8B 4D E4 88 01 FF 45 E4 3C 0A 75 C4 8B 45 E4 88 18 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 8B 7D DC 57 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_301_0_0 {
	meta:
		name = "__fltinf_l"
		size = 182
		refs = "0007 ___security_cookie 0031 ___strgtold12_l 0059 __ld12tod 0085 _flt 00b0 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 20 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 18 83 65 EC 00 53 56 8B 75 08 50 6A 01 FF 75 14 8D 45 E0 FF 75 10 6A 00 56 50 8D 45 F0 50 E8 ?? ?? ?? ?? 8B D8 83 C4 20 F6 C3 04 74 11 83 65 E4 00 83 65 E8 00 C7 45 EC 00 02 00 00 EB 31 8D 45 E4 50 8D 45 F0 50 E8 ?? ?? ?? ?? F6 C3 02 59 59 75 05 83 F8 01 75 07 C7 45 EC 80 00 00 00 F6 C3 01 75 05 83 F8 02 75 07 81 4D EC 00 01 00 00 8B 4D E0 A1 ?? ?? ?? ?? 2B CE 39 4D 0C 5E 89 48 04 5B 74 04 83 4D EC 40 8B 4D E4 89 48 10 8B 4D E8 89 48 14 8B 4D EC 89 08 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_302_3_0 {
	meta:
		name = "__gcvt_s"
		size = 286
		refs = "0007 ___security_cookie 001d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0026 __errno 0035 __invalid_parameter 006a __fltout2 008f __cftof 00a4 __cftoe 0118 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 3C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B 7D 08 33 DB 53 8D 4D D4 E8 ?? ?? ?? ?? 3B FB 75 1C E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 C0 00 00 00 39 5D 0C 76 DF 8B 75 18 3B 75 0C 88 1F 72 09 E8 ?? ?? ?? ?? 6A 22 EB D3 6A 16 8D 45 E4 50 8D 45 C4 50 FF 75 14 FF 75 10 E8 ?? ?? ?? ?? 8B 40 04 8D 48 FF 83 C4 14 83 F9 FF 7C 1C 8D 56 FF 3B CA 7F 15 2B F0 56 FF 75 0C 8D 45 10 57 50 E8 ?? ?? ?? ?? 83 C4 10 EB 13 53 4E 56 FF 75 0C 8D 45 10 57 50 E8 ?? ?? ?? ?? 83 C4 14 8B F0 3B F3 75 49 8A 0F 3A CB 8B C7 74 18 8B 55 D4 8B 92 BC 00 00 00 8B 12 8A 12 3A CA 74 07 40 8A 08 3A CB 75 F5 8A 08 40 84 C9 74 29 EB 06 80 F9 65 74 07 40 8A 08 3A CB 75 F4 8B D0 48 80 38 30 74 FA 8A 0A 40 42 3A CB 88 08 75 F6 EB 07 E8 ?? ?? ?? ?? 89 30 38 5D E0 74 07 8B 45 DC 83 60 70 FD 8B 4D FC 5F 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_302_4_0 {
	meta:
		name = "__gcvt"
		size = 38
		refs = "0014 __gcvt_s"
	strings:
		$1 = { FF 74 24 0C DD 44 24 08 51 51 DD 1C 24 6A FF FF 74 24 20 E8 ?? ?? ?? ?? 83 C4 14 F7 D8 1B C0 F7 D0 23 44 24 10 C3 }
	condition:
		$1
}

rule file_303_9_0 {
	meta:
		name = "__whiteout"
		size = 42
		refs = "0008 __fgetwc_nolock 001b _iswctype"
	strings:
		$1 = { 57 FF 74 24 08 FF 06 E8 ?? ?? ?? ?? 0F B7 F8 66 81 FF FF FF 59 74 0E 6A 08 57 E8 ?? ?? ?? ?? 85 C0 59 59 75 DC 66 8B C7 5F C3 }
	condition:
		$1
}

rule file_303_10_0 {
	meta:
		name = "__winput_s_l"
		size = 3470
		refs = "000f ___security_cookie 005b __errno 006b __invalid_parameter 0088 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00a7 _iswctype 00be __whiteout 00c5 __un_inc 013a _isdigit 027b __fgetwc_nolock 03c6 ___check_float_string 040e __mbtowc_l 062d __malloc_crt 0649 _wcstombs_s 0664 __invoke_watson 067b __cfltcvt_tab 0680 __decode_pointer 0689 _free 080a _memset 0998 _wctomb_s 0ab1 __allmul 0ac9 _isxdigit 0ae8 __hextodec 0d82 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 2C FD FF FF 81 EC 48 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 D0 02 00 00 8B 8D E8 02 00 00 8B 85 DC 02 00 00 56 33 F6 57 8B BD E0 02 00 00 3B FE 89 4D AC 8D 4D 14 89 45 F8 89 7D DC 89 4D F0 C7 45 BC 5E 01 00 00 89 75 B8 89 75 B0 89 75 9C 89 75 04 89 75 A0 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 FD 0C 00 00 3B C6 74 DC FF B5 E4 02 00 00 8D 4D 8C E8 ?? ?? ?? ?? 0F B7 07 66 3B C6 C6 45 F6 00 89 75 0C 89 75 C4 0F 84 C5 0C 00 00 53 6A 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 38 FF 75 F8 FF 4D 0C FF 75 F8 8D 75 0C E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 8B 75 DC 59 59 46 46 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 ED 89 75 DC E9 B4 0B 00 00 8B 75 DC 66 83 3E 25 0F 85 6E 0B 00 00 33 FF 89 7D D8 89 7D B4 89 7D EC 89 7D CC 89 7D 00 89 7D C0 C6 45 D3 00 C6 45 F5 00 C6 45 FF 00 C6 45 13 00 C6 45 F7 00 C6 45 0B 00 C6 45 FE 01 89 7D E8 46 46 0F B7 1E 66 F7 C3 00 FF 75 23 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 15 8B 45 00 FF 45 CC 6B C0 0A 8D 44 18 D0 89 45 00 E9 AE 00 00 00 83 FB 4E 7F 7E 0F 84 A3 00 00 00 83 FB 2A 74 6E 83 FB 46 0F 84 95 00 00 00 83 FB 49 74 0D 83 FB 4C 75 6F FE 45 FE E9 83 00 00 00 0F B7 4E 02 66 83 F9 36 75 16 8D 46 04 66 83 38 34 75 0D FF 45 E8 8B F0 89 7D E0 89 7D E4 EB 63 66 83 F9 33 75 0D 8D 46 04 66 83 38 32 75 04 8B F0 EB 50 66 83 F9 64 74 4A 66 83 F9 69 74 44 66 83 F9 6F 74 3E 66 83 F9 78 74 38 66 83 F9 58 75 16 EB 30 FE 45 FF EB 2B 83 FB 68 74 20 83 FB 6C 74 0A 83 FB 77 74 11 FE 45 13 EB 17 8D 46 02 66 83 38 6C 74 9E FE 45 FE FE 45 0B EB 06 FE 4D FE FE 4D 0B 80 7D 13 00 0F 84 19 FF FF FF 80 7D FF 00 89 75 DC 75 10 8B 45 AC 8B 18 89 45 A8 83 C0 04 89 45 AC EB 02 33 DB 80 7D 0B 00 89 5D C8 C6 45 13 00 75 17 0F B7 06 66 3D 53 00 74 0A 66 3D 43 00 C6 45 0B 01 75 04 C6 45 0B FF 0F B7 3E 83 CF 20 83 FF 6E 89 7D D4 74 39 83 FF 63 74 12 83 FF 7B 74 0D FF 75 F8 8D 75 0C E8 ?? ?? ?? ?? EB 0B FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 C0 66 3D FF FF 89 45 04 59 0F 84 72 0A 00 00 8B 5D C8 8B 75 DC 8B 4D CC 85 C9 74 0A 83 7D 00 00 0F 84 4E 0A 00 00 80 7D FF 00 75 32 83 FF 63 74 0A 83 FF 73 74 05 83 FF 7B 75 23 8B 45 A8 8B 18 83 C0 04 89 45 A8 83 C0 04 89 45 AC 8B 40 FC 83 F8 01 89 5D C8 89 45 C0 0F 82 CC 09 00 00 83 FF 6F 0F 8F 8C 04 00 00 0F 84 23 07 00 00 83 FF 63 0F 84 9E 03 00 00 6A 64 58 3B F8 0F 84 0F 07 00 00 0F 8E 96 04 00 00 83 FF 67 7E 3E 83 FF 69 74 1E 83 FF 6E 0F 85 83 04 00 00 80 7D FF 00 8B 45 0C 89 45 D8 0F 84 05 09 00 00 E9 27 09 00 00 89 45 D4 8B F8 8B 5D 04 66 83 FB 2D 0F 85 8F 05 00 00 C6 45 F5 01 E9 8C 05 00 00 33 DB 66 83 7D 04 2D 75 0B 8B 45 F0 66 C7 00 2D 00 43 EB 07 66 83 7D 04 2B 75 15 FF 4D 00 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 C0 59 89 45 04 83 7D CC 00 75 04 83 4D 00 FF 66 F7 45 04 00 FF 75 60 0F B6 45 04 50 E8 ?? ?? ?? ?? 85 C0 59 74 51 8B 45 00 FF 4D 00 85 C0 74 47 66 0F BE 45 04 8B 4D F0 FF 45 EC 66 89 04 59 8D 45 B8 50 8D 45 14 50 43 53 8D 7D F0 8D 75 BC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 2D 09 00 00 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 59 89 45 04 74 A0 8D 45 8C 50 8B 45 8C C7 45 A4 2E 00 00 00 FF B0 AC 00 00 00 8B 80 BC 00 00 00 FF 30 8D 45 A4 50 E8 ?? ?? ?? ?? 0F B7 45 A4 0F BE 4D 04 83 C4 10 3B C1 0F 85 B1 00 00 00 8B 45 00 FF 4D 00 85 C0 0F 84 A3 00 00 00 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 8B 4D F0 0F B7 C0 89 45 04 66 8B 45 A4 66 89 04 59 8D 45 B8 50 8D 45 14 50 43 53 8D 7D F0 8D 75 BC E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 93 08 00 00 66 F7 45 04 00 FF 75 5F 0F B6 45 04 50 E8 ?? ?? ?? ?? 85 C0 59 74 50 8B 45 00 FF 4D 00 85 C0 74 46 8B 45 F0 66 8B 4D 04 FF 45 EC 66 89 0C 58 8D 45 B8 50 8D 45 14 50 43 53 8D 7D F0 8D 75 BC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 44 08 00 00 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 59 89 45 04 74 A1 83 7D EC 00 0F 84 15 01 00 00 66 83 7D 04 65 74 0B 66 83 7D 04 45 0F 85 03 01 00 00 8B 45 00 FF 4D 00 85 C0 0F 84 F5 00 00 00 8B 45 F0 66 C7 04 58 65 00 8D 45 B8 50 8D 45 14 50 43 53 8D 7D F0 8D 75 BC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 D9 07 00 00 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 C0 66 3D 2D 00 59 89 45 04 75 25 8B 45 F0 66 C7 04 58 2D 00 8D 45 B8 50 8D 45 14 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 9E 07 00 00 EB 07 66 83 7D 04 2B 75 21 8B 45 00 FF 4D 00 85 C0 75 05 21 45 00 EB 12 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 C0 59 89 45 04 66 F7 45 04 00 FF 75 5F 0F B6 45 04 50 E8 ?? ?? ?? ?? 85 C0 59 74 50 8B 45 00 FF 4D 00 85 C0 74 46 8B 45 F0 66 8B 4D 04 FF 45 EC 66 89 0C 58 8D 45 B8 50 8D 45 14 50 43 53 8D 7D F0 8D 75 BC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 25 07 00 00 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 59 89 45 04 74 A1 FF 75 F8 FF 4D 0C FF 75 04 E8 ?? ?? ?? ?? 83 7D EC 00 59 59 0F 84 F3 06 00 00 80 7D FF 00 0F 85 3E 06 00 00 8B 75 BC 8B 45 F0 FF 45 C4 66 83 24 58 00 8D 74 36 02 56 E8 ?? ?? ?? ?? 8B F8 85 FF 59 0F 84 C6 06 00 00 8D 46 FF 50 FF 75 F0 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 17 83 F8 16 74 05 83 F8 22 75 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8D 45 8C 50 0F BE 45 FE 57 FF 75 C8 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 C2 05 00 00 85 C9 75 0A FF 45 00 C7 45 CC 01 00 00 00 80 7D 0B 00 7E 04 C6 45 F7 01 FF 75 F8 FF 4D 0C FF 75 04 8B F3 E8 ?? ?? ?? ?? 83 FF 63 59 59 74 03 FF 4D C0 83 7D CC 00 74 0E 8B 45 00 FF 4D 00 85 C0 0F 84 FA 02 00 00 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 D0 66 81 FA FF FF 59 89 55 04 0F 84 CF 02 00 00 83 FF 63 74 4C 83 FF 73 75 16 66 83 FA 09 72 0A 66 83 FA 0D 0F 86 B5 02 00 00 66 83 FA 20 75 31 83 FF 7B 0F 85 A6 02 00 00 0F B7 C2 8B C8 33 FF 83 E1 07 47 D3 E7 8B 4D B0 C1 E8 03 0F BE 04 08 0F BE 4D D3 33 C1 85 F8 8B 7D D4 0F 84 7E 02 00 00 80 7D FF 00 0F 85 6D 02 00 00 83 7D C0 00 0F 84 7C 05 00 00 80 7D F7 00 0F 84 23 02 00 00 66 89 13 43 43 89 5D C8 E9 50 FF FF FF 8B C7 83 E8 70 0F 84 8E 02 00 00 83 E8 03 0F 84 1B FF FF FF 48 48 0F 84 81 02 00 00 83 E8 03 0F 84 9C FB FF FF 83 E8 03 74 24 8B 45 04 66 39 06 0F 85 1D 05 00 00 FE 4D F6 80 7D FF 00 0F 85 A0 04 00 00 8B 45 A8 89 45 AC E9 95 04 00 00 80 7D 0B 00 7E 04 C6 45 F7 01 46 46 66 83 3E 5E 75 07 83 C6 02 C6 45 D3 FF 8B 5D B0 85 DB 75 1F 68 00 20 00 00 E8 ?? ?? ?? ?? 85 C0 59 89 45 B0 0F 84 0A 05 00 00 C7 45 9C 01 00 00 00 8B D8 68 00 20 00 00 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 6A 5D 59 66 39 0E 75 09 46 89 4D B4 46 C6 43 0B 20 0F B7 06 66 3B C1 0F 84 8B 00 00 00 0F B7 C0 46 46 66 3D 2D 00 75 5A 8B 55 B4 66 85 D2 74 52 0F B7 0E 66 83 F9 5D 74 49 0F B7 C9 46 46 66 3B D1 73 05 0F B7 C1 EB 09 0F B7 C2 0F B7 D1 89 55 B4 66 3B D0 77 26 2B 45 B4 0F B7 7D B4 40 0F B7 C0 89 45 E8 8B CF 83 E1 07 8B C7 B2 01 D2 E2 C1 E8 03 03 C3 08 10 47 FF 4D E8 75 E8 83 65 B4 00 EB 19 0F B7 C8 89 4D B4 0F B7 C8 8B C1 83 E1 07 B2 01 C1 E8 03 D2 E2 03 C3 08 10 0F B7 06 66 3D 5D 00 0F 85 75 FF FF FF 66 83 3E 00 0F 84 3F 04 00 00 8B 5D C8 8B 7D D4 89 75 DC E9 DC FD FF FF 66 83 FB 2B 75 21 FF 4D 00 75 0A 85 C9 74 06 C6 45 13 01 EB 12 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 D8 59 89 5D 04 66 83 FB 30 0F 85 45 01 00 00 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 59 0F B7 D8 6A 78 5E 66 3B DE 89 5D 04 74 3E 66 83 FB 58 74 38 3B FE C7 45 EC 01 00 00 00 74 17 83 7D CC 00 74 08 FF 4D 00 75 03 FE 45 13 C7 45 D4 6F 00 00 00 EB 3E FF 75 F8 FF 4D 0C 53 E8 ?? ?? ?? ?? 59 59 6A 30 5B E9 EA 00 00 00 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 83 7D CC 00 0F B7 D8 59 89 5D 04 74 0D 83 6D 00 02 83 7D 00 01 7D 03 FE 45 13 89 75 D4 8B 7D D4 E9 BD 00 00 00 83 65 E8 00 52 FF 75 C0 8D 45 E8 53 50 E8 ?? ?? ?? ?? 83 C4 10 83 F8 22 0F 84 31 03 00 00 8B 45 E8 85 C0 0F 8E 14 FD FF FF 03 D8 29 45 C0 89 5D C8 E9 07 FD FF FF 46 46 E9 00 FD FF FF FF 75 F8 FF 4D 0C 52 E8 ?? ?? ?? ?? 59 59 3B F3 0F 84 25 03 00 00 80 7D FF 00 0F 85 70 02 00 00 FF 45 C4 83 FF 63 0F 84 64 02 00 00 80 7D F7 00 8B 45 C8 74 09 66 83 20 00 E9 52 02 00 00 C6 00 00 E9 4A 02 00 00 C6 45 FE 01 8B 5D 04 66 83 FB 2D 75 06 C6 45 F5 01 EB 06 66 83 FB 2B 75 21 FF 4D 00 75 0A 85 C9 74 06 C6 45 13 01 EB 12 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 59 0F B7 D8 89 5D 04 83 7D E8 00 0F 84 06 01 00 00 80 7D 13 00 0F 85 DA 00 00 00 83 FF 78 74 5D 83 FF 70 74 58 66 F7 C3 00 FF 0F 85 B7 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 A5 00 00 00 83 FF 6F 75 1F 66 83 FB 38 0F 83 96 00 00 00 8B 45 E0 8B 4D E4 0F A4 C1 03 C1 E0 03 89 45 E0 89 4D E4 EB 4F 6A 00 6A 0A FF 75 E4 FF 75 E0 E8 ?? ?? ?? ?? 89 45 E0 89 55 E4 EB 38 66 F7 C3 00 FF 75 63 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 55 8B 45 E0 8B 4D E4 0F A4 C1 04 C1 E0 04 8B FB 89 45 E0 89 4D E4 E8 ?? ?? ?? ?? 8B 7D D4 0F B7 D8 89 5D 04 FF 45 EC 0F B7 C3 83 E8 30 99 01 45 E0 11 55 E4 83 7D CC 00 74 05 FF 4D 00 74 25 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 D8 59 89 5D 04 E9 34 FF FF FF FF 75 F8 FF 4D 0C 53 E8 ?? ?? ?? ?? 59 59 80 7D F5 00 0F 84 D2 00 00 00 8B 45 E0 8B 4D E4 F7 D8 83 D1 00 F7 D9 89 45 E0 89 4D E4 E9 BA 00 00 00 80 7D 13 00 0F 85 A7 00 00 00 83 FF 78 74 39 83 FF 70 74 34 66 F7 C3 00 FF 0F 85 84 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 76 83 FF 6F 75 0E 66 83 FB 38 73 6B 8B 45 D8 C1 E0 03 EB 34 8B 45 D8 6B C0 0A EB 2C 66 F7 C3 00 FF 75 54 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 46 C1 65 D8 04 8B FB E8 ?? ?? ?? ?? 8B 7D D4 0F B7 D8 8B 45 D8 89 5D 04 FF 45 EC 83 7D CC 00 0F B7 CB 8D 44 08 D0 89 45 D8 74 05 FF 4D 00 74 25 FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 0F B7 D8 59 89 5D 04 E9 67 FF FF FF FF 75 F8 FF 4D 0C 53 E8 ?? ?? ?? ?? 59 59 80 7D F5 00 74 03 F7 5D D8 83 FF 46 75 04 83 65 EC 00 83 7D EC 00 0F 84 DE 00 00 00 80 7D FF 00 75 2D FF 45 C4 8B 5D C8 83 7D E8 00 74 0D 8B 45 E0 89 03 8B 45 E4 89 43 04 EB 14 80 7D FE 00 74 07 8B 45 D8 89 03 EB 07 66 8B 45 D8 66 89 03 8B 75 DC FE 45 F6 46 46 89 75 DC EB 1F FF 75 F8 FF 45 0C E8 ?? ?? ?? ?? 59 66 8B 0E 0F B7 C0 46 46 66 3B C8 89 45 04 89 75 DC 75 72 66 81 7D 04 FF FF 75 12 66 83 3E 25 75 71 8B 45 DC 66 83 78 02 6E 75 67 8B F0 0F B7 06 66 85 C0 0F 85 FA F3 FF FF EB 57 80 7D 0B 00 7E 06 66 83 23 00 EB 03 C6 03 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 3B FF 75 F8 50 E8 ?? ?? ?? ?? C7 45 A0 01 00 00 00 EB 27 E8 ?? ?? ?? ?? 80 7D F7 00 C7 00 0C 00 00 00 74 06 66 83 26 00 EB 12 C6 06 00 EB 0D FF 75 F8 FF 75 04 E8 ?? ?? ?? ?? 59 59 83 7D 9C 01 5B 75 09 FF 75 B0 E8 ?? ?? ?? ?? 59 83 7D B8 01 75 09 FF 75 F0 E8 ?? ?? ?? ?? 59 66 81 7D 04 FF FF 75 1E 8B 45 C4 85 C0 75 08 38 45 F6 75 03 83 C8 FF 80 7D 98 00 74 39 8B 4D 94 83 61 70 FD EB 30 83 7D A0 01 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 80 7D 98 00 74 07 8B 45 94 83 60 70 FD 8B 45 C4 8B 8D D0 02 00 00 5F 33 CD 5E E8 ?? ?? ?? ?? 81 C5 D4 02 00 00 C9 C3 }
	condition:
		$1
}

rule file_305_0_0 {
	meta:
		name = "__getws_helper"
		size = 327
		refs = "0003 __sehtable$__getws_helper 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 004a ___iob_func 0051 __lock_file2 0061 __fgetwc_nolock 010d ___security_cookie 0112 __local_unwind4 0131 __SEH_epilog4 0140 __unlock_file2"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 08 89 7D DC 33 C0 33 F6 3B FE 0F 95 C0 3B C6 75 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 F2 00 00 00 33 C0 3B 45 0C 1B C0 F7 D8 74 D6 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 89 75 FC E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 E0 BB FF FF 00 00 3B C3 75 0C 89 75 DC 39 75 10 0F 85 A0 00 00 00 8B 4D 0C 83 F9 FF 75 2D 83 F8 0A 0F 84 8C 00 00 00 3B C3 0F 84 84 00 00 00 66 89 07 47 47 89 7D D8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 E0 EB D3 89 4D E4 83 F8 0A 74 28 3B C3 74 24 39 75 E4 76 0B FF 4D E4 66 89 07 47 47 89 7D D8 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 0F B7 C0 89 45 E0 EB D3 39 75 E4 75 33 8B 45 08 66 89 30 E8 ?? ?? ?? ?? C7 00 22 00 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 6A FE 8D 45 F0 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 20 E9 19 FF FF FF 66 89 37 C7 45 FC FE FF FF FF E8 0B 00 00 00 8B 45 DC E8 ?? ?? ?? ?? C3 33 F6 E8 ?? ?? ?? ?? 50 56 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_306_0_0 {
	meta:
		name = "__wfltin2"
		size = 167
		refs = "0007 ___security_cookie 0032 ___wstrgtold12_l 0056 __ld12tod 00a1 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 24 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 1C 8B 4D 0C 53 56 8B 75 08 57 50 33 FF 57 57 57 57 51 8D 45 DC 50 8D 45 F0 50 89 4D E0 33 DB E8 ?? ?? ?? ?? 83 C4 20 A8 04 89 45 EC 74 0D BB 00 02 00 00 89 7D E4 89 7D E8 EB 30 8D 45 E4 50 8D 45 F0 50 E8 ?? ?? ?? ?? F6 45 EC 02 59 59 75 05 83 F8 01 75 05 BB 80 00 00 00 F6 45 EC 01 75 05 83 F8 02 75 06 81 CB 00 01 00 00 8B 45 DC 2B 45 E0 8B 4D FC D1 F8 89 46 04 8B 45 E4 89 46 10 8B 45 E8 89 46 14 5F 89 1E 8B C6 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_307_3_0 {
	meta:
		name = "__wtof_l"
		size = 138
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001d __errno 002d __invalid_parameter 0051 __iswctype_l 0064 _wcslen 0070 __wfltin2"
	strings:
		$1 = { 55 8B EC 83 EC 28 53 56 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 08 33 DB 3B F3 75 2A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD D9 EE EB 42 46 46 8D 45 F0 50 0F B7 06 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 E8 8D 45 F0 50 53 53 56 E8 ?? ?? ?? ?? 59 50 8D 45 D8 56 50 E8 ?? ?? ?? ?? DD 40 10 83 C4 18 38 5D FC 74 07 8B 45 F8 83 60 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_307_5_0 {
	meta:
		name = "___wstrgtold12"
		size = 64
		refs = "000c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ___wstrgtold12_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_375_5_0 {
	meta:
		name = "___strgtold12"
		size = 64
		refs = "000c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002a ___strgtold12_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 20 FF 75 1C FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_307_6_0 {
	meta:
		name = "___WSTRINGTOLD"
		size = 55
		refs = "000c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 ___WSTRINGTOLD_L"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_914_4_0 {
	meta:
		name = "?_fltinf@@YAPAU_flt@@PBDHHH@Z"
		size = 55
		refs = "000c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 __fltinf_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_375_6_0 {
	meta:
		name = "___STRINGTOLD"
		size = 55
		refs = "000c ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0021 ___STRINGTOLD_L"
	strings:
		$1 = { 55 8B EC 83 EC 10 6A 00 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_308_3_0 {
	meta:
		name = "__mbcjistojms_l"
		size = 161
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0086 __errno"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 74 12 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 8B 45 08 C9 C3 0F B6 45 09 0F B6 4D 08 8D 50 DF 83 FA 5D 77 46 8D 51 DF 83 FA 5D 77 3E A8 01 74 0F 83 F9 5F 77 05 83 C1 1F EB 08 83 C1 20 EB 03 83 C1 7E 83 C0 DF D1 E8 05 81 00 00 00 3D 9F 00 00 00 76 03 83 C0 40 C1 E0 08 0B C1 80 7D FC 00 74 23 8B 4D F8 83 61 70 FD C9 C3 E8 ?? ?? ?? ?? 80 7D FC 00 C7 00 2A 00 00 00 74 07 8B 45 F8 83 60 70 FD 33 C0 C9 C3 }
	condition:
		$1
}

rule file_308_5_0 {
	meta:
		name = "__mbcjmstojis_l"
		size = 217
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00bd __errno"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 55 F4 81 7A 04 A4 03 00 00 74 12 80 7D FC 00 74 07 8B 45 F8 83 60 70 FD 8B 45 08 C9 C3 0F B6 45 09 0F B6 4D 08 56 0F B6 F0 F6 44 16 1D 04 74 7A 0F B6 F1 F6 44 16 1D 08 74 70 3D A0 00 00 00 1B D2 83 E2 C0 81 C2 C1 00 00 00 2B C2 81 F9 9F 00 00 00 72 0D 83 C0 11 C1 E0 09 83 C1 82 0B C1 EB 1A 6A 7E 5A 3B D1 1B D2 F7 DA C1 E0 09 83 C2 1F 05 00 21 00 00 2B CA 0B C8 8B C1 8D 88 DF DE FF FF 81 F9 5D 5D 00 00 77 21 8B C8 81 E1 FF 00 00 00 83 F9 7E 77 14 83 F9 21 72 0F 80 7D FC 00 74 23 8B 4D F8 83 61 70 FD EB 1A E8 ?? ?? ?? ?? 80 7D FC 00 C7 00 2A 00 00 00 74 07 8B 45 F8 83 60 70 FD 33 C0 5E C9 C3 }
	condition:
		$1
}

rule file_309_0_0 {
	meta:
		name = "__wspawnv"
		size = 81
		refs = "000c __errno 001c __invalid_parameter 0048 __wspawnve"
	strings:
		$1 = { 8B 54 24 08 56 33 F6 3B D6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF 5E C3 66 39 32 74 DE 8B 4C 24 10 3B CE 74 D6 8B 01 3B C6 74 D0 66 39 30 74 CB 56 51 52 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 10 5E C3 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "___init_ctype"
		size = 917
		refs = "0007 ___security_cookie 004e ___getlocaleinfo 0060 __malloc_crt 0070 __calloc_crt 00e9 __imp__GetCPInfo@8 0155 ___crtGetStringTypeA 0188 ___crtLCMapStringA 0253 _memcpy 0288 __imp__InterlockedDecrement@4 029d _free 0362 ___newctype 036c ___newclmap 0376 ___newcumap 038f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 48 A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 33 DB 56 8B 75 08 39 5E 14 57 89 5D D4 89 5D DC 89 5D E4 89 5D D8 89 5D E0 89 75 B8 89 5D BC 0F 84 0B 03 00 00 8D 46 04 39 18 75 20 50 0F B7 46 30 68 04 10 00 00 50 8D 45 B8 53 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 BC 02 00 00 6A 04 E8 ?? ?? ?? ?? 6A 02 BF 80 01 00 00 57 89 45 D4 E8 ?? ?? ?? ?? 6A 01 57 89 45 DC E8 ?? ?? ?? ?? 6A 01 57 89 45 E4 E8 ?? ?? ?? ?? 6A 01 68 01 01 00 00 89 45 D8 E8 ?? ?? ?? ?? 83 C4 24 39 5D D4 89 45 E0 0F 84 71 02 00 00 39 5D DC 0F 84 68 02 00 00 3B C3 0F 84 60 02 00 00 39 5D E4 0F 84 57 02 00 00 39 5D D8 0F 84 4E 02 00 00 8B 45 D4 89 18 33 C0 8B 4D E0 88 04 08 40 3D 00 01 00 00 7C F2 8D 45 E8 50 FF 76 04 FF 15 ?? ?? ?? ?? 85 C0 0F 84 24 02 00 00 83 7D E8 05 0F 87 1A 02 00 00 0F B7 45 E8 83 F8 01 89 45 D0 7E 2D 38 5D EE 74 28 8D 45 EF 8A 08 3A CB 74 1F 0F B6 78 FF 0F B6 C9 EB 0B 8B 4D E0 C6 04 0F 20 0F B6 08 47 3B F9 7E F1 40 40 38 58 FF 75 DB 8B 45 DC 53 53 FF 76 04 05 00 01 00 00 50 68 00 01 00 00 FF 75 E0 89 45 C4 6A 01 53 E8 ?? ?? ?? ?? 83 C4 20 85 C0 0F 84 B5 01 00 00 8B 4D E4 8B 45 E0 53 FF 76 04 BF FF 00 00 00 57 81 C1 81 00 00 00 51 57 40 50 68 00 01 00 00 FF 76 14 53 E8 ?? ?? ?? ?? 83 C4 24 85 C0 0F 84 82 01 00 00 8B 45 D8 53 FF 76 04 05 81 00 00 00 57 50 8B 45 E0 57 40 50 68 00 02 00 00 FF 76 14 53 E8 ?? ?? ?? ?? 83 C4 24 85 C0 0F 84 55 01 00 00 83 7D D0 01 8B 45 DC 8B 7D E4 8B 55 D8 8D 88 FE 00 00 00 66 89 19 89 4D C8 8D 8F 80 00 00 00 88 5F 7F 88 5A 7F 88 19 89 4D C0 8D 8A 80 00 00 00 89 4D CC 88 19 7E 4A 38 5D EE 74 45 8D 4D EF 89 4D E4 8A 11 3A D3 74 39 0F B6 49 FF 0F B6 D2 3B CA 7F 21 8D 94 48 00 01 00 00 EB 03 8B 55 DC 66 C7 02 00 80 41 42 42 89 55 DC 8B 55 E4 0F B6 12 3B CA 7E E8 8B 4D E4 41 41 38 59 FF 89 4D E4 75 C1 68 FE 00 00 00 8D 88 00 02 00 00 51 50 E8 ?? ?? ?? ?? 6A 7F 8D 87 00 01 00 00 50 57 E8 ?? ?? ?? ?? 8B 45 D8 6A 7F 8D 88 00 01 00 00 51 50 E8 ?? ?? ?? ?? 8B 86 C0 00 00 00 83 C4 24 3B C3 74 4B 50 FF 15 ?? ?? ?? ?? 85 C0 75 40 8B 86 C4 00 00 00 2D FE 00 00 00 50 E8 ?? ?? ?? ?? 8B 86 CC 00 00 00 BF 80 00 00 00 2B C7 50 E8 ?? ?? ?? ?? 8B 86 D0 00 00 00 2B C7 50 E8 ?? ?? ?? ?? FF B6 C0 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 8B 45 D4 C7 00 01 00 00 00 89 86 C0 00 00 00 8B 45 C4 89 86 C8 00 00 00 8B 45 C8 89 86 C4 00 00 00 8B 45 C0 89 86 CC 00 00 00 8B 45 CC 89 86 D0 00 00 00 8B 45 D0 89 86 AC 00 00 00 FF 75 E0 E8 ?? ?? ?? ?? 59 8B C3 EB 6D FF 75 D4 E8 ?? ?? ?? ?? FF 75 DC E8 ?? ?? ?? ?? FF 75 E4 E8 ?? ?? ?? ?? FF 75 D8 E8 ?? ?? ?? ?? 33 DB 83 C4 10 43 EB CB 8D BE C0 00 00 00 8B 07 3B C3 74 07 50 FF 15 ?? ?? ?? ?? 89 1F 89 9E C4 00 00 00 C7 86 C8 00 00 00 ?? ?? ?? ?? C7 86 CC 00 00 00 ?? ?? ?? ?? C7 86 D0 00 00 00 ?? ?? ?? ?? C7 86 AC 00 00 00 01 00 00 00 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_310_1_0 {
	meta:
		name = "____mb_cur_max_func"
		size = 41
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 80 AC 00 00 00 C3 }
	condition:
		$1
}

rule file_310_2_0 {
	meta:
		name = "____mb_cur_max_l_func"
		size = 22
		refs = "0009 ____mb_cur_max_func"
	strings:
		$1 = { 8B 44 24 04 85 C0 75 05 E9 ?? ?? ?? ?? 8B 00 8B 80 AC 00 00 00 C3 }
	condition:
		$1
}

rule file_310_3_0 {
	meta:
		name = "____lc_codepage_func"
		size = 38
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 40 04 C3 }
	condition:
		$1
}

rule file_310_4_0 {
	meta:
		name = "____lc_collate_cp_func"
		size = 38
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 40 08 C3 }
	condition:
		$1
}

rule file_310_5_0 {
	meta:
		name = "____lc_handle_func"
		size = 38
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 83 C0 0C C3 }
	condition:
		$1
}

rule file_311_0_0 {
	meta:
		name = "___libm_sse2_exp"
		size = 534
		refs = "000b _cv 0013 _Shifter 0096 _Tbl_addr 00ba _mmask 00c6 _bias 0124 _emask 0193 _XMAX 01a3 _XMIN 01d1 _INF 01dd _ZERO 0211 _ONE_val"
	strings:
		$1 = { 83 EC 0C 66 0F 14 C0 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 35 ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? 66 0F C5 C0 03 25 FF 7F 00 00 BA 8F 40 00 00 2B D0 2D 90 3C 00 00 0B D0 81 FA 00 00 00 80 0F 83 9F 01 00 00 66 0F 59 C8 66 0F 58 CE 66 0F 28 F9 66 0F 5C CE 66 0F 59 D1 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 D9 66 0F 28 2D ?? ?? ?? ?? 66 0F 5C C2 66 0F 7E F8 8B C8 83 E1 3F C1 E1 04 C1 F8 06 8B D0 66 0F 5C C3 66 0F 28 91 ?? ?? ?? ?? 66 0F 59 E0 66 0F 28 C8 66 0F 59 C0 66 0F 58 EC F2 0F 59 C0 F2 0F 58 CA 66 0F 15 D2 66 0F 6F 35 ?? ?? ?? ?? 66 0F DB FE 66 0F 6F 35 ?? ?? ?? ?? 66 0F D4 FE 66 0F 73 F7 2E 66 0F 59 C5 F2 0F 58 C8 66 0F 56 D7 66 0F 15 C0 F2 0F 58 C1 81 C2 7E 03 00 00 81 FA 7C 07 00 00 77 0C 83 C4 0C F2 0F 59 C2 F2 0F 58 C2 C3 83 EC 12 9B D9 7C 24 10 66 8B 54 24 10 66 81 CA 00 03 66 89 14 24 D9 2C 24 8B D0 D1 F8 2B D0 66 0F 6F 35 ?? ?? ?? ?? 66 0F DF F2 05 FF 03 00 00 66 0F 6E D8 66 0F 73 F3 34 66 0F 56 F3 81 C2 FF 03 00 00 66 0F 6E E2 66 0F 73 F4 34 66 0F 13 04 24 DD 04 24 66 0F 13 74 24 08 DD 44 24 08 DC C9 DE C1 66 0F 13 24 24 DD 04 24 DE C9 DD 1C 24 66 0F 12 04 24 D9 6C 24 10 83 C4 1E C3 3D 00 00 F0 7F 73 2B 8B 44 24 08 3D 00 00 00 80 73 10 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 59 C0 C3 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 59 C0 C3 8B 54 24 04 3D 00 00 F0 7F 77 28 83 FA 00 75 23 8B 44 24 08 3D 00 00 F0 7F 75 0C 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? C3 66 0F 12 44 24 04 83 C4 0C F2 0F 58 C0 C3 8B 44 24 08 25 FF FF FF 7F 3D 00 00 90 40 0F 83 79 FF FF FF 66 0F 12 44 24 04 83 C4 0C F2 0F 58 05 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "__sleep"
		size = 17
		refs = "000c __imp__Sleep@4"
	strings:
		$1 = { 8B 44 24 04 85 C0 75 01 40 50 FF 15 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_314_0_0 {
	meta:
		name = "__mbstok_l"
		size = 30
		refs = "0001 __getptd 0016 __mbstok_s_l"
	strings:
		$1 = { E8 ?? ?? ?? ?? FF 74 24 0C 83 C0 20 50 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_315_1_0 {
	meta:
		name = "__wfindfirst32i64"
		size = 314
		refs = "000f ___security_cookie 0030 __errno 0040 __invalid_parameter 005a __imp__FindFirstFileW@8 0068 __imp__GetLastError@0 00bc ___timet_from_ft 00e6 __allmul 0107 _wcscpy_s 0119 __invoke_watson 012e @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 28 FE FF FF 81 EC 58 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 D4 01 00 00 8B 85 E0 01 00 00 56 8B B5 E4 01 00 00 57 33 FF 3B F7 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 D4 00 00 00 3B C7 74 DC 8D 4D 84 51 50 FF 15 ?? ?? ?? ?? 83 F8 FF 89 45 80 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B8 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB AB E8 ?? ?? ?? ?? 89 30 EB A2 8B 45 84 2D 80 00 00 00 F7 D8 1B C0 23 45 84 53 89 06 8D 45 88 50 E8 ?? ?? ?? ?? 89 46 04 8D 45 90 50 E8 ?? ?? ?? ?? 89 46 08 8D 45 98 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF 75 A0 89 46 0C E8 ?? ?? ?? ?? 8B 4D A4 33 DB 03 C1 89 46 10 13 D3 8D 45 B0 50 89 56 14 68 04 01 00 00 83 C6 18 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 5B 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B 45 80 8B 8D D4 01 00 00 5F 33 CD 5E E8 ?? ?? ?? ?? 81 C5 D8 01 00 00 C9 C3 }
	condition:
		$1
}

rule file_315_2_0 {
	meta:
		name = "__wfindnext32i64"
		size = 324
		refs = "000a ___security_cookie 0024 __errno 0036 __invalid_parameter 005b __imp__FindNextFileW@8 0065 __imp__GetLastError@0 00c1 ___timet_from_ft 00f4 __allmul 011b _wcscpy_s 012c __invoke_watson 013e @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 81 EC 54 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 56 8B 75 0C 83 CB FF 3B C3 57 75 21 E8 ?? ?? ?? ?? 33 FF 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 8B C3 E9 F1 00 00 00 33 FF 3B F7 75 07 E8 ?? ?? ?? ?? EB D9 8D 8D AC FD FF FF 51 50 FF 15 ?? ?? ?? ?? 85 C0 75 3F FF 15 ?? ?? ?? ?? 6A 02 5E 3B C6 72 0F 83 F8 03 76 24 83 F8 08 74 12 83 F8 12 74 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 EB B1 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB A4 E8 ?? ?? ?? ?? 89 30 EB 9B 8B 85 AC FD FF FF 2D 80 00 00 00 F7 D8 1B C0 23 85 AC FD FF FF 89 06 8D 85 B0 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 04 8D 85 B8 FD FF FF 50 E8 ?? ?? ?? ?? 89 46 08 8D 85 C0 FD FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 6A 01 57 57 FF B5 C8 FD FF FF 89 46 0C E8 ?? ?? ?? ?? 8B 8D CC FD FF FF 33 DB 03 C1 89 46 10 13 D3 8D 85 D8 FD FF FF 50 89 56 14 68 04 01 00 00 83 C6 18 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_316_2_0 {
	meta:
		name = "__wspawnvpe"
		size = 576
		refs = "0017 __errno 0027 __invalid_parameter 008a __wspawnve 00b1 _wcschr 00c0 ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 00ca __wdupenv_s 00e4 __invoke_watson 0102 __calloc_crt 012b _wcslen 0144 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 014b _wcscat_s 01fa __wgetpath 0225 _free"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 45 0C 56 33 F6 57 33 FF 3B C6 89 75 FC 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 06 02 00 00 66 39 30 74 DB 53 8B 5D 10 3B DE 74 0B 8B 03 3B C6 74 05 66 39 30 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CD 01 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 EC E8 ?? ?? ?? ?? FF 75 14 89 30 53 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 89 45 F4 0F 85 6F 01 00 00 E8 ?? ?? ?? ?? 83 38 02 0F 85 61 01 00 00 6A 2F FF 75 0C E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 4D 01 00 00 68 ?? ?? ?? ?? 8D 45 FC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 1B 83 F8 16 0F 85 2E 01 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 E9 1C 01 00 00 39 75 FC 0F 84 13 01 00 00 6A 02 BB 04 01 00 00 53 E8 ?? ?? ?? ?? 8B F8 3B FE 59 59 0F 84 FA 00 00 00 68 03 01 00 00 57 FF 75 FC E9 D9 00 00 00 66 39 37 0F 84 E3 00 00 00 57 E8 ?? ?? ?? ?? 8D 44 47 FE 0F B7 00 66 3D 5C 00 59 74 26 66 3D 2F 00 74 20 68 ?? ?? ?? ?? 53 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? FF 75 0C 89 45 F0 E8 ?? ?? ?? ?? 59 59 8B 4D F0 03 C8 BB 04 01 00 00 3B CB 0F 83 84 00 00 00 FF 75 0C 53 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? FF 75 14 89 30 FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 89 45 F4 75 45 E8 ?? ?? ?? ?? 83 38 02 74 1F 0F B7 07 66 3D 5C 00 74 06 66 3D 2F 00 75 2C 0F B7 47 02 66 3D 5C 00 74 06 66 3D 2F 00 75 1C 68 03 01 00 00 57 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 89 45 F8 0F 85 14 FF FF FF E8 ?? ?? ?? ?? 39 30 75 0A E8 ?? ?? ?? ?? 8B 4D EC 89 08 3B FE 74 07 57 E8 ?? ?? ?? ?? 59 39 75 FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 8B 45 F4 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "__fputwchar"
		size = 21
		refs = "0001 ___iob_func 000e _fputwc"
	strings:
		$1 = { E8 ?? ?? ?? ?? 83 C0 20 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_404_0_0 {
	meta:
		name = "__fputchar"
		size = 21
		refs = "0001 ___iob_func 000e _putc"
	strings:
		$1 = { E8 ?? ?? ?? ?? 83 C0 20 50 FF 74 24 08 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "__flush"
		size = 98
		refs = "002b __fileno 0032 __write"
	strings:
		$1 = { 53 56 8B 74 24 0C 8B 46 0C 8B C8 80 E1 03 33 DB 80 F9 02 75 3F 66 A9 08 01 74 39 8B 46 08 57 8B 3E 2B F8 85 FF 7E 2C 57 50 56 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 75 0F 8B 46 0C 84 C0 79 0F 83 E0 FD 89 46 0C EB 07 83 4E 0C 20 83 CB FF 5F 8B 46 08 83 66 04 00 89 06 5E 8B C3 5B C3 }
	condition:
		$1
}

rule file_320_1_0 {
	meta:
		name = "__fflush_nolock"
		size = 66
		refs = "000b _flsall 0014 __flush 002c __fileno 0032 __commit"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 75 09 56 E8 ?? ?? ?? ?? 59 5E C3 56 E8 ?? ?? ?? ?? 85 C0 59 74 05 83 C8 FF 5E C3 66 F7 46 0C 00 40 74 14 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 59 F7 D8 1B C0 5E C3 33 C0 5E C3 }
	condition:
		$1
}

rule file_320_2_0 {
	meta:
		name = "_flsall"
		size = 218
		refs = "0003 __sehtable$_flsall 0008 __SEH_prolog4 0017 __lock 0026 __nstream 0031 ___piob 0047 __lock_file2 006a __fflush_nolock 00ac __unlock_file2 00cc __SEH_epilog4 00d4 __unlock"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 89 7D DC 6A 01 E8 ?? ?? ?? ?? 59 89 7D FC 33 F6 89 75 E0 3B 35 ?? ?? ?? ?? 0F 8D 83 00 00 00 A1 ?? ?? ?? ?? 8D 04 B0 39 38 74 5E 8B 00 F6 40 0C 83 74 56 50 56 E8 ?? ?? ?? ?? 59 59 33 D2 42 89 55 FC A1 ?? ?? ?? ?? 8B 04 B0 8B 48 0C F6 C1 83 74 2F 39 55 08 75 11 50 E8 ?? ?? ?? ?? 59 83 F8 FF 74 1E FF 45 E4 EB 19 39 7D 08 75 14 F6 C1 02 74 0F 50 E8 ?? ?? ?? ?? 59 83 F8 FF 75 03 09 45 DC 89 7D FC E8 08 00 00 00 46 EB 84 33 FF 8B 75 E0 A1 ?? ?? ?? ?? FF 34 B0 56 E8 ?? ?? ?? ?? 59 59 C3 C7 45 FC FE FF FF FF E8 12 00 00 00 83 7D 08 01 8B 45 E4 74 03 8B 45 DC E8 ?? ?? ?? ?? C3 6A 01 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_320_3_0 {
	meta:
		name = "_fflush"
		size = 83
		refs = "0003 __sehtable$_fflush 0008 __SEH_prolog4 0015 _flsall 0020 __lock_file 002c __fflush_nolock 0044 __SEH_epilog4 004d __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 75 08 75 09 56 E8 ?? ?? ?? ?? 59 EB 27 FF 75 08 E8 ?? ?? ?? ?? 59 89 75 FC FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_321_0_0 {
	meta:
		name = "__byteswap_ulong"
		size = 35
	strings:
		$1 = { 8B 4C 24 04 8B C1 25 00 FF 00 00 8B D1 C1 E2 10 03 C2 33 D2 8A 74 24 06 C1 E0 08 C1 E9 18 03 C2 03 C1 C3 }
	condition:
		$1
}

rule file_321_1_0 {
	meta:
		name = "__byteswap_ushort"
		size = 17
	strings:
		$1 = { 8B 44 24 04 66 0F B6 4C 24 05 C1 E0 08 66 03 C1 C3 }
	condition:
		$1
}

rule file_321_2_0 {
	meta:
		name = "__byteswap_uint64"
		size = 172
		refs = "0023 __allmul"
	strings:
		$1 = { 53 55 56 8B 74 24 14 57 8B 7C 24 14 33 C0 50 68 00 00 01 00 56 8B EF 57 81 E5 00 FF 00 00 89 44 24 24 E8 ?? ?? ?? ?? 03 E8 8B 44 24 14 6A 00 BB 00 00 01 00 53 13 C2 50 55 E8 ?? ?? ?? ?? 8B CF 33 ED 81 E1 00 00 FF 00 55 03 C1 53 13 D5 52 50 E8 ?? ?? ?? ?? 8B CF BB 00 00 00 FF 23 CB 55 03 C1 68 00 01 00 00 13 D5 52 50 E8 ?? ?? ?? ?? 8B CE C1 E9 08 81 E1 00 FF 00 00 03 C1 13 D5 8B CF 8B EE 0F AC E9 08 23 CB 33 DB 03 C1 13 D3 8B CE 0F AC CF 18 81 E7 00 00 FF 00 33 C9 03 C7 13 D1 C1 EE 18 5F 03 C6 5E 5D 13 D1 5B C3 }
	condition:
		$1
}

rule file_323_1_0 {
	meta:
		name = "___pctype_func"
		size = 41
		refs = "0001 __getptd 000c ___ptlocinfo 0014 ___globallocalestatus 001e ___updatetlocinfo"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B C8 8B 41 6C 3B 05 ?? ?? ?? ?? 74 10 8B 15 ?? ?? ?? ?? 85 51 70 75 05 E8 ?? ?? ?? ?? 8B 80 C8 00 00 00 C3 }
	condition:
		$1
}

rule file_324_5_0 {
	meta:
		name = "___wstrgtold12_l"
		size = 1832
		refs = "0007 ___security_cookie 004c __errno 005c __invalid_parameter 00a7 $LN281 038b ___mtold12 03c8 __pow10pos 03df __pow10neg 06ef @__security_check_cookie@4 06f8 $LN119 06fc $LN108 0700 $LN97 0704 $LN88 0708 $LN75 070c $LN61 0710 $LN58 0714 $LN43 0718 $LN49 071c $LN36 0720 $LN258 0724 $LN28"
	strings:
		$1 = { 55 8B EC 83 EC 7C A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 56 33 F6 89 45 84 8B 45 0C 57 33 FF 89 45 90 47 8D 45 E0 33 C9 39 75 24 89 45 A8 89 75 88 89 7D 9C 89 75 B4 89 75 A4 89 75 94 89 75 A0 89 75 98 89 75 B0 89 75 8C 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 7D 06 00 00 8B 55 10 6A 02 89 55 AC 5E 0F B7 02 66 3D 20 00 74 12 66 3D 09 00 74 0C 66 3D 0A 00 74 06 66 3D 0D 00 75 04 03 D6 EB E1 53 6A 30 5B 0F B7 02 03 D6 83 F9 0B 0F 87 67 02 00 00 FF 24 8D ?? ?? ?? ?? 8D 48 CF 66 83 F9 08 77 07 6A 03 59 2B D6 EB DB 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 0F BE 09 0F B7 C0 3B C1 75 05 6A 05 59 EB BF 83 E8 2B 74 1C 2B C6 74 0D 83 E8 03 0F 85 C5 01 00 00 8B CF EB A9 8B CE C7 45 88 00 80 00 00 EB 9E 83 65 88 00 8B CE EB 96 8D 48 CF 66 83 F9 08 89 7D A4 76 A8 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 0F BE 09 0F B7 C0 3B C1 75 04 6A 04 EB AD 83 F8 2B 74 26 83 F8 2D 74 21 3B C3 74 B4 83 F8 43 0F 8E 70 01 00 00 83 F8 45 7E 0B 83 C0 9C 3B C7 0F 87 60 01 00 00 6A 06 EB 82 2B D6 6A 0B E9 79 FF FF FF 8D 48 CF 66 83 F9 08 0F 86 4C FF FF FF 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 0F BE 09 0F B7 C0 3B C1 0F 84 4F FF FF FF 3B C3 0F 84 5E FF FF FF 8B 55 AC E9 47 01 00 00 89 7D A4 EB 23 66 3D 39 00 77 22 83 7D B4 19 73 0F 8B 4D A8 FF 45 B4 2A C3 FF 45 A8 88 01 EB 03 FF 45 B0 0F B7 02 03 D6 66 3B C3 73 D8 8B 4D 24 8B 09 8B 89 BC 00 00 00 8B 09 0F BE 09 0F B7 C0 3B C1 0F 84 48 FF FF FF 83 F8 2B 0F 84 6E FF FF FF 83 F8 2D 0F 84 65 FF FF FF E9 43 FF FF FF 83 7D B4 00 89 7D A4 89 7D 94 75 32 EB 08 FF 4D B0 0F B7 02 03 D6 66 3B C3 74 F3 EB 21 66 3D 39 00 77 20 83 7D B4 19 73 10 FF 45 B4 8B 4D A8 2A C3 FF 45 A8 FF 4D B0 88 01 0F B7 02 03 D6 66 3B C3 73 DA 0F B7 C0 EB A1 83 C0 D0 66 3D 09 00 89 7D 94 0F 87 41 FF FF FF 6A 04 E9 65 FE FF FF 8D 4A FC 89 4D AC 8D 48 CF 66 83 F9 08 77 07 6A 09 E9 4F FE FF FF 0F B7 C0 83 E8 2B 74 20 2B C6 74 10 83 E8 03 0F 85 0F FF FF FF 6A 08 E9 51 FE FF FF 83 4D 9C FF 6A 07 59 E9 07 FE FF FF 6A 07 E9 3E FE FF FF 89 7D A0 EB 05 0F B7 02 03 D6 66 3B C3 74 F6 83 C0 CF 66 3D 08 00 76 B2 2B D6 EB 28 8D 48 CF 66 83 F9 08 76 A5 66 3B C3 EB B6 83 7D 20 00 74 40 0F B7 C0 83 E8 2B 8D 4A FE 89 4D AC 74 BB 2B C6 74 AB 8B D1 83 7D A4 00 8B 45 90 89 10 0F 84 B8 03 00 00 6A 18 58 39 45 B4 76 73 80 7D F7 05 7C 03 FE 45 F7 89 45 B4 8B 45 A8 48 FF 45 B0 EB 61 6A 0A 59 2B D6 83 F9 0A 0F 85 82 FD FF FF EB C4 89 7D A0 33 C9 EB 1D 66 3D 39 00 77 23 6B C9 0A 0F B7 F8 8D 4C 39 D0 81 F9 50 14 00 00 7F 0C 0F B7 02 03 D6 66 3B C3 73 DE EB 05 B9 51 14 00 00 89 4D 98 EB 0F 66 3D 39 00 0F 87 59 FF FF FF 0F B7 02 03 D6 66 3B C3 73 EC E9 4A FF FF FF 8B 45 A8 83 7D B4 00 0F 86 57 03 00 00 EB 06 FF 4D B4 FF 45 B0 48 80 38 00 74 F4 8D 45 C4 50 FF 75 B4 8D 45 E0 50 E8 ?? ?? ?? ?? 8B 45 98 33 C9 83 C4 0C 39 4D 9C 7D 02 F7 D8 03 45 B0 39 4D A0 75 03 03 45 18 39 4D 94 75 03 2B 45 1C 3D 50 14 00 00 0F 8F EE 02 00 00 3D B0 EB FF FF 0F 8C FA 02 00 00 BE ?? ?? ?? ?? 83 EE 60 3B C1 89 45 AC 0F 84 B5 02 00 00 7D 0D F7 D8 BE ?? ?? ?? ?? 89 45 AC 83 EE 60 39 4D 14 75 04 66 89 4D C4 39 4D AC 0F 84 94 02 00 00 8B 45 AC C1 7D AC 03 83 C6 54 83 E0 07 85 C0 89 75 B0 0F 84 72 02 00 00 6B C0 0C 03 C6 8B D8 66 81 3B 00 80 89 5D 90 72 14 8B F3 8D 7D B8 A5 A5 A5 FF 4D BA 8B 75 B0 8D 5D B8 89 5D 90 0F B7 53 0A 8B 4D CE 33 C0 89 45 A8 89 45 D4 89 45 D8 89 45 DC 8B C2 BF FF 7F 00 00 33 C1 23 CF 23 D7 25 00 80 00 00 66 81 F9 FF 7F 8D 3C 0A 0F B7 FF 0F 83 FB 01 00 00 66 81 FA FF 7F 0F 83 F0 01 00 00 66 81 FF FD BF 0F 87 E5 01 00 00 66 81 FF BF 3F 77 0D 33 C0 89 45 C8 89 45 C4 E9 E8 01 00 00 66 85 C9 75 1F 47 F7 45 CC FF FF FF 7F 75 15 83 7D C8 00 75 0F 83 7D C4 00 75 09 66 21 4D CE E9 C7 01 00 00 33 C9 66 3B D1 75 21 47 F7 43 08 FF FF FF 7F 75 17 39 4B 04 75 12 39 0B 75 0E 89 4D CC 89 4D C8 89 4D C4 E9 9F 01 00 00 21 4D 9C 8D 75 D8 C7 45 A4 05 00 00 00 8B 4D 9C 8B 55 A4 03 C9 85 D2 89 55 98 7E 55 8D 4C 0D C4 83 C3 08 89 4D 94 89 5D A0 8B 4D 94 8B 55 A0 0F B7 12 0F B7 09 83 65 B4 00 0F AF CA 8B 56 FC 8D 1C 0A 3B DA 72 04 3B D9 73 07 C7 45 B4 01 00 00 00 83 7D B4 00 89 5E FC 74 03 66 FF 06 83 45 94 02 83 6D A0 02 FF 4D 98 83 7D 98 00 7F BB 8B 5D 90 46 46 FF 45 9C FF 4D A4 83 7D A4 00 7F 8E 81 C7 02 C0 00 00 66 85 FF 7E 3B F7 45 DC 00 00 00 80 75 2D 8B 75 D8 8B 4D D4 D1 65 D4 C1 E9 1F 8B D6 03 F6 0B F1 8B 4D DC C1 EA 1F 03 C9 0B CA 81 C7 FF FF 00 00 66 85 FF 89 75 D8 89 4D DC 7F CA 66 85 FF 7F 4E 81 C7 FF FF 00 00 66 85 FF 7D 43 8B CF F7 D9 0F B7 F1 03 FE F6 45 D4 01 74 03 FF 45 A8 8B 4D DC 8B 5D D8 8B 55 D8 D1 6D DC C1 E1 1F D1 EB 0B D9 8B 4D D4 C1 E2 1F D1 E9 0B CA 4E 89 5D D8 89 4D D4 75 D1 83 7D A8 00 74 05 66 83 4D D4 01 66 81 7D D4 00 80 77 11 8B 4D D4 81 E1 FF FF 01 00 81 F9 00 80 01 00 75 33 83 7D D6 FF 75 2A 83 65 D6 00 83 7D DA FF 75 1B 83 65 DA 00 66 81 7D DE FF FF 75 09 66 C7 45 DE 00 80 47 EB 0E 66 FF 45 DE EB 08 FF 45 DA EB 03 FF 45 D6 66 81 FF FF 7F 8B 75 B0 73 1C 66 8B 4D D6 66 89 4D C4 8B 4D D8 89 4D C6 8B 4D DC 0B F8 89 4D CA 66 89 7D CE EB 1A 66 F7 D8 1B C0 83 65 C8 00 25 00 00 00 80 05 00 80 FF 7F 83 65 C4 00 89 45 CC 83 7D AC 00 0F 85 6C FD FF FF 8B 45 CC 0F B7 4D C4 8B 75 C6 8B 55 CA C1 E8 10 EB 2F C7 45 8C 04 00 00 00 EB 1E 33 F6 B8 FF 7F 00 00 BA 00 00 00 80 33 C9 C7 45 8C 02 00 00 00 EB 0F C7 45 8C 01 00 00 00 33 C9 33 C0 33 D2 33 F6 8B 7D 84 0B 45 88 66 89 0F 66 89 47 0A 8B 45 8C 89 77 02 89 57 06 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_325_6_0 {
	meta:
		name = "?_wcsftime_l_stat@@YAIPA_WIPB_WPBUtm@@PAUlocaleinfo_struct@@@Z"
		size = 464
		refs = "0007 ___security_cookie 0020 __errno 0030 __invalid_parameter 0053 _wcslen 0076 __alloca_probe_16 008a _malloc 0106 __wcstombs_s_l 0125 __invoke_watson 0143 __Strftime_l 015f __mbstowcs_s_l 01a3 __freea 01ca @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 53 33 DB 3B C3 56 57 89 5D F8 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 80 01 00 00 8B 7D 0C 3B FB 74 DA 76 03 66 89 18 39 5D 10 74 D0 FF 75 10 E8 ?? ?? ?? ?? 8B F0 8D 47 FF BF EF FF FF 7F 46 3B C7 59 77 3A 8B 45 0C 8D 44 00 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 3B C3 59 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 F0 EB 03 89 5D F0 39 5D F0 74 8E 8D 46 FF 3B C7 77 37 8D 44 36 08 3D 00 04 00 00 77 13 E8 ?? ?? ?? ?? 8B C4 3B C3 74 1C C7 00 CC CC 00 00 EB 11 50 E8 ?? ?? ?? ?? 3B C3 59 74 09 C7 00 DD DD 00 00 83 C0 08 89 45 F4 EB 03 89 5D F4 39 5D F4 0F 84 B5 00 00 00 FF 75 18 8D 04 36 8D 48 FF 51 FF 75 10 50 FF 75 F4 53 E8 ?? ?? ?? ?? 83 C4 18 3B C3 74 1D 83 F8 16 74 09 83 F8 22 0F 85 80 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 71 FF 75 18 8B 75 0C 53 FF 75 14 8D 04 36 FF 75 F4 50 FF 75 F0 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 4E FF 75 18 8D 45 F8 6A FF FF 75 F0 56 FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 18 3B C3 74 28 83 F8 16 6A 22 5F 74 04 3B C7 75 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 39 75 F8 72 07 E8 ?? ?? ?? ?? 89 38 89 5D F8 39 5D F8 76 08 FF 4D F8 EB 03 89 5D F8 FF 75 F4 E8 ?? ?? ?? ?? 59 FF 75 F0 E8 ?? ?? ?? ?? 8B 45 F8 3B C3 59 75 06 8B 4D 08 66 89 19 8D 65 E4 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_325_7_0 {
	meta:
		name = "__wcsftime_l"
		size = 56
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0022 ?_wcsftime_l_stat@@YAIPA_WIPB_WPBUtm@@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 18 8D 4D F0 E8 ?? ?? ?? ?? 8D 45 F0 50 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_325_8_0 {
	meta:
		name = "_wcsftime"
		size = 27
		refs = "0013 __wcsftime_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_696_6_0 {
	meta:
		name = "__aligned_recalloc"
		size = 27
		refs = "0013 __aligned_offset_recalloc"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_610_20_0 {
	meta:
		name = "__cftof"
		size = 27
		refs = "0013 __cftof_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_334_0_0 {
	meta:
		name = "__mbccpy_s"
		size = 27
		refs = "0013 __mbccpy_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_801_0_0 {
	meta:
		name = "__mbsnbcat_s"
		size = 27
		refs = "0013 __mbsnbcat_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_917_0_0 {
	meta:
		name = "__mbsnbcpy_s"
		size = 27
		refs = "0013 __mbsnbcpy_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_898_0_0 {
	meta:
		name = "__mbsnbset_s"
		size = 27
		refs = "0013 __mbsnbset_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_902_0_0 {
	meta:
		name = "__mbsncat_s"
		size = 27
		refs = "0013 __mbsncat_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_825_0_0 {
	meta:
		name = "__mbsncpy_s"
		size = 27
		refs = "0013 __mbsncpy_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_373_0_0 {
	meta:
		name = "__mbsnset_s"
		size = 27
		refs = "0013 __mbsnset_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_444_4_0 {
	meta:
		name = "_wctomb_s"
		size = 27
		refs = "0013 __wctomb_s_l"
	strings:
		$1 = { 6A 00 FF 74 24 14 FF 74 24 14 FF 74 24 14 FF 74 24 14 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_327_1_0 {
	meta:
		name = "__resetstkoflw"
		size = 300
		refs = "0007 ___security_cookie 001c __alloca_probe 002e __imp__VirtualQuery@12 0046 __imp__GetSystemInfo@4 0057 __get_osplatform 0066 __invoke_watson 0074 ??_C@_0N@MDJJJHMB@kernel32?4dll?$AA@ 007a __imp__GetModuleHandleA@4 0083 ??_C@_0BI@BKLFFAPO@SetThreadStackGuarantee?$AA@ 008a __imp__GetProcAddress@8 00fa __imp__VirtualAlloc@16 010b __imp__VirtualProtect@16 0126 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 5C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 6A 04 33 FF 58 89 7D F8 E8 ?? ?? ?? ?? 89 65 F0 6A 1C 8D 45 C8 50 FF 75 F0 FF 15 ?? ?? ?? ?? 85 C0 0F 84 DE 00 00 00 8B 45 CC 89 45 E8 8D 45 A4 50 FF 15 ?? ?? ?? ?? 8B 75 A8 8D 45 F8 50 89 75 EC 33 DB E8 ?? ?? ?? ?? 85 C0 59 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 83 7D F8 02 75 36 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 3B C7 74 27 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 3B C7 74 17 8D 4D F4 51 89 7D F4 FF D0 83 F8 01 59 75 08 39 7D F4 76 03 8B 5D F4 8B 7D F8 4F F7 DF 1B FF 81 E7 03 01 00 00 8D 46 FF 8D 5C 33 FF F7 D0 47 23 D8 74 02 03 DE 8D 04 36 3B D8 73 02 8B D8 4E F7 D6 23 75 F0 2B F3 83 7D F8 01 75 05 6A 11 58 EB 03 8B 45 EC 8B 4D E8 03 C1 3B F0 72 29 6A 04 68 00 10 00 00 53 56 FF 15 ?? ?? ?? ?? 85 C0 74 16 8D 45 E4 50 57 53 56 FF 15 ?? ?? ?? ?? 85 C0 74 05 33 C0 40 EB 02 33 C0 8D 65 98 5F 5E 5B 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "__telli64"
		size = 19
		refs = "000b __lseeki64"
	strings:
		$1 = { 6A 01 6A 00 6A 00 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_330_3_0 {
	meta:
		name = "__wcsicoll_l"
		size = 223
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001d __errno 002d __invalid_parameter 00b1 ___crtCompareStringW"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 08 33 DB 3B F3 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 91 00 00 00 8B 55 0C 3B D3 74 CB 8B 45 F0 8B 48 10 3B CB 75 42 0F B7 06 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 0F B7 C8 0F B7 02 66 3D 41 00 72 09 66 3D 5A 00 77 03 83 C0 20 46 46 42 42 66 3B CB 0F B7 C0 74 05 66 3B C8 74 C8 0F B7 D0 0F B7 C1 2B C2 EB 32 FF 70 04 8D 45 F0 6A FF 52 6A FF 56 68 01 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 10 E8 ?? ?? ?? ?? C7 00 16 00 00 00 E9 68 FF FF FF 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "_wcsncat"
		size = 61
	strings:
		$1 = { 55 8B EC 8B 4D 08 8B C1 66 8B 11 41 41 66 85 D2 75 F6 49 49 83 7D 10 00 56 74 1B 8B 75 0C 0F B7 16 FF 4D 10 66 89 11 41 41 46 46 66 85 D2 74 0A 83 7D 10 00 75 E8 66 83 21 00 5E 5D C3 }
	condition:
		$1
}

rule file_332_1_0 {
	meta:
		name = "_xcptlookup"
		size = 50
		refs = "0006 __XcptActTabCount"
	strings:
		$1 = { 8B 44 24 04 8B 0D ?? ?? ?? ?? 56 39 10 74 10 8B F1 6B F6 0C 03 74 24 08 83 C0 0C 3B C6 72 EC 6B C9 0C 03 4C 24 08 5E 3B C1 73 04 39 10 74 02 33 C0 C3 }
	condition:
		$1
}

rule file_332_2_0 {
	meta:
		name = "__XcptFilter"
		size = 367
		refs = "0007 __getptd_noexit 0016 __imp__UnhandledExceptionFilter@4 0023 __XcptActTabCount 00a3 __First_FPE_Indx 00a9 __Num_FPE"
	strings:
		$1 = { 55 8B EC 51 51 56 E8 ?? ?? ?? ?? 8B F0 85 F6 75 0E FF 75 0C FF 15 ?? ?? ?? ?? E9 4D 01 00 00 8B 56 5C A1 ?? ?? ?? ?? 57 8B 7D 08 8B CA 53 39 39 74 0E 8B D8 6B DB 0C 83 C1 0C 03 DA 3B CB 72 EE 6B C0 0C 03 C2 3B C8 73 08 39 39 75 04 8B C1 EB 02 33 C0 85 C0 74 0A 8B 58 08 85 DB 89 5D FC 75 0E FF 75 0C FF 15 ?? ?? ?? ?? E9 FB 00 00 00 83 FB 05 75 0C 83 60 08 00 33 C0 40 E9 EA 00 00 00 83 FB 01 0F 84 DE 00 00 00 8B 4E 60 89 4D F8 8B 4D 0C 89 4E 60 8B 48 04 83 F9 08 0F 85 B8 00 00 00 8B 0D ?? ?? ?? ?? 8B 3D ?? ?? ?? ?? 8B D1 03 F9 3B D7 7D 24 6B C9 0C 8B 7E 5C 83 64 39 08 00 8B 3D ?? ?? ?? ?? 8B 1D ?? ?? ?? ?? 42 03 DF 83 C1 0C 3B D3 7C E2 8B 5D FC 8B 00 3D 8E 00 00 C0 8B 7E 64 75 09 C7 46 64 83 00 00 00 EB 5E 3D 90 00 00 C0 75 09 C7 46 64 81 00 00 00 EB 4E 3D 91 00 00 C0 75 09 C7 46 64 84 00 00 00 EB 3E 3D 93 00 00 C0 75 09 C7 46 64 85 00 00 00 EB 2E 3D 8D 00 00 C0 75 09 C7 46 64 82 00 00 00 EB 1E 3D 8F 00 00 C0 75 09 C7 46 64 86 00 00 00 EB 0E 3D 92 00 00 C0 75 07 C7 46 64 8A 00 00 00 FF 76 64 6A 08 FF D3 59 89 7E 64 EB 07 83 60 08 00 51 FF D3 8B 45 F8 59 89 46 60 83 C8 FF 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_332_3_0 {
	meta:
		name = "___CppXcptFilter"
		size = 27
		refs = "0011 __XcptFilter"
	strings:
		$1 = { B8 63 73 6D E0 39 44 24 04 75 0D FF 74 24 08 50 E8 ?? ?? ?? ?? 59 59 C3 33 C0 C3 }
	condition:
		$1
}

rule file_333_7_0 {
	meta:
		name = "___tmainCRTStartup"
		size = 479
		refs = "0003 __sehtable$___tmainCRTStartup 0008 __SEH_prolog4 0016 __imp__GetStartupInfoW@4 002b __imp__GetProcessHeap@0 0034 __imp__HeapAlloc@12 0041 _fast_error_exit 0050 __imp__GetVersionExA@4 0060 __imp__HeapFree@12 00aa __osplatform 00af __winver 00b5 __winmajor 00bb __winminor 00c1 __osver 00c6 _check_managed_app 00d2 __heap_init 00e4 __mtinit 00f5 __RTC_Initialize 00fd __ioinit 0108 __amsg_exit 010e ___crtGetCommandLineW 0113 __wcmdln 0118 ___crtGetEnvironmentStringsW 011d __wenvptr 0122 __wsetargv 0133 __wsetenvp 0145 __cinit 0156 __wwincmdln 016d ___ImageBase 0172 _wWinMain@16 0181 _exit 0186 __cexit 0199 __XcptFilter 01b1 __exit 01b6 __c_exit 01da __SEH_epilog4"
	strings:
		$1 = { 6A 60 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 8D 45 90 50 FF 15 ?? ?? ?? ?? C7 45 FC FE FF FF FF BF 94 00 00 00 57 6A 00 8B 1D ?? ?? ?? ?? FF D3 50 FF 15 ?? ?? ?? ?? 8B F0 85 F6 75 0D 6A 12 E8 ?? ?? ?? ?? 59 E9 89 01 00 00 89 3E 56 FF 15 ?? ?? ?? ?? 56 6A 00 85 C0 75 0E FF D3 50 FF 15 ?? ?? ?? ?? E9 6B 01 00 00 8B 46 10 89 45 E0 8B 46 04 89 45 DC 8B 46 08 89 45 D8 8B 7E 0C 81 E7 FF 7F 00 00 FF D3 50 FF 15 ?? ?? ?? ?? 8B 75 E0 83 FE 02 74 06 81 CF 00 80 00 00 8B 4D DC 8B C1 C1 E0 08 8B 55 D8 03 C2 89 35 ?? ?? ?? ?? A3 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 15 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E0 33 DB 43 53 E8 ?? ?? ?? ?? 59 85 C0 75 08 6A 1C E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 75 08 6A 10 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 89 5D FC E8 ?? ?? ?? ?? 85 C0 7D 08 6A 1B E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? A3 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 7D 08 6A 08 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 85 C0 7D 08 6A 09 E8 ?? ?? ?? ?? 59 53 E8 ?? ?? ?? ?? 59 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 84 5D BC 74 06 0F B7 4D C0 EB 03 6A 0A 59 51 50 6A 00 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E4 83 7D E0 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? EB 2E 8B 45 EC 8B 08 8B 09 89 4D D4 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 8B 45 D4 89 45 E4 83 7D E0 00 75 06 50 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E4 EB 13 33 C0 40 C3 8B 65 E8 C7 45 FC FE FF FF FF B8 FF 00 00 00 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "__CallSettingFrame@12"
		size = 76
		refs = "001f __NLG_Notify1"
	strings:
		$1 = { 55 8B EC 83 EC 04 53 51 8B 45 0C 83 C0 0C 89 45 FC 8B 45 08 55 FF 75 10 8B 4D 10 8B 6D FC E8 ?? ?? ?? ?? 56 57 FF D0 5F 5E 8B DD 5D 8B 4D 10 55 8B EB 81 F9 00 01 00 00 75 05 B9 02 00 00 00 51 E8 ?? ?? ?? ?? 5D 59 5B C9 C2 0C 00 }
	condition:
		$1
}

rule file_337_0_0 {
	meta:
		name = "_strstr"
		size = 134
		refs = "0075 ___from_strstr_to_strchr"
	strings:
		$1 = { 8B 4C 24 08 57 53 56 8A 11 8B 7C 24 10 84 D2 74 6F 8A 71 01 84 F6 74 55 8B F7 8B 4C 24 14 8A 07 83 C6 01 3A C2 74 17 84 C0 74 0D 8A 06 83 C6 01 3A C2 74 0A 84 C0 75 F3 5E 5B 5F 33 C0 C3 8A 06 83 C6 01 3A C6 75 E9 8D 7E FF 8A 61 02 84 E4 74 28 8A 06 83 C6 02 3A C4 75 BE 8A 41 03 84 C0 74 18 8A 66 FF 83 C1 02 3A C4 74 DF EB AB 33 C0 5E 5B 5F 8A C2 E9 ?? ?? ?? ?? 8D 47 FF 5E 5B 5F C3 8B C7 5E 5B 5F C3 }
	condition:
		$1
}

rule file_338_3_0 {
	meta:
		name = "__mbctoupper_l"
		size = 164
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0064 ___crtLCMapStringA"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 FF 75 0C 8D 4D E8 E8 ?? ?? ?? ?? 8B 5D 08 81 FB FF 00 00 00 76 61 8B C3 C1 E8 08 0F B6 C8 88 45 FC 8B 45 EC 88 5D FD F6 44 01 1D 04 75 11 80 7D F4 00 74 07 8B 45 F0 83 60 70 FD 8B C3 EB 5B 6A 01 FF 70 04 8D 4D F8 6A 02 51 6A 02 8D 4D FC 51 68 00 02 00 00 FF 70 0C 8D 45 E8 50 E8 ?? ?? ?? ?? 83 C4 24 85 C0 74 C6 0F B6 45 F8 0F B6 4D F9 C1 E0 08 03 C1 EB 16 8B 45 EC 03 C3 F6 40 1D 20 74 09 0F B6 80 1D 01 00 00 EB 02 8B C3 80 7D F4 00 74 07 8B 4D F0 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_339_0_0 {
	meta:
		name = "_strlen"
		size = 139
	strings:
		$1 = { 8B 4C 24 04 F7 C1 03 00 00 00 74 24 8A 01 83 C1 01 84 C0 74 4E F7 C1 03 00 00 00 75 EF 05 00 00 00 00 8D A4 24 00 00 00 00 8D A4 24 00 00 00 00 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 32 84 E4 74 24 A9 00 00 FF 00 74 13 A9 00 00 00 FF 74 02 EB CD 8D 41 FF 8B 4C 24 04 2B C1 C3 8D 41 FE 8B 4C 24 04 2B C1 C3 8D 41 FD 8B 4C 24 04 2B C1 C3 8D 41 FC 8B 4C 24 04 2B C1 C3 }
	condition:
		$1
}

rule file_340_1_0 {
	meta:
		name = "_init_namebuf"
		size = 197
		refs = "0018 _tmpnam_s_buf 001f _tmpfile_buf 0029 _tmpnam_buf 0035 ??_C@_01KICIPPFI@?2?$AA@ 003c _strcpy_s 004d __invoke_watson 0082 __getpid 0088 __ultoa_s 00a1 ??_C@_01LFCBOECM@?4?$AA@ 00a8 _strcat_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 53 56 57 33 DB 33 FF 2B C3 74 17 48 74 0A 48 75 1A BE ?? ?? ?? ?? EB 05 BE ?? ?? ?? ?? 6A 12 5F EB 0C BE ?? ?? ?? ?? 6A 0E EB F4 8B 75 08 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 46 01 8A 48 FF 80 F9 5C 74 09 80 F9 2F 74 04 C6 00 5C 40 83 7D 08 01 75 05 C6 00 74 EB 03 C6 00 73 40 8B CE 2B C8 6A 20 03 CF 51 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_340_2_0 {
	meta:
		name = "_genfname"
		size = 144
		refs = "0007 ___security_cookie 0019 __mbsrchr 0027 _strtoul 0043 __ultoa_s 0054 __invoke_watson 0067 _strcpy_s 008a @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 0C A1 ?? ?? ?? ?? 33 C5 89 45 FC 53 56 57 8B F9 6A 2E 57 E8 ?? ?? ?? ?? 8B F0 6A 20 33 DB 46 53 56 E8 ?? ?? ?? ?? 83 C4 14 40 3B 45 0C 72 05 83 C8 FF EB 48 6A 20 6A 08 8D 4D F4 51 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 45 F4 2B FE 03 7D 08 50 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_340_4_0 {
	meta:
		name = "__tmpnam_helper"
		size = 319
		refs = "0003 __sehtable$__tmpnam_helper 0008 __SEH_prolog4 0012 __errno 001e __mtinitlocknum 003b __lock 0049 _tmpnam_buf 0052 _tmpnam_s_buf 0061 _init_namebuf 006f _genfname 0080 __access_s 0092 __getptd_noexit 00ad __malloc_crt 00cb _strlen 00eb _strcpy_s 00fc __invoke_watson 012c __unlock 013a __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 E8 ?? ?? ?? ?? 8B 00 89 45 E0 6A 02 E8 ?? ?? ?? ?? 59 85 C0 75 11 8B 45 18 89 18 E8 ?? ?? ?? ?? 8B 00 E9 01 01 00 00 6A 02 E8 ?? ?? ?? ?? 59 89 5D FC 39 5D 10 75 09 BF ?? ?? ?? ?? 6A 0E EB 07 BF ?? ?? ?? ?? 6A 12 5E 38 1F 75 0B FF 75 10 E8 ?? ?? ?? ?? 59 EB 15 FF 75 14 56 8B CF E8 ?? ?? ?? ?? 59 85 C0 59 0F 85 86 00 00 00 53 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 DE 8B 75 08 3B F3 75 33 E8 ?? ?? ?? ?? 8B F0 3B F3 75 09 C7 45 E4 0C 00 00 00 EB 5E 39 5E 2C 75 0F 6A 0E E8 ?? ?? ?? ?? 59 89 46 2C 3B C3 74 E3 8B 76 2C 89 75 08 57 6A 0E EB 25 39 5D 10 74 1C 57 E8 ?? ?? ?? ?? 59 3B 45 0C 72 10 C7 45 E4 22 00 00 00 39 5D 0C 74 22 88 1E EB 1E 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 C7 45 FC FE FF FF FF E8 1A 00 00 00 8B 45 18 8B 4D 08 89 08 8B 75 E4 E8 ?? ?? ?? ?? 3B F3 74 0F 89 30 EB 10 33 DB 6A 02 E8 ?? ?? ?? ?? 59 C3 8B 4D E0 89 08 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_340_5_0 {
	meta:
		name = "_tmpnam_s"
		size = 68
		refs = "000c __errno 001c __invalid_parameter 003a __tmpnam_helper"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 19 8D 45 08 50 68 FF FF FF 7F 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5E 5D C3 }
	condition:
		$1
}

rule file_381_4_0 {
	meta:
		name = "__wtmpnam_s"
		size = 68
		refs = "000c __errno 001c __invalid_parameter 003a __wtmpnam_helper"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 75 08 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 EB 19 8D 45 08 50 68 FF FF FF 7F 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5E 5D C3 }
	condition:
		$1
}

rule file_340_6_0 {
	meta:
		name = "_tmpnam"
		size = 37
		refs = "0019 __tmpnam_helper"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 8D 45 FC 50 68 FF 7F 00 00 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_381_5_0 {
	meta:
		name = "__wtmpnam"
		size = 37
		refs = "0019 __wtmpnam_helper"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 8D 45 FC 50 68 FF 7F 00 00 6A 00 6A FF FF 75 08 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_340_7_0 {
	meta:
		name = "__tmpfile_helper"
		size = 544
		refs = "0003 __sehtable$__tmpfile_helper 0008 __SEH_prolog4 0023 __errno 0032 __invalid_parameter 0043 __mtinitlocknum 005b __lock 0064 _tmpfile_buf 0075 ??_C@_01KICIPPFI@?2?$AA@ 007d _strcpy_s 008e __invoke_watson 00cf __getpid 00d5 __ultoa_s 00ee ??_C@_01LFCBOECM@?4?$AA@ 00f6 _strcat_s 011a _genfname 0129 __getstream 016d __sopen_s 01a8 __strdup 01b8 __close 01c8 __commode 0201 __SEH_epilog4 0212 __unlock_file 021a __unlock"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D D4 89 5D D8 33 C9 8B 45 08 3B C3 0F 95 C1 3B CB 75 1C E8 ?? ?? ?? ?? 6A 16 5E 89 30 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E9 C0 01 00 00 89 18 6A 02 E8 ?? ?? ?? ?? 59 85 C0 75 0C E8 ?? ?? ?? ?? 8B 00 E9 A8 01 00 00 6A 02 E8 ?? ?? ?? ?? 59 89 5D FC BF ?? ?? ?? ?? 38 1D ?? ?? ?? ?? 0F 85 9C 00 00 00 68 ?? ?? ?? ?? 6A 12 57 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 C7 45 E4 ?? ?? ?? ?? A0 ?? ?? ?? ?? 3C 5C 74 12 3C 2F 74 0E C6 05 ?? ?? ?? ?? 5C C7 45 E4 ?? ?? ?? ?? 8B 45 E4 C6 00 74 FF 45 E4 6A 20 B8 ?? ?? ?? ?? 2B 45 E4 50 FF 75 E4 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 6A 12 57 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 27 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 18 68 FF FF FF 7F 6A 12 8B CF E8 ?? ?? ?? ?? 59 59 85 C0 0F 85 B9 00 00 00 E8 ?? ?? ?? ?? 8B F0 89 75 DC 3B F3 75 0C C7 45 D4 18 00 00 00 E9 A2 00 00 00 C7 45 D8 01 00 00 00 E8 ?? ?? ?? ?? 8B 00 89 45 D0 E8 ?? ?? ?? ?? 89 18 68 80 01 00 00 FF 75 0C 68 42 85 00 00 57 8D 45 E0 50 E8 ?? ?? ?? ?? 83 C4 14 83 F8 11 75 14 68 FF FF FF 7F 6A 12 8B CF E8 ?? ?? ?? ?? 59 59 85 C0 74 CD E8 ?? ?? ?? ?? 39 18 75 0A E8 ?? ?? ?? ?? 8B 4D D0 89 08 83 7D E0 FF 74 3E 57 E8 ?? ?? ?? ?? 59 89 46 1C 3B C3 75 0B FF 75 E0 E8 ?? ?? ?? ?? 59 EB 25 89 5E 04 89 1E 89 5E 08 A1 ?? ?? ?? ?? 0D 80 00 00 00 89 46 0C 8B 45 E0 89 46 10 8B 45 08 89 30 EB 03 8B 75 DC C7 45 FC FE FF FF FF E8 1B 00 00 00 8B 75 D4 3B F3 74 07 E8 ?? ?? ?? ?? 89 30 8B C6 E8 ?? ?? ?? ?? C3 33 DB 8B 75 DC 39 5D D8 74 07 56 E8 ?? ?? ?? ?? 59 6A 02 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_340_8_0 {
	meta:
		name = "_tmpfile"
		size = 26
		refs = "000f __tmpfile_helper"
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 8D 45 FC 6A 40 50 E8 ?? ?? ?? ?? 8B 45 FC 59 59 C9 C3 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "__vsprintf_l"
		size = 124
		refs = "000f __errno 001f __invalid_parameter 0055 __output_l 0070 __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 33 DB 39 5D 0C 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 4E 8B 45 08 3B C3 74 DC 56 FF 75 14 89 45 E8 FF 75 10 89 45 E0 FF 75 0C 8D 45 E0 50 C7 45 E4 FF FF FF 7F C7 45 EC 42 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 FF 4D E4 8B F0 78 07 8B 45 E0 88 18 EB 0C 8D 45 E0 50 53 E8 ?? ?? ?? ?? 59 59 8B C6 5E 5B C9 C3 }
	condition:
		$1
}

rule file_341_1_0 {
	meta:
		name = "_vsprintf"
		size = 23
		refs = "000f __vsprintf_l"
	strings:
		$1 = { FF 74 24 0C 6A 00 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_606_1_0 {
	meta:
		name = "__vswprintf"
		size = 23
		refs = "000f __vswprintf_l"
	strings:
		$1 = { FF 74 24 0C 6A 00 FF 74 24 10 FF 74 24 10 E8 ?? ?? ?? ?? 83 C4 10 C3 }
	condition:
		$1
}

rule file_341_2_0 {
	meta:
		name = "__vscprintf_helper"
		size = 85
		refs = "000f __errno 001f __invalid_parameter"
		altNames = "__vscwprintf_helper"
	strings:
		$1 = { 55 8B EC 83 EC 20 56 33 F6 39 75 0C 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 27 FF 75 14 8D 45 E0 FF 75 10 C7 45 E4 FF FF FF 7F FF 75 0C C7 45 EC 42 00 00 00 50 89 75 E8 89 75 E0 FF 55 08 83 C4 10 5E C9 C3 }
	condition:
		$1
}

rule file_345_0_0 {
	meta:
		name = "_strncmp"
		size = 190
	strings:
		$1 = { 55 8B EC 51 83 65 FC 00 53 8B 5D 10 85 DB 75 07 33 C0 E9 9A 00 00 00 83 FB 04 57 72 75 8D 7B FC 85 FF 76 6E 8B 4D 0C 8B 45 08 8A 10 83 C0 04 83 C1 04 84 D2 74 52 3A 51 FC 75 4D 8A 50 FD 84 D2 74 3C 3A 51 FD 75 37 8A 50 FE 84 D2 74 26 3A 51 FE 75 21 8A 50 FF 84 D2 74 10 3A 51 FF 75 0B 83 45 FC 04 39 7D FC 72 C2 EB 3F 0F B6 40 FF 0F B6 49 FF EB 46 0F B6 40 FE 0F B6 49 FE EB 3C 0F B6 40 FD 0F B6 49 FD EB 32 0F B6 40 FC 0F B6 49 FC EB 28 8B 4D 0C 8B 45 08 EB 0F 8A 10 84 D2 74 14 3A 11 75 10 40 41 FF 45 FC 39 5D FC 72 EC 33 C0 5F 5B C9 C3 0F B6 00 0F B6 09 2B C1 EB F2 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "__amsg_exit"
		size = 36
		refs = "0001 __FF_MSGBANNER 000a __NMSG_WRITE 0010 __aexit_rtn 0015 __decode_pointer"
	strings:
		$1 = { E8 ?? ?? ?? ?? FF 74 24 04 E8 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 FF 00 00 00 FF D0 83 C4 0C C3 }
	condition:
		$1
}

rule file_346_1_0 {
	meta:
		name = "___crtCorExitProcess"
		size = 38
		refs = "0001 ??_C@_0M@MBOPBNBK@mscoree?4dll?$AA@ 0007 __imp__GetModuleHandleA@4 0010 ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 0017 __imp__GetProcAddress@8"
	strings:
		$1 = { 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 74 16 68 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? 85 C0 74 06 FF 74 24 04 FF D0 C3 }
	condition:
		$1
}

rule file_346_2_0 {
	meta:
		name = "___crtExitProcess"
		size = 21
		refs = "0005 ___crtCorExitProcess 0010 __imp__ExitProcess@4"
	strings:
		$1 = { FF 74 24 04 E8 ?? ?? ?? ?? 59 FF 74 24 04 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_346_5_0 {
	meta:
		name = "__initterm"
		size = 24
	strings:
		$1 = { 56 8B F0 EB 0B 8B 06 85 C0 74 02 FF D0 83 C6 04 3B 74 24 08 72 EF 5E C3 }
	condition:
		$1
}

rule file_346_6_0 {
	meta:
		name = "__initterm_e"
		size = 32
	strings:
		$1 = { 56 8B 74 24 08 33 C0 EB 0F 85 C0 75 11 8B 0E 85 C9 74 02 FF D1 83 C6 04 3B 74 24 0C 72 EB 5E C3 }
	condition:
		$1
}

rule file_346_7_0 {
	meta:
		name = "__get_osplatform"
		size = 55
		refs = "000c __errno 001c __invalid_parameter 0029 __osplatform"
	strings:
		$1 = { 8B 4C 24 04 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 A1 ?? ?? ?? ?? 3B C6 74 DA 89 01 33 C0 5E C3 }
	condition:
		$1
}

rule file_346_13_0 {
	meta:
		name = "__get_pgmptr"
		size = 55
		refs = "000c __errno 001c __invalid_parameter 0029 __pgmptr"
	strings:
		$1 = { 8B 4C 24 04 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 A1 ?? ?? ?? ?? 3B C6 74 DA 89 01 33 C0 5E C3 }
	condition:
		$1
}

rule file_346_12_0 {
	meta:
		name = "__get_wpgmptr"
		size = 55
		refs = "000c __errno 001c __invalid_parameter 0029 __wpgmptr"
	strings:
		$1 = { 8B 4C 24 04 56 33 F6 3B CE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 A1 ?? ?? ?? ?? 3B C6 74 DA 89 01 33 C0 5E C3 }
	condition:
		$1
}

rule file_346_8_0 {
	meta:
		name = "__get_osver"
		size = 60
		refs = "000c __errno 001c __invalid_parameter 002a __osplatform 0032 __osver"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 39 35 ?? ?? ?? ?? 74 DB 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E C3 }
	condition:
		$1
}

rule file_826_2_0 {
	meta:
		name = "__get_amblksiz"
		size = 60
		refs = "000c __errno 001c __invalid_parameter 002a __crtheap 0032 __amblksiz"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 39 35 ?? ?? ?? ?? 74 DB 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E C3 }
	condition:
		$1
}

rule file_346_10_0 {
	meta:
		name = "__get_winmajor"
		size = 60
		refs = "000c __errno 001c __invalid_parameter 002a __osplatform 0032 __winmajor"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 39 35 ?? ?? ?? ?? 74 DB 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E C3 }
	condition:
		$1
}

rule file_346_11_0 {
	meta:
		name = "__get_winminor"
		size = 60
		refs = "000c __errno 001c __invalid_parameter 002a __osplatform 0032 __winminor"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 39 35 ?? ?? ?? ?? 74 DB 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E C3 }
	condition:
		$1
}

rule file_346_9_0 {
	meta:
		name = "__get_winver"
		size = 60
		refs = "000c __errno 001c __invalid_parameter 002a __osplatform 0032 __winver"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 6A 16 58 5E C3 39 35 ?? ?? ?? ?? 74 DB 8B 0D ?? ?? ?? ?? 89 08 33 C0 5E C3 }
	condition:
		$1
}

rule file_346_14_0 {
	meta:
		name = "__cinit"
		size = 146
		refs = "0002 __FPinit 000f __IsNonwritableInCurrentImage 0024 __initp_misc_cfltcvt_tab 0029 ___xi_z 002e ___xi_a 0033 __initterm_e 0040 __RTC_Terminate 0045 _atexit 004a ___xc_a 0051 ___xc_z 006b ___dyn_tls_init_callback"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 1A 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 0B FF 74 24 04 FF 15 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 59 75 54 56 57 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? BE ?? ?? ?? ?? 8B C6 BF ?? ?? ?? ?? 3B C7 59 73 0F 8B 06 85 C0 74 02 FF D0 83 C6 04 3B F7 72 F1 83 3D ?? ?? ?? ?? 00 5F 5E 74 1B 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 0C 6A 00 6A 02 6A 00 FF 15 ?? ?? ?? ?? 33 C0 C3 }
	condition:
		$1
}

rule file_346_15_0 {
	meta:
		name = "_doexit"
		size = 206
		refs = "0003 __sehtable$_doexit 0008 __SEH_prolog4 000f __lock 001d __C_Exit_Done 0025 __C_Termination_Done 002d __exitflag 0039 ___onexitbegin 003e __decode_pointer 0046 ___onexitend 006f ___xp_z 0074 ___xp_a 0079 __initterm 007f ___xt_z 0084 ___xt_a 00a9 __unlock 00b2 ___crtExitProcess 00c9 __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 59 83 65 FC 00 33 F6 46 39 35 ?? ?? ?? ?? 74 6B 89 35 ?? ?? ?? ?? 8A 45 10 A2 ?? ?? ?? ?? 83 7D 0C 00 75 47 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 59 89 45 E4 85 FF 74 16 83 6D E4 04 39 7D E4 72 0D 8B 45 E4 8B 00 85 C0 74 EE FF D0 EB EA 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 68 ?? ?? ?? ?? B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 1F 00 00 00 83 7D 10 00 75 28 89 35 ?? ?? ?? ?? 6A 08 E8 ?? ?? ?? ?? 59 FF 75 08 E8 ?? ?? ?? ?? 33 F6 46 83 7D 10 00 74 08 6A 08 E8 ?? ?? ?? ?? 59 C3 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_346_16_0 {
	meta:
		name = "_exit"
		size = 17
		refs = "0009 _doexit"
	strings:
		$1 = { 6A 00 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_346_17_0 {
	meta:
		name = "__exit"
		size = 17
		refs = "0009 _doexit"
	strings:
		$1 = { 6A 00 6A 01 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_346_20_0 {
	meta:
		name = "__init_pointers"
		size = 76
		refs = "0002 __encoded_null 000a __initp_heap_handler 0010 __initp_misc_initcrit 0016 __initp_misc_invarg 001c __initp_misc_purevirt 0022 __initp_misc_rand_s 0028 __initp_misc_winsig 002e __initp_misc_winxfltr 0034 __initp_eh_hooks 0039 __exit 003e __encode_pointer 0046 __aexit_rtn"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B F0 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 24 A3 ?? ?? ?? ?? 5E C3 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "_issnanf"
		size = 33
	strings:
		$1 = { 8B 44 24 04 25 00 00 C0 7F 3D 00 00 80 7F 75 0E F7 44 24 04 FF FF 3F 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_347_1_0 {
	meta:
		name = "_isnanf"
		size = 32
	strings:
		$1 = { 8B 4C 24 04 B8 00 00 80 7F 23 C8 3B C8 75 0E F7 44 24 04 FF FF 7F 00 74 04 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_347_5_0 {
	meta:
		name = "_XMMI_FP_Emulation"
		size = 3532
		refs = "0050 $LN256 0057 $LN332 0070 _isdenormalf 009d $LN333 010c __control87 0166 __statusfp 018d _Fill_FPIEEE_RECORD 01ae _isnanf 026d _MIN_SINGLE_NORMALA 02aa _NEGINFFA 02b4 _MAX_SINGLE_NORMALA 02d5 _POSINFFA 02f7 _TWO_TO_192A 0350 _TWO_TO_M192A 044f _ZEROFA 0461 _NZEROFA 05e5 $LN257 05ec $LN334 05f4 _issnanf 06c2 $LN258 06c9 $LN335 0703 $LN259 070a $LN336 0d48 $LN248 0d4c $LN21 0d50 $LN55 0d54 $LN174 0d58 $LN123 0d5c $LN92 0d60 $LN81 0d7c $LN242 0d84 $LN241 0d8c $LN240 0d94 $LN239 0d9c $LN168 0da0 $LN163 0dac $LN126 0db0 $LN127"
	strings:
		$1 = { 55 8B EC 83 EC 24 53 56 57 DB E3 8B 75 08 8B 46 20 8B 08 33 4E 10 33 DB 83 E1 03 31 08 8B 4E 14 8B 46 20 C1 E1 02 33 08 89 5D EC 83 E1 1C 31 08 8B 4E 20 8B 11 C1 EA 05 81 E2 FF 0F 00 00 8D 7A D5 83 FF 17 89 5D E4 0F 87 D9 04 00 00 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 39 5E 0C 8B 41 10 89 45 08 8B 41 30 89 45 F8 74 29 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 85 C0 BB 00 00 00 80 74 03 21 5D 08 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 03 21 5D F8 83 FF 07 77 39 FF 24 BD ?? ?? ?? ?? 8B 01 25 3F 00 FE FF 83 C8 20 EB 24 8B 01 25 5F 00 FE FF 83 C8 40 EB 18 8B 01 25 7F 00 FE FF 83 C8 60 EB 0C 8B 01 25 9F 00 FE FF 0D 80 00 00 00 89 01 8B 46 10 83 E8 00 74 1E 48 74 14 48 74 0A 48 75 19 B8 00 03 00 00 EB 15 B8 00 02 00 00 EB 0E B8 00 01 00 00 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 48 59 59 74 36 48 74 24 48 74 12 48 75 3A DB E2 D9 45 08 D9 45 F8 DE F9 DD 5D DC EB 2B DB E2 D9 45 08 D9 45 F8 DE C9 DD 5D DC EB 1C DB E2 D9 45 08 D9 45 F8 DE E9 DD 5D DC EB 0D DB E2 D9 45 08 D9 45 F8 DE C1 DD 5D DC E8 ?? ?? ?? ?? A8 08 89 45 F0 74 07 81 65 F0 FF FF F7 FF 8B 06 33 DB 43 84 C3 89 45 E8 75 25 F6 45 F0 10 74 1F 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 10 09 5E 04 8B 76 20 83 4E 04 10 8B C3 E9 7D 03 00 00 8B 55 08 52 E8 ?? ?? ?? ?? 8B F8 85 FF 59 0F 85 74 03 00 00 FF 75 F8 E8 ?? ?? ?? ?? 85 C0 59 0F 85 63 03 00 00 F6 45 E8 02 6A 02 BA 00 00 08 00 5F 75 11 85 55 F0 74 0C 8B C6 E8 ?? ?? ?? ?? 09 7E 04 EB B5 F6 45 E8 04 75 21 F6 45 F0 08 74 1B 8B C6 E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 08 83 4E 04 04 8B 76 20 83 4E 04 08 EB 8E DD 45 DC D9 55 FC FF 75 FC E8 ?? ?? ?? ?? 85 C0 59 74 3C 8B 46 20 DD D8 09 58 60 D9 45 FC 8B 46 20 D9 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 8B 46 20 83 48 0C 10 09 5E 04 E9 C1 02 00 00 85 55 F0 74 03 09 7E 04 DD 05 ?? ?? ?? ?? D9 C0 D9 E0 D8 DA DF E0 D9 EE F6 C4 05 7A 09 D8 D2 DF E0 F6 C4 41 74 14 D8 DA DF E0 F6 C4 05 7A 14 D8 D9 DF E0 F6 C4 41 75 0D EB 04 DD D9 DD D8 89 5D EC EB 02 DD D8 D9 05 ?? ?? ?? ?? D8 D9 DF E0 DD 05 ?? ?? ?? ?? F6 C4 05 7A 0D D9 C0 D9 E0 D8 DA DF E0 F6 C4 41 74 1A D8 D9 DF E0 F6 C4 05 7A 16 D9 05 ?? ?? ?? ?? D8 D9 DF E0 F6 C4 41 75 07 EB 02 DD D8 89 5D E4 F6 45 E8 10 75 53 83 7D EC 00 74 4D DC 0D ?? ?? ?? ?? 8B C6 DD 5D DC E8 ?? ?? ?? ?? 8B 46 20 09 78 0C 8B 46 20 83 4E 04 10 09 78 04 8B 46 20 09 58 60 DD 45 DC D9 5D 08 D9 45 08 84 5D F0 8B 46 20 D9 58 50 0F 84 6F FE FF FF 8B 46 20 09 58 0C 83 4E 04 20 E9 60 FE FF FF F6 45 E8 08 75 39 83 7D E4 00 74 33 DC 0D ?? ?? ?? ?? 8B C6 DD 5D DC E8 ?? ?? ?? ?? 8B 46 20 83 48 0C 04 8B 46 20 83 4E 04 08 83 48 04 04 8B 46 20 09 58 60 DD 45 DC D9 5D 08 D9 45 08 EB A3 8B 46 20 DD D8 8B 00 C1 E8 05 25 FF 0F 00 00 48 74 30 48 74 20 48 74 10 48 75 32 D9 45 08 D9 45 F8 DE F9 D9 5D FC EB 25 D9 45 08 D9 45 F8 DE C9 D9 5D FC EB 18 D9 45 08 D9 45 F8 DE E9 D9 5D FC EB 0B D9 45 08 D9 45 F8 DE C1 D9 5D FC E8 ?? ?? ?? ?? F6 06 20 8B C8 0F 85 98 00 00 00 84 CB 75 14 83 7E 08 00 0F 84 8A 00 00 00 83 7D EC 00 0F 84 80 00 00 00 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 83 7D EC 00 74 0A 8B 46 20 09 78 0C 83 4E 04 10 33 C9 39 4D E4 74 0B 8B 46 20 83 48 0C 04 83 4E 04 08 39 4E 08 74 2E 39 4D EC 74 29 D9 EE D8 55 FC DF E0 F6 C4 05 7A 0A DD D8 D9 05 ?? ?? ?? ?? EB 10 D8 5D FC DF E0 F6 C4 41 75 09 D9 05 ?? ?? ?? ?? D9 5D FC 8B 46 20 D9 45 FC D9 58 50 E9 2C FD FF FF 8B 46 20 09 58 60 F6 C1 02 8B 46 20 74 09 09 78 0C 83 4E 04 10 EB 04 83 60 0C FD F6 C1 04 8B 46 20 74 0A 83 48 0C 04 83 4E 04 08 EB 04 83 60 0C FB 84 CB 8B 46 20 74 09 09 58 0C 83 4E 04 20 EB 04 83 60 0C FE 83 7E 08 00 74 43 83 7D EC 00 74 3D D9 EE D8 55 FC DF E0 F6 C4 05 7A 0A DD D8 D9 05 ?? ?? ?? ?? EB 10 D8 5D FC DF E0 F6 C4 41 75 09 D9 05 ?? ?? ?? ?? D9 5D FC 8B 46 20 09 58 0C 83 4E 04 20 8B 46 20 09 78 0C 83 4E 04 10 F6 C1 08 D9 45 FC 8B 46 20 D9 58 50 8B 46 20 74 16 83 48 0C 08 83 4E 04 04 8B 76 20 83 66 0C EF 33 C0 5F 5E 5B C9 C3 83 60 0C F7 EB EC 8B 46 20 09 58 60 85 FF 74 1B FF 75 F8 E8 ?? ?? ?? ?? 85 C0 59 74 0E 8B 46 20 81 CA 00 00 40 00 89 50 50 EB 0F DD 45 DC 8B 46 20 D9 5D 08 D9 45 08 D9 58 50 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C F7 F6 45 F0 10 74 96 E9 C8 FC FF FF 39 5E 0C 8B 41 10 89 45 08 8B 41 30 89 45 F8 74 29 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 85 C0 BB 00 00 00 80 74 03 21 5D 08 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 03 21 5D F8 8B 01 8B 7E 18 25 FF 00 FE FF 33 DB 83 E7 07 0D E0 00 00 00 43 83 FF 07 89 01 77 40 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 14 FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 05 21 45 F0 EB 03 89 5D F0 E8 ?? ?? ?? ?? A8 10 74 03 89 5D F0 33 D2 39 55 F0 74 08 84 1E 0F 84 59 FB FF FF FF 75 08 E8 ?? ?? ?? ?? 85 C0 59 0F 85 FB 00 00 00 FF 75 F8 E8 ?? ?? ?? ?? 85 C0 59 0F 85 EA 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0F FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 3A 83 4E 04 02 F6 06 02 75 31 8B C6 E8 ?? ?? ?? ?? E9 1C FB FF FF FF 75 08 E8 ?? ?? ?? ?? 85 C0 59 75 8C FF 75 F8 E8 ?? ?? ?? ?? 85 C0 59 0F 85 7B FF FF FF 33 D2 89 55 F0 EB 86 D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 41 75 13 83 FF 07 77 52 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 05 7A 10 83 FF 03 76 2D 83 FF 07 77 2B 83 4D 08 FF EB 25 D9 45 08 D9 45 F8 DA E9 DF E0 F6 C4 44 7A 16 83 FF 07 77 11 0F B6 87 ?? ?? ?? ?? FF 24 85 ?? ?? ?? ?? 89 55 08 8B 46 20 D9 45 08 09 58 60 8B 46 20 D9 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 E9 EE FD FF FF 83 FF 02 76 0A 83 FF 06 76 3B 83 FF 07 75 03 89 55 08 8B 46 20 D9 45 08 09 58 60 8B 46 20 D9 58 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 39 55 F0 E9 03 FE FF FF 83 4D 08 FF EB C7 39 5E 0C 8B 79 10 8B 49 30 89 7D 08 89 4D F8 74 29 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 BB 00 00 00 80 74 05 23 FB 89 7D 08 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 23 CB 89 4D F8 83 EA 3B 6A 01 5B 74 30 4A 75 49 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 11 51 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 04 33 FF EB 02 8B FB E8 ?? ?? ?? ?? A8 10 74 23 8B FB EB 1F 57 E8 ?? ?? ?? ?? 85 C0 59 75 F1 FF 75 F8 E8 ?? ?? ?? ?? 85 C0 59 75 E4 33 FF EB 03 8B 7D F0 8B 46 20 8B 08 81 E1 FF 00 FE FF 81 C9 E0 00 00 00 85 FF 89 08 74 08 84 1E 0F 84 52 F9 FF FF FF 75 08 E8 ?? ?? ?? ?? 85 C0 59 0F 85 98 00 00 00 FF 75 F8 E8 ?? ?? ?? ?? 85 C0 59 0F 85 87 00 00 00 FF 75 08 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0F FF 75 F8 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 0D 83 4E 04 02 F6 06 02 0F 84 F5 FD FF FF D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 05 7A 0C 81 66 1C 2A F7 FF FF E9 80 FE FF FF D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 41 75 0C 8B 46 1C 25 2B F7 FF FF 0B C3 EB 1E D9 45 08 D9 45 F8 DA E9 DF E0 F6 C4 44 0F 8A 52 FE FF FF 8B 46 1C 25 6A F7 FF FF 83 C8 40 89 46 1C E9 3F FE FF FF 8B 46 1C 25 6F F7 FF FF 83 C8 45 89 46 1C 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB 8B 46 20 83 60 0C F7 85 FF E9 73 FC FF FF 8B 41 10 89 45 08 8B 46 10 2B C3 BF 00 01 00 00 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 12 B8 00 02 00 00 EB 0B 8B C7 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 DB 45 08 D9 5D FC E8 ?? ?? ?? ?? 33 DB 43 F6 06 20 75 35 84 C3 74 31 8B C6 E8 ?? ?? ?? ?? 8B 46 20 8B 08 81 E1 1F 01 FE FF 0B CF 89 08 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 46 20 09 58 60 E9 C6 FA FF FF 8B 4E 20 09 59 60 D9 45 FC 8B 4E 20 D9 59 50 84 C3 8B 46 20 0F 84 67 FD FF FF 09 58 0C 83 4E 04 20 E9 5F FD FF FF 39 5E 0C 8B 41 10 89 45 08 74 14 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 81 65 08 00 00 00 80 83 FA 3F BF 00 01 00 00 72 23 83 FA 40 76 13 83 FA 42 77 19 8B 01 25 5F 05 FE FF 0D 40 05 00 00 EB 09 8B 01 25 1F 01 FE FF 0B C7 89 01 8B 46 20 8B 00 C1 E8 05 25 FF 0F 00 00 83 F8 08 74 05 83 F8 2A EB 0E 8B 46 10 2B C3 74 1B 48 74 14 48 74 0A 48 75 16 B8 00 03 00 00 EB 12 B8 00 02 00 00 EB 0B 8B C7 EB 07 33 C0 EB 03 8B 45 08 0D 1F 00 0A 00 68 1F 03 0B 00 50 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 08 DB 5D F4 E8 ?? ?? ?? ?? 33 DB 43 84 1E 75 08 A8 10 0F 85 08 F7 FF FF 8B 4E 20 8B 55 F4 89 51 50 F6 06 20 75 26 84 C3 74 22 8B C6 E8 ?? ?? ?? ?? 8B 46 20 09 58 0C 8B 46 20 83 4E 04 20 09 58 04 8B 76 20 09 5E 60 E9 EC F6 FF FF 8B 4E 20 09 59 60 84 C3 8B 4E 20 74 09 09 59 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 8B 4E 20 83 61 0C F7 A8 10 E9 99 FA FF FF 83 7E 0C 00 8B 59 10 8B 79 30 89 5D 08 89 7D F8 74 2A 53 E8 ?? ?? ?? ?? 83 C4 04 85 C0 BB 00 00 00 80 74 03 21 5D 08 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 05 23 FB 89 7D F8 8B 5D 08 83 FA 35 72 26 83 FA 36 76 13 83 FA 38 77 1C 8B 01 25 1F 05 FE FF 0D 00 05 00 00 EB 0C 8B 01 25 3F 05 FE FF 0D 20 05 00 00 89 01 53 E8 ?? ?? ?? ?? 85 C0 59 75 0B 57 E8 ?? ?? ?? ?? 85 C0 59 74 31 33 DB 43 84 1E 0F 84 16 F6 FF FF 8B 46 20 09 58 60 8B 46 20 89 78 50 8B 46 20 83 60 0C FE 8B 46 20 83 60 0C FD 8B 46 20 83 60 0C FB E9 B3 F6 FF FF 53 E8 ?? ?? ?? ?? 83 C4 04 85 C0 75 0D 57 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 18 83 4E 04 02 F6 06 02 75 0F 8B C6 E8 ?? ?? ?? ?? 33 C0 40 E9 5A F9 FF FF D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 41 75 1A 8B 4E 20 8B 01 C1 E8 05 25 FF 0F 00 00 83 E8 28 74 2C 48 75 43 89 79 50 EB 3E D9 45 08 D9 45 F8 DE D9 DF E0 F6 C4 05 7A 1A 8B 4E 20 8B 01 C1 E8 05 25 FF 0F 00 00 83 E8 28 74 DA 48 75 1A 89 59 50 EB 15 D9 45 08 D9 45 F8 DA E9 DF E0 F6 C4 44 7A 06 8B 46 20 89 78 50 8B 46 20 83 48 60 01 E9 E1 FA FF FF 39 5E 0C 8B 41 10 89 45 08 74 14 50 E8 ?? ?? ?? ?? 83 C4 04 85 C0 74 07 81 65 08 00 00 00 80 8B 01 25 BF 00 FE FF 0D A0 00 00 00 89 01 8B 46 10 2B C3 74 21 48 74 14 48 74 0A 48 75 15 BB 00 03 00 00 EB 11 BB 00 02 00 00 EB 0A BB 00 01 00 00 EB 03 8B 5D 08 68 1F 03 0B 00 81 CB 1F 00 0A 00 53 E8 ?? ?? ?? ?? 59 59 DB E2 D9 45 08 D9 FA D9 5D FC E8 ?? ?? ?? ?? A8 10 74 05 25 FF FF F7 FF 8B 0E 33 DB 43 84 CB 75 08 A8 10 0F 85 BA F4 FF FF 8B D0 81 E2 00 00 08 00 74 04 83 4E 04 02 F6 C1 02 75 08 85 D2 0F 85 8F F9 FF FF 8B 4E 20 D9 45 FC D9 59 50 F6 06 20 75 08 84 C3 0F 85 93 FD FF FF 8B 4E 20 09 59 60 8B 4E 20 83 61 0C FD 8B 4E 20 83 61 0C FB 84 C3 8B 4E 20 74 09 09 59 0C 83 4E 04 20 EB 04 83 61 0C FE 8B 4E 20 83 61 0C F7 A8 10 0F 84 E5 F7 FF FF 8B 46 20 83 48 0C 10 89 5E 04 E9 DD F7 FF FF 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 00 00 00 00 00 00 00 01 01 02 02 02 02 03 03 04 04 05 05 06 06 06 06 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 00 01 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 }
	condition:
		$1
}

rule file_348_0_0 {
	meta:
		name = "__rmtmp"
		size = 169
		refs = "0003 __sehtable$__rmtmp 0008 __SEH_prolog4 0014 __lock 0023 __nstream 002a ___piob 0040 __lock_file2 0062 __fclose_nolock 0084 __unlock_file2 009b __SEH_epilog4 00a3 __unlock"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 6A 01 E8 ?? ?? ?? ?? 59 89 7D FC 33 F6 89 75 E0 3B 35 ?? ?? ?? ?? 7D 62 A1 ?? ?? ?? ?? 8D 04 B0 39 38 74 3D 8B 00 F6 40 0C 83 74 35 50 56 E8 ?? ?? ?? ?? 59 59 C7 45 FC 01 00 00 00 A1 ?? ?? ?? ?? 8B 04 B0 F6 40 0C 83 74 0F 39 78 1C 74 0A 50 E8 ?? ?? ?? ?? 59 FF 45 E4 89 7D FC E8 08 00 00 00 46 EB A9 33 FF 8B 75 E0 A1 ?? ?? ?? ?? FF 34 B0 56 E8 ?? ?? ?? ?? 59 59 C3 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 01 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "___libm_sse2_atan"
		size = 530
		refs = "0007 _BMASK1 0013 _BMASK2 001b _SGNMASK 0059 _ONEMASK 00a2 _a2 00aa _b2 00bf _atan_tbl 01ca _pi_table"
	strings:
		$1 = { 83 EC 0C 66 0F 12 1D ?? ?? ?? ?? 66 0F 57 D2 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 3D ?? ?? ?? ?? 66 0F C5 D0 03 8B C2 81 E2 FF 7F 00 00 66 0F 13 44 24 04 B9 40 40 00 00 66 0F C4 D1 03 66 0F 54 C7 66 0F 57 FF F2 0F 10 C8 66 0F 54 D8 66 0F C4 F9 03 66 0F 56 DE 66 0F 12 2D ?? ?? ?? ?? 81 EA A0 3F 00 00 81 FA 5F 04 00 00 0F 87 BD 00 00 00 83 C4 0C F2 0F C2 D0 06 F2 0F 5D DF 66 0F 54 EA 66 0F 54 C2 F2 0F 59 CB F2 0F 5C C3 F2 0F 58 CD F2 0F 5E C1 66 0F C5 D3 03 81 EA 9F 3F 00 00 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 25 ?? ?? ?? ?? 25 00 80 00 00 66 0F C4 F8 03 03 D2 66 0F 12 34 D5 ?? ?? ?? ?? 83 C2 01 66 0F 12 2C D5 ?? ?? ?? ?? 66 0F 57 EF 66 0F 57 F7 F2 0F 10 C8 66 0F 57 CF F2 0F 10 D9 F2 0F 59 C0 F2 0F 59 D0 F2 0F 58 E0 F2 0F 58 CE F2 0F 5C F1 F2 0F 58 F3 F2 0F 58 15 ?? ?? ?? ?? F2 0F 59 E0 F2 0F 59 D8 F2 0F 58 F5 F2 0F 59 D3 F2 0F 58 25 ?? ?? ?? ?? F2 0F 59 D4 F2 0F 58 D6 F2 0F 58 CA 66 0F 28 C1 C3 81 C2 B0 03 00 00 81 FA 0F 08 00 00 77 56 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 44 24 04 83 C4 0C F2 0F 59 C9 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 59 E1 F2 0F 58 F9 F2 0F 10 F1 F2 0F 59 C8 F2 0F 58 D4 F2 0F 59 FE F2 0F 59 D1 F2 0F 58 FD F2 0F 59 D7 F2 0F 58 C2 C3 81 C2 F0 3B 00 00 81 FA F0 43 00 00 73 17 66 0F 12 44 24 04 83 C4 0C 83 FA 10 66 0F 28 C8 73 04 F2 0F 59 C9 C3 66 0F 12 64 24 04 83 C4 0C 66 0F 12 05 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 7E C8 66 0F 73 D1 20 66 0F 7E CA 81 FA 00 00 F0 7F 73 11 66 0F 55 C4 66 0F 56 D0 66 0F 56 C3 F2 0F 58 C2 C3 81 EA 00 00 F0 7F 0B C2 83 F8 00 74 E2 F2 0F 10 C4 F2 0F 58 C0 C3 }
	condition:
		$1
}

rule file_352_0_0 {
	meta:
		name = "_wcsncmp"
		size = 53
	strings:
		$1 = { 55 8B EC 83 7D 10 00 75 04 33 C0 5D C3 8B 55 0C 8B 4D 08 FF 4D 10 74 13 0F B7 01 66 85 C0 74 0B 66 3B 02 75 06 41 41 42 42 EB E8 0F B7 01 0F B7 0A 2B C1 5D C3 }
	condition:
		$1
}

rule file_353_3_0 {
	meta:
		name = "__mbstok_s_l"
		size = 461
		refs = "0012 __errno 0022 __invalid_parameter 0065 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0077 _strtok_s 00ad __ismbblead_l"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 57 8B 7D 10 33 DB 3B FB 75 1F E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 99 01 00 00 39 5D 0C 74 DC 56 8B 75 08 3B F3 75 21 39 1F 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 57 01 00 00 FF 75 14 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 39 58 08 75 22 57 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F4 0F 84 41 01 00 00 8B 4D F0 83 61 70 FD E9 35 01 00 00 3B F3 75 6E 8B 37 EB 6A 8B 7D 0C 8B C7 38 18 74 44 8D 45 E8 50 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 18 8D 47 01 8A 08 3A CB 74 1C 8A 17 3A 16 75 05 3A 4E 01 74 1D 8B F8 EB 06 8A 07 3A 06 74 13 47 38 1F 75 CA EB 0C 47 E8 ?? ?? ?? ?? C7 00 2A 00 00 00 38 1F 74 2A 8D 45 E8 50 0F B6 06 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 05 46 38 1E 74 07 46 38 1E 75 92 EB 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 89 75 F8 EB 6F 8B 7D 0C 8B C7 38 18 89 5D FC 74 42 8D 45 E8 50 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 18 8D 47 01 8A 08 3A CB 74 1C 8A 17 3A 16 75 05 3A 4E 01 74 14 8B F8 EB 06 8A 07 3A 06 74 11 47 38 1F 75 CA EB 0A 47 EB 07 C7 45 FC 01 00 00 00 38 1F 75 23 8D 45 E8 50 0F B6 06 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 09 8D 46 01 38 18 74 16 8B F0 46 38 1E 75 8D EB 0F 88 1E 46 39 5D FC 74 07 88 1E 46 EB 02 88 1E 39 75 F8 8B 45 10 89 30 75 10 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 EB 0F 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B 45 F8 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_354_0_0 {
	meta:
		name = "_vscan_fn"
		size = 110
		refs = "0009 _wcslen 0015 __errno 0025 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 20 57 56 E8 ?? ?? ?? ?? 33 FF 3B F7 59 75 1D E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 3A 39 7D 0C 74 DE 3D FF FF FF 3F C7 45 EC 49 00 00 00 89 75 E8 89 75 E0 76 09 C7 45 E4 FF FF FF 7F EB 05 03 C0 89 45 E4 FF 75 14 8D 45 E0 FF 75 10 FF 75 0C 50 FF 55 08 83 C4 10 5F C9 C3 }
	condition:
		$1
}

rule file_355_0_0 {
	meta:
		name = "__except_handler2"
		size = 174
		refs = "0057 __global_unwind2 0064 __local_unwind2"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 55 FC 8B 5D 0C 8B 45 08 F7 40 04 06 00 00 00 75 77 89 45 F8 8B 45 10 89 45 FC 8D 45 F8 89 43 14 8B 73 0C 8B 7B 08 83 FE FF 74 56 8D 0C 76 83 7C 8F 04 00 74 3A 56 55 8B 6B 10 FF 54 8F 04 5D 5E 8B 5D 0C 0B C0 74 28 78 31 8B 7B 08 53 E8 ?? ?? ?? ?? 83 C4 04 8B 6B 10 56 53 E8 ?? ?? ?? ?? 83 C4 08 8D 0C 76 8B 04 8F 89 43 0C FF 54 8F 08 8B 7B 08 8D 0C 76 8B 34 8F EB AC B8 00 00 00 00 EB 1C B8 01 00 00 00 EB 15 55 8B 6B 10 6A FF 53 E8 ?? ?? ?? ?? 83 C4 08 5D B8 01 00 00 00 5D 5F 5E 5B 8B E5 5D C3 }
	condition:
		$1
}

rule file_356_3_0 {
	meta:
		name = "___freetlocinfo"
		size = 320
		refs = "0015 ___lconv_c 0039 _free 0044 ___free_lconv_mon 0065 ___free_lconv_num 00da ___lc_time_c 00ea ___free_lc_time 0100 ___clocalestr"
	strings:
		$1 = { 53 55 56 8B 74 24 10 8B 86 BC 00 00 00 33 ED 3B C5 57 74 6F 3D ?? ?? ?? ?? 74 68 8B 86 B0 00 00 00 3B C5 74 5E 39 28 75 5A 8B 86 B8 00 00 00 3B C5 74 17 39 28 75 13 50 E8 ?? ?? ?? ?? FF B6 BC 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 86 B4 00 00 00 3B C5 74 17 39 28 75 13 50 E8 ?? ?? ?? ?? FF B6 BC 00 00 00 E8 ?? ?? ?? ?? 59 59 FF B6 B0 00 00 00 E8 ?? ?? ?? ?? FF B6 BC 00 00 00 E8 ?? ?? ?? ?? 59 59 8B 86 C0 00 00 00 3B C5 74 44 39 28 75 40 8B 86 C4 00 00 00 2D FE 00 00 00 50 E8 ?? ?? ?? ?? 8B 86 CC 00 00 00 BF 80 00 00 00 2B C7 50 E8 ?? ?? ?? ?? 8B 86 D0 00 00 00 2B C7 50 E8 ?? ?? ?? ?? FF B6 C0 00 00 00 E8 ?? ?? ?? ?? 83 C4 10 8D BE D4 00 00 00 8B 07 3D ?? ?? ?? ?? 74 17 39 A8 B4 00 00 00 75 0F 50 E8 ?? ?? ?? ?? FF 37 E8 ?? ?? ?? ?? 59 59 6A 06 8D 7E 50 5B 81 7F F8 ?? ?? ?? ?? 74 11 8B 07 3B C5 74 0B 39 28 75 07 50 E8 ?? ?? ?? ?? 59 39 6F FC 74 12 8B 47 04 3B C5 74 0B 39 28 75 07 50 E8 ?? ?? ?? ?? 59 83 C7 10 4B 75 C9 56 E8 ?? ?? ?? ?? 59 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_356_4_0 {
	meta:
		name = "___addlocaleref"
		size = 134
		refs = "000a __imp__InterlockedIncrement@4 004e ___clocalestr"
	strings:
		$1 = { 53 55 56 8B 74 24 10 57 8B 3D ?? ?? ?? ?? 56 FF D7 8B 86 B0 00 00 00 85 C0 74 03 50 FF D7 8B 86 B8 00 00 00 85 C0 74 03 50 FF D7 8B 86 B4 00 00 00 85 C0 74 03 50 FF D7 8B 86 C0 00 00 00 85 C0 74 03 50 FF D7 6A 06 8D 5E 50 5D 81 7B F8 ?? ?? ?? ?? 74 09 8B 03 85 C0 74 03 50 FF D7 83 7B FC 00 74 0A 8B 43 04 85 C0 74 03 50 FF D7 83 C3 10 4D 75 D8 8B 86 D4 00 00 00 05 B4 00 00 00 50 FF D7 5F 5E 5D 5B C3 }
	condition:
		$1
}

rule file_356_5_0 {
	meta:
		name = "___removelocaleref"
		size = 140
		refs = "000e __imp__InterlockedDecrement@4 0052 ___clocalestr"
	strings:
		$1 = { 56 8B 74 24 08 85 F6 74 7F 53 55 57 8B 3D ?? ?? ?? ?? 56 FF D7 8B 86 B0 00 00 00 85 C0 74 03 50 FF D7 8B 86 B8 00 00 00 85 C0 74 03 50 FF D7 8B 86 B4 00 00 00 85 C0 74 03 50 FF D7 8B 86 C0 00 00 00 85 C0 74 03 50 FF D7 6A 06 8D 5E 50 5D 81 7B F8 ?? ?? ?? ?? 74 09 8B 03 85 C0 74 03 50 FF D7 83 7B FC 00 74 0A 8B 43 04 85 C0 74 03 50 FF D7 83 C3 10 4D 75 D8 8B 86 D4 00 00 00 05 B4 00 00 00 50 FF D7 5F 5D 5B 8B C6 5E C3 }
	condition:
		$1
}

rule file_356_6_0 {
	meta:
		name = "__copytlocinfo_nolock"
		size = 36
		refs = "001c ___addlocaleref"
	strings:
		$1 = { 56 8B F1 85 F6 74 1B 85 C0 74 17 3B C6 74 13 57 6A 36 59 8B F8 F3 A5 83 20 00 50 E8 ?? ?? ?? ?? 59 5F 5E C3 }
	condition:
		$1
}

rule file_356_7_0 {
	meta:
		name = "__updatetlocinfoEx_nolock"
		size = 62
		refs = "0013 ___addlocaleref 001e ___removelocaleref 002a ___initiallocinfo 0032 ___freetlocinfo"
	strings:
		$1 = { 85 FF 74 37 85 C0 74 33 56 8B 30 3B F7 74 28 57 89 38 E8 ?? ?? ?? ?? 85 F6 59 74 1B 56 E8 ?? ?? ?? ?? 83 3E 00 59 75 0F 81 FE ?? ?? ?? ?? 74 07 56 E8 ?? ?? ?? ?? 59 8B C7 5E C3 33 C0 C3 }
	condition:
		$1
}

rule file_356_8_0 {
	meta:
		name = "___updatetlocinfo"
		size = 118
		refs = "0003 __sehtable$___updatetlocinfo 0008 __SEH_prolog4 000d __getptd 0014 ___globallocalestatus 0032 __amsg_exit 003a __SEH_epilog4 0042 __lock 0050 ___ptlocinfo 0055 __updatetlocinfoEx_nolock 006d __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F0 A1 ?? ?? ?? ?? 85 46 70 74 22 83 7E 6C 00 74 1C E8 ?? ?? ?? ?? 8B 70 6C 85 F6 75 08 6A 20 E8 ?? ?? ?? ?? 59 8B C6 E8 ?? ?? ?? ?? C3 6A 0C E8 ?? ?? ?? ?? 59 83 65 FC 00 8D 46 6C 8B 3D ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 45 E4 C7 45 FC FE FF FF FF E8 02 00 00 00 EB C1 6A 0C E8 ?? ?? ?? ?? 59 8B 75 E4 C3 }
	condition:
		$1
}

rule file_356_9_0 {
	meta:
		name = "__configthreadlocale"
		size = 102
		refs = "0003 __getptd 0031 __errno 0041 __invalid_parameter 005c ___globallocalestatus"
	strings:
		$1 = { 56 57 E8 ?? ?? ?? ?? 8B 48 70 8B D1 80 E2 02 F6 DA 1B D2 42 42 8B FA 8B 54 24 0C 83 FA FF 74 3A 33 F6 3B D6 74 3B 83 FA 01 74 27 83 FA 02 74 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF EB 16 83 E1 FD EB 03 83 C9 02 89 48 70 EB 07 83 0D ?? ?? ?? ?? FF 8B C7 5F 5E C3 }
	condition:
		$1
}

rule file_356_10_0 {
	meta:
		name = "_sync_legacy_variables_lk"
		size = 83
		refs = "0001 ___ptlocinfo 000a ___lc_codepage 0013 ___lc_collate_cp 001f ___lc_clike 002b ___lc_time_curr 0037 ___lconv 0043 __pctype 004e ___mb_cur_max"
	strings:
		$1 = { A1 ?? ?? ?? ?? 8B 48 04 89 0D ?? ?? ?? ?? 8B 48 08 89 0D ?? ?? ?? ?? 8B 88 A8 00 00 00 89 0D ?? ?? ?? ?? 8B 88 D4 00 00 00 89 0D ?? ?? ?? ?? 8B 88 BC 00 00 00 89 0D ?? ?? ?? ?? 8B 88 C8 00 00 00 89 0D ?? ?? ?? ?? 8B 80 AC 00 00 00 A3 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_356_11_0 {
	meta:
		name = "__free_locale"
		size = 150
		refs = "0003 __sehtable$__free_locale 0008 __SEH_prolog4 001f __imp__InterlockedDecrement@4 002b ___initialmbcinfo 0033 _free 003f __lock 004a ___removelocaleref 005a ___initiallocinfo 0062 ___freetlocinfo 0085 __SEH_epilog4 0090 __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 33 FF 3B F7 74 6F 8B 46 04 3B C7 74 1C 50 FF 15 ?? ?? ?? ?? 85 C0 75 11 8B 46 04 3D ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 39 3E 74 37 6A 0C E8 ?? ?? ?? ?? 59 89 7D FC FF 36 E8 ?? ?? ?? ?? 59 8B 06 3B C7 74 12 39 38 75 0E 3D ?? ?? ?? ?? 74 07 50 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 1A 00 00 00 B8 0D F0 AD BA 89 06 89 46 04 56 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C3 8B 75 08 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_356_13_0 {
	meta:
		name = "__get_current_locale"
		size = 136
		refs = "0003 __sehtable$__get_current_locale 0008 __SEH_prolog4 000d __getptd 0018 __calloc_crt 0028 __errno 0037 ___updatetlocinfo 003c ___updatetmbcinfo 004e __lock 005a ___addlocaleref 0070 __imp__InterlockedIncrement@4 0077 __SEH_epilog4 0082 __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B F8 6A 01 6A 08 E8 ?? ?? ?? ?? 59 59 8B F0 89 75 E4 85 F6 75 0F E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 EB 40 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 47 6C 89 06 8B 47 68 89 46 04 6A 0C E8 ?? ?? ?? ?? 59 83 65 FC 00 FF 36 E8 ?? ?? ?? ?? 59 C7 45 FC FE FF FF FF E8 14 00 00 00 FF 76 04 FF 15 ?? ?? ?? ?? 8B C6 E8 ?? ?? ?? ?? C3 8B 75 E4 6A 0C E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_356_16_0 {
	meta:
		name = "__strcats"
		size = 62
		refs = "001f _strcat_s 0030 __invoke_watson"
	strings:
		$1 = { 53 57 8B 7C 24 14 33 DB 3B FB 7E 2F 56 8D 74 24 18 83 C6 04 FF 36 FF 74 24 18 FF 74 24 18 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 4F 75 D7 5E 5F 5B C3 }
	condition:
		$1
}

rule file_356_17_0 {
	meta:
		name = "___lc_strtolc"
		size = 297
		refs = "0013 _memset 0042 _strncpy_s 0053 __invoke_watson 0063 ??_C@_03EGDHDPFD@_?4?0?$AA@ 006c _strcspn"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 08 68 90 00 00 00 33 DB 53 57 E8 ?? ?? ?? ?? 8B 75 0C 8A 06 83 C4 0C 84 C0 75 07 33 C0 E9 FA 00 00 00 3C 2E 75 34 8D 46 01 38 18 74 2D 6A 0F 50 8D 87 80 00 00 00 6A 10 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 88 9F 8F 00 00 00 EB C1 68 ?? ?? ?? ?? 56 89 5D 0C E8 ?? ?? ?? ?? 3B C3 E9 A2 00 00 00 83 7D 0C 00 8D 3C 30 8A 1F 75 1B 83 F8 40 0F 83 96 00 00 00 80 FB 2E 0F 84 8D 00 00 00 50 56 6A 40 FF 75 08 EB 3D 83 7D 0C 01 75 16 83 F8 40 73 79 80 FB 5F 74 74 50 8B 45 08 56 6A 40 83 C0 40 EB 20 83 7D 0C 02 75 62 83 F8 10 73 5D 84 DB 74 05 80 FB 2C 75 54 50 8B 45 08 56 6A 10 05 80 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 80 FB 2C 0F 84 25 FF FF FF 84 DB 0F 84 1D FF FF FF FF 45 0C 8D 77 01 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 56 FF FF FF 83 C8 FF 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_356_18_0 {
	meta:
		name = "___lc_lctostr"
		size = 107
		refs = "0010 _strcpy_s 0023 __invoke_watson 0033 ??_C@_01IDAFKMJL@_?$AA@ 0040 __strcats 0055 ??_C@_01LFCBOECM@?4?$AA@"
	strings:
		$1 = { 55 8B EC 53 56 8B 75 10 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 33 DB 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 46 40 38 18 74 16 50 68 ?? ?? ?? ?? 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 8D 86 80 00 00 00 38 18 5E 5B 74 16 50 68 ?? ?? ?? ?? 6A 02 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 14 5D C3 }
	condition:
		$1
}

rule file_356_19_0 {
	meta:
		name = "__setlocale_get_all"
		size = 369
		refs = "0011 __malloc_crt 0039 ??_C@_01NEMOKFLO@?$DN?$AA@ 003f ___lc_category 004c __strcats 005c ??_C@_01ICJEACDI@?$DL?$AA@ 0067 _strcat_s 007a __invoke_watson 0087 _strcmp 00e2 __imp__InterlockedDecrement@4 00f3 _free"
	strings:
		$1 = { 83 EC 10 53 33 DB 43 68 55 03 00 00 89 5C 24 10 E8 ?? ?? ?? ?? 85 C0 59 89 44 24 10 0F 84 4A 01 00 00 55 57 8D 78 04 C6 07 00 89 18 8D 6E 10 89 5C 24 10 8D 5D 48 FF 33 68 ?? ?? ?? ?? FF 35 ?? ?? ?? ?? 6A 03 68 51 03 00 00 57 E8 ?? ?? ?? ?? 83 C4 18 C7 44 24 0C ?? ?? ?? ?? 68 ?? ?? ?? ?? 68 51 03 00 00 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 FF 75 58 FF 33 E8 ?? ?? ?? ?? 85 C0 59 59 74 05 83 64 24 14 00 FF 44 24 10 8B 44 24 10 83 44 24 0C 0C C1 E0 04 8D 2C 30 8B 44 24 0C 8D 5D 48 FF 33 68 ?? ?? ?? ?? FF 30 6A 03 68 51 03 00 00 57 E8 ?? ?? ?? ?? 83 C4 18 81 7C 24 0C ?? ?? ?? ?? 7C 88 33 ED 39 6C 24 14 75 42 8B 46 50 3B C5 8B 1D ?? ?? ?? ?? 74 10 50 FF D3 85 C0 75 09 FF 76 50 E8 ?? ?? ?? ?? 59 8B 46 54 3B C5 74 10 50 FF D3 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 44 24 18 89 46 50 89 7E 48 8B C7 EB 47 FF 74 24 18 E8 ?? ?? ?? ?? 8B 46 50 3B C5 8B 3D ?? ?? ?? ?? 59 74 10 50 FF D7 85 C0 75 09 FF 76 50 E8 ?? ?? ?? ?? 59 8B 46 54 3B C5 74 10 50 FF D7 85 C0 75 09 FF 76 54 E8 ?? ?? ?? ?? 59 8B 46 68 89 6E 50 89 6E 48 5F 89 6E 4C 89 6E 54 5D 5B 83 C4 10 C3 }
	condition:
		$1
}

rule file_356_20_0 {
	meta:
		name = "__expandlocale"
		size = 468
		refs = "000c ___security_cookie 002e __getptd 0076 ??_C@_01GFHCPBMG@C?$AA@ 0081 _strcpy_s 0094 __invoke_watson 00bd _strlen 00d3 _strcmp 00fa ___lc_strtolc 010f ___get_qualified_locale 0130 ___lc_lctostr 0147 ??_C@_00CNPNBAHC@?$AA@ 0153 _strncpy_s 017d _memcpy 01cb @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 A0 81 EC B4 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 5C 8B 45 6C 53 56 8B 75 68 57 8B 7D 74 89 45 C4 8B 45 78 89 7D BC 89 45 C0 E8 ?? ?? ?? ?? 05 9C 00 00 00 8D 48 28 89 4D B4 8D 48 2C 8D 58 20 05 AF 00 00 00 85 F6 89 4D B8 89 45 C8 0F 84 6A 01 00 00 83 7D C4 00 0F 84 60 01 00 00 83 7D 70 00 0F 84 56 01 00 00 80 3E 43 75 4C 80 7E 01 00 75 46 68 ?? ?? ?? ?? FF 75 70 FF 75 C4 E8 ?? ?? ?? ?? 83 C4 0C 33 F6 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 3B FE 74 0B 66 89 37 66 89 77 02 66 89 77 04 8B 45 C0 3B C6 74 02 89 30 8B 45 C4 E9 07 01 00 00 56 E8 ?? ?? ?? ?? BF 83 00 00 00 3B C7 59 89 45 B0 73 22 56 FF 75 C8 E8 ?? ?? ?? ?? 85 C0 59 59 0F 84 8E 00 00 00 56 FF 75 B8 E8 ?? ?? ?? ?? 85 C0 59 59 74 7F 83 65 AC 00 8D 45 CC 56 50 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 B8 00 00 00 8D 45 CC 50 53 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 A2 00 00 00 0F B7 43 04 8B 4D B4 89 01 8D 45 CC 50 57 FF 75 C8 E8 ?? ?? ?? ?? 83 C4 0C 80 3E 00 74 07 8B 45 B0 3B C7 72 08 8B 45 AC BE ?? ?? ?? ?? 40 50 56 57 FF 75 B8 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 11 33 F6 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 EB 02 33 F6 39 75 BC 74 0E 6A 06 53 FF 75 BC E8 ?? ?? ?? ?? 83 C4 0C 39 75 C0 74 10 6A 04 FF 75 B4 FF 75 C0 E8 ?? ?? ?? ?? 83 C4 0C FF 75 C8 FF 75 70 FF 75 C4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8B 45 C8 EB 02 33 C0 8B 4D 5C 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 83 C5 60 C9 C3 }
	condition:
		$1
}

rule file_356_21_0 {
	meta:
		name = "__setlocale_set_cat"
		size = 758
		refs = "000c ___security_cookie 001a __getptd 0042 __expandlocale 0065 _strcmp 0078 _strlen 0087 __malloc_crt 00cf _memcpy 00f5 _strcpy_s 0108 __invoke_watson 01e3 __first_127char 01ec ___crtGetStringTypeA 0210 __ctype_loc_style 021c _memcmp 0257 ___lc_category 0270 _free 0297 ___clocalestr 02ad __imp__InterlockedDecrement@4 02ed @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC C4 01 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 70 53 57 8B D9 E8 ?? ?? ?? ?? FF 75 7C 8B F8 8D 85 DC FE FF FF 50 8D 85 C4 FE FF FF 50 68 83 00 00 00 8D 45 EC 50 53 81 C7 D0 01 00 00 E8 ?? ?? ?? ?? 83 C4 18 85 C0 75 07 33 C0 E9 91 02 00 00 8B 45 7C C1 E0 04 8D 1C 30 FF 73 48 8D 45 EC 50 E8 ?? ?? ?? ?? 85 C0 59 59 0F 84 6F 02 00 00 8D 45 EC 50 E8 ?? ?? ?? ?? 83 C0 05 50 89 85 E8 FE FF FF E8 ?? ?? ?? ?? 85 C0 59 59 89 85 E4 FE FF FF 74 B6 8B 43 48 8B 4D 7C 89 85 D0 FE FF FF 8D 44 8E 0C 83 C1 06 6B C9 06 89 85 E0 FE FF FF 8B 00 89 85 CC FE FF FF 8D 04 31 6A 06 50 89 85 D8 FE FF FF 8D 85 B0 FE FF FF 50 E8 ?? ?? ?? ?? 8B 46 04 8D 4D EC 51 8B 8D E8 FE FF FF 89 85 C0 FE FF FF 8B 85 E4 FE FF FF 83 C1 FC 83 C0 04 51 50 E8 ?? ?? ?? ?? 83 C4 18 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 8B 85 E4 FE FF FF 8B 8D E0 FE FF FF 83 C0 04 89 43 48 0F B7 85 C4 FE FF FF 89 01 6A 06 8D 85 C4 FE FF FF 50 FF B5 D8 FE FF FF E8 ?? ?? ?? ?? 83 C4 0C 83 7D 7C 02 0F 85 F4 00 00 00 8B 85 DC FE FF FF 83 A5 E8 FE FF FF 00 89 46 04 8B 47 24 8B 4F 20 89 85 D8 FE FF FF 8B C7 8B 56 04 3B 10 74 36 8B 10 FF 85 E8 FE FF FF 89 08 8B 8D D8 FE FF FF 89 95 B8 FE FF FF 8B 50 04 89 48 04 8B 8D B8 FE FF FF 83 C0 08 83 BD E8 FE FF FF 05 89 95 D8 FE FF FF 7C C5 EB 22 8B 85 E8 FE FF FF 85 C0 74 18 8D 04 C7 8B 10 89 17 8B 50 04 89 57 04 89 08 8B 8D D8 FE FF FF 89 48 04 83 BD E8 FE FF FF 05 75 65 6A 01 FF 76 14 8D 85 EC FE FF FF FF 76 04 50 6A 7F 68 ?? ?? ?? ?? 6A 01 6A 00 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 36 33 C0 66 81 A4 45 EC FE FF FF FF 01 40 83 F8 7F 72 F0 68 FE 00 00 00 FF 35 ?? ?? ?? ?? 8D 85 EC FE FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C F7 D8 1B C0 40 89 47 04 EB 04 83 67 04 00 8B 46 04 89 07 8B 47 04 89 86 A8 00 00 00 83 7D 7C 01 75 09 8B 85 DC FE FF FF 89 46 08 8B 45 7C 6B C0 0C 56 FF 90 ?? ?? ?? ?? 85 C0 59 74 31 8B 85 D0 FE FF FF FF B5 E4 FE FF FF 89 43 48 E8 ?? ?? ?? ?? 8B 85 CC FE FF FF 59 8B 8D E0 FE FF FF 89 01 8B 85 C0 FE FF FF 89 46 04 E9 BC FD FF FF 81 BD D0 FE FF FF ?? ?? ?? ?? 74 2D 8B 45 7C 83 C0 05 C1 E0 04 8D 3C 30 FF 37 FF 15 ?? ?? ?? ?? 85 C0 75 15 FF 37 E8 ?? ?? ?? ?? FF 73 54 E8 ?? ?? ?? ?? 83 63 4C 00 59 59 8B 4D 7C 8B 85 E4 FE FF FF 83 C1 05 C1 E1 04 C7 00 01 00 00 00 89 04 31 8B 43 48 8B 4D 70 5F 33 CD 5B E8 ?? ?? ?? ?? 83 C5 74 C9 C3 }
	condition:
		$1
}

rule file_356_22_0 {
	meta:
		name = "__setlocale_nolock"
		size = 462
		refs = "000c ___security_cookie 002c __setlocale_set_cat 0074 ??_C@_02BALPLPBG@?$DN?$DL?$AA@ 007a _strpbrk 00a6 ___lc_category 00b4 _strncmp 00c2 _strlen 00dc ??_C@_01ICJEACDI@?$DL?$AA@ 00e2 _strcspn 0107 _strncpy_s 0118 __invoke_watson 0169 __expandlocale 0182 _strcmp 01b8 __setlocale_get_all 01c5 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D 6C 24 8C 81 EC 98 00 00 00 A1 ?? ?? ?? ?? 33 C5 89 45 70 8B 45 7C 53 56 33 DB 3B C3 8B F2 57 89 75 DC 74 1C 3B CB 74 0C 50 E8 ?? ?? ?? ?? 59 E9 86 01 00 00 C1 E0 04 8B 44 30 48 E9 7A 01 00 00 3B CB C7 45 E4 01 00 00 00 89 5D E8 0F 84 63 01 00 00 80 39 4C 0F 85 FE 00 00 00 80 79 01 43 0F 85 F4 00 00 00 80 79 02 5F 0F 85 EA 00 00 00 8B F9 68 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 8B D8 85 DB 59 59 0F 84 CD 00 00 00 2B C7 89 45 E4 0F 84 C2 00 00 00 80 3B 3B 0F 84 B9 00 00 00 C7 45 E0 01 00 00 00 BE ?? ?? ?? ?? EB 03 8B 45 E4 50 57 FF 36 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0D FF 36 E8 ?? ?? ?? ?? 39 45 E4 59 74 0E FF 45 E0 83 C6 0C 81 FE ?? ?? ?? ?? 7E D2 43 68 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 8B F8 33 F6 3B FE 59 59 75 05 80 3B 3B 75 62 83 7D E0 05 7F 3F 57 53 8D 45 EC 68 83 00 00 00 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 FF 75 E0 8B 75 DC 8D 4D EC C6 44 3D EC 00 E8 ?? ?? ?? ?? 85 C0 59 74 03 FF 45 E8 03 FB 80 3F 00 74 0A 47 80 3F 00 0F 85 28 FF FF FF 33 C0 39 45 E8 74 6A 8B 75 DC EB 60 33 C0 EB 61 53 53 53 68 83 00 00 00 8D 45 EC 50 51 E8 ?? ?? ?? ?? 83 C4 18 3B C3 74 48 8D 7E 48 85 DB 74 27 FF 37 8D 45 EC 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 13 53 8D 4D EC E8 ?? ?? ?? ?? 85 C0 59 75 05 21 45 E4 EB 03 FF 45 E8 43 83 C7 10 83 FB 05 7E CC 33 C0 39 45 E4 75 05 39 45 E8 74 05 E8 ?? ?? ?? ?? 8B 4D 70 5F 5E 33 CD 5B E8 ?? ?? ?? ?? 83 C5 74 C9 C3 }
	condition:
		$1
}

rule file_356_23_0 {
	meta:
		name = "__create_locale"
		size = 243
		refs = "0017 __calloc_crt 0024 __errno 0048 _free 0076 ___initiallocinfo 007b __copytlocinfo_nolock 008a __setlocale_nolock 0096 ___removelocaleref 009d ___freetlocinfo 00b5 __setmbcp_nolock"
	strings:
		$1 = { 83 7C 24 04 05 56 57 77 25 83 7C 24 10 00 74 1E 33 FF 47 57 6A 08 E8 ?? ?? ?? ?? 8B F0 85 F6 59 59 75 10 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 33 C0 5F 5E C3 57 68 D8 00 00 00 E8 ?? ?? ?? ?? 59 59 89 06 85 C0 75 09 56 E8 ?? ?? ?? ?? 59 EB D4 57 68 20 02 00 00 E8 ?? ?? ?? ?? 85 C0 59 59 89 46 04 75 10 FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 EB D9 8B 06 B9 ?? ?? ?? ?? E8 ?? ?? ?? ?? FF 74 24 0C 8B 4C 24 14 8B 16 E8 ?? ?? ?? ?? 85 C0 59 75 19 FF 36 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 0C EB 32 FF 76 04 8B 06 FF 70 04 E8 ?? ?? ?? ?? 85 C0 59 59 74 23 FF 76 04 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? FF 36 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 10 33 F6 EB 0A 8B 46 04 89 38 8B 46 04 89 38 8B C6 E9 3D FF FF FF }
	condition:
		$1
}

rule file_356_25_0 {
	meta:
		name = "_setlocale"
		size = 368
		refs = "0003 __sehtable$_setlocale 0008 __SEH_prolog4 0018 __errno 0028 __invalid_parameter 0037 __getptd 0041 ___updatetlocinfo 0054 __calloc_crt 006a __lock 007c __copytlocinfo_nolock 0091 __setlocale_nolock 00a7 ___clocalestr 00af _strcmp 00bb ___locale_changed 00d8 __updatetlocinfoEx_nolock 00de ___removelocaleref 00eb ___globallocalestatus 00f5 ___ptlocinfo 010a ___lc_handle 010f _memcpy 0117 _sync_legacy_variables_lk 0131 __unlock 014d ___freetlocinfo 0163 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E0 83 7D 08 05 76 1F E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 2C 01 00 00 E8 ?? ?? ?? ?? 8B F0 89 75 E4 E8 ?? ?? ?? ?? 83 4E 70 10 89 5D FC 6A 01 68 D8 00 00 00 E8 ?? ?? ?? ?? 59 59 8B F8 89 7D DC 3B FB 0F 84 EC 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 01 00 00 00 8B 4E 6C 8B C7 E8 ?? ?? ?? ?? 89 5D FC E8 A6 00 00 00 FF 75 08 8B 4D 0C 8B D7 E8 ?? ?? ?? ?? 59 89 45 E0 3B C3 0F 84 A4 00 00 00 39 5D 0C 74 1D 68 ?? ?? ?? ?? FF 75 0C E8 ?? ?? ?? ?? 59 59 85 C0 74 0A C7 05 ?? ?? ?? ?? 01 00 00 00 6A 0C E8 ?? ?? ?? ?? 59 C7 45 FC 02 00 00 00 8D 5E 6C 8B C3 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 F6 46 70 02 75 32 F6 05 ?? ?? ?? ?? 01 75 29 8B 3B B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 18 A1 ?? ?? ?? ?? 83 C0 0C 50 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 65 FC 00 E8 16 00 00 00 EB 2D 8B 7D DC 8B 75 E4 33 DB 6A 0C E8 ?? ?? ?? ?? 59 C3 8B 75 E4 6A 0C E8 ?? ?? ?? ?? 59 C3 EB 0E 57 E8 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E0 E8 ?? ?? ?? ?? C3 8B 75 E4 83 66 70 EF C3 }
	condition:
		$1
}

rule file_357_3_0 {
	meta:
		name = "__ismbchira_l"
		size = 64
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 12 8B 45 08 05 61 7D FF FF 83 F8 52 77 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_357_5_0 {
	meta:
		name = "__ismbckata_l"
		size = 72
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 1A 8B 45 08 8D 88 C0 7C FF FF 83 F9 56 77 0C 3D 7F 83 00 00 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_357_7_0 {
	meta:
		name = "__ismbcsymbol_l"
		size = 72
		refs = "000d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F4 81 78 04 A4 03 00 00 75 1A 8B 45 08 8D 88 BF 7E FF FF 83 F9 6B 77 0C 3D 7F 81 00 00 74 05 33 C0 40 EB 02 33 C0 80 7D FC 00 74 07 8B 4D F8 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_358_0_0 {
	meta:
		name = "__cintrindisp2"
		size = 62
		refs = "0014 __matherr_flag 001c __trandisp2"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 9B D9 BD 5C FF FF FF 9B 83 3D ?? ?? ?? ?? 00 74 14 E8 ?? ?? ?? ?? 80 8D 38 FD FF FF 03 E8 9E 00 00 00 5B C9 C3 D9 C9 DD 95 7A FF FF FF D9 C9 DD 55 82 EB DD }
	condition:
		$1
}

rule file_358_1_0 {
	meta:
		name = "__cintrindisp1"
		size = 61
		refs = "0013 __matherr_flag 001b __trandisp1"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 9B D9 BD 5C FF FF FF 83 3D ?? ?? ?? ?? 00 74 1B E8 ?? ?? ?? ?? 80 8D 38 FD FF FF 01 80 A5 38 FD FF FF FD E8 5A 00 00 00 5B C9 C3 DD 95 7A FF FF FF EB DD }
	condition:
		$1
}

rule file_358_2_0 {
	meta:
		name = "__ctrandisp2"
		size = 406
		refs = "003c __trandisp2 0051 ___fastflag 00e6 IeeeAdjU 00f6 DblMin 0102 _zero 0114 IeeeAdjO 0124 DblMax 0130 _infinity 0185 __87except"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 FF 75 0C FF 75 08 E8 B4 01 00 00 83 C4 08 FF 75 14 FF 75 10 E8 A6 01 00 00 83 C4 08 9B D9 BD 5C FF FF FF 80 8D 38 FD FF FF 02 C6 85 71 FF FF FF 01 E8 ?? ?? ?? ?? E8 03 00 00 00 5B C9 C3 80 A5 38 FD FF FF FE 83 3D ?? ?? ?? ?? 00 75 4F DD 95 30 FD FF FF 8A 85 70 FF FF FF 0A C0 74 1A 3C FF 74 5B 3C FE 74 3F 0A C0 74 33 0F BE C0 89 85 72 FF FF FF E9 B2 00 00 00 66 8B 85 5C FF FF FF 66 83 E0 20 75 18 9B DF E0 66 83 E0 20 74 0F C7 85 72 FF FF FF 08 00 00 00 E9 8D 00 00 00 D9 AD 5C FF FF FF 9B C3 66 8B 85 36 FD FF FF 66 25 F0 7F 66 0B C0 74 1B 66 3D F0 7F 74 43 EB BB 66 8B 85 36 FD FF FF 66 25 F0 7F 66 3D F0 7F 74 30 EB A8 C7 85 72 FF FF FF 04 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 73 34 DC 0D ?? ?? ?? ?? EB 2C C7 85 72 FF FF FF 03 00 00 00 DD 05 ?? ?? ?? ?? D9 C9 D9 FD DD D9 D9 C0 D9 E1 DC 1D ?? ?? ?? ?? 9B DF E0 9E 76 06 DC 0D ?? ?? ?? ?? 56 57 8B 9D 6C FF FF FF 43 89 9D 76 FF FF FF F6 85 38 FD FF FF 01 75 1A FC 8D 75 08 8D BD 7A FF FF FF A5 A5 80 7B 0C 01 74 08 8D 75 10 8D 7D 82 A5 A5 DD 5D 8A 8D 85 72 FF FF FF 8D 9D 5C FF FF FF 53 50 8B 9D 6C FF FF FF 8A 43 0E 0F BE C0 50 E8 ?? ?? ?? ?? 83 C4 0C 5F 5E DD 45 8A E9 11 FF FF FF }
	condition:
		$1
}

rule file_358_3_0 {
	meta:
		name = "__ctrandisp1"
		size = 51
		refs = "0027 __trandisp1"
	strings:
		$1 = { 55 8B EC 81 C4 30 FD FF FF 53 FF 75 0C FF 75 08 E8 1E 00 00 00 83 C4 08 9B D9 BD 5C FF FF FF 80 A5 38 FD FF FF FD E8 ?? ?? ?? ?? E8 82 FE FF FF 5B C9 C3 }
	condition:
		$1
}

rule file_358_4_0 {
	meta:
		name = "__fload"
		size = 60
	strings:
		$1 = { 55 8B EC 83 C4 F4 53 66 8B 45 0E 66 8B D8 66 25 F0 7F 66 3D F0 7F 75 1E 66 81 CB FF 7F 66 89 5D FE 8B 45 0C 8B 5D 08 0F A4 D8 0B 89 45 FA 89 5D F6 DB 6D F6 EB 03 DD 45 08 5B C9 C3 }
	condition:
		$1
}

rule file_359_3_0 {
	meta:
		name = "__ismbstrail_l"
		size = 166
		refs = "0012 __errno 0022 __invalid_parameter 0056 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 44 57 8B 7D 0C 3B FB 75 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 1F FF 75 10 8D 4D F0 E8 ?? ?? ?? ?? 8B 4D F4 39 59 08 75 2D 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 5F 5E 5B C9 C3 8A 06 3A C3 74 E7 0F B6 C0 F6 44 08 1D 04 74 09 46 3B F7 74 0B 38 1E 74 D4 46 3B F7 76 E2 EB CD 38 5D FC 74 07 8B 45 F8 83 60 70 FD 83 C8 FF EB CA }
	condition:
		$1
}

rule file_360_0_0 {
	meta:
		name = "_vfscanf"
		size = 317
		refs = "0003 __sehtable$_vfscanf 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 004d __lock_file 0061 __fileno 0083 ___pioinfo 009a ___badioinfo 012d __SEH_epilog4 0137 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C0 8B 7D 0C 3B FB 0F 95 C0 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 ED 00 00 00 33 C0 39 5D 10 0F 95 C0 3B C3 74 D4 57 E8 ?? ?? ?? ?? 59 89 5D FC F6 47 0C 40 0F 85 A6 00 00 00 57 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 57 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 57 E8 ?? ?? ?? ?? C1 F8 05 8D 34 85 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 06 EB 05 B8 ?? ?? ?? ?? F6 40 24 7F 75 45 57 E8 ?? ?? ?? ?? 59 83 F8 FF 74 2E 57 E8 ?? ?? ?? ?? 59 83 F8 FE 74 22 57 E8 ?? ?? ?? ?? C1 F8 05 8D 34 85 ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 83 E0 1F 6B C0 28 03 06 EB 05 B8 ?? ?? ?? ?? F6 40 24 80 74 1C E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 4D E4 FF 39 5D E4 75 13 FF 75 18 FF 75 14 FF 75 10 57 FF 55 08 83 C4 10 89 45 E4 C7 45 FC FE FF FF FF E8 0C 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 8B 7D 0C 57 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_360_1_0 {
	meta:
		name = "_fscanf"
		size = 29
		refs = "0010 __input_l 0015 _vfscanf"
	strings:
		$1 = { 8D 44 24 0C 50 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_360_3_0 {
	meta:
		name = "_fscanf_s"
		size = 29
		refs = "0010 __input_s_l 0015 _vfscanf"
	strings:
		$1 = { 8D 44 24 0C 50 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_681_1_0 {
	meta:
		name = "_fwscanf"
		size = 29
		refs = "0010 __winput_l 0015 _vfwscanf"
	strings:
		$1 = { 8D 44 24 0C 50 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_681_3_0 {
	meta:
		name = "_fwscanf_s"
		size = 29
		refs = "0010 __winput_s_l 0015 _vfwscanf"
	strings:
		$1 = { 8D 44 24 0C 50 6A 00 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_360_2_0 {
	meta:
		name = "__fscanf_l"
		size = 31
		refs = "0012 __input_l 0017 _vfscanf"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_360_4_0 {
	meta:
		name = "__fscanf_s_l"
		size = 31
		refs = "0012 __input_s_l 0017 _vfscanf"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_681_2_0 {
	meta:
		name = "__fwscanf_l"
		size = 31
		refs = "0012 __winput_l 0017 _vfwscanf"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_681_4_0 {
	meta:
		name = "__fwscanf_s_l"
		size = 31
		refs = "0012 __winput_s_l 0017 _vfwscanf"
	strings:
		$1 = { 8D 44 24 10 50 FF 74 24 10 FF 74 24 10 FF 74 24 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_361_3_0 {
	meta:
		name = "__ismbclower_l"
		size = 171
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0068 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 81 F9 FF 00 00 00 76 6E 33 C0 57 33 DB 66 89 5D FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 39 58 08 5F 75 10 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 59 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CC 66 39 5D FE 75 0B F6 45 FC 02 74 05 33 C0 40 EB 02 33 C0 38 5D F8 EB 14 8B 45 F0 8A 44 08 1D 24 20 2C 20 F6 D8 1B C0 40 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_362_0_0 {
	meta:
		name = "_strcspn"
		size = 70
	strings:
		$1 = { 55 8B EC 56 33 C0 50 50 50 50 50 50 50 50 8B 55 0C 8D 49 00 8A 02 0A C0 74 09 83 C2 01 0F AB 04 24 EB F1 8B 75 08 83 C9 FF 8D 49 00 83 C1 01 8A 06 0A C0 74 09 83 C6 01 0F A3 04 24 73 EE 8B C1 83 C4 20 5E C9 C3 }
	condition:
		$1
}

rule file_363_3_0 {
	meta:
		name = "?_wcrtomb_s_l@@YAHPAHPADI_W0PAUlocaleinfo_struct@@@Z"
		size = 162
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0065 __imp__WideCharToMultiByte@32 007b __errno"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 FF 75 14 8D 4D EC E8 ?? ?? ?? ?? 33 DB 3B FB 74 02 89 1F 8B 45 EC 39 58 14 75 29 66 8B 45 10 66 3D FF 00 77 4E 3B F3 8B 4D 08 88 01 74 06 C7 06 01 00 00 00 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 54 8D 4D FC 51 53 FF 75 0C 8D 4D 10 FF 75 08 89 5D FC 6A 01 51 53 FF 70 04 FF 15 ?? ?? ?? ?? 3B C3 74 0D 39 5D FC 75 08 3B F3 74 C5 89 06 EB C1 E8 ?? ?? ?? ?? 3B F3 C7 00 2A 00 00 00 74 03 83 0E FF E8 ?? ?? ?? ?? 38 5D F8 8B 00 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 }
	condition:
		$1
}

rule file_363_4_0 {
	meta:
		name = "_wcrtomb_s"
		size = 130
		refs = "0007 ___security_cookie 002f __errno 003e __invalid_parameter 0060 ?_wcrtomb_s_l@@YAHPAHPADI_W0PAUlocaleinfo_struct@@@Z 007c @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 08 83 4D F0 FF 53 89 45 EC 8B 45 0C 56 33 DB 3B C3 57 8B 7D 18 75 2B 39 5D 10 74 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 2A 53 FF 75 14 8D 45 F4 6A 05 EB 07 53 FF 75 14 FF 75 10 50 8D 75 F0 E8 ?? ?? ?? ?? 8B 4D EC 83 C4 10 3B CB 74 05 8B 55 F0 89 11 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_363_5_0 {
	meta:
		name = "_wcrtomb"
		size = 45
		refs = "0021 _wcrtomb_s"
	strings:
		$1 = { 55 8B EC 51 FF 75 10 83 4D FC FF 8B 45 08 FF 75 0C F7 D8 1B C0 83 E0 05 50 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 8B 45 FC 83 C4 14 C9 C3 }
	condition:
		$1
}

rule file_363_6_0 {
	meta:
		name = "__wcsrtombs_helper"
		size = 423
		refs = "0007 ___security_cookie 002b __errno 003b __invalid_parameter 0058 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0075 ?_wcrtomb_s_l@@YAHPAHPADI_W0PAUlocaleinfo_struct@@@Z 00fe @__security_check_cookie@4 0159 _memcpy_s"
	strings:
		$1 = { 55 8B EC 83 EC 34 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 45 0C 8B 4D 14 56 8B 75 08 57 33 FF 3B C7 89 75 E0 89 45 E8 89 4D DC 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AC 00 00 00 53 8B 18 57 8D 4D CC 89 7D EC 89 7D F0 E8 ?? ?? ?? ?? 3B F7 75 7B 8B 7D DC 8D 45 CC 50 0F B7 03 50 8D 45 F4 6A 05 50 8D 75 EC E8 ?? ?? ?? ?? 8B 45 EC 83 C4 10 85 C0 7E 3A 8D 4D F4 49 89 4D E8 EB 03 8B 4D E8 80 3C 01 00 74 3A 01 45 F0 8B 7D DC 43 8D 45 CC 50 43 0F B7 03 50 8D 45 F4 6A 05 50 8D 75 EC E8 ?? ?? ?? ?? 8B 45 EC 83 C4 10 85 C0 7F CF 80 7D D8 00 74 07 8B 45 D4 83 60 70 FD 83 C8 FF EB 26 8B 4D F0 8D 44 01 FF E9 B6 00 00 00 39 7D 10 77 27 80 7D D8 00 8B 45 E8 89 18 74 07 8B 45 D4 83 60 70 FD 8B 45 F0 5B 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 8B 75 E0 8B 45 CC 8B 4D 10 3B 88 AC 00 00 00 73 08 8D 45 F4 89 45 E4 EB 03 89 75 E4 8B 7D DC 8D 45 CC 50 0F B7 03 50 6A 05 FF 75 E4 8D 75 EC E8 ?? ?? ?? ?? 8B 75 EC 83 C4 10 85 F6 7E 39 8B 7D E0 3B 7D E4 74 16 39 75 10 72 91 56 8D 45 F4 50 FF 75 10 57 E8 ?? ?? ?? ?? 83 C4 10 8D 04 37 80 78 FF 00 74 1B 01 75 F0 43 43 29 75 10 89 45 E0 75 8E E9 65 FF FF FF 83 4D F0 FF E9 5C FF FF FF 8B 45 E8 83 20 00 8B 45 F0 8D 44 30 FF 80 7D D8 00 0F 84 5A FF FF FF 8B 4D D4 83 61 70 FD E9 4E FF FF FF }
	condition:
		$1
}

rule file_363_8_0 {
	meta:
		name = "_wcsrtombs_s"
		size = 158
		refs = "0026 __errno 0035 __invalid_parameter 005b __wcsrtombs_helper"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 08 33 DB 3B FB 74 03 83 0F FF 8B 75 0C 3B F3 75 07 39 5D 10 74 24 EB 05 39 5D 10 77 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 59 88 1E 39 5D 14 74 DE 8B 45 18 3B 45 10 76 03 8B 45 10 FF 75 1C 50 FF 75 14 56 E8 ?? ?? ?? ?? 83 C4 10 83 F8 FF 75 0F 3B F3 74 02 88 1E E8 ?? ?? ?? ?? 8B 00 EB 23 40 3B F3 74 16 39 45 10 73 0D 88 1E 76 09 E8 ?? ?? ?? ?? 6A 22 EB 9F 88 5C 30 FF 3B FB 74 02 89 07 33 C0 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_363_9_0 {
	meta:
		name = "_wctob"
		size = 87
		refs = "0007 ___security_cookie 002f ?_wcrtomb_s_l@@YAHPAHPADI_W0PAUlocaleinfo_struct@@@Z 0051 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 A1 ?? ?? ?? ?? 33 C5 89 45 FC 66 81 7D 08 FF FF 74 30 83 4D F0 FF 56 57 6A 00 FF 75 08 8D 45 F4 6A 05 50 33 FF 8D 75 F0 E8 ?? ?? ?? ?? 83 C4 10 85 C0 5F 5E 75 0C 83 7D F0 01 75 06 0F BE 45 F4 EB 03 83 C8 FF 8B 4D FC 33 CD E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_365_0_0 {
	meta:
		name = "__dup_nolock"
		size = 334
		refs = "0003 __sehtable$__dup_nolock 0008 __SEH_prolog4 001c ___pioinfo 0034 __alloc_osfhnd 0041 __errno 004c ___doserrno 0056 __SEH_epilog4 0069 __imp__GetCurrentProcess@0 0074 __get_osfhandle 007f __imp__DuplicateHandle@28 0089 __imp__GetLastError@0 0096 __set_osfhnd 00a4 __dosmaperr 0148 __unlock_fhandle"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D DC 8B 75 08 8B C6 C1 F8 05 8D 1C 85 ?? ?? ?? ?? 83 E6 1F 6B F6 28 8B 03 8A 44 30 04 88 45 E7 A8 01 74 1F E8 ?? ?? ?? ?? 89 45 E0 83 F8 FF 75 1B E8 ?? ?? ?? ?? C7 00 18 00 00 00 E8 ?? ?? ?? ?? 89 38 83 C8 FF E8 ?? ?? ?? ?? C3 89 7D FC 6A 02 6A 01 57 8D 45 D8 50 8B 3D ?? ?? ?? ?? FF D7 50 FF 75 08 E8 ?? ?? ?? ?? 59 50 FF D7 50 FF 15 ?? ?? ?? ?? 85 C0 75 08 FF 15 ?? ?? ?? ?? EB 0F FF 75 D8 FF 75 E0 E8 ?? ?? ?? ?? 59 59 33 C0 85 C0 74 09 50 E8 ?? ?? ?? ?? 59 EB 58 8B 45 E0 8B C8 C1 F9 05 8D 0C 8D ?? ?? ?? ?? 83 E0 1F 6B C0 28 8A 55 E7 80 E2 EF 8B 39 88 54 07 04 8B 11 8D 7C 02 24 8B 13 8A 54 32 24 02 D2 D0 FA 32 17 80 E2 7F 30 17 8B 09 8D 44 01 24 8B 0B 8A 4C 31 24 32 08 80 E1 7F 8B 13 32 4C 32 24 88 08 C7 45 DC 01 00 00 00 C7 45 FC FE FF FF FF E8 12 00 00 00 83 7D DC 00 0F 84 39 FF FF FF 8B 45 E0 E9 34 FF FF FF 83 7D DC 00 75 1D 8B 45 E0 C1 F8 05 8B 4D E0 83 E1 1F 6B C9 28 8B 04 85 ?? ?? ?? ?? 8D 44 08 04 80 20 FE FF 75 E0 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_365_1_0 {
	meta:
		name = "__dup"
		size = 216
		refs = "0003 __sehtable$__dup 0008 __SEH_prolog4 0019 ___doserrno 0021 __errno 003b __nhandle 0059 __invalid_parameter 006a ___pioinfo 0084 ___lock_fhandle 0099 __dup_nolock 00c9 __SEH_epilog4 00d2 __unlock_fhandle"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 4D E4 FF 8B 45 08 83 F8 FE 75 1B E8 ?? ?? ?? ?? 83 20 00 E8 ?? ?? ?? ?? C7 00 09 00 00 00 83 C8 FF E9 95 00 00 00 33 FF 3B C7 7C 08 3B 05 ?? ?? ?? ?? 72 21 E8 ?? ?? ?? ?? 89 38 E8 ?? ?? ?? ?? C7 00 09 00 00 00 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 EB C9 8B C8 C1 F9 05 8D 1C 8D ?? ?? ?? ?? 8B F0 83 E6 1F 6B F6 28 8B 0B 0F B6 4C 31 04 83 E1 01 74 BF 50 E8 ?? ?? ?? ?? 59 89 7D FC 8B 03 F6 44 30 04 01 74 0E FF 75 08 E8 ?? ?? ?? ?? 59 89 45 E4 EB 16 E8 ?? ?? ?? ?? C7 00 09 00 00 00 E8 ?? ?? ?? ?? 89 38 83 4D E4 FF C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_366_0_0 {
	meta:
		name = "_evaluate"
		size = 50
	strings:
		$1 = { DD 04 C8 DD 44 24 04 EB 05 DD 04 C8 DE C2 49 DC C9 85 C9 7F F4 DD 00 8D 42 FF DE C2 DD 04 D6 85 C0 D8 C9 7E 06 DC 04 C6 48 EB F4 DD D9 DC 06 DE F9 C3 }
	condition:
		$1
}

rule file_366_1_0 {
	meta:
		name = "__j0"
		size = 234
		refs = "001d __real@401e000000000000 0030 _J0q 0037 _J0p 0045 _evaluate 0050 __real@4020000000000000 0055 _P0q 005a _P0p 0081 _Q0q 008b _Q0p 009f __real@3fe921fb54442d18 00ad _cos 00be _sin 00d0 __real@400921fb54442d18 00d6 __real@4000000000000000 00de _sqrt"
	strings:
		$1 = { 55 8B EC D9 EE 83 EC 18 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 05 D9 E0 DD 55 08 DD 05 ?? ?? ?? ?? 56 D8 D9 51 51 DF E0 F6 C4 01 75 21 D9 C0 BE ?? ?? ?? ?? DE C9 B8 ?? ?? ?? ?? DD 1C 24 6A 04 5A 6A 0B 59 E8 ?? ?? ?? ?? E9 97 00 00 00 DC 3D ?? ?? ?? ?? BE ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 5D F8 DD 45 F8 DC 4D F8 DD 5D F0 DD 45 F0 DD 1C 24 6A 05 5A 8B CA E8 ?? ?? ?? ?? DD 5D E8 DD 45 F0 BE ?? ?? ?? ?? 8B CA DD 1C 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 4D F8 DD 5D F8 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 DD 5D E8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F8 DC 6D E8 DD 5D E8 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_366_2_0 {
	meta:
		name = "__j1"
		size = 256
		refs = "0028 __real@401e000000000000 003b _J1q 0042 _J1p 0050 _evaluate 0063 __real@4020000000000000 0068 _P1q 006d _P1p 0094 _Q1q 009e _Q1p 00b2 __real@4002d97c7f3321d2 00c0 _cos 00d1 _sin 00e3 __real@400921fb54442d18 00e9 __real@4000000000000000 00f1 _sqrt"
	strings:
		$1 = { 55 8B EC 83 EC 1C D9 EE C7 45 FC 01 00 00 00 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 09 83 4D FC FF D9 E0 DD 55 08 DD 05 ?? ?? ?? ?? 56 D8 D9 51 51 DF E0 F6 C4 01 75 29 D9 C0 BE ?? ?? ?? ?? DE C9 B8 ?? ?? ?? ?? DD 1C 24 6A 04 5A 6A 0A 59 E8 ?? ?? ?? ?? DB 45 FC DC 4D 08 DE C9 E9 9A 00 00 00 DC 3D ?? ?? ?? ?? BE ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 5D F4 DD 45 F4 DC 4D F4 DD 5D EC DD 45 EC DD 1C 24 6A 05 5A 8B CA E8 ?? ?? ?? ?? DD 5D E4 DD 45 EC BE ?? ?? ?? ?? 8B CA DD 1C 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 4D F4 DD 5D F4 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D EC DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? DC 4D E4 DD 5D E4 DD 45 EC DD 1C 24 E8 ?? ?? ?? ?? DC 4D F4 DC 6D E4 DD 5D E4 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DA 4D FC DC 4D E4 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_366_3_0 {
	meta:
		name = "__jn"
		size = 317
		refs = "0028 __j0 003f __j1 0069 _fabs"
	strings:
		$1 = { 55 8B EC 83 EC 14 56 8B 75 08 85 F6 7D 0F DD 45 0C F7 DE D9 E0 89 75 08 DD 5D 0C 85 F6 75 12 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 07 01 00 00 83 FE 01 75 12 DD 45 0C 51 51 DD 1C 24 E8 ?? ?? ?? ?? E9 F0 00 00 00 D9 EE DC 55 0C DF E0 F6 C4 44 0F 8B E2 00 00 00 DD D8 51 DB 45 08 51 DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DC 5D F4 59 03 F6 59 DF E0 DD 45 0C F6 C4 41 75 54 51 51 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? D9 C0 59 D9 C9 59 DC C0 6A 04 58 3B F0 DC 75 0C 89 45 FC DC 65 F4 75 09 DD D9 E9 85 00 00 00 D9 C9 D9 C0 DB 45 FC 83 45 FC 02 39 75 FC DE CA D9 C9 DC 75 0C DE E2 75 E7 DD D8 EB 68 D9 C0 8D 46 24 3B C6 D8 C9 D9 EE 89 75 08 89 45 FC 7E 10 DA 6D FC 83 6D FC 02 39 75 FC D9 C1 DE F1 7F F0 DD D9 83 C6 FE DA 6D 08 89 75 FC D9 C1 DE F1 DD 55 EC D9 E8 DB 45 FC 83 6D FC 02 D8 F3 DE E2 D9 C9 DD 5D F4 74 0B DD 45 F4 DB 45 FC DC 4D F4 EB E6 51 DD D8 51 DD 1C 24 E8 ?? ?? ?? ?? DC 4D EC DC 75 F4 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_366_4_0 {
	meta:
		name = "_domain_err"
		size = 51
		refs = "000b __ctrlfp 002b __except1"
	strings:
		$1 = { 68 FF FF 00 00 68 3F 13 00 00 E8 ?? ?? ?? ?? DD 44 24 18 59 59 50 83 EC 10 DD 5C 24 08 DD 44 24 1C DD 1C 24 FF 74 24 18 6A 08 E8 ?? ?? ?? ?? 83 C4 1C C3 }
	condition:
		$1
}

rule file_366_5_0 {
	meta:
		name = "__y0"
		size = 296
		refs = "0018 __d_ind 0029 _domain_err 0034 __real@401e000000000000 0047 _Y0q 004e _Y0p 005b _evaluate 0069 __j0 006f __real@3fe45f306dc9c883 007d _log 008e __real@4020000000000000 0093 _P0q 0098 _P0p 00bf _Q0q 00c9 _Q0p 00dd __real@3fe921fb54442d18 00eb _cos 00fc _sin 010e __real@400921fb54442d18 0114 __real@4000000000000000 011c _sqrt"
	strings:
		$1 = { 55 8B EC D9 EE 83 EC 18 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 22 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DD 05 ?? ?? ?? ?? 56 D8 D9 51 51 DF E0 F6 C4 01 75 48 D9 C0 BE ?? ?? ?? ?? DE C9 B8 ?? ?? ?? ?? DD 1C 24 6A 08 59 8B D1 E8 ?? ?? ?? ?? DD 5D F8 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 0D ?? ?? ?? ?? DD 5D F0 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F0 DC 45 F8 E9 97 00 00 00 DC 3D ?? ?? ?? ?? BE ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 5D F8 DD 45 F8 DC 4D F8 DD 5D F0 DD 45 F0 DD 1C 24 6A 05 5A 8B CA E8 ?? ?? ?? ?? DD 5D E8 DD 45 F0 BE ?? ?? ?? ?? 8B CA DD 1C 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 4D F8 DD 5D F8 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F8 DD 5D F8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 DC 45 F8 DD 5D E8 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_366_6_0 {
	meta:
		name = "__y1"
		size = 306
		refs = "0018 __d_ind 0029 _domain_err 0034 __real@401e000000000000 0048 __j1 0056 _log 005e _Y1q 0065 _Y1p 0070 __real@3fe45f306dc9c883 0087 _evaluate 0098 __real@4020000000000000 009d _P1q 00a2 _P1p 00c9 _Q1q 00d3 _Q1p 00e7 __real@4002d97c7f3321d2 00f5 _cos 0106 _sin 0118 __real@400921fb54442d18 011e __real@4000000000000000 0126 _sqrt"
	strings:
		$1 = { 55 8B EC D9 EE 83 EC 18 DD 45 08 D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 23 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 DD 05 ?? ?? ?? ?? 56 D8 D9 51 51 DF E0 F6 C4 01 75 52 DD 1C 24 E8 ?? ?? ?? ?? DD 5D F0 DD 45 08 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F0 BE ?? ?? ?? ?? D9 E8 B8 ?? ?? ?? ?? DC 75 08 DE E9 DC 0D ?? ?? ?? ?? DD 5D F0 DD 45 08 DC 4D 08 DD 1C 24 6A 08 5A 6A 07 59 E8 ?? ?? ?? ?? DC 4D 08 DC 45 F0 E9 97 00 00 00 DC 3D ?? ?? ?? ?? BE ?? ?? ?? ?? B8 ?? ?? ?? ?? DD 5D F8 DD 45 F8 DC 4D F8 DD 5D F0 DD 45 F0 DD 1C 24 6A 05 5A 8B CA E8 ?? ?? ?? ?? DD 5D E8 DD 45 F0 BE ?? ?? ?? ?? 8B CA DD 1C 24 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? DC 4D F8 DD 5D F8 DD 45 08 DC 25 ?? ?? ?? ?? DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D F8 DD 5D F8 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 DC 45 F8 DD 5D E8 DD 45 08 DC 0D ?? ?? ?? ?? DC 3D ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 59 59 5E C9 C3 }
	condition:
		$1
}

rule file_366_7_0 {
	meta:
		name = "__yn"
		size = 198
		refs = "0018 __d_ind 0029 _domain_err 0057 __y0 0063 __y1 0083 __real@4000000000000000"
	strings:
		$1 = { 55 8B EC D9 EE 83 EC 14 DD 45 0C D8 D1 DF E0 DD D9 F6 C4 05 7A 1C DD 05 ?? ?? ?? ?? 83 EC 10 DD 5C 24 08 DD 1C 24 6A 24 E8 ?? ?? ?? ?? 83 C4 14 C9 C3 53 33 DB 43 83 7D 08 00 89 5D FC 7D 10 F7 5D 08 84 5D 08 74 04 83 4D FC FF 83 7D 08 00 51 51 DD 1C 24 75 07 E8 ?? ?? ?? ?? EB 0A 39 5D 08 75 0C E8 ?? ?? ?? ?? DA 4D FC 59 59 EB 55 E8 ?? ?? ?? ?? DD 5D F4 DD 45 0C DD 1C 24 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 8B 45 08 3B C3 DC 75 0C 59 59 89 5D 10 7F 06 DD D9 EB 21 D9 C9 DB 45 10 FF 45 10 39 45 10 D8 C9 D8 CA DC 65 F4 DD 5D EC D9 C9 DD 5D F4 DD 45 EC 7C E1 DD D8 DD D8 DB 45 FC DC 4D EC 5B C9 C3 }
	condition:
		$1
}

rule file_367_3_0 {
	meta:
		name = "__mbsstr_l"
		size = 319
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0023 _strstr 0046 __errno 0056 __invalid_parameter 00bd _strlen"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 FF 75 10 8D 4D E8 E8 ?? ?? ?? ?? 8B 45 EC 33 DB 39 58 08 75 22 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 38 5D F4 59 59 0F 84 FA 00 00 00 8B 4D F0 83 61 70 FD E9 EE 00 00 00 8B 45 0C 3B C3 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 E9 BC 00 00 00 38 18 75 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B 45 08 E9 A4 00 00 00 56 8B 75 08 3B F3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 EB 73 57 50 8B FE E8 ?? ?? ?? ?? 89 75 F8 29 45 F8 56 E8 ?? ?? ?? ?? 03 45 F8 38 1E 59 59 74 46 2B 75 0C 3B F8 77 3F 8A 17 3A D3 8B 4D 0C 88 55 FF 74 11 8A 11 3A D3 74 40 38 14 0E 75 06 41 38 1C 0E 75 EF 38 19 74 31 0F B6 4D FF 8B 55 EC 8A 4C 11 1D 80 E1 04 47 46 84 C9 74 06 38 1F 74 06 47 46 38 1F 75 BD 38 5D F4 74 07 8B 45 F0 83 60 70 FD 33 C0 5F 5E 5B C9 C3 38 5D F4 74 07 8B 45 F0 83 60 70 FD 8B C7 EB EB }
	condition:
		$1
}

rule file_368_0_0 {
	meta:
		name = "_ceil"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __ceil_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_455_0_0 {
	meta:
		name = "_floor"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __floor_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_401_0_0 {
	meta:
		name = "_modf"
		size = 64
		refs = "0002 ___use_sse2_mathfcns 0009 __modf_default"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 0F 84 ?? ?? ?? ?? 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 0F 85 ?? ?? ?? ?? EB 00 }
	condition:
		$1
}

rule file_368_1_0 {
	meta:
		name = "__ceil_pentium4"
		size = 221
		refs = "000a _Bns 0023 _S 0076 ___libm_error_support 00a7 _One 00bc _NegZero 00c5 _Zero"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 C8 66 0F 28 F8 66 0F 73 D0 34 66 0F 7E C0 66 0F 54 05 ?? ?? ?? ?? 66 0F FA D0 66 0F D3 CA A9 00 08 00 00 74 4C 3D FF 0B 00 00 7C 7D 66 0F F3 CA 3D 32 0C 00 00 7F 0B 66 0F D6 4C 24 04 DD 44 24 04 C3 66 0F 2E FF 7B 24 BA EC 03 00 00 83 EC 10 89 54 24 0C 8B D4 83 C2 14 89 54 24 08 89 54 24 04 89 14 24 E8 ?? ?? ?? ?? 83 C4 10 DD 44 24 04 C3 F3 0F 7E 44 24 04 66 0F F3 CA 66 0F 28 D8 66 0F C2 C1 06 3D FF 03 00 00 7C 25 3D 32 04 00 00 7F B0 66 0F 54 05 ?? ?? ?? ?? F2 0F 58 C8 66 0F D6 4C 24 04 DD 44 24 04 C3 DD 05 ?? ?? ?? ?? C3 66 0F C2 1D ?? ?? ?? ?? 06 66 0F 54 1D ?? ?? ?? ?? 66 0F D6 5C 24 04 DD 44 24 04 C3 }
	condition:
		$1
}

rule file_369_0_0 {
	meta:
		name = "_LoadOperand"
		size = 493
	strings:
		$1 = { 55 8B EC 8B 45 0C 83 F8 1F 8B 4D 14 89 01 75 06 83 61 20 FE 5D C3 83 F8 15 74 3E 83 F8 14 74 39 83 F8 17 74 34 83 F8 1B 74 2F 80 7D 08 00 74 40 83 F8 12 6A 0D 5A 75 02 89 11 83 F8 13 75 06 C7 01 19 00 00 00 83 F8 0E 75 02 89 11 83 F8 0C 75 1F C7 01 0B 00 00 00 EB 17 80 7D 08 00 74 0B 83 F8 14 75 06 C7 01 08 00 00 00 8B 45 10 89 41 04 53 56 8B 75 18 57 33 C0 8D 51 10 8B FA AB AB AB AB 83 49 20 01 8B 39 83 FF 13 8B 41 20 8D 9E CC 00 00 00 0F 87 C7 00 00 00 0F 84 B9 00 00 00 83 EF 08 74 54 83 EF 03 74 3C 4F 74 31 4F 74 29 4F 74 11 83 EF 04 0F 85 2D 01 00 00 83 E0 E1 E9 D5 00 00 00 83 E0 E1 89 41 20 8B 5B 10 8B 03 89 02 8B 43 04 E9 0D 01 00 00 83 E0 E1 EB 0E 83 E0 EB 83 C8 0A EB E1 83 E0 EB 83 C8 0A 89 41 20 8B 43 10 8B 00 E9 96 00 00 00 83 E0 EB 83 C8 0A 89 41 20 8B 45 10 83 E8 00 74 47 48 74 3C 48 74 31 48 74 26 48 48 74 1A 48 74 0F 48 0F 85 C8 00 00 00 8B 86 9C 00 00 00 EB 66 8B 86 A0 00 00 00 EB 5E 8B 86 B4 00 00 00 EB 56 8B 86 A4 00 00 00 EB 4E 8B 86 A8 00 00 00 EB 46 8B 86 AC 00 00 00 EB 3E 8B 86 B0 00 00 00 EB 36 83 E0 E3 83 C8 02 EB 38 83 EF 14 74 65 4F 74 49 6A 02 5E 2B FE 74 3B 2B FE 74 2D 4F 74 1C 4F 75 6F 83 E0 EB 83 C8 0A 89 41 20 8B 45 10 83 C0 0A C1 E0 04 8B 04 18 89 02 EB 56 83 E0 EB 83 C8 0A 89 41 20 8B 73 10 EB 22 83 E0 E3 0B C6 E9 1C FF FF FF 83 E0 E3 0B C6 EB 03 83 E0 E1 8B 75 10 83 C6 0A C1 E6 04 89 41 20 03 F3 8B FA A5 A5 A5 A5 EB 1E 83 E0 EB 83 C8 0A 89 41 20 8B 45 10 83 C0 02 C1 E0 04 8B 0C 18 89 0A 8B 44 18 04 89 42 04 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_369_1_0 {
	meta:
		name = "_LoadImm8"
		size = 79
	strings:
		$1 = { 56 8B 74 24 08 8B 0E 8B C1 C1 E8 0E 83 E0 03 83 F8 03 6A 02 5A 74 32 C1 E9 08 83 E1 07 83 F9 04 75 03 6A 03 5A 83 F8 01 75 01 42 83 F8 02 75 03 83 C2 04 85 C0 75 08 83 F9 05 75 03 83 C2 04 83 F8 01 75 05 85 C9 75 01 42 0F B6 04 32 5E C3 }
	condition:
		$1
}

rule file_369_2_0 {
	meta:
		name = "_AdjustExceptionResult"
		size = 448
		refs = "00bb $LN61 00c2 $LN70 00e1 $LN62 00e8 $LN71 00fa $LN63 0101 $LN72 0123 $LN64 012a $LN73 0180 $LN39 0184 $LN40 01a0 $LN16 01a4 $LN17"
	strings:
		$1 = { 8B 4C 24 08 8B 41 20 8B 50 60 F6 C2 01 0F 84 6A 01 00 00 83 E2 1E 80 FA 0E 0F 85 5E 01 00 00 8B 54 24 04 83 FA 55 53 56 57 0F 87 FF 00 00 00 6A 07 83 CB FF 33 F6 83 FA 54 5F 73 3A 83 FA 39 0F 82 35 01 00 00 83 FA 3A 76 08 83 FA 3C E9 E4 00 00 00 8B 50 50 2B D6 74 7E 4A 74 6A 4A 74 52 4A 75 14 8B 51 18 83 FA 02 76 09 83 FA 06 76 63 3B D7 75 03 89 70 50 8B 41 20 8B 50 50 2B D6 0F 84 95 00 00 00 4A 74 7E 4A 74 62 4A 0F 85 E9 00 00 00 8B 49 18 83 F9 02 76 0D 83 F9 06 76 73 3B CF 0F 85 D4 00 00 00 89 70 50 89 70 54 E9 C9 00 00 00 8B 51 18 3B D7 77 BE 0F B6 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 51 18 83 FA 03 76 A5 3B D7 77 A4 89 58 50 EB 9F 8B 51 18 3B D7 77 98 0F B6 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B 49 18 3B CF 0F 87 83 00 00 00 0F B6 89 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 8B 49 18 83 F9 03 76 99 3B CF 77 69 89 58 50 89 58 54 EB 61 8B 49 18 3B CF 77 5A 0F B6 89 ?? ?? ?? ?? FF 24 8D ?? ?? ?? ?? 83 FA 56 72 47 83 FA 57 77 42 8B 40 50 83 E8 00 74 2C 48 74 20 48 74 10 48 75 31 8B 41 1C 25 6F F7 FF FF 83 C8 45 EB 21 8B 41 1C 25 2B F7 FF FF 83 C8 01 EB 14 81 61 1C 2A F7 FF FF EB 0E 8B 41 1C 25 6A F7 FF FF 83 C8 40 89 41 1C 5F 5E 5B C3 8B FF ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 01 00 01 00 00 01 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 01 01 00 01 00 }
	condition:
		$1
}

rule file_369_3_0 {
	meta:
		name = "_UpdateResult"
		size = 304
		refs = "0025 $LN24 002c $LN27 00fc $LN12 0100 $LN10 0104 $LN17 0108 $LN18 010c $LN19 0110 $LN13 0114 $LN14 0118 $LN20"
	strings:
		$1 = { 8B 44 24 04 8B 10 8B 4C 24 08 53 56 83 C2 F8 83 FA 13 57 8B 78 04 8D 99 6C 01 00 00 0F 87 D3 00 00 00 0F B6 92 ?? ?? ?? ?? FF 24 95 ?? ?? ?? ?? 8B B9 DC 00 00 00 8D 70 10 A5 A5 A5 A5 E9 B3 00 00 00 8B 50 10 8B 89 DC 00 00 00 89 11 8B 40 14 89 41 04 E9 9D 00 00 00 8B 89 DC 00 00 00 8B 40 10 89 01 E9 8D 00 00 00 C1 E7 04 03 FB EB C7 8B 50 10 C1 E7 04 89 94 0F EC 00 00 00 8B 40 14 89 84 0F F0 00 00 00 EB 6D 83 EF 00 74 55 4F 74 47 4F 74 39 4F 74 2B 4F 4F 74 1C 4F 74 0E 4F 75 4B 8B 40 10 89 81 9C 00 00 00 EB 40 8B 40 10 89 81 A0 00 00 00 EB 35 8B 40 10 89 81 B4 00 00 00 EB 2A 8B 40 10 89 81 A4 00 00 00 EB 1F 8B 40 10 89 81 A8 00 00 00 EB 14 8B 40 10 89 81 AC 00 00 00 EB 09 8B 40 10 89 81 B0 00 00 00 8B 44 24 18 89 81 C0 00 00 00 5F 5E 5B C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 01 07 02 03 02 03 07 07 07 04 04 05 06 07 06 07 03 04 06 }
	condition:
		$1
}

rule file_369_4_0 {
	meta:
		name = "_ValidateResult"
		size = 78
	strings:
		$1 = { 8B 4C 24 04 8B 51 04 8B 09 53 8B D9 33 DA 32 C0 F6 C3 01 74 02 FE C0 8B D9 33 DA F6 C3 02 74 02 B0 01 8B D9 33 DA F6 C3 04 74 02 B0 01 8B D9 33 DA F6 C3 08 74 02 B0 01 8B D9 33 DA F6 C3 10 5B 74 02 B0 01 33 CA F6 C1 20 74 02 B0 01 C3 }
	condition:
		$1
}

rule file_369_5_0 {
	meta:
		name = "_SetPniOperation"
		size = 109
	strings:
		$1 = { 55 8B EC 8B 45 08 83 E8 43 74 3E 48 74 47 48 74 4F 83 E8 20 74 20 48 74 12 48 74 04 32 C0 5D C3 8B 45 0C C7 00 48 00 00 00 EB 3E 8B 45 0C C7 00 46 00 00 00 EB 33 8B 4D 0C 33 C0 39 45 10 0F 94 C0 8D 44 00 46 89 01 EB 20 83 7D 10 00 74 11 83 7D 10 02 74 0B 8B 45 0C C7 00 2B 00 00 00 EB 09 8B 45 0C C7 00 2D 00 00 00 B0 01 5D C3 }
	condition:
		$1
}

rule file_369_6_0 {
	meta:
		name = "_ax0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 B0 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_369_7_0 {
	meta:
		name = "_ax8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 B0 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_369_8_0 {
	meta:
		name = "_ax32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 B0 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_369_9_0 {
	meta:
		name = "_cx0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 AC 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_369_10_0 {
	meta:
		name = "_cx8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 AC 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_369_11_0 {
	meta:
		name = "_cx32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 AC 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_369_12_0 {
	meta:
		name = "_dx0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 A8 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_369_13_0 {
	meta:
		name = "_dx8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 A8 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_369_14_0 {
	meta:
		name = "_dx32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 A8 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_369_15_0 {
	meta:
		name = "_bx0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 A4 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_369_16_0 {
	meta:
		name = "_bx8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 A4 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_369_17_0 {
	meta:
		name = "_bx32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 A4 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_369_18_0 {
	meta:
		name = "_sib0"
		size = 328
		refs = "0031 $LN31 00ab $LN32 0108 $LN23 010c $LN22 0110 $LN21 0114 $LN20 0118 $LN19 011c $LN18 0120 $LN17 0124 $LN16 0128 $LN9 012c $LN8 0130 $LN7 0134 $LN6 0138 $LN5 013c $LN4 0140 $LN3 0144 $LN2"
	strings:
		$1 = { 55 8B EC 53 56 57 8B 7D 10 0F B6 17 33 F6 8B C2 6A 07 8B CA C1 E9 06 C1 E8 03 46 5B D3 E6 8B 4D 0C 23 C3 83 F8 04 74 4D 23 C3 3B C3 77 47 FF 24 85 ?? ?? ?? ?? 8B 81 B0 00 00 00 EB 3A 8B 81 AC 00 00 00 EB 32 8B 81 A8 00 00 00 EB 2A 8B 81 A4 00 00 00 EB 22 8B 81 C4 00 00 00 EB 1A 8B 81 B4 00 00 00 EB 12 8B 81 A0 00 00 00 EB 0A 8B 81 9C 00 00 00 EB 02 33 C0 23 D3 83 FA 05 75 0F 8B 4D 08 0F AF C6 03 47 01 52 89 01 58 EB 75 83 FA 04 75 10 0F AF C6 03 81 C4 00 00 00 8B 4D 08 89 01 EB 5D 23 D3 3B D3 77 4C FF 24 95 ?? ?? ?? ?? 8B 91 B0 00 00 00 8B 4D 08 89 11 EB 3E 8B 91 AC 00 00 00 EB F1 8B 91 A8 00 00 00 EB E9 8B 91 A4 00 00 00 EB E1 8B 91 C4 00 00 00 EB D9 8B 91 B4 00 00 00 EB D1 8B 91 A0 00 00 00 EB C9 8B 91 9C 00 00 00 EB C1 8B 4D 08 83 21 00 0F AF C6 01 01 33 C0 40 5F 5E 5B 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_19_0 {
	meta:
		name = "_sib8"
		size = 320
		refs = "0031 $LN30 009d $LN31 0100 $LN22 0104 $LN21 0108 $LN20 010c $LN19 0110 $LN18 0114 $LN17 0118 $LN16 011c $LN15 0120 $LN9 0124 $LN8 0128 $LN7 012c $LN6 0130 $LN5 0134 $LN4 0138 $LN3 013c $LN2"
	strings:
		$1 = { 55 8B EC 53 8B 5D 10 0F B6 13 56 57 33 F6 8B C2 6A 07 8B CA C1 E9 06 C1 E8 03 46 5F D3 E6 8B 4D 0C 23 C7 83 F8 04 74 4D 23 C7 3B C7 77 47 FF 24 85 ?? ?? ?? ?? 8B 81 B0 00 00 00 EB 3A 8B 81 AC 00 00 00 EB 32 8B 81 A8 00 00 00 EB 2A 8B 81 A4 00 00 00 EB 22 8B 81 C4 00 00 00 EB 1A 8B 81 B4 00 00 00 EB 12 8B 81 A0 00 00 00 EB 0A 8B 81 9C 00 00 00 EB 02 33 C0 23 D7 83 FA 04 75 16 0F B6 53 01 0F AF C6 03 C2 03 81 C4 00 00 00 8B 4D 08 89 01 EB 63 23 D7 3B D7 77 4C FF 24 95 ?? ?? ?? ?? 8B 91 B0 00 00 00 8B 4D 08 89 11 EB 3E 8B 91 AC 00 00 00 EB F1 8B 91 A8 00 00 00 EB E9 8B 91 A4 00 00 00 EB E1 8B 91 C4 00 00 00 EB D9 8B 91 B4 00 00 00 EB D1 8B 91 A0 00 00 00 EB C9 8B 91 9C 00 00 00 EB C1 8B 4D 08 83 21 00 0F B6 53 01 0F AF C6 03 C2 01 01 6A 02 58 5F 5E 5B 5D C3 90 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_20_0 {
	meta:
		name = "_sib32"
		size = 316
		refs = "0031 $LN30 009a $LN31 00fc $LN22 0100 $LN21 0104 $LN20 0108 $LN19 010c $LN18 0110 $LN17 0114 $LN16 0118 $LN15 011c $LN9 0120 $LN8 0124 $LN7 0128 $LN6 012c $LN5 0130 $LN4 0134 $LN3 0138 $LN2"
	strings:
		$1 = { 55 8B EC 53 8B 5D 10 0F B6 13 56 57 33 F6 8B C2 6A 07 8B CA C1 E9 06 C1 E8 03 46 5F D3 E6 8B 4D 0C 23 C7 83 F8 04 74 4D 23 C7 3B C7 77 47 FF 24 85 ?? ?? ?? ?? 8B 81 B0 00 00 00 EB 3A 8B 81 AC 00 00 00 EB 32 8B 81 A8 00 00 00 EB 2A 8B 81 A4 00 00 00 EB 22 8B 81 C4 00 00 00 EB 1A 8B 81 B4 00 00 00 EB 12 8B 81 A0 00 00 00 EB 0A 8B 81 9C 00 00 00 EB 02 33 C0 23 D7 83 FA 04 75 13 0F AF C6 03 81 C4 00 00 00 8B 4D 08 03 43 01 89 01 EB 60 23 D7 3B D7 77 4C FF 24 95 ?? ?? ?? ?? 8B 91 B0 00 00 00 8B 4D 08 89 11 EB 3E 8B 91 AC 00 00 00 EB F1 8B 91 A8 00 00 00 EB E9 8B 91 A4 00 00 00 EB E1 8B 91 C4 00 00 00 EB D9 8B 91 B4 00 00 00 EB D1 8B 91 A0 00 00 00 EB C9 8B 91 9C 00 00 00 EB C1 8B 4D 08 83 21 00 0F AF C6 03 43 01 01 01 6A 05 58 5F 5E 5B 5D C3 8D 49 00 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_369_21_0 {
	meta:
		name = "_d32"
		size = 16
	strings:
		$1 = { 8B 44 24 0C 8B 00 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_369_22_0 {
	meta:
		name = "_bp8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 B4 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_369_23_0 {
	meta:
		name = "_bp32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 B4 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_369_24_0 {
	meta:
		name = "_si0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 A0 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_369_25_0 {
	meta:
		name = "_si8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 A0 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_369_26_0 {
	meta:
		name = "_si32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 A0 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_369_27_0 {
	meta:
		name = "_di0"
		size = 19
	strings:
		$1 = { 8B 44 24 08 8B 80 9C 00 00 00 8B 4C 24 04 89 01 33 C0 C3 }
	condition:
		$1
}

rule file_369_28_0 {
	meta:
		name = "_di8"
		size = 27
	strings:
		$1 = { 8B 44 24 0C 0F B6 00 8B 4C 24 08 03 81 9C 00 00 00 8B 4C 24 04 89 01 33 C0 40 C3 }
	condition:
		$1
}

rule file_369_29_0 {
	meta:
		name = "_di32"
		size = 26
	strings:
		$1 = { 8B 44 24 08 8B 80 9C 00 00 00 8B 4C 24 0C 03 01 8B 4C 24 04 6A 04 89 01 58 C3 }
	condition:
		$1
}

rule file_369_31_0 {
	meta:
		name = "_fpieee_flt_simd"
		size = 2656
		refs = "0018 __sehtable$_fpieee_flt_simd 001d __except_handler4 0032 ___security_cookie 01ad _InstInfoTableEX 01b4 _InstInfoTableDX 01ca _InstInfoTableCX 01d1 _InstInfoTable7X 01d8 _InstInfoTable5X 01df _InstInfoTable2X 024e _InstInfoTableX 02fe _modrm32 0338 _LoadOperand 0572 _SetPniOperation 087e _XMMI_FP_Emulation 0893 _XMMI2_FP_Emulation 0919 _AdjustExceptionResult 09c9 _UpdateResult 0a55 @__security_check_cookie@4"
	strings:
		$1 = { 53 8B DC 51 51 83 E4 F0 83 C4 04 55 8B 6B 04 89 6C 24 04 8B EC 6A FE 68 ?? ?? ?? ?? 68 ?? ?? ?? ?? 64 A1 00 00 00 00 50 51 51 53 81 EC B8 01 00 00 A1 ?? ?? ?? ?? 31 45 F8 33 C5 89 45 DC 56 57 50 8D 45 F0 64 A3 00 00 00 00 89 65 E8 8B 43 0C 8B 73 10 89 B5 38 FE FF FF 83 8D 64 FE FF FF FF 33 D2 89 95 84 FE FF FF 89 95 70 FE FF FF 8B 08 8B 49 14 3B CA 74 09 51 FF D6 59 E9 C2 09 00 00 8B 48 04 89 8D 74 FE FF FF 8B 31 B8 20 00 01 00 23 F0 3B F0 0F 85 A6 09 00 00 8B 81 DC 00 00 00 89 85 3C FE FF FF 89 95 80 FE FF FF 88 95 8F FE FF FF 89 55 FC 33 F6 46 C6 85 7F FE FF FF 01 C6 85 7A FE FF FF 00 8B 89 B8 00 00 00 89 8D 88 FE FF FF 80 BD 7F FE FF FF 00 74 77 8A 01 88 85 7E FE FF FF 41 89 8D 88 FE FF FF 0F B6 C0 83 F8 66 7F 26 74 56 83 F8 26 74 16 83 F8 2E 74 11 83 F8 36 74 0C 83 F8 3E 74 07 83 C0 9C 3B C6 77 1C C6 85 8F FE FF FF 01 EB BA 83 E8 67 74 F2 2D 89 00 00 00 74 EB 48 48 74 1B 48 74 09 C6 85 7F FE FF FF 00 EB 9E C6 85 7A FE FF FF 01 FF 85 84 FE FF FF EB 8F C6 85 7A FE FF FF 01 89 B5 80 FE FF FF EB E9 C7 45 FC FE FF FF FF 80 BD 8F FE FF FF 00 0F 85 DA 08 00 00 89 75 FC 89 8D 6C FE FF FF 80 BD 7E FE FF FF 0F 74 12 C6 85 8F FE FF FF 01 8B B5 68 FE FF FF E9 82 02 00 00 8B 09 8B C1 C1 E8 04 83 E0 0F 48 48 74 46 83 E8 03 74 3A 48 48 74 2F 83 E8 05 74 23 48 74 0A 48 75 CC BE ?? ?? ?? ?? EB 30 BE ?? ?? ?? ?? 80 BD 7A FE FF FF 00 74 22 89 95 80 FE FF FF EB 1A BE ?? ?? ?? ?? EB 13 BE ?? ?? ?? ?? EB E1 BE ?? ?? ?? ?? EB 05 BE ?? ?? ?? ?? 8B D1 B8 00 C0 00 00 23 D0 3B D0 0F 95 C2 0F B6 C2 C1 E0 04 83 E1 0F 0B C1 83 F8 20 0F 87 73 FF FF FF 8B 8D 80 FE FF FF 8D 04 41 8D 34 86 89 B5 68 FE FF FF 8B 06 BF FF 0F 00 00 85 C7 75 0C C6 85 8F FE FF FF 01 E9 DE 01 00 00 8B C8 81 E1 00 F0 01 00 81 F9 00 E0 01 00 75 34 C1 E8 11 83 E0 1F 80 BD 7A FE FF FF 00 8D 34 85 ?? ?? ?? ?? 75 07 8D 34 85 ?? ?? ?? ?? 89 B5 68 FE FF FF C6 85 7A FE FF FF 00 C7 85 80 FE FF FF 02 00 00 00 8B 06 23 C7 83 F8 43 74 0A 83 F8 44 74 05 83 F8 45 75 07 C6 85 7A FE FF FF 00 83 F8 65 74 0A 83 F8 66 74 05 83 F8 67 75 0A C7 85 80 FE FF FF 01 00 00 00 0F B6 8D 7A FE FF FF 03 C8 89 8D B8 FE FF FF 83 85 84 FE FF FF 03 84 D2 74 4C 8B 85 88 FE FF FF 89 85 88 FE FF FF FF 85 88 FE FF FF 8B 85 88 FE FF FF 8A 00 88 85 7E FE FF FF FF 85 88 FE FF FF 0F B6 C8 FF B5 88 FE FF FF 8B 85 74 FE FF FF 50 05 DC 00 00 00 50 FF 14 8D ?? ?? ?? ?? 83 C4 0C 89 85 70 FE FF FF FF B5 74 FE FF FF 8D 85 D0 FE FF FF 50 8B 85 6C FE FF FF 8B 00 C1 E8 0B 83 E0 07 50 8B 06 C1 E8 0C 83 E0 1F 50 8B BD 7A FE FF FF 57 E8 ?? ?? ?? ?? 83 C4 14 8B 06 8B D0 B9 00 F0 01 00 23 D1 FF B5 74 FE FF FF C1 E8 11 83 E0 1F 3B D1 75 29 8D 8D D0 FE FF FF 51 8B 8D 6C FE FF FF 8B 09 C1 E9 08 83 E1 07 51 50 57 E8 ?? ?? ?? ?? 83 C4 14 83 A5 20 FF FF FF FE EB 20 8D 8D 00 FF FF FF 51 8B 8D 6C FE FF FF 8B 09 C1 E9 08 83 E1 07 51 50 57 E8 ?? ?? ?? ?? 83 C4 14 FF B5 74 FE FF FF 8D 85 30 FF FF FF 50 8B 85 6C FE FF FF 8B 00 C1 E8 0B 83 E0 07 50 8B 06 C1 E8 19 83 E0 1F 50 57 E8 ?? ?? ?? ?? 83 C4 14 8B 85 70 FE FF FF 01 85 84 FE FF FF 8B 06 25 00 00 C0 01 3D 00 00 40 00 75 21 8B 85 88 FE FF FF 03 85 70 FE FF FF 89 85 88 FE FF FF 0F B6 00 89 85 BC FE FF FF FF 85 84 FE FF FF C7 45 FC FE FF FF FF 80 BD 8F FE FF FF 00 0F 85 20 06 00 00 8B BD 74 FE FF FF 0F B7 87 CC 00 00 00 B9 00 03 00 00 23 C1 74 20 3D 00 02 00 00 74 0D 3B C1 75 1F 83 A5 54 FE FF FF 00 EB 16 C7 85 54 FE FF FF 01 00 00 00 EB 0A C7 85 54 FE FF FF 02 00 00 00 8B 87 E4 00 00 00 8B C8 C1 E9 0D 6A 03 5A 23 CA 83 E9 00 74 29 49 74 1A 49 74 0B 49 75 27 89 95 50 FE FF FF EB 1F C7 85 50 FE FF FF 02 00 00 00 EB 13 C7 85 50 FE FF FF 01 00 00 00 EB 07 83 A5 50 FE FF FF 00 8B C8 C1 E9 07 83 E1 3F 89 8D 40 FE FF FF 8B C8 C1 E9 0F 83 E1 01 89 8D 48 FE FF FF 8B C8 C1 E9 06 83 E1 01 89 8D 4C FE FF FF 8B 8F C0 00 00 00 89 8D 5C FE FF FF 8B 8D BC FE FF FF 89 8D 58 FE FF FF 83 E0 3F 89 85 90 FE FF FF 83 A5 94 FE FF FF 00 8B 06 C1 E8 1E 40 89 85 6C FE FF FF 80 BD 7A FE FF FF 00 74 09 33 C0 40 89 85 6C FE FF FF 33 F6 85 C0 0F 86 9B 04 00 00 6A E0 5F 83 A5 44 FE FF FF 00 21 BD 64 FF FF FF 21 BD 68 FF FF FF 21 BD 6C FF FF FF 8B 85 54 FE FF FF 83 E0 07 C1 E0 02 8B 8D 60 FF FF FF 23 CF 0B C1 8B 8D 50 FE FF FF 83 E1 03 0B C1 89 85 60 FF FF FF 56 8D 85 34 FE FF FF 50 8B 95 B8 FE FF FF 52 E8 ?? ?? ?? ?? 83 C4 0C 84 C0 8B 85 34 FE FF FF 75 02 8B C2 C1 E0 05 33 85 60 FF FF FF 25 E0 FF 01 00 31 85 60 FF FF FF 8B 8D F0 FE FF FF 83 E1 1F 89 8D 70 FE FF FF 8B 45 80 23 C7 0B C1 89 45 80 8B 8D 80 FE FF FF 83 E9 00 0F 84 C0 00 00 00 49 74 6F 83 FA 5C 0F 82 08 01 00 00 83 FA 5D 76 48 83 FA 5F 0F 86 FA 00 00 00 83 FA 62 76 28 83 FA 64 0F 87 EC 00 00 00 8B 84 F5 E0 FE FF FF 89 85 70 FF FF FF 8B 84 F5 E4 FE FF FF 89 85 74 FF FF FF E9 CD 00 00 00 8B 84 B5 E0 FE FF FF 89 85 70 FF FF FF E9 BB 00 00 00 8B 84 B5 E0 FE FF FF 89 85 70 FF FF FF 83 A5 74 FF FF FF 00 E9 A2 00 00 00 8B 8C F5 E0 FE FF FF 89 8D 70 FF FF FF 8B 8C F5 E4 FE FF FF 89 8D 74 FF FF FF 83 FA 66 74 05 83 FA 67 75 7E 83 FE 01 75 79 8B 8D 10 FF FF FF 89 8D 70 FF FF FF 8B 8D 14 FF FF FF 89 8D 74 FF FF FF 8B C8 33 8D 20 FF FF FF 83 E1 1F EB 4F 8B 8C B5 E0 FE FF FF 89 8D 70 FF FF FF 83 FA 44 74 05 83 FA 45 75 3D 8B CE 49 74 1C 49 74 11 49 75 32 8B 8D 18 FF FF FF 89 8D 70 FF FF FF EB C3 8B 8D 10 FF FF FF EB F0 8B 8D E8 FE FF FF 89 8D 70 FF FF FF 8B C8 33 8D F0 FE FF FF 83 E1 1E 33 C1 89 45 80 8B 45 A0 F6 85 20 FF FF FF 01 74 0F 8B C8 33 8D 20 FF FF FF 83 E1 1F 33 C1 EB 03 83 E0 FE 89 45 A0 8B 8D 80 FE FF FF 83 E9 00 0F 84 99 00 00 00 49 74 60 83 FA 5C 0F 82 E2 00 00 00 83 FA 5D 76 3F 83 FA 5F 0F 86 D4 00 00 00 83 FA 62 76 22 83 FA 64 0F 87 C6 00 00 00 8B 84 F5 10 FF FF FF 89 45 90 8B 84 F5 14 FF FF FF 89 45 94 E9 AD 00 00 00 8B 84 B5 10 FF FF FF 89 45 90 E9 9E 00 00 00 8B 84 B5 10 FF FF FF 89 45 90 83 65 94 00 E9 8B 00 00 00 8B 8C F5 10 FF FF FF 89 4D 90 8B 8C F5 14 FF FF FF 89 4D 94 83 FA 66 74 05 83 FA 67 75 6D 85 F6 75 69 8B 8D E8 FE FF FF 89 4D 90 8B 8D EC FE FF FF 89 4D 94 EB 4A 8B 8C B5 10 FF FF FF 89 4D 90 83 FA 44 74 05 83 FA 45 75 41 8B CE 83 E9 00 74 26 49 74 1B 49 75 34 8B 8D 14 FF FF FF 89 4D 90 8B C8 33 8D 20 FF FF FF 83 E1 1F 33 C1 EB 19 8B 8D EC FE FF FF EB 06 8B 8D E4 FE FF FF 89 4D 90 23 C7 0B 85 70 FE FF FF 89 45 A0 83 65 C0 FE 8B 85 80 FE FF FF 83 E8 00 74 36 48 74 19 83 FA 5C 72 38 83 FA 5D 76 25 83 FA 5F 76 2E 83 FA 62 76 1F 83 FA 64 77 24 8B 84 F5 40 FF FF FF 89 45 B0 8B 84 F5 44 FF FF FF 89 45 B4 EB 0E 83 65 B4 00 8B 84 B5 40 FF FF FF 89 45 B0 8B 85 50 FF FF FF 33 45 C0 83 E0 1E 31 45 C0 8D 85 60 FF FF FF 89 85 60 FE FF FF 83 BD 80 FE FF FF 01 74 1E 83 BD 80 FE FF FF 02 74 15 8D BC B5 98 FE FF FF 8D 85 40 FE FF FF 50 E8 ?? ?? ?? ?? EB 13 8D BC B5 98 FE FF FF 8D 85 40 FE FF FF 50 E8 ?? ?? ?? ?? 89 07 59 8B 85 44 FE FF FF 89 84 B5 A8 FE FF FF 83 3F 01 75 73 A8 20 74 07 83 8D 94 FE FF FF 20 A8 10 74 07 83 8D 94 FE FF FF 10 A8 08 74 07 83 8D 94 FE FF FF 08 A8 04 74 07 83 8D 94 FE FF FF 04 A8 02 74 07 83 8D 94 FE FF FF 02 A8 01 74 07 83 8D 94 FE FF FF 01 8D 85 60 FF FF FF 50 FF 95 38 FE FF FF 59 89 85 64 FE FF FF 83 F8 FF 0F 85 37 01 00 00 8D 85 40 FE FF FF 50 FF B5 B8 FE FF FF E8 ?? ?? ?? ?? 59 59 8B 85 50 FF FF FF 33 45 C0 83 E0 01 31 85 50 FF FF FF 8B 85 5C FE FF FF 89 85 C0 FE FF FF F6 85 50 FF FF FF 01 74 61 8B 85 80 FE FF FF 83 E8 00 74 4C 48 74 1F 8B 85 B8 FE FF FF 83 F8 5C 72 48 83 F8 5D 76 25 83 F8 5F 76 3E 83 F8 62 76 2F 83 F8 64 77 34 8B 45 B0 89 84 F5 40 FF FF FF 8B 45 B4 89 84 F5 44 FF FF FF EB 1E 8B 45 B0 89 84 F5 40 FF FF FF 83 A4 F5 44 FF FF FF 00 EB 0A 8B 45 B0 89 84 B5 40 FF FF FF 46 3B B5 6C FE FF FF 0F 82 6B FB FF FF 8B BD 74 FE FF FF FF B5 C0 FE FF FF 57 8D 85 30 FF FF FF 50 E8 ?? ?? ?? ?? 83 C4 0C 8D 87 B8 00 00 00 8B 08 89 8D 88 FE FF FF 03 8D 84 FE FF FF 89 8D 88 FE FF FF 89 08 8B 85 3C FE FF FF 89 87 DC 00 00 00 8B 85 64 FE FF FF EB 42 8B 5D E4 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 5D E4 EB 1A 8B 5D E4 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 5D E4 8B 65 E8 C7 45 FC FE FF FF FF 33 C0 8B 4D F0 64 89 0D 00 00 00 00 59 5F 5E 8B 4D DC 33 CD E8 ?? ?? ?? ?? 8B E5 5D 8B E3 5B C3 }
	condition:
		$1
}

rule file_370_0_0 {
	meta:
		name = "_feof"
		size = 47
		refs = "000c __errno 001c __invalid_parameter"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C3 8B 40 0C 83 E0 10 5E C3 }
	condition:
		$1
}

rule file_370_1_0 {
	meta:
		name = "_ferror"
		size = 47
		refs = "000c __errno 001c __invalid_parameter"
	strings:
		$1 = { 8B 44 24 04 56 33 F6 3B C6 75 1C E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 5E C3 8B 40 0C 83 E0 20 5E C3 }
	condition:
		$1
}

rule file_371_0_0 {
	meta:
		name = "_strcpy"
		size = 16
	strings:
		$1 = { 57 8B 7C 24 08 EB 6E 8D A4 24 00 00 00 00 8B FF }
	condition:
		$1
}

rule file_371_1_0 {
	meta:
		name = "_strcat"
		size = 232
	strings:
		$1 = { 8B 4C 24 04 57 F7 C1 03 00 00 00 74 13 8A 01 83 C1 01 84 C0 74 3D F7 C1 03 00 00 00 75 EF 8B FF 8B 01 BA FF FE FE 7E 03 D0 83 F0 FF 33 C2 83 C1 04 A9 00 01 01 81 74 E8 8B 41 FC 84 C0 74 23 84 E4 74 1A A9 00 00 FF 00 74 0E A9 00 00 00 FF 74 02 EB CD 8D 79 FF EB 0D 8D 79 FE EB 08 8D 79 FD EB 03 8D 79 FC 8B 4C 24 0C F7 C1 03 00 00 00 74 1D 8A 11 83 C1 01 84 D2 74 66 88 17 83 C7 01 F7 C1 03 00 00 00 75 EA EB 05 89 17 83 C7 04 BA FF FE FE 7E 8B 01 03 D0 83 F0 FF 33 C2 8B 11 83 C1 04 A9 00 01 01 81 74 E1 84 D2 74 34 84 F6 74 27 F7 C2 00 00 FF 00 74 12 F7 C2 00 00 00 FF 74 02 EB C7 89 17 8B 44 24 08 5F C3 66 89 17 8B 44 24 08 C6 47 02 00 5F C3 66 89 17 8B 44 24 08 5F C3 88 17 8B 44 24 08 5F C3 }
	condition:
		$1
}

rule file_374_10_0 {
	meta:
		name = "__winput_l"
		size = 3248
		refs = "000f ___security_cookie 0055 __errno 0065 __invalid_parameter 0082 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 00a3 _iswctype 00ba __whiteout 00c1 __un_inc 0128 _isdigit 026c __fgetwc_nolock 037a ___check_float_string 03c2 __mbtowc_l 05e1 __malloc_crt 05fd _wcstombs_s 0618 __invoke_watson 062f __cfltcvt_tab 0634 __decode_pointer 063d _free 07a7 _memset 091f _wctomb_s 0a4c __allmul 0a64 _isxdigit 0a83 __hextodec 0ca4 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 34 FD FF FF 81 EC 3C 03 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 C8 02 00 00 8B 8D E0 02 00 00 8B 85 D4 02 00 00 56 33 F6 57 8B BD D8 02 00 00 3B FE 89 4D AC 8D 4D 0C 89 45 F4 89 4D EC C7 45 B4 5E 01 00 00 89 75 BC 89 75 B8 89 75 A8 89 75 00 75 20 E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 25 0C 00 00 3B C6 74 DC FF B5 DC 02 00 00 8D 4D 94 E8 ?? ?? ?? ?? 0F B7 07 66 3B C6 C6 45 F2 00 89 75 04 89 75 C0 0F 84 ED 0B 00 00 53 6A 08 50 33 F6 E8 ?? ?? ?? ?? 85 C0 59 59 74 32 FF 75 F4 FF 4D 04 FF 75 F4 8D 75 04 E8 ?? ?? ?? ?? 59 50 E8 ?? ?? ?? ?? 59 59 47 47 0F B7 07 6A 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 ED E9 44 0B 00 00 66 83 3F 25 0F 85 01 0B 00 00 89 75 C4 89 75 90 89 75 E8 89 75 D4 89 75 FC C6 45 DB 00 C6 45 F1 00 C6 45 F9 00 C6 45 0B 00 C6 45 F3 00 C6 45 FB 00 C6 45 FA 01 89 75 D0 47 47 0F B7 1F 66 F7 C3 00 FF 75 23 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 15 8B 45 FC FF 45 D4 6B C0 0A 8D 44 18 D0 89 45 FC E9 AE 00 00 00 83 FB 4E 7F 7E 0F 84 A3 00 00 00 83 FB 2A 74 6E 83 FB 46 0F 84 95 00 00 00 83 FB 49 74 0D 83 FB 4C 75 6F FE 45 FA E9 83 00 00 00 0F B7 4F 02 66 83 F9 36 75 16 8D 47 04 66 83 38 34 75 0D FF 45 D0 8B F8 89 75 DC 89 75 E0 EB 63 66 83 F9 33 75 0D 8D 47 04 66 83 38 32 75 04 8B F8 EB 50 66 83 F9 64 74 4A 66 83 F9 69 74 44 66 83 F9 6F 74 3E 66 83 F9 78 74 38 66 83 F9 58 75 16 EB 30 FE 45 F9 EB 2B 83 FB 68 74 20 83 FB 6C 74 0A 83 FB 77 74 11 FE 45 0B EB 17 8D 47 02 66 83 38 6C 74 9E FE 45 FA FE 45 FB EB 06 FE 4D FA FE 4D FB 80 7D 0B 00 0F 84 19 FF FF FF 80 7D F9 00 89 7D C8 75 10 8B 45 AC 8B 18 89 45 A4 83 C0 04 89 45 AC EB 02 33 DB 80 7D FB 00 89 5D CC C6 45 0B 00 75 17 0F B7 07 66 3D 53 00 74 0A 66 3D 43 00 C6 45 FB 01 75 04 C6 45 FB FF 0F B7 37 83 CE 20 83 FE 6E 89 75 E4 74 3C 83 FE 63 74 15 83 FE 7B 74 10 FF 75 F4 8D 75 04 E8 ?? ?? ?? ?? 8B 75 E4 EB 0B FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 C0 66 3D FF FF 89 45 00 59 0F 84 C3 09 00 00 8B 5D CC 8B 7D C8 8B 4D D4 85 C9 74 0A 83 7D FC 00 0F 84 9F 09 00 00 83 FE 6F 0F 8F 70 04 00 00 0F 84 02 07 00 00 83 FE 63 0F 84 99 03 00 00 6A 64 58 3B F0 0F 84 EE 06 00 00 0F 8E 7A 04 00 00 83 FE 67 7E 39 83 FE 69 74 1B 83 FE 6E 0F 85 67 04 00 00 80 7D F9 00 8B 75 04 0F 84 DC 08 00 00 E9 F7 08 00 00 89 45 E4 8B 5D 00 66 83 FB 2D 0F 85 61 05 00 00 C6 45 F1 01 E9 5E 05 00 00 33 DB 66 83 7D 00 2D 75 0B 8B 45 EC 66 C7 00 2D 00 43 EB 07 66 83 7D 00 2B 75 15 FF 4D FC FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 C0 59 89 45 00 83 7D D4 00 75 04 83 4D FC FF 66 F7 45 00 00 FF 75 60 0F B6 45 00 50 E8 ?? ?? ?? ?? 85 C0 59 74 51 8B 45 FC FF 4D FC 85 C0 74 47 66 0F BE 45 00 8B 4D EC FF 45 E8 66 89 04 59 8D 45 BC 50 8D 45 0C 50 43 53 8D 7D EC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 BB 08 00 00 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 59 89 45 00 74 A0 8D 45 94 50 8B 45 94 C7 45 B0 2E 00 00 00 FF B0 AC 00 00 00 8B 80 BC 00 00 00 FF 30 8D 45 B0 50 E8 ?? ?? ?? ?? 0F B7 45 B0 0F BE 4D 00 83 C4 10 3B C1 0F 85 B1 00 00 00 8B 45 FC FF 4D FC 85 C0 0F 84 A3 00 00 00 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 8B 4D EC 0F B7 C0 89 45 00 66 8B 45 B0 66 89 04 59 8D 45 BC 50 8D 45 0C 50 43 53 8D 7D EC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 10 85 C0 0F 84 21 08 00 00 66 F7 45 00 00 FF 75 5F 0F B6 45 00 50 E8 ?? ?? ?? ?? 85 C0 59 74 50 8B 45 FC FF 4D FC 85 C0 74 46 8B 45 EC 66 8B 4D 00 FF 45 E8 66 89 0C 58 8D 45 BC 50 8D 45 0C 50 43 53 8D 7D EC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 D2 07 00 00 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 59 89 45 00 74 A1 83 7D E8 00 0F 84 15 01 00 00 66 83 7D 00 65 74 0B 66 83 7D 00 45 0F 85 03 01 00 00 8B 45 FC FF 4D FC 85 C0 0F 84 F5 00 00 00 8B 45 EC 66 C7 04 58 65 00 8D 45 BC 50 8D 45 0C 50 43 53 8D 7D EC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 67 07 00 00 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 C0 66 3D 2D 00 59 89 45 00 75 25 8B 45 EC 66 C7 04 58 2D 00 8D 45 BC 50 8D 45 0C 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 2C 07 00 00 EB 07 66 83 7D 00 2B 75 21 8B 45 FC FF 4D FC 85 C0 75 05 21 45 FC EB 12 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 C0 59 89 45 00 66 F7 45 00 00 FF 75 5F 0F B6 45 00 50 E8 ?? ?? ?? ?? 85 C0 59 74 50 8B 45 FC FF 4D FC 85 C0 74 46 8B 45 EC 66 8B 4D 00 FF 45 E8 66 89 0C 58 8D 45 BC 50 8D 45 0C 50 43 53 8D 7D EC 8D 75 B4 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 B3 06 00 00 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 C0 66 A9 00 FF 59 89 45 00 74 A1 FF 75 F4 FF 4D 04 FF 75 00 E8 ?? ?? ?? ?? 83 7D E8 00 59 59 0F 84 81 06 00 00 80 7D F9 00 0F 85 10 06 00 00 8B 75 B4 8B 45 EC FF 45 C0 66 83 24 58 00 8D 74 36 02 56 E8 ?? ?? ?? ?? 8B F8 85 FF 59 0F 84 54 06 00 00 8D 46 FF 50 FF 75 EC 56 57 33 F6 56 E8 ?? ?? ?? ?? 83 C4 14 3B C6 74 17 83 F8 16 74 05 83 F8 22 75 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 8D 45 94 50 0F BE 45 FA 57 FF 75 CC 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 57 E8 ?? ?? ?? ?? 83 C4 14 E9 94 05 00 00 85 C9 75 0A FF 45 FC C7 45 D4 01 00 00 00 80 7D FB 00 7E 04 C6 45 F3 01 FF 75 F4 FF 4D 04 FF 75 00 89 5D C4 E8 ?? ?? ?? ?? 59 59 83 7D D4 00 74 0E 8B 45 FC FF 4D FC 85 C0 0F 84 E4 02 00 00 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 D0 66 81 FA FF FF 59 89 55 00 0F 84 B9 02 00 00 83 FE 63 74 49 83 FE 73 75 16 66 83 FA 09 72 0A 66 83 FA 0D 0F 86 9F 02 00 00 66 83 FA 20 75 2E 83 FE 7B 0F 85 90 02 00 00 0F B7 C2 8B C8 33 FF 83 E1 07 47 D3 E7 8B 4D B8 C1 E8 03 0F BE 04 08 0F BE 4D DB 33 C1 85 F8 0F 84 6B 02 00 00 80 7D F9 00 0F 85 58 02 00 00 80 7D F3 00 0F 84 0A 02 00 00 66 89 13 43 43 E9 3C 02 00 00 8B C6 83 E8 70 0F 84 89 02 00 00 83 E8 03 0F 84 32 FF FF FF 48 48 0F 84 7C 02 00 00 83 E8 03 0F 84 B3 FB FF FF 83 E8 03 74 24 8B 45 00 66 39 07 0F 85 EA 04 00 00 FE 4D F2 80 7D F9 00 0F 85 89 04 00 00 8B 45 A4 89 45 AC E9 7E 04 00 00 80 7D FB 00 7E 04 C6 45 F3 01 47 47 66 83 3F 5E 75 07 83 C7 02 C6 45 DB FF 83 7D B8 00 75 1D 68 00 20 00 00 E8 ?? ?? ?? ?? 85 C0 59 89 45 B8 0F 84 B0 04 00 00 C7 45 A8 01 00 00 00 8B 5D B8 68 00 20 00 00 6A 00 53 E8 ?? ?? ?? ?? 83 C4 0C 66 83 3F 5D 75 0B 6A 5D 47 5E 47 C6 43 0B 20 EB 77 8B 75 90 EB 72 0F B7 C0 47 47 66 3D 2D 00 75 51 66 85 F6 74 4C 0F B7 0F 66 83 F9 5D 74 43 0F B7 C9 47 47 66 3B F1 73 05 0F B7 C1 EB 06 0F B7 C6 0F B7 F1 66 3B F0 77 22 2B C6 40 0F B7 D6 0F B7 F0 8B 4D B8 8B C2 C1 E8 03 03 C1 8B CA 83 E1 07 B3 01 D2 E3 08 18 42 4E 75 E7 8B 5D B8 33 F6 EB 16 0F B7 C8 0F B7 F0 8B C1 83 E1 07 B2 01 C1 E8 03 D2 E2 03 C3 08 10 0F B7 07 66 3D 5D 00 75 85 66 83 3F 00 0F 84 FB 03 00 00 8B 5D CC 8B 75 E4 89 7D C8 E9 0A FE FF FF 66 83 FB 2B 75 21 FF 4D FC 75 0A 85 C9 74 06 C6 45 0B 01 EB 12 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 D8 59 89 5D 00 66 83 FB 30 0F 85 57 01 00 00 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 59 0F B7 D8 6A 78 5E 66 3B DE 89 5D 00 74 42 66 83 FB 58 74 3C 39 75 E4 C7 45 E8 01 00 00 00 74 1A 83 7D D4 00 74 08 FF 4D FC 75 03 FE 45 0B C7 45 E4 6F 00 00 00 E9 11 01 00 00 FF 75 F4 FF 4D 04 53 E8 ?? ?? ?? ?? 59 59 6A 30 5B E9 F8 00 00 00 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 83 7D D4 00 0F B7 D8 59 89 5D 00 74 0D 83 6D FC 02 83 7D FC 01 7D 03 FE 45 0B 89 75 E4 E9 CE 00 00 00 52 6A 05 8D 45 D0 53 33 FF 50 89 7D D0 E8 ?? ?? ?? ?? 83 C4 10 3B C7 74 20 83 F8 16 74 09 83 F8 22 0F 85 3C FD FF FF 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 E9 2A FD FF FF 03 5D D0 89 5D CC E9 1F FD FF FF 83 45 C4 02 E9 16 FD FF FF FF 75 F4 FF 4D 04 52 E8 ?? ?? ?? ?? 59 59 39 5D C4 0F 84 CF 02 00 00 80 7D F9 00 0F 85 5E 02 00 00 FF 45 C0 83 FE 63 0F 84 52 02 00 00 80 7D F3 00 8B 45 CC 74 09 66 83 20 00 E9 40 02 00 00 C6 00 00 E9 38 02 00 00 C6 45 FA 01 8B 5D 00 66 83 FB 2D 75 06 C6 45 F1 01 EB 06 66 83 FB 2B 75 21 FF 4D FC 75 0A 85 C9 74 06 C6 45 0B 01 EB 12 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 59 0F B7 D8 89 5D 00 83 7D D0 00 0F 84 09 01 00 00 80 7D 0B 00 0F 85 DA 00 00 00 83 7D E4 78 74 5F 83 7D E4 70 74 59 66 F7 C3 00 FF 0F 85 B5 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 A3 00 00 00 83 7D E4 6F 75 1F 66 83 FB 38 0F 83 93 00 00 00 8B 45 DC 8B 4D E0 0F A4 C1 03 C1 E0 03 89 45 DC 89 4D E0 EB 4C 6A 00 6A 0A FF 75 E0 FF 75 DC E8 ?? ?? ?? ?? 89 45 DC 89 55 E0 EB 35 66 F7 C3 00 FF 75 60 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 52 8B 45 DC 8B 4D E0 0F A4 C1 04 C1 E0 04 8B FB 89 45 DC 89 4D E0 E8 ?? ?? ?? ?? 0F B7 D8 89 5D 00 FF 45 E8 0F B7 C3 83 E8 30 99 01 45 DC 11 55 E0 83 7D D4 00 74 05 FF 4D FC 74 25 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 D8 59 89 5D 00 E9 34 FF FF FF FF 75 F4 FF 4D 04 53 E8 ?? ?? ?? ?? 59 59 80 7D F1 00 8B 75 C4 0F 84 C3 00 00 00 8B 45 DC 8B 4D E0 F7 D8 83 D1 00 F7 D9 89 45 DC 89 4D E0 E9 AB 00 00 00 80 7D 0B 00 8B 75 C4 0F 85 96 00 00 00 83 7D E4 78 74 31 83 7D E4 70 74 2B 66 F7 C3 00 FF 75 75 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 67 83 7D E4 6F 75 0B 66 83 FB 38 73 5B C1 E6 03 EB 2A 6B F6 0A EB 25 66 F7 C3 00 FF 75 4A 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 3C 8B FB C1 E6 04 E8 ?? ?? ?? ?? 0F B7 D8 89 5D 00 FF 45 E8 83 7D D4 00 0F B7 C3 8D 74 06 D0 74 05 FF 4D FC 74 25 FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 0F B7 D8 59 89 5D 00 E9 78 FF FF FF FF 75 F4 FF 4D 04 53 E8 ?? ?? ?? ?? 59 59 80 7D F1 00 74 02 F7 DE 83 7D E4 46 75 04 83 65 E8 00 83 7D E8 00 0F 84 93 00 00 00 80 7D F9 00 75 26 FF 45 C0 8B 5D CC 83 7D D0 00 74 0D 8B 45 DC 89 03 8B 45 E0 89 43 04 EB 0D 80 7D FA 00 74 04 89 33 EB 03 66 89 33 8B 7D C8 FE 45 F2 47 47 89 7D C8 EB 1F FF 75 F4 FF 45 04 E8 ?? ?? ?? ?? 59 66 8B 0F 0F B7 C0 47 47 66 3B C8 89 45 00 89 7D C8 75 2E 66 81 7D 00 FF FF 75 12 66 83 3F 25 75 2D 8B 45 C8 66 83 78 02 6E 75 23 8B F8 0F B7 07 66 85 C0 0F 85 6E F4 FF FF EB 13 FF 75 F4 50 EB 06 FF 75 F4 FF 75 00 E8 ?? ?? ?? ?? 59 59 83 7D A8 01 5B 75 09 FF 75 B8 E8 ?? ?? ?? ?? 59 83 7D BC 01 75 09 FF 75 EC E8 ?? ?? ?? ?? 59 66 81 7D 00 FF FF 75 1E 8B 45 C0 85 C0 75 08 38 45 F2 75 03 83 C8 FF 80 7D A0 00 74 19 8B 4D 9C 83 61 70 FD EB 10 80 7D A0 00 74 07 8B 45 9C 83 60 70 FD 8B 45 C0 8B 8D C8 02 00 00 5F 33 CD 5E E8 ?? ?? ?? ?? 81 C5 CC 02 00 00 C9 C3 }
	condition:
		$1
}

rule file_375_3_0 {
	meta:
		name = "__atof_l"
		size = 169
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 001d __errno 002d __invalid_parameter 005b __isctype_l 0083 _strlen 008f __fltin2"
	strings:
		$1 = { 55 8B EC 83 EC 28 53 56 FF 75 0C 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 08 33 DB 3B F3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD D9 EE EB 61 8B 45 F0 83 B8 AC 00 00 00 01 7E 14 8D 45 F0 50 0F B6 06 6A 08 50 E8 ?? ?? ?? ?? 83 C4 0C EB 10 0F B6 0E 8B 80 C8 00 00 00 0F B6 04 48 83 E0 08 3B C3 74 03 46 EB C9 8D 45 F0 50 53 53 56 E8 ?? ?? ?? ?? 59 50 8D 45 D8 56 50 E8 ?? ?? ?? ?? DD 40 10 83 C4 18 38 5D FC 74 07 8B 45 F8 83 60 70 FD 5E 5B C9 C3 }
	condition:
		$1
}

rule file_376_0_0 {
	meta:
		name = "_localeconv"
		size = 38
		refs = "0001 __getptd 000a ___ptlocinfo 0012 ___globallocalestatus 001c ___updatetlocinfo 0021 ___lconv"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 48 6C 3B 0D ?? ?? ?? ?? 74 10 8B 0D ?? ?? ?? ?? 85 48 70 75 05 E8 ?? ?? ?? ?? A1 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_378_0_0 {
	meta:
		name = "__fullpath"
		size = 264
		refs = "0022 __imp__GetFullPathNameA@16 0034 __imp__GetLastError@0 003a __dosmaperr 0054 __errno 0069 _calloc 009b __invalid_parameter 00c4 _free 00fd __getcwd"
	strings:
		$1 = { 55 8B EC 51 51 8B 45 0C 53 33 DB 3B C3 56 57 0F 84 E1 00 00 00 38 18 0F 84 D9 00 00 00 39 5D 08 8B 35 ?? ?? ?? ?? 75 5B 53 53 53 50 FF D6 3B C3 75 13 FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 33 C0 E9 BD 00 00 00 8B 7D 10 3B F8 77 02 8B F8 83 FF FF 76 12 E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 E9 9E 00 00 00 6A 01 57 E8 ?? ?? ?? ?? 3B C3 59 59 89 45 FC 75 34 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB DB 8B 7D 10 3B FB 77 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB BA 8B 45 08 89 45 FC 8D 45 F8 50 FF 75 FC 57 FF 75 0C FF D6 3B C7 72 1B 39 5D 08 75 09 FF 75 FC E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? C7 00 22 00 00 00 EB 88 3B C3 75 17 39 5D 08 0F 85 4F FF FF FF FF 75 FC E8 ?? ?? ?? ?? 59 E9 41 FF FF FF 8B 45 FC EB 0D FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 59 59 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_380_2_0 {
	meta:
		name = "__wexecvpe"
		size = 553
		refs = "0015 __errno 0025 __invalid_parameter 0073 __wexecve 008c _wcschr 00bd ??_C@_19IJOJOJIB@?$AAP?$AAA?$AAT?$AAH?$AA?$AA@ 00c7 __wdupenv_s 00e1 __invoke_watson 00fe __calloc_crt 0162 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 016d _wcscat_s 0187 _wcslen 020e _free"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 8B 5D 08 56 33 F6 3B DE 89 75 FC 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 F1 01 00 00 66 39 33 74 DE 57 8B 7D 0C 3B FE 75 1D E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 C6 01 00 00 8B 07 3B C6 74 DD 66 39 30 74 D8 E8 ?? ?? ?? ?? FF 75 10 89 30 57 53 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 38 02 0F 85 8B 01 00 00 6A 5C 53 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 79 01 00 00 6A 2F 53 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 67 01 00 00 66 39 33 74 0B 66 83 7B 02 3A 0F 84 57 01 00 00 68 ?? ?? ?? ?? 8D 45 FC 56 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C6 74 1B 83 F8 16 0F 85 38 01 00 00 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 E9 26 01 00 00 39 75 FC 0F 84 2B 01 00 00 6A 02 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F8 3B FE 59 59 8B CF 0F 84 03 01 00 00 8B 55 FC 0F B7 02 66 3B C6 89 55 F8 74 2A EB 03 8B 5D 08 66 3D 3B 00 74 1F 8D 9F 04 02 00 00 3B CB 73 12 66 89 01 41 41 42 42 0F B7 02 66 3B C6 89 55 F8 75 DB 8B 5D 08 3B CF 66 89 31 76 03 83 C1 FE 0F B7 01 66 3D 5C 00 74 2A 66 3D 2F 00 74 24 68 ?? ?? ?? ?? 68 04 01 00 00 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 53 89 45 F4 E8 ?? ?? ?? ?? 59 59 8B 4D F4 03 C8 B8 04 01 00 00 3B C8 73 68 8B 5D 08 53 50 57 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 FF 75 10 FF 75 0C 57 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 38 02 74 1F 0F B7 07 66 3D 5C 00 74 06 66 3D 2F 00 75 21 0F B7 47 02 66 3D 5C 00 74 06 66 3D 2F 00 75 11 8B 55 F8 66 39 32 74 09 42 42 8B CF E9 07 FF FF FF 57 E8 ?? ?? ?? ?? 59 39 75 FC 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 5F 5E 83 C8 FF 5B C9 C3 }
	condition:
		$1
}

rule file_381_1_0 {
	meta:
		name = "_winit_namebuf"
		size = 212
		refs = "0018 _tmpnam_s_buf 001f _tmpfile_buf 0029 _tmpnam_buf 0035 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 003c _wcscpy_s 004d __invoke_watson 0091 __getpid 0097 __ultow_s 00b0 ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 00b7 _wcscat_s"
	strings:
		$1 = { 55 8B EC 8B 45 08 53 56 57 33 DB 33 FF 2B C3 74 17 48 74 0A 48 75 1A BE ?? ?? ?? ?? EB 05 BE ?? ?? ?? ?? 6A 12 5F EB 0C BE ?? ?? ?? ?? 6A 0E EB F4 8B 75 08 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 46 02 0F B7 48 FE 66 83 F9 5C 74 0D 66 83 F9 2F 74 07 66 C7 00 5C 00 40 40 83 7D 08 01 75 07 66 C7 00 74 00 EB 05 66 C7 00 73 00 40 40 8B C8 2B CE D1 F9 8B D7 6A 20 2B D1 52 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_381_2_0 {
	meta:
		name = "_wgenfname"
		size = 149
		refs = "0007 ___security_cookie 0018 _wcsrchr 0026 _wcstoul 0042 __ultow_s 0055 __invoke_watson 006b _wcscpy_s 008f @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 14 A1 ?? ?? ?? ?? 33 C5 89 45 FC 56 57 6A 2E 53 8B F9 E8 ?? ?? ?? ?? 8B F0 6A 20 46 46 6A 00 56 E8 ?? ?? ?? ?? 83 C4 14 40 3B 45 08 72 05 83 C8 FF EB 4F 6A 20 6A 08 8D 4D EC 51 50 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 8D 45 EC 50 8B C6 2B C3 D1 F8 2B F8 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 33 C0 8B 4D FC 5F 33 CD 5E E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_381_3_0 {
	meta:
		name = "__wtmpnam_helper"
		size = 322
		refs = "0003 __sehtable$__wtmpnam_helper 0008 __SEH_prolog4 0012 __errno 001e __mtinitlocknum 003b __lock 0049 _tmpnam_buf 0052 _tmpnam_s_buf 0062 _winit_namebuf 006f _wgenfname 007f __waccess_s 0091 __getptd_noexit 00ae __calloc_crt 00cd _wcslen 00ee _wcscpy_s 00ff __invoke_watson 012f __unlock 013d __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 FF 89 7D E4 E8 ?? ?? ?? ?? 8B 00 89 45 E0 6A 02 E8 ?? ?? ?? ?? 59 85 C0 75 11 8B 45 18 89 38 E8 ?? ?? ?? ?? 8B 00 E9 04 01 00 00 6A 02 E8 ?? ?? ?? ?? 59 89 7D FC 39 7D 10 75 09 BB ?? ?? ?? ?? 6A 0E EB 07 BB ?? ?? ?? ?? 6A 12 5E 66 39 3B 75 0B FF 75 10 E8 ?? ?? ?? ?? 59 EB 13 FF 75 14 8B CE E8 ?? ?? ?? ?? 85 C0 59 0F 85 8A 00 00 00 57 53 E8 ?? ?? ?? ?? 59 59 85 C0 74 E0 8B 75 08 3B F7 75 36 E8 ?? ?? ?? ?? 8B F0 3B F7 75 09 C7 45 E4 0C 00 00 00 EB 62 39 7E 30 75 12 6A 02 6A 0E E8 ?? ?? ?? ?? 59 59 89 46 30 3B C7 74 E0 8B 76 30 89 75 08 53 6A 0E EB 26 39 7D 10 74 1D 53 E8 ?? ?? ?? ?? 59 3B 45 0C 72 11 C7 45 E4 22 00 00 00 39 7D 0C 74 23 66 89 3E EB 1E 53 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C7 74 0D 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 C7 45 FC FE FF FF FF E8 1A 00 00 00 8B 45 18 8B 4D 08 89 08 8B 75 E4 E8 ?? ?? ?? ?? 3B F7 74 0F 89 30 EB 10 33 FF 6A 02 E8 ?? ?? ?? ?? 59 C3 8B 4D E0 89 08 8B C6 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_383_0_0 {
	meta:
		name = "___RTtypeid"
		size = 125
		refs = "0003 __sehtable$___RTtypeid 0008 __SEH_prolog4 0014 ??_C@_0CE@FFJAJLDK@Attempted?5a?5typeid?5of?5NULL?5point@ 001c ??0bad_typeid@std@@QAE@PBD@Z 0021 __TI2?AVbad_typeid@std@@ 002a __CxxThrowException@8 0046 __SEH_epilog4 004c ??_C@_0CB@EEENAAHH@Bad?5read?5pointer?5?9?5no?5RTTI?5data?$CB@ 0054 ??0__non_rtti_object@std@@QAE@PBD@Z 0059 __TI3?AV__non_rtti_object@std@@ 0077 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 08 85 C0 75 1B 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? 83 65 FC 00 8B 00 8B 40 FC 8B 40 0C 85 C0 74 0D C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB C6 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? EB D3 }
	condition:
		$1
}

rule file_383_1_0 {
	meta:
		name = "?FindCompleteObject@@YAPAXPAPAX@Z"
		size = 22
	strings:
		$1 = { 8B 01 8B 50 FC 8B C1 2B 42 04 8B 52 08 85 D2 74 04 2B CA 2B 01 C3 }
	condition:
		$1
}

rule file_383_2_0 {
	meta:
		name = "?FindSITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@1@Z"
		size = 117
		refs = "002e _strcmp"
	strings:
		$1 = { 55 8B EC 51 8B 40 10 53 8B 58 08 56 33 F6 85 DB 57 8B 78 0C 76 27 8B 04 B7 8B 4D 0C 89 45 FC 8B 00 3B C1 74 44 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 31 46 3B F3 72 D9 33 C0 5F 5E 5B C9 C3 8B 04 B7 F6 40 14 04 75 F0 8B 00 8B 4D 08 3B C1 74 1A 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 07 46 3B F3 72 D6 EB CD 8B 45 FC EB CA }
	condition:
		$1
}

rule file_383_3_0 {
	meta:
		name = "?PMDtoOffset@@YAHPAXABUPMD@@@Z"
		size = 31
	strings:
		$1 = { 8B 50 04 33 C9 85 D2 7C 11 8B CA 8B 54 24 04 8B 14 11 56 8B 70 08 03 0C 32 5E 8B 00 03 C1 C3 }
	condition:
		$1
}

rule file_383_4_0 {
	meta:
		name = "___RTCastToVoid"
		size = 96
		refs = "0003 __sehtable$___RTCastToVoid 0008 __SEH_prolog4 0016 __SEH_epilog4 0020 ?FindCompleteObject@@YAPAXPAPAX@Z 0045 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 004d ??0__non_rtti_object@std@@QAE@PBD@Z 0052 __TI3?AV__non_rtti_object@std@@ 005b __CxxThrowException@8"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 08 85 C9 75 08 33 C0 E8 ?? ?? ?? ?? C3 83 65 FC 00 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF EB E8 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 68 ?? ?? ?? ?? 8D 4D DC E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 DC 50 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_383_5_0 {
	meta:
		name = "?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 258
		refs = "004c _strcmp 008f ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 14 8B 40 10 83 4D F8 FF 53 8B 58 08 33 C9 3B D9 56 57 8B 78 0C 89 4D F0 89 4D EC 89 4D F4 89 4D FC 0F 86 CF 00 00 00 8B 45 FC 8B 34 87 2B 45 F8 3B 45 F4 76 32 8B 06 8B 4D 14 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 16 8B 45 EC 85 C0 75 50 8B 45 FC 89 45 F8 8B 46 04 89 75 F0 89 45 F4 8B 06 8B 4D 0C 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 1B FF 75 08 8D 46 08 E8 ?? ?? ?? ?? 3B 45 10 59 75 0A 8B 45 F0 85 C0 75 1D 89 75 EC FF 45 FC 39 5D FC 72 81 EB 4E F6 46 14 03 75 48 F6 40 14 01 75 42 8B C6 EB 40 8B 4D FC 2B 4D F8 3B 4D F4 77 2D F6 40 14 40 75 0E 83 7D F8 00 75 29 F6 46 14 01 75 21 EB 21 8B 50 18 8B 52 0C 8B 0C 8A 8A 49 14 80 E1 01 F6 D9 1B C9 F7 D1 23 C1 EB 08 F6 40 14 03 74 D9 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_383_6_0 {
	meta:
		name = "?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z"
		size = 340
		refs = "005d _strcmp 00a5 ?PMDtoOffset@@YAHPAXABUPMD@@@Z"
	strings:
		$1 = { 55 8B EC 83 EC 24 8B 40 10 8B 48 0C 83 4D F4 FF 83 4D E8 FF 53 8B 58 08 56 57 33 FF 3B DF 89 7D EC 89 7D E4 89 7D E0 89 4D DC 89 7D F0 C6 45 FF 01 89 7D F8 0F 86 13 01 00 00 8B 45 F8 8B 4D DC 8B 34 81 2B 45 F4 3B 45 F0 76 33 8B 06 8B 4D 14 3B C1 74 13 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 75 17 F6 46 14 03 75 03 89 75 E0 8B 45 F8 89 45 F4 8B 46 04 8B FE 89 45 F0 8B 06 8B 4D 0C 3B C1 74 17 83 C1 08 51 83 C0 08 50 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 89 00 00 00 FF 75 08 8D 46 08 E8 ?? ?? ?? ?? 3B 45 10 59 75 78 8B 45 F8 2B 45 F4 3B 45 F0 77 64 80 7D FF 00 74 67 F6 47 14 40 75 14 83 7D F4 00 75 0A F6 46 14 01 74 04 C6 45 FF 00 B0 01 EB 1B 8B 4F 18 8B 49 0C 8B 04 81 8B 40 14 A8 01 74 04 C6 45 FF 00 C1 E8 02 F6 D0 24 01 80 7D FF 00 74 2C 84 C0 74 28 FF 75 08 8D 47 08 E8 ?? ?? ?? ?? 83 7D EC 00 59 74 05 39 45 E8 75 37 89 7D EC 89 45 E8 EB 09 F6 46 14 05 75 03 89 75 E4 FF 45 F8 39 5D F8 0F 82 07 FF FF FF 80 7D FF 00 74 07 8B 45 EC 85 C0 75 0F 83 7D E4 00 74 07 8B 45 E0 85 C0 75 02 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_383_7_0 {
	meta:
		name = "___RTDynamicCast"
		size = 213
		refs = "0003 __sehtable$___RTDynamicCast 0008 __SEH_prolog4 0016 __SEH_epilog4 0022 ?FindCompleteObject@@YAPAXPAPAX@Z 0044 ?FindSITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@1@Z 0057 ?FindMITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 005e ?FindVITargetTypeInstance@@YAPBU_s_RTTIBaseClassDescriptor@@PAXPBU_s_RTTICompleteObjectLocator@@PAUTypeDescriptor@@H2@Z 006e ?PMDtoOffset@@YAHPAXABUPMD@@@Z 008c ??_C@_0BC@JNJNLHBP@Bad?5dynamic_cast?$CB?$AA@ 0094 ??0bad_cast@std@@QAE@PBD@Z 0099 __TI2?AVbad_cast@std@@ 00a2 __CxxThrowException@8 00c2 ??_C@_0CB@CGKGGDFI@Access?5violation?5?9?5no?5RTTI?5data?$CB@ 00ca ??0__non_rtti_object@std@@QAE@PBD@Z 00cf __TI3?AV__non_rtti_object@std@@"
	strings:
		$1 = { 6A 18 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 85 F6 75 08 33 C0 E8 ?? ?? ?? ?? C3 83 65 FC 00 8B CE E8 ?? ?? ?? ?? 8B F8 8B 06 8B 40 FC 2B 75 0C 2B F7 8B 48 10 8B 49 04 FF 75 14 F6 C1 01 75 0C FF 75 10 E8 ?? ?? ?? ?? 59 59 EB 19 56 FF 75 10 57 F6 C1 02 75 07 E8 ?? ?? ?? ?? EB 05 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 18 83 C0 08 57 E8 ?? ?? ?? ?? 59 03 C7 89 45 E4 C7 45 FC FE FF FF FF EB 94 33 C0 89 45 E4 39 45 18 74 ED 68 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D8 50 E8 ?? ?? ?? ?? 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 83 65 E4 00 68 ?? ?? ?? ?? 8D 4D D8 E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? EB C8 }
	condition:
		$1
}

rule file_384_0_0 {
	meta:
		name = "__mbsinc_l"
		size = 35
		refs = "000e __ismbblead_l"
	strings:
		$1 = { 56 8B 74 24 08 0F B6 06 FF 74 24 0C 50 E8 ?? ?? ?? ?? 59 46 85 C0 59 74 06 80 3E 00 74 01 46 8B C6 5E C3 }
	condition:
		$1
}

rule file_384_1_0 {
	meta:
		name = "__mbsinc"
		size = 65
		refs = "000d __errno 001d __invalid_parameter 002d __ismbblead"
	strings:
		$1 = { 53 56 8B 74 24 0C 33 DB 3B F3 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 16 0F B6 06 50 E8 ?? ?? ?? ?? 46 85 C0 59 74 05 38 1E 74 01 46 8B C6 5E 5B C3 }
	condition:
		$1
}

rule file_385_2_0 {
	meta:
		name = "__cenvarg"
		size = 983
		refs = "0007 ___security_cookie 001a ??_C@_0L@NKOGAPMJ@SystemRoot?$AA@ 004e _strlen 0067 __calloc_crt 007c __errno 0087 ___doserrno 00a3 __dupenv_s 00b9 __invoke_watson 010b __aenvptr 0114 ___crtGetEnvironmentStringsA 012b _free 01e0 __mbsnicmp 024c _strcpy_s 02da _memcpy 034d ??_C@_01NEMOKFLO@?$DN?$AA@ 0354 _strcat_s 03d1 @__security_check_cookie@4"
	strings:
		$1 = { 55 8B EC 83 EC 40 A1 ?? ?? ?? ?? 33 C5 89 45 FC 8B 4D 0C 8B 45 08 53 56 57 BE ?? ?? ?? ?? 8D 7D F0 A5 A5 66 A5 89 4D D4 8B 4D 10 33 DB 89 4D E0 8B 4D 14 A4 6A 02 89 45 C8 8B F8 8B 00 89 4D E8 89 5D DC 89 5D EC 89 5D C4 5E EB 10 50 E8 ?? ?? ?? ?? 83 C7 04 8D 74 06 01 8B 07 59 3B C3 75 EC 6A 01 56 89 75 CC E8 ?? ?? ?? ?? 3B C3 8B 75 E0 59 59 89 06 75 23 8B 45 E8 89 18 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? C7 00 08 00 00 00 83 C8 FF E9 2F 03 00 00 8D 45 F0 50 8D 45 EC 53 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 14 83 F8 16 75 71 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 62 8D 45 F0 50 E8 ?? ?? ?? ?? 8B F8 47 47 39 5D EC 59 89 7D D0 74 0E FF 75 EC E8 ?? ?? ?? ?? 03 F8 59 89 7D D0 8B 45 D4 3B C3 74 4F 6A 02 8B F0 8B 00 5F EB 10 50 E8 ?? ?? ?? ?? 83 C6 04 8D 7C 07 01 8B 06 59 3B C3 75 EC A1 ?? ?? ?? ?? 3B C3 75 43 E8 ?? ?? ?? ?? 3B C3 A3 ?? ?? ?? ?? 75 35 8B 75 E0 FF 36 83 4D DC FF E8 ?? ?? ?? ?? 8B 45 E8 89 1E 59 89 18 E9 65 02 00 00 8B 45 E8 89 18 8B 7D C8 8B 07 3B C3 8B 36 0F 85 F1 00 00 00 46 E9 55 01 00 00 38 18 89 5D E4 74 28 8A 08 8B F0 80 F9 3D 74 1F 56 E8 ?? ?? ?? ?? 59 8B 4D E4 8D 4C 01 01 A1 ?? ?? ?? ?? 8D 34 08 89 4D E4 8A 0E 3A CB 75 DC 8B 4D E4 89 4D D8 EB 2B 38 58 01 74 2D 80 78 02 3A 75 27 80 78 03 3D 75 21 83 C0 04 50 E8 ?? ?? ?? ?? 59 8B 4D D8 8D 44 01 05 8B 0D ?? ?? ?? ?? 89 45 D8 03 C1 80 38 3D 74 CE 8B 45 D8 2B 45 E4 8B 75 D4 03 F8 89 7D C0 EB 1F 8D 45 F0 50 E8 ?? ?? ?? ?? 50 8D 45 F0 50 FF 36 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 4D 83 C6 04 39 1E 75 DD 03 7D D0 6A 01 57 E8 ?? ?? ?? ?? 3B C3 8B 75 E0 59 59 8B 4D E8 89 01 0F 85 32 FF FF FF FF 36 E8 ?? ?? ?? ?? 59 89 1E E8 ?? ?? ?? ?? C7 00 0C 00 00 00 E8 ?? ?? ?? ?? 83 4D DC FF C7 00 08 00 00 00 E9 69 01 00 00 C7 45 C4 01 00 00 00 EB B4 50 8B C6 2B C6 03 45 CC 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 37 E8 ?? ?? ?? ?? 8D 74 06 01 83 C7 04 EB 36 50 8B 45 E0 8B 00 2B C6 03 45 CC 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 37 E8 ?? ?? ?? ?? 03 F0 83 C7 04 C6 06 20 46 59 8B 07 3B C3 75 C3 39 5D D4 8B 45 E8 88 5E FF 88 1E 8B 30 0F 84 CD 00 00 00 8B 7D D8 8B 45 E4 8B CF 2B C8 51 8B 0D ?? ?? ?? ?? 03 C8 51 56 E8 ?? ?? ?? ?? 2B 7D E4 83 C4 0C 03 F7 8B 7D D4 EB 36 8B 45 C0 8B 4D E8 FF 37 2B C6 03 01 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 37 E8 ?? ?? ?? ?? 59 8D 74 06 01 83 C7 04 39 1F 75 C6 39 5D C4 75 67 8B 7D D0 8D 45 F0 50 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 68 ?? ?? ?? ?? 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 39 5D EC 74 1E FF 75 EC 57 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 03 F7 3B F3 74 0C 8B 45 E8 3B 30 75 03 88 1E 46 88 1E A1 ?? ?? ?? ?? 3B C3 74 07 50 E8 ?? ?? ?? ?? 59 39 5D EC 89 1D ?? ?? ?? ?? 74 09 FF 75 EC E8 ?? ?? ?? ?? 59 8B 45 DC 8B 4D FC 5F 5E 33 CD 5B E8 ?? ?? ?? ?? C9 C3 }
	condition:
		$1
}

rule file_386_0_0 {
	meta:
		name = "__strdate_s"
		size = 170
		refs = "0017 __errno 0028 __invalid_parameter 004b __imp__GetLocalTime@4"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 74 05 39 5D 0C 77 1D E8 ?? ?? ?? ?? 6A 16 59 53 53 53 53 53 8B F1 89 08 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 73 83 7D 0C 09 88 1E 73 09 E8 ?? ?? ?? ?? 6A 22 EB D9 57 8D 45 F0 50 FF 15 ?? ?? ?? ?? 0F B7 45 F0 99 6A 64 5B F7 FB 0F B7 4D F2 8B C1 6A 0A 59 0F B7 7D F6 6A 0A C6 46 05 2F C6 46 02 2F C6 46 08 00 8B DA 99 F7 F9 B1 30 02 C1 88 06 02 D1 88 56 01 8B C7 99 5F F7 FF 02 C1 88 46 03 02 D1 88 56 04 8B C3 99 F7 FF 5F 02 C1 02 D1 88 46 06 88 56 07 33 C0 5E 5B C9 C3 }
	condition:
		$1
}

rule file_386_1_0 {
	meta:
		name = "__strdate"
		size = 24
		refs = "0007 __strdate_s"
	strings:
		$1 = { 6A 09 FF 74 24 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 44 24 08 59 C3 }
	condition:
		$1
}

rule file_619_1_0 {
	meta:
		name = "__strtime"
		size = 24
		refs = "0007 __strtime_s"
	strings:
		$1 = { 6A 09 FF 74 24 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 44 24 08 59 C3 }
	condition:
		$1
}

rule file_462_1_0 {
	meta:
		name = "__wstrdate"
		size = 24
		refs = "0007 __wstrdate_s"
	strings:
		$1 = { 6A 09 FF 74 24 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 44 24 08 59 C3 }
	condition:
		$1
}

rule file_763_1_0 {
	meta:
		name = "__wstrtime"
		size = 24
		refs = "0007 __wstrtime_s"
	strings:
		$1 = { 6A 09 FF 74 24 08 E8 ?? ?? ?? ?? F7 D8 1B C0 59 F7 D0 23 44 24 08 59 C3 }
	condition:
		$1
}

rule file_387_2_0 {
	meta:
		name = "__wstripquote"
		size = 87
		refs = "000a _wcslen 0012 __calloc_crt 004d _free"
	strings:
		$1 = { 53 56 8B F0 6A 02 56 33 DB E8 ?? ?? ?? ?? 59 40 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 36 0F B7 0E 66 85 C9 8B D0 74 25 66 83 F9 22 75 05 46 46 43 EB 07 66 89 08 40 40 46 46 0F B7 0E 66 85 C9 75 E6 85 DB 74 07 66 21 08 8B C2 EB 09 52 E8 ?? ?? ?? ?? 59 33 C0 5E 5B C3 }
	condition:
		$1
}

rule file_387_3_0 {
	meta:
		name = "__wtempnam"
		size = 583
		refs = "0003 __sehtable$__wtempnam 0008 __SEH_prolog4 001a __mtinitlocknum 0028 ??_C@_17DDHKMLLK@?$AAT?$AAM?$AAP?$AA?$AA@ 0032 __wdupenv_s 004a __invoke_watson 005f __waccess_s 0084 ??_C@_13FPGAJAPJ@?$AA?2?$AA?$AA@ 0095 ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 00a2 _wcslen 00be _calloc 00db _wcscat_s 0163 __lock 0171 __old_pfxlen 0179 __tempoff 018f __errno 01b3 _free 01d8 __ultow_s 0236 __SEH_epilog4 0241 __unlock"
	strings:
		$1 = { 6A 20 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D DC 89 5D D0 89 5D E4 6A 02 E8 ?? ?? ?? ?? 59 85 C0 0F 84 0E 02 00 00 68 ?? ?? ?? ?? 53 8D 45 E4 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 3B F3 74 16 83 FE 16 75 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 3B F3 75 19 39 5D E4 74 14 53 FF 75 E4 E8 ?? ?? ?? ?? 59 59 85 C0 75 05 8B 7D E4 EB 2B 8B 7D 08 3B FB 74 0D 53 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 17 53 BF ?? ?? ?? ?? 57 E8 ?? ?? ?? ?? 59 59 85 C0 74 05 BF ?? ?? ?? ?? 39 5D 0C 74 0C FF 75 0C E8 ?? ?? ?? ?? 59 89 45 DC 57 E8 ?? ?? ?? ?? 8B 4D DC 8D 44 08 0C 89 45 E0 6A 02 50 E8 ?? ?? ?? ?? 83 C4 0C 8B F0 89 75 D4 3B F3 0F 84 4F 01 00 00 66 89 1E 57 FF 75 E0 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 57 E8 ?? ?? ?? ?? 59 8D 44 47 FE 0F B7 00 66 3D 5C 00 74 28 66 3D 2F 00 74 22 68 ?? ?? ?? ?? FF 75 E0 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 39 5D 0C 74 20 FF 75 0C FF 75 E0 56 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? 8D 04 46 89 45 D8 6A 02 E8 ?? ?? ?? ?? 59 59 89 5D FC 8B 45 DC 39 05 ?? ?? ?? ?? 73 0A C7 05 ?? ?? ?? ?? 01 00 00 00 A3 ?? ?? ?? ?? A1 ?? ?? ?? ?? 89 45 DC E8 ?? ?? ?? ?? 8B 38 FF 05 ?? ?? ?? ?? A1 ?? ?? ?? ?? 2B 45 DC 3D FF FF FF 7F 76 15 E8 ?? ?? ?? ?? 89 38 56 E8 ?? ?? ?? ?? 59 33 F6 89 75 D4 EB 56 6A 0A 8B 45 D8 2B C6 D1 F8 8B 4D E0 2B C8 51 FF 75 D8 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 10 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? 89 18 53 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 91 E8 ?? ?? ?? ?? 83 38 0D 74 87 E8 ?? ?? ?? ?? 89 38 C7 45 FC FE FF FF FF E8 1D 00 00 00 FF 75 E4 E8 ?? ?? ?? ?? FF 75 D0 E8 ?? ?? ?? ?? 59 59 8B C6 E8 ?? ?? ?? ?? C3 8B 75 D4 6A 02 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_389_0_0 {
	meta:
		name = "??0exception@std@@QAE@XZ"
		size = 17
		refs = "000c ??_7exception@std@@6B@"
	strings:
		$1 = { 8B C1 83 60 04 00 83 60 08 00 C7 00 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_389_1_0 {
	meta:
		name = "??0exception@std@@QAE@ABQBD@Z"
		size = 78
		refs = "000b ??_7exception@std@@6B@ 0017 _strlen 0020 _malloc 0032 _strcpy_s"
	strings:
		$1 = { 53 8B 5C 24 08 56 57 8B F9 C7 07 ?? ?? ?? ?? 8B 03 85 C0 74 26 50 E8 ?? ?? ?? ?? 8B F0 46 56 E8 ?? ?? ?? ?? 85 C0 59 59 89 47 04 74 12 FF 33 56 50 E8 ?? ?? ?? ?? 83 C4 0C EB 04 83 67 04 00 C7 47 08 01 00 00 00 8B C7 5F 5E 5B C2 04 00 }
	condition:
		$1
}

rule file_389_2_0 {
	meta:
		name = "??0exception@std@@QAE@ABQBDH@Z"
		size = 24
		refs = "0008 ??_7exception@std@@6B@"
	strings:
		$1 = { 8B C1 8B 4C 24 04 C7 00 ?? ?? ?? ?? 8B 09 83 60 08 00 89 48 04 C2 08 00 }
	condition:
		$1
}

rule file_389_3_0 {
	meta:
		name = "??0exception@std@@QAE@ABV01@@Z"
		size = 88
		refs = "000a ??_7exception@std@@6B@ 0022 _strlen 002b _malloc 003e _strcpy_s"
	strings:
		$1 = { 53 8B 5C 24 08 56 8B F1 C7 06 ?? ?? ?? ?? 8B 43 08 89 46 08 85 C0 8B 43 04 57 74 31 85 C0 74 27 50 E8 ?? ?? ?? ?? 8B F8 47 57 E8 ?? ?? ?? ?? 85 C0 59 59 89 46 04 74 18 FF 73 04 57 50 E8 ?? ?? ?? ?? 83 C4 0C EB 09 83 66 04 00 EB 03 89 46 04 5F 8B C6 5E 5B C2 04 00 }
	condition:
		$1
}

rule file_389_4_0 {
	meta:
		name = "??4exception@std@@QAEAAV01@ABV01@@Z"
		size = 86
		refs = "0020 _strlen 0029 _malloc 003c _strcpy_s"
	strings:
		$1 = { 53 8B 5C 24 08 56 57 8B F9 3B FB 74 41 8B 43 08 89 47 08 85 C0 8B 43 04 74 31 85 C0 74 27 50 E8 ?? ?? ?? ?? 8B F0 46 56 E8 ?? ?? ?? ?? 85 C0 59 59 89 47 04 74 18 FF 73 04 56 50 E8 ?? ?? ?? ?? 83 C4 0C EB 09 83 67 04 00 EB 03 89 47 04 8B C7 5F 5E 5B C2 04 00 }
	condition:
		$1
}

rule file_389_5_0 {
	meta:
		name = "??1exception@std@@UAE@XZ"
		size = 22
		refs = "0006 ??_7exception@std@@6B@ 0010 _free"
	strings:
		$1 = { 83 79 08 00 C7 01 ?? ?? ?? ?? 74 09 FF 71 04 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_389_7_0 {
	meta:
		name = "??0bad_cast@std@@QAE@PBD@Z"
		size = 25
		refs = "0009 ??0exception@std@@QAE@ABQBD@Z 000f ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 56 8D 44 24 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_44_0_1 {
	meta:
		name = "??0bad_alloc@std@@QAE@PBD@Z"
		size = 25
		refs = "0009 ??0exception@std@@QAE@ABQBD@Z 000f ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 56 8D 44 24 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_395_0_0 {
	meta:
		name = "??0bad_exception@std@@QAE@PBD@Z"
		size = 25
		refs = "0009 ??0exception@std@@QAE@ABQBD@Z 000f ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 56 8D 44 24 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_389_10_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@PBD@Z"
		size = 25
		refs = "0009 ??0exception@std@@QAE@ABQBD@Z 000f ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 56 8D 44 24 08 50 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_389_8_0 {
	meta:
		name = "??0bad_cast@std@@QAE@ABV01@@Z"
		size = 24
		refs = "0008 ??0exception@std@@QAE@ABV01@@Z 000e ??_7bad_cast@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_389_14_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@ABV01@@Z"
		size = 24
		refs = "0008 ??0bad_typeid@std@@QAE@ABV01@@Z 000e ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_389_13_0 {
	meta:
		name = "??0__non_rtti_object@std@@QAE@PBD@Z"
		size = 24
		refs = "0008 ??0bad_typeid@std@@QAE@PBD@Z 000e ??_7__non_rtti_object@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_45_56_1 {
	meta:
		name = "??0bad_alloc@std@@QAE@ABV01@@Z"
		size = 24
		refs = "0008 ??0exception@std@@QAE@ABV01@@Z 000e ??_7bad_alloc@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_395_31_0 {
	meta:
		name = "??0bad_exception@std@@QAE@ABV01@@Z"
		size = 24
		refs = "0008 ??0exception@std@@QAE@ABV01@@Z 000e ??_7bad_exception@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_389_11_0 {
	meta:
		name = "??0bad_typeid@std@@QAE@ABV01@@Z"
		size = 24
		refs = "0008 ??0exception@std@@QAE@ABV01@@Z 000e ??_7bad_typeid@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_59_241_1 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV012@@Z"
		size = 24
		refs = "0008 ??0runtime_error@std@@QAE@ABV01@@Z 000e ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_44_170_1 {
	meta:
		name = "??0failure@ios_base@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@2@@Z"
		size = 24
		refs = "0008 ??0runtime_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 000e ??_7failure@ios_base@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_69_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV01@@Z"
		size = 24
		refs = "0008 ??0logic_error@std@@QAE@ABV01@@Z 000e ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_40_1 {
	meta:
		name = "??0invalid_argument@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 24
		refs = "0008 ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 000e ??_7invalid_argument@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_55_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV01@@Z"
		size = 24
		refs = "0008 ??0logic_error@std@@QAE@ABV01@@Z 000e ??_7length_error@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_43_1 {
	meta:
		name = "??0length_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 24
		refs = "0008 ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 000e ??_7length_error@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_61_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV01@@Z"
		size = 24
		refs = "0008 ??0logic_error@std@@QAE@ABV01@@Z 000e ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_46_1 {
	meta:
		name = "??0out_of_range@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 24
		refs = "0008 ??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 000e ??_7out_of_range@std@@6B@"
	strings:
		$1 = { 56 FF 74 24 08 8B F1 E8 ?? ?? ?? ?? C7 06 ?? ?? ?? ?? 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_389_16_0 {
	meta:
		name = "??_Gexception@std@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1exception@std@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_80_123_1 {
	meta:
		name = "??_G?$_Mpunct@D@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$_Mpunct@D@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_324_1 {
	meta:
		name = "??_G?$_Mpunct@G@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$_Mpunct@G@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_323_1 {
	meta:
		name = "??_G?$_Mpunct@_W@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$_Mpunct@_W@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_30_220_1 {
	meta:
		name = "??_G?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_7_247_1 {
	meta:
		name = "??_G?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_45_246_1 {
	meta:
		name = "??_G?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_30_86_1 {
	meta:
		name = "??_G?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$basic_streambuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_76_89_1 {
	meta:
		name = "??_G?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$basic_streambuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_59_90_1 {
	meta:
		name = "??_G?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_26_68_1 {
	meta:
		name = "??_G?$ctype@D@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$ctype@D@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_39_231_1 {
	meta:
		name = "??_G?$ctype@G@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$ctype@G@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_128_1 {
	meta:
		name = "??_G?$ctype@_W@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$ctype@_W@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_26_139_1 {
	meta:
		name = "??_G?$numpunct@D@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$numpunct@D@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_414_1 {
	meta:
		name = "??_G?$numpunct@G@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$numpunct@G@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_407_1 {
	meta:
		name = "??_G?$numpunct@_W@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$numpunct@_W@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_80_299_1 {
	meta:
		name = "??_G?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_776_1 {
	meta:
		name = "??_G?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_740_1 {
	meta:
		name = "??_G?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_80_122_1 {
	meta:
		name = "??_G?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$time_put@DV?$ostreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_322_1 {
	meta:
		name = "??_G?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$time_put@GV?$ostreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_158_1 {
	meta:
		name = "??_G?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1?$time_put@_WV?$ostreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_75_20_1 {
	meta:
		name = "??_G_Fac_node@std@@QAEPAXI@Z"
		size = 28
		refs = "0004 ??1_Fac_node@std@@QAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_75_78_1 {
	meta:
		name = "??_G_Locimp@locale@std@@MAEPAXI@Z"
		size = 28
		refs = "0004 ??1_Locimp@locale@std@@MAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_65_40_1 {
	meta:
		name = "??_Glocale@std@@QAEPAXI@Z"
		size = 28
		refs = "0004 ??1locale@std@@QAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_39_1 {
	meta:
		name = "??_Glogic_error@std@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1logic_error@std@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_83_147_1 {
	meta:
		name = "??_Gruntime_error@std@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1runtime_error@std@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_642_2_0 {
	meta:
		name = "??_Gtype_info@@UAEPAXI@Z"
		size = 28
		refs = "0004 ??1type_info@@UAE@XZ 0011 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_389_17_0 {
	meta:
		name = "??_Gbad_cast@std@@UAEPAXI@Z"
		size = 34
		refs = "0005 ??_7bad_cast@std@@6B@ 000a ??1exception@std@@UAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_80_175_1 {
	meta:
		name = "??_G?$moneypunct@D$00@std@@MAEPAXI@Z"
		size = 34
		refs = "0005 ??_7?$moneypunct@D$00@std@@6B@ 000a ??1?$_Mpunct@D@std@@MAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_80_172_1 {
	meta:
		name = "??_G?$moneypunct@D$0A@@std@@MAEPAXI@Z"
		size = 34
		refs = "0005 ??_7?$moneypunct@D$0A@@std@@6B@ 000a ??1?$_Mpunct@D@std@@MAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_473_1 {
	meta:
		name = "??_G?$moneypunct@G$00@std@@MAEPAXI@Z"
		size = 34
		refs = "0005 ??_7?$moneypunct@G$00@std@@6B@ 000a ??1?$_Mpunct@G@std@@MAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_470_1 {
	meta:
		name = "??_G?$moneypunct@G$0A@@std@@MAEPAXI@Z"
		size = 34
		refs = "0005 ??_7?$moneypunct@G$0A@@std@@6B@ 000a ??1?$_Mpunct@G@std@@MAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_467_1 {
	meta:
		name = "??_G?$moneypunct@_W$00@std@@MAEPAXI@Z"
		size = 34
		refs = "0005 ??_7?$moneypunct@_W$00@std@@6B@ 000a ??1?$_Mpunct@_W@std@@MAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_4_464_1 {
	meta:
		name = "??_G?$moneypunct@_W$0A@@std@@MAEPAXI@Z"
		size = 34
		refs = "0005 ??_7?$moneypunct@_W$0A@@std@@6B@ 000a ??1?$_Mpunct@_W@std@@MAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_389_19_0 {
	meta:
		name = "??_G__non_rtti_object@std@@UAEPAXI@Z"
		size = 34
		refs = "0005 ??_7bad_typeid@std@@6B@ 000a ??1exception@std@@UAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_39_2_1 {
	meta:
		name = "??_Gbad_alloc@std@@UAEPAXI@Z"
		size = 34
		refs = "0005 ??_7bad_alloc@std@@6B@ 000a ??1exception@std@@UAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_395_2_0 {
	meta:
		name = "??_Gbad_exception@std@@UAEPAXI@Z"
		size = 34
		refs = "0005 ??_7bad_exception@std@@6B@ 000a ??1exception@std@@UAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_389_18_0 {
	meta:
		name = "??_Gbad_typeid@std@@UAEPAXI@Z"
		size = 34
		refs = "0005 ??_7bad_typeid@std@@6B@ 000a ??1exception@std@@UAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_18_176_1 {
	meta:
		name = "??_Gfailure@ios_base@std@@UAEPAXI@Z"
		size = 34
		refs = "0005 ??_7failure@ios_base@std@@6B@ 000a ??1runtime_error@std@@UAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_42_1 {
	meta:
		name = "??_Ginvalid_argument@std@@UAEPAXI@Z"
		size = 34
		refs = "0005 ??_7invalid_argument@std@@6B@ 000a ??1logic_error@std@@UAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_45_1 {
	meta:
		name = "??_Glength_error@std@@UAEPAXI@Z"
		size = 34
		refs = "0005 ??_7length_error@std@@6B@ 000a ??1logic_error@std@@UAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_24_48_1 {
	meta:
		name = "??_Gout_of_range@std@@UAEPAXI@Z"
		size = 34
		refs = "0005 ??_7out_of_range@std@@6B@ 000a ??1logic_error@std@@UAE@XZ 0017 ??3@YAXPAX@Z"
	strings:
		$1 = { 56 8B F1 C7 06 ?? ?? ?? ?? E8 ?? ?? ?? ?? F6 44 24 08 01 74 07 56 E8 ?? ?? ?? ?? 59 8B C6 5E C2 04 00 }
	condition:
		$1
}

rule file_390_3_0 {
	meta:
		name = "__mbsset_l"
		size = 185
		refs = "0015 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0020 __errno 0030 __invalid_parameter 0054 __strset"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 08 57 FF 75 10 8D 4D F0 8B FE E8 ?? ?? ?? ?? 33 DB 3B F3 75 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 EB 6D 8B 45 F4 39 58 08 75 19 FF 75 0C 56 E8 ?? ?? ?? ?? 38 5D FC 59 59 74 55 8B 4D F8 83 61 70 FD EB 4C 8B 4D 0C 8B C1 C1 E8 08 3A C3 74 2E 3A CB 75 21 E8 ?? ?? ?? ?? C7 00 16 00 00 00 B0 20 8A C8 EB 10 88 06 46 38 1E 74 05 88 0E 46 EB 04 C6 46 FF 20 38 1E 75 EC EB 07 88 0E 46 38 1E 75 F9 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C7 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_391_3_0 {
	meta:
		name = "__iswctype_l"
		size = 130
		refs = "0022 __pwctype 003d ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 005b ___crtGetStringTypeW"
	strings:
		$1 = { 55 8B EC 83 EC 14 66 81 7D 08 FF FF 75 06 83 65 FC 00 EB 62 66 81 7D 08 00 01 73 1A 0F B7 45 08 8B 0D ?? ?? ?? ?? 66 8B 04 41 66 23 45 0C 0F B7 C0 89 45 FC EB 40 FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 8B 45 EC FF 70 14 FF 70 04 8D 45 FC 50 6A 01 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 75 03 21 45 FC 80 7D F8 00 74 07 8B 45 F4 83 60 70 FD 0F B7 45 FC 0F B7 4D 0C 23 C1 C9 C3 }
	condition:
		$1
}

rule file_391_4_0 {
	meta:
		name = "_iswctype"
		size = 110
		refs = "001e __pwctype 0030 ___locale_changed 0039 ___initiallocinfo 0050 ___initiallocalestructinfo 0055 ___crtGetStringTypeW 0065 __iswctype_l"
	strings:
		$1 = { 55 8B EC 51 66 81 7D 08 FF FF 75 04 33 C0 C9 C3 66 81 7D 08 00 01 73 16 0F B7 45 08 8B 0D ?? ?? ?? ?? 0F B7 04 41 0F B7 4D 0C 23 C1 C9 C3 83 3D ?? ?? ?? ?? 00 75 25 FF 35 ?? ?? ?? ?? 8D 45 FC FF 35 ?? ?? ?? ?? 50 6A 01 8D 45 08 50 6A 01 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 1C 6A 00 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C C9 C3 }
	condition:
		$1
}

rule file_392_0_0 {
	meta:
		name = "__CIsqrt"
		size = 186
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0031 __load_CW 0040 ___fastflag 0047 __fast_exit 0052 _NAME_ 0057 __math_exit 0073 __convertTOStoQNaN 0092 __indefinite 00b4 __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 8B 44 24 0C 74 51 66 81 3C 24 7F 02 74 05 E8 ?? ?? ?? ?? A9 00 00 00 80 75 1F D9 FA 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E9 ?? ?? ?? ?? A9 00 00 F0 7F 75 2C A9 FF FF 0F 00 75 25 83 7C 24 08 00 75 1E EB CC E8 ?? ?? ?? ?? EB 22 A9 FF FF 0F 00 75 F2 83 7C 24 08 00 75 EB 25 00 00 00 80 74 B0 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? BA 05 00 00 00 8D 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_393_0_0 {
	meta:
		name = "_setvbuf"
		size = 254
		refs = "0003 __sehtable$_setvbuf 0008 __SEH_prolog4 0020 __errno 0030 __invalid_parameter 0073 __lock_file 007d __flush 0083 __freebuf 00ad __malloc_crt 00b8 __cflush 00ef __SEH_epilog4 00f8 __unlock_file"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C0 8B 75 08 3B F3 0F 95 C0 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 AF 00 00 00 8B 45 10 83 F8 04 74 09 3B C3 74 0E 83 F8 40 75 CF 3B C3 74 05 83 F8 40 75 0F 8B 7D 14 8D 47 FE 3D FD FF FF 7F 76 05 EB B7 8B 7D 14 83 E7 FE 89 75 08 56 E8 ?? ?? ?? ?? 59 89 5D FC 56 E8 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 59 59 81 66 0C F3 C2 FF FF 8B 4E 0C F6 45 10 04 74 0B 83 C9 04 8D 46 14 6A 02 5F EB 2D 8B 45 0C 3B C3 75 20 57 E8 ?? ?? ?? ?? 59 3B C3 75 0C FF 05 ?? ?? ?? ?? 83 4D E4 FF EB 1D 81 4E 0C 08 04 00 00 EB 09 81 C9 00 05 00 00 89 4E 0C 89 7E 18 89 46 08 89 06 89 5E 04 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 75 08 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_394_0_0 {
	meta:
		name = "__hypothlp"
		size = 588
		refs = "0015 __ctrlfp 00bb _sqrt 00c3 __decomp 00ee __get_exp 0110 __set_exp 0207 __except2 0223 __d_inf 0240 __handle_qnan2"
	strings:
		$1 = { 55 8B EC 83 EC 18 53 56 57 BE FF FF 00 00 56 68 3F 13 00 00 E8 ?? ?? ?? ?? 8B 55 0E 8B 7D 16 59 59 8B D8 B8 F0 7F 00 00 8B CA 66 23 C8 66 3B C8 0F 84 7F 01 00 00 8B CF 66 23 C8 66 3B C8 0F 84 71 01 00 00 D9 EE DD 45 08 D8 D1 DF E0 F6 C4 05 7A 02 D9 E0 DD 45 10 D8 D2 DF E0 F6 C4 05 7A 02 D9 E0 D8 D1 DF E0 F6 C4 41 75 05 DD 55 F0 EB 07 D9 C9 DD 55 F0 D9 C9 D9 CA DC 5D F0 DF E0 F6 C4 44 7A 14 56 DD D9 53 DD D8 E8 ?? ?? ?? ?? D9 EE 59 59 E9 B0 01 00 00 DC 75 F0 8D 45 F8 50 51 51 DD 5D 08 DC 75 F0 DD 5D 10 DD 45 08 DC 4D 08 DD 45 10 DC 4D 10 DE C1 DD 1C 24 E8 ?? ?? ?? ?? DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D E8 DD 45 F0 8D 45 FC 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 4D E8 83 C4 04 DD 5D F0 DD 45 F0 DD 1C 24 E8 ?? ?? ?? ?? 03 45 FC DD 45 F0 59 03 45 F8 59 3D 00 04 00 00 7E 32 05 00 FA FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 53 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 11 E9 D0 00 00 00 3D 03 FC FF FF 7D 32 05 00 06 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C 53 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 12 E9 97 00 00 00 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C DD 5D F0 F6 C3 20 74 11 56 53 E8 ?? ?? ?? ?? DD 45 F0 59 59 E9 B1 00 00 00 DD 45 F0 53 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 10 EB 51 B9 F8 7F 00 00 23 D1 66 3B D0 75 0F F7 45 0C FF FF 07 00 75 1C 83 7D 08 00 75 16 23 F9 66 3B F8 75 39 F7 45 14 FF FF 07 00 75 06 83 7D 10 00 74 2A DD 45 08 53 DC 45 10 83 EC 18 DD 5C 24 10 DD 45 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 6A 08 E8 ?? ?? ?? ?? 83 C4 24 EB 37 66 3B D1 74 16 66 3B F9 74 11 56 53 E8 ?? ?? ?? ?? DD 05 ?? ?? ?? ?? 59 59 EB 1C DD 45 10 53 83 EC 10 DD 5C 24 08 DD 45 08 DD 1C 24 FF 75 18 E8 ?? ?? ?? ?? 83 C4 18 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_394_1_0 {
	meta:
		name = "__hypot"
		size = 29
		refs = "0015 __hypothlp"
	strings:
		$1 = { DD 44 24 0C 6A 18 83 EC 10 DD 5C 24 08 DD 44 24 18 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_394_2_0 {
	meta:
		name = "__cabs"
		size = 29
		refs = "0015 __hypothlp"
	strings:
		$1 = { DD 44 24 0C 6A 11 83 EC 10 DD 5C 24 08 DD 44 24 18 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_395_3_0 {
	meta:
		name = "___TypeMatch"
		size = 92
		refs = "0026 _strcmp"
	strings:
		$1 = { 56 57 8B 7C 24 0C 8B 47 04 85 C0 74 49 8D 50 08 80 3A 00 74 41 8B 74 24 10 8B 4E 04 3B C1 74 14 83 C1 08 51 52 E8 ?? ?? ?? ?? 85 C0 59 59 74 04 33 C0 EB 25 F6 06 02 74 05 F6 07 08 74 F2 8B 44 24 14 8B 00 A8 01 74 05 F6 07 01 74 E3 A8 02 74 05 F6 07 02 74 DA 33 C0 40 5F 5E C3 }
	condition:
		$1
}

rule file_395_4_0 {
	meta:
		name = "___FrameUnwindFilter"
		size = 68
		refs = "0017 __getptd 0023 ?terminate@@YAXXZ"
	strings:
		$1 = { 8B 44 24 04 8B 00 8B 00 3D 4D 4F 43 E0 74 18 3D 63 73 6D E0 75 2B E8 ?? ?? ?? ?? 83 A0 90 00 00 00 00 E9 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7E 0C E8 ?? ?? ?? ?? 05 90 00 00 00 FF 08 33 C0 C3 }
	condition:
		$1
}

rule file_395_5_0 {
	meta:
		name = "___FrameUnwindToState"
		size = 225
		refs = "0003 __sehtable$___FrameUnwindToState 0008 __SEH_prolog4 0028 __getptd 0047 ?_inconsistency@@YAXXZ 0078 __CallSettingFrame@12 0086 ___FrameUnwindFilter 00bb __SEH_epilog4"
	strings:
		$1 = { 6A 10 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 7D 10 8B 5D 08 81 7F 04 80 00 00 00 7F 06 0F BE 73 08 EB 03 8B 73 08 89 75 E4 E8 ?? ?? ?? ?? 05 90 00 00 00 FF 00 83 65 FC 00 3B 75 14 74 65 83 FE FF 7E 05 3B 77 04 7C 05 E8 ?? ?? ?? ?? 8B C6 C1 E0 03 8B 4F 08 03 C8 8B 31 89 75 E0 C7 45 FC 01 00 00 00 83 79 04 00 74 15 89 73 08 68 03 01 00 00 53 8B 4F 08 FF 74 01 04 E8 ?? ?? ?? ?? 83 65 FC 00 EB 1A FF 75 EC E8 ?? ?? ?? ?? 59 C3 8B 65 E8 83 65 FC 00 8B 7D 10 8B 5D 08 8B 75 E0 89 75 E4 EB 96 C7 45 FC FE FF FF FF E8 19 00 00 00 3B 75 14 74 05 E8 ?? ?? ?? ?? 89 73 08 E8 ?? ?? ?? ?? C3 8B 5D 08 8B 75 E4 E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 7E 0C E8 ?? ?? ?? ?? 05 90 00 00 00 FF 08 C3 }
	condition:
		$1
}

rule file_395_6_0 {
	meta:
		name = "?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 69
		refs = "0032 __getptd"
	strings:
		$1 = { 8B 00 81 38 63 73 6D E0 75 38 83 78 10 03 75 32 8B 48 14 81 F9 20 05 93 19 74 10 81 F9 21 05 93 19 74 08 81 F9 22 05 93 19 75 17 83 78 1C 00 75 11 E8 ?? ?? ?? ?? 33 C9 41 89 88 0C 02 00 00 8B C1 C3 33 C0 C3 }
	condition:
		$1
}

rule file_395_7_0 {
	meta:
		name = "___DestructExceptionObject"
		size = 84
		refs = "0003 __sehtable$___DestructExceptionObject 0008 __SEH_prolog4 0032 ?_CallMemberFunction0@@YGXPAX0@Z 003e __SEH_epilog4 0050 ?terminate@@YAXXZ"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 4D 08 85 C9 74 2A 81 39 63 73 6D E0 75 22 8B 41 1C 85 C0 74 1B 8B 40 04 85 C0 74 14 83 65 FC 00 50 FF 71 18 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 33 C0 38 45 0C 0F 95 C0 C3 8B 65 E8 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_8_0 {
	meta:
		name = "___AdjustPointer"
		size = 37
	strings:
		$1 = { 8B 4C 24 08 8B 01 56 8B 74 24 08 03 C6 83 79 04 00 7C 10 8B 51 04 8B 49 08 8B 34 32 8B 0C 0E 03 CA 03 C1 5E C3 }
	condition:
		$1
}

rule file_395_9_0 {
	meta:
		name = "?__uncaught_exception@@YA_NXZ"
		size = 19
		refs = "0001 __getptd"
	strings:
		$1 = { E8 ?? ?? ?? ?? 33 C9 39 88 90 00 00 00 0F 95 C1 8A C1 C3 }
	condition:
		$1
}

rule file_395_10_0 {
	meta:
		name = "___CxxRegisterExceptionObject"
		size = 179
		refs = "0041 __getptd 0050 __CreateFrameInfo"
	strings:
		$1 = { 8B 44 24 04 85 C0 56 57 8B 7C 24 10 74 71 8B 30 85 F6 74 6B 81 3E 63 73 6D E0 75 2F 83 7E 10 03 75 29 8B 46 14 3D 20 05 93 19 74 0E 3D 21 05 93 19 74 07 3D 22 05 93 19 75 11 83 7E 1C 00 75 0B E8 ?? ?? ?? ?? 8B B0 88 00 00 00 FF 76 18 57 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 47 08 E8 ?? ?? ?? ?? 8B 80 8C 00 00 00 89 47 0C E8 ?? ?? ?? ?? 89 B0 88 00 00 00 EB 08 83 4F 08 FF 83 4F 0C FF E8 ?? ?? ?? ?? 05 90 00 00 00 FF 08 E8 ?? ?? ?? ?? 83 B8 90 00 00 00 00 5F 5E 7D 0C E8 ?? ?? ?? ?? 83 A0 90 00 00 00 00 33 C0 40 C3 }
	condition:
		$1
}

rule file_395_11_0 {
	meta:
		name = "___CxxDetectRethrow"
		size = 76
		refs = "003a __getptd"
	strings:
		$1 = { 8B 44 24 04 85 C0 74 41 8B 00 81 38 63 73 6D E0 75 37 83 78 10 03 75 31 8B 48 14 81 F9 20 05 93 19 74 10 81 F9 21 05 93 19 74 08 81 F9 22 05 93 19 75 16 83 78 1C 00 75 10 E8 ?? ?? ?? ?? 05 90 00 00 00 FF 00 33 C0 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_395_12_0 {
	meta:
		name = "___CxxUnregisterExceptionObject"
		size = 315
		refs = "0014 __FindAndUnlinkFrame 0034 __getptd 0096 __IsExceptionObjectToBeDestroyed 00ad ___DestructExceptionObject"
	strings:
		$1 = { 56 8B 74 24 08 83 7E 08 FF 0F 84 2A 01 00 00 53 55 57 56 E8 ?? ?? ?? ?? 83 7C 24 1C 00 59 BF 63 73 6D E0 BB 20 05 93 19 BD 21 05 93 19 0F 85 80 00 00 00 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 39 38 75 71 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 83 78 10 03 75 60 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 39 58 14 74 24 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 39 68 14 74 14 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 22 05 93 19 75 2C E8 ?? ?? ?? ?? 8B 80 88 00 00 00 FF 70 18 E8 ?? ?? ?? ?? 85 C0 59 74 14 6A 01 E8 ?? ?? ?? ?? FF B0 88 00 00 00 E8 ?? ?? ?? ?? 59 59 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 39 38 75 58 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 83 78 10 03 75 47 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 39 58 14 74 24 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 39 68 14 74 14 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 81 78 14 22 05 93 19 75 13 83 7C 24 18 00 74 0C E8 ?? ?? ?? ?? 05 90 00 00 00 FF 08 E8 ?? ?? ?? ?? 8B 4E 08 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 4E 0C 5F 5D 89 88 8C 00 00 00 5B 5E C3 }
	condition:
		$1
}

rule file_395_14_0 {
	meta:
		name = "___CxxCallUnwindDtor"
		size = 50
		refs = "0003 __sehtable$___CxxCallUnwindDtor 0008 __SEH_prolog4 001c ___FrameUnwindFilter 002d __SEH_epilog4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 8B 4D 0C FF 55 08 EB 0D FF 75 EC E8 ?? ?? ?? ?? 59 C3 8B 65 E8 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_395_15_0 {
	meta:
		name = "___CxxCallUnwindDelDtor"
		size = 51
		refs = "0003 __sehtable$___CxxCallUnwindDelDtor 0008 __SEH_prolog4 001d ___FrameUnwindFilter 002e __SEH_epilog4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 75 0C FF 55 08 59 EB 0D FF 75 EC E8 ?? ?? ?? ?? 59 C3 8B 65 E8 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_395_16_0 {
	meta:
		name = "___CxxCallUnwindStdDelDtor"
		size = 50
		refs = "0003 __sehtable$___CxxCallUnwindStdDelDtor 0008 __SEH_prolog4 001c ___FrameUnwindFilter 002d __SEH_epilog4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 75 0C FF 55 08 EB 0D FF 75 EC E8 ?? ?? ?? ?? 59 C3 8B 65 E8 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_395_17_0 {
	meta:
		name = "___CxxCallUnwindVecDtor"
		size = 59
		refs = "0003 __sehtable$___CxxCallUnwindVecDtor 0008 __SEH_prolog4 0025 ___FrameUnwindFilter 0036 __SEH_epilog4"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 75 18 FF 75 14 FF 75 10 FF 75 0C FF 55 08 EB 0D FF 75 EC E8 ?? ?? ?? ?? 59 C3 8B 65 E8 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_395_18_0 {
	meta:
		name = "?IsInExceptionSpec@@YAEPAUEHExceptionRecord@@PBU_s_ESTypeList@@@Z"
		size = 121
		refs = "000b ?_inconsistency@@YAXXZ 0010 ?terminate@@YAXXZ 004f ___TypeMatch"
	strings:
		$1 = { 55 8B EC 83 EC 0C 85 FF 75 0A E8 ?? ?? ?? ?? E9 ?? ?? ?? ?? 83 65 F8 00 83 3F 00 C6 45 FF 00 7E 53 53 56 8B 45 08 8B 40 1C 8B 40 0C 8B 18 85 DB 8D 70 04 7E 33 8B 45 F8 C1 E0 04 89 45 F4 8B 4D 08 FF 71 1C 8B 06 50 8B 47 04 03 45 F4 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0A 4B 83 C6 04 85 DB 7F DC EB 04 C6 45 FF 01 FF 45 F8 8B 45 F8 3B 07 7C B1 5E 5B 8A 45 FF C9 C3 }
	condition:
		$1
}

rule file_395_19_0 {
	meta:
		name = "?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 49
		refs = "0003 __ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0008 __EH_prolog3_catch 000d __getptd 001b ?_inconsistency@@YAXXZ 0024 ?unexpected@@YAXXZ 002d ?terminate@@YAXXZ"
	strings:
		$1 = { 6A 04 B8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 74 05 E8 ?? ?? ?? ?? 83 65 FC 00 E8 ?? ?? ?? ?? 83 4D FC FF E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_20_0 {
	meta:
		name = "__catch$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z$0"
		size = 24
		refs = "0001 __getptd 0013 __CxxThrowException@8"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 4D 08 6A 00 6A 00 89 88 94 00 00 00 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_395_21_0 {
	meta:
		name = "__ehhandler$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_154_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@D@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_425_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@G@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_421_1 {
	meta:
		name = "__ehhandler$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$_Mpunct@_W@std@@QAE@ABV_Locinfo@1@I_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_44_103_1 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@DU?$char_traits@D@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_107_1 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@GU?$char_traits@G@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_107_1 {
	meta:
		name = "__ehhandler$??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$basic_streambuf@_WU?$char_traits@_W@std@@@std@@IAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_26_135_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@D@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_410_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@G@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_403_1 {
	meta:
		name = "__ehhandler$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$numpunct@_W@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_293_1 {
	meta:
		name = "__ehhandler$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@DV?$istreambuf_iterator@DU?$char_traits@D@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_770_1 {
	meta:
		name = "__ehhandler$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@GV?$istreambuf_iterator@GU?$char_traits@G@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_4_734_1 {
	meta:
		name = "__ehhandler$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0?$time_get@_WV?$istreambuf_iterator@_WU?$char_traits@_W@std@@@std@@@std@@QAE@ABV_Locinfo@1@I@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_73_1 {
	meta:
		name = "__ehhandler$??0_Locimp@locale@std@@AAE@_N@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0_Locimp@locale@std@@AAE@_N@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_54_1 {
	meta:
		name = "__ehhandler$??0logic_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0logic_error@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_35_1 {
	meta:
		name = "__ehhandler$??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0logic_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_53_61_1 {
	meta:
		name = "__ehhandler$??0runtime_error@std@@QAE@ABV01@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0runtime_error@std@@QAE@ABV01@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_11_49_1 {
	meta:
		name = "__ehhandler$??0runtime_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??0runtime_error@std@@QAE@ABV?$basic_string@DU?$char_traits@D@std@@V?$allocator@D@2@@1@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_219_1 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@DU?$char_traits@D@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_39_245_1 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@GU?$char_traits@G@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_18_245_1 {
	meta:
		name = "__ehhandler$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1?$basic_filebuf@_WU?$char_traits@_W@std@@@std@@UAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_77_1 {
	meta:
		name = "__ehhandler$??1_Locimp@locale@std@@MAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locimp@locale@std@@MAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_188_1 {
	meta:
		name = "__ehhandler$??1_Locinfo@std@@QAE@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$??1_Locinfo@std@@QAE@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_34_1 {
	meta:
		name = "__ehhandler$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?_Locimp_dtor@_Locimp@locale@std@@CAXPAV123@@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_75_87_1 {
	meta:
		name = "__ehhandler$?empty@locale@std@@SA?AV12@XZ"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?empty@locale@std@@SA?AV12@XZ 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_61_237_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@DU?$char_traits@D@std@@@std@@QBEDD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_76_258_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@GU?$char_traits@G@std@@@std@@QBEGD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_65_258_1 {
	meta:
		name = "__ehhandler$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z"
		size = 27
		refs = "000d @__security_check_cookie@4 0012 __ehfuncinfo$?widen@?$basic_ios@_WU?$char_traits@_W@std@@@std@@QBE_WD@Z 0017 ___CxxFrameHandler3"
	strings:
		$1 = { 8B 54 24 08 8D 42 0C 8B 4A EC 33 C8 E8 ?? ?? ?? ?? B8 ?? ?? ?? ?? E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_22_0 {
	meta:
		name = "?Is_bad_exception_allowed@@YAEPBU_s_ESTypeList@@@Z"
		size = 48
		refs = "0012 ??_R0?AVbad_exception@std@@@8 0017 ??8type_info@@QBE_NABV0@@Z"
	strings:
		$1 = { 53 57 33 DB 33 FF 39 1E 7E 1D 8B 46 04 8B 4C 03 04 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 0D 47 83 C3 10 3B 3E 7C E3 32 C0 5F 5B C3 B0 01 EB F9 }
	condition:
		$1
}

rule file_395_23_0 {
	meta:
		name = "?_is_exception_typeof@@YAHABVtype_info@@PAU_EXCEPTION_POINTERS@@@Z"
		size = 130
		refs = "000b ?_inconsistency@@YAXXZ 0060 ?raw_name@type_info@@QBEPBDXZ 0066 _strcmp"
	strings:
		$1 = { 56 8B 74 24 0C 85 F6 57 75 05 E8 ?? ?? ?? ?? 8B 36 85 F6 75 05 E8 ?? ?? ?? ?? 81 3E 63 73 6D E0 75 1E 83 7E 10 03 75 18 8B 46 14 3D 20 05 93 19 74 13 3D 21 05 93 19 74 0C 3D 22 05 93 19 74 05 E8 ?? ?? ?? ?? 8B 46 1C 8B 40 0C 8B 38 8D 70 04 EB 22 8B 06 8B 40 04 8B 4C 24 0C 83 C0 08 50 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 0D 4F 83 C6 04 85 FF 7F DA 33 C0 5F 5E C3 33 C0 40 EB F8 }
	condition:
		$1
}

rule file_395_24_0 {
	meta:
		name = "?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 412
		refs = "0003 __sehtable$?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 0008 __SEH_prolog4 0029 __CreateFrameInfo 0033 __getptd 0080 ?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z 0094 ?ExFilterRethrow@@YAHPAU_EXCEPTION_POINTERS@@@Z 00ed ___FrameUnwindToState 0116 __SEH_epilog4 0130 __FindAndUnlinkFrame 0187 __IsExceptionObjectToBeDestroyed 0195 ___DestructExceptionObject"
	strings:
		$1 = { 6A 2C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B D9 8B 7D 0C 8B 75 08 89 5D E4 83 65 CC 00 8B 47 FC 89 45 DC FF 76 18 8D 45 C4 50 E8 ?? ?? ?? ?? 59 59 89 45 D8 E8 ?? ?? ?? ?? 8B 80 88 00 00 00 89 45 D4 E8 ?? ?? ?? ?? 8B 80 8C 00 00 00 89 45 D0 E8 ?? ?? ?? ?? 89 B0 88 00 00 00 E8 ?? ?? ?? ?? 8B 4D 10 89 88 8C 00 00 00 83 65 FC 00 33 C0 40 89 45 10 89 45 FC FF 75 1C FF 75 18 53 FF 75 14 57 E8 ?? ?? ?? ?? 83 C4 14 89 45 E4 83 65 FC 00 EB 6F 8B 45 EC E8 ?? ?? ?? ?? C3 8B 65 E8 E8 ?? ?? ?? ?? 83 A0 0C 02 00 00 00 8B 75 14 8B 7D 0C 81 7E 04 80 00 00 00 7F 06 0F BE 4F 08 EB 03 8B 4F 08 8B 5E 10 83 65 E0 00 8B 45 E0 3B 46 0C 73 18 6B C0 14 03 C3 8B 50 04 3B CA 7E 40 3B 48 08 7F 3B 8B 46 08 8B 4C D0 08 51 56 6A 00 57 E8 ?? ?? ?? ?? 83 C4 10 83 65 E4 00 83 65 FC 00 8B 75 08 C7 45 FC FE FF FF FF C7 45 10 00 00 00 00 E8 14 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 FF 45 E0 EB A7 8B 7D 0C 8B 75 08 8B 45 DC 89 47 FC FF 75 D8 E8 ?? ?? ?? ?? 59 E8 ?? ?? ?? ?? 8B 4D D4 89 88 88 00 00 00 E8 ?? ?? ?? ?? 8B 4D D0 89 88 8C 00 00 00 81 3E 63 73 6D E0 75 42 83 7E 10 03 75 3C 8B 46 14 3D 20 05 93 19 74 0E 3D 21 05 93 19 74 07 3D 22 05 93 19 75 24 83 7D CC 00 75 1E 83 7D E4 00 74 18 FF 76 18 E8 ?? ?? ?? ?? 59 85 C0 74 0B FF 75 10 56 E8 ?? ?? ?? ?? 59 59 C3 }
	condition:
		$1
}

rule file_395_25_0 {
	meta:
		name = "___BuildCatchObjectHelper"
		size = 383
		refs = "0003 __sehtable$___BuildCatchObjectHelper 0008 __SEH_prolog4 005a ?_ValidateRead@@YAHPBXI@Z 006b ?_ValidateWrite@@YAHPAXI@Z 0087 ___AdjustPointer 00cc _memmove 0142 ?_ValidateExecute@@YAHP6GHXZ@Z 015b ?_inconsistency@@YAXXZ 0173 ?terminate@@YAXXZ 017a __SEH_epilog4"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 D2 89 55 E4 8B 45 10 8B 48 04 3B CA 0F 84 58 01 00 00 38 51 08 0F 84 4F 01 00 00 8B 48 08 3B CA 75 0C F7 00 00 00 00 80 0F 84 3C 01 00 00 8B 00 8B 75 0C 85 C0 78 04 8D 74 31 0C 89 55 FC 33 DB 43 53 A8 08 74 41 8B 7D 08 FF 77 18 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 F2 00 00 00 53 56 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 E1 00 00 00 8B 47 18 89 06 8B 4D 14 83 C1 08 51 50 E8 ?? ?? ?? ?? 59 59 89 06 E9 CB 00 00 00 8B 7D 14 8B 45 08 FF 70 18 84 1F 74 48 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 AA 00 00 00 53 56 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 99 00 00 00 FF 77 14 8B 45 08 FF 70 18 56 E8 ?? ?? ?? ?? 83 C4 0C 83 7F 14 04 0F 85 82 00 00 00 8B 06 85 C0 74 7C 83 C7 08 57 EB 9C 39 57 18 75 38 E8 ?? ?? ?? ?? 59 59 85 C0 74 61 53 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 54 FF 77 14 83 C7 08 57 8B 45 08 FF 70 18 E8 ?? ?? ?? ?? 59 59 50 56 E8 ?? ?? ?? ?? 83 C4 0C EB 39 E8 ?? ?? ?? ?? 59 59 85 C0 74 29 53 56 E8 ?? ?? ?? ?? 59 59 85 C0 74 1C FF 77 18 E8 ?? ?? ?? ?? 59 85 C0 74 0F F6 07 04 6A 00 58 0F 95 C0 40 89 45 E4 EB 05 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF 8B 45 E4 EB 0E 33 C0 40 C3 8B 65 E8 E9 ?? ?? ?? ?? 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_395_26_0 {
	meta:
		name = "___BuildCatchObject"
		size = 145
		refs = "0003 __sehtable$___BuildCatchObject 0008 __SEH_prolog4 0037 ___BuildCatchObjectHelper 004e ___AdjustPointer 005a ?_CallMemberFunction2@@YGXPAX00H@Z 0074 ?_CallMemberFunction1@@YGXPAX00@Z 0080 __SEH_epilog4 008d ?terminate@@YAXXZ"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 45 10 F7 00 00 00 00 80 74 05 8B 5D 0C EB 0A 8B 48 08 8B 55 0C 8D 5C 11 0C 83 65 FC 00 8B 75 14 56 50 FF 75 0C 8B 7D 08 57 E8 ?? ?? ?? ?? 83 C4 10 48 74 1F 48 75 34 6A 01 8D 46 08 50 FF 77 18 E8 ?? ?? ?? ?? 59 59 50 FF 76 18 53 E8 ?? ?? ?? ?? EB 18 8D 46 08 50 FF 77 18 E8 ?? ?? ?? ?? 59 59 50 FF 76 18 53 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C3 33 C0 40 C3 8B 65 E8 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_395_27_0 {
	meta:
		name = "___CxxExceptionFilter"
		size = 323
		refs = "0073 __getptd 00b6 ___TypeMatch 00e9 ___BuildCatchObject"
	strings:
		$1 = { 55 8B EC 8B 45 08 83 EC 10 85 C0 75 02 C9 C3 53 8B 5D 10 56 8B 30 57 8B 7D 0C 85 FF 74 06 80 7F 08 00 75 16 8B 06 3D 4D 4F 43 E0 0F 84 C1 00 00 00 F6 C3 40 0F 84 B8 00 00 00 81 3E 63 73 6D E0 0F 85 E5 00 00 00 83 7E 10 03 0F 85 DB 00 00 00 8B 46 14 3D 20 05 93 19 74 12 3D 21 05 93 19 74 0B 3D 22 05 93 19 0F 85 BF 00 00 00 83 7E 1C 00 75 1D E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 0F 84 A7 00 00 00 E8 ?? ?? ?? ?? 8B B0 88 00 00 00 8B 46 1C 8B 40 0C 81 CB 00 00 00 80 89 7D F4 8B 38 89 5D F0 8D 58 04 EB 1D 8B 03 FF 76 1C 89 45 08 50 8D 45 F0 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 0A 4F 83 C3 04 85 FF 7F DF EB 60 E8 ?? ?? ?? ?? 05 90 00 00 00 FF 00 83 7D 14 00 74 5E FF 75 08 8D 45 F0 50 FF 75 14 56 E8 ?? ?? ?? ?? 83 C4 10 EB 49 3D 63 73 6D E0 75 36 83 7E 10 03 75 30 8B 46 14 3D 20 05 93 19 74 0E 3D 21 05 93 19 74 07 3D 22 05 93 19 75 18 83 7E 1C 00 75 12 E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 75 04 33 C0 EB 0F E8 ?? ?? ?? ?? 05 90 00 00 00 FF 00 33 C0 40 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_395_28_0 {
	meta:
		name = "?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
		size = 108
		refs = "0012 ___BuildCatchObject 0029 ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0037 ___FrameUnwindToState 0058 ?CallCatchBlock@@YAPAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PBU_s_FuncInfo@@PAXHK@Z 0066 ?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
	strings:
		$1 = { 55 8B EC 83 7D 18 00 74 10 FF 75 18 53 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 83 7D 20 00 FF 75 08 75 03 56 EB 03 FF 75 20 E8 ?? ?? ?? ?? FF 37 FF 75 14 FF 75 10 56 E8 ?? ?? ?? ?? 8B 47 04 68 00 01 00 00 FF 75 1C 40 FF 75 14 89 46 08 FF 75 0C 8B 4B 0C 56 FF 75 08 E8 ?? ?? ?? ?? 83 C4 28 85 C0 74 07 56 50 E8 ?? ?? ?? ?? 5D C3 }
	condition:
		$1
}

rule file_395_29_0 {
	meta:
		name = "?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z"
		size = 242
		refs = "0017 __getptd 0030 __encoded_null 0054 ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z 006d ?_inconsistency@@YAXXZ 0082 ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 00d5 ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z"
	strings:
		$1 = { 55 8B EC 51 51 56 8B 75 08 81 3E 03 00 00 80 0F 84 DA 00 00 00 57 E8 ?? ?? ?? ?? 83 B8 80 00 00 00 00 74 3F E8 ?? ?? ?? ?? 8D B8 80 00 00 00 E8 ?? ?? ?? ?? 39 07 74 2B 81 3E 4D 4F 43 E0 74 23 FF 75 24 FF 75 20 FF 75 18 FF 75 14 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 1C 85 C0 0F 85 8B 00 00 00 8B 7D 18 83 7F 0C 00 75 05 E8 ?? ?? ?? ?? 8B 75 1C 8D 45 F8 50 8D 45 FC 50 56 FF 75 20 57 E8 ?? ?? ?? ?? 8B F8 8B 45 FC 83 C4 14 3B 45 F8 73 5B 53 3B 37 7C 47 3B 77 04 7F 42 8B 47 0C 8B 4F 10 C1 E0 04 03 C1 8B 48 F4 85 C9 74 06 80 79 08 00 75 2A 8D 58 F0 F6 03 40 75 22 FF 75 24 8B 75 0C FF 75 20 6A 00 FF 75 18 FF 75 14 FF 75 10 FF 75 08 E8 ?? ?? ?? ?? 8B 75 1C 83 C4 1C FF 45 FC 8B 45 FC 83 C7 14 3B 45 F8 72 A7 5B 5F 5E C9 C3 }
	condition:
		$1
}

rule file_395_30_0 {
	meta:
		name = "?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
		size = 854
		refs = "0033 ?_inconsistency@@YAXXZ 007a __getptd 00ab ?_ValidateRead@@YAHPBXI@Z 0112 ?IsInExceptionSpec@@YAEPAUEHExceptionRecord@@PBU_s_ESTypeList@@@Z 0129 ??_R0?AVbad_exception@std@@@8 012e ??8type_info@@QBE_NABV0@@Z 013f ?terminate@@YAXXZ 0149 ___DestructExceptionObject 0159 ??_C@_0O@DPKOEFFH@bad?5exception?$AA@ 015e ??0exception@std@@QAE@ABQBD@Z 0163 __TI2?AVbad_exception@std@@ 016e ??_7bad_exception@std@@6B@ 0173 __CxxThrowException@8 01c7 ?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z 021b ___TypeMatch 025e ?CatchIt@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@PBU_s_HandlerType@@PBU_s_CatchableType@@PBU_s_TryBlockMapEntry@@H1E@Z 02ef ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0300 ___FrameUnwindToState 030b ?CallUnexpected@@YAXPBU_s_ESTypeList@@@Z 0337 ?FindHandlerForForeignException@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@HH1@Z"
	strings:
		$1 = { 55 8B EC 83 EC 2C 8B 4D 0C 53 8B 5D 18 8B 43 04 3D 80 00 00 00 56 57 C6 45 FF 00 7F 06 0F BE 49 08 EB 03 8B 49 08 83 F9 FF 89 4D F8 7C 04 3B C8 7C 05 E8 ?? ?? ?? ?? 8B 75 08 BF 63 73 6D E0 39 3E 0F 85 CB 02 00 00 83 7E 10 03 BB 20 05 93 19 0F 85 29 01 00 00 8B 46 14 3B C3 74 12 3D 21 05 93 19 74 0B 3D 22 05 93 19 0F 85 10 01 00 00 83 7E 1C 00 0F 85 06 01 00 00 E8 ?? ?? ?? ?? 83 B8 88 00 00 00 00 0F 84 C6 02 00 00 E8 ?? ?? ?? ?? 8B B0 88 00 00 00 89 75 08 E8 ?? ?? ?? ?? 8B 80 8C 00 00 00 6A 01 56 89 45 10 E8 ?? ?? ?? ?? 85 C0 59 59 75 05 E8 ?? ?? ?? ?? 39 3E 75 26 83 7E 10 03 75 20 8B 46 14 3B C3 74 0E 3D 21 05 93 19 74 07 3D 22 05 93 19 75 0B 83 7E 1C 00 75 05 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 0F 84 89 00 00 00 E8 ?? ?? ?? ?? 8B B8 94 00 00 00 E8 ?? ?? ?? ?? FF 75 08 33 F6 89 B0 94 00 00 00 E8 ?? ?? ?? ?? 84 C0 59 75 5C 33 DB 39 1F 7E 1D 8B 47 04 8B 4C 03 04 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 84 C0 75 0D 46 83 C3 10 3B 37 7C E3 E9 ?? ?? ?? ?? 6A 01 FF 75 08 E8 ?? ?? ?? ?? 59 59 8D 45 08 50 8D 4D D4 C7 45 08 ?? ?? ?? ?? E8 ?? ?? ?? ?? 68 ?? ?? ?? ?? 8D 45 D4 50 C7 45 D4 ?? ?? ?? ?? E8 ?? ?? ?? ?? 8B 75 08 BF 63 73 6D E0 39 3E 0F 85 88 01 00 00 83 7E 10 03 0F 85 7E 01 00 00 8B 46 14 3B C3 74 12 3D 21 05 93 19 74 0B 3D 22 05 93 19 0F 85 65 01 00 00 8B 7D 18 83 7F 0C 00 0F 86 BF 00 00 00 8D 45 E4 50 8D 45 F0 50 FF 75 F8 FF 75 20 57 E8 ?? ?? ?? ?? 83 C4 14 8B F8 8B 45 F0 3B 45 E4 0F 83 97 00 00 00 8B 45 F8 39 07 0F 8F 81 00 00 00 3B 47 04 7F 7C 8B 47 10 89 45 F4 8B 47 0C 85 C0 89 45 E8 7E 6C 8B 46 1C 8B 40 0C 8D 58 04 8B 00 85 C0 89 45 EC 7E 23 FF 76 1C 8B 03 50 FF 75 F4 89 45 E0 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 75 1A FF 4D EC 83 C3 04 39 45 EC 7F DD FF 4D E8 83 45 F4 10 83 7D E8 00 7F BE EB 28 FF 75 24 8B 5D F4 FF 75 20 C6 45 FF 01 FF 75 E0 FF 75 18 FF 75 14 FF 75 10 56 8B 75 0C E8 ?? ?? ?? ?? 8B 75 08 83 C4 1C FF 45 F0 83 C7 14 E9 5D FF FF FF 8B 7D 18 80 7D 1C 00 74 0A 6A 01 56 E8 ?? ?? ?? ?? 59 59 80 7D FF 00 0F 85 AE 00 00 00 8B 07 25 FF FF FF 1F 3D 21 05 93 19 0F 82 9C 00 00 00 8B 7F 1C 85 FF 0F 84 91 00 00 00 56 E8 ?? ?? ?? ?? 84 C0 59 0F 85 82 00 00 00 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 B0 88 00 00 00 E8 ?? ?? ?? ?? 83 7D 24 00 8B 4D 10 89 88 8C 00 00 00 56 75 05 FF 75 0C EB 03 FF 75 24 E8 ?? ?? ?? ?? 8B 75 18 6A FF 56 FF 75 14 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 FF 76 1C E8 ?? ?? ?? ?? 8B 5D 18 83 7B 0C 00 76 26 80 7D 1C 00 0F 85 1C FE FF FF FF 75 24 FF 75 20 FF 75 F8 53 FF 75 14 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 20 E8 ?? ?? ?? ?? 83 B8 94 00 00 00 00 74 05 E8 ?? ?? ?? ?? 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_395_32_0 {
	meta:
		name = "___InternalCxxFrameHandler"
		size = 228
		refs = "0007 __getptd 0069 ___FrameUnwindToState 00d5 ?FindHandler@@YAXPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAU_CONTEXT@@PAXPBU_s_FuncInfo@@EH1@Z"
	strings:
		$1 = { 55 8B EC 53 56 57 E8 ?? ?? ?? ?? 83 B8 0C 02 00 00 00 8B 45 18 8B 4D 08 BF 63 73 6D E0 BE FF FF FF 1F BB 22 05 93 19 75 20 8B 11 3B D7 74 1A 81 FA 26 00 00 80 74 12 8B 10 23 D6 3B D3 72 0A F6 40 20 01 0F 85 93 00 00 00 F6 41 04 66 74 23 83 78 04 00 0F 84 83 00 00 00 83 7D 1C 00 75 7D 6A FF 50 FF 75 14 FF 75 0C E8 ?? ?? ?? ?? 83 C4 10 EB 6A 83 78 0C 00 75 12 8B 10 23 D6 81 FA 21 05 93 19 72 58 83 78 1C 00 74 52 39 39 75 32 83 79 10 03 72 2C 39 59 14 76 27 8B 51 1C 8B 52 08 85 D2 74 1D 0F B6 75 24 56 FF 75 20 FF 75 1C 50 FF 75 14 FF 75 10 FF 75 0C 51 FF D2 83 C4 20 EB 1F FF 75 20 FF 75 1C FF 75 24 50 FF 75 14 FF 75 10 FF 75 0C 51 E8 ?? ?? ?? ?? 83 C4 20 33 C0 40 5F 5E 5B 5D C3 }
	condition:
		$1
}

rule file_396_3_0 {
	meta:
		name = "__mbstrnlen_l"
		size = 257
		refs = "0012 __errno 0022 __invalid_parameter 005e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0071 _strnlen 0084 __imp__MultiByteToWideChar@24 00c1 __isleadbyte_l"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 56 8B 75 08 33 DB 3B F3 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 CC 00 00 00 57 8B 7D 0C 81 FF FF FF FF 7F 76 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 4C FF 75 10 8D 4D EC E8 ?? ?? ?? ?? 8B 45 EC 83 B8 AC 00 00 00 01 75 0B 57 56 E8 ?? ?? ?? ?? 59 59 EB 77 53 53 57 56 6A 09 FF 70 04 FF 15 ?? ?? ?? ?? 85 C0 75 1C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 38 5D F8 74 07 8B 45 F4 83 60 70 FD 83 C8 FF EB 54 3B FB 89 5D FC 89 5D 08 76 37 8A 06 3A C3 74 2C 8D 4D EC 0F B6 C0 51 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 0D FF 45 08 39 7D 08 73 16 46 38 1E 74 0C FF 45 FC 46 FF 45 08 39 7D 08 72 CE 39 7D 08 72 04 8B C7 EB 03 8B 45 FC 38 5D F8 74 07 8B 4D F4 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_398_3_0 {
	meta:
		name = "__wcsncoll_l"
		size = 234
		refs = "001f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0029 __errno 0039 __invalid_parameter 0091 _wcsncmp 00b0 ___crtCompareStringW"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 10 33 DB 3B F3 75 07 33 C0 E9 CE 00 00 00 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 90 00 00 00 39 5D 0C 74 CD 57 BF FF FF FF 7F 3B F7 76 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 47 8B 45 F0 8B 48 10 3B CB 75 11 56 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C EB 3F FF 70 08 8D 45 F0 56 FF 75 0C 56 FF 75 08 68 00 10 00 00 51 50 E8 ?? ?? ?? ?? 83 C4 20 3B C3 75 1B E8 ?? ?? ?? ?? C7 00 16 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C7 EB 0F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_398_4_0 {
	meta:
		name = "__wcsncoll"
		size = 92
		refs = "0008 ___locale_changed 0014 __errno 0024 __invalid_parameter 0043 _wcsncmp 0052 __wcsncoll_l"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 39 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 27 39 75 0C 74 DC 81 7D 10 FF FF FF 7F 77 D3 5E 5D E9 ?? ?? ?? ?? 56 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_910_4_0 {
	meta:
		name = "__strncoll"
		size = 92
		refs = "0008 ___locale_changed 0014 __errno 0024 __invalid_parameter 0043 _strncmp 0052 __strncoll_l"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 39 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 27 39 75 0C 74 DC 81 7D 10 FF FF FF 7F 77 D3 5E 5D E9 ?? ?? ?? ?? 56 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_406_4_0 {
	meta:
		name = "__strnicmp"
		size = 92
		refs = "0008 ___locale_changed 0014 __errno 0024 __invalid_parameter 0043 ___ascii_strnicmp 0052 __strnicmp_l"
	strings:
		$1 = { 55 8B EC 56 33 F6 39 35 ?? ?? ?? ?? 75 39 39 75 08 75 1F E8 ?? ?? ?? ?? 56 56 56 56 56 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 B8 FF FF FF 7F EB 27 39 75 0C 74 DC 81 7D 10 FF FF FF 7F 77 D3 5E 5D E9 ?? ?? ?? ?? 56 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 5E 5D C3 }
	condition:
		$1
}

rule file_399_0_0 {
	meta:
		name = "__heapwalk"
		size = 346
		refs = "0003 __sehtable$__heapwalk 0008 __SEH_prolog4 0023 __errno 0033 __invalid_parameter 0058 __crtheap 005e __imp__HeapWalk@8 006c __imp__GetLastError@0 0078 ___doserrno 00a1 __imp__HeapValidate@12 0155 __SEH_epilog4"
	strings:
		$1 = { 6A 2C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A FE 5F 89 7D E0 33 C0 8B 75 08 33 DB 3B F3 0F 95 C0 3B C3 75 20 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 6A FA 58 E9 12 01 00 00 66 89 5D CE 88 5D CD 8B 06 89 45 C4 3B C3 75 3F 8D 45 C4 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 0F 85 C5 00 00 00 FF 15 ?? ?? ?? ?? 6A 78 5E 3B C6 75 16 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C7 00 28 00 00 00 6A FB EB AF 6A FD EB AB 83 7E 08 01 75 1C 50 53 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 04 6A FC EB 8F 66 C7 45 CE 04 00 89 5D FC 89 5D E4 8D 45 C4 50 FF 35 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 85 C0 75 07 C7 45 E4 01 00 00 00 89 7D FC EB 29 8B 45 EC 8B 00 8B 00 33 C9 3D 05 00 00 C0 0F 94 C1 8B C1 C3 8B 65 E8 C7 45 E4 02 00 00 00 6A FE 5F 89 7D FC 33 DB 8B 75 08 83 7D E4 01 75 1D FF 15 ?? ?? ?? ?? 3D 03 01 00 00 0F 84 70 FF FF FF 6A 78 5E 3B C6 75 89 E9 52 FF FF FF 83 7D E4 02 0F 84 7A FF FF FF F6 45 CE 03 0F 85 7A FF FF FF 8B 45 C4 89 06 8B 45 C8 89 46 04 0F B6 45 CE C1 E8 02 83 E0 01 89 46 08 8B 45 E0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_401_1_0 {
	meta:
		name = "__modf_pentium4"
		size = 264
		refs = "000a _Bns 0031 _Sign 00a9 _Mantissa 00b1 _Zero 00fc ___libm_error_support"
	strings:
		$1 = { F3 0F 7E 44 24 04 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 D8 66 0F 28 C8 66 0F 28 E0 66 0F 28 F0 66 0F 73 F0 01 66 0F 73 D0 35 66 0F 73 D3 34 66 0F 54 25 ?? ?? ?? ?? 66 0F 7E C0 66 0F FA D0 8B 4C 24 0C 66 0F D3 CA 66 0F F3 CA 66 0F 7E DA 3D FF 03 00 00 7C 1E 3D 32 04 00 00 7F 20 66 0F D6 09 F2 0F 5C F1 66 0F 56 F4 66 0F D6 74 24 04 DD 44 24 04 C3 66 0F D6 21 DD 44 24 04 C3 3D FF 07 00 00 F3 0F 7E 44 24 04 74 11 66 0F D6 01 81 FA 00 08 00 00 D9 EE 7C 02 D9 E0 C3 66 0F 28 C8 F2 0F 58 C0 66 0F D6 01 66 0F 54 05 ?? ?? ?? ?? 66 0F C2 05 ?? ?? ?? ?? 04 66 0F C5 C0 00 66 0F 54 C1 66 0F 56 C4 BA EF 03 00 00 83 F8 00 75 0B 66 0F D6 44 24 04 DD 44 24 04 C3 83 EC 1C 66 0F 13 44 24 10 89 54 24 0C 8B D4 83 C2 10 89 54 24 08 83 C2 18 89 54 24 04 83 EA 08 89 14 24 E8 ?? ?? ?? ?? DD 44 24 10 83 C4 1C C3 }
	condition:
		$1
}

rule file_402_0_0 {
	meta:
		name = "__aulldvrm"
		size = 149
	strings:
		$1 = { 56 8B 44 24 14 0B C0 75 28 8B 4C 24 10 8B 44 24 0C 33 D2 F7 F1 8B D8 8B 44 24 08 F7 F1 8B F0 8B C3 F7 64 24 10 8B C8 8B C6 F7 64 24 10 03 D1 EB 47 8B C8 8B 5C 24 10 8B 54 24 0C 8B 44 24 08 D1 E9 D1 DB D1 EA D1 D8 0B C9 75 F4 F7 F3 8B F0 F7 64 24 14 8B C8 8B 44 24 10 F7 E6 03 D1 72 0E 3B 54 24 0C 77 08 72 0F 3B 44 24 08 76 09 4E 2B 44 24 10 1B 54 24 14 33 DB 2B 44 24 08 1B 54 24 0C F7 DA F7 D8 83 DA 00 8B CA 8B D3 8B D9 8B C8 8B C6 5E C2 10 00 }
	condition:
		$1
}

rule file_403_0_0 {
	meta:
		name = "__swprintf_c"
		size = 230
		refs = "000f __errno 001f __invalid_parameter 008d __woutput_l 00af __flsbuf"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 33 DB 39 5D 10 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 B5 00 00 00 8B 45 0C 3B C3 56 8B 75 08 74 24 3B F3 75 20 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 85 00 00 00 3D FF FF FF 3F C7 45 EC 42 00 00 00 89 75 E8 89 75 E0 76 09 C7 45 E4 FF FF FF 7F EB 05 03 C0 89 45 E4 57 8D 45 14 50 53 FF 75 10 8D 45 E0 50 E8 ?? ?? ?? ?? 8B F8 83 C4 10 3B FB 7C 41 FF 4D E4 78 0A 8B 45 E0 88 18 FF 45 E0 EB 11 8D 45 E0 50 53 E8 ?? ?? ?? ?? 83 F8 FF 59 59 74 21 FF 4D E4 78 07 8B 45 E0 88 18 EB 11 8D 45 E0 50 53 E8 ?? ?? ?? ?? 83 F8 FF 59 59 74 04 8B C7 EB 06 66 89 1E 83 C8 FF 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_406_3_0 {
	meta:
		name = "__strnicmp_l"
		size = 240
		refs = "001b ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0025 __errno 0035 __invalid_parameter 009b ___ascii_strnicmp 00bc __tolower_l"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 33 DB 39 5D 10 56 57 0F 84 D5 00 00 00 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 99 00 00 00 8B 7D 0C 3B FB 74 CB BE FF FF FF 7F 39 75 10 76 28 E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD 8B C6 EB 60 8B 45 F0 39 58 14 75 1D FF 75 10 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 38 5D FC 74 44 8B 4D F8 83 61 70 FD EB 3B 8B 45 08 0F B6 00 8D 4D F0 51 50 E8 ?? ?? ?? ?? FF 45 08 8B F0 0F B6 07 8D 4D F0 51 50 E8 ?? ?? ?? ?? 83 C4 10 47 FF 4D 10 74 08 3B F3 74 04 3B F0 74 CD 2B F0 8B C6 EB B9 33 C0 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_407_0_0 {
	meta:
		name = "_wcsspn"
		size = 70
	strings:
		$1 = { 8B 44 24 04 0F B7 08 66 85 C9 53 56 57 74 2D 8B 5C 24 14 0F B7 3B 0F B7 C9 66 3B F9 8B F3 74 12 0F B7 D7 66 85 D2 74 14 46 46 0F B7 16 66 3B D1 75 F1 40 40 0F B7 08 66 85 C9 75 DD 2B 44 24 10 5F 5E D1 F8 5B C3 }
	condition:
		$1
}

rule file_408_0_0 {
	meta:
		name = "__set_exp"
		size = 42
	strings:
		$1 = { 55 8B EC 51 51 8B 45 10 DD 45 08 8B 4D 0E DD 5D F8 05 FE 03 00 00 C1 E0 04 81 E1 0F 80 FF FF 0B C1 66 89 45 FE DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_408_1_0 {
	meta:
		name = "__get_exp"
		size = 21
	strings:
		$1 = { 8B 44 24 0A C1 E8 04 25 FF 07 FF FF 2D FE 03 00 00 0F BF C0 C3 }
	condition:
		$1
}

rule file_408_2_0 {
	meta:
		name = "__add_exp"
		size = 42
		refs = "0022 __set_exp"
	strings:
		$1 = { 8B 44 24 0A DD 44 24 04 8B 4C 24 0C C1 E8 04 25 FF 07 00 00 8D 84 08 02 FC FF FF 50 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_408_3_0 {
	meta:
		name = "__set_bexp"
		size = 37
	strings:
		$1 = { 55 8B EC 51 51 8B 45 10 DD 45 08 8B 4D 0E DD 5D F8 C1 E0 04 81 E1 0F 80 FF FF 0B C1 66 89 45 FE DD 45 F8 C9 C3 }
	condition:
		$1
}

rule file_408_4_0 {
	meta:
		name = "__sptype"
		size = 91
	strings:
		$1 = { 55 8B EC 33 D2 81 7D 0C 00 00 F0 7F 75 0A 39 55 08 75 18 33 C0 40 5D C3 81 7D 0C 00 00 F0 FF 75 0A 39 55 08 75 05 6A 02 58 5D C3 8B 4D 0E B8 F8 7F 00 00 23 C8 66 3B C8 75 04 6A 03 EB EA 66 81 F9 F0 7F 75 12 F7 45 0C FF FF 07 00 75 05 39 55 08 74 04 6A 04 EB D1 33 C0 5D C3 }
	condition:
		$1
}

rule file_408_5_0 {
	meta:
		name = "__decomp"
		size = 175
		refs = "007a __set_exp"
	strings:
		$1 = { 55 8B EC D9 EE DC 55 08 DF E0 F6 C4 44 7A 07 33 D2 E9 92 00 00 00 33 C9 66 F7 45 0E F0 7F 75 63 F7 45 0C FF FF 0F 00 75 05 39 4D 08 74 55 DC 5D 08 BA 03 FC FF FF DF E0 F6 C4 41 75 05 33 C0 40 EB 18 33 C0 EB 14 D1 65 0C F7 45 08 00 00 00 80 74 04 83 4D 0C 01 D1 65 08 4A F6 45 0E 10 74 E6 66 81 65 0E EF FF 3B C1 74 06 66 81 4D 0E 00 80 DD 45 08 51 51 51 DD 1C 24 E8 ?? ?? ?? ?? 83 C4 0C EB 25 51 DD D8 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? 8B 55 0E C1 EA 04 81 E2 FF 07 00 00 83 C4 0C 81 EA FE 03 00 00 8B 45 10 89 10 5D C3 }
	condition:
		$1
}

rule file_409_0_0 {
	meta:
		name = "__tell"
		size = 17
		refs = "0009 __lseek"
	strings:
		$1 = { 6A 01 6A 00 FF 74 24 0C E8 ?? ?? ?? ?? 83 C4 0C C3 }
	condition:
		$1
}

rule file_411_0_0 {
	meta:
		name = "__wcreat"
		size = 47
		refs = "001a __wsopen_s"
	strings:
		$1 = { 55 8B EC 51 FF 75 0C 83 4D FC FF 6A 40 68 02 03 00 00 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 8B 45 FC C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_526_0_0 {
	meta:
		name = "__creat"
		size = 47
		refs = "001a __sopen_s"
	strings:
		$1 = { 55 8B EC 51 FF 75 0C 83 4D FC FF 6A 40 68 02 03 00 00 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 8B 45 FC C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_415_0_0 {
	meta:
		name = "___libm_sse2_asin"
		size = 1097
		refs = "0007 _ABSVALMASK 000f _ONEMASK 0021 _TMASK 0089 _T_table 0096 _Tbl_addr 00c2 _cv 00d6 _SIGNMASK 014b _HALFMASK2 01a2 _PI_BY_2 025d _cv2 02c4 _ONE_BY_2"
	strings:
		$1 = { 83 EC 0C 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 BE 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 C7 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E C6 66 0F 12 3D ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 54 15 ?? ?? ?? ?? F2 0F 10 D9 F2 0F 59 C9 66 0F 12 35 ?? ?? ?? ?? 83 C4 0C F2 0F 59 D9 F2 0F 59 F9 F2 0F 59 EB 66 0F 57 E2 F2 0F 59 D9 F2 0F 58 F7 F2 0F 59 F3 F2 0F 58 EC 66 0F 70 E4 EE F2 0F 58 F5 66 0F 56 E2 F2 0F 58 C6 F2 0F 58 C4 C3 2D BB 03 00 00 83 F8 43 0F 83 18 01 00 00 F2 0F 59 C9 F2 0F 5C D9 F2 0F 51 DB 8B C2 66 0F 54 05 ?? ?? ?? ?? 66 0F 54 3D ?? ?? ?? ?? F2 0F 10 C8 66 0F 12 25 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 5C CF F2 0F 59 FF F2 0F 58 C6 F2 0F 5C E7 F2 0F 59 C1 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 66 0F 28 1D ?? ?? ?? ?? F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 5C 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 25 00 00 08 00 C1 E8 04 F2 0F 59 C6 F2 0F 59 CE F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB 83 C4 0C 66 0F C4 F0 03 F2 0F 58 C5 F2 0F 10 EC 66 0F 70 DB EE F2 0F 5C E3 F2 0F 58 DC F2 0F 5C EB F2 0F 5C C5 F2 0F 5C C4 66 0F 56 C6 C3 05 BB 3B 00 00 3D 00 38 00 00 73 5D 66 0F 14 FF 66 0F 28 0D ?? ?? ?? ?? 66 0F 28 F7 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 83 C4 0C 66 0F 59 FF 66 0F 59 F7 66 0F 59 CF 66 0F 59 FF F2 0F 10 DE F2 0F 59 F6 66 0F 58 CA 66 0F 59 E7 F2 0F 59 F3 66 0F 58 CC 66 0F 59 CE 66 0F 70 D1 EE F2 0F 58 CA F2 0F 58 C1 C3 2D FE 3B 00 00 83 F8 02 0F 83 BB 00 00 00 66 0F 12 25 ?? ?? ?? ?? 66 0F 73 F1 01 66 0F 73 D1 01 F2 0F 5C D9 F2 0F 59 E3 66 0F 28 0D ?? ?? ?? ?? 66 0F 70 FC 44 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 1D ?? ?? ?? ?? F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 59 DF 66 0F 28 35 ?? ?? ?? ?? F2 0F 59 FD 66 0F 58 D3 F2 0F 59 D7 66 0F 59 D5 F2 0F 58 E4 66 0F 70 EE EE 66 0F 70 DC 44 F2 0F 5C E5 F2 0F 58 EC F2 0F 5C EB 66 0F 59 D3 F2 0F 58 EE 66 0F 57 F6 66 0F 70 C2 EE F2 0F 5C D5 83 C4 0C F2 0F 58 C2 25 00 80 00 00 35 00 80 00 00 66 0F C4 F0 03 F2 0F 58 C4 66 0F 57 C6 C3 05 FE FE 03 00 3D 00 FF 03 00 0F 82 8A 00 00 00 66 0F 7E C1 66 0F 73 D0 20 66 0F 7E C2 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 74 41 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 7D 42 83 C4 0C 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 F2 0F 59 C1 C3 66 0F 12 0D ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 58 C2 66 0F 55 CF 66 0F 56 C1 C3 66 0F 12 44 24 04 66 0F 57 F6 F2 0F 10 F8 83 C4 0C 66 0F C5 D0 03 81 E2 F0 7F 00 00 83 EA 10 81 FA E0 7F 00 00 72 0C F2 0F 58 F0 66 0F 56 C6 F2 0F 59 F8 C3 }
	condition:
		$1
}

rule file_416_3_0 {
	meta:
		name = "__ismbcprint_l"
		size = 179
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0068 ___crtGetStringTypeA"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 FF 75 0C 8D 4D EC E8 ?? ?? ?? ?? 8B 4D 08 33 DB 81 F9 FF 00 00 00 76 72 33 C0 57 66 89 5D FC 8D 7D FE 66 AB 8B C1 C1 E8 08 88 45 08 8B 45 F0 88 4D 09 39 58 08 5F 75 10 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 EB 3F 6A 01 FF 70 0C FF 70 04 8D 45 FC 50 6A 02 8D 45 08 50 8D 45 EC 6A 01 50 E8 ?? ?? ?? ?? 83 C4 20 85 C0 74 CC 66 39 5D FE 75 36 F6 45 FC 20 75 30 33 C0 40 38 5D F8 74 07 8B 4D F4 83 61 70 FD 5B C9 C3 0F B6 C1 8B 4D EC 8B 89 C8 00 00 00 66 F7 04 41 57 01 75 DA 8B 4D F0 F6 44 08 1D 03 75 D0 33 C0 EB CF }
	condition:
		$1
}

rule file_417_0_0 {
	meta:
		name = "__RTC_InitBase"
		size = 38
		refs = "0004 ?init@?1??_RTC_InitBase@@9@4_NA 0018 __CRT_RTC_INITW 001e __RTC_SetErrorFuncW"
	strings:
		$1 = { 33 C0 38 05 ?? ?? ?? ?? 75 1B 50 6A 01 50 50 50 C6 05 ?? ?? ?? ?? 01 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 83 C4 18 C3 }
	condition:
		$1
}

rule file_417_1_0 {
	meta:
		name = "__RTC_Shutdown"
		size = 18
		refs = "000a __CRT_RTC_INITW"
	strings:
		$1 = { 6A 01 33 C0 6A 01 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 C3 }
	condition:
		$1
}

rule file_418_0_0 {
	meta:
		name = "_wcstok"
		size = 167
		refs = "0008 __getptd"
	strings:
		$1 = { 55 8B EC 51 53 56 57 E8 ?? ?? ?? ?? 8B 4D 08 33 DB 3B CB 89 45 FC 75 03 8B 48 1C 0F B7 11 66 3B D3 74 2F 8B 45 0C 0F B7 00 66 3B C3 8B 7D 0C 74 12 0F B7 F0 66 3B F2 74 0A 47 47 0F B7 37 66 3B F3 75 F1 66 39 1F 74 0A 41 41 0F B7 11 66 3B D3 75 D7 66 39 19 89 4D 08 74 36 8B 45 0C 0F B7 00 66 3B C3 8B 75 0C 74 15 0F B7 39 0F B7 D0 66 3B D7 74 0A 46 46 0F B7 16 66 3B D3 75 F1 66 39 1E 75 09 41 41 66 39 19 75 D7 EB 05 66 89 19 41 41 8B 45 FC 89 48 1C 8B 45 08 2B C1 F7 D8 5F 1B C0 23 45 08 5E 5B C9 C3 }
	condition:
		$1
}

rule file_421_0_0 {
	meta:
		name = "?_JumpToContinuation@@YGXPAXPAUEHRegistrationNode@@@Z"
		size = 48
	strings:
		$1 = { 55 8B EC 51 53 8B 45 0C 83 C0 0C 89 45 FC 64 8B 1D 00 00 00 00 8B 03 64 A3 00 00 00 00 8B 45 08 8B 5D 0C 8B 6D FC 8B 63 FC FF E0 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_421_4_0 {
	meta:
		name = "?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z"
		size = 82
		refs = "0015 $ReturnPoint$23329 0025 _RtlUnwind@16"
	strings:
		$1 = { 55 8B EC 51 51 53 56 57 64 8B 35 00 00 00 00 89 75 FC C7 45 F8 ?? ?? ?? ?? 6A 00 FF 75 0C FF 75 F8 FF 75 08 E8 ?? ?? ?? ?? 8B 45 0C 8B 40 04 83 E0 FD 8B 4D 0C 89 41 04 64 8B 3D 00 00 00 00 8B 5D FC 89 3B 64 89 1D 00 00 00 00 5F 5E 5B C9 C2 08 00 }
	condition:
		$1
}

rule file_421_5_0 {
	meta:
		name = "___CxxFrameHandler"
		size = 54
		refs = "0022 ___InternalCxxFrameHandler"
		altNames = "___CxxFrameHandler2 ___CxxFrameHandler3"
	strings:
		$1 = { 55 8B EC 83 EC 08 53 56 57 FC 89 45 FC 33 C0 50 50 50 FF 75 FC FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 89 45 F8 5F 5E 5B 8B 45 F8 8B E5 5D C3 }
	condition:
		$1
}

rule file_421_8_0 {
	meta:
		name = "___CxxLongjmpUnwind@4"
		size = 26
		refs = "0010 ___FrameUnwindToState"
	strings:
		$1 = { 8B 44 24 04 FF 70 1C FF 70 28 6A 00 FF 70 18 E8 ?? ?? ?? ?? 83 C4 10 C2 04 00 }
	condition:
		$1
}

rule file_421_9_0 {
	meta:
		name = "?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z"
		size = 48
		refs = "000c @__security_check_cookie@4 0027 ___InternalCxxFrameHandler"
	strings:
		$1 = { 56 FC 8B 74 24 0C 8B 4E 08 33 CE E8 ?? ?? ?? ?? 6A 00 56 FF 76 14 FF 76 0C 6A 00 FF 74 24 24 FF 76 10 FF 74 24 24 E8 ?? ?? ?? ?? 83 C4 20 5E C3 }
	condition:
		$1
}

rule file_421_10_0 {
	meta:
		name = "?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
		size = 213
		refs = "0011 $ExceptionContinuation$23447 0029 ?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z 002e ___security_cookie 008a __getptd"
	strings:
		$1 = { 55 8B EC 83 EC 38 53 81 7D 08 23 01 00 00 75 12 B8 ?? ?? ?? ?? 8B 4D 0C 89 01 33 C0 40 E9 B0 00 00 00 83 65 D8 00 C7 45 DC ?? ?? ?? ?? A1 ?? ?? ?? ?? 8D 4D D8 33 C1 89 45 E0 8B 45 18 89 45 E4 8B 45 0C 89 45 E8 8B 45 1C 89 45 EC 8B 45 20 89 45 F0 83 65 F4 00 83 65 F8 00 83 65 FC 00 89 65 F4 89 6D F8 64 A1 00 00 00 00 89 45 D8 8D 45 D8 64 A3 00 00 00 00 C7 45 C8 01 00 00 00 8B 45 08 89 45 CC 8B 45 10 89 45 D0 E8 ?? ?? ?? ?? 8B 80 80 00 00 00 89 45 D4 8D 45 CC 50 8B 45 08 FF 30 FF 55 D4 59 59 83 65 C8 00 83 7D FC 00 74 17 64 8B 1D 00 00 00 00 8B 03 8B 5D D8 89 03 64 89 1D 00 00 00 00 EB 09 8B 45 D8 64 A3 00 00 00 00 8B 45 C8 5B C9 C3 }
	condition:
		$1
}

rule file_421_11_0 {
	meta:
		name = "?TranslatorGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUTranslatorGuardRN@@PAX2@Z"
		size = 157
		refs = "0010 @__security_check_cookie@4 0053 ___InternalCxxFrameHandler 006a ?_UnwindNestedFrames@@YGXPAUEHRegistrationNode@@PAUEHExceptionRecord@@@Z 0082 ?_CallSETranslator@@YAHPAUEHExceptionRecord@@PAUEHRegistrationNode@@PAX2PBU_s_FuncInfo@@H1@Z"
	strings:
		$1 = { 55 8B EC 51 53 FC 8B 45 0C 8B 48 08 33 4D 0C E8 ?? ?? ?? ?? 8B 45 08 8B 40 04 83 E0 66 74 11 8B 45 0C C7 40 24 01 00 00 00 33 C0 40 EB 6C EB 6A 6A 01 8B 45 0C FF 70 18 8B 45 0C FF 70 14 8B 45 0C FF 70 0C 6A 00 FF 75 10 8B 45 0C FF 70 10 FF 75 08 E8 ?? ?? ?? ?? 83 C4 20 8B 45 0C 83 78 24 00 75 0B FF 75 08 FF 75 0C E8 ?? ?? ?? ?? 6A 00 6A 00 6A 00 6A 00 6A 00 8D 45 FC 50 68 23 01 00 00 E8 ?? ?? ?? ?? 83 C4 1C 8B 45 FC 8B 5D 0C 8B 63 1C 8B 6B 20 FF E0 33 C0 40 5B C9 C3 }
	condition:
		$1
}

rule file_421_12_0 {
	meta:
		name = "?_GetRangeOfTrysToCheck@@YAPBU_s_TryBlockMapEntry@@PBU_s_FuncInfo@@HHPAI1@Z"
		size = 115
		refs = "001d ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 55 8B EC 51 53 56 57 8B 7D 08 8B 47 10 8B 77 0C 89 45 FC 8B DE EB 2D 83 FE FF 75 05 E8 ?? ?? ?? ?? 8B 4D FC 4E 8B C6 6B C0 14 03 C1 8B 4D 10 39 48 04 7D 05 3B 48 08 7E 05 83 FE FF 75 09 FF 4D 0C 8B 5D 08 89 75 08 83 7D 0C 00 7D CA 8B 45 14 46 89 30 8B 45 18 89 18 3B 5F 0C 77 04 3B F3 76 05 E8 ?? ?? ?? ?? 8B C6 6B C0 14 03 45 FC 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_421_13_0 {
	meta:
		name = "__CreateFrameInfo"
		size = 40
		refs = "000c __getptd"
	strings:
		$1 = { 8B 44 24 08 56 8B 74 24 08 89 06 E8 ?? ?? ?? ?? 8B 80 98 00 00 00 89 46 04 E8 ?? ?? ?? ?? 89 B0 98 00 00 00 8B C6 5E C3 }
	condition:
		$1
}

rule file_421_14_0 {
	meta:
		name = "__IsExceptionObjectToBeDestroyed"
		size = 33
		refs = "0001 __getptd"
	strings:
		$1 = { E8 ?? ?? ?? ?? 8B 80 98 00 00 00 EB 0B 8B 08 3B 4C 24 04 74 09 8B 40 04 85 C0 75 F1 40 C3 33 C0 C3 }
	condition:
		$1
}

rule file_421_15_0 {
	meta:
		name = "__FindAndUnlinkFrame"
		size = 76
		refs = "0002 __getptd 0040 ?_inconsistency@@YAXXZ"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? 8B 74 24 08 3B B0 98 00 00 00 75 10 E8 ?? ?? ?? ?? 8B 4E 04 89 88 98 00 00 00 5E C3 E8 ?? ?? ?? ?? 8B 80 98 00 00 00 EB 09 8B 48 04 3B F1 74 0E 8B C1 83 78 04 00 75 F1 5E E9 ?? ?? ?? ?? 8B 4E 04 89 48 04 5E C3 }
	condition:
		$1
}

rule file_421_16_0 {
	meta:
		name = "?_CallCatchBlock2@@YAPAXPAUEHRegistrationNode@@PBU_s_FuncInfo@@PAXHK@Z"
		size = 94
		refs = "0007 ___security_cookie 0027 ?CatchGuardHandler@@YA?AW4_EXCEPTION_DISPOSITION@@PAUEHExceptionRecord@@PAUCatchGuardRN@@PAX2@Z 004b __CallSettingFrame@12"
	strings:
		$1 = { 55 8B EC 83 EC 18 A1 ?? ?? ?? ?? 83 65 E8 00 8D 4D E8 33 C1 8B 4D 08 89 45 F0 8B 45 0C 89 45 F4 8B 45 14 40 C7 45 EC ?? ?? ?? ?? 89 4D F8 89 45 FC 64 A1 00 00 00 00 89 45 E8 8D 45 E8 64 A3 00 00 00 00 FF 75 18 51 FF 75 10 E8 ?? ?? ?? ?? 8B C8 8B 45 E8 64 A3 00 00 00 00 8B C1 C9 C3 }
	condition:
		$1
}

rule file_422_0_0 {
	meta:
		name = "___libm_sse2_acos"
		size = 1187
		refs = "0007 _ABSVALMASK 000f _ONEMASK 0021 _TMASK 007f _T_table 008c _Tbl_addr 00b8 _cv 00fb _PI_BY_2 01ba _NEG_PI 026a _cv2 0303 _ONE_BY_2 034a _HALFMASK 0463 _PI"
	strings:
		$1 = { 83 EC 0C 66 0F 12 25 ?? ?? ?? ?? 66 0F 12 1D ?? ?? ?? ?? 66 0F 13 44 24 04 66 0F 57 ED 66 0F 12 15 ?? ?? ?? ?? F2 0F 10 C8 66 0F 73 D0 2C 66 0F 7E C2 F2 0F 10 F9 B9 00 20 00 00 66 0F C4 E9 02 F2 0F 10 C1 B8 FF FF 07 00 23 C2 2D 00 FB 03 00 3D BB 03 00 00 0F 83 C9 00 00 00 F2 0F 59 C9 81 E2 FF FF 00 00 F2 0F 5C D9 F2 0F 51 DB 66 0F 54 D7 83 E2 FC 81 EA 00 FB 00 00 66 0F 12 0C 55 ?? ?? ?? ?? 66 0F 56 D5 66 0F 28 24 95 ?? ?? ?? ?? F2 0F 10 F7 F2 0F 58 FA F2 0F 5C C2 F2 0F 59 F8 F2 0F 59 F1 F2 0F 59 DA F2 0F 10 CE F2 0F 58 F3 F2 0F 5E FE 66 0F 12 05 ?? ?? ?? ?? 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C CB 66 0F 73 D2 3F F2 0F 10 D9 66 0F 73 F2 3F F2 0F 59 C9 66 0F 70 D2 44 66 0F 12 35 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 59 C1 66 0F 57 E2 F2 0F 59 EB 66 0F 5C 25 ?? ?? ?? ?? F2 0F 59 D9 F2 0F 58 C6 F2 0F 59 C3 F2 0F 5C EC 66 0F 70 E4 EE F2 0F 58 C5 F2 0F 5C C7 83 C4 0C F2 0F 5C C4 C3 2D BB 03 00 00 83 F8 41 0F 83 20 01 00 00 66 0F 73 D7 26 66 0F 73 F7 26 66 0F D7 C0 66 0F 55 E0 F2 0F 5C CF F2 0F 10 F7 F2 0F 59 FF F2 0F 58 C6 66 0F 56 EC F2 0F 5C DF F2 0F 59 C1 F2 0F 10 E3 F2 0F 5C D8 F2 0F 51 DB 25 80 00 00 00 C1 E8 07 F7 D8 F2 0F 10 FB 66 0F 54 D3 66 0F 73 F3 02 66 0F C5 D3 03 66 0F 56 D5 66 0F 6E D8 66 0F 70 DB 00 81 EA C0 FE 00 00 03 D2 F2 0F 59 3C 95 ?? ?? ?? ?? F2 0F 59 F2 F2 0F 59 CA F2 0F 59 D2 F2 0F 5C F7 66 0F 54 1D ?? ?? ?? ?? F2 0F 58 F1 F2 0F 5C E2 F2 0F 58 FF 66 0F 12 2D ?? ?? ?? ?? F2 0F 5C E0 F2 0F 58 FE 66 0F 12 05 ?? ?? ?? ?? F2 0F 5E E7 66 0F 12 15 ?? ?? ?? ?? 66 0F 58 1C D5 ?? ?? ?? ?? F2 0F 10 CE F2 0F 59 F6 F2 0F 59 C6 F2 0F 59 CE F2 0F 59 E9 F2 0F 59 CE F2 0F 58 C2 66 0F EF F6 F2 0F 59 C1 F2 0F 58 EB F2 0F 58 C5 25 00 80 00 00 66 0F C4 F0 03 F2 0F 10 EC 66 0F 70 DB EE F2 0F 58 E3 F2 0F 5C DC F2 0F 58 EB F2 0F 58 C5 F2 0F 58 C4 83 C4 0C 66 0F 57 C6 C3 05 BB 3B 00 00 3D 00 38 00 00 0F 83 83 00 00 00 66 0F 14 C0 66 0F 28 35 ?? ?? ?? ?? 66 0F 14 C8 66 0F 28 15 ?? ?? ?? ?? 66 0F 28 25 ?? ?? ?? ?? 66 0F 59 C0 66 0F 28 2D ?? ?? ?? ?? 66 0F 59 C8 66 0F 59 F0 66 0F 59 C0 F2 0F 10 D9 F2 0F 59 C9 66 0F 58 F2 66 0F 59 E0 F2 0F 59 CB 66 0F 58 F4 66 0F 70 C5 EE 66 0F 59 CE 66 0F 70 F5 EE F2 0F 5C C7 66 0F 70 D1 EE F2 0F 5C E9 F2 0F 5C F0 F2 0F 5C EA F2 0F 5C FE 83 C4 0C F2 0F 5C EF F2 0F 58 C5 C3 2D FC 3B 00 00 83 F8 04 0F 83 E7 00 00 00 66 0F 57 F6 66 0F 54 3D ?? ?? ?? ?? 66 0F 12 25 ?? ?? ?? ?? 66 0F 28 0D ?? ?? ?? ?? F2 0F 59 FC 66 0F 28 15 ?? ?? ?? ?? F2 0F 5C E7 66 0F 28 1D ?? ?? ?? ?? 66 0F 70 FC 44 F2 0F 51 E4 66 0F 59 CF 66 0F 70 EF 44 66 0F C5 C0 03 66 0F 59 FF 66 0F 58 D1 66 0F 12 0D ?? ?? ?? ?? 66 0F 59 DF F2 0F C2 C6 01 F2 0F 59 FD 66 0F 58 D3 66 0F 70 C0 44 F2 0F 59 D7 66 0F 54 05 ?? ?? ?? ?? 66 0F 59 D5 66 0F 54 CC 66 0F 70 DC 44 F2 0F 5C E1 F2 0F 58 DB F2 0F 59 C9 F2 0F 5C DC F2 0F 5C E9 F2 0F 59 E3 66 0F 70 DB EE F2 0F 5C EC F2 0F 5E EB 66 0F 58 DB 66 0F 59 D3 66 0F 70 E2 EE F2 0F 58 D0 25 00 80 00 00 66 0F C4 F0 03 66 0F 70 C0 EE F2 0F 58 D4 F2 0F 58 D5 F2 0F 58 D3 F2 0F 58 C2 83 C4 0C 66 0F 57 C6 C3 05 FC FE 03 00 3D 00 FF 03 00 0F 82 95 00 00 00 66 0F 7E F9 66 0F 73 D7 20 66 0F 7E FA 81 E2 FF FF FF 7F B8 00 00 F0 3F 2B C2 0B C1 83 F8 00 74 41 66 0F 12 54 24 04 66 0F 7E D2 66 0F 73 D2 20 66 0F 7E D1 81 E1 FF FF FF 7F 83 EA 01 81 D9 00 00 F0 7F 83 F9 00 7D 65 66 0F 57 C9 66 0F 57 C0 BA F0 7F 00 00 66 0F C4 CA 03 83 C4 0C F2 0F 59 C1 C3 66 0F C5 D7 01 C1 EA 0F F7 DA 66 0F 6E FA 66 0F 70 FF 00 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 66 0F 54 D7 66 0F 54 C7 83 C4 0C F2 0F 58 C2 C3 66 0F 12 15 ?? ?? ?? ?? 66 0F 12 05 ?? ?? ?? ?? 83 C4 0C F2 0F 58 C2 C3 66 0F 57 F6 83 C4 0C F2 0F 58 C6 C3 }
	condition:
		$1
}

rule file_424_0_0 {
	meta:
		name = "?ArrayUnwindFilter@@YAHPAU_EXCEPTION_POINTERS@@@Z"
		size = 18
		refs = "000e ?terminate@@YAXXZ"
	strings:
		$1 = { 8B 00 81 38 63 73 6D E0 74 03 33 C0 C3 E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_424_1_0 {
	meta:
		name = "?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
		size = 94
		refs = "0003 __sehtable$?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z 0008 __SEH_prolog4 0048 ?terminate@@YAXXZ 0057 __SEH_epilog4"
	strings:
		$1 = { 6A 14 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 4D 10 78 3A 8B 4D 08 2B 4D 0C 89 4D 08 FF 55 14 EB ED 8B 45 EC 89 45 E4 8B 45 E4 8B 00 89 45 E0 8B 45 E0 81 38 63 73 6D E0 74 0B C7 45 DC 00 00 00 00 8B 45 DC C3 E8 ?? ?? ?? ?? 8B 65 E8 C7 45 FC FE FF FF FF E8 ?? ?? ?? ?? C2 10 00 }
	condition:
		$1
}

rule file_424_2_0 {
	meta:
		name = "??_M@YGXPAXIHP6EX0@Z@Z"
		size = 99
		refs = "0003 __sehtable$??_M@YGXPAXIHP6EX0@Z@Z 0008 __SEH_prolog4 0044 __SEH_epilog4 005e ?__ArrayUnwind@@YGXPAXIHP6EX0@Z@Z"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 E4 00 8B 75 0C 8B C6 0F AF 45 10 01 45 08 83 65 FC 00 FF 4D 10 78 0B 29 75 08 8B 4D 08 FF 55 14 EB F0 C7 45 E4 01 00 00 00 C7 45 FC FE FF FF FF E8 08 00 00 00 E8 ?? ?? ?? ?? C2 10 00 83 7D E4 00 75 11 FF 75 14 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_425_1_0 {
	meta:
		name = "__wsetenvp"
		size = 218
		refs = "0004 __wenvptr 0022 _wcslen 0039 __calloc_crt 0045 __wenviron 007c _wcscpy_s 008d __invoke_watson 00a6 _free 00b4 ___env_initialized"
	strings:
		$1 = { 55 56 8B 35 ?? ?? ?? ?? 57 33 ED 33 FF 3B F5 75 1A 83 C8 FF E9 A7 00 00 00 66 3D 3D 00 74 01 47 56 E8 ?? ?? ?? ?? 59 8D 74 46 02 0F B7 06 66 3B C5 75 E6 53 6A 04 47 57 E8 ?? ?? ?? ?? 8B D8 3B DD 59 59 89 1D ?? ?? ?? ?? 75 05 83 C8 FF EB 6F 8B 35 ?? ?? ?? ?? EB 42 56 E8 ?? ?? ?? ?? 8B F8 47 66 83 3E 3D 59 74 2F 6A 02 57 E8 ?? ?? ?? ?? 3B C5 59 59 89 03 74 4C 56 57 50 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 55 55 55 55 55 E8 ?? ?? ?? ?? 83 C4 14 83 C3 04 8D 34 7E 66 39 2E 75 B9 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 89 2B C7 05 ?? ?? ?? ?? 01 00 00 00 33 C0 59 5B 5F 5E 5D C3 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 89 2D ?? ?? ?? ?? 83 C8 FF EB E4 }
	condition:
		$1
}

rule file_427_1_0 {
	meta:
		name = "__pipe"
		size = 694
		refs = "0003 __sehtable$__pipe 0008 __SEH_prolog4 0020 ___doserrno 0027 __errno 0037 __invalid_parameter 00c2 __imp__CreatePipe@16 00cc __imp__GetLastError@0 00d2 __dosmaperr 00da __alloc_osfhnd 00f4 ___pioinfo 017e __get_fmode 018d __invoke_watson 0222 __set_osfhnd 023b __unlock_fhandle 028f __imp__CloseHandle@4 02b1 __SEH_epilog4"
	strings:
		$1 = { 6A 2C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D E4 33 C9 8B 45 08 3B C3 0F 95 C1 3B CB 75 27 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 6A 02 00 00 83 CE FF 89 70 04 89 30 8B 45 10 25 7F 3F FF FF F7 D8 1B C0 40 75 26 E8 ?? ?? ?? ?? 89 18 E8 ?? ?? ?? ?? C7 00 16 00 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 2D 02 00 00 8B 4D 10 B8 00 C0 00 00 23 C8 33 D2 3B C8 0F 95 C2 8B C2 3B C3 74 C3 C7 45 C4 0C 00 00 00 89 5D C8 8A 45 10 24 80 F6 D8 1B C0 40 89 45 CC FF 75 0C 8D 45 C4 50 8D 45 D0 50 8D 45 D4 50 FF 15 ?? ?? ?? ?? 85 C0 75 0F FF 15 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 59 EB A3 E8 ?? ?? ?? ?? 8B F8 89 7D E0 3B FE 0F 84 85 01 00 00 89 5D FC C1 F8 05 8D 0C 85 ?? ?? ?? ?? 8B C7 83 E0 1F 6B C0 28 8B 11 C6 44 02 04 89 8B 11 8D 54 02 24 80 22 80 8B 09 8D 44 01 24 80 20 7F C7 45 FC FE FF FF FF E8 14 01 00 00 E8 ?? ?? ?? ?? 8B F0 89 75 D8 83 FE FF 0F 84 1E 01 00 00 89 5D DC C7 45 FC 01 00 00 00 C1 F8 05 8D 0C 85 ?? ?? ?? ?? 8B C6 83 E0 1F 6B C0 28 8B 11 C6 44 10 04 89 8B 11 8D 54 10 24 80 22 80 8B 09 8D 44 08 24 80 20 7F C7 45 FC FE FF FF FF E8 D0 00 00 00 8D 45 DC 50 E8 ?? ?? ?? ?? 59 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 B8 00 80 00 00 85 45 10 75 0D 66 F7 45 10 00 40 75 3B 39 45 DC 75 36 8B C7 C1 F8 05 8B CF 83 E1 1F 6B C9 28 8B 04 85 ?? ?? ?? ?? 8D 44 08 04 80 20 7F 8B C6 C1 F8 05 8B CE 83 E1 1F 6B C9 28 8B 04 85 ?? ?? ?? ?? 8D 44 08 04 80 20 7F F6 45 10 80 74 36 8B C7 C1 F8 05 8B CF 83 E1 1F 6B C9 28 8B 04 85 ?? ?? ?? ?? 8D 44 08 04 80 08 10 8B C6 C1 F8 05 8B CE 83 E1 1F 6B C9 28 8B 04 85 ?? ?? ?? ?? 8D 44 08 04 80 08 10 FF 75 D4 57 E8 ?? ?? ?? ?? FF 75 D0 56 E8 ?? ?? ?? ?? 83 C4 10 EB 46 33 DB 8B 7D E0 57 E8 ?? ?? ?? ?? 59 C3 33 DB 8B 7D E0 8B 75 D8 83 FE FF 74 07 56 E8 ?? ?? ?? ?? 59 C3 8B C7 C1 F8 05 8B CF 83 E1 1F 6B C9 28 8B 04 85 ?? ?? ?? ?? 88 5C 08 04 EB 03 8B 75 D8 C7 45 E4 01 00 00 00 39 5D E4 74 27 E8 ?? ?? ?? ?? C7 00 18 00 00 00 FF 75 D4 8B 35 ?? ?? ?? ?? FF D6 FF 75 D0 FF D6 E8 ?? ?? ?? ?? 89 18 E9 98 FD FF FF 8B 45 08 89 38 89 70 04 33 C0 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_428_0_0 {
	meta:
		name = "_exp"
		size = 60
		refs = "0002 ___use_sse2_mathfcns 0037 __exp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 6E 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 41 E9 ?? ?? ?? ?? 90 }
	condition:
		$1
}

rule file_428_1_0 {
	meta:
		name = "__CIexp"
		size = 59
		refs = "0002 ___use_sse2_mathfcns 0037 __CIexp_pentium4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 3C 83 EC 08 0F AE 5C 24 04 8B 44 24 04 25 80 1F 00 00 3D 80 1F 00 00 75 0F D9 3C 24 66 8B 04 24 66 83 E0 7F 66 83 F8 7F 8D 64 24 08 75 0F E9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_429_4_0 {
	meta:
		name = "__tzset_nolock"
		size = 831
		refs = "0003 __sehtable$__tzset_nolock 0008 __SEH_prolog4 0023 __lock 002c ___tzname 0038 __get_timezone 0047 __invoke_watson 0053 __get_daylight 006e __get_dstbias 0085 ____lc_codepage_func 008e _tzapiused 0097 _dstend 009d _dststart 00a2 ??_C@_02CLFPBFFP@TZ?$AA@ 00a7 __getenv_helper_nolock 00ba _lastTZ 00c5 _strcmp 00de _free 00e5 _strlen 00ec __malloc_crt 0110 _strcpy_s 0148 _tzinfo 014e __imp__GetTimeZoneInformation@4 01c6 __imp__WideCharToMultiByte@32 0227 ___timezone 0231 ___daylight 023b ___dstbias 0261 _strncpy_s 028b _atol 02b2 __unlock 033a __SEH_epilog4"
	strings:
		$1 = { 6A 2C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 DB 89 5D C8 89 5D D4 89 5D E4 89 5D DC 89 5D D8 89 5D E0 6A 07 E8 ?? ?? ?? ?? 59 89 5D FC E8 ?? ?? ?? ?? 89 45 E0 8D 45 E4 50 E8 ?? ?? ?? ?? 59 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 45 DC 50 E8 ?? ?? ?? ?? 59 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 8D 45 D8 50 E8 ?? ?? ?? ?? 59 3B C3 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E8 ?? ?? ?? ?? 89 45 CC 89 1D ?? ?? ?? ?? 83 CF FF 89 3D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 8B F0 89 75 C4 3B F3 74 7C 38 1E 74 78 A1 ?? ?? ?? ?? 3B C3 74 21 50 56 E8 ?? ?? ?? ?? 59 59 85 C0 0F 84 49 01 00 00 A1 ?? ?? ?? ?? 3B C3 74 07 50 E8 ?? ?? ?? ?? 59 56 E8 ?? ?? ?? ?? 40 50 E8 ?? ?? ?? ?? 59 59 A3 ?? ?? ?? ?? 3B C3 0F 84 1D 01 00 00 56 56 E8 ?? ?? ?? ?? 59 40 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 3B C3 0F 84 04 01 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E9 F2 00 00 00 A1 ?? ?? ?? ?? 3B C3 74 0D 50 E8 ?? ?? ?? ?? 59 89 1D ?? ?? ?? ?? 68 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 3B C7 0F 84 C2 00 00 00 33 C9 41 89 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 6B C0 3C 89 45 E4 66 39 1D ?? ?? ?? ?? 74 0E 8B 15 ?? ?? ?? ?? 6B D2 3C 03 C2 89 45 E4 66 39 1D ?? ?? ?? ?? 74 1A A1 ?? ?? ?? ?? 3B C3 74 11 89 4D DC 2B 05 ?? ?? ?? ?? 6B C0 3C 89 45 D8 EB 06 89 5D DC 89 5D D8 8D 45 D0 50 53 6A 3F 8B 45 E0 FF 30 57 68 ?? ?? ?? ?? 53 FF 75 CC 8B 3D ?? ?? ?? ?? FF D7 85 C0 74 0F 39 5D D0 75 0A 8B 45 E0 8B 00 88 58 3F EB 07 8B 45 E0 8B 00 88 18 8D 45 D0 50 53 6A 3F 8B 45 E0 FF 70 04 6A FF 68 ?? ?? ?? ?? 53 FF 75 CC FF D7 85 C0 74 10 39 5D D0 75 0B 8B 45 E0 8B 40 04 88 58 3F EB 08 8B 45 E0 8B 40 04 88 18 C7 45 D4 01 00 00 00 8B 7D E4 E8 ?? ?? ?? ?? 89 38 8B 7D DC E8 ?? ?? ?? ?? 89 38 8B 7D D8 E8 ?? ?? ?? ?? 89 38 C7 45 FC FE FF FF FF E8 62 00 00 00 39 5D D4 0F 85 E3 00 00 00 6A 03 56 6A 40 8B 7D E0 FF 37 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 83 C6 03 80 3E 2D 75 08 C7 45 C8 01 00 00 00 46 56 E8 ?? ?? ?? ?? 59 69 C0 10 0E 00 00 89 45 E4 8A 06 3C 2B 74 08 3C 30 7C 15 3C 39 7F 11 46 EB EF 33 DB 8B 75 C4 6A 07 E8 ?? ?? ?? ?? 59 C3 80 3E 3A 75 38 46 56 E8 ?? ?? ?? ?? 59 6B C0 3C 01 45 E4 EB 05 3C 39 7F 07 46 8A 06 3C 30 7D F5 80 3E 3A 75 18 46 56 E8 ?? ?? ?? ?? 59 01 45 E4 EB 05 3C 39 7F 07 46 8A 06 3C 30 7D F5 39 5D C8 74 03 F7 5D E4 0F BE 06 89 45 DC 3B C3 74 23 6A 03 56 6A 40 FF 77 04 E8 ?? ?? ?? ?? 83 C4 10 85 C0 74 14 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 EB 05 8B 47 04 88 18 8B 75 E4 E8 ?? ?? ?? ?? 89 30 E8 ?? ?? ?? ?? C3 }
	condition:
		$1
}

rule file_429_5_0 {
	meta:
		name = "_cvtdate"
		size = 501
		refs = "0054 __days 0061 __lpdays 0173 _dststart 018b _dstend 0196 __get_dstbias 01a7 __invoke_watson"
	strings:
		$1 = { 55 8B EC 83 EC 0C 83 65 FC 00 83 7D 0C 01 53 56 57 8B 7D 10 8B F0 8B C7 0F 85 F9 00 00 00 25 03 00 00 80 79 05 48 83 C8 FC 40 89 45 F4 75 0C 8B C7 6A 64 99 5B F7 FB 85 D2 75 1F 8D 87 6C 07 00 00 99 BB 90 01 00 00 F7 FB 85 D2 74 0D 8B C6 C1 E0 02 8B B0 ?? ?? ?? ?? EB 0B 8B C6 C1 E0 02 8B B0 ?? ?? ?? ?? 89 45 0C 8D 87 2B 01 00 00 99 8D 5F FF BF 90 01 00 00 F7 FF 6A 64 5F 46 6A 07 89 45 F8 8B C3 99 F7 FF 8B 55 F8 8B 7D 10 2B D0 8B DA 8D 47 FF 99 83 E2 03 03 C2 C1 F8 02 8B D7 69 D2 6D 01 00 00 03 C6 03 C3 8D 84 02 25 9C FF FF 99 5B F7 FB 8B 45 14 6B C0 07 2B C2 03 45 18 3B 55 18 7F 06 8D 74 06 F9 EB 02 03 F0 83 7D 14 05 0F 85 80 00 00 00 83 7D F4 00 75 0C 8B C7 6A 64 99 5B F7 FB 85 D2 75 1D 8D 87 6C 07 00 00 99 BB 90 01 00 00 F7 FB 85 D2 74 0B 8B 45 0C 8B 80 ?? ?? ?? ?? EB 09 8B 45 0C 8B 80 ?? ?? ?? ?? 3B F0 7E 44 83 EE 07 EB 3F 25 03 00 00 80 79 05 48 83 C8 FC 40 75 0C 8B C7 6A 64 99 5B F7 FB 85 D2 75 1B 8D 87 6C 07 00 00 99 BB 90 01 00 00 F7 FB 85 D2 74 09 8B 34 B5 ?? ?? ?? ?? EB 07 8B 34 B5 ?? ?? ?? ?? 03 75 1C 6B C9 3C 03 4D 20 6B C9 3C 03 4D 24 69 C9 E8 03 00 00 03 4D 28 83 7D 08 01 75 14 89 35 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? 89 3D ?? ?? ?? ?? EB 6B 8D 45 FC 50 89 35 ?? ?? ?? ?? 89 0D ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 0F 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 8B 45 FC 69 C0 E8 03 00 00 01 05 ?? ?? ?? ?? 79 12 81 05 ?? ?? ?? ?? 00 5C 26 05 FF 0D ?? ?? ?? ?? EB 19 B8 00 5C 26 05 39 05 ?? ?? ?? ?? 7C 0C 29 05 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? 89 3D ?? ?? ?? ?? 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_429_6_0 {
	meta:
		name = "__isindst_nolock"
		size = 430
		refs = "000f __get_daylight 001e __invoke_watson 003a _dststart 0042 _dstend 004e _tzapiused 005b _tzinfo 00aa _cvtdate"
	strings:
		$1 = { 55 8B EC 51 56 8D 45 FC 33 F6 50 89 75 FC E8 ?? ?? ?? ?? 85 C0 59 74 0D 56 56 56 56 56 E8 ?? ?? ?? ?? 83 C4 14 39 75 FC 75 07 33 C0 E9 32 01 00 00 8B 57 14 53 33 DB 43 3B 15 ?? ?? ?? ?? 75 0C 3B 15 ?? ?? ?? ?? 0F 84 F2 00 00 00 39 35 ?? ?? ?? ?? 0F 84 B8 00 00 00 66 39 35 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 50 0F B7 05 ?? ?? ?? ?? 50 0F B7 05 ?? ?? ?? ?? 50 75 15 0F B7 05 ?? ?? ?? ?? 56 50 0F B7 05 ?? ?? ?? ?? 50 52 53 EB 0C 0F B7 05 ?? ?? ?? ?? 50 56 56 52 56 0F B7 05 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 0F B7 05 ?? ?? ?? ?? 0F B7 0D ?? ?? ?? ?? 83 C4 24 66 39 35 ?? ?? ?? ?? 50 0F B7 05 ?? ?? ?? ?? 50 0F B7 05 ?? ?? ?? ?? 50 75 17 0F B7 05 ?? ?? ?? ?? 56 50 0F B7 05 ?? ?? ?? ?? 50 FF 77 14 53 EB 0E 0F B7 05 ?? ?? ?? ?? 50 56 56 FF 77 14 56 0F B7 05 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 83 C4 24 EB 2E 56 56 56 56 56 53 52 53 53 6A 02 59 6A 04 58 E8 ?? ?? ?? ?? 56 56 56 56 56 6A 05 FF 77 14 53 56 6A 02 59 6A 0A 58 E8 ?? ?? ?? ?? 83 C4 48 8B 0D ?? ?? ?? ?? A1 ?? ?? ?? ?? 3B C8 8B 57 1C 7D 16 3B D1 7C 22 3B D0 7F 1E 3B D1 7E 1E 3B D0 7D 1A 8B C3 5B 5E C9 C3 3B D0 7C F6 3B D1 7F F2 3B D0 7E 08 3B D1 7D 04 33 C0 EB E8 8B 47 08 6B C0 3C 03 47 04 6B C0 3C 03 07 69 C0 E8 03 00 00 3B D1 75 0D 33 C9 3B 05 ?? ?? ?? ?? 0F 9D C1 EB 0B 33 C9 3B 05 ?? ?? ?? ?? 0F 9C C1 8B C1 EB B4 }
	condition:
		$1
}

rule file_429_7_0 {
	meta:
		name = "___tzset"
		size = 79
		refs = "0003 __sehtable$___tzset 0008 __SEH_prolog4 0010 ?first_time@?1??__tzset@@9@9 0019 __lock 002a __tzset_nolock 0041 __SEH_epilog4 0049 __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 33 F6 39 35 ?? ?? ?? ?? 75 2A 6A 06 E8 ?? ?? ?? ?? 59 89 75 FC 39 35 ?? ?? ?? ?? 75 0B E8 ?? ?? ?? ?? FF 05 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 06 00 00 00 E8 ?? ?? ?? ?? C3 6A 06 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_429_8_0 {
	meta:
		name = "__tzset"
		size = 56
		refs = "0003 __sehtable$__tzset 0008 __SEH_prolog4 000f __lock 0019 __tzset_nolock 002a __SEH_epilog4 0032 __unlock"
	strings:
		$1 = { 6A 08 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 06 E8 ?? ?? ?? ?? 59 83 65 FC 00 E8 ?? ?? ?? ?? C7 45 FC FE FF FF FF E8 06 00 00 00 E8 ?? ?? ?? ?? C3 6A 06 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_429_9_0 {
	meta:
		name = "__isindst"
		size = 65
		refs = "0003 __sehtable$__isindst 0008 __SEH_prolog4 000f __lock 001c __isindst_nolock 0033 __SEH_epilog4 003b __unlock"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 6A 06 E8 ?? ?? ?? ?? 59 83 65 FC 00 8B 7D 08 E8 ?? ?? ?? ?? 89 45 E4 C7 45 FC FE FF FF FF E8 09 00 00 00 8B 45 E4 E8 ?? ?? ?? ?? C3 6A 06 E8 ?? ?? ?? ?? 59 C3 }
	condition:
		$1
}

rule file_431_0_0 {
	meta:
		name = "__endthreadex"
		size = 57
		refs = "0002 __FPmtterm 000f __IsNonwritableInCurrentImage 001f __getptd_noexit 0029 __freeptd 0034 __imp__ExitThread@4"
	strings:
		$1 = { 83 3D ?? ?? ?? ?? 00 74 15 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 06 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 74 07 50 E8 ?? ?? ?? ?? 59 FF 74 24 04 FF 15 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_431_1_0 {
	meta:
		name = "__callthreadstartex"
		size = 65
		refs = "0003 __sehtable$__callthreadstartex 0008 __SEH_prolog4 000d __getptd 001d __endthreadex 002e __XcptFilter 003c __exit"
	strings:
		$1 = { 6A 0C 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 65 FC 00 FF 70 58 FF 50 54 50 E8 ?? ?? ?? ?? 8B 45 EC 8B 08 8B 09 89 4D E4 50 51 E8 ?? ?? ?? ?? 59 59 C3 8B 65 E8 FF 75 E4 E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_431_2_0 {
	meta:
		name = "__threadstartex@4"
		size = 128
		refs = "0002 ___set_flsgetvalue 0007 ___get_flsindex 000d ___fls_getvalue@4 0021 ___fls_setvalue@8 002b __imp__GetLastError@0 0032 __imp__ExitThread@4 0038 __imp__GetCurrentThreadId@0 0058 __freefls@4 005e __FPmtinit 006b __IsNonwritableInCurrentImage 007b __callthreadstartex"
	strings:
		$1 = { 56 E8 ?? ?? ?? ?? E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 2B 8B 74 24 08 56 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 85 C0 75 0D FF 15 ?? ?? ?? ?? 50 FF 15 ?? ?? ?? ?? FF 15 ?? ?? ?? ?? 89 06 EB 1C 8B 4C 24 08 8B 51 54 89 50 54 8B 51 58 89 50 58 8B 51 04 51 89 50 04 E8 ?? ?? ?? ?? 83 3D ?? ?? ?? ?? 00 74 15 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 85 C0 59 74 06 FF 15 ?? ?? ?? ?? E8 ?? ?? ?? ?? CC }
	condition:
		$1
}

rule file_431_3_0 {
	meta:
		name = "__beginthreadex"
		size = 174
		refs = "0013 __errno 0023 __invalid_parameter 0030 ___set_flsgetvalue 003c __calloc_crt 0049 __getptd 0052 __initptd 0075 __threadstartex@4 0081 __imp__CreateThread@24 008b __imp__GetLastError@0 0094 _free 00a2 __dosmaperr"
	strings:
		$1 = { 55 8B EC 51 53 57 8B 7D 10 33 DB 3B FB 89 5D FC 75 1C E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 EB 7C 56 E8 ?? ?? ?? ?? 68 14 02 00 00 6A 01 E8 ?? ?? ?? ?? 8B F0 3B F3 59 59 74 4A E8 ?? ?? ?? ?? FF 70 6C 56 E8 ?? ?? ?? ?? 8B 45 14 83 4E 04 FF 89 46 58 8B 45 1C 3B C3 59 59 89 7E 54 75 03 8D 45 10 50 FF 75 18 56 68 ?? ?? ?? ?? FF 75 0C FF 75 08 FF 15 ?? ?? ?? ?? 3B C3 75 20 FF 15 ?? ?? ?? ?? 89 45 FC 56 E8 ?? ?? ?? ?? 39 5D FC 59 74 09 FF 75 FC E8 ?? ?? ?? ?? 59 33 C0 5E 5F 5B C9 C3 }
	condition:
		$1
}

rule file_433_0_0 {
	meta:
		name = "__aullshr"
		size = 31
	strings:
		$1 = { 80 F9 40 73 15 80 F9 20 73 06 0F AD D0 D3 EA C3 8B C2 33 D2 80 E1 1F D3 E8 C3 33 C0 33 D2 C3 }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "___ascii_strnicmp"
		size = 97
	strings:
		$1 = { 55 8B EC 57 56 53 8B 4D 10 0B C9 74 4D 8B 75 08 8B 7D 0C B7 41 B3 5A B6 20 8D 49 00 8A 26 0A E4 8A 07 74 27 0A C0 74 23 83 C6 01 83 C7 01 3A E7 72 06 3A E3 77 02 02 E6 3A C7 72 06 3A C3 77 02 02 C6 3A E0 75 0B 83 E9 01 75 D1 33 C9 3A E0 74 09 B9 FF FF FF FF 72 02 F7 D9 8B C1 5B 5E 5F C9 C3 }
	condition:
		$1
}

rule file_435_0_0 {
	meta:
		name = "_fastzero_I"
		size = 87
	strings:
		$1 = { 55 8B EC 83 EC 04 89 7D FC 8B 7D 08 8B 4D 0C C1 E9 07 66 0F EF C0 EB 08 8D A4 24 00 00 00 00 90 66 0F 7F 07 66 0F 7F 47 10 66 0F 7F 47 20 66 0F 7F 47 30 66 0F 7F 47 40 66 0F 7F 47 50 66 0F 7F 47 60 66 0F 7F 47 70 8D BF 80 00 00 00 49 75 D0 8B 7D FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_435_1_0 {
	meta:
		name = "__VEC_memzero"
		size = 143
		refs = "0032 _fastzero_I 007e __VEC_memzero"
	strings:
		$1 = { 55 8B EC 83 EC 10 89 7D FC 8B 45 08 99 8B F8 33 FA 2B FA 83 E7 0F 33 FA 2B FA 85 FF 75 3C 8B 4D 10 8B D1 83 E2 7F 89 55 F4 3B CA 74 12 2B CA 51 50 E8 ?? ?? ?? ?? 83 C4 08 8B 45 08 8B 55 F4 85 D2 74 45 03 45 10 2B C2 89 45 F8 33 C0 8B 7D F8 8B 4D F4 F3 AA 8B 45 08 EB 2E F7 DF 83 C7 10 89 7D F0 33 C0 8B 7D 08 8B 4D F0 F3 AA 8B 45 F0 8B 4D 08 8B 55 10 03 C8 2B D0 52 6A 00 51 E8 ?? ?? ?? ?? 83 C4 0C 8B 45 08 8B 7D FC 8B E5 5D C3 }
	condition:
		$1
}

rule file_436_0_0 {
	meta:
		name = "_memchr"
		size = 173
	strings:
		$1 = { 8B 44 24 0C 53 85 C0 74 52 8B 54 24 08 33 DB 8A 5C 24 0C F7 C2 03 00 00 00 74 16 8A 0A 83 C2 01 32 CB 74 72 83 E8 01 74 32 F7 C2 03 00 00 00 75 EA 83 E8 04 72 12 57 8B FB C1 E3 08 03 DF 8B FB C1 E3 10 03 DF EB 1B 5F 83 C0 04 74 0E 8A 0A 83 C2 01 32 CB 74 40 83 E8 01 75 F2 5B C3 83 E8 04 72 E5 8B 0A 33 CB BF FF FE FE 7E 03 F9 83 F1 FF 33 CF 83 C2 04 81 E1 00 01 01 81 74 E0 8B 4A FC 32 CB 74 23 32 EB 74 19 C1 E9 10 32 CB 74 0C 32 EB 74 02 EB C8 5F 8D 42 FF 5B C3 8D 42 FE 5F 5B C3 8D 42 FD 5F 5B C3 8D 42 FC 5F 5B C3 }
	condition:
		$1
}

rule file_439_2_0 {
	meta:
		name = "__CIlog_default"
		size = 213
		refs = "0007 __checkTOS_withFB 0019 __fload_withFB 0032 __DEFAULT_CW_in_mem 004c ___fastflag 0053 __fast_exit 0059 LOG_name 0063 __math_exit 0089 __indefinite 0095 __convertTOStoQNaN 00ad __minfinity 00cf __startOneArgErrorHandling"
	strings:
		$1 = { 83 EC 0C DD 14 24 E8 ?? ?? ?? ?? E8 0D 00 00 00 83 C4 0C C3 8D 54 24 04 E8 ?? ?? ?? ?? 52 9B D9 3C 24 74 4C 8B 44 24 0C 66 81 3C 24 7F 02 74 06 D9 2D ?? ?? ?? ?? A9 00 00 F0 7F 74 5E A9 00 00 00 80 75 41 D9 ED D9 C9 D9 F1 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E9 ?? ?? ?? ?? A9 00 00 00 80 75 17 EB D4 A9 FF FF 0F 00 75 1D 83 7C 24 08 00 75 16 25 00 00 00 80 74 C5 DD D8 DB 2D ?? ?? ?? ?? B8 01 00 00 00 EB 22 E8 ?? ?? ?? ?? EB 1B A9 FF FF 0F 00 75 C5 83 7C 24 08 00 75 BE DD D8 DB 2D ?? ?? ?? ?? B8 02 00 00 00 83 3D ?? ?? ?? ?? 00 0F 85 ?? ?? ?? ?? 8D 0D ?? ?? ?? ?? BA 1A 00 00 00 E8 ?? ?? ?? ?? 5A C3 }
	condition:
		$1
}

rule file_440_0_0 {
	meta:
		name = "_wcscpy_s"
		size = 108
		refs = "0016 __errno 0025 __invalid_parameter"
	strings:
		$1 = { 8B 4C 24 04 53 56 57 33 FF 3B CF 74 08 8B 5C 24 14 3B DF 77 1B E8 ?? ?? ?? ?? 6A 16 5E 89 30 57 57 57 57 57 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 38 8B 74 24 18 3B F7 75 05 66 89 39 EB D8 8B D1 0F B7 06 66 89 02 42 42 46 46 66 3B C7 74 03 4B 75 EE 3B DF 75 11 66 89 39 E8 ?? ?? ?? ?? 6A 22 59 89 08 8B F1 EB B9 33 C0 5F 5E 5B C3 }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "__d_inttype"
		size = 100
		refs = "000e __fpclass 0021 __frnd 0037 __real@3fe0000000000000"
	strings:
		$1 = { 55 8B EC 51 51 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? A8 90 59 59 75 48 DD 45 08 51 51 DD 1C 24 E8 ?? ?? ?? ?? DC 5D 08 59 59 DF E0 F6 C4 44 7A 2F DD 45 08 51 DC 0D ?? ?? ?? ?? 51 DD 5D F8 DD 45 F8 DD 1C 24 E8 ?? ?? ?? ?? DC 5D F8 59 59 DF E0 F6 C4 44 7A 05 6A 02 58 C9 C3 33 C0 40 C9 C3 33 C0 C9 C3 }
	condition:
		$1
}

rule file_442_1_0 {
	meta:
		name = "__powhlp"
		size = 318
		refs = "0040 __d_inf 009e __d_ind 00ee __d_inttype 0126 __d_mzero"
	strings:
		$1 = { 55 8B EC D9 EE 56 DC 55 08 33 D2 33 F6 DF E0 DD 45 08 F6 C4 41 75 02 D9 E0 B8 00 00 F0 7F 39 45 14 B9 00 00 F0 FF 75 3D 39 55 10 75 7F D9 E8 D8 D1 DF E0 F6 C4 05 7A 11 DD DA DD D9 DD D8 DD 05 ?? ?? ?? ?? E9 E1 00 00 00 D8 D1 DF E0 DD D9 F6 C4 41 8B 45 18 75 07 DD D8 E9 CF 00 00 00 DD D9 E9 C8 00 00 00 39 4D 14 75 42 39 55 10 75 3D D9 E8 D8 D1 DF E0 F6 C4 05 7A 09 DD D8 DD D8 E9 A7 00 00 00 DD DA DE D9 DF E0 F6 C4 05 8B 45 18 7A 0B DD 05 ?? ?? ?? ?? E9 91 00 00 00 DD 05 ?? ?? ?? ?? 33 F6 DD 18 46 E9 8D 00 00 00 39 45 0C DD D8 75 26 39 55 08 75 7F DC 55 10 DF E0 F6 C4 05 0F 8B 76 FF FF FF DC 55 10 DF E0 F6 C4 41 8B 45 18 74 5A DD D8 D9 E8 EB 54 39 4D 0C DD D8 75 59 39 55 08 75 54 DD 45 10 51 51 DD 1C 24 E8 ?? ?? ?? ?? D9 EE 59 DC 55 10 59 8B C8 DF E0 F6 C4 05 7A 11 83 F9 01 DD D8 DD 05 ?? ?? ?? ?? 75 1B D9 E0 EB 17 DC 55 10 DF E0 F6 C4 41 75 14 83 F9 01 75 08 DD D8 DD 05 ?? ?? ?? ?? 8B 45 18 DD 18 EB 08 DD D8 D9 E8 EB F3 DD D8 8B C6 5E 5D C3 }
	condition:
		$1
}

rule file_443_0_0 {
	meta:
		name = "___crtGetEnvironmentStringsW"
		size = 353
		refs = "0002 ?f_use@?1??__crtGetEnvironmentStringsW@@9@9 0009 __imp__GetEnvironmentStringsW@0 002e __imp__GetLastError@0 007b __malloc_crt 0089 __imp__FreeEnvironmentStringsW@4 0096 _memcpy 00aa __imp__GetEnvironmentStrings@0 00c7 __imp__MultiByteToWideChar@24 00d3 _strlen 00e9 __calloc_crt 00f8 __imp__FreeEnvironmentStringsA@4 0136 _wcslen 015a _free"
	strings:
		$1 = { 51 A1 ?? ?? ?? ?? 53 8B 1D ?? ?? ?? ?? 55 56 57 33 FF 33 F6 3B C7 75 2E FF D3 8B F0 3B F7 74 0C C7 05 ?? ?? ?? ?? 01 00 00 00 EB 1F FF 15 ?? ?? ?? ?? 83 F8 78 75 0A 6A 02 58 A3 ?? ?? ?? ?? EB 05 A1 ?? ?? ?? ?? 83 F8 01 75 54 3B F7 75 0F FF D3 8B F0 3B F7 75 07 33 C0 E9 F4 00 00 00 66 39 3E 8B C6 74 0E 40 40 66 39 38 75 F9 40 40 66 39 38 75 F2 2B C6 40 40 8B E8 55 E8 ?? ?? ?? ?? 8B D8 85 DB 59 75 0C 56 FF 15 ?? ?? ?? ?? E9 BE 00 00 00 55 56 53 E8 ?? ?? ?? ?? 83 C4 0C EB E7 83 F8 02 74 04 3B C7 75 AF FF 15 ?? ?? ?? ?? 8B E8 33 DB 3B EB 74 A1 38 5D 00 8B F5 74 23 53 53 6A FF 56 6A 01 53 FF 15 ?? ?? ?? ?? 3B C3 74 88 56 03 F8 E8 ?? ?? ?? ?? 8D 74 06 01 38 1E 59 75 DD 47 6A 02 57 89 7C 24 18 E8 ?? ?? ?? ?? 8B D8 85 DB 59 59 75 0C 55 FF 15 ?? ?? ?? ?? E9 56 FF FF FF 80 7D 00 00 8B FD 8B F3 74 3A 8B 4C 24 10 8B C6 2B C3 D1 F8 2B C8 51 56 6A FF 57 6A 01 6A 00 FF 15 ?? ?? ?? ?? 85 C0 74 2E 57 E8 ?? ?? ?? ?? 56 8D 7C 07 01 E8 ?? ?? ?? ?? 80 3F 00 59 59 8D 74 46 02 75 C6 66 83 26 00 55 FF 15 ?? ?? ?? ?? 8B C3 5F 5E 5D 5B 59 C3 53 E8 ?? ?? ?? ?? 59 EB 94 }
	condition:
		$1
}

rule file_444_3_0 {
	meta:
		name = "__wctomb_s_l"
		size = 351
		refs = "0039 __errno 0048 __invalid_parameter 005a ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0080 _memset 0114 __imp__WideCharToMultiByte@32 0132 __imp__GetLastError@0"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 0C 33 DB 3B F3 57 8B 7D 10 75 11 3B FB 76 0D 8B 45 08 3B C3 74 02 89 18 33 C0 EB 7F 8B 45 08 3B C3 74 03 83 08 FF 81 FF FF FF FF 7F 76 1B E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 EB 52 FF 75 18 8D 4D F0 E8 ?? ?? ?? ?? 8B 45 F0 39 58 14 0F 85 94 00 00 00 66 8B 45 14 66 3D FF 00 76 36 3B F3 74 0F 3B FB 76 0B 57 53 56 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? C7 00 2A 00 00 00 E8 ?? ?? ?? ?? 38 5D FC 8B 00 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 3B F3 74 2E 3B FB 77 28 E8 ?? ?? ?? ?? 6A 22 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 81 8B 45 F8 83 60 70 FD E9 75 FF FF FF 88 06 8B 45 08 3B C3 74 06 C7 00 01 00 00 00 38 5D FC 0F 84 30 FF FF FF 8B 45 F8 83 60 70 FD E9 24 FF FF FF 8D 4D 0C 51 53 57 56 6A 01 8D 4D 14 51 53 89 5D 0C FF 70 04 FF 15 ?? ?? ?? ?? 3B C3 74 14 39 5D 0C 0F 85 62 FF FF FF 8B 4D 08 3B CB 74 BD 89 01 EB B9 FF 15 ?? ?? ?? ?? 83 F8 7A 0F 85 48 FF FF FF 3B F3 0F 84 6B FF FF FF 3B FB 0F 86 63 FF FF FF 57 53 56 E8 ?? ?? ?? ?? 83 C4 0C E9 53 FF FF FF }
	condition:
		$1
}

rule file_444_5_0 {
	meta:
		name = "__wctomb_l"
		size = 79
		refs = "0011 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 002d __wctomb_s_l"
	strings:
		$1 = { 55 8B EC 83 EC 14 FF 75 10 83 4D FC FF 8D 4D EC E8 ?? ?? ?? ?? 8D 45 EC 50 FF 75 0C 8B 45 EC FF B0 AC 00 00 00 8D 45 FC FF 75 08 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 8B 45 FC EB 03 83 C8 FF 80 7D F8 00 74 07 8B 4D F4 83 61 70 FD C9 C3 }
	condition:
		$1
}

rule file_444_6_0 {
	meta:
		name = "_wctomb"
		size = 48
		refs = "000e ____mb_cur_max_func 001b __wctomb_s_l"
	strings:
		$1 = { 55 8B EC 51 83 4D FC FF 6A 00 FF 75 0C E8 ?? ?? ?? ?? 50 FF 75 08 8D 45 FC 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 75 05 8B 45 FC C9 C3 83 C8 FF C9 C3 }
	condition:
		$1
}

rule file_445_0_0 {
	meta:
		name = "__wopenfile"
		size = 652
		refs = "000f __commode 003c __errno 004c __invalid_parameter 01c2 ?ccsField@?P@??_wopenfile@@9@9 01c7 _wcsncmp 01da ?utf8encoding@?P@??_wopenfile@@9@9 01e0 __wcsicmp 01f6 ?utf16encoding@?P@??_wopenfile@@9@9 0212 ?unicodeencoding@?P@??_wopenfile@@9@9 0256 __wsopen_s 026b __cflush"
	strings:
		$1 = { 83 EC 0C 53 55 56 8B 74 24 20 33 ED 57 8B 3D ?? ?? ?? ?? 89 6C 24 14 89 6C 24 10 89 6C 24 18 EB 02 46 46 66 83 3E 20 74 F8 0F B7 06 83 F8 61 74 37 83 F8 72 74 2B 83 F8 77 74 1F E8 ?? ?? ?? ?? 55 55 55 55 55 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 33 C0 E9 2A 02 00 00 BB 01 03 00 00 EB 0C 33 DB 83 CF 01 EB 08 BB 09 01 00 00 83 CF 02 33 C9 41 46 46 0F B7 06 66 3B C5 0F 84 B2 01 00 00 BA 00 40 00 00 3B CD 0F 84 20 01 00 00 0F B7 C0 83 F8 53 0F 8F 9A 00 00 00 0F 84 81 00 00 00 83 E8 20 0F 84 F7 00 00 00 83 E8 0B 74 59 48 74 49 83 E8 18 74 33 83 E8 0A 74 23 83 E8 04 0F 85 77 FF FF FF 39 6C 24 10 0F 85 CC 00 00 00 C7 44 24 10 01 00 00 00 83 CB 10 E9 C2 00 00 00 81 CB 80 00 00 00 E9 B7 00 00 00 F6 C3 40 0F 85 A8 00 00 00 83 CB 40 E9 A6 00 00 00 C7 44 24 18 01 00 00 00 E9 93 00 00 00 F6 C3 02 0F 85 8A 00 00 00 83 E3 FE 83 E7 FC 83 CB 02 81 CF 80 00 00 00 EB 7F 39 6C 24 10 75 73 C7 44 24 10 01 00 00 00 83 CB 20 EB 6C 83 E8 54 74 58 83 E8 0E 74 44 48 74 2F 83 E8 0B 74 14 83 E8 06 0F 85 EC FE FF FF 66 F7 C3 00 C0 75 44 0B DA EB 46 39 6C 24 14 75 3A C7 44 24 14 01 00 00 00 81 E7 FF BF FF FF EB 30 39 6C 24 14 75 24 C7 44 24 14 01 00 00 00 0B FA EB 1E 66 F7 C3 00 C0 75 11 81 CB 00 80 00 00 EB 0F B8 00 10 00 00 85 D8 74 04 33 C9 EB 02 0B D8 46 46 0F B7 06 66 3B C5 0F 85 D8 FE FF FF 39 6C 24 18 74 7F EB 02 46 46 66 83 3E 20 74 F8 6A 04 56 68 ?? ?? ?? ?? E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 85 65 FE FF FF 83 C6 08 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 0B 83 C6 0A 81 CB 00 00 04 00 EB 3E 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 75 0B 83 C6 10 81 CB 00 00 02 00 EB 22 68 ?? ?? ?? ?? 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 15 FE FF FF 83 C6 0E 81 CB 00 00 01 00 EB 02 46 46 66 83 3E 20 74 F8 66 39 2E 0F 85 F9 FD FF FF 68 80 01 00 00 FF 74 24 2C 8D 44 24 2C 53 FF 74 24 2C 50 E8 ?? ?? ?? ?? 83 C4 14 85 C0 0F 85 EE FD FF FF 8B 44 24 2C FF 05 ?? ?? ?? ?? 8B 4C 24 24 89 78 0C 89 68 04 89 28 89 68 08 89 68 1C 89 48 10 5F 5E 5D 5B 83 C4 0C C3 }
	condition:
		$1
}

rule file_446_3_0 {
	meta:
		name = "__mbsnicoll_l"
		size = 281
		refs = "000f ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0035 __errno 0045 __invalid_parameter 009d __strnicoll_l 00af __mbsnbcnt_l 00dc ___crtCompareStringA"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 FF 75 14 8D 4D F0 E8 ?? ?? ?? ?? 8B 75 10 33 DB 3B F3 75 13 38 5D FC 74 07 8B 45 F8 83 60 70 FD 33 C0 E9 E6 00 00 00 39 5D 08 75 2E E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F E9 B3 00 00 00 57 8B 7D 0C 3B FB 74 08 81 FE FF FF FF 7F 76 1A E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 EB 66 8B 45 F4 39 58 08 75 12 FF 75 14 56 57 FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 EB 62 8D 45 F0 50 56 FF 75 08 E8 ?? ?? ?? ?? 89 45 10 8D 45 F0 50 56 57 E8 ?? ?? ?? ?? 8B 4D F4 FF 71 04 50 57 FF 75 10 8D 45 F0 FF 75 08 68 01 10 00 00 FF 71 0C 50 E8 ?? ?? ?? ?? 83 C4 38 3B C3 75 1E E8 ?? ?? ?? ?? C7 00 16 00 00 00 38 5D FC 74 07 8B 45 F8 83 60 70 FD B8 FF FF FF 7F EB 0F 83 C0 FE 38 5D FC 74 07 8B 4D F8 83 61 70 FD 5F 5E 5B C9 C3 }
	condition:
		$1
}

rule file_447_2_0 {
	meta:
		name = "__execvpe"
		size = 630
		refs = "0015 __errno 0025 __invalid_parameter 0071 __execve 008a __mbschr 00b9 ??_C@_04HBHDLLBA@PATH?$AA@ 00c3 __dupenv_s 00dd __invoke_watson 00fa __calloc_crt 0133 _isleadbyte 018b __mbsrchr 019a ??_C@_01KICIPPFI@?2?$AA@ 01a5 _strcat_s 01bf _strlen 025b _free"
	strings:
		$1 = { 55 8B EC 83 EC 10 53 56 8B 75 08 33 DB 3B F3 89 5D F4 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 3E 02 00 00 38 1E 74 DF 57 8B 7D 0C 3B FB 75 1D E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 E9 14 02 00 00 8B 07 3B C3 74 DD 38 18 74 D9 E8 ?? ?? ?? ?? FF 75 10 89 18 57 56 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 38 02 0F 85 DA 01 00 00 6A 5C 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 C8 01 00 00 6A 2F 56 E8 ?? ?? ?? ?? 85 C0 59 59 0F 85 B6 01 00 00 38 1E 74 0A 80 7E 01 3A 0F 84 A8 01 00 00 68 ?? ?? ?? ?? 8D 45 F4 53 50 E8 ?? ?? ?? ?? 83 C4 0C 3B C3 74 1B 83 F8 16 0F 85 89 01 00 00 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 E9 77 01 00 00 39 5D F4 0F 84 7C 01 00 00 6A 01 68 04 01 00 00 E8 ?? ?? ?? ?? 8B F0 3B F3 59 59 89 75 FC 0F 84 53 01 00 00 8B 7D F4 8A 07 3A C3 89 7D F0 74 5B 8D 4E 01 89 4D F8 3C 3B 74 51 8D 8E 02 01 00 00 39 4D FC 73 46 0F BE C0 50 E8 ?? ?? ?? ?? 85 C0 59 74 21 8D 47 01 38 18 74 31 8D 8E 02 01 00 00 39 4D F8 73 26 8A 0F 8B 55 FC FF 45 FC FF 45 F8 88 0A 8B F8 8B 4D FC FF 45 FC 8A 07 FF 45 F8 47 88 01 8A 07 3A C3 89 7D F0 75 AB 8B 7D FC 3B FE 88 1F 76 01 4F 8A 07 3C 5C 89 75 FC 75 0E 6A 5C 56 E8 ?? ?? ?? ?? 59 59 3B F8 EB 02 3C 2F 74 24 68 ?? ?? ?? ?? 68 04 01 00 00 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 56 E8 ?? ?? ?? ?? FF 75 08 8B F8 E8 ?? ?? ?? ?? 03 F8 B8 04 01 00 00 3B F8 59 59 73 7F FF 75 08 50 56 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 74 0D 53 53 53 53 53 E8 ?? ?? ?? ?? 83 C4 14 FF 75 10 FF 75 0C 56 E8 ?? ?? ?? ?? 83 C4 0C E8 ?? ?? ?? ?? 83 38 02 74 3B 6A 5C 56 E8 ?? ?? ?? ?? 3B F0 59 59 74 0E 6A 2F 56 E8 ?? ?? ?? ?? 3B F0 59 59 75 2C 8D 7E 01 6A 5C 57 E8 ?? ?? ?? ?? 3B F8 59 59 74 0E 6A 2F 57 E8 ?? ?? ?? ?? 3B F8 59 59 75 0D 8B 7D F0 38 1F 74 06 47 E9 B7 FE FF FF 56 E8 ?? ?? ?? ?? 59 39 5D F4 74 09 FF 75 F4 E8 ?? ?? ?? ?? 59 5F 5E 83 C8 FF 5B C9 C3 }
	condition:
		$1
}

rule file_448_0_0 {
	meta:
		name = "___libm_sse2_log10f"
		size = 377
		refs = "0004 _dword_mask 000c _SIGMASK 0018 _EXPMASK 0039 _cv 0077 _B_table 00a8 _T_Tbl 00cc _L102 010e _pow2_64 0152 _SNAN 015f _One 016b _NEG_INF"
	strings:
		$1 = { F3 0F 10 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F DB C4 66 0F 12 1D ?? ?? ?? ?? 66 0F 6F F8 66 0F C5 C0 01 0F 28 E0 66 0F 73 F0 1D 66 0F 54 C8 66 0F 56 CB 66 0F 12 2D ?? ?? ?? ?? 66 0F 12 35 ?? ?? ?? ?? 66 0F 12 15 ?? ?? ?? ?? 8B D0 B9 7F 7F 00 00 2B CA 81 EA 80 00 00 00 0B D1 81 FA 00 80 00 00 0F 83 87 00 00 00 B9 3F 3F 00 00 66 0F 6E C1 66 0F 12 1D ?? ?? ?? ?? 83 E0 7F 83 C0 01 25 FE 00 00 00 03 C0 03 C0 66 0F 12 B8 ?? ?? ?? ?? 66 0F 73 D4 10 66 0F FA E0 66 0F 72 E4 07 F3 0F E6 E4 66 0F 12 80 ?? ?? ?? ?? F2 0F 59 CF F2 0F 5C CB F2 0F 10 F9 F2 0F 59 E9 F2 0F 10 D9 F2 0F 59 C9 F2 0F 58 EE F2 0F 59 25 ?? ?? ?? ?? F2 0F 59 F9 F2 0F 59 D1 F2 0F 58 D3 F2 0F 59 FD F2 0F 58 C4 F2 0F 58 D7 F2 0F 58 C2 66 0F 5A C0 C3 66 0F 7E FA 81 FA 00 00 00 80 73 37 81 FA 00 00 80 7F 73 6B 83 FA 00 74 51 F3 0F 59 25 ?? ?? ?? ?? 66 0F 12 0D ?? ?? ?? ?? 66 0F C5 C4 01 0F 5A C4 66 0F 54 C8 66 0F 56 CB B9 3F 5F 00 00 E9 3B FF FF FF 81 FA 00 00 00 80 74 1F 81 E2 FF FF FF 7F 81 FA 01 00 80 7F 73 26 F3 0F 10 C7 F3 0F 10 0D ?? ?? ?? ?? F3 0F 58 C1 C3 F3 0F 10 0D ?? ?? ?? ?? F3 0F 5E CF F3 0F 10 05 ?? ?? ?? ?? C3 F3 0F 10 C7 F3 0F 58 C0 C3 }
	condition:
		$1
}

rule file_449_9_0 {
	meta:
		name = "__cprinput_s_l"
		size = 2973
		refs = "000f ___security_cookie 004b __errno 005b __invalid_parameter 0074 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0092 _isspace 00a2 __whiteout 00a8 __un_inc 010d _isdigit 0232 __getche_nolock 0353 ___check_float_string 055c __cfltcvt_tab 0561 __decode_pointer 0634 _isleadbyte 0665 __mbtowc_l 06e9 _memset 090c __allmul 091e _isxdigit 0b51 _free 0b91 @__security_check_cookie@4"
	strings:
		$1 = { 55 8D AC 24 70 FE FF FF 81 EC 00 02 00 00 A1 ?? ?? ?? ?? 33 C5 89 85 8C 01 00 00 8B 85 9C 01 00 00 56 57 33 FF 8B F1 3B F7 89 45 B0 8D 45 0C 89 75 D4 89 45 E8 C7 45 BC 5E 01 00 00 89 7D C4 89 7D A4 89 7D 08 89 7D A0 75 20 E8 ?? ?? ?? ?? 57 57 57 57 57 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 83 C8 FF E9 1C 0B 00 00 FF B5 98 01 00 00 8D 4D 90 E8 ?? ?? ?? ?? 8A 06 84 C0 C6 45 F7 00 89 7D 04 89 7D C8 0F 84 EA 0A 00 00 53 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 74 29 FF 4D 04 8D 75 04 E8 ?? ?? ?? ?? 50 E8 ?? ?? ?? ?? 8B 75 D4 59 46 0F B6 06 50 E8 ?? ?? ?? ?? 85 C0 59 75 F1 E9 CD 09 00 00 8B 75 D4 80 3E 25 0F 85 C6 09 00 00 33 FF 89 7D AC C6 45 C3 00 89 7D EC 89 7D E0 89 7D FC 89 7D CC C6 45 F9 00 C6 45 F8 00 C6 45 02 00 C6 45 E7 00 C6 45 FA 00 C6 45 03 00 C6 45 FB 01 89 7D B8 46 0F B6 1E 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 15 8B 45 FC FF 45 E0 6B C0 0A 8D 44 18 D0 89 45 FC E9 A0 00 00 00 83 FB 4E 7F 71 0F 84 95 00 00 00 83 FB 2A 74 61 83 FB 46 0F 84 87 00 00 00 83 FB 49 74 0A 83 FB 4C 75 62 FE 45 FB EB 78 8A 4E 01 80 F9 36 75 15 8D 46 02 80 38 34 75 0D FF 45 B8 8B F0 89 7D D8 89 7D DC EB 5B 80 F9 33 75 0C 8D 46 02 80 38 32 75 04 8B F0 EB 4A 80 F9 64 74 45 80 F9 69 74 40 80 F9 6F 74 3B 80 F9 78 74 36 80 F9 58 75 16 EB 2F FE 45 02 EB 2A 83 FB 68 74 1F 83 FB 6C 74 0A 83 FB 77 74 10 FE 45 E7 EB 16 8D 46 01 80 38 6C 74 A6 FE 45 FB FE 45 03 EB 06 FE 4D FB FE 4D 03 80 7D E7 00 0F 84 2F FF FF FF 80 7D 02 00 89 75 D4 75 10 8B 45 B0 8B 38 89 45 A8 83 C0 04 89 45 B0 EB 02 33 FF 32 DB 38 5D 03 89 7D D0 75 12 8A 06 3C 53 74 08 3C 43 C6 45 03 FF 75 04 C6 45 03 01 0F B6 06 83 C8 20 83 F8 6E 89 45 F0 74 2E 83 F8 63 74 0F 83 F8 7B 74 0A 8D 75 04 E8 ?? ?? ?? ?? EB 08 FF 45 04 E8 ?? ?? ?? ?? 83 F8 FF 89 45 08 0F 84 04 09 00 00 8B 7D D0 8B 75 D4 83 7D E0 00 74 0A 83 7D FC 00 0F 84 8A 08 00 00 80 7D 02 00 8B 4D F0 75 32 83 F9 63 74 0A 83 F9 73 74 05 83 F9 7B 75 23 8B 45 A8 8B 38 83 C0 04 89 45 A8 83 C0 04 89 45 B0 8B 40 FC 83 F8 01 89 7D D0 89 45 CC 0F 82 59 08 00 00 83 F9 6F 0F 8F DE 03 00 00 0F 84 DD 05 00 00 83 F9 63 0F 84 C5 02 00 00 6A 64 58 3B C8 0F 84 C9 05 00 00 0F 8E E8 03 00 00 83 F9 67 7E 36 83 F9 69 74 1B 83 F9 6E 0F 85 D5 03 00 00 80 7D 02 00 8B 75 04 0F 84 8E 07 00 00 E9 A9 07 00 00 89 45 F0 83 7D 08 2D 0F 85 95 04 00 00 C6 45 F8 01 E9 92 04 00 00 33 DB 83 7D 08 2D 75 09 8B 45 E8 C6 00 2D 43 EB 06 83 7D 08 2B 75 0E FF 4D FC FF 45 04 E8 ?? ?? ?? ?? 89 45 08 83 7D E0 00 75 04 83 4D FC FF 0F B6 45 08 EB 44 8B 45 FC FF 4D FC 85 C0 74 45 8A 45 08 8B 4D E8 FF 45 EC 88 04 0B 8D 45 C4 50 8D 45 0C 50 43 53 8D 7D E8 8D 75 BC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 E4 07 00 00 FF 45 04 E8 ?? ?? ?? ?? 89 45 08 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 75 B1 8B 45 90 8B 80 BC 00 00 00 8B 00 8A 00 3A 45 08 88 45 F9 0F 85 97 00 00 00 8B 45 FC FF 4D FC 85 C0 0F 84 89 00 00 00 FF 45 04 E8 ?? ?? ?? ?? 8B 4D E8 89 45 08 8A 45 F9 88 04 0B 8D 45 C4 50 8D 45 0C 50 43 53 8D 7D E8 8D 75 BC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 70 07 00 00 0F B6 45 08 EB 44 8B 45 FC FF 4D FC 85 C0 74 45 8B 45 E8 8A 4D 08 FF 45 EC 88 0C 03 8D 45 C4 50 8D 45 0C 50 43 53 8D 7D E8 8D 75 BC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 34 07 00 00 FF 45 04 E8 ?? ?? ?? ?? 89 45 08 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 75 B1 83 7D EC 00 0F 84 ED 00 00 00 83 7D 08 65 74 0A 83 7D 08 45 0F 85 DD 00 00 00 8B 45 FC FF 4D FC 85 C0 0F 84 CF 00 00 00 8B 45 E8 C6 04 03 65 8D 45 C4 50 8D 45 0C 50 43 53 8D 7D E8 8D 75 BC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 CC 06 00 00 FF 45 04 E8 ?? ?? ?? ?? 83 F8 2D 89 45 08 75 23 8B 45 E8 C6 04 03 2D 8D 45 C4 50 8D 45 0C 50 43 53 E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 9B 06 00 00 EB 06 83 7D 08 2B 75 1A 8B 45 FC FF 4D FC 85 C0 75 05 21 45 FC EB 0B FF 45 04 E8 ?? ?? ?? ?? 89 45 08 0F B6 45 08 EB 44 8B 45 FC FF 4D FC 85 C0 74 45 8B 45 E8 8A 4D 08 FF 45 EC 88 0C 03 8D 45 C4 50 8D 45 0C 50 43 53 8D 7D E8 8D 75 BC E8 ?? ?? ?? ?? 83 C4 0C 85 C0 0F 84 3D 06 00 00 FF 45 04 E8 ?? ?? ?? ?? 89 45 08 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 75 B1 FF 75 08 FF 4D 04 E8 ?? ?? ?? ?? 83 7D EC 00 59 0F 84 0E 06 00 00 80 7D 02 00 0F 85 48 05 00 00 8B 45 E8 FF 45 C8 8D 4D 90 51 50 FF 75 D0 C6 04 03 00 0F BE 45 FB 48 50 FF 35 ?? ?? ?? ?? E8 ?? ?? ?? ?? 59 FF D0 83 C4 10 E9 1A 05 00 00 83 7D E0 00 75 0A FF 45 FC C7 45 E0 01 00 00 00 80 7D 03 00 7E 04 C6 45 FA 01 FF 75 08 FF 4D 04 8B F7 E8 ?? ?? ?? ?? 83 7D F0 63 59 74 03 FF 4D CC 83 7D E0 00 74 0E 8B 45 FC FF 4D FC 85 C0 0F 84 8D 02 00 00 FF 45 04 E8 ?? ?? ?? ?? 83 7D F0 63 89 45 08 74 48 83 7D F0 73 75 13 83 F8 09 7C 09 83 F8 0D 0F 8E 5E 02 00 00 83 F8 20 75 2F 83 7D F0 7B 0F 85 4F 02 00 00 0F BE 5D F9 33 D2 8B C8 83 E1 07 42 D3 E2 8B C8 C1 F9 03 0F BE 8C 0D 6C 01 00 00 33 CB 85 D1 0F 84 2A 02 00 00 80 7D 02 00 0F 85 1A 02 00 00 83 7D CC 00 0F 84 F7 04 00 00 80 7D FA 00 0F 84 FB 01 00 00 88 45 B4 0F B6 C0 50 E8 ?? ?? ?? ?? 85 C0 59 74 0B FF 45 04 E8 ?? ?? ?? ?? 88 45 B5 8D 45 90 50 8B 45 90 C7 45 A4 3F 00 00 00 FF B0 AC 00 00 00 8D 45 B4 50 8D 45 A4 50 E8 ?? ?? ?? ?? 66 8B 45 A4 83 C4 10 66 89 07 47 47 E9 B0 01 00 00 8B C1 83 E8 70 0F 84 F6 01 00 00 83 E8 03 0F 84 F2 FE FF FF 48 48 0F 84 E9 01 00 00 83 E8 03 0F 84 45 FC FF FF 83 E8 03 74 24 0F B6 06 3B 45 08 0F 85 58 04 00 00 FE 4D F7 80 7D 02 00 0F 85 CD 03 00 00 8B 45 A8 89 45 B0 E9 C2 03 00 00 80 7D 03 00 7E 04 C6 45 FA 01 46 80 3E 5E 75 05 46 C6 45 F9 FF 6A 20 8D 85 6C 01 00 00 6A 00 50 E8 ?? ?? ?? ?? 83 C4 0C 80 3E 5D 75 0C B2 5D 46 C6 85 77 01 00 00 20 EB 69 8A 55 C3 EB 64 46 3C 2D 75 45 84 D2 74 41 8A 0E 80 F9 5D 74 3A 46 3A D1 73 04 8A C1 EB 04 8A C2 8A D1 3A D0 77 25 2A C2 FE C0 0F B6 FA 0F B6 D0 8B CF 83 E1 07 8B C7 B3 01 D2 E3 C1 E8 03 8D 84 05 6C 01 00 00 08 18 47 4A 75 E5 32 D2 EB 1A 0F B6 C8 8A D0 8B C1 83 E1 07 B3 01 C1 E8 03 D2 E3 8D 84 05 6C 01 00 00 08 18 8A 06 3C 5D 75 96 84 C0 0F 84 CE 03 00 00 8B 7D D0 89 75 D4 E9 07 FE FF FF 83 7D 08 2B 75 1A FF 4D FC 75 0A 83 7D E0 00 74 04 B3 01 EB 0B FF 45 04 E8 ?? ?? ?? ?? 89 45 08 83 7D 08 30 0F 85 FE 00 00 00 FF 45 04 E8 ?? ?? ?? ?? 3C 78 89 45 08 74 42 3C 58 74 3E 83 7D F0 78 C7 45 EC 01 00 00 00 74 19 83 7D E0 00 74 07 FF 4D FC 75 02 FE C3 C7 45 F0 6F 00 00 00 E9 C5 00 00 00 FF 75 08 FF 4D 04 E8 ?? ?? ?? ?? 59 C7 45 08 30 00 00 00 E9 AD 00 00 00 FF 45 04 E8 ?? ?? ?? ?? 83 7D E0 00 89 45 08 74 0C 83 6D FC 02 83 7D FC 01 7D 02 FE C3 C7 45 F0 78 00 00 00 E9 84 00 00 00 88 07 47 89 7D D0 E9 6C FD FF FF 46 E9 69 FD FF FF FF 4D 04 50 E8 ?? ?? ?? ?? 59 3B F7 0F 84 FC 02 00 00 80 7D 02 00 0F 85 36 02 00 00 FF 45 C8 83 7D F0 63 0F 84 29 02 00 00 80 7D FA 00 8B 45 D0 74 09 66 83 20 00 E9 17 02 00 00 C6 00 00 E9 0F 02 00 00 C6 45 FB 01 83 7D 08 2D 75 06 C6 45 F8 01 EB 06 83 7D 08 2B 75 1A FF 4D FC 75 0A 83 7D E0 00 74 04 B3 01 EB 0B FF 45 04 E8 ?? ?? ?? ?? 89 45 08 83 7D B8 00 0F 84 F9 00 00 00 84 DB 0F 85 CC 00 00 00 83 7D F0 78 74 55 83 7D F0 70 74 4F 0F B6 45 08 50 E8 ?? ?? ?? ?? 85 C0 59 0F 84 A1 00 00 00 83 7D F0 6F 75 1F 83 7D 08 38 0F 8D 91 00 00 00 8B 45 D8 8B 4D DC 0F A4 C1 03 C1 E0 03 89 45 D8 89 4D DC EB 51 6A 00 6A 0A FF 75 DC FF 75 D8 E8 ?? ?? ?? ?? 89 45 D8 89 55 DC EB 3A 0F B6 75 08 56 E8 ?? ?? ?? ?? 85 C0 59 74 56 8B 45 D8 8B 4D DC 0F A4 C1 04 C1 E0 04 56 89 45 D8 89 4D DC E8 ?? ?? ?? ?? 85 C0 0F BE 45 08 59 75 06 83 E0 DF 83 E8 07 89 45 08 8B 45 08 FF 45 EC 83 C0 D0 99 01 45 D8 11 55 DC 83 7D E0 00 74 05 FF 4D FC 74 1C FF 45 04 E8 ?? ?? ?? ?? 89 45 08 E9 40 FF FF FF FF 75 08 FF 4D 04 E8 ?? ?? ?? ?? 59 80 7D F8 00 8B 75 AC 0F 84 B4 00 00 00 8B 45 D8 8B 4D DC F7 D8 83 D1 00 F7 D9 89 45 D8 89 4D DC E9 9C 00 00 00 84 DB 8B 75 AC 0F 85 89 00 00 00 83 7D F0 78 74 2B 83 7D F0 70 74 25 0F B6 45 08 50 E8 ?? ?? ?? ?? 85 C0 59 74 62 83 7D F0 6F 75 0B 83 7D 08 38 7D 56 C1 E6 03 EB 2F 6B F6 0A EB 2A 0F B6 7D 08 57 E8 ?? ?? ?? ?? 85 C0 59 74 3D 57 C1 E6 04 E8 ?? ?? ?? ?? 85 C0 0F BE 45 08 59 75 06 83 E0 DF 83 E8 07 89 45 08 FF 45 EC 83 7D E0 00 8B 45 08 8D 74 06 D0 74 05 FF 4D FC 74 19 FF 45 04 E8 ?? ?? ?? ?? 89 45 08 EB 83 FF 75 08 FF 4D 04 E8 ?? ?? ?? ?? 59 80 7D F8 00 74 02 F7 DE 83 7D F0 46 75 04 83 65 EC 00 83 7D EC 00 0F 84 E8 00 00 00 80 7D 02 00 75 26 FF 45 C8 8B 7D D0 83 7D B8 00 74 0D 8B 45 D8 89 07 8B 45 DC 89 47 04 EB 0D 80 7D FB 00 74 04 89 37 EB 03 66 89 37 8B 75 D4 FE 45 F7 46 89 75 D4 EB 40 FF 45 04 E8 ?? ?? ?? ?? 8B D8 0F B6 06 46 3B C3 89 5D 08 89 75 D4 0F 85 83 00 00 00 0F B6 C3 50 E8 ?? ?? ?? ?? 85 C0 59 74 16 FF 45 04 E8 ?? ?? ?? ?? 0F B6 0E 46 3B C8 89 75 D4 75 65 FF 4D 04 8A 06 84 C0 0F 85 AD F5 FF FF EB 64 FF 75 08 E8 ?? ?? ?? ?? EB 59 80 7D 03 00 7E 06 66 83 27 00 EB 03 C6 07 00 E8 ?? ?? ?? ?? C7 00 0C 00 00 00 EB 3E FF 75 08 E8 ?? ?? ?? ?? C7 45 A0 01 00 00 00 EB 2C E8 ?? ?? ?? ?? 80 7D FA 00 C7 00 0C 00 00 00 74 06 66 83 26 00 EB 16 C6 06 00 EB 11 53 EB AD 50 E8 ?? ?? ?? ?? 53 E8 ?? ?? ?? ?? 59 59 83 7D C4 01 5B 75 09 FF 75 E8 E8 ?? ?? ?? ?? 59 83 7D A0 01 75 1A E8 ?? ?? ?? ?? C7 00 16 00 00 00 33 C0 50 50 50 50 50 E8 ?? ?? ?? ?? 83 C4 14 80 7D 9C 00 74 07 8B 45 98 83 60 70 FD 8B 45 C8 8B 8D 8C 01 00 00 5F 33 CD 5E E8 ?? ?? ?? ?? 81 C5 90 01 00 00 C9 C3 }
	condition:
		$1
}

rule file_450_3_0 {
	meta:
		name = "__mbsncmp_l"
		size = 294
		refs = "000e ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 003f _strncmp 0069 __errno 0079 __invalid_parameter"
	strings:
		$1 = { 55 8B EC 83 EC 14 53 FF 75 14 8D 4D EC E8 ?? ?? ?? ?? 33 DB 39 5D 10 75 13 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 E9 E3 00 00 00 57 8B 7D F0 39 5F 08 75 26 FF 75 10 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 0C 38 5D F8 0F 84 BF 00 00 00 8B 4D F4 83 61 70 FD E9 B3 00 00 00 56 8B 75 08 3B F3 74 05 39 5D 0C 75 2B E8 ?? ?? ?? ?? 53 53 53 53 53 C7 00 16 00 00 00 E8 ?? ?? ?? ?? 83 C4 14 38 5D F8 74 07 8B 45 F4 83 60 70 FD B8 FF FF FF 7F EB 7A 66 0F B6 06 FF 4D 10 0F B7 C8 0F B6 C1 46 F6 44 38 1D 04 74 14 8A 06 3A C3 75 04 33 C9 EB 0A 33 D2 8A F1 46 8A D0 0F B7 CA 8B 45 0C 66 0F B6 00 FF 45 0C 0F B7 C0 0F B6 D0 F6 44 3A 1D 04 74 1D 8B 55 0C 8A 12 3A D3 88 55 FF 75 04 33 C0 EB 0D 33 D2 FF 45 0C 8A F0 8A 55 FF 0F B7 C2 66 3B C1 75 1D 66 3B CB 74 05 39 5D 10 75 94 38 5D F8 74 07 8B 45 F4 83 60 70 FD 33 C0 5E 5F 5B C9 C3 1B C0 83 E0 02 48 38 5D F8 74 F0 8B 4D F4 83 61 70 FD EB E7 }
	condition:
		$1
}

rule file_451_3_0 {
	meta:
		name = "__mbsncat_s_l"
		size = 631
		refs = "002e __errno 003d __invalid_parameter 0080 ??0_LocaleUpdate@@QAE@PAUlocaleinfo_struct@@@Z 0097 _strncat_s 00fb __ismbblead_l"
	strings:
		$1 = { 55 8B EC 83 EC 20 53 33 DB 39 5D 14 56 89 5D F4 75 11 39 5D 08 75 11 39 5D 0C 75 11 33 C0 E9 50 02 00 00 39 5D 08 74 05 39 5D 0C 77 1E E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 8B C6 E9 28 02 00 00 39 5D 14 57 8B 7D 10 74 25 3B FB 75 21 8B 45 08 88 18 E8 ?? ?? ?? ?? 6A 16 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 E9 C8 01 00 00 FF 75 18 8D 4D E0 E8 ?? ?? ?? ?? 8B 45 E4 39 58 08 75 27 FF 75 14 57 FF 75 0C FF 75 08 E8 ?? ?? ?? ?? 83 C4 10 38 5D EC 0F 84 CB 01 00 00 8B 4D E8 83 61 70 FD E9 BF 01 00 00 8B 45 0C 8B 75 08 89 45 FC 38 1E 74 06 46 FF 4D FC 75 F6 39 5D FC 75 11 8B 45 08 88 18 E8 ?? ?? ?? ?? 6A 16 E9 49 01 00 00 39 45 FC 73 4A 8D 46 FF 3B 45 08 89 45 F0 89 45 F8 72 24 8D 45 E0 50 8B 45 F8 0F B6 00 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 0B FF 4D F8 8B 45 F8 3B 45 08 73 DF 8B 45 F0 8B C8 2B 4D F8 F6 C1 01 74 0E FF 45 FC 8B F0 88 1E C7 45 F4 01 00 00 00 83 7D 14 FF 75 11 8A 07 88 06 46 47 3A C3 74 6A FF 4D FC 75 F1 EB 63 39 5D 14 76 5A 8D 45 E0 50 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 20 8D 47 01 38 18 74 2F 83 7D FC 02 76 34 8A 0F 88 0E 46 8B F8 8A 07 88 06 46 47 83 6D FC 02 EB 0F 8A 07 88 06 46 47 3A C3 74 1A FF 4D FC 74 15 FF 4D 14 75 B9 EB 0E 88 1E C7 45 F4 01 00 00 00 EB 03 89 5D FC 39 5D 14 75 02 88 1E 39 5D FC 0F 85 97 00 00 00 83 7D 14 FF 75 65 39 5D F4 74 0B E8 ?? ?? ?? ?? C7 00 2A 00 00 00 8B 45 0C 83 F8 01 76 35 8B 4D 08 8D 74 01 FE 3B F1 8B FE 72 19 8D 45 E0 50 0F B6 07 50 E8 ?? ?? ?? ?? 85 C0 59 59 74 06 4F 3B 7D 08 73 E7 8B C6 2B C7 A8 01 74 04 88 1E EB 0A 8B 45 0C 8B 4D 08 88 5C 01 FF 38 5D EC 74 07 8B 45 E8 83 60 70 FD 6A 50 58 EB 59 8B 45 08 88 18 E8 ?? ?? ?? ?? 6A 22 5E 53 53 53 53 53 89 30 E8 ?? ?? ?? ?? 83 C4 14 38 5D EC 74 07 8B 45 E8 83 60 70 FD 8B C6 EB 2D 39 5D F4 74 1A E8 ?? ?? ?? ?? 6A 2A 59 89 08 38 5D EC 7