private rule architecture {
	meta:
		bits = 64
		endianness = "little"
		architecture = "ARM"
	condition:
		true
}

rule file_0_0_0 {
	meta:
		name = "csinl"
		size = 92
		refs = "000c creall 001c cimagl 0028 _LCbuild 002c csinhl"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD 00 40 61 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 0B 40 FD 01 42 61 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_258_0_0 {
	meta:
		name = "cabs"
		size = 48
		refs = "000c cimag 001c creal 0024 hypot"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_1_0_0 {
	meta:
		name = "cabsl"
		size = 48
		refs = "000c cimagl 001c creall 0024 _hypot"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_504_0_4 {
	meta:
		name = "carg"
		size = 48
		refs = "000c creal 001c cimag 0024 atan2"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_579_1_4 {
	meta:
		name = "cargl"
		size = 48
		refs = "000c creall 001c cimagl 0024 atan2"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_212_0_4 {
	meta:
		name = "casin"
		size = 92
		refs = "000c creal 001c cimag 0028 _Cbuild 002c casinh"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD 00 40 61 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 0B 40 FD 01 42 61 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_478_0_2 {
	meta:
		name = "casinl"
		size = 92
		refs = "000c creall 001c cimagl 0028 _LCbuild 002c casinhl"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD 00 40 61 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 0B 40 FD 01 42 61 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_412_0_2 {
	meta:
		name = "catan"
		size = 92
		refs = "000c creal 001c cimag 0028 _Cbuild 002c catanh"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD 00 40 61 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 0B 40 FD 01 42 61 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_305_0_3 {
	meta:
		name = "catanl"
		size = 92
		refs = "000c creall 001c cimagl 0028 _LCbuild 002c catanhl"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD 00 40 61 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 0B 40 FD 01 42 61 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_393_0_4 {
	meta:
		name = "csin"
		size = 92
		refs = "000c creal 001c cimag 0028 _Cbuild 002c csinh"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD 00 40 61 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 0B 40 FD 01 42 61 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_51_0_0 {
	meta:
		name = "ctan"
		size = 92
		refs = "000c creal 001c cimag 0028 _Cbuild 002c ctanh"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD 00 40 61 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 0B 40 FD 01 42 61 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_462_0_0 {
	meta:
		name = "ctanl"
		size = 92
		refs = "000c creall 001c cimagl 0028 _LCbuild 002c ctanhl"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD 00 40 61 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 0B 40 FD 01 42 61 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_2_0_0 {
	meta:
		name = "??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
		size = 156
		refs = "0024 __acrt_locale_changed_data 0030 __acrt_initial_locale_pointers 0044 __acrt_getptd 0060 __acrt_update_locale_info 006c __acrt_update_multibyte_info"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 62 00 39 81 00 00 B4 28 24 40 A9 68 A6 00 A9 1B 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? C8 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 29 40 A9 69 AA 00 A9 13 00 00 14 ?? ?? ?? ?? 61 22 00 91 60 02 00 F9 08 48 40 F9 68 06 00 F9 09 44 40 F9 69 0A 00 F9 ?? ?? ?? ?? 60 02 40 F9 61 42 00 91 ?? ?? ?? ?? 69 02 40 F9 28 A9 43 B9 A8 00 08 37 08 01 1F 32 2A 00 80 52 28 A9 03 B9 6A 62 00 39 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_2_1_0 {
	meta:
		name = "??1_LocaleUpdate@@QEAA@XZ"
		size = 28
	strings:
		$1 = { 08 60 40 39 A8 00 00 34 0A 00 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_2_3_0 {
	meta:
		name = "__acrt_locale_changed"
		size = 20
		refs = "0000 __acrt_locale_changed_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 00 71 E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_643_99_2 {
	meta:
		name = "__acrt_can_use_vista_locale_apis"
		size = 52
		refs = "0008 ?candidate_modules@?1??try_get_CompareStringEx@@YAP6AHPEB_WK0H0HPEAU_nlsversioninfo@@PEAX_J@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0010 ??_C@_0BA@IHGNDAEB@CompareStringEx?$AA@ 0020 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 20 00 80 52 ?? ?? ?? ?? 1F 00 00 F1 E0 07 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_643_100_3 {
	meta:
		name = "__acrt_can_use_xstate_apis"
		size = 52
		refs = "0008 ?candidate_modules@?1??try_get_LocateXStateFeature@@YAP6APEAXPEAU_CONTEXT@@KPEAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0010 ??_C@_0BE@KINNKFDA@LocateXStateFeature?$AA@ 0020 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 E0 02 80 52 ?? ?? ?? ?? 1F 00 00 F1 E0 07 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_643_101_3 {
	meta:
		name = "__acrt_eagerly_load_locale_apis"
		size = 324
		refs = "0008 ?candidate_modules@?1??try_get_AreFileApisANSI@@YAP6AHXZXZ@4QBW4module_id@?A0x391cf84c@@B 0010 ??_C@_0BA@FHFNEAED@AreFileApisANSI?$AA@ 0020 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z 0024 ?candidate_modules@?1??try_get_CompareStringEx@@YAP6AHPEB_WK0H0HPEAU_nlsversioninfo@@PEAX_J@ZXZ@4QBW4module_id@?A0x391cf84c@@B 002c ??_C@_0BA@IHGNDAEB@CompareStringEx?$AA@ 0040 ?candidate_modules@?1??try_get_EnumSystemLocalesEx@@YAP6AHP6AHPEA_WK_J@ZK1PEAX@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0048 ??_C@_0BE@LJANKFHF@EnumSystemLocalesEx?$AA@ 005c ?candidate_modules@?1??try_get_GetDateFormatEx@@YAP6AHPEB_WKPEBU_SYSTEMTIME@@0PEA_WH0@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0064 ??_C@_0BA@EPCJIIPD@GetDateFormatEx?$AA@ 0078 ?candidate_modules@?1??try_get_GetLocaleInfoEx@@YAP6AHPEB_WKPEA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0080 ??_C@_0BA@ONOKGCMP@GetLocaleInfoEx?$AA@ 0094 ?candidate_modules@?1??try_get_GetTimeFormatEx@@YAP6AHPEB_WKPEBU_SYSTEMTIME@@0PEA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B 009c ??_C@_0BA@CIJJKCJJ@GetTimeFormatEx?$AA@ 00b0 ?candidate_modules@?1??try_get_GetUserDefaultLocaleName@@YAP6AHPEA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00b8 ??_C@_0BJ@PBCCBIPI@GetUserDefaultLocaleName?$AA@ 00cc ?candidate_modules@?1??try_get_IsValidLocaleName@@YAP6AHPEB_W@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00d4 ??_C@_0BC@CELBKLLA@IsValidLocaleName?$AA@ 00e8 ?candidate_modules@?1??try_get_LCMapStringEx@@YAP6AHPEB_WK0HPEA_WHPEAU_nlsversioninfo@@PEAX_J@ZXZ@4QBW4module_id@?A0x391cf84c@@B 00f0 ??_C@_0O@KKBNKAPF@LCMapStringEx?$AA@ 0104 ?candidate_modules@?1??try_get_LCIDToLocaleName@@YAP6AHKPEA_WHK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 010c ??_C@_0BB@CDHDDLLP@LCIDToLocaleName?$AA@ 0124 ?candidate_modules@?1??try_get_LocaleNameToLCID@@YAP6AKPEB_WK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0130 ??_C@_0BB@HBDEELFH@LocaleNameToLCID?$AA@"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 10 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 60 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 C0 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 E0 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 60 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 80 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 A0 02 80 52 ?? ?? ?? ?? C0 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_502_62_0 {
	meta:
		name = "__acrt_initialize_ptd"
		size = 76
		refs = "0008 ?destroy_fls@@YAXPEAX@Z 0010 __acrt_FlsAlloc 0014 ?__acrt_flsindex@@3KA 002c __acrt_getptd_noexit 0038 __acrt_uninitialize_ptd"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 31 61 00 00 54 00 00 80 52 07 00 00 14 ?? ?? ?? ?? 80 00 00 B5 00 00 80 52 ?? ?? ?? ?? FA FF FF 17 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_37_3 {
	meta:
		name = "__acrt_update_thread_multibyte_data"
		size = 32
		refs = "0008 __acrt_getptd 000c __acrt_current_multibyte_data 0014 ?update_thread_multibyte_data_internal@@YAPEAU__crt_multibyte_data@@QEAU__acrt_ptd@@QEAU1@@Z"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_606_0_2 {
	meta:
		name = "__dcrt_lowio_initialize_console_input"
		size = 72
		refs = "0008 ??_C@_1O@PNMIMBDD@?$AAC?$AAO?$AAN?$AAI?$AAN?$AA$?$AA?$AA@ 000c __imp_CreateFileW 0038 __dcrt_lowio_console_input_handle"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 06 00 80 D2 05 00 80 52 64 00 80 52 03 00 80 D2 62 00 80 52 01 00 B8 52 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_269_0_2 {
	meta:
		name = "__dcrt_lowio_initialize_console_output"
		size = 72
		refs = "0008 ??_C@_1BA@BALFACEM@?$AAC?$AAO?$AAN?$AAO?$AAU?$AAT?$AA$?$AA?$AA@ 000c __imp_CreateFileW 0038 __dcrt_lowio_console_output_handle"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 06 00 80 D2 05 00 80 52 64 00 80 52 03 00 80 D2 62 00 80 52 01 00 A8 52 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_652_0_3 {
	meta:
		name = "_heapchk"
		size = 64
		refs = "0008 __acrt_heap 000c __imp_HeapValidate"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 02 00 80 D2 01 00 80 52 20 01 3F D6 69 00 80 12 28 00 80 12 1F 00 00 71 20 01 88 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_257_0_0 {
	meta:
		name = "_heapmin"
		size = 56
		refs = "0008 __acrt_heap 000c __imp_HeapCompact"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 01 00 80 52 20 01 3F D6 08 00 80 12 1F 00 00 F1 00 01 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_612_0_3 {
	meta:
		name = "c16rtomb"
		size = 352
		refs = "0008 __security_push_cookie 000c ?internal_pst@?1??c16rtomb@@9@4U_Mbstatet@@A 0154 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 5F 00 00 F1 0A 01 82 9A 49 19 C0 39 4B 01 40 B9 60 00 00 B5 E0 03 00 91 01 00 80 52 29 02 00 34 08 80 84 52 28 00 08 0B 09 3D 00 53 3F FD 0F 71 48 01 00 54 08 80 9B 52 5F 0D 00 79 28 00 08 4B 01 01 0B 2A 28 60 19 12 68 02 00 35 01 00 00 39 0C 00 80 52 2C 00 00 14 00 00 80 92 39 00 00 14 08 00 85 52 28 00 08 0B 09 3D 00 53 3F FD 0F 71 A8 FE FF 54 28 00 80 52 09 F8 9A 52 48 0D 00 79 28 00 09 4B 09 55 16 53 49 01 00 B9 00 00 80 D2 2C 00 00 14 28 50 15 12 A8 00 00 35 28 7C 06 53 09 05 1A 32 2C 00 80 52 16 00 00 14 28 3C 10 12 A8 00 00 35 28 7C 0C 53 09 09 1B 32 4C 00 80 52 10 00 00 14 28 28 0B 12 A8 00 00 35 28 7C 12 53 09 0D 1C 32 6C 00 80 52 0A 00 00 14 28 14 06 12 A8 00 00 35 28 7C 18 53 09 11 1D 32 8C 00 80 52 04 00 00 14 28 7C 1E 53 09 15 1E 32 AC 00 80 52 09 00 00 39 0D 04 00 91 9F 01 00 71 8D 01 00 54 88 05 0C 0B 0D 04 00 91 0E 79 1F 53 CE 19 00 51 29 24 CE 1A 2A 15 00 12 4B 01 19 32 8C 05 00 51 AB 15 00 38 9F 01 00 71 2C FF FF 54 A0 01 00 CB ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_318_1_3 {
	meta:
		name = "initialize_c"
		size = 44
		refs = "0008 __acrt_atexit_table 0010 _initialize_onexit_table 0014 __acrt_at_quick_exit_table"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_93_4 {
	meta:
		name = "sync_legacy_variables_lk"
		size = 48
		refs = "0000 __acrt_current_locale_data 0008 __acrt_lconv 000c _pctype 0010 __mb_cur_max"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 7D 40 F9 ?? ?? ?? ?? 0A 01 40 F9 ?? ?? ?? ?? 09 09 40 B9 ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_145_0_2 {
	meta:
		name = "towctrans"
		size = 16
		refs = "0008 towupper 000c towlower"
	strings:
		$1 = { 3F 04 00 71 41 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_2_5_0 {
	meta:
		name = "_mbsdec_l"
		size = 176
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 0044 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 1E 00 00 14 53 FF FF B4 9F 02 13 EB 82 FF FF 54 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? EC 13 40 F9 88 09 40 B9 68 00 00 35 60 06 00 D1 0D 00 00 14 6B 06 00 D1 6B 05 00 D1 9F 02 0B EB A8 00 00 54 69 01 40 39 29 01 0C 8B 2A 65 40 39 4A FF 17 37 68 02 0B CB 09 01 40 92 6A 02 09 CB 40 05 00 D1 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_3_5_0 {
	meta:
		name = "_mbsncpy_l"
		size = 248
		refs = "0028 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 003c _errno 0048 _invalid_parameter_noinfo 0094 strncpy"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 36 00 00 91 61 00 00 91 E0 43 00 91 75 02 00 91 54 00 00 91 ?? ?? ?? ?? 53 00 00 B5 74 00 00 B5 56 02 00 B5 34 02 00 B4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 15 00 80 D2 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 A0 02 00 91 FD 7B C3 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 ED 13 40 F9 A8 09 40 B9 E8 00 00 35 82 02 00 91 C1 02 00 91 60 02 00 91 ?? ?? ?? ?? 15 00 00 91 ED FF FF 17 94 FD FF B4 CA 16 40 38 94 06 00 D1 48 01 0D 8B 09 65 40 39 C9 01 10 36 6A 02 00 39 CA 02 40 39 D6 06 00 91 6A 06 00 39 73 0A 00 91 AA FE FF 35 7F E2 1F 38 F4 FB FF B4 69 02 14 8B 7F 02 09 EB 80 FB FF 54 7F 16 00 38 FD FF FF 17 6A 16 00 38 2A FF FF 34 EB FF FF 17 }
	condition:
		$1
}

rule file_5_0_0 {
	meta:
		name = "normf"
		size = 52
		refs = "000c crealf 001c cimagf"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? F1 13 40 BD 10 08 20 1E 20 42 11 1F FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_6_0_0 {
	meta:
		name = "strncmp"
		size = 252
	strings:
		$1 = { 0B 00 80 D2 22 07 00 B4 5F 10 00 F1 A3 06 00 54 47 10 00 D1 67 06 00 B4 2C 0C 00 D1 0F 0C 00 D1 EF 11 00 91 E9 F1 DF 38 00 10 00 91 21 10 00 91 8C 11 00 91 09 04 00 34 88 F1 DF 38 3F 01 08 6B A1 03 00 54 EA 01 C0 39 0A 03 00 34 89 01 C0 39 5F 01 09 6B A1 02 00 54 ED 05 C0 39 0D 02 00 34 8A 05 C0 39 BF 01 0A 6B A1 01 00 54 EE 09 C0 39 0E 01 00 34 88 09 C0 39 DF 01 08 6B A1 00 00 54 6B 11 00 91 7F 01 07 EB C3 FC FF 54 15 00 00 14 09 F0 5F 38 28 F0 5F 38 09 00 00 14 09 E0 5F 38 28 E0 5F 38 06 00 00 14 09 D0 5F 38 28 D0 5F 38 03 00 00 14 09 C0 5F 38 28 C0 5F 38 20 01 08 4B 0B 00 00 14 0A 14 C0 38 4A 01 00 34 28 00 C0 39 5F 01 08 6B E1 00 00 54 6B 05 00 91 21 04 00 91 7F 01 02 EB 03 FF FF 54 00 00 80 52 C0 03 5F D6 09 F0 5F 38 28 00 40 39 F1 FF FF 17 }
	condition:
		$1
}

rule file_7_0_0 {
	meta:
		name = "??$common_fopen_s@D@@YAHQEAPEAU_iobuf@@QEBD1@Z"
		size = 96
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0038 ??$common_fsopen@D@@YAPEAU_iobuf@@QEBD0H@Z"
		altNames = "fopen_s"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 20 00 00 91 41 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 09 00 00 14 02 10 80 52 ?? ?? ?? ?? 60 02 00 F9 80 00 00 B5 ?? ?? ?? ?? 00 00 40 B9 02 00 00 14 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_7_1_0 {
	meta:
		name = "??$common_fopen_s@_W@@YAHQEAPEAU_iobuf@@QEB_W1@Z"
		size = 96
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0038 ??$common_fsopen@_W@@YAPEAU_iobuf@@QEB_W0H@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 20 00 00 91 41 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 09 00 00 14 02 10 80 52 ?? ?? ?? ?? 60 02 00 F9 80 00 00 B5 ?? ?? ?? ?? 00 00 40 B9 02 00 00 14 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_7_13_0 {
	meta:
		name = "_wfopen_s"
		size = 96
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0038 ??$common_fsopen@_W@@YAPEAU_iobuf@@QEB_W0H@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 20 00 00 91 41 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 09 00 00 14 02 10 80 52 ?? ?? ?? ?? 60 02 00 F9 80 00 00 B5 ?? ?? ?? ?? 00 00 40 B9 02 00 00 14 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_7_2_0 {
	meta:
		name = "??$common_fsopen@D@@YAPEAU_iobuf@@QEBD0H@Z"
		size = 192
		refs = "0020 _errno 002c _invalid_parameter_noinfo 0060 ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 0088 _openfile 009c ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 00a4 _unlock_file"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 14 00 00 91 33 00 00 91 55 00 00 11 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 1E 00 00 14 53 FF FF B4 68 02 C0 39 08 FF FF 34 88 02 C0 39 A8 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 F6 FF FF 17 A0 43 00 91 ?? ?? ?? ?? A3 0B 40 F9 83 00 00 B5 ?? ?? ?? ?? 08 03 80 52 F8 FF FF 17 BF 0F 00 F9 A2 02 00 11 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 13 00 00 91 B3 0F 00 F9 73 00 00 B5 A0 0B 40 F9 ?? ?? ?? ?? A0 0B 40 F9 ?? ?? ?? ?? 60 02 00 91 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_7_3_0 {
	meta:
		name = "?fin$0@?0???$common_fsopen@D@@YAPEAU_iobuf@@QEBD0H@Z@4HA"
		size = 52
		refs = "0014 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 0020 _unlock_file"
		altNames = "?fin$0@?0???$common_fsopen@_W@@YAPEAU_iobuf@@QEB_W0H@Z@4HA"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A8 0F 40 F9 88 00 00 B5 A0 0B 40 F9 ?? ?? ?? ?? 1F 20 03 D5 A0 0B 40 F9 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_7_4_0 {
	meta:
		name = "??$common_fsopen@_W@@YAPEAU_iobuf@@QEB_W0H@Z"
		size = 192
		refs = "0020 _errno 002c _invalid_parameter_noinfo 0060 ?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ 0088 _wopenfile 009c ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 00a4 _unlock_file"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 14 00 00 91 33 00 00 91 55 00 00 11 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 1E 00 00 14 53 FF FF B4 68 02 40 79 08 FF FF 34 88 02 40 79 A8 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 F6 FF FF 17 A0 43 00 91 ?? ?? ?? ?? A3 0B 40 F9 83 00 00 B5 ?? ?? ?? ?? 08 03 80 52 F8 FF FF 17 BF 0F 00 F9 A2 02 00 11 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 13 00 00 91 B3 0F 00 F9 73 00 00 B5 A0 0B 40 F9 ?? ?? ?? ?? A0 0B 40 F9 ?? ?? ?? ?? 60 02 00 91 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_7_6_0 {
	meta:
		name = "??$open_file@AEBQEBDAEBQEBDAEBHPEAU_iobuf@@@?$__crt_char_traits@D@@SAPEAU_iobuf@@AEBQEBD0AEBH$$QEAPEAU1@@Z"
		size = 20
		refs = "0010 _openfile"
	strings:
		$1 = { 63 00 40 F9 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_84_1_0 {
	meta:
		name = "??$common_wincmdln@_W@@YAPEA_WXZ"
		size = 96
		refs = "0000 _wcmdln 0008 ?empty_string@?1???$common_wincmdln@_W@@YAPEA_WXZ@4PA_WA"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0B 00 80 52 3F 01 00 F1 00 01 89 9A 0A 00 40 79 5F 81 00 71 68 00 00 54 AA 01 00 34 4B 01 00 34 5F 89 00 71 61 00 00 54 7F 01 00 71 EB 17 9F 1A 00 08 00 91 F6 FF FF 17 1F 81 00 71 88 00 00 54 00 08 00 91 08 00 40 79 88 FF FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_518_5_4 {
	meta:
		name = "??$get_module_file_name@$$TAEAY0BAF@DH@?$__crt_char_traits@D@@SAK$$QEA$$TAEAY0BAF@D$$QEAH@Z"
		size = 24
		refs = "0000 __imp_GetModuleFileNameA"
	strings:
		$1 = { ?? ?? ?? ?? 42 00 40 B9 ?? ?? ?? ?? 00 00 40 F9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_518_6_3 {
	meta:
		name = "??$get_module_file_name@$$TAEAY0BAF@_WH@?$__crt_char_traits@_W@@SAK$$QEA$$TAEAY0BAF@_W$$QEAH@Z"
		size = 24
		refs = "0000 __imp_GetModuleFileNameW"
	strings:
		$1 = { ?? ?? ?? ?? 42 00 40 B9 ?? ?? ?? ?? 00 00 40 F9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_222_13_4 {
	meta:
		name = "??$get_module_file_name@AEAPEAUHINSTANCE__@@AEAY0BAF@DK@?$__crt_char_traits@D@@SAKAEAPEAUHINSTANCE__@@AEAY0BAF@D$$QEAK@Z"
		size = 24
		refs = "0000 __imp_GetModuleFileNameA"
	strings:
		$1 = { ?? ?? ?? ?? 42 00 40 B9 ?? ?? ?? ?? 00 00 40 F9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_222_14_4 {
	meta:
		name = "??$get_module_file_name@AEAPEAUHINSTANCE__@@AEAY0BAF@_WK@?$__crt_char_traits@_W@@SAKAEAPEAUHINSTANCE__@@AEAY0BAF@_W$$QEAK@Z"
		size = 24
		refs = "0000 __imp_GetModuleFileNameW"
	strings:
		$1 = { ?? ?? ?? ?? 42 00 40 B9 ?? ?? ?? ?? 00 00 40 F9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_7_7_4 {
	meta:
		name = "??$open_file@AEBQEB_WAEBQEB_WAEBHPEAU_iobuf@@@?$__crt_char_traits@_W@@SAPEAU_iobuf@@AEBQEB_W0AEBH$$QEAPEAU1@@Z"
		size = 20
		refs = "0010 _wopenfile"
	strings:
		$1 = { 63 00 40 F9 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_28_4 {
	meta:
		name = "?try_get_AppPolicyGetProcessTerminationMethod@@YAP6AJPEAXPEAW4AppPolicyProcessTerminationMethod@@@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_AppPolicyGetProcessTerminationMethod@@YAP6AJPEAXPEAW4AppPolicyProcessTerminationMethod@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0CF@OJOFEIGO@AppPolicyGetProcessTerminationMe@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 10 00 91 80 03 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_29_0 {
	meta:
		name = "?try_get_AppPolicyGetShowDeveloperDiagnostic@@YAP6AJPEAXPEAW4AppPolicyShowDeveloperDiagnostic@@@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_AppPolicyGetShowDeveloperDiagnostic@@YAP6AJPEAXPEAW4AppPolicyShowDeveloperDiagnostic@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0CE@OICFMIKE@AppPolicyGetShowDeveloperDiagnos@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 10 00 91 C0 03 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_30_0 {
	meta:
		name = "?try_get_AppPolicyGetThreadInitializationType@@YAP6AJPEAXPEAW4AppPolicyThreadInitializationType@@@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_AppPolicyGetThreadInitializationType@@YAP6AJPEAXPEAW4AppPolicyThreadInitializationType@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0CF@NNDFDCOC@AppPolicyGetThreadInitialization@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 10 00 91 A0 03 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_31_0 {
	meta:
		name = "?try_get_AppPolicyGetWindowingModel@@YAP6AJPEAXPEAW4AppPolicyWindowingModel@@@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_AppPolicyGetWindowingModel@@YAP6AJPEAXPEAW4AppPolicyWindowingModel@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BL@ODDJNEDA@AppPolicyGetWindowingModel?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 10 00 91 E0 03 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_32_2 {
	meta:
		name = "?try_get_AreFileApisANSI@@YAP6AHXZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_AreFileApisANSI@@YAP6AHXZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BA@FHFNEAED@AreFileApisANSI?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 10 00 91 00 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_33_2 {
	meta:
		name = "?try_get_CompareStringEx@@YAP6AHPEB_WK0H0HPEAU_nlsversioninfo@@PEAX_J@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_CompareStringEx@@YAP6AHPEB_WK0H0HPEAU_nlsversioninfo@@PEAX_J@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BA@IHGNDAEB@CompareStringEx?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 20 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_34_2 {
	meta:
		name = "?try_get_EnumSystemLocalesEx@@YAP6AHP6AHPEA_WK_J@ZK1PEAX@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_EnumSystemLocalesEx@@YAP6AHP6AHPEA_WK_J@ZK1PEAX@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BE@LJANKFHF@EnumSystemLocalesEx?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 40 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_35_2 {
	meta:
		name = "?try_get_FlsAlloc@@YAP6AKP6AXPEAX@Z@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_FlsAlloc@@YAP6AKP6AXPEAX@Z@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_08KNHFBNJ@FlsAlloc?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 60 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_36_4 {
	meta:
		name = "?try_get_FlsFree@@YAP6AHK@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_FlsFree@@YAP6AHK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_07PEJMOBNF@FlsFree?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 80 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_37_0 {
	meta:
		name = "?try_get_FlsGetValue@@YAP6APEAXK@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_FlsGetValue@@YAP6APEAXK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0M@GDNOONDI@FlsGetValue?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 A0 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_38_3 {
	meta:
		name = "?try_get_FlsSetValue@@YAP6AHKPEAX@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_FlsSetValue@@YAP6AHKPEAX@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0M@JCPCPOEF@FlsSetValue?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 C0 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_39_3 {
	meta:
		name = "?try_get_GetActiveWindow@@YAP6APEAUHWND__@@XZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetActiveWindow@@YAP6APEAUHWND__@@XZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BA@HNOPNCHB@GetActiveWindow?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 E0 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_40_0 {
	meta:
		name = "?try_get_GetDateFormatEx@@YAP6AHPEB_WKPEBU_SYSTEMTIME@@0PEA_WH0@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetDateFormatEx@@YAP6AHPEB_WKPEBU_SYSTEMTIME@@0PEA_WH0@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BA@EPCJIIPD@GetDateFormatEx?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 00 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_41_4 {
	meta:
		name = "?try_get_GetEnabledXStateFeatures@@YAP6A_KXZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetEnabledXStateFeatures@@YAP6A_KXZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BJ@DIBIJBHA@GetEnabledXStateFeatures?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 20 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_42_2 {
	meta:
		name = "?try_get_GetLastActivePopup@@YAP6APEAUHWND__@@PEAU1@@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetLastActivePopup@@YAP6APEAUHWND__@@PEAU2@@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BD@HHGDFDBJ@GetLastActivePopup?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 40 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_43_4 {
	meta:
		name = "?try_get_GetLocaleInfoEx@@YAP6AHPEB_WKPEA_WH@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetLocaleInfoEx@@YAP6AHPEB_WKPEA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BA@ONOKGCMP@GetLocaleInfoEx?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 60 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_44_4 {
	meta:
		name = "?try_get_GetProcessWindowStation@@YAP6APEAUHWINSTA__@@XZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetProcessWindowStation@@YAP6APEAUHWINSTA__@@XZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BI@DFKBFLJE@GetProcessWindowStation?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 80 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_45_0 {
	meta:
		name = "?try_get_GetSystemTimePreciseAsFileTime@@YAP6AXPEAU_FILETIME@@@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetSystemTimePreciseAsFileTime@@YAP6AXPEAU_FILETIME@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BP@FPNJPEJC@GetSystemTimePreciseAsFileTime?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 10 00 91 A0 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_46_2 {
	meta:
		name = "?try_get_GetTimeFormatEx@@YAP6AHPEB_WKPEBU_SYSTEMTIME@@0PEA_WH@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetTimeFormatEx@@YAP6AHPEB_WKPEBU_SYSTEMTIME@@0PEA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BA@CIJJKCJJ@GetTimeFormatEx?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 C0 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_47_2 {
	meta:
		name = "?try_get_GetUserDefaultLocaleName@@YAP6AHPEA_WH@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetUserDefaultLocaleName@@YAP6AHPEA_WH@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BJ@PBCCBIPI@GetUserDefaultLocaleName?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 E0 01 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_48_3 {
	meta:
		name = "?try_get_GetUserObjectInformationW@@YAP6AHPEAXH0KPEAK@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetUserObjectInformationW@@YAP6AHPEAXH0KPEAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BK@DEKFELLI@GetUserObjectInformationW?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 00 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_49_4 {
	meta:
		name = "?try_get_GetXStateFeaturesMask@@YAP6AHPEAU_CONTEXT@@PEA_K@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_GetXStateFeaturesMask@@YAP6AHPEAU_CONTEXT@@PEA_K@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BG@IKLDMBLM@GetXStateFeaturesMask?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 20 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_50_4 {
	meta:
		name = "?try_get_InitializeCriticalSectionEx@@YAP6AHPEAU_RTL_CRITICAL_SECTION@@KK@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_InitializeCriticalSectionEx@@YAP6AHPEAU_RTL_CRITICAL_SECTION@@KK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BM@HCFOFFN@InitializeCriticalSectionEx?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 40 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_51_3 {
	meta:
		name = "?try_get_IsValidLocaleName@@YAP6AHPEB_W@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_IsValidLocaleName@@YAP6AHPEB_W@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BC@CELBKLLA@IsValidLocaleName?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 60 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_52_0 {
	meta:
		name = "?try_get_LCIDToLocaleName@@YAP6AHKPEA_WHK@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_LCIDToLocaleName@@YAP6AHKPEA_WHK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BB@CDHDDLLP@LCIDToLocaleName?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 A0 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_53_0 {
	meta:
		name = "?try_get_LCMapStringEx@@YAP6AHPEB_WK0HPEA_WHPEAU_nlsversioninfo@@PEAX_J@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_LCMapStringEx@@YAP6AHPEB_WK0HPEA_WHPEAU_nlsversioninfo@@PEAX_J@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0O@KKBNKAPF@LCMapStringEx?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 80 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_54_0 {
	meta:
		name = "?try_get_LocaleNameToLCID@@YAP6AKPEB_WK@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_LocaleNameToLCID@@YAP6AKPEB_WK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BB@HBDEELFH@LocaleNameToLCID?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 C0 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_55_3 {
	meta:
		name = "?try_get_LocateXStateFeature@@YAP6APEAXPEAU_CONTEXT@@KPEAK@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_LocateXStateFeature@@YAP6APEAXPEAU_CONTEXT@@KPEAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BE@KINNKFDA@LocateXStateFeature?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 E0 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_56_4 {
	meta:
		name = "?try_get_MessageBoxA@@YAP6AHPEAUHWND__@@PEBD1I@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_MessageBoxA@@YAP6AHPEAUHWND__@@PEBD1I@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0M@CHKKJDAI@MessageBoxA?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 00 03 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_57_3 {
	meta:
		name = "?try_get_MessageBoxW@@YAP6AHPEAUHWND__@@PEB_W1I@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_MessageBoxW@@YAP6AHPEAUHWND__@@PEB_W1I@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0M@DLDCCGNP@MessageBoxW?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 20 03 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_58_3 {
	meta:
		name = "?try_get_RoInitialize@@YAP6AJW4RO_INIT_TYPE@@@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_RoInitialize@@YAP6AJW4RO_INIT_TYPE@@@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0N@PPOMPGGK@RoInitialize?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 10 00 91 40 03 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_59_3 {
	meta:
		name = "?try_get_RoUninitialize@@YAP6AXXZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_RoUninitialize@@YAP6AXXZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0P@LLFHBIJD@RoUninitialize?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 10 00 91 60 03 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_60_0 {
	meta:
		name = "?try_get_SetThreadStackGuarantee@@YAP6AHPEAK@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_SetThreadStackGuarantee@@YAP6AHPEAK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BI@BKLFFAPO@SetThreadStackGuarantee?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 00 04 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_643_61_4 {
	meta:
		name = "?try_get_SystemFunction036@@YAP6AEPEAXK@ZXZ"
		size = 28
		refs = "0000 ?candidate_modules@?1??try_get_SystemFunction036@@YAP6AEPEAXK@ZXZ@4QBW4module_id@?A0x391cf84c@@B 0008 ??_C@_0BC@JEAENNKH@SystemFunction036?$AA@ 0018 ?try_get_function@@YAPEAXW4function_id@?A0x391cf84c@@QEBDQEBW4module_id@2@2@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 43 20 00 91 20 04 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_493_6_2 {
	meta:
		name = "__acrt_has_user_matherr"
		size = 40
		refs = "0000 __security_cookie 0004 ?user_matherr@@3V?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@A"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2A 15 00 12 29 01 08 CA 2A 2D CA 9A 5F 01 00 F1 E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_348_8_2 {
	meta:
		name = "_get_invalid_parameter_handler"
		size = 32
		refs = "0000 __security_cookie 0004 ?__acrt_invalid_parameter_handler@@3V?$dual_state_global@P6AXPEB_W00I_K@Z@__crt_state_management@@A"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2A 15 00 12 29 01 08 CA 20 2D CA 9A C0 03 5F D6 }
	condition:
		$1
}

rule file_571_0_0 {
	meta:
		name = "_get_printf_count_output"
		size = 32
		refs = "0000 __security_cookie 0008 ?enable_percent_n@@3_KA"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0A 01 40 B2 3F 01 0A EB E0 17 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_84_9_3 {
	meta:
		name = "_get_wide_winmain_command_line"
		size = 96
		refs = "0000 _wcmdln 0008 ?empty_string@?1???$common_wincmdln@_W@@YAPEA_WXZ@4PA_WA"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0B 00 80 52 3F 01 00 F1 00 01 89 9A 0A 00 40 79 5F 81 00 71 68 00 00 54 AA 01 00 34 4B 01 00 34 5F 89 00 71 61 00 00 54 7F 01 00 71 EB 17 9F 1A 00 08 00 91 F6 FF FF 17 1F 81 00 71 88 00 00 54 00 08 00 91 08 00 40 79 88 FF FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_220_3_4 {
	meta:
		name = "_guard_icall_checks_enforced"
		size = 28
		refs = "0000 __guard_check_icall_fptr 0008 _guard_check_icall_nop"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 3F 01 08 EB E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_348_14_3 {
	meta:
		name = "_set_invalid_parameter_handler"
		size = 52
		refs = "0000 __security_cookie 0004 ?__acrt_invalid_parameter_handler@@3V?$dual_state_global@P6AXPEB_W00I_K@Z@__crt_state_management@@A"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 15 00 12 6C 01 08 CA 08 08 80 52 08 01 0A 4B 09 2C C8 9A 28 01 0B CA ?? ?? ?? ?? 80 2D CA 9A C0 03 5F D6 }
	condition:
		$1
}

rule file_571_1_3 {
	meta:
		name = "_set_printf_count_output"
		size = 48
		refs = "0000 __security_cookie 0008 ?enable_percent_n@@3_KA"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0B 00 00 11 0A 01 40 B2 3F 01 0A EB E0 17 9F 1A 7F 01 00 71 48 11 9F 9A ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_318_0_2 {
	meta:
		name = "initialize_global_variables"
		size = 24
		refs = "0000 __acrt_initial_locale_data 0008 __acrt_current_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_7_10_0 {
	meta:
		name = "?valid@__crt_stdio_stream@@QEBA_NXZ"
		size = 16
		altNames = "??B?$__crt_scoped_stack_ptr@D@@QEBA_NXZ ??B?$__crt_scoped_stack_ptr@_W@@QEBA_NXZ ??B?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QEBA_NXZ ??B?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QEBA_NXZ ??B?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEBA_NXZ ??B?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QEBA_NXZ ?is_valid@?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QEBA_NXZ ?is_valid@?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEBA_NXZ ?is_valid@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEBA_NXZ"
	strings:
		$1 = { 08 00 40 F9 1F 01 00 F1 E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_8_0_0 {
	meta:
		name = "clogf"
		size = 456
		refs = "0010 crealf 0020 cimagf 002c _fdtest 008c atan2f 00ec _fperrraise 00f0 _FInf_C 0128 _fd_int 0168 log1pf 018c logf 01ac _FCbuild"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 E0 07 05 2D ?? ?? ?? ?? E1 2F 40 BD E0 13 00 BD E0 2B 40 BD ?? ?? ?? ?? E0 43 00 91 E0 17 00 BD ?? ?? ?? ?? 14 00 00 11 E0 53 00 91 ?? ?? ?? ?? 9F 0A 00 71 13 00 00 11 01 01 00 54 7F 06 00 71 61 00 00 54 E1 13 40 BD 54 00 00 14 E0 13 40 BD 01 40 20 1E 53 00 00 14 7F 0A 00 71 E1 00 00 54 9F 06 00 71 61 00 00 54 E1 17 40 BD 4B 00 00 14 E0 17 40 BD F7 FF FF 17 E1 03 42 2D E0 87 03 2D ?? ?? ?? ?? 9F 06 00 71 E0 1B 00 BD 64 1A 41 7A 20 08 00 54 F2 23 40 BD 48 22 20 1E 62 00 00 54 52 42 21 1E F2 13 00 BD F3 1F 40 BD 68 22 20 1E 62 00 00 54 73 42 21 1E F3 17 00 BD 40 22 33 1E A2 00 00 54 50 42 20 1E 72 42 20 1E 13 42 20 1E F2 4F 02 2D 48 22 20 1E 01 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 42 21 1E E1 1B 40 BD 2B 00 00 14 F0 05 00 1C 40 22 30 1E 68 03 00 54 B1 05 00 1C 20 22 33 1E 08 03 00 54 61 01 80 52 F3 CB 03 2D E0 83 00 91 ?? ?? ?? ?? 61 01 80 52 E0 73 00 91 ?? ?? ?? ?? F6 D3 43 2D F3 43 42 2D 11 3A 36 1E D0 2A 30 1E 72 3A 34 1E 35 0A 30 1E 91 2A 33 1E 55 56 11 1F 12 10 2E 1E 93 CA 34 1F D4 4E 16 1F A0 2A 34 1E ?? ?? ?? ?? 11 10 2C 1E 00 08 31 1E E2 FF FF 17 70 1A 32 1E 00 0A 30 1E ?? ?? ?? ?? E0 23 00 BD E0 13 40 BD ?? ?? ?? ?? F0 23 40 BD 11 10 2C 1E 00 02 11 1F D8 FF FF 17 01 40 20 1E ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 66 66 66 3F CD CC CC 3E }
	condition:
		$1
}

rule file_9_11_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAA@XZ"
		size = 40
		refs = "0014 _free_base"
		altNames = "??1?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAA@XZ ??1?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAA@XZ ??1?$scanset_buffer@_W@__crt_stdio_input@@QEAA@XZ ??1?$scanset_storage@$01@__crt_stdio_input@@QEAA@XZ ?release@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAAXXZ ?release@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAXXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 ?? ?? ?? ?? 7F 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_104_12_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAA@XZ"
		size = 40
		refs = "0014 free"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 ?? ?? ?? ?? 7F 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_104_13_4 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAA@XZ"
		size = 40
		refs = "0014 free"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 ?? ?? ?? ?? 7F 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_104_24_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAXXZ"
		size = 40
		refs = "0014 free"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 ?? ?? ?? ?? 7F 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_426_20_4 {
	meta:
		name = "?release@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAAXXZ"
		size = 40
		refs = "0014 free"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 ?? ?? ?? ?? 7F 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_17_0 {
	meta:
		name = "?CPtoLocaleName@@YAPEB_WH@Z"
		size = 80
		refs = "0018 ??_C@_1M@CLNBBOPM@?$AAz?$AAh?$AA?9?$AAT?$AAW?$AA?$AA@ 002c ??_C@_1M@JLOOOEGK@?$AAk?$AAo?$AA?9?$AAK?$AAR?$AA?$AA@ 0038 ??_C@_1M@BIBDDEMK@?$AAz?$AAh?$AA?9?$AAC?$AAN?$AA?$AA@ 0044 ??_C@_1M@HPNHIDJI@?$AAj?$AAa?$AA?9?$AAJ?$AAP?$AA?$AA@"
	strings:
		$1 = { 1F 90 0E 71 00 02 00 54 1F A0 0E 71 60 01 00 54 1F D4 0E 71 C0 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 1F D8 0E 71 E0 13 88 9A 09 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 06 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_9_21_0 {
	meta:
		name = "?detach@?$__crt_unique_heap_ptr@U__crt_multibyte_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_multibyte_data@@XZ"
		size = 16
		altNames = "?detach@?$__crt_unique_handle_t@Uprocess_handle_pair_traits@?A0xe43b7539@@@@QEAAPEAUprocess_handle_pair@?A0xe43b7539@@XZ ?detach@?$__crt_unique_handle_t@Ustream_traits@?A0xe43b7539@@@@QEAAPEAU_iobuf@@XZ ?detach@?$__crt_unique_heap_ptr@$$CBDU__crt_internal_free_policy@@@@QEAAPEBDXZ ?detach@?$__crt_unique_heap_ptr@$$CB_WU__crt_internal_free_policy@@@@QEAAPEB_WXZ ?detach@?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAPEADXZ ?detach@?$__crt_unique_heap_ptr@DU__crt_public_free_policy@@@@QEAAPEADXZ ?detach@?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAPEAEXZ ?detach@?$__crt_unique_heap_ptr@GU__crt_internal_free_policy@@@@QEAAPEAGXZ ?detach@?$__crt_unique_heap_ptr@JU__crt_internal_free_policy@@@@QEAAPEAJXZ ?detach@?$__crt_unique_heap_ptr@P6AXXZU__crt_internal_free_policy@@@@QEAAPEAP6AXXZXZ ?detach@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAPEAPEADXZ ?detach@?$__crt_unique_heap_ptr@PEAU__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAPEAPEAU__crt_stdio_stream_data@@XZ ?detach@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAPEAPEA_WXZ ?detach@?$__crt_unique_heap_ptr@U__acrt_ptd@@U__crt_internal_free_policy@@@@QEAAPEAU__acrt_ptd@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@U__crt_internal_free_policy@@@@QEAAPEAU__acrt_thread_parameter@@XZ ?detach@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEAAPEAU__acrt_thread_parameter@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_lc_time_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_lc_time_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_locale_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_locale_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_locale_pointers@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_locale_pointers@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_lowio_handle_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_lowio_handle_data@@XZ ?detach@?$__crt_unique_heap_ptr@U__crt_stdio_stream_data@@U__crt_internal_free_policy@@@@QEAAPEAU__crt_stdio_stream_data@@XZ ?detach@?$__crt_unique_heap_ptr@Ulconv@@U__crt_internal_free_policy@@@@QEAAPEAUlconv@@XZ ?detach@?$__crt_unique_heap_ptr@Uprocess_handle_pair@?A0xe43b7539@@U__crt_internal_free_policy@@@@QEAAPEAUprocess_handle_pair@?A0xe43b7539@@XZ ?detach@?$__crt_unique_heap_ptr@Utm@@U__crt_internal_free_policy@@@@QEAAPEAUtm@@XZ ?detach@?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAPEA_WXZ ?detach@?$__crt_unique_heap_ptr@_WU__crt_public_free_policy@@@@QEAAPEA_WXZ"
	strings:
		$1 = { 08 00 40 F9 1F 00 00 F9 00 01 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_23_0 {
	meta:
		name = "?getSystemCP@@YAHH@Z"
		size = 168
		refs = "0018 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 001c ?fSystemSet@@3HA 0034 __imp_GetOEMCP 0050 __imp_GetACP"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7F 0A 00 31 C1 00 00 54 28 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 07 00 00 14 7F 0E 00 31 21 01 00 54 28 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 13 00 00 11 07 00 00 14 7F 12 00 31 A1 00 00 54 28 00 80 52 ?? ?? ?? ?? E8 0F 40 F9 13 0D 40 B9 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_25_0 {
	meta:
		name = "?initialize@?$dual_state_global@PEAU__crt_multibyte_data@@@__crt_state_management@@QEAAXQEAU__crt_multibyte_data@@@Z"
		size = 52
		altNames = "?initialize@?$dual_state_global@P6AHPEAU_exception@@@Z@__crt_state_management@@QEAAXQ6AHPEAU_exception@@@Z@Z ?initialize@?$dual_state_global@P6AH_K@Z@__crt_state_management@@QEAAXQ6AH_K@Z@Z ?initialize@?$dual_state_global@P6AXH@Z@__crt_state_management@@QEAAXQ6AXH@Z@Z ?initialize@?$dual_state_global@PEAPEAD@__crt_state_management@@QEAAXQEAPEAD@Z ?initialize@?$dual_state_global@PEAPEA_W@__crt_state_management@@QEAAXQEAPEA_W@Z ?initialize@?$dual_state_global@PEAU__crt_locale_data@@@__crt_state_management@@QEAAXQEAU__crt_locale_data@@@Z"
	strings:
		$1 = { 0B 20 00 91 68 01 00 CB 09 1D 00 91 2A FD 43 D3 1F 00 0B EB ED 83 8A 9A 0C 00 80 D2 AD 00 00 B4 8C 05 00 91 01 84 00 F8 9F 01 0D EB A1 FF FF 54 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_28_0 {
	meta:
		name = "?setSBCS@@YAXPEAU__crt_multibyte_data@@@Z"
		size = 132
		refs = "0040 __acrt_initial_multibyte_data"
	strings:
		$1 = { 29 20 80 52 08 60 00 91 09 01 09 8B 1F 01 09 EB 60 00 00 54 1F 15 00 38 FD FF FF 17 C9 00 80 52 1F FC 00 29 08 30 00 91 1F 10 01 F9 09 05 09 8B 1F 01 09 EB 60 00 00 54 1F 25 00 78 FD FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 6C 61 00 91 0D 60 00 91 2A 20 80 52 88 15 40 38 4A 05 00 51 A8 15 00 38 AA FF FF 35 6B 65 04 91 0C 64 04 91 0A 20 80 52 69 15 40 38 4A 05 00 51 89 15 00 38 AA FF FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_29_0 {
	meta:
		name = "?setSBUpLow@@YAXPEAU__crt_multibyte_data@@@Z"
		size = 508
		refs = "000c __security_push_cookie 0014 __imp_GetCPInfo 00a8 __acrt_GetStringTypeA 00d0 __acrt_LCMapStringA 01ec __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 0B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 83 1C D1 ?? ?? ?? ?? 13 00 00 91 ?? ?? ?? ?? 60 06 40 B9 09 FD DF C8 E1 43 00 91 20 01 3F D6 40 0A 00 34 08 00 80 52 E9 A3 00 91 28 15 00 38 08 05 00 11 1F 01 04 71 A3 FF FF 54 0C 04 80 52 E8 5B 40 39 EC A3 00 39 E9 5B 00 91 88 01 00 34 2A 05 40 39 06 00 00 14 1F 01 04 71 C2 00 00 54 EB A3 00 91 6C 49 28 38 08 05 00 11 1F 01 0A 6B 49 FF FF 54 28 2D 40 38 C8 FE FF 35 65 06 40 B9 06 00 80 52 E4 A3 0C 91 03 20 80 52 E2 A3 00 91 21 00 80 52 00 00 80 D2 ?? ?? ?? ?? 67 06 40 B9 06 20 80 52 61 12 41 F9 E5 A3 04 91 FF 03 00 F9 04 20 80 52 E3 A3 00 91 02 20 80 52 00 00 80 D2 ?? ?? ?? ?? 67 06 40 B9 06 20 80 52 61 12 41 F9 E5 A3 08 91 FF 03 00 F9 04 20 80 52 E3 A3 00 91 02 40 80 52 00 00 80 D2 ?? ?? ?? ?? 2D 00 80 52 6C 66 04 91 E7 A3 0C 91 0E 00 80 D2 0F 20 80 52 E8 24 40 78 28 01 00 36 69 42 2D 8B EA A3 04 91 28 61 40 39 08 01 1C 32 28 61 00 39 C9 69 6A 38 89 01 00 39 0B 00 00 14 28 01 08 36 6B 42 2D 8B E6 A3 08 91 6A 61 40 39 4A 01 1B 32 6A 61 00 39 CB 69 66 38 8B 01 00 39 02 00 00 14 9F 01 00 39 AD 05 00 11 CE 05 00 91 8C 05 00 91 EF 05 00 51 0F FD FF 35 1D 00 00 14 2D 00 80 52 6E 66 04 91 0F 20 80 52 AB 7D 00 11 68 85 01 51 1F 65 00 71 E8 00 00 54 6A 42 2D 8B CB 01 00 39 49 61 40 39 29 01 1C 32 49 61 00 39 0C 00 00 14 6A 05 02 51 5F 65 00 71 08 01 00 54 6C 42 2D 8B A8 7D 03 11 C8 01 00 39 8B 61 40 39 6B 01 1B 32 8B 61 00 39 02 00 00 14 DF 01 00 39 AD 05 00 11 CE 05 00 91 EF 05 00 51 0F FD FF 35 FF 83 1C 91 ?? ?? ?? ?? F3 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_30_0 {
	meta:
		name = "?setmbcp_internal@@YAHH_NQEAU__acrt_ptd@@QEAPEAU__crt_multibyte_data@@@Z"
		size = 368
		refs = "0024 ?update_thread_multibyte_data_internal@@YAPEAU__crt_multibyte_data@@QEAU__acrt_ptd@@QEAU1@@Z 002c ?getSystemCP@@YAHH@Z 0054 _malloc_base 0070 memcpy 0080 _setmbcp_nolock 0090 _errno 00a4 _free_base 00c0 __acrt_set_locale_changed 00e8 __acrt_initial_multibyte_data 0120 __globallocalestatus 0154 ??$?RV<lambda_efdfa57d1f175319df784efa44bb7b81>@@AEAV<lambda_5f0a4c1567f8adc6734073e5d1e1b35c>@@V<lambda_2e8a7d3640ea6ccb4c2413664c2db6fd>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_efdfa57d1f175319df784efa44bb7b81>@@AEAV<lambda_5f0a4c1567f8adc6734073e5d1e1b35c>@@$$QEAV<lambda_2e8a7d3640ea6ccb4c2413664c2db6fd>@@@Z 0160 __acrt_initial_locale_pointers"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BC A9 FD 03 00 91 36 00 00 11 E2 0F 02 A9 61 00 40 F9 13 00 00 11 40 00 00 91 ?? ?? ?? ?? 60 02 00 11 ?? ?? ?? ?? E8 13 40 F9 15 00 00 11 08 45 40 F9 09 05 40 B9 BF 02 09 6B 61 00 00 54 00 00 80 52 18 00 00 14 00 45 80 D2 ?? ?? ?? ?? 14 00 00 91 93 02 00 91 F4 01 00 B4 E8 13 40 F9 02 45 80 52 01 45 40 F9 ?? ?? ?? ?? 81 02 00 91 9F 02 00 B9 A0 02 00 11 ?? ?? ?? ?? 15 00 00 11 BF 06 00 31 81 01 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 15 00 80 12 60 02 00 91 ?? ?? ?? ?? A0 02 00 11 FD 7B C4 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 56 00 00 35 ?? ?? ?? ?? E8 13 40 F9 0B 45 40 F9 69 FD 5F 88 2A 05 00 51 6A FD 08 88 A8 FF FF 35 BF 3B 03 D5 0A 01 00 35 E8 13 40 F9 ?? ?? ?? ?? 00 45 40 F9 ?? ?? ?? ?? 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 28 00 80 52 88 02 00 B9 E8 13 40 F9 13 00 80 D2 14 45 00 F9 E9 13 40 F9 28 A9 43 B9 28 FC 0F 37 ?? ?? ?? ?? ?? ?? ?? ?? C9 FB 07 37 E8 83 00 91 E9 A3 00 91 E8 27 03 A9 A8 00 80 52 A9 00 80 52 E8 A7 02 29 E3 53 00 91 E2 C3 00 91 E1 63 00 91 E0 43 00 91 ?? ?? ?? ?? 56 FA FF 34 E8 17 40 F9 ?? ?? ?? ?? 09 01 40 F9 ?? ?? ?? ?? CD FF FF 17 }
	condition:
		$1
}

rule file_9_31_0 {
	meta:
		name = "?update_thread_multibyte_data_internal@@YAPEAU__crt_multibyte_data@@QEAU__acrt_ptd@@QEAU1@@Z"
		size = 200
		refs = "001c __globallocalestatus 0040 __acrt_lock 006c __acrt_initial_multibyte_data 0080 _free_base 00a4 __acrt_unlock 00ac abort"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 35 00 00 91 89 AA 43 B9 ?? ?? ?? ?? ?? ?? ?? ?? 29 01 08 0A A9 00 00 34 88 4A 40 F9 68 00 00 B4 93 46 40 F9 1C 00 00 14 A0 00 80 52 ?? ?? ?? ?? 93 46 40 F9 7F 02 15 EB A0 02 00 54 B3 01 00 B4 68 FE 5F 88 09 05 00 51 69 FE 08 88 A8 FF FF 35 BF 3B 03 D5 E9 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 08 EB 60 00 00 54 60 02 00 91 ?? ?? ?? ?? 95 46 00 F9 B3 02 00 91 A9 FE 5F 88 29 05 00 11 A9 FE 08 88 A8 FF FF 35 BF 3B 03 D5 A0 00 80 52 ?? ?? ?? ?? 53 00 00 B5 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_9_32_0 {
	meta:
		name = "?fin$0@?0??update_thread_multibyte_data_internal@@YAPEAU__crt_multibyte_data@@QEAU__acrt_ptd@@QEAU1@@Z@4HA"
		size = 32
		refs = "000c __acrt_unlock"
		altNames = "_free_locale$fin$1"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A0 00 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_9_35_0 {
	meta:
		name = "__acrt_initialize_multibyte"
		size = 112
		refs = "000c ?initialized@?1??__acrt_initialize_multibyte@@9@4_NA 0018 _mbctype 001c __acrt_initial_multibyte_data 002c _mbcasemaps 0030 _mbctypes 0040 __acrt_getptd_head 0054 ?setmbcp_internal@@YAHH_NQEAU__acrt_ptd@@QEAPEAU__crt_multibyte_data@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 68 02 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 0A 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 26 00 A9 ?? ?? ?? ?? 02 00 00 91 40 00 80 12 63 42 00 91 21 00 80 52 ?? ?? ?? ?? 28 00 80 52 ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_40_0 {
	meta:
		name = "_getmbcp"
		size = 76
		refs = "0010 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? E9 13 40 F9 28 09 40 B9 68 00 00 34 20 05 40 B9 02 00 00 14 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_41_0 {
	meta:
		name = "_setmbcp"
		size = 56
		refs = "0010 __acrt_getptd 0020 __acrt_current_multibyte_data 0028 ?setmbcp_internal@@YAHH_NQEAU__acrt_ptd@@QEAPEAU__crt_multibyte_data@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 02 00 00 91 60 02 00 11 01 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_42_0 {
	meta:
		name = "_setmbcp_nolock"
		size = 664
		refs = "0014 __security_push_cookie 0020 ?getSystemCP@@YAHH@Z 0030 ?setSBCS@@YAXPEAU__crt_multibyte_data@@@Z 0038 ?__rgcode_page_info@@3PAUcode_page_info@@A 0078 __imp_IsValidCodePage 0090 __imp_GetCPInfo 0154 ?CPtoLocaleName@@YAPEB_WH@Z 0188 ?fSystemSet@@3HA 01b8 ?__rgctypeflag@@3PADA 0274 ?setSBUpLow@@YAXPEAU__crt_multibyte_data@@@Z 0280 __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 33 00 00 91 ?? ?? ?? ?? 14 00 00 11 94 00 00 35 60 02 00 91 ?? ?? ?? ?? 91 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 48 7D 40 D3 09 06 80 D2 09 7D 09 9B 28 69 75 B8 1F 01 14 6B 20 0A 00 54 4A 05 00 11 5F 15 00 71 03 FF FF 54 08 BD 9F 52 88 02 08 4B 1F 05 00 71 09 09 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 80 3E 00 53 20 01 3F D6 40 08 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E1 03 00 91 80 02 00 11 20 01 3F D6 00 07 00 34 29 20 80 52 68 62 00 91 09 01 09 8B 1F 01 09 EB 60 00 00 54 1F 15 00 38 FD FF FF 17 E8 03 40 B9 74 06 00 B9 7F 12 01 F9 1F 05 00 71 89 04 00 54 E8 1B 40 39 EB 1B 00 91 48 02 00 34 69 05 40 39 09 02 00 34 6A 01 40 39 5F 01 09 6B 68 01 00 54 28 01 0A 4B 0D 05 00 11 4C 05 00 11 6A 42 2C 8B AD 05 00 51 8C 05 00 11 49 61 40 39 29 01 1E 32 49 61 00 39 4D FF FF 35 6A 2D 40 38 0A FE FF 35 4C 00 80 52 CD 1F 80 52 6B 42 2C 8B AD 05 00 51 8C 05 00 11 68 61 40 39 08 01 1D 32 68 61 00 39 4D FF FF 35 60 06 40 B9 ?? ?? ?? ?? 28 00 80 52 68 0A 00 B9 60 12 01 F9 02 00 00 14 7F 0A 00 B9 C9 00 80 52 68 32 00 91 09 05 09 8B 1F 01 09 EB A0 07 00 54 1F 25 00 78 FD FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? E8 F4 FF 35 00 00 80 12 39 00 00 14 29 20 80 52 68 62 00 91 09 01 09 8B 1F 01 09 EB 60 00 00 54 1F 15 00 38 FD FF FF 17 ?? ?? ?? ?? 56 7D 40 D3 17 06 80 D2 A8 42 00 91 ?? ?? ?? ?? CE 22 17 9B 8C 00 80 52 CB 01 00 91 C9 85 40 38 A9 02 00 34 6D 05 40 39 6D 02 00 34 6F 01 40 39 FF 01 0D 6B C8 01 00 54 E6 05 00 11 DF 04 04 71 62 01 00 54 6A 42 26 8B E9 00 C0 39 EF 05 00 11 C6 04 00 11 48 61 40 39 28 01 08 2A 48 61 00 39 69 05 40 39 FF 01 09 6B A9 FE FF 54 69 2D 40 38 A9 FD FF 35 E7 04 00 91 8C 05 00 51 EC FC FF 35 28 00 80 52 74 A2 00 29 80 02 00 11 ?? ?? ?? ?? A8 12 00 91 CC 22 17 9B 60 12 01 F9 6B 32 00 91 CA 00 80 52 89 25 40 78 4A 05 00 51 69 25 00 78 AA FF FF 35 60 02 00 91 ?? ?? ?? ?? 00 00 80 52 FF 43 00 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_9_43_0 {
	meta:
		name = "memcpy_s"
		size = 168
		refs = "002c _errno 0038 _invalid_parameter_noinfo 0064 memcpy 0074 memset"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 34 00 00 91 55 00 00 91 73 00 00 91 73 00 00 B5 00 00 80 52 07 00 00 14 40 01 00 B5 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 BF 02 00 F1 80 12 53 FA A3 00 00 54 62 02 00 91 A1 02 00 91 ?? ?? ?? ?? EE FF FF 17 82 02 00 91 01 00 80 52 ?? ?? ?? ?? 95 00 00 B5 ?? ?? ?? ?? D3 02 80 52 05 00 00 14 9F 02 13 EB 82 FD FF 54 ?? ?? ?? ?? 53 04 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 E7 FF FF 17 }
	condition:
		$1
}

rule file_10_0_0 {
	meta:
		name = "_hypotf"
		size = 232
		refs = "0060 ??_C@_07HIGHJEEA@_hypotf?$AA@ 0080 _handle_errorf 00c4 _controlfp_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 10 C0 22 1E 31 C0 22 1E 12 C0 22 1E 33 C0 22 1E 08 02 66 9E F0 0B 00 FD F1 0B 00 FD 0A F9 40 92 28 02 66 9E 0B F9 40 92 48 FD 74 D3 1F FD 1F F1 69 FD 74 D3 A0 02 00 54 3F FD 1F F1 E0 02 00 54 70 0A 73 1E B3 04 00 5C 52 42 52 1F 54 C2 61 1E 80 22 73 1E 6D 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 46 00 80 52 45 04 80 52 24 02 80 52 63 00 80 52 02 F0 AF D2 01 03 80 52 ?? ?? ?? ?? 14 00 00 14 80 42 62 1E 12 00 00 14 48 CD 40 92 08 01 00 B4 3F FD 1F F1 61 00 00 54 68 CD 40 92 88 00 00 B4 10 08 20 1E 20 40 01 1F 09 00 00 14 02 00 80 52 FF 13 00 B9 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 08 F0 AF 52 E8 13 00 B9 00 01 27 1E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 E0 FF FF EF 47 }
	condition:
		$1
}

rule file_10_1_0 {
	meta:
		name = "infinityf_with_flags"
		size = 48
		refs = "0018 _controlfp_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 02 00 00 11 FF 13 00 B9 01 00 00 11 E0 43 00 91 ?? ?? ?? ?? 08 F0 AF 52 E8 13 00 B9 00 01 27 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_10_2_0 {
	meta:
		name = "raise_fpsw_flags"
		size = 36
		refs = "0018 _controlfp_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 02 00 00 11 FF 13 00 B9 01 00 00 11 E0 43 00 91 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_12_4_0 {
	meta:
		name = "??$common_set_variable_in_environment_nolock@D@@YAHQEADH@Z"
		size = 836
		refs = "0028 _errno 004c strchr 0064 _environ_table 0068 __dcrt_initial_narrow_environment 0088 ??$copy_environment@D@@YAPEAPEADQEAPEAD@Z 0098 _wenviron_table 00a8 __dcrt_get_or_create_narrow_environment_nolock 00e0 _calloc_base 00ec _free_base 0144 _strnicoll 01bc _recalloc_base 0288 strcpy_s 0298 __imp_SetEnvironmentVariableA 0340 _invoke_watson"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 23 00 F9 FD 7B BE A9 FD 03 00 91 16 00 00 91 38 00 00 11 D6 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 80 12 B6 00 00 14 D3 02 00 91 A1 07 80 52 F3 0B 00 F9 C0 02 00 91 ?? ?? ?? ?? 19 00 00 91 3F 03 00 F1 24 13 56 FA C0 14 00 54 28 07 C0 39 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 00 71 ?? ?? ?? ?? FA 17 9F 1A 9F 02 08 EB A1 00 00 54 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 ?? ?? ?? ?? 94 04 00 B5 ?? ?? ?? ?? D8 01 00 34 ?? ?? ?? ?? 88 01 00 B4 ?? ?? ?? ?? 40 12 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 9F 02 08 EB 41 03 00 54 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 ?? ?? ?? ?? 15 00 00 14 DA 10 00 35 01 01 80 D2 20 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 74 10 00 B4 ?? ?? ?? ?? 48 01 00 B5 01 01 80 D2 20 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 28 0F 00 B4 ?? ?? ?? ?? F4 0E 00 B4 88 02 40 F9 37 03 16 CB 95 02 00 91 C8 01 00 B4 A1 02 40 F9 E2 02 00 91 C0 02 00 91 ?? ?? ?? ?? C0 00 00 35 A8 02 40 F9 09 69 F7 38 3F F5 00 71 24 19 40 7A C0 03 00 54 B5 22 00 91 A9 02 40 F9 89 FE FF B5 A8 02 14 CB F5 0F 88 CB F5 03 F8 B7 88 02 40 F9 A8 03 00 B4 80 7A 75 F8 ?? ?? ?? ?? DA 02 00 34 88 7A 75 F8 08 01 00 B4 8B 0E 15 8B 69 05 40 F9 B5 06 00 91 69 01 00 F9 8B 0E 15 8B 6A 01 40 F9 6A FF FF B5 02 01 80 D2 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 00 00 80 D2 ?? ?? ?? ?? B4 03 00 B4 1B 00 00 14 A8 02 14 CB 15 FD 43 93 E6 FF FF 17 13 00 80 D2 FF 0B 00 F9 96 7A 35 F8 15 00 00 14 FA 07 00 35 F5 03 15 CB A1 0A 00 91 3F 00 15 EB 03 08 00 54 08 00 FC 92 3F 00 08 EB A2 07 00 54 02 01 80 D2 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 00 00 80 D2 ?? ?? ?? ?? D4 06 00 B4 88 0E 15 8B 13 00 80 D2 FF 0B 00 F9 16 7D 00 A9 ?? ?? ?? ?? 78 05 00 34 C8 02 C0 39 CA 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 54 01 16 CB 80 0A 00 91 21 00 80 D2 ?? ?? ?? ?? 15 00 00 91 75 00 00 B5 14 00 80 52 17 00 00 14 C2 02 00 91 81 0A 00 91 A0 02 00 91 ?? ?? ?? ?? 00 05 00 35 A8 02 16 CB 09 01 19 8B ?? ?? ?? ?? 2A 05 00 91 ?? ?? ?? ?? 5F F1 1F 38 09 FD DF C8 5F 03 00 71 E1 13 8A 9A A0 02 00 91 20 01 3F D6 20 01 00 35 ?? ?? ?? ?? 48 05 80 52 F3 0B 40 F9 08 00 00 B9 14 00 80 12 A0 02 00 91 ?? ?? ?? ?? 0A 00 00 14 A0 02 00 91 ?? ?? ?? ?? F3 0B 40 F9 14 00 80 52 05 00 00 14 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 14 00 80 12 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 FB 23 40 F9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_5_0 {
	meta:
		name = "??$common_set_variable_in_environment_nolock@_W@@YAHQEA_WH@Z"
		size = 832
		refs = "0024 _errno 0048 wcschr 0060 _wenviron_table 0064 __dcrt_initial_wide_environment 0084 ??$copy_environment@_W@@YAPEAPEA_WQEAPEA_W@Z 0094 _environ_table 00a4 __dcrt_get_or_create_wide_environment_nolock 00e0 _calloc_base 00ec _free_base 0144 _wcsnicoll 01bc _recalloc_base 028c wcscpy_s 029c __imp_SetEnvironmentVariableW 033c _invoke_watson"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FD 7B BE A9 FD 03 00 91 16 00 00 91 37 00 00 11 D6 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 80 12 B7 00 00 14 D3 02 00 91 A1 07 80 52 F3 0B 00 F9 C0 02 00 91 ?? ?? ?? ?? 15 00 00 91 BF 02 00 F1 A4 12 56 FA E0 14 00 54 A8 06 40 79 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 00 71 ?? ?? ?? ?? F8 17 9F 1A 9F 02 08 EB A1 00 00 54 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 ?? ?? ?? ?? 94 04 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? B7 01 00 34 88 01 00 B4 ?? ?? ?? ?? 60 12 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 9F 02 08 EB 41 03 00 54 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 ?? ?? ?? ?? 15 00 00 14 F8 10 00 35 68 01 00 B5 01 01 80 D2 20 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 68 10 00 B4 ?? ?? ?? ?? 34 01 00 B5 01 01 80 D2 20 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 34 0F 00 B4 14 0F 00 B4 A8 02 16 CB 19 FD 41 93 88 02 40 F9 95 02 00 91 C8 01 00 B4 A1 02 40 F9 22 03 00 91 C0 02 00 91 ?? ?? ?? ?? C0 00 00 35 A8 02 40 F9 09 79 79 78 3F F5 00 71 24 19 40 7A C0 03 00 54 B5 22 00 91 A9 02 40 F9 89 FE FF B5 A8 02 14 CB F5 0F 88 CB F5 03 F8 B7 88 02 40 F9 A8 03 00 B4 80 7A 75 F8 ?? ?? ?? ?? D8 02 00 34 88 7A 75 F8 08 01 00 B4 8B 0E 15 8B 69 05 40 F9 B5 06 00 91 69 01 00 F9 8B 0E 15 8B 6A 01 40 F9 6A FF FF B5 02 01 80 D2 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 00 00 80 D2 ?? ?? ?? ?? B4 03 00 B4 1B 00 00 14 A8 02 14 CB 15 FD 43 93 E6 FF FF 17 13 00 80 D2 FF 0B 00 F9 96 7A 35 F8 15 00 00 14 F8 07 00 35 F5 03 15 CB A1 0A 00 91 3F 00 15 EB 03 08 00 54 08 00 FC 92 3F 00 08 EB A2 07 00 54 02 01 80 D2 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 00 00 80 D2 ?? ?? ?? ?? D4 06 00 B4 88 0E 15 8B 13 00 80 D2 FF 0B 00 F9 16 7D 00 A9 ?? ?? ?? ?? 77 05 00 34 C8 02 C0 79 CA 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 16 CB 14 FD 41 93 80 0A 00 91 41 00 80 D2 ?? ?? ?? ?? 15 00 00 91 75 00 00 B5 14 00 80 52 16 00 00 14 C2 02 00 91 81 0A 00 91 A0 02 00 91 ?? ?? ?? ?? C0 04 00 35 28 07 00 91 A9 06 08 8B ?? ?? ?? ?? 1F 03 00 71 ?? ?? ?? ?? 3F E1 1F 78 E1 13 89 9A 09 FD DF C8 A0 02 00 91 20 01 3F D6 20 01 00 35 ?? ?? ?? ?? 48 05 80 52 F3 0B 40 F9 08 00 00 B9 14 00 80 12 A0 02 00 91 ?? ?? ?? ?? 0A 00 00 14 A0 02 00 91 ?? ?? ?? ?? F3 0B 40 F9 14 00 80 52 05 00 00 14 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 14 00 80 12 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_6_0 {
	meta:
		name = "??$copy_environment@D@@YAPEAPEADQEAPEAD@Z"
		size = 240
		refs = "0044 _calloc_base 0090 _free_base 00a4 strcpy_s 00d0 abort 00e8 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 73 00 00 B5 00 00 80 D2 29 00 00 14 68 02 40 F9 0A 00 80 D2 6B 02 00 91 88 00 00 B4 69 8D 40 F8 4A 05 00 91 C9 FF FF B5 01 01 80 D2 40 05 00 91 ?? ?? ?? ?? 14 00 00 91 34 04 00 B4 68 02 40 F9 08 03 00 B4 95 02 13 CB 6C 02 40 F9 89 01 C0 39 8B 01 00 91 89 00 00 34 6B 05 00 91 6A 01 C0 39 CA FF FF 35 76 01 0C CB C0 06 00 91 21 00 80 D2 ?? ?? ?? ?? A0 6A 33 F8 00 00 80 D2 ?? ?? ?? ?? A0 6A 73 F8 A0 02 00 B4 62 02 40 F9 C1 06 00 91 ?? ?? ?? ?? 60 01 00 35 68 8E 40 F8 68 FD FF B5 00 00 80 D2 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_7_0 {
	meta:
		name = "??$copy_environment@_W@@YAPEAPEA_WQEAPEA_W@Z"
		size = 244
		refs = "0044 _calloc_base 0094 _free_base 00a8 wcscpy_s 00d4 abort 00ec _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 73 00 00 B5 00 00 80 D2 2A 00 00 14 68 02 40 F9 0A 00 80 D2 6B 02 00 91 88 00 00 B4 69 8D 40 F8 4A 05 00 91 C9 FF FF B5 01 01 80 D2 40 05 00 91 ?? ?? ?? ?? 14 00 00 91 54 04 00 B4 68 02 40 F9 28 03 00 B4 95 02 13 CB 6C 02 40 F9 89 01 C0 79 8B 01 00 91 89 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 68 01 0C CB 16 FD 41 93 C0 06 00 91 41 00 80 D2 ?? ?? ?? ?? A0 6A 33 F8 00 00 80 D2 ?? ?? ?? ?? A0 6A 73 F8 A0 02 00 B4 62 02 40 F9 C1 06 00 91 ?? ?? ?? ?? 60 01 00 35 68 8E 40 F8 48 FD FF B5 00 00 80 D2 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_8_0 {
	meta:
		name = "??$ensure_current_environment_is_not_initial_environment_nolock@D@@YAXXZ"
		size = 56
		refs = "000c _environ_table 0010 __dcrt_initial_narrow_environment 0024 ??$copy_environment@D@@YAPEAPEADQEAPEAD@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 EB 61 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_12_9_0 {
	meta:
		name = "??$ensure_current_environment_is_not_initial_environment_nolock@_W@@YAXXZ"
		size = 56
		refs = "000c _wenviron_table 0010 __dcrt_initial_wide_environment 0024 ??$copy_environment@_W@@YAPEAPEA_WQEAPEA_W@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 EB 61 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_12_10_0 {
	meta:
		name = "??$find_in_environment_nolock@D@@YA_JQEBD_K@Z"
		size = 132
		refs = "0010 _environ_table 0038 _strnicoll"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 16 00 00 91 35 00 00 91 88 02 40 F9 93 02 00 91 C8 01 00 B4 61 02 40 F9 A2 02 00 91 C0 02 00 91 ?? ?? ?? ?? C0 00 00 35 68 02 40 F9 09 69 F5 38 3F F5 00 71 24 19 40 7A 40 01 00 54 73 22 00 91 69 02 40 F9 89 FE FF B5 68 02 14 CB E0 0F 88 CB FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 68 02 14 CB 00 FD 43 93 FA FF FF 17 }
	condition:
		$1
}

rule file_12_11_0 {
	meta:
		name = "??$find_in_environment_nolock@_W@@YA_JQEB_W_K@Z"
		size = 132
		refs = "0010 _wenviron_table 0038 _wcsnicoll"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 16 00 00 91 35 00 00 91 88 02 40 F9 93 02 00 91 C8 01 00 B4 61 02 40 F9 A2 02 00 91 C0 02 00 91 ?? ?? ?? ?? C0 00 00 35 68 02 40 F9 09 79 75 78 3F F5 00 71 24 19 40 7A 40 01 00 54 73 22 00 91 69 02 40 F9 89 FE FF B5 68 02 14 CB E0 0F 88 CB FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 68 02 14 CB 00 FD 43 93 FA FF FF 17 }
	condition:
		$1
}

rule file_12_14_0 {
	meta:
		name = "??$set_environment_variable@AEBQEADQEAD@?$__crt_char_traits@D@@SAHAEBQEAD$$QEBQEAD@Z"
		size = 24
		refs = "0000 __imp_SetEnvironmentVariableA"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 00 00 40 F9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_531_15_0 {
	meta:
		name = "??$find_next_file@PEAXPEAU_WIN32_FIND_DATAA@@@?$__crt_char_traits@D@@SAH$$QEAPEAX$$QEAPEAU_WIN32_FIND_DATAA@@@Z"
		size = 24
		refs = "0000 __imp_FindNextFileA"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 00 00 40 F9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_531_16_0 {
	meta:
		name = "??$find_next_file@PEAXPEAU_WIN32_FIND_DATAW@@@?$__crt_char_traits@_W@@SAH$$QEAPEAX$$QEAPEAU_WIN32_FIND_DATAW@@@Z"
		size = 24
		refs = "0000 __imp_FindNextFileW"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 00 00 40 F9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_79_5_4 {
	meta:
		name = "??$lseek_nolock@AEBHAEB_JH@?$__crt_integer_traits@_J@@SA_JAEBHAEB_J$$QEAH@Z"
		size = 16
		refs = "000c _lseeki64_nolock"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_15_3 {
	meta:
		name = "??$set_environment_variable@AEBQEA_WQEA_W@?$__crt_char_traits@_W@@SAHAEBQEA_W$$QEBQEA_W@Z"
		size = 24
		refs = "0000 __imp_SetEnvironmentVariableW"
	strings:
		$1 = { ?? ?? ?? ?? 21 00 40 F9 ?? ?? ?? ?? 00 00 40 F9 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_674_12_2 {
	meta:
		name = "??$tasctime_s@AEBQEADAEB_KPEAUtm@@@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEAUtm@@@Z"
		size = 16
		refs = "000c asctime_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_674_13_2 {
	meta:
		name = "??$tasctime_s@AEBQEA_WAEB_KPEAUtm@@@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEAUtm@@@Z"
		size = 16
		refs = "000c _wasctime_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_15_2 {
	meta:
		name = "??$tcscat_s@AEAPEADAEB_KPEAD@?$__crt_char_traits@D@@SAHAEAPEADAEB_K$$QEAPEAD@Z"
		size = 16
		refs = "000c strcat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_17_2 {
	meta:
		name = "??$tcscat_s@AEAPEA_WAEB_KPEA_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_K$$QEAPEA_W@Z"
		size = 16
		refs = "000c wcscat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_19_2 {
	meta:
		name = "??$tcscat_s@AEBQEADAEB_KAEAPEAD@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEAPEAD@Z"
		size = 16
		refs = "000c strcat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_20_0 {
	meta:
		name = "??$tcscat_s@AEBQEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEBQEBD@Z"
		size = 16
		refs = "000c strcat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_21_4 {
	meta:
		name = "??$tcscat_s@AEBQEADAEB_KPEBD@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEBD@Z"
		size = 16
		refs = "000c strcat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_22_4 {
	meta:
		name = "??$tcscat_s@AEBQEA_WAEB_KAEAPEA_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEAPEA_W@Z"
		size = 16
		refs = "000c wcscat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_23_4 {
	meta:
		name = "??$tcscat_s@AEBQEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_24_2 {
	meta:
		name = "??$tcscat_s@AEBQEA_WAEB_KPEB_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEB_W@Z"
		size = 16
		refs = "000c wcscat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_532_24_0 {
	meta:
		name = "??$tcscat_s@PEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEBQEBD@Z"
		size = 16
		refs = "000c strcat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_532_28_3 {
	meta:
		name = "??$tcscat_s@PEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscat_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_18_3 {
	meta:
		name = "??$tcscpy_s@AEAPEADAEA_KAEBQEBD@?$__crt_char_traits@D@@SAHAEAPEADAEA_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_18_3 {
	meta:
		name = "??$tcscpy_s@AEAPEADAEB_KAEAPEAD@?$__crt_char_traits@D@@SAHAEAPEADAEB_K0@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_18_2 {
	meta:
		name = "??$tcscpy_s@AEAPEADAEB_KAEBQEAD@?$__crt_char_traits@D@@SAHAEAPEADAEB_KAEBQEAD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_20_4 {
	meta:
		name = "??$tcscpy_s@AEAPEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAHAEAPEADAEB_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_20_3 {
	meta:
		name = "??$tcscpy_s@AEAPEAD_KAEBQEBD@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_21_4 {
	meta:
		name = "??$tcscpy_s@AEAPEA_WAEA_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEA_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_19_2 {
	meta:
		name = "??$tcscpy_s@AEAPEA_WAEB_KAEAPEA_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_K0@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_19_2 {
	meta:
		name = "??$tcscpy_s@AEAPEA_WAEB_KAEBQEA_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_KAEBQEA_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_21_2 {
	meta:
		name = "??$tcscpy_s@AEAPEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_9_2 {
	meta:
		name = "??$tcscpy_s@AEAPEA_W_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_10_2 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KAEAPEAD@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEAPEAD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_20_4 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KAEBQEAD@?$__crt_char_traits@D@@SAHAEBQEADAEB_K0@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_22_4 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_27_3 {
	meta:
		name = "??$tcscpy_s@AEBQEADAEB_KPEBD@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_11_2 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KAEAPEA_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEAPEA_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_21_2 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KAEBQEA_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K0@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_13_4 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_28_3 {
	meta:
		name = "??$tcscpy_s@AEBQEA_WAEB_KPEB_W@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_22_4 {
	meta:
		name = "??$tcscpy_s@PEADAEB_KAEAPEAD@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEAPEAD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_22_0 {
	meta:
		name = "??$tcscpy_s@PEADAEB_KAEAPEBD@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEAPEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_18_2 {
	meta:
		name = "??$tcscpy_s@PEADAEB_KAEBQEBD@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_19_0 {
	meta:
		name = "??$tcscpy_s@PEAD_KAEBQEBD@?$__crt_char_traits@D@@SAH$$QEAPEAD$$QEA_KAEBQEBD@Z"
		size = 16
		refs = "000c strcpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_23_3 {
	meta:
		name = "??$tcscpy_s@PEA_WAEB_KAEAPEA_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEAPEA_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_24_4 {
	meta:
		name = "??$tcscpy_s@PEA_WAEB_KAEAPEB_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEAPEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_20_2 {
	meta:
		name = "??$tcscpy_s@PEA_WAEB_KAEBQEB_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_27_21_2 {
	meta:
		name = "??$tcscpy_s@PEA_W_KAEBQEB_W@?$__crt_char_traits@_W@@SAH$$QEAPEA_W$$QEA_KAEBQEB_W@Z"
		size = 16
		refs = "000c wcscpy_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_14_0 {
	meta:
		name = "??$tcserror_s@PEAD_KAEBH@?$__crt_char_traits@D@@SAH$$QEAPEAD$$QEA_KAEBH@Z"
		size = 16
		refs = "000c strerror_s"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_15_4 {
	meta:
		name = "??$tcserror_s@PEA_W_KAEBH@?$__crt_char_traits@_W@@SAH$$QEAPEA_W$$QEA_KAEBH@Z"
		size = 16
		refs = "000c _wcserror_s"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_28_0 {
	meta:
		name = "??$tcsnicoll@AEAPEADAEBQEBDAEB_K@?$__crt_char_traits@D@@SAHAEAPEADAEBQEBDAEB_K@Z"
		size = 16
		refs = "000c _strnicoll"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_29_3 {
	meta:
		name = "??$tcsnicoll@AEAPEA_WAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAHAEAPEA_WAEBQEB_WAEB_K@Z"
		size = 16
		refs = "000c _wcsnicoll"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_26_2 {
	meta:
		name = "??$tcsnicoll@AEBQEBDAEAPEADAEB_K@?$__crt_char_traits@D@@SAHAEBQEBDAEAPEADAEB_K@Z"
		size = 16
		refs = "000c _strnicoll"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_27_4 {
	meta:
		name = "??$tcsnicoll@AEBQEB_WAEAPEA_WAEB_K@?$__crt_char_traits@_W@@SAHAEBQEB_WAEAPEA_WAEB_K@Z"
		size = 16
		refs = "000c _wcsnicoll"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_243_0 {
	meta:
		name = "??$tcstol@AEAPEBDPEAPEADH@?$__crt_char_traits@D@@SAJAEAPEBD$$QEAPEAPEAD$$QEAH@Z"
		size = 16
		refs = "000c strtol"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_610_129_3 {
	meta:
		name = "??$tcstol@AEAPEB_WPEAPEA_WH@?$__crt_char_traits@_W@@SAJAEAPEB_W$$QEAPEAPEA_W$$QEAH@Z"
		size = 16
		refs = "000c wcstol"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_245_3 {
	meta:
		name = "??$tcstol@PEBDPEAPEADH@?$__crt_char_traits@D@@SAJ$$QEAPEBD$$QEAPEAPEAD$$QEAH@Z"
		size = 16
		refs = "000c strtol"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_374_246_3 {
	meta:
		name = "??$tcstol@PEB_WPEAPEA_WH@?$__crt_char_traits@_W@@SAJ$$QEAPEB_W$$QEAPEAPEA_W$$QEAH@Z"
		size = 16
		refs = "000c wcstol"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_405_113_2 {
	meta:
		name = "??$tcstoull@AEAPEB_WPEAPEA_WH@?$__crt_char_traits@_W@@SA_KAEAPEB_W$$QEAPEAPEA_W$$QEAH@Z"
		size = 16
		refs = "000c wcstoull"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_28_4 {
	meta:
		name = "??$tcstoull@AEBQEAD$$TH@?$__crt_char_traits@D@@SA_KAEBQEAD$$QEA$$T$$QEAH@Z"
		size = 16
		refs = "000c strtoull"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_29_4 {
	meta:
		name = "??$tcstoull@AEBQEA_W$$TH@?$__crt_char_traits@_W@@SA_KAEBQEA_W$$QEA$$T$$QEAH@Z"
		size = 16
		refs = "000c wcstoull"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_368_65_2 {
	meta:
		name = "??$tcstoull@PEBDPEAPEADH@?$__crt_char_traits@D@@SA_K$$QEAPEBD$$QEAPEAPEAD$$QEAH@Z"
		size = 16
		refs = "000c strtoull"
	strings:
		$1 = { 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_18_0 {
	meta:
		name = "??$tdupenv_s_crt@PEAPEAD$$TAEBQEBD@?$__crt_char_traits@D@@SAH$$QEAPEAPEAD$$QEA$$TAEBQEBD@Z"
		size = 16
		refs = "000c _dupenv_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_19_2 {
	meta:
		name = "??$tdupenv_s_crt@PEAPEA_W$$TAEBQEB_W@?$__crt_char_traits@_W@@SAH$$QEAPEAPEA_W$$QEA$$TAEBQEB_W@Z"
		size = 16
		refs = "000c _wdupenv_s"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_20_2 {
	meta:
		name = "??$tfullpath@AEBQEADAEBQEBDAEB_K@?$__crt_char_traits@D@@SAPEADAEBQEADAEBQEBDAEB_K@Z"
		size = 16
		refs = "000c _fullpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_21_0 {
	meta:
		name = "??$tfullpath@AEBQEA_WAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAPEA_WAEBQEA_WAEBQEB_WAEB_K@Z"
		size = 16
		refs = "000c _wfullpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_22_2 {
	meta:
		name = "??$tgetpath@AEAPEADAEAPEADH@?$__crt_char_traits@D@@SAPEADAEAPEAD0$$QEAH@Z"
		size = 16
		refs = "000c __acrt_getpath"
	strings:
		$1 = { 42 00 80 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_22_4 {
	meta:
		name = "??$tgetpath@AEAPEADAEAPEAD_K@?$__crt_char_traits@D@@SAPEADAEAPEAD0$$QEA_K@Z"
		size = 16
		refs = "000c __acrt_getpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_23_4 {
	meta:
		name = "??$tgetpath@AEAPEA_WAEAPEA_WH@?$__crt_char_traits@_W@@SAPEA_WAEAPEA_W0$$QEAH@Z"
		size = 16
		refs = "000c __acrt_wgetpath"
	strings:
		$1 = { 42 00 80 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_23_4 {
	meta:
		name = "??$tgetpath@AEAPEA_WAEAPEA_W_K@?$__crt_char_traits@_W@@SAPEA_WAEAPEA_W0$$QEA_K@Z"
		size = 16
		refs = "000c __acrt_wgetpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_532_45_4 {
	meta:
		name = "??$tgetpath@AEAPEBDPEADH@?$__crt_char_traits@D@@SAPEADAEAPEBD$$QEAPEAD$$QEAH@Z"
		size = 16
		refs = "000c __acrt_getpath"
	strings:
		$1 = { 42 00 80 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_532_46_2 {
	meta:
		name = "??$tgetpath@AEAPEB_WPEA_WH@?$__crt_char_traits@_W@@SAPEA_WAEAPEB_W$$QEAPEA_W$$QEAH@Z"
		size = 16
		refs = "000c __acrt_wgetpath"
	strings:
		$1 = { 42 00 80 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_24_3 {
	meta:
		name = "??$tgetpath@AEBQEADAEAPEAD_K@?$__crt_char_traits@D@@SAPEADAEBQEADAEAPEAD$$QEA_K@Z"
		size = 16
		refs = "000c __acrt_getpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_475_25_3 {
	meta:
		name = "??$tgetpath@AEBQEA_WAEAPEA_W_K@?$__crt_char_traits@_W@@SAPEA_WAEBQEA_WAEAPEA_W$$QEA_K@Z"
		size = 16
		refs = "000c __acrt_wgetpath"
	strings:
		$1 = { 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_8_2 {
	meta:
		name = "??$tspawnve@HAEAPEBDAEAY03PEBD$$T@?$__crt_char_traits@D@@SA_J$$QEAHAEAPEBDAEAY03PEBD$$QEA$$T@Z"
		size = 16
		refs = "000c _spawnve"
	strings:
		$1 = { 63 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_9_3 {
	meta:
		name = "??$tspawnve@HAEAPEB_WAEAY03PEB_W$$T@?$__crt_char_traits@_W@@SA_J$$QEAHAEAPEB_WAEAY03PEB_W$$QEA$$T@Z"
		size = 16
		refs = "000c _wspawnve"
	strings:
		$1 = { 63 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_10_3 {
	meta:
		name = "??$tspawnvpe@HAEAPEBDAEAY03PEBD$$T@?$__crt_char_traits@D@@SA_J$$QEAHAEAPEBDAEAY03PEBD$$QEA$$T@Z"
		size = 16
		refs = "000c _spawnvpe"
	strings:
		$1 = { 63 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_464_11_3 {
	meta:
		name = "??$tspawnvpe@HAEAPEB_WAEAY03PEB_W$$T@?$__crt_char_traits@_W@@SA_J$$QEAHAEAPEB_WAEAY03PEB_W$$QEA$$T@Z"
		size = 16
		refs = "000c _wspawnvpe"
	strings:
		$1 = { 63 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_12_17_0 {
	meta:
		name = "??$tcschr@AEBQEA_WD@?$__crt_char_traits@_W@@SAPEA_WAEBQEA_W$$QEAD@Z"
		size = 16
		refs = "000c wcschr"
		altNames = "??$tcschr@AEAPEA_WD@?$__crt_char_traits@_W@@SAPEA_WAEAPEA_W$$QEAD@Z ??$tcschr@AEBQEB_WD@?$__crt_char_traits@_W@@SAPEB_WAEBQEB_W$$QEAD@Z ??$tcschr@PEA_WD@?$__crt_char_traits@_W@@SAPEA_W$$QEAPEA_W$$QEAD@Z"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_424_6_3 {
	meta:
		name = "??$output_debug_string@AEBQEBD@?$__crt_char_traits@D@@SAXAEBQEBD@Z"
		size = 20
		refs = "0000 __imp_OutputDebugStringA"
	strings:
		$1 = { ?? ?? ?? ?? 00 00 40 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_424_7_3 {
	meta:
		name = "??$output_debug_string@AEBQEB_W@?$__crt_char_traits@_W@@SAXAEBQEB_W@Z"
		size = 20
		refs = "0000 __imp_OutputDebugStringW"
	strings:
		$1 = { ?? ?? ?? ?? 00 00 40 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_645_6_3 {
	meta:
		name = "??$set_current_directory@AEBQEBD@?$__crt_char_traits@D@@SAHAEBQEBD@Z"
		size = 20
		refs = "0000 __imp_SetCurrentDirectoryA"
	strings:
		$1 = { ?? ?? ?? ?? 00 00 40 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_645_7_4 {
	meta:
		name = "??$set_current_directory@AEBQEB_W@?$__crt_char_traits@_W@@SAHAEBQEB_W@Z"
		size = 20
		refs = "0000 __imp_SetCurrentDirectoryW"
	strings:
		$1 = { ?? ?? ?? ?? 00 00 40 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_354_19_2 {
	meta:
		name = "??$tcsrchr@AEAPEA_WD@?$__crt_char_traits@_W@@SAPEA_WAEAPEA_W$$QEAD@Z"
		size = 16
		refs = "000c wcsrchr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_31_4 {
	meta:
		name = "??$tcsrchr@AEAPEB_WD@?$__crt_char_traits@_W@@SAPEB_WAEAPEB_W$$QEAD@Z"
		size = 16
		refs = "000c wcsrchr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_559_27_0 {
	meta:
		name = "??$tcsrchr@AEBQEA_WD@?$__crt_char_traits@_W@@SAPEA_WAEBQEA_W$$QEAD@Z"
		size = 16
		refs = "000c wcsrchr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_33_3 {
	meta:
		name = "??$tcsrchr@AEBQEB_WD@?$__crt_char_traits@_W@@SAPEB_WAEBQEB_W$$QEAD@Z"
		size = 16
		refs = "000c wcsrchr"
	strings:
		$1 = { 28 00 C0 39 00 00 40 F9 01 3D 00 53 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_28_3 {
	meta:
		name = "??$uninitialize_environment_internal@D@@YAXAEAPEAPEAD@Z"
		size = 28
		refs = "0000 __dcrt_initial_narrow_environment 0014 ??$free_environment@D@@YAXQEAPEAD@Z"
	strings:
		$1 = { ?? ?? ?? ?? 00 00 40 F9 ?? ?? ?? ?? 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_22_29_4 {
	meta:
		name = "??$uninitialize_environment_internal@_W@@YAXAEAPEAPEA_W@Z"
		size = 28
		refs = "0000 __dcrt_initial_wide_environment 0014 ??$free_environment@_W@@YAXQEAPEA_W@Z"
	strings:
		$1 = { ?? ?? ?? ?? 00 00 40 F9 ?? ?? ?? ?? 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_12_22_0 {
	meta:
		name = "??$tcslen@AEAPEAD@?$__crt_char_traits@D@@SA_KAEAPEAD@Z"
		size = 36
		altNames = "??$tcslen@AEAPEBD@?$__crt_char_traits@D@@SA_KAEAPEBD@Z ??$tcslen@AEBQEAD@?$__crt_char_traits@D@@SA_KAEBQEAD@Z ??$tcslen@AEBQEBD@?$__crt_char_traits@D@@SA_KAEBQEBD@Z ??$tcslen@PEAD@?$__crt_char_traits@D@@SA_K$$QEAPEAD@Z"
	strings:
		$1 = { 0B 00 40 F9 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 40 01 0B CB C0 03 5F D6 }
	condition:
		$1
}

rule file_12_23_0 {
	meta:
		name = "??$tcslen@AEAPEA_W@?$__crt_char_traits@_W@@SA_KAEAPEA_W@Z"
		size = 40
		altNames = "??$tcslen@AEAPEB_W@?$__crt_char_traits@_W@@SA_KAEAPEB_W@Z ??$tcslen@AEBQEA_W@?$__crt_char_traits@_W@@SA_KAEBQEA_W@Z ??$tcslen@AEBQEB_W@?$__crt_char_traits@_W@@SA_KAEBQEB_W@Z ??$tcslen@PEA_W@?$__crt_char_traits@_W@@SA_K$$QEAPEA_W@Z"
	strings:
		$1 = { 0B 00 40 F9 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 0B CB 00 FD 41 93 C0 03 5F D6 }
	condition:
		$1
}

rule file_12_69_0 {
	meta:
		name = "_invoke_watson_if_error"
		size = 36
		refs = "0020 _invoke_watson"
	strings:
		$1 = { 28 00 00 91 41 00 00 91 62 00 00 91 83 00 00 11 40 00 00 35 C0 03 5F D6 A4 00 00 91 00 01 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_13_1_0 {
	meta:
		name = "_mbctohira_l"
		size = 76
		refs = "0010 _ismbckata_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 40 01 00 34 68 72 90 52 7F 02 08 6B E8 00 00 54 E8 6F 90 52 7F 02 08 6B 62 00 00 54 73 86 02 51 02 00 00 14 73 8A 02 51 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_14_0_0 {
	meta:
		name = "cosh"
		size = 896
		refs = "003c _controlfp_s 005c _handle_nan 00a4 ??_C@_04HPJJNFIM@cosh?$AA@ 00c8 _handle_error 0118 ?two_to_jby32_trail_table@?1??splitexp@@9@9 0128 ?two_to_jby32_lead_table@?1??splitexp@@9@9 01fc ?cosh_tail@?1??cosh@@9@9 020c ?sinh_tail@?1??cosh@@9@9 0268 ?cosh_lead@?1??cosh@@9@9 0270 ?sinh_lead@?1??cosh@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 09 00 66 9E 0A C6 E7 D2 E0 0B 00 FD 28 F9 40 92 1F 01 0A EB 42 01 00 54 68 00 00 B5 00 10 6E 1E A9 00 00 14 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? F9 FF FF 17 0A FE EF D2 1F 01 0A EB E3 01 00 54 1F 01 0A EB 89 00 00 54 20 01 00 91 ?? ?? ?? ?? 9B 00 00 14 02 00 80 52 FF 13 00 B9 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 08 FE EF D2 E8 0B 00 F9 00 01 67 9E 92 00 00 14 15 40 60 1E 1F 01 09 EB 40 00 00 54 15 40 61 1E 10 12 00 5C A0 22 70 1E 8B 01 00 54 ?? ?? ?? ?? E1 03 67 9E ?? ?? ?? ?? 26 00 80 52 45 04 80 52 24 02 80 52 63 00 80 52 02 FE EF D2 61 02 80 52 ?? ?? ?? ?? 80 00 00 14 10 90 66 1E A0 22 70 1E 0B 09 00 54 31 10 00 5C 1A 10 6C 1E B2 0A 71 1E 48 22 60 1E 8D 00 00 54 52 2A 7A 1E 4A 02 78 1E 03 00 00 14 53 3A 7A 1E 6A 02 78 1E 54 01 62 1E E8 03 0A 4B F0 0E 00 5C 49 11 00 12 F1 0E 00 5C ?? ?? ?? ?? F2 0E 00 5C 99 D6 50 1F 15 01 62 1E ?? ?? ?? ?? B0 0E 00 5C ?? ?? ?? ?? 1B D9 69 FC ?? ?? ?? ?? 17 D9 69 FC 49 01 09 4B 28 7D 04 13 29 6D 48 0B 2A 7D 05 13 4B 05 00 51 68 F9 0F 11 B8 0A 71 1E 1F F5 1F 71 16 2B 79 1E D3 42 52 1F 12 0D 00 5C 74 4A 56 1F 13 0D 00 5C 91 4E 56 1F 35 6A 56 1F D1 0A 76 1E B4 62 51 1F F5 2A 7B 1E 96 2A 79 1E DC 5E 55 1F 28 01 00 54 68 7D 40 93 72 2B 7C 1E 09 FE E7 D2 28 D1 08 8B 10 01 67 9E E8 0B 00 F9 40 0A 70 1E 47 00 00 14 68 7D 4B 0B 0C FE E7 D2 73 2B 7C 1E 0A 7D 01 13 49 7D 40 93 88 D1 09 8B 69 01 0A 4B 2A 7D 40 93 E8 0B 00 F9 F1 0B 40 FD 08 FE E7 D2 08 D1 0A 8B 10 01 67 9E E8 0F 00 F9 74 0A 71 1E 80 0A 70 1E 36 00 00 14 A9 02 78 1E ?? ?? ?? ?? D2 08 00 5C ?? ?? ?? ?? D1 08 00 5C ?? ?? ?? ?? D9 08 00 5C 30 01 62 1E A6 3A 70 1E B0 08 00 5C DF 08 66 1E F3 47 52 1F 92 08 00 5C FA 43 59 1F 99 08 00 5C B1 08 00 5C 74 4A 5F 1F B3 08 00 5C D2 08 00 5C 95 4E 5F 1F D4 08 00 5C B6 52 5F 1F D5 08 00 5C D7 56 5F 1F 15 D9 69 FC ?? ?? ?? ?? 96 08 00 5C 14 D9 69 FC ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F8 5A 5F 1F F7 0B 66 1E 07 0B 77 1E 17 D9 69 FC ?? ?? ?? ?? 98 07 00 5C 16 D9 69 FC 5B 63 5F 1F 1A 10 6C 1E 90 0A 67 1E 7C 67 5F 1F 9D 47 5F 1F BE 4B 5F 1F D3 6B 5F 1F 7F 0A 7F 1E B1 42 5F 1F 92 46 46 1F 53 2A 75 1E F4 4E 5F 1F D5 52 47 1F D6 56 46 1F C0 2A 77 1E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 7E F8 B9 8F CE 33 86 40 FE 82 2B 65 47 15 47 40 00 00 00 FE 42 2E 96 3F 8E 27 AF E6 3D 47 CF 3D 65 97 73 8D 72 C1 56 3F 5E 90 AA B7 15 11 81 3F 4E 5D 54 55 55 55 A5 3F 7C 8F 54 55 55 55 C5 3F 8B A0 1E 92 25 41 6B 3D BE B7 DC 2B CB 11 E6 3D D7 FC 63 7F 4B 98 A9 3D 20 7B 5B 38 56 EE 21 3E C0 61 BE 0F 46 E6 5A 3E 11 90 07 19 A0 01 FA 3E E5 12 C2 16 6C C1 56 3F 7D 3E E1 A4 E3 1D C7 3E 02 55 55 55 55 55 A5 3F 80 EE 01 1A A0 01 2A 3F FD 10 11 11 11 11 81 3F 55 55 55 55 55 55 C5 3F 55 CB F1 69 50 7E 92 3E }
	condition:
		$1
}

rule file_14_1_0 {
	meta:
		name = "infinity_with_flags"
		size = 48
		refs = "0018 _controlfp_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 02 00 00 11 FF 13 00 B9 01 00 00 11 E0 43 00 91 ?? ?? ?? ?? 08 FE EF D2 E8 0B 00 F9 00 01 67 9E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_14_3_0 {
	meta:
		name = "scaleDouble_1"
		size = 36
	strings:
		$1 = { FF 43 00 D1 08 7C 40 93 09 FE E7 D2 28 D1 08 8B 10 01 67 9E E8 03 00 F9 00 0A 60 1E FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_14_4_0 {
	meta:
		name = "scaleDouble_2"
		size = 72
	strings:
		$1 = { FF 43 00 D1 08 7C 40 0B 0B FE E7 D2 0A 7D 01 13 49 7D 40 93 68 D1 09 8B 09 00 0A 4B 2A 7D 40 93 E8 03 00 F9 08 FE E7 D2 F0 03 40 FD 08 D1 0A 8B 11 01 67 9E E8 07 00 F9 12 0A 60 1E 40 0A 71 1E FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_14_5_0 {
	meta:
		name = "splitexp"
		size = 208
		refs = "0024 ?two_to_jby32_lead_table@?1??splitexp@@9@9 003c ?two_to_jby32_trail_table@?1??splitexp@@9@9"
	strings:
		$1 = { 10 08 62 1E 19 10 6C 1E 08 22 60 1E 8D 00 00 54 10 2A 79 1E 0B 02 78 1E 03 00 00 14 11 3A 79 1E 2B 02 78 1E ?? ?? ?? ?? 70 01 62 1E ?? ?? ?? ?? 15 04 00 5C 69 11 00 12 14 04 00 5C ?? ?? ?? ?? 1E D9 69 FC ?? ?? ?? ?? 1D D9 69 FC 69 01 09 4B 28 7D 04 13 29 6D 48 0B E8 03 0B 4B 12 01 62 1E 2A 7D 05 13 11 82 43 1F 0A 00 00 B9 3E 00 00 FD 53 0A 64 1E 7B 0A 61 1E 3A 6E 41 1F 56 53 55 1F 15 02 00 5C D7 56 5A 1F 16 02 00 5C F8 5A 5A 1F 57 0B 7A 1E 19 67 5A 1F 30 6F 57 1F 3A 42 41 1F B1 2B 7E 1E 58 77 51 1F 58 00 00 FD C0 03 5F D6 65 97 73 8D 72 C1 56 3F 5E 90 AA B7 15 11 81 3F 4E 5D 54 55 55 55 A5 3F 7C 8F 54 55 55 55 C5 3F }
	condition:
		$1
}

rule file_14_6_0 {
	meta:
		name = "val_with_flags"
		size = 44
		refs = "001c _controlfp_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 02 00 00 11 E0 0F 00 FD 01 00 00 11 FF 13 00 B9 E0 43 00 91 ?? ?? ?? ?? E0 0F 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_15_0_0 {
	meta:
		name = "_finitef"
		size = 36
	strings:
		$1 = { FF 43 00 D1 08 00 26 1E 09 F0 AF 52 E0 03 00 BD 08 79 00 12 08 01 09 4B 00 7D 1F 53 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_16_0_0 {
	meta:
		name = "frexp"
		size = 304
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0040 _ctrlfp 0068 _sptype 00a0 _except1 00cc _dsign 00f4 _decomp"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 E0 03 01 6D 13 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? E0 03 67 9E 37 00 00 14 75 07 00 58 A1 02 00 91 00 E0 93 D2 ?? ?? ?? ?? E8 3F 40 79 09 FE 8F 52 14 00 00 91 08 29 1C 12 1F 01 09 6B 21 03 00 54 E0 0B 40 FD 08 00 80 12 68 02 00 B9 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 1F 08 00 71 80 01 00 54 1F 0C 00 71 40 01 00 54 F1 0B 40 FD 10 10 6E 1E 00 01 80 52 21 2A 70 1E 20 42 60 1E E1 02 80 52 82 02 00 91 ?? ?? ?? ?? 1A 00 00 14 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? E0 0B 40 FD 15 00 00 14 F0 0B 40 FD 08 22 60 1E 41 01 00 54 00 42 60 1E ?? ?? ?? ?? C0 00 00 34 E0 0B 40 FD 7F 02 00 B9 61 02 00 5C 00 00 80 52 ED FF FF 17 F0 0B 40 FD 00 42 60 1E 60 02 00 91 ?? ?? ?? ?? A1 02 00 91 80 02 00 91 E0 0F 00 FD ?? ?? ?? ?? E0 0F 40 FD FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 1F 20 03 D5 00 9F C0 03 00 00 00 00 00 00 00 00 00 00 00 80 }
	condition:
		$1
}

rule file_17_1_0 {
	meta:
		name = "catanhl"
		size = 704
		refs = "0010 creall 0020 cimagl 002c _ldtest 00a0 _LZero_C 01c4 log1pl 0200 atan2 021c _fperrraise 0220 _LInf_C 0248 log 0294 _LCbuild"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BA A9 FD 03 00 91 E0 87 04 6D ?? ?? ?? ?? E1 2B 40 FD E0 0F 00 FD E0 27 40 FD ?? ?? ?? ?? E0 63 00 91 E0 0B 00 FD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 0A 00 71 21 02 00 54 1F 08 00 71 61 00 00 54 F2 0F 40 FD 1B 00 00 14 1F 04 00 71 01 01 00 54 F0 0B 40 FD 53 12 00 5C 71 12 00 5C F2 03 67 9E 08 22 60 1E 61 3E 71 1E 87 00 00 14 F2 0F 40 FD 41 42 60 1E 84 00 00 14 1F 08 00 71 E1 01 00 54 68 3E 00 53 1F 05 00 71 69 00 00 54 F2 0B 40 FD F8 FF FF 17 ?? ?? ?? ?? E8 3F 40 79 F2 03 67 9E ?? ?? ?? ?? 1F 01 11 72 11 42 61 1E 32 1E 72 1E E1 0B 40 FD 74 00 00 14 7F 06 00 71 C1 01 00 54 ?? ?? ?? ?? F2 0F 40 FD B3 0E 00 5C ?? ?? ?? ?? E8 2F 40 79 48 22 60 1E 30 42 61 1E F2 03 67 9E 31 0E 00 5C 12 3E 72 1E 1F 01 11 72 61 1E 71 1E 65 00 00 14 F3 47 41 6D E8 2F 40 79 74 42 61 1E F3 1F 00 FD 1F 01 11 72 F1 17 00 FD 95 1E 73 1E 28 22 60 1E F5 1B 00 FD C2 00 00 54 31 42 61 1E 33 00 80 52 F1 17 00 FD F1 0F 00 FD 05 00 00 14 93 42 60 1E 13 00 80 52 F3 1F 00 FD F3 0B 00 FD 70 0B 00 5C 00 22 71 1E C2 00 00 54 70 1A 71 1E 15 10 6E 1E B1 1A 71 1E 10 56 50 1F 07 00 00 14 00 22 75 1E 62 01 00 54 32 1A 73 1E 15 10 6E 1E 51 1A 73 1E 50 56 52 1F 68 22 60 1E 32 1A 70 1E F3 08 00 5C 11 09 00 5C 61 3E 71 1E 3A 00 00 14 10 10 6E 1E F0 23 00 FD 20 22 70 1E 40 03 00 54 12 3A 71 1E B0 0A 75 1E 14 10 62 1E 31 0A 74 1E 50 42 52 1F 20 1A 70 1E ?? ?? ?? ?? 10 10 6A 1E F5 23 40 FD F1 0F 40 FD 16 10 60 1E F4 17 40 FD 00 08 70 1E 31 2A 75 1E B3 3A 74 1E E0 13 00 FD E0 1B 40 FD 12 08 60 1E 21 CA 73 1F F2 0B 40 FD 40 0A 76 1E ?? ?? ?? ?? 11 10 6C 1E 01 08 71 1E 1C 00 00 14 68 22 60 1E E1 00 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? E1 0B 40 FD ?? ?? ?? ?? 15 00 00 14 14 10 62 1E B2 C2 61 1E 70 52 53 1F 11 C2 61 1E 33 C2 61 1E 60 1A 72 1E ?? ?? ?? ?? 01 10 60 1E E0 13 00 FD E0 1B 40 FD ?? ?? ?? ?? B1 02 00 5C 10 28 71 1E 11 10 6C 1E 01 0A 71 1E F1 1F 40 FD 28 22 60 1E 42 00 00 54 21 40 61 1E F2 13 40 FD 73 00 00 34 52 42 61 1E 02 00 00 14 21 40 61 1E 40 42 60 1E ?? ?? ?? ?? FD 7B C6 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 FB 21 F9 3F 7B 52 82 BD 3A FB CF 5F }
	condition:
		$1
}

rule file_53_0_0 {
	meta:
		name = "catanh"
		size = 704
		refs = "0010 creal 0020 cimag 002c _dtest 00a0 _Zero_C 01c4 log1p 0200 atan2 021c _fperrraise 0220 _Inf_C 0248 log 0294 _Cbuild"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BA A9 FD 03 00 91 E0 87 04 6D ?? ?? ?? ?? E1 2B 40 FD E0 0F 00 FD E0 27 40 FD ?? ?? ?? ?? E0 63 00 91 E0 0B 00 FD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 0A 00 71 21 02 00 54 1F 08 00 71 61 00 00 54 F2 0F 40 FD 1B 00 00 14 1F 04 00 71 01 01 00 54 F0 0B 40 FD 53 12 00 5C 71 12 00 5C F2 03 67 9E 08 22 60 1E 61 3E 71 1E 87 00 00 14 F2 0F 40 FD 41 42 60 1E 84 00 00 14 1F 08 00 71 E1 01 00 54 68 3E 00 53 1F 05 00 71 69 00 00 54 F2 0B 40 FD F8 FF FF 17 ?? ?? ?? ?? E8 3F 40 79 F2 03 67 9E ?? ?? ?? ?? 1F 01 11 72 11 42 61 1E 32 1E 72 1E E1 0B 40 FD 74 00 00 14 7F 06 00 71 C1 01 00 54 ?? ?? ?? ?? F2 0F 40 FD B3 0E 00 5C ?? ?? ?? ?? E8 2F 40 79 48 22 60 1E 30 42 61 1E F2 03 67 9E 31 0E 00 5C 12 3E 72 1E 1F 01 11 72 61 1E 71 1E 65 00 00 14 F3 47 41 6D E8 2F 40 79 74 42 61 1E F3 1F 00 FD 1F 01 11 72 F1 17 00 FD 95 1E 73 1E 28 22 60 1E F5 1B 00 FD C2 00 00 54 31 42 61 1E 33 00 80 52 F1 17 00 FD F1 0F 00 FD 05 00 00 14 93 42 60 1E 13 00 80 52 F3 1F 00 FD F3 0B 00 FD 70 0B 00 5C 00 22 71 1E C2 00 00 54 70 1A 71 1E 15 10 6E 1E B1 1A 71 1E 10 56 50 1F 07 00 00 14 00 22 75 1E 62 01 00 54 32 1A 73 1E 15 10 6E 1E 51 1A 73 1E 50 56 52 1F 68 22 60 1E 32 1A 70 1E F3 08 00 5C 11 09 00 5C 61 3E 71 1E 3A 00 00 14 10 10 6E 1E F0 23 00 FD 20 22 70 1E 40 03 00 54 12 3A 71 1E B0 0A 75 1E 14 10 62 1E 31 0A 74 1E 50 42 52 1F 20 1A 70 1E ?? ?? ?? ?? 10 10 6A 1E F5 23 40 FD F1 0F 40 FD 16 10 60 1E F4 17 40 FD 00 08 70 1E 31 2A 75 1E B3 3A 74 1E E0 13 00 FD E0 1B 40 FD 12 08 60 1E 21 CA 73 1F F2 0B 40 FD 40 0A 76 1E ?? ?? ?? ?? 11 10 6C 1E 01 08 71 1E 1C 00 00 14 68 22 60 1E E1 00 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? E1 0B 40 FD ?? ?? ?? ?? 15 00 00 14 14 10 62 1E B2 C2 61 1E 70 52 53 1F 11 C2 61 1E 33 C2 61 1E 60 1A 72 1E ?? ?? ?? ?? 01 10 60 1E E0 13 00 FD E0 1B 40 FD ?? ?? ?? ?? B1 02 00 5C 10 28 71 1E 11 10 6C 1E 01 0A 71 1E F1 1F 40 FD 28 22 60 1E 42 00 00 54 21 40 61 1E F2 13 40 FD 73 00 00 34 52 42 61 1E 02 00 00 14 21 40 61 1E 40 42 60 1E ?? ?? ?? ?? FD 7B C6 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 FB 21 F9 3F 7B 52 82 BD 3A FB CF 5F }
	condition:
		$1
}

rule file_18_0_0 {
	meta:
		name = "llrintl"
		size = 144
		refs = "0010 _ldtest 0028 nearbyintl 0044 _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? 00 03 00 34 08 04 00 51 1F 05 00 71 69 02 00 54 E0 0B 40 FD ?? ?? ?? ?? F0 0B 40 FD 12 40 60 1E F2 0F 00 FD 40 22 70 1E 80 00 00 54 00 04 80 52 ?? ?? ?? ?? F2 0F 40 FD B0 01 00 5C 00 22 72 1E C8 00 00 54 91 01 00 5C 40 22 71 1E 68 00 00 54 40 02 78 9E 04 00 00 14 20 00 80 52 ?? ?? ?? ?? 00 00 80 D2 FD 7B C2 A8 C0 03 5F D6 00 00 00 00 00 00 E0 C3 00 00 00 00 00 00 E0 43 }
	condition:
		$1
}

rule file_167_0_0 {
	meta:
		name = "llrint"
		size = 144
		refs = "0010 _dtest 0028 nearbyint 0044 _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? 00 03 00 34 08 04 00 51 1F 05 00 71 69 02 00 54 E0 0B 40 FD ?? ?? ?? ?? F0 0B 40 FD 12 40 60 1E F2 0F 00 FD 40 22 70 1E 80 00 00 54 00 04 80 52 ?? ?? ?? ?? F2 0F 40 FD B0 01 00 5C 00 22 72 1E C8 00 00 54 91 01 00 5C 40 22 71 1E 68 00 00 54 40 02 78 9E 04 00 00 14 20 00 80 52 ?? ?? ?? ?? 00 00 80 D2 FD 7B C2 A8 C0 03 5F D6 00 00 00 00 00 00 E0 C3 00 00 00 00 00 00 E0 43 }
	condition:
		$1
}

rule file_20_0_0 {
	meta:
		name = "_fdclass"
		size = 28
		refs = "0010 _fdtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 13 00 BD ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_20_1_0 {
	meta:
		name = "_fdpcomp"
		size = 96
		refs = "0010 _fdtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 02 2D ?? ?? ?? ?? 1F 08 00 71 E0 01 00 54 E0 53 00 91 ?? ?? ?? ?? 1F 08 00 71 60 01 00 54 F0 47 42 2D 00 22 31 1E 62 00 00 54 20 00 80 52 07 00 00 14 20 22 30 1E 89 00 80 52 48 00 80 52 20 31 88 1A 02 00 00 14 00 00 80 52 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_20_2_0 {
	meta:
		name = "_fdsign"
		size = 24
	strings:
		$1 = { FF 43 00 D1 E0 03 00 BD E8 07 40 79 00 01 11 12 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_4_0 {
	meta:
		name = "??$common_get_initial_environment@D@@YAPEAPEADXZ"
		size = 44
		refs = "000c __dcrt_initial_narrow_environment 0018 ??$common_get_or_create_environment_nolock@D@@YAPEAPEADXZ"
		altNames = "_get_initial_narrow_environment"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 60 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_5_0 {
	meta:
		name = "??$common_get_initial_environment@_W@@YAPEAPEA_WXZ"
		size = 44
		refs = "000c __dcrt_initial_wide_environment 0018 ??$common_get_or_create_environment_nolock@_W@@YAPEAPEA_WXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 60 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_545_0_4 {
	meta:
		name = "??$common_strdate@D@@YAPEADQEAD@Z"
		size = 44
		refs = "0014 ??$common_strdate_s@D@@YAHQEAD_K@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 21 01 80 D2 13 00 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_545_1_4 {
	meta:
		name = "??$common_strdate@_W@@YAPEA_WQEA_W@Z"
		size = 44
		refs = "0014 ??$common_strdate_s@_W@@YAHQEA_W_K@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 21 01 80 D2 13 00 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_381_0_2 {
	meta:
		name = "??$common_strtime@D@@YAPEADQEAD@Z"
		size = 44
		refs = "0014 ??$common_strtime_s@D@@YAHQEAD_K@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 21 01 80 D2 13 00 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_381_1_2 {
	meta:
		name = "??$common_strtime@_W@@YAPEA_WQEA_W@Z"
		size = 44
		refs = "0014 ??$common_strtime_s@_W@@YAHQEA_W_K@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 21 01 80 D2 13 00 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_502_45_2 {
	meta:
		name = "?destroy_fls@@YAXPEAX@Z"
		size = 44
		refs = "0014 ?destroy_ptd_array@@YAXQEAU__acrt_ptd@@@Z 001c _free_base"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 93 00 00 B4 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_81_4 {
	meta:
		name = "_get_initial_wide_environment"
		size = 44
		refs = "000c __dcrt_initial_wide_environment 0018 ??$common_get_or_create_environment_nolock@_W@@YAPEAPEA_WXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 60 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_545_4_4 {
	meta:
		name = "_strdate"
		size = 44
		refs = "0014 ??$common_strdate_s@D@@YAHQEAD_K@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 21 01 80 D2 13 00 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_381_4_3 {
	meta:
		name = "_strtime"
		size = 44
		refs = "0014 ??$common_strtime_s@D@@YAHQEAD_K@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 21 01 80 D2 13 00 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_545_6_4 {
	meta:
		name = "_wstrdate"
		size = 44
		refs = "0014 ??$common_strdate_s@_W@@YAHQEA_W_K@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 21 01 80 D2 13 00 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_381_6_4 {
	meta:
		name = "_wstrtime"
		size = 44
		refs = "0014 ??$common_strtime_s@_W@@YAHQEA_W_K@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 21 01 80 D2 13 00 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_6_0 {
	meta:
		name = "??$common_get_or_create_environment_nolock@D@@YAPEAPEADXZ"
		size = 76
		refs = "000c _environ_table 002c ??$common_initialize_environment_nolock@D@@YAHXZ 0034 ??$initialize_environment_by_cloning_nolock@D@@YAHXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 60 02 40 F9 40 01 00 B5 68 06 40 F9 68 00 00 B5 00 00 80 D2 06 00 00 14 ?? ?? ?? ?? 60 00 00 34 ?? ?? ?? ?? 60 FF FF 35 60 02 40 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_7_0 {
	meta:
		name = "??$common_get_or_create_environment_nolock@_W@@YAPEAPEA_WXZ"
		size = 76
		refs = "000c _environ_table 002c ??$common_initialize_environment_nolock@_W@@YAHXZ 0034 ??$initialize_environment_by_cloning_nolock@_W@@YAHXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 60 06 40 F9 40 01 00 B5 68 02 40 F9 68 00 00 B5 00 00 80 D2 06 00 00 14 ?? ?? ?? ?? 60 00 00 34 ?? ?? ?? ?? 60 FF FF 35 60 06 40 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_8_0 {
	meta:
		name = "??$common_initialize_environment_nolock@D@@YAHXZ"
		size = 124
		refs = "000c _environ_table 0020 __acrt_initialize_multibyte 0024 __dcrt_get_narrow_environment_from_os 003c ??$create_environment@D@@YAQEAPEADQEAD@Z 004c __dcrt_initial_narrow_environment 0060 _free_base"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 B4 00 00 80 52 15 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 14 00 80 12 0C 00 00 14 60 02 00 91 ?? ?? ?? ?? 60 00 00 B5 14 00 80 12 05 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 14 00 80 52 00 00 80 D2 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_9_0 {
	meta:
		name = "??$common_initialize_environment_nolock@_W@@YAHXZ"
		size = 120
		refs = "000c _wenviron_table 0020 __dcrt_get_wide_environment_from_os 0038 ??$create_environment@_W@@YAQEAPEA_WQEA_W@Z 0048 __dcrt_initial_wide_environment 005c _free_base"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 B4 00 00 80 52 14 00 00 14 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 14 00 80 12 0C 00 00 14 60 02 00 91 ?? ?? ?? ?? 60 00 00 B5 14 00 80 12 05 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 14 00 80 52 00 00 80 D2 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_10_0 {
	meta:
		name = "??$count_variables_in_environment_block@D@@YA?B_KQEAD@Z"
		size = 56
	strings:
		$1 = { 08 00 C0 39 09 00 80 D2 48 01 00 34 1F F5 00 71 40 00 00 54 29 05 00 91 88 00 00 34 00 04 00 91 08 00 C0 39 C8 FF FF 35 08 1C C0 38 08 FF FF 35 20 01 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_11_0 {
	meta:
		name = "??$count_variables_in_environment_block@_W@@YA?B_KQEA_W@Z"
		size = 84
	strings:
		$1 = { 0D 00 00 91 A8 01 40 79 00 00 80 D2 28 02 00 34 08 3D 00 53 1F F5 00 71 40 00 00 54 00 04 00 91 AA 01 00 91 08 3D 00 13 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0D CB 4B FD 41 93 6C 05 00 91 AD 05 0C 8B A8 01 40 79 48 FE FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_12_0 {
	meta:
		name = "??$create_environment@D@@YAQEAPEADQEAD@Z"
		size = 284
		refs = "0054 _calloc_base 00b0 strcpy_s 00c4 _free_base 00d4 ??$free_environment@D@@YAXQEAPEAD@Z 0118 _invoke_watson"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 68 02 C0 39 69 02 00 91 0A 00 80 D2 48 01 00 34 1F F5 00 71 40 00 00 54 4A 05 00 91 88 00 00 34 29 05 00 91 28 01 C0 39 C8 FF FF 35 28 1D C0 38 08 FF FF 35 01 01 80 D2 40 05 00 91 ?? ?? ?? ?? 14 00 00 91 34 04 00 B4 95 02 00 91 68 02 C0 39 E8 03 00 34 6A 02 00 91 0B 1D 00 13 8B 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4A 01 13 CB 56 05 00 91 7F F5 00 71 C0 01 00 54 21 00 80 D2 C0 02 00 91 ?? ?? ?? ?? 17 00 00 91 77 01 00 B4 62 02 00 91 C1 02 00 91 ?? ?? ?? ?? 80 02 00 35 B7 02 00 F9 00 00 80 D2 B5 22 00 91 ?? ?? ?? ?? D3 02 13 8B E6 FF FF 17 80 02 00 91 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 14 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_13_0 {
	meta:
		name = "??$create_environment@_W@@YAQEAPEA_WQEA_W@Z"
		size = 320
		refs = "0070 _calloc_base 00d4 wcscpy_s 00e8 _free_base 00f8 ??$free_environment@_W@@YAXQEAPEA_W@Z 013c _invoke_watson"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 88 02 40 79 8E 02 00 91 0D 00 80 D2 28 02 00 34 08 3D 00 53 1F F5 00 71 40 00 00 54 AD 05 00 91 CA 01 00 91 08 3D 00 13 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0E CB 4B FD 41 93 6C 05 00 91 CE 05 0C 8B C8 01 40 79 48 FE FF 35 01 01 80 D2 A0 05 00 91 ?? ?? ?? ?? 13 00 00 91 73 04 00 B4 75 02 00 91 88 02 40 79 28 04 00 34 0C 3D 00 53 89 3D 00 13 8B 02 00 91 89 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 68 01 14 CB 0B FD 41 93 76 05 00 91 9F F5 00 71 C0 01 00 54 41 00 80 D2 C0 02 00 91 ?? ?? ?? ?? 17 00 00 91 77 01 00 B4 82 02 00 91 C1 02 00 91 ?? ?? ?? ?? 80 02 00 35 B7 02 00 F9 00 00 80 D2 B5 22 00 91 ?? ?? ?? ?? 94 06 16 8B E4 FF FF 17 60 02 00 91 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 13 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_22_14_0 {
	meta:
		name = "??$free_environment@D@@YAXQEAPEAD@Z"
		size = 68
		refs = "0024 _free_base"
		altNames = "??$free_environment@_W@@YAXQEAPEA_W@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 53 01 00 B4 68 02 40 F9 74 02 00 91 A8 00 00 B4 00 01 00 91 ?? ?? ?? ?? 88 8E 40 F8 A8 FF FF B5 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_18_0 {
	meta:
		name = "??$initialize_environment_by_cloning_nolock@D@@YAHXZ"
		size = 228
		refs = "0010 _wenviron_table 002c __imp_WideCharToMultiByte 006c _calloc_base 00b0 __dcrt_set_variable_in_narrow_environment_nolock 00b8 _free_base"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 73 00 00 B5 00 00 80 12 2A 00 00 14 68 02 40 F9 E8 04 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 62 02 40 F9 2A FD DF C8 07 00 80 D2 06 00 80 D2 05 00 80 52 04 00 80 D2 03 00 80 12 01 00 80 52 00 00 80 52 40 01 3F D6 15 7C 40 93 F5 FD FF B4 21 00 80 D2 A0 02 00 91 ?? ?? ?? ?? 14 00 00 91 34 03 00 B4 ?? ?? ?? ?? 62 02 40 F9 09 FD DF C8 A5 02 00 11 07 00 80 D2 06 00 80 D2 84 02 00 91 03 00 80 12 01 00 80 52 00 00 80 52 20 01 3F D6 A0 01 00 34 01 00 80 52 80 02 00 91 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 68 8E 40 F8 88 FB FF B5 00 00 80 52 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 80 02 00 91 ?? ?? ?? ?? CF FF FF 17 }
	condition:
		$1
}

rule file_22_19_0 {
	meta:
		name = "??$initialize_environment_by_cloning_nolock@_W@@YAHXZ"
		size = 212
		refs = "0010 _environ_table 002c __imp_MultiByteToWideChar 0064 _calloc_base 00a0 __dcrt_set_variable_in_wide_environment_nolock 00a8 _free_base"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 73 00 00 B5 00 00 80 12 26 00 00 14 68 02 40 F9 68 04 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 62 02 40 F9 2A FD DF C8 05 00 80 52 04 00 80 D2 03 00 80 12 01 00 80 52 00 00 80 52 40 01 3F D6 15 7C 40 93 35 FE FF B4 41 00 80 D2 A0 02 00 91 ?? ?? ?? ?? 14 00 00 91 F4 02 00 B4 ?? ?? ?? ?? 62 02 40 F9 09 FD DF C8 A5 02 00 11 84 02 00 91 03 00 80 12 01 00 80 52 00 00 80 52 20 01 3F D6 A0 01 00 34 01 00 80 52 80 02 00 91 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 68 8E 40 F8 08 FC FF B5 00 00 80 52 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 80 02 00 91 ?? ?? ?? ?? D3 FF FF 17 }
	condition:
		$1
}

rule file_22_26_0 {
	meta:
		name = "??$uninitialize@A6AXAEAPEAPEAD@Z@?$dual_state_global@PEAPEAD@__crt_state_management@@QEAAXA6AXAEAPEAPEAD@Z@Z"
		size = 88
		refs = "0024 __guard_check_icall_fptr"
		altNames = "??$uninitialize@A6AXAEAPEAPEA_W@Z@?$dual_state_global@PEAPEA_W@__crt_state_management@@QEAAXA6AXAEAPEAPEA_W@Z@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 74 22 00 91 7F 02 14 EB 35 00 00 91 40 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? AF 02 00 91 00 01 3F D6 60 02 00 91 A0 02 3F D6 73 22 00 91 7F 02 14 EB 21 FF FF 54 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_42_0 {
	meta:
		name = "?__crt_compute_required_transform_buffer_count@@YA_KIQEBD@Z"
		size = 56
		refs = "0008 __imp_MultiByteToWideChar"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 22 00 00 91 05 00 80 52 04 00 80 D2 03 00 80 12 01 00 80 52 20 01 3F D6 00 7C 40 93 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_43_0 {
	meta:
		name = "?__crt_compute_required_transform_buffer_count@@YA_KIQEB_W@Z"
		size = 64
		refs = "0008 __imp_WideCharToMultiByte"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 22 00 00 91 07 00 80 D2 06 00 80 D2 05 00 80 52 04 00 80 D2 03 00 80 12 01 00 80 52 20 01 3F D6 00 7C 40 93 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_44_0 {
	meta:
		name = "?__crt_transform_string@@YA_KIQEBDQEA_W_K@Z"
		size = 56
		refs = "0008 __imp_MultiByteToWideChar"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 44 00 00 91 65 00 00 11 22 00 00 91 03 00 80 12 01 00 80 52 20 01 3F D6 00 7C 40 93 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_45_0 {
	meta:
		name = "?__crt_transform_string@@YA_KIQEB_WQEAD_K@Z"
		size = 64
		refs = "0008 __imp_WideCharToMultiByte"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 44 00 00 91 65 00 00 11 22 00 00 91 07 00 80 D2 06 00 80 D2 03 00 80 12 01 00 80 52 20 01 3F D6 00 7C 40 93 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_22_77_0 {
	meta:
		name = "__dcrt_uninitialize_environments_nolock"
		size = 72
		refs = "000c _environ_table 0018 ??$uninitialize_environment_internal@D@@YAXAEAPEAPEAD@Z 0020 ??$uninitialize_environment_internal@_W@@YAXAEAPEAPEA_W@Z 0024 __dcrt_initial_narrow_environment 002c ??$free_environment@D@@YAXQEAPEAD@Z 0030 __dcrt_initial_wide_environment 0038 ??$free_environment@_W@@YAXQEAPEA_W@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 60 22 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_406_4_0 {
	meta:
		name = "_gcvt"
		size = 52
		refs = "001c _gcvt_s"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 33 00 00 91 02 00 00 11 60 02 00 91 01 00 80 92 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_23_0_0 {
	meta:
		name = "casinh"
		size = 664
		refs = "0010 creal 0020 cimag 002c _dtest 00c0 _Zero_C 0114 _Cbuild 0118 csqrt 01f4 asinh 0214 log 023c _Cmulcc 024c atan2"
	strings:
		$1 = { F3 0F 1F F8 FD 7B B9 A9 FD 03 00 91 E0 87 05 6D ?? ?? ?? ?? E1 33 40 FD E0 13 00 FD E0 2F 40 FD ?? ?? ?? ?? E0 83 00 91 E0 0B 00 FD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 0A 00 71 C1 01 00 54 AA FF 9F 52 08 00 0A 0A 08 01 00 34 1F 04 00 71 81 00 00 54 F3 0B 40 FD E0 13 40 FD 7D 00 00 14 F3 13 40 FD 09 00 00 14 F3 13 40 FD E0 0B 40 FD 78 00 00 14 1F 08 00 71 C1 00 00 54 7F 06 00 71 40 FF FF 54 F3 0B 40 FD 60 42 60 1E 71 00 00 14 7F 06 00 71 41 02 00 54 F3 13 40 FD 1F 04 00 71 E1 00 00 54 F0 0B 40 FD 31 0E 00 5C 08 22 60 1E 30 0E 00 5C 20 3E 70 1E 66 00 00 14 ?? ?? ?? ?? E8 2F 40 79 F0 03 67 9E ?? ?? ?? ?? 1F 01 11 72 32 42 61 1E 40 1E 70 1E 5E 00 00 14 1F 04 00 71 E1 00 00 54 F3 0B 40 FD B2 0C 00 5C D0 0C 00 5C 68 22 60 1E 40 3E 70 1E 56 00 00 14 F1 0B 40 FD 10 10 6E 1E E1 13 40 FD F0 1B 00 FD 00 3A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? F0 13 40 FD F1 0B 40 FD E1 83 04 6D F2 1B 40 FD 01 42 61 1E 20 2A 72 1E ?? ?? ?? ?? ?? ?? ?? ?? F0 13 40 FD E1 83 03 6D F0 0F 00 FD 08 22 60 1E 40 07 00 54 E1 83 44 6D ?? ?? ?? ?? E1 27 40 FD E0 17 00 FD E0 2B 40 FD ?? ?? ?? ?? E1 1F 40 FD E0 1B 00 FD E0 23 40 FD ?? ?? ?? ?? E1 1F 40 FD E0 0F 00 FD E0 23 40 FD ?? ?? ?? ?? F3 C7 42 6D 32 08 00 5C 40 22 73 1E C2 00 00 54 F2 0F 40 FD F3 17 00 FD 50 1A 73 1E 00 82 71 1F 13 00 00 14 40 22 71 1E C2 00 00 54 F1 17 00 FD 11 18 71 1E F2 0F 40 FD 20 CA 53 1F 0C 00 00 14 30 42 61 1E 40 22 70 1E F0 17 00 FD F2 0F 40 FD 82 00 00 54 10 18 70 1E 00 CA 53 1F 04 00 00 14 52 0A 71 1E FF 17 00 F9 00 C8 53 1F ?? ?? ?? ?? F1 17 40 FD E0 0F 00 FD 28 22 60 1E 80 01 00 54 08 20 60 1E 20 42 60 1E AB 00 00 54 ?? ?? ?? ?? F0 0F 40 FD 10 28 70 1E 04 00 00 14 ?? ?? ?? ?? F0 0F 40 FD 10 3A 60 1E F0 0F 00 FD E3 8B 43 6D E1 83 44 6D ?? ?? ?? ?? ?? ?? ?? ?? 01 40 60 1E E0 0B 40 FD ?? ?? ?? ?? F3 0F 40 FD 01 40 60 1E 60 42 60 1E ?? ?? ?? ?? FD 7B C7 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 18 2D 44 54 FB 21 E9 BF 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 FB 21 F9 3F 7B 52 82 BD 3A FB CF 5F }
	condition:
		$1
}

rule file_448_1_0 {
	meta:
		name = "casinhl"
		size = 664
		refs = "0010 creall 0020 cimagl 002c _ldtest 00c0 _LZero_C 0114 _LCbuild 0118 csqrtl 01f4 asinhl 0214 log 023c _LCmulcc 024c atan2"
	strings:
		$1 = { F3 0F 1F F8 FD 7B B9 A9 FD 03 00 91 E0 87 05 6D ?? ?? ?? ?? E1 33 40 FD E0 13 00 FD E0 2F 40 FD ?? ?? ?? ?? E0 83 00 91 E0 0B 00 FD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 0A 00 71 C1 01 00 54 AA FF 9F 52 08 00 0A 0A 08 01 00 34 1F 04 00 71 81 00 00 54 F3 0B 40 FD E0 13 40 FD 7D 00 00 14 F3 13 40 FD 09 00 00 14 F3 13 40 FD E0 0B 40 FD 78 00 00 14 1F 08 00 71 C1 00 00 54 7F 06 00 71 40 FF FF 54 F3 0B 40 FD 60 42 60 1E 71 00 00 14 7F 06 00 71 41 02 00 54 F3 13 40 FD 1F 04 00 71 E1 00 00 54 F0 0B 40 FD 31 0E 00 5C 08 22 60 1E 30 0E 00 5C 20 3E 70 1E 66 00 00 14 ?? ?? ?? ?? E8 2F 40 79 F0 03 67 9E ?? ?? ?? ?? 1F 01 11 72 32 42 61 1E 40 1E 70 1E 5E 00 00 14 1F 04 00 71 E1 00 00 54 F3 0B 40 FD B2 0C 00 5C D0 0C 00 5C 68 22 60 1E 40 3E 70 1E 56 00 00 14 F1 0B 40 FD 10 10 6E 1E E1 13 40 FD F0 1B 00 FD 00 3A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? F0 13 40 FD F1 0B 40 FD E1 83 04 6D F2 1B 40 FD 01 42 61 1E 20 2A 72 1E ?? ?? ?? ?? ?? ?? ?? ?? F0 13 40 FD E1 83 03 6D F0 0F 00 FD 08 22 60 1E 40 07 00 54 E1 83 44 6D ?? ?? ?? ?? E1 27 40 FD E0 17 00 FD E0 2B 40 FD ?? ?? ?? ?? E1 1F 40 FD E0 1B 00 FD E0 23 40 FD ?? ?? ?? ?? E1 1F 40 FD E0 0F 00 FD E0 23 40 FD ?? ?? ?? ?? F3 C7 42 6D 32 08 00 5C 40 22 73 1E C2 00 00 54 F2 0F 40 FD F3 17 00 FD 50 1A 73 1E 00 82 71 1F 13 00 00 14 40 22 71 1E C2 00 00 54 F1 17 00 FD 11 18 71 1E F2 0F 40 FD 20 CA 53 1F 0C 00 00 14 30 42 61 1E 40 22 70 1E F0 17 00 FD F2 0F 40 FD 82 00 00 54 10 18 70 1E 00 CA 53 1F 04 00 00 14 52 0A 71 1E FF 17 00 F9 00 C8 53 1F ?? ?? ?? ?? F1 17 40 FD E0 0F 00 FD 28 22 60 1E 80 01 00 54 08 20 60 1E 20 42 60 1E AB 00 00 54 ?? ?? ?? ?? F0 0F 40 FD 10 28 70 1E 04 00 00 14 ?? ?? ?? ?? F0 0F 40 FD 10 3A 60 1E F0 0F 00 FD E3 8B 43 6D E1 83 44 6D ?? ?? ?? ?? ?? ?? ?? ?? 01 40 60 1E E0 0B 40 FD ?? ?? ?? ?? F3 0F 40 FD 01 40 60 1E 60 42 60 1E ?? ?? ?? ?? FD 7B C7 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 18 2D 44 54 FB 21 E9 BF 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 FB 21 F9 3F 7B 52 82 BD 3A FB CF 5F }
	condition:
		$1
}

rule file_24_4_0 {
	meta:
		name = "__acrt_add_locale_ref"
		size = 248
		refs = "0090 __acrt_wide_c_locale_string 00f4 __acrt_locale_add_lc_time_reference"
	strings:
		$1 = { 0A 40 00 91 49 FD 5F 88 29 05 00 11 49 FD 08 88 A8 FF FF 35 BF 3B 03 D5 0B 70 40 F9 CB 00 00 B4 6A FD 5F 88 4A 05 00 11 6A FD 09 88 A9 FF FF 35 BF 3B 03 D5 0C 78 40 F9 CC 00 00 B4 8B FD 5F 88 6B 05 00 11 8B FD 08 88 A8 FF FF 35 BF 3B 03 D5 0D 74 40 F9 CD 00 00 B4 AA FD 5F 88 4A 05 00 11 AA FD 09 88 A9 FF FF 35 BF 3B 03 D5 0C 80 40 F9 CC 00 00 B4 8B FD 5F 88 6B 05 00 11 8B FD 08 88 A8 FF FF 35 BF 3B 03 D5 0C E0 00 91 CD 00 80 52 ?? ?? ?? ?? 89 01 5F F8 ?? ?? ?? ?? 3F 01 0A EB 00 01 00 54 8E 01 40 F9 CE 00 00 B4 CB FD 5F 88 6B 05 00 11 CB FD 08 88 A8 FF FF 35 BF 3B 03 D5 89 81 5E F8 09 01 00 B4 8F 81 5F F8 CF 00 00 B4 EA FD 5F 88 4A 05 00 11 EA FD 08 88 A8 FF FF 35 BF 3B 03 D5 8C 81 00 91 AD 05 00 51 4D FD FF 35 00 90 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_24_5_0 {
	meta:
		name = "__acrt_free_locale"
		size = 336
		refs = "0020 __acrt_lconv_c 0050 _free_base 0058 __acrt_locale_free_monetary 0074 __acrt_locale_free_numeric 00c8 __acrt_locale_free_lc_time_if_unreferenced 00d8 __acrt_wide_c_locale_string"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 69 7E 40 F9 69 03 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 3F 01 08 EB E0 02 00 54 68 72 40 F9 A8 02 00 B4 08 01 40 B9 68 02 00 35 60 7A 40 F9 C0 00 00 B4 08 00 40 B9 88 00 00 35 ?? ?? ?? ?? 60 7E 40 F9 ?? ?? ?? ?? 60 76 40 F9 C0 00 00 B4 08 00 40 B9 88 00 00 35 ?? ?? ?? ?? 60 7E 40 F9 ?? ?? ?? ?? 60 72 40 F9 ?? ?? ?? ?? 60 7E 40 F9 ?? ?? ?? ?? 68 82 40 F9 C8 01 00 B4 08 01 40 B9 88 01 00 35 68 86 40 F9 00 F9 03 D1 ?? ?? ?? ?? 68 8A 40 F9 00 01 02 D1 ?? ?? ?? ?? 68 8E 40 F9 00 01 02 D1 ?? ?? ?? ?? 60 82 40 F9 ?? ?? ?? ?? 60 92 40 F9 ?? ?? ?? ?? 76 A2 04 91 74 E2 00 91 D5 00 80 52 ?? ?? ?? ?? 88 02 5F F8 ?? ?? ?? ?? 1F 01 09 EB 00 01 00 54 80 02 40 F9 C0 00 00 B4 09 00 40 B9 89 00 00 35 ?? ?? ?? ?? C0 02 40 F9 ?? ?? ?? ?? 88 82 5E F8 C8 00 00 B4 80 82 5F F8 80 00 00 B4 09 00 40 B9 49 00 00 35 ?? ?? ?? ?? D6 22 00 91 94 82 00 91 B5 06 00 51 75 FD FF 35 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_24_6_0 {
	meta:
		name = "__acrt_locale_add_lc_time_reference"
		size = 56
		refs = "0004 __lc_time_c"
	strings:
		$1 = { 80 01 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 EB 00 01 00 54 0A 70 05 91 49 FD 5F 88 20 05 00 11 40 FD 09 88 A9 FF FF 35 BF 3B 03 D5 02 00 00 14 00 00 B0 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_24_7_0 {
	meta:
		name = "__acrt_locale_free_lc_time_if_unreferenced"
		size = 72
		refs = "0014 __lc_time_c 0030 __acrt_locale_free_time 0038 _free_base"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 73 01 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 08 EB E0 00 00 54 68 5E 41 B9 BF 3B 03 D5 88 00 00 35 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_24_8_0 {
	meta:
		name = "__acrt_locale_release_lc_time_reference"
		size = 56
		refs = "0004 __lc_time_c"
	strings:
		$1 = { 80 01 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 EB 00 01 00 54 0A 70 05 91 49 FD 5F 88 20 05 00 51 40 FD 09 88 A9 FF FF 35 BF 3B 03 D5 02 00 00 14 00 00 B0 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_24_9_0 {
	meta:
		name = "__acrt_release_locale_ref"
		size = 256
		refs = "0094 __acrt_wide_c_locale_string 00f8 __acrt_locale_release_lc_time_reference"
	strings:
		$1 = { E0 07 00 B4 0A 40 00 91 49 FD 5F 88 29 05 00 51 49 FD 08 88 A8 FF FF 35 BF 3B 03 D5 0B 70 40 F9 CB 00 00 B4 6A FD 5F 88 4A 05 00 51 6A FD 09 88 A9 FF FF 35 BF 3B 03 D5 0C 78 40 F9 CC 00 00 B4 8B FD 5F 88 6B 05 00 51 8B FD 08 88 A8 FF FF 35 BF 3B 03 D5 0D 74 40 F9 CD 00 00 B4 AA FD 5F 88 4A 05 00 51 AA FD 09 88 A9 FF FF 35 BF 3B 03 D5 0C 80 40 F9 CC 00 00 B4 8B FD 5F 88 6B 05 00 51 8B FD 08 88 A8 FF FF 35 BF 3B 03 D5 0C E0 00 91 CD 00 80 52 ?? ?? ?? ?? 89 01 5F F8 ?? ?? ?? ?? 3F 01 0A EB 00 01 00 54 8E 01 40 F9 CE 00 00 B4 CB FD 5F 88 6B 05 00 51 CB FD 08 88 A8 FF FF 35 BF 3B 03 D5 89 81 5E F8 09 01 00 B4 8F 81 5F F8 CF 00 00 B4 EA FD 5F 88 4A 05 00 51 EA FD 08 88 A8 FF FF 35 BF 3B 03 D5 8C 81 00 91 AD 05 00 51 4D FD FF 35 00 90 40 F9 ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_24_10_0 {
	meta:
		name = "__acrt_update_thread_locale_data"
		size = 112
		refs = "000c __acrt_getptd 0018 __globallocalestatus 0034 __acrt_lock 0038 __acrt_current_locale_data 0044 _updatetlocinfoEx_nolock 0050 __acrt_unlock 0058 abort"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 14 00 00 91 89 AA 43 B9 ?? ?? ?? ?? ?? ?? ?? ?? 29 01 08 0A 69 00 00 34 93 4A 40 F9 53 01 00 B5 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 80 42 02 91 ?? ?? ?? ?? 13 00 00 91 80 00 80 52 ?? ?? ?? ?? 53 00 00 B5 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_24_11_0 {
	meta:
		name = "__acrt_update_thread_locale_data$fin$0"
		size = 32
		refs = "000c __acrt_unlock"
		altNames = "_free_locale$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 80 00 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_24_12_0 {
	meta:
		name = "_updatetlocinfoEx_nolock"
		size = 120
		refs = "0034 __acrt_add_locale_ref 0040 __acrt_release_locale_ref 004c __acrt_initial_locale_data 0060 __acrt_free_locale"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 33 00 00 91 D3 02 00 B4 A0 02 00 B4 14 00 40 F9 9F 02 13 EB 61 00 00 54 60 02 00 91 11 00 00 14 13 00 00 F9 60 02 00 91 ?? ?? ?? ?? 74 FF FF B4 80 02 00 91 ?? ?? ?? ?? 88 12 40 B9 E8 FE FF 35 ?? ?? ?? ?? ?? ?? ?? ?? 9F 02 08 EB 60 FE FF 54 80 02 00 91 ?? ?? ?? ?? F0 FF FF 17 00 00 80 D2 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_25_0_0 {
	meta:
		name = "_calloc_base"
		size = 148
		refs = "002c __acrt_heap 0030 __imp_HeapAlloc 0040 _query_new_mode 004c _callnewh 0074 _errno"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 A0 00 00 B4 E8 03 80 92 08 09 C0 9A 1F 01 01 EB A3 02 00 54 08 7C 01 9B 29 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 00 F1 33 01 88 9A 06 00 00 14 ?? ?? ?? ?? 80 01 00 34 60 02 00 91 ?? ?? ?? ?? 20 01 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 01 01 80 52 62 02 00 91 20 01 3F D6 A0 FE FF B4 05 00 00 14 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_26_0_0 {
	meta:
		name = "strlen"
		size = 24
	strings:
		$1 = { 09 00 00 91 28 15 C0 38 E8 FF FF 35 28 01 00 CB 00 05 00 D1 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_2_0 {
	meta:
		name = "??$common_putenv@D@@YAHQEBD0@Z"
		size = 72
		refs = "0018 __acrt_lock 0024 ??$common_putenv_nolock@D@@YAHQEBD0@Z 0030 __acrt_unlock"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 34 00 00 91 60 01 80 52 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 13 00 00 11 60 01 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_27_4_0 {
	meta:
		name = "??$common_putenv@_W@@YAHQEB_W0@Z"
		size = 72
		refs = "0018 __acrt_lock 0024 ??$common_putenv_nolock@_W@@YAHQEB_W0@Z 0030 __acrt_unlock"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 34 00 00 91 60 01 80 52 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 13 00 00 11 60 01 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_27_3_0 {
	meta:
		name = "?fin$0@?0???$common_putenv@D@@YAHQEBD0@Z@4HA"
		size = 32
		refs = "000c __acrt_unlock"
		altNames = "?fin$0@?0???$common_dupenv_s@D@@YAHQEAPEADQEA_KQEBDH2H@Z@4HA ?fin$0@?0???$common_dupenv_s@_W@@YAHQEAPEA_WQEA_KQEB_WHQEBDH@Z@4HA ?fin$0@?0???$common_getenv@D@@YAPEADQEBD@Z@4HA ?fin$0@?0???$common_getenv@_W@@YAPEA_WQEB_W@Z@4HA ?fin$0@?0???$common_getenv_s@D@@YAHQEA_KQEAD_KQEBD@Z@4HA ?fin$0@?0???$common_getenv_s@_W@@YAHQEA_KQEA_W_KQEB_W@Z@4HA ?fin$0@?0???$common_putenv@_W@@YAHQEB_W0@Z@4HA"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 60 01 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_27_6_0 {
	meta:
		name = "??$common_putenv_nolock@D@@YAHQEBD0@Z"
		size = 180
		refs = "0010 _environ_table 0020 _wenviron_table 003c _errno 0048 _invalid_parameter_noinfo 0058 ??$create_environment_string@D@@YAPEADQEBD0@Z 006c __dcrt_set_variable_in_narrow_environment_nolock 0084 ??$set_variable_in_other_environment@D@@YA_NQEBD0@Z 009c _free_base"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 14 00 00 91 35 00 00 91 ?? ?? ?? ?? A8 00 00 B5 ?? ?? ?? ?? 68 00 00 B5 00 00 80 12 1C 00 00 14 D4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? F9 FF FF 17 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 13 00 00 91 A0 01 00 B4 21 00 80 52 13 00 80 D2 ?? ?? ?? ?? 20 01 00 35 ?? ?? ?? ?? A8 00 00 B4 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 60 00 00 34 14 00 80 52 02 00 00 14 14 00 80 12 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_7_0 {
	meta:
		name = "??$common_putenv_nolock@_W@@YAHQEB_W0@Z"
		size = 180
		refs = "0010 _environ_table 0024 _wenviron_table 003c _errno 0048 _invalid_parameter_noinfo 0058 ??$create_environment_string@_W@@YAPEA_WQEB_W0@Z 006c __dcrt_set_variable_in_wide_environment_nolock 0084 ??$set_variable_in_other_environment@_W@@YA_NQEB_W0@Z 009c _free_base"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 14 00 00 91 35 00 00 91 C8 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 B5 00 00 80 12 1C 00 00 14 D4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? F9 FF FF 17 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 13 00 00 91 A0 01 00 B4 21 00 80 52 13 00 80 D2 ?? ?? ?? ?? 20 01 00 35 ?? ?? ?? ?? A8 00 00 B4 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 60 00 00 34 14 00 80 52 02 00 00 14 14 00 80 12 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_8_0 {
	meta:
		name = "??$compute_required_transform_buffer_count@D@@YA_KQEBD0@Z"
		size = 164
		refs = "0010 __imp_MultiByteToWideChar 0044 _errno"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 34 00 00 91 02 00 00 91 05 00 80 52 04 00 80 D2 03 00 80 12 01 00 80 52 00 00 80 52 20 01 3F D6 13 7C 40 93 D3 00 00 B5 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 00 00 80 D2 10 00 00 14 74 00 00 B5 60 02 00 91 0D 00 00 14 ?? ?? ?? ?? 09 FD DF C8 05 00 80 52 04 00 80 D2 03 00 80 12 82 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 08 7C 40 93 C8 FD FF B4 00 01 13 8B FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_9_0 {
	meta:
		name = "??$compute_required_transform_buffer_count@_W@@YA_KQEB_W0@Z"
		size = 180
		refs = "0010 __imp_WideCharToMultiByte 004c _errno"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 34 00 00 91 02 00 00 91 07 00 80 D2 06 00 80 D2 05 00 80 52 04 00 80 D2 03 00 80 12 01 00 80 52 00 00 80 52 20 01 3F D6 13 7C 40 93 D3 00 00 B5 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 00 00 80 D2 12 00 00 14 74 00 00 B5 60 02 00 91 0F 00 00 14 ?? ?? ?? ?? 09 FD DF C8 07 00 80 D2 06 00 80 D2 05 00 80 52 04 00 80 D2 03 00 80 12 82 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 08 7C 40 93 88 FD FF B4 00 01 13 8B FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_10_0 {
	meta:
		name = "??$create_environment_string@D@@YAPEADQEBD0@Z"
		size = 328
		refs = "0024 strnlen 0048 _errno 0054 _invalid_parameter_noinfo 0078 _calloc_base 0098 strcpy_s 00bc strchr 012c _free_base"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 35 00 00 91 F5 04 00 B4 E1 FF 8F D2 ?? ?? ?? ?? E1 FF 8F D2 18 00 00 91 A0 02 00 91 ?? ?? ?? ?? E8 FF 8F D2 1F 03 08 EB 16 00 00 91 E3 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 36 00 00 14 E8 FF 8F D2 DF 02 08 EB 02 FF FF 54 D7 02 18 8B E0 0A 00 91 21 00 80 D2 ?? ?? ?? ?? 14 00 00 91 74 00 00 B5 14 00 80 D2 28 00 00 14 62 02 00 91 E1 0A 00 91 80 02 00 91 ?? ?? ?? ?? 88 02 18 8B A9 07 80 52 89 6A 38 38 00 05 00 91 A2 02 00 91 C1 06 00 91 1C 00 00 14 A1 07 80 52 ?? ?? ?? ?? 60 01 00 B4 08 00 13 CB E9 FF 8F D2 1F 01 09 EB CA FB FF 54 E1 FF 8F D2 00 04 00 91 ?? ?? ?? ?? E8 FF 8F D2 1F 00 08 EB 02 FB FF 54 68 02 C0 39 6A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 55 01 13 CB A0 06 00 91 21 00 80 D2 ?? ?? ?? ?? 14 00 00 91 74 FB FF B4 62 02 00 91 A1 06 00 91 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_11_0 {
	meta:
		name = "??$create_environment_string@_W@@YAPEA_WQEB_W0@Z"
		size = 336
		refs = "0024 wcsnlen 0048 _errno 0054 _invalid_parameter_noinfo 0078 _calloc_base 0098 wcscpy_s 00bc wcschr 0134 _free_base"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 35 00 00 91 F5 04 00 B4 E1 FF 8F D2 ?? ?? ?? ?? E1 FF 8F D2 18 00 00 91 A0 02 00 91 ?? ?? ?? ?? E8 FF 8F D2 1F 03 08 EB 16 00 00 91 E3 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 38 00 00 14 E8 FF 8F D2 DF 02 08 EB 02 FF FF 54 D7 02 18 8B E0 0A 00 91 41 00 80 D2 ?? ?? ?? ?? 14 00 00 91 74 00 00 B5 14 00 80 D2 2A 00 00 14 62 02 00 91 E1 0A 00 91 80 02 00 91 ?? ?? ?? ?? 88 06 18 8B A9 07 80 52 A2 02 00 91 09 01 00 79 00 09 00 91 C1 06 00 91 1E 00 00 14 A1 07 80 52 ?? ?? ?? ?? 80 01 00 B4 08 00 13 CB 09 F9 7F 92 CA FF 9F D2 3F 01 0A EB AA FB FF 54 E1 FF 8F D2 00 08 00 91 ?? ?? ?? ?? E8 FF 8F D2 1F 00 08 EB E2 FA FF 54 68 02 C0 79 6A 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 13 CB 15 FD 41 93 A0 06 00 91 41 00 80 D2 ?? ?? ?? ?? 14 00 00 91 34 FB FF B4 62 02 00 91 A1 06 00 91 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_14_0 {
	meta:
		name = "??$set_variable_in_other_environment@D@@YA_NQEBD0@Z"
		size = 356
		refs = "0018 __imp_MultiByteToWideChar 0054 _errno 00a0 _calloc_base 00f4 _free_base 0154 __dcrt_set_variable_in_wide_environment_nolock"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 17 00 00 91 36 00 00 91 05 00 80 52 04 00 80 D2 03 00 80 12 E2 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 58 05 80 52 14 7C 40 93 B4 00 00 B5 ?? ?? ?? ?? 14 00 80 D2 18 00 00 B9 0E 00 00 14 B6 01 00 B4 ?? ?? ?? ?? 09 FD DF C8 05 00 80 52 04 00 80 D2 03 00 80 12 C2 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 08 7C 40 93 28 FE FF B4 14 01 14 8B 41 00 80 D2 80 02 00 91 ?? ?? ?? ?? 15 00 00 91 B3 02 00 91 F3 0B 00 F9 F5 01 00 B4 ?? ?? ?? ?? 09 FD DF C8 85 02 00 11 A4 02 00 91 03 00 80 12 E2 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 08 7C 40 93 C8 01 00 B5 ?? ?? ?? ?? F3 0B 40 F9 18 00 00 B9 14 00 80 52 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 B6 01 00 B4 A4 06 08 8B A9 07 80 52 85 02 08 4B ?? ?? ?? ?? 89 E0 1F 78 09 FD DF C8 03 00 80 12 C2 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 E0 FC FF 34 01 00 80 52 A0 02 00 91 13 00 80 D2 ?? ?? ?? ?? 1F 00 00 71 F4 17 9F 1A E4 FF FF 17 }
	condition:
		$1
}

rule file_27_15_0 {
	meta:
		name = "??$set_variable_in_other_environment@_W@@YA_NQEB_W0@Z"
		size = 388
		refs = "0018 __imp_WideCharToMultiByte 005c _errno 00b0 _calloc_base 010c _free_base 0174 __dcrt_set_variable_in_narrow_environment_nolock"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 17 00 00 91 36 00 00 91 07 00 80 D2 06 00 80 D2 05 00 80 52 04 00 80 D2 03 00 80 12 E2 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 58 05 80 52 14 7C 40 93 B4 00 00 B5 ?? ?? ?? ?? 14 00 80 D2 18 00 00 B9 10 00 00 14 F6 01 00 B4 ?? ?? ?? ?? 09 FD DF C8 07 00 80 D2 06 00 80 D2 05 00 80 52 04 00 80 D2 03 00 80 12 C2 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 08 7C 40 93 E8 FD FF B4 14 01 14 8B 21 00 80 D2 80 02 00 91 ?? ?? ?? ?? 15 00 00 91 B3 02 00 91 F3 0B 00 F9 35 02 00 B4 ?? ?? ?? ?? 09 FD DF C8 07 00 80 D2 06 00 80 D2 85 02 00 11 A4 02 00 91 03 00 80 12 E2 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 08 7C 40 93 C8 01 00 B5 ?? ?? ?? ?? F3 0B 40 F9 18 00 00 B9 14 00 80 52 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 F6 01 00 B4 A4 02 08 8B A9 07 80 52 85 02 08 4B 89 F0 1F 38 ?? ?? ?? ?? 09 FD DF C8 07 00 80 D2 06 00 80 D2 03 00 80 12 C2 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 A0 FC FF 34 01 00 80 52 A0 02 00 91 13 00 80 D2 ?? ?? ?? ?? 1F 00 00 71 F4 17 9F 1A E2 FF FF 17 }
	condition:
		$1
}

rule file_27_45_0 {
	meta:
		name = "?other_environment_exists@@YA_ND@Z"
		size = 20
		refs = "0000 _wenviron_table"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 00 F1 E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_27_46_0 {
	meta:
		name = "?other_environment_exists@@YA_N_W@Z"
		size = 20
		refs = "0000 _environ_table"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 00 F1 E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_27_52_0 {
	meta:
		name = "_putenv_s"
		size = 68
		refs = "000c _errno 0018 _invalid_parameter_noinfo 0024 ??$common_putenv@D@@YAHQEBD0@Z"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 E1 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 07 00 00 14 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 03 00 00 14 ?? ?? ?? ?? 00 00 40 B9 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_27_54_0 {
	meta:
		name = "_wputenv_s"
		size = 68
		refs = "000c _errno 0018 _invalid_parameter_noinfo 0024 ??$common_putenv@_W@@YAHQEB_W0@Z"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 E1 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 07 00 00 14 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 03 00 00 14 ?? ?? ?? ?? 00 00 40 B9 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_28_0_0 {
	meta:
		name = "strtok"
		size = 52
		refs = "0014 __acrt_getptd 0024 __acrt_strtok_s_novalidation"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 33 00 00 91 ?? ?? ?? ?? 02 C0 00 91 80 02 00 91 61 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_29_5_0 {
	meta:
		name = "_set_new_mode"
		size = 76
		refs = "0010 _errno 001c _invalid_parameter_noinfo 0028 ?__acrt_global_new_mode@@3V?$dual_state_global@J@__crt_state_management@@A"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 1F 04 00 71 E9 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 08 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 49 FD 5F 88 40 FD 08 88 C8 FF FF 35 BF 3B 03 D5 20 01 00 11 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_30_0_0 {
	meta:
		name = "?initialize_multibyte@@YAHXZ"
		size = 28
		refs = "0008 __acrt_initialize_multibyte"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 17 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_507_10_4 {
	meta:
		name = "?common_mktemp_s_continue@@YA_NQEBD0@Z"
		size = 28
		refs = "0008 _ismbstrail"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 17 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_549_0_4 {
	meta:
		name = "?try_walk@@YAHQEAU_PROCESS_HEAP_ENTRY@@@Z"
		size = 104
		refs = "000c __acrt_heap 0014 __imp_HeapWalk 0030 __imp_GetLastError"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 01 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 60 00 00 34 20 00 80 12 0C 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 1F 0C 04 71 61 00 00 54 80 00 80 12 04 00 00 14 60 00 80 12 02 00 00 14 60 00 80 12 FD 7B C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_170_9_0 {
	meta:
		name = "_fgetchar"
		size = 28
		refs = "000c __acrt_iob_func 0010 fgetc"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_164_8_3 {
	meta:
		name = "_fgetwchar"
		size = 28
		refs = "000c __acrt_iob_func 0010 fgetwc"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_170_14_3 {
	meta:
		name = "getchar"
		size = 28
		refs = "000c __acrt_iob_func 0010 fgetc"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_164_13_3 {
	meta:
		name = "getwchar"
		size = 28
		refs = "000c __acrt_iob_func 0010 fgetwc"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_4_0 {
	meta:
		name = "??$capture_argv@PEAPEADAEBQEBDPEAPEADH@?$__crt_char_traits@D@@SAPEAPEAD$$QEAPEAPEADAEBQEBD0$$QEAH@Z"
		size = 20
		refs = "0010 __acrt_capture_narrow_argv"
	strings:
		$1 = { 63 00 80 B9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_5_0 {
	meta:
		name = "??$capture_argv@PEAPEADAEBQEB_WPEAPEA_WH@?$__crt_char_traits@_W@@SAPEAPEA_W$$QEAPEAPEADAEBQEB_W$$QEAPEAPEA_W$$QEAH@Z"
		size = 20
		refs = "0010 __acrt_capture_wide_argv"
	strings:
		$1 = { 63 00 80 B9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_13_0 {
	meta:
		name = "??$tcsncpy_s@AEAPEAD_KAEAPEBDH@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_KAEAPEBD$$QEAH@Z"
		size = 20
		refs = "0010 strncpy_s"
	strings:
		$1 = { 63 00 80 B9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_15_0 {
	meta:
		name = "??$tcsncpy_s@AEAPEA_W_KAEAPEB_WH@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_KAEAPEB_W$$QEAH@Z"
		size = 20
		refs = "0010 wcsncpy_s"
	strings:
		$1 = { 63 00 80 B9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_6_0 {
	meta:
		name = "??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
		size = 236
		refs = "0010 __security_push_cookie 0030 _errno 003c _invalid_parameter_noinfo 0068 __acrt_capture_narrow_argv 00c0 _spawnvpe 00cc _free_base 00d8 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 08 D1 36 00 00 11 E4 03 00 F9 61 00 00 91 15 00 00 11 54 00 00 91 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 24 00 00 14 88 02 C0 39 28 FF FF 34 01 FF FF B4 28 00 C0 39 C8 FE FF 34 03 08 80 D2 E2 23 00 91 E0 03 00 91 ?? ?? ?? ?? A0 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 F1 FF FF 17 E8 23 00 91 1F 00 08 EB F3 03 80 9A 35 01 00 34 EA 03 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 EB 03 00 F9 63 81 5F F8 02 00 00 14 03 00 80 D2 02 00 00 91 C0 02 00 11 81 02 00 91 ?? ?? ?? ?? 14 00 00 91 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FF 03 08 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_6_0 {
	meta:
		name = "??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
		size = 236
		refs = "0010 __security_push_cookie 0030 _errno 003c _invalid_parameter_noinfo 0068 __acrt_capture_narrow_argv 00c0 _spawnve 00cc _free_base 00d8 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 08 D1 36 00 00 11 E4 03 00 F9 61 00 00 91 15 00 00 11 54 00 00 91 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 24 00 00 14 88 02 C0 39 28 FF FF 34 01 FF FF B4 28 00 C0 39 C8 FE FF 34 03 08 80 D2 E2 23 00 91 E0 03 00 91 ?? ?? ?? ?? A0 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 F1 FF FF 17 E8 23 00 91 1F 00 08 EB F3 03 80 9A 35 01 00 34 EA 03 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 EB 03 00 F9 63 81 5F F8 02 00 00 14 03 00 80 D2 02 00 00 91 C0 02 00 11 81 02 00 91 ?? ?? ?? ?? 14 00 00 91 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FF 03 08 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_7_0 {
	meta:
		name = "??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
		size = 236
		refs = "0010 __security_push_cookie 0030 _errno 003c _invalid_parameter_noinfo 0068 __acrt_capture_wide_argv 00c0 _wspawnvpe 00cc _free_base 00d8 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 08 D1 36 00 00 11 E4 03 00 F9 61 00 00 91 15 00 00 11 54 00 00 91 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 24 00 00 14 88 02 40 79 28 FF FF 34 01 FF FF B4 28 00 40 79 C8 FE FF 34 03 08 80 D2 E2 23 00 91 E0 03 00 91 ?? ?? ?? ?? A0 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 F1 FF FF 17 E8 23 00 91 1F 00 08 EB F3 03 80 9A 35 01 00 34 EA 03 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 EB 03 00 F9 63 81 5F F8 02 00 00 14 03 00 80 D2 02 00 00 91 C0 02 00 11 81 02 00 91 ?? ?? ?? ?? 14 00 00 91 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FF 03 08 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_7_0 {
	meta:
		name = "??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
		size = 236
		refs = "0010 __security_push_cookie 0030 _errno 003c _invalid_parameter_noinfo 0068 __acrt_capture_wide_argv 00c0 _wspawnve 00cc _free_base 00d8 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 08 D1 36 00 00 11 E4 03 00 F9 61 00 00 91 15 00 00 11 54 00 00 91 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 24 00 00 14 88 02 40 79 28 FF FF 34 01 FF FF B4 28 00 40 79 C8 FE FF 34 03 08 80 D2 E2 23 00 91 E0 03 00 91 ?? ?? ?? ?? A0 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 F1 FF FF 17 E8 23 00 91 1F 00 08 EB F3 03 80 9A 35 01 00 34 EA 03 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 EB 03 00 F9 63 81 5F F8 02 00 00 14 03 00 80 D2 02 00 00 91 C0 02 00 11 81 02 00 91 ?? ?? ?? ?? 14 00 00 91 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FF 03 08 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_8_0 {
	meta:
		name = "??$tspawnvpe@AEBHAEBQEBDAEBQEAPEADAEBQEBQEBD@?$__crt_char_traits@D@@SA_JAEBHAEBQEBDAEBQEAPEADAEBQEBQEBD@Z"
		size = 20
		refs = "0010 _spawnvpe"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_24_3 {
	meta:
		name = "??$tspawnve@AEBHAEAPEADAEBQEBQEBDAEBQEBQEBD@?$__crt_char_traits@D@@SA_JAEBHAEAPEADAEBQEBQEBD2@Z"
		size = 20
		refs = "0010 _spawnve"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_25_3 {
	meta:
		name = "??$tspawnve@AEBHAEAPEA_WAEBQEBQEB_WAEBQEBQEB_W@?$__crt_char_traits@_W@@SA_JAEBHAEAPEA_WAEBQEBQEB_W2@Z"
		size = 20
		refs = "0010 _wspawnve"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_8_4 {
	meta:
		name = "??$tspawnve@AEBHAEBQEBDAEBQEAPEADAEBQEBQEBD@?$__crt_char_traits@D@@SA_JAEBHAEBQEBDAEBQEAPEADAEBQEBQEBD@Z"
		size = 20
		refs = "0010 _spawnve"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_26_2 {
	meta:
		name = "??$tspawnve@AEBHAEBQEBDAEBQEBQEBDAEBQEBQEBD@?$__crt_char_traits@D@@SA_JAEBHAEBQEBDAEBQEBQEBD2@Z"
		size = 20
		refs = "0010 _spawnve"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_33_9_2 {
	meta:
		name = "??$tspawnve@AEBHAEBQEB_WAEBQEAPEA_WAEBQEBQEB_W@?$__crt_char_traits@_W@@SA_JAEBHAEBQEB_WAEBQEAPEA_WAEBQEBQEB_W@Z"
		size = 20
		refs = "0010 _wspawnve"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_27_4 {
	meta:
		name = "??$tspawnve@AEBHAEBQEB_WAEBQEBQEB_WAEBQEBQEB_W@?$__crt_char_traits@_W@@SA_JAEBHAEBQEB_WAEBQEBQEB_W2@Z"
		size = 20
		refs = "0010 _wspawnve"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_9_4 {
	meta:
		name = "??$tspawnvpe@AEBHAEBQEB_WAEBQEAPEA_WAEBQEBQEB_W@?$__crt_char_traits@_W@@SA_JAEBHAEBQEB_WAEBQEAPEA_WAEBQEBQEB_W@Z"
		size = 20
		refs = "0010 _wspawnvpe"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_31_16_0 {
	meta:
		name = "_execlp"
		size = 56
		refs = "0028 ??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { E2 0F BD A9 E4 17 01 A9 E6 1F 02 A9 FD 7B BF A9 FD 03 00 91 23 00 00 91 02 00 00 91 41 00 80 52 00 00 80 52 E4 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_16_0 {
	meta:
		name = "_execl"
		size = 56
		refs = "0028 ??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { E2 0F BD A9 E4 17 01 A9 E6 1F 02 A9 FD 7B BF A9 FD 03 00 91 23 00 00 91 02 00 00 91 41 00 80 52 00 00 80 52 E4 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_20_0 {
	meta:
		name = "_wexecl"
		size = 56
		refs = "0028 ??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { E2 0F BD A9 E4 17 01 A9 E6 1F 02 A9 FD 7B BF A9 FD 03 00 91 23 00 00 91 02 00 00 91 41 00 80 52 00 00 80 52 E4 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_20_0 {
	meta:
		name = "_wexeclp"
		size = 56
		refs = "0028 ??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { E2 0F BD A9 E4 17 01 A9 E6 1F 02 A9 FD 7B BF A9 FD 03 00 91 23 00 00 91 02 00 00 91 41 00 80 52 00 00 80 52 E4 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_17_0 {
	meta:
		name = "_execlpe"
		size = 56
		refs = "0028 ??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { E2 0F BD A9 E4 17 01 A9 E6 1F 02 A9 FD 7B BF A9 FD 03 00 91 23 00 00 91 02 00 00 91 41 00 80 52 20 00 80 52 E4 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_17_0 {
	meta:
		name = "_execle"
		size = 56
		refs = "0028 ??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { E2 0F BD A9 E4 17 01 A9 E6 1F 02 A9 FD 7B BF A9 FD 03 00 91 23 00 00 91 02 00 00 91 41 00 80 52 20 00 80 52 E4 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_21_0 {
	meta:
		name = "_wexecle"
		size = 56
		refs = "0028 ??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { E2 0F BD A9 E4 17 01 A9 E6 1F 02 A9 FD 7B BF A9 FD 03 00 91 23 00 00 91 02 00 00 91 41 00 80 52 20 00 80 52 E4 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_21_0 {
	meta:
		name = "_wexeclpe"
		size = 56
		refs = "0028 ??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { E2 0F BD A9 E4 17 01 A9 E6 1F 02 A9 FD 7B BF A9 FD 03 00 91 23 00 00 91 02 00 00 91 41 00 80 52 20 00 80 52 E4 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_18_0 {
	meta:
		name = "_spawnlp"
		size = 60
		refs = "002c ??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { FF C3 00 D1 E3 93 00 A9 E5 9B 01 A9 E7 17 00 F9 FD 7B BF A9 FD 03 00 91 43 00 00 91 22 00 00 91 01 00 00 11 00 00 80 52 E4 63 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_18_0 {
	meta:
		name = "_spawnl"
		size = 60
		refs = "002c ??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { FF C3 00 D1 E3 93 00 A9 E5 9B 01 A9 E7 17 00 F9 FD 7B BF A9 FD 03 00 91 43 00 00 91 22 00 00 91 01 00 00 11 00 00 80 52 E4 63 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_22_0 {
	meta:
		name = "_wspawnl"
		size = 60
		refs = "002c ??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { FF C3 00 D1 E3 93 00 A9 E5 9B 01 A9 E7 17 00 F9 FD 7B BF A9 FD 03 00 91 43 00 00 91 22 00 00 91 01 00 00 11 00 00 80 52 E4 63 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_22_0 {
	meta:
		name = "_wspawnlp"
		size = 60
		refs = "002c ??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { FF C3 00 D1 E3 93 00 A9 E5 9B 01 A9 E7 17 00 F9 FD 7B BF A9 FD 03 00 91 43 00 00 91 22 00 00 91 01 00 00 11 00 00 80 52 E4 63 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_19_0 {
	meta:
		name = "_spawnlpe"
		size = 60
		refs = "002c ??$common_spawnlp@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { FF C3 00 D1 E3 93 00 A9 E5 9B 01 A9 E7 17 00 F9 FD 7B BF A9 FD 03 00 91 43 00 00 91 22 00 00 91 01 00 00 11 20 00 80 52 E4 63 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_19_0 {
	meta:
		name = "_spawnle"
		size = 60
		refs = "002c ??$common_spawnl@D@@YA_J_NHQEBD1PEAD@Z"
	strings:
		$1 = { FF C3 00 D1 E3 93 00 A9 E5 9B 01 A9 E7 17 00 F9 FD 7B BF A9 FD 03 00 91 43 00 00 91 22 00 00 91 01 00 00 11 20 00 80 52 E4 63 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_33_23_0 {
	meta:
		name = "_wspawnle"
		size = 60
		refs = "002c ??$common_spawnl@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { FF C3 00 D1 E3 93 00 A9 E5 9B 01 A9 E7 17 00 F9 FD 7B BF A9 FD 03 00 91 43 00 00 91 22 00 00 91 01 00 00 11 20 00 80 52 E4 63 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_31_23_0 {
	meta:
		name = "_wspawnlpe"
		size = 60
		refs = "002c ??$common_spawnlp@_W@@YA_J_NHQEB_W1PEAD@Z"
	strings:
		$1 = { FF C3 00 D1 E3 93 00 A9 E5 9B 01 A9 E7 17 00 F9 FD 7B BF A9 FD 03 00 91 43 00 00 91 22 00 00 91 01 00 00 11 20 00 80 52 E4 63 00 91 ?? ?? ?? ?? FD 7B C1 A8 FF C3 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_32_0_0 {
	meta:
		name = "?write_binary_nolock@@YA?AUwrite_result@?A0x17268360@@HQEBDI@Z"
		size = 132
		refs = "0008 __security_push_cookie 0014 __pioinfo 0044 __imp_WriteFile 0058 __imp_GetLastError 0078 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 09 7C 40 93 ?? ?? ?? ?? 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 04 00 80 D2 E3 13 00 91 09 19 09 8B E8 13 00 91 20 15 40 F9 FF 03 00 B9 1F 01 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 C0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 03 00 B9 E0 03 40 F9 E1 0B 40 B9 FF 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_32_1_0 {
	meta:
		name = "?write_double_translated_ansi_nolock@@YA?AUwrite_result@?A0x17268360@@HQEBDI@Z"
		size = 632
		refs = "001c __security_push_cookie 0028 __pioinfo 0050 __imp_GetConsoleCP 00c8 __pctype_func 00ec mbtowc 011c __imp_WideCharToMultiByte 015c __imp_WriteFile 0238 __security_pop_cookie 0260 __imp_GetLastError"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 73 05 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 01 D1 08 7C 40 93 ?? ?? ?? ?? ?? ?? ?? ?? 1B FD 46 93 17 15 40 92 88 7B 7B F8 3A 00 00 91 F7 1B 00 F9 59 43 22 8B 09 19 17 8B 28 15 40 F9 ?? ?? ?? ?? E8 17 00 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E9 33 00 91 FF 0B 00 B9 3F 01 00 F9 54 03 00 91 F3 13 40 B9 E0 23 00 B9 5F 03 19 EB 62 0D 00 54 F5 0F 40 B9 56 07 00 91 88 7B 7B F8 FF 03 00 79 98 02 C0 39 0B 19 17 8B 6A F5 40 39 4A 01 10 36 69 F9 C0 39 6C 1F 80 52 F8 E7 00 39 4A 01 0C 0A 6A F5 00 39 42 00 80 D2 E1 E3 00 91 E9 E3 00 39 12 00 00 14 ?? ?? ?? ?? 88 02 40 39 09 D8 68 78 89 01 78 36 DF 02 19 EB 22 09 00 54 42 00 80 D2 81 02 00 91 E0 03 00 91 ?? ?? ?? ?? 1F 04 00 31 C0 09 00 54 94 06 00 91 D6 06 00 91 07 00 00 14 22 00 80 D2 81 02 00 91 E0 03 00 91 ?? ?? ?? ?? 1F 04 00 31 A0 08 00 54 ?? ?? ?? ?? E0 23 40 B9 ?? ?? ?? ?? 09 FD DF C8 07 00 80 D2 06 00 80 D2 A5 00 80 52 E4 03 01 91 23 00 80 52 E2 03 00 91 01 00 80 52 94 06 00 91 D6 06 00 91 20 01 3F D6 17 00 00 11 17 08 00 34 ?? ?? ?? ?? E0 17 40 F9 ?? ?? ?? ?? 09 FD DF C8 04 00 80 D2 E3 73 00 91 E2 02 00 11 E1 03 01 91 20 01 3F D6 00 07 00 34 F3 13 40 B9 8A 02 1A 4B 55 01 13 0B EA 1F 40 B9 F5 0F 00 B9 5F 01 17 6B 83 04 00 54 1F 2B 00 71 61 02 00 54 ?? ?? ?? ?? E0 17 40 F9 AB 01 80 52 ?? ?? ?? ?? EB 33 00 79 09 FD DF C8 04 00 80 D2 E3 73 00 91 22 00 80 52 E1 63 00 91 20 01 3F D6 60 04 00 34 E8 1F 40 B9 E8 03 00 34 EA A7 41 29 33 05 00 11 55 05 00 11 F5 CF 01 29 9F 02 19 EB C2 01 00 54 F7 1B 40 F9 A4 FF FF 17 88 7B 7B F8 89 02 C0 39 0A 19 17 8B 49 F9 00 39 88 7B 7B F8 0B 19 17 8B 69 F5 40 39 28 01 1E 32 A9 06 00 11 68 F5 00 39 E9 0F 00 B9 61 02 00 11 E0 07 40 F9 FF 03 01 91 ?? ?? ?? ?? FB 73 45 A9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 E1 13 40 B9 F5 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 0B 00 B9 F9 FF FF 17 }
	condition:
		$1
}

rule file_32_2_0 {
	meta:
		name = "?write_double_translated_unicode_nolock@@YA?AUwrite_result@?A0x17268360@@QEBDI@Z"
		size = 184
		refs = "0040 _putwch_nolock 009c __imp_GetLastError"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 15 00 00 91 FF 13 00 B9 B7 42 21 8B E8 53 00 91 1F 01 00 F9 F3 1B 40 B9 BF 02 17 EB 82 02 00 54 F4 17 40 B9 B6 26 40 78 C0 02 00 11 ?? ?? ?? ?? 1F 00 16 6B A1 02 00 54 94 0A 00 11 F4 17 00 B9 DF 2A 00 71 01 01 00 54 A0 01 80 52 ?? ?? ?? ?? 1F 34 00 71 A1 01 00 54 94 06 00 11 73 06 00 11 F4 CF 02 29 BF 02 17 EB E3 FD FF 54 61 02 00 11 E0 0B 40 F9 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E1 1B 40 B9 E0 13 00 B9 F4 FF FF 17 }
	condition:
		$1
}

rule file_32_3_0 {
	meta:
		name = "?write_requires_double_translation_nolock@@YA_NH@Z"
		size = 160
		refs = "0014 _isatty 0028 __pioinfo 0048 __acrt_getptd 0074 __imp_GetConsoleMode"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 1C 00 00 14 68 7E 40 93 ?? ?? ?? ?? ?? ?? ?? ?? 13 FD 46 93 15 15 40 92 88 7A 73 F8 09 19 15 8B 2A E1 40 39 CA FE 3F 36 ?? ?? ?? ?? 08 48 40 F9 09 9D 40 F9 A9 00 00 B5 88 7A 73 F8 09 19 15 8B 2A E5 C0 39 CA FD FF 34 88 7A 73 F8 E1 43 00 91 09 19 15 8B ?? ?? ?? ?? ?? ?? ?? ?? 20 15 40 F9 09 FD DF C8 20 01 3F D6 1F 00 00 71 E0 07 9F 1A FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_32_4_0 {
	meta:
		name = "?write_text_ansi_nolock@@YA?AUwrite_result@?A0x17268360@@HQEBDI@Z"
		size = 312
		refs = "0014 __security_push_cookie 001c __chkstk 002c __pioinfo 0064 __imp_WriteFile 00fc __imp_GetLastError 0120 __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 FD 03 00 91 ?? ?? ?? ?? 2F 28 80 D2 ?? ?? ?? ?? FF 73 2F CB 09 7C 40 93 FF 03 00 B9 ?? ?? ?? ?? 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 33 00 00 91 29 15 40 92 74 42 22 8B 7F 02 14 EB 09 19 09 8B E8 13 00 91 1F 01 00 F9 37 15 40 F9 A2 05 00 54 F6 63 00 91 ?? ?? ?? ?? EA 0B 40 B9 EB 63 00 91 7F 02 14 EB C2 01 00 54 68 02 C0 39 73 06 00 91 1F 29 00 71 A1 00 00 54 A9 01 80 52 69 01 00 39 4A 05 00 11 6B 05 00 91 68 15 00 38 F0 82 82 D2 EC 63 30 8B 7F 01 0C EB 43 FE FF 54 ?? ?? ?? ?? EA 0B 00 B9 2A FD DF C8 75 01 16 4B 04 00 80 D2 E3 43 00 91 A2 02 00 11 E1 63 00 91 E0 02 00 91 40 01 3F D6 40 01 00 34 E8 07 40 B9 E9 13 40 B9 08 01 09 0B E8 07 00 B9 3F 01 15 6B 23 01 00 54 7F 02 14 EB A3 FB FF 54 06 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 03 00 B9 E0 03 40 F9 E1 0B 40 B9 2F 28 80 D2 FF 73 2F 8B ?? ?? ?? ?? F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_32_5_0 {
	meta:
		name = "?write_text_utf16le_nolock@@YA?AUwrite_result@?A0x17268360@@HQEBDI@Z"
		size = 316
		refs = "0014 __security_push_cookie 001c __chkstk 002c __pioinfo 0060 __imp_WriteFile 0100 __imp_GetLastError 0124 __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? 2F 28 80 D2 ?? ?? ?? ?? FF 73 2F CB 09 7C 40 93 FF 03 00 B9 ?? ?? ?? ?? 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 33 00 00 91 29 15 40 92 74 42 22 8B 7F 02 14 EB 09 19 09 8B E8 13 00 91 1F 01 00 F9 36 15 40 F9 C2 05 00 54 ?? ?? ?? ?? EC 0B 40 B9 EB 63 00 91 7F 02 14 EB C2 01 00 54 68 02 40 79 73 0A 00 91 1F 29 00 71 A1 00 00 54 A9 01 80 52 69 01 00 79 8C 09 00 11 6B 09 00 91 68 25 00 78 D0 82 82 D2 EA 63 30 8B 7F 01 0A EB 43 FE FF 54 ED 63 00 91 EC 0B 00 B9 ?? ?? ?? ?? 68 01 0D CB 4B FD DF C8 15 FD 41 93 A2 7A 1F 53 04 00 80 D2 E3 43 00 91 E1 63 00 91 C0 02 00 91 60 01 3F D6 40 01 00 34 E8 07 40 B9 E9 13 40 B9 08 01 09 0B 3F 05 15 6B E8 07 00 B9 23 01 00 54 7F 02 14 EB 63 FB FF 54 06 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 03 00 B9 E0 03 40 F9 E1 0B 40 B9 2F 28 80 D2 FF 73 2F 8B ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_32_6_0 {
	meta:
		name = "?write_text_utf8_nolock@@YA?AUwrite_result@?A0x17268360@@HQEBDI@Z"
		size = 376
		refs = "0018 __security_push_cookie 0020 __chkstk 0030 __pioinfo 0068 __imp_WriteFile 006c __imp_WideCharToMultiByte 0138 __imp_GetLastError 015c __security_pop_cookie"
	strings:
		$1 = { FD 7B BB A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FD 03 00 91 ?? ?? ?? ?? 4F 28 80 D2 ?? ?? ?? ?? FF 73 2F CB 09 7C 40 93 FF 03 00 B9 ?? ?? ?? ?? 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 37 00 00 91 29 15 40 92 F6 42 22 8B F3 02 00 91 FF 02 16 EB 09 19 09 8B E8 13 00 91 1F 01 00 F9 38 15 40 F9 42 07 00 54 ?? ?? ?? ?? ?? ?? ?? ?? EB 63 00 91 7F 02 16 EB 82 01 00 54 68 02 40 79 73 0A 00 91 1F 29 00 71 81 00 00 54 A9 01 80 52 69 01 00 79 6B 09 00 91 68 25 00 78 EA 03 1B 91 7F 01 0A EB 83 FE FF 54 EC 63 00 91 ?? ?? ?? ?? 68 01 0C CB 4B FD DF C8 03 FD 41 93 07 00 80 D2 06 00 80 D2 A5 AA 81 52 E4 23 1B 91 E2 63 00 91 01 00 80 52 20 BD 9F 52 60 01 3F D6 15 00 00 11 D5 02 00 34 14 00 80 52 F5 01 00 34 E8 23 1B 91 01 41 34 8B ?? ?? ?? ?? 09 FD DF C8 A2 02 14 4B 04 00 80 D2 E3 43 00 91 00 03 00 91 20 01 3F D6 40 01 00 34 E8 13 40 B9 14 01 14 0B 9F 02 15 6B 63 FE FF 54 69 02 17 4B E9 07 00 B9 7F 02 16 EB E2 00 00 54 CF FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 03 00 B9 E0 03 40 F9 E1 0B 40 B9 4F 28 80 D2 FF 73 2F 8B ?? ?? ?? ?? F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_32_7_0 {
	meta:
		name = "_write"
		size = 272
		refs = "0030 __doserrno 0038 _errno 004c _nhandle 0064 __pioinfo 0088 __acrt_lowio_lock_fh 00c4 _write_nolock 00d0 __acrt_lowio_unlock_fh 00f0 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 11 B3 13 00 B9 35 00 00 91 56 00 00 11 7F 0A 00 31 E1 00 00 54 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 2C 00 00 14 B3 04 F8 37 ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 08 6B 22 04 00 54 68 7E 40 93 17 FD 46 93 ?? ?? ?? ?? ?? ?? ?? ?? 19 15 40 92 08 7B 77 F8 09 19 19 8B 2A E1 40 39 48 01 00 12 E8 02 00 34 60 02 00 11 ?? ?? ?? ?? 14 00 80 12 08 7B 77 F8 09 19 19 8B 2A E1 40 39 EA 00 00 37 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 1F 00 00 B9 06 00 00 14 C2 02 00 11 A1 02 00 91 60 02 00 11 ?? ?? ?? ?? 14 00 00 11 60 02 00 11 ?? ?? ?? ?? 80 02 00 11 08 00 00 14 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_32_8_0 {
	meta:
		name = "_write$fin$0"
		size = 32
		refs = "000c __acrt_lowio_unlock_fh"
		altNames = "?fin$0@?0???$common_filelength@J@@YAJH@Z@4HA ?fin$0@?0???$common_filelength@_J@@YA_JH@Z@4HA ?fin$0@?0???$common_lseek@J@@YAJHJH@Z@4HA ?fin$0@?0???$common_lseek@_J@@YA_JH_JH@Z@4HA _dup$fin$0 _locking$fin$0 _read$fin$0 _setmode$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A0 13 40 B9 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_32_9_0 {
	meta:
		name = "_write_nolock"
		size = 680
		refs = "0018 __security_push_cookie 003c __doserrno 0044 _errno 0050 _invalid_parameter_noinfo 0060 __pioinfo 00a4 _lseeki64_nolock 00b8 _isatty 00d0 __acrt_getptd 00fc __imp_GetConsoleMode 012c ?write_double_translated_unicode_nolock@@YA?AUwrite_result@?A0x17268360@@QEBDI@Z 0148 ?write_double_translated_ansi_nolock@@YA?AUwrite_result@?A0x17268360@@HQEBDI@Z 0180 ?write_text_utf16le_nolock@@YA?AUwrite_result@?A0x17268360@@HQEBDI@Z 0194 ?write_text_utf8_nolock@@YA?AUwrite_result@?A0x17268360@@HQEBDI@Z 01a8 ?write_text_ansi_nolock@@YA?AUwrite_result@?A0x17268360@@HQEBDI@Z 01c0 __imp_WriteFile 01e4 __imp_GetLastError 0244 __acrt_errno_map_os_error 028c __security_pop_cookie"
	strings:
		$1 = { FD 7B BB A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 23 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 16 00 00 11 34 00 00 91 55 00 00 11 75 00 00 35 00 00 80 52 95 00 00 14 34 01 00 B5 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 8C 00 00 14 C8 7E 40 93 ?? ?? ?? ?? 17 FD 46 93 ?? ?? ?? ?? 19 15 40 92 08 7B 77 F8 0A 19 19 8B 53 E5 C0 39 68 FE 03 11 09 1D 00 53 3F 05 00 71 48 00 00 54 95 FD 07 37 48 E1 40 39 A8 00 28 36 42 00 80 52 01 00 80 D2 C0 02 00 11 ?? ?? ?? ?? E8 13 00 91 FF 03 00 B9 C0 02 00 11 1F 01 00 F9 ?? ?? ?? ?? A0 04 00 34 08 7B 77 F8 09 19 19 8B 2A E1 40 39 2A 04 38 36 ?? ?? ?? ?? 08 48 40 F9 09 9D 40 F9 A9 00 00 B5 08 7B 77 F8 09 19 19 8B 2A E5 C0 39 2A 03 00 34 08 7B 77 F8 E1 43 00 91 09 19 19 8B ?? ?? ?? ?? ?? ?? ?? ?? 20 15 40 F9 09 FD DF C8 20 01 3F D6 00 02 00 34 53 01 00 34 68 06 00 51 1F 05 00 71 88 07 00 54 A1 02 00 11 80 02 00 91 ?? ?? ?? ?? E1 23 00 B9 E0 0F 00 F9 30 00 00 14 A2 02 00 11 81 02 00 91 C0 02 00 11 ?? ?? ?? ?? F9 FF FF 17 08 7B 77 F8 0A 19 19 8B 49 E1 40 39 A9 02 38 36 F3 01 00 34 7F 06 00 71 00 01 00 54 7F 0A 00 71 01 05 00 54 A2 02 00 11 81 02 00 91 C0 02 00 11 ?? ?? ?? ?? EB FF FF 17 A2 02 00 11 81 02 00 91 C0 02 00 11 ?? ?? ?? ?? E6 FF FF 17 A2 02 00 11 81 02 00 91 C0 02 00 11 ?? ?? ?? ?? E1 FF FF 17 40 15 40 F9 E8 73 00 91 FF 1B 00 B9 1F 01 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 04 00 80 D2 E3 73 00 91 A2 02 00 11 81 02 00 91 20 01 3F D6 C0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 1B 00 B9 E9 63 00 91 28 01 40 F9 EA 03 00 91 29 09 40 B9 48 01 00 F9 49 09 00 B9 E9 07 40 B9 69 03 00 35 E0 03 40 B9 80 01 00 34 1F 14 00 71 01 01 00 54 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? A8 00 80 52 08 00 00 B9 85 FF FF 17 ?? ?? ?? ?? 83 FF FF 17 08 7B 77 F8 09 19 19 8B 2A E1 40 39 8A 00 30 36 88 02 C0 39 1F 69 00 71 60 EE FF 54 ?? ?? ?? ?? 88 03 80 52 08 00 00 B9 ?? ?? ?? ?? 1F 00 00 B9 76 FF FF 17 E8 0B 40 B9 20 01 08 4B FF 83 00 91 ?? ?? ?? ?? F9 23 40 F9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_34_0_0 {
	meta:
		name = "wcscat"
		size = 48
	strings:
		$1 = { 08 00 40 79 0A 00 00 91 88 00 00 34 4A 09 00 91 49 01 40 79 C9 FF FF 35 4B 01 01 CB 2A 00 40 79 6A 69 21 78 21 08 00 91 AA FF FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_35_0_0 {
	meta:
		name = "cos"
		size = 936
		refs = "0054 _controlfp_s 00ec _handle_nan 00f4 ??_C@_03LALBNOCG@cos?$AA@ 0118 _handle_error 021c __remainder_piby2 029c sin_piby4"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 0A 00 66 9E 28 18 00 58 E0 0F 00 FD 49 F9 40 92 3F 01 08 EB A8 05 00 54 08 E4 E7 D2 3F 01 08 EB 42 02 00 54 08 C8 E7 D2 3F 01 08 EB 42 01 00 54 69 00 00 B5 00 10 6E 1E B2 00 00 14 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? F9 FF FF 17 10 08 60 1E 11 10 6C 1E 18 10 6E 1E 00 E2 51 1F A7 00 00 14 15 08 60 1E 32 15 00 5C 53 15 00 5C 11 10 6C 1E 59 15 00 5C B0 CE 52 1F B4 0A 71 1E 3A 15 00 5C 18 10 6E 1E 3B 15 00 5C 5C 15 00 5C 17 3B 74 1E E1 03 67 9E 11 E6 75 1F 10 3B 77 1E 14 3A 74 1E 32 6A 55 1F 11 D0 41 1F 53 EE 75 1F 76 72 55 1F B5 0A 75 1E D2 46 55 1F 40 2A 77 1E 8F 00 00 14 48 29 4C 92 0B FE EF D2 1F 01 0B EB 21 02 00 54 48 CD 40 92 88 00 00 B4 40 01 00 91 ?? ?? ?? ?? 86 00 00 14 ?? ?? ?? ?? E1 03 67 9E ?? ?? ?? ?? 26 00 80 52 25 04 80 52 04 01 80 52 23 00 80 52 02 FF FF D2 41 02 80 52 ?? ?? ?? ?? 7B 00 00 14 3F 01 0A EB 40 00 00 54 00 40 61 1E F0 10 00 5C 1A 10 6C 1E 00 20 70 1E FA 0B 00 FD A2 06 00 54 88 10 00 58 3F 01 08 EB 2A FD 74 D3 A8 00 00 54 48 10 00 58 4C 00 80 52 2B 00 80 52 07 00 00 14 08 10 00 58 3F 01 08 EB E8 00 00 54 E8 0F 00 58 8C 00 80 52 6B 00 80 52 3F 01 08 EB 89 81 8B 1A 04 00 00 14 70 0F 00 5C 10 68 50 1F 09 02 78 1E 39 01 62 1E 31 0F 00 5C 52 0F 00 5C 38 83 51 1F 33 0B 72 1E 08 03 66 9E F8 0F 00 FD 08 F9 74 D3 4A 01 08 CB 5F 3D 00 F1 29 02 00 54 70 0E 00 5C 5F C1 00 F1 15 43 60 1E 54 0E 00 5C 38 E3 50 1F B1 3A 78 1E 33 C7 50 1F 33 CF 74 1F 09 01 00 54 D2 0D 00 5C 17 43 60 1E D6 0D 00 5C 38 E3 52 1F F4 3A 78 1E 35 D3 52 1F 33 D7 76 1F 00 3B 73 1E 28 05 00 12 10 3B 60 1E 01 3A 73 1E 08 00 00 14 E2 63 00 91 E1 A3 00 91 E0 83 00 91 ?? ?? ?? ?? E0 07 42 6D E8 1B 40 B9 FA 0B 40 FD 1F 05 00 71 80 06 00 54 1F 09 00 71 60 03 00 54 1F 0D 00 71 E0 02 00 54 14 08 60 1E 92 06 00 5C B3 06 00 5C D9 06 00 5C 18 10 6E 1E 90 CE 52 1F 97 0A 7A 1E 9A 06 00 5C BB 06 00 5C DC 06 00 5C 16 3B 77 1E 11 E6 74 1F 10 3B 76 1E 32 6A 54 1F 11 3A 77 1E 53 EE 74 1F 32 C4 40 1F 75 72 54 1F 94 0A 74 1E B3 4A 54 1F 60 2A 76 1E 1C 00 00 14 ?? ?? ?? ?? 1A 00 00 14 14 08 60 1E 92 03 00 5C B3 03 00 5C D9 03 00 5C 18 10 6E 1E 90 CE 52 1F 97 0A 7A 1E 9A 03 00 5C BB 03 00 5C DC 03 00 5C 16 3B 77 1E 11 E6 74 1F 10 3B 76 1E 32 6A 54 1F 11 3A 77 1E 53 EE 74 1F 32 C4 40 1F 75 72 54 1F 94 0A 74 1E B3 4A 54 1F 74 2A 76 1E 80 42 61 1E 03 00 00 14 ?? ?? ?? ?? 00 40 61 1E FD 7B C3 A8 C0 03 5F D6 18 2D 44 54 FB 21 E9 3F 42 5E CC 46 DB 07 A9 3D 78 AB 37 90 B6 EE 21 3E F6 65 7F A1 4F 7E 92 3E 90 EC F4 19 A0 01 FA 3E 67 69 C1 16 6C C1 56 3F 55 55 55 55 55 55 A5 3F 00 00 00 00 80 84 1E 41 5E 38 55 29 7A 6A 0F 40 D2 21 33 7F 7C D9 02 40 BB B2 CC BE 3A 46 1C 40 75 A7 BB E9 BB FD 15 40 83 C8 C9 6D 30 5F E4 3F 00 00 40 54 FB 21 F9 3F 31 63 62 1A 61 B4 D0 3D 00 00 60 1A 61 B4 D0 3D 73 70 03 2E 8A 19 A3 3B 00 00 00 2E 8A 19 A3 3B C1 49 20 25 9A 83 7B 39 }
	condition:
		$1
}

rule file_35_1_0 {
	meta:
		name = "cos_piby4"
		size = 144
	strings:
		$1 = { 18 08 60 1E F2 02 00 5C 11 03 00 5C 10 10 6C 1E 17 10 6E 1E 13 C7 52 1F D2 02 00 5C 1B 0B 70 1E FA 3A 7B 1E 74 CA 78 1F 93 02 00 5C 95 4E 58 1F 94 02 00 5C B6 D2 78 1F 95 02 00 5C D9 56 58 1F F6 3A 7A 1E 18 0B 78 1E D7 3A 7B 1E 10 DC 41 1F 38 43 58 1F 00 2B 7A 1E C0 03 5F D6 1F 20 03 D5 42 5E CC 46 DB 07 A9 3D 78 AB 37 90 B6 EE 21 3E F6 65 7F A1 4F 7E 92 3E 90 EC F4 19 A0 01 FA 3E 67 69 C1 16 6C C1 56 3F 55 55 55 55 55 55 A5 3F }
	condition:
		$1
}

rule file_35_3_0 {
	meta:
		name = "sin"
		size = 928
		refs = "0058 _controlfp_s 0080 sin_piby4 00a4 _handle_nan 00ac ??_C@_03BLEJJJBH@sin?$AA@ 00d4 _handle_error 01e0 __remainder_piby2"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 0A 00 66 9E 88 17 00 58 13 40 60 1E 49 F9 40 92 F3 CF 01 6D 3F 01 08 EB 28 03 00 54 08 E4 E7 D2 3F 01 08 EB 42 02 00 54 08 C8 E7 D2 3F 01 08 EB 42 01 00 54 49 00 00 B5 AB 00 00 14 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? E0 13 40 FD A4 00 00 14 70 0A 73 1E 11 15 00 5C 12 0A 73 1E 40 CE 51 1F 9F 00 00 14 E1 03 67 9E 60 42 60 1E ?? ?? ?? ?? 9B 00 00 14 48 29 4C 92 0B FE EF D2 1F 01 0B EB 41 02 00 54 48 CD 40 92 88 00 00 B4 40 01 00 91 ?? ?? ?? ?? 92 00 00 14 ?? ?? ?? ?? E1 03 67 9E 60 42 60 1E ?? ?? ?? ?? 26 00 80 52 25 04 80 52 04 01 80 52 23 00 80 52 02 FF FF D2 C1 03 80 52 ?? ?? ?? ?? 86 00 00 14 3F 01 0A EB F3 07 9F 1A 53 00 00 34 73 42 61 1E 30 11 00 5C 1B 10 6C 1E 60 22 70 1E FB 13 00 FD A2 06 00 54 C8 10 00 58 3F 01 08 EB 2A FD 74 D3 A8 00 00 54 88 10 00 58 4C 00 80 52 2B 00 80 52 07 00 00 14 48 10 00 58 3F 01 08 EB E8 00 00 54 28 10 00 58 8C 00 80 52 6B 00 80 52 3F 01 08 EB 89 81 8B 1A 04 00 00 14 B0 0F 00 5C 70 6E 50 1F 09 02 78 1E 39 01 62 1E 71 0F 00 5C 92 0F 00 5C 38 CF 51 1F 34 0B 72 1E 08 03 66 9E F8 13 00 FD 08 F9 74 D3 4A 01 08 CB 5F 3D 00 F1 29 02 00 54 B0 0E 00 5C 5F C1 00 F1 15 43 60 1E 94 0E 00 5C 38 E3 50 1F B1 3A 78 1E 33 C7 50 1F 34 CF 74 1F 09 01 00 54 12 0E 00 5C 17 43 60 1E 16 0E 00 5C 38 E3 52 1F F4 3A 78 1E 35 D3 52 1F 34 D7 76 1F 19 3B 74 1E 28 05 00 12 10 3B 79 1E 1A 3A 74 1E 09 00 00 14 60 42 60 1E E2 63 00 91 E1 C3 00 91 E0 A3 00 91 ?? ?? ?? ?? F9 EB 42 6D E8 1B 40 B9 FB 13 40 FD 1F 05 00 71 53 04 00 34 40 01 00 54 1F 09 00 71 80 04 00 54 1F 0D 00 71 A0 04 00 54 41 43 60 1E 20 43 60 1E ?? ?? ?? ?? 00 40 61 1E 35 00 00 14 34 0B 79 1E 71 0A 00 5C 90 0A 00 5C B2 0A 00 5C D3 0A 00 5C 90 C6 50 1F 97 0A 7B 1E 18 10 6E 1E 95 0A 00 5C BC 0A 00 5C 16 3B 77 1E 11 CA 74 1F 10 3B 76 1E 32 4E 54 1F 11 3A 77 1E 53 D6 74 1F 52 C7 59 1F 75 72 54 1F 94 0A 74 1E B3 4A 54 1F 74 2A 76 1E 80 42 61 1E 1E 00 00 14 00 01 00 54 1F 09 00 71 40 FC FF 54 1F 0D 00 71 A0 FC FF 54 41 43 60 1E 20 43 60 1E 7A FF FF 17 34 0B 79 1E 91 06 00 5C B0 06 00 5C D2 06 00 5C F3 06 00 5C 90 C6 50 1F 97 0A 7B 1E 18 10 6E 1E B5 06 00 5C DC 06 00 5C 16 3B 77 1E 11 CA 74 1F 10 3B 76 1E 32 4E 54 1F 11 3A 77 1E 53 D6 74 1F 52 C7 59 1F 75 72 54 1F 94 0A 74 1E B3 4A 54 1F 60 2A 76 1E FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 18 2D 44 54 FB 21 E9 3F 55 55 55 55 55 55 C5 3F 00 00 00 00 80 84 1E 41 5E 38 55 29 7A 6A 0F 40 D2 21 33 7F 7C D9 02 40 BB B2 CC BE 3A 46 1C 40 75 A7 BB E9 BB FD 15 40 83 C8 C9 6D 30 5F E4 3F 00 00 40 54 FB 21 F9 3F 31 63 62 1A 61 B4 D0 3D 00 00 60 1A 61 B4 D0 3D 73 70 03 2E 8A 19 A3 3B 00 00 00 2E 8A 19 A3 3B C1 49 20 25 9A 83 7B 39 78 AB 37 90 B6 EE 21 3E 42 5E CC 46 DB 07 A9 3D F6 65 7F A1 4F 7E 92 3E 90 EC F4 19 A0 01 FA 3E 67 69 C1 16 6C C1 56 3F 55 55 55 55 55 55 A5 3F }
	condition:
		$1
}

rule file_35_4_0 {
	meta:
		name = "sin_piby4"
		size = 160
	strings:
		$1 = { 15 08 60 1E 31 03 00 5C 50 03 00 5C 28 20 60 1E B2 C2 71 1F 31 03 00 5C B9 0A 60 1E 53 46 55 1F 12 03 00 5C 74 CA 75 1F 13 03 00 5C 98 4E 55 1F A1 00 00 54 F4 02 00 5C 15 D3 75 1F A0 02 59 1F 08 00 00 14 16 10 6C 1E 91 02 00 5C 37 08 76 1E 10 DF 59 1F 18 86 75 1F 38 E3 51 1F 00 38 78 1E C0 03 5F D6 1F 20 03 D5 B8 3B A4 F9 B2 E0 E5 3D A7 DF 2F B4 00 E6 5A 3E 01 DE 6C 79 E3 1D C7 3E 5C 3E E8 19 A0 01 2A 3F B3 0B 11 11 11 11 81 3F 55 55 55 55 55 55 C5 3F 55 55 55 55 55 55 C5 BF }
	condition:
		$1
}

rule file_36_1_0 {
	meta:
		name = "clogl"
		size = 488
		refs = "0010 creall 0020 cimagl 002c _ldtest 0094 atan2 0100 _fperrraise 0104 _LInf_C 013c _ld_int 017c log1pl 0190 log 01c4 _LCbuild"
	strings:
		$1 = { F3 53 BF A9 FD 7B BB A9 FD 03 00 91 E0 07 04 6D ?? ?? ?? ?? E1 27 40 FD E0 0F 00 FD E0 23 40 FD ?? ?? ?? ?? E0 63 00 91 E0 0B 00 FD ?? ?? ?? ?? 14 00 00 11 E0 43 00 91 ?? ?? ?? ?? 9F 0A 00 71 13 00 00 11 01 01 00 54 7F 06 00 71 61 00 00 54 E1 0F 40 FD 5A 00 00 14 E0 0F 40 FD 01 40 60 1E 59 00 00 14 7F 0A 00 71 E1 00 00 54 9F 06 00 71 61 00 00 54 E1 0B 40 FD 51 00 00 14 E0 0B 40 FD F7 FF FF 17 F2 47 41 6D 21 42 60 1E F1 4B 02 6D 40 42 60 1E ?? ?? ?? ?? 9F 06 00 71 E0 1B 00 FD 64 1A 41 7A A0 08 00 54 F2 13 40 FD 48 22 60 1E 62 00 00 54 52 42 61 1E F2 CB 01 6D F3 17 40 FD 68 22 60 1E 82 00 00 54 73 42 61 1E F3 17 00 FD F3 0B 00 FD 40 22 73 1E E2 00 00 54 50 42 60 1E 72 42 60 1E 13 42 60 1E F2 CB 01 6D F3 17 00 FD F3 0B 00 FD 48 22 60 1E 01 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 42 61 1E E1 1B 40 FD 2C 00 00 14 10 06 00 5C 40 22 70 1E 68 03 00 54 F1 05 00 5C 20 22 73 1E 08 03 00 54 41 03 80 52 F2 4F 02 6D E0 83 00 91 ?? ?? ?? ?? 41 03 80 52 E0 A3 00 91 ?? ?? ?? ?? F4 5B 42 6D F0 4F 41 6D 11 3A 76 1E D0 2A 70 1E 72 3A 74 1E 35 0A 70 1E 91 2A 73 1E 55 56 51 1F 12 10 6E 1E 93 CA 74 1F D4 4E 56 1F A0 2A 74 1E ?? ?? ?? ?? 11 10 6C 1E 00 08 71 1E E2 FF FF 17 40 42 60 1E ?? ?? ?? ?? F1 4B 42 6D E0 1F 00 FD 50 1A 71 1E 00 0A 70 1E ?? ?? ?? ?? F0 1F 40 FD 11 10 6C 1E 00 40 51 1F D7 FF FF 17 01 40 60 1E ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C5 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 CD CC CC CC CC CC EC 3F 9A 99 99 99 99 99 D9 3F }
	condition:
		$1
}

rule file_37_0_0 {
	meta:
		name = "coshf"
		size = 808
		refs = "0054 _controlfp_s 0078 _handle_nanf 00bc ??_C@_05NHNGJKPP@coshf?$AA@ 00e0 _handle_errorf 0130 ?two_to_jby32_trail_table@?1??splitexp@@9@9 013c ?two_to_jby32_lead_table@?1??splitexp@@9@9 01c4 ?sinh_lead@?1??coshf@@9@9 01e0 ?cosh_lead@?1??coshf@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 15 C0 22 1E 0A E2 E7 D2 07 10 6E 1E A9 02 66 9E F5 0B 00 FD 28 F9 40 92 1F 01 0A EB C2 01 00 54 68 00 00 B5 00 10 2E 1E 8E 00 00 14 F0 11 00 5C B1 2A 70 1E 20 22 67 1E 2D 03 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? F5 FF FF 17 0A FE EF D2 1F 01 0A EB 03 02 00 54 1F 01 0A EB A9 00 00 54 00 00 26 1E E0 13 00 BD ?? ?? ?? ?? 7B 00 00 14 02 00 80 52 FF 13 00 B9 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 08 F0 AF 52 E8 13 00 B9 00 01 27 1E 72 00 00 14 1F 01 09 EB 40 00 00 54 B5 42 61 1E 50 0E 00 5C A0 22 70 1E 8B 01 00 54 ?? ?? ?? ?? E1 03 27 1E ?? ?? ?? ?? 26 00 80 52 45 04 80 52 24 02 80 52 63 00 80 52 02 F0 AF D2 61 02 80 52 ?? ?? ?? ?? 61 00 00 14 D0 0C 00 5C A0 22 70 1E 8B 06 00 54 B1 0C 00 5C 1B 10 6C 1E B2 0A 71 1E 48 22 60 1E 8D 00 00 54 52 2A 7B 1E 4A 02 78 1E 03 00 00 14 53 3A 7B 1E 6A 02 78 1E 54 01 62 1E E8 03 0A 4B 70 0B 00 5C 49 11 00 12 71 0B 00 5C ?? ?? ?? ?? 9A D6 50 1F 15 01 62 1E ?? ?? ?? ?? 10 0B 00 5C ?? ?? ?? ?? 18 D9 69 FC ?? ?? ?? ?? 17 D9 69 FC 49 01 09 4B 28 7D 04 13 29 6D 48 0B 2A 7D 05 13 4B 05 00 51 68 7D 40 93 B9 0A 71 1E 09 FE E7 D2 B1 09 00 5C 28 D1 08 8B E8 0B 00 F9 36 2B 7A 1E D2 42 51 1F 51 09 00 5C 53 46 56 1F 52 09 00 5C 74 4A 56 1F D3 0A 76 1E 95 6E 56 1F B4 66 53 1F F5 2A 78 1E 96 2A 7A 1E D6 5E 55 1F 17 01 67 9E D8 2A 78 1E 1C 0B 77 1E 2A 00 00 14 A9 02 78 1E ?? ?? ?? ?? D2 07 00 5C ?? ?? ?? ?? D1 07 00 5C 30 01 62 1E B9 3A 70 1E 10 D9 69 FC ?? ?? ?? ?? ?? ?? ?? ?? 3F 0B 79 1E F3 47 52 1F 12 07 00 5C 31 07 00 5C 74 4A 5F 1F 33 07 00 5C 52 07 00 5C 95 4E 5F 1F 54 07 00 5C 73 07 00 5C B6 52 5F 1F 75 07 00 5C D7 56 5F 1F 76 07 00 5C F8 5A 5F 1F F7 0B 79 1E 19 67 57 1F 38 07 00 5C 3E 0B 70 1E 39 07 00 5C FA 63 59 1F 39 07 00 5C 5B 67 5F 1F 7C 47 5F 1F 1B 10 6C 1E 9D 4B 5F 1F B4 4F 5F 1F 94 6E 5F 1F 95 1E 5F 1F 14 D9 69 FC BC 7A 54 1F 80 43 62 1E FD 7B C2 A8 C0 03 5F D6 9C 75 00 88 3C E4 37 7E 63 2E F8 84 9F 5A 56 40 5F 82 95 1B D2 0F 42 40 FE 82 2B 65 47 15 47 40 00 00 00 FE 42 2E 96 3F 8E 27 AF E6 3D 47 CF 3D 5E 90 AA B7 15 11 81 3F 65 97 73 8D 72 C1 56 3F 4E 5D 54 55 55 55 A5 3F 7C 8F 54 55 55 55 C5 3F 8B A0 1E 92 25 41 6B 3D BE B7 DC 2B CB 11 E6 3D C0 61 BE 0F 46 E6 5A 3E 11 90 07 19 A0 01 FA 3E 7D 3E E1 A4 E3 1D C7 3E E5 12 C2 16 6C C1 56 3F 80 EE 01 1A A0 01 2A 3F 02 55 55 55 55 55 A5 3F FD 10 11 11 11 11 81 3F 55 55 55 55 55 55 C5 3F 20 7B 5B 38 56 EE 21 3E D7 FC 63 7F 4B 98 A9 3D 55 CB F1 69 50 7E 92 3E }
	condition:
		$1
}

rule file_37_5_0 {
	meta:
		name = "valf_with_flags"
		size = 44
		refs = "001c _controlfp_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 02 00 00 11 E0 17 00 BD 01 00 00 11 FF 13 00 B9 E0 43 00 91 ?? ?? ?? ?? E0 17 40 BD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_38_0_0 {
	meta:
		name = "_copysignf"
		size = 44
	strings:
		$1 = { FF 43 00 D1 28 00 26 1E E1 03 00 2D 09 00 26 1E 08 01 09 4A 88 00 F8 36 29 01 01 52 E9 07 00 B9 20 01 27 1E FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_39_0_0 {
	meta:
		name = "_ldpoly"
		size = 36
		altNames = "_dpoly"
	strings:
		$1 = { 11 40 60 1E 28 04 00 51 00 00 40 FD A8 00 F8 37 10 8C 40 FC 08 05 00 51 00 40 51 1F A8 FF FF 36 C0 03 5F D6 }
	condition:
		$1
}

rule file_39_1_0 {
	meta:
		name = "erfcl"
		size = 648
		refs = "0010 _ldtest 003c erfl 0068 s00 008c c00 00b8 s01 00dc c01 0104 approx 013c _fperrraise 01e0 _ld_int 01f4 exp 0218 _ldexp"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 63 00 91 E0 0F 00 FD ?? ?? ?? ?? 80 11 00 34 1F 04 00 71 80 10 00 54 1F 08 00 71 00 10 00 54 F2 0F 40 FD 30 11 00 5C 40 22 70 1E C2 00 00 54 40 42 60 1E ?? ?? ?? ?? 10 10 6E 1E 00 3A 60 1E 80 00 00 14 70 10 00 5C 40 22 70 1E 82 05 00 54 10 10 6E 1E 40 22 70 1E A2 02 00 54 10 10 6D 1E ?? ?? ?? ?? ?? ?? ?? ?? 94 0F 00 5C E8 00 80 52 55 3A 70 1E 31 8D 40 FC 08 05 00 51 94 46 55 1F A8 FF FF 36 ?? ?? ?? ?? D3 0E 00 5C ?? ?? ?? ?? 09 01 80 52 50 8D 40 FC 29 05 00 51 73 42 55 1F A9 FF FF 36 80 1A 73 1E 66 00 00 14 F1 0D 00 5C ?? ?? ?? ?? ?? ?? ?? ?? D5 0D 00 5C E8 00 80 52 56 3A 71 1E 70 8D 40 FC 08 05 00 51 B5 42 56 1F A8 FF FF 36 ?? ?? ?? ?? 13 0D 00 5C ?? ?? ?? ?? 09 01 80 52 51 8D 40 FC 29 05 00 51 73 46 56 1F A9 FF FF 36 A0 1A 73 1E 52 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 48 7D 40 93 0C 06 80 D2 09 7D 0C 9B 30 69 6B FC 40 22 70 1E 23 01 00 54 4A 05 00 11 48 7D 40 93 1F 19 00 F1 E3 FE FF 54 00 02 80 52 ?? ?? ?? ?? E0 03 67 9E 41 00 00 14 10 10 6E 1E 48 7D 40 93 09 06 80 D2 0E 7D 09 9B 68 21 00 91 11 1A 72 1E D0 69 68 FC 68 41 00 91 CD 69 68 F8 68 61 00 91 C9 69 68 B8 2C 05 00 51 33 3A 70 1E F3 0B 00 FD B0 01 40 FD F0 17 00 FD CC 00 F8 37 B1 8D 40 FC 8C 05 00 51 10 46 53 1F AC FF FF 36 F0 17 00 FD 68 81 00 91 CD 69 68 F8 68 A1 00 91 C9 69 68 B8 B1 01 40 FD 2A 05 00 51 F1 13 00 FD CA 00 F8 37 B0 8D 40 FC 4A 05 00 51 31 42 53 1F AA FF FF 36 F1 13 00 FD 21 02 80 52 F2 0B 00 FD E0 43 00 91 ?? ?? ?? ?? F2 43 41 6D 51 3A 70 1E 50 2A 70 1E 20 0A 70 1E ?? ?? ?? ?? F0 0B 40 FD 01 00 80 52 F1 4B 42 6D E0 43 00 91 10 8A 70 1E F0 0B 00 FD 50 1A 71 1E 00 0A 60 1E ?? ?? ?? ?? E0 0B 40 FD 0A 00 00 14 E0 0F 40 FD 08 00 00 14 E8 3F 40 79 10 10 60 1E F1 03 67 9E 1F 01 11 72 00 1E 71 1E 02 00 00 14 00 10 6E 1E FD 7B C3 A8 C0 03 5F D6 0A C0 24 BB 1F 86 DE 3F 91 ED 7C 3F 35 5E F8 3F A9 9B E2 EB 08 E3 2A 3F 49 B8 C7 5A 1F B3 CF BE 00 00 00 00 00 80 F4 3F 59 20 36 18 2F 33 E0 3E EC F4 CD C2 BC 5B 21 3F }
	condition:
		$1
}

rule file_40_0_0 {
	meta:
		name = "expf"
		size = 556
		refs = "0038 _handle_nanf 0068 ??_C@_04KBNCNMNN@expf?$AA@ 0080 _handle_errorf 0138 ?two_to_jby32_lead_table@?1??splitexpf@@9@9 014c ?two_to_jby32_trail_table@?1??splitexpf@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 09 00 26 1E AA 0F 00 18 E0 13 00 BD 28 79 00 12 1F 01 0A 6B 43 04 00 54 0A F0 AF 52 1F 01 0A 6B 43 01 00 54 28 59 00 12 88 00 00 34 20 01 00 91 ?? ?? ?? ?? 6E 00 00 14 E1 03 27 1E 3F 01 01 72 20 1C 20 1E 6A 00 00 14 B0 0D 00 1C 00 20 30 1E 8B 01 00 54 24 02 80 52 63 00 80 52 02 F0 AF D2 ?? ?? ?? ?? E1 03 27 1E ?? ?? ?? ?? 45 04 80 52 26 00 80 52 81 02 80 52 ?? ?? ?? ?? 5C 00 00 14 10 0C 00 1C 00 20 30 1E A2 00 00 54 44 02 80 52 83 00 80 52 02 00 80 D2 F2 FF FF 17 09 90 A7 52 1F 01 09 6B C2 02 00 54 09 50 A6 52 1F 01 09 6B 82 00 00 54 10 10 2E 1E 00 28 30 1E 4C 00 00 14 31 0A 00 1C 30 0A 00 1C 35 0A 00 1C 19 10 2C 1E 12 40 11 1F F1 09 00 1C 10 10 2E 1E 53 46 00 1F B2 09 00 1C 74 4A 00 1F 95 56 00 1F B6 66 00 1F D4 42 00 1F 80 42 00 1F 3D 00 00 14 F3 08 00 1C 19 10 2C 1E 10 08 33 1E 08 22 20 1E 8D 00 00 54 10 2A 39 1E 0A 02 38 1E 03 00 00 14 11 3A 39 1E 2A 02 38 1E 54 01 22 1E E8 03 0A 4B 15 01 22 1E ?? ?? ?? ?? 52 07 00 1C ?? ?? ?? ?? 33 07 00 1C 49 11 00 12 ?? ?? ?? ?? 1A D9 69 BC ?? ?? ?? ?? 16 D9 69 BC 49 01 09 4B 28 7D 04 13 29 6D 48 0B 98 82 12 1F 2C 7D 05 13 B7 0A 33 1E 88 F9 01 11 F5 04 00 1C 1F F5 03 71 D2 2A 3A 1E F0 2A 38 1E 11 66 15 1F 10 0A 30 1E 31 5E 10 1F 33 2A 38 1E 74 5A 12 1F 08 01 00 54 88 FD 01 11 55 2B 34 1E 09 21 09 53 34 01 27 1E E9 13 00 B9 A0 0A 34 1E 0F 00 00 14 88 7D 4C 0B 51 2B 34 1E 0B 7D 01 13 69 FD 01 11 2A 21 09 53 EA 13 00 B9 88 01 0B 4B F0 13 40 BD 09 FD 01 11 2A 21 09 53 EA 17 00 B9 32 0A 30 1E 51 01 27 1E 40 0A 31 1E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 18 72 B1 42 18 72 B1 42 D0 8E CE C2 01 0D 50 39 61 0B B6 3A AB AA 2A 3E 89 88 08 3C AB AA 2A 3D 3B AA 38 42 00 70 B1 3C F4 FD 85 35 }
	condition:
		$1
}

rule file_40_1_0 {
	meta:
		name = "scaleFloat_1"
		size = 32
	strings:
		$1 = { FF 43 00 D1 08 FC 01 11 09 21 09 53 30 01 27 1E E9 03 00 B9 00 0A 20 1E FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_2_0 {
	meta:
		name = "scaleFloat_2"
		size = 64
	strings:
		$1 = { FF 43 00 D1 08 7C 40 0B 0B 7D 01 13 69 FD 01 11 2A 21 09 53 EA 03 00 B9 08 00 0B 4B F0 03 40 BD 09 FD 01 11 2A 21 09 53 51 01 27 1E EA 07 00 B9 12 0A 20 1E 40 0A 31 1E FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_40_3_0 {
	meta:
		name = "splitexpf"
		size = 156
		refs = "0024 ?two_to_jby32_lead_table@?1??splitexpf@@9@9 0038 ?two_to_jby32_trail_table@?1??splitexpf@@9@9"
	strings:
		$1 = { 10 08 22 1E 15 10 2C 1E 08 22 20 1E 8D 00 00 54 10 2A 35 1E 0B 02 38 1E 03 00 00 14 11 3A 35 1E 2B 02 38 1E ?? ?? ?? ?? 70 01 22 1E ?? ?? ?? ?? 54 03 00 1C 69 11 00 12 ?? ?? ?? ?? 1A D9 69 BC ?? ?? ?? ?? 19 D9 69 BC 69 01 09 4B 28 7D 04 13 29 6D 48 0B E8 03 0B 4B 12 01 22 1E 2A 7D 05 13 11 82 03 1F 0A 00 00 B9 3A 00 00 BD 53 0A 24 1E 77 0A 21 1E 36 5E 01 1F D5 56 14 1F D4 0A 36 1E 36 2B 3A 1E B5 5E 14 1F 37 56 01 1F F7 66 16 1F 57 00 00 BD C0 03 5F D6 AB AA 2A 3E }
	condition:
		$1
}

rule file_41_0_0 {
	meta:
		name = "_get_sys_err_msg"
		size = 76
		refs = "0010 __sys_nerr 0020 __sys_errlist"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 ?? ?? ?? ?? 08 00 40 B9 7F C2 28 EB E3 00 00 54 ?? ?? ?? ?? 13 00 00 91 ?? ?? ?? ?? 08 00 40 B9 60 DA 68 F8 03 00 00 14 ?? ?? ?? ?? 00 78 73 F8 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_41_1_0 {
	meta:
		name = "perror"
		size = 224
		refs = "0014 __acrt_lowio_lock_fh 0044 _write_nolock 004c ??_C@_02LMMGGCAJ@?3?5?$AA@ 005c _errno 0064 __sys_nerr 0074 __sys_errlist 00b8 ??_C@_01EEMJAFIK@?6?$AA@ 00cc __acrt_lowio_unlock_fh"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 40 00 80 52 ?? ?? ?? ?? 33 02 00 B4 68 02 C0 39 E8 01 00 34 6A 02 00 91 49 01 C0 39 69 00 00 34 4A 05 00 91 FD FF FF 17 42 01 13 CB 61 02 00 91 40 00 80 52 ?? ?? ?? ?? 42 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 80 B9 ?? ?? ?? ?? 08 00 40 B9 7F C2 28 EB E3 00 00 54 ?? ?? ?? ?? 13 00 00 91 ?? ?? ?? ?? 08 00 40 B9 61 DA 68 F8 03 00 00 14 ?? ?? ?? ?? 01 78 73 F8 29 00 00 91 28 01 C0 39 68 00 00 34 29 05 00 91 FD FF FF 17 22 01 01 CB 40 00 80 52 ?? ?? ?? ?? 22 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_41_2_0 {
	meta:
		name = "perror$fin$0"
		size = 32
		refs = "000c __acrt_lowio_unlock_fh"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 40 00 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_42_0_0 {
	meta:
		name = "__acrt_LCMapStringW"
		size = 148
		refs = "0040 wcsnlen 0078 __acrt_LCMapStringEx"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BF A9 FD 03 00 91 FF 43 00 D1 73 00 00 11 7F 02 00 71 15 00 00 91 36 00 00 11 54 00 00 91 97 00 00 91 B8 00 00 11 0D 01 00 54 61 7E 40 93 80 02 00 91 ?? ?? ?? ?? 1F 00 13 6B 13 04 00 11 4B 00 00 54 13 00 00 11 07 00 80 D2 FF 03 00 F9 06 00 80 D2 05 03 00 11 E4 02 00 91 63 02 00 11 82 02 00 91 C1 02 00 11 A0 02 00 91 ?? ?? ?? ?? FF 43 00 91 FD 7B C1 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_43_0_0 {
	meta:
		name = "_getdllprocaddr"
		size = 52
		refs = "0014 __imp_GetProcAddress"
	strings:
		$1 = { 21 01 00 B5 E8 FF 9F D2 5F 00 08 EB 0C 01 00 54 41 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 5F 04 00 B1 60 FF FF 54 00 00 80 D2 C0 03 5F D6 }
	condition:
		$1
}

rule file_44_0_0 {
	meta:
		name = "log1pf"
		size = 172
		refs = "0010 _fdtest 0050 _fperrraise 0054 _FNan_C 0070 _FInf_C 008c logf"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 13 00 BD ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 C0 00 00 54 1F 08 00 71 C1 00 00 54 E0 13 40 BD FD 7B C2 A8 C0 03 5F D6 E8 27 40 79 88 FF 7F 36 F1 13 40 BD 10 10 3E 1E 20 22 30 1E C2 00 00 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F4 FF FF 17 20 22 30 1E E1 00 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 42 21 1E EC FF FF 17 10 10 2E 1E 20 2A 30 1E F0 17 00 BD ?? ?? ?? ?? F2 43 42 2D 51 2A 30 1E 30 3A 30 1E 10 3A 32 1E 11 1A 31 1E 00 38 31 1E E1 FF FF 17 }
	condition:
		$1
}

rule file_45_3_0 {
	meta:
		name = "??1?$__crt_scoped_stack_ptr@_W@@QEAA@XZ"
		size = 36
		refs = "001c _free_base"
		altNames = "??1?$__crt_scoped_stack_ptr@D@@QEAA@XZ ??1?$__crt_scoped_stack_ptr@U_INPUT_RECORD@@@@QEAA@XZ"
	strings:
		$1 = { 08 00 40 F9 E8 00 00 B4 00 41 00 D1 08 00 40 B9 A9 BB 9B 52 1F 01 09 6B 41 00 00 54 ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_45_6_0 {
	meta:
		name = "?InternalCompareStringA@@YAHPEAU__crt_locale_pointers@@PEB_WKPEBDH2HH@Z"
		size = 1028
		refs = "001c __security_push_cookie 0058 __strncnt 00d8 __imp_GetCPInfo 0184 __imp_MultiByteToWideChar 0208 __chkstk 0228 _malloc_base 0388 __acrt_CompareStringEx 03b0 _free_base 03e4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 73 05 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 FC 43 00 91 93 00 00 11 7F 02 00 71 14 00 00 91 3B 00 00 91 5A 00 00 11 76 00 00 91 B9 00 00 91 D5 00 00 11 F7 00 00 11 8D 01 00 54 61 7E 40 93 C0 02 00 91 ?? ?? ?? ?? 13 00 00 11 BF 02 00 71 4D 01 00 54 A1 7E 40 93 20 03 00 91 ?? ?? ?? ?? 15 00 00 11 07 00 00 14 7F 06 00 31 0A FF FF 54 00 00 80 52 D5 00 00 14 BF 06 00 31 AB FF FF 54 77 00 00 35 88 02 40 F9 17 0D 40 B9 53 00 00 34 15 07 00 35 7F 02 15 6B 61 00 00 54 40 00 80 52 CA 00 00 14 BF 06 00 71 6D 00 00 54 20 00 80 52 C6 00 00 14 7F 06 00 71 6D 00 00 54 60 00 80 52 C2 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 81 03 00 91 E0 02 00 11 20 01 3F D6 A0 FC FF 34 7F 02 00 71 2D 02 00 54 88 03 40 B9 1F 09 00 71 63 FE FF 54 88 1B 40 39 8A 1B 00 91 08 FE FF 34 4B 05 40 39 CB FD FF 34 C9 02 40 39 48 01 40 39 3F 01 08 6B 2A 21 4B 7A 29 FC FF 54 49 2D 40 38 09 FF FF 35 E6 FF FF 17 BF 02 00 71 2D 02 00 54 88 03 40 B9 1F 09 00 71 A3 FB FF 54 88 1B 40 39 8A 1B 00 91 48 FB FF 34 4B 05 40 39 0B FB FF 34 29 03 40 39 48 01 40 39 3F 01 08 6B 2A 21 4B 7A E9 F9 FF 54 49 2D 40 38 09 FF FF 35 D0 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 05 00 80 52 04 00 80 D2 63 02 00 11 C2 02 00 91 21 01 80 52 E0 02 00 11 20 01 3F D6 18 00 00 11 B8 F6 FF 34 0A 7F 40 93 4B F9 7F D3 68 41 00 91 1F 01 0B EB 09 81 9F 9A 8C 99 99 52 C9 03 00 B4 68 41 00 91 1F 05 0A EB 08 81 9F 9A 1F 01 10 F1 48 F9 7F D3 09 41 00 91 C8 01 00 54 3F 01 08 EB 2A 81 9F 9A 4B 3D 00 91 7F 01 0A EB 4C 00 00 54 EB DF 7C B2 6F FD 44 D3 ?? ?? ?? ?? FF 73 2F CB F4 43 00 91 B4 01 00 B4 8C 02 00 B9 08 00 00 14 3F 01 08 EB 20 81 9F 9A ?? ?? ?? ?? 14 00 00 91 D4 00 00 B4 A8 BB 9B 52 88 02 00 B9 94 42 00 91 02 00 00 14 14 00 80 D2 94 0B 00 B4 63 02 00 11 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 05 03 00 11 84 02 00 91 C2 02 00 91 21 00 80 52 E0 02 00 11 20 01 3F D6 20 0A 00 34 ?? ?? ?? ?? 09 FD DF C8 05 00 80 52 04 00 80 D2 A3 02 00 11 22 03 00 91 21 01 80 52 E0 02 00 11 20 01 3F D6 16 00 00 11 D6 08 00 34 C9 7E 40 93 2A F9 7F D3 48 41 00 91 1F 01 0A EB 08 81 9F 9A C8 03 00 B4 48 41 00 91 1F 05 09 EB 08 81 9F 9A 1F 01 10 F1 28 F9 7F D3 09 41 00 91 C8 01 00 54 3F 01 08 EB 2A 81 9F 9A 4B 3D 00 91 7F 01 0A EB 4C 00 00 54 EB DF 7C B2 6F FD 44 D3 ?? ?? ?? ?? FF 73 2F CB F3 43 00 91 B3 01 00 B4 88 99 99 52 07 00 00 14 3F 01 08 EB 20 81 9F 9A ?? ?? ?? ?? 13 00 00 91 D3 00 00 B4 A8 BB 9B 52 68 02 00 B9 73 42 00 91 02 00 00 14 13 00 80 D2 13 03 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 C5 02 00 11 64 02 00 91 A3 02 00 11 22 03 00 91 21 00 80 52 E0 02 00 11 20 01 3F D6 A0 01 00 34 07 00 80 D2 FF 03 00 F9 06 00 80 D2 C5 02 00 11 64 02 00 91 03 03 00 11 82 02 00 91 41 03 00 11 60 03 00 91 ?? ?? ?? ?? 15 00 00 11 02 00 00 14 15 00 80 52 33 01 00 B4 68 02 5F B8 A9 BB 9B 52 1F 01 09 6B A1 00 00 54 60 42 00 D1 ?? ?? ?? ?? 02 00 00 14 15 00 80 52 F4 00 00 B4 88 02 5F B8 A9 BB 9B 52 1F 01 09 6B 61 00 00 54 80 42 00 D1 ?? ?? ?? ?? A0 02 00 11 9F 43 00 D1 FF 83 00 91 ?? ?? ?? ?? FB 73 45 A9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_45_8_0 {
	meta:
		name = "_MallocaComputeSize"
		size = 16
	strings:
		$1 = { 08 40 00 91 1F 01 00 EB 00 81 9F 9A C0 03 5F D6 }
	condition:
		$1
}

rule file_45_9_0 {
	meta:
		name = "_MarkAllocaS"
		size = 16
	strings:
		$1 = { 60 00 00 B4 01 00 00 B9 00 40 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_45_10_0 {
	meta:
		name = "__acrt_CompareStringA"
		size = 148
		refs = "003c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0060 ?InternalCompareStringA@@YAHPEAU__crt_locale_pointers@@PEB_WKPEBDH2HH@Z"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BD A9 FD 03 00 91 39 00 00 91 01 00 00 91 E0 43 00 91 58 00 00 11 77 00 00 91 96 00 00 11 B5 00 00 91 D4 00 00 11 F3 00 00 11 ?? ?? ?? ?? 67 02 00 11 86 02 00 11 A5 02 00 91 C4 02 00 11 E3 02 00 91 02 03 00 11 21 03 00 91 E0 63 00 91 ?? ?? ?? ?? E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_45_12_0 {
	meta:
		name = "_freea_crt"
		size = 28
		refs = "0014 _free_base"
	strings:
		$1 = { C0 00 00 B4 08 0C 5F B8 A9 BB 9B 52 1F 01 09 6B 41 00 00 54 ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_46_5_0 {
	meta:
		name = "_mbsstr_l"
		size = 316
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0034 strstr 0044 _errno 0050 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? EF 13 40 F9 E8 09 40 B9 C8 00 00 35 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 13 00 00 91 07 00 00 14 14 02 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 13 00 80 D2 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 91 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 88 02 40 39 A8 FE FF 34 F3 FD FF B4 6B 02 C0 39 69 02 00 91 8B 00 00 34 29 05 00 91 28 01 C0 39 C8 FF FF 35 2C 01 13 CB 8A 02 00 91 49 1D C0 38 E9 FF FF 35 48 01 14 CB 88 01 08 CB 0E 01 13 8B 69 1D 00 53 89 FC FF 34 6D 02 14 CB 7F 02 0E EB 28 FC FF 54 6C 16 40 38 8A 02 00 91 2C 01 00 34 4B 01 40 39 8B 02 00 34 A8 69 6A 38 1F 01 0B 6B 81 00 00 54 4A 05 00 91 A9 69 6A 38 29 FF FF 35 4A 01 40 39 8A 01 00 34 8B 01 0F 8B 6C 65 40 39 AD 05 00 91 AC 00 10 36 68 02 40 39 C8 F9 FF 34 73 06 00 91 AD 05 00 91 69 02 40 39 09 FD FF 35 C9 FF FF 17 73 06 00 D1 C8 FF FF 17 }
	condition:
		$1
}

rule file_47_0_0 {
	meta:
		name = "_realloc_base"
		size = 164
		refs = "0020 _malloc_base 0030 _free_base 0040 __acrt_heap 0044 __imp_HeapReAlloc 004c _query_new_mode 0058 _callnewh 0084 _errno"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 33 00 00 91 94 00 00 B5 60 02 00 91 ?? ?? ?? ?? 1C 00 00 14 93 00 00 B5 80 02 00 91 ?? ?? ?? ?? 17 00 00 14 7F 82 00 B1 48 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 06 00 00 14 ?? ?? ?? ?? A0 01 00 34 60 02 00 91 ?? ?? ?? ?? 40 01 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 01 00 80 52 82 02 00 91 63 02 00 91 20 01 3F D6 80 FE FF B4 05 00 00 14 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_48_1_0 {
	meta:
		name = "bsearch_s"
		size = 276
		refs = "003c _errno 0048 _invalid_parameter_noinfo 006c __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 73 04 A9 FD 7B BF A9 FD 03 00 91 1A 00 00 91 33 00 00 91 54 00 00 91 76 00 00 91 99 00 00 91 BB 00 00 91 13 01 00 B5 F4 00 00 B4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 1F 00 00 14 56 FF FF B4 39 FF FF B4 88 06 00 D1 17 4D 16 9B 7F 02 17 EB E8 02 00 54 ?? ?? ?? ?? 98 FE 41 D3 B8 03 00 B4 9F 02 40 F2 ?? ?? ?? ?? 0A 07 00 D1 14 13 8A 9A 2F 03 00 91 95 4E 16 9B 00 01 3F D6 A2 02 00 91 41 03 00 91 60 03 00 91 20 03 3F D6 20 01 00 34 60 00 F8 36 B7 02 16 CB 03 00 00 14 B3 02 16 8B 14 03 00 91 7F 02 17 EB 89 FD FF 54 15 00 80 D2 A0 02 00 91 FD 7B C1 A8 FB 73 44 A9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 F4 FE FF B4 ?? ?? ?? ?? 2F 03 00 91 00 01 3F D6 62 02 00 91 41 03 00 91 60 03 00 91 20 03 3F D6 1F 00 00 71 F5 13 93 9A EE FF FF 17 }
	condition:
		$1
}

rule file_50_5_0 {
	meta:
		name = "_mbscmp_l"
		size = 260
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0028 _errno 0034 _invalid_parameter_noinfo 0054 strcmp"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 54 00 00 B4 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 29 00 00 14 ED 13 40 F9 A8 09 40 B9 A8 00 00 35 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 22 00 00 14 8A 16 40 38 48 1D 00 53 A8 C1 28 8B 09 65 40 39 09 01 10 36 8B 02 40 39 6B 00 00 35 0B 00 80 52 03 00 00 14 6B 21 0A 2A 94 06 00 91 6A 3D 00 53 6B 16 40 38 68 1D 00 53 A8 C1 28 8B 09 65 40 39 09 01 10 36 6C 02 40 39 6C 00 00 35 0C 00 80 52 03 00 00 14 8C 21 0B 2A 73 06 00 91 8B 3D 00 53 5F 01 0B 6B 81 00 00 54 CA FC FF 35 00 00 80 52 05 00 00 14 5F 01 0B 6B 29 00 80 52 08 00 80 12 20 81 88 1A E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_52_3_0 {
	meta:
		name = "?lowio_handle@__crt_stdio_stream@@QEBAHXZ"
		size = 16
	strings:
		$1 = { 08 00 40 F9 00 19 40 B9 BF 3B 03 D5 C0 03 5F D6 }
	condition:
		$1
}

rule file_52_5_0 {
	meta:
		name = "_fileno"
		size = 52
		refs = "000c _errno 0018 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 03 00 00 14 00 18 40 B9 BF 3B 03 D5 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_54_0_0 {
	meta:
		name = "__acrt_execute_initializers"
		size = 172
		refs = "0030 __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 35 00 00 91 9F 02 15 EB 61 00 00 54 20 00 80 52 1C 00 00 14 93 02 00 91 ?? ?? ?? ?? 76 02 40 F9 D6 00 00 B4 ?? ?? ?? ?? CF 02 00 91 00 01 3F D6 C0 02 3F D6 80 00 00 34 73 42 00 91 7F 02 15 EB E1 FE FF 54 7F 02 15 EB 20 FE FF 54 0A 00 00 14 68 0E 5F F8 08 01 00 B4 75 06 40 F9 D5 00 00 B4 ?? ?? ?? ?? AF 02 00 91 20 01 3F D6 00 00 80 52 A0 02 3F D6 7F 02 14 EB C1 FE FF 54 00 00 80 52 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_54_1_0 {
	meta:
		name = "__acrt_execute_uninitializers"
		size = 96
		refs = "0020 __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 9F 02 01 EB A0 01 00 54 33 20 00 D1 ?? ?? ?? ?? 75 06 5F F8 D5 00 00 B4 ?? ?? ?? ?? AF 02 00 91 00 01 3F D6 00 00 80 52 A0 02 3F D6 68 22 00 91 1F 01 14 EB E1 FE FF 54 20 00 80 52 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_56_0_0 {
	meta:
		name = "strcmp"
		size = 72
	strings:
		$1 = { 2A 00 40 39 08 00 40 39 09 01 0A 4B 09 01 00 35 0B 00 01 CB 48 1D 00 13 A8 00 00 34 2A 1C 40 38 69 69 61 38 29 01 0A 4B 69 FF FF 34 69 00 F8 36 00 00 80 12 04 00 00 14 3F 01 00 71 28 00 80 52 00 C1 89 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_57_3_0 {
	meta:
		name = "sinh"
		size = 920
		refs = "0038 _controlfp_s 005c _handle_nan 008c ??_C@_04COOMCNPB@sinh?$AA@ 00b8 _handle_error 0110 ?two_to_jby32_trail_table@?1??splitexp@@9@9 0120 ?two_to_jby32_lead_table@?1??splitexp@@9@9 01f4 ?sinh_tail@?1??sinh@@9@9 0230 ?cosh_tail@?1??sinh@@9@9 029c ?cosh_lead@?1??sinh@@9@9 02a8 ?sinh_lead@?1??sinh@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 09 00 66 9E 0A C6 E7 D2 E0 03 01 6D 28 F9 40 92 1F 01 0A EB 42 01 00 54 48 00 00 B5 AF 00 00 14 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? E0 0F 40 FD A8 00 00 14 0A FE EF D2 1F 01 0A EB 03 01 00 54 1F 01 0A EB 89 00 00 54 20 01 00 91 ?? ?? ?? ?? A0 00 00 14 00 28 60 1E 9E 00 00 14 1F 01 09 EB 15 40 60 1E EC 07 9F 9A 4C 00 00 B4 15 40 61 1E 50 13 00 5C A0 22 70 1E 0B 02 00 54 ?? ?? ?? ?? E1 03 67 9E ?? ?? ?? ?? 00 40 60 1E 26 00 80 52 45 04 80 52 24 00 80 52 63 00 80 52 E1 03 80 52 8C 00 00 B4 02 FE FF D2 ?? ?? ?? ?? 89 00 00 14 02 FE EF D2 FD FF FF 17 50 11 00 5C 1A 10 6C 1E A0 22 70 1E EB 08 00 54 11 11 00 5C B2 0A 71 1E 48 22 60 1E 8D 00 00 54 52 2A 7A 1E 4A 02 78 1E 03 00 00 14 53 3A 7A 1E 6A 02 78 1E 54 01 62 1E E8 03 0A 4B F0 0F 00 5C 49 11 00 12 F1 0F 00 5C ?? ?? ?? ?? F2 0F 00 5C 99 D6 50 1F 15 01 62 1E ?? ?? ?? ?? B0 0F 00 5C ?? ?? ?? ?? 1B D9 69 FC ?? ?? ?? ?? 17 D9 69 FC 49 01 09 4B 28 7D 04 13 29 6D 48 0B 2A 7D 05 13 4B 05 00 51 68 F9 0F 11 B8 0A 71 1E 1F F5 1F 71 16 2B 79 1E D3 42 52 1F 12 0E 00 5C 74 4A 56 1F 13 0E 00 5C 91 4E 56 1F 35 6A 56 1F D1 0A 76 1E B4 62 51 1F F5 2A 7B 1E 96 2A 79 1E DC 5E 55 1F 28 01 00 54 68 7D 40 93 72 2B 7C 1E 09 FE E7 D2 28 D1 08 8B 10 01 67 9E E8 0F 00 F9 40 0A 70 1E 4C 00 00 14 68 7D 4B 0B 0D FE E7 D2 73 2B 7C 1E 0A 7D 01 13 49 7D 40 93 A8 D1 09 8B 69 01 0A 4B 2A 7D 40 93 E8 0F 00 F9 08 FE E7 D2 F1 0F 40 FD 08 D1 0A 8B 10 01 67 9E E8 0B 00 F9 74 0A 71 1E 80 0A 70 1E 3B 00 00 14 A9 02 78 1E ?? ?? ?? ?? D2 09 00 5C F1 09 00 5C 30 01 62 1E BF 3A 70 1E D0 09 00 5C FD 0B 7F 1E FF 0B 00 FD E8 03 66 9E 08 91 65 92 B3 47 52 1F E8 0F 00 F9 32 09 00 5C 51 09 00 5C 06 01 67 9E ?? ?? ?? ?? ?? ?? ?? ?? 74 4A 5D 1F F3 08 00 5C 12 09 00 5C 95 4E 5D 1F 14 09 00 5C 33 09 00 5C B6 52 5D 1F 35 09 00 5C 54 09 00 5C D7 56 5D 1F 55 09 00 5C F6 6A 5D 1F 57 09 00 5C B8 43 57 1F C5 0A 7D 1E F6 3B 66 1E 19 47 5D 1F 3A 4B 5D 1F 5B 4F 5D 1F 7C 53 5D 1F 9E 57 5D 1F BD 0B 7F 1E 1F D9 69 FC ?? ?? ?? ?? 17 D9 69 FC ?? ?? ?? ?? ?? ?? ?? ?? 18 D9 69 FC ?? ?? ?? ?? ?? ?? ?? ?? 15 D9 69 FC C7 5B 5D 1F F0 0B 67 1E F1 42 45 1F F1 47 46 1F 32 2A 77 1E 13 4B 47 1F B4 4E 45 1F 14 53 46 1F 80 2A 75 1E 4C 00 00 B4 00 40 61 1E FD 7B C2 A8 C0 03 5F D6 7E F8 B9 8F CE 33 86 40 5F 82 95 1B D2 0F 42 40 FE 82 2B 65 47 15 47 40 00 00 00 FE 42 2E 96 3F 8E 27 AF E6 3D 47 CF 3D 65 97 73 8D 72 C1 56 3F 5E 90 AA B7 15 11 81 3F 4E 5D 54 55 55 55 A5 3F 7C 8F 54 55 55 55 C5 3F D7 FC 63 7F 4B 98 A9 3D 20 7B 5B 38 56 EE 21 3E BE B7 DC 2B CB 11 E6 3D 55 CB F1 69 50 7E 92 3E C0 61 BE 0F 46 E6 5A 3E 11 90 07 19 A0 01 FA 3E 7D 3E E1 A4 E3 1D C7 3E E5 12 C2 16 6C C1 56 3F 80 EE 01 1A A0 01 2A 3F 02 55 55 55 55 55 A5 3F FD 10 11 11 11 11 81 3F 55 55 55 55 55 55 C5 3F 8B A0 1E 92 25 41 6B 3D }
	condition:
		$1
}

rule file_58_0_0 {
	meta:
		name = "?dup2_nolock@@YAHHH@Z"
		size = 396
		refs = "0024 __pioinfo 0048 _errno 0054 __doserrno 0088 _close_nolock 008c __imp_GetCurrentProcess 00a4 _get_osfhandle 00b8 __imp_DuplicateHandle 00e4 __imp_GetLastError 00f4 __acrt_errno_map_os_error 0104 __acrt_lowio_set_os_handle"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 73 04 A9 FD 7B BE A9 FD 03 00 91 13 00 00 11 68 7E 40 93 ?? ?? ?? ?? 16 FD 46 93 ?? ?? ?? ?? 18 15 40 92 E8 7A 76 F8 35 00 00 11 09 19 18 8B 2A E1 40 39 0A 01 00 37 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 1F 00 00 B9 00 00 80 12 44 00 00 14 A8 7E 40 93 19 FD 46 93 ?? ?? ?? ?? 1B 15 40 92 48 7B 79 F8 09 19 1B 8B 2A E1 40 39 6A 00 00 36 A0 02 00 11 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 14 00 00 91 60 02 00 11 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 13 00 00 91 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 46 00 80 52 25 00 80 52 04 00 80 52 E3 43 00 91 82 02 00 91 61 02 00 91 20 01 3F D6 E0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? D9 FF FF 17 E1 0B 40 F9 A0 02 00 11 ?? ?? ?? ?? E8 7A 76 F8 00 00 80 52 09 19 18 8B E8 1D 80 52 2A E1 40 39 4B 01 08 0A 48 7B 79 F8 09 19 1B 8B 2B E1 00 39 EA 7A 76 F8 48 7B 79 F8 4C 19 18 8B 0B 19 1B 8B 89 E5 C0 39 69 E5 00 39 48 7B 79 F8 E9 7A 76 F8 0C 19 1B 8B 2A 19 18 8B 88 F5 40 39 4B F5 40 39 89 F5 40 39 68 01 08 4A 0A 01 00 12 48 01 09 4A 88 F5 00 39 FD 7B C2 A8 FB 73 44 A9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_58_1_0 {
	meta:
		name = "_dup2"
		size = 312
		refs = "0028 __doserrno 0030 _errno 0044 _nhandle 005c __pioinfo 009c __acrt_lowio_ensure_fh_exists 00c0 __acrt_lowio_lock_fh 00ec ?dup2_nolock@@YAHHH@Z 00f8 __acrt_lowio_unlock_fh 0120 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 14 00 00 11 B4 13 00 B9 33 00 00 11 B3 17 00 B9 9F 0A 00 31 E1 00 00 54 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 3A 00 00 14 74 06 F8 37 ?? ?? ?? ?? ?? ?? ?? ?? 9F 02 0B 6B E2 05 00 54 89 7E 40 93 2A FD 46 93 ?? ?? ?? ?? ?? ?? ?? ?? 29 15 40 92 08 79 6A F8 09 19 09 8B 2A E1 40 39 48 01 00 12 A8 04 00 34 7F 0A 00 31 40 FD FF 54 08 00 84 52 7F 02 08 6B 02 04 00 54 7F 02 0B 6B 8B 00 00 54 60 02 00 11 ?? ?? ?? ?? 20 04 00 35 9F 02 13 6B 61 00 00 54 00 00 80 52 1E 00 00 14 9F 02 13 6B AA 00 00 54 80 02 00 11 ?? ?? ?? ?? 60 02 00 11 06 00 00 14 9F 02 13 6B AD 00 00 54 60 02 00 11 ?? ?? ?? ?? 80 02 00 11 ?? ?? ?? ?? 61 02 00 11 80 02 00 11 ?? ?? ?? ?? 15 00 00 11 80 02 00 11 ?? ?? ?? ?? 60 02 00 11 ?? ?? ?? ?? A0 02 00 11 08 00 00 14 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_58_2_0 {
	meta:
		name = "_dup2$fin$0"
		size = 40
		refs = "000c __acrt_lowio_unlock_fh"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A0 13 40 B9 ?? ?? ?? ?? A0 17 40 B9 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_59_3_0 {
	meta:
		name = "__acrt_update_locale_info"
		size = 76
		refs = "0010 __acrt_current_locale_data 0024 __globallocalestatus 0038 __acrt_update_thread_locale_data"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 33 00 00 91 ?? ?? ?? ?? 69 02 40 F9 ?? ?? ?? ?? 3F 01 08 EB 00 01 00 54 ?? ?? ?? ?? 09 A8 43 B9 ?? ?? ?? ?? 29 01 08 0A 69 00 00 35 ?? ?? ?? ?? 60 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_59_4_0 {
	meta:
		name = "__acrt_update_multibyte_info"
		size = 76
		refs = "0010 __acrt_current_multibyte_data 0024 __globallocalestatus 0038 __acrt_update_thread_multibyte_data"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 33 00 00 91 ?? ?? ?? ?? 69 02 40 F9 ?? ?? ?? ?? 3F 01 08 EB 00 01 00 54 ?? ?? ?? ?? 09 A8 43 B9 ?? ?? ?? ?? 29 01 08 0A 69 00 00 35 ?? ?? ?? ?? 60 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_60_4_0 {
	meta:
		name = "_wcsicmp"
		size = 156
		refs = "0008 __acrt_locale_changed_data 0018 _errno 0024 _invalid_parameter_noinfo 0090 _wcsicmp_l"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? E8 03 00 35 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 1A 00 00 14 41 FF FF B4 0E 00 01 CB CA 69 61 78 E8 F7 9F 52 48 01 08 0B 09 3D 00 53 3F 65 00 71 48 00 00 54 4A 81 00 11 2C 24 40 78 EB F7 9F 52 4D 3D 00 53 8A 01 0B 0B 4B 3D 00 53 7F 65 00 71 48 00 00 54 8C 81 00 11 88 3D 00 53 BF 01 00 71 A0 11 48 7A C0 FD FF 54 A0 01 08 4B 03 00 00 14 02 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_415_4_0 {
	meta:
		name = "_wcsicoll"
		size = 156
		refs = "0008 __acrt_locale_changed_data 0018 _errno 0024 _invalid_parameter_noinfo 0090 _wcsicoll_l"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? E8 03 00 35 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 1A 00 00 14 41 FF FF B4 0E 00 01 CB CA 69 61 78 E8 F7 9F 52 48 01 08 0B 09 3D 00 53 3F 65 00 71 48 00 00 54 4A 81 00 11 2C 24 40 78 EB F7 9F 52 4D 3D 00 53 8A 01 0B 0B 4B 3D 00 53 7F 65 00 71 48 00 00 54 8C 81 00 11 88 3D 00 53 BF 01 00 71 A0 11 48 7A C0 FD FF 54 A0 01 08 4B 03 00 00 14 02 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_60_5_0 {
	meta:
		name = "_wcsicmp_l"
		size = 252
		refs = "0020 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002c _errno 0038 _invalid_parameter_noinfo 00ac _towlower_l"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BD A9 FD 03 00 91 15 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 55 00 00 B4 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 25 00 00 14 E8 0F 40 F9 08 9D 40 F9 C8 02 00 B5 AD 02 13 CB AB 69 73 78 E9 F7 9F 52 69 01 09 0B 2A 3D 00 53 5F 65 00 71 48 00 00 54 6B 81 00 11 6C 26 40 78 E8 F7 9F 52 74 3D 00 53 88 01 08 0B 0B 3D 00 53 7F 65 00 71 48 00 00 54 8C 81 00 11 89 3D 00 53 F4 01 00 34 9F 02 09 6B C0 FD FF 54 0C 00 00 14 A0 26 40 78 E1 63 00 91 ?? ?? ?? ?? E1 63 00 91 14 00 00 11 60 26 40 78 ?? ?? ?? ?? 9F 02 00 71 09 00 00 11 80 12 49 7A C0 FE FF 54 80 02 09 4B E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_61_0_0 {
	meta:
		name = "conj"
		size = 48
		refs = "000c creal 001c cimag"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? 01 40 61 1E E0 0B 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_582_0_0 {
	meta:
		name = "conjl"
		size = 48
		refs = "000c creall 001c cimagl"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? 01 40 61 1E E0 0B 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_62_0_0 {
	meta:
		name = "atan2"
		size = 1464
		refs = "0068 _handle_nan 009c _controlfp_s 034c ?atan_jby256_lead@?1??atan2@@9@9 03ec ?atan_jby256_tail@?1??atan2@@9@9"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 23 00 F9 FD 7B BD A9 FD 03 00 91 36 00 66 9E 17 00 66 9E 18 40 60 1E C8 FE 74 D3 35 40 60 1E 1A 29 00 12 E8 FE 74 D3 F5 63 02 6D 1B 29 00 12 F8 57 01 6D 08 FE EF D2 D9 FA 40 92 3F 03 08 EB F8 FA 40 92 D4 02 41 92 F3 02 41 92 75 03 1A 4B 89 00 00 54 C0 02 00 91 ?? ?? ?? ?? 1E 01 00 14 08 FE EF D2 1F 03 08 EB 69 00 00 54 E0 02 00 91 FA FF FF 17 D8 01 00 B5 74 01 00 B4 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 73 00 00 B4 E0 22 00 5C 0F 01 00 14 E0 22 00 5C 0D 01 00 14 00 43 60 1E 0B 01 00 14 59 01 00 B5 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 73 00 00 B4 C0 21 00 5C 02 01 00 14 F5 63 42 6D 5F F7 0F 71 AA 05 00 54 7F F7 0F 71 6A 05 00 54 C8 2A 4C 92 12 10 62 1E A8 01 00 B5 08 02 E8 D2 C8 02 08 AA E8 0F 00 F9 94 00 00 B4 10 01 67 9E 11 2A 72 1E 03 00 00 14 F1 0F 40 FD 31 3A 72 1E F1 17 00 FD 2A 02 66 9E 03 00 00 14 08 00 E8 D2 CA 02 08 8B E8 2A 4C 92 A8 01 00 B5 08 02 E8 D2 E8 02 08 AA E8 0F 00 F9 93 00 00 B4 10 01 67 9E 11 2A 72 1E 03 00 00 14 F1 0F 40 FD 31 3A 72 1E F1 17 00 FD 28 02 66 9E 03 00 00 14 08 00 E8 D2 E8 02 08 8B E8 0F 00 F9 08 FD 74 D3 0B 29 00 12 EA 17 00 F9 F8 0F 40 FD 48 FD 74 D3 F5 17 40 FD 0A 29 00 12 75 01 0A 4B BF E2 00 71 2D 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 13 F9 FF B5 E0 1A 00 5C C9 00 00 14 BF 72 00 31 80 BA 40 FA 21 07 00 54 BF CA 10 31 6A 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 73 00 00 B4 80 19 00 5C BC 00 00 14 E0 03 67 9E BA 00 00 14 BF FA 0F 31 2A 05 00 54 08 C6 E8 D2 10 01 67 9E E8 17 00 F9 10 0A 78 1E 10 1A 75 1E 08 02 66 9E F0 17 00 FD 0A F9 40 92 0C 01 41 92 48 FD 74 D3 0B 91 01 51 7F 01 00 71 AD 00 00 54 69 7D 40 93 48 D1 41 92 0B D1 09 AA 0D 00 00 14 28 00 80 D2 0A 29 4C B3 28 00 80 52 08 01 0B 4B 1F D9 00 71 6D 00 00 54 0B 00 80 D2 05 00 00 14 08 05 00 51 4A 25 C8 9A 49 01 40 92 2B 05 4A 8B 68 01 0C AA E8 0F 00 F9 08 29 4C 92 C8 00 00 B5 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? E0 0F 40 FD 90 00 00 14 00 1B 75 1E 8E 00 00 14 BF E2 00 31 84 BA 40 FA A1 EE FF 54 08 FE EF D2 1F 03 08 EB 61 02 00 54 3F 03 08 EB 21 02 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? D4 00 00 B4 73 00 00 B4 E0 11 00 5C 7D 00 00 14 E0 11 00 5C 7B 00 00 14 73 00 00 B4 C0 11 00 5C 78 00 00 14 C0 11 00 5C 76 00 00 14 54 00 00 B4 B5 42 61 1E 53 00 00 B4 18 43 61 1E A0 22 78 1E EE 27 9F 1A 8E 00 00 34 B0 42 60 1E 15 43 60 1E 18 42 60 1E 1A 1B 75 1E 70 10 00 5C 40 23 70 1E 4D 07 00 54 11 10 6C 1E ?? ?? ?? ?? F5 0B 00 FD F2 0F 00 5C ?? ?? ?? ?? EB 7F 80 52 D3 0F 00 5C 0C FE E7 D2 52 47 52 1F 0F FE E7 D2 49 02 78 1E 2D 41 00 51 34 01 63 1E 1B 59 6D FC A8 02 66 9E 08 FD 74 D3 0A 29 00 12 6B 01 0A 4B 68 7D 4B 0B 0A 7D 01 13 49 7D 40 93 97 0A 73 1E 8C D1 09 8B 68 01 0A 4B 09 7D 40 93 90 01 67 9E EA D1 09 8B EA 33 02 A9 EA 33 02 A9 51 01 67 9E 12 0A 75 1E 53 01 67 9E 56 0A 71 1E 92 01 67 9E 54 0A 78 1E C8 02 66 9E F6 0B 00 FD 08 91 65 92 95 0A 73 1E E8 0F 00 F9 10 01 67 9E ?? ?? ?? ?? 94 0B 00 5C ?? ?? ?? ?? 93 0B 00 5C 11 D6 57 1F D0 3A 70 1E 12 C6 57 1F F1 5A 55 1F 57 1A 71 1E 12 59 6D FC F5 0A 77 1E 56 2A 77 1E B4 CE 54 1F 95 0A 75 1E BA DA 57 1F 22 00 00 14 36 0A 00 5C FB 03 67 9E 40 23 76 1E C3 03 00 54 A8 02 66 9E F5 0B 00 FD 49 03 66 9E FA 0B 00 FD 59 0B 7A 1E 08 7D 60 92 33 09 00 5C E8 0F 00 F9 28 7D 60 92 F0 0F 40 FD 12 01 67 9E E8 17 00 F9 51 E2 50 1F B0 3A 70 1E 11 C6 52 1F 50 3B 72 1E 32 08 00 5C 34 CB 53 1F 33 08 00 5C 11 C6 55 1F 38 1A 75 1E 95 CE 59 1F F4 07 00 5C B6 D2 59 1F F5 07 00 5C D7 D6 59 1F 36 0B 7A 1E F7 E2 56 1F FA 2A 7A 1E AE 00 00 34 30 03 00 5C 1B 3A 7B 1E 30 07 00 5C 1A 3A 7A 1E B4 00 00 B4 11 07 00 5C 32 07 00 5C 3B 3A 7B 1E 5A 3A 7A 1E 40 2B 7B 1E 53 00 00 B4 00 40 61 1E FD 7B C3 A8 FB 23 40 F9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 18 2D 44 54 FB 21 09 C0 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 FB 21 F9 3F 00 00 00 00 00 00 00 80 D2 21 33 7F 7C D9 02 C0 D2 21 33 7F 7C D9 02 40 18 2D 44 54 FB 21 E9 BF 18 2D 44 54 FB 21 E9 3F 00 00 00 00 00 00 B0 3F 00 00 00 00 00 00 70 40 00 00 00 00 00 00 70 3F 7D 2D 80 B9 92 99 C9 3F 77 08 55 55 55 55 D5 3F 3A 8C 30 E2 8E 79 45 3E C2 51 D7 92 31 0C B7 3F EB C4 B8 39 88 71 BC 3F E1 6B BD 82 24 49 C2 3F A3 43 96 99 99 99 C9 3F 38 55 55 55 55 55 D5 3F 07 5C 14 33 26 A6 91 3C 00 00 00 50 FB 21 09 40 63 62 1A 61 B4 10 61 3E }
	condition:
		$1
}

rule file_62_4_0 {
	meta:
		name = "scaleDownDouble"
		size = 100
	strings:
		$1 = { 0A F8 40 92 48 FD 74 D3 0B 01 01 4B 7F 01 00 71 0C 00 41 92 AD 00 00 54 69 7D 40 93 48 D1 41 92 0A D1 09 AA 0D 00 00 14 28 00 80 D2 0A 29 4C B3 28 00 80 52 08 01 0B 4B 1F D9 00 71 6D 00 00 54 0A 00 80 D2 05 00 00 14 08 05 00 51 4A 25 C8 9A 49 01 40 92 2A 05 4A 8B 48 01 0C AA 48 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_62_5_0 {
	meta:
		name = "scaleUpDouble1024"
		size = 88
	strings:
		$1 = { FF 43 00 D1 08 28 4C 92 E8 01 00 B5 08 02 E8 D2 12 10 62 1E 08 00 08 AA E8 03 00 F9 09 00 41 92 89 00 00 B4 10 01 67 9E 11 2A 72 1E 03 00 00 14 F1 03 40 FD 31 3A 72 1E F1 03 00 FD 28 02 66 9E 03 00 00 14 09 00 E8 D2 08 00 09 8B 28 00 00 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_63_5_0 {
	meta:
		name = "_mbscspn_l"
		size = 288
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0034 strcspn 0044 _errno 0050 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? EF 13 40 F9 E8 09 40 B9 A8 00 00 35 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 31 00 00 14 53 00 00 B4 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 29 00 00 14 68 02 40 39 6D 02 00 91 A8 04 00 34 8E 02 40 39 8C 02 00 91 CE 02 00 34 8B 01 40 39 69 01 0F 8B 2A 65 40 39 8A 01 10 36 A8 01 40 39 7F 01 08 6B A1 00 00 54 AB 05 40 39 8A 05 40 39 5F 01 0B 6B 60 01 00 54 8B 05 40 39 2B 01 00 34 8C 05 00 91 04 00 00 14 A9 01 40 39 7F 01 09 6B 80 00 00 54 8C 05 00 91 88 01 40 39 88 FD FF 35 8A 01 40 39 6A 01 00 35 AB 01 40 39 6B 01 0F 8B 6C 65 40 39 8C 00 10 36 AD 05 00 91 A9 01 40 39 89 00 00 34 AD 05 00 91 A8 01 40 39 C8 FB FF 35 A0 01 13 CB E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_64_0_0 {
	meta:
		name = "acos"
		size = 576
		refs = "0034 _handle_nan 0054 _controlfp_s 00a0 ??_C@_04PDIFKINK@acos?$AA@ 00c4 _handle_error"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 00 00 66 9E 09 FE EF D2 E0 0B 00 FD FD 03 67 9E 08 FC 74 D3 0A 29 00 12 08 F8 40 92 1F 01 09 EB 0C 00 41 92 4B FD 0F 51 69 00 00 54 ?? ?? ?? ?? 64 00 00 14 7F E1 00 31 0A 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? C0 0B 00 5C 5B 00 00 14 6B 03 F8 37 11 10 6E 1E 00 20 71 1E 61 00 00 54 E0 03 67 9E 55 00 00 14 10 10 7E 1E 00 20 70 1E 01 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 00 0A 00 5C 4B 00 00 14 ?? ?? ?? ?? E1 03 67 9E ?? ?? ?? ?? 26 00 80 52 25 04 80 52 04 01 80 52 23 00 80 52 02 FF FF D2 A1 01 80 52 ?? ?? ?? ?? 40 00 00 14 6C 00 00 B4 1C 40 61 1E 02 00 00 14 1C 40 60 1E 7F 05 00 31 0B 01 00 54 11 10 6E 1E 10 10 6C 1E 31 3A 7C 1E 3E 0A 70 1E DD C3 61 1E BC 43 60 1E 02 00 00 14 9E 0B 7C 1E F2 06 00 5C 11 07 00 5C 30 07 00 5C 57 07 00 5C D3 47 52 1F 52 07 00 5C 74 CA 7E 1F 53 07 00 5C 95 4E 5E 1F 54 07 00 5C B6 D2 7E 1F D5 42 5E 1F 36 07 00 5C D8 DB 77 1F 37 07 00 5C BB 0A 7E 1E 19 5F 5E 1F 18 07 00 5C 3A E3 7E 1F 19 07 00 5C 5A 67 5E 1F 67 1B 7A 1E CB 02 00 54 1F 10 60 1E EC 00 00 B4 91 06 00 5C F0 C4 7C 1F 11 2A 7D 1E 30 03 00 5C 20 C2 5F 1F 13 00 00 14 A8 03 66 9E FD 0B 00 FD 08 7D 60 92 15 01 67 9E E8 0B 00 F9 B1 FA 55 1F B0 2A 7D 1E 32 1A 70 1E 91 0B 7F 1E 53 0A 7F 1E 34 4E 47 1F A0 52 5F 1F 06 00 00 14 31 04 00 5C D0 00 00 5C F2 C4 40 1F 15 38 72 1E 00 3A 75 1E FD 7B C2 A8 C0 03 5F D6 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 FB 21 09 40 61 10 32 5D 66 51 09 3F 35 21 A6 87 F8 E5 51 3F 34 98 02 80 41 1E CD 3F 76 CE 82 29 42 1A BB 3F 90 96 C2 90 D3 28 AC 3F 59 EF B7 C1 BE A2 D1 3F AC 9E 26 7E 29 7B DC 3F 8D F7 18 B4 4A 32 EE 3F FC CC 1D 57 21 20 06 40 EA CD 03 F9 46 46 0A 40 28 F2 01 20 B1 D6 F5 3F 07 5C 14 33 26 A6 91 3C }
	condition:
		$1
}

rule file_66_5_0 {
	meta:
		name = "_mbsnbcat_l"
		size = 356
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 004c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0068 strncat 00a0 _mbsbtype_l"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 14 00 00 91 37 00 00 91 56 00 00 91 96 09 00 B4 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 45 00 00 14 57 FF FF B4 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? EC 13 40 F9 88 09 40 B9 E8 00 00 35 C2 02 00 91 E1 02 00 91 80 02 00 91 ?? ?? ?? ?? 15 00 00 91 31 00 00 14 95 02 00 91 93 02 00 91 88 16 40 38 C8 FF FF 35 7F 02 15 EB 60 01 00 54 69 02 15 4B 2A 05 00 51 41 7D 40 93 E2 63 00 91 A0 02 00 91 ?? ?? ?? ?? EC 13 40 F9 1F 04 00 71 41 00 00 54 73 06 00 D1 EA 16 40 38 D6 06 00 D1 48 01 0C 8B 09 65 40 39 6A 16 00 38 49 01 10 36 96 01 00 B4 EA 02 40 39 D6 06 00 D1 F7 06 00 91 6A 02 00 39 73 06 00 91 8A 00 00 35 7F E2 1F 38 05 00 00 14 8A 00 00 34 76 00 00 B4 EF FF FF 17 7F F2 1F 38 7F 02 15 EB 60 01 00 54 69 02 15 4B 2A 05 00 51 41 7D 40 93 E2 63 00 91 A0 02 00 91 ?? ?? ?? ?? 1F 04 00 71 61 00 00 54 7F F2 1F 38 02 00 00 14 7F 02 00 39 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 A0 02 00 91 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_68_0_0 {
	meta:
		name = "_FHypot"
		size = 444
		refs = "001c _fdunscale 0110 _fdscale 019c _FInf_C"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 14 00 00 91 E0 87 02 2D E0 43 00 91 E1 53 00 91 ?? ?? ?? ?? E1 63 00 91 13 00 00 11 E0 4B 00 91 ?? ?? ?? ?? 7F 06 00 71 9F 02 00 B9 04 18 41 7A 00 0B 00 54 7F 0A 00 71 61 00 00 54 E0 17 40 BD 56 00 00 14 1F 08 00 71 61 00 00 54 E0 1B 40 BD 52 00 00 14 F0 17 40 BD 08 22 20 1E 62 00 00 54 10 42 21 1E F0 17 00 BD F1 1B 40 BD 28 22 20 1E 62 00 00 54 31 42 21 1E F1 1B 00 BD 28 22 20 1E E1 00 00 54 08 22 20 1E 61 00 00 54 E0 03 27 1E 42 00 00 14 EC 23 C0 79 0E 00 00 14 EC 23 C0 79 08 22 20 1E E9 27 C0 79 8A 11 49 7A 8B 00 00 54 9F 01 09 6B 0E 06 31 1E C2 00 00 54 88 01 00 11 F1 C3 02 2D 2C 01 00 11 E8 27 00 79 EC 23 00 79 88 7D 01 13 89 79 48 0B E0 53 00 91 2A 7D 02 13 4B 79 1F 53 7F 01 00 71 8B 02 00 B9 68 01 00 11 49 00 80 52 29 01 88 1A 2A 01 00 11 89 02 00 B9 81 01 0A 4B ?? ?? ?? ?? E9 27 C0 79 E0 63 00 91 88 02 40 B9 21 01 08 4B ?? ?? ?? ?? FB D3 42 2D 60 3B 34 1E 00 20 3B 1E 80 03 00 54 80 22 20 1E E2 00 00 54 73 1B 34 1E 10 10 2E 1E 71 42 13 1F 32 C2 21 1E 53 2A 33 1E 0F 00 00 14 1A 18 34 1E 16 10 20 1E 97 02 00 1C 90 02 00 1C 92 02 00 1C 55 2B 36 1E B9 0A 3A 1E 36 2B 36 1E D8 C2 21 1E 18 2B 37 1E 39 1B 38 1E 31 2B 30 1E 33 2A 3A 1E 73 2A 32 1E 94 1A 33 1E 80 2A 3B 1E 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 F3 04 B5 3F F3 89 63 37 41 82 1A 40 }
	condition:
		$1
}

rule file_68_1_0 {
	meta:
		name = "csqrtf"
		size = 428
		refs = "0010 crealf 0020 cimagf 002c _fdtest 005c _FHypot 0088 ldexp 0164 _FInf_C 017c _FZero_C 019c _FCbuild"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 E0 07 04 2D ?? ?? ?? ?? E1 27 40 BD E0 17 00 BD E0 23 40 BD ?? ?? ?? ?? E0 43 00 91 E0 13 00 BD ?? ?? ?? ?? 13 00 00 11 7F 06 00 71 61 00 00 54 E1 13 40 BD 55 00 00 14 E0 53 00 91 ?? ?? ?? ?? 1F 04 00 71 00 07 00 54 E1 03 42 2D E0 63 00 91 ?? ?? ?? ?? F3 1B 40 B9 E0 1F 00 BD 93 00 00 35 F0 13 40 BD 01 08 30 1E 4A 00 00 14 F0 17 40 BD E0 03 13 4B 11 C2 20 1E 20 C2 22 1E ?? ?? ?? ?? F1 1F 40 BD 68 7E 53 0B 10 40 62 1E 09 7D 01 13 20 05 00 51 11 2A 31 1E 10 10 20 1E F0 1B 00 BD 31 0A 30 1E 32 C2 21 1E 40 C2 22 1E ?? ?? ?? ?? F0 17 40 BD 13 40 62 1E 08 22 20 1E EB 00 00 54 F2 1B 40 BD 60 42 20 1E F1 13 40 BD 72 0A 32 1E 21 1A 32 1E 2F 00 00 14 E8 27 40 79 08 01 78 36 F2 1B 40 BD 61 42 21 1E F0 13 40 BD 71 0A 32 1E 10 1A 31 1E 00 42 21 1E 26 00 00 14 F1 13 40 BD 61 42 20 1E 28 22 20 1E 61 00 00 54 E0 03 27 1E 20 00 00 14 F2 1B 40 BD 70 0A 32 1E 20 1A 30 1E 1C 00 00 14 7F 0A 00 71 01 01 00 54 E1 17 40 BD 28 20 20 1E 62 00 00 54 E0 13 40 BD 15 00 00 14 E0 07 44 2D 14 00 00 14 F0 17 40 BD E8 27 40 79 08 22 20 1E E2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 11 72 51 42 21 1E 21 1E 32 1E E8 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 1F 01 11 72 11 42 21 1E F0 03 27 1E 21 1E 30 1E ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_68_2_0 {
	meta:
		name = "ldexpf"
		size = 28
		refs = "000c ldexp"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 00 C0 22 1E ?? ?? ?? ?? 00 40 62 1E FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_69_1_0 {
	meta:
		name = "_recalloc_base"
		size = 160
		refs = "0030 _errno 004c _msize 0068 _realloc_base 0088 memset"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 35 00 00 91 56 00 00 91 55 01 00 B4 E8 03 80 92 08 09 D5 9A 1F 01 16 EB C2 00 00 54 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 14 00 00 14 B4 00 00 B4 80 02 00 91 ?? ?? ?? ?? 13 00 00 91 02 00 00 14 13 00 80 D2 B5 7E 16 9B 80 02 00 91 A1 02 00 91 ?? ?? ?? ?? 14 00 00 91 9F 02 00 F1 6E 12 55 FA A2 00 00 54 A2 02 13 CB 01 00 80 52 80 02 13 8B ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_70_5_0 {
	meta:
		name = "_mbsnicoll_l"
		size = 272
		refs = "0028 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 004c _errno 0058 _invalid_parameter_noinfo 007c _strnicoll_l 008c _mbsnbcnt_l 00c8 __acrt_CompareStringA"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BD A9 FD 03 00 91 73 00 00 91 15 00 00 91 36 00 00 91 61 02 00 91 E0 43 00 91 54 00 00 91 ?? ?? ?? ?? 74 00 00 B5 00 00 80 52 2D 00 00 14 B5 00 00 B4 96 00 00 B4 E8 7B 40 B2 9F 02 08 EB C9 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 20 00 00 14 E8 13 40 F9 A0 02 00 91 08 09 40 B9 C8 00 00 35 63 02 00 91 82 02 00 91 C1 02 00 91 ?? ?? ?? ?? 1A 00 00 14 E2 63 00 91 81 02 00 91 ?? ?? ?? ?? E2 63 00 91 13 00 00 91 C0 02 00 91 81 02 00 91 ?? ?? ?? ?? E8 13 40 F9 64 02 00 11 06 00 00 11 C5 02 00 91 A3 02 00 91 07 05 40 B9 22 00 82 52 01 11 41 F9 E0 63 00 91 ?? ?? ?? ?? C0 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 B0 12 02 00 00 14 00 08 00 51 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_71_0_0 {
	meta:
		name = "ctanf"
		size = 92
		refs = "000c crealf 001c cimagf 0028 _FCbuild 002c ctanhf"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? E1 13 40 BD 00 40 21 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? F0 13 40 BD 01 42 21 1E ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_550_0_4 {
	meta:
		name = "cabsf"
		size = 48
		refs = "000c cimagf 001c crealf 0024 _hypotf"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? E1 13 40 BD ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_651_0_4 {
	meta:
		name = "cargf"
		size = 48
		refs = "000c crealf 001c cimagf 0024 atan2f"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? E1 13 40 BD ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_296_0_0 {
	meta:
		name = "casinf"
		size = 92
		refs = "000c crealf 001c cimagf 0028 _FCbuild 002c casinhf"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? E1 13 40 BD 00 40 21 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? F0 13 40 BD 01 42 21 1E ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_476_0_3 {
	meta:
		name = "catanf"
		size = 92
		refs = "000c crealf 001c cimagf 0028 _FCbuild 002c catanhf"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? E1 13 40 BD 00 40 21 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? F0 13 40 BD 01 42 21 1E ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_99_0_3 {
	meta:
		name = "csinf"
		size = 92
		refs = "000c crealf 001c cimagf 0028 _FCbuild 002c csinhf"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? E1 13 40 BD 00 40 21 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? F0 13 40 BD 01 42 21 1E ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_72_5_0 {
	meta:
		name = "_mbsncmp_l"
		size = 288
		refs = "0024 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0044 strncmp 0054 _errno 0060 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 61 00 00 91 E0 43 00 91 55 00 00 91 ?? ?? ?? ?? D5 05 00 B4 ED 13 40 F9 A8 09 40 B9 C8 00 00 35 A2 02 00 91 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 2C 00 00 14 53 00 00 B4 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 24 00 00 14 6A 16 40 38 B5 06 00 D1 48 1D 00 53 A8 C1 28 8B 09 65 40 39 09 01 10 36 6B 02 40 39 6B 00 00 35 0B 00 80 52 03 00 00 14 6B 21 0A 2A 73 06 00 91 6A 3D 00 53 8B 16 40 38 68 1D 00 53 A8 C1 28 8B 09 65 40 39 09 01 10 36 8C 02 40 39 6C 00 00 35 0C 00 80 52 03 00 00 14 8C 21 0B 2A 94 06 00 91 8B 3D 00 53 5F 01 0B 6B A1 00 00 54 4A 00 00 34 95 FC FF B5 00 00 80 52 05 00 00 14 5F 01 0B 6B 29 00 80 52 08 00 80 12 20 81 88 1A E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_73_0_0 {
	meta:
		name = "?scale_count@@YA_J_J@Z"
		size = 48
		refs = "0000 ?source_frequency@@3_JA"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 49 00 00 B5 80 00 3E D4 0A 0C C9 9A 0B 7D 80 D2 48 81 09 9B 0C 7D 80 D2 08 7D 0B 9B 09 0D C9 9A 40 25 0C 9B C0 03 5F D6 }
	condition:
		$1
}

rule file_73_1_0 {
	meta:
		name = "__acrt_initialize_clock"
		size = 120
		refs = "0008 __imp_QueryPerformanceFrequency 0020 __imp_QueryPerformanceCounter 0040 ?source_frequency@@3_JA"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E0 43 00 91 20 01 3F D6 E0 01 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E0 63 00 91 20 01 3F D6 20 01 00 34 E8 0B 40 F9 E8 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 28 01 00 F9 E8 0F 40 F9 28 05 00 F9 06 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 00 80 92 0A 00 80 92 09 29 00 A9 00 00 80 52 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_73_2_0 {
	meta:
		name = "clock"
		size = 152
		refs = "000c ?source_frequency@@3_JA 0028 __imp_QueryPerformanceCounter"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 68 06 40 F9 1F 05 00 B1 61 00 00 54 00 00 80 12 1A 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E0 43 00 91 20 01 3F D6 20 FF FF 34 E8 0B 40 F9 69 06 40 F9 0B 01 09 CB AB FE FF B7 69 02 40 F9 49 00 00 B5 80 00 3E D4 6A 0D C9 9A 0C 7D 80 D2 48 AD 09 9B 0B 7D 80 D2 00 00 80 12 08 7D 0C 9B 09 0D C9 9A E8 7B 40 B2 4B 25 0B 9B 7F 01 08 EB 4C 00 00 54 60 01 00 11 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_74_4_0 {
	meta:
		name = "_stricoll"
		size = 24
		refs = "0000 __acrt_locale_changed_data 000c _stricmp 0014 _stricoll_l"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 48 00 00 35 ?? ?? ?? ?? 02 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_532_13_4 {
	meta:
		name = "??$get_comspec@D@@YAPEBDXZ"
		size = 84
		refs = "0008 ?comspec_name@?1???$get_comspec@D@@YAPEBDXZ@4QBDB 001c _dupenv_s 0050 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? FF 0B 00 F9 ?? ?? ?? ?? 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 58 00 71 00 00 80 D2 61 00 00 54 04 00 00 14 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_532_14_2 {
	meta:
		name = "??$get_comspec@_W@@YAPEB_WXZ"
		size = 84
		refs = "0008 ?comspec_name@?1???$get_comspec@_W@@YAPEB_WXZ@4QB_WB 001c _wdupenv_s 0050 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? FF 0B 00 F9 ?? ?? ?? ?? 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 58 00 71 00 00 80 D2 61 00 00 54 04 00 00 14 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_532_17_0 {
	meta:
		name = "??$get_path@D@@YAPEBDXZ"
		size = 84
		refs = "0008 ?path_name@?1???$get_path@D@@YAPEBDXZ@4QBDB 001c _dupenv_s 0050 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? FF 0B 00 F9 ?? ?? ?? ?? 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 58 00 71 00 00 80 D2 61 00 00 54 04 00 00 14 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_532_18_0 {
	meta:
		name = "??$get_path@_W@@YAPEB_WXZ"
		size = 84
		refs = "0008 ?path_name@?1???$get_path@_W@@YAPEB_WXZ@4QB_WB 001c _wdupenv_s 0050 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? FF 0B 00 F9 ?? ?? ?? ?? 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 58 00 71 00 00 80 D2 61 00 00 54 04 00 00 14 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_669_12_2 {
	meta:
		name = "??$get_tmp_directory@D@@YAPEBDXZ"
		size = 84
		refs = "0008 ?tmp_name@?1???$get_tmp_directory@D@@YAPEBDXZ@4QBDB 001c _dupenv_s 0050 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? FF 0B 00 F9 ?? ?? ?? ?? 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 58 00 71 00 00 80 D2 61 00 00 54 04 00 00 14 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_669_13_2 {
	meta:
		name = "??$get_tmp_directory@_W@@YAPEB_WXZ"
		size = 84
		refs = "0008 ?tmp_name@?1???$get_tmp_directory@_W@@YAPEB_WXZ@4QB_WB 001c _wdupenv_s 0050 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? FF 0B 00 F9 ?? ?? ?? ?? 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 58 00 71 00 00 80 D2 61 00 00 54 04 00 00 14 E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_490_4_2 {
	meta:
		name = "??1scoped_fp_state_reset@?A0x71ca7cfb@@QEAA@XZ"
		size = 16
		refs = "0008 fesetenv"
	strings:
		$1 = { 08 20 40 39 48 00 00 34 ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_374_565_3 {
	meta:
		name = "?state_case_normal@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 52
		refs = "0008 ?state_case_normal_common@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$format_validation_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0010 _errno 001c _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? E0 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_374_567_2 {
	meta:
		name = "?state_case_normal@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ"
		size = 52
		refs = "0008 ?state_case_normal_common@?$output_processor@DV?$stream_output_adapter@D@__crt_stdio_output@@V?$standard_base@DV?$stream_output_adapter@D@__crt_stdio_output@@@2@@__crt_stdio_output@@AEAA_NXZ 0010 _errno 001c _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? E0 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_151_2_0 {
	meta:
		name = "__doserrno"
		size = 40
		refs = "0008 __acrt_getptd_noexit 0010 ?doserrno_no_memory@@3KA"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 80 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 14 00 90 00 91 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_151_3_4 {
	meta:
		name = "_errno"
		size = 40
		refs = "0008 __acrt_getptd_noexit 0010 ?errno_no_memory@@3HA"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 80 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 14 00 80 00 91 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_96_14_4 {
	meta:
		name = "_getextendedkeycode"
		size = 248
		refs = "0008 ?EnhancedKeys@@3QBUEnhKeyVals@?A0x85a4bdeb@@B 0094 ?NormalKeys@@3QBUNormKeyVals@?A0x85a4bdeb@@B"
	strings:
		$1 = { 0A 0C 40 B9 4A 04 40 36 ?? ?? ?? ?? 0D 10 40 79 ?? ?? ?? ?? 0B 00 80 52 68 7D 40 93 49 01 80 D2 09 7D 09 9B 28 69 6C 78 1F 01 0D 6B C0 00 00 54 6B 05 00 11 69 7D 40 93 3F 31 00 F1 E3 FE FF 54 2C 00 00 14 48 05 00 12 69 7D 40 93 A8 00 00 34 88 21 00 91 4D 01 80 D2 20 21 0D 9B 26 00 00 14 48 05 1E 12 68 00 00 34 88 19 00 91 FA FF FF 17 6A 00 20 36 88 11 00 91 F7 FF FF 17 4A 01 80 D2 88 09 00 91 20 21 0A 9B 1B 00 00 14 48 05 00 12 88 00 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 0C 00 00 14 48 05 1E 12 88 00 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 07 00 00 14 8A 00 20 36 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 10 40 79 EA 1B 80 52 00 0D 09 8B 08 00 40 39 09 81 00 11 28 01 0A 0A 68 00 00 35 08 04 40 39 48 00 00 35 00 00 80 D2 C0 03 5F D6 }
	condition:
		$1
}

rule file_74_5_0 {
	meta:
		name = "_stricoll_l"
		size = 184
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0028 _errno 0034 _invalid_parameter_noinfo 0050 _stricmp 0074 __acrt_CompareStringA"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 54 00 00 B4 D3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 14 00 00 14 E8 0F 40 F9 01 99 40 F9 A1 00 00 B5 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 10 00 00 14 07 15 40 B9 06 00 80 12 65 02 00 91 04 00 80 12 83 02 00 91 22 00 82 52 E0 63 00 91 ?? ?? ?? ?? C0 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 B0 12 02 00 00 14 00 08 00 51 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_77_7_0 {
	meta:
		name = "?_wcslwr_s_l_stat@@YAHPEA_W_KPEAU__crt_locale_pointers@@@Z"
		size = 564
		refs = "0014 __security_push_cookie 002c _errno 0038 _invalid_parameter_noinfo 004c wcsnlen 00b8 __acrt_LCMapStringW 0150 __chkstk 0170 _malloc_base 01dc wcscpy_s 0210 _free_base 021c __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 FD 03 00 91 ?? ?? ?? ?? F8 03 00 91 14 00 00 91 35 00 00 91 56 00 00 91 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 76 00 00 14 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 1F 00 15 EB 63 00 00 54 9F 02 00 79 F4 FF FF 17 C8 02 40 F9 00 9D 40 F9 E0 01 00 B5 88 02 40 79 68 01 00 34 8B 02 40 79 E9 F7 9F 52 69 01 09 0B 2A 3D 00 53 5F 65 00 71 68 00 00 54 6B 81 00 11 8B 02 00 79 8D 2E 40 78 ED FE FF 35 00 00 80 52 5E 00 00 14 05 00 80 52 04 00 80 D2 03 00 80 12 82 02 00 91 01 20 80 52 ?? ?? ?? ?? 17 00 00 11 F7 00 00 35 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 40 B9 50 00 00 14 E9 7E 40 93 BF 02 09 EB 02 01 00 54 9F 02 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 46 00 00 14 2A F9 7F D3 48 41 00 91 1F 01 0A EB 08 81 9F 9A C8 03 00 B4 48 41 00 91 1F 05 09 EB 08 81 9F 9A 1F 01 10 F1 28 F9 7F D3 09 41 00 91 C8 01 00 54 3F 01 08 EB 2A 81 9F 9A 4B 3D 00 91 7F 01 0A EB 4C 00 00 54 EB DF 7C B2 6F FD 44 D3 ?? ?? ?? ?? FF 73 2F CB F3 03 00 91 B3 01 00 B4 88 99 99 52 07 00 00 14 3F 01 08 EB 20 81 9F 9A ?? ?? ?? ?? 13 00 00 91 D3 00 00 B4 A8 BB 9B 52 68 02 00 B9 73 42 00 91 02 00 00 14 13 00 80 D2 F3 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 ?? ?? ?? ?? 14 00 40 B9 14 00 00 14 C8 02 40 F9 E5 02 00 11 64 02 00 91 03 00 80 12 82 02 00 91 00 9D 40 F9 01 20 80 52 ?? ?? ?? ?? E0 00 00 34 62 02 00 91 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 14 00 00 11 05 00 00 14 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 54 05 80 52 F3 00 00 B4 68 02 5F B8 A9 BB 9B 52 1F 01 09 6B 61 00 00 54 60 42 00 D1 ?? ?? ?? ?? 80 02 00 11 1F 03 00 91 ?? ?? ?? ?? F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_77_13_0 {
	meta:
		name = "_wcslwr"
		size = 144
		refs = "000c __acrt_locale_changed_data 0020 _errno 002c _invalid_parameter_noinfo 007c _wcslwr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 91 C8 02 00 35 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 14 00 00 14 68 02 40 79 6E 02 00 91 08 02 00 34 CB 01 40 79 E9 F7 9F 52 69 01 09 0B 2A 3D 00 53 5F 65 00 71 68 00 00 54 6B 81 00 11 CB 01 00 79 CD 2D 40 78 ED FE FF 35 05 00 00 14 02 00 80 D2 01 00 80 92 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_77_14_0 {
	meta:
		name = "_wcslwr_l"
		size = 44
		refs = "0018 _wcslwr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 22 00 00 91 01 00 80 92 13 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_78_14_0 {
	meta:
		name = "_strlwr_l"
		size = 44
		refs = "0018 _strlwr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 22 00 00 91 01 00 80 92 13 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_634_14_0 {
	meta:
		name = "_strupr_l"
		size = 44
		refs = "0018 _strupr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 22 00 00 91 01 00 80 92 13 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_623_13_0 {
	meta:
		name = "_wcsupr_l"
		size = 44
		refs = "0018 _wcsupr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 22 00 00 91 01 00 80 92 13 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_77_16_0 {
	meta:
		name = "_wcslwr_s_l"
		size = 84
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002c ?_wcslwr_s_l_stat@@YAHPEA_W_KPEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? E2 63 00 91 61 02 00 91 80 02 00 91 ?? ?? ?? ?? E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_78_16_0 {
	meta:
		name = "_strlwr_s_l"
		size = 84
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002c ?_strlwr_s_l_stat@@YAHQEAD_KQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? E2 63 00 91 61 02 00 91 80 02 00 91 ?? ?? ?? ?? E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_634_16_0 {
	meta:
		name = "_strupr_s_l"
		size = 84
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002c ?_strupr_s_l_stat@@YAHQEAD_KQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? E2 63 00 91 61 02 00 91 80 02 00 91 ?? ?? ?? ?? E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_623_15_0 {
	meta:
		name = "_wcsupr_s_l"
		size = 84
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002c ?_wcsupr_s_l_stat@@YAHQEA_W_KQEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? E2 63 00 91 61 02 00 91 80 02 00 91 ?? ?? ?? ?? E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_78_7_0 {
	meta:
		name = "?_strlwr_s_l_stat@@YAHQEAD_KQEAU__crt_locale_pointers@@@Z"
		size = 600
		refs = "0018 __security_push_cookie 0034 _errno 0040 _invalid_parameter_noinfo 0054 strnlen 00cc __acrt_LCMapStringA 0160 __chkstk 0180 _malloc_base 01f8 strcpy_s 022c _free_base 023c __security_pop_cookie"
	strings:
		$1 = { FD 7B BB A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 23 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 F9 43 00 91 14 00 00 91 36 00 00 91 57 00 00 91 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 7B 00 00 14 C1 02 00 91 80 02 00 91 ?? ?? ?? ?? 1F 00 16 EB 63 00 00 54 9F 02 00 39 F4 FF FF 17 E8 02 40 F9 01 9D 40 F9 C1 01 00 B5 88 02 C0 39 48 01 00 34 8B 02 C0 39 69 FD 02 11 2A 1D 00 53 5F 65 00 71 68 00 00 54 6B 81 00 11 8B 02 00 39 8C 1E C0 38 0C FF FF 35 00 00 80 52 64 00 00 14 07 0D 40 B9 38 00 80 52 06 00 80 52 F8 03 00 B9 05 00 80 D2 04 00 80 12 83 02 00 91 02 20 80 52 E0 02 00 91 ?? ?? ?? ?? 15 00 00 11 F5 00 00 35 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 40 B9 52 00 00 14 DF C2 35 EB 02 01 00 54 9F 02 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 49 00 00 14 A9 7E 40 93 28 41 00 91 1F 01 09 EB 08 81 9F 9A C8 03 00 B4 28 41 00 91 1F C1 35 EB 08 81 9F 9A 1F 01 10 F1 A8 7E 40 93 09 41 00 91 C8 01 00 54 3F 01 08 EB 2A 81 9F 9A 4B 3D 00 91 7F 01 0A EB 4C 00 00 54 EB DF 7C B2 6F FD 44 D3 ?? ?? ?? ?? FF 73 2F CB F3 43 00 91 B3 01 00 B4 88 99 99 52 07 00 00 14 3F 01 08 EB 20 81 9F 9A ?? ?? ?? ?? 13 00 00 91 D3 00 00 B4 A8 BB 9B 52 68 02 00 B9 73 42 00 91 02 00 00 14 13 00 80 D2 F3 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 ?? ?? ?? ?? 14 00 40 B9 17 00 00 14 E8 02 40 F9 A6 02 00 11 F8 03 00 B9 65 02 00 91 04 00 80 12 83 02 00 91 07 0D 40 B9 02 20 80 52 01 9D 40 F9 E0 02 00 91 ?? ?? ?? ?? E0 00 00 34 62 02 00 91 C1 02 00 91 80 02 00 91 ?? ?? ?? ?? 14 00 00 11 05 00 00 14 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 54 05 80 52 F3 00 00 B4 68 02 5F B8 A9 BB 9B 52 1F 01 09 6B 61 00 00 54 60 42 00 D1 ?? ?? ?? ?? 80 02 00 11 3F 43 00 D1 FF 43 00 91 ?? ?? ?? ?? F9 23 40 F9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_78_13_0 {
	meta:
		name = "_strlwr"
		size = 140
		refs = "000c __acrt_locale_changed_data 0020 _errno 002c _invalid_parameter_noinfo 0078 _strlwr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 91 A8 02 00 35 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 13 00 00 14 68 02 C0 39 6D 02 00 91 E8 01 00 34 AB 01 C0 39 69 FD 02 11 2A 1D 00 53 5F 65 00 71 68 00 00 54 6B 81 00 11 AB 01 00 39 AC 1D C0 38 0C FF FF 35 05 00 00 14 02 00 80 D2 01 00 80 92 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_79_0_0 {
	meta:
		name = "??$common_filelength@J@@YAJH@Z"
		size = 312
		refs = "0024 __doserrno 002c _errno 0040 _nhandle 0058 __pioinfo 007c __acrt_lowio_lock_fh 00b8 _lseek_nolock 00fc __acrt_lowio_unlock_fh 011c _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 11 B3 13 00 B9 7F 0A 00 31 E1 00 00 54 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 3A 00 00 14 73 06 F8 37 ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 08 6B E2 05 00 54 68 7E 40 93 15 FD 46 93 ?? ?? ?? ?? ?? ?? ?? ?? 17 15 40 92 C8 7A 75 F8 09 19 17 8B 2A E1 40 39 48 01 00 12 A8 04 00 34 60 02 00 11 ?? ?? ?? ?? 14 00 80 12 C8 7A 75 F8 09 19 17 8B 2A E1 40 39 EA 00 00 37 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 1F 00 00 B9 14 00 00 14 22 00 80 52 01 00 80 52 60 02 00 11 ?? ?? ?? ?? 15 00 00 11 BF 06 00 31 A0 01 00 54 42 00 80 52 01 00 80 52 60 02 00 11 ?? ?? ?? ?? 14 00 00 11 B4 17 00 B9 BF 02 14 6B A0 00 00 54 02 00 80 52 A1 02 00 11 60 02 00 11 ?? ?? ?? ?? 60 02 00 11 ?? ?? ?? ?? 80 02 00 11 08 00 00 14 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_79_2_0 {
	meta:
		name = "??$common_filelength@_J@@YA_JH@Z"
		size = 312
		refs = "0024 __doserrno 002c _errno 0040 _nhandle 0058 __pioinfo 007c __acrt_lowio_lock_fh 00b8 _lseeki64_nolock 00fc __acrt_lowio_unlock_fh 011c _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 11 B3 13 00 B9 7F 0A 00 31 E1 00 00 54 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 3A 00 00 14 73 06 F8 37 ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 08 6B E2 05 00 54 68 7E 40 93 15 FD 46 93 ?? ?? ?? ?? ?? ?? ?? ?? 17 15 40 92 C8 7A 75 F8 09 19 17 8B 2A E1 40 39 48 01 00 12 A8 04 00 34 60 02 00 11 ?? ?? ?? ?? 14 00 80 92 C8 7A 75 F8 09 19 17 8B 2A E1 40 39 EA 00 00 37 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 1F 00 00 B9 14 00 00 14 22 00 80 52 01 00 80 D2 60 02 00 11 ?? ?? ?? ?? 15 00 00 91 BF 06 00 B1 A0 01 00 54 42 00 80 52 01 00 80 D2 60 02 00 11 ?? ?? ?? ?? 14 00 00 91 B4 0F 00 F9 BF 02 14 EB A0 00 00 54 02 00 80 52 A1 02 00 91 60 02 00 11 ?? ?? ?? ?? 60 02 00 11 ?? ?? ?? ?? 80 02 00 91 08 00 00 14 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_79_4_0 {
	meta:
		name = "??$lseek_nolock@AEBHAEBJH@?$__crt_integer_traits@J@@SAJAEBHAEBJ$$QEAH@Z"
		size = 16
		refs = "000c _lseek_nolock"
		altNames = "??$lseek_nolock@AEBHHH@?$__crt_integer_traits@J@@SAJAEBH$$QEAH1@Z"
	strings:
		$1 = { 42 00 40 B9 21 00 40 B9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_79_7_0 {
	meta:
		name = "??$lseek_nolock@AEBHHH@?$__crt_integer_traits@_J@@SA_JAEBH$$QEAH1@Z"
		size = 16
		refs = "000c _lseeki64_nolock"
	strings:
		$1 = { 21 00 80 B9 42 00 40 B9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_80_5_0 {
	meta:
		name = "_ismbclegal_l"
		size = 112
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? EA 13 40 F9 68 7E 08 53 09 1D 00 53 48 C1 29 8B 09 65 40 39 E9 00 10 36 68 1E 00 53 48 C1 28 8B 09 65 40 39 69 00 18 36 20 00 80 52 02 00 00 14 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_81_4_0 {
	meta:
		name = "_wctomb_l"
		size = 116
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 003c _wctomb_s_l"
	strings:
		$1 = { F3 53 BF A9 FD 7B BC A9 FD 03 00 91 14 00 00 91 33 00 00 11 41 00 00 91 E0 63 00 91 ?? ?? ?? ?? E8 13 40 F9 E4 83 00 91 63 02 00 11 FF 13 00 B9 81 02 00 91 E0 43 00 91 02 09 80 B9 ?? ?? ?? ?? E8 13 40 B9 09 00 80 12 1F 00 00 71 20 11 88 1A E9 C3 40 39 A9 00 00 34 EA 0F 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C4 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_81_5_0 {
	meta:
		name = "_wctomb_s_l"
		size = 412
		refs = "0054 _errno 0060 _invalid_parameter_noinfo 0074 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00a8 memset 0100 __imp_WideCharToMultiByte 0150 __imp_GetLastError"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BC A9 FD 03 00 91 34 00 00 91 E3 23 00 79 9F 02 00 F1 55 00 00 91 A4 0A 40 FA 13 00 00 91 A9 00 00 54 53 00 00 B4 7F 02 00 B9 00 00 80 52 27 00 00 14 73 00 00 B4 08 00 80 12 68 02 00 B9 E8 7B 40 B2 BF 02 08 EB E9 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 1B 00 00 14 81 00 00 91 E0 63 00 91 ?? ?? ?? ?? E9 13 40 F9 28 9D 40 F9 08 04 00 B5 E8 23 40 79 1F FD 03 71 C9 02 00 54 9F 02 00 F1 A4 1A 40 FA A9 00 00 54 A2 02 00 91 01 00 80 52 80 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 40 05 80 52 E8 C3 40 39 A8 00 00 34 EA 0F 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C4 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 74 00 00 B4 F5 04 00 B4 88 02 00 39 D3 02 00 B4 28 00 80 52 68 02 00 B9 13 00 00 14 ?? ?? ?? ?? FF 17 00 B9 20 0D 40 B9 ?? ?? ?? ?? 09 FD DF C8 A5 02 00 11 E7 53 00 91 06 00 80 D2 84 02 00 91 23 00 80 52 E2 43 00 91 01 00 80 52 20 01 3F D6 E0 00 00 34 E8 17 40 B9 88 FB FF 35 53 00 00 B4 60 02 00 B9 00 00 80 52 DC FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 1F E8 01 71 41 FA FF 54 9F 02 00 F1 A4 1A 40 FA A9 00 00 54 A2 02 00 91 01 00 80 52 80 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 C9 FF FF 17 }
	condition:
		$1
}

rule file_81_6_0 {
	meta:
		name = "wctomb"
		size = 80
		refs = "0018 ___mb_cur_max_func 0030 _wctomb_s_l"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 14 00 00 91 FF 13 00 B9 33 00 00 11 ?? ?? ?? ?? 02 7C 40 93 E0 43 00 91 04 00 80 D2 63 02 00 11 81 02 00 91 ?? ?? ?? ?? E8 13 40 B9 09 00 80 12 1F 00 00 71 20 11 88 1A FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_82_0_0 {
	meta:
		name = "cexpf"
		size = 472
		refs = "0010 crealf 0020 cimagf 002c _fdtest 00a8 _FZero_C 00d4 cosf 00f0 sinf 010c _fperrraise 0114 _FNan_C 01a4 _fdexp 01c8 _FCbuild"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 E0 07 05 2D ?? ?? ?? ?? E1 2F 40 BD E0 1F 00 BD E0 2B 40 BD ?? ?? ?? ?? E0 73 00 91 E0 1B 00 BD ?? ?? ?? ?? 13 00 00 11 E0 63 00 91 ?? ?? ?? ?? 7F 0A 00 71 C1 00 00 54 F4 1F 40 BD F4 13 00 BD C0 09 00 35 F3 1B 40 BD 4D 00 00 14 1F 08 00 71 81 01 00 54 7F 06 00 71 01 01 00 54 F4 1F 40 BD 88 22 20 1E E2 05 00 54 FF 7F 02 29 F3 03 27 1E F4 03 27 1E 50 00 00 14 F4 1B 40 BD 3E 00 00 14 7F 06 00 71 C1 06 00 54 F0 1F 40 BD 08 22 20 1E 22 03 00 54 1F 04 00 71 61 01 00 54 ?? ?? ?? ?? F1 1B 40 BD F3 03 27 1E ?? ?? ?? ?? FF 13 00 B9 F4 03 27 1E 28 22 20 1E 12 42 21 1E 53 3E 33 1E 2F 00 00 14 E0 1B 40 BD ?? ?? ?? ?? F0 03 27 1E FF 17 00 B9 11 08 30 1E E0 1B 40 BD F1 23 00 BD F1 13 00 BD ?? ?? ?? ?? F3 03 27 1E 13 08 33 1E 18 00 00 14 1F 04 00 71 01 01 00 54 20 00 80 52 ?? ?? ?? ?? F4 1F 40 BD ?? ?? ?? ?? ?? ?? ?? ?? F4 13 00 BD 1A 00 00 14 80 00 00 35 14 42 20 1E F4 13 00 BD C8 FF FF 17 E0 1B 40 BD ?? ?? ?? ?? F0 1F 40 BD 11 08 30 1E E0 1B 40 BD F1 23 00 BD F1 13 00 BD ?? ?? ?? ?? F0 1F 40 BD 13 08 30 1E F3 17 00 BD F4 23 40 BD 17 00 00 14 1F 04 00 71 21 01 00 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F4 13 00 BD 93 42 20 1E F3 17 00 BD 0D 00 00 14 E0 43 43 2D F0 43 02 2D ?? ?? ?? ?? 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? E0 1B 40 BD ?? ?? ?? ?? 01 00 80 52 E0 53 00 91 ?? ?? ?? ?? F4 4F 42 2D 61 42 20 1E 80 42 20 1E ?? ?? ?? ?? FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_83_1_0 {
	meta:
		name = "??$common_refill_and_read_nolock@D@@YAHV__crt_stdio_stream@@@Z"
		size = 548
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 00b4 __acrt_stdio_allocate_buffer_nolock 00cc _fileno 00d8 _read 0174 __pioinfo 0190 __badioinfo"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 20 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 08 14 40 B9 BF 3B 03 D5 48 FF 6F 36 E8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 C9 FE 67 37 E8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 E8 0B 40 F9 09 01 08 36 0B 51 00 91 6A FD 5F 88 4A 01 1C 32 6A FD 09 88 A9 FF FF 35 BF 3B 03 D5 EA FF FF 17 0C 51 00 91 8B FD 5F 88 6B 01 00 32 8B FD 0A 88 AA FF FF 35 BF 3B 03 D5 E8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 08 98 80 52 28 01 08 0A 68 00 00 35 E0 0B 40 F9 ?? ?? ?? ?? E8 0B 40 F9 09 05 40 F9 09 01 00 F9 F3 0B 40 F9 60 02 00 91 ?? ?? ?? ?? 62 22 40 B9 61 06 40 F9 ?? ?? ?? ?? E8 0B 40 F9 00 11 00 B9 E9 0B 40 F9 2A 11 40 B9 48 05 00 11 1F 05 00 71 C8 01 00 54 5F 01 00 71 0B 02 80 52 08 01 80 52 6D 11 88 1A 2C 51 00 91 8B FD 5F 88 6B 01 0D 2A 8B FD 0A 88 AA FF FF 35 BF 3B 03 D5 E8 0B 40 F9 1F 11 00 B9 BF FF FF 17 28 15 40 B9 BF 3B 03 D5 08 05 1F 12 88 04 00 35 E0 0B 40 F9 ?? ?? ?? ?? 1F 04 00 31 40 02 00 54 E0 0B 40 F9 ?? ?? ?? ?? 1F 08 00 31 C0 01 00 54 E0 0B 40 F9 ?? ?? ?? ?? 13 00 00 11 E0 0B 40 F9 ?? ?? ?? ?? 68 7E 40 93 ?? ?? ?? ?? 0B FD 46 93 ?? ?? ?? ?? 29 79 6B F8 0A 14 40 92 2C 19 0A 8B 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 88 E1 40 39 49 10 80 52 08 01 09 0A 1F 09 02 71 01 01 00 54 E8 0B 40 F9 0C 51 00 91 8A FD 5F 88 4A 01 1B 32 8A FD 09 88 A9 FF FF 35 BF 3B 03 D5 E8 0B 40 F9 09 21 40 B9 3F 01 08 71 81 01 00 54 09 15 40 B9 BF 3B 03 D5 09 01 30 36 E8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 89 00 40 37 E8 0B 40 F9 09 00 82 52 09 21 00 B9 E8 0B 40 F9 09 11 40 B9 2A 05 00 51 0A 11 00 B9 0B 01 40 F9 69 05 00 91 60 01 40 39 09 01 00 F9 82 FF FF 17 }
	condition:
		$1
}

rule file_83_2_0 {
	meta:
		name = "??$common_refill_and_read_nolock@_W@@YAHV__crt_stdio_stream@@@Z"
		size = 648
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 00bc __acrt_stdio_allocate_buffer_nolock 00f8 _fileno 0104 _read 01a0 __pioinfo 01bc __badioinfo"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 40 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? E0 FF 9F 52 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 08 14 40 B9 BF 3B 03 D5 28 FF 6F 36 E8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 A9 FE 67 37 E8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 E8 0B 40 F9 09 01 08 36 0B 51 00 91 6A FD 5F 88 4A 01 1C 32 6A FD 09 88 A9 FF FF 35 BF 3B 03 D5 E9 FF FF 17 0C 51 00 91 8B FD 5F 88 6B 01 00 32 8B FD 0A 88 AA FF FF 35 BF 3B 03 D5 E8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 08 98 80 52 28 01 08 0A 68 00 00 35 E0 0B 40 F9 ?? ?? ?? ?? E8 0B 40 F9 09 11 40 B9 3F 05 00 71 A1 00 00 54 09 01 40 F9 34 00 80 52 35 01 40 39 03 00 00 14 14 00 80 52 15 00 80 52 09 05 40 F9 09 01 00 F9 F3 0B 40 F9 60 02 00 91 ?? ?? ?? ?? 62 22 40 B9 61 06 40 F9 ?? ?? ?? ?? E8 0B 40 F9 00 11 00 B9 E9 0B 40 F9 2A 11 40 B9 48 05 00 11 1F 09 00 71 C8 01 00 54 5F 01 00 71 0B 02 80 52 08 01 80 52 6D 11 88 1A 2C 51 00 91 8B FD 5F 88 6B 01 0D 2A 8B FD 0A 88 AA FF FF 35 BF 3B 03 D5 E8 0B 40 F9 1F 11 00 B9 B5 FF FF 17 28 15 40 B9 BF 3B 03 D5 08 05 1F 12 88 04 00 35 E0 0B 40 F9 ?? ?? ?? ?? 1F 04 00 31 40 02 00 54 E0 0B 40 F9 ?? ?? ?? ?? 1F 08 00 31 C0 01 00 54 E0 0B 40 F9 ?? ?? ?? ?? 13 00 00 11 E0 0B 40 F9 ?? ?? ?? ?? 68 7E 40 93 ?? ?? ?? ?? 0B FD 46 93 ?? ?? ?? ?? 29 79 6B F8 0A 14 40 92 2C 19 0A 8B 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 88 E1 40 39 49 10 80 52 08 01 09 0A 1F 09 02 71 01 01 00 54 E8 0B 40 F9 0C 51 00 91 8A FD 5F 88 4A 01 1B 32 8A FD 09 88 A9 FF FF 35 BF 3B 03 D5 E8 0B 40 F9 09 21 40 B9 3F 01 08 71 81 01 00 54 09 15 40 B9 BF 3B 03 D5 09 01 30 36 E8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 89 00 40 37 E8 0B 40 F9 09 00 82 52 09 21 00 B9 E8 0B 40 F9 09 01 40 F9 B4 01 00 34 2A 01 C0 39 09 11 40 B9 4B 1D 18 53 2A 05 00 51 0A 11 00 B9 6C 3D 00 53 0B 01 40 F9 8D 01 15 2A A0 3D 00 53 69 05 00 91 09 01 00 F9 72 FF FF 17 0A 11 40 B9 20 01 40 79 49 09 00 51 09 11 00 B9 0B 01 40 F9 6A 09 00 91 0A 01 00 F9 6A FF FF 17 }
	condition:
		$1
}

rule file_83_6_0 {
	meta:
		name = "?get_context_nolock@@YA?AUfilwbuf_context@?A0x763516dc@@V__crt_stdio_stream@@_W@Z"
		size = 60
	strings:
		$1 = { FF 43 00 D1 08 10 40 B9 1F 05 00 71 E1 00 00 54 28 00 80 52 E8 03 00 39 08 00 40 F9 09 01 40 39 E9 07 00 39 03 00 00 14 FF 03 00 39 FF 07 00 39 E0 03 40 79 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_83_8_0 {
	meta:
		name = "?get_flags@__crt_stdio_stream@@QEBAJXZ"
		size = 16
	strings:
		$1 = { 08 00 40 F9 00 15 40 B9 BF 3B 03 D5 C0 03 5F D6 }
	condition:
		$1
}

rule file_83_9_0 {
	meta:
		name = "?has_all_of@__crt_stdio_stream@@QEBA_NJ@Z"
		size = 28
	strings:
		$1 = { 08 00 40 F9 09 15 40 B9 BF 3B 03 D5 28 01 01 0A 1F 01 01 6B E0 17 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_83_10_0 {
	meta:
		name = "?has_any_buffer@__crt_stdio_stream@@QEBA_NXZ"
		size = 28
	strings:
		$1 = { 08 00 40 F9 09 15 40 B9 BF 3B 03 D5 08 98 80 52 3F 01 08 6A E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_83_11_0 {
	meta:
		name = "?has_any_of@__crt_stdio_stream@@QEBA_NJ@Z"
		size = 24
	strings:
		$1 = { 08 00 40 F9 09 15 40 B9 BF 3B 03 D5 3F 01 01 6A E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_83_12_0 {
	meta:
		name = "?has_crt_buffer@__crt_stdio_stream@@QEBA_NXZ"
		size = 20
	strings:
		$1 = { 08 00 40 F9 09 15 40 B9 BF 3B 03 D5 20 19 06 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_83_13_0 {
	meta:
		name = "?is_buffer_valid_nolock@@YA_NV__crt_stdio_stream@@D@Z"
		size = 20
	strings:
		$1 = { 08 10 40 B9 09 05 00 11 3F 05 00 71 E0 97 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_83_14_0 {
	meta:
		name = "?is_buffer_valid_nolock@@YA_NV__crt_stdio_stream@@_W@Z"
		size = 20
	strings:
		$1 = { 08 10 40 B9 09 05 00 11 3F 09 00 71 E0 97 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_83_15_0 {
	meta:
		name = "?is_in_use@__crt_stdio_stream@@QEBA_NXZ"
		size = 20
	strings:
		$1 = { 08 00 40 F9 09 15 40 B9 BF 3B 03 D5 20 35 0D 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_83_16_0 {
	meta:
		name = "?is_string_backed@__crt_stdio_stream@@QEBA_NXZ"
		size = 20
	strings:
		$1 = { 08 00 40 F9 09 15 40 B9 BF 3B 03 D5 20 31 0C 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_83_18_0 {
	meta:
		name = "?read_character_nolock@@YAEV__crt_stdio_stream@@HD@Z"
		size = 44
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 08 10 40 B9 09 05 00 51 09 10 00 B9 E8 03 40 F9 09 01 40 F9 20 15 40 38 09 01 00 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_83_19_0 {
	meta:
		name = "?read_character_nolock@@YA_WV__crt_stdio_stream@@Ufilwbuf_context@?A0x763516dc@@_W@Z"
		size = 124
	strings:
		$1 = { FF 43 00 D1 E1 03 00 79 E8 03 40 39 E0 07 00 F9 E8 01 00 34 08 00 40 F9 09 01 C0 39 E8 07 40 39 2A 1D 18 53 4B 3D 00 53 6C 01 08 2A 08 10 40 B9 09 05 00 51 09 10 00 B9 E8 07 40 F9 80 3D 00 53 09 01 40 F9 2A 05 00 91 0A 00 00 14 08 00 40 F9 09 10 40 B9 0B 01 40 79 28 09 00 51 08 10 00 B9 E8 07 40 F9 60 01 00 11 09 01 40 F9 2A 09 00 91 0A 01 00 F9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_83_20_0 {
	meta:
		name = "?set_flags@__crt_stdio_stream@@QEBA_NJ@Z"
		size = 40
	strings:
		$1 = { 08 00 40 F9 0C 51 00 91 8B FD 5F 88 69 01 01 2A 89 FD 0A 88 AA FF FF 35 BF 3B 03 D5 7F 01 01 6A E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_84_0_0 {
	meta:
		name = "??$common_wincmdln@D@@YAPEADXZ"
		size = 136
		refs = "000c __acrt_initialize_multibyte 0010 _acmdln 0018 ?empty_string@?1???$common_wincmdln@D@@YAPEADXZ@4PADA 0050 _ismbblead"
		altNames = "_get_narrow_winmain_command_line"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 14 00 80 52 3F 01 00 F1 13 01 89 9A 60 02 C0 39 1F 80 00 71 6C 00 00 54 00 02 00 34 B4 01 00 34 1F 88 00 71 61 00 00 54 9F 02 00 71 F4 17 9F 1A ?? ?? ?? ?? 40 00 00 34 73 06 00 91 73 06 00 91 F3 FF FF 17 1F 81 00 71 8C 00 00 54 73 06 00 91 68 02 C0 39 88 FF FF 35 60 02 00 91 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_84_6_0 {
	meta:
		name = "?should_copy_another_character@@YA_ND@Z"
		size = 28
		refs = "0008 _ismbblead"
		altNames = "?is_lead_byte@@YA_ND@Z"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 07 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_85_0_0 {
	meta:
		name = "_j0"
		size = 288
		refs = "0030 J0q 0034 J0p 0048 evaluate 0054 P0q 0058 P0p 0094 cos 009c Q0q 00a0 Q0p 00d8 sin"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 11 40 60 1E F1 0B 00 FD 28 22 60 1E 62 00 00 54 31 42 61 1E F1 0B 00 FD 10 D0 63 1E 20 22 70 1E 48 01 00 54 20 0A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? 83 00 80 52 ?? ?? ?? ?? 61 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 2E 00 00 14 10 10 64 1E ?? ?? ?? ?? ?? ?? ?? ?? A3 00 80 52 10 1A 71 1E ?? ?? ?? ?? A1 00 80 52 ?? ?? ?? ?? 00 0A 70 1E F0 0F 00 FD ?? ?? ?? ?? F1 0B 40 FD 90 04 00 5C E0 13 00 FD 30 3A 70 1E 00 42 60 1E F0 17 00 FD ?? ?? ?? ?? F0 13 40 FD ?? ?? ?? ?? ?? ?? ?? ?? A3 00 80 52 ?? ?? ?? ?? 10 08 70 1E A1 00 80 52 ?? ?? ?? ?? F0 1B 00 FD F0 0F 40 FD 00 0A 70 1E ?? ?? ?? ?? F0 0F 40 FD 10 08 70 1E E0 17 40 FD F0 13 00 FD ?? ?? ?? ?? F0 13 40 FD F1 1B 40 FD 14 C6 40 1F F1 0B 40 FD 70 01 00 5C 32 0A 70 1E 11 10 60 1E 32 1A 72 1E 53 C2 61 1E 80 0A 73 1E FD 7B C4 A8 C0 03 5F D6 1F 20 03 D5 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 09 40 }
	condition:
		$1
}

rule file_85_1_0 {
	meta:
		name = "_j1"
		size = 328
		refs = "003c J1q 0040 J1p 0054 evaluate 0070 P1q 0074 P1p 00b0 cos 00b8 Q1q 00bc Q1p 00f4 sin"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 11 40 60 1E 33 00 80 52 F1 0B 00 FD 28 22 60 1E 82 00 00 54 31 42 61 1E 13 00 80 12 F1 0B 00 FD 10 D0 63 1E 20 22 70 1E C8 01 00 54 20 0A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? 83 00 80 52 ?? ?? ?? ?? 41 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 70 02 62 1E F1 0B 40 FD 11 0A 71 1E 00 08 71 1E 30 00 00 14 12 10 64 1E ?? ?? ?? ?? ?? ?? ?? ?? A3 00 80 52 50 1A 71 1E ?? ?? ?? ?? A1 00 80 52 ?? ?? ?? ?? 00 0A 70 1E F0 0F 00 FD ?? ?? ?? ?? F1 0B 40 FD F0 04 00 5C E0 13 00 FD 30 3A 70 1E 00 42 60 1E F0 17 00 FD ?? ?? ?? ?? F0 13 40 FD ?? ?? ?? ?? ?? ?? ?? ?? A3 00 80 52 ?? ?? ?? ?? 10 08 70 1E A1 00 80 52 ?? ?? ?? ?? F0 1B 00 FD F0 0F 40 FD 00 0A 70 1E ?? ?? ?? ?? F0 0F 40 FD 10 08 70 1E E0 17 40 FD F0 13 00 FD ?? ?? ?? ?? F0 13 40 FD F1 1B 40 FD 73 02 62 1E 15 C6 40 1F F1 0B 40 FD B0 01 00 5C 32 0A 70 1E 11 10 60 1E 32 1A 72 1E 54 C2 61 1E 94 0A 73 1E A0 0A 74 1E FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 D2 21 33 7F 7C D9 02 40 18 2D 44 54 FB 21 09 40 }
	condition:
		$1
}

rule file_85_2_0 {
	meta:
		name = "_jn"
		size = 364
		refs = "002c _j0 0040 _j1"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 18 40 60 1E F8 0B 00 FD 80 00 F8 36 18 43 61 1E E0 03 00 4B F8 0B 00 FD 80 00 00 35 00 43 60 1E ?? ?? ?? ?? 4C 00 00 14 1F 04 00 71 81 00 00 54 00 43 60 1E ?? ?? ?? ?? 47 00 00 14 08 23 60 1E 61 00 00 54 E0 03 67 9E 43 00 00 14 11 00 62 1E 10 C3 60 1E 20 22 70 1E 62 03 00 54 00 43 60 1E 13 78 1F 53 ?? ?? ?? ?? E0 0F 00 FD E0 0B 40 FD ?? ?? ?? ?? 10 10 60 1E F3 0F 40 FD 17 40 60 1E 88 00 80 52 7F 12 00 71 F1 0A 70 1E F0 0B 40 FD 32 1A 70 1E 40 3A 73 1E E0 05 00 54 13 01 62 1E 08 09 00 11 F6 42 60 1E 1F 01 13 6B 17 40 60 1E 74 0A 60 1E 95 1A 70 1E A0 3A 76 1E 01 FF FF 54 25 00 00 14 09 78 1F 53 12 0B 78 1E 28 91 00 11 F1 03 67 9E 05 00 00 14 10 01 62 1E 08 09 00 51 11 3A 71 1E 51 1A 71 1E 1F 01 09 6B 6C FF FF 54 32 01 62 1E 28 09 00 51 14 01 62 1E 0A 09 00 51 19 10 6E 1E 53 3A 71 1E 95 1A 78 1E 10 1B 73 1E B1 3A 70 1E F1 43 01 6D 4A 01 00 34 50 01 62 1E 4A 09 00 51 37 43 60 1E 39 42 60 1E 11 0A 71 1E 36 1A 78 1E D1 3A 77 1E 2A FF FF 35 F1 0B 00 FD 00 43 60 1E ?? ?? ?? ?? F1 43 41 6D 10 08 70 1E 00 1A 71 1E FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_85_3_0 {
	meta:
		name = "_y0"
		size = 384
		refs = "000c _dclass 0024 _handle_qnan2 0038 _d_ind 0048 domain_err 0060 Y0q 0064 Y0p 0078 evaluate 0084 _j0 0098 log 00ac P0q 00b0 P0p 00e0 Q0q 00e4 Q0p 011c cos 0130 sin"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0B 00 FD ?? ?? ?? ?? 1F 08 00 71 C1 00 00 54 F0 0B 40 FD 01 42 60 1E 00 42 60 1E ?? ?? ?? ?? 4D 00 00 14 F1 0B 40 FD 28 22 60 1E E2 00 00 54 ?? ?? ?? ?? 20 42 60 1E ?? ?? ?? ?? 40 04 80 52 ?? ?? ?? ?? 44 00 00 14 10 D0 63 1E 20 22 70 1E 88 02 00 54 20 0A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? 03 01 80 52 ?? ?? ?? ?? 01 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? E0 0F 00 FD E0 0B 40 FD ?? ?? ?? ?? 10 07 00 5C 10 08 70 1E E0 0B 40 FD F0 13 00 FD ?? ?? ?? ?? F1 C3 41 6D 00 46 40 1F 2E 00 00 14 10 10 64 1E ?? ?? ?? ?? ?? ?? ?? ?? A3 00 80 52 10 1A 71 1E ?? ?? ?? ?? A1 00 80 52 ?? ?? ?? ?? 00 0A 70 1E F0 0F 00 FD ?? ?? ?? ?? F1 0B 40 FD D0 04 00 5C E0 17 00 FD ?? ?? ?? ?? ?? ?? ?? ?? A3 00 80 52 30 3A 70 1E ?? ?? ?? ?? A1 00 80 52 ?? ?? ?? ?? F0 13 00 FD F0 0F 40 FD 00 0A 70 1E ?? ?? ?? ?? F0 0F 40 FD 10 08 70 1E E0 13 40 FD F0 0F 00 FD ?? ?? ?? ?? F0 0F 40 FD 10 0A 60 1E E0 13 40 FD F0 0F 00 FD ?? ?? ?? ?? F0 0F 40 FD F1 17 40 FD 14 40 51 1F F1 0B 40 FD B0 01 00 5C 32 0A 70 1E 11 10 60 1E 32 1A 72 1E 53 C2 61 1E 80 0A 73 1E FD 7B C3 A8 C0 03 5F D6 1F 20 03 D5 83 C8 C9 6D 30 5F E4 3F 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 09 40 }
	condition:
		$1
}

rule file_85_4_0 {
	meta:
		name = "_y1"
		size = 400
		refs = "000c _dclass 0024 _handle_qnan2 0038 _d_ind 0048 domain_err 0060 Y1q 0064 Y1p 0078 evaluate 0084 _j1 0090 log 00bc P1q 00c0 P1p 00f0 Q1q 00f4 Q1p 012c cos 0140 sin"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 0B 00 FD ?? ?? ?? ?? 1F 08 00 71 C1 00 00 54 F0 0B 40 FD 01 42 60 1E 00 42 60 1E ?? ?? ?? ?? 51 00 00 14 F1 0B 40 FD 28 22 60 1E E2 00 00 54 ?? ?? ?? ?? 20 42 60 1E ?? ?? ?? ?? 60 04 80 52 ?? ?? ?? ?? 48 00 00 14 10 D0 63 1E 20 22 70 1E 08 03 00 54 20 0A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? 03 01 80 52 ?? ?? ?? ?? E1 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? E0 0F 00 FD E0 0B 40 FD ?? ?? ?? ?? E0 13 00 FD E0 0B 40 FD ?? ?? ?? ?? F5 53 41 6D 10 10 6E 1E F2 13 40 FD 11 1A 75 1E 53 C6 60 1F 92 06 00 5C 73 0A 72 1E 80 4E 55 1F 2E 00 00 14 14 10 64 1E ?? ?? ?? ?? ?? ?? ?? ?? A3 00 80 52 90 1A 71 1E ?? ?? ?? ?? A1 00 80 52 ?? ?? ?? ?? 00 0A 70 1E F0 0F 00 FD ?? ?? ?? ?? F1 0B 40 FD D0 04 00 5C E0 17 00 FD ?? ?? ?? ?? ?? ?? ?? ?? A3 00 80 52 30 3A 70 1E ?? ?? ?? ?? A1 00 80 52 ?? ?? ?? ?? F0 13 00 FD F0 0F 40 FD 00 0A 70 1E ?? ?? ?? ?? F0 0F 40 FD 10 08 70 1E E0 13 40 FD F0 0F 00 FD ?? ?? ?? ?? F0 0F 40 FD 10 0A 60 1E E0 13 40 FD F0 0F 00 FD ?? ?? ?? ?? F0 0F 40 FD F1 17 40 FD 14 40 51 1F F1 0B 40 FD B0 01 00 5C 32 0A 70 1E 11 10 60 1E 32 1A 72 1E 53 C2 61 1E 80 0A 73 1E FD 7B C3 A8 C0 03 5F D6 1F 20 03 D5 83 C8 C9 6D 30 5F E4 3F D2 21 33 7F 7C D9 02 40 18 2D 44 54 FB 21 09 40 }
	condition:
		$1
}

rule file_85_5_0 {
	meta:
		name = "_yn"
		size = 212
		refs = "001c _d_ind 0028 domain_err 0050 _y0 0068 _y1"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 E0 0B 00 FD 13 00 00 11 08 20 60 1E C2 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 80 04 80 52 ?? ?? ?? ?? 27 00 00 14 34 00 80 52 B3 00 F8 36 F3 03 13 4B 7F 02 00 72 09 00 80 12 34 11 94 1A 00 40 60 1E B3 00 00 35 ?? ?? ?? ?? 90 02 62 1E 00 08 70 1E 1B 00 00 14 7F 06 00 71 61 00 00 54 ?? ?? ?? ?? FA FF FF 17 ?? ?? ?? ?? E0 0F 00 FD E0 0B 40 FD ?? ?? ?? ?? F1 0B 40 FD 10 10 60 1E F2 03 67 9E 28 00 80 52 7F 06 00 71 13 1A 71 1E 4D 01 00 54 F0 0F 40 FD 11 01 62 1E 08 05 00 11 1F 01 13 6B 32 0A 73 1E 52 C2 60 1F 10 40 60 1E 40 42 60 1E 2B FF FF 54 93 02 62 1E 60 0A 72 1E FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_85_6_0 {
	meta:
		name = "domain_err"
		size = 72
		refs = "001c _ctrlfp 0030 _except1"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 11 E1 03 01 6D 00 E0 93 D2 41 01 00 58 ?? ?? ?? ?? E1 03 41 6D 61 02 00 11 02 00 00 91 00 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 00 9F C0 03 00 00 00 00 }
	condition:
		$1
}

rule file_85_7_0 {
	meta:
		name = "evaluate"
		size = 164
		refs = "0014 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 3F 00 00 71 6E C8 40 7A 8C 00 00 54 ?? ?? ?? ?? 00 10 7E 1E 20 00 00 14 10 D8 61 FC 29 04 00 51 3F 01 00 71 12 0A 60 1E 2D 01 00 54 28 7D 40 93 0A 0C 08 8B 51 85 5F FC 29 05 00 51 3F 01 00 71 32 2A 72 1E 52 0A 60 1E 6C FF FF 54 10 00 40 FD 6A 04 00 51 53 D8 63 FC 5F 01 00 71 15 2A 72 1E 74 0A 60 1E 2D 01 00 54 48 7D 40 93 4B 0C 08 8B 71 85 5F FC 4A 05 00 51 5F 01 00 71 32 2A 74 1E 54 0A 60 1E 6C FF FF 54 50 00 40 FD 13 2A 74 1E A0 1A 73 1E FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_86_2_0 {
	meta:
		name = "_rotr64"
		size = 28
	strings:
		$1 = { 29 14 00 12 08 08 80 52 08 01 09 4B 0B 20 C8 9A 0A 24 C9 9A 60 01 0A AA C0 03 5F D6 }
	condition:
		$1
}

rule file_87_14_0 {
	meta:
		name = "_invoke_watson_if_oneof"
		size = 52
		refs = "0030 _invoke_watson"
	strings:
		$1 = { 68 00 00 91 89 00 00 91 80 00 00 34 1F 00 01 6B 04 10 42 7A 40 00 00 54 C0 03 5F D6 E4 00 00 91 C3 00 00 11 A2 00 00 91 21 01 00 91 00 01 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_15_0 {
	meta:
		name = "call_wsetlocale"
		size = 244
		refs = "0020 _wsetlocale 0044 mbstowcs_s 0060 _calloc_base 00b8 _free_base 00d8 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 33 00 00 91 01 00 80 D2 15 00 00 11 D3 00 00 B5 ?? ?? ?? ?? FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 E4 7B 40 B2 63 02 00 91 02 00 80 D2 E0 43 00 91 ?? ?? ?? ?? 1F 58 00 71 80 04 00 54 1F 88 00 71 40 04 00 54 E0 0B 40 F9 41 00 80 D2 ?? ?? ?? ?? 14 00 00 91 54 02 00 B4 E2 0B 40 F9 04 00 80 92 63 02 00 91 81 02 00 91 00 00 80 D2 ?? ?? ?? ?? C0 00 00 34 1F 58 00 71 C0 01 00 54 1F 88 00 71 E1 00 00 54 0B 00 00 14 81 02 00 91 A0 02 00 11 ?? ?? ?? ?? 13 00 00 91 02 00 00 14 13 00 80 D2 80 02 00 91 ?? ?? ?? ?? 60 02 00 91 D9 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_87_16_0 {
	meta:
		name = "setlocale"
		size = 72
		refs = "0010 __acrt_eagerly_load_locale_apis 003c ??$?RV<lambda_9bd929c17696992ce54f1d748594fc62>@@AEAV<lambda_082c17da81b0962e08c0587ee0fac50c>@@V<lambda_9c08ac857f4975304d44e9f601d9b878>@@@?$__crt_seh_guarded_call@PEAD@@QEAAPEAD$$QEAV<lambda_9bd929c17696992ce54f1d748594fc62>@@AEAV<lambda_082c17da81b0962e08c0587ee0fac50c>@@$$QEAV<lambda_9c08ac857f4975304d44e9f601d9b878>@@@Z"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 17 00 B9 E1 13 00 F9 ?? ?? ?? ?? E3 63 00 91 E2 A3 00 91 E1 73 00 91 E0 43 00 91 E8 53 00 91 E9 83 00 91 E8 A7 02 A9 88 00 80 52 89 00 80 52 E8 27 03 29 ?? ?? ?? ?? FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_88_0_0 {
	meta:
		name = "free"
		size = 20
		refs = "0010 _free_base"
	strings:
		$1 = { FF 43 00 D1 FF FF 9F 88 E8 FF DF 88 FF 43 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_89_1_0 {
	meta:
		name = "_mbctokata_l"
		size = 60
		refs = "0010 _ismbchira_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? C0 00 00 34 73 86 02 11 E8 6F 90 52 7F 02 08 6B 43 00 00 54 73 06 00 11 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_90_17_0 {
	meta:
		name = "?set_buffer@@YAHV__crt_stdio_stream@@QEAD_KH@Z"
		size = 76
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 0A 50 00 91 49 FD 5F 88 29 01 03 2A 49 FD 08 88 A8 FF FF 35 BF 3B 03 D5 E8 03 40 F9 00 00 80 52 02 21 00 B9 E9 03 40 F9 21 01 00 F9 E8 03 40 F9 01 05 00 F9 E9 03 40 F9 3F 11 00 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_90_19_0 {
	meta:
		name = "?unset_flags@__crt_stdio_stream@@QEBA_NJ@Z"
		size = 44
	strings:
		$1 = { 08 00 40 F9 ED 03 21 2A 0C 51 00 91 8B FD 5F 88 69 01 0D 0A 89 FD 0A 88 AA FF FF 35 BF 3B 03 D5 7F 01 01 6A E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_90_21_0 {
	meta:
		name = "setvbuf"
		size = 160
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 0088 ??$?RV<lambda_84ec643ea9557e2f7dc01bb0e9624395>@@AEAV<lambda_ca71763b3c0644891230e4f79ea54fa6>@@V<lambda_439a761618c59b0600e24586724d733b>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_84ec643ea9557e2f7dc01bb0e9624395>@@AEAV<lambda_ca71763b3c0644891230e4f79ea54fa6>@@$$QEAV<lambda_439a761618c59b0600e24586724d733b>@@@Z"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 07 02 A9 E2 17 00 B9 E3 0F 00 F9 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 18 00 00 14 5F 10 00 71 80 00 00 54 A2 00 00 34 5F 00 01 71 C1 FE FF 54 48 78 19 12 A8 00 00 35 68 08 00 D1 49 02 00 58 1F 01 09 EB 08 FE FF 54 E8 63 00 91 E0 03 03 A9 E9 83 00 91 E8 27 04 A9 E8 53 00 91 E9 A3 00 91 E8 27 05 A9 E3 C3 00 91 E2 03 01 91 E1 E3 00 91 E0 43 00 91 ?? ?? ?? ?? FD 7B C6 A8 C0 03 5F D6 1F 20 03 D5 FD FF FF 7F 00 00 00 00 }
	condition:
		$1
}

rule file_91_0_0 {
	meta:
		name = "strncat"
		size = 48
	strings:
		$1 = { 09 00 00 91 2A 01 00 91 28 15 C0 38 C8 FF FF 35 C2 00 00 B4 29 14 C0 38 42 04 00 D1 49 15 00 38 69 00 00 34 82 FF FF B5 5F 01 00 39 C0 03 5F D6 }
	condition:
		$1
}

rule file_92_0_0 {
	meta:
		name = "asin"
		size = 584
		refs = "0038 _handle_nan 0058 _controlfp_s 00b8 ??_C@_04FIHNOPOL@asin?$AA@ 00e0 _handle_error"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 00 00 66 9E 09 FE EF D2 1C 40 60 1E FE 03 67 9E 08 FC 74 D3 0A 29 00 12 FC 73 01 6D 08 F8 40 92 1F 01 09 EB 0C 00 41 92 4B FD 0F 51 69 00 00 54 ?? ?? ?? ?? 63 00 00 14 7F 71 00 31 0A 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? E0 0F 40 FD 5A 00 00 14 2B 04 F8 37 10 10 6E 1E 80 23 70 1E 01 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 40 0A 00 5C 4F 00 00 14 10 10 7E 1E 80 23 70 1E 01 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 40 09 00 5C 45 00 00 14 ?? ?? ?? ?? E1 03 67 9E 80 43 60 1E ?? ?? ?? ?? 26 00 80 52 25 04 80 52 04 01 80 52 23 00 80 52 02 FF FF D2 C1 01 80 52 ?? ?? ?? ?? 39 00 00 14 4C 00 00 B4 9C 43 61 1E 7F 05 00 31 0B 01 00 54 10 10 6E 1E 11 3A 7C 1E 10 10 6C 1E 3D 0A 70 1E BE C3 61 1E DC 43 60 1E 02 00 00 14 9D 0B 7C 1E 52 06 00 5C 71 06 00 5C 90 06 00 5C B7 06 00 5C B3 47 52 1F B2 06 00 5C 74 CA 7D 1F B3 06 00 5C 95 4E 5D 1F B4 06 00 5C B6 D2 7D 1F D5 42 5D 1F 96 06 00 5C B8 DB 77 1F 97 06 00 5C BB 0A 7D 1E 19 5F 5D 1F 78 06 00 5C 3A E3 7D 1F 79 06 00 5C 5A 67 5D 1F 7F 1B 7A 1E 6B 02 00 54 C8 03 66 9E FE 0F 00 FD 1C 10 60 1E D5 05 00 5C 08 7D 60 92 16 01 67 9E E8 0F 00 F9 D3 0B 7C 1E D1 F6 56 1F D0 2A 7E 1E 32 1A 70 1E 11 05 00 5C 52 C6 5C 1F 74 CA 7F 1F D3 D6 5C 1F 94 3A 73 1E A0 3A 74 1E 02 00 00 14 E0 73 5C 1F 4C 00 00 B4 00 40 61 1E FD 7B C2 A8 C0 03 5F D6 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 FB 21 F9 BF 61 10 32 5D 66 51 09 3F 35 21 A6 87 F8 E5 51 3F 34 98 02 80 41 1E CD 3F 76 CE 82 29 42 1A BB 3F 90 96 C2 90 D3 28 AC 3F 59 EF B7 C1 BE A2 D1 3F AC 9E 26 7E 29 7B DC 3F 8D F7 18 B4 4A 32 EE 3F FC CC 1D 57 21 20 06 40 EA CD 03 F9 46 46 0A 40 28 F2 01 20 B1 D6 F5 3F 18 2D 44 54 FB 21 E9 3F 07 5C 14 33 26 A6 91 3C }
	condition:
		$1
}

rule file_93_5_0 {
	meta:
		name = "_mbsncat_l"
		size = 324
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 004c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0068 strncat 0090 _ismbslead_l 00ec _mbsbtype_l"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 14 00 00 91 37 00 00 91 56 00 00 91 96 08 00 B4 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 3D 00 00 14 57 FF FF B4 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 08 09 40 B9 E8 00 00 35 C2 02 00 91 E1 02 00 91 80 02 00 91 ?? ?? ?? ?? 15 00 00 91 29 00 00 14 95 02 00 91 93 02 00 91 88 16 40 38 C8 FF FF 35 E2 63 00 91 61 02 00 91 A0 02 00 91 ?? ?? ?? ?? 40 00 00 34 73 06 00 D1 ED 13 40 F9 EA 16 40 38 D6 06 00 D1 48 01 0D 8B 09 65 40 39 89 02 10 36 6A 02 00 39 EA 02 40 39 F7 06 00 91 6A 06 00 39 73 0A 00 91 0A 02 00 35 7F E2 1F 38 7F 02 15 EB E0 01 00 54 69 02 15 4B 2A 05 00 51 41 7D 40 93 E2 63 00 91 A0 02 00 91 ?? ?? ?? ?? 1F 04 00 71 E1 00 00 54 7F F2 1F 38 06 00 00 14 6A 16 00 38 6A FE FF 34 56 FE FF B4 E5 FF FF 17 7F 02 00 39 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 A0 02 00 91 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_94_5_0 {
	meta:
		name = "_mbsnbicmp_l"
		size = 548
		refs = "0024 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0044 _strnicmp 0054 _errno 0060 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BD A9 FD 03 00 91 15 00 00 91 34 00 00 91 61 00 00 91 E0 43 00 91 53 00 00 91 ?? ?? ?? ?? F3 0D 00 B4 EE 13 40 F9 C8 09 40 B9 C8 00 00 35 62 02 00 91 81 02 00 91 A0 02 00 91 ?? ?? ?? ?? 6D 00 00 14 55 00 00 B4 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 65 00 00 14 AC 16 40 38 73 06 00 D1 88 1D 00 53 C8 C1 28 8B 09 65 40 39 A9 04 10 36 33 01 00 B5 8B 02 40 39 0F 00 80 52 69 01 0E 8B 2A 65 40 39 4A 00 10 36 0B 00 80 52 6D 3D 00 53 4C 00 00 14 A8 02 40 39 68 00 00 35 0F 00 80 52 1F 00 00 14 C9 19 40 79 08 21 0C 2A B5 06 00 91 0F 3D 00 53 FF 01 09 6B 03 01 00 54 CA 1D 40 79 FF 01 0A 6B A8 00 00 54 CB 21 40 79 6B 01 0F 0B 6F 3D 00 53 12 00 00 14 CC 25 40 79 FF 01 0C 6B E3 01 00 54 C8 29 40 79 FF 01 08 6B 88 01 00 54 C9 2D 40 79 29 01 0F 0B 2F 3D 00 53 08 00 00 14 8A 05 00 11 CA C1 2A 8B 4B 61 40 39 6B 00 20 36 88 01 0E 8B 0C 65 44 39 8F 3D 00 53 8D 02 40 39 94 06 00 91 A9 1D 00 53 C9 C1 29 8B 2A 65 40 39 AA 03 10 36 73 00 00 B5 0D 00 80 52 21 00 00 14 88 02 40 39 73 06 00 D1 88 FF FF 34 C9 19 40 79 08 21 0D 2A 94 06 00 91 0D 3D 00 53 BF 01 09 6B E3 00 00 54 CA 1D 40 79 BF 01 0A 6B 88 00 00 54 CB 21 40 79 6B 01 0D 0B C5 FF FF 17 CC 25 40 79 BF 01 0C 6B E3 01 00 54 C8 29 40 79 BF 01 08 6B 88 01 00 54 C9 2D 40 79 29 01 0D 0B 2D 3D 00 53 08 00 00 14 AA 05 00 11 CA C1 2A 8B 4B 61 40 39 6B 00 20 36 A8 01 0E 8B 0D 65 44 39 AD 3D 00 53 FF 01 0D 6B A1 00 00 54 4F 00 00 34 73 F4 FF B5 00 00 80 52 05 00 00 14 FF 01 0D 6B 29 00 80 52 08 00 80 12 20 81 88 1A E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_96_7_0 {
	meta:
		name = "_getch"
		size = 56
		refs = "0010 __acrt_lock 0014 _getch_nolock 0020 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 20 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 20 01 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_96_11_0 {
	meta:
		name = "_getche"
		size = 56
		refs = "0010 __acrt_lock 0014 _getche_nolock 0020 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 20 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 20 01 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_275_0_0 {
	meta:
		name = "_getwch"
		size = 56
		refs = "0010 __acrt_lock 0014 _getwch_nolock 0020 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 20 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 20 01 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_275_4_0 {
	meta:
		name = "_getwche"
		size = 56
		refs = "0010 __acrt_lock 0014 _getwche_nolock 0020 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 20 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 20 01 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_96_15_0 {
	meta:
		name = "_kbhit"
		size = 56
		refs = "0010 __acrt_lock 0014 _kbhit_nolock 0020 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 20 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 20 01 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_96_8_0 {
	meta:
		name = "_getch$fin$0"
		size = 32
		refs = "000c __acrt_unlock"
		altNames = "_cgets_s$fin$0 _cgetws_s$fin$0 _cputs$fin$0 _cputws$fin$0 _getche$fin$0 _getwch$fin$0 _getwche$fin$0 _kbhit$fin$0 _ungetch$fin$0 _ungetwch$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 20 01 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_96_9_0 {
	meta:
		name = "_getch_nolock"
		size = 336
		refs = "0014 __security_push_cookie 0020 ?chbuf@@3HA 0040 __dcrt_lowio_console_input_handle 0050 __dcrt_lowio_initialize_console_input 0074 __imp_GetConsoleMode 008c __imp_SetConsoleMode 009c __imp_ReadConsoleInputA 00f0 _getextendedkeycode 0134 __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 00 D1 F7 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 1F 05 00 31 A0 00 00 54 00 1D 00 53 09 00 80 12 ?? ?? ?? ?? 3D 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 7F 0A 00 B1 61 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 7F 06 00 B1 61 00 00 54 00 00 80 12 33 00 00 14 F3 0A 00 F9 E1 12 00 91 60 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 01 00 80 52 60 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E3 22 00 91 22 00 80 52 E1 62 00 91 60 02 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 A0 02 00 34 E8 0A 40 B9 68 02 00 34 E9 32 40 79 3F 05 00 71 E1 01 00 54 EA 1E 40 B9 AA 01 00 34 EB 9A 40 39 6B 00 00 34 EB 02 00 B9 0C 00 00 14 E0 72 00 91 ?? ?? ?? ?? C0 00 00 B4 08 04 40 39 ?? ?? ?? ?? 09 00 40 39 E9 02 00 B9 04 00 00 14 E5 FF FF 17 08 00 80 12 E8 02 00 B9 E1 06 40 B9 60 02 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 02 40 B9 FF C3 00 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_96_10_0 {
	meta:
		name = "_getch_nolock$fin$0"
		size = 44
		refs = "000c __imp_SetConsoleMode"
		altNames = "_getwch_nolock$fin$0"
	strings:
		$1 = { FD 7B BF A9 E1 06 40 B9 E0 0A 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_96_13_0 {
	meta:
		name = "_getche_nolock"
		size = 100
		refs = "000c ?chbuf@@3HA 002c _getch_nolock 0048 _putch_nolock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 1F 05 00 31 A0 00 00 54 09 00 80 12 ?? ?? ?? ?? 00 1D 00 53 0C 00 00 14 ?? ?? ?? ?? 13 00 00 11 7F 06 00 31 61 00 00 54 00 00 80 12 06 00 00 14 60 02 00 11 ?? ?? ?? ?? 08 00 80 12 1F 04 00 31 00 01 93 1A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_96_17_0 {
	meta:
		name = "_kbhit_nolock"
		size = 452
		refs = "0010 __security_push_cookie 0018 ?chbuf@@3HA 0030 __dcrt_lowio_console_input_handle 0040 __dcrt_lowio_initialize_console_input 0058 __imp_GetNumberOfConsoleInputEvents 00c8 __chkstk 00e8 _malloc_base 0110 __imp_PeekConsoleInputA 0168 _getextendedkeycode 019c _free_base 01a8 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? F6 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 1F 05 00 31 60 00 00 54 20 00 80 52 5E 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 9F 0A 00 B1 61 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 9F 06 00 B1 61 00 00 54 00 00 80 52 54 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 C1 02 00 91 80 02 00 91 20 01 3F D6 00 FF FF 34 C2 02 40 B9 C2 FE FF 34 89 02 80 D2 4A 7C 09 9B 49 41 00 91 3F 01 0A EB 28 81 9F 9A C8 03 00 B4 48 41 00 91 1F 01 0A EB 08 81 9F 9A 1F 01 10 F1 48 41 00 91 C8 01 00 54 1F 01 0A EB 09 81 9F 9A 2B 3D 00 91 7F 01 09 EB 4C 00 00 54 EB DF 7C B2 6F FD 44 D3 ?? ?? ?? ?? FF 73 2F CB F3 03 00 91 D3 01 00 B4 88 99 99 52 07 00 00 14 1F 01 0A EB 00 81 9F 9A ?? ?? ?? ?? 13 00 00 91 93 00 00 B4 A8 BB 9B 52 68 02 00 B9 73 42 00 91 C2 02 40 B9 02 00 00 14 13 00 80 D2 B3 03 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 C3 12 00 91 61 02 00 91 80 02 00 91 20 01 3F D6 A0 02 00 34 C8 52 40 29 9F 02 00 71 8A 12 48 7A 28 02 00 54 14 02 00 34 75 12 00 91 A8 C2 5F 78 1F 05 00 71 01 01 00 54 A9 02 40 B9 C9 00 00 34 AA 2A C0 39 EA 02 00 35 A0 02 00 91 ?? ?? ?? ?? 80 02 00 B5 94 06 00 51 D4 06 00 B9 B5 52 00 91 74 FE FF 35 14 00 80 52 F3 00 00 B4 68 02 5F B8 A9 BB 9B 52 1F 01 09 6B 61 00 00 54 60 42 00 D1 ?? ?? ?? ?? 80 02 00 11 DF 02 00 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 34 00 80 52 F1 FF FF 17 }
	condition:
		$1
}

rule file_96_18_0 {
	meta:
		name = "_ungetch"
		size = 64
		refs = "0014 __acrt_lock 001c _ungetch_nolock 0028 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 20 01 80 52 ?? ?? ?? ?? 60 02 00 11 ?? ?? ?? ?? 13 00 00 11 20 01 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_275_7_0 {
	meta:
		name = "_ungetwch"
		size = 64
		refs = "0014 __acrt_lock 001c _ungetwch_nolock 0028 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 20 01 80 52 ?? ?? ?? ?? 60 02 00 11 ?? ?? ?? ?? 13 00 00 11 20 01 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_96_20_0 {
	meta:
		name = "_ungetch_nolock"
		size = 44
		refs = "0008 ?chbuf@@3HA"
	strings:
		$1 = { 1F 04 00 31 00 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 1F 05 00 31 81 00 00 54 00 1C 00 12 ?? ?? ?? ?? 02 00 00 14 00 00 80 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_98_5_0 {
	meta:
		name = "_mbsnset_l"
		size = 396
		refs = "0030 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 003c _errno 0048 _invalid_parameter_noinfo 006c _strnset"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 36 00 00 11 61 00 00 91 E0 43 00 91 77 02 00 91 55 00 00 91 14 00 80 52 ?? ?? ?? ?? 13 01 00 B5 F5 00 00 B4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 17 00 80 D2 43 00 00 14 ED 13 40 F9 A8 09 40 B9 E8 00 00 35 A2 02 00 91 C1 02 00 11 60 02 00 91 ?? ?? ?? ?? 17 00 00 91 3A 00 00 14 C8 7E 08 53 0C 1D 00 53 18 04 80 52 8C 04 00 34 CB 1E 00 53 EB 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 0C 04 80 52 ED 13 40 F9 0B 04 80 52 B5 05 00 B4 69 02 40 39 B5 06 00 D1 C9 04 00 34 D4 00 00 35 28 01 0D 8B 09 65 40 39 69 00 10 36 34 00 80 52 02 00 00 14 14 00 80 52 6C 02 00 39 6A 1E 40 38 6A 01 00 34 D4 00 00 35 48 01 0D 8B 0A 65 40 39 6A 00 10 36 34 00 80 52 02 00 00 14 14 00 80 52 6B 02 00 39 73 06 00 91 02 00 00 14 78 F2 1F 38 15 FD FF B5 0F 00 00 14 55 02 00 B4 68 02 40 39 B5 06 00 D1 68 01 00 34 D4 00 00 35 08 01 0D 8B 09 65 40 39 69 00 10 36 34 00 80 52 02 00 00 14 14 00 80 52 76 02 00 39 73 06 00 91 95 FE FF B5 94 00 00 34 68 02 40 39 48 00 00 34 78 02 00 39 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 E0 02 00 91 FD 7B C3 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_100_0_0 {
	meta:
		name = "llroundf"
		size = 112
		refs = "0010 _fdtest 0028 roundf 0054 _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 13 00 BD ?? ?? ?? ?? 20 02 00 34 08 04 00 51 1F 05 00 71 89 01 00 54 E0 13 40 BD ?? ?? ?? ?? F0 01 00 1C E0 13 00 BD 00 22 20 1E C8 00 00 54 91 01 00 1C 00 20 31 1E 68 00 00 54 00 00 38 9E 04 00 00 14 20 00 80 52 ?? ?? ?? ?? 00 00 80 D2 FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 DF 00 00 00 5F }
	condition:
		$1
}

rule file_101_0_0 {
	meta:
		name = "fesetround"
		size = 76
		refs = "0024 _getfpcontrolword 0030 _setfpcontrolword 0034 fegetround"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 68 06 18 12 1F 01 13 6B 60 00 00 54 20 00 80 52 08 00 00 14 ?? ?? ?? ?? 08 74 16 12 00 01 13 2A ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 13 6B E0 07 9F 1A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_102_0_0 {
	meta:
		name = "??$common_tcsncpy_s@_W@@YAHQEA_W_KQEB_W1@Z"
		size = 248
		refs = "003c _errno 00cc _invalid_parameter_noinfo"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 A3 00 00 B5 A0 00 00 B5 21 06 00 B5 00 00 80 52 34 00 00 14 C0 05 00 B4 A1 05 00 B4 63 00 00 B5 1F 00 00 79 FA FF FF 17 A2 00 00 B5 1F 00 00 79 ?? ?? ?? ?? D3 02 80 52 21 00 00 14 0B 00 00 91 2A 00 00 91 68 00 00 91 7F 04 00 B1 01 01 00 54 49 00 00 CB 28 69 6B 78 68 25 00 78 C8 01 00 34 4A 05 00 D1 8A FF FF B5 0B 00 00 14 4C 00 00 CB 89 69 6B 78 69 25 00 78 A9 00 00 34 4A 05 00 D1 6A 00 00 B4 08 05 00 D1 48 FF FF B5 48 00 00 B5 7F 01 00 79 CA FB FF B5 7F 04 00 B1 A1 00 00 54 08 04 01 8B 00 0A 80 52 1F E1 1F 78 0D 00 00 14 1F 00 00 79 ?? ?? ?? ?? 53 04 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 06 00 00 14 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_102_1_0 {
	meta:
		name = "wcsncpy_s"
		size = 228
		refs = "0038 _errno 0044 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 A3 00 00 B5 A0 00 00 B5 41 01 00 B5 00 00 80 52 0D 00 00 14 E0 00 00 B4 C1 00 00 B4 63 00 00 B5 1F 00 00 79 FA FF FF 17 22 01 00 B5 1F 00 00 79 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C1 A8 C0 03 5F D6 0B 00 00 91 2A 00 00 91 68 00 00 91 7F 04 00 B1 01 01 00 54 49 00 00 CB 28 69 6B 78 68 25 00 78 C8 01 00 34 4A 05 00 D1 8A FF FF B5 0B 00 00 14 4C 00 00 CB 89 69 6B 78 69 25 00 78 A9 00 00 34 4A 05 00 D1 6A 00 00 B4 08 05 00 D1 48 FF FF B5 48 00 00 B5 7F 01 00 79 4A FB FF B5 7F 04 00 B1 A1 00 00 54 08 04 01 8B 00 0A 80 52 1F E1 1F 78 E2 FF FF 17 1F 00 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 DB FF FF 17 }
	condition:
		$1
}

rule file_103_4_0 {
	meta:
		name = "_mbccpy_s_l"
		size = 284
		refs = "0034 _errno 0040 _invalid_parameter_noinfo 0060 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 36 00 00 91 53 00 00 91 75 00 00 91 53 00 00 B4 7F 02 00 B9 9F 02 00 F1 C4 1A 40 FA E8 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 31 00 00 14 75 00 00 B5 9F 02 00 39 F8 FF FF 17 81 00 00 91 E0 43 00 91 ?? ?? ?? ?? AA 02 40 39 E8 13 40 F9 48 01 08 8B 09 65 40 39 69 03 10 36 A8 06 40 39 48 01 00 35 9F 02 00 39 73 00 00 B4 28 00 80 52 68 02 00 B9 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 40 05 80 52 15 00 00 14 DF 0A 00 F1 02 01 00 54 9F 02 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 0C 00 00 14 8A 02 00 39 A8 06 40 39 88 06 00 39 F3 00 00 B4 48 00 80 52 04 00 00 14 8A 02 00 39 73 00 00 B4 28 00 80 52 68 02 00 B9 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_104_2_0 {
	meta:
		name = "??$common_fullpath@D@@YAPEADQEADQEBD_KH1H@Z"
		size = 76
		refs = "0024 ??$common_fullpath_user_buffer@D@@YAPEADQEADQEBD_K@Z 0034 ??$common_fullpath_dynamic_buffer@D@@YAPEADQEBD_KH0H@Z 0048 _getcwd"
	strings:
		$1 = { 4A 00 00 91 62 00 00 11 83 00 00 91 29 00 00 91 49 01 00 B4 28 01 C0 39 08 01 00 34 60 00 00 B4 42 01 00 91 ?? ?? ?? ?? A4 00 00 11 41 01 00 91 20 01 00 91 ?? ?? ?? ?? E9 7B 40 B2 5F 01 09 EB 09 00 B0 12 41 31 89 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_3_0 {
	meta:
		name = "??$common_fullpath@_W@@YAPEA_WQEA_WQEB_W_KHQEBDH@Z"
		size = 76
		refs = "0024 ??$common_fullpath_user_buffer@_W@@YAPEA_WQEA_WQEB_W_K@Z 0034 ??$common_fullpath_dynamic_buffer@_W@@YAPEA_WQEB_W_KHQEBDH@Z 0048 _wgetcwd"
	strings:
		$1 = { 4A 00 00 91 62 00 00 11 83 00 00 91 29 00 00 91 49 01 00 B4 28 01 40 79 08 01 00 34 60 00 00 B4 42 01 00 91 ?? ?? ?? ?? A4 00 00 11 41 01 00 91 20 01 00 91 ?? ?? ?? ?? E9 7B 40 B2 5F 01 09 EB 09 00 B0 12 41 31 89 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_4_0 {
	meta:
		name = "??$common_fullpath_dynamic_buffer@D@@YAPEADQEBD_KH0H@Z"
		size = 196
		refs = "0010 __imp_GetFullPathNameA 0038 __imp_GetLastError 0048 __acrt_errno_map_os_error 0068 calloc 0078 _errno 0094 ??$common_fullpath_user_buffer@D@@YAPEADQEADQEBD_K@Z 00ac free"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 33 00 00 91 03 00 80 D2 02 00 80 D2 01 00 80 52 16 00 00 91 20 01 3F D6 00 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? 00 00 80 D2 19 00 00 14 08 7C 40 D3 7F 02 08 EB 75 82 88 9A A0 02 00 91 21 00 80 D2 ?? ?? ?? ?? 14 00 00 91 93 02 00 91 B4 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 06 00 00 14 A2 7E 40 D3 C1 02 00 91 80 02 00 91 ?? ?? ?? ?? 60 00 00 B5 14 00 80 D2 02 00 00 14 13 00 80 D2 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_104_5_0 {
	meta:
		name = "??$common_fullpath_dynamic_buffer@_W@@YAPEA_WQEB_W_KHQEBDH@Z"
		size = 196
		refs = "0010 __imp_GetFullPathNameW 0038 __imp_GetLastError 0048 __acrt_errno_map_os_error 0068 calloc 0078 _errno 0094 ??$common_fullpath_user_buffer@_W@@YAPEA_WQEA_WQEB_W_K@Z 00ac free"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 33 00 00 91 03 00 80 D2 02 00 80 D2 01 00 80 52 16 00 00 91 20 01 3F D6 00 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? 00 00 80 D2 19 00 00 14 08 7C 40 D3 7F 02 08 EB 75 82 88 9A A0 02 00 91 41 00 80 D2 ?? ?? ?? ?? 14 00 00 91 93 02 00 91 B4 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 06 00 00 14 A2 7E 40 D3 C1 02 00 91 80 02 00 91 ?? ?? ?? ?? 60 00 00 B5 14 00 80 D2 02 00 00 14 13 00 80 D2 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_104_6_0 {
	meta:
		name = "??$common_fullpath_user_buffer@D@@YAPEADQEADQEBD_K@Z"
		size = 160
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0050 __imp_GetFullPathNameA 0078 __imp_GetLastError 0088 __acrt_errno_map_os_error"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 20 00 00 91 53 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 19 00 00 14 E8 7F 40 B2 7F 02 08 EB A9 00 00 54 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 F8 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 61 02 00 11 03 00 80 D2 82 02 00 91 20 01 3F D6 7F 42 20 EB 89 FE FF 54 E0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E8 FF FF 17 80 02 00 91 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_104_7_0 {
	meta:
		name = "??$common_fullpath_user_buffer@_W@@YAPEA_WQEA_WQEB_W_K@Z"
		size = 160
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0050 __imp_GetFullPathNameW 0078 __imp_GetLastError 0088 __acrt_errno_map_os_error"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 20 00 00 91 53 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 19 00 00 14 E8 7F 40 B2 7F 02 08 EB A9 00 00 54 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 F8 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 61 02 00 11 03 00 80 D2 82 02 00 91 20 01 3F D6 7F 42 20 EB 89 FE FF 54 E0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E8 FF FF 17 80 02 00 91 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_104_20_0 {
	meta:
		name = "?get_full_path_name@@YAIQEADQEBDI@Z"
		size = 36
		refs = "0008 __imp_GetFullPathNameA"
	strings:
		$1 = { 28 00 00 91 41 00 00 11 ?? ?? ?? ?? 02 00 00 91 00 01 00 91 ?? ?? ?? ?? 09 FD DF C8 03 00 80 D2 20 01 1F D6 }
	condition:
		$1
}

rule file_104_21_0 {
	meta:
		name = "?get_full_path_name@@YAIQEA_WQEB_WI@Z"
		size = 36
		refs = "0008 __imp_GetFullPathNameW"
	strings:
		$1 = { 28 00 00 91 41 00 00 11 ?? ?? ?? ?? 02 00 00 91 00 01 00 91 ?? ?? ?? ?? 09 FD DF C8 03 00 80 D2 20 01 1F D6 }
	condition:
		$1
}

rule file_104_26_0 {
	meta:
		name = "_fullpath"
		size = 80
		refs = "0020 ??$common_fullpath_user_buffer@D@@YAPEADQEADQEBD_K@Z 0034 ??$common_fullpath_dynamic_buffer@D@@YAPEADQEBD_KH0H@Z 004c _getcwd"
	strings:
		$1 = { 09 00 00 91 20 00 00 91 4A 00 00 91 60 01 00 B4 08 00 C0 39 28 01 00 34 69 00 00 B4 20 01 00 91 ?? ?? ?? ?? 04 00 80 52 03 00 80 D2 22 00 80 52 41 01 00 91 ?? ?? ?? ?? EB 7B 40 B2 5F 01 0B EB 0B 00 B0 12 41 31 8B 1A 20 01 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_104_27_0 {
	meta:
		name = "_wfullpath"
		size = 80
		refs = "0020 ??$common_fullpath_user_buffer@_W@@YAPEA_WQEA_WQEB_W_K@Z 0034 ??$common_fullpath_dynamic_buffer@_W@@YAPEA_WQEB_W_KHQEBDH@Z 004c _wgetcwd"
	strings:
		$1 = { 09 00 00 91 20 00 00 91 4A 00 00 91 60 01 00 B4 08 00 40 79 28 01 00 34 69 00 00 B4 20 01 00 91 ?? ?? ?? ?? 04 00 80 52 03 00 80 D2 22 00 80 52 41 01 00 91 ?? ?? ?? ?? EB 7B 40 B2 5F 01 0B EB 0B 00 B0 12 41 31 8B 1A 20 01 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_105_0_0 {
	meta:
		name = "_finite"
		size = 36
	strings:
		$1 = { FF 43 00 D1 08 00 66 9E 09 02 F0 D2 E0 03 00 FD 08 F9 40 92 08 01 09 8B 00 FD 7F D3 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_106_0_0 {
	meta:
		name = "??$common_creat@D@@YAHQEBDH@Z"
		size = 64
		refs = "0024 _sopen_s"
		altNames = "_creat"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 24 00 00 11 01 00 00 91 08 00 80 12 E0 43 00 91 E8 13 00 B9 03 08 80 52 42 60 80 52 ?? ?? ?? ?? E8 13 40 B9 09 00 80 12 1F 00 00 71 00 01 89 1A FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_106_1_0 {
	meta:
		name = "??$common_creat@_W@@YAHQEB_WH@Z"
		size = 64
		refs = "0024 _wsopen_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 24 00 00 11 01 00 00 91 08 00 80 12 E0 43 00 91 E8 13 00 B9 03 08 80 52 42 60 80 52 ?? ?? ?? ?? E8 13 40 B9 09 00 80 12 1F 00 00 71 00 01 89 1A FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_106_5_0 {
	meta:
		name = "_wcreat"
		size = 64
		refs = "0024 _wsopen_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 24 00 00 11 01 00 00 91 08 00 80 12 E0 43 00 91 E8 13 00 B9 03 08 80 52 42 60 80 52 ?? ?? ?? ?? E8 13 40 B9 09 00 80 12 1F 00 00 71 00 01 89 1A FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_106_2_0 {
	meta:
		name = "??$tsopen_s@PEAHAEBQEBDHHAEBH@?$__crt_char_traits@D@@SAH$$QEAPEAHAEBQEBD$$QEAH2AEBH@Z"
		size = 24
		refs = "0014 _sopen_s"
		altNames = "??$tsopen_s@PEAHAEBQEBDAEBHAEBHH@?$__crt_char_traits@D@@SAH$$QEAPEAHAEBQEBDAEBH2$$QEAH@Z ??$tsopen_s@PEAHAEBQEBDHHH@?$__crt_char_traits@D@@SAH$$QEAPEAHAEBQEBD$$QEAH22@Z"
	strings:
		$1 = { 84 00 40 B9 63 00 40 B9 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_499_13_0 {
	meta:
		name = "??$tsopen_s@PEAHAEBQEB_WAEBHAEBHH@?$__crt_char_traits@_W@@SAH$$QEAPEAHAEBQEB_WAEBH2$$QEAH@Z"
		size = 24
		refs = "0014 _wsopen_s"
	strings:
		$1 = { 84 00 40 B9 63 00 40 B9 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_106_3_0 {
	meta:
		name = "??$tsopen_s@PEAHAEBQEB_WHHAEBH@?$__crt_char_traits@_W@@SAH$$QEAPEAHAEBQEB_W$$QEAH2AEBH@Z"
		size = 24
		refs = "0014 _wsopen_s"
	strings:
		$1 = { 84 00 40 B9 63 00 40 B9 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_143_13_0 {
	meta:
		name = "??$tsopen_s@PEAHAEBQEB_WHHH@?$__crt_char_traits@_W@@SAH$$QEAPEAHAEBQEB_W$$QEAH22@Z"
		size = 24
		refs = "0014 _wsopen_s"
	strings:
		$1 = { 84 00 40 B9 63 00 40 B9 42 00 40 B9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_107_0_0 {
	meta:
		name = "??$__crt_time_elapsed_leap_years@H@@YAHH@Z"
		size = 76
		altNames = "??$__crt_time_elapsed_leap_years@J@@YAJJ@Z"
	strings:
		$1 = { 08 AC 04 11 2E 02 00 18 08 7D 2E 9B 0D 04 00 51 09 FD 60 D3 A8 7D 2E 9B 2B 7D 07 13 09 FD 60 D3 6C 7D 4B 0B 2B 7D 05 13 68 7D 4B 0B A9 7D 01 13 AA 79 49 0B 8C 01 08 4B 88 09 8A 0B 00 45 00 51 C0 03 5F D6 1F 20 03 D5 1F 85 EB 51 }
	condition:
		$1
}

rule file_107_1_0 {
	meta:
		name = "??$__crt_time_is_leap_year@H@@YA_NH@Z"
		size = 92
		altNames = "??$__crt_time_is_leap_year@J@@YA_NJ@Z"
	strings:
		$1 = { 08 7C 01 13 09 78 48 0B 2A 7D 02 13 0B 08 0A 4B 6B 01 00 35 28 02 00 18 08 7C 28 9B 09 FD 60 D3 2B 7D 05 13 68 7D 4B 0B 89 0C 80 52 08 81 09 1B 68 00 00 34 20 00 80 52 07 00 00 14 09 B0 1D 11 0A 32 80 52 28 0D CA 1A 09 A5 0A 1B 3F 01 00 71 E0 17 9F 1A C0 03 5F D6 1F 85 EB 51 }
	condition:
		$1
}

rule file_107_2_0 {
	meta:
		name = "??$common_loctotime_t@J@@YAJHHHHHHH@Z"
		size = 568
		refs = "001c __security_push_cookie 0068 ?__crt_time_is_day_valid@@YA_NHHH@Z 0088 _days 009c ??$__crt_time_is_leap_year@H@@YA_NH@Z 00b0 __tzset 00c0 _get_daylight 00cc _get_dstbias 00d8 _get_timezone 01a0 _isindst 01b0 _errno 01c4 __security_pop_cookie 01f8 _invoke_watson"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 2B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 00 D1 13 B0 1D 51 7F 1A 01 71 35 00 00 11 54 00 00 11 77 00 00 11 98 00 00 11 B9 00 00 11 DA 00 00 11 6B 0B 00 54 7F 2A 02 71 28 0B 00 54 A8 06 00 51 1F 2D 00 71 C8 0A 00 54 B6 06 00 51 C1 02 00 11 60 02 00 11 ?? ?? ?? ?? 20 0A 00 34 FF 5E 00 71 E8 09 00 54 1F EF 00 71 A8 09 00 54 3F EF 00 71 68 09 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 D9 76 B8 60 02 00 11 34 01 14 0B ?? ?? ?? ?? 1F 00 00 71 AE 1A 42 7A 4D 00 00 54 94 06 00 11 ?? ?? ?? ?? E0 23 00 91 FF FF 00 29 FF 03 00 B9 ?? ?? ?? ?? 80 0A 00 35 E0 13 00 91 ?? ?? ?? ?? 60 09 00 35 E0 03 00 91 ?? ?? ?? ?? 40 08 00 35 8E 0A 00 18 68 AE 04 11 08 7D 2E 9B 6D 06 00 51 09 FD 60 D3 A8 7D 2E 9B 2B 7D 07 13 09 FD 60 D3 6C 7D 4B 0B 2B 7D 05 13 68 7D 4B 0B A9 7D 01 13 AA 79 49 0B AB 2D 80 52 8C 01 08 4B 88 09 8A 0B 5F 07 00 71 69 22 0B 1B 2A 01 14 0B 28 01 14 0B 0B 05 0A 0B EC 0E 0B 0B E9 0E 0B 0B 88 6D 1C 53 0A 01 09 4B E9 03 40 B9 0B 0B 0A 0B 0C 0B 0A 0B 68 6D 1C 53 0D 01 0C 4B 28 09 0D 0B CB 06 00 18 0A 01 19 0B E8 07 40 B9 5B 01 0B 0B 75 03 08 0B 61 00 00 54 A0 02 00 11 12 00 00 14 E8 0B 40 B9 5F 07 00 31 F4 2F 00 B9 F6 4F 04 29 F8 DF 02 29 F9 13 00 B9 04 09 40 7A 80 00 00 54 E0 43 00 91 ?? ?? ?? ?? 80 FE FF 35 60 03 00 11 05 00 00 14 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 80 12 FF C3 00 91 ?? ?? ?? ?? FB 2B 40 F9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 1F 20 03 D5 1F 85 EB 51 80 81 55 7C }
	condition:
		$1
}

rule file_107_3_0 {
	meta:
		name = "??$common_loctotime_t@_J@@YA_JHHHHHHH@Z"
		size = 564
		refs = "001c __security_push_cookie 006c ?__crt_time_is_day_valid@@YA_NHHH@Z 008c _days 00a0 ??$__crt_time_is_leap_year@H@@YA_NH@Z 00b4 __tzset 00c4 _get_daylight 00d0 _get_dstbias 00dc _get_timezone 01a0 _isindst 01b0 _errno 01c4 __security_pop_cookie 01f8 _invoke_watson"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 2B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 00 D1 13 B0 1D 51 7F 1A 01 71 35 00 00 11 54 00 00 11 77 00 00 11 98 00 00 11 B9 00 00 11 DB 00 00 11 6B 0B 00 54 68 7E 40 93 1F 35 11 F1 08 0B 00 54 A8 06 00 51 1F 2D 00 71 A8 0A 00 54 B6 06 00 51 C1 02 00 11 60 02 00 11 ?? ?? ?? ?? 00 0A 00 34 FF 5E 00 71 C8 09 00 54 1F EF 00 71 88 09 00 54 3F EF 00 71 48 09 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 D9 76 B8 60 02 00 11 34 01 14 0B ?? ?? ?? ?? 1F 00 00 71 AE 1A 42 7A 4D 00 00 54 94 06 00 11 ?? ?? ?? ?? E0 23 00 91 FF FF 00 29 FF 03 00 B9 ?? ?? ?? ?? 60 0A 00 35 E0 13 00 91 ?? ?? ?? ?? 40 09 00 35 E0 03 00 91 ?? ?? ?? ?? 20 08 00 35 6E 0A 00 18 FA 07 80 B9 68 AE 04 11 08 7D 2E 9B 6D 06 00 51 09 FD 60 D3 A8 7D 2E 9B 2B 7D 07 13 09 FD 60 D3 6C 7D 4B 0B 2B 7D 05 13 68 7D 4B 0B A9 7D 01 13 AA 79 49 0B 69 7E 40 93 8C 01 08 4B 88 09 8A 0B 2A 19 01 D1 8C 07 80 D2 0B 45 00 51 A8 2D 80 D2 48 7D 08 9B 0A 03 80 D2 7F 07 00 71 09 C1 2B 8B 2B C1 34 8B 68 7D 0A 9B 8A 07 80 D2 09 C1 37 8B 29 7D 0C 9B 28 C1 38 8B E9 03 40 B9 0A 7D 0A 9B 48 C1 29 8B 15 C1 39 8B 61 00 00 54 40 03 15 8B 12 00 00 14 E8 0B 40 B9 7F 07 00 31 F4 2F 00 B9 F6 4F 04 29 F8 DF 02 29 F9 13 00 B9 04 09 40 7A 80 00 00 54 E0 43 00 91 ?? ?? ?? ?? 80 FE FF 35 A0 02 00 91 05 00 00 14 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 80 92 FF C3 00 91 ?? ?? ?? ?? FB 2B 40 F9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 1F 20 03 D5 1F 85 EB 51 }
	condition:
		$1
}

rule file_107_4_0 {
	meta:
		name = "?__crt_time_is_day_valid@@YA_NHHH@Z"
		size = 112
		refs = "0024 _days 0050 ??$__crt_time_is_leap_year@H@@YA_NH@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 53 00 00 11 7F 02 00 71 34 00 00 11 6C 00 00 54 00 00 80 52 11 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 8A 06 00 11 ?? ?? ?? ?? 0A D9 6A B8 28 D9 74 B8 49 01 08 4B 7F 02 09 6B 6C 00 00 54 20 00 80 52 06 00 00 14 ?? ?? ?? ?? 1F 00 00 71 80 1A 41 7A 60 0A 5D 7A E0 C7 9F 1A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_108_0_0 {
	meta:
		name = "_fpieee_flt"
		size = 128
		refs = "004c __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 68 03 00 18 08 00 08 0B 1F 0D 00 71 54 00 00 91 89 00 00 54 E8 02 00 18 1F 00 08 6B 01 02 00 54 2B 00 40 F9 28 44 3B D5 0A 7D 40 93 EC 13 80 92 48 01 0C 8A 28 44 1B D5 73 11 40 F9 13 01 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 8F 02 00 91 00 01 3F D6 60 02 00 91 80 02 3F D6 02 00 00 14 00 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 72 FF FF 3F 93 00 00 C0 }
	condition:
		$1
}

rule file_109_0_0 {
	meta:
		name = "cbrtl"
		size = 364
		refs = "0018 _ldunscale 0090 _ldscale"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 E1 63 00 91 E0 0F 00 FD E0 43 00 91 ?? ?? ?? ?? 1F 08 00 71 68 00 00 54 E0 0F 40 FD 45 00 00 14 EF 23 C0 79 D3 09 00 18 01 00 80 52 E7 01 00 11 E8 7C 33 9B 09 FD 60 D3 2A 7D 49 0B 28 7D 49 0B 09 05 0A 0B 3F 01 07 6B 20 02 00 54 EA 04 00 11 4F 3D 00 13 E7 01 00 11 EF 23 00 79 EB 7C 33 9B 21 04 00 51 6C FD 60 D3 8E 7D 4C 0B 8D 7D 4C 0B AE 05 0E 0B DF 01 07 6B A1 FE FF 54 81 00 F8 36 E0 63 00 91 ?? ?? ?? ?? EF 23 C0 79 E8 3F 40 79 88 00 78 37 F5 0F 40 FD 09 00 80 52 05 00 00 14 F0 0F 40 FD 29 00 80 52 15 42 61 1E F5 0F 00 FD 71 04 00 5C 90 04 00 5C 1C 10 6C 1E B2 42 51 1F 71 04 00 5C BA 0A 7C 1E 54 46 55 1F 52 04 00 5C B3 2A 72 1E 98 1A 73 1E 14 10 6F 1E BB 0A 74 1E 55 1B 78 1E 16 57 58 1F 77 1B 76 1E F8 2A 78 1E 19 0B 7C 1E 50 1B 79 1E 31 43 59 1F 78 1B 71 1E 19 2B 79 1E 32 0B 7C 1E F2 13 00 FD 69 00 00 34 52 42 61 1E F2 13 00 FD E8 7D 33 9B E0 83 00 91 09 FD 60 D3 21 7D 49 0B ?? ?? ?? ?? E0 13 40 FD FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 6A C1 8B BE 82 34 CF 3F 46 EB A8 6A 82 A8 EE 3F F9 14 00 E3 19 34 B4 3F 68 AE D3 48 4B E5 D1 3F 56 55 55 55 }
	condition:
		$1
}

rule file_344_0_0 {
	meta:
		name = "cbrt"
		size = 364
		refs = "0018 _dunscale 0090 _dscale"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 E1 63 00 91 E0 0F 00 FD E0 43 00 91 ?? ?? ?? ?? 1F 08 00 71 68 00 00 54 E0 0F 40 FD 45 00 00 14 EF 23 C0 79 D3 09 00 18 01 00 80 52 E7 01 00 11 E8 7C 33 9B 09 FD 60 D3 2A 7D 49 0B 28 7D 49 0B 09 05 0A 0B 3F 01 07 6B 20 02 00 54 EA 04 00 11 4F 3D 00 13 E7 01 00 11 EF 23 00 79 EB 7C 33 9B 21 04 00 51 6C FD 60 D3 8E 7D 4C 0B 8D 7D 4C 0B AE 05 0E 0B DF 01 07 6B A1 FE FF 54 81 00 F8 36 E0 63 00 91 ?? ?? ?? ?? EF 23 C0 79 E8 3F 40 79 88 00 78 37 F5 0F 40 FD 09 00 80 52 05 00 00 14 F0 0F 40 FD 29 00 80 52 15 42 61 1E F5 0F 00 FD 71 04 00 5C 90 04 00 5C 1C 10 6C 1E B2 42 51 1F 71 04 00 5C BA 0A 7C 1E 54 46 55 1F 52 04 00 5C B3 2A 72 1E 98 1A 73 1E 14 10 6F 1E BB 0A 74 1E 55 1B 78 1E 16 57 58 1F 77 1B 76 1E F8 2A 78 1E 19 0B 7C 1E 50 1B 79 1E 31 43 59 1F 78 1B 71 1E 19 2B 79 1E 32 0B 7C 1E F2 13 00 FD 69 00 00 34 52 42 61 1E F2 13 00 FD E8 7D 33 9B E0 83 00 91 09 FD 60 D3 21 7D 49 0B ?? ?? ?? ?? E0 13 40 FD FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 6A C1 8B BE 82 34 CF 3F 46 EB A8 6A 82 A8 EE 3F F9 14 00 E3 19 34 B4 3F 68 AE D3 48 4B E5 D1 3F 56 55 55 55 }
	condition:
		$1
}

rule file_110_4_0 {
	meta:
		name = "_strcoll_l"
		size = 184
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0028 _errno 0034 _invalid_parameter_noinfo 0050 strcmp 0074 __acrt_CompareStringA"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 54 00 00 B4 D3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 14 00 00 14 E8 0F 40 F9 01 99 40 F9 A1 00 00 B5 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 10 00 00 14 07 15 40 B9 06 00 80 12 65 02 00 91 04 00 80 12 83 02 00 91 02 00 82 52 E0 63 00 91 ?? ?? ?? ?? C0 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 B0 12 02 00 00 14 00 08 00 51 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_111_0_0 {
	meta:
		name = "casinhf"
		size = 644
		refs = "0010 crealf 0020 cimagf 002c _fdtest 00c0 _FZero_C 0114 _FCbuild 0118 csqrtf 01f4 asinhf 0214 logf 023c _FCmulcc 024c atan2f"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 E0 07 07 2D ?? ?? ?? ?? E1 3F 40 BD E0 1B 00 BD E0 3B 40 BD ?? ?? ?? ?? E0 63 00 91 E0 13 00 BD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 0A 00 71 C1 01 00 54 AA FF 9F 52 08 00 0A 0A 08 01 00 34 1F 04 00 71 81 00 00 54 F3 13 40 BD E0 1B 40 BD 7D 00 00 14 F3 1B 40 BD 09 00 00 14 F3 1B 40 BD E0 13 40 BD 78 00 00 14 1F 08 00 71 C1 00 00 54 7F 06 00 71 40 FF FF 54 F3 13 40 BD 60 42 20 1E 71 00 00 14 7F 06 00 71 41 02 00 54 F3 1B 40 BD 1F 04 00 71 E1 00 00 54 F0 13 40 BD 31 0E 00 1C 08 22 20 1E 10 0E 00 1C 20 3E 30 1E 66 00 00 14 ?? ?? ?? ?? E8 27 40 79 F0 03 27 1E ?? ?? ?? ?? 1F 01 11 72 32 42 21 1E 40 1E 30 1E 5E 00 00 14 1F 04 00 71 E1 00 00 54 F3 13 40 BD 72 0C 00 1C 70 0C 00 1C 68 22 20 1E 40 3E 30 1E 56 00 00 14 F1 13 40 BD 10 10 2E 1E E1 1B 40 BD F0 23 00 BD 00 3A 31 1E ?? ?? ?? ?? ?? ?? ?? ?? F0 1B 40 BD F1 13 40 BD E1 83 05 2D F2 23 40 BD 01 42 21 1E 20 2A 32 1E ?? ?? ?? ?? ?? ?? ?? ?? F0 1B 40 BD E1 83 04 2D F0 17 00 BD 08 22 20 1E 40 07 00 54 E1 83 45 2D ?? ?? ?? ?? E1 2F 40 BD E0 1F 00 BD E0 33 40 BD ?? ?? ?? ?? E1 27 40 BD E0 23 00 BD E0 2B 40 BD ?? ?? ?? ?? E1 27 40 BD E0 17 00 BD E0 2B 40 BD ?? ?? ?? ?? F3 C7 43 2D B2 07 00 1C 40 22 33 1E C2 00 00 54 F2 17 40 BD F3 1F 00 BD 50 1A 33 1E 00 82 31 1F 13 00 00 14 40 22 31 1E C2 00 00 54 F1 1F 00 BD 11 18 31 1E F2 17 40 BD 20 CA 13 1F 0C 00 00 14 30 42 21 1E 40 22 30 1E F0 1F 00 BD F2 17 40 BD 82 00 00 54 10 18 30 1E 00 CA 13 1F 04 00 00 14 52 0A 31 1E FF 1F 00 B9 00 C8 13 1F ?? ?? ?? ?? F1 1F 40 BD E0 17 00 BD 28 22 20 1E 80 01 00 54 08 20 20 1E 20 42 20 1E AB 00 00 54 ?? ?? ?? ?? F0 17 40 BD 10 28 30 1E 04 00 00 14 ?? ?? ?? ?? F0 17 40 BD 10 3A 20 1E F0 17 00 BD E3 8B 44 2D E1 83 45 2D ?? ?? ?? ?? ?? ?? ?? ?? 01 40 20 1E E0 13 40 BD ?? ?? ?? ?? F3 17 40 BD 01 40 20 1E 60 42 20 1E ?? ?? ?? ?? FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 DB 0F 49 BF DB 0F 49 3F DB 0F C9 BF DB 0F C9 3F 0A E8 7F 5E }
	condition:
		$1
}

rule file_112_4_0 {
	meta:
		name = "_mbsset_s_l"
		size = 364
		refs = "002c _errno 0038 _invalid_parameter_noinfo 004c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0068 _strset_s"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 9F 02 00 F1 33 00 00 91 64 1A 40 FA 55 00 00 11 16 00 80 52 E8 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 47 00 00 14 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? E9 13 40 F9 28 09 40 B9 C8 00 00 35 A2 02 00 11 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 36 00 00 14 A8 7E 08 53 0D 1D 00 53 8A 02 00 91 AC 1E 00 53 CD 02 00 34 0C 03 00 34 A8 01 09 8B 09 65 40 39 A9 02 10 36 88 02 40 39 88 03 00 34 73 06 00 D1 53 03 00 B4 49 05 40 39 09 01 00 34 4D 01 00 39 73 06 00 D1 D3 02 00 B4 4C 05 00 39 48 2D 40 38 E8 FE FF 35 11 00 00 14 5F 01 00 39 73 06 00 91 36 00 80 52 0D 00 00 14 88 01 09 8B 09 65 40 39 69 00 10 36 9F 02 00 39 11 00 00 14 88 02 40 39 C8 00 00 34 73 06 00 D1 93 00 00 B4 4C 01 00 39 49 1D 40 38 89 FF FF 35 13 01 00 B5 9F 02 00 39 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 08 00 00 14 D6 00 00 34 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 40 05 80 52 02 00 00 14 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_113_6_0 {
	meta:
		name = "_wperror"
		size = 232
		refs = "0034 wcstombs_s 0054 _calloc_base 0094 perror 009c _free_base 00cc _invoke_watson"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 B3 04 00 B4 68 02 40 79 68 04 00 34 E4 7B 40 B2 FF 0B 00 F9 63 02 00 91 02 00 80 D2 01 00 80 D2 E0 43 00 91 ?? ?? ?? ?? 1F 58 00 71 A0 04 00 54 1F 88 00 71 60 04 00 54 E0 0B 40 F9 00 03 00 B4 21 00 80 D2 ?? ?? ?? ?? 14 00 00 91 F4 01 00 B4 E2 0B 40 F9 04 00 80 92 63 02 00 91 81 02 00 91 00 00 80 D2 ?? ?? ?? ?? C0 00 00 34 1F 58 00 71 C0 01 00 54 1F 88 00 71 81 00 00 54 0B 00 00 14 80 02 00 91 ?? ?? ?? ?? 80 02 00 91 ?? ?? ?? ?? 03 00 00 14 00 00 80 D2 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_114_7_0 {
	meta:
		name = "?__acrt_LCMapStringA_stat@@YAHPEAU__crt_locale_pointers@@PEB_WKPEBDHPEADHHH@Z"
		size = 896
		refs = "001c __security_push_cookie 0058 __strncnt 0090 __imp_MultiByteToWideChar 0114 __chkstk 0134 _malloc_base 01a8 __acrt_LCMapStringEx 02b8 __imp_WideCharToMultiByte 0308 _free_base 0338 __security_pop_cookie"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 73 05 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 FC 43 00 91 93 00 00 11 7F 02 00 71 14 00 00 91 3A 00 00 91 59 00 00 11 75 00 00 91 BB 00 00 91 D6 00 00 11 F7 00 00 11 0D 01 00 54 61 7E 40 93 A0 02 00 91 ?? ?? ?? ?? 1F 00 13 6B 13 04 00 11 4B 00 00 54 13 00 00 11 77 00 00 35 88 02 40 F9 17 0D 40 B9 88 73 40 B9 2A 01 80 52 29 00 80 52 05 00 80 52 04 00 80 D2 1F 01 00 71 ?? ?? ?? ?? ?? ?? ?? ?? 41 11 89 1A 09 FD DF C8 63 02 00 11 A2 02 00 91 E0 02 00 11 20 01 3F D6 18 00 00 11 78 00 00 35 00 00 80 52 9D 00 00 14 0A 7F 40 93 4B F9 7F D3 68 41 00 91 1F 01 0B EB 09 81 9F 9A 8C 99 99 52 C9 03 00 B4 68 41 00 91 1F 05 0A EB 08 81 9F 9A 1F 01 10 F1 48 F9 7F D3 09 41 00 91 C8 01 00 54 3F 01 08 EB 2A 81 9F 9A 4B 3D 00 91 7F 01 0A EB 4C 00 00 54 EB DF 7C B2 6F FD 44 D3 ?? ?? ?? ?? FF 73 2F CB F4 43 00 91 B4 01 00 B4 8C 02 00 B9 08 00 00 14 3F 01 08 EB 20 81 9F 9A ?? ?? ?? ?? 14 00 00 91 D4 00 00 B4 A8 BB 9B 52 88 02 00 B9 94 42 00 91 02 00 00 14 14 00 80 D2 D4 0D 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 05 03 00 11 84 02 00 91 63 02 00 11 A2 02 00 91 21 00 80 52 E0 02 00 11 20 01 3F D6 60 0C 00 34 07 00 80 D2 FF 03 00 F9 06 00 80 D2 05 00 80 52 04 00 80 D2 03 03 00 11 82 02 00 91 21 03 00 11 40 03 00 91 ?? ?? ?? ?? 15 00 00 11 F5 0A 00 34 39 02 50 36 D6 0A 00 34 BF 02 16 6B 6C 0A 00 54 07 00 80 D2 FF 03 00 F9 06 00 80 D2 C5 02 00 11 64 03 00 91 03 03 00 11 82 02 00 91 21 03 00 11 40 03 00 91 ?? ?? ?? ?? 15 00 00 11 15 09 00 35 46 00 00 14 A9 7E 40 93 2A F9 7F D3 48 41 00 91 1F 01 0A EB 08 81 9F 9A C8 03 00 B4 48 41 00 91 1F 05 09 EB 08 81 9F 9A 1F 01 10 F1 28 F9 7F D3 09 41 00 91 C8 01 00 54 3F 01 08 EB 2A 81 9F 9A 4B 3D 00 91 7F 01 0A EB 4C 00 00 54 EB DF 7C B2 6F FD 44 D3 ?? ?? ?? ?? FF 73 2F CB F3 43 00 91 B3 01 00 B4 88 99 99 52 07 00 00 14 3F 01 08 EB 20 81 9F 9A ?? ?? ?? ?? 13 00 00 91 D3 00 00 B4 A8 BB 9B 52 68 02 00 B9 73 42 00 91 02 00 00 14 13 00 80 D2 33 04 00 B4 07 00 80 D2 FF 03 00 F9 06 00 80 D2 A5 02 00 11 64 02 00 91 03 03 00 11 82 02 00 91 21 03 00 11 40 03 00 91 ?? ?? ?? ?? 00 02 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 07 00 80 D2 06 00 80 D2 A3 02 00 11 62 02 00 91 01 00 80 52 E0 02 00 11 F6 03 00 35 05 00 80 52 04 00 80 D2 20 01 3F D6 15 00 00 11 B5 03 00 35 68 02 5F B8 A9 BB 9B 52 1F 01 09 6B 61 00 00 54 60 42 00 D1 ?? ?? ?? ?? 15 00 80 52 F4 00 00 B4 88 02 5F B8 A9 BB 9B 52 1F 01 09 6B 61 00 00 54 80 42 00 D1 ?? ?? ?? ?? A0 02 00 11 9F 43 00 D1 FF 43 00 91 ?? ?? ?? ?? FB 73 45 A9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 C5 02 00 11 64 03 00 91 E2 FF FF 17 68 02 5F B8 A9 BB 9B 52 1F 01 09 6B 01 FD FF 54 60 42 00 D1 ?? ?? ?? ?? E5 FF FF 17 }
	condition:
		$1
}

rule file_114_11_0 {
	meta:
		name = "__acrt_LCMapStringA"
		size = 164
		refs = "0040 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c ?__acrt_LCMapStringA_stat@@YAHPEAU__crt_locale_pointers@@PEB_WKPEBDHPEADHHH@Z"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BD A9 FD 03 00 91 FF 43 00 D1 39 00 00 91 01 00 00 91 E0 83 00 91 58 00 00 11 77 00 00 91 96 00 00 11 B5 00 00 91 D4 00 00 11 F3 00 00 11 ?? ?? ?? ?? E8 83 40 B9 67 02 00 11 86 02 00 11 A5 02 00 91 C4 02 00 11 E8 03 00 B9 E3 02 00 91 02 03 00 11 21 03 00 91 E0 A3 00 91 ?? ?? ?? ?? E8 E3 40 39 A8 00 00 34 EA 13 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FF 43 00 91 FD 7B C3 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_115_0_0 {
	meta:
		name = "_dnorm"
		size = 416
	strings:
		$1 = { F3 0F 1F F8 08 0C 40 79 22 00 80 52 09 0D 00 12 09 0C 00 79 13 01 11 12 E9 00 00 35 08 08 40 79 A8 00 00 35 08 04 40 79 68 00 00 35 08 00 40 79 E8 0A 00 34 E9 01 00 35 0A 08 40 79 0B 04 40 79 0D 00 40 79 4C 01 00 11 6A 01 00 11 48 40 00 51 AB 01 00 11 0D 00 80 52 02 3D 00 13 4C FF FF 34 0C 0C 00 79 0A 08 00 79 0B 04 00 79 1F 00 00 79 03 0C 40 79 7F 40 00 71 02 04 00 54 0E 08 40 79 07 04 40 79 01 00 40 79 C9 7D 0F 53 68 78 1F 53 ED 7C 0F 53 CC 79 1F 53 0B 3D 00 53 2A 3D 00 53 E7 78 1F 53 26 7C 0F 53 AE 3D 00 53 E4 3C 00 53 6B 01 0A 2A 8F 3D 00 53 C5 3C 00 53 63 3D 00 53 EF 01 0E 2A 84 00 05 2A 28 78 1F 53 49 04 00 51 7F 40 00 71 EE 3D 00 53 87 3C 00 53 01 3D 00 53 22 3D 00 13 23 FD FF 54 03 0C 00 79 0E 08 00 79 07 04 00 79 01 00 00 79 03 0C 40 79 7F 80 00 71 03 04 00 54 06 08 40 79 0D 04 40 79 0A 00 40 79 A8 41 11 53 CC 40 11 53 49 7D 01 53 AD 7D 01 53 C6 7C 01 53 67 40 11 53 0B 3D 00 53 2A 3D 00 53 AE 3D 00 53 C5 3C 00 53 68 7C 01 53 8F 3D 00 53 E4 3C 00 53 EF 01 0E 2A 84 00 05 2A 03 3D 00 53 6B 01 0A 2A 49 04 00 11 ED 3D 00 53 86 3C 00 53 7F 80 00 71 6A 3D 00 53 22 3D 00 13 22 FD FF 54 03 0C 00 79 06 08 00 79 0D 04 00 79 0A 00 00 79 08 0C 40 79 09 0D 00 12 09 0C 00 79 28 01 13 2A 08 0C 00 79 40 00 00 11 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_115_1_0 {
	meta:
		name = "_fdnorm"
		size = 224
	strings:
		$1 = { 08 04 40 79 2F 00 80 52 09 19 00 12 09 04 00 79 07 01 11 12 69 00 00 35 08 00 40 79 A8 05 00 34 A9 00 00 35 08 00 40 79 CF 01 80 12 1F 00 00 79 08 04 00 79 0A 04 40 79 5F 01 02 71 02 02 00 54 0E 00 40 79 49 79 1F 53 CA 7D 0F 53 4B 3D 00 53 2C 3D 00 53 88 01 0B 2A 0A 3D 00 53 CC 79 1F 53 ED 05 00 51 5F 01 02 71 8E 3D 00 53 AF 3D 00 13 A3 FE FF 54 0A 04 00 79 0E 00 00 79 0E 04 40 79 DF 01 04 71 03 02 00 54 09 00 40 79 C8 41 11 53 29 7D 01 53 2A 3D 00 53 0B 3D 00 53 CC 7D 01 53 6B 01 0A 2A 8E 3D 00 53 ED 05 00 11 69 3D 00 53 AF 3D 00 13 DF 01 04 71 A2 FE FF 54 0E 04 00 79 09 00 00 79 08 04 40 79 09 19 00 12 09 04 00 79 28 01 07 2A 08 04 00 79 E0 01 00 11 C0 03 5F D6 }
	condition:
		$1
}

rule file_116_0_0 {
	meta:
		name = "wcscmp"
		size = 64
	strings:
		$1 = { 2A 00 40 79 08 00 40 79 09 01 0A 4B E9 00 00 35 0B 00 01 CB AA 00 00 34 2A 2C 40 78 69 69 61 78 29 01 0A 4B 89 FF FF 34 69 00 F8 36 00 00 80 12 03 00 00 14 3F 01 00 71 E0 D7 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_117_0_0 {
	meta:
		name = "dekker_mul12"
		size = 88
	strings:
		$1 = { FF 43 00 D1 08 00 66 9E E0 03 00 FD 10 08 61 1E 08 91 65 92 11 01 67 9E E8 03 00 F9 28 00 66 9E E1 03 00 FD 10 00 00 FD 14 38 71 1E 08 91 65 92 13 01 67 9E E8 03 00 F9 70 C2 71 1F 32 38 73 1E 51 42 51 1F 70 46 54 1F 51 42 54 1F 31 00 00 FD FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_117_1_0 {
	meta:
		name = "fmod"
		size = 800
		refs = "0070 _handle_nan 0098 ??_C@_04KEPJIHGP@fmod?$AA@ 00b8 _handle_error"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 00 00 66 9E E1 03 01 6D 2E 00 66 9E 08 FC 74 D3 0A 29 00 12 C8 FD 74 D3 0B 29 00 12 0D F8 40 92 CC F9 40 92 5F 05 00 71 8B 01 00 54 5F F9 1F 71 8C 01 00 54 68 05 00 51 1F F5 1F 71 E8 00 00 54 BF 01 0C EB C1 06 00 54 08 00 41 92 E8 0B 00 F9 00 01 67 9E AD 00 00 14 5F F9 1F 71 AD 00 00 54 08 CC 40 92 68 01 00 B4 ?? ?? ?? ?? A7 00 00 14 7F F9 1F 71 AD 00 00 54 C8 CD 40 92 68 14 00 B4 C0 01 00 91 F9 FF FF 17 8D 01 00 B5 EC 13 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 46 00 80 52 25 04 80 52 04 01 80 52 23 00 80 52 02 FF FF D2 C1 02 80 52 ?? ?? ?? ?? 95 00 00 14 CC FE FF B4 5F 05 00 71 6A 01 00 54 09 02 E0 D2 BF 01 09 EB A8 01 00 91 C2 00 00 54 08 F9 7F D3 0E 02 E0 D2 1F 01 0E EB 4A 05 00 51 83 FF FF 54 4A 05 00 11 7F 05 00 71 6A 01 00 54 08 02 E0 D2 9F 01 08 EB 89 01 00 91 C2 00 00 54 29 F9 7F D3 0F 02 E0 D2 3F 01 0F EB 6B 05 00 51 83 FF FF 54 6B 05 00 11 ED 33 01 A9 BF 01 0C EB C2 00 00 54 B1 01 67 9E 08 20 60 1E 30 42 61 1E 00 3E 71 1E 74 00 00 14 28 44 3B D5 0F 7D 40 D3 5F 01 0B 6B 6C 00 00 54 0E 00 80 52 08 00 00 14 48 01 0B 4B C9 0D 00 18 08 7D 29 9B 09 FD 60 D3 2B 7D 04 13 6E 7D 4B 0B 8E 00 00 35 F8 0F 40 FD 1A 10 6E 1E 22 00 00 14 88 06 80 52 F0 0F 40 FD CD 7D 08 1B 68 0C 00 18 A8 7D 28 9B 09 FD 60 D3 2C 7D 49 0B A8 01 0C 4B 09 7D 48 0B 8A 7D 40 93 08 FE E7 D2 08 D1 0A 8B 2B 7D 01 13 69 7D 40 93 E8 13 00 F9 0A FE E7 D2 F1 13 40 FD 48 D1 09 8B A9 01 0B 4B 2A 01 0C 4B E8 17 00 F9 0B FE E7 D2 48 7D 40 93 32 0A 70 1E F1 17 40 FD 68 D1 08 8B E8 1B 00 F9 53 0A 71 1E 12 01 67 9E 08 96 E7 D2 E8 1B 00 F9 1A 01 67 9E 78 0A 72 1E F9 0B 40 FD DF 01 00 71 0D 04 00 54 30 1B 78 1E F8 0B 00 FD 09 03 66 9E 29 91 65 92 32 01 67 9E E9 1B 00 F9 17 3B 72 1E 08 02 78 9E 11 01 62 9E 2A 02 66 9E F1 0B 00 FD 4A 91 65 92 56 01 67 9E EA 1B 00 F9 35 3A 76 1E 31 0A 78 1E 34 3B 71 1E 30 3B 74 1E 13 3A 71 1E D1 C6 72 1F B2 46 52 1F D1 4A 57 1F B2 46 57 1F 73 3A 72 1E 79 2A 74 1E 28 23 60 1E 42 00 00 54 19 2B 79 1E 58 0B 78 1E CE 05 00 51 4E FC FF 35 30 1B 78 1E F8 0B 00 FD 08 02 78 9E 11 01 62 9E 08 03 66 9E 08 91 65 92 12 01 67 9E E8 1B 00 F9 17 3B 72 1E 28 02 66 9E F1 0B 00 FD 08 91 65 92 16 01 67 9E E8 1B 00 F9 35 3A 76 1E 31 0A 78 1E 34 3B 71 1E 30 3B 74 1E 13 3A 71 1E D1 C6 72 1F B2 46 52 1F D1 4A 57 1F B2 46 57 1F 73 3A 72 1E 7A 2A 74 1E 48 23 60 1E 42 00 00 54 1A 2B 7A 1E 2F 44 1B D5 50 43 61 1E 08 20 60 1E 00 3E 7A 1E FD 7B C4 A8 C0 03 5F D6 4F EC C4 4E 56 55 55 55 }
	condition:
		$1
}

rule file_117_2_0 {
	meta:
		name = "scaleDouble_3"
		size = 124
	strings:
		$1 = { FF 83 00 D1 A8 03 00 18 08 7C 28 9B 09 FD 60 D3 2C 7D 49 0B 08 00 0C 4B 09 7D 48 0B 8A 7D 40 93 08 FE E7 D2 08 D1 0A 8B 2B 7D 01 13 69 7D 40 93 E8 03 00 F9 0A FE E7 D2 F0 03 40 FD 48 D1 09 8B 09 00 0B 4B 2A 01 0C 4B E8 07 00 F9 0B FE E7 D2 F1 07 40 FD 48 7D 40 93 12 0A 60 1E 68 D1 08 8B E8 0B 00 F9 53 0A 71 1E 12 01 67 9E 60 0A 72 1E FF 83 00 91 C0 03 5F D6 56 55 55 55 }
	condition:
		$1
}

rule file_118_0_0 {
	meta:
		name = "??$common_tcscpy_s@_W@@YAHQEA_W_KQEB_W@Z"
		size = 144
		refs = "0018 _errno 0024 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 1F 00 00 F1 24 18 40 FA E8 00 00 54 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 16 00 00 14 A2 00 00 B5 1F 00 00 79 ?? ?? ?? ?? D3 02 80 52 0C 00 00 14 09 00 00 91 4A 00 00 CB 48 69 69 78 28 25 00 78 68 00 00 34 21 04 00 D1 81 FF FF B5 01 01 00 B5 1F 00 00 79 ?? ?? ?? ?? 53 04 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 02 00 00 14 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_118_1_0 {
	meta:
		name = "wcscpy_s"
		size = 128
		refs = "0014 _errno 0020 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 1F 00 00 F1 24 18 40 FA E8 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 14 00 00 14 62 00 00 B5 1F 00 00 79 F8 FF FF 17 09 00 00 91 4A 00 00 CB 48 69 69 78 28 25 00 78 68 00 00 34 21 04 00 D1 81 FF FF B5 01 01 00 B5 1F 00 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 02 00 00 14 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_120_2_0 {
	meta:
		name = "sinhf"
		size = 792
		refs = "0040 _controlfp_s 0068 _handle_nanf 0094 ??_C@_05PJDDOCIG@sinhf?$AA@ 00c0 _handle_errorf 0118 ?two_to_jby32_trail_table@?1??splitexp@@9@9 0124 ?two_to_jby32_lead_table@?1??splitexp@@9@9 01ac ?cosh_lead@?1??sinhf@@9@9 01c8 ?sinh_lead@?1??sinhf@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 15 C0 22 1E 0A E2 E7 D2 E0 1B 00 BD A9 02 66 9E F5 0B 00 FD 28 F9 40 92 1F 01 0A EB 42 01 00 54 48 00 00 B5 8C 00 00 14 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? E0 1B 40 BD 85 00 00 14 0A FE EF D2 1F 01 0A EB 23 01 00 54 1F 01 0A EB A9 00 00 54 00 00 26 1E E0 1B 00 BD ?? ?? ?? ?? 7C 00 00 14 00 28 20 1E 7A 00 00 14 1F 01 09 EB EC 07 9F 9A 4C 00 00 B4 B5 42 61 1E 10 0F 00 5C A0 22 70 1E 0B 02 00 54 ?? ?? ?? ?? E1 03 27 1E ?? ?? ?? ?? 00 40 20 1E 26 00 80 52 45 04 80 52 24 00 80 52 63 00 80 52 E1 03 80 52 8C 00 00 B4 02 F0 BF D2 ?? ?? ?? ?? 66 00 00 14 02 F0 AF D2 FD FF FF 17 10 0D 00 5C A0 22 70 1E 8B 06 00 54 F1 0C 00 5C 1B 10 6C 1E B2 0A 71 1E 48 22 60 1E 8D 00 00 54 52 2A 7B 1E 4A 02 78 1E 03 00 00 14 53 3A 7B 1E 6A 02 78 1E 54 01 62 1E E8 03 0A 4B B0 0B 00 5C 49 11 00 12 B1 0B 00 5C ?? ?? ?? ?? 9A D6 50 1F 15 01 62 1E ?? ?? ?? ?? 50 0B 00 5C ?? ?? ?? ?? 18 D9 69 FC ?? ?? ?? ?? 17 D9 69 FC 49 01 09 4B 28 7D 04 13 29 6D 48 0B 2A 7D 05 13 4B 05 00 51 68 7D 40 93 B9 0A 71 1E 09 FE E7 D2 F1 09 00 5C 28 D1 08 8B E8 0F 00 F9 36 2B 7A 1E D2 42 51 1F 91 09 00 5C 53 46 56 1F 92 09 00 5C 74 4A 56 1F D3 0A 76 1E 95 6E 56 1F B4 66 53 1F F5 2A 78 1E 96 2A 7A 1E D6 5E 55 1F 17 01 67 9E D8 2A 78 1E 1C 0B 77 1E 2B 00 00 14 A9 02 78 1E ?? ?? ?? ?? 12 08 00 5C ?? ?? ?? ?? 11 08 00 5C 30 01 62 1E B9 3A 70 1E 10 D9 69 FC ?? ?? ?? ?? ?? ?? ?? ?? 3F 0B 79 1E F3 47 52 1F 52 07 00 5C 71 07 00 5C 74 4A 5F 1F 73 07 00 5C 92 07 00 5C 95 4E 5F 1F 94 07 00 5C B3 07 00 5C B6 52 5F 1F B5 07 00 5C D7 56 5F 1F B6 07 00 5C F8 5A 5F 1F F7 0B 79 1E 19 67 57 1F 78 07 00 5C 3E 0B 70 1E 79 07 00 5C FA 63 59 1F 79 07 00 5C 5B 67 5F 1F 7C 47 5F 1F 1B 10 6C 1E 9D 4B 5F 1F B4 4F 5F 1F 95 6E 5F 1F 14 10 6E 1E B6 52 5F 1F 15 D9 69 FC DC 7A 55 1F 4C 00 00 B4 9C 43 61 1E 80 43 62 1E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 63 2E F8 84 9F 5A 56 40 5F 82 95 1B D2 0F 42 40 FE 82 2B 65 47 15 47 40 00 00 00 FE 42 2E 96 3F 8E 27 AF E6 3D 47 CF 3D 5E 90 AA B7 15 11 81 3F 65 97 73 8D 72 C1 56 3F 4E 5D 54 55 55 55 A5 3F 7C 8F 54 55 55 55 C5 3F 8B A0 1E 92 25 41 6B 3D BE B7 DC 2B CB 11 E6 3D C0 61 BE 0F 46 E6 5A 3E 11 90 07 19 A0 01 FA 3E 7D 3E E1 A4 E3 1D C7 3E E5 12 C2 16 6C C1 56 3F 80 EE 01 1A A0 01 2A 3F 02 55 55 55 55 55 A5 3F FD 10 11 11 11 11 81 3F 55 55 55 55 55 55 C5 3F 20 7B 5B 38 56 EE 21 3E D7 FC 63 7F 4B 98 A9 3D 55 CB F1 69 50 7E 92 3E }
	condition:
		$1
}

rule file_121_4_0 {
	meta:
		name = "?fputwc_binary_nolock@@YAG_WV__crt_stdio_stream@@@Z"
		size = 80
		refs = "0028 __acrt_stdio_flush_and_write_wide_nolock"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E1 0B 00 F9 28 10 40 B9 09 09 00 51 29 10 00 B9 EB 0B 40 F9 68 11 40 B9 A8 00 F8 36 61 01 00 91 ?? ?? ?? ?? 00 3C 00 53 06 00 00 14 68 01 40 F9 00 01 00 79 69 01 40 F9 2A 09 00 91 6A 01 00 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_121_8_0 {
	meta:
		name = "_fputwc_nolock"
		size = 388
		refs = "0014 __security_push_cookie 0034 _fileno 0038 __pioinfo 0040 __badioinfo 010c wctomb_s 0138 _fputc_nolock 0164 ?fputwc_binary_nolock@@YAG_WV__crt_stdio_stream@@@Z 016c __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 34 00 00 91 88 16 40 B9 15 00 00 11 BF 3B 03 D5 88 09 60 37 80 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 31 ?? ?? ?? ?? 20 02 00 54 80 02 00 91 ?? ?? ?? ?? 1F 08 00 31 A0 01 00 54 80 02 00 91 ?? ?? ?? ?? 13 00 00 11 80 02 00 91 ?? ?? ?? ?? 68 7E 40 93 0C FD 46 93 ?? ?? ?? ?? 68 79 6C F8 0A 14 40 92 0D 19 0A 8B 02 00 00 14 ?? ?? ?? ?? A8 E5 C0 39 08 FD 03 11 09 1D 00 53 3F 05 00 71 09 06 00 54 80 02 00 91 ?? ?? ?? ?? 1F 04 00 31 20 02 00 54 80 02 00 91 ?? ?? ?? ?? 1F 08 00 31 A0 01 00 54 80 02 00 91 ?? ?? ?? ?? 13 00 00 11 80 02 00 91 ?? ?? ?? ?? 68 7E 40 93 0C FD 46 93 ?? ?? ?? ?? 68 79 6C F8 0A 14 40 92 0D 19 0A 8B 02 00 00 14 ?? ?? ?? ?? A8 E1 40 39 28 03 38 36 A3 02 00 11 A2 00 80 D2 E1 23 00 91 E0 03 00 91 ?? ?? ?? ?? 60 00 00 34 E0 FF 9F 52 14 00 00 14 E8 03 40 B9 13 00 80 52 1F 01 00 71 6D 01 00 54 E9 23 00 91 20 C9 F3 38 81 02 00 91 ?? ?? ?? ?? 1F 04 00 31 A0 FE FF 54 E8 03 40 B9 73 06 00 11 7F 02 08 6B EB FE FF 54 A0 02 00 11 04 00 00 14 81 02 00 91 A0 02 00 11 ?? ?? ?? ?? FF 43 00 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_121_9_0 {
	meta:
		name = "_fputwchar"
		size = 48
		refs = "0014 __acrt_iob_func 0020 fputwc"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 20 00 80 52 ?? ?? ?? ?? 01 00 00 91 60 02 00 11 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_8_0 {
	meta:
		name = "_fputchar"
		size = 48
		refs = "0014 __acrt_iob_func 0020 fputc"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 20 00 80 52 ?? ?? ?? ?? 01 00 00 91 60 02 00 11 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_121_11_0 {
	meta:
		name = "fputwc"
		size = 104
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0038 _lock_file 0044 _fputwc_nolock 0050 _unlock_file"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 14 00 00 11 33 00 00 91 B3 0B 00 F9 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? E0 FF 9F 52 0A 00 00 14 60 02 00 91 ?? ?? ?? ?? 61 02 00 91 80 02 00 11 ?? ?? ?? ?? 14 00 00 11 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_497_13_0 {
	meta:
		name = "ungetwc"
		size = 104
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0038 _lock_file 0044 _ungetwc_nolock 0050 _unlock_file"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 14 00 00 11 33 00 00 91 B3 0B 00 F9 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? E0 FF 9F 52 0A 00 00 14 60 02 00 91 ?? ?? ?? ?? 61 02 00 91 80 02 00 11 ?? ?? ?? ?? 14 00 00 11 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_121_12_0 {
	meta:
		name = "fputwc$fin$0"
		size = 32
		refs = "000c _unlock_file"
		altNames = "?fin$0@?0???$common_fdopen@D@@YAPEAU_iobuf@@HQEBD@Z@4HA ?fin$0@?0???$common_fdopen@_W@@YAPEAU_iobuf@@HQEB_W@Z@4HA ?fin$0@?0???$common_freopen@D@@YAHQEAPEAU_iobuf@@QEBD1V__crt_stdio_stream@@H@Z@4HA ?fin$0@?0???$common_freopen@_W@@YAHQEAPEAU_iobuf@@QEB_W1V__crt_stdio_stream@@H@Z@4HA ?fin$0@?0???$common_ftell@J@@YAJV__crt_stdio_stream@@@Z@4HA ?fin$0@?0???$common_ftell@_J@@YA_JV__crt_stdio_stream@@@Z@4HA ?fin$0@?0??common_fseek@@YAHV__crt_stdio_stream@@_JH@Z@4HA clearerr_s$fin$0 fclose$fin$0 fgetc$fin$0 fgetwc$fin$0 fputc$fin$0 fread_s$fin$0 rewind$fin$0 ungetc$fin$0 ungetwc$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A0 0B 40 F9 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_122_0_0 {
	meta:
		name = "fetestexcept"
		size = 40
		refs = "0014 fegetexceptflag"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 00 11 FF 13 00 B9 E0 43 00 91 ?? ?? ?? ?? E8 13 40 B9 00 11 00 12 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_123_5_0 {
	meta:
		name = "clearerr_s"
		size = 216
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 0034 _lock_file 0054 _fileno 008c __pioinfo 00a4 __badioinfo 00c0 _unlock_file"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 14 00 00 91 B4 0B 00 F9 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 27 00 00 14 80 02 00 91 ?? ?? ?? ?? 8A 52 00 91 49 FD 5F 88 29 75 1B 12 49 FD 08 88 A8 FF FF 35 BF 3B 03 D5 80 02 00 91 ?? ?? ?? ?? 1F 04 00 31 40 02 00 54 80 02 00 91 ?? ?? ?? ?? 1F 08 00 31 C0 01 00 54 80 02 00 91 ?? ?? ?? ?? 13 00 00 11 80 02 00 91 ?? ?? ?? ?? 68 7E 40 93 0B FD 46 93 ?? ?? ?? ?? ?? ?? ?? ?? 0A 14 40 92 29 79 6B F8 2C 19 0A 8B 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 88 E1 40 39 A9 1F 80 52 08 01 09 0A 88 E1 00 39 80 02 00 91 ?? ?? ?? ?? 00 00 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_124_0_0 {
	meta:
		name = "cacosh"
		size = 720
		refs = "0010 creal 0020 cimag 002c _dtest 0060 _Inf_C 011c _Cbuild 0120 csqrt 01f8 asinh 0218 log 0274 atan2"
	strings:
		$1 = { F3 0F 1F F8 FD 7B B9 A9 FD 03 00 91 E0 87 05 6D ?? ?? ?? ?? E1 33 40 FD E0 13 00 FD E0 2F 40 FD ?? ?? ?? ?? E0 83 00 91 E0 0F 00 FD ?? ?? ?? ?? 13 00 00 11 E0 63 00 91 ?? ?? ?? ?? 7F 0A 00 71 A1 01 00 54 1F 08 00 71 61 00 00 54 E1 83 41 6D 8F 00 00 14 E1 13 40 FD 1F 04 00 71 81 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 89 00 00 14 E1 0B 00 FD 86 00 00 14 1F 08 00 71 81 00 00 54 E1 0F 40 FD 7F 06 00 71 F6 FF FF 17 7F 06 00 71 81 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 71 E1 00 00 54 F0 13 40 FD F1 0F 00 5C 08 22 60 1E F0 0F 00 5C 21 3E 70 1E 06 00 00 14 F2 13 40 FD B3 0F 00 5C F0 03 67 9E 48 22 60 1E 61 3E 70 1E E8 3F 40 79 E8 0D 78 36 21 40 61 1E 6D 00 00 14 1F 04 00 71 21 01 00 54 F0 0F 40 FD 91 0E 00 5C ?? ?? ?? ?? ?? ?? ?? ?? 08 22 60 1E 50 0E 00 5C 21 3E 70 1E 63 00 00 14 F2 0F 40 FD 10 10 6E 1E F0 27 00 FD 41 42 61 1E F2 13 40 FD 40 3A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? F0 13 40 FD F1 27 40 FD E0 0B 00 FD E1 17 00 FD E1 0F 40 FD 00 2A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 07 03 6D E1 17 40 FD E0 0B 40 FD ?? ?? ?? ?? E1 17 40 FD E0 2B 00 FD E0 0B 40 FD ?? ?? ?? ?? E1 1F 40 FD E0 23 00 FD E0 1B 40 FD ?? ?? ?? ?? E1 1F 40 FD E0 0B 00 FD E0 1B 40 FD ?? ?? ?? ?? F2 2B 40 FD 14 0A 00 5C E0 1B 00 FD F1 23 40 FD 80 22 72 1E C2 00 00 54 F4 0B 40 FD F2 17 00 FD 90 1A 72 1E 00 82 51 1F 13 00 00 14 80 22 71 1E C2 00 00 54 F1 17 00 FD 11 18 71 1E F4 0B 40 FD 20 D2 72 1F 0C 00 00 14 30 42 61 1E 80 22 70 1E F0 17 00 FD F4 0B 40 FD 82 00 00 54 10 18 70 1E 00 D2 72 1F 04 00 00 14 12 08 72 1E FF 17 00 F9 80 CA 51 1F ?? ?? ?? ?? F1 17 40 FD E0 0B 00 FD 28 22 60 1E 80 01 00 54 08 20 60 1E 20 42 60 1E AB 00 00 54 ?? ?? ?? ?? F0 0B 40 FD 10 28 70 1E 04 00 00 14 ?? ?? ?? ?? F0 0B 40 FD 10 3A 60 1E F0 0B 00 FD E8 3F 40 79 13 01 11 12 B3 00 00 34 F0 0F 40 FD 01 42 61 1E E1 0F 00 FD 02 00 00 14 E1 0F 40 FD F0 13 40 FD F1 27 40 FD 00 3A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E1 1B 40 FD ?? ?? ?? ?? 10 10 60 1E 01 08 70 1E 53 00 00 34 21 40 61 1E E0 0B 40 FD ?? ?? ?? ?? FD 7B C7 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 D2 21 33 7F 7C D9 02 40 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 FB 21 F9 3F 7B 52 82 BD 3A FB CF 5F }
	condition:
		$1
}

rule file_565_1_0 {
	meta:
		name = "cacoshl"
		size = 720
		refs = "0010 creall 0020 cimagl 002c _ldtest 0060 _LInf_C 011c _LCbuild 0120 csqrtl 01f8 asinhl 0218 log 0274 atan2"
	strings:
		$1 = { F3 0F 1F F8 FD 7B B9 A9 FD 03 00 91 E0 87 05 6D ?? ?? ?? ?? E1 33 40 FD E0 13 00 FD E0 2F 40 FD ?? ?? ?? ?? E0 83 00 91 E0 0F 00 FD ?? ?? ?? ?? 13 00 00 11 E0 63 00 91 ?? ?? ?? ?? 7F 0A 00 71 A1 01 00 54 1F 08 00 71 61 00 00 54 E1 83 41 6D 8F 00 00 14 E1 13 40 FD 1F 04 00 71 81 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 89 00 00 14 E1 0B 00 FD 86 00 00 14 1F 08 00 71 81 00 00 54 E1 0F 40 FD 7F 06 00 71 F6 FF FF 17 7F 06 00 71 81 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 71 E1 00 00 54 F0 13 40 FD F1 0F 00 5C 08 22 60 1E F0 0F 00 5C 21 3E 70 1E 06 00 00 14 F2 13 40 FD B3 0F 00 5C F0 03 67 9E 48 22 60 1E 61 3E 70 1E E8 3F 40 79 E8 0D 78 36 21 40 61 1E 6D 00 00 14 1F 04 00 71 21 01 00 54 F0 0F 40 FD 91 0E 00 5C ?? ?? ?? ?? ?? ?? ?? ?? 08 22 60 1E 50 0E 00 5C 21 3E 70 1E 63 00 00 14 F2 0F 40 FD 10 10 6E 1E F0 27 00 FD 41 42 61 1E F2 13 40 FD 40 3A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? F0 13 40 FD F1 27 40 FD E0 0B 00 FD E1 17 00 FD E1 0F 40 FD 00 2A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 07 03 6D E1 17 40 FD E0 0B 40 FD ?? ?? ?? ?? E1 17 40 FD E0 2B 00 FD E0 0B 40 FD ?? ?? ?? ?? E1 1F 40 FD E0 23 00 FD E0 1B 40 FD ?? ?? ?? ?? E1 1F 40 FD E0 0B 00 FD E0 1B 40 FD ?? ?? ?? ?? F2 2B 40 FD 14 0A 00 5C E0 1B 00 FD F1 23 40 FD 80 22 72 1E C2 00 00 54 F4 0B 40 FD F2 17 00 FD 90 1A 72 1E 00 82 51 1F 13 00 00 14 80 22 71 1E C2 00 00 54 F1 17 00 FD 11 18 71 1E F4 0B 40 FD 20 D2 72 1F 0C 00 00 14 30 42 61 1E 80 22 70 1E F0 17 00 FD F4 0B 40 FD 82 00 00 54 10 18 70 1E 00 D2 72 1F 04 00 00 14 12 08 72 1E FF 17 00 F9 80 CA 51 1F ?? ?? ?? ?? F1 17 40 FD E0 0B 00 FD 28 22 60 1E 80 01 00 54 08 20 60 1E 20 42 60 1E AB 00 00 54 ?? ?? ?? ?? F0 0B 40 FD 10 28 70 1E 04 00 00 14 ?? ?? ?? ?? F0 0B 40 FD 10 3A 60 1E F0 0B 00 FD E8 3F 40 79 13 01 11 12 B3 00 00 34 F0 0F 40 FD 01 42 61 1E E1 0F 00 FD 02 00 00 14 E1 0F 40 FD F0 13 40 FD F1 27 40 FD 00 3A 71 1E ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E1 1B 40 FD ?? ?? ?? ?? 10 10 60 1E 01 08 70 1E 53 00 00 34 21 40 61 1E E0 0B 40 FD ?? ?? ?? ?? FD 7B C7 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 D2 21 33 7F 7C D9 02 40 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 F9 BF 18 2D 44 54 FB 21 F9 3F 7B 52 82 BD 3A FB CF 5F }
	condition:
		$1
}

rule file_125_8_0 {
	meta:
		name = "__acrt_uninitialize_tmpfile"
		size = 24
		refs = "0008 __acrt_stdio_free_tmpfile_name_buffers_nolock 000c _rmtmp"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_532_72_0 {
	meta:
		name = "?close@stream_traits@?A0xe43b7539@@SA_NPEAU_iobuf@@@Z"
		size = 24
		refs = "0008 fclose"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_318_20_0 {
	meta:
		name = "__acrt_thread_detach"
		size = 24
		refs = "0008 __acrt_freeptd"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_318_22_0 {
	meta:
		name = "__acrt_uninitialize_critical"
		size = 24
		refs = "0008 __acrt_uninitialize_ptd"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_253_23_2 {
	meta:
		name = "__fpecode"
		size = 24
		refs = "0008 __acrt_getptd"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 00 40 00 91 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_253_24_3 {
	meta:
		name = "__pxcptinfoptrs"
		size = 24
		refs = "0008 __acrt_getptd"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 00 20 00 91 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_458_3_3 {
	meta:
		name = "_getfpstatusword"
		size = 24
		refs = "0008 _statusfp"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 00 10 00 12 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_573_1_4 {
	meta:
		name = "fegetround"
		size = 24
		refs = "0008 _getfpcontrolword"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 00 04 18 12 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_520_26_3 {
	meta:
		name = "isalnum"
		size = 44
		refs = "0000 __acrt_locale_changed_data 0010 _isalnum_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EA 20 80 52 09 D9 60 78 20 01 0A 0A C0 03 5F D6 }
	condition:
		$1
}

rule file_520_27_3 {
	meta:
		name = "isalpha"
		size = 44
		refs = "0000 __acrt_locale_changed_data 0010 _isalpha_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 20 80 52 09 D9 60 78 20 01 0A 0A C0 03 5F D6 }
	condition:
		$1
}

rule file_520_29_2 {
	meta:
		name = "iscntrl"
		size = 40
		refs = "0000 __acrt_locale_changed_data 0010 _iscntrl_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 D9 60 78 20 01 1B 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_520_30_4 {
	meta:
		name = "isdigit"
		size = 40
		refs = "0000 __acrt_locale_changed_data 0010 _isdigit_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 D9 60 78 20 01 1E 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_520_31_4 {
	meta:
		name = "isgraph"
		size = 44
		refs = "0000 __acrt_locale_changed_data 0010 _isgraph_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EA 22 80 52 09 D9 60 78 20 01 0A 0A C0 03 5F D6 }
	condition:
		$1
}

rule file_520_32_0 {
	meta:
		name = "islower"
		size = 40
		refs = "0000 __acrt_locale_changed_data 0010 _islower_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 D9 60 78 20 01 1F 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_520_33_3 {
	meta:
		name = "isprint"
		size = 44
		refs = "0000 __acrt_locale_changed_data 0010 _isprint_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EA 2A 80 52 09 D9 60 78 20 01 0A 0A C0 03 5F D6 }
	condition:
		$1
}

rule file_520_34_3 {
	meta:
		name = "ispunct"
		size = 40
		refs = "0000 __acrt_locale_changed_data 0010 _ispunct_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 D9 60 78 20 01 1C 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_520_35_2 {
	meta:
		name = "isspace"
		size = 40
		refs = "0000 __acrt_locale_changed_data 0010 _isspace_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 D9 60 78 20 01 1D 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_520_36_2 {
	meta:
		name = "isupper"
		size = 40
		refs = "0000 __acrt_locale_changed_data 0010 _isupper_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 D9 60 78 20 01 00 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_520_37_2 {
	meta:
		name = "isxdigit"
		size = 40
		refs = "0000 __acrt_locale_changed_data 0010 _isxdigit_l 0014 __acrt_initial_locale_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 D9 60 78 20 01 19 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_318_4_4 {
	meta:
		name = "uninitialize_environment"
		size = 24
		refs = "0008 __dcrt_uninitialize_environments_nolock"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_125_9_0 {
	meta:
		name = "_rmtmp"
		size = 192
		refs = "001c __acrt_lock 0028 __piob 002c _nstream 0058 _lock_file 0074 _fclose_nolock 0084 _unlock_file 00a0 __acrt_unlock"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 14 00 80 52 00 01 80 52 ?? ?? ?? ?? 15 00 80 52 BF 13 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? BF 02 08 6B 00 03 00 54 33 D9 75 F8 B3 0F 00 F9 B3 13 00 F9 53 00 00 B5 10 00 00 14 60 02 00 91 ?? ?? ?? ?? 68 16 40 B9 BF 3B 03 D5 E8 00 68 36 68 16 40 F9 A8 00 00 B4 60 02 00 91 ?? ?? ?? ?? 94 06 00 11 B4 17 00 B9 60 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B5 06 00 11 B5 13 00 B9 E8 FF FF 17 00 01 80 52 ?? ?? ?? ?? 80 02 00 11 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_125_10_0 {
	meta:
		name = "_rmtmp$fin$0"
		size = 32
		refs = "000c _unlock_file"
		altNames = "?fin$0@?0???$common_fgets@D@@YAPEADQEADHV__crt_stdio_stream@@@Z@4HA ?fin$0@?0???$common_fgets@_W@@YAPEA_WQEA_WHV__crt_stdio_stream@@@Z@4HA fputws$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A0 0F 40 F9 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_125_11_0 {
	meta:
		name = "_rmtmp$fin$1"
		size = 32
		refs = "000c __acrt_unlock"
		altNames = "?fin$0@?0??__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ@4HA _fcloseall$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 00 01 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_126_0_0 {
	meta:
		name = "lrintl"
		size = 144
		refs = "0010 _ldtest 0028 nearbyintl 0044 _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? 00 03 00 34 08 04 00 51 1F 05 00 71 69 02 00 54 E0 0B 40 FD ?? ?? ?? ?? F0 0B 40 FD 12 40 60 1E F2 0F 00 FD 40 22 70 1E 80 00 00 54 00 04 80 52 ?? ?? ?? ?? F2 0F 40 FD B0 01 00 5C 00 22 72 1E C8 00 00 54 91 01 00 5C 40 22 71 1E 68 00 00 54 40 02 78 1E 04 00 00 14 20 00 80 52 ?? ?? ?? ?? 00 00 80 52 FD 7B C2 A8 C0 03 5F D6 00 00 00 00 00 00 E0 C1 00 00 C0 FF FF FF DF 41 }
	condition:
		$1
}

rule file_537_0_0 {
	meta:
		name = "lrint"
		size = 144
		refs = "0010 _dtest 0028 nearbyint 0044 _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? 00 03 00 34 08 04 00 51 1F 05 00 71 69 02 00 54 E0 0B 40 FD ?? ?? ?? ?? F0 0B 40 FD 12 40 60 1E F2 0F 00 FD 40 22 70 1E 80 00 00 54 00 04 80 52 ?? ?? ?? ?? F2 0F 40 FD B0 01 00 5C 00 22 72 1E C8 00 00 54 91 01 00 5C 40 22 71 1E 68 00 00 54 40 02 78 1E 04 00 00 14 20 00 80 52 ?? ?? ?? ?? 00 00 80 52 FD 7B C2 A8 C0 03 5F D6 00 00 00 00 00 00 E0 C1 00 00 C0 FF FF FF DF 41 }
	condition:
		$1
}

rule file_127_1_0 {
	meta:
		name = "erfc"
		size = 648
		refs = "0010 _dtest 003c erf 0068 s00 008c c00 00b8 s01 00dc c01 0104 approx 013c _fperrraise 01e0 _d_int 01f4 exp 0218 _dexp"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 63 00 91 E0 0F 00 FD ?? ?? ?? ?? 80 11 00 34 1F 04 00 71 80 10 00 54 1F 08 00 71 00 10 00 54 F2 0F 40 FD 30 11 00 5C 40 22 70 1E C2 00 00 54 40 42 60 1E ?? ?? ?? ?? 10 10 6E 1E 00 3A 60 1E 80 00 00 14 70 10 00 5C 40 22 70 1E 82 05 00 54 10 10 6E 1E 40 22 70 1E A2 02 00 54 10 10 6D 1E ?? ?? ?? ?? ?? ?? ?? ?? 94 0F 00 5C E8 00 80 52 55 3A 70 1E 31 8D 40 FC 08 05 00 51 94 46 55 1F A8 FF FF 36 ?? ?? ?? ?? D3 0E 00 5C ?? ?? ?? ?? 09 01 80 52 50 8D 40 FC 29 05 00 51 73 42 55 1F A9 FF FF 36 80 1A 73 1E 66 00 00 14 F1 0D 00 5C ?? ?? ?? ?? ?? ?? ?? ?? D5 0D 00 5C E8 00 80 52 56 3A 71 1E 70 8D 40 FC 08 05 00 51 B5 42 56 1F A8 FF FF 36 ?? ?? ?? ?? 13 0D 00 5C ?? ?? ?? ?? 09 01 80 52 51 8D 40 FC 29 05 00 51 73 46 56 1F A9 FF FF 36 A0 1A 73 1E 52 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 48 7D 40 93 0C 06 80 D2 09 7D 0C 9B 30 69 6B FC 40 22 70 1E 23 01 00 54 4A 05 00 11 48 7D 40 93 1F 19 00 F1 E3 FE FF 54 00 02 80 52 ?? ?? ?? ?? E0 03 67 9E 41 00 00 14 10 10 6E 1E 48 7D 40 93 09 06 80 D2 0E 7D 09 9B 68 21 00 91 11 1A 72 1E D0 69 68 FC 68 41 00 91 CD 69 68 F8 68 61 00 91 C9 69 68 B8 2C 05 00 51 33 3A 70 1E F3 0B 00 FD B0 01 40 FD F0 17 00 FD CC 00 F8 37 B1 8D 40 FC 8C 05 00 51 10 46 53 1F AC FF FF 36 F0 17 00 FD 68 81 00 91 CD 69 68 F8 68 A1 00 91 C9 69 68 B8 B1 01 40 FD 2A 05 00 51 F1 13 00 FD CA 00 F8 37 B0 8D 40 FC 4A 05 00 51 31 42 53 1F AA FF FF 36 F1 13 00 FD 21 02 80 52 F2 0B 00 FD E0 43 00 91 ?? ?? ?? ?? F2 43 41 6D 51 3A 70 1E 50 2A 70 1E 20 0A 70 1E ?? ?? ?? ?? F0 47 42 6D 01 00 80 52 E0 43 00 91 30 1A 70 1E F1 0B 40 FD 31 8A 71 1E F1 0B 00 FD 00 08 70 1E ?? ?? ?? ?? E0 0B 40 FD 0A 00 00 14 E0 0F 40 FD 08 00 00 14 E8 3F 40 79 10 10 60 1E F1 03 67 9E 1F 01 11 72 00 1E 71 1E 02 00 00 14 00 10 6E 1E FD 7B C3 A8 C0 03 5F D6 0A C0 24 BB 1F 86 DE 3F 91 ED 7C 3F 35 5E F8 3F A9 9B E2 EB 08 E3 2A 3F 49 B8 C7 5A 1F B3 CF BE 00 00 00 00 00 80 F4 3F 59 20 36 18 2F 33 E0 3E EC F4 CD C2 BC 5B 21 3F }
	condition:
		$1
}

rule file_128_4_0 {
	meta:
		name = "_mbsnbcat_s_l"
		size = 728
		refs = "0050 _errno 005c _invalid_parameter_noinfo 0080 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00a0 strncat_s"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 13 00 00 91 35 00 00 91 56 00 00 91 74 00 00 91 17 00 80 52 B4 00 00 B5 B3 00 00 B5 15 01 00 B5 00 00 80 52 0B 00 00 14 B3 00 00 B4 95 00 00 B4 B4 01 00 B4 96 01 00 B5 7F 02 00 39 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 81 00 00 91 E0 43 00 91 ?? ?? ?? ?? EF 13 40 F9 E8 09 40 B9 E8 00 00 35 83 02 00 91 C2 02 00 91 A1 02 00 91 60 02 00 91 ?? ?? ?? ?? 86 00 00 14 6B 02 00 91 AC 02 00 91 68 01 40 39 88 00 00 34 6B 05 00 91 8C 05 00 D1 8C FF FF B5 0C 01 00 B5 7F 02 00 39 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 77 00 00 14 9F 01 15 EB 42 02 00 54 6D 05 00 D1 AA 01 00 91 BF 01 13 EB 03 01 00 54 48 01 40 39 08 01 0F 8B 09 65 40 39 89 00 10 36 4A 05 00 D1 5F 01 13 EB 42 FF FF 54 A9 01 0A 4B A9 00 00 36 6B 05 00 D1 7F 01 00 39 8C 05 00 91 37 00 80 52 9F 06 00 B1 E1 00 00 54 CA 16 40 38 6A 15 00 38 EA 01 00 34 8C 05 00 D1 8C FF FF B5 0C 00 00 14 14 01 00 B4 C8 16 40 38 68 15 00 38 A8 00 00 34 8C 05 00 D1 6C 00 00 B4 94 06 00 D1 54 FF FF B5 74 00 00 B5 7F 01 00 39 6B 05 00 91 0C 07 00 B5 C8 02 40 39 1F 01 00 71 84 1A 41 FA 01 02 00 54 6E 05 00 D1 CD 01 00 91 DF 01 13 EB 03 01 00 54 A9 01 40 39 29 01 0F 8B 2A 65 40 39 8A 00 10 36 AD 05 00 D1 BF 01 13 EB 42 FF FF 54 C9 01 0D 4B 69 00 00 36 7F F1 1F 38 37 00 00 14 9F 06 00 B1 81 03 00 54 B7 00 00 34 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 EF 13 40 F9 BF 06 00 F1 29 02 00 54 6C 02 15 8B 8B 09 00 D1 6A 01 00 91 7F 01 13 EB 03 01 00 54 48 01 40 39 08 01 0F 8B 09 65 40 39 89 00 10 36 4A 05 00 D1 5F 01 13 EB 42 FF FF 54 69 01 0A 4B 69 00 00 36 9F E1 1F 38 03 00 00 14 68 02 15 8B 1F F1 1F 38 00 0A 80 52 20 00 00 14 7F 02 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 19 00 00 14 9F 01 15 EB 02 02 00 54 6D 09 00 D1 AA 01 00 91 BF 01 13 EB 03 01 00 54 48 01 40 39 08 01 0F 8B 09 65 40 39 89 00 10 36 4A 05 00 D1 5F 01 13 EB 42 FF FF 54 A9 01 0A 4B 69 00 00 36 7F E1 1F 38 37 00 80 52 D7 00 00 34 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 40 05 80 52 02 00 00 14 00 00 80 52 E8 A3 40 39 28 ED FF 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 64 FF FF 17 }
	condition:
		$1
}

rule file_129_9_0 {
	meta:
		name = "__acrt_GetStringTypeA"
		size = 500
		refs = "001c __security_push_cookie 0048 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0064 __imp_MultiByteToWideChar 00ec __chkstk 010c _malloc_base 013c memset 0168 __imp_GetStringTypeW 01ac _free_base 01d4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 73 05 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 FC 03 00 91 37 00 00 11 01 00 00 91 80 03 00 91 59 00 00 91 7A 00 00 11 98 00 00 91 B5 00 00 11 D3 00 00 11 ?? ?? ?? ?? 75 00 00 35 88 07 40 F9 15 0D 40 B9 7F 02 00 71 29 01 80 52 28 00 80 52 ?? ?? ?? ?? 21 11 88 1A ?? ?? ?? ?? 09 FD DF C8 05 00 80 52 04 00 80 D2 43 03 00 11 22 03 00 91 A0 02 00 11 20 01 3F D6 16 00 00 11 76 00 00 35 14 00 80 52 46 00 00 14 D4 7E 40 93 89 FA 7F D3 28 41 00 91 1F 01 09 EB 08 81 9F 9A C8 03 00 B4 28 41 00 91 1F 05 14 EB 08 81 9F 9A 1F 01 10 F1 88 FA 7F D3 09 41 00 91 C8 01 00 54 3F 01 08 EB 2A 81 9F 9A 4B 3D 00 91 7F 01 0A EB 4C 00 00 54 EB DF 7C B2 6F FD 44 D3 ?? ?? ?? ?? FF 73 2F CB F3 03 00 91 B3 01 00 B4 88 99 99 52 07 00 00 14 3F 01 08 EB 20 81 9F 9A ?? ?? ?? ?? 13 00 00 91 D3 00 00 B4 A8 BB 9B 52 68 02 00 B9 73 42 00 91 02 00 00 14 13 00 80 D2 33 03 00 B4 82 FA 7F D3 01 00 80 52 60 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 C5 02 00 11 64 02 00 91 43 03 00 11 22 03 00 91 21 00 80 52 A0 02 00 11 20 01 3F D6 60 01 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 02 00 00 11 03 03 00 91 61 02 00 91 E0 02 00 11 20 01 3F D6 14 00 00 11 02 00 00 14 14 00 80 52 F3 00 00 B4 68 02 5F B8 A9 BB 9B 52 1F 01 09 6B 61 00 00 54 60 42 00 D1 ?? ?? ?? ?? 88 63 40 39 A8 00 00 34 8A 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 80 02 00 11 9F 03 00 91 FF 83 00 91 ?? ?? ?? ?? FB 73 45 A9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_130_0_0 {
	meta:
		name = "wcstok"
		size = 56
		refs = "0018 __acrt_getptd 0028 __acrt_wcstok_s_novalidation"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 34 00 00 91 62 00 00 B5 ?? ?? ?? ?? 02 00 01 91 81 02 00 91 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_131_5_0 {
	meta:
		name = "_mbsnlen_l"
		size = 180
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0034 strnlen"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? EC 13 40 F9 88 09 40 B9 A8 00 00 35 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 16 00 00 14 0B 00 80 D2 0A 00 80 D2 34 02 00 B4 68 02 40 39 E8 01 00 34 08 01 0C 8B 09 65 40 39 E9 00 10 36 4A 05 00 91 5F 01 14 EB 22 01 00 54 73 06 00 91 69 02 40 39 C9 00 00 34 4A 05 00 91 5F 01 14 EB 6B 05 00 91 73 06 00 91 23 FE FF 54 5F 01 14 EB 80 22 8B 9A E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_0_0 {
	meta:
		name = "_dxp_addh"
		size = 812
		refs = "002c _dunscale 0044 _dtest 006c _fperrraise 0070 _Nan_C 0200 _d_int 020c _dscale"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BC A9 FD 03 00 91 E0 83 01 6D 13 00 00 91 35 00 00 11 B5 17 00 34 E1 83 00 91 E0 4B 00 91 ?? ?? ?? ?? 1F 00 00 71 2D 03 00 54 1F 08 00 71 80 02 00 54 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 0D 02 00 54 1F 08 00 71 00 16 00 54 69 0E 40 79 E8 3F 40 79 28 01 08 4A 88 15 78 36 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? BF 06 00 71 70 02 00 FD AD 14 00 54 7F 06 00 F9 A3 00 00 14 F1 0F 40 FD 71 02 00 FD A0 00 00 14 E0 13 F8 36 17 00 81 52 14 00 80 52 BF 02 00 71 6D 13 00 54 FF 17 00 F9 96 7E 40 93 70 7A 76 FC E1 C3 00 91 E0 43 00 91 F0 1B 00 FD ?? ?? ?? ?? 1F 00 00 71 4C 12 00 54 40 11 00 34 E9 23 C0 79 E8 27 C0 79 F1 0F 40 FD 2A 01 08 4B 5F 69 00 31 CC 03 00 54 28 22 60 1E 80 03 00 54 89 02 00 11 2B 01 00 11 29 05 00 11 3F 01 15 6B 8A 00 00 54 70 DA 69 FC 08 22 60 1E 41 FF FF 54 A8 06 00 51 3F 01 08 6B 6A 00 00 54 2A 05 00 11 03 00 00 14 3F 01 15 6B 6A 01 89 1A 9F 02 0A 6B EA 00 00 54 49 05 00 51 70 DA 69 FC 70 DA 2A FC 2A 01 00 11 5F 01 14 6B 6C FF FF 54 F0 17 40 FD 71 7A 36 FC F0 0F 00 FD 64 00 00 14 5F 69 00 71 CB 00 00 54 28 22 60 1E 80 00 00 54 37 01 00 11 94 06 00 11 5D 00 00 14 70 7A 76 FC 11 2A 71 1E 71 7A 36 FC 28 22 60 1E 01 02 00 54 89 02 00 11 29 05 00 11 3F 01 15 6B CA 00 00 54 72 DA 69 FC 28 05 00 51 72 DA 28 FC 48 22 60 1E 21 FF FF 54 F0 17 40 FD A9 06 00 51 70 DA 29 FC 70 7A 76 FC 08 22 60 1E 60 0A 00 54 71 7A 76 FC E1 63 00 91 E0 4B 00 91 F1 0F 00 FD ?? ?? ?? ?? E9 27 C0 79 E8 6A 00 51 1F 01 09 6B EA 04 00 54 29 01 17 4B 2A 69 00 11 41 3D 00 13 E0 63 00 91 ?? ?? ?? ?? E1 27 C0 79 E0 63 00 91 ?? ?? ?? ?? 71 7A 76 FC F0 0F 40 FD 30 3A 70 1E 70 7A 36 FC 08 22 60 1E A1 01 00 54 89 02 00 11 29 05 00 11 3F 01 15 6B CA 00 00 54 72 DA 69 FC 28 05 00 51 72 DA 28 FC 48 22 60 1E 21 FF FF 54 F0 17 40 FD A9 06 00 51 70 DA 29 FC 94 06 00 51 74 00 00 35 17 00 81 52 22 00 00 14 89 06 00 51 70 DA 69 FC E1 83 00 91 E0 43 00 91 F0 13 00 FD ?? ?? ?? ?? F7 23 C0 79 1A 00 00 14 94 06 00 11 9F 02 15 6B 20 04 00 54 70 7A 76 FC 61 0E 16 8B E0 43 00 91 F0 0F 00 FD ?? ?? ?? ?? 60 0E 16 8B 41 03 80 52 ?? ?? ?? ?? E1 23 C0 79 60 0E 16 8B ?? ?? ?? ?? F0 0F 40 FD E1 83 00 91 72 7A 76 FC E0 4B 00 91 F7 23 C0 79 11 3A 72 1E 28 22 60 1E F1 0F 00 FD 30 1E 72 1E F0 13 00 FD ?? ?? ?? ?? 9F 02 15 6B 0B EE FF 54 08 00 00 14 F0 0F 40 FD 88 06 00 11 1F 01 15 6B 70 DA 34 FC 6A 00 00 54 F0 17 40 FD 70 DA 28 FC 60 02 00 91 FD 7B C4 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_626_0_0 {
	meta:
		name = "_ldxp_addh"
		size = 812
		refs = "002c _ldunscale 0044 _ldtest 006c _fperrraise 0070 _LNan_C 0200 _ld_int 020c _ldscale"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BC A9 FD 03 00 91 E0 83 01 6D 13 00 00 91 35 00 00 11 B5 17 00 34 E1 83 00 91 E0 4B 00 91 ?? ?? ?? ?? 1F 00 00 71 2D 03 00 54 1F 08 00 71 80 02 00 54 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 0D 02 00 54 1F 08 00 71 00 16 00 54 69 0E 40 79 E8 3F 40 79 28 01 08 4A 88 15 78 36 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? BF 06 00 71 70 02 00 FD AD 14 00 54 7F 06 00 F9 A3 00 00 14 F1 0F 40 FD 71 02 00 FD A0 00 00 14 E0 13 F8 36 17 00 81 52 14 00 80 52 BF 02 00 71 6D 13 00 54 FF 17 00 F9 96 7E 40 93 70 7A 76 FC E1 C3 00 91 E0 43 00 91 F0 1B 00 FD ?? ?? ?? ?? 1F 00 00 71 4C 12 00 54 40 11 00 34 E9 23 C0 79 E8 27 C0 79 F1 0F 40 FD 2A 01 08 4B 5F 69 00 31 CC 03 00 54 28 22 60 1E 80 03 00 54 89 02 00 11 2B 01 00 11 29 05 00 11 3F 01 15 6B 8A 00 00 54 70 DA 69 FC 08 22 60 1E 41 FF FF 54 A8 06 00 51 3F 01 08 6B 6A 00 00 54 2A 05 00 11 03 00 00 14 3F 01 15 6B 6A 01 89 1A 9F 02 0A 6B EA 00 00 54 49 05 00 51 70 DA 69 FC 70 DA 2A FC 2A 01 00 11 5F 01 14 6B 6C FF FF 54 F0 17 40 FD 71 7A 36 FC F0 0F 00 FD 64 00 00 14 5F 69 00 71 CB 00 00 54 28 22 60 1E 80 00 00 54 37 01 00 11 94 06 00 11 5D 00 00 14 70 7A 76 FC 11 2A 71 1E 71 7A 36 FC 28 22 60 1E 01 02 00 54 89 02 00 11 29 05 00 11 3F 01 15 6B CA 00 00 54 72 DA 69 FC 28 05 00 51 72 DA 28 FC 48 22 60 1E 21 FF FF 54 F0 17 40 FD A9 06 00 51 70 DA 29 FC 70 7A 76 FC 08 22 60 1E 60 0A 00 54 71 7A 76 FC E1 63 00 91 E0 4B 00 91 F1 0F 00 FD ?? ?? ?? ?? E9 27 C0 79 E8 6A 00 51 1F 01 09 6B EA 04 00 54 29 01 17 4B 2A 69 00 11 41 3D 00 13 E0 63 00 91 ?? ?? ?? ?? E1 27 C0 79 E0 63 00 91 ?? ?? ?? ?? 71 7A 76 FC F0 0F 40 FD 30 3A 70 1E 70 7A 36 FC 08 22 60 1E A1 01 00 54 89 02 00 11 29 05 00 11 3F 01 15 6B CA 00 00 54 72 DA 69 FC 28 05 00 51 72 DA 28 FC 48 22 60 1E 21 FF FF 54 F0 17 40 FD A9 06 00 51 70 DA 29 FC 94 06 00 51 74 00 00 35 17 00 81 52 22 00 00 14 89 06 00 51 70 DA 69 FC E1 83 00 91 E0 43 00 91 F0 13 00 FD ?? ?? ?? ?? F7 23 C0 79 1A 00 00 14 94 06 00 11 9F 02 15 6B 20 04 00 54 70 7A 76 FC 61 0E 16 8B E0 43 00 91 F0 0F 00 FD ?? ?? ?? ?? 60 0E 16 8B 41 03 80 52 ?? ?? ?? ?? E1 23 C0 79 60 0E 16 8B ?? ?? ?? ?? F0 0F 40 FD E1 83 00 91 72 7A 76 FC E0 4B 00 91 F7 23 C0 79 11 3A 72 1E 28 22 60 1E F1 0F 00 FD 30 1E 72 1E F0 13 00 FD ?? ?? ?? ?? 9F 02 15 6B 0B EE FF 54 08 00 00 14 F0 0F 40 FD 88 06 00 11 1F 01 15 6B 70 DA 34 FC 6A 00 00 54 F0 17 40 FD 70 DA 28 FC 60 02 00 91 FD 7B C4 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_1_0 {
	meta:
		name = "_dxp_addx"
		size = 108
		refs = "0044 _dxp_addh"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 76 00 00 11 DF 02 00 71 13 00 00 91 37 00 00 11 55 00 00 91 14 00 80 52 4D 01 00 54 A0 DA 74 FC 08 20 60 1E E0 00 00 54 E1 02 00 11 60 02 00 91 ?? ?? ?? ?? 94 06 00 11 9F 02 16 6B 0B FF FF 54 60 02 00 91 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_626_1_0 {
	meta:
		name = "_ldxp_addx"
		size = 108
		refs = "0044 _ldxp_addh"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 76 00 00 11 DF 02 00 71 13 00 00 91 37 00 00 11 55 00 00 91 14 00 80 52 4D 01 00 54 A0 DA 74 FC 08 20 60 1E E0 00 00 54 E1 02 00 11 60 02 00 91 ?? ?? ?? ?? 94 06 00 11 9F 02 16 6B 0B FF FF 54 60 02 00 91 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_2_0 {
	meta:
		name = "_dxp_getw"
		size = 96
		altNames = "_ldxp_getw"
	strings:
		$1 = { 61 00 00 35 E0 03 67 9E 15 00 00 14 3F 04 00 71 40 02 00 54 14 00 40 FD 88 22 60 1E E0 01 00 54 3F 04 00 71 8D 00 00 54 10 04 40 FD 08 22 60 1E 40 01 00 54 3F 08 00 71 81 00 00 54 11 04 40 FD 20 2A 74 1E 06 00 00 14 12 CC 40 6D 73 2A 72 1E 60 2A 74 1E 02 00 00 14 00 00 40 FD C0 03 5F D6 }
	condition:
		$1
}

rule file_132_3_0 {
	meta:
		name = "_dxp_invx"
		size = 332
		refs = "0028 _dtest 0044 _Inf_C 0074 memcpy 0084 _dxp_mulh 00b0 _dxp_setw 00e4 _dxp_mulx 00f4 _dxp_addh 0120 _dxp_addx"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 34 00 00 11 56 00 00 91 74 08 00 34 ?? ?? ?? ?? 40 01 F8 37 1F 04 00 71 61 00 00 54 7F 02 00 F9 3D 00 00 14 80 07 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 70 02 00 FD 38 00 00 14 97 7E 40 93 70 02 40 FD D5 0E 17 8B 98 7E 40 93 02 F3 7D D3 A0 02 00 91 61 02 00 91 F0 0B 00 FD ?? ?? ?? ?? 00 10 7E 1E 81 02 00 11 A0 02 00 91 ?? ?? ?? ?? F1 0B 40 FD 9F 06 00 71 6D 00 00 54 70 06 40 FD 11 2A 71 1E 10 10 6E 1E 81 02 00 11 60 02 00 91 00 1A 71 1E F0 0B 00 FD ?? ?? ?? ?? 39 00 80 52 9F 06 00 71 AD 03 00 54 02 F3 7D D3 61 02 00 91 C0 02 00 91 ?? ?? ?? ?? A4 0E 17 8B 83 02 00 11 A2 02 00 91 81 02 00 11 C0 02 00 91 ?? ?? ?? ?? E0 0B 40 FD 81 02 00 11 C0 02 00 91 ?? ?? ?? ?? A4 0E 17 8B 83 02 00 11 62 02 00 91 81 02 00 11 C0 02 00 91 ?? ?? ?? ?? 83 02 00 11 C2 02 00 91 81 02 00 11 60 02 00 91 ?? ?? ?? ?? 39 7B 1F 53 3F 03 14 6B AB FC FF 54 60 02 00 91 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_626_3_0 {
	meta:
		name = "_ldxp_invx"
		size = 332
		refs = "0028 _ldtest 0044 _LInf_C 0074 memcpy 0084 _ldxp_mulh 00b0 _ldxp_setw 00e4 _ldxp_mulx 00f4 _ldxp_addh 0120 _ldxp_addx"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 34 00 00 11 56 00 00 91 74 08 00 34 ?? ?? ?? ?? 40 01 F8 37 1F 04 00 71 61 00 00 54 7F 02 00 F9 3D 00 00 14 80 07 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 70 02 00 FD 38 00 00 14 97 7E 40 93 70 02 40 FD D5 0E 17 8B 98 7E 40 93 02 F3 7D D3 A0 02 00 91 61 02 00 91 F0 0B 00 FD ?? ?? ?? ?? 00 10 7E 1E 81 02 00 11 A0 02 00 91 ?? ?? ?? ?? F1 0B 40 FD 9F 06 00 71 6D 00 00 54 70 06 40 FD 11 2A 71 1E 10 10 6E 1E 81 02 00 11 60 02 00 91 00 1A 71 1E F0 0B 00 FD ?? ?? ?? ?? 39 00 80 52 9F 06 00 71 AD 03 00 54 02 F3 7D D3 61 02 00 91 C0 02 00 91 ?? ?? ?? ?? A4 0E 17 8B 83 02 00 11 A2 02 00 91 81 02 00 11 C0 02 00 91 ?? ?? ?? ?? E0 0B 40 FD 81 02 00 11 C0 02 00 91 ?? ?? ?? ?? A4 0E 17 8B 83 02 00 11 62 02 00 91 81 02 00 11 C0 02 00 91 ?? ?? ?? ?? 83 02 00 11 C2 02 00 91 81 02 00 11 60 02 00 91 ?? ?? ?? ?? 39 7B 1F 53 3F 03 14 6B AB FC FF 54 60 02 00 91 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_4_0 {
	meta:
		name = "_dxp_ldexpx"
		size = 96
		refs = "0030 ldexp"
		altNames = "_ldxp_ldexpx"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 35 00 00 11 BF 02 00 71 14 00 00 91 56 00 00 11 13 00 80 52 4D 01 00 54 80 DA 73 FC C0 02 00 11 ?? ?? ?? ?? 80 DA 33 FC 08 20 60 1E 80 00 00 54 73 06 00 11 7F 02 15 6B 0B FF FF 54 80 02 00 91 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_5_0 {
	meta:
		name = "_dxp_movx"
		size = 48
		refs = "001c memcpy"
		altNames = "_ldxp_movx"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 28 00 00 11 41 00 00 91 02 7D 7D 93 13 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_6_0 {
	meta:
		name = "_dxp_mulh"
		size = 424
		refs = "0010 __security_push_cookie 0048 _dtest 0060 _fperrraise 0100 _dunscale 010c _d_int 0118 _dscale 0128 _dxp_addh 0194 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 01 D1 12 40 60 1E 35 00 00 11 FF 0B 00 F9 14 00 00 91 F1 03 67 9E BF 02 00 71 F2 0F 00 FD AD 02 00 54 90 02 40 FD E0 83 00 91 11 0A 72 1E F1 13 00 FD ?? ?? ?? ?? 13 00 00 11 93 01 F8 37 7F 0A 00 71 61 00 00 54 20 00 80 52 ?? ?? ?? ?? F0 13 40 FD 7F 02 00 71 AE CA 41 7A 90 02 00 FD CD 08 00 54 9F 06 00 F9 44 00 00 14 F1 4B 41 6D 91 02 00 FD 33 00 80 52 16 00 80 52 BF 02 00 71 CD 07 00 54 7F 12 00 71 6A 02 00 54 C8 02 13 0B 1F 01 15 6B AA 01 00 54 90 DA 68 FC 08 22 60 1E 40 01 00 54 10 0A 72 1E E9 83 00 91 91 DA 28 FC 08 05 00 11 30 D9 33 FC 73 06 00 11 7F 12 00 71 8B FE FF 54 04 00 00 14 EA 83 00 91 51 D9 33 FC 13 01 80 52 F3 13 40 FD 68 22 60 1E E0 04 00 54 E1 23 00 91 F3 07 00 FD E0 03 00 91 ?? ?? ?? ?? 41 03 80 52 E0 23 00 91 ?? ?? ?? ?? E1 03 C0 79 E0 23 00 91 ?? ?? ?? ?? E0 07 40 FD A1 02 00 11 80 02 00 91 ?? ?? ?? ?? F1 13 40 FD A1 02 00 11 F0 07 40 FD 80 02 00 91 20 3A 70 1E ?? ?? ?? ?? 29 00 80 52 7F 06 00 71 6D 01 00 54 E8 83 00 91 10 D9 69 FC EA 83 00 91 28 05 00 51 50 D9 28 FC 08 22 60 1E 80 00 00 54 29 05 00 11 3F 01 13 6B EB FE FF 54 D6 06 00 11 F1 4B 41 6D DF 02 15 6B 73 06 00 51 8B F8 FF 54 80 02 00 91 FF 03 01 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_626_6_0 {
	meta:
		name = "_ldxp_mulh"
		size = 424
		refs = "0010 __security_push_cookie 0048 _ldtest 0060 _fperrraise 0100 _ldunscale 010c _ld_int 0118 _ldscale 0128 _ldxp_addh 0194 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 01 D1 12 40 60 1E 35 00 00 11 FF 0B 00 F9 14 00 00 91 F1 03 67 9E BF 02 00 71 F2 0F 00 FD AD 02 00 54 90 02 40 FD E0 83 00 91 11 0A 72 1E F1 13 00 FD ?? ?? ?? ?? 13 00 00 11 93 01 F8 37 7F 0A 00 71 61 00 00 54 20 00 80 52 ?? ?? ?? ?? F0 13 40 FD 7F 02 00 71 AE CA 41 7A 90 02 00 FD CD 08 00 54 9F 06 00 F9 44 00 00 14 F1 4B 41 6D 91 02 00 FD 33 00 80 52 16 00 80 52 BF 02 00 71 CD 07 00 54 7F 12 00 71 6A 02 00 54 C8 02 13 0B 1F 01 15 6B AA 01 00 54 90 DA 68 FC 08 22 60 1E 40 01 00 54 10 0A 72 1E E9 83 00 91 91 DA 28 FC 08 05 00 11 30 D9 33 FC 73 06 00 11 7F 12 00 71 8B FE FF 54 04 00 00 14 EA 83 00 91 51 D9 33 FC 13 01 80 52 F3 13 40 FD 68 22 60 1E E0 04 00 54 E1 23 00 91 F3 07 00 FD E0 03 00 91 ?? ?? ?? ?? 41 03 80 52 E0 23 00 91 ?? ?? ?? ?? E1 03 C0 79 E0 23 00 91 ?? ?? ?? ?? E0 07 40 FD A1 02 00 11 80 02 00 91 ?? ?? ?? ?? F1 13 40 FD A1 02 00 11 F0 07 40 FD 80 02 00 91 20 3A 70 1E ?? ?? ?? ?? 29 00 80 52 7F 06 00 71 6D 01 00 54 E8 83 00 91 10 D9 69 FC EA 83 00 91 28 05 00 51 50 D9 28 FC 08 22 60 1E 80 00 00 54 29 05 00 11 3F 01 13 6B EB FE FF 54 D6 06 00 11 F1 4B 41 6D DF 02 15 6B 73 06 00 51 8B F8 FF 54 80 02 00 91 FF 03 01 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_7_0 {
	meta:
		name = "_dxp_mulx"
		size = 248
		refs = "0060 memcpy 0070 _dxp_mulh 00bc _dxp_addx"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 35 00 00 11 53 00 00 91 76 00 00 11 98 00 00 91 95 05 00 34 76 05 00 34 60 02 40 FD 08 20 60 1E A0 04 00 54 70 06 40 FD 08 22 60 1E 40 04 00 54 B9 7E 40 93 22 F3 7D D3 81 02 00 91 00 03 00 91 BA 7E 40 93 ?? ?? ?? ?? 60 02 40 FD A1 02 00 11 80 02 00 91 ?? ?? ?? ?? 37 00 80 52 DF 06 00 71 0D 03 00 54 70 DA 77 FC 08 22 60 1E A0 02 00 54 00 0F 1A 8B 22 F3 7D D3 01 03 00 91 ?? ?? ?? ?? 60 DA 77 FC 00 0F 1A 8B A1 02 00 11 ?? ?? ?? ?? 02 0F 1A 8B A3 02 00 11 A1 02 00 11 80 02 00 91 ?? ?? ?? ?? F7 06 00 11 FF 02 16 6B CB FD FF 54 04 00 00 14 A1 02 00 11 80 02 00 91 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_626_7_0 {
	meta:
		name = "_ldxp_mulx"
		size = 248
		refs = "0060 memcpy 0070 _ldxp_mulh 00bc _ldxp_addx"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 35 00 00 11 53 00 00 91 76 00 00 11 98 00 00 91 95 05 00 34 76 05 00 34 60 02 40 FD 08 20 60 1E A0 04 00 54 70 06 40 FD 08 22 60 1E 40 04 00 54 B9 7E 40 93 22 F3 7D D3 81 02 00 91 00 03 00 91 BA 7E 40 93 ?? ?? ?? ?? 60 02 40 FD A1 02 00 11 80 02 00 91 ?? ?? ?? ?? 37 00 80 52 DF 06 00 71 0D 03 00 54 70 DA 77 FC 08 22 60 1E A0 02 00 54 00 0F 1A 8B 22 F3 7D D3 01 03 00 91 ?? ?? ?? ?? 60 DA 77 FC 00 0F 1A 8B A1 02 00 11 ?? ?? ?? ?? 02 0F 1A 8B A3 02 00 11 A1 02 00 11 80 02 00 91 ?? ?? ?? ?? F7 06 00 11 FF 02 16 6B CB FD FF 54 04 00 00 14 A1 02 00 11 80 02 00 91 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_8_0 {
	meta:
		name = "_dxp_setw"
		size = 240
		refs = "0034 _dunscale 0068 _d_int 0074 _dscale"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 10 40 60 1E 34 00 00 11 13 00 00 91 9F 02 00 71 F0 C3 01 6D 8D 01 00 54 9F 06 00 71 20 01 00 54 E1 63 00 91 E0 43 00 91 ?? ?? ?? ?? 80 00 00 34 1F 00 00 71 0D 01 00 54 7F 06 00 F9 F0 0F 40 FD 70 02 00 FD 60 02 00 91 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 41 03 80 52 E0 63 00 91 ?? ?? ?? ?? E1 23 C0 79 E0 63 00 91 ?? ?? ?? ?? F0 C7 41 6D 9F 0A 00 71 70 02 00 FD 30 3A 70 1E F0 13 00 FD 70 06 00 FD 0D FE FF 54 08 22 60 1E 80 02 00 54 61 22 00 91 E0 43 00 91 ?? ?? ?? ?? 41 03 80 52 60 22 00 91 ?? ?? ?? ?? E1 23 C0 79 60 22 00 91 ?? ?? ?? ?? 70 06 40 FD 9F 0E 00 71 F1 13 40 FD 32 3A 70 1E 72 0A 00 FD ED FB FF 54 48 22 60 1E A0 FB FF 54 7F 0E 00 F9 DB FF FF 17 7F 0A 00 F9 D9 FF FF 17 }
	condition:
		$1
}

rule file_626_8_0 {
	meta:
		name = "_ldxp_setw"
		size = 240
		refs = "0034 _ldunscale 0068 _ld_int 0074 _ldscale"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 10 40 60 1E 34 00 00 11 13 00 00 91 9F 02 00 71 F0 C3 01 6D 8D 01 00 54 9F 06 00 71 20 01 00 54 E1 63 00 91 E0 43 00 91 ?? ?? ?? ?? 80 00 00 34 1F 00 00 71 0D 01 00 54 7F 06 00 F9 F0 0F 40 FD 70 02 00 FD 60 02 00 91 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 41 03 80 52 E0 63 00 91 ?? ?? ?? ?? E1 23 C0 79 E0 63 00 91 ?? ?? ?? ?? F0 C7 41 6D 9F 0A 00 71 70 02 00 FD 30 3A 70 1E F0 13 00 FD 70 06 00 FD 0D FE FF 54 08 22 60 1E 80 02 00 54 61 22 00 91 E0 43 00 91 ?? ?? ?? ?? 41 03 80 52 60 22 00 91 ?? ?? ?? ?? E1 23 C0 79 60 22 00 91 ?? ?? ?? ?? 70 06 40 FD 9F 0E 00 71 F1 13 40 FD 32 3A 70 1E 72 0A 00 FD ED FB FF 54 48 22 60 1E A0 FB FF 54 7F 0E 00 F9 DB FF FF 17 7F 0A 00 F9 D9 FF FF 17 }
	condition:
		$1
}

rule file_132_9_0 {
	meta:
		name = "_dxp_sqrtx"
		size = 344
		refs = "0028 _dtest 0068 _dxp_setw 0088 memcpy 0098 _dxp_mulh 00b0 _dxp_mulx 00d8 _dxp_addh 012c _fperrraise 0130 _Nan_C"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 33 00 00 11 57 00 00 91 D3 08 00 34 ?? ?? ?? ?? 80 07 F8 36 91 02 40 FD 28 22 60 1E 83 07 00 54 76 7E 40 93 F5 0E 16 8B 7F 06 00 71 6D 00 00 54 90 06 40 FD 11 2A 71 1E 32 C2 61 1E 61 02 00 11 11 10 6E 1E A0 02 00 91 20 1A 72 1E ?? ?? ?? ?? 59 00 80 52 7F 0A 00 71 6D 04 00 54 78 7E 40 93 02 F3 7D D3 A1 02 00 91 E0 02 00 91 ?? ?? ?? ?? 00 10 7C 1E 61 02 00 11 E0 02 00 91 ?? ?? ?? ?? A4 0E 16 8B 63 02 00 11 82 02 00 91 61 02 00 11 E0 02 00 91 ?? ?? ?? ?? A4 0E 16 8B 63 02 00 11 A2 02 00 91 61 02 00 11 E0 02 00 91 ?? ?? ?? ?? 00 10 6F 1E 61 02 00 11 E0 02 00 91 ?? ?? ?? ?? A4 0E 16 8B 63 02 00 11 E2 02 00 91 61 02 00 11 A0 02 00 91 ?? ?? ?? ?? 39 7B 1F 53 3F 03 13 6B 0B FC FF 54 A4 0E 16 8B 63 02 00 11 A2 02 00 91 61 02 00 11 80 02 00 91 ?? ?? ?? ?? 09 00 00 14 90 02 40 FD 08 22 60 1E C2 00 00 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 02 00 FD 80 02 00 91 FD 7B C1 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_626_9_0 {
	meta:
		name = "_ldxp_sqrtx"
		size = 344
		refs = "0028 _ldtest 0068 _ldxp_setw 0088 memcpy 0098 _ldxp_mulh 00b0 _ldxp_mulx 00d8 _ldxp_addh 012c _fperrraise 0130 _LNan_C"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 33 00 00 11 57 00 00 91 D3 08 00 34 ?? ?? ?? ?? 80 07 F8 36 91 02 40 FD 28 22 60 1E 83 07 00 54 76 7E 40 93 F5 0E 16 8B 7F 06 00 71 6D 00 00 54 90 06 40 FD 11 2A 71 1E 32 C2 61 1E 61 02 00 11 11 10 6E 1E A0 02 00 91 20 1A 72 1E ?? ?? ?? ?? 59 00 80 52 7F 0A 00 71 6D 04 00 54 78 7E 40 93 02 F3 7D D3 A1 02 00 91 E0 02 00 91 ?? ?? ?? ?? 00 10 7C 1E 61 02 00 11 E0 02 00 91 ?? ?? ?? ?? A4 0E 16 8B 63 02 00 11 82 02 00 91 61 02 00 11 E0 02 00 91 ?? ?? ?? ?? A4 0E 16 8B 63 02 00 11 A2 02 00 91 61 02 00 11 E0 02 00 91 ?? ?? ?? ?? 00 10 6F 1E 61 02 00 11 E0 02 00 91 ?? ?? ?? ?? A4 0E 16 8B 63 02 00 11 E2 02 00 91 61 02 00 11 A0 02 00 91 ?? ?? ?? ?? 39 7B 1F 53 3F 03 13 6B 0B FC FF 54 A4 0E 16 8B 63 02 00 11 A2 02 00 91 61 02 00 11 80 02 00 91 ?? ?? ?? ?? 09 00 00 14 90 02 40 FD 08 22 60 1E C2 00 00 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 90 02 00 FD 80 02 00 91 FD 7B C1 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_10_0 {
	meta:
		name = "_dxp_subx"
		size = 112
		refs = "0048 _dxp_addh"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 76 00 00 11 DF 02 00 71 13 00 00 91 37 00 00 11 55 00 00 91 14 00 80 52 6D 01 00 54 B0 DA 74 FC 08 22 60 1E 00 01 00 54 00 42 61 1E E1 02 00 11 60 02 00 91 ?? ?? ?? ?? 94 06 00 11 9F 02 16 6B EB FE FF 54 60 02 00 91 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_626_10_0 {
	meta:
		name = "_ldxp_subx"
		size = 112
		refs = "0048 _ldxp_addh"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 76 00 00 11 DF 02 00 71 13 00 00 91 37 00 00 11 55 00 00 91 14 00 80 52 6D 01 00 54 B0 DA 74 FC 08 22 60 1E 00 01 00 54 00 42 61 1E E1 02 00 11 60 02 00 91 ?? ?? ?? ?? 94 06 00 11 9F 02 16 6B EB FE FF 54 60 02 00 91 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_132_11_0 {
	meta:
		name = "fma"
		size = 516
		refs = "000c __security_push_cookie 0030 _dunscale 00ec _dscale 00fc _dxp_setw 012c _dxp_mulh 016c _dxp_addx 018c _dxp_getw 01e4 _fperrraise 01e8 _Nan_C 01f4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 02 D1 E1 A3 00 91 E0 87 01 6D E0 13 00 91 E0 83 02 6D E2 87 04 6D E2 8B 00 6D E1 23 00 FD ?? ?? ?? ?? 14 00 00 11 9F 0A 00 71 61 00 00 54 E0 0F 40 FD 6B 00 00 14 E1 03 01 91 E0 0B 00 91 ?? ?? ?? ?? 13 00 00 11 7F 0A 00 71 61 00 00 54 E0 13 40 FD 63 00 00 14 E1 23 00 91 E0 03 00 91 ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0B 40 FD 5C 00 00 14 9F 06 00 71 64 1A 41 7A E0 08 00 54 1F 04 00 71 40 FF FF 54 D4 09 00 34 B3 09 00 34 80 09 00 34 E9 07 C0 79 E8 0B C0 79 33 01 08 0B E9 03 C0 79 28 01 13 4B E9 9F 40 79 01 3D 00 13 E8 AF 40 79 E1 03 00 79 2A 01 08 4A E9 6F 40 79 48 01 09 4A E8 07 78 36 29 08 00 11 28 3D 00 53 1F 11 00 71 68 07 00 54 E0 23 00 91 ?? ?? ?? ?? E0 17 40 FD 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? E0 23 40 FD 41 00 80 52 E0 C3 00 91 ?? ?? ?? ?? E0 07 40 FD 41 00 80 52 E0 43 01 91 ?? ?? ?? ?? E0 1B 40 FD 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? F0 1F 40 FD 08 22 60 1E C0 01 00 54 E0 17 40 FD 81 00 80 52 E0 03 02 91 ?? ?? ?? ?? E0 1F 40 FD 81 00 80 52 E0 03 02 91 ?? ?? ?? ?? 83 00 80 52 E2 03 02 91 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? 43 00 80 52 E2 43 01 91 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? 61 02 00 11 E0 23 00 91 E0 07 00 FD ?? ?? ?? ?? E0 07 40 FD 13 00 00 14 D4 01 00 34 B3 01 00 34 1F 04 00 71 E1 00 00 54 E9 9F 40 79 E8 AF 40 79 2A 01 08 4A E9 6F 40 79 48 01 09 4A A8 00 78 37 F0 47 41 6D F2 13 40 FD 20 42 52 1F 05 00 00 14 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 83 02 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_626_11_0 {
	meta:
		name = "fmal"
		size = 516
		refs = "000c __security_push_cookie 0030 _ldunscale 00ec _ldscale 00fc _ldxp_setw 012c _ldxp_mulh 016c _ldxp_addx 018c _ldxp_getw 01e4 _fperrraise 01e8 _LNan_C 01f4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 02 D1 E1 A3 00 91 E0 87 01 6D E0 13 00 91 E0 83 02 6D E2 87 04 6D E2 8B 00 6D E1 23 00 FD ?? ?? ?? ?? 14 00 00 11 9F 0A 00 71 61 00 00 54 E0 0F 40 FD 6B 00 00 14 E1 03 01 91 E0 0B 00 91 ?? ?? ?? ?? 13 00 00 11 7F 0A 00 71 61 00 00 54 E0 13 40 FD 63 00 00 14 E1 23 00 91 E0 03 00 91 ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0B 40 FD 5C 00 00 14 9F 06 00 71 64 1A 41 7A E0 08 00 54 1F 04 00 71 40 FF FF 54 D4 09 00 34 B3 09 00 34 80 09 00 34 E9 07 C0 79 E8 0B C0 79 33 01 08 0B E9 03 C0 79 28 01 13 4B E9 9F 40 79 01 3D 00 13 E8 AF 40 79 E1 03 00 79 2A 01 08 4A E9 6F 40 79 48 01 09 4A E8 07 78 36 29 08 00 11 28 3D 00 53 1F 11 00 71 68 07 00 54 E0 23 00 91 ?? ?? ?? ?? E0 17 40 FD 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? E0 23 40 FD 41 00 80 52 E0 C3 00 91 ?? ?? ?? ?? E0 07 40 FD 41 00 80 52 E0 43 01 91 ?? ?? ?? ?? E0 1B 40 FD 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? F0 1F 40 FD 08 22 60 1E C0 01 00 54 E0 17 40 FD 81 00 80 52 E0 03 02 91 ?? ?? ?? ?? E0 1F 40 FD 81 00 80 52 E0 03 02 91 ?? ?? ?? ?? 83 00 80 52 E2 03 02 91 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? 43 00 80 52 E2 43 01 91 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? 81 00 80 52 E0 83 01 91 ?? ?? ?? ?? 61 02 00 11 E0 23 00 91 E0 07 00 FD ?? ?? ?? ?? E0 07 40 FD 13 00 00 14 D4 01 00 34 B3 01 00 34 1F 04 00 71 E1 00 00 54 E9 9F 40 79 E8 AF 40 79 2A 01 08 4A E9 6F 40 79 48 01 09 4A A8 00 78 37 F0 47 41 6D F2 13 40 FD 20 42 52 1F 05 00 00 14 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FF 83 02 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_133_1_0 {
	meta:
		name = "_pipe"
		size = 688
		refs = "0028 __doserrno 0030 _errno 003c _invalid_parameter_noinfo 0098 __imp_CreatePipe 00ac __imp_GetLastError 00bc __acrt_errno_map_os_error 00c4 _alloc_osfhnd 00ec __imp_CloseHandle 0118 __pioinfo 0158 __acrt_lowio_unlock_fh 01d4 _get_fmode 025c __acrt_lowio_set_os_handle 0290 _invoke_watson"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 23 00 F9 FD 7B BB A9 FD 03 00 91 15 00 00 91 53 00 00 11 35 01 00 B5 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 94 00 00 14 08 00 80 12 A8 06 00 B9 A8 02 00 B9 08 10 98 12 68 02 08 0A 68 FE FF 35 68 06 12 12 09 00 98 52 1F 01 09 6B E0 FD FF 54 1A 03 80 52 BA 33 00 B9 BF 1F 00 F9 E8 1F 73 2A 09 01 00 12 A9 43 00 B9 23 00 00 11 A2 C3 00 91 A1 A3 00 91 A0 83 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E0 FF FF 17 ?? ?? ?? ?? 14 00 00 11 B4 17 00 B9 9F 06 00 31 E1 01 00 54 ?? ?? ?? ?? 1A 00 00 B9 ?? ?? ?? ?? 1F 00 00 B9 A0 13 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 A0 17 40 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 CD FF FF 17 88 7E 40 93 17 FD 46 93 ?? ?? ?? ?? ?? ?? ?? ?? 19 15 40 92 08 7B 77 F8 09 19 19 8B 28 11 80 52 28 E1 00 39 08 7B 77 F8 09 19 19 8B 3F E5 00 39 0A 7B 77 F8 4B 19 19 8B 68 F5 40 39 08 19 1F 12 68 F5 00 39 80 02 00 11 ?? ?? ?? ?? ?? ?? ?? ?? 16 00 00 11 B6 17 00 B9 DF 06 00 31 A1 00 00 54 08 7B 77 F8 09 19 19 8B 3F E1 00 39 D7 FF FF 17 C8 7E 40 93 1A FD 46 93 ?? ?? ?? ?? 0B 15 40 92 AB 0F 00 F9 68 7B 7A F8 09 19 0B 8B 2A 11 80 52 2A E1 00 39 68 7B 7A F8 09 19 0B 8B 3F E5 00 39 6A 7B 7A F8 4B 19 0B 8B 68 F5 40 39 08 19 1F 12 68 F5 00 39 C0 02 00 11 ?? ?? ?? ?? BF 13 00 B9 A0 43 00 91 ?? ?? ?? ?? 20 05 00 35 D3 00 78 37 33 02 70 37 09 00 90 52 A8 13 40 B9 1F 01 09 6B A1 01 00 54 08 7B 77 F8 0A 19 19 8B 49 E1 40 39 28 19 00 12 48 E1 00 39 69 7B 7A F8 AC 0F 40 F9 2B 19 0C 8B 68 E1 40 39 08 19 00 12 68 E1 00 39 02 00 00 14 AC 0F 40 F9 73 01 38 36 08 7B 77 F8 0A 19 19 8B 49 E1 40 39 28 01 1C 32 48 E1 00 39 69 7B 7A F8 2B 19 0C 8B 68 E1 40 39 08 01 1C 32 68 E1 00 39 A1 13 40 F9 80 02 00 11 ?? ?? ?? ?? A1 17 40 F9 C0 02 00 11 ?? ?? ?? ?? B4 02 00 B9 B6 06 00 B9 00 00 80 52 07 00 00 14 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? FD 7B C5 A8 FB 23 40 F9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_133_2_0 {
	meta:
		name = "_pipe$fin$1"
		size = 32
		refs = "000c __acrt_lowio_unlock_fh"
		altNames = "_pipe$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A0 17 40 B9 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_134_0_0 {
	meta:
		name = "_fdpow"
		size = 1408
		refs = "0010 __security_push_cookie 0030 _fdunscale 0040 _fd_int 00bc _fperrraise 00c0 _FNan_C 0138 _fdlogpoly 0218 _fdxp_setw 023c _fdxp_addx 0260 log2e 0274 _fdxp_mulh 02d8 _fdxp_addh 039c _fdxp_getw 03c8 _fdexp 03e4 _FInf_C 0494 _FZero_C 0554 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF C3 01 D1 15 00 00 91 E0 03 00 BD E0 13 00 91 E1 07 02 2D E1 03 00 91 E1 0B 00 BD ?? ?? ?? ?? 01 00 80 52 14 00 00 11 E0 43 00 91 ?? ?? ?? ?? 13 00 00 11 55 00 00 B4 BF 02 00 79 F1 17 40 BD 73 00 00 35 28 22 20 1E E0 01 00 54 E0 03 40 BD E9 0B C0 79 74 1D F8 36 10 10 2C 1E 3F 05 00 71 F0 1B 00 BD 41 01 00 54 00 20 30 1E C0 00 00 54 7F 06 00 71 C1 00 00 54 10 10 3C 1E 00 20 30 1E 61 00 00 54 00 10 2E 1E 2D 01 00 14 9F 02 00 71 60 BA 40 7A 6C 1B 00 54 E8 07 40 79 E8 00 78 36 D3 00 F8 36 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 22 01 00 14 08 20 20 1E 6D 00 00 54 14 00 80 52 09 00 00 14 10 40 21 1E 01 00 80 12 E0 43 00 91 F0 03 00 BD ?? ?? ?? ?? E0 03 40 BD 14 00 00 11 E9 0B C0 79 70 23 00 1C 00 20 30 1E A2 00 00 54 10 10 20 1E 28 05 00 51 E8 0B 00 79 00 08 30 1E 10 10 2E 1E 12 38 30 1E F0 2B 00 BD 11 28 30 1E F2 03 00 BD 50 1A 31 1E 00 0A 30 1E F0 0B 00 BD ?? ?? ?? ?? F1 0B 40 BD 7A 21 00 1C F4 03 40 BD FF 0B 00 B9 E8 0B C0 79 F7 17 40 BD FA 27 00 BD 30 0A 31 1E 19 01 22 1E 10 D0 30 1F 10 0A 31 1E 18 2A 34 1E F0 23 00 BD F0 03 27 1E 11 1B 3A 1E 32 2A 39 1E 56 0A 37 1E F6 CB 01 2D 72 1F 00 1C C0 22 32 1E 62 00 00 54 08 00 80 52 91 00 00 14 10 10 35 1E 00 22 36 1E C8 02 00 54 12 10 25 1E C0 22 32 1E 68 02 00 54 31 1E 00 1C 20 22 37 1E 02 02 00 54 F3 1D 00 1C E0 22 33 1E A2 01 00 54 F4 1B 40 BD C8 22 20 1E D5 3A 34 1E D4 2A 34 1E 16 0B 37 1E B0 3E 34 1E 01 02 38 1E 32 00 22 1E 31 CB 37 1F 35 5A 1A 1F F5 0F 00 BD 70 00 00 14 31 1C 00 1C 20 22 36 1E 62 00 00 54 28 00 80 52 73 00 00 14 80 42 20 1E 81 00 80 52 E0 03 01 91 ?? ?? ?? ?? E0 23 40 BD 41 00 80 52 E0 63 00 91 ?? ?? ?? ?? 43 00 80 52 E2 63 00 91 81 00 80 52 E0 03 01 91 ?? ?? ?? ?? E0 43 40 BD 81 00 80 52 E0 43 01 91 08 20 20 1E 81 00 00 54 E0 0B 40 BD ?? ?? ?? ?? 1B 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 29 40 A9 EB 43 01 91 69 29 00 A9 ?? ?? ?? ?? 33 00 80 52 E8 03 01 91 00 D9 73 BC 08 20 20 1E 00 02 00 54 ?? ?? ?? ?? 09 29 40 A9 EB 83 01 91 81 00 80 52 E0 83 01 91 69 29 00 A9 ?? ?? ?? ?? 83 00 80 52 E2 83 01 91 81 00 80 52 E0 43 01 91 ?? ?? ?? ?? 73 06 00 11 7F 12 00 71 CB FD FF 54 E8 0B C0 79 81 00 80 52 E0 43 01 91 00 01 22 1E ?? ?? ?? ?? E0 17 40 BD 41 00 80 52 E0 03 01 91 ?? ?? ?? ?? E8 43 01 91 E0 43 40 BD 08 25 40 A9 EA C3 00 91 81 00 80 52 E0 C3 00 91 48 25 00 A9 ?? ?? ?? ?? E0 47 40 BD 08 20 20 1E A0 01 00 54 E8 43 01 91 08 25 40 A9 EA 83 01 91 81 00 80 52 E0 83 01 91 48 25 00 A9 ?? ?? ?? ?? 83 00 80 52 E2 83 01 91 81 00 80 52 E0 C3 00 91 ?? ?? ?? ?? F1 33 40 BD F1 03 00 BD 28 22 20 1E 00 01 00 54 F2 37 40 BD 48 22 20 1E A0 00 00 54 F0 3B 40 BD 10 2A 32 1E 10 2A 31 1E F0 03 00 BD 01 00 80 52 E0 03 00 91 ?? ?? ?? ?? F0 03 40 BD 81 00 80 52 E0 C3 00 91 00 42 21 1E ?? ?? ?? ?? 81 00 80 52 E0 C3 00 91 ?? ?? ?? ?? F0 27 40 BD F1 03 40 BD 10 08 30 1E 21 02 38 1E F0 0F 00 BD 75 00 00 B4 A1 02 00 79 01 00 80 52 E0 2B 40 BD E0 33 00 91 ?? ?? ?? ?? F6 0F 40 BD 08 00 00 11 F0 0B 40 BD E8 00 00 34 1F 05 00 71 21 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 80 52 02 00 00 14 00 02 80 52 F0 0F 00 BD ?? ?? ?? ?? F6 0F 40 BD D0 42 21 1E 9F 02 00 71 00 1E 36 1E 50 00 00 14 9F 0A 00 71 C0 09 00 54 7F 0A 00 71 61 00 00 54 20 42 20 1E 4A 00 00 14 9F 06 00 71 01 04 00 54 E8 07 40 79 08 01 78 37 E9 17 40 79 ?? ?? ?? ?? F1 03 27 1E ?? ?? ?? ?? 3F 01 11 72 20 1E 30 1E 3F 00 00 14 E8 17 40 79 28 01 78 37 53 07 00 35 01 00 80 12 E0 43 00 91 ?? ?? ?? ?? C0 06 F8 36 ?? ?? ?? ?? ?? ?? ?? ?? 31 00 00 14 33 01 00 35 01 00 80 12 E0 43 00 91 ?? ?? ?? ?? A0 00 F8 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 21 1E 02 00 00 14 F0 03 27 1E 00 42 20 1E 29 00 00 14 E8 17 40 79 7F 06 00 71 81 01 00 54 3F 01 00 71 C8 00 78 37 ?? ?? ?? ?? F1 03 27 1E ?? ?? ?? ?? 20 DE 30 1E 1F 00 00 14 ?? ?? ?? ?? F0 03 27 1E ?? ?? ?? ?? FB FF FF 17 68 01 78 37 D3 FD FF 35 01 00 80 12 E0 43 00 91 ?? ?? ?? ?? 40 FD FF 36 E8 07 40 79 08 FD 7F 36 ?? ?? ?? ?? ?? ?? ?? ?? E3 FF FF 17 80 00 80 52 ?? ?? ?? ?? 73 01 00 35 01 00 80 12 E0 43 00 91 ?? ?? ?? ?? E0 00 F8 36 E8 07 40 79 A8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 00 42 21 1E 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? FF C3 01 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 F3 04 35 3F 18 72 31 3F 00 00 00 C7 00 00 20 C2 00 00 20 42 00 00 00 47 }
	condition:
		$1
}

rule file_134_1_0 {
	meta:
		name = "_fdtgamma"
		size = 384
		refs = "002c stirling 0104 _fdunscale"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 91 10 F0 27 1E 78 02 40 BD 20 00 00 91 F8 17 00 BD 00 22 38 1E 88 00 00 54 60 02 00 91 ?? ?? ?? ?? 48 00 00 14 10 10 3C 1E 12 10 2C 1E 00 23 30 1E A2 01 00 54 13 43 20 1E 11 10 2E 1E 40 22 38 1E F3 13 00 BD C3 00 00 54 18 2B 31 1E 73 0A 38 1E 40 22 38 1E A2 FF FF 54 F3 13 00 BD 18 3B 31 1E 23 00 00 14 00 23 32 1E C2 00 00 54 11 10 2E 1E 10 2B 31 1E 11 0A 38 1E F1 13 00 BD 1D 00 00 14 10 10 2F 1E 00 23 30 1E A2 00 00 54 11 10 2E 1E 10 43 20 1E 18 3B 31 1E 07 00 00 14 13 90 20 1E 00 23 33 1E C2 00 00 54 12 10 20 1E 10 10 2E 1E 18 3B 32 1E 1F 00 00 79 11 00 00 14 11 10 2E 1E 60 22 38 1E 32 42 20 1E F2 13 00 BD C2 00 00 54 18 3B 31 1E 52 1A 38 1E 60 22 38 1E A3 FF FF 54 F2 13 00 BD 12 10 20 1E 18 3B 32 1E F8 17 00 BD E1 43 00 91 ?? ?? ?? ?? F0 63 42 2D 70 02 00 BD 91 02 00 1C 90 02 00 1C 94 02 00 1C 12 43 11 1F 71 02 00 1C 53 46 18 1F 52 02 00 1C 77 4A 18 1F 33 02 00 1C 15 CF 34 1F 14 02 00 1C B6 52 18 1F F5 01 00 1C D6 56 18 1F F7 1A 36 1E E0 0A 38 1E FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 91 00 59 3C 74 A3 1A 3C 2B E5 11 3D 10 C7 DB 3E FC AC DD 3E A6 2C 45 3E C0 53 91 3C B3 14 83 3F }
	condition:
		$1
}

rule file_134_2_0 {
	meta:
		name = "stirling"
		size = 196
		refs = "002c _fdpow 0054 approx0 006c _fdpoly 0098 expf"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 14 00 00 91 10 10 2C 1E 91 02 40 BD 33 00 00 91 60 02 00 91 21 3A 30 1E F1 13 00 BD 20 42 20 1E ?? ?? ?? ?? F1 13 40 BD 10 10 2E 1E 68 02 C0 79 E0 1F 00 BD 21 00 80 52 12 1A 31 1E D1 03 00 1C E8 03 08 4B 68 02 00 79 ?? ?? ?? ?? ?? ?? ?? ?? 60 0E 40 F9 50 3A 31 1E 00 42 20 1E F0 17 00 BD ?? ?? ?? ?? 60 06 40 F9 E1 00 80 52 E0 1B 00 BD E0 17 40 BD ?? ?? ?? ?? F0 1B 40 BD 10 1A 20 1E F0 1B 00 BD F0 13 40 BD 00 42 21 1E ?? ?? ?? ?? F1 43 43 2D 10 08 30 1E E0 03 27 1E 31 1A 30 1E 91 02 00 BD FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 EC AA C5 3C }
	condition:
		$1
}

rule file_134_3_0 {
	meta:
		name = "tgammaf"
		size = 548
		refs = "0018 _fd_int 0048 _fperrraise 004c _FNan_C 0068 _FInf_C 00a8 _fdgamma_big 0120 _fdsin 0150 _fdtgamma 0178 _fdscale"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 01 00 80 52 E0 17 00 BD E0 73 00 91 E0 1F 00 BD ?? ?? ?? ?? F4 17 40 BD C0 01 00 34 1F 04 00 71 A0 00 00 54 1F 08 00 71 E1 02 00 54 E0 17 40 BD 76 00 00 14 E8 2F 40 79 A8 FF 7F 36 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6F 00 00 14 88 22 20 1E 41 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? E8 2F 40 79 ?? ?? ?? ?? 1F 01 11 72 30 42 21 1E 00 1E 31 1E 64 00 00 14 88 22 20 1E E3 FD FF 54 70 0C 00 1C 80 22 30 1E A8 00 00 54 00 02 80 52 ?? ?? ?? ?? E0 03 27 1E 5B 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 11 42 21 1E 80 22 31 1E 42 07 00 54 92 42 21 1E F3 1F 40 BD F4 1B 00 BD 10 10 2E 1E 01 00 80 12 E0 63 00 91 94 3A 33 1E F4 C3 03 2D 52 3A 30 1E F2 27 00 BD ?? ?? ?? ?? F1 C3 42 2D 31 3A 30 1E 10 10 3E 1E 20 22 30 1E A2 00 00 54 F2 1F 40 BD 53 42 21 1E F3 1F 00 BD 02 00 00 14 F3 1F 40 BD 70 08 00 1C 00 00 80 52 60 0A 30 1E F0 2B 00 BD ?? ?? ?? ?? F2 17 40 BD E1 43 00 91 F1 23 40 BD E0 93 00 91 F3 2B 40 BD 50 42 21 1E 11 3A 31 1E 10 08 32 1E 31 8A 30 1E 72 1A 31 1E F2 1B 00 BD ?? ?? ?? ?? F0 23 40 BD E1 23 C0 79 E0 63 00 91 11 28 30 1E F0 1B 40 BD 12 1A 31 1E F1 27 40 BD 52 0A 31 1E F2 1B 00 BD ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 A1 00 00 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? E0 1B 40 BD 1D 00 00 14 10 04 00 1C 80 22 30 1E C8 02 00 54 E1 43 00 91 E0 53 00 91 ?? ?? ?? ?? 10 10 2E 1E E8 23 C0 79 E0 53 00 91 E0 1F 00 BD 11 28 30 1E F0 17 40 BD E1 03 08 4B 30 1A 30 1E F0 17 00 BD ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 61 F2 FF 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? 8E FF FF 17 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 00 00 18 C2 DB 0F 49 40 00 00 18 42 }
	condition:
		$1
}

rule file_135_0_0 {
	meta:
		name = "__acrt_wcstok_s_novalidation"
		size = 168
	strings:
		$1 = { 40 00 00 B5 40 00 40 F9 08 00 40 79 E8 01 00 34 2B 00 40 79 29 00 00 91 EB 00 00 34 6A 01 00 11 5F 01 08 6B 80 00 00 54 29 09 00 91 2A 01 40 79 8A FF FF 35 28 01 40 79 88 00 00 34 00 08 00 91 08 00 40 79 88 FE FF 35 08 00 40 79 0C 00 00 91 48 02 00 34 2D 00 40 79 29 00 00 91 0D 01 00 34 0E 00 40 79 AA 01 00 11 5F 01 0E 6B 80 00 00 54 29 09 00 91 2A 01 40 79 8A FF FF 35 28 01 40 79 A8 00 00 35 00 08 00 91 09 00 40 79 69 FE FF 35 02 00 00 14 1F 24 00 78 1F 00 0C EB 40 00 00 F9 80 11 9F 9A C0 03 5F D6 }
	condition:
		$1
}

rule file_135_1_0 {
	meta:
		name = "wcstok_s"
		size = 64
		refs = "000c _errno 0018 _invalid_parameter_noinfo 0034 __acrt_wcstok_s_novalidation"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 E2 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 06 00 00 14 41 FF FF B4 60 00 00 B5 48 00 40 F9 E8 FE FF B4 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_658_1_0 {
	meta:
		name = "strtok_s"
		size = 64
		refs = "000c _errno 0018 _invalid_parameter_noinfo 0034 __acrt_strtok_s_novalidation"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 E2 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 06 00 00 14 41 FF FF B4 60 00 00 B5 48 00 40 F9 E8 FE FF B4 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_136_5_0 {
	meta:
		name = "_mbcjistojms_l"
		size = 192
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0088 _errno"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 08 05 40 B9 1F 91 0E 71 A1 03 00 54 6A 3E 08 53 48 85 00 51 1F 75 01 71 69 1E 00 12 88 02 00 54 28 85 00 51 1F 75 01 71 28 02 00 54 CA 00 00 36 3F 7D 01 71 EB 03 80 52 08 04 80 52 68 91 88 1A 02 00 00 14 C8 0F 80 52 0B 01 09 0B 48 85 00 51 09 7D 01 53 2A 05 02 11 5F 7D 02 71 49 00 00 54 4A 01 01 11 73 21 0A 2A 05 00 00 14 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 13 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_136_7_0 {
	meta:
		name = "_mbcjmstojis_l"
		size = 248
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00c0 _errno"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? EB 13 40 F9 68 05 40 B9 1F 91 0E 71 61 05 00 54 6C 3E 08 53 88 1D 00 53 68 C1 28 8B 6A 1E 00 12 09 65 40 39 29 04 10 36 48 1D 00 53 68 C1 28 8B 09 65 40 39 A9 03 18 36 9F 81 02 71 2B 18 80 52 28 10 80 52 68 21 88 1A 8B 01 08 4B 5F 7D 02 71 A3 00 00 54 69 45 00 11 48 F9 01 51 13 25 09 2A 09 00 00 14 E9 03 80 52 5F F9 01 71 08 04 80 52 28 91 88 1A 0C 20 84 52 49 01 08 4B 88 25 0B 0B 33 01 08 2A 28 24 84 52 68 02 08 4B A9 AB 8B 52 1F 01 09 6B A8 00 00 54 68 1E 00 12 09 85 00 51 3F 75 01 71 A9 00 00 54 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 13 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_138_0_0 {
	meta:
		name = "localeconv"
		size = 44
		refs = "0008 __acrt_getptd 0018 __acrt_update_locale_info"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? E1 43 00 91 08 48 40 F9 E8 0B 00 F9 ?? ?? ?? ?? E8 0B 40 F9 00 7D 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_139_0_0 {
	meta:
		name = "??$common_ftime_s@JU__timeb32@@@@YAHQEAU__timeb32@@@Z"
		size = 372
		refs = "0010 __security_push_cookie 0020 _errno 002c _invalid_parameter_noinfo 0038 __security_pop_cookie 004c __tzset 0058 _get_timezone 0084 __acrt_GetSystemTimePreciseAsFileTime 0090 ?elapsed_minutes_cache@@3JA 0094 ?dstflag_cache@@3HA 00a8 __imp_GetTimeZoneInformation 0154 _invoke_watson"
		altNames = "_ftime32_s"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 03 D1 13 00 00 91 93 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FF 03 03 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 ?? ?? ?? ?? E0 03 00 91 FF 03 00 B9 ?? ?? ?? ?? 20 07 00 35 EB 03 40 B9 68 08 00 18 E0 23 00 91 68 7D 28 9B 09 FD 60 D3 2B 01 0B 0B 68 7D 05 13 09 7D 48 0B 69 0E 00 79 ?? ?? ?? ?? E8 07 40 F9 69 06 00 58 ?? ?? ?? ?? ?? ?? ?? ?? 14 09 C9 9A ?? ?? ?? ?? 9F 02 09 6B 00 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E0 43 00 91 20 01 3F D6 1F 04 00 31 61 00 00 54 09 00 80 12 08 00 00 14 1F 08 00 71 01 01 00 54 E8 57 41 79 C8 00 00 34 E8 BB 40 B9 88 00 00 34 29 00 80 52 ?? ?? ?? ?? 03 00 00 14 09 00 80 52 ?? ?? ?? ?? E8 07 40 F9 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? 0A E2 84 D2 69 12 00 79 0A 09 CA 9A 0B 7D 80 D2 00 00 80 52 49 09 CB 9A 2A A9 0B 9B E9 01 00 58 09 01 09 8B 6A 0A 00 79 CA 01 00 58 29 09 CA 9A 69 02 00 B9 BE FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 00 46 C3 23 00 00 00 00 00 80 C1 2A 21 4E 62 FE 80 96 98 00 00 00 00 00 89 88 88 88 }
	condition:
		$1
}

rule file_139_1_0 {
	meta:
		name = "??$common_ftime_s@_JU__timeb64@@@@YAHQEAU__timeb64@@@Z"
		size = 380
		refs = "0010 __security_push_cookie 0020 _errno 002c _invalid_parameter_noinfo 0038 __security_pop_cookie 004c __tzset 0058 _get_timezone 0084 __acrt_GetSystemTimePreciseAsFileTime 0090 ?elapsed_minutes_cache@@3JA 0094 ?dstflag_cache@@3HA 00a8 __imp_GetTimeZoneInformation 0158 _invoke_watson"
		altNames = "_ftime64_s"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 03 D1 13 00 00 91 93 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FF 03 03 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 ?? ?? ?? ?? E0 03 00 91 FF 03 00 B9 ?? ?? ?? ?? 40 07 00 35 EB 03 40 B9 A8 08 00 18 E0 23 00 91 68 7D 28 9B 09 FD 60 D3 2B 01 0B 0B 68 7D 05 13 09 7D 48 0B 69 16 00 79 ?? ?? ?? ?? E8 07 40 F9 A9 06 00 58 ?? ?? ?? ?? ?? ?? ?? ?? 14 09 C9 9A ?? ?? ?? ?? 9F 02 09 6B 00 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E0 43 00 91 20 01 3F D6 1F 04 00 31 61 00 00 54 09 00 80 12 08 00 00 14 1F 08 00 71 01 01 00 54 E8 57 41 79 C8 00 00 34 E8 BB 40 B9 88 00 00 34 29 00 80 52 ?? ?? ?? ?? 03 00 00 14 09 00 80 52 ?? ?? ?? ?? E8 07 40 F9 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? 0A E2 84 D2 69 1A 00 79 0A 09 CA 9A 0B 7D 80 D2 00 00 80 52 49 09 CB 9A 2A A9 0B 9B 29 02 00 58 09 01 09 8B 6A 12 00 79 0A 02 00 58 29 09 CA 9A 2A 7D 40 93 6A 02 00 F9 BD FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 1F 20 03 D5 00 46 C3 23 00 00 00 00 00 80 C1 2A 21 4E 62 FE 80 96 98 00 00 00 00 00 89 88 88 88 }
	condition:
		$1
}

rule file_140_1_0 {
	meta:
		name = "cprojf"
		size = 164
		refs = "0010 crealf 0020 cimagf 002c _fdtest 0054 _FInf_C 0060 _FZero_C"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 E0 07 04 2D ?? ?? ?? ?? E1 27 40 BD E0 1B 00 BD E0 23 40 BD ?? ?? ?? ?? E0 63 00 91 E0 13 00 BD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 06 00 71 04 18 41 7A 80 00 00 54 F0 13 40 FD F0 13 00 FD 10 00 00 14 ?? ?? ?? ?? F1 03 27 1E ?? ?? ?? ?? ?? ?? ?? ?? E8 27 40 79 E9 83 00 91 F0 1B 00 BD ?? ?? ?? ?? 1F 01 11 72 E8 63 00 91 12 42 21 1E 52 1E 31 1E F2 1F 00 BD 08 01 40 F9 28 01 00 F9 E0 23 40 BD E1 27 40 BD FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_141_5_0 {
	meta:
		name = "_mbsnbcnt_l"
		size = 172
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0028 _errno 0034 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 14 01 00 B5 F3 00 00 B4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 13 00 00 14 8A 02 00 91 13 02 00 B4 EC 13 40 F9 48 01 40 39 4B 01 00 91 73 06 00 D1 68 01 00 34 08 01 0C 8B 09 65 40 39 89 00 10 36 4A 05 00 91 49 01 40 39 89 00 00 34 4A 05 00 91 73 00 00 B4 F4 FF FF 17 6A 01 00 91 40 01 14 CB E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_142_0_0 {
	meta:
		name = "??$common_tcscpy_s@D@@YAHQEAD_KQEBD@Z"
		size = 144
		refs = "0018 _errno 0024 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 1F 00 00 F1 24 18 40 FA E8 00 00 54 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 16 00 00 14 A2 00 00 B5 1F 00 00 39 ?? ?? ?? ?? D3 02 80 52 0C 00 00 14 09 00 00 91 4A 00 00 CB 48 69 E9 38 28 15 00 38 68 00 00 34 21 04 00 D1 81 FF FF B5 01 01 00 B5 1F 00 00 39 ?? ?? ?? ?? 53 04 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 02 00 00 14 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_142_1_0 {
	meta:
		name = "strcpy_s"
		size = 128
		refs = "0014 _errno 0020 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 1F 00 00 F1 24 18 40 FA E8 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 14 00 00 14 62 00 00 B5 1F 00 00 39 F8 FF FF 17 09 00 00 91 4A 00 00 CB 48 69 E9 38 28 15 00 38 68 00 00 34 21 04 00 D1 81 FF FF B5 01 01 00 B5 1F 00 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 02 00 00 14 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_0_0 {
	meta:
		name = "??$common_futime@JU__utimbuf32@@@@YAHHPEAU__utimbuf32@@@Z"
		size = 496
		refs = "0010 __security_push_cookie 0028 _errno 003c _nhandle 0050 __pioinfo 0078 _time32 0090 _localtime32_s 00a8 __imp_TzSpecificLocalTimeToSystemTime 00fc __imp_SystemTimeToFileTime 0198 _get_osfhandle 019c __imp_SetFileTime 01d0 _invalid_parameter_noinfo 01dc __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 01 D1 13 00 00 11 7F 0A 00 31 34 00 00 91 A1 00 00 54 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 68 00 00 14 73 0C F8 37 ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 08 6B E2 0B 00 54 69 7E 40 93 ?? ?? ?? ?? 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 09 19 09 8B 2A E1 40 39 CA 0A 00 36 D4 00 00 B5 E0 13 00 91 ?? ?? ?? ?? E8 07 40 B9 F4 03 00 91 E8 03 00 B9 81 12 00 91 E0 A3 00 91 ?? ?? ?? ?? 80 00 00 34 ?? ?? ?? ?? C8 02 80 52 E4 FF FF 17 EA 23 47 29 ?? ?? ?? ?? FF 4F 00 79 E9 63 40 79 E2 43 01 91 E1 63 00 91 00 00 80 D2 08 B1 1D 11 E8 33 00 79 48 05 00 11 EA 6B 40 79 E9 43 00 79 E9 53 40 79 E8 37 00 79 ?? ?? ?? ?? EA 3F 00 79 EA 5B 40 79 E9 4B 00 79 EA 47 00 79 09 FD DF C8 20 01 3F D6 00 FD FF 34 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E1 23 00 91 E0 43 01 91 20 01 3F D6 20 FC FF 34 81 02 00 91 E0 A3 00 91 ?? ?? ?? ?? A0 FB FF 35 EA 23 47 29 FF 4F 00 79 E2 43 01 91 E9 63 40 79 E1 63 00 91 00 00 80 D2 08 B1 1D 11 E8 33 00 79 48 05 00 11 EA 6B 40 79 E9 43 00 79 E9 53 40 79 E8 37 00 79 ?? ?? ?? ?? EA 3F 00 79 EA 5B 40 79 E9 4B 00 79 EA 47 00 79 09 FD DF C8 20 01 3F D6 00 F9 FF 34 ?? ?? ?? ?? 09 FD DF C8 E1 43 00 91 E0 43 01 91 20 01 3F D6 40 F8 FF 34 60 02 00 11 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E3 23 00 91 E2 43 00 91 01 00 80 D2 20 01 3F D6 00 F7 FF 34 00 00 80 52 06 00 00 14 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 FF 83 01 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_1_0 {
	meta:
		name = "??$common_futime@_JU__utimbuf64@@@@YAHHPEAU__utimbuf64@@@Z"
		size = 496
		refs = "0010 __security_push_cookie 0028 _errno 003c _nhandle 0050 __pioinfo 0078 _time64 0090 _localtime64_s 00a8 __imp_TzSpecificLocalTimeToSystemTime 00fc __imp_SystemTimeToFileTime 0198 _get_osfhandle 019c __imp_SetFileTime 01d0 _invalid_parameter_noinfo 01dc __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 01 D1 13 00 00 11 7F 0A 00 31 34 00 00 91 A1 00 00 54 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 68 00 00 14 73 0C F8 37 ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 08 6B E2 0B 00 54 69 7E 40 93 ?? ?? ?? ?? 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 09 19 09 8B 2A E1 40 39 CA 0A 00 36 D4 00 00 B5 E0 43 01 91 ?? ?? ?? ?? E8 2B 40 F9 F4 23 01 91 E8 27 00 F9 81 22 00 91 E0 83 00 91 ?? ?? ?? ?? 80 00 00 34 ?? ?? ?? ?? C8 02 80 52 E4 FF FF 17 EA 23 46 29 ?? ?? ?? ?? FF 3F 00 79 E9 53 40 79 E2 63 01 91 E1 43 00 91 00 00 80 D2 08 B1 1D 11 E8 23 00 79 48 05 00 11 EA 5B 40 79 E9 33 00 79 E9 43 40 79 E8 27 00 79 ?? ?? ?? ?? EA 2F 00 79 EA 4B 40 79 E9 3B 00 79 EA 37 00 79 09 FD DF C8 20 01 3F D6 00 FD FF 34 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E1 03 00 91 E0 63 01 91 20 01 3F D6 20 FC FF 34 81 02 00 91 E0 83 00 91 ?? ?? ?? ?? A0 FB FF 35 EA 23 46 29 FF 3F 00 79 E2 63 01 91 E9 53 40 79 E1 43 00 91 00 00 80 D2 08 B1 1D 11 E8 23 00 79 48 05 00 11 EA 5B 40 79 E9 33 00 79 E9 43 40 79 E8 27 00 79 ?? ?? ?? ?? EA 2F 00 79 EA 4B 40 79 E9 3B 00 79 EA 37 00 79 09 FD DF C8 20 01 3F D6 00 F9 FF 34 ?? ?? ?? ?? 09 FD DF C8 E1 23 00 91 E0 63 01 91 20 01 3F D6 40 F8 FF 34 60 02 00 11 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E3 03 00 91 E2 23 00 91 01 00 80 D2 20 01 3F D6 00 F7 FF 34 00 00 80 52 06 00 00 14 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 FF 83 01 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_2_0 {
	meta:
		name = "??$common_utime@JDU__utimbuf32@@@@YAHQEBDQEAU__utimbuf32@@@Z"
		size = 148
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 _sopen_s 0050 ??$common_futime@JU__utimbuf32@@@@YAHHPEAU__utimbuf32@@@Z 0070 _close"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 33 00 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 18 00 00 14 01 00 00 91 E0 43 00 91 04 00 80 52 03 08 80 52 42 00 90 52 ?? ?? ?? ?? 00 FF FF 35 E0 13 40 B9 61 02 00 91 ?? ?? ?? ?? 14 00 80 52 13 00 00 11 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 40 B9 E0 13 40 B9 ?? ?? ?? ?? 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 00 B9 60 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_3_0 {
	meta:
		name = "??$common_utime@J_WU__utimbuf32@@@@YAHQEB_WQEAU__utimbuf32@@@Z"
		size = 148
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 _wsopen_s 0050 ??$common_futime@JU__utimbuf32@@@@YAHHPEAU__utimbuf32@@@Z 0070 _close"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 33 00 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 18 00 00 14 01 00 00 91 E0 43 00 91 04 00 80 52 03 08 80 52 42 00 90 52 ?? ?? ?? ?? 00 FF FF 35 E0 13 40 B9 61 02 00 91 ?? ?? ?? ?? 14 00 80 52 13 00 00 11 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 40 B9 E0 13 40 B9 ?? ?? ?? ?? 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 00 B9 60 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_4_0 {
	meta:
		name = "??$common_utime@_JDU__utimbuf64@@@@YAHQEBDQEAU__utimbuf64@@@Z"
		size = 148
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 _sopen_s 0050 ??$common_futime@_JU__utimbuf64@@@@YAHHPEAU__utimbuf64@@@Z 0070 _close"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 33 00 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 18 00 00 14 01 00 00 91 E0 43 00 91 04 00 80 52 03 08 80 52 42 00 90 52 ?? ?? ?? ?? 00 FF FF 35 E0 13 40 B9 61 02 00 91 ?? ?? ?? ?? 14 00 80 52 13 00 00 11 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 40 B9 E0 13 40 B9 ?? ?? ?? ?? 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 00 B9 60 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_5_0 {
	meta:
		name = "??$common_utime@_J_WU__utimbuf64@@@@YAHQEB_WQEAU__utimbuf64@@@Z"
		size = 148
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 _wsopen_s 0050 ??$common_futime@_JU__utimbuf64@@@@YAHHPEAU__utimbuf64@@@Z 0070 _close"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 33 00 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 18 00 00 14 01 00 00 91 E0 43 00 91 04 00 80 52 03 08 80 52 42 00 90 52 ?? ?? ?? ?? 00 FF FF 35 E0 13 40 B9 61 02 00 91 ?? ?? ?? ?? 14 00 80 52 13 00 00 11 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 40 B9 E0 13 40 B9 ?? ?? ?? ?? 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 00 B9 60 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_16_0 {
	meta:
		name = "_utime32"
		size = 148
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 _sopen_s 0050 ??$common_futime@JU__utimbuf32@@@@YAHHPEAU__utimbuf32@@@Z 0070 _close"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 33 00 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 13 00 80 12 17 00 00 14 01 00 00 91 E0 43 00 91 04 00 80 52 03 08 80 52 42 00 90 52 ?? ?? ?? ?? 00 FF FF 35 E0 13 40 B9 61 02 00 91 ?? ?? ?? ?? 14 00 80 52 13 00 00 11 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 40 B9 E0 13 40 B9 ?? ?? ?? ?? 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 00 B9 60 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_17_0 {
	meta:
		name = "_utime64"
		size = 148
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 _sopen_s 0050 ??$common_futime@_JU__utimbuf64@@@@YAHHPEAU__utimbuf64@@@Z 0070 _close"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 33 00 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 13 00 80 12 17 00 00 14 01 00 00 91 E0 43 00 91 04 00 80 52 03 08 80 52 42 00 90 52 ?? ?? ?? ?? 00 FF FF 35 E0 13 40 B9 61 02 00 91 ?? ?? ?? ?? 14 00 80 52 13 00 00 11 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 40 B9 E0 13 40 B9 ?? ?? ?? ?? 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 00 B9 60 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_18_0 {
	meta:
		name = "_wutime32"
		size = 148
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 _wsopen_s 0050 ??$common_futime@JU__utimbuf32@@@@YAHHPEAU__utimbuf32@@@Z 0070 _close"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 33 00 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 13 00 80 12 17 00 00 14 01 00 00 91 E0 43 00 91 04 00 80 52 03 08 80 52 42 00 90 52 ?? ?? ?? ?? 00 FF FF 35 E0 13 40 B9 61 02 00 91 ?? ?? ?? ?? 14 00 80 52 13 00 00 11 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 40 B9 E0 13 40 B9 ?? ?? ?? ?? 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 00 B9 60 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_143_19_0 {
	meta:
		name = "_wutime64"
		size = 148
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 _wsopen_s 0050 ??$common_futime@_JU__utimbuf64@@@@YAHHPEAU__utimbuf64@@@Z 0070 _close"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 33 00 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 13 00 80 12 17 00 00 14 01 00 00 91 E0 43 00 91 04 00 80 52 03 08 80 52 42 00 90 52 ?? ?? ?? ?? 00 FF FF 35 E0 13 40 B9 61 02 00 91 ?? ?? ?? ?? 14 00 80 52 13 00 00 11 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 40 B9 E0 13 40 B9 ?? ?? ?? ?? 7F 06 00 31 61 00 00 54 ?? ?? ?? ?? 14 00 00 B9 60 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_145_1_0 {
	meta:
		name = "wctrans"
		size = 108
		refs = "0010 ?tab@@3QBUwctab@@B 0030 strcmp"
		altNames = "wctype"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 88 02 40 F9 15 00 00 91 13 00 80 52 28 01 00 B4 A1 02 00 91 00 01 00 91 ?? ?? ?? ?? 40 01 00 34 73 06 00 11 68 7E 7C D3 08 69 74 F8 28 FF FF B5 00 00 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 69 7E 7C D3 88 22 00 91 20 69 68 78 F9 FF FF 17 }
	condition:
		$1
}

rule file_146_0_0 {
	meta:
		name = "wcspbrk"
		size = 60
	strings:
		$1 = { 08 00 40 79 88 01 00 34 29 00 40 79 2B 00 00 91 E9 00 00 34 0C 00 40 79 2A 01 00 11 5F 01 0C 6B C0 00 00 54 6A 2D 40 78 AA FF FF 35 08 2C 40 78 E8 FE FF 35 00 00 80 D2 C0 03 5F D6 }
	condition:
		$1
}

rule file_147_7_0 {
	meta:
		name = "?_isindst_nolock@@YAHQEAUtm@@@Z"
		size = 684
		refs = "0024 _get_daylight 0050 ?dststart@@3Utransitiondate@?A0x7639d0b4@@A 0060 ?dstend@@3Utransitiondate@?A0x7639d0b4@@A 007c ?tz_api_used@@3HA 00c8 ?cvtdate@@YAXW4transition_type@?A0x7639d0b4@@W4date_type@2@HHHHHHHHH@Z 02a8 _invoke_watson"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 FF 83 00 D1 14 00 00 91 FF 33 00 B9 E0 C3 00 91 ?? ?? ?? ?? 60 13 00 35 E8 33 40 B9 08 01 00 35 00 00 80 52 FF 83 00 91 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 ?? ?? ?? ?? 82 16 40 B9 ?? ?? ?? ?? C8 02 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 5F 00 08 6B 81 00 00 54 A8 02 40 B9 5F 00 08 6B 40 0B 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 68 02 40 B9 E8 06 00 34 68 52 41 79 00 00 80 52 6A 6E 41 79 69 6A 41 79 67 62 41 79 63 56 41 79 68 01 00 35 68 66 41 79 06 00 80 52 EA 13 00 B9 65 5A 41 79 21 00 80 52 E9 0B 00 B9 64 5E 41 79 E8 03 00 B9 ?? ?? ?? ?? 0A 00 00 14 68 66 41 79 05 00 80 52 EA 13 00 B9 66 5E 41 79 04 00 80 52 E9 0B 00 B9 01 00 80 52 E8 03 00 B9 ?? ?? ?? ?? 68 AA 40 79 20 00 80 52 6A C6 40 79 69 C2 40 79 67 BA 40 79 63 AE 40 79 82 16 40 B9 68 01 00 35 68 BE 40 79 06 00 80 52 EA 13 00 B9 65 B2 40 79 21 00 80 52 E9 0B 00 B9 64 B6 40 79 E8 03 00 B9 ?? ?? ?? ?? 2A 00 00 14 68 BE 40 79 05 00 80 52 EA 13 00 B9 66 B6 40 79 04 00 80 52 E9 0B 00 B9 01 00 80 52 E8 03 00 B9 ?? ?? ?? ?? 20 00 00 14 63 00 80 52 44 00 80 52 73 01 80 52 37 00 80 52 5F AC 01 71 AA 00 00 54 83 00 80 52 24 00 80 52 53 01 80 52 B7 00 80 52 47 00 80 52 FF 0B 00 F9 06 00 80 52 FF 07 00 F9 05 00 80 52 FF 03 00 F9 21 00 80 52 00 00 80 52 ?? ?? ?? ?? 82 16 40 B9 47 00 80 52 06 00 80 52 FF 0B 00 F9 05 00 80 52 FF 07 00 F9 E4 02 00 11 FF 03 00 F9 63 02 00 11 21 00 80 52 20 00 80 52 ?? ?? ?? ?? A8 06 40 B9 CE 06 40 B9 8D 1E 40 B9 DF 01 08 6B 6A 01 00 54 BF 01 0E 6B EB F1 FF 54 BF 01 08 6B AC F1 FF 54 BF 01 0E 6B AD 01 00 54 BF 01 08 6B 6A 01 00 54 20 00 80 52 88 FF FF 17 BF 01 08 6B AB FF FF 54 BF 01 0E 6B 6C FF FF 54 BF 01 08 6B 6D 00 00 54 BF 01 0E 6B EB EF FF 54 89 0A 40 B9 BF 01 0E 6B 28 6D 1C 53 0B 01 09 4B 89 06 40 B9 2A 09 0B 0B 2B 09 0B 0B 89 02 40 B9 48 6D 1C 53 0C 01 0B 4B 08 7D 80 52 2A 09 0C 0B 4B 7D 08 1B A1 00 00 54 C8 0A 40 B9 7F 01 08 6B E0 B7 9F 1A 6E FF FF 17 A8 0A 40 B9 7F 01 08 6B E0 A7 9F 1A 6A FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_147_8_0 {
	meta:
		name = "?_set_daylight@@YAXH@Z"
		size = 36
		refs = "0010 __daylight"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 13 00 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_147_9_0 {
	meta:
		name = "?_set_dstbias@@YAXJ@Z"
		size = 36
		refs = "0010 __dstbias"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 13 00 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_147_10_0 {
	meta:
		name = "?_set_timezone@@YAXJ@Z"
		size = 36
		refs = "0010 __timezone"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 13 00 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_147_11_0 {
	meta:
		name = "?cvtdate@@YAXW4transition_type@?A0x7639d0b4@@W4date_type@2@HHHHHHHHH@Z"
		size = 608
		refs = "0044 ??$__crt_time_is_leap_year@H@@YA_NH@Z 0048 _lpdays 004c _days 0144 ?dststart@@3Utransitiondate@?A0x7639d0b4@@A 01a0 ?dstend@@3Utransitiondate@?A0x7639d0b4@@A 01e4 _get_dstbias 0254 _invoke_watson"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 55 00 00 11 FF 13 00 B9 19 00 00 11 A0 02 00 11 73 00 00 11 94 00 00 11 B6 00 00 11 D7 00 00 11 F8 00 00 11 3F 04 00 71 C1 06 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 69 06 00 51 60 00 00 34 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? 0A D9 69 B8 87 0F 00 18 A8 AE 04 11 08 7D 27 9B AD 06 00 51 09 FD 60 D3 A8 7D 27 9B 2B 7D 07 13 09 FD 60 D3 6C 7D 4B 0B 2B 7D 05 13 68 7D 4B 0B A9 7D 01 13 4F 05 00 11 AA 79 49 0B 8C 01 08 4B 88 09 8A 0B AB 2D 80 52 6A 7B 8C 52 A8 22 0B 1B EB 00 80 52 09 01 0F 0B 2A 01 0A 4B 48 0D CB 1A 0B A9 0B 1B 88 72 1D 53 09 01 14 4B 2A 01 0B 4B 7F 01 16 6B 4B 01 0F 0B 8C 00 00 54 68 01 16 0B 09 1D 00 51 02 00 00 14 69 01 16 0B 60 00 00 34 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? 0A D9 73 B8 9F 16 00 71 2E 01 4A 7A AD 01 00 54 29 1D 00 51 0B 00 00 14 ?? ?? ?? ?? 69 06 00 51 80 00 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 0A D9 69 B8 49 01 17 0B 19 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 89 05 00 B9 E9 63 40 B9 08 6F 1C 53 0A 01 18 4B 0D 7D 80 52 28 09 0A 0B 29 09 0A 0B EA 6B 40 B9 08 6D 1C 53 0B 01 09 4B E8 73 40 B9 49 09 0B 0B 28 21 0D 1B 88 09 00 B9 95 01 00 B9 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? 69 06 00 B9 E9 63 40 B9 08 6F 1C 53 0A 01 18 4B 0C 7D 80 52 E0 43 00 91 28 09 0A 0B 29 09 0A 0B EA 6B 40 B9 08 6D 1C 53 0B 01 09 4B E8 73 40 B9 49 09 0B 0B 28 21 0C 1B 68 0A 00 B9 ?? ?? ?? ?? C0 02 00 35 68 0A 40 B9 0A 7D 80 52 E9 13 40 B9 2A 21 0A 1B 08 03 00 18 6A 0A 00 B9 CA 00 F8 36 48 01 08 0B 68 0A 00 B9 69 06 40 B9 28 05 00 51 07 00 00 14 5F 01 08 6B CB 00 00 54 48 01 08 4B 68 0A 00 B9 69 06 40 B9 28 05 00 11 68 06 00 B9 75 02 00 B9 D3 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 1F 85 EB 51 00 5C 26 05 }
	condition:
		$1
}

rule file_147_14_0 {
	meta:
		name = "?get_tz_environment_variable@@YAPEADAEAY0BAA@D@Z"
		size = 156
		refs = "0014 ??_C@_02CLFPBFFP@TZ?$AA@ 0028 getenv_s 004c _malloc_base 0084 _free_base"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 61 02 00 91 02 20 80 D2 E0 43 00 91 ?? ?? ?? ?? 60 00 00 35 60 02 00 91 16 00 00 14 1F 88 00 71 60 00 00 54 00 00 80 D2 12 00 00 14 E0 0B 40 F9 ?? ?? ?? ?? 14 00 00 91 93 02 00 91 34 01 00 B4 E2 0B 40 F9 ?? ?? ?? ?? 81 02 00 91 E0 63 00 91 ?? ?? ?? ?? 60 00 00 35 13 00 80 D2 02 00 00 14 14 00 80 D2 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_147_16_0 {
	meta:
		name = "?tzset_from_environment_nolock@@YAXPEAD@Z"
		size = 680
		refs = "0014 __tzname 0024 _get_timezone 0030 _get_daylight 0038 ?last_tz@@3PEADEA 004c strcmp 0058 _free_base 007c _malloc_base 00b8 strcpy_s 00d4 strncpy_s 0108 atol 020c __timezone 0218 __daylight 0244 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 ?? ?? ?? ?? FF 7F 02 29 15 00 00 91 E0 43 00 91 ?? ?? ?? ?? 40 13 00 35 E0 53 00 91 ?? ?? ?? ?? 20 12 00 35 ?? ?? ?? ?? ?? ?? ?? ?? B4 00 00 B4 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 0E 00 34 80 02 00 91 ?? ?? ?? ?? 68 02 C0 39 6A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 13 CB 00 05 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 80 0C 00 B4 68 02 C0 39 6A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 13 CB 01 05 00 91 62 02 00 91 ?? ?? ?? ?? 20 0D 00 35 A0 02 40 F9 63 00 80 D2 62 02 00 91 01 08 80 D2 74 00 80 D2 ?? ?? ?? ?? 80 0B 00 35 68 02 C0 39 88 00 00 34 94 06 00 D1 73 06 00 91 94 FF FF B5 68 02 C0 39 1F B5 00 71 F4 17 9F 1A 54 00 00 34 73 06 00 91 60 02 00 91 ?? ?? ?? ?? 08 C2 81 52 0A 7C 08 1B EA 13 00 B9 68 02 C0 39 1F AD 00 71 A0 00 00 54 08 41 03 11 09 1D 00 53 3F 25 00 71 68 00 00 54 73 06 00 91 F8 FF FF 17 68 02 C0 39 1F E9 00 71 01 04 00 54 60 06 00 91 ?? ?? ?? ?? E9 13 40 B9 08 6C 1C 53 6B 1E C0 38 0A 01 00 4B 2A 09 0A 0B EA 13 00 B9 05 00 00 14 7F E5 00 71 AC 00 00 54 73 06 00 91 6B 02 C0 39 7F C1 00 71 6A FF FF 54 68 02 C0 39 1F E9 00 71 C1 01 00 54 73 06 00 91 60 02 00 91 ?? ?? ?? ?? E8 13 40 B9 0A 00 08 0B EA 13 00 B9 04 00 00 14 3F E5 00 71 AC 00 00 54 73 06 00 91 69 02 C0 39 3F C1 00 71 6A FF FF 54 74 00 00 34 E8 03 0A 4B E8 13 00 B9 68 02 C0 39 1F 01 00 71 E9 07 9F 1A E9 17 00 B9 09 01 00 34 A0 06 40 F9 63 00 80 D2 62 02 00 91 01 08 80 D2 ?? ?? ?? ?? 80 00 00 34 0D 00 00 14 A8 06 40 F9 1F 01 00 39 F3 13 40 B9 ?? ?? ?? ?? 13 00 00 B9 F3 17 40 B9 ?? ?? ?? ?? 13 00 00 B9 FD 7B C2 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_147_17_0 {
	meta:
		name = "?tzset_from_system_nolock@@YAXXZ"
		size = 512
		refs = "0010 __tzname 0024 _get_timezone 0030 _get_daylight 003c _get_dstbias 0044 ?last_tz@@3PEADEA 004c _free_base 0050 ?tz_api_used@@3HA 0058 __imp_GetTimeZoneInformation 00e4 ___lc_codepage_func 00e8 __imp_WideCharToMultiByte 0188 __timezone 0194 __daylight 01a0 __dstbias 01cc _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? FF 7F 02 29 13 00 00 91 FF 1B 00 B9 E0 43 00 91 ?? ?? ?? ?? 00 0E 00 35 E0 53 00 91 ?? ?? ?? ?? E0 0C 00 35 E0 63 00 91 ?? ?? ?? ?? C0 0B 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 80 42 00 91 20 01 3F D6 1F 04 00 31 80 08 00 54 89 12 40 B9 28 00 80 52 88 02 00 B9 8B 66 40 B9 28 6D 1C 53 09 01 09 4B 88 AE 40 79 2A 75 1E 53 EA 13 00 B9 A8 00 00 34 68 6D 1C 53 09 01 0B 4B 4A 09 09 0B EA 13 00 B9 88 56 41 79 68 01 00 34 88 BA 40 B9 28 01 00 34 29 00 80 52 E9 17 00 B9 09 01 0B 4B 28 6D 1C 53 09 01 09 4B 2A 75 1E 53 EA 1B 00 B9 02 00 00 14 FF FF 02 29 ?? ?? ?? ?? ?? ?? ?? ?? 64 02 40 F9 ?? ?? ?? ?? 09 FD DF C8 E7 73 00 91 06 00 80 D2 E5 07 80 52 03 00 80 12 82 52 00 91 01 00 80 52 15 00 00 11 20 01 3F D6 C0 00 00 34 E8 1F 40 B9 88 00 00 35 68 02 40 F9 1F FD 00 39 03 00 00 14 68 02 40 F9 1F 01 00 39 ?? ?? ?? ?? 64 06 40 F9 09 FD DF C8 E7 73 00 91 06 00 80 D2 E5 07 80 52 03 00 80 12 82 A2 01 91 01 00 80 52 A0 02 00 11 20 01 3F D6 C0 00 00 34 E8 1F 40 B9 88 00 00 35 68 06 40 F9 1F FD 00 39 03 00 00 14 68 06 40 F9 1F 01 00 39 F3 13 40 B9 ?? ?? ?? ?? 13 00 00 B9 F3 17 40 B9 ?? ?? ?? ?? 13 00 00 B9 F3 1B 40 B9 ?? ?? ?? ?? 13 00 00 B9 FD 7B C2 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_147_18_0 {
	meta:
		name = "?tzset_nolock@@YAXXZ"
		size = 236
		refs = "000c __security_push_cookie 0014 ?tz_api_used@@3HA 001c ??_C@_02CLFPBFFP@TZ?$AA@ 0024 ?dstend@@3Utransitiondate@?A0x7639d0b4@@A 0028 ?dststart@@3Utransitiondate@?A0x7639d0b4@@A 0044 getenv_s 0068 _malloc_base 0078 _free_base 00c4 ?tzset_from_environment_nolock@@YAXPEAD@Z 00cc ?tzset_from_system_nolock@@YAXXZ 00dc __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 04 D1 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 12 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 02 20 80 D2 E1 43 00 91 E0 03 00 91 ?? ?? ?? ?? 60 00 00 35 F4 43 00 91 16 00 00 14 1F 88 00 71 60 00 00 54 14 00 80 D2 12 00 00 14 E0 03 40 F9 ?? ?? ?? ?? 14 00 00 91 94 00 00 B5 00 00 80 D2 ?? ?? ?? ?? F8 FF FF 17 E2 03 40 F9 ?? ?? ?? ?? 81 02 00 91 E0 23 00 91 ?? ?? ?? ?? 60 00 00 34 80 02 00 91 F7 FF FF 17 00 00 80 D2 ?? ?? ?? ?? E8 43 00 91 9F 02 08 EB F3 03 94 9A D4 00 00 B4 88 02 C0 39 88 00 00 34 80 02 00 91 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? FF 43 04 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_147_19_0 {
	meta:
		name = "__tzset"
		size = 96
		refs = "000c ?first_time@?1??__tzset@@9@4JA 0020 __acrt_lock 0030 ?tzset_nolock@@YAXXZ 0050 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? BF 3B 03 D5 E8 01 00 35 C0 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? BF 3B 03 D5 08 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 49 FD 5F 88 29 05 00 11 49 FD 08 88 A8 FF FF 35 BF 3B 03 D5 C0 00 80 52 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_147_20_0 {
	meta:
		name = "__tzset$fin$0"
		size = 32
		refs = "000c __acrt_unlock"
		altNames = "_isindst$fin$0 _tzset$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 C0 00 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_147_22_0 {
	meta:
		name = "_isindst"
		size = 64
		refs = "0014 __acrt_lock 001c ?_isindst_nolock@@YAHQEAUtm@@@Z 0028 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 C0 00 80 52 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 13 00 00 11 C0 00 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_147_24_0 {
	meta:
		name = "_tzset"
		size = 40
		refs = "000c __acrt_lock 0010 ?tzset_nolock@@YAXXZ 0018 __acrt_unlock"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 C0 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? C0 00 80 52 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_148_7_0 {
	meta:
		name = "?__acrt_stdio_allocate_stream@@YA?AV__crt_stdio_stream@@XZ"
		size = 104
		refs = "0018 __acrt_lock 0020 ?find_or_allocate_unused_stream_nolock@@YA?AV__crt_stdio_stream@@XZ 0050 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 91 7F 02 00 F9 00 01 80 52 ?? ?? ?? ?? A0 43 00 91 ?? ?? ?? ?? 08 00 40 F9 68 02 00 F9 08 01 00 B4 1F 11 00 B9 1F 15 00 F9 09 01 00 91 3F 01 00 F9 1F 05 00 F9 0A 00 80 12 2A 19 00 B9 00 01 80 52 ?? ?? ?? ?? 60 02 00 91 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_148_9_0 {
	meta:
		name = "?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z"
		size = 88
	strings:
		$1 = { FF 43 00 D1 E0 03 00 F9 1F 00 00 F9 E8 03 40 F9 1F 05 00 F9 E9 03 40 F9 3F 11 00 B9 E8 03 40 F9 09 00 80 12 09 19 00 B9 E8 03 40 F9 1F 1D 00 B9 E9 03 40 F9 3F 21 00 B9 E8 03 40 F9 1F 15 00 F9 E9 03 40 F9 28 51 00 91 1F FD 9F 88 BF 3B 03 D5 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_148_11_0 {
	meta:
		name = "?deallocate@__crt_stdio_stream@@QEAAXXZ"
		size = 20
	strings:
		$1 = { 08 00 40 F9 09 51 00 91 3F FD 9F 88 BF 3B 03 D5 C0 03 5F D6 }
	condition:
		$1
}

rule file_148_13_0 {
	meta:
		name = "?find_or_allocate_unused_stream_nolock@@YA?AV__crt_stdio_stream@@XZ"
		size = 252
		refs = "0010 __piob 0014 _nstream 0050 _lock_file 0074 _unlock_file 0084 _calloc_base 0090 _free_base 00b4 __acrt_InitializeCriticalSectionEx"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 14 00 00 91 15 61 00 91 28 0D 00 D1 B6 0E 08 8B BF 02 16 EB 80 05 00 54 B3 86 40 F8 13 02 00 B4 6A 16 40 B9 BF 3B 03 D5 4A FF 6F 37 60 02 00 91 ?? ?? ?? ?? 6A 52 00 91 4B FD 5F 88 68 01 13 32 48 FD 09 88 A9 FF FF 35 BF 3B 03 D5 8B 03 68 36 60 02 00 91 ?? ?? ?? ?? EE FF FF 17 01 0B 80 D2 20 00 80 D2 ?? ?? ?? ?? A0 82 1F F8 00 00 80 D2 ?? ?? ?? ?? A8 82 5F F8 68 02 00 B4 09 00 80 12 09 19 00 B9 A8 82 5F F8 02 00 80 52 01 F4 81 52 00 C1 00 91 ?? ?? ?? ?? B3 82 5F F8 6A 52 00 91 49 FD 5F 88 29 01 13 32 49 FD 08 88 A8 FF FF 35 BF 3B 03 D5 60 02 00 91 ?? ?? ?? ?? 93 02 00 F9 02 00 00 14 9F 02 00 F9 80 02 00 91 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_148_19_0 {
	meta:
		name = "?try_allocate@__crt_stdio_stream@@QEAA_NXZ"
		size = 40
	strings:
		$1 = { 08 00 40 F9 0B 51 00 91 6C FD 5F 88 89 01 13 32 69 FD 0A 88 AA FF FF 35 BF 3B 03 D5 E8 37 6C 2A 00 01 00 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_149_4_0 {
	meta:
		name = "_towlower_l"
		size = 208
		refs = "0024 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0068 iswctype 009c __acrt_LCMapStringW"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E8 FF 9F 52 E0 23 00 79 1F 00 08 6B 61 00 00 54 E0 FF 9F 52 2B 00 00 14 E0 63 00 91 ?? ?? ?? ?? E8 13 40 F9 09 9D 40 F9 49 01 00 B5 EA 23 40 79 E8 F7 9F 52 48 01 08 0B 09 3D 00 53 3F 65 00 71 48 00 00 54 4A 81 00 11 40 3D 00 53 17 00 00 14 E0 23 40 79 1F 00 04 71 22 01 00 54 21 00 80 52 ?? ?? ?? ?? C0 01 00 34 E8 13 40 F9 E9 23 40 79 08 89 40 F9 00 69 69 38 0C 00 00 14 25 00 80 52 E4 4B 00 91 23 00 80 52 E2 43 00 91 01 20 80 52 20 01 00 91 ?? ?? ?? ?? 60 00 00 35 E0 23 40 79 02 00 00 14 E0 27 40 79 E8 C3 40 39 A8 00 00 34 EA 0F 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_150_1_0 {
	meta:
		name = "??$thread_start@P6AIPEAX@Z@@YAKQEAX@Z"
		size = 144
		refs = "0014 __imp_GetLastError 0024 __imp_ExitThread 0034 __acrt_getptd 003c __acrt_get_begin_thread_init_policy 004c __acrt_RoInitialize 0068 __guard_check_icall_fptr 007c _endthreadex 0080 _exit"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 33 01 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? 13 E0 01 F9 ?? ?? ?? ?? 1F 08 00 71 C1 00 00 54 20 00 80 52 ?? ?? ?? ?? 1F 00 00 71 E8 17 9F 1A 68 82 00 39 74 02 40 F9 73 06 40 F9 8F 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 60 02 00 91 80 02 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_150_2_0 {
	meta:
		name = "?filt$0@?0???$thread_start@P6AIPEAX@Z@@YAKQEAX@Z@4HA"
		size = 40
		refs = "0014 _seh_filter_exe"
		altNames = "?filt$0@?0???$thread_start@P6AXPEAX@Z@@YAKQEAX@Z@4HA"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 01 00 00 91 28 00 40 F9 00 01 40 B9 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_150_3_0 {
	meta:
		name = "??$thread_start@P6AXPEAX@Z@@YAKQEAX@Z"
		size = 152
		refs = "0014 __imp_GetLastError 0024 __imp_ExitThread 0034 __acrt_getptd 003c __acrt_get_begin_thread_init_policy 004c __acrt_RoInitialize 0068 __guard_check_icall_fptr 0080 _endthreadex 0084 _exit"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 33 01 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? 13 E0 01 F9 ?? ?? ?? ?? 1F 08 00 71 C1 00 00 54 20 00 80 52 ?? ?? ?? ?? 1F 00 00 71 E8 17 9F 1A 68 82 00 39 74 02 40 F9 73 06 40 F9 8F 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 60 02 00 91 80 02 3F D6 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_150_8_0 {
	meta:
		name = "??1?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEAA@XZ"
		size = 96
		refs = "0020 __imp_CloseHandle 0038 __imp_FreeLibrary 004c _free_base"
		altNames = "?release@?$__crt_unique_heap_ptr@U__acrt_thread_parameter@@Uthread_parameter_free_policy@?A0x4e93fcdd@@@@QEAAXXZ"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 93 02 40 F9 F3 01 00 B4 60 0A 40 F9 A0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 60 0E 40 F9 A0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 60 02 00 91 ?? ?? ?? ?? 9F 02 00 F9 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_150_10_0 {
	meta:
		name = "??Rthread_parameter_free_policy@?A0x4e93fcdd@@QEAAXQEAU__acrt_thread_parameter@@@Z"
		size = 88
		refs = "001c __imp_CloseHandle 0034 __imp_FreeLibrary 0048 _free_base"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 33 00 00 91 F3 01 00 B4 60 0A 40 F9 A0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 60 0E 40 F9 A0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_150_11_0 {
	meta:
		name = "?common_end_thread@@YAXI@Z"
		size = 172
		refs = "0010 __acrt_getptd_noexit 0018 __imp_ExitThread 0050 __acrt_RoUninitialize 0064 __imp_CloseHandle 0084 __imp_FreeLibraryAndExitThread"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 11 ?? ?? ?? ?? C0 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 80 02 00 11 20 01 3F D6 13 E0 41 F9 D3 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 80 02 00 11 20 01 3F D6 68 82 40 39 48 00 00 34 ?? ?? ?? ?? 60 0A 40 F9 08 04 00 D1 1F 0D 00 B1 A8 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 60 0E 40 F9 08 04 00 D1 1F 0D 00 B1 C8 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 81 02 00 11 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 80 02 00 11 20 01 3F D6 }
	condition:
		$1
}

rule file_150_12_0 {
	meta:
		name = "?create_thread_parameter@@YAPEAU__acrt_thread_parameter@@QEAX0@Z"
		size = 112
		refs = "0020 _calloc_base 002c _free_base 003c __imp_GetModuleHandleExW"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 35 00 00 91 01 05 80 D2 20 00 80 D2 ?? ?? ?? ?? 13 00 00 91 00 00 80 D2 ?? ?? ?? ?? 73 00 00 B5 13 00 80 D2 09 00 00 14 ?? ?? ?? ?? 74 56 00 A9 ?? ?? ?? ?? 09 FD DF C8 62 62 00 91 81 02 00 91 80 00 80 52 20 01 3F D6 60 02 00 91 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_150_16_0 {
	meta:
		name = "?invoke_thread_procedure@@YAIQ6AIPEAX@ZQEAX@Z"
		size = 56
		refs = "000c __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 14 00 00 91 8F 02 00 91 33 00 00 91 00 01 3F D6 60 02 00 91 80 02 3F D6 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_150_17_0 {
	meta:
		name = "?invoke_thread_procedure@@YAIQ6AXPEAX@ZQEAX@Z"
		size = 60
		refs = "000c __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 14 00 00 91 8F 02 00 91 33 00 00 91 00 01 3F D6 60 02 00 91 80 02 3F D6 00 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_150_21_0 {
	meta:
		name = "_beginthread"
		size = 276
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0030 ?create_thread_parameter@@YAPEAU__acrt_thread_parameter@@QEAX0@Z 0040 ??$thread_start@P6AXPEAX@Z@@YAKQEAX@Z 004c __imp_CreateThread 0078 __imp_GetLastError 0088 __acrt_errno_map_os_error 00a0 __imp_CloseHandle 00bc __imp_FreeLibrary 00d4 _free_base 00e8 __imp_ResumeThread"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 34 7C 40 D3 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 2D 00 00 14 41 00 00 91 ?? ?? ?? ?? 13 00 00 91 F3 0F 00 F9 B3 02 00 B4 ?? ?? ?? ?? FF 13 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E5 43 00 91 84 00 80 52 63 02 00 91 81 02 00 91 00 00 80 D2 20 01 3F D6 14 00 00 91 B4 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? F3 0F 40 F9 14 00 80 92 33 02 00 B4 60 0A 40 F9 C0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 F3 0F 40 F9 60 0E 40 F9 C0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 F3 0F 40 F9 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 ?? ?? ?? ?? 74 0A 00 F9 ?? ?? ?? ?? 09 FD DF C8 80 02 00 91 20 01 3F D6 1F 04 00 31 A0 FB FF 54 13 00 80 D2 FF 0F 00 F9 E1 FF FF 17 }
	condition:
		$1
}

rule file_150_22_0 {
	meta:
		name = "_beginthreadex"
		size = 276
		refs = "0024 _errno 0030 _invalid_parameter_noinfo 0044 ?create_thread_parameter@@YAPEAU__acrt_thread_parameter@@QEAX0@Z 0050 ??$thread_start@P6AIPEAX@Z@@YAKQEAX@Z 0058 __imp_CreateThread 0084 __imp_GetLastError 0094 __acrt_errno_map_os_error 00ac __imp_CloseHandle 00cc __imp_FreeLibrary 00e4 _free_base"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BE A9 FD 03 00 91 14 00 00 91 35 7C 40 D3 96 00 00 11 B3 00 00 91 E2 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 2D 00 00 14 61 00 00 91 40 00 00 91 ?? ?? ?? ?? E0 0F 00 F9 80 02 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 03 00 00 91 E5 43 00 91 C4 02 00 11 A1 02 00 91 80 02 00 91 20 01 3F D6 14 00 00 91 F4 03 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E0 0F 40 F9 14 00 80 D2 40 02 00 B4 08 08 40 F9 E8 00 00 B4 ?? ?? ?? ?? 00 01 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 0F 40 F9 08 0C 40 F9 E8 00 00 B4 ?? ?? ?? ?? 00 01 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 0F 40 F9 ?? ?? ?? ?? 80 02 00 91 FD 7B C2 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 73 00 00 B4 E8 13 40 B9 68 02 00 B9 00 00 80 D2 FF 0F 00 F9 E4 FF FF 17 }
	condition:
		$1
}

rule file_151_0_0 {
	meta:
		name = "__acrt_errno_from_os_error"
		size = 100
		refs = "0000 ?errtable@@3QBUerrentry@?A0x31fdb9ec@@B"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 09 00 80 52 28 7D 7D D3 08 69 6A B8 1F 00 08 6B E0 01 00 54 29 05 00 11 3F B1 00 71 43 FF FF 54 08 4C 00 51 1F 45 00 71 68 00 00 54 A0 01 80 52 0A 00 00 14 08 F0 02 51 1F 39 00 71 0A 01 80 52 C9 02 80 52 40 91 89 1A 04 00 00 14 29 7D 7D D3 48 11 00 91 20 69 68 B8 C0 03 5F D6 }
	condition:
		$1
}

rule file_151_1_0 {
	meta:
		name = "__acrt_errno_map_os_error"
		size = 56
		refs = "0010 __doserrno 001c __acrt_errno_from_os_error 0024 _errno"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 13 00 00 B9 60 02 00 11 ?? ?? ?? ?? 13 00 00 11 ?? ?? ?? ?? 13 00 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_151_4_0 {
	meta:
		name = "_get_doserrno"
		size = 60
		refs = "0014 _invalid_parameter_noinfo 0020 __doserrno"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 93 00 00 B5 ?? ?? ?? ?? C0 02 80 52 05 00 00 14 ?? ?? ?? ?? 08 00 40 B9 00 00 80 52 68 02 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_151_5_0 {
	meta:
		name = "_get_errno"
		size = 60
		refs = "0014 _invalid_parameter_noinfo 0020 _errno"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 93 00 00 B5 ?? ?? ?? ?? C0 02 80 52 05 00 00 14 ?? ?? ?? ?? 08 00 40 B9 00 00 80 52 68 02 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_151_6_0 {
	meta:
		name = "_set_doserrno"
		size = 56
		refs = "0010 __acrt_getptd_noexit 0020 __doserrno"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 60 00 00 B5 80 01 80 52 04 00 00 14 ?? ?? ?? ?? 13 00 00 B9 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_151_7_0 {
	meta:
		name = "_set_errno"
		size = 56
		refs = "0010 __acrt_getptd_noexit 0020 _errno"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 60 00 00 B5 80 01 80 52 04 00 00 14 ?? ?? ?? ?? 13 00 00 B9 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_152_0_0 {
	meta:
		name = "_putw"
		size = 168
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 0048 _lock_file 0068 _fputc_nolock 0078 ferror 0088 _unlock_file"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 15 00 00 11 B5 13 00 B9 33 00 00 91 B3 13 00 F9 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 15 00 00 14 17 00 80 12 60 02 00 91 ?? ?? ?? ?? B6 53 00 91 B4 43 00 91 B4 0F 00 F9 9F 02 16 EB C0 00 00 54 80 02 C0 39 61 02 00 91 ?? ?? ?? ?? 94 06 00 91 F9 FF FF 17 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 B4 02 97 1A 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_152_1_0 {
	meta:
		name = "_putw$fin$0"
		size = 32
		refs = "000c _unlock_file"
		altNames = "_getw$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A0 13 40 F9 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_153_3_0 {
	meta:
		name = "?_wcrtomb_s_l@@YAHQEAHQEAD_K_WQEAU_Mbstatet@@QEAU__crt_locale_pointers@@@Z"
		size = 248
		refs = "002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0064 __imp_WideCharToMultiByte 00c0 _errno"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BC A9 FD 03 00 91 13 00 00 91 E3 23 00 79 35 00 00 91 A1 00 00 91 E0 63 00 91 56 00 00 91 94 00 00 91 ?? ?? ?? ?? 54 00 00 B4 9F 02 00 B9 E9 13 40 F9 28 9D 40 F9 28 01 00 B5 E8 23 40 79 1F FD 03 71 48 03 00 54 A8 02 00 39 D3 02 00 B4 28 00 80 52 68 02 00 B9 13 00 00 14 ?? ?? ?? ?? FF 17 00 B9 20 0D 40 B9 ?? ?? ?? ?? 09 FD DF C8 C5 02 00 11 E7 53 00 91 06 00 80 D2 A4 02 00 91 23 00 80 52 E2 43 00 91 01 00 80 52 20 01 3F D6 E0 00 00 34 E8 17 40 B9 A8 00 00 35 53 00 00 B4 60 02 00 B9 00 00 80 52 08 00 00 14 73 00 00 B4 08 00 80 12 68 02 00 B9 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 40 05 80 52 E8 C3 40 39 A8 00 00 34 EA 0F 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C4 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_153_5_0 {
	meta:
		name = "internal_wcsrtombs"
		size = 440
		refs = "001c __security_push_cookie 0038 _errno 0044 _invalid_parameter_noinfo 0064 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00a0 ?_wcrtomb_s_l@@YAHQEAHQEAD_K_WQEAU_Mbstatet@@QEAU__crt_locale_pointers@@@Z 0138 memcpy 0198 __security_pop_cookie"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 2B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 00 D1 14 00 00 91 38 00 00 91 57 00 00 91 7A 00 00 91 F8 00 00 B5 ?? ?? ?? ?? D9 02 80 52 19 00 00 B9 ?? ?? ?? ?? 00 00 80 92 52 00 00 14 01 00 80 D2 16 03 40 F9 FF 03 00 B9 E0 23 00 91 13 00 80 D2 ?? ?? ?? ?? D4 02 00 B5 C3 02 40 79 07 00 00 14 28 05 00 51 EA A3 00 91 48 C9 E8 38 C8 01 00 34 C3 2E 40 78 73 C2 29 8B E5 43 00 91 44 03 00 91 A2 00 80 D2 E1 A3 00 91 E0 03 00 91 ?? ?? ?? ?? E9 03 40 B9 3F 01 00 71 4C FE FF 54 13 00 80 92 31 00 00 14 68 C2 29 8B 2B 00 00 14 B7 05 00 B4 D9 02 80 52 E9 0B 40 F9 EA A3 00 91 C3 02 40 79 E5 43 00 91 44 03 00 91 A2 00 80 D2 28 09 40 B9 E0 03 00 91 FF C2 28 EB 5B 31 94 9A 61 03 00 91 ?? ?? ?? ?? F5 03 40 B9 BF 02 00 71 8D 03 00 54 9F 02 1B EB A0 01 00 54 FF C2 35 EB 23 03 00 54 A2 7E 40 93 22 01 00 B4 B4 00 00 B5 ?? ?? ?? ?? 19 00 00 B9 ?? ?? ?? ?? 04 00 00 14 E1 A3 00 91 80 02 00 91 ?? ?? ?? ?? A8 06 00 51 89 CA E8 38 E9 00 00 34 73 C2 35 8B D6 0A 00 91 94 C2 35 8B F7 C2 35 CB 97 FB FF B5 06 00 00 14 1F 03 00 F9 68 C2 35 8B 13 05 00 D1 03 00 00 14 13 00 80 92 16 03 00 F9 E8 83 40 39 A8 00 00 34 EA 07 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 91 FF C3 00 91 ?? ?? ?? ?? FB 2B 40 F9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_153_7_0 {
	meta:
		name = "wcrtomb"
		size = 60
		refs = "002c wcrtomb_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 1F 00 00 F1 A9 00 80 D2 23 00 00 11 01 00 00 91 44 00 00 91 08 00 80 92 E2 03 89 9A E8 0B 00 F9 E0 43 00 91 ?? ?? ?? ?? E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_153_8_0 {
	meta:
		name = "wcrtomb_s"
		size = 120
		refs = "000c __security_push_cookie 0020 _errno 002c _invalid_parameter_noinfo 0054 ?_wcrtomb_s_l@@YAHQEAHQEAD_K_WQEAU_Mbstatet@@QEAU__crt_locale_pointers@@@Z 0068 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 0B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 13 00 00 91 01 01 00 B5 E2 00 00 B4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 0C 00 00 14 08 00 80 12 E8 03 00 B9 05 00 80 D2 E0 03 00 91 61 00 00 B5 A2 00 80 D2 E1 23 00 91 ?? ?? ?? ?? 73 00 00 B4 E8 03 80 B9 68 02 00 F9 FF 43 00 91 ?? ?? ?? ?? F3 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_153_10_0 {
	meta:
		name = "wcsrtombs_s"
		size = 220
		refs = "003c _errno 0048 _invalid_parameter_noinfo 006c internal_wcsrtombs"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 33 00 00 91 61 00 00 91 14 00 00 91 55 00 00 91 74 00 00 B4 08 00 80 92 88 02 00 F9 73 00 00 B5 55 01 00 B4 02 00 00 14 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 1F 00 00 14 7F 02 00 39 21 FF FF B4 9F 00 15 EB A2 82 84 9A A3 00 00 91 60 02 00 91 ?? ?? ?? ?? 1F 04 00 B1 C1 00 00 54 53 00 00 B4 7F 02 00 39 ?? ?? ?? ?? 00 00 40 B9 11 00 00 14 09 04 00 91 93 01 00 B4 3F 01 15 EB 09 01 00 54 7F 02 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 06 00 00 14 28 01 13 8B 1F F1 1F 38 54 00 00 B4 89 02 00 F9 00 00 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_153_11_0 {
	meta:
		name = "wctob"
		size = 108
		refs = "0008 __security_push_cookie 003c ?_wcrtomb_s_l@@YAHQEAHQEAD_K_WQEAU_Mbstatet@@QEAU__crt_locale_pointers@@@Z 0060 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 E8 FF 9F 52 1F 00 08 6B 00 02 00 54 08 00 80 12 03 00 00 11 E8 03 00 B9 E0 03 00 91 05 00 80 D2 04 00 80 D2 A2 00 80 D2 E1 23 00 91 ?? ?? ?? ?? E8 03 40 B9 1F 00 00 71 00 09 41 7A 61 00 00 54 E0 23 C0 39 02 00 00 14 00 00 80 12 FF 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_154_0_0 {
	meta:
		name = "_getdiskfree"
		size = 236
		refs = "000c __security_push_cookie 0018 _errno 0024 _invalid_parameter_noinfo 0080 __imp_GetDiskFreeSpaceW 00a8 __imp_GetLastError 00bc __acrt_errno_from_os_error 00dc __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 E1 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? E0 0A 80 52 2B 00 00 14 1F 68 00 71 28 FF FF 54 E8 03 00 91 FF 2F 00 79 E9 03 00 91 1F 7D 00 A9 28 25 40 A9 EA 0B 80 52 1F 00 00 71 EA 23 00 79 28 24 00 A9 48 07 80 52 E8 27 00 79 89 0B 80 52 E8 43 00 91 E9 2B 00 79 EA 03 88 9A 60 00 00 34 08 00 01 11 E8 23 00 79 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 24 00 00 91 23 10 00 91 22 30 00 91 21 20 00 91 40 01 00 91 20 01 3F D6 80 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 14 00 00 11 ?? ?? ?? ?? 13 00 00 11 ?? ?? ?? ?? 13 00 00 B9 80 02 00 11 02 00 00 14 00 00 80 52 FF 43 00 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_155_16_0 {
	meta:
		name = "__acrt_copy_path_to_wide_string"
		size = 280
		refs = "0020 _errno 002c _invalid_parameter_noinfo 003c __acrt_AreFileApisANSI 0040 __imp_MultiByteToWideChar 007c __imp_GetLastError 008c __acrt_errno_map_os_error 0098 _malloc_base 00ec _free_base"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BE A9 FD 03 00 91 15 00 00 91 34 00 00 91 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 30 00 00 14 54 FF FF B4 ?? ?? ?? ?? ?? ?? ?? ?? 9F 02 00 F9 ?? ?? ?? ?? 1F 00 00 71 09 FD DF C8 F7 17 9F 1A 05 00 80 52 04 00 80 D2 03 00 80 12 A2 02 00 91 01 00 80 52 E0 02 00 11 20 01 3F D6 16 00 00 11 F6 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E8 FF FF 17 C0 7E 7F 93 ?? ?? ?? ?? 13 00 00 91 E0 0B 00 F9 33 02 00 B4 ?? ?? ?? ?? 09 FD DF C8 C5 02 00 11 64 02 00 91 03 00 80 12 A2 02 00 91 01 00 80 52 E0 02 00 11 20 01 3F D6 E0 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E0 0B 40 F9 13 00 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C2 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 93 02 00 F9 00 00 80 D2 33 00 80 52 F6 FF FF 17 }
	condition:
		$1
}

rule file_155_17_0 {
	meta:
		name = "__acrt_copy_to_char"
		size = 296
		refs = "0020 _errno 002c _invalid_parameter_noinfo 003c __acrt_AreFileApisANSI 0040 __imp_WideCharToMultiByte 0084 __imp_GetLastError 0094 __acrt_errno_map_os_error 00a0 _malloc_base 00fc _free_base"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BE A9 FD 03 00 91 15 00 00 91 34 00 00 91 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 34 00 00 14 54 FF FF B4 ?? ?? ?? ?? ?? ?? ?? ?? 9F 02 00 F9 ?? ?? ?? ?? 1F 00 00 71 09 FD DF C8 F7 17 9F 1A 07 00 80 D2 06 00 80 D2 05 00 80 52 04 00 80 D2 03 00 80 12 A2 02 00 91 01 00 80 52 E0 02 00 11 20 01 3F D6 16 7C 40 93 F6 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E6 FF FF 17 C0 02 00 91 ?? ?? ?? ?? 13 00 00 91 E0 0B 00 F9 73 02 00 B4 ?? ?? ?? ?? 09 FD DF C8 C5 02 00 11 07 00 80 D2 06 00 80 D2 64 02 00 91 03 00 80 12 A2 02 00 91 01 00 80 52 E0 02 00 11 20 01 3F D6 E0 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E0 0B 40 F9 13 00 80 52 ?? ?? ?? ?? 60 02 00 11 FD 7B C2 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 93 02 00 F9 00 00 80 D2 33 00 80 52 F6 FF FF 17 }
	condition:
		$1
}

rule file_156_6_0 {
	meta:
		name = "??0__acrt_stdio_temporary_buffering_guard@@QEAA@QEAU_iobuf@@@Z"
		size = 48
		refs = "0018 __acrt_stdio_begin_temporary_buffering_nolock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 20 00 00 91 61 02 00 F9 ?? ?? ?? ?? 60 22 00 39 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_156_11_0 {
	meta:
		name = "_putws"
		size = 96
		refs = "0010 _errno 001c _invalid_parameter_noinfo 002c __acrt_iob_func 0054 ??$?RV<lambda_2f83a2a1986a37a798595b5ae3dfb15a>@@AEAV<lambda_65123f7c9d6f4a18edfa2b860f737003>@@V<lambda_39f88bc36d3cf8c3d3f84f87ff1ba7e6>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_2f83a2a1986a37a798595b5ae3dfb15a>@@AEAV<lambda_65123f7c9d6f4a18edfa2b860f737003>@@$$QEAV<lambda_39f88bc36d3cf8c3d3f84f87ff1ba7e6>@@@Z"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 13 00 F9 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? E0 FF 9F 52 0D 00 00 14 20 00 80 52 ?? ?? ?? ?? E8 63 00 91 E0 0F 00 F9 E9 83 00 91 E0 83 02 A9 E3 A3 00 91 E0 43 00 91 E8 A7 03 A9 E2 E3 00 91 E1 C3 00 91 ?? ?? ?? ?? FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_157_0_0 {
	meta:
		name = "??$common_dupenv_s@D@@YAHQEAPEADQEA_KQEBDH2H@Z"
		size = 248
		refs = "0020 __acrt_lock 0028 _errno 0034 _invalid_parameter_noinfo 0054 ??$common_getenv_nolock@D@@YAPEADQEBD@Z 0084 calloc 00ac strcpy_s 00c4 __acrt_unlock 00e4 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 15 00 00 91 33 00 00 91 54 00 00 91 60 01 80 52 ?? ?? ?? ?? F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? D3 02 80 52 21 00 00 14 BF 02 00 F9 53 00 00 B4 7F 02 00 F9 F4 FE FF B4 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 14 03 00 B4 89 02 00 91 28 01 C0 39 68 00 00 34 29 05 00 91 FD FF FF 17 28 01 14 CB 16 05 00 91 21 00 80 D2 C0 02 00 91 ?? ?? ?? ?? A0 02 00 F9 C0 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 93 01 80 52 08 00 00 14 82 02 00 91 C1 02 00 91 ?? ?? ?? ?? 00 01 00 35 53 00 00 B4 76 02 00 F9 13 00 80 52 60 01 80 52 ?? ?? ?? ?? 60 02 00 11 07 00 00 14 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_157_2_0 {
	meta:
		name = "??$common_dupenv_s@_W@@YAHQEAPEA_WQEA_KQEB_WHQEBDH@Z"
		size = 256
		refs = "0020 __acrt_lock 0028 _errno 0034 _invalid_parameter_noinfo 0054 ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 0088 calloc 00b0 wcscpy_s 00c8 __acrt_unlock 00e8 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 15 00 00 91 33 00 00 91 54 00 00 91 60 01 80 52 ?? ?? ?? ?? F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? D3 02 80 52 22 00 00 14 BF 02 00 F9 53 00 00 B4 7F 02 00 F9 F4 FE FF B4 80 02 00 91 ?? ?? ?? ?? 14 00 00 91 34 03 00 B4 89 02 00 91 28 01 C0 79 68 00 00 34 29 09 00 91 FD FF FF 17 28 01 14 CB 09 FD 41 93 36 05 00 91 41 00 80 D2 C0 02 00 91 ?? ?? ?? ?? A0 02 00 F9 C0 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 93 01 80 52 08 00 00 14 82 02 00 91 C1 02 00 91 ?? ?? ?? ?? 00 01 00 35 53 00 00 B4 76 02 00 F9 13 00 80 52 60 01 80 52 ?? ?? ?? ?? 60 02 00 11 07 00 00 14 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_157_4_0 {
	meta:
		name = "??$common_dupenv_s_nolock@D@@YAHQEAPEADQEA_KQEBDH2H@Z"
		size = 228
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0054 ??$common_getenv_nolock@D@@YAPEADQEBD@Z 0090 calloc 00b8 strcpy_s 00e0 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 16 00 00 91 33 00 00 91 56 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 DF 02 00 F9 53 00 00 B4 7F 02 00 F9 82 FE FF B4 40 00 00 91 ?? ?? ?? ?? 14 00 00 91 74 00 00 B5 00 00 80 52 F3 FF FF 17 88 02 C0 39 8A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 14 CB 15 05 00 91 A0 02 00 91 21 00 80 D2 ?? ?? ?? ?? C0 02 00 F9 C0 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 80 01 80 52 E1 FF FF 17 82 02 00 91 A1 02 00 91 ?? ?? ?? ?? 80 00 00 35 13 FD FF B4 75 02 00 F9 E6 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_5_0 {
	meta:
		name = "??$common_dupenv_s_nolock@_W@@YAHQEAPEA_WQEA_KQEB_WHQEBDH@Z"
		size = 232
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0054 ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 0094 calloc 00bc wcscpy_s 00e4 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 16 00 00 91 33 00 00 91 56 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 DF 02 00 F9 53 00 00 B4 7F 02 00 F9 82 FE FF B4 40 00 00 91 ?? ?? ?? ?? 14 00 00 91 74 00 00 B5 00 00 80 52 F3 FF FF 17 88 02 C0 79 8A 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 14 CB 09 FD 41 93 35 05 00 91 A0 02 00 91 41 00 80 D2 ?? ?? ?? ?? C0 02 00 F9 C0 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 80 01 80 52 E0 FF FF 17 82 02 00 91 A1 02 00 91 ?? ?? ?? ?? 80 00 00 35 F3 FC FF B4 75 02 00 F9 E5 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_6_0 {
	meta:
		name = "??$common_getenv@D@@YAPEADQEBD@Z"
		size = 112
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0034 strnlen 0048 __acrt_lock 0050 ??$common_getenv_nolock@D@@YAPEADQEBD@Z 005c __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 0F 00 00 14 E1 FF 8F D2 60 02 00 91 ?? ?? ?? ?? E8 FF 8F D2 1F 00 08 EB A2 FE FF 54 60 01 80 52 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 13 00 00 91 60 01 80 52 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_157_8_0 {
	meta:
		name = "??$common_getenv@_W@@YAPEA_WQEB_W@Z"
		size = 112
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0034 wcsnlen 0048 __acrt_lock 0050 ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 005c __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 0F 00 00 14 E1 FF 8F D2 60 02 00 91 ?? ?? ?? ?? E8 FF 8F D2 1F 00 08 EB A2 FE FF 54 60 01 80 52 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 13 00 00 91 60 01 80 52 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_157_10_0 {
	meta:
		name = "??$common_getenv_nolock@D@@YAPEADQEBD@Z"
		size = 184
		refs = "0014 __dcrt_get_or_create_narrow_environment_nolock 0084 _strnicoll"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 53 04 00 B4 34 04 00 B4 88 02 C0 39 8A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 68 02 40 F9 55 01 14 CB 08 03 00 B4 60 02 40 F9 0A 00 C0 39 0B 00 00 91 8A 00 00 34 6B 05 00 91 69 01 C0 39 C9 FF FF 35 68 01 00 CB 1F 01 15 EB 09 01 00 54 08 68 F5 38 1F F5 00 71 A1 00 00 54 A2 02 00 91 81 02 00 91 ?? ?? ?? ?? 60 00 00 34 68 8E 40 F8 ED FF FF 17 68 02 40 F9 09 01 15 8B 20 05 00 91 02 00 00 14 00 00 80 D2 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_157_11_0 {
	meta:
		name = "??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z"
		size = 188
		refs = "0014 __dcrt_get_or_create_wide_environment_nolock 0088 _wcsnicoll"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 F3 03 00 B4 D4 03 00 B4 88 02 C0 79 8A 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 14 CB 69 02 40 F9 15 FD 41 93 89 02 00 B4 60 02 40 F9 0A 00 C0 79 0C 00 00 91 8A 00 00 34 8C 09 00 91 8B 01 C0 79 CB FF FF 35 88 01 00 CB BF 06 88 EB 02 01 00 54 09 78 75 78 3F F5 00 71 A1 00 00 54 A2 02 00 91 81 02 00 91 ?? ?? ?? ?? 00 01 00 34 68 8E 40 F8 C8 FD FF B5 00 00 80 D2 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 68 02 40 F9 A9 06 00 91 00 05 09 8B F9 FF FF 17 }
	condition:
		$1
}

rule file_157_12_0 {
	meta:
		name = "??$common_getenv_s@D@@YAHQEA_KQEAD_KQEBD@Z"
		size = 264
		refs = "0024 __acrt_lock 002c _errno 0038 _invalid_parameter_noinfo 0078 ??$common_getenv_nolock@D@@YAPEADQEBD@Z 00c0 strcpy_s 00d0 __acrt_unlock 00f0 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 15 00 00 91 33 00 00 91 54 00 00 91 76 00 00 91 60 01 80 52 ?? ?? ?? ?? F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? D3 02 80 52 23 00 00 14 BF 02 00 F9 7F 02 00 F1 84 1A 40 FA A8 00 00 54 53 00 00 B5 74 00 00 B4 08 00 80 52 02 00 00 14 28 00 80 52 28 FE FF 34 53 00 00 B4 7F 02 00 39 C0 02 00 91 ?? ?? ?? ?? 60 02 00 B4 09 00 00 91 28 01 C0 39 68 00 00 34 29 05 00 91 FD FF FF 17 28 01 00 CB 0A 05 00 91 AA 02 00 F9 54 01 00 B4 5F 01 14 EB 69 00 00 54 53 04 80 52 07 00 00 14 02 00 00 91 81 02 00 91 60 02 00 91 ?? ?? ?? ?? C0 00 00 35 13 00 80 52 60 01 80 52 ?? ?? ?? ?? 60 02 00 11 07 00 00 14 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_157_14_0 {
	meta:
		name = "??$common_getenv_s@_W@@YAHQEA_KQEA_W_KQEB_W@Z"
		size = 264
		refs = "0024 __acrt_lock 002c _errno 0038 _invalid_parameter_noinfo 0078 ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 00c4 wcscpy_s 00d4 __acrt_unlock 00f4 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 15 00 00 91 33 00 00 91 54 00 00 91 76 00 00 91 60 01 80 52 ?? ?? ?? ?? F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? D3 02 80 52 24 00 00 14 BF 02 00 F9 7F 02 00 F1 84 1A 40 FA A8 00 00 54 53 00 00 B5 74 00 00 B4 08 00 80 52 02 00 00 14 28 00 80 52 28 FE FF 34 53 00 00 B4 7F 02 00 79 C0 02 00 91 ?? ?? ?? ?? 80 02 00 B4 09 00 00 91 28 01 C0 79 68 00 00 34 29 09 00 91 FD FF FF 17 28 01 00 CB 09 FD 41 93 2A 05 00 91 AA 02 00 F9 54 01 00 B4 5F 01 14 EB 69 00 00 54 53 04 80 52 07 00 00 14 02 00 00 91 81 02 00 91 60 02 00 91 ?? ?? ?? ?? C0 00 00 35 13 00 80 52 60 01 80 52 ?? ?? ?? ?? 60 02 00 11 07 00 00 14 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_157_16_0 {
	meta:
		name = "??$common_getenv_s_nolock@D@@YAHQEA_KQEAD_KQEBD@Z"
		size = 216
		refs = "0020 _errno 002c _invalid_parameter_noinfo 0064 ??$common_getenv_nolock@D@@YAPEADQEBD@Z 00b8 strcpy_s 00d4 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 15 00 00 91 34 00 00 91 53 00 00 91 55 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 BF 02 00 F9 74 00 00 B4 73 00 00 B5 F4 FF FF 17 73 FE FF B5 54 00 00 B4 9F 02 00 39 60 00 00 91 ?? ?? ?? ?? 60 00 00 B5 00 00 80 52 F1 FF FF 17 08 00 C0 39 0A 00 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 00 CB 09 05 00 91 A9 02 00 F9 B3 FE FF B4 3F 01 13 EB 69 00 00 54 40 04 80 52 E3 FF FF 17 02 00 00 91 80 02 00 91 61 02 00 91 ?? ?? ?? ?? 80 FD FF 34 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_17_0 {
	meta:
		name = "??$common_getenv_s_nolock@_W@@YAHQEA_KQEA_W_KQEB_W@Z"
		size = 220
		refs = "0020 _errno 002c _invalid_parameter_noinfo 0064 ??$common_getenv_nolock@_W@@YAPEA_WQEB_W@Z 00bc wcscpy_s 00d8 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 15 00 00 91 34 00 00 91 53 00 00 91 55 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 BF 02 00 F9 74 00 00 B4 73 00 00 B5 F4 FF FF 17 73 FE FF B5 54 00 00 B4 9F 02 00 79 60 00 00 91 ?? ?? ?? ?? 60 00 00 B5 00 00 80 52 F1 FF FF 17 08 00 C0 79 0A 00 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 00 CB 09 FD 41 93 2B 05 00 91 AB 02 00 F9 93 FE FF B4 7F 01 13 EB 69 00 00 54 40 04 80 52 E2 FF FF 17 02 00 00 91 80 02 00 91 61 02 00 91 ?? ?? ?? ?? 60 FD FF 34 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_32_0 {
	meta:
		name = "_dupenv_s"
		size = 16
		refs = "000c ??$common_dupenv_s@D@@YAHQEAPEADQEA_KQEBDH2H@Z"
	strings:
		$1 = { 05 00 80 52 04 00 80 D2 23 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_426_22_0 {
	meta:
		name = "_getdcwd"
		size = 16
		refs = "000c ??$common_getdcwd@D@@YAPEADHQEADHHQEBDH@Z"
	strings:
		$1 = { 05 00 80 52 04 00 80 D2 23 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_157_34_0 {
	meta:
		name = "_wdupenv_s"
		size = 16
		refs = "000c ??$common_dupenv_s@_W@@YAHQEAPEA_WQEA_KQEB_WHQEBDH@Z"
	strings:
		$1 = { 05 00 80 52 04 00 80 D2 23 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_426_24_0 {
	meta:
		name = "_wgetdcwd"
		size = 16
		refs = "000c ??$common_getdcwd@_W@@YAPEA_WHQEA_WHHQEBDH@Z"
	strings:
		$1 = { 05 00 80 52 04 00 80 D2 23 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_158_0_0 {
	meta:
		name = "_waccess"
		size = 32
		refs = "0008 _waccess_s"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 08 00 80 12 1F 00 00 71 E0 03 88 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_498_6_0 {
	meta:
		name = "_access"
		size = 32
		refs = "0008 _access_s"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 08 00 80 12 1F 00 00 71 E0 03 88 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_158_1_0 {
	meta:
		name = "_waccess_s"
		size = 196
		refs = "000c __security_push_cookie 001c __doserrno 0024 _errno 0030 _invalid_parameter_noinfo 0044 __imp_GetFileAttributesExW 0060 __imp_GetLastError 0070 __acrt_errno_map_os_error 00b4 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 0B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 33 00 00 11 20 01 00 B5 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 1E 00 00 14 68 76 1D 12 E8 FE FF 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E2 03 00 91 01 00 80 52 20 01 3F D6 20 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 40 B9 0D 00 00 14 E8 03 40 B9 48 01 20 37 28 01 00 36 13 01 08 36 ?? ?? ?? ?? A8 00 80 52 08 00 00 B9 ?? ?? ?? ?? A8 01 80 52 08 00 00 B9 F3 FF FF 17 00 00 80 52 FF 83 00 91 ?? ?? ?? ?? F3 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_159_0_0 {
	meta:
		name = "cbrtf"
		size = 332
		refs = "0018 _fdunscale 0090 _fdscale"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E1 53 00 91 E0 17 00 BD E0 43 00 91 ?? ?? ?? ?? 1F 08 00 71 68 00 00 54 E0 17 40 BD 40 00 00 14 EF 23 C0 79 53 08 00 18 01 00 80 52 E7 01 00 11 E8 7C 33 9B 09 FD 60 D3 2A 7D 49 0B 28 7D 49 0B 09 05 0A 0B 3F 01 07 6B 20 02 00 54 EA 04 00 11 4F 3D 00 13 E7 01 00 11 EF 23 00 79 EB 7C 33 9B 21 04 00 51 6C FD 60 D3 8E 7D 4C 0B 8D 7D 4C 0B AE 05 0E 0B DF 01 07 6B A1 FE FF 54 81 00 F8 36 E0 53 00 91 ?? ?? ?? ?? EF 23 C0 79 E8 2F 40 79 88 00 78 37 F5 17 40 BD 09 00 80 52 05 00 00 14 F0 17 40 BD 29 00 80 52 15 42 21 1E F5 17 00 BD 11 04 00 1C 10 04 00 1C 1A 10 2C 1E B2 42 11 1F D1 03 00 1C 54 46 15 1F B2 03 00 1C B3 2A 32 1E 99 1A 33 1E 14 10 2F 1E B8 0A 34 1E B5 0A 3A 1E B6 1A 39 1E 37 5B 19 1F 18 1B 37 1E 19 2B 39 1E 30 0B 3A 1E F0 1B 00 BD 69 00 00 34 10 42 21 1E F0 1B 00 BD E8 7D 33 9B E0 63 00 91 09 FD 60 D3 21 7D 49 0B ?? ?? ?? ?? E0 1B 40 BD FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 56 55 55 55 16 A4 79 3E 13 44 75 3F CF A0 A1 3D 5A 2A 8F 3E }
	condition:
		$1
}

rule file_160_0_0 {
	meta:
		name = "fgetpos"
		size = 80
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0030 _ftelli64"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 33 00 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 07 00 00 14 53 FF FF B4 ?? ?? ?? ?? 08 00 80 12 1F 04 00 B1 60 02 00 F9 00 01 9F 1A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_161_5_0 {
	meta:
		name = "_mbsbtype_l"
		size = 192
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 0038 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0074 _mbbtype_l"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 22 00 00 14 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 08 09 40 B9 68 00 00 35 00 00 80 52 14 00 00 14 00 00 80 12 74 00 00 B5 69 02 40 39 E9 01 00 34 6A 16 40 38 2A 01 00 34 01 00 00 11 40 01 00 11 E2 63 00 91 ?? ?? ?? ?? 9F 02 00 F1 94 06 00 D1 E0 00 00 54 F4 FF FF 17 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_162_0_0 {
	meta:
		name = "fdimf"
		size = 92
		refs = "0010 _fdtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 02 2D ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 13 40 BD 0D 00 00 14 E0 53 00 91 ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 17 40 BD 07 00 00 14 F0 47 42 2D 00 22 31 1E 68 00 00 54 E0 03 27 1E 02 00 00 14 00 3A 31 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_163_0_0 {
	meta:
		name = "_abstract_cw"
		size = 184
	strings:
		$1 = { 09 00 00 11 3F 01 18 72 0A 02 80 52 40 11 9F 1A 49 00 48 36 00 00 1D 32 49 00 50 36 00 00 1E 32 49 00 58 36 00 00 1F 32 49 00 60 36 00 00 00 32 49 00 78 36 00 00 0D 32 28 05 0A 12 E8 01 00 34 0A 08 A0 52 1F 01 0A 6B 60 01 00 54 0A 10 A0 52 1F 01 0A 6B C0 00 00 54 0A 18 A0 52 1F 01 0A 6B C1 00 00 54 00 04 18 32 04 00 00 14 00 00 18 32 02 00 00 14 00 00 17 32 28 05 08 12 0A 20 A0 52 1F 01 0A 6B 60 01 00 54 09 40 A0 52 1F 01 09 6B C0 00 00 54 09 60 A0 52 1F 01 09 6B C1 00 00 54 00 00 08 32 04 00 00 14 00 00 07 32 02 00 00 14 00 04 08 32 C0 03 5F D6 }
	condition:
		$1
}

rule file_163_1_0 {
	meta:
		name = "_abstract_sw"
		size = 76
	strings:
		$1 = { 09 00 00 11 E8 13 80 52 28 01 08 0A 00 00 80 52 C8 01 00 34 3F 01 00 72 0A 02 80 52 40 11 9F 1A 49 00 08 36 00 00 1D 32 49 00 10 36 00 00 1E 32 49 00 18 36 00 00 1F 32 49 00 20 36 00 00 00 32 49 00 38 36 00 00 0D 32 C0 03 5F D6 }
	condition:
		$1
}

rule file_163_2_0 {
	meta:
		name = "_clearfp"
		size = 24
		refs = "0014 _abstract_sw"
	strings:
		$1 = { 28 44 3B D5 00 7D 40 D3 E8 13 80 92 08 00 08 8A 28 44 1B D5 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_163_3_0 {
	meta:
		name = "_control87"
		size = 132
		refs = "002c _abstract_cw 004c _hw_cw"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 88 03 00 18 33 00 08 0A 14 00 00 11 08 44 3B D5 0A E0 93 52 15 01 0A 4A A0 02 00 11 ?? ?? ?? ?? E8 03 33 2A 0A 01 00 0A 89 02 13 0A 48 01 09 2A 1F 01 00 6B 40 01 00 54 00 01 00 11 ?? ?? ?? ?? E8 13 80 52 A8 02 08 0A 00 01 00 2A 08 E0 93 D2 08 00 08 CA 08 44 1B D5 ?? ?? ?? ?? FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 1F 20 03 D5 1F 03 08 03 }
	condition:
		$1
}

rule file_163_6_0 {
	meta:
		name = "_hw_cw"
		size = 172
	strings:
		$1 = { 09 00 00 11 3F 01 1C 72 0A 20 80 52 40 11 9F 1A 49 00 18 36 00 00 17 32 49 00 10 36 00 00 16 32 49 00 08 36 00 00 15 32 49 00 00 36 00 00 14 32 49 00 98 36 00 00 11 32 28 05 18 12 88 01 00 34 1F 01 04 71 20 01 00 54 1F 01 08 71 A0 00 00 54 1F 01 0C 71 C1 00 00 54 00 04 0A 32 04 00 00 14 00 00 0A 32 02 00 00 14 00 00 09 32 28 05 08 12 0A 20 A0 52 1F 01 0A 6B 60 01 00 54 09 40 A0 52 1F 01 09 6B C0 00 00 54 09 60 A0 52 1F 01 09 6B C1 00 00 54 00 00 08 32 04 00 00 14 00 00 07 32 02 00 00 14 00 04 08 32 C0 03 5F D6 }
	condition:
		$1
}

rule file_164_7_0 {
	meta:
		name = "_fgetwc_nolock"
		size = 468
		refs = "001c __badioinfo 0020 __pioinfo 0028 _fileno 0088 _getc_nolock 012c __pctype_func 0154 ungetc 0174 mbtowc 0180 _errno 01bc __acrt_stdio_refill_and_read_wide_nolock"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BE A9 FD 03 00 91 14 00 00 91 88 16 40 B9 BF 3B 03 D5 ?? ?? ?? ?? ?? ?? ?? ?? 48 04 60 37 ?? ?? ?? ?? 1F 04 00 31 20 02 00 54 80 02 00 91 ?? ?? ?? ?? 1F 08 00 31 A0 01 00 54 80 02 00 91 ?? ?? ?? ?? 13 00 00 11 80 02 00 91 ?? ?? ?? ?? 68 7E 40 93 0C FD 46 93 ?? ?? ?? ?? 68 79 6C F8 0A 14 40 92 0D 19 0A 8B 02 00 00 14 ?? ?? ?? ?? A8 E5 C0 39 88 01 00 34 F3 43 00 91 80 02 00 91 ?? ?? ?? ?? 1F 04 00 31 40 06 00 54 60 16 00 38 E8 4B 00 91 7F 02 08 EB 21 FF FF 54 E0 23 40 79 47 00 00 14 88 16 40 B9 BF 3B 03 D5 E8 06 60 37 80 02 00 91 ?? ?? ?? ?? 1F 04 00 31 20 02 00 54 80 02 00 91 ?? ?? ?? ?? 1F 08 00 31 A0 01 00 54 80 02 00 91 ?? ?? ?? ?? 13 00 00 11 80 02 00 91 ?? ?? ?? ?? 68 7E 40 93 0C FD 46 93 ?? ?? ?? ?? 68 79 6C F8 0A 14 40 92 0D 19 0A 8B 02 00 00 14 ?? ?? ?? ?? A8 E1 40 39 08 04 38 36 80 02 00 91 33 00 80 52 ?? ?? ?? ?? 1F 04 00 31 A0 01 00 54 E0 53 00 39 ?? ?? ?? ?? E8 53 40 39 09 D8 68 78 89 01 78 36 80 02 00 91 ?? ?? ?? ?? 1F 04 00 31 C1 00 00 54 E0 53 C0 39 81 02 00 91 ?? ?? ?? ?? E0 FF 9F 52 1A 00 00 14 E0 57 00 39 53 00 80 52 62 7E 40 93 E1 53 00 91 E0 43 00 91 ?? ?? ?? ?? 1F 04 00 31 41 F9 FF 54 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 F3 FF FF 17 88 12 40 B9 1F 09 00 71 0B 01 00 54 08 09 00 51 88 12 00 B9 89 02 40 F9 28 09 00 91 20 01 40 79 88 02 00 F9 04 00 00 14 80 02 00 91 ?? ?? ?? ?? 00 3C 00 53 FD 7B C2 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_164_10_0 {
	meta:
		name = "fgetwc"
		size = 96
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 0034 _lock_file 003c _fgetwc_nolock 0048 _unlock_file"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 B3 0B 00 F9 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? E0 FF 9F 52 09 00 00 14 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 14 00 00 11 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_165_0_0 {
	meta:
		name = "cacoshf"
		size = 696
		refs = "0010 crealf 0020 cimagf 002c _fdtest 0060 _FInf_C 011c _FCbuild 0120 csqrtf 01f8 asinhf 0218 logf 0274 atan2f"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 E0 07 07 2D ?? ?? ?? ?? E1 3F 40 BD E0 1B 00 BD E0 3B 40 BD ?? ?? ?? ?? E0 63 00 91 E0 17 00 BD ?? ?? ?? ?? 13 00 00 11 E0 53 00 91 ?? ?? ?? ?? 7F 0A 00 71 A1 01 00 54 1F 08 00 71 61 00 00 54 E1 83 42 2D 8F 00 00 14 E1 1B 40 BD 1F 04 00 71 81 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 89 00 00 14 E1 13 00 BD 86 00 00 14 1F 08 00 71 81 00 00 54 E1 17 40 BD 7F 06 00 71 F6 FF FF 17 7F 06 00 71 81 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 71 E1 00 00 54 F0 1B 40 BD F1 0F 00 1C 08 22 20 1E D0 0F 00 1C 21 3E 30 1E 06 00 00 14 F2 1B 40 BD 73 0F 00 1C F0 03 27 1E 48 22 20 1E 61 3E 30 1E E8 2F 40 79 E8 0D 78 36 21 40 21 1E 6D 00 00 14 1F 04 00 71 21 01 00 54 F0 17 40 BD 31 0E 00 1C ?? ?? ?? ?? ?? ?? ?? ?? 08 22 20 1E D0 0D 00 1C 21 3E 30 1E 63 00 00 14 F2 17 40 BD 10 10 2E 1E F0 2F 00 BD 41 42 21 1E F2 1B 40 BD 40 3A 30 1E ?? ?? ?? ?? ?? ?? ?? ?? F0 1B 40 BD F1 2F 40 BD E0 13 00 BD E1 1F 00 BD E1 17 40 BD 00 2A 31 1E ?? ?? ?? ?? ?? ?? ?? ?? E0 07 04 2D E1 1F 40 BD E0 13 40 BD ?? ?? ?? ?? E1 1F 40 BD E0 33 00 BD E0 13 40 BD ?? ?? ?? ?? E1 27 40 BD E0 2B 00 BD E0 23 40 BD ?? ?? ?? ?? E1 27 40 BD E0 13 00 BD E0 23 40 BD ?? ?? ?? ?? F2 33 40 BD 74 09 00 1C E0 23 00 BD F1 2B 40 BD 80 22 32 1E C2 00 00 54 F4 13 40 BD F2 1F 00 BD 90 1A 32 1E 00 82 11 1F 13 00 00 14 80 22 31 1E C2 00 00 54 F1 1F 00 BD 11 18 31 1E F4 13 40 BD 20 D2 32 1F 0C 00 00 14 30 42 21 1E 80 22 30 1E F0 1F 00 BD F4 13 40 BD 82 00 00 54 10 18 30 1E 00 D2 32 1F 04 00 00 14 12 08 32 1E FF 1F 00 B9 80 CA 11 1F ?? ?? ?? ?? F1 1F 40 BD E0 13 00 BD 28 22 20 1E 80 01 00 54 08 20 20 1E 20 42 20 1E AB 00 00 54 ?? ?? ?? ?? F0 13 40 BD 10 28 30 1E 04 00 00 14 ?? ?? ?? ?? F0 13 40 BD 10 3A 20 1E F0 13 00 BD E8 2F 40 79 13 01 11 12 B3 00 00 34 F0 17 40 BD 01 42 21 1E E1 17 00 BD 02 00 00 14 E1 17 40 BD F0 1B 40 BD F1 2F 40 BD 00 3A 31 1E ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E1 23 40 BD ?? ?? ?? ?? 10 10 20 1E 01 08 30 1E 53 00 00 34 21 40 21 1E E0 13 40 BD ?? ?? ?? ?? FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 E4 CB 16 40 DB 0F 49 3F DB 0F 49 40 DB 0F C9 BF DB 0F C9 3F 0A E8 7F 5E }
	condition:
		$1
}

rule file_166_0_0 {
	meta:
		name = "__p___mb_cur_max"
		size = 44
		refs = "0008 __acrt_getptd 0018 __acrt_update_locale_info"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? E1 43 00 91 08 48 40 F9 E8 0B 00 F9 ?? ?? ?? ?? E8 0B 40 F9 00 21 00 91 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_168_0_0 {
	meta:
		name = "_Cmulcc"
		size = 104
		refs = "0010 creal 0020 cimag 005c _Cbuild"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 87 03 6D E2 8F 02 6D ?? ?? ?? ?? E1 23 40 FD E0 13 00 FD E0 1F 40 FD ?? ?? ?? ?? E1 1B 40 FD E0 0F 00 FD E0 17 40 FD ?? ?? ?? ?? E1 1B 40 FD E0 0B 00 FD E0 17 40 FD ?? ?? ?? ?? F1 4B 41 6D F3 13 40 FD 30 0A 72 1E 31 0A 73 1E 01 40 53 1F 00 C4 52 1F ?? ?? ?? ?? FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_449_0_0 {
	meta:
		name = "_LCmulcc"
		size = 104
		refs = "0010 creall 0020 cimagl 005c _LCbuild"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E0 87 03 6D E2 8F 02 6D ?? ?? ?? ?? E1 23 40 FD E0 13 00 FD E0 1F 40 FD ?? ?? ?? ?? E1 1B 40 FD E0 0F 00 FD E0 17 40 FD ?? ?? ?? ?? E1 1B 40 FD E0 0B 00 FD E0 17 40 FD ?? ?? ?? ?? F1 4B 41 6D F3 13 40 FD 30 0A 72 1E 31 0A 73 1E 01 40 53 1F 00 C4 52 1F ?? ?? ?? ?? FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_168_1_0 {
	meta:
		name = "_Cmulcr"
		size = 60
		refs = "0010 cimag 0020 creal 0030 _Cbuild"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 07 02 6D E2 0F 00 FD ?? ?? ?? ?? E1 17 40 FD E0 0B 00 FD E0 13 40 FD ?? ?? ?? ?? F0 47 41 6D 01 0A 71 1E 00 08 71 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_449_1_0 {
	meta:
		name = "_LCmulcr"
		size = 60
		refs = "0010 cimagl 0020 creall 0030 _LCbuild"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 07 02 6D E2 0F 00 FD ?? ?? ?? ?? E1 17 40 FD E0 0B 00 FD E0 13 40 FD ?? ?? ?? ?? F0 47 41 6D 01 0A 71 1E 00 08 71 1E ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_168_2_0 {
	meta:
		name = "cpow"
		size = 144
		refs = "0010 cimag 0020 creal 0058 pow 0060 _Cbuild 006c clog 0080 _Cmulcc 0084 cexp"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 87 01 6D E2 8F 02 6D ?? ?? ?? ?? 08 20 60 1E 81 02 00 54 E0 87 41 6D ?? ?? ?? ?? 08 20 60 1E 0B 02 00 54 E0 87 42 6D ?? ?? ?? ?? 08 20 60 1E 81 01 00 54 E0 87 42 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD ?? ?? ?? ?? E1 03 67 9E ?? ?? ?? ?? 09 00 00 14 E0 87 41 6D ?? ?? ?? ?? 23 40 60 1E E1 1B 40 FD 02 40 60 1E E0 17 40 FD ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_449_2_0 {
	meta:
		name = "cpowl"
		size = 144
		refs = "0010 cimagl 0020 creall 0058 pow 0060 _LCbuild 006c clogl 0080 _LCmulcc 0084 cexpl"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E0 87 01 6D E2 8F 02 6D ?? ?? ?? ?? 08 20 60 1E 81 02 00 54 E0 87 41 6D ?? ?? ?? ?? 08 20 60 1E 0B 02 00 54 E0 87 42 6D ?? ?? ?? ?? 08 20 60 1E 81 01 00 54 E0 87 42 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? E1 0B 40 FD ?? ?? ?? ?? E1 03 67 9E ?? ?? ?? ?? 09 00 00 14 E0 87 41 6D ?? ?? ?? ?? 23 40 60 1E E1 1B 40 FD 02 40 60 1E E0 17 40 FD ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_169_17_0 {
	meta:
		name = "fputs"
		size = 272
		refs = "0010 _errno 001c _invalid_parameter_noinfo 003c _fileno 0040 __pioinfo 004c __badioinfo 0104 ??$?RV<lambda_638071c8ff4a7adc38ebf97819af8252>@@AEAV<lambda_c24b6d9e7c4576f9a5efdbd124f9441f>@@V<lambda_b22ff52eb36be97581a67924712ed724>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_638071c8ff4a7adc38ebf97819af8252>@@AEAV<lambda_c24b6d9e7c4576f9a5efdbd124f9441f>@@$$QEAV<lambda_b22ff52eb36be97581a67924712ed724>@@@Z"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E0 87 01 A9 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 39 00 00 14 41 FF FF B4 28 14 40 B9 BF 3B 03 D5 E8 03 60 37 20 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 08 08 00 11 1F 05 00 71 ?? ?? ?? ?? 09 01 00 54 09 7C 40 93 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 0B 19 09 8B 02 00 00 14 ?? ?? ?? ?? 68 E5 C0 39 C8 FC FF 35 08 08 00 11 1F 05 00 71 09 01 00 54 09 7C 40 93 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 0B 19 09 8B 02 00 00 14 ?? ?? ?? ?? 68 F5 40 39 28 FB 07 37 EB 0F 40 F9 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 0B CB E8 17 00 F9 E8 63 00 91 E8 27 00 F9 E8 13 40 F9 E9 83 00 91 E8 A7 03 A9 E9 A3 00 91 E3 C3 00 91 E9 2B 00 F9 E2 03 01 91 E1 E3 00 91 E8 1B 00 F9 E0 43 00 91 ?? ?? ?? ?? FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_170_8_0 {
	meta:
		name = "_fgetc_nolock"
		size = 84
		refs = "000c _errno 0018 _invalid_parameter_noinfo 0034 __acrt_stdio_refill_and_read_narrow_nolock"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 0B 00 00 14 08 10 40 B9 09 05 00 51 09 10 00 B9 69 00 F8 36 ?? ?? ?? ?? 05 00 00 14 08 00 40 F9 09 15 40 38 08 00 00 F9 20 01 00 11 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_170_11_0 {
	meta:
		name = "fgetc"
		size = 288
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 0044 _lock_file 0058 _fileno 0064 __pioinfo 0084 __badioinfo 00dc $LN18 00e8 _local_unwind 00fc _fgetc_nolock 0108 _unlock_file"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 08 08 80 D2 E8 63 28 8B A8 13 00 F9 13 00 00 91 B3 0B 00 F9 B3 0F 00 F9 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 35 00 00 14 60 02 00 91 ?? ?? ?? ?? 68 16 40 B9 BF 3B 03 D5 48 05 60 37 60 02 00 91 ?? ?? ?? ?? 08 08 00 11 1F 05 00 71 ?? ?? ?? ?? ?? ?? ?? ?? 29 01 00 54 08 7C 40 93 0A FD 46 93 09 15 40 92 88 79 6A F8 0B 19 09 8B ?? ?? ?? ?? ?? ?? ?? ?? 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 4B 01 00 91 68 E5 C0 39 68 01 00 35 08 08 00 11 1F 05 00 71 C9 00 00 54 08 7C 40 93 0A FD 46 93 09 15 40 92 88 79 6A F8 0A 19 09 8B 48 F5 40 39 88 01 00 36 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 13 40 F9 ?? ?? ?? ?? 1F 20 03 D5 00 00 80 12 07 00 00 14 60 02 00 91 ?? ?? ?? ?? 14 00 00 11 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_171_0_0 {
	meta:
		name = "_cabs"
		size = 24
		refs = "000c _hypot"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 01 6D ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_172_0_0 {
	meta:
		name = "scalbnf"
		size = 92
		refs = "001c _fdtest 002c _fdscale 0048 _fperrraise"
		altNames = "scalblnf"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 13 00 BD 13 00 00 11 F3 01 00 34 E0 43 00 91 ?? ?? ?? ?? 60 01 F8 36 61 02 00 11 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 A1 00 00 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? E0 13 40 BD FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_173_0_0 {
	meta:
		name = "_ldpow"
		size = 1608
		refs = "0014 __security_push_cookie 0030 _ldunscale 0040 _ld_int 00bc _fperrraise 00c0 _LNan_C 0154 lnbias 0174 _ldlogpoly 027c _ldxp_setw 02a0 _ldxp_addx 02c4 log2e 02e0 _ldxp_mulh 0360 _ldxp_addh 0434 _ldxp_getw 0464 _ldexp 0480 _LInf_C 0530 _LZero_C 05f0 __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 03 D1 15 00 00 91 E0 87 00 6D E0 03 00 91 E1 07 02 6D E1 23 00 91 ?? ?? ?? ?? 01 00 80 52 14 00 00 11 E0 83 00 91 ?? ?? ?? ?? 13 00 00 11 55 00 00 B4 BF 02 00 79 F1 17 40 FD 73 00 00 35 28 22 60 1E E0 01 00 54 E0 07 40 FD E9 03 C0 79 54 22 F8 36 14 10 6C 1E 3F 05 00 71 F4 27 00 FD 41 01 00 54 00 20 74 1E C0 00 00 54 7F 06 00 71 C1 00 00 54 10 10 7C 1E 00 20 70 1E 61 00 00 54 00 10 6E 1E 54 01 00 14 9F 02 00 71 60 BA 40 7A 4C 20 00 54 E8 1F 40 79 E8 00 78 36 D3 00 F8 36 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 49 01 00 14 08 20 60 1E 6D 00 00 54 14 00 80 52 0A 00 00 14 10 40 61 1E 01 00 80 12 E0 83 00 91 F0 07 00 FD ?? ?? ?? ?? E0 07 40 FD 14 00 00 11 E9 03 C0 79 F4 27 40 FD 11 10 6E 1E 3F 05 00 71 12 10 60 1E F2 C7 03 6D 01 01 00 54 B0 27 00 5C 00 20 70 1E A2 00 00 54 08 00 80 52 30 42 60 1E 00 08 72 1E 08 00 00 14 11 27 00 5C 32 27 00 5C 10 50 51 1F 08 02 78 1E 08 81 00 51 13 01 62 1E 70 52 52 1F 14 38 70 1E F4 C3 00 6D ?? ?? ?? ?? 11 2A 60 1E 09 7D 40 93 ?? ?? ?? ?? 16 15 09 8B 90 1A 71 1E 00 0A 70 1E F0 1B 00 FD ?? ?? ?? ?? F8 CB 42 6D 3A 25 00 5C F5 CF 40 6D FF 0B 00 F9 F9 23 40 FD E8 03 C0 79 FA 1B 00 FD 50 0A 72 1E 11 D4 70 1F 30 3B 73 1E F3 1F 40 FD 10 46 53 1F D1 02 40 FD 10 0A 72 1E 12 01 62 1E 17 2A 75 1E F0 1F 00 FD F0 03 67 9E 5B 2A 71 1E F2 1A 7A 1E 53 2A 7B 1E 76 0A 78 1E F6 CF 01 6D B3 22 00 5C C0 22 73 1E 62 00 00 54 08 00 80 52 A4 00 00 14 10 D0 75 1E 00 22 76 1E 68 03 00 54 11 D0 65 1E C0 22 71 1E 08 03 00 54 92 21 00 5C 40 22 78 1E A2 02 00 54 74 21 00 5C 00 23 74 1E 42 02 00 54 F3 27 40 FD C8 22 60 1E D1 06 40 FD F7 0A 78 1E D5 3A 73 1E D3 2A 73 1E B0 3E 73 1E D5 0A 40 FD 01 02 78 1E B2 2A 71 1E 56 0A 78 1E 32 00 62 1E D7 5E 5A 1F 74 CB 78 1F 97 5E 5A 1F F7 0F 00 FD 7E 00 00 14 30 1F 00 5C 00 22 76 1E 62 00 00 54 28 00 80 52 81 00 00 14 A0 42 60 1E 81 00 80 52 E0 63 02 91 ?? ?? ?? ?? E0 1F 40 FD 41 00 80 52 E0 23 01 91 ?? ?? ?? ?? 43 00 80 52 E2 23 01 91 81 00 80 52 E0 63 02 91 ?? ?? ?? ?? E0 4F 40 FD 81 00 80 52 E0 63 01 91 08 20 60 1E 81 00 00 54 E0 0B 40 FD ?? ?? ?? ?? 1F 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 48 25 40 A9 EC 63 01 91 4A 2D 41 A9 88 25 00 A9 8A 2D 01 A9 ?? ?? ?? ?? 33 00 80 52 E8 63 02 91 00 D9 73 FC 08 20 60 1E 40 02 00 54 ?? ?? ?? ?? 48 25 40 A9 EC E3 02 91 4A 2D 41 A9 81 00 80 52 E0 E3 02 91 88 25 00 A9 8A 2D 01 A9 ?? ?? ?? ?? 83 00 80 52 E2 E3 02 91 81 00 80 52 E0 63 01 91 ?? ?? ?? ?? 73 06 00 11 7F 12 00 71 8B FD FF 54 63 00 80 52 C2 02 00 91 81 00 80 52 E0 63 01 91 ?? ?? ?? ?? E8 03 C0 79 81 00 80 52 E0 63 01 91 00 01 62 1E ?? ?? ?? ?? E0 17 40 FD 41 00 80 52 E0 63 02 91 ?? ?? ?? ?? EA 63 01 91 E0 4F 40 FD 48 25 40 A9 EC E3 01 91 4A 2D 41 A9 81 00 80 52 E0 E3 01 91 88 25 00 A9 8A 2D 01 A9 ?? ?? ?? ?? E0 53 40 FD 08 20 60 1E E0 01 00 54 EA 63 01 91 48 25 40 A9 EC E3 02 91 4A 2D 41 A9 81 00 80 52 E0 E3 02 91 88 25 00 A9 8A 2D 01 A9 ?? ?? ?? ?? 83 00 80 52 E2 E3 02 91 81 00 80 52 E0 E3 01 91 ?? ?? ?? ?? F1 3F 40 FD F1 07 00 FD 28 22 60 1E 00 01 00 54 F2 43 40 FD 48 22 60 1E A0 00 00 54 F0 47 40 FD 10 2A 72 1E 10 2A 71 1E F0 07 00 FD 01 00 80 52 E0 23 00 91 ?? ?? ?? ?? F0 07 40 FD 81 00 80 52 E0 E3 01 91 00 42 61 1E ?? ?? ?? ?? 81 00 80 52 E0 E3 01 91 ?? ?? ?? ?? F0 1B 40 FD F1 07 40 FD F9 23 40 FD 10 08 70 1E 21 02 78 1E F0 0F 00 FD 75 00 00 B4 A1 02 00 79 01 00 80 52 20 43 60 1E E0 63 00 91 ?? ?? ?? ?? F6 0F 40 FD 08 00 00 11 F0 0B 40 FD E8 00 00 34 1F 05 00 71 21 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 80 52 02 00 00 14 00 02 80 52 F0 0F 00 FD ?? ?? ?? ?? F6 0F 40 FD D0 42 61 1E 9F 02 00 71 00 1E 76 1E 50 00 00 14 9F 0A 00 71 C0 09 00 54 7F 0A 00 71 61 00 00 54 20 42 60 1E 4A 00 00 14 9F 06 00 71 01 04 00 54 E8 1F 40 79 08 01 78 37 E9 2F 40 79 ?? ?? ?? ?? F1 03 67 9E ?? ?? ?? ?? 3F 01 11 72 20 1E 70 1E 3F 00 00 14 E8 2F 40 79 28 01 78 37 53 07 00 35 01 00 80 12 E0 83 00 91 ?? ?? ?? ?? C0 06 F8 36 ?? ?? ?? ?? ?? ?? ?? ?? 31 00 00 14 33 01 00 35 01 00 80 12 E0 83 00 91 ?? ?? ?? ?? A0 00 F8 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E 02 00 00 14 F0 03 67 9E 00 42 60 1E 29 00 00 14 E8 2F 40 79 7F 06 00 71 81 01 00 54 3F 01 00 71 C8 00 78 37 ?? ?? ?? ?? F1 03 67 9E ?? ?? ?? ?? 20 DE 70 1E 1F 00 00 14 ?? ?? ?? ?? F0 03 67 9E ?? ?? ?? ?? FB FF FF 17 68 01 78 37 D3 FD FF 35 01 00 80 12 E0 83 00 91 ?? ?? ?? ?? 40 FD FF 36 E8 1F 40 79 08 FD 7F 36 ?? ?? ?? ?? ?? ?? ?? ?? E3 FF FF 17 80 00 80 52 ?? ?? ?? ?? 73 01 00 35 01 00 80 12 E0 83 00 91 ?? ?? ?? ?? E0 00 F8 36 E8 1F 40 79 A8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 00 42 61 1E 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? FF 43 03 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 CD 3B 7F 66 9E A0 E6 3F 00 00 00 00 00 00 50 40 00 00 00 00 00 00 90 3F EF 39 FA FE 42 2E E6 3F 00 00 00 00 00 00 E0 C0 00 00 00 00 00 00 44 C0 00 00 00 00 00 00 44 40 00 00 00 00 00 00 E0 40 }
	condition:
		$1
}

rule file_438_0_0 {
	meta:
		name = "_dpow"
		size = 1608
		refs = "0014 __security_push_cookie 0030 _dunscale 0040 _d_int 00bc _fperrraise 00c0 _Nan_C 0154 lnbias 0174 _dlogpoly 027c _dxp_setw 02a0 _dxp_addx 02c4 log2e 02e0 _dxp_mulh 0360 _dxp_addh 0434 _dxp_getw 0464 _dexp 0480 _Inf_C 0530 _Zero_C 05f0 __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 03 D1 15 00 00 91 E0 87 00 6D E0 03 00 91 E1 07 02 6D E1 23 00 91 ?? ?? ?? ?? 01 00 80 52 14 00 00 11 E0 83 00 91 ?? ?? ?? ?? 13 00 00 11 55 00 00 B4 BF 02 00 79 F1 17 40 FD 73 00 00 35 28 22 60 1E E0 01 00 54 E0 07 40 FD E9 03 C0 79 54 22 F8 36 14 10 6C 1E 3F 05 00 71 F4 27 00 FD 41 01 00 54 00 20 74 1E C0 00 00 54 7F 06 00 71 C1 00 00 54 10 10 7C 1E 00 20 70 1E 61 00 00 54 00 10 6E 1E 54 01 00 14 9F 02 00 71 60 BA 40 7A 4C 20 00 54 E8 1F 40 79 E8 00 78 36 D3 00 F8 36 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 49 01 00 14 08 20 60 1E 6D 00 00 54 14 00 80 52 0A 00 00 14 10 40 61 1E 01 00 80 12 E0 83 00 91 F0 07 00 FD ?? ?? ?? ?? E0 07 40 FD 14 00 00 11 E9 03 C0 79 F4 27 40 FD 11 10 6E 1E 3F 05 00 71 12 10 60 1E F2 C7 03 6D 01 01 00 54 B0 27 00 5C 00 20 70 1E A2 00 00 54 08 00 80 52 30 42 60 1E 00 08 72 1E 08 00 00 14 11 27 00 5C 32 27 00 5C 10 50 51 1F 08 02 78 1E 08 81 00 51 13 01 62 1E 70 52 52 1F 14 38 70 1E F4 C3 00 6D ?? ?? ?? ?? 11 2A 60 1E 09 7D 40 93 ?? ?? ?? ?? 16 15 09 8B 90 1A 71 1E 00 0A 70 1E F0 1B 00 FD ?? ?? ?? ?? F8 CB 42 6D 3A 25 00 5C F5 CF 40 6D FF 0B 00 F9 F9 23 40 FD E8 03 C0 79 FA 1B 00 FD 50 0A 72 1E 11 D4 70 1F 30 3B 73 1E F3 1F 40 FD 10 46 53 1F D1 02 40 FD 10 0A 72 1E 12 01 62 1E 17 2A 75 1E F0 1F 00 FD F0 03 67 9E 5B 2A 71 1E F2 1A 7A 1E 53 2A 7B 1E 76 0A 78 1E F6 CF 01 6D B3 22 00 5C C0 22 73 1E 62 00 00 54 08 00 80 52 A4 00 00 14 10 D0 75 1E 00 22 76 1E 68 03 00 54 11 D0 65 1E C0 22 71 1E 08 03 00 54 92 21 00 5C 40 22 78 1E A2 02 00 54 74 21 00 5C 00 23 74 1E 42 02 00 54 F3 27 40 FD C8 22 60 1E D1 06 40 FD F7 0A 78 1E D5 3A 73 1E D3 2A 73 1E B0 3E 73 1E D5 0A 40 FD 01 02 78 1E B2 2A 71 1E 56 0A 78 1E 32 00 62 1E D7 5E 5A 1F 74 CB 78 1F 97 5E 5A 1F F7 0F 00 FD 7E 00 00 14 30 1F 00 5C 00 22 76 1E 62 00 00 54 28 00 80 52 81 00 00 14 A0 42 60 1E 81 00 80 52 E0 63 02 91 ?? ?? ?? ?? E0 1F 40 FD 41 00 80 52 E0 23 01 91 ?? ?? ?? ?? 43 00 80 52 E2 23 01 91 81 00 80 52 E0 63 02 91 ?? ?? ?? ?? E0 4F 40 FD 81 00 80 52 E0 63 01 91 08 20 60 1E 81 00 00 54 E0 0B 40 FD ?? ?? ?? ?? 1F 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 48 25 40 A9 EC 63 01 91 4A 2D 41 A9 88 25 00 A9 8A 2D 01 A9 ?? ?? ?? ?? 33 00 80 52 E8 63 02 91 00 D9 73 FC 08 20 60 1E 40 02 00 54 ?? ?? ?? ?? 48 25 40 A9 EC E3 02 91 4A 2D 41 A9 81 00 80 52 E0 E3 02 91 88 25 00 A9 8A 2D 01 A9 ?? ?? ?? ?? 83 00 80 52 E2 E3 02 91 81 00 80 52 E0 63 01 91 ?? ?? ?? ?? 73 06 00 11 7F 12 00 71 8B FD FF 54 63 00 80 52 C2 02 00 91 81 00 80 52 E0 63 01 91 ?? ?? ?? ?? E8 03 C0 79 81 00 80 52 E0 63 01 91 00 01 62 1E ?? ?? ?? ?? E0 17 40 FD 41 00 80 52 E0 63 02 91 ?? ?? ?? ?? EA 63 01 91 E0 4F 40 FD 48 25 40 A9 EC E3 01 91 4A 2D 41 A9 81 00 80 52 E0 E3 01 91 88 25 00 A9 8A 2D 01 A9 ?? ?? ?? ?? E0 53 40 FD 08 20 60 1E E0 01 00 54 EA 63 01 91 48 25 40 A9 EC E3 02 91 4A 2D 41 A9 81 00 80 52 E0 E3 02 91 88 25 00 A9 8A 2D 01 A9 ?? ?? ?? ?? 83 00 80 52 E2 E3 02 91 81 00 80 52 E0 E3 01 91 ?? ?? ?? ?? F1 3F 40 FD F1 07 00 FD 28 22 60 1E 00 01 00 54 F2 43 40 FD 48 22 60 1E A0 00 00 54 F0 47 40 FD 10 2A 72 1E 10 2A 71 1E F0 07 00 FD 01 00 80 52 E0 23 00 91 ?? ?? ?? ?? F0 07 40 FD 81 00 80 52 E0 E3 01 91 00 42 61 1E ?? ?? ?? ?? 81 00 80 52 E0 E3 01 91 ?? ?? ?? ?? F0 1B 40 FD F1 07 40 FD F9 23 40 FD 10 08 70 1E 21 02 78 1E F0 0F 00 FD 75 00 00 B4 A1 02 00 79 01 00 80 52 20 43 60 1E E0 63 00 91 ?? ?? ?? ?? F6 0F 40 FD 08 00 00 11 F0 0B 40 FD E8 00 00 34 1F 05 00 71 21 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 80 52 02 00 00 14 00 02 80 52 F0 0F 00 FD ?? ?? ?? ?? F6 0F 40 FD D0 42 61 1E 9F 02 00 71 00 1E 76 1E 50 00 00 14 9F 0A 00 71 C0 09 00 54 7F 0A 00 71 61 00 00 54 20 42 60 1E 4A 00 00 14 9F 06 00 71 01 04 00 54 E8 1F 40 79 08 01 78 37 E9 2F 40 79 ?? ?? ?? ?? F1 03 67 9E ?? ?? ?? ?? 3F 01 11 72 20 1E 70 1E 3F 00 00 14 E8 2F 40 79 28 01 78 37 53 07 00 35 01 00 80 12 E0 83 00 91 ?? ?? ?? ?? C0 06 F8 36 ?? ?? ?? ?? ?? ?? ?? ?? 31 00 00 14 33 01 00 35 01 00 80 12 E0 83 00 91 ?? ?? ?? ?? A0 00 F8 36 ?? ?? ?? ?? ?? ?? ?? ?? 10 42 61 1E 02 00 00 14 F0 03 67 9E 00 42 60 1E 29 00 00 14 E8 2F 40 79 7F 06 00 71 81 01 00 54 3F 01 00 71 C8 00 78 37 ?? ?? ?? ?? F1 03 67 9E ?? ?? ?? ?? 20 DE 70 1E 1F 00 00 14 ?? ?? ?? ?? F0 03 67 9E ?? ?? ?? ?? FB FF FF 17 68 01 78 37 D3 FD FF 35 01 00 80 12 E0 83 00 91 ?? ?? ?? ?? 40 FD FF 36 E8 1F 40 79 08 FD 7F 36 ?? ?? ?? ?? ?? ?? ?? ?? E3 FF FF 17 80 00 80 52 ?? ?? ?? ?? 73 01 00 35 01 00 80 12 E0 83 00 91 ?? ?? ?? ?? E0 00 F8 36 E8 1F 40 79 A8 00 78 36 ?? ?? ?? ?? ?? ?? ?? ?? 00 42 61 1E 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? FF 43 03 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 CD 3B 7F 66 9E A0 E6 3F 00 00 00 00 00 00 50 40 00 00 00 00 00 00 90 3F EF 39 FA FE 42 2E E6 3F 00 00 00 00 00 00 E0 C0 00 00 00 00 00 00 44 C0 00 00 00 00 00 00 44 40 00 00 00 00 00 00 E0 40 }
	condition:
		$1
}

rule file_173_1_0 {
	meta:
		name = "_ldtgamma"
		size = 352
		refs = "002c stirling 0108 _ldunscale 0110 s 0124 _ldpoly 0128 c"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 91 50 0A 00 5C 71 02 40 FD 20 00 00 91 F1 0F 00 FD 00 22 71 1E 88 00 00 54 60 02 00 91 ?? ?? ?? ?? 47 00 00 14 10 10 7C 1E 13 10 6C 1E 20 22 70 1E A2 01 00 54 34 42 60 1E 12 10 6E 1E 60 22 71 1E F4 0B 00 FD C3 00 00 54 31 2A 72 1E 94 0A 71 1E 60 22 71 1E A2 FF FF 54 F4 0B 00 FD 31 3A 72 1E 24 00 00 14 20 22 73 1E C2 00 00 54 12 10 6E 1E 30 2A 72 1E 11 0A 71 1E F1 0B 00 FD 1E 00 00 14 10 10 6F 1E 20 22 70 1E A2 00 00 54 12 10 6E 1E 30 42 60 1E 31 3A 72 1E 07 00 00 14 14 90 60 1E 20 22 74 1E E2 00 00 54 13 10 60 1E 10 10 6E 1E 31 3A 73 1E F0 47 01 6D 1F 00 00 79 11 00 00 14 12 10 6E 1E 80 22 71 1E 53 42 60 1E F3 0B 00 FD C2 00 00 54 31 3A 72 1E 73 1A 71 1E 80 22 71 1E A3 FF FF 54 F3 0B 00 FD 13 10 60 1E 31 3A 73 1E F1 0F 00 FD E1 43 00 91 ?? ?? ?? ?? F0 47 41 6D ?? ?? ?? ?? 20 42 60 1E 70 02 00 FD ?? ?? ?? ?? E1 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? E0 13 00 FD E0 0F 40 FD C1 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? F1 C3 41 6D 10 1A 60 1E 00 0A 71 1E FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 00 00 4B 40 }
	condition:
		$1
}

rule file_438_1_0 {
	meta:
		name = "_dtgamma"
		size = 352
		refs = "002c stirling 0108 _dunscale 0110 s 0124 _dpoly 0128 c"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 91 50 0A 00 5C 71 02 40 FD 20 00 00 91 F1 0F 00 FD 00 22 71 1E 88 00 00 54 60 02 00 91 ?? ?? ?? ?? 47 00 00 14 10 10 7C 1E 13 10 6C 1E 20 22 70 1E A2 01 00 54 34 42 60 1E 12 10 6E 1E 60 22 71 1E F4 0B 00 FD C3 00 00 54 31 2A 72 1E 94 0A 71 1E 60 22 71 1E A2 FF FF 54 F4 0B 00 FD 31 3A 72 1E 24 00 00 14 20 22 73 1E C2 00 00 54 12 10 6E 1E 30 2A 72 1E 11 0A 71 1E F1 0B 00 FD 1E 00 00 14 10 10 6F 1E 20 22 70 1E A2 00 00 54 12 10 6E 1E 30 42 60 1E 31 3A 72 1E 07 00 00 14 14 90 60 1E 20 22 74 1E E2 00 00 54 13 10 60 1E 10 10 6E 1E 31 3A 73 1E F0 47 01 6D 1F 00 00 79 11 00 00 14 12 10 6E 1E 80 22 71 1E 53 42 60 1E F3 0B 00 FD C2 00 00 54 31 3A 72 1E 73 1A 71 1E 80 22 71 1E A3 FF FF 54 F3 0B 00 FD 13 10 60 1E 31 3A 73 1E F1 0F 00 FD E1 43 00 91 ?? ?? ?? ?? F0 47 41 6D ?? ?? ?? ?? 20 42 60 1E 70 02 00 FD ?? ?? ?? ?? E1 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? E0 13 00 FD E0 0F 40 FD C1 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? F1 C3 41 6D 10 1A 60 1E 00 0A 71 1E FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 00 00 4B 40 }
	condition:
		$1
}

rule file_173_3_0 {
	meta:
		name = "stirling"
		size = 200
		refs = "002c _ldpow 0054 approx0 006c _ldpoly 0098 exp"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 10 10 6C 1E 91 02 40 FD 33 00 00 91 60 02 00 91 21 3A 70 1E F1 0B 00 FD 20 42 60 1E ?? ?? ?? ?? F1 0B 40 FD 10 10 6E 1E 68 02 C0 79 E0 17 00 FD 21 00 80 52 12 1A 71 1E D1 03 00 5C E8 03 08 4B 68 02 00 79 ?? ?? ?? ?? ?? ?? ?? ?? 60 12 40 F9 50 3A 71 1E 00 42 60 1E F0 0F 00 FD ?? ?? ?? ?? 60 0A 40 F9 A1 01 80 52 E0 13 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 13 40 FD 10 1A 60 1E F0 13 00 FD F0 0B 40 FD 00 42 61 1E ?? ?? ?? ?? F1 43 42 6D 10 08 70 1E E0 03 67 9E 31 1A 70 1E 91 02 00 FD FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 DF 4A 35 D3 E6 E2 86 3F }
	condition:
		$1
}

rule file_438_2_0 {
	meta:
		name = "stirling"
		size = 200
		refs = "002c _dpow 0054 approx0 006c _dpoly 0098 exp"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 10 10 6C 1E 91 02 40 FD 33 00 00 91 60 02 00 91 21 3A 70 1E F1 0B 00 FD 20 42 60 1E ?? ?? ?? ?? F1 0B 40 FD 10 10 6E 1E 68 02 C0 79 E0 17 00 FD 21 00 80 52 12 1A 71 1E D1 03 00 5C E8 03 08 4B 68 02 00 79 ?? ?? ?? ?? ?? ?? ?? ?? 60 12 40 F9 50 3A 71 1E 00 42 60 1E F0 0F 00 FD ?? ?? ?? ?? 60 0A 40 F9 A1 01 80 52 E0 13 00 FD E0 0F 40 FD ?? ?? ?? ?? F0 13 40 FD 10 1A 60 1E F0 13 00 FD F0 0B 40 FD 00 42 61 1E ?? ?? ?? ?? F1 43 42 6D 10 08 70 1E E0 03 67 9E 31 1A 70 1E 91 02 00 FD FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 DF 4A 35 D3 E6 E2 86 3F }
	condition:
		$1
}

rule file_173_4_0 {
	meta:
		name = "tgammal"
		size = 560
		refs = "0018 _ld_int 0048 _fperrraise 004c _LNan_C 0068 _LInf_C 00a8 _ldgamma_big 0120 _ldsin 0150 _ldtgamma 0178 _ldscale"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 01 00 80 52 E0 0F 00 FD E0 A3 00 91 E0 17 00 FD ?? ?? ?? ?? F4 0F 40 FD C0 01 00 34 1F 04 00 71 A0 00 00 54 1F 08 00 71 E1 02 00 54 E0 0F 40 FD 76 00 00 14 E8 3F 40 79 A8 FF 7F 36 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6F 00 00 14 88 22 60 1E 41 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? E8 3F 40 79 ?? ?? ?? ?? 1F 01 11 72 30 42 61 1E 00 1E 71 1E 64 00 00 14 88 22 60 1E E3 FD FF 54 70 0C 00 5C 80 22 70 1E A8 00 00 54 00 02 80 52 ?? ?? ?? ?? E0 03 67 9E 5B 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 11 42 61 1E 80 22 71 1E 42 07 00 54 92 42 61 1E F3 17 40 FD F4 13 00 FD 10 10 6E 1E 01 00 80 12 E0 83 00 91 94 3A 73 1E F4 C3 02 6D 52 3A 70 1E F2 1F 00 FD ?? ?? ?? ?? F1 C3 41 6D 31 3A 70 1E 10 10 7E 1E 20 22 70 1E A2 00 00 54 F2 17 40 FD 53 42 61 1E F3 17 00 FD 02 00 00 14 F3 17 40 FD 90 08 00 5C 00 00 80 52 60 0A 70 1E F0 23 00 FD ?? ?? ?? ?? F2 0F 40 FD E1 43 00 91 F1 1B 40 FD E0 E3 00 91 F3 23 40 FD 50 42 61 1E 11 3A 71 1E 10 08 72 1E 31 8A 70 1E 72 1A 71 1E F2 13 00 FD ?? ?? ?? ?? F0 1B 40 FD E1 23 C0 79 E0 83 00 91 11 28 70 1E F0 13 40 FD 12 1A 71 1E F1 1F 40 FD 52 0A 71 1E F2 13 00 FD ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 A1 00 00 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? E0 13 40 FD 1D 00 00 14 50 04 00 5C 80 22 70 1E C8 02 00 54 E1 43 00 91 E0 63 00 91 ?? ?? ?? ?? 10 10 6E 1E E8 23 C0 79 E0 63 00 91 E0 17 00 FD 11 28 70 1E F0 0F 40 FD E1 03 08 4B 30 1A 70 1E F0 0F 00 FD ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 61 F2 FF 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? 8E FF FF 17 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C5 A8 C0 03 5F D6 00 00 00 00 00 C0 65 C0 18 2D 44 54 FB 21 09 40 00 00 00 00 00 C0 65 40 }
	condition:
		$1
}

rule file_438_3_0 {
	meta:
		name = "tgamma"
		size = 560
		refs = "0018 _d_int 0048 _fperrraise 004c _Nan_C 0068 _Inf_C 00a8 _dgamma_big 0120 _dsin 0150 _dtgamma 0178 _dscale"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 01 00 80 52 E0 0F 00 FD E0 A3 00 91 E0 17 00 FD ?? ?? ?? ?? F4 0F 40 FD C0 01 00 34 1F 04 00 71 A0 00 00 54 1F 08 00 71 E1 02 00 54 E0 0F 40 FD 76 00 00 14 E8 3F 40 79 A8 FF 7F 36 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6F 00 00 14 88 22 60 1E 41 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? E8 3F 40 79 ?? ?? ?? ?? 1F 01 11 72 30 42 61 1E 00 1E 71 1E 64 00 00 14 88 22 60 1E E3 FD FF 54 70 0C 00 5C 80 22 70 1E A8 00 00 54 00 02 80 52 ?? ?? ?? ?? E0 03 67 9E 5B 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 11 42 61 1E 80 22 71 1E 42 07 00 54 92 42 61 1E F3 17 40 FD F4 13 00 FD 10 10 6E 1E 01 00 80 12 E0 83 00 91 94 3A 73 1E F4 C3 02 6D 52 3A 70 1E F2 1F 00 FD ?? ?? ?? ?? F1 C3 41 6D 31 3A 70 1E 10 10 7E 1E 20 22 70 1E A2 00 00 54 F2 17 40 FD 53 42 61 1E F3 17 00 FD 02 00 00 14 F3 17 40 FD 90 08 00 5C 00 00 80 52 60 0A 70 1E F0 23 00 FD ?? ?? ?? ?? F2 0F 40 FD E1 43 00 91 F1 1B 40 FD E0 E3 00 91 F3 23 40 FD 50 42 61 1E 11 3A 71 1E 10 08 72 1E 31 8A 70 1E 72 1A 71 1E F2 13 00 FD ?? ?? ?? ?? F0 1B 40 FD E1 23 C0 79 E0 83 00 91 11 28 70 1E F0 13 40 FD 12 1A 71 1E F1 1F 40 FD 52 0A 71 1E F2 13 00 FD ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 A1 00 00 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? E0 13 40 FD 1D 00 00 14 50 04 00 5C 80 22 70 1E C8 02 00 54 E1 43 00 91 E0 63 00 91 ?? ?? ?? ?? 10 10 6E 1E E8 23 C0 79 E0 63 00 91 E0 17 00 FD 11 28 70 1E F0 0F 40 FD E1 03 08 4B 30 1A 70 1E F0 0F 00 FD ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 61 F2 FF 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? 8E FF FF 17 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C5 A8 C0 03 5F D6 00 00 00 00 00 C0 65 C0 18 2D 44 54 FB 21 09 40 00 00 00 00 00 C0 65 40 }
	condition:
		$1
}

rule file_174_0_0 {
	meta:
		name = "_derfc"
		size = 88
		refs = "000c _s 001c _dpoly 0020 _c 0048 _dexp"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 10 88 60 1E ?? ?? ?? ?? F0 03 01 6D C1 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 13 00 FD E0 0F 40 FD C1 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? F0 13 40 FD 01 00 80 52 E0 43 00 91 00 1A 60 1E ?? ?? ?? ?? E0 0B 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_338_0_0 {
	meta:
		name = "_lderfc"
		size = 88
		refs = "000c _s 001c _ldpoly 0020 _c 0048 _ldexp"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 10 88 60 1E ?? ?? ?? ?? F0 03 01 6D C1 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E0 13 00 FD E0 0F 40 FD C1 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? F0 13 40 FD 01 00 80 52 E0 43 00 91 00 1A 60 1E ?? ?? ?? ?? E0 0B 40 FD FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_174_1_0 {
	meta:
		name = "erf"
		size = 384
		refs = "0010 _dtest 002c _derf_small 00b8 _derf_one 00c8 _derfc"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? A0 07 00 34 1F 04 00 71 A0 06 00 54 1F 08 00 71 20 07 00 54 E7 0B 40 FD ?? ?? ?? ?? ?? ?? ?? ?? E0 C0 60 1E 00 20 70 1E E2 03 00 54 FE 08 67 1E B2 06 00 5C D1 06 00 5C F8 06 00 5C 10 07 00 5C D3 47 52 1F 12 07 00 5C D9 43 58 1F 18 07 00 5C 1F 10 6E 1E 74 4A 5E 1F F3 06 00 5C 95 4E 5E 1F F4 06 00 5C B6 52 5E 1F F5 06 00 5C D7 56 5E 1F F6 06 00 5C FD 5A 5E 1F F7 06 00 5C 3A 5F 5E 1F F9 06 00 5C 5B 63 5E 1F FA 06 00 5C 7C 67 5E 1F 91 6B 5E 1F 31 7E 5E 1F B2 1B 71 1E 40 0A 67 1E 16 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 70 1E C2 00 00 54 ?? ?? ?? ?? 1F 10 6E 1E E7 0B 40 FD FF 3B 60 1E 02 00 00 14 1F 10 6E 1E F0 43 61 1E E8 20 60 1E 00 3E 7F 1E 08 00 00 14 E8 2F 40 79 11 10 7E 1E 1F 10 6E 1E 1F 01 11 72 20 1E 7F 1E 02 00 00 14 E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 67 3E 76 81 41 29 80 3E 69 20 49 94 93 9E E2 3E D1 53 87 C9 F7 96 B7 3E E5 70 D2 CE CB 9F 0E 3F 3E 30 56 72 0A 80 35 3F DF 10 9A 9A C7 40 8D 3F 62 5B 02 D3 36 85 6C 3F 0A CE FC 99 24 7C AA 3F 86 72 09 F2 96 95 C6 3F 6D 9B 42 50 D7 0D F2 3F E6 74 61 30 1C 3D 53 3F 6F FF 10 D7 6A EC BB 3F E4 49 ED C8 3B 57 DF 3F }
	condition:
		$1
}

rule file_338_1_0 {
	meta:
		name = "erfl"
		size = 384
		refs = "0010 _ldtest 002c _lderf_small 00b8 _lderf_one 00c8 _lderfc"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? A0 07 00 34 1F 04 00 71 A0 06 00 54 1F 08 00 71 20 07 00 54 E7 0B 40 FD ?? ?? ?? ?? ?? ?? ?? ?? E0 C0 60 1E 00 20 70 1E E2 03 00 54 FE 08 67 1E B2 06 00 5C D1 06 00 5C F8 06 00 5C 10 07 00 5C D3 47 52 1F 12 07 00 5C D9 43 58 1F 18 07 00 5C 1F 10 6E 1E 74 4A 5E 1F F3 06 00 5C 95 4E 5E 1F F4 06 00 5C B6 52 5E 1F F5 06 00 5C D7 56 5E 1F F6 06 00 5C FD 5A 5E 1F F7 06 00 5C 3A 5F 5E 1F F9 06 00 5C 5B 63 5E 1F FA 06 00 5C 7C 67 5E 1F 91 6B 5E 1F 31 7E 5E 1F B2 1B 71 1E 40 0A 67 1E 16 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 70 1E C2 00 00 54 ?? ?? ?? ?? 1F 10 6E 1E E7 0B 40 FD FF 3B 60 1E 02 00 00 14 1F 10 6E 1E F0 43 61 1E E8 20 60 1E 00 3E 7F 1E 08 00 00 14 E8 2F 40 79 11 10 7E 1E 1F 10 6E 1E 1F 01 11 72 20 1E 7F 1E 02 00 00 14 E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 67 3E 76 81 41 29 80 3E 69 20 49 94 93 9E E2 3E D1 53 87 C9 F7 96 B7 3E E5 70 D2 CE CB 9F 0E 3F 3E 30 56 72 0A 80 35 3F DF 10 9A 9A C7 40 8D 3F 62 5B 02 D3 36 85 6C 3F 0A CE FC 99 24 7C AA 3F 86 72 09 F2 96 95 C6 3F 6D 9B 42 50 D7 0D F2 3F E6 74 61 30 1C 3D 53 3F 6F FF 10 D7 6A EC BB 3F E4 49 ED C8 3B 57 DF 3F }
	condition:
		$1
}

rule file_175_3_0 {
	meta:
		name = "?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
		size = 148
		refs = "0024 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BD A9 FD 03 00 91 33 00 00 11 01 00 00 91 E0 43 00 91 55 00 00 11 74 00 00 11 ?? ?? ?? ?? E8 13 40 F9 6A 1E 00 53 08 41 2A 8B 09 65 40 39 29 01 14 0A 69 01 00 35 D5 00 00 34 E8 0F 40 F9 08 01 40 F9 09 59 6A 78 2A 01 15 0A 02 00 00 14 0A 00 80 52 6A 00 00 35 00 00 80 52 02 00 00 14 20 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_175_5_0 {
	meta:
		name = "_ismbbalnum"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 23 00 80 52 E2 20 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_6_0 {
	meta:
		name = "_ismbbalnum_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 23 00 80 52 E2 20 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_7_0 {
	meta:
		name = "_ismbbalpha"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 23 00 80 52 62 20 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_8_0 {
	meta:
		name = "_ismbbalpha_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 23 00 80 52 62 20 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_9_0 {
	meta:
		name = "_ismbbblank"
		size = 40
		refs = "0020 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 1F 24 00 71 61 00 00 54 00 08 80 52 06 00 00 14 01 00 00 11 00 00 80 D2 43 00 80 52 02 08 80 52 ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_175_10_0 {
	meta:
		name = "_ismbbblank_l"
		size = 44
		refs = "0024 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 28 00 00 91 1F 24 00 71 61 00 00 54 00 08 80 52 06 00 00 14 01 00 00 11 00 01 00 91 43 00 80 52 02 08 80 52 ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_175_11_0 {
	meta:
		name = "_ismbbgraph"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 63 00 80 52 E2 22 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_12_0 {
	meta:
		name = "_ismbbgraph_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 63 00 80 52 E2 22 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_13_0 {
	meta:
		name = "_ismbbkalnum"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 23 00 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_14_0 {
	meta:
		name = "_ismbbkalnum_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 23 00 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_16_0 {
	meta:
		name = "_ismbbkana_l"
		size = 112
		refs = "0018 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0040 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 11 E0 43 00 91 33 00 00 91 ?? ?? ?? ?? E8 13 40 F9 48 01 00 B4 08 05 40 B9 1F 91 0E 71 E1 00 00 54 63 00 80 52 02 00 80 52 81 02 00 11 60 02 00 91 ?? ?? ?? ?? 02 00 00 14 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_175_17_0 {
	meta:
		name = "_ismbbkprint"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 63 00 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_18_0 {
	meta:
		name = "_ismbbkprint_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 63 00 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_19_0 {
	meta:
		name = "_ismbbkpunct"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 43 00 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_20_0 {
	meta:
		name = "_ismbbkpunct_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 43 00 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_21_0 {
	meta:
		name = "_ismbblead"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 83 00 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_22_0 {
	meta:
		name = "_ismbblead_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 83 00 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_23_0 {
	meta:
		name = "_ismbbprint"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 63 00 80 52 E2 2A 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_24_0 {
	meta:
		name = "_ismbbprint_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 63 00 80 52 E2 2A 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_25_0 {
	meta:
		name = "_ismbbpunct"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 43 00 80 52 02 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_26_0 {
	meta:
		name = "_ismbbpunct_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 43 00 80 52 02 02 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_27_0 {
	meta:
		name = "_ismbbtrail"
		size = 20
		refs = "0010 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 01 00 00 11 00 00 80 D2 03 01 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_175_28_0 {
	meta:
		name = "_ismbbtrail_l"
		size = 24
		refs = "0014 ?x_ismbbtype_l@@YAHPEAU__crt_locale_pointers@@IHH@Z"
	strings:
		$1 = { 08 00 00 11 20 00 00 91 01 01 00 11 03 01 80 52 02 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_176_0_0 {
	meta:
		name = "??$common_tcsnset_s@_W@@YAHQEA_W_K_W1@Z"
		size = 144
		refs = "0074 _errno 0080 _invalid_parameter_noinfo"
		altNames = "_wcsnset_s"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 A3 00 00 B5 A0 00 00 B5 21 03 00 B5 00 00 80 52 1C 00 00 14 C0 02 00 B4 A1 02 00 B4 08 00 40 79 0B 00 00 91 28 01 00 34 03 01 00 B4 21 04 00 D1 C1 00 00 B4 62 01 00 79 6B 09 00 91 69 01 40 79 63 04 00 D1 29 FF FF 35 E3 00 00 B5 68 01 40 79 A8 00 00 34 21 04 00 D1 61 00 00 B4 6A 2D 40 78 AA FF FF 35 41 FD FF B5 1F 00 00 79 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_177_1_0 {
	meta:
		name = "cacosl"
		size = 712
		refs = "0010 creall 0020 cimagl 002c _ldtest 0080 _LInf_C 0134 _LCbuild 0138 csqrtl 01b0 conjl 01c0 atan2 0244 asinhl 026c log"
	strings:
		$1 = { F3 0F 1F F8 FD 7B B9 A9 FD 03 00 91 E0 87 05 6D ?? ?? ?? ?? E1 33 40 FD E0 13 00 FD E0 2F 40 FD ?? ?? ?? ?? E0 83 00 91 E0 0F 00 FD ?? ?? ?? ?? 13 00 00 11 E0 63 00 91 ?? ?? ?? ?? 7F 0A 00 71 61 01 00 54 F0 13 40 FD 1F 08 00 71 81 00 00 54 F0 0B 00 FD F0 0F 40 FD 8C 00 00 14 F0 0B 00 FD 1F 04 00 71 21 11 00 54 2B 00 00 14 1F 08 00 71 C1 01 00 54 7F 06 00 71 C1 00 00 54 F0 0F 40 FD ?? ?? ?? ?? F0 0B 00 FD ?? ?? ?? ?? 7F 00 00 14 73 00 00 35 70 10 00 5C EE FF FF 17 F0 0F 40 FD F0 0B 00 FD 79 00 00 14 7F 06 00 71 C1 02 00 54 1F 04 00 71 01 01 00 54 F0 13 40 FD 71 0F 00 5C 08 22 60 1E 70 0F 00 5C 21 3E 70 1E E1 0B 00 FD 07 00 00 14 F2 13 40 FD 13 0F 00 5C F0 03 67 9E 48 22 60 1E 70 3E 70 1E F0 0B 00 FD ?? ?? ?? ?? ?? ?? ?? ?? E8 3F 40 79 70 42 61 1E 68 0C 78 36 06 00 00 14 1F 04 00 71 C1 00 00 54 B0 0C 00 5C F0 0B 00 FD F0 0F 40 FD 10 42 61 1E 5B 00 00 14 F1 C3 41 6D 21 42 61 1E 11 10 6E 1E 00 2A 71 1E F1 1F 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 0F 40 FD E1 1B 00 FD F1 1F 40 FD E0 0B 00 FD 01 42 61 1E F0 13 40 FD 20 3A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? E1 17 00 FD E1 1B 40 FD E0 27 00 FD E0 0B 40 FD ?? ?? ?? ?? E1 1B 40 FD E0 2B 00 FD E0 0B 40 FD ?? ?? ?? ?? E1 17 40 FD E0 1F 00 FD E0 27 40 FD ?? ?? ?? ?? E1 17 40 FD E0 23 00 FD E0 27 40 FD ?? ?? ?? ?? E1 1B 40 FD E0 17 00 FD E0 0B 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 01 40 60 1E E0 17 40 FD ?? ?? ?? ?? 10 10 60 1E F3 2B 40 FD B1 07 00 5C F2 D3 43 6D 10 08 70 1E 20 22 73 1E F0 0B 00 FD C2 00 00 54 F0 17 40 FD F3 1B 00 FD 11 1A 73 1E 20 52 52 1F 14 00 00 14 20 22 72 1E C2 00 00 54 F2 1B 00 FD 92 1A 72 1E F0 17 40 FD 40 42 53 1F 0D 00 00 14 50 42 61 1E F0 1B 00 FD 20 22 70 1E A2 00 00 54 90 1A 70 1E F4 17 40 FD 00 52 53 1F 05 00 00 14 F0 17 40 FD FF 1B 00 F9 11 0A 72 1E 80 46 53 1F ?? ?? ?? ?? F2 1B 40 FD 10 40 60 1E F0 1F 00 FD 48 22 60 1E 80 01 00 54 F1 0B 40 FD 40 42 60 1E 28 22 60 1E AB 00 00 54 ?? ?? ?? ?? F0 1F 40 FD 10 28 70 1E 04 00 00 14 ?? ?? ?? ?? F0 1F 40 FD 10 3A 60 1E E0 0B 40 FD 01 42 60 1E ?? ?? ?? ?? FD 7B C7 A8 F3 07 41 F8 C0 03 5F D6 18 2D 44 54 FB 21 F9 3F D2 21 33 7F 7C D9 02 40 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 09 40 7B 52 82 BD 3A FB CF 5F }
	condition:
		$1
}

rule file_646_0_0 {
	meta:
		name = "cacos"
		size = 712
		refs = "0010 creal 0020 cimag 002c _dtest 0080 _Inf_C 0134 _Cbuild 0138 csqrt 01b0 conj 01c0 atan2 0244 asinh 026c log"
	strings:
		$1 = { F3 0F 1F F8 FD 7B B9 A9 FD 03 00 91 E0 87 05 6D ?? ?? ?? ?? E1 33 40 FD E0 13 00 FD E0 2F 40 FD ?? ?? ?? ?? E0 83 00 91 E0 0F 00 FD ?? ?? ?? ?? 13 00 00 11 E0 63 00 91 ?? ?? ?? ?? 7F 0A 00 71 61 01 00 54 F0 13 40 FD 1F 08 00 71 81 00 00 54 F0 0B 00 FD F0 0F 40 FD 8C 00 00 14 F0 0B 00 FD 1F 04 00 71 21 11 00 54 2B 00 00 14 1F 08 00 71 C1 01 00 54 7F 06 00 71 C1 00 00 54 F0 0F 40 FD ?? ?? ?? ?? F0 0B 00 FD ?? ?? ?? ?? 7F 00 00 14 73 00 00 35 70 10 00 5C EE FF FF 17 F0 0F 40 FD F0 0B 00 FD 79 00 00 14 7F 06 00 71 C1 02 00 54 1F 04 00 71 01 01 00 54 F0 13 40 FD 71 0F 00 5C 08 22 60 1E 70 0F 00 5C 21 3E 70 1E E1 0B 00 FD 07 00 00 14 F2 13 40 FD 13 0F 00 5C F0 03 67 9E 48 22 60 1E 70 3E 70 1E F0 0B 00 FD ?? ?? ?? ?? ?? ?? ?? ?? E8 3F 40 79 70 42 61 1E 68 0C 78 36 06 00 00 14 1F 04 00 71 C1 00 00 54 B0 0C 00 5C F0 0B 00 FD F0 0F 40 FD 10 42 61 1E 5B 00 00 14 F1 C3 41 6D 21 42 61 1E 11 10 6E 1E 00 2A 71 1E F1 1F 00 FD ?? ?? ?? ?? ?? ?? ?? ?? F0 0F 40 FD E1 1B 00 FD F1 1F 40 FD E0 0B 00 FD 01 42 61 1E F0 13 40 FD 20 3A 70 1E ?? ?? ?? ?? ?? ?? ?? ?? E1 17 00 FD E1 1B 40 FD E0 27 00 FD E0 0B 40 FD ?? ?? ?? ?? E1 1B 40 FD E0 2B 00 FD E0 0B 40 FD ?? ?? ?? ?? E1 17 40 FD E0 1F 00 FD E0 27 40 FD ?? ?? ?? ?? E1 17 40 FD E0 23 00 FD E0 27 40 FD ?? ?? ?? ?? E1 1B 40 FD E0 17 00 FD E0 0B 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 01 40 60 1E E0 17 40 FD ?? ?? ?? ?? 10 10 60 1E F3 2B 40 FD B1 07 00 5C F2 D3 43 6D 10 08 70 1E 20 22 73 1E F0 0B 00 FD C2 00 00 54 F0 17 40 FD F3 1B 00 FD 11 1A 73 1E 20 52 52 1F 14 00 00 14 20 22 72 1E C2 00 00 54 F2 1B 00 FD 92 1A 72 1E F0 17 40 FD 40 42 53 1F 0D 00 00 14 50 42 61 1E F0 1B 00 FD 20 22 70 1E A2 00 00 54 90 1A 70 1E F4 17 40 FD 00 52 53 1F 05 00 00 14 F0 17 40 FD FF 1B 00 F9 11 0A 72 1E 80 46 53 1F ?? ?? ?? ?? F2 1B 40 FD 10 40 60 1E F0 1F 00 FD 48 22 60 1E 80 01 00 54 F1 0B 40 FD 40 42 60 1E 28 22 60 1E AB 00 00 54 ?? ?? ?? ?? F0 1F 40 FD 10 28 70 1E 04 00 00 14 ?? ?? ?? ?? F0 1F 40 FD 10 3A 60 1E E0 0B 40 FD 01 42 60 1E ?? ?? ?? ?? FD 7B C7 A8 F3 07 41 F8 C0 03 5F D6 18 2D 44 54 FB 21 F9 3F D2 21 33 7F 7C D9 02 40 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 09 40 7B 52 82 BD 3A FB CF 5F }
	condition:
		$1
}

rule file_179_5_0 {
	meta:
		name = "_mbctoupper_l"
		size = 200
		refs = "0018 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c __acrt_LCMapStringA"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 FF 43 00 D1 13 00 00 11 E0 A3 00 91 ?? ?? ?? ?? EA 1F 40 F9 7F FE 03 71 09 03 00 54 68 7E 08 53 F3 87 00 39 09 1D 00 53 28 01 0A 8B E9 83 00 39 09 65 40 39 E9 02 10 36 47 05 40 B9 28 00 80 52 41 11 41 F9 46 00 80 52 E8 03 00 B9 E5 93 00 91 44 00 80 52 E3 83 00 91 02 40 80 52 E0 C3 00 91 ?? ?? ?? ?? 60 01 00 34 E9 93 40 39 E8 97 40 39 13 21 09 0B 07 00 00 14 68 06 00 11 48 C1 28 8B 09 61 40 39 69 00 28 36 48 C1 33 8B 13 65 44 39 E8 03 41 39 A8 00 00 34 EA 17 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 00 91 FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_180_11_0 {
	meta:
		name = "?free_crt_array_internal@@YAXQEAPEBX_K@Z"
		size = 88
		refs = "0038 _free_base"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 8B 0E 01 8B 13 00 80 D2 68 01 14 CB 09 1D 00 91 2A FD 43 D3 9F 02 0B EB F5 83 8A 9A D5 00 00 B4 80 86 40 F8 ?? ?? ?? ?? 73 06 00 91 7F 02 15 EB 81 FF FF 54 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_180_13_0 {
	meta:
		name = "?get_or_create_lc_time@@YAPEBU__crt_lc_time_data@@QEAU__crt_locale_data@@@Z"
		size = 132
		refs = "001c __lc_time_c 0030 _calloc_base 0044 ?initialize_lc_time@@YA_NQEAU__crt_lc_time_data@@QEAU__crt_locale_data@@@Z 0050 __acrt_locale_free_time 005c _free_base"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 15 00 00 91 A8 AA 40 F9 88 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 10 00 00 14 01 58 80 D2 20 00 80 D2 ?? ?? ?? ?? 14 00 00 91 93 02 00 91 D4 00 00 B4 A1 02 00 91 ?? ?? ?? ?? 60 01 00 35 80 02 00 91 ?? ?? ?? ?? 14 00 80 D2 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 28 00 80 52 88 5E 01 B9 13 00 80 D2 F6 FF FF 17 }
	condition:
		$1
}

rule file_180_14_0 {
	meta:
		name = "?initialize_lc_time@@YA_NQEAU__crt_lc_time_data@@QEAU__crt_locale_data@@@Z"
		size = 780
		refs = "0030 __acrt_copy_locale_name 006c __acrt_GetLocaleInfoA"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 73 04 A9 FD 7B BC A9 FD 03 00 91 37 A8 40 F9 19 00 00 91 E1 FF 02 A9 F9 DF 01 A9 E0 02 00 91 ?? ?? ?? ?? 1A 00 80 52 20 5F 01 F9 38 06 80 52 FB 00 80 52 09 C3 00 51 EA 00 80 52 28 09 CA 1A 03 03 00 11 E2 02 00 91 21 00 80 52 E0 A3 00 91 09 A5 0A 1B 35 0F 09 8B A4 02 00 91 ?? ?? ?? ?? A4 E2 00 91 16 00 00 11 E0 A3 00 91 03 1F 00 51 E2 02 00 91 21 00 80 52 ?? ?? ?? ?? A4 82 05 91 14 00 00 11 E0 A3 00 91 03 03 00 11 E2 02 00 91 41 00 80 52 ?? ?? ?? ?? A4 62 06 91 13 00 00 11 E0 A3 00 91 03 1F 00 51 E2 02 00 91 41 00 80 52 ?? ?? ?? ?? 18 07 00 11 08 00 13 2A 09 01 14 2A 2A 01 16 2A 5A 01 1A 2A 7B 07 00 51 5B FB FF 35 38 43 03 91 99 01 80 52 16 07 80 52 04 83 01 D1 C3 32 00 11 E2 02 00 91 21 00 80 52 E0 A3 00 91 ?? ?? ?? ?? 04 03 00 91 15 00 00 11 E0 A3 00 91 C3 02 00 11 E2 02 00 91 21 00 80 52 ?? ?? ?? ?? 04 03 04 91 14 00 00 11 E0 A3 00 91 C3 32 00 11 E2 02 00 91 41 00 80 52 ?? ?? ?? ?? 04 83 05 91 13 00 00 11 E0 A3 00 91 C3 02 00 11 E2 02 00 91 41 00 80 52 ?? ?? ?? ?? D6 06 00 11 08 00 13 2A 09 01 14 2A 2A 01 15 2A 5A 01 1A 2A 18 23 00 91 39 07 00 51 D9 FB FF 35 F4 0F 40 F9 03 05 80 52 FA 13 00 B9 E2 02 00 91 21 00 80 52 E0 A3 00 91 84 C2 04 91 ?? ?? ?? ?? 84 E2 04 91 1C 00 00 11 E0 A3 00 91 23 05 80 52 E2 02 00 91 21 00 80 52 ?? ?? ?? ?? 84 42 0A 91 1B 00 00 11 E0 A3 00 91 03 05 80 52 E2 02 00 91 41 00 80 52 ?? ?? ?? ?? 84 62 0A 91 1A 00 00 11 E0 A3 00 91 23 05 80 52 E2 02 00 91 41 00 80 52 ?? ?? ?? ?? 84 02 05 91 19 00 00 11 E0 A3 00 91 E3 03 80 52 E2 02 00 91 21 00 80 52 ?? ?? ?? ?? 84 22 05 91 18 00 00 11 E0 A3 00 91 03 04 80 52 E2 02 00 91 21 00 80 52 ?? ?? ?? ?? F3 13 40 F9 84 42 05 91 17 00 00 11 63 00 82 52 21 00 80 52 62 02 00 91 E0 A3 00 91 ?? ?? ?? ?? 84 62 05 91 16 00 00 11 E0 A3 00 91 23 01 82 52 62 02 00 91 01 00 80 52 ?? ?? ?? ?? 84 82 0A 91 15 00 00 11 E0 A3 00 91 E3 03 80 52 62 02 00 91 41 00 80 52 ?? ?? ?? ?? E8 0F 40 F9 03 04 80 52 14 00 00 11 62 02 00 91 41 00 80 52 04 A1 0A 91 E0 A3 00 91 ?? ?? ?? ?? E8 8B 41 A9 63 00 82 52 41 00 80 52 13 00 00 11 E0 A3 00 91 04 C1 0A 91 ?? ?? ?? ?? 08 00 13 2A 09 01 14 2A 2A 01 15 2A 4B 01 16 2A 68 01 17 2A 09 01 18 2A 2A 01 19 2A 4B 01 1A 2A EA 13 40 B9 68 01 1B 2A 09 01 1C 2A 2A 01 0A 2A 5F 01 00 71 E0 17 9F 1A FD 7B C4 A8 FB 73 44 A9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_180_17_0 {
	meta:
		name = "__acrt_locale_free_time"
		size = 204
		refs = "0018 ?free_crt_array_internal@@YAXQEAPEBX_K@Z 0050 _free_base"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 93 05 00 B4 E1 00 80 D2 ?? ?? ?? ?? E1 00 80 D2 60 E2 00 91 ?? ?? ?? ?? 81 01 80 D2 60 C2 01 91 ?? ?? ?? ?? 81 01 80 D2 60 42 03 91 ?? ?? ?? ?? 41 00 80 D2 60 C2 04 91 ?? ?? ?? ?? 60 A2 40 F9 ?? ?? ?? ?? 60 A6 40 F9 ?? ?? ?? ?? 60 AA 40 F9 ?? ?? ?? ?? E1 00 80 D2 60 82 05 91 ?? ?? ?? ?? E1 00 80 D2 60 62 06 91 ?? ?? ?? ?? 81 01 80 D2 60 42 07 91 ?? ?? ?? ?? 81 01 80 D2 60 C2 08 91 ?? ?? ?? ?? 41 00 80 D2 60 42 0A 91 ?? ?? ?? ?? 60 52 41 F9 ?? ?? ?? ?? 60 56 41 F9 ?? ?? ?? ?? 60 5A 41 F9 ?? ?? ?? ?? 60 5E 41 F9 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_180_18_0 {
	meta:
		name = "__acrt_locale_initialize_time"
		size = 148
		refs = "0018 __lc_time_c 002c _calloc_base 0048 ?initialize_lc_time@@YA_NQEAU__crt_lc_time_data@@QEAU__crt_locale_data@@@Z 0054 __acrt_locale_free_time 005c _free_base 007c __acrt_locale_release_lc_time_reference"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 88 AA 40 F9 88 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 16 00 00 14 01 58 80 D2 20 00 80 D2 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 00 00 80 D2 08 00 00 14 81 02 00 91 60 02 00 91 ?? ?? ?? ?? E0 00 00 35 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 20 00 80 52 09 00 00 14 28 00 80 52 00 00 80 D2 68 5E 01 B9 ?? ?? ?? ?? 80 92 40 F9 ?? ?? ?? ?? 93 92 00 F9 00 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_181_1_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_handle_traits@@@@QEAA@XZ"
		size = 64
		refs = "001c __imp_CloseHandle"
		altNames = "?close@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QEAAXXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 1F 04 00 B1 E0 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 08 00 80 92 68 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_531_37_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QEAA@XZ"
		size = 64
		refs = "001c __imp_FindClose"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 1F 04 00 B1 E0 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 08 00 80 92 68 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_531_58_0 {
	meta:
		name = "?close@?$__crt_unique_handle_t@U__crt_findfile_traits@@@@QEAAXXZ"
		size = 64
		refs = "001c __imp_FindClose"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 1F 04 00 B1 E0 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 08 00 80 92 68 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_181_3_0 {
	meta:
		name = "?close@__crt_handle_traits@@SA_NPEAX@Z"
		size = 40
		refs = "0008 __imp_CloseHandle"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 1F 00 00 71 E0 07 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_531_59_0 {
	meta:
		name = "?close@__crt_findfile_traits@@SA_NPEAX@Z"
		size = 40
		refs = "0008 __imp_FindClose"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 1F 00 00 71 E0 07 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_283_23_0 {
	meta:
		name = "?close@__crt_hmodule_traits@@SA_NPEAUHINSTANCE__@@@Z"
		size = 40
		refs = "0008 __imp_FreeLibrary"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 1F 00 00 71 E0 07 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_508_0_0 {
	meta:
		name = "__acrt_initialize_command_line"
		size = 68
		refs = "0008 __imp_GetCommandLineA 0018 _acmdln 0020 __imp_GetCommandLineW 0030 _wcmdln"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_181_6_0 {
	meta:
		name = "_cwait"
		size = 252
		refs = "0030 __imp_WaitForSingleObject 004c __imp_GetExitCodeProcess 007c __imp_GetLastError 0094 _errno 00a0 __doserrno 00b0 __acrt_errno_map_os_error 00c0 __imp_CloseHandle"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 34 00 00 91 15 00 80 12 53 00 00 B4 75 02 00 B9 88 0A 00 91 1F 05 00 F1 89 05 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 01 00 80 12 80 02 00 91 20 01 3F D6 A0 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 E1 43 00 91 80 02 00 91 20 01 3F D6 C0 00 00 34 73 00 00 B4 E8 13 40 B9 68 02 00 B9 93 02 00 91 12 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 1F 18 00 71 01 01 00 54 ?? ?? ?? ?? 48 01 80 52 08 00 00 B9 ?? ?? ?? ?? C8 00 80 52 08 00 00 B9 02 00 00 14 ?? ?? ?? ?? 53 00 00 B4 75 02 00 B9 13 00 80 92 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 80 02 00 91 20 01 3F D6 60 02 00 91 05 00 00 14 ?? ?? ?? ?? 48 01 80 52 08 00 00 B9 00 00 80 92 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_182_1_0 {
	meta:
		name = "GetLocaleNameFromDefault"
		size = 164
		refs = "000c __security_push_cookie 0030 __acrt_GetUserDefaultLocaleName 0070 wcsncpy_s 007c __security_pop_cookie 00a0 _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 F3 0B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 02 D1 13 00 00 91 68 12 40 B9 89 20 80 52 A1 0A 80 52 E0 03 00 91 08 01 09 2A 68 12 00 B9 ?? ?? ?? ?? 1F 04 00 71 0D 02 00 54 E8 03 C0 79 E9 03 00 91 88 00 00 34 29 09 00 91 28 01 C0 79 C8 FF FF 35 E8 03 00 91 28 01 08 CB 09 FD 41 93 23 05 00 91 E2 03 00 91 A1 0A 80 D2 60 62 09 91 ?? ?? ?? ?? C0 00 00 35 FF C3 02 91 ?? ?? ?? ?? F3 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_2_0 {
	meta:
		name = "GetLocaleNameFromLangCountry"
		size = 196
		refs = "007c GetPrimaryLen 0080 LangCountryEnumProcEx 0098 __acrt_EnumSystemLocalesEx"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 08 00 C0 79 0A 00 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 00 CB 6C 06 40 F9 09 F9 7F 92 3F 19 00 F1 ED 17 9F 1A 6D 1A 00 B9 8B 01 00 91 88 01 C0 79 88 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 68 01 0C CB 09 F9 7F 92 3F 19 00 F1 EA 17 9F 1A 6A 1E 00 B9 6D 00 00 34 40 00 80 52 02 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 60 16 00 B9 ?? ?? ?? ?? 03 00 80 D2 02 00 80 D2 61 00 80 52 ?? ?? ?? ?? 69 12 40 B9 28 05 18 12 1F 01 0C 71 61 00 00 54 28 09 00 12 48 00 00 35 7F 12 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_182_3_0 {
	meta:
		name = "GetLocaleNameFromLanguage"
		size = 132
		refs = "004c GetPrimaryLen 0050 LanguageEnumProcEx 0068 __acrt_EnumSystemLocalesEx"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 08 00 C0 79 0A 00 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 00 CB 09 F9 7F 92 3F 19 00 F1 EA 17 9F 1A 6A 1A 00 B9 6A 00 00 34 40 00 80 52 02 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 60 16 00 B9 ?? ?? ?? ?? 03 00 80 D2 02 00 80 D2 61 00 80 52 ?? ?? ?? ?? 68 12 40 B9 48 00 10 37 7F 12 00 B9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_182_4_0 {
	meta:
		name = "GetPrimaryLen"
		size = 76
	strings:
		$1 = { 08 00 00 91 00 00 80 52 48 00 00 B5 C0 03 5F D6 0A 01 40 79 0C 09 00 91 E9 F7 9F 52 48 01 09 0B 09 3D 00 53 3F 65 00 71 C9 00 00 54 EB F3 9F 52 4A 01 0B 0B 4B 3D 00 53 7F 65 00 71 88 FE FF 54 8A 25 40 78 00 04 00 11 F4 FF FF 17 }
	condition:
		$1
}

rule file_182_5_0 {
	meta:
		name = "LangCountryEnumProcEx"
		size = 1044
		refs = "0010 __security_push_cookie 001c __acrt_getptd 0044 __acrt_GetLocaleInfoEx 0060 _wcsicmp 00e0 wcsncpy_s 0104 _wcsnicmp 0160 TestDefaultCountry 029c GetPrimaryLen 0370 __security_pop_cookie 0398 _invoke_watson"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 03 02 D1 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 68 B6 40 B9 EA 00 80 52 49 00 82 52 03 08 80 52 E2 03 00 91 1F 01 00 71 41 11 89 1A 80 02 00 91 ?? ?? ?? ?? 80 00 00 35 7F AA 00 B9 20 00 80 52 C6 00 00 14 60 52 40 F9 E1 03 00 91 ?? ?? ?? ?? 40 0A 00 35 68 B2 40 B9 6A 00 80 52 29 00 82 52 03 08 80 52 E2 03 00 91 1F 01 00 71 41 11 89 1A 80 02 00 91 ?? ?? ?? ?? 00 FE FF 34 60 4E 40 F9 E1 03 00 91 ?? ?? ?? ?? 68 AA 40 B9 60 02 00 35 89 60 80 52 08 01 09 2A 68 AA 00 B9 8B 02 00 91 89 02 C0 79 89 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 68 01 14 CB 09 FD 41 93 23 05 00 91 82 02 00 91 A1 0A 80 D2 60 C2 0B 91 ?? ?? ?? ?? 40 06 00 34 A7 00 00 14 08 06 08 37 69 AE 40 B9 09 03 00 34 60 4E 40 F9 22 7D 40 93 E1 03 00 91 ?? ?? ?? ?? 60 02 00 35 68 AA 40 B9 8B 02 00 91 09 01 1F 32 69 AA 00 B9 88 02 C0 79 88 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 68 01 14 CB 09 FD 41 93 23 05 00 91 82 02 00 91 A1 0A 80 D2 60 C2 0B 91 ?? ?? ?? ?? 00 03 00 34 93 00 00 14 68 AA 40 B9 A8 02 00 37 80 02 00 91 ?? ?? ?? ?? 40 02 00 34 68 AA 40 B9 8B 02 00 91 09 01 00 32 69 AA 00 B9 88 02 C0 79 88 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 68 01 14 CB 09 FD 41 93 23 05 00 91 82 02 00 91 A1 0A 80 D2 60 C2 0B 91 ?? ?? ?? ?? 60 10 00 35 68 AA 40 B9 09 05 18 12 3F 01 0C 71 40 0D 00 54 68 B2 40 B9 6A 00 80 52 29 00 82 52 03 08 80 52 E2 03 00 91 1F 01 00 71 41 11 89 1A 80 02 00 91 ?? ?? ?? ?? 60 F3 FF 34 60 4E 40 F9 E1 03 00 91 ?? ?? ?? ?? 80 0B 00 35 68 AA 40 B9 69 B2 40 B9 0B 01 17 32 6B AA 00 B9 89 02 00 34 68 01 18 32 69 E2 45 79 68 AA 00 B9 69 0A 00 35 88 02 C0 79 8B 02 00 91 88 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 68 01 14 CB 09 FD 41 93 23 05 00 91 82 02 00 91 A1 0A 80 D2 60 C2 0B 91 ?? ?? ?? ?? A0 08 00 34 5F 00 00 14 6D AE 40 B9 0D 06 00 34 6C 4E 40 F9 88 01 C0 79 8A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 0C CB 09 FD 41 93 3F 01 0D 6B A1 04 00 54 80 02 00 91 ?? ?? ?? ?? C0 01 00 35 75 4E 40 F9 A0 02 00 91 ?? ?? ?? ?? A8 02 C0 79 AA 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 15 CB 09 FD 41 93 1F 00 09 6B E0 04 00 54 68 AA 40 B9 6A E2 45 79 09 01 18 32 69 AA 00 B9 4A 04 00 35 88 02 C0 79 8C 02 00 91 88 00 00 34 8C 09 00 91 8B 01 C0 79 CB FF FF 35 88 01 14 CB 09 FD 41 93 23 05 00 91 82 02 00 91 A1 0A 80 D2 60 C2 0B 91 ?? ?? ?? ?? 80 02 00 34 34 00 00 14 68 01 18 32 69 E2 45 79 68 AA 00 B9 E9 01 00 35 88 02 C0 79 8B 02 00 91 88 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 68 01 14 CB 09 FD 41 93 23 05 00 91 82 02 00 91 A1 0A 80 D2 60 C2 0B 91 ?? ?? ?? ?? 00 05 00 35 68 AA 40 B9 E9 0B 68 2A 20 01 00 12 FF 03 02 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_6_0 {
	meta:
		name = "LanguageEnumProcEx"
		size = 224
		refs = "000c __security_push_cookie 0018 __acrt_getptd 0040 __acrt_GetLocaleInfoEx 005c _wcsicmp 0094 wcsncpy_s 00b8 __security_pop_cookie 00dc _invoke_watson"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF C3 03 D1 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 68 B2 40 B9 6A 00 80 52 29 00 82 52 03 0F 80 52 E2 03 00 91 1F 01 00 71 41 11 89 1A 80 02 00 91 ?? ?? ?? ?? 80 00 00 35 7F AA 00 B9 20 00 80 52 19 00 00 14 60 4E 40 F9 E1 03 00 91 ?? ?? ?? ?? 40 02 00 35 88 02 C0 79 8A 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 14 CB 09 FD 41 93 23 05 00 91 82 02 00 91 A1 0A 80 D2 60 C2 0B 91 ?? ?? ?? ?? 80 01 00 35 68 AA 40 B9 09 01 1E 32 69 AA 00 B9 68 AA 40 B9 E9 0B 68 2A 20 01 00 12 FF C3 03 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_182_7_0 {
	meta:
		name = "ProcessCodePage"
		size = 192
		refs = "0020 ??_C@_17DNCLJFIF@?$AAA?$AAC?$AAP?$AA?$AA@ 0028 wcscmp 0030 ??_C@_17CIKBIHLH@?$AAO?$AAC?$AAP?$AA?$AA@ 0054 __acrt_GetLocaleInfoEx 0068 _wtol 0098 __imp_GetACP"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 34 00 00 91 F3 02 00 B4 68 02 40 79 A8 02 00 34 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 02 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 20 01 00 35 43 00 80 52 E2 43 00 91 61 03 00 18 80 62 09 91 ?? ?? ?? ?? 80 01 00 34 E0 13 40 B9 12 00 00 14 60 02 00 91 ?? ?? ?? ?? 0F 00 00 14 43 00 80 52 E2 43 00 91 21 02 00 18 80 62 09 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 07 00 00 14 E0 13 40 B9 A0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 0B 00 00 20 04 10 00 20 }
	condition:
		$1
}

rule file_182_8_0 {
	meta:
		name = "TestDefaultCountry"
		size = 96
		refs = "000c __security_push_cookie 0024 __acrt_GetLocaleInfoEx 0040 wcsncmp 0050 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 0B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 23 01 80 52 E2 03 00 91 21 0B 80 52 13 00 00 91 ?? ?? ?? ?? 60 00 00 35 00 00 80 52 07 00 00 14 22 01 80 D2 61 02 00 91 E0 03 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 17 9F 1A FF 43 00 91 ?? ?? ?? ?? F3 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_182_9_0 {
	meta:
		name = "TestDefaultLanguage"
		size = 104
		refs = "0014 TestDefaultCountry 0028 GetPrimaryLen"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 33 00 00 11 54 00 00 91 ?? ?? ?? ?? 00 02 00 35 F3 01 00 34 93 02 40 F9 60 02 00 91 ?? ?? ?? ?? 68 02 C0 79 6A 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 13 CB 09 FD 41 93 1F 00 09 6B 00 00 80 52 40 00 00 54 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_182_10_0 {
	meta:
		name = "TranslateName"
		size = 148
		refs = "004c _wcsicmp"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BF A9 FD 03 00 91 18 00 00 91 20 00 80 52 33 00 00 11 56 00 00 91 14 00 80 52 93 02 F8 37 60 02 00 34 88 02 13 0B C0 02 40 F9 09 7D 48 0B 35 7D 01 13 AA 7E 40 93 17 13 0A 8B E1 02 40 F9 ?? ?? ?? ?? 80 00 00 35 E8 22 00 91 C8 02 00 F9 05 00 00 14 60 00 F8 36 B3 06 00 51 02 00 00 14 B4 06 00 11 9F 02 13 6B CD FD FF 54 1F 00 00 71 E0 17 9F 1A FD 7B C1 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_182_11_0 {
	meta:
		name = "__acrt_get_qualified_locale"
		size = 508
		refs = "001c __acrt_getptd 003c __acrt_rg_country 004c TranslateName 006c GetLocaleNameFromLangCountry 0074 GetLocaleNameFromLanguage 0080 __acrt_rg_language 00b8 GetLocaleNameFromDefault 00cc ProcessCodePage 00e8 __imp_IsValidCodePage 0144 wcsncpy_s 015c __acrt_GetLocaleInfoEx 0184 wcschr 01c4 _itow_s 01f8 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 15 00 00 91 36 00 00 91 54 00 00 91 ?? ?? ?? ?? 13 00 00 91 A8 02 02 91 7F E2 05 79 7F AA 00 B9 75 A2 09 A9 08 01 40 79 C8 00 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 62 82 02 91 C1 02 80 52 ?? ?? ?? ?? 68 4E 40 F9 60 62 02 91 09 01 40 79 E9 02 00 34 68 52 40 F9 09 01 40 79 69 00 00 34 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? 68 AA 40 B9 08 02 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 62 62 02 91 01 08 80 52 ?? ?? ?? ?? 40 01 00 34 68 52 40 F9 60 62 02 91 09 01 40 79 69 00 00 34 ?? ?? ?? ?? 04 00 00 14 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? 68 AA 40 B9 88 08 00 34 61 62 02 91 A0 02 04 91 ?? ?? ?? ?? 15 00 00 11 F5 07 00 34 08 BD 9F 52 A8 02 08 4B 1F 05 00 71 69 07 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 A0 3E 00 53 20 01 3F D6 A0 06 00 34 56 00 00 B4 D5 02 00 B9 14 06 00 B4 6B C2 0B 91 9F 42 02 79 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 0B CB 09 FD 41 93 23 05 00 91 62 C2 0B 91 A1 0A 80 D2 80 82 04 91 ?? ?? ?? ?? E0 04 00 35 03 08 80 52 82 02 00 91 21 00 82 52 80 82 04 91 ?? ?? ?? ?? 80 03 00 34 03 08 80 52 82 02 02 91 41 00 82 52 80 82 04 91 ?? ?? ?? ?? C0 02 00 34 E1 0B 80 52 80 02 02 91 ?? ?? ?? ?? A0 00 00 B5 C1 05 80 52 80 02 02 91 ?? ?? ?? ?? E0 00 00 B4 03 08 80 52 82 02 02 91 E1 00 80 52 80 82 04 91 ?? ?? ?? ?? 00 01 00 34 43 01 80 52 02 02 80 D2 81 02 04 91 A0 02 00 11 ?? ?? ?? ?? 20 00 80 52 02 00 00 14 00 00 80 52 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_183_0_0 {
	meta:
		name = "_fdquad"
		size = 996
		refs = "0010 __security_push_cookie 0070 _fd_int 00e4 _fdunscale 0100 _fdxp_setw 0120 _fdscale 0138 __b 0170 _fdxp_mulh 01c8 _fdxp_addx 01d0 __c 0244 memcpy 0268 get_acsize 0364 _fdxp_getw 0388 fmodf 0398 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 01 D1 14 00 00 91 F2 1C 00 1C 90 02 40 BD D1 1C 00 1C F2 47 03 2D F0 0B 00 BD 40 22 30 1E 02 05 00 54 00 22 31 1E C2 04 00 54 11 1C 00 1C 11 0A 31 1E 10 10 2C 1E 28 22 20 1E 8B 00 00 54 30 2A 30 1E F0 03 00 BD 03 00 00 14 31 3A 30 1E F1 03 00 BD 01 00 80 52 E0 03 00 91 ?? ?? ?? ?? E0 03 40 BD 08 20 20 1E 60 02 00 54 10 10 2A 1E F3 0B 40 BD F4 19 00 1C 11 08 30 1E 10 19 00 5C 32 C2 22 1E 52 0A 70 1E 58 42 62 1E 14 CF 14 1F 33 19 00 1C 15 D3 13 1F 14 19 00 1C 16 D7 14 1F F5 18 00 1C 17 DB 15 1F D6 18 00 1C 19 DF 16 1F 02 00 00 14 F9 0B 40 BD 99 02 00 BD A8 00 00 14 E1 03 00 91 F0 03 00 BD E0 13 00 91 B3 00 80 52 ?? ?? ?? ?? E8 0B C0 79 1F 85 00 71 CA 00 00 54 E0 0B 40 BD A1 00 80 52 E0 A3 00 91 ?? ?? ?? ?? 32 00 00 14 08 65 00 51 09 7D 03 13 2A 3D 00 13 E1 0F 0A 4B E0 23 00 91 EA 0B 00 79 ?? ?? ?? ?? E0 0B 40 BD 41 00 80 52 E0 43 00 91 ?? ?? ?? ?? E8 0B C0 79 ?? ?? ?? ?? 8A 02 80 D2 E0 13 40 BD EB A3 00 91 A1 00 80 52 08 05 00 51 09 7D 40 93 ?? ?? ?? ?? 2A 21 0A 9B E0 A3 00 91 48 25 40 A9 4A 11 40 B9 68 25 00 A9 6A 11 00 B9 ?? ?? ?? ?? E0 17 40 BD 08 20 20 1E 80 02 00 54 E8 0B C0 79 8B 02 80 D2 ?? ?? ?? ?? EC 03 01 91 A1 00 80 52 08 05 00 51 0A 7D 40 93 4A 25 0B 9B E0 03 01 91 48 25 40 A9 4A 11 40 B9 88 25 00 A9 8A 11 00 B9 ?? ?? ?? ?? A3 00 80 52 E2 03 01 91 A1 00 80 52 E0 A3 00 91 ?? ?? ?? ?? 30 0F 00 5C ?? ?? ?? ?? F0 13 00 FD F1 2B 40 BD F0 1B 40 BD 20 22 30 1E 83 00 00 54 F0 1F 40 BD 00 22 31 1E 62 06 00 54 F0 2F 40 BD 01 00 80 52 E0 03 00 91 11 2A 31 1E B0 0E 00 1C 32 0A 30 1E F2 03 00 BD ?? ?? ?? ?? F0 03 40 BD 41 00 80 52 E0 43 00 91 10 42 21 1E 11 C2 22 1E F0 13 40 FD 31 0A 70 1E 20 42 62 1E ?? ?? ?? ?? 62 7E 7E 93 ?? ?? ?? ?? E0 03 01 91 ?? ?? ?? ?? E0 13 40 BD 61 02 00 11 E0 03 01 91 ?? ?? ?? ?? F0 17 40 BD 08 22 20 1E 20 02 00 54 E0 2B 40 BD ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 62 7E 7E 93 E0 63 01 91 ?? ?? ?? ?? E0 17 40 BD 61 02 00 11 E0 63 01 91 ?? ?? ?? ?? 63 02 00 11 E2 63 01 91 61 02 00 11 E0 03 01 91 ?? ?? ?? ?? 63 02 00 11 E2 03 01 91 61 02 00 11 E0 A3 00 91 ?? ?? ?? ?? C8 FF FF 17 F0 2F 40 BD 10 2A 31 1E F1 07 00 1C 12 0A 31 1E 10 10 2C 1E 48 22 20 1E 8B 00 00 54 50 2A 30 1E F0 03 00 BD 03 00 00 14 51 3A 30 1E F1 03 00 BD 01 00 80 52 E0 03 00 91 ?? ?? ?? ?? F0 03 40 BD 08 22 20 1E E0 02 00 54 E0 2B 40 BD ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 62 7E 7E 93 E0 63 01 91 ?? ?? ?? ?? F0 03 40 BD 11 10 3A 1E 61 02 00 11 E0 63 01 91 10 0A 31 1E 11 C2 22 1E F0 13 40 FD 31 0A 70 1E 20 42 62 1E ?? ?? ?? ?? 63 02 00 11 E2 63 01 91 61 02 00 11 E0 A3 00 91 ?? ?? ?? ?? 61 02 00 11 E0 A3 00 91 ?? ?? ?? ?? 80 02 00 BD E0 03 40 BD 70 03 00 1C 61 03 00 1C 00 20 30 1E 63 00 00 54 20 20 20 1E 42 00 00 54 ?? ?? ?? ?? 08 00 38 1E 00 05 00 12 FF C3 01 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 00 00 30 3F 83 F9 22 C5 83 F9 22 45 83 F9 22 3F 00 00 C9 46 00 A0 FD 40 00 20 A2 3A 00 00 34 33 00 30 C2 2E 83 F9 22 3E 00 00 00 CF 00 00 00 4F }
	condition:
		$1
}

rule file_183_1_0 {
	meta:
		name = "_fdquadph"
		size = 228
		refs = "0014 _fdquad 002c _fd_int 0054 fmodf"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 E0 17 00 BD 13 00 00 91 ?? ?? ?? ?? F0 17 40 BD 14 00 00 11 21 00 80 52 E0 43 00 91 F0 13 00 BD ?? ?? ?? ?? E0 43 42 2D E1 04 00 1C 16 3A 20 1E D0 04 00 1C 00 20 30 1E F6 17 00 BD 63 00 00 54 20 20 20 1E 62 00 00 54 ?? ?? ?? ?? F6 17 40 BD 10 10 20 1E 74 02 40 BD B5 03 00 1C B2 03 00 1C 11 08 30 1E D3 52 15 1F 28 02 38 1E 40 22 33 1E 09 05 00 12 20 01 14 0B 28 01 00 54 13 10 2C 1E 00 04 00 11 D3 3A 33 1E 73 52 15 1F 73 02 00 BD FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 D0 01 00 1C 60 22 30 1E 48 FF FF 54 13 10 2C 1E 00 04 00 51 D1 2A 33 1E 31 52 15 1F 71 02 00 BD F5 FF FF 17 1F 20 03 D5 00 00 80 4E 00 00 80 CE DB 0F 49 40 DB 0F 49 3F DB 0F 49 BF }
	condition:
		$1
}

rule file_183_2_0 {
	meta:
		name = "_fdsin"
		size = 280
		refs = "0018 _fdtest 0034 _fdquad 0038 _FRteps_C 00c8 _fperrraise 00cc _FNan_C"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 11 E0 13 00 BD E0 43 00 91 ?? ?? ?? ?? E0 05 00 34 1F 04 00 71 00 05 00 54 1F 08 00 71 80 04 00 54 E0 43 00 91 ?? ?? ?? ?? ?? ?? ?? ?? F1 13 40 BD ?? ?? ?? ?? 08 00 13 0B 50 42 21 1E 00 22 31 1E C2 00 00 54 20 22 32 1E 82 00 00 54 88 02 00 36 11 10 2E 1E 12 00 00 14 36 0A 31 1E 28 01 00 36 91 04 00 1C 90 04 00 1C D2 C2 11 1F 71 04 00 1C 53 C6 36 1F 11 10 2E 1E 71 46 16 1F 08 00 00 14 F3 03 00 1C F2 03 00 1C D4 CA 13 1F D3 03 00 1C 95 CE 36 1F D4 0A 31 1E B1 46 14 1F 30 42 21 1E 1F 01 1F 72 00 1E 31 1E 0F 00 00 14 E0 13 40 BD 0D 00 00 14 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 00 14 F0 13 40 BD 11 10 2E 1E 7F 02 00 72 32 1E 30 1E 7F 02 1F 72 51 42 21 1E 20 1E 32 1E FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 93 49 B2 3A 36 A0 2A 3D DF FF FF 3E 6E 8C 4C 39 42 83 08 3C A1 AA 2A 3E }
	condition:
		$1
}

rule file_183_3_0 {
	meta:
		name = "get_acsize"
		size = 84
		refs = "0014 _fdunscale"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E1 53 00 91 E0 17 00 BD E0 43 00 91 ?? ?? ?? ?? E8 23 C0 79 A9 01 00 18 08 7D 29 9B 09 FD 60 D3 2B 7D 02 13 68 7D 4B 0B 09 09 00 11 2C 79 1F 53 8A 7D 40 93 5F 15 00 F1 A8 00 80 52 80 91 88 1A FD 7B C2 A8 C0 03 5F D6 AB AA AA 2A }
	condition:
		$1
}

rule file_183_4_0 {
	meta:
		name = "lgamma_big"
		size = 160
		refs = "0010 _fdlog 0030 _fdunscale 0058 _fdscale 0088 _fperrraise"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 00 00 80 52 E0 1B 00 BD ?? ?? ?? ?? F1 1B 40 BD 10 10 2C 1E E1 53 00 91 E0 1F 00 BD E0 43 00 91 31 3A 30 1E F1 17 00 BD ?? ?? ?? ?? F0 1F 40 BD 11 10 2E 1E E1 23 C0 79 E0 53 00 91 F1 23 00 BD 11 3A 31 1E F0 17 40 BD 31 0A 30 1E F1 17 00 BD ?? ?? ?? ?? 40 01 F8 36 F0 1B 40 BD F1 23 40 BD 32 1A 30 1E 71 01 00 1C 70 01 00 1C 53 42 11 1F F2 17 40 BD 60 2A 32 1E 04 00 00 14 00 01 80 52 ?? ?? ?? ?? E0 17 40 BD FD 7B C3 A8 C0 03 5F D6 AB AA AA 3D 1D 7F D6 3E }
	condition:
		$1
}

rule file_183_5_0 {
	meta:
		name = "lgammaf"
		size = 608
		refs = "0018 _fd_int 0048 _fperrraise 004c _FInf_C 0058 _fdgamma_big 0084 _fdsin 0098 _fdlog 00a8 lgamma_big 00cc rootapprox 0144 _fdpoly 0164 approx 01f4 _fdtgamma 0234 log1pf"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 01 00 80 52 E0 83 02 2D E0 63 00 91 ?? ?? ?? ?? F3 17 40 BD E0 00 00 34 1F 04 00 71 20 01 00 54 1F 08 00 71 41 01 00 54 60 42 20 1E 82 00 00 14 68 22 20 1E C8 00 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7B 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 30 42 21 1E 60 22 30 1E 82 02 00 54 F1 1B 40 BD 10 0F 00 1C 00 00 80 52 F0 13 00 BD 72 3A 31 1E 40 0A 30 1E ?? ?? ?? ?? F2 43 42 2D 00 00 80 52 11 08 30 1E 40 1A 31 1E ?? ?? ?? ?? F0 17 40 BD E0 13 00 BD 00 42 21 1E ?? ?? ?? ?? F0 13 40 BD 00 3A 20 1E 63 00 00 14 20 22 33 1E 88 00 00 54 60 42 20 1E ?? ?? ?? ?? 5E 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 49 7D 7B 93 30 69 6B BC 00 22 33 1E A2 00 00 54 68 11 00 91 31 69 68 BC 60 22 31 1E A3 00 00 54 4A 05 00 11 49 7D 40 93 3F 31 00 F1 A3 FE FF 54 48 7D 40 93 1F 31 00 F1 E2 01 00 54 4A 7D 7B 93 68 21 00 91 50 69 68 BC 69 31 00 91 52 69 69 BC 68 61 00 91 69 41 00 91 41 69 68 B8 40 69 69 F8 73 3A 30 1E 60 3A 32 1E E0 1B 00 BD ?? ?? ?? ?? 3E 00 00 14 50 08 00 1C 00 22 33 1E C2 04 00 54 11 10 2F 1E 60 22 31 1E 62 04 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 48 7D 40 93 09 05 80 D2 09 7D 09 9B 32 69 74 BC 60 22 32 1E 83 00 00 54 4A 05 00 11 48 7D 40 93 08 FF FF B4 48 7D 40 93 09 05 80 D2 13 7D 09 9B 88 12 00 91 89 22 00 91 70 6A 68 BC 88 42 00 91 61 6A 68 B8 60 6A 69 F8 60 3A 30 1E E0 1B 00 BD ?? ?? ?? ?? 88 82 00 91 89 62 00 91 E0 13 00 BD 61 6A 68 B8 60 6A 69 F8 E0 1B 40 BD ?? ?? ?? ?? F0 13 40 BD 00 1A 20 1E 16 00 00 14 E1 43 00 91 E0 53 00 91 ?? ?? ?? ?? F0 17 40 BD 00 00 80 52 E0 1B 00 BD 00 C2 20 1E ?? ?? ?? ?? E8 23 C0 79 51 02 00 1C 10 40 21 1E E0 1B 40 BD E8 03 08 4B 13 01 22 1E 72 42 11 1F B1 01 00 1C 73 4A 11 1F F3 17 00 BD ?? ?? ?? ?? F0 17 40 BD 00 28 30 1E FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 1F 20 03 D5 DB 0F 49 40 9A 99 99 3F E8 E8 FB 33 16 72 31 3F }
	condition:
		$1
}

rule file_184_5_0 {
	meta:
		name = "_mbspbrk_l"
		size = 292
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0034 strpbrk 0044 _errno 0050 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? EE 13 40 F9 C8 09 40 B9 A8 00 00 35 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 32 00 00 14 53 00 00 B4 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 2A 00 00 14 68 02 40 39 A8 04 00 34 8D 02 40 39 8C 02 00 91 CD 02 00 34 8B 01 40 39 69 01 0E 8B 2A 65 40 39 8A 01 10 36 68 02 40 39 7F 01 08 6B A1 00 00 54 6B 06 40 39 8A 05 40 39 5F 01 0B 6B 60 01 00 54 8B 05 40 39 2B 01 00 34 8C 05 00 91 04 00 00 14 69 02 40 39 7F 01 09 6B 80 00 00 54 8C 05 00 91 88 01 40 39 88 FD FF 35 8A 01 40 39 6A 01 00 35 6B 02 40 39 6B 01 0E 8B 6C 65 40 39 8C 00 10 36 73 06 00 91 69 02 40 39 89 00 00 34 73 06 00 91 68 02 40 39 C8 FB FF 35 68 02 40 39 1F 01 00 71 60 12 9F 9A E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_185_0_0 {
	meta:
		name = "roundl"
		size = 100
		refs = "0014 _ld_int"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 21 00 80 52 E0 0B 00 FD E0 43 00 91 ?? ?? ?? ?? 08 04 00 51 1F 05 00 71 C9 01 00 54 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 40 01 00 34 E8 2F 40 79 12 10 6E 1E 88 00 78 36 F0 0B 40 FD 00 3A 72 1E 05 00 00 14 F1 0B 40 FD 20 2A 72 1E 02 00 00 14 E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_542_0_0 {
	meta:
		name = "round"
		size = 100
		refs = "0014 _d_int"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 21 00 80 52 E0 0B 00 FD E0 43 00 91 ?? ?? ?? ?? 08 04 00 51 1F 05 00 71 C9 01 00 54 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 40 01 00 34 E8 2F 40 79 12 10 6E 1E 88 00 78 36 F0 0B 40 FD 00 3A 72 1E 05 00 00 14 F1 0B 40 FD 20 2A 72 1E 02 00 00 14 E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_186_5_0 {
	meta:
		name = "_ismbslead_l"
		size = 180
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 003c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 1F 00 00 14 54 FF FF B4 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? EB 13 40 F9 68 09 40 B9 28 02 00 34 7F 02 14 EB E8 01 00 54 69 02 40 39 A9 01 00 34 29 01 0B 8B 2A 65 40 39 CA 00 10 36 7F 02 14 EB 73 06 00 91 A0 00 00 54 68 02 40 39 A8 00 00 34 73 06 00 91 F3 FF FF 17 00 00 80 12 02 00 00 14 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_187_0_0 {
	meta:
		name = "_set_abort_behavior"
		size = 36
		refs = "0000 __abort_behavior"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? E8 03 21 2A 09 00 01 0A 0A 01 0B 0A 48 01 09 2A ?? ?? ?? ?? 60 01 00 11 C0 03 5F D6 }
	condition:
		$1
}

rule file_187_1_0 {
	meta:
		name = "abort"
		size = 48
		refs = "0008 __acrt_get_sigabrt_handler 0014 raise 0018 __abort_behavior 002c _exit"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 60 00 00 B4 C0 02 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 48 00 08 36 60 00 3E D4 60 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_259_5_0 {
	meta:
		name = "mblen"
		size = 32
		refs = "0000 __acrt_locale_changed_data 000c __acrt_initial_locale_pointers 001c _mblen_l"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 88 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 14 02 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_459_7_0 {
	meta:
		name = "mbstowcs"
		size = 32
		refs = "0000 __acrt_locale_changed_data 000c __acrt_initial_locale_pointers 001c ?_mbstowcs_l_helper@@YA_KPEA_WPEBD_KPEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 88 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 02 00 00 14 03 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_188_1_0 {
	meta:
		name = "wmemcpy_s"
		size = 164
		refs = "0020 _errno 002c _invalid_parameter_noinfo 0054 memcpy"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 49 00 00 91 63 00 00 B5 00 00 80 52 07 00 00 14 20 01 00 B5 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 3F 01 00 F1 20 10 43 FA A3 00 00 54 62 F8 7F D3 21 01 00 91 ?? ?? ?? ?? EF FF FF 17 C1 00 00 B4 0A 04 01 8B 1F 00 0A EB 60 00 00 54 1F 24 00 78 FD FF FF 17 89 00 00 B5 ?? ?? ?? ?? D3 02 80 52 05 00 00 14 3F 00 03 EB 42 FD FF 54 ?? ?? ?? ?? 53 04 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 E5 FF FF 17 }
	condition:
		$1
}

rule file_188_2_0 {
	meta:
		name = "wmemset"
		size = 32
	strings:
		$1 = { E2 00 00 B4 09 00 00 91 2A 05 02 8B 3F 01 0A EB 60 00 00 54 21 25 00 78 FD FF FF 17 C0 03 5F D6 }
	condition:
		$1
}

rule file_189_4_0 {
	meta:
		name = "_mbscat_s_l"
		size = 496
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 0054 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0070 strcat_s"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BD A9 FD 03 00 91 14 00 00 91 9F 02 00 F1 33 00 00 91 64 1A 40 FA 55 00 00 91 E8 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 69 00 00 14 75 00 00 B5 9F 02 00 39 F8 FF FF 17 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? EF 13 40 F9 E8 09 40 B9 C8 00 00 35 A2 02 00 91 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 55 00 00 14 0E 00 80 52 8B 02 00 91 68 01 40 39 88 00 00 34 6B 05 00 91 73 06 00 D1 93 FF FF B5 13 01 00 B5 9F 02 00 39 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 46 00 00 14 6C 05 00 D1 8A 01 00 91 9F 01 14 EB 03 01 00 54 48 01 40 39 08 01 0F 8B 09 65 40 39 89 00 10 36 4A 05 00 D1 5F 01 14 EB 42 FF FF 54 89 01 0A 4B A9 00 00 36 6B 05 00 D1 7F 01 00 39 2E 00 80 52 73 06 00 91 AA 16 40 38 6D 01 00 91 6A 15 00 38 6A 00 00 34 73 06 00 D1 73 FF FF B5 13 03 00 B5 A8 02 40 39 E8 01 00 35 AC 01 00 91 BF 01 14 EB 03 01 00 54 89 01 40 39 29 01 0F 8B 2A 65 40 39 8A 00 10 36 8C 05 00 D1 9F 01 14 EB 42 FF FF 54 A9 01 0C 4B 69 00 00 36 7F F1 1F 38 18 00 00 14 9F 02 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 17 00 00 14 6C 09 00 D1 8A 01 00 91 9F 01 14 EB 03 01 00 54 48 01 40 39 08 01 0F 8B 09 65 40 39 89 00 10 36 4A 05 00 D1 5F 01 14 EB 42 FF FF 54 89 01 0A 4B 69 00 00 36 7F E1 1F 38 2E 00 80 52 CE 00 00 34 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 40 05 80 52 02 00 00 14 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_191_0_0 {
	meta:
		name = "__acrt_initialize_locks"
		size = 108
		refs = "000c ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A 002c __acrt_InitializeCriticalSectionEx 0058 __acrt_uninitialize_locks"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 13 00 80 52 68 7E 40 D3 09 05 80 D2 00 51 09 9B 02 00 80 52 01 F4 81 52 ?? ?? ?? ?? 20 01 00 34 88 32 42 B9 73 06 00 11 7F 3A 00 71 09 05 00 11 89 32 02 B9 83 FE FF 54 20 00 80 52 04 00 00 14 00 00 80 52 ?? ?? ?? ?? 00 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_191_1_0 {
	meta:
		name = "__acrt_lock"
		size = 36
		refs = "0000 ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A 0014 __imp_EnterCriticalSection"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 09 7C 40 93 0A 05 80 D2 20 21 0A 9B ?? ?? ?? ?? ?? ?? ?? ?? 28 FD DF C8 00 01 1F D6 }
	condition:
		$1
}

rule file_191_3_0 {
	meta:
		name = "__acrt_unlock"
		size = 36
		refs = "0000 ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A 0014 __imp_LeaveCriticalSection"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 09 7C 40 93 0A 05 80 D2 20 21 0A 9B ?? ?? ?? ?? ?? ?? ?? ?? 28 FD DF C8 00 01 1F D6 }
	condition:
		$1
}

rule file_191_2_0 {
	meta:
		name = "__acrt_uninitialize_locks"
		size = 96
		refs = "0010 ?__acrt_lock_table@@3PAU_RTL_CRITICAL_SECTION@@A 0020 __imp_DeleteCriticalSection"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 93 32 42 B9 93 01 00 34 ?? ?? ?? ?? 09 05 80 D2 73 06 00 51 ?? ?? ?? ?? 60 52 09 9B 09 FD DF C8 20 01 3F D6 88 32 42 B9 09 05 00 51 89 32 02 B9 F3 FE FF 35 20 00 80 52 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_0_0 {
	meta:
		name = "??$convert_mantissa_to_ld12@$09@@YAXQEBE_KQEAU_LDBL12@@@Z"
		size = 408
	strings:
		$1 = { FF 43 00 D1 08 00 01 8B 5F 7C 00 29 1F 00 08 EB 5F 08 00 B9 E7 83 81 9A 0F 00 80 D2 27 08 00 B4 0D 00 80 52 0B 00 80 52 0C 00 80 52 49 00 40 F9 EE 03 00 91 8C 79 8B 13 4A 08 40 B9 A8 75 1E 53 6D 79 8D 13 48 34 00 29 4C 08 00 B9 C9 01 00 F9 CA 09 00 B9 EE 03 40 B9 06 01 0E 0B 46 00 00 B9 DF 00 08 6B 63 00 00 54 DF 00 0E 6B 22 01 00 54 A8 01 00 11 0D 05 00 11 BF 01 08 6B 4D 04 00 B9 A0 29 41 7A 62 00 00 54 8C 05 00 11 4C 08 00 B9 E9 07 40 B9 AE 01 09 0B 4E 04 00 B9 DF 01 0D 6B 63 00 00 54 DF 01 09 6B 62 00 00 54 8C 05 00 11 4C 08 00 B9 E8 0B 40 B9 CA 78 1F 53 CB 7D 86 13 4A 2C 00 29 89 01 08 0B 2C 7D 8E 13 49 08 00 B9 4C 08 00 B9 06 14 40 38 4D 01 06 0B 4D 00 00 B9 BF 01 0A 6B 63 00 00 54 BF 01 06 6B 22 01 00 54 68 01 00 11 0B 05 00 11 7F 01 08 6B 4B 04 00 B9 60 29 41 7A 62 00 00 54 8C 05 00 11 4C 08 00 B9 EF 05 00 91 4B B0 00 29 FF 01 07 EB 81 F8 FF 54 48 08 40 B9 CD 09 88 52 68 01 00 35 4E 28 40 29 09 FE 9F 52 A9 01 09 0B 47 7D 10 53 4A 41 8E 13 2D 3D 00 53 CE 3D 10 53 47 FF FF 34 4E 28 00 29 47 08 00 B9 4A 08 40 B9 AA 01 78 37 4B 30 40 29 68 01 00 11 89 01 00 11 8C 7D 88 13 EE FF 9F 52 4A 7D 89 13 A8 01 0E 0B 0D 3D 00 53 6B 79 1F 53 0A FF 7F 36 4B 30 00 29 4A 08 00 B9 4D 14 00 79 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_1_0 {
	meta:
		name = "??$convert_mantissa_to_ld12@$0BA@@@YAXQEBE_KQEAU_LDBL12@@@Z"
		size = 256
	strings:
		$1 = { 08 00 01 8B 5F 7C 00 29 1F 00 08 EB 5F 08 00 B9 EE 83 81 9A 0D 00 80 D2 AE 03 00 B4 0F 00 80 52 0B 00 80 52 0C 00 80 52 69 01 00 11 6B 71 8F 13 EA 6D 1C 53 8C 71 89 13 4A 2C 00 29 4C 08 00 B9 08 14 40 38 4F 01 08 0B 4F 00 00 B9 FF 01 0A 6B 63 00 00 54 FF 01 08 6B 22 01 00 54 68 01 00 11 0B 05 00 11 7F 01 08 6B 4B 04 00 B9 60 29 41 7A 62 00 00 54 8C 05 00 11 4C 08 00 B9 AD 05 00 91 4B B0 00 29 BF 01 0E EB 01 FD FF 54 48 08 40 B9 CD 09 88 52 68 01 00 35 4E 28 40 29 09 FE 9F 52 A9 01 09 0B 4F 7D 10 53 4A 41 8E 13 2D 3D 00 53 CE 3D 10 53 4F FF FF 34 4E 28 00 29 4F 08 00 B9 4A 08 40 B9 AA 01 78 37 4B 30 40 29 68 01 00 11 89 01 00 11 8C 7D 88 13 EE FF 9F 52 4A 7D 89 13 A8 01 0E 0B 0D 3D 00 53 6B 79 1F 53 0A FF 7F 36 4B 30 00 29 4A 08 00 B9 4D 14 00 79 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_2_0 {
	meta:
		name = "??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z"
		size = 16
		altNames = "??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z ??0?$c_string_character_source@D@__crt_strtox@@QEAA@QEBDQEAPEBD@Z ??0?$c_string_character_source@_W@__crt_strtox@@QEAA@QEB_WQEAPEB_W@Z"
	strings:
		$1 = { 01 08 00 A9 42 00 00 B4 41 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_3_0 {
	meta:
		name = "??$multiply_ld12_by@$09@@YAXQEAU_LDBL12@@@Z"
		size = 196
	strings:
		$1 = { FF 43 00 D1 08 00 40 F9 EA 03 00 91 09 08 40 B9 48 01 00 F9 08 00 40 B9 49 09 00 B9 09 04 40 B9 0A 75 1E 53 2B 79 88 13 08 08 40 B9 0A 2C 00 29 0D 79 89 13 E8 03 40 B9 0D 08 00 B9 4C 01 08 0B 0C 00 00 B9 9F 01 0A 6B 63 00 00 54 9F 01 08 6B 02 01 00 54 68 05 00 11 1F 01 0B 6B 08 04 00 B9 00 29 41 7A 62 00 00 54 A8 05 00 11 08 08 00 B9 08 04 40 B9 E9 07 40 B9 2B 01 08 0B 0B 04 00 B9 7F 01 08 6B 63 00 00 54 7F 01 09 6B 82 00 00 54 08 08 40 B9 09 05 00 11 09 08 00 B9 88 79 1F 53 0A 08 40 B9 69 7D 8C 13 08 24 00 29 E8 0B 40 B9 48 01 08 0B 09 7D 8B 13 09 08 00 B9 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_4_0 {
	meta:
		name = "??$multiply_ld12_by@$0BA@@@YAXQEAU_LDBL12@@@Z"
		size = 32
		altNames = "??$shl_ld12@$03@@YAXQEAU_LDBL12@@@Z"
	strings:
		$1 = { 09 28 40 29 28 6D 1C 53 49 71 89 13 08 24 00 29 08 08 40 B9 0A 71 8A 13 0A 08 00 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_5_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAU_LDBL12@@@Z"
		size = 136
		refs = "000c __security_push_cookie 0020 _errno 002c _invalid_parameter_noinfo 0054 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z 0060 ??$parse_floating_point_write_result@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAU_LDBL12@@@Z 0078 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 0C D1 33 00 00 91 54 00 00 91 74 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 20 00 80 52 0C 00 00 14 C0 FE FF B4 E2 03 00 91 61 02 00 91 ?? ?? ?? ?? 82 02 00 91 E1 03 00 91 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 FF 43 0C 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_447_22_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAM@Z"
		size = 136
		refs = "000c __security_push_cookie 0020 _errno 002c _invalid_parameter_noinfo 0054 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z 0060 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0078 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 0C D1 33 00 00 91 54 00 00 91 74 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 20 00 80 52 0C 00 00 14 C0 FE FF B4 E2 03 00 91 61 02 00 91 ?? ?? ?? ?? 82 02 00 91 E1 03 00 91 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 FF 43 0C 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_447_23_0 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAN@Z"
		size = 136
		refs = "000c __security_push_cookie 0020 _errno 002c _invalid_parameter_noinfo 0054 ??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z 0060 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0078 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 0C D1 33 00 00 91 54 00 00 91 74 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 20 00 80 52 0C 00 00 14 C0 FE FF B4 E2 03 00 91 61 02 00 91 ?? ?? ?? ?? 82 02 00 91 E1 03 00 91 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 FF 43 0C 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_526_24_2 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@M@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAM@Z"
		size = 136
		refs = "000c __security_push_cookie 0020 _errno 002c _invalid_parameter_noinfo 0054 ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@_W@0@AEAUfloating_point_string@0@@Z 0060 ??$parse_floating_point_write_result@M@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAM@Z 0078 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 0C D1 33 00 00 91 54 00 00 91 74 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 20 00 80 52 0C 00 00 14 C0 FE FF B4 E2 03 00 91 61 02 00 91 ?? ?? ?? ?? 82 02 00 91 E1 03 00 91 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 FF 43 0C 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_526_25_2 {
	meta:
		name = "??$parse_floating_point@V?$c_string_character_source@_W@__crt_strtox@@N@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@QEAN@Z"
		size = 136
		refs = "000c __security_push_cookie 0020 _errno 002c _invalid_parameter_noinfo 0054 ??$parse_floating_point_from_source@V?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@_W@0@AEAUfloating_point_string@0@@Z 0060 ??$parse_floating_point_write_result@N@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAN@Z 0078 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 0C D1 33 00 00 91 54 00 00 91 74 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 20 00 80 52 0C 00 00 14 C0 FE FF B4 E2 03 00 91 61 02 00 91 ?? ?? ?? ?? 82 02 00 91 E1 03 00 91 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 FF 43 0C 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_6_0 {
	meta:
		name = "??$parse_floating_point_from_source@V?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA?AW4floating_point_parse_result@0@QEAU__crt_locale_pointers@@AEAV?$c_string_character_source@D@0@AEAUfloating_point_string@0@@Z"
		size = 1564
		refs = "0030 _errno 003c _invalid_parameter_noinfo 007c _isctype_l 0094 __pctype_func 05e8 ??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z 05fc ??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 73 04 A9 FD 7B BE A9 FD 03 00 91 34 00 00 91 96 02 40 F9 17 00 00 91 5B 00 00 91 F6 00 00 B5 ?? ?? ?? ?? D8 02 80 52 18 00 00 B9 ?? ?? ?? ?? E0 00 80 52 6F 01 00 14 D3 02 C0 39 C8 06 00 91 88 02 00 F9 75 1E 00 53 F3 43 00 39 D7 01 00 B4 EA 02 40 F9 49 09 40 B9 3F 05 00 71 CD 00 00 54 E2 02 00 91 01 01 80 52 A0 02 00 11 ?? ?? ?? ?? 08 00 00 14 48 01 40 F9 09 D9 75 78 20 01 1D 12 04 00 00 14 ?? ?? ?? ?? 08 D8 75 78 00 01 1D 12 A0 00 00 34 89 02 40 F9 33 01 C0 39 28 05 00 91 E8 FF FF 17 7F B6 00 71 E8 17 9F 1A 69 1E 00 53 68 23 0C 39 A8 1F 80 52 2A AD 00 51 48 01 08 0A A8 00 00 35 88 02 40 F9 13 15 C0 38 F3 43 00 39 88 02 00 F9 68 1E 00 53 09 25 01 51 EA 1B 80 52 29 01 0A 0A E9 27 00 34 68 1E 00 53 09 39 01 51 29 01 0A 0A C9 26 00 34 19 00 80 52 D8 02 80 52 7F C2 00 71 21 03 00 54 8C 02 40 F9 ED 1B 80 52 8B 01 C0 39 8A 05 00 91 8A 02 00 F9 68 1D 00 53 09 61 01 51 29 01 0D 0A 69 01 00 34 48 05 00 D1 88 02 00 F9 AB 01 00 34 08 01 C0 39 1F 01 0B 6B 40 01 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 06 00 00 14 48 05 00 91 53 01 C0 39 88 02 00 F9 39 00 80 52 96 01 00 91 7A 23 00 91 6F 23 0C 91 75 23 00 91 1C 00 80 52 0D 00 80 52 7F C2 00 71 E1 00 00 54 89 02 40 F9 2D 00 80 52 33 15 C0 38 89 02 00 F9 7F C2 00 71 A0 FF FF 54 3F 03 00 71 E9 01 80 52 28 01 80 52 2E 11 88 1A 68 42 03 11 09 1D 00 53 3F 25 00 71 68 00 00 54 6A C2 00 51 0D 00 00 14 6A 7E 02 11 4B 1D 00 53 7F 65 00 71 68 00 00 54 6A 5E 01 51 07 00 00 14 68 FE 02 11 09 1D 00 53 3F 65 00 71 6A DE 00 51 49 00 00 54 0A 00 80 12 5F 01 0E 6B 68 01 00 54 2D 00 80 52 BF 02 0F EB 60 00 00 54 AA 02 00 39 B5 06 00 91 88 02 40 F9 9C 07 00 11 13 15 C0 38 88 02 00 F9 E3 FF FF 17 E8 02 40 F9 09 7D 40 F9 2A 01 40 F9 4B 01 C0 39 7F 02 0B 6B C1 05 00 54 88 02 40 F9 BF 02 1A EB 0C 05 00 91 13 01 C0 39 8C 02 00 F9 61 01 00 54 7F C2 00 71 21 01 00 54 2D 00 80 52 93 01 C0 39 88 05 00 91 9C 07 00 51 88 02 00 F9 0C 01 00 91 7F C2 00 71 40 FF FF 54 68 42 03 11 09 1D 00 53 3F 25 00 71 68 00 00 54 6A C2 00 51 0D 00 00 14 6A 7E 02 11 4B 1D 00 53 7F 65 00 71 68 00 00 54 6A 5E 01 51 07 00 00 14 68 FE 02 11 09 1D 00 53 3F 65 00 71 6A DE 00 51 49 00 00 54 0A 00 80 12 5F 01 0E 6B 48 01 00 54 2D 00 80 52 BF 02 0F EB 60 00 00 54 AA 02 00 39 B5 06 00 91 88 02 40 F9 13 15 C0 38 88 02 00 F9 E4 FF FF 17 88 02 40 F9 09 05 00 D1 89 02 00 F9 CD 01 00 35 F3 00 00 34 28 01 C0 39 1F 01 13 6B 80 00 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 3F 03 00 71 96 02 00 F9 49 00 80 52 E8 00 80 52 20 11 88 1A B0 00 00 14 F3 00 00 34 28 01 C0 39 1F 01 13 6B 80 00 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 96 02 40 F9 08 00 80 52 CC 02 C0 39 D7 06 00 91 97 02 00 F9 9F 15 01 71 20 01 00 54 9F 41 01 71 A0 00 00 54 9F 95 01 71 A0 00 00 54 9F C1 01 71 A1 00 00 54 28 03 00 11 03 00 00 14 28 03 00 52 08 1D 00 53 13 00 80 52 C8 0B 00 34 EC 02 C0 39 EA 06 00 91 AB 1F 80 52 8A 02 00 F9 88 1D 00 53 09 AD 00 51 9F B5 00 71 29 01 0B 0A EE 17 9F 1A 89 00 00 35 48 05 00 91 4C 01 C0 39 88 02 00 F9 0D 00 80 52 9F C1 00 71 E1 00 00 54 8A 02 40 F9 2D 00 80 52 4C 15 C0 38 8A 02 00 F9 9F C1 00 71 A0 FF FF 54 88 41 03 11 09 1D 00 53 3F 25 00 71 68 00 00 54 8B C1 00 51 0D 00 00 14 8A 7D 02 11 4B 1D 00 53 7F 65 00 71 68 00 00 54 8B 5D 01 51 07 00 00 14 88 FD 02 11 09 1D 00 53 3F 65 00 71 8B DD 00 51 49 00 00 54 0B 00 80 12 7F 29 00 71 82 01 00 54 6A 0A 13 0B 08 8A 82 52 2D 00 80 52 73 05 0A 0B 7F 02 08 6B AC 00 00 54 88 02 40 F9 0C 15 C0 38 88 02 00 F9 E3 FF FF 17 33 8A 82 52 89 41 03 11 2A 1D 00 53 5F 25 00 71 68 00 00 54 8B C1 00 51 0D 00 00 14 88 7D 02 11 0B 1D 00 53 7F 65 00 71 68 00 00 54 8B 5D 01 51 07 00 00 14 89 FD 02 11 2A 1D 00 53 5F 65 00 71 8B DD 00 51 49 00 00 54 0B 00 80 12 7F 29 00 71 A2 00 00 54 88 02 40 F9 0C 15 C0 38 88 02 00 F9 E9 FF FF 17 4E 00 00 34 F3 03 13 4B CD 01 00 35 88 02 40 F9 09 05 00 D1 89 02 00 F9 EC 00 00 34 28 01 C0 39 1F 01 0C 6B 80 00 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 96 02 00 F9 CC 02 C0 39 97 02 00 F9 88 02 40 F9 09 05 00 D1 89 02 00 F9 EC 00 00 34 28 01 C0 39 1F 01 0C 6B 80 00 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? BF 02 1A EB 40 04 00 54 A8 F2 5F 38 88 00 00 35 B5 06 00 D1 BF 02 1A EB 81 FF FF 54 BF 02 1A EB 60 03 00 54 08 8A 82 52 7F 02 08 6B 6D 00 00 54 20 01 80 52 21 00 00 14 E8 89 82 12 7F 02 08 6B 6A 00 00 54 00 01 80 52 1C 00 00 14 3F 03 00 71 89 00 80 52 28 00 80 52 28 11 88 1A 09 4D 1C 1B 0A 8A 82 52 3F 01 0A 6B 4C FE FF 54 E8 89 82 12 3F 01 08 6B 8B FE FF 54 69 03 00 B9 A9 02 1A 4B 69 07 00 B9 20 03 00 11 0C 00 00 14 40 00 80 52 0A 00 00 14 C2 02 00 91 81 02 00 91 E0 43 00 91 ?? ?? ?? ?? 05 00 00 14 C2 02 00 91 81 02 00 91 E0 43 00 91 ?? ?? ?? ?? FD 7B C2 A8 FB 73 44 A9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_7_0 {
	meta:
		name = "??$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z"
		size = 420
		refs = "0020 ?inf_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 0024 ?inf_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 0088 _errno 0090 _invalid_parameter_noinfo 009c ?inity_uppercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 00a0 ?inity_lowercase@?1???$parse_floating_point_possible_infinity@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 15 00 00 91 33 00 00 91 56 00 00 91 0E 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? AC 02 C0 39 C9 69 E8 38 9F 01 09 6B A0 00 00 54 ?? ?? ?? ?? CB 69 EA 38 9F 01 0B 6B 41 07 00 54 6C 02 40 F9 CE 05 00 91 DF 0D 00 F1 8D 15 C0 38 6C 02 00 F9 AD 02 00 39 21 FE FF 54 68 02 40 F9 D4 02 80 52 09 05 00 D1 69 02 00 F9 ED 00 00 34 28 01 C0 39 1F 01 0D 6B 80 00 00 54 ?? ?? ?? ?? 14 00 00 B9 ?? ?? ?? ?? 76 02 40 F9 0E 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? C9 02 C0 39 C8 06 00 91 68 02 00 F9 A9 02 00 39 ?? ?? ?? ?? AD 02 C0 39 CA 69 E9 38 BF 01 0A 6B A0 00 00 54 ?? ?? ?? ?? CC 69 EB 38 BF 01 0C 6B A1 04 00 54 68 02 40 F9 CE 05 00 91 DF 15 00 F1 0D 15 C0 38 68 02 00 F9 AD 02 00 39 21 FE FF 54 68 02 40 F9 09 05 00 D1 69 02 00 F9 ED 00 00 34 28 01 C0 39 1F 01 0D 6B 80 00 00 54 ?? ?? ?? ?? 14 00 00 B9 ?? ?? ?? ?? 60 00 80 52 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 68 02 40 F9 A9 02 C0 39 0A 05 00 D1 6A 02 00 F9 09 01 00 34 48 01 C0 39 1F 01 09 6B A0 00 00 54 ?? ?? ?? ?? D4 02 80 52 14 00 00 B9 ?? ?? ?? ?? E0 00 80 52 0D 00 00 14 68 02 40 F9 A9 02 C0 39 0A 05 00 D1 6A 02 00 F9 E9 00 00 34 48 01 C0 39 1F 01 09 6B 80 00 00 54 ?? ?? ?? ?? 14 00 00 B9 ?? ?? ?? ?? 60 00 80 52 BF 02 00 39 76 02 00 F9 E0 FF FF 17 }
	condition:
		$1
}

rule file_192_8_0 {
	meta:
		name = "??$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@0@AEADAEAV?$c_string_character_source@D@0@PEBD@Z"
		size = 572
		refs = "0020 ?uppercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 0024 ?lowercase@?1???$parse_floating_point_possible_nan@DV?$c_string_character_source@D@__crt_strtox@@PEBD@__crt_strtox@@YA?AW4floating_point_parse_result@1@AEADAEAV?$c_string_character_source@D@1@PEBD@Z@4QBDB 0088 _errno 0090 _invalid_parameter_noinfo 00c8 ??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z 0144 ??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 33 00 00 91 56 00 00 91 0D 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8C 02 C0 39 A9 69 E8 38 9F 01 09 6B A0 00 00 54 ?? ?? ?? ?? AB 69 EA 38 9F 01 0B 6B E1 05 00 54 6C 02 40 F9 AD 05 00 91 BF 0D 00 F1 8E 15 C0 38 6C 02 00 F9 8E 02 00 39 21 FE FF 54 68 02 40 F9 D5 02 80 52 09 05 00 D1 69 02 00 F9 EE 00 00 34 28 01 C0 39 1F 01 0E 6B 80 00 00 54 ?? ?? ?? ?? 15 00 00 B9 ?? ?? ?? ?? 76 02 40 F9 C9 02 C0 39 C8 06 00 91 68 02 00 F9 89 02 00 39 3F A1 00 71 68 02 40 F9 C1 09 00 54 09 15 C0 38 61 02 00 91 80 02 00 91 68 02 00 F9 89 02 00 39 ?? ?? ?? ?? 80 03 00 34 68 02 40 F9 89 02 C0 39 0A 05 00 D1 6A 02 00 F9 E9 00 00 34 48 01 C0 39 1F 01 09 6B 80 00 00 54 ?? ?? ?? ?? 15 00 00 B9 ?? ?? ?? ?? A0 00 80 52 4B 00 00 14 68 02 40 F9 89 02 C0 39 0A 05 00 D1 6A 02 00 F9 09 01 00 34 48 01 C0 39 1F 01 09 6B A0 00 00 54 ?? ?? ?? ?? D5 02 80 52 15 00 00 B9 ?? ?? ?? ?? E8 00 80 52 36 00 00 14 61 02 00 91 80 02 00 91 ?? ?? ?? ?? C0 01 00 34 68 02 40 F9 89 02 C0 39 0A 05 00 D1 6A 02 00 F9 E9 00 00 34 48 01 C0 39 1F 01 09 6B 80 00 00 54 ?? ?? ?? ?? 15 00 00 B9 ?? ?? ?? ?? C0 00 80 52 2C 00 00 14 88 02 C0 39 1F A5 00 71 00 05 00 54 8C 02 C0 39 4C 02 00 34 89 C1 00 51 3F 25 00 71 29 01 00 54 8A 85 01 51 5F 65 00 71 C9 00 00 54 8B 05 01 51 7F 65 00 71 69 00 00 54 9F 7D 01 71 21 03 00 54 68 02 40 F9 0C 15 C0 38 68 02 00 F9 9F A5 00 71 8C 02 00 39 C1 FD FF 54 89 02 C0 39 3F A5 00 71 40 02 00 54 68 02 40 F9 0A 05 00 D1 6A 02 00 F9 E9 00 00 34 48 01 C0 39 1F 01 09 6B 80 00 00 54 ?? ?? ?? ?? 15 00 00 B9 ?? ?? ?? ?? 88 00 80 52 9F 02 00 39 00 01 00 11 76 02 00 F9 04 00 00 14 89 02 C0 39 F0 FF FF 17 80 00 80 52 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_9_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z"
		size = 92
		refs = "0004 ?uppercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB 0008 ?lowercase@?1???$parse_floating_point_possible_nan_is_ind@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB"
	strings:
		$1 = { 0E 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0C 00 C0 39 C9 69 E8 38 9F 01 09 6B A0 00 00 54 ?? ?? ?? ?? CB 69 EA 38 9F 01 0B 6B 41 01 00 54 2C 00 40 F9 CE 05 00 91 DF 11 00 F1 8D 15 C0 38 2C 00 00 F9 0D 00 00 39 21 FE FF 54 20 00 80 52 C0 03 5F D6 00 00 80 52 FE FF FF 17 }
	condition:
		$1
}

rule file_192_10_0 {
	meta:
		name = "??$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@0@@Z"
		size = 92
		refs = "0004 ?uppercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB 0008 ?lowercase@?1???$parse_floating_point_possible_nan_is_snan@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NAEADAEAV?$c_string_character_source@D@1@@Z@4QBDB"
	strings:
		$1 = { 0E 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 0C 00 C0 39 C9 69 E8 38 9F 01 09 6B A0 00 00 54 ?? ?? ?? ?? CB 69 EA 38 9F 01 0B 6B 41 01 00 54 2C 00 40 F9 CE 05 00 91 DF 15 00 F1 8D 15 C0 38 2C 00 00 F9 0D 00 00 39 21 FE FF 54 20 00 80 52 C0 03 5F D6 00 00 80 52 FE FF FF 17 }
	condition:
		$1
}

rule file_192_11_0 {
	meta:
		name = "??$parse_floating_point_write_result@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@W4floating_point_parse_result@0@AEBUfloating_point_string@0@QEAU_LDBL12@@@Z"
		size = 340
		refs = "0030 ?common_convert_to_ldbl12@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@_NAEAU_LDBL12@@@Z"
	strings:
		$1 = { 2A 00 00 91 1F 24 00 71 88 07 00 54 89 00 00 10 28 49 A0 38 28 09 08 8B 00 01 1F D6 03 06 08 12 1C 27 2F 33 39 43 43 43 01 00 80 52 40 01 00 91 ?? ?? ?? ?? 21 00 80 52 FD FF FF 17 48 21 4C 39 09 00 90 52 5F 60 00 B8 1F 01 00 71 29 11 9F 1A 5F 20 00 B8 5F 00 00 79 49 14 00 79 00 00 80 52 27 00 00 14 48 21 4C 39 5F 00 00 79 5F 20 00 B8 5F 60 00 B8 1F 01 00 71 EA FF 9F 52 E9 FF 8F 52 48 11 89 1A 48 14 00 79 F5 FF FF 17 48 21 4C 39 E9 FF 9F 52 49 00 00 79 0A 00 80 12 EB FF 9F 52 4A 20 00 B8 E9 FF 8F 52 4A 60 00 B8 1F 01 00 71 68 11 89 1A F4 FF FF 17 E9 FF 9F 52 48 21 4C 39 49 00 00 79 0A 00 80 12 09 00 A8 12 4A 20 00 B8 49 60 00 B8 E8 FF FF 17 08 00 B8 52 48 60 00 B8 E9 FF 9F 52 DB FF FF 17 5F 00 00 79 5F 20 00 B8 5F 60 00 B8 5F 14 00 79 20 00 80 52 C0 03 5F D6 48 21 4C 39 09 00 90 52 5F 00 00 79 5F 20 00 B8 40 00 80 52 5F 60 00 B8 1F 01 00 71 29 11 9F 1A 49 14 00 79 F6 FF FF 17 48 21 4C 39 E9 FF 8F 52 5F 00 00 79 EA FF 9F 52 5F 20 00 B8 5F 60 00 B8 60 00 80 52 1F 01 00 71 48 11 89 1A 48 14 00 79 EB FF FF 17 }
	condition:
		$1
}

rule file_192_12_0 {
	meta:
		name = "??$parse_next_characters_from_source@DV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_NQEBD0_KAEADAEAV?$c_string_character_source@D@0@@Z"
		size = 88
	strings:
		$1 = { 0D 00 80 D2 22 02 00 B4 0C 00 01 CB 6A 00 C0 39 88 69 E1 38 5F 01 08 6B 80 00 00 54 29 00 C0 39 5F 01 09 6B 61 01 00 54 8A 00 40 F9 AD 05 00 91 21 04 00 91 BF 01 02 EB 4B 15 C0 38 8A 00 00 F9 6B 00 00 39 41 FE FF 54 20 00 80 52 C0 03 5F D6 00 00 80 52 FE FF FF 17 }
	condition:
		$1
}

rule file_192_13_0 {
	meta:
		name = "??$shl_ld12@$00@@YAXQEAU_LDBL12@@@Z"
		size = 32
	strings:
		$1 = { 09 28 40 29 28 79 1F 53 49 7D 89 13 08 24 00 29 08 08 40 B9 0A 7D 8A 13 0A 08 00 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_14_0 {
	meta:
		name = "??$shl_ld12@$01@@YAXQEAU_LDBL12@@@Z"
		size = 32
	strings:
		$1 = { 09 28 40 29 28 75 1E 53 49 79 89 13 08 24 00 29 08 08 40 B9 0A 79 8A 13 0A 08 00 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_21_0 {
	meta:
		name = "??1?$c_string_character_source@D@__crt_strtox@@QEAA@XZ"
		size = 20
		altNames = "??1?$c_string_character_source@_W@__crt_strtox@@QEAA@XZ"
	strings:
		$1 = { 09 04 40 F9 69 00 00 B4 08 00 40 F9 28 01 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_27_0 {
	meta:
		name = "?add_ld12@@YAXQEAU_LDBL12@@QEBU1@@Z"
		size = 124
	strings:
		$1 = { 2A 00 40 B9 09 00 40 B9 28 01 0A 0B 1F 01 09 6B 08 00 00 B9 00 21 4A 7A 42 01 00 54 09 04 40 B9 28 05 00 11 1F 01 09 6B 08 04 00 B9 00 29 41 7A 82 00 00 54 08 08 40 B9 09 05 00 11 09 08 00 B9 2A 04 40 B9 09 04 40 B9 28 01 0A 0B 1F 01 09 6B 08 04 00 B9 00 21 4A 7A 82 00 00 54 08 08 40 B9 09 05 00 11 09 08 00 B9 29 08 40 B9 08 08 40 B9 29 01 08 0B 09 08 00 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_28_0 {
	meta:
		name = "?add_uint32_carry@@YA_NIIQEAI@Z"
		size = 24
	strings:
		$1 = { 08 00 01 0B 1F 01 00 6B 48 00 00 B9 00 21 41 7A E0 27 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_192_29_0 {
	meta:
		name = "?assemble_floating_point_ind@__crt_strtox@@YAXAEAU_LDBL12@@@Z"
		size = 28
	strings:
		$1 = { 08 00 B8 52 1F 00 00 79 E9 FF 9F 52 08 60 00 B8 09 14 00 79 1F 20 00 B8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_30_0 {
	meta:
		name = "?assemble_floating_point_infinity@__crt_strtox@@YAX_NAEAU_LDBL12@@@Z"
		size = 36
	strings:
		$1 = { 1F 00 00 71 3F 00 00 79 E9 FF 9F 52 3F 20 00 B8 E8 FF 8F 52 3F 60 00 B8 28 11 88 1A 28 14 00 79 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_31_0 {
	meta:
		name = "?assemble_floating_point_qnan@__crt_strtox@@YAX_NAEAU_LDBL12@@@Z"
		size = 44
	strings:
		$1 = { 09 00 80 12 E8 FF 9F 52 29 20 00 B8 28 00 00 79 1F 00 00 71 29 60 00 B8 E8 FF 8F 52 E9 FF 9F 52 28 11 88 1A 28 14 00 79 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_32_0 {
	meta:
		name = "?assemble_floating_point_snan@__crt_strtox@@YAX_NAEAU_LDBL12@@@Z"
		size = 48
	strings:
		$1 = { E8 FF 9F 52 28 00 00 79 09 00 80 12 08 00 A8 12 29 20 00 B8 28 60 00 B8 1F 00 00 71 E8 FF 8F 52 E9 FF 9F 52 28 11 88 1A 28 14 00 79 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_33_0 {
	meta:
		name = "?assemble_floating_point_zero@__crt_strtox@@YAX_NAEAU_LDBL12@@@Z"
		size = 32
	strings:
		$1 = { 1F 00 00 71 3F 00 00 79 08 00 90 52 3F 20 00 B8 08 11 9F 1A 3F 60 00 B8 28 14 00 79 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_34_0 {
	meta:
		name = "?common_convert_to_ldbl12@__crt_strtox@@YA?AW4SLD_STATUS@@AEBUfloating_point_string@1@_NAEAU_LDBL12@@@Z"
		size = 2476
		refs = "0010 __security_push_cookie 0030 memcpy 0608 ?ld12_pow10_positive@@3QBU_LDBL12@@B 0618 ?ld12_pow10_negative@@3QBU_LDBL12@@B 0998 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF C3 0C D1 34 00 00 11 E8 83 00 91 01 00 00 91 53 00 00 91 00 01 00 91 82 61 80 52 ?? ?? ?? ?? EA 27 40 B9 5F 61 00 71 A9 01 00 54 9F 02 00 71 A8 00 80 52 09 01 80 52 29 11 88 1A E8 03 41 39 1F 01 09 6B 8B 00 00 54 E8 FF 40 39 08 05 00 11 E8 FF 00 39 0A 03 80 52 EA 27 00 B9 28 00 80 52 7F 7E 00 29 9F 02 00 71 7F 0A 00 B9 89 00 80 52 29 11 88 1A E8 23 40 B9 0E 00 80 D2 26 A1 0A 1B 49 7D 40 D3 E8 A3 00 91 28 01 08 8B EA A3 00 91 E6 23 00 B9 5F 01 08 EB F4 1E 00 34 E7 A3 00 91 EF 83 89 9A 4F 03 00 B4 0D 00 80 52 0B 00 80 52 0C 00 80 52 EA 14 40 38 69 01 00 11 6B 71 8D 13 A8 6D 1C 53 8C 71 89 13 0D 01 0A 0B BF 01 08 6B 63 00 00 54 BF 01 0A 6B 02 01 00 54 6A 05 00 11 68 01 00 11 5F 01 08 6B 40 29 41 7A 4B 01 00 11 42 00 00 54 8C 05 00 11 CE 05 00 91 DF 01 0F EB A1 FD FF 54 6D 2E 00 29 6C 0A 00 B9 68 0A 40 B9 CE 09 88 52 68 01 00 35 6F 2A 40 29 09 FE 9F 52 C9 01 09 0B 47 7D 10 53 4A 41 8F 13 2E 3D 00 53 EF 3D 10 53 47 FF FF 34 6F 2A 00 29 67 0A 00 B9 6A 0A 40 B9 AA 01 78 37 6B 32 40 29 68 01 00 11 89 01 00 11 8C 7D 88 13 ED FF 9F 52 4A 7D 89 13 C8 01 0D 0B 0E 3D 00 53 6B 79 1F 53 0A FF 7F 36 6B 32 00 29 6A 0A 00 B9 08 00 B0 52 FF 23 00 79 E9 FF 87 52 E8 63 01 B8 C8 00 09 0B FF 23 01 B8 09 3D 00 53 FF 7F 00 29 C8 01 09 4A E9 37 00 79 CA 39 00 12 FF 0B 00 B9 2B 39 00 12 02 01 11 12 68 01 0A 0B 65 2A 00 91 E9 FF 8F 52 AE 00 00 79 0C 3D 00 53 5F 01 09 6B 82 14 00 54 E8 FF 8F 52 7F 01 08 6B 22 14 00 54 A8 FF 97 52 9F 01 08 6B C8 13 00 54 E8 F7 87 52 9F 01 08 6B 68 00 00 54 7F 0A 00 B9 9E 00 00 14 8A 01 00 35 69 0A 40 B9 88 05 00 11 0C 3D 00 53 2A 79 00 12 EA 00 00 35 68 06 40 B9 A8 00 00 35 68 02 40 B9 68 00 00 35 BF 00 00 79 CC 01 00 14 4B 01 00 35 E9 1B 40 B9 88 05 00 11 0C 3D 00 53 28 79 00 12 A8 00 00 35 E8 17 40 B9 68 00 00 35 E8 13 40 B9 28 FD FF 34 0F 00 80 52 8E 00 80 52 AD 00 80 52 E6 79 1F 53 04 01 80 52 A7 01 00 11 BF 01 00 71 CD 02 00 54 C3 11 00 51 E0 03 00 91 E8 43 00 91 69 CA 66 78 08 C9 64 78 0A C8 63 B8 2B 7D 08 1B 49 01 0B 0B 3F 01 0A 6B 09 C8 23 B8 20 21 4B 7A A2 00 00 54 E1 03 00 91 29 C8 6E 78 28 05 00 11 28 C8 2E 78 E7 04 00 51 FF 00 00 71 C6 08 00 11 84 08 00 51 CC FD FF 54 AD 05 00 51 BF 01 00 71 CE 09 00 11 EF 05 00 11 4C FC FF 54 48 00 98 52 EE BF 40 29 88 01 08 0B E7 03 40 B9 0D 3D 00 53 A9 3D 00 13 3F 01 00 71 8D 01 00 54 6F 01 F8 37 EA 00 00 11 CB 01 00 11 CE 7D 8A 13 EF 7D 8B 13 E7 78 1F 53 EE BF 00 29 E8 FF 9F 52 E7 03 00 B9 A8 01 08 0B F2 FF FF 17 A8 3D 00 13 1F 01 00 71 8C 03 00 54 E8 FF 9F 52 A8 01 08 0B 0D 3D 00 53 A9 3D 00 13 06 00 80 52 C9 02 F8 36 EA 03 40 79 2B 00 80 52 CC 01 00 11 A8 05 00 11 87 05 87 13 0D 3D 00 53 E7 03 00 B9 5F 01 00 72 66 11 86 1A EB 01 00 11 6E 05 8E 13 EF 7D 01 53 A9 3D 00 13 69 FE FF 37 EE BF 00 29 C6 00 00 34 E8 03 40 79 08 01 00 32 E8 03 00 79 E7 03 40 B9 02 00 00 14 E8 03 40 79 09 00 90 52 1F 01 09 6B A8 00 00 54 E8 40 00 12 E9 07 11 32 1F 01 09 6B C1 03 00 54 E8 23 40 B8 1F 05 00 31 01 03 00 54 E8 63 40 B8 FF 23 00 B8 1F 05 00 31 01 02 00 54 E8 17 40 79 E9 FF 9F 52 FF 63 00 B8 EE 07 40 B9 1F 01 09 6B C1 00 00 54 15 00 90 52 A8 05 00 11 F5 17 00 79 0D 3D 00 53 03 00 00 14 08 05 00 11 E8 17 00 79 EF 0B 40 B9 08 00 00 14 08 05 00 11 E8 63 00 B8 EF 0B 40 B9 03 00 00 14 08 05 00 11 E8 23 00 B8 EE 07 40 B9 E8 FF 8F 52 BF 01 08 6B 02 01 00 54 E8 07 40 79 6E 22 00 B8 6F 62 00 B8 68 02 00 79 48 00 0D 2A A8 00 00 79 40 01 00 14 5F 00 00 71 E9 FF 8F 12 E8 3F 11 32 28 11 88 1A 68 0A 00 B9 7F 7E 00 29 39 01 00 14 E4 A3 00 91 E7 83 89 9A 07 08 00 B4 0D 00 80 52 0B 00 80 52 0C 00 80 52 68 02 40 F9 EF 43 00 91 8C 79 8B 13 69 0A 40 B9 AA 75 1E 53 6D 79 8D 13 6A 36 00 29 6C 0A 00 B9 E8 01 00 F9 E9 09 00 B9 E5 13 40 B9 AF 00 0A 0B 6F 02 00 B9 FF 01 0A 6B 63 00 00 54 FF 01 05 6B 22 01 00 54 A8 01 00 11 0D 05 00 11 BF 01 08 6B 6D 06 00 B9 A0 29 41 7A 62 00 00 54 8C 05 00 11 6C 0A 00 B9 E9 17 40 B9 AA 01 09 0B 6A 06 00 B9 5F 01 0D 6B 63 00 00 54 5F 01 09 6B 62 00 00 54 8C 05 00 11 6C 0A 00 B9 E8 1B 40 B9 4B 7D 8F 13 85 14 40 38 6B 06 00 B9 89 01 08 0B AD 04 0F 0B 69 0A 00 B9 2C 7D 8A 13 6C 0A 00 B9 BF 05 0F 6B 6D 02 00 B9 63 00 00 54 BF 01 05 6B 22 01 00 54 68 01 00 11 0B 05 00 11 7F 01 08 6B 6B 06 00 B9 60 29 41 7A 62 00 00 54 8C 05 00 11 6C 0A 00 B9 CE 05 00 91 6B B2 00 29 DF 01 07 EB A1 F8 FF 54 68 0A 40 B9 CD 09 88 52 68 01 00 35 6E 2A 40 29 09 FE 9F 52 A9 01 09 0B 4F 7D 10 53 4A 41 8E 13 2D 3D 00 53 CE 3D 10 53 4F FF FF 34 6E 2A 00 29 6F 0A 00 B9 6A 0A 40 B9 AA 01 78 37 6B 32 40 29 68 01 00 11 89 01 00 11 8C 7D 88 13 EE FF 9F 52 4A 7D 89 13 A8 01 0E 0B 0D 3D 00 53 6B 79 1F 53 0A FF 7F 36 6B 32 00 29 6A 0A 00 B9 65 2A 00 91 AD 00 00 79 26 1B 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 00 81 01 D1 A6 00 F8 36 ?? ?? ?? ?? ?? ?? ?? ?? 00 81 01 D1 E6 03 06 4B 06 1A 00 34 15 00 90 52 C9 08 00 12 C6 7C 03 13 00 50 01 91 49 19 00 34 29 7D 40 93 8A 01 80 D2 2E 01 0A 9B 0B 00 90 52 C8 01 40 79 1F 01 0B 6B 43 01 00 54 C9 01 40 F9 EC 43 00 91 CA 09 40 B9 EE 43 00 91 89 01 00 F9 8A 09 00 B9 EB 23 41 B8 6B 05 00 51 EB 23 01 B8 AC 00 40 79 EB FF 8F 52 FF 7F 00 29 CD 15 40 79 FF 0B 00 B9 8A 39 00 12 A7 39 00 12 E9 00 0A 0B 88 01 0D 4A 2F 3D 00 53 14 01 11 12 5F 01 0B 6B E2 14 00 54 E4 FF 8F 52 FF 00 04 6B 82 14 00 54 A8 FF 97 52 FF 01 08 6B 28 14 00 54 EC F7 87 52 FF 01 0C 6B 68 00 00 54 7F 0A 00 B9 A1 00 00 14 8A 01 00 35 69 0A 40 B9 E8 05 00 11 0F 3D 00 53 2A 79 00 12 EA 00 00 35 6B 06 40 B9 AB 00 00 35 6C 02 40 B9 6C 00 00 35 BF 00 00 79 96 00 00 14 47 01 00 35 C9 09 40 B9 E8 05 00 11 0F 3D 00 53 2A 79 00 12 AA 00 00 35 CB 05 40 B9 6B 00 00 35 CC 01 40 B9 2C FD FF 34 04 00 80 52 87 00 80 52 AD 00 80 52 82 78 1F 53 01 01 80 52 A3 01 00 11 BF 01 00 71 AD 02 00 54 EC 10 00 51 F6 03 00 91 69 CA 62 78 C8 C9 61 78 CA CA 6C B8 2B 7D 08 1B 49 01 0B 0B 3F 01 0A 6B C9 CA 2C B8 20 21 4B 7A A2 00 00 54 EA 03 00 91 49 C9 67 78 28 05 00 11 48 C9 27 78 63 04 00 51 7F 00 00 71 42 08 00 11 21 08 00 51 EC FD FF 54 AD 05 00 51 BF 01 00 71 E7 08 00 11 84 04 00 11 6C FC FF 54 4A 00 98 52 E7 0B 40 B9 E8 01 0A 0B E4 3F 40 29 0D 3D 00 53 A9 3D 00 13 3F 01 00 71 8D 01 00 54 67 01 F8 37 8A 00 00 11 EB 01 00 11 EF 7D 8A 13 E7 7C 8B 13 84 78 1F 53 EF 9F 00 29 E8 FF 9F 52 E4 03 00 B9 A8 01 08 0B F2 FF FF 17 AA 3D 00 13 5F 01 00 71 8C 03 00 54 E8 FF 9F 52 A8 01 08 0B 0D 3D 00 53 A9 3D 00 13 0E 00 80 52 C9 02 F8 36 EB 03 40 79 2A 00 80 52 EC 01 00 11 A8 05 00 11 84 05 84 13 0D 3D 00 53 E4 03 00 B9 7F 01 00 72 4E 11 8E 1A EA 00 00 11 4F 05 8F 13 E7 7C 01 53 A9 3D 00 13 69 FE FF 37 EF 9F 00 29 CE 00 00 34 EA 03 40 79 48 01 00 32 E8 03 00 79 E4 03 40 B9 02 00 00 14 E8 03 40 79 09 00 90 52 1F 01 09 6B A8 00 00 54 89 40 00 12 EB 07 11 32 3F 01 0B 6B A1 03 00 54 EA 23 40 B8 5F 05 00 31 E1 02 00 54 EA 63 40 B8 FF 23 00 B8 5F 05 00 31 E1 01 00 54 E8 17 40 79 EC FF 9F 52 FF 63 00 B8 EF 07 40 B9 1F 01 0C 6B A1 00 00 54 A8 05 00 11 F5 17 00 79 0D 3D 00 53 03 00 00 14 09 05 00 11 E9 17 00 79 E7 0B 40 B9 08 00 00 14 48 05 00 11 E8 63 00 B8 E7 0B 40 B9 03 00 00 14 4B 05 00 11 EB 23 00 B8 EF 07 40 B9 E9 FF 8F 52 BF 01 09 6B C3 00 00 54 9F 02 00 71 EC FF 8F 12 E8 3F 11 32 88 11 88 1A 0C 00 00 14 E9 07 40 79 6F 22 00 B8 67 62 00 B8 69 02 00 79 89 02 0D 2A A9 00 00 79 07 00 00 14 9F 02 00 71 EA FF 8F 12 E8 3F 11 32 48 11 88 1A 68 0A 00 B9 7F 7E 00 29 66 E6 FF 35 E8 A3 4C 39 88 00 00 34 A8 00 40 79 08 01 11 32 A8 00 00 79 A8 00 40 79 EA FF 8F 52 09 39 00 12 5F 21 29 6B 68 00 80 52 00 01 9F 1A FF C3 0C 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_37_0 {
	meta:
		name = "?convert_ld12_to_ldouble@@YAXQEBU_LDBL12@@QEAU_LDOUBLE@@@Z"
		size = 184
		refs = "0008 __security_push_cookie 00ac __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 08 14 40 79 0A 60 40 B8 09 20 40 B8 0C 39 00 12 0D 01 11 12 08 00 40 79 EA 03 00 B9 0B 3D 10 53 EB 0B 00 B9 4B 03 F8 36 68 79 00 12 08 03 00 34 28 05 00 11 1F 01 09 6B E8 07 00 B9 00 29 41 7A EA 27 9F 1A 0B 00 80 52 4A 01 00 34 EE 03 00 91 CA D9 6B B8 49 05 00 11 3F 01 0A 6B C9 D9 2B B8 20 29 41 7A EA 27 9F 1A 6B 05 00 51 EB FE FF 36 E9 07 40 B9 AA 00 00 34 88 05 00 11 0C 3D 00 53 0A 00 B0 52 02 00 00 14 EA 03 40 B9 A8 01 0C 2A 29 28 00 29 28 10 00 79 FF 43 00 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_38_0 {
	meta:
		name = "?get@?$c_string_character_source@D@__crt_strtox@@QEAADXZ"
		size = 20
	strings:
		$1 = { 09 00 00 91 28 01 40 F9 00 15 C0 38 28 01 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_39_0 {
	meta:
		name = "?increment_mantissa@@YA_NQEAIH@Z"
		size = 104
	strings:
		$1 = { 28 7C 04 13 29 6C 48 0B E8 03 80 52 0E 00 00 91 2C 7D 05 13 2A 14 0C 4B 29 00 80 52 8D 05 00 51 08 01 0A 4B 2B 21 C8 1A C9 D9 6C B8 28 01 0B 0B 1F 01 09 6B C8 D9 2C B8 00 21 4B 7A 08 00 00 14 20 01 00 34 CA D9 6D B8 49 05 00 11 3F 01 0A 6B C9 D9 2D B8 20 29 41 7A AD 05 00 51 E0 27 9F 1A 0D FF FF 36 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_40_0 {
	meta:
		name = "?is_digit_or_nondigit@__crt_strtox@@YA_NH@Z"
		size = 56
	strings:
		$1 = { 08 C0 00 51 1F 25 00 71 68 00 00 54 20 00 80 52 09 00 00 14 08 84 01 51 1F 65 00 71 89 FF FF 54 08 04 01 51 1F 65 00 71 29 FF FF 54 1F 7C 01 71 E0 17 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_192_41_0 {
	meta:
		name = "?is_space@__crt_strtox@@YA_NDQEAU__crt_locale_pointers@@@Z"
		size = 104
		refs = "0030 _isctype_l 0048 __pctype_func"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 1C 00 53 C1 01 00 B4 29 00 40 F9 28 09 40 B9 1F 05 00 71 CD 00 00 54 22 00 00 91 01 01 80 52 60 02 00 11 ?? ?? ?? ?? 08 00 00 14 28 01 40 F9 09 D9 73 78 20 01 1D 12 04 00 00 14 ?? ?? ?? ?? 08 D8 73 78 00 01 1D 12 1F 00 00 71 E0 07 9F 1A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_42_0 {
	meta:
		name = "?mantissa_has_zero_tail@@YA_NQEAIH@Z"
		size = 92
	strings:
		$1 = { 28 7C 04 13 29 6C 48 0B E8 03 80 52 2B 7D 05 13 2A 14 0B 4B 09 00 80 12 08 01 0A 4B 28 21 C8 1A 09 D8 6B B8 EA 03 28 2A 4A 01 09 0A 6A 00 00 34 00 00 80 52 09 00 00 14 6C 05 00 11 04 00 00 14 0B D8 6C B8 6B FF FF 35 8C 05 00 11 9F 0D 00 71 8B FF FF 54 20 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_43_0 {
	meta:
		name = "?multiply_ld12@@YAXQEAU_LDBL12@@QEBU1@@Z"
		size = 764
		refs = "000c __security_push_cookie 02ec __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 0B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 09 14 40 79 FF 7F 00 29 2A 14 40 79 FF 0B 00 B9 2D 39 00 12 28 01 0A 4A 4B 39 00 12 03 01 11 12 68 01 0D 0B E9 FF 8F 52 0C 3D 00 53 BF 01 09 6B 62 14 00 54 E8 FF 8F 52 7F 01 08 6B 02 14 00 54 A8 FF 97 52 9F 01 08 6B A8 13 00 54 E8 F7 87 52 9F 01 08 6B 68 00 00 54 1F 08 00 B9 9D 00 00 14 8D 01 00 35 09 08 40 B9 88 05 00 11 0C 3D 00 53 2A 79 00 12 EA 00 00 35 08 04 40 B9 A8 00 00 35 08 00 40 B9 68 00 00 35 1F 14 00 79 92 00 00 14 4B 01 00 35 29 08 40 B9 88 05 00 11 0C 3D 00 53 2A 79 00 12 AA 00 00 35 28 04 40 B9 68 00 00 35 28 00 40 B9 28 FD FF 34 0F 00 80 52 8E 00 80 52 AD 00 80 52 E6 79 1F 53 05 01 80 52 A7 01 00 11 BF 01 00 71 AD 02 00 54 C4 11 00 51 F3 03 00 91 09 C8 66 78 28 C8 65 78 6A CA 64 B8 2B 7D 08 1B 49 01 0B 0B 3F 01 0A 6B 69 CA 24 B8 20 21 4B 7A A2 00 00 54 E2 03 00 91 49 C8 6E 78 28 05 00 11 48 C8 2E 78 E7 04 00 51 FF 00 00 71 C6 08 00 11 A5 08 00 51 EC FD FF 54 AD 05 00 51 BF 01 00 71 CE 09 00 11 EF 05 00 11 6C FC FF 54 48 00 98 52 EE BF 40 29 88 01 08 0B E7 03 40 B9 0D 3D 00 53 A9 3D 00 13 3F 01 00 71 8D 01 00 54 6F 01 F8 37 EA 00 00 11 CB 01 00 11 CE 7D 8A 13 EF 7D 8B 13 E7 78 1F 53 EE BF 00 29 E8 FF 9F 52 E7 03 00 B9 A8 01 08 0B F2 FF FF 17 A8 3D 00 13 1F 01 00 71 8C 03 00 54 E8 FF 9F 52 A8 01 08 0B 0D 3D 00 53 A9 3D 00 13 06 00 80 52 C9 02 F8 36 EA 03 40 79 2B 00 80 52 CC 01 00 11 A8 05 00 11 87 05 87 13 0D 3D 00 53 E7 03 00 B9 5F 01 00 72 66 11 86 1A EB 01 00 11 6E 05 8E 13 EF 7D 01 53 A9 3D 00 13 69 FE FF 37 EE BF 00 29 C6 00 00 34 E8 03 40 79 08 01 00 32 E8 03 00 79 E7 03 40 B9 02 00 00 14 E8 03 40 79 09 00 90 52 1F 01 09 6B A8 00 00 54 E8 40 00 12 E9 07 11 32 1F 01 09 6B C1 03 00 54 E8 23 40 B8 1F 05 00 31 01 03 00 54 E8 63 40 B8 FF 23 00 B8 1F 05 00 31 01 02 00 54 E8 17 40 79 E9 FF 9F 52 FF 63 00 B8 EE 07 40 B9 1F 01 09 6B C1 00 00 54 09 00 90 52 A8 05 00 11 E9 17 00 79 0D 3D 00 53 03 00 00 14 08 05 00 11 E8 17 00 79 EF 0B 40 B9 08 00 00 14 08 05 00 11 E8 63 00 B8 EF 0B 40 B9 03 00 00 14 08 05 00 11 E8 23 00 B8 EE 07 40 B9 E8 FF 8F 52 BF 01 08 6B 02 01 00 54 E8 07 40 79 0E 20 00 B8 0F 60 00 B8 08 00 00 79 68 00 0D 2A 08 14 00 79 07 00 00 14 E8 3F 11 32 E9 FF 8F 12 7F 00 00 71 28 11 88 1A 08 08 00 B9 1F 7C 00 29 FF 43 00 91 ?? ?? ?? ?? F3 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_44_0 {
	meta:
		name = "?multiply_ten_pow_ld12@@YAXQEAU_LDBL12@@H@Z"
		size = 904
		refs = "000c __security_push_cookie 0018 ?ld12_pow10_positive@@3QBU_LDBL12@@B 0028 ?ld12_pow10_negative@@3QBU_LDBL12@@B 0378 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 01 1B 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 02 81 01 D1 A1 00 F8 36 ?? ?? ?? ?? ?? ?? ?? ?? 02 81 01 D1 E1 03 01 4B E1 19 00 34 29 08 00 12 21 7C 03 13 42 50 01 91 49 19 00 34 29 7D 40 93 8A 01 80 D2 2E 09 0A 9B 0B 00 90 52 C8 01 40 79 1F 01 0B 6B 43 01 00 54 C9 01 40 F9 EC 43 00 91 CA 09 40 B9 EE 43 00 91 89 01 00 F9 8A 09 00 B9 EB 23 41 B8 6B 05 00 51 EB 23 01 B8 0C 14 40 79 EB FF 8F 52 FF 7F 00 29 CD 15 40 79 FF 0B 00 B9 8A 39 00 12 A7 39 00 12 E9 00 0A 0B 88 01 0D 4A 2F 3D 00 53 13 01 11 12 5F 01 0B 6B E2 14 00 54 E6 FF 8F 52 FF 00 06 6B 82 14 00 54 A8 FF 97 52 FF 01 08 6B 28 14 00 54 EC F7 87 52 FF 01 0C 6B 68 00 00 54 1F 08 00 B9 A1 00 00 14 8A 01 00 35 09 08 40 B9 E8 05 00 11 0F 3D 00 53 2A 79 00 12 EA 00 00 35 0B 04 40 B9 AB 00 00 35 0C 00 40 B9 6C 00 00 35 1F 14 00 79 96 00 00 14 47 01 00 35 C9 09 40 B9 E8 05 00 11 0F 3D 00 53 2A 79 00 12 AA 00 00 35 CB 05 40 B9 6B 00 00 35 CC 01 40 B9 2C FD FF 34 06 00 80 52 87 00 80 52 AD 00 80 52 C4 78 1F 53 03 01 80 52 A5 01 00 11 BF 01 00 71 AD 02 00 54 EC 10 00 51 F4 03 00 91 09 C8 64 78 C8 C9 63 78 8A CA 6C B8 2B 7D 08 1B 49 01 0B 0B 3F 01 0A 6B 89 CA 2C B8 20 21 4B 7A A2 00 00 54 EA 03 00 91 49 C9 67 78 28 05 00 11 48 C9 27 78 A5 04 00 51 BF 00 00 71 84 08 00 11 63 08 00 51 EC FD FF 54 AD 05 00 51 BF 01 00 71 E7 08 00 11 C6 04 00 11 6C FC FF 54 4A 00 98 52 E7 0B 40 B9 E8 01 0A 0B E6 3F 40 29 0D 3D 00 53 A9 3D 00 13 3F 01 00 71 8D 01 00 54 67 01 F8 37 CA 00 00 11 EB 01 00 11 EF 7D 8A 13 E7 7C 8B 13 C6 78 1F 53 EF 9F 00 29 E8 FF 9F 52 E6 03 00 B9 A8 01 08 0B F2 FF FF 17 AA 3D 00 13 5F 01 00 71 8C 03 00 54 E8 FF 9F 52 A8 01 08 0B 0D 3D 00 53 A9 3D 00 13 0E 00 80 52 C9 02 F8 36 EB 03 40 79 2A 00 80 52 EC 01 00 11 A8 05 00 11 86 05 86 13 0D 3D 00 53 E6 03 00 B9 7F 01 00 72 4E 11 8E 1A EA 00 00 11 4F 05 8F 13 E7 7C 01 53 A9 3D 00 13 69 FE FF 37 EF 9F 00 29 CE 00 00 34 EA 03 40 79 48 01 00 32 E8 03 00 79 E6 03 40 B9 02 00 00 14 E8 03 40 79 09 00 90 52 1F 01 09 6B A8 00 00 54 C9 40 00 12 EB 07 11 32 3F 01 0B 6B A1 03 00 54 EA 23 40 B8 5F 05 00 31 E1 02 00 54 EA 63 40 B8 FF 23 00 B8 5F 05 00 31 E1 01 00 54 E8 17 40 79 EC FF 9F 52 FF 63 00 B8 EF 07 40 B9 1F 01 0C 6B A1 00 00 54 A8 05 00 11 0D 3D 00 53 09 00 90 52 02 00 00 14 09 05 00 11 E9 17 00 79 E7 0B 40 B9 08 00 00 14 48 05 00 11 E8 63 00 B8 E7 0B 40 B9 03 00 00 14 4B 05 00 11 EB 23 00 B8 EF 07 40 B9 E9 FF 8F 52 BF 01 09 6B C3 00 00 54 7F 02 00 71 EC FF 8F 12 E8 3F 11 32 88 11 88 1A 0C 00 00 14 E9 07 40 79 0F 20 00 B8 07 60 00 B8 09 00 00 79 69 02 0D 2A 09 14 00 79 07 00 00 14 7F 02 00 71 EA FF 8F 12 E8 3F 11 32 48 11 88 1A 08 08 00 B9 1F 7C 00 29 61 E6 FF 35 FF 83 00 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_45_0 {
	meta:
		name = "?multiply_two_pow_ld12@@YAXQEAU_LDBL12@@H@Z"
		size = 788
		refs = "0008 __security_push_cookie 0308 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 08 00 B0 52 FF 23 00 79 E9 FF 87 52 E8 63 01 B8 28 00 09 0B 09 14 40 79 FF 23 01 B8 0A 3D 00 53 FF 7F 00 29 4B 39 00 12 EA 37 00 79 FF 0B 00 B9 48 01 09 4A 2D 39 00 12 03 01 11 12 68 01 0D 0B E9 FF 8F 52 0C 3D 00 53 BF 01 09 6B 82 14 00 54 E8 FF 8F 52 7F 01 08 6B 22 14 00 54 A8 FF 97 52 9F 01 08 6B C8 13 00 54 E8 F7 87 52 9F 01 08 6B 68 00 00 54 1F 08 00 B9 9E 00 00 14 8D 01 00 35 09 08 40 B9 88 05 00 11 0C 3D 00 53 2A 79 00 12 EA 00 00 35 08 04 40 B9 A8 00 00 35 08 00 40 B9 68 00 00 35 1F 14 00 79 93 00 00 14 4B 01 00 35 E9 1B 40 B9 88 05 00 11 0C 3D 00 53 28 79 00 12 A8 00 00 35 E8 17 40 B9 68 00 00 35 E8 13 40 B9 28 FD FF 34 0F 00 80 52 8E 00 80 52 AD 00 80 52 E6 79 1F 53 05 01 80 52 A7 01 00 11 BF 01 00 71 CD 02 00 54 C4 11 00 51 E1 03 00 91 E8 43 00 91 09 C8 66 78 08 C9 65 78 2A C8 64 B8 2B 7D 08 1B 49 01 0B 0B 3F 01 0A 6B 29 C8 24 B8 20 21 4B 7A A2 00 00 54 E2 03 00 91 49 C8 6E 78 28 05 00 11 48 C8 2E 78 E7 04 00 51 FF 00 00 71 C6 08 00 11 A5 08 00 51 CC FD FF 54 AD 05 00 51 BF 01 00 71 CE 09 00 11 EF 05 00 11 4C FC FF 54 48 00 98 52 EE BF 40 29 88 01 08 0B E7 03 40 B9 0D 3D 00 53 A9 3D 00 13 3F 01 00 71 8D 01 00 54 6F 01 F8 37 EA 00 00 11 CB 01 00 11 CE 7D 8A 13 EF 7D 8B 13 E7 78 1F 53 EE BF 00 29 E8 FF 9F 52 E7 03 00 B9 A8 01 08 0B F2 FF FF 17 A8 3D 00 13 1F 01 00 71 8C 03 00 54 E8 FF 9F 52 A8 01 08 0B 0D 3D 00 53 A9 3D 00 13 06 00 80 52 C9 02 F8 36 EA 03 40 79 2B 00 80 52 CC 01 00 11 A8 05 00 11 87 05 87 13 0D 3D 00 53 E7 03 00 B9 5F 01 00 72 66 11 86 1A EB 01 00 11 6E 05 8E 13 EF 7D 01 53 A9 3D 00 13 69 FE FF 37 EE BF 00 29 C6 00 00 34 E8 03 40 79 08 01 00 32 E8 03 00 79 E7 03 40 B9 02 00 00 14 E8 03 40 79 09 00 90 52 1F 01 09 6B A8 00 00 54 E8 40 00 12 E9 07 11 32 1F 01 09 6B C1 03 00 54 E8 23 40 B8 1F 05 00 31 01 03 00 54 E8 63 40 B8 FF 23 00 B8 1F 05 00 31 01 02 00 54 E8 17 40 79 E9 FF 9F 52 FF 63 00 B8 EE 07 40 B9 1F 01 09 6B C1 00 00 54 09 00 90 52 A8 05 00 11 E9 17 00 79 0D 3D 00 53 03 00 00 14 08 05 00 11 E8 17 00 79 EF 0B 40 B9 08 00 00 14 08 05 00 11 E8 63 00 B8 EF 0B 40 B9 03 00 00 14 08 05 00 11 E8 23 00 B8 EE 07 40 B9 E8 FF 8F 52 BF 01 08 6B 02 01 00 54 E8 07 40 79 0E 20 00 B8 0F 60 00 B8 08 00 00 79 68 00 0D 2A 08 14 00 79 07 00 00 14 E8 3F 11 32 E9 FF 8F 12 7F 00 00 71 28 11 88 1A 08 08 00 B9 1F 7C 00 29 FF 83 00 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_46_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAID@Z"
		size = 76
	strings:
		$1 = { 08 40 03 11 09 1D 00 53 3F 25 00 71 68 00 00 54 00 C0 00 51 0D 00 00 14 08 7C 02 11 09 1D 00 53 3F 65 00 71 68 00 00 54 00 5C 01 51 07 00 00 14 08 FC 02 11 09 1D 00 53 3F 65 00 71 00 DC 00 51 49 00 00 54 00 00 80 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_48_0 {
	meta:
		name = "?round_mantissa@@YA_NQEAIH@Z"
		size = 292
	strings:
		$1 = { 2D 04 00 51 AA 05 00 11 48 7D 04 13 49 6D 48 0B E8 03 80 52 0F 00 80 52 2E 7D 05 13 4A 15 0E 4B 07 01 0A 4B 28 00 80 52 09 21 C7 1A 08 D8 6E B8 29 01 08 0A E9 04 00 34 08 00 80 12 09 D8 6E B8 08 21 C7 1A EA 03 28 2A 2A 01 0A 0A 2A 01 00 35 CC 05 00 11 04 00 00 14 0B D8 6C B8 AB 00 00 35 8C 05 00 11 9F 0D 00 71 8B FF FF 54 19 00 00 14 A8 7D 04 13 A9 6D 48 0B E8 03 80 52 2C 7D 05 13 AA 15 0C 4B 29 00 80 52 8D 05 00 51 08 01 0A 4B 2B 21 C8 1A 09 D8 6C B8 28 01 0B 0B 1F 01 09 6B 08 D8 2C B8 00 21 4B 7A 08 00 00 14 2F 01 00 34 0A D8 6D B8 49 05 00 11 3F 01 0A 6B 09 D8 2D B8 20 29 41 7A AD 05 00 51 EF 27 9F 1A 0D FF FF 36 08 00 80 12 09 21 C7 1A 08 D8 6E B8 CB 05 00 11 7F 0D 00 71 29 01 08 0A 09 D8 2E B8 8A 01 00 54 68 00 80 52 08 01 0B 4B 69 7D 40 93 0A 75 1E 53 0B 08 09 8B 48 7D 02 53 6C 09 08 8B 7F 01 0C EB 60 00 00 54 7F 45 00 B8 FD FF FF 17 E0 01 00 11 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_50_0 {
	meta:
		name = "?shr_ld12@@YAXQEAU_LDBL12@@@Z"
		size = 32
	strings:
		$1 = { 0A A4 40 29 28 7D 01 53 29 05 8A 13 09 A0 00 29 08 00 40 B9 4A 05 88 13 0A 00 00 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_51_0 {
	meta:
		name = "?transform_into_return_value@@YAHW4SLD_STATUS@@@Z"
		size = 32
	strings:
		$1 = { 1F 08 00 71 A0 00 00 54 1F 0C 00 71 68 00 80 52 E0 13 88 1A 02 00 00 14 80 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_52_0 {
	meta:
		name = "?unget@?$c_string_character_source@D@__crt_strtox@@QEAAXD@Z"
		size = 60
		refs = "0024 _errno 0030 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 08 00 40 F9 09 05 00 D1 09 00 00 F9 01 01 00 34 28 01 C0 39 1F 01 01 6B A0 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_53_0 {
	meta:
		name = "?validate@?$c_string_character_source@D@__crt_strtox@@QEBA_NXZ"
		size = 52
		refs = "0010 _errno 001c _invalid_parameter_noinfo"
		altNames = "?validate@?$c_string_character_source@_W@__crt_strtox@@QEBA_NXZ ?validate@?$stream_input_adapter@_W@__crt_stdio_input@@QEBA_NXZ ?validate@?$stream_output_adapter@_W@__crt_stdio_output@@QEBA_NXZ ?validate@?$string_output_adapter@D@__crt_stdio_output@@QEBA_NXZ ?validate@?$string_output_adapter@_W@__crt_stdio_output@@QEBA_NXZ"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 08 00 40 F9 E8 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_57_0 {
	meta:
		name = "_atoldbl_l"
		size = 308
		refs = "000c __security_push_cookie 0024 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0040 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0050 ??$parse_floating_point@V?$c_string_character_source@D@__crt_strtox@@U_LDBL12@@@__crt_strtox@@YA?AW4SLD_STATUS@@QEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@QEAU_LDBL12@@@Z 0124 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 53 01 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 01 D1 14 00 00 91 33 00 00 91 41 00 00 91 E0 03 00 91 ?? ?? ?? ?? E8 83 00 91 1F 01 00 F9 02 00 80 D2 61 02 00 91 1F 09 00 B9 E0 C3 00 91 ?? ?? ?? ?? E2 83 00 91 01 00 00 91 E0 23 00 91 ?? ?? ?? ?? E8 57 40 79 EA 63 42 B8 E9 23 42 B8 0C 39 00 12 0D 01 11 12 E8 43 40 79 EA 33 00 B9 0B 3D 10 53 EB 3B 00 B9 4B 03 F8 36 68 79 00 12 08 03 00 34 28 05 00 11 1F 01 09 6B E8 37 00 B9 00 29 41 7A EB 27 9F 1A 0A 00 80 52 4B 01 00 34 EE C3 00 91 C9 D9 6A B8 28 05 00 11 1F 01 09 6B C8 D9 2A B8 00 29 41 7A EB 27 9F 1A 4A 05 00 51 EA FE FF 36 E9 37 40 B9 AB 00 00 34 88 05 00 11 0C 3D 00 53 0A 00 B0 52 02 00 00 14 EA 33 40 B9 A8 01 0C 2A 89 2A 00 29 88 12 00 79 1F 08 00 71 A0 00 00 54 1F 0C 00 71 68 00 80 52 E0 13 88 1A 02 00 00 14 80 00 80 52 E8 63 40 39 A8 00 00 34 EA 03 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FF 03 01 91 ?? ?? ?? ?? F3 53 41 A9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_58_0 {
	meta:
		name = "_chvalidchk_l"
		size = 68
		refs = "002c __pctype_func"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 11 34 00 00 11 C2 00 00 B4 48 00 40 F9 09 01 40 F9 2A D9 73 78 40 01 14 0A 04 00 00 14 ?? ?? ?? ?? 08 D8 73 78 00 01 14 0A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_192_59_0 {
	meta:
		name = "_ischartype_l"
		size = 84
		refs = "0028 _isctype_l 003c __pctype_func"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 11 34 00 00 11 42 01 00 B4 49 00 40 F9 28 09 40 B9 1F 05 00 71 6D 00 00 54 ?? ?? ?? ?? 07 00 00 14 28 01 40 F9 0A D9 73 78 03 00 00 14 ?? ?? ?? ?? 0A D8 73 78 40 01 14 0A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_193_0_0 {
	meta:
		name = "_dscale"
		size = 664
		refs = "005c _dnorm 0084 _Inf_C"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6C 0E 40 79 34 00 00 11 88 29 1C 12 09 7D 04 53 2B 3D 00 13 7F FD 1F 71 61 01 00 54 88 0D 00 12 E8 00 00 35 68 0A 40 79 A8 00 00 35 68 06 40 79 68 00 00 35 68 02 40 79 C8 02 00 34 40 00 80 52 8F 00 00 14 CB 00 00 35 60 02 00 91 ?? ?? ?? ?? 0B 00 00 11 7F 01 00 71 0C 11 00 54 9F 02 00 71 CD 01 00 54 E8 FF 80 52 08 01 0B 4B 1F 01 14 6B 4C 01 00 54 ?? ?? ?? ?? 68 0E 40 79 ?? ?? ?? ?? 1F 01 11 72 30 42 61 1E 10 1E 71 1E 70 02 00 FD 20 00 80 52 7A 00 00 14 E8 03 0B 4B 1F 01 14 6B 68 0E 40 79 0A 01 00 54 EA 01 90 52 08 01 0A 0A 69 01 14 0B 09 11 09 2A 69 0E 00 79 00 00 80 12 6F 00 00 14 06 01 11 12 68 0E 40 79 08 0D 00 12 0F 01 1C 32 68 01 14 0B 6F 0E 00 79 0A 05 00 51 49 D5 00 11 3F D1 00 71 08 0C 00 54 4C 3D 00 13 9F 41 00 31 07 00 80 52 6C 02 00 54 6D 0A 40 79 6E 06 40 79 6A 02 40 79 FF 00 00 71 6E 02 00 79 EB 07 9F 1A 89 41 00 11 AE 01 00 11 68 01 0A 2A 2C 3D 00 13 ED 01 00 11 07 3D 00 53 0F 00 80 52 9F 41 00 31 8D FE FF 54 7F 0E 00 79 6D 0A 00 79 6E 06 00 79 E8 03 0C 4B 0E 3D 00 13 4E 04 00 34 6B 02 40 79 08 02 80 52 0F 01 0E 4B 6D 06 40 79 FF 00 00 71 6C 0A 40 79 E9 07 9F 1A 68 21 CF 1A 0A 3D 00 53 48 01 09 2A 07 3D 00 53 A8 21 CF 1A 69 25 CE 1A 0A 3D 00 53 28 3D 00 53 4A 01 08 2A 88 21 CF 1A 6A 02 00 79 A9 25 CE 1A 0A 3D 00 53 28 3D 00 53 4A 01 08 2A 68 0E 40 79 6A 06 00 79 89 25 CE 1A 08 21 CF 1A 0A 3D 00 53 28 3D 00 53 4A 01 08 2A 68 0E 40 79 6A 0A 00 79 09 25 CE 1A 69 0E 00 79 68 0E 40 79 0B 01 06 2A 08 00 90 52 6B 0E 00 79 1F 01 07 6B A3 00 00 54 1F 01 07 6B A1 02 00 54 68 02 40 79 68 02 00 36 69 02 40 79 28 05 00 11 0A 3D 00 53 6A 02 00 79 CA 01 00 35 68 06 40 79 08 05 00 11 09 3D 00 53 69 06 00 79 29 01 00 35 68 0A 40 79 08 05 00 11 09 3D 00 53 69 0A 00 79 89 00 00 35 68 05 00 11 68 0E 00 79 9F FF FF 17 7F 01 06 6B A1 F3 FF 54 68 0A 40 79 68 F3 FF 35 68 06 40 79 28 F3 FF 35 68 02 40 79 C8 00 00 34 96 FF FF 17 66 0E 00 79 7F 0A 00 79 7F 06 00 79 7F 02 00 79 00 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_193_1_0 {
	meta:
		name = "_fdscale"
		size = 476
		refs = "004c _fdnorm 0074 _FInf_C"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 6C 06 40 79 34 00 00 11 88 1D 19 12 09 7D 07 53 2B 3D 00 13 7F FD 03 71 E1 00 00 54 88 19 00 12 68 00 00 35 68 02 40 79 C8 02 00 34 40 00 80 52 64 00 00 14 CB 00 00 35 60 02 00 91 ?? ?? ?? ?? 0B 00 00 11 7F 01 00 71 AC 0B 00 54 9F 02 00 71 CD 01 00 54 E8 1F 80 52 08 01 0B 4B 1F 01 14 6B 4C 01 00 54 ?? ?? ?? ?? 68 06 40 79 ?? ?? ?? ?? 1F 01 11 72 30 42 21 1E 10 1E 31 1E 70 02 00 BD 20 00 80 52 4F 00 00 14 E8 03 0B 4B 1F 01 14 6B 68 06 40 79 0A 01 00 54 EA 0F 90 52 08 01 0A 0A 69 01 14 0B 09 1D 09 2A 69 06 00 79 00 00 80 12 44 00 00 14 29 00 80 52 0F 01 11 12 28 61 19 33 0C 01 00 11 68 01 14 0B 6C 06 00 79 0A 05 00 51 49 61 00 11 3F 5D 00 71 E8 06 00 54 48 3D 00 13 1F 41 00 31 0E 00 80 52 CC 00 00 54 08 41 00 11 6E 02 40 79 7F 06 00 79 08 3D 00 13 6C 02 00 79 E8 03 08 4B 0C 3D 00 13 8C 02 00 34 6D 02 40 79 08 02 80 52 0B 01 0C 4B DF 01 00 71 E9 07 9F 1A A8 21 CB 1A 0A 3D 00 53 48 01 09 2A 69 06 40 79 0E 3D 00 53 28 21 CB 1A A9 25 CC 1A 0A 3D 00 53 28 3D 00 53 4A 01 08 2A 68 06 40 79 6A 02 00 79 09 25 CC 1A 69 06 00 79 68 06 40 79 0B 01 0F 2A 08 00 90 52 6B 06 00 79 1F 01 0E 6B A3 00 00 54 1F 01 0E 6B 61 01 00 54 68 02 40 79 28 01 00 36 69 02 40 79 28 05 00 11 0A 3D 00 53 6A 02 00 79 8A 00 00 35 68 05 00 11 68 06 00 79 C4 FF FF 17 7F 01 0F 6B 41 F8 FF 54 68 02 40 79 88 00 00 34 BF FF FF 17 6F 06 00 79 7F 02 00 79 00 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_194_0_0 {
	meta:
		name = "log"
		size = 584
		refs = "002c _handle_nan 004c ??_C@_03MGHMBJCF@log?$AA@ 0060 _handle_error 016c ?ln_tail_table@?1??log@@9@9 0180 ?ln_lead_table@?1??log@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 0C 00 66 9E 09 FE EF D2 E0 0B 00 FD 88 29 4C 92 1F 01 09 EB 61 02 00 54 88 CD 40 92 88 00 00 B4 80 01 00 91 ?? ?? ?? ?? 69 00 00 14 88 01 41 92 E8 0C 00 B4 25 04 80 52 04 01 80 52 23 00 80 52 02 FF FF D2 ?? ?? ?? ?? E1 03 67 9E ?? ?? ?? ?? 26 00 80 52 41 03 80 52 ?? ?? ?? ?? 5C 00 00 14 88 F9 40 92 C8 00 00 B5 45 04 80 52 84 00 80 52 43 00 80 52 02 FE FF D2 F3 FF FF 17 88 01 41 92 A8 FD FF B5 A8 0A 00 58 88 01 08 8B A9 0A 00 58 1F 01 09 EB 88 02 00 54 10 10 6E 1E 11 10 60 1E 54 0A 00 5C 1B 38 70 1E 72 2B 71 1E 73 1B 72 1E 79 2A 73 1E 7A 0A 7B 1E D3 09 00 5C 38 0B 79 1E 15 4F 54 1F B4 09 00 5C B6 52 58 1F B5 09 00 5C D7 56 58 1F 16 0B 79 1E F7 EA 76 1F E0 2A 7B 1E 3B 00 00 14 08 02 E0 D2 9F 01 08 EB 62 01 00 54 08 7A E0 D2 B0 08 00 5C 88 01 08 AA 11 01 67 9E E8 0B 00 F9 8B 07 80 52 31 3A 70 1E F1 0B 00 FD 2C 02 66 9E 02 00 00 14 0B 00 80 52 88 FD 74 D3 90 07 00 5C 0A 29 00 12 88 01 00 91 C9 7F 80 D2 28 2D 4C B3 E8 0B 00 F9 88 FD 6E D3 4B 01 0B 4B F2 0B 40 FD 0A 15 00 12 88 FD 6D D3 6D FD 0F 51 4B 01 1A 32 BA 01 62 1E 0A 01 00 12 6C 01 0A 0B 91 01 62 1E ?? ?? ?? ?? ?? ?? ?? ?? 89 01 01 51 34 0A 70 1E 10 D9 69 FC ?? ?? ?? ?? 11 10 6C 1E ?? ?? ?? ?? 53 3A 74 1E 72 52 51 1F 11 D9 69 FC 54 04 00 5C 77 1A 72 1E 53 04 00 5C 72 04 00 5C 52 47 52 1F F6 0A 77 1E D5 4E 54 1F 34 04 00 5C B5 52 56 1F B6 0A 76 1E D7 5E 57 1F F8 2A 70 1E D7 03 00 5C 59 63 57 1F 20 2B 72 1E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 56 F0 11 C0 00 00 00 00 82 F8 02 00 F0 FF 5D C8 34 80 3C 3F 9F 51 F1 07 23 49 62 3F D4 C6 BA 99 99 99 89 3F E6 54 55 55 55 55 B5 3F 00 00 00 00 00 00 D0 03 00 00 00 00 00 00 80 3F 41 47 D9 3B 42 49 62 3F DE 5E 86 99 99 99 89 3F 00 00 00 E0 42 2E E6 3F 57 55 55 55 55 55 B5 3F 3C 79 35 EF 39 FA 6E 3E }
	condition:
		$1
}

rule file_195_1_0 {
	meta:
		name = "_mbstok_l"
		size = 68
		refs = "001c __acrt_getptd 0030 _mbstok_s_l"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 15 00 00 91 34 00 00 91 53 00 00 91 ?? ?? ?? ?? 02 E0 00 91 A0 02 00 91 63 02 00 91 81 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_196_0_0 {
	meta:
		name = "nearbyintf"
		size = 44
		refs = "0010 _fdtest 0020 _fdrint"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 13 00 BD ?? ?? ?? ?? E0 13 40 BD 1F 08 00 71 49 00 00 54 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_197_0_0 {
	meta:
		name = "_FCmulcc"
		size = 104
		refs = "0010 crealf 0020 cimagf 005c _FCbuild"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 07 05 2D E2 0F 04 2D ?? ?? ?? ?? E1 2F 40 BD E0 1B 00 BD E0 2B 40 BD ?? ?? ?? ?? E1 27 40 BD E0 17 00 BD E0 23 40 BD ?? ?? ?? ?? E1 27 40 BD E0 13 00 BD E0 23 40 BD ?? ?? ?? ?? F1 4B 42 2D F3 1B 40 BD 30 0A 32 1E 31 0A 33 1E 01 40 13 1F 00 C4 12 1F ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_197_1_0 {
	meta:
		name = "_FCmulcr"
		size = 60
		refs = "0010 cimagf 0020 crealf 0030 _FCbuild"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 03 2D E2 17 00 BD ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? F0 47 42 2D 01 0A 31 1E 00 08 31 1E ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_197_2_0 {
	meta:
		name = "cpowf"
		size = 144
		refs = "0010 cimagf 0020 crealf 0058 powf 0060 _FCbuild 006c clogf 0080 _FCmulcc 0084 cexpf"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 07 03 2D E2 0F 04 2D ?? ?? ?? ?? 08 20 20 1E 81 02 00 54 E0 07 43 2D ?? ?? ?? ?? 08 20 20 1E 0B 02 00 54 E0 07 44 2D ?? ?? ?? ?? 08 20 20 1E 81 01 00 54 E0 07 44 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? E1 13 40 BD ?? ?? ?? ?? E1 03 27 1E ?? ?? ?? ?? 09 00 00 14 E0 07 43 2D ?? ?? ?? ?? 23 40 20 1E E1 27 40 BD 02 40 20 1E E0 23 40 BD ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_198_0_0 {
	meta:
		name = "_LSinh"
		size = 416
		refs = "0014 _ldtest 004c _LRteps_C 00b8 _LXbig_C 00d4 _ldexp 0140 _fperrraise 0144 _LNan_C"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 13 00 00 11 E0 63 00 91 ?? ?? ?? ?? 73 07 F8 36 40 07 F8 36 F5 0B 40 FD A8 22 60 1E A2 00 00 54 B5 42 61 1E 33 00 80 52 F5 0B 00 FD 02 00 00 14 13 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? A0 22 70 1E 82 00 00 54 F1 0F 40 FD B2 0A 71 1E 27 00 00 14 50 08 00 5C A0 22 70 1E 42 02 00 54 B8 0A 75 1E 12 08 00 5C 31 08 00 5C 00 10 6E 1E 13 47 52 1F 12 08 00 5C 74 4A 58 1F 13 0B 75 1E 97 56 53 1F D5 07 00 5C F4 07 00 5C 16 D3 75 1F D5 02 58 1F F6 0F 40 FD F7 1A 75 1E F2 0A 76 1E 13 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 01 00 80 12 E0 43 00 91 A0 22 70 1E 42 01 00 54 00 10 6E 1E ?? ?? ?? ?? F1 0B 40 FD 10 10 6A 1E 10 1A 71 1E 32 3A 70 1E F1 0F 40 FD 52 0A 71 1E 04 00 00 14 E0 0F 40 FD ?? ?? ?? ?? F2 0B 40 FD 50 42 61 1E 7F 02 00 71 00 1E 72 1E 16 00 00 14 7F 0A 00 71 61 00 00 54 E0 0B 40 FD 12 00 00 14 1F 08 00 71 61 00 00 54 E0 0F 40 FD 0E 00 00 14 7F 06 00 71 E1 00 00 54 20 01 00 35 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 00 00 14 73 00 00 35 1F 04 00 71 20 FF FF 54 F1 43 41 6D 20 0A 70 1E FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 0B 03 AD 7A EA 93 E1 3F DC 4A FD 3F A1 0F 0C 3F 3B 78 52 CC 86 BE 74 3F 72 82 62 3E 65 B3 C2 3F A2 64 E9 3D 4F D7 24 3F 66 9F 96 B7 80 0F 95 3F }
	condition:
		$1
}

rule file_551_0_0 {
	meta:
		name = "_Sinh"
		size = 416
		refs = "0014 _dtest 004c _Rteps_C 00b8 _Xbig_C 00d4 _dexp 0140 _fperrraise 0144 _Nan_C"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 13 00 00 11 E0 63 00 91 ?? ?? ?? ?? 73 07 F8 36 40 07 F8 36 F5 0B 40 FD A8 22 60 1E A2 00 00 54 B5 42 61 1E 33 00 80 52 F5 0B 00 FD 02 00 00 14 13 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? A0 22 70 1E 82 00 00 54 F1 0F 40 FD B2 0A 71 1E 27 00 00 14 50 08 00 5C A0 22 70 1E 42 02 00 54 B8 0A 75 1E 12 08 00 5C 31 08 00 5C 00 10 6E 1E 13 47 52 1F 12 08 00 5C 74 4A 58 1F 13 0B 75 1E 97 56 53 1F D5 07 00 5C F4 07 00 5C 16 D3 75 1F D5 02 58 1F F6 0F 40 FD F7 1A 75 1E F2 0A 76 1E 13 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 01 00 80 12 E0 43 00 91 A0 22 70 1E 42 01 00 54 00 10 6E 1E ?? ?? ?? ?? F1 0B 40 FD 10 10 6A 1E 10 1A 71 1E 32 3A 70 1E F1 0F 40 FD 52 0A 71 1E 04 00 00 14 E0 0F 40 FD ?? ?? ?? ?? F2 0B 40 FD 50 42 61 1E 7F 02 00 71 00 1E 72 1E 16 00 00 14 7F 0A 00 71 61 00 00 54 E0 0B 40 FD 12 00 00 14 1F 08 00 71 61 00 00 54 E0 0F 40 FD 0E 00 00 14 7F 06 00 71 E1 00 00 54 20 01 00 35 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 06 00 00 14 73 00 00 35 1F 04 00 71 20 FF FF 54 F1 43 41 6D 20 0A 70 1E FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 0B 03 AD 7A EA 93 E1 3F DC 4A FD 3F A1 0F 0C 3F 3B 78 52 CC 86 BE 74 3F 72 82 62 3E 65 B3 C2 3F A2 64 E9 3D 4F D7 24 3F 66 9F 96 B7 80 0F 95 3F }
	condition:
		$1
}

rule file_198_2_0 {
	meta:
		name = "csinhl"
		size = 280
		refs = "0010 creall 0020 cimagl 002c _ldtest 0044 _LNan_C 0064 _fperrraise 00b0 sin 00b4 _LInf_C 00c8 cos 00e8 _LCosh 0100 _LSinh 0108 _LCbuild"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 E0 87 02 6D ?? ?? ?? ?? E1 1B 40 FD E0 0F 00 FD E0 17 40 FD ?? ?? ?? ?? E0 63 00 91 E0 0B 00 FD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 0A 00 71 C1 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 80 01 00 35 E1 0B 40 FD 2D 00 00 14 1F 04 00 71 A1 01 00 54 20 00 80 52 ?? ?? ?? ?? 68 3E 00 53 1F 05 00 71 ?? ?? ?? ?? 89 00 00 54 ?? ?? ?? ?? 01 40 60 1E 22 00 00 14 ?? ?? ?? ?? E0 0F 40 FD 1F 00 00 14 1F 08 00 71 A0 FE FF 54 7F 06 00 71 E1 01 00 54 60 00 00 35 E1 0B 40 FD F8 FF FF 17 E0 0B 40 FD ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 08 70 1E E0 0B 40 FD F0 13 00 FD ?? ?? ?? ?? F0 87 41 6D 00 08 70 1E 0D 00 00 14 E0 0B 40 FD ?? ?? ?? ?? 01 40 60 1E E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 0B 40 FD ?? ?? ?? ?? 01 40 60 1E E0 0F 40 FD ?? ?? ?? ?? E1 13 40 FD ?? ?? ?? ?? FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_551_1_0 {
	meta:
		name = "csinh"
		size = 280
		refs = "0010 creal 0020 cimag 002c _dtest 0044 _Nan_C 0064 _fperrraise 00b0 sin 00b4 _Inf_C 00c8 cos 00e8 _Cosh 0100 _Sinh 0108 _Cbuild"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 E0 87 02 6D ?? ?? ?? ?? E1 1B 40 FD E0 0F 00 FD E0 17 40 FD ?? ?? ?? ?? E0 63 00 91 E0 0B 00 FD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 0A 00 71 C1 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 80 01 00 35 E1 0B 40 FD 2D 00 00 14 1F 04 00 71 A1 01 00 54 20 00 80 52 ?? ?? ?? ?? 68 3E 00 53 1F 05 00 71 ?? ?? ?? ?? 89 00 00 54 ?? ?? ?? ?? 01 40 60 1E 22 00 00 14 ?? ?? ?? ?? E0 0F 40 FD 1F 00 00 14 1F 08 00 71 A0 FE FF 54 7F 06 00 71 E1 01 00 54 60 00 00 35 E1 0B 40 FD F8 FF FF 17 E0 0B 40 FD ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 10 08 70 1E E0 0B 40 FD F0 13 00 FD ?? ?? ?? ?? F0 87 41 6D 00 08 70 1E 0D 00 00 14 E0 0B 40 FD ?? ?? ?? ?? 01 40 60 1E E0 0F 40 FD ?? ?? ?? ?? E0 13 00 FD E0 0B 40 FD ?? ?? ?? ?? 01 40 60 1E E0 0F 40 FD ?? ?? ?? ?? E1 13 40 FD ?? ?? ?? ?? FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_199_0_0 {
	meta:
		name = "_cputws"
		size = 288
		refs = "0020 __doserrno 0028 _errno 0034 _invalid_parameter_noinfo 0040 __dcrt_lowio_console_output_handle 0050 __dcrt_lowio_initialize_console_output 0088 __acrt_lock 0094 __imp_WriteConsoleW 0100 __acrt_unlock"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 13 00 00 91 B3 0F 00 F9 33 01 00 B5 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 33 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 1F 09 00 B1 61 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 1F 05 00 B1 E0 FE FF 54 6A 02 00 91 68 02 C0 79 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 13 CB 15 FD 41 93 B5 13 00 F9 20 01 80 52 ?? ?? ?? ?? 14 00 80 52 BF 13 00 B9 ?? ?? ?? ?? BF 02 00 F1 0D 03 00 54 E9 FF 8F D2 BF 02 09 EB E9 FF 8F 52 34 81 95 1A 04 00 80 D2 A3 53 00 91 82 02 00 11 61 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 60 00 00 35 14 00 80 12 09 00 00 14 A8 0F 40 F9 13 05 14 8B B3 0F 00 F9 A9 13 40 F9 35 01 14 CB B5 13 00 F9 B4 13 40 B9 E8 FF FF 17 20 01 80 52 ?? ?? ?? ?? 80 02 00 11 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_200_9_0 {
	meta:
		name = "_eof"
		size = 172
		refs = "0014 __doserrno 001c _errno 0030 _nhandle 0044 __pioinfo 0080 ??$?RV<lambda_8c7fe0501b21a3d651df18af1281dd99>@@AEAV<lambda_1e7e4d1273646f0421e1a651ace3f6b8>@@V<lambda_c9c67eda4188d8fc3f34e64078023a71>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_8c7fe0501b21a3d651df18af1281dd99>@@AEAV<lambda_1e7e4d1273646f0421e1a651ace3f6b8>@@$$QEAV<lambda_c9c67eda4188d8fc3f34e64078023a71>@@@Z 009c _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 B9 1F 08 00 31 E1 00 00 54 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 1E 00 00 14 E0 02 F8 37 ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 6B 62 02 00 54 09 7C 40 93 ?? ?? ?? ?? 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 09 19 09 8B 2A E1 40 39 4A 01 00 36 E8 53 00 91 E0 03 03 29 E0 43 00 91 E8 13 00 F9 E3 63 00 91 E2 83 00 91 E1 73 00 91 ?? ?? ?? ?? 08 00 00 14 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_389_10_0 {
	meta:
		name = "_close"
		size = 172
		refs = "0014 __doserrno 001c _errno 0030 _nhandle 0044 __pioinfo 0080 ??$?RV<lambda_751a882b2c74d4b022dec766aa51a29a>@@AEAV<lambda_628dfdc04ba53c8bfc02c9951375f3f5>@@V<lambda_f6c7be5f7998530c34de24c7437d6b54>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_751a882b2c74d4b022dec766aa51a29a>@@AEAV<lambda_628dfdc04ba53c8bfc02c9951375f3f5>@@$$QEAV<lambda_f6c7be5f7998530c34de24c7437d6b54>@@@Z 009c _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 17 00 B9 1F 08 00 31 E1 00 00 54 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 1E 00 00 14 E0 02 F8 37 ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 6B 62 02 00 54 09 7C 40 93 ?? ?? ?? ?? 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 09 19 09 8B 2A E1 40 39 4A 01 00 36 E8 53 00 91 E0 03 03 29 E0 43 00 91 E8 13 00 F9 E3 63 00 91 E2 83 00 91 E1 73 00 91 ?? ?? ?? ?? 08 00 00 14 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_202_0_0 {
	meta:
		name = "_chgsignf"
		size = 32
	strings:
		$1 = { FF 43 00 D1 08 00 26 1E E0 03 00 BD 08 01 01 52 E8 03 00 B9 00 01 27 1E FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_203_0_0 {
	meta:
		name = "nearbyintl"
		size = 44
		refs = "0010 _ldtest 0020 _ldrint"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? E0 0B 40 FD 1F 08 00 71 49 00 00 54 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_434_0_0 {
	meta:
		name = "nearbyint"
		size = 44
		refs = "0010 _dtest 0020 _drint"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? E0 0B 40 FD 1F 08 00 71 49 00 00 54 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_204_0_0 {
	meta:
		name = "fmaxl"
		size = 96
		refs = "0010 _ldtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0F 40 FD 0E 00 00 14 E0 63 00 91 ?? ?? ?? ?? E0 0B 40 FD 1F 08 00 71 20 01 00 54 F0 0F 40 FD 00 20 70 1E A3 00 00 54 00 20 70 1E 81 00 00 54 E8 2F 40 79 48 00 78 36 00 42 60 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_292_0_0 {
	meta:
		name = "fmax"
		size = 96
		refs = "0010 _dtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0F 40 FD 0E 00 00 14 E0 63 00 91 ?? ?? ?? ?? E0 0B 40 FD 1F 08 00 71 20 01 00 54 F0 0F 40 FD 00 20 70 1E A3 00 00 54 00 20 70 1E 81 00 00 54 E8 2F 40 79 48 00 78 36 00 42 60 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_205_0_0 {
	meta:
		name = "log1pl"
		size = 172
		refs = "0010 _ldtest 0050 _fperrraise 0054 _LNan_C 0070 _LInf_C 008c log"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 C0 00 00 54 1F 08 00 71 C1 00 00 54 E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 E8 2F 40 79 88 FF 7F 36 F1 0B 40 FD 10 10 7E 1E 20 22 70 1E C2 00 00 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F4 FF FF 17 20 22 70 1E E1 00 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 42 61 1E EC FF FF 17 10 10 6E 1E 20 2A 70 1E F0 0F 00 FD ?? ?? ?? ?? F2 43 41 6D 51 2A 70 1E 30 3A 70 1E 10 3A 72 1E 11 1A 71 1E 00 38 71 1E E1 FF FF 17 }
	condition:
		$1
}

rule file_366_0_0 {
	meta:
		name = "log1p"
		size = 172
		refs = "0010 _dtest 0050 _fperrraise 0054 _Nan_C 0070 _Inf_C 008c log"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 C0 00 00 54 1F 08 00 71 C1 00 00 54 E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 E8 2F 40 79 88 FF 7F 36 F1 0B 40 FD 10 10 7E 1E 20 22 70 1E C2 00 00 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? F4 FF FF 17 20 22 70 1E E1 00 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 42 61 1E EC FF FF 17 10 10 6E 1E 20 2A 70 1E F0 0F 00 FD ?? ?? ?? ?? F2 43 41 6D 51 2A 70 1E 30 3A 70 1E 10 3A 72 1E 11 1A 71 1E 00 38 71 1E E1 FF FF 17 }
	condition:
		$1
}

rule file_206_1_0 {
	meta:
		name = "??$common_fgets@D@@YAPEADQEADHV__crt_stdio_stream@@@Z"
		size = 224
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 0054 _lock_file 005c ?validate_stream_is_ansi_if_required@?$__acrt_stdio_char_traits@D@@SA_NQEAU_iobuf@@@Z 0080 _getc_nolock 00c4 _unlock_file"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 16 00 00 91 35 00 00 11 A2 0F 00 F9 16 01 00 B5 F5 00 00 34 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 24 00 00 14 55 FF FF 37 22 FF FF B4 95 FF FF 34 17 00 80 D2 40 00 00 91 ?? ?? ?? ?? A0 0F 40 F9 ?? ?? ?? ?? 00 03 00 34 D3 02 00 91 B3 13 00 F9 34 00 80 52 B4 13 00 B9 9F 02 15 6B 00 02 00 54 A0 0F 40 F9 ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 7F 02 16 EB 80 01 00 54 09 00 00 14 08 1C 00 13 68 02 00 39 73 06 00 91 B3 13 00 F9 1F 29 00 71 60 00 00 54 94 06 00 11 EF FF FF 17 7F 02 00 39 D7 02 00 91 A0 0F 40 F9 ?? ?? ?? ?? E0 02 00 91 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_206_3_0 {
	meta:
		name = "??$common_fgets@_W@@YAPEA_WQEA_WHV__crt_stdio_stream@@@Z"
		size = 216
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 0054 _lock_file 0074 _getwc_nolock 00bc _unlock_file"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 16 00 00 91 35 00 00 11 A2 0F 00 F9 16 01 00 B5 F5 00 00 34 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 22 00 00 14 55 FF FF 37 22 FF FF B4 95 FF FF 34 17 00 80 D2 40 00 00 91 ?? ?? ?? ?? D3 02 00 91 B3 13 00 F9 34 00 80 52 B4 13 00 B9 9F 02 15 6B 20 02 00 54 A0 0F 40 F9 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B 81 00 00 54 7F 02 16 EB 80 01 00 54 09 00 00 14 08 3C 00 53 68 02 00 79 73 0A 00 91 B3 13 00 F9 1F 29 00 71 60 00 00 54 94 06 00 11 EE FF FF 17 7F 02 00 79 D7 02 00 91 A0 0F 40 F9 ?? ?? ?? ?? E0 02 00 91 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_206_13_0 {
	meta:
		name = "?validate_stream_is_ansi_if_required@?$__acrt_stdio_char_traits@D@@SA_NQEAU_iobuf@@@Z"
		size = 172
		refs = "0014 _fileno 0018 __pioinfo 0024 __badioinfo 0088 _errno 0094 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 08 14 40 B9 BF 3B 03 D5 88 04 60 37 ?? ?? ?? ?? ?? ?? ?? ?? 08 08 00 11 1F 05 00 71 ?? ?? ?? ?? 09 01 00 54 09 7C 40 93 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 0B 19 09 8B 02 00 00 14 ?? ?? ?? ?? 68 E5 C0 39 C8 01 00 35 08 08 00 11 1F 05 00 71 09 01 00 54 09 7C 40 93 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 0B 19 09 8B 02 00 00 14 ?? ?? ?? ?? 68 F5 40 39 E8 00 00 36 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 02 00 00 14 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_207_0_0 {
	meta:
		name = "scalblnl"
		size = 92
		refs = "001c _ldtest 002c _ldscale 0048 _fperrraise"
		altNames = "scalbnl"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 0B 00 FD 13 00 00 11 F3 01 00 34 E0 43 00 91 ?? ?? ?? ?? 60 01 F8 36 61 02 00 11 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 A1 00 00 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? E0 0B 40 FD FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_291_0_0 {
	meta:
		name = "scalbln"
		size = 92
		refs = "001c _dtest 002c _dscale 0048 _fperrraise"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 0B 00 FD 13 00 00 11 F3 01 00 34 E0 43 00 91 ?? ?? ?? ?? 60 01 F8 36 61 02 00 11 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 A1 00 00 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? E0 0B 40 FD FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_668_0_0 {
	meta:
		name = "scalbn"
		size = 92
		refs = "001c _dtest 002c _dscale 0048 _fperrraise"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 0B 00 FD 13 00 00 11 F3 01 00 34 E0 43 00 91 ?? ?? ?? ?? 60 01 F8 36 61 02 00 11 E0 43 00 91 ?? ?? ?? ?? A0 00 00 34 1F 04 00 71 A1 00 00 54 00 01 80 52 02 00 00 14 00 02 80 52 ?? ?? ?? ?? E0 0B 40 FD FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_208_0_0 {
	meta:
		name = "_malloc_base"
		size = 132
		refs = "0024 __acrt_heap 0028 __imp_HeapAlloc 0030 _query_new_mode 003c _callnewh 0064 _errno"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 1F 80 00 B1 88 02 00 54 1F 00 00 F1 28 00 80 D2 13 01 80 9A ?? ?? ?? ?? ?? ?? ?? ?? 06 00 00 14 ?? ?? ?? ?? 80 01 00 34 60 02 00 91 ?? ?? ?? ?? 20 01 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 01 00 80 52 62 02 00 91 20 01 3F D6 A0 FE FF B4 05 00 00 14 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_209_0_0 {
	meta:
		name = "_fdrint"
		size = 244
		refs = "000c fegetround 0034 _fd_int"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 13 00 BD ?? ?? ?? ?? E0 03 00 34 1F 00 04 71 A0 02 00 54 1F 00 08 71 20 01 00 54 1F 00 0C 71 81 00 00 54 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? E0 13 40 BD FD 7B C2 A8 C0 03 5F D6 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 40 FF FF 34 E8 27 40 79 08 FF 7F 37 F0 13 40 BD 12 10 2E 1E 00 2A 32 1E F5 FF FF 17 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 00 FE FF 34 E8 27 40 79 C8 FD 7F 36 12 10 2E 1E 18 00 00 14 21 00 80 52 E0 43 00 91 ?? ?? ?? ?? 01 00 80 52 A0 01 00 35 E0 43 00 91 ?? ?? ?? ?? 80 FC FF 34 01 00 80 12 E0 43 00 91 ?? ?? ?? ?? 00 FC FF 34 12 10 20 1E 08 00 00 14 F1 13 40 BD 20 2A 32 1E DC FF FF 17 E0 43 00 91 ?? ?? ?? ?? 00 FB FF 34 12 10 2E 1E E8 27 40 79 08 FF 7F 36 F0 13 40 BD 00 3A 32 1E D3 FF FF 17 }
	condition:
		$1
}

rule file_209_1_0 {
	meta:
		name = "rintf"
		size = 80
		refs = "0010 _fdtest 0020 _fdrint 003c _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 13 00 BD ?? ?? ?? ?? E0 13 40 BD 1F 08 00 71 69 01 00 54 ?? ?? ?? ?? F0 13 40 BD 11 40 20 1E F1 17 00 BD 20 22 30 1E 80 00 00 54 00 04 80 52 ?? ?? ?? ?? F1 17 40 BD 20 42 20 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_210_6_0 {
	meta:
		name = "??$common_spawnv@D@@YA_JHQEBDQEBQEBD1@Z"
		size = 708
		refs = "0030 _errno 003c _invalid_parameter_noinfo 0084 strrchr 00dc _calloc_base 00ec _free_base 00f4 ?dot_slash@?CB@???$common_spawnv@D@@YA_JHQEBDQEBQEBD1@Z@4QBDB 0104 strcpy_s 0118 strcat_s 015c _access_s 0174 ??$execute_command@D@@YA_JHQEBDQEBQEBD1@Z 01d8 ?extensions@?CP@???$common_spawnv@D@@YA_JHQEBDQEBQEBD1@Z@4QAY04$$CBDA 0278 _invoke_watson"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 23 00 F9 FD 7B BF A9 FD 03 00 91 1A 00 00 11 33 00 00 91 57 00 00 91 7B 00 00 91 B3 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 FD 7B C1 A8 FB 23 40 F9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 68 02 C0 39 68 FE FF 34 57 FE FF B4 E8 02 40 F9 08 FE FF B4 08 01 C0 39 C8 FD FF 34 81 0B 80 52 60 02 00 91 ?? ?? ?? ?? E1 05 80 52 15 00 00 91 60 02 00 91 ?? ?? ?? ?? 74 02 00 91 A0 04 00 B5 F5 04 00 B5 41 07 80 52 60 02 00 91 ?? ?? ?? ?? 15 00 00 91 55 04 00 B5 68 02 C0 39 6A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 55 01 13 CB A0 0E 00 91 21 00 80 D2 ?? ?? ?? ?? 14 00 00 91 94 00 00 B5 00 00 80 D2 ?? ?? ?? ?? D4 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? A1 0E 00 91 80 02 00 91 ?? ?? ?? ?? A0 0B 00 35 62 02 00 91 A1 0E 00 91 80 02 00 91 ?? ?? ?? ?? 40 0A 00 35 00 00 80 D2 95 0A 00 91 ?? ?? ?? ?? 04 00 00 14 BF 02 00 F1 0A 10 55 FA 15 80 95 9A 7F 02 14 EB C1 05 80 52 A0 02 00 91 F3 03 94 9A ?? ?? ?? ?? 80 01 00 B4 01 00 80 52 80 02 00 91 ?? ?? ?? ?? 20 06 00 35 63 03 00 91 E2 02 00 91 81 02 00 91 40 03 00 11 ?? ?? ?? ?? 14 00 00 91 36 00 00 14 88 02 C0 39 8A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 14 CB 16 15 00 91 C0 02 00 91 21 00 80 D2 ?? ?? ?? ?? 15 00 00 91 75 00 00 B5 14 00 80 92 25 00 00 14 82 02 00 91 C1 02 00 91 A0 02 00 91 ?? ?? ?? ?? 00 07 00 35 B8 02 16 8B ?? ?? ?? ?? ?? ?? ?? ?? 19 00 40 B9 ?? ?? ?? ?? D4 02 00 91 82 02 00 91 A1 00 80 D2 00 17 00 D1 ?? ?? ?? ?? E0 04 00 35 01 00 80 52 A0 02 00 91 ?? ?? ?? ?? 20 01 00 34 94 16 00 91 C8 52 00 91 9F 02 08 EB 81 FE FF 54 A0 02 00 91 ?? ?? ?? ?? 14 00 80 92 0B 00 00 14 ?? ?? ?? ?? 63 03 00 91 19 00 00 B9 E2 02 00 91 40 03 00 11 A1 02 00 91 ?? ?? ?? ?? 14 00 00 91 A0 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 79 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_7_0 {
	meta:
		name = "??$common_spawnv@_W@@YA_JHQEB_WQEBQEB_W1@Z"
		size = 712
		refs = "0030 _errno 003c _invalid_parameter_noinfo 0084 wcsrchr 00e0 _calloc_base 00f0 _free_base 00f8 ?dot_slash@?CB@???$common_spawnv@_W@@YA_JHQEB_WQEBQEB_W1@Z@4QB_WB 0108 wcscpy_s 011c wcscat_s 0160 _waccess_s 0178 ??$execute_command@_W@@YA_JHQEB_WQEBQEB_W1@Z 01dc ?extensions@?CP@???$common_spawnv@_W@@YA_JHQEB_WQEBQEB_W1@Z@4QAY04$$CB_WA 027c _invoke_watson"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 23 00 F9 FD 7B BF A9 FD 03 00 91 1A 00 00 11 33 00 00 91 57 00 00 91 7B 00 00 91 B3 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 FD 7B C1 A8 FB 23 40 F9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 68 02 40 79 68 FE FF 34 57 FE FF B4 E8 02 40 F9 08 FE FF B4 08 01 40 79 C8 FD FF 34 81 0B 80 52 60 02 00 91 ?? ?? ?? ?? E1 05 80 52 15 00 00 91 60 02 00 91 ?? ?? ?? ?? 74 02 00 91 C0 04 00 B5 15 05 00 B5 41 07 80 52 60 02 00 91 ?? ?? ?? ?? 15 00 00 91 75 04 00 B5 68 02 C0 79 6A 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 13 CB 15 FD 41 93 A0 0E 00 91 41 00 80 D2 ?? ?? ?? ?? 14 00 00 91 94 00 00 B5 00 00 80 D2 ?? ?? ?? ?? D3 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? A1 0E 00 91 80 02 00 91 ?? ?? ?? ?? A0 0B 00 35 62 02 00 91 A1 0E 00 91 80 02 00 91 ?? ?? ?? ?? 40 0A 00 35 00 00 80 D2 95 12 00 91 ?? ?? ?? ?? 04 00 00 14 BF 02 00 F1 0A 10 55 FA 15 80 95 9A 7F 02 14 EB C1 05 80 52 A0 02 00 91 F3 03 94 9A ?? ?? ?? ?? 80 01 00 B4 01 00 80 52 80 02 00 91 ?? ?? ?? ?? 20 06 00 35 63 03 00 91 E2 02 00 91 81 02 00 91 40 03 00 11 ?? ?? ?? ?? 14 00 00 91 36 00 00 14 88 02 C0 79 8A 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 14 CB 16 FD 41 93 C0 16 00 91 41 00 80 D2 ?? ?? ?? ?? 15 00 00 91 75 00 00 B5 14 00 80 92 25 00 00 14 82 02 00 91 C1 16 00 91 A0 02 00 91 ?? ?? ?? ?? 00 07 00 35 D8 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 19 00 40 B9 ?? ?? ?? ?? D4 02 00 91 A0 06 18 8B 82 02 00 91 A1 00 80 D2 ?? ?? ?? ?? E0 04 00 35 01 00 80 52 A0 02 00 91 ?? ?? ?? ?? 20 01 00 34 94 2A 00 91 C8 A2 00 91 9F 02 08 EB 81 FE FF 54 A0 02 00 91 ?? ?? ?? ?? 14 00 80 92 0B 00 00 14 ?? ?? ?? ?? 63 03 00 91 19 00 00 B9 E2 02 00 91 40 03 00 11 A1 02 00 91 ?? ?? ?? ?? 14 00 00 91 A0 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 78 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_8_0 {
	meta:
		name = "??$create_process@PEADPEAD$$T$$THAEAKPEAD$$TPEAU_STARTUPINFOA@@PEAU_PROCESS_INFORMATION@@@?$__crt_char_traits@D@@SAH$$QEAPEAD0$$QEA$$T1$$QEAHAEAK01$$QEAPEAU_STARTUPINFOA@@$$QEAPEAU_PROCESS_INFORMATION@@@Z"
		size = 96
		refs = "0044 __imp_CreateProcessA"
		altNames = "??$create_process@AEBQEBDPEAD$$T$$THH$$T$$TPEAU_STARTUPINFOA@@PEAU_PROCESS_INFORMATION@@@?$__crt_char_traits@D@@SAHAEBQEBD$$QEAPEAD$$QEA$$T2$$QEAH322$$QEAPEAU_STARTUPINFOA@@$$QEAPEAU_PROCESS_INFORMATION@@@Z"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 FF 43 00 D1 E7 00 40 F9 C6 00 40 F9 A5 00 40 B9 84 00 40 B9 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 E8 17 40 F9 E9 13 40 F9 08 01 40 F9 E8 07 00 F9 28 01 40 F9 E8 03 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 FF 43 00 91 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_532_12_0 {
	meta:
		name = "??$create_process@AEBQEB_WPEA_W$$T$$THH$$T$$TPEAU_STARTUPINFOW@@PEAU_PROCESS_INFORMATION@@@?$__crt_char_traits@_W@@SAHAEBQEB_W$$QEAPEA_W$$QEA$$T2$$QEAH322$$QEAPEAU_STARTUPINFOW@@$$QEAPEAU_PROCESS_INFORMATION@@@Z"
		size = 96
		refs = "0044 __imp_CreateProcessW"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 FF 43 00 D1 E7 00 40 F9 C6 00 40 F9 A5 00 40 B9 84 00 40 B9 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 E8 17 40 F9 E9 13 40 F9 08 01 40 F9 E8 07 00 F9 28 01 40 F9 E8 03 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 FF 43 00 91 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_210_9_0 {
	meta:
		name = "??$create_process@PEA_WPEA_W$$T$$THAEAKPEA_W$$TPEAU_STARTUPINFOW@@PEAU_PROCESS_INFORMATION@@@?$__crt_char_traits@_W@@SAH$$QEAPEA_W0$$QEA$$T1$$QEAHAEAK01$$QEAPEAU_STARTUPINFOW@@$$QEAPEAU_PROCESS_INFORMATION@@@Z"
		size = 96
		refs = "0044 __imp_CreateProcessW"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 FF 43 00 D1 E7 00 40 F9 C6 00 40 F9 A5 00 40 B9 84 00 40 B9 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 E8 17 40 F9 E9 13 40 F9 08 01 40 F9 E8 07 00 F9 28 01 40 F9 E8 03 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 FF 43 00 91 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_210_10_0 {
	meta:
		name = "??$execute_command@D@@YA_JHQEBDQEBQEBD1@Z"
		size = 752
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 004c __doserrno 0068 __acrt_pack_narrow_command_line_and_environment 0078 _free_base 00dc ??$?RV<lambda_a22f0c497e5168315e06dae667770027>@@AEAV<lambda_a094494068278ba5130ab06e1292f60a>@@V<lambda_24dc10c13f43218c635520766e23e324>@@@?$__crt_seh_guarded_call@_N@@QEAA_N$$QEAV<lambda_a22f0c497e5168315e06dae667770027>@@AEAV<lambda_a094494068278ba5130ab06e1292f60a>@@$$QEAV<lambda_24dc10c13f43218c635520766e23e324>@@@Z 0170 __imp_CreateProcessA 018c __imp_GetLastError 019c __acrt_errno_map_os_error 01a4 __imp_CloseHandle 01e8 __imp_WaitForSingleObject 0200 __imp_GetExitCodeProcess 02ec _exit"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B AF A9 FD 03 00 91 FF 43 00 D1 14 00 00 11 35 00 00 91 40 00 00 91 61 00 00 91 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 A6 00 00 14 40 FF FF B4 9F 12 00 71 89 00 00 54 ?? ?? ?? ?? 1F 00 00 B9 F5 FF FF 17 E3 A3 00 91 FF 23 00 F9 E2 03 01 91 FF 17 00 F9 ?? ?? ?? ?? 1F 04 00 31 E1 00 00 54 E0 17 40 F9 ?? ?? ?? ?? E0 23 40 F9 FF 17 00 F9 ?? ?? ?? ?? EC FF FF 17 E8 C3 00 91 FF 1B 00 F9 9F 12 00 71 E8 37 00 F9 E8 07 9F 1A E8 83 00 39 E9 E3 01 91 E8 A3 01 91 E9 3B 00 F9 E8 43 00 F9 E9 C3 01 91 E8 83 00 91 E9 A3 08 A9 E8 00 80 52 E9 00 80 52 E9 23 09 29 E3 23 01 91 E2 03 02 91 E1 33 01 91 E0 E3 00 91 ?? ?? ?? ?? A0 00 00 35 E0 1B 40 F9 ?? ?? ?? ?? FF 1B 00 F9 E1 FF FF 17 9F 12 00 71 08 01 80 52 13 01 9F 1A ?? ?? ?? ?? 1F 00 00 B9 E8 C3 02 91 E6 17 40 F9 1F 7D 00 A9 E9 63 02 91 E1 23 40 F9 1F 7D 01 A9 07 00 80 D2 1F 7D 02 A9 65 02 00 11 1F 7D 03 A9 24 00 80 52 1F 7D 04 A9 03 00 80 D2 1F 7D 05 A9 02 00 80 D2 1F 31 00 F9 08 0D 80 52 E8 B3 00 B9 E8 F3 40 79 A0 02 00 91 E9 07 00 F9 E8 E7 01 79 E8 1B 40 F9 E8 7F 00 F9 E8 C3 02 91 E8 03 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 F3 A3 49 A9 F3 A3 05 A9 A0 02 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E0 33 40 F9 ?? ?? ?? ?? 1F 04 00 B1 80 00 00 54 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 2F 40 F9 1F 04 00 B1 80 00 00 54 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 13 00 80 92 36 00 00 14 9F 0A 00 71 40 08 00 54 54 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 01 00 80 12 60 02 00 91 20 01 3F D6 ?? ?? ?? ?? E0 4F 40 F9 ?? ?? ?? ?? 09 FD DF C8 E1 43 01 91 20 01 3F D6 E0 33 40 F9 ?? ?? ?? ?? F3 53 80 B9 1F 04 00 B1 80 00 00 54 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 2F 40 F9 1F 04 00 B1 80 03 00 54 ?? ?? ?? ?? 18 00 00 14 9F 12 00 71 21 02 00 54 1F 05 00 B1 ?? ?? ?? ?? C0 00 00 54 00 01 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 F3 2F 40 F9 7F 06 00 B1 A0 00 00 54 ?? ?? ?? ?? 09 FD DF C8 60 02 00 91 20 01 3F D6 13 00 80 D2 08 00 00 14 1F 05 00 B1 C0 00 00 54 ?? ?? ?? ?? 00 01 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 1B 40 F9 ?? ?? ?? ?? E0 17 40 F9 FF 1B 00 F9 ?? ?? ?? ?? E0 23 40 F9 FF 17 00 F9 ?? ?? ?? ?? 60 02 00 91 FF 43 00 91 FD 7B D1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 00 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_11_0 {
	meta:
		name = "??$execute_command@_W@@YA_JHQEB_WQEBQEB_W1@Z"
		size = 756
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 004c __doserrno 0068 __acrt_pack_wide_command_line_and_environment 0078 _free_base 00dc ??$?RV<lambda_a22f0c497e5168315e06dae667770027>@@AEAV<lambda_a094494068278ba5130ab06e1292f60a>@@V<lambda_24dc10c13f43218c635520766e23e324>@@@?$__crt_seh_guarded_call@_N@@QEAA_N$$QEAV<lambda_a22f0c497e5168315e06dae667770027>@@AEAV<lambda_a094494068278ba5130ab06e1292f60a>@@$$QEAV<lambda_24dc10c13f43218c635520766e23e324>@@@Z 0174 __imp_CreateProcessW 0190 __imp_GetLastError 01a0 __acrt_errno_map_os_error 01a8 __imp_CloseHandle 01ec __imp_WaitForSingleObject 0204 __imp_GetExitCodeProcess 02f0 _exit"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B AF A9 FD 03 00 91 FF 43 00 D1 14 00 00 11 35 00 00 91 40 00 00 91 61 00 00 91 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 A7 00 00 14 40 FF FF B4 9F 12 00 71 89 00 00 54 ?? ?? ?? ?? 1F 00 00 B9 F5 FF FF 17 E3 A3 00 91 FF 23 00 F9 E2 03 01 91 FF 17 00 F9 ?? ?? ?? ?? 1F 04 00 31 E1 00 00 54 E0 17 40 F9 ?? ?? ?? ?? E0 23 40 F9 FF 17 00 F9 ?? ?? ?? ?? EC FF FF 17 E8 C3 00 91 FF 1B 00 F9 9F 12 00 71 E8 37 00 F9 E8 07 9F 1A E8 83 00 39 E9 E3 01 91 E8 A3 01 91 E9 3B 00 F9 E8 43 00 F9 E9 C3 01 91 E8 83 00 91 E9 A3 08 A9 E8 00 80 52 E9 00 80 52 E9 23 09 29 E3 23 01 91 E2 03 02 91 E1 33 01 91 E0 E3 00 91 ?? ?? ?? ?? A0 00 00 35 E0 1B 40 F9 ?? ?? ?? ?? FF 1B 00 F9 E1 FF FF 17 9F 12 00 71 08 01 80 52 08 01 9F 1A 13 01 16 32 ?? ?? ?? ?? 1F 00 00 B9 E8 C3 02 91 E6 17 40 F9 1F 7D 00 A9 E9 63 02 91 E1 23 40 F9 1F 7D 01 A9 07 00 80 D2 1F 7D 02 A9 65 02 00 11 1F 7D 03 A9 24 00 80 52 1F 7D 04 A9 03 00 80 D2 1F 7D 05 A9 02 00 80 D2 1F 31 00 F9 08 0D 80 52 E8 B3 00 B9 E8 F3 40 79 A0 02 00 91 E9 07 00 F9 E8 E7 01 79 E8 1B 40 F9 E8 7F 00 F9 E8 C3 02 91 E8 03 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 F3 A3 49 A9 F3 A3 05 A9 A0 02 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E0 33 40 F9 ?? ?? ?? ?? 1F 04 00 B1 80 00 00 54 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 2F 40 F9 1F 04 00 B1 80 00 00 54 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 13 00 80 92 36 00 00 14 9F 0A 00 71 40 08 00 54 54 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 01 00 80 12 60 02 00 91 20 01 3F D6 ?? ?? ?? ?? E0 4F 40 F9 ?? ?? ?? ?? 09 FD DF C8 E1 43 01 91 20 01 3F D6 E0 33 40 F9 ?? ?? ?? ?? F3 53 80 B9 1F 04 00 B1 80 00 00 54 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 2F 40 F9 1F 04 00 B1 80 03 00 54 ?? ?? ?? ?? 18 00 00 14 9F 12 00 71 21 02 00 54 1F 05 00 B1 ?? ?? ?? ?? C0 00 00 54 00 01 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 F3 2F 40 F9 7F 06 00 B1 A0 00 00 54 ?? ?? ?? ?? 09 FD DF C8 60 02 00 91 20 01 3F D6 13 00 80 D2 08 00 00 14 1F 05 00 B1 C0 00 00 54 ?? ?? ?? ?? 00 01 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 1B 40 F9 ?? ?? ?? ?? E0 17 40 F9 FF 1B 00 F9 ?? ?? ?? ?? E0 23 40 F9 FF 17 00 F9 ?? ?? ?? ?? 60 02 00 91 FF 43 00 91 FD 7B D1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 00 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_12_0 {
	meta:
		name = "??$pack_command_line_and_environment@AEBQEBQEBDAEBQEBQEBDPEAPEADPEAPEAD@?$__crt_char_traits@D@@SAHAEBQEBQEBD0$$QEAPEAPEAD1@Z"
		size = 20
		refs = "0010 __acrt_pack_narrow_command_line_and_environment"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_13_0 {
	meta:
		name = "??$pack_command_line_and_environment@AEBQEBQEB_WAEBQEBQEB_WPEAPEA_WPEAPEA_W@?$__crt_char_traits@_W@@SAHAEBQEBQEB_W0$$QEAPEAPEA_W1@Z"
		size = 20
		refs = "0010 __acrt_pack_wide_command_line_and_environment"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_20_4 {
	meta:
		name = "??$tcsncat_s@AEAPEADAEB_KAEBQEBD_K@?$__crt_char_traits@D@@SAHAEAPEADAEB_KAEBQEBD$$QEA_K@Z"
		size = 20
		refs = "0010 strncat_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_21_4 {
	meta:
		name = "??$tcsncat_s@AEAPEA_WAEB_KAEBQEB_W_K@?$__crt_char_traits@_W@@SAHAEAPEA_WAEB_KAEBQEB_W$$QEA_K@Z"
		size = 20
		refs = "0010 wcsncat_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_35_0 {
	meta:
		name = "??$tcsncat_s@AEBQEADAEB_KAEAPEBD_K@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEAPEBD$$QEA_K@Z"
		size = 20
		refs = "0010 strncat_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_36_0 {
	meta:
		name = "??$tcsncat_s@AEBQEADAEB_KAEBQEBDAEB_K@?$__crt_char_traits@D@@SAHAEBQEADAEB_KAEBQEBD1@Z"
		size = 20
		refs = "0010 strncat_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_37_0 {
	meta:
		name = "??$tcsncat_s@AEBQEADAEB_KPEBD_K@?$__crt_char_traits@D@@SAHAEBQEADAEB_K$$QEAPEBD$$QEA_K@Z"
		size = 20
		refs = "0010 strncat_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_38_2 {
	meta:
		name = "??$tcsncat_s@AEBQEA_WAEB_KAEAPEB_W_K@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEAPEB_W$$QEA_K@Z"
		size = 20
		refs = "0010 wcsncat_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_39_3 {
	meta:
		name = "??$tcsncat_s@AEBQEA_WAEB_KAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_KAEBQEB_W1@Z"
		size = 20
		refs = "0010 wcsncat_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_40_0 {
	meta:
		name = "??$tcsncat_s@AEBQEA_WAEB_KPEB_W_K@?$__crt_char_traits@_W@@SAHAEBQEA_WAEB_K$$QEAPEB_W$$QEA_K@Z"
		size = 20
		refs = "0010 wcsncat_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_21_2 {
	meta:
		name = "??$tcsncpy_s@AEAPEAD_KAEAPEADAEB_K@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_K0AEB_K@Z"
		size = 20
		refs = "0010 strncpy_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_12_2 {
	meta:
		name = "??$tcsncpy_s@AEAPEAD_KAEAPEBDAEB_K@?$__crt_char_traits@D@@SAHAEAPEAD$$QEA_KAEAPEBDAEB_K@Z"
		size = 20
		refs = "0010 strncpy_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_22_2 {
	meta:
		name = "??$tcsncpy_s@AEAPEA_W_KAEAPEA_WAEB_K@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_K0AEB_K@Z"
		size = 20
		refs = "0010 wcsncpy_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_14_3 {
	meta:
		name = "??$tcsncpy_s@AEAPEA_W_KAEAPEB_WAEB_K@?$__crt_char_traits@_W@@SAHAEAPEA_W$$QEA_KAEAPEB_WAEB_K@Z"
		size = 20
		refs = "0010 wcsncpy_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_23_4 {
	meta:
		name = "??$tcsncpy_s@PEADAEB_KAEBQEBDAEB_K@?$__crt_char_traits@D@@SAH$$QEAPEADAEB_KAEBQEBD1@Z"
		size = 20
		refs = "0010 strncpy_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_24_4 {
	meta:
		name = "??$tcsncpy_s@PEAD_KAEBQEBDAEB_K@?$__crt_char_traits@D@@SAH$$QEAPEAD$$QEA_KAEBQEBDAEB_K@Z"
		size = 20
		refs = "0010 strncpy_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_25_0 {
	meta:
		name = "??$tcsncpy_s@PEA_WAEB_KAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAH$$QEAPEA_WAEB_KAEBQEB_W1@Z"
		size = 20
		refs = "0010 wcsncpy_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_531_26_3 {
	meta:
		name = "??$tcsncpy_s@PEA_W_KAEBQEB_WAEB_K@?$__crt_char_traits@_W@@SAH$$QEAPEA_W$$QEA_KAEBQEB_WAEB_K@Z"
		size = 20
		refs = "0010 wcsncpy_s"
	strings:
		$1 = { 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_54_0 {
	meta:
		name = "?accumulate_inheritable_handles@@YA_NQEAPEAEQEA_K_N@Z"
		size = 76
		refs = "0040 ??$?RV<lambda_a22f0c497e5168315e06dae667770027>@@AEAV<lambda_a094494068278ba5130ab06e1292f60a>@@V<lambda_24dc10c13f43218c635520766e23e324>@@@?$__crt_seh_guarded_call@_N@@QEAA_N$$QEAV<lambda_a22f0c497e5168315e06dae667770027>@@AEAV<lambda_a094494068278ba5130ab06e1292f60a>@@$$QEAV<lambda_24dc10c13f43218c635520766e23e324>@@@Z"
	strings:
		$1 = { FD 7B BB A9 FD 03 00 91 E3 53 00 91 E0 07 02 A9 E1 63 00 91 E2 43 00 39 E2 C3 00 91 E0 47 00 91 E8 83 00 91 E8 1B 00 F9 E9 A3 00 91 E8 43 00 91 E9 A3 03 A9 E8 00 80 52 E9 00 80 52 E9 A3 02 29 ?? ?? ?? ?? FD 7B C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_210_57_0 {
	meta:
		name = "?detach@?$__crt_unique_handle_t@U__crt_handle_traits@@@@QEAAPEAXXZ"
		size = 20
	strings:
		$1 = { 08 00 40 F9 09 00 80 92 09 00 00 F9 00 01 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_210_77_0 {
	meta:
		name = "_execv"
		size = 20
		refs = "0010 ??$common_spawnv@D@@YA_JHQEBDQEBQEBD1@Z"
	strings:
		$1 = { 22 00 00 91 01 00 00 91 40 00 80 52 03 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_48_0 {
	meta:
		name = "_execvp"
		size = 20
		refs = "0010 ??$common_spawnvp@D@@YA_JHQEBDQEBQEBD1@Z"
	strings:
		$1 = { 22 00 00 91 01 00 00 91 40 00 80 52 03 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_82_0 {
	meta:
		name = "_wexecv"
		size = 20
		refs = "0010 ??$common_spawnv@_W@@YA_JHQEB_WQEBQEB_W1@Z"
	strings:
		$1 = { 22 00 00 91 01 00 00 91 40 00 80 52 03 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_54_0 {
	meta:
		name = "_wexecvp"
		size = 20
		refs = "0010 ??$common_spawnvp@_W@@YA_JHQEB_WQEBQEB_W1@Z"
	strings:
		$1 = { 22 00 00 91 01 00 00 91 40 00 80 52 03 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_78_0 {
	meta:
		name = "_execve"
		size = 20
		refs = "0010 ??$common_spawnv@D@@YA_JHQEBDQEBQEBD1@Z"
	strings:
		$1 = { 43 00 00 91 22 00 00 91 01 00 00 91 40 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_49_0 {
	meta:
		name = "_execvpe"
		size = 20
		refs = "0010 ??$common_spawnvp@D@@YA_JHQEBDQEBQEBD1@Z"
	strings:
		$1 = { 43 00 00 91 22 00 00 91 01 00 00 91 40 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_210_83_0 {
	meta:
		name = "_wexecve"
		size = 20
		refs = "0010 ??$common_spawnv@_W@@YA_JHQEB_WQEBQEB_W1@Z"
	strings:
		$1 = { 43 00 00 91 22 00 00 91 01 00 00 91 40 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_354_55_0 {
	meta:
		name = "_wexecvpe"
		size = 20
		refs = "0010 ??$common_spawnvp@_W@@YA_JHQEB_WQEBQEB_W1@Z"
	strings:
		$1 = { 43 00 00 91 22 00 00 91 01 00 00 91 40 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_211_0_0 {
	meta:
		name = "fdiml"
		size = 92
		refs = "0010 _ldtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0B 40 FD 0D 00 00 14 E0 63 00 91 ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0F 40 FD 07 00 00 14 F0 47 41 6D 00 22 71 1E 68 00 00 54 E0 03 67 9E 02 00 00 14 00 3A 71 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_414_0_0 {
	meta:
		name = "fdim"
		size = 92
		refs = "0010 _dtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0B 40 FD 0D 00 00 14 E0 63 00 91 ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0F 40 FD 07 00 00 14 F0 47 41 6D 00 22 71 1E 68 00 00 54 E0 03 67 9E 02 00 00 14 00 3A 71 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_213_0_0 {
	meta:
		name = "_mbccpy"
		size = 20
		refs = "0010 _mbccpy_s_l"
	strings:
		$1 = { 23 00 00 91 41 00 80 D2 04 00 80 D2 02 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_213_1_0 {
	meta:
		name = "_mbccpy_l"
		size = 20
		refs = "0010 _mbccpy_s_l"
	strings:
		$1 = { 44 00 00 91 23 00 00 91 02 00 80 D2 41 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_214_0_0 {
	meta:
		name = "_logb"
		size = 180
		refs = "0020 ??_C@_05JGDBENOH@_logb?$AA@ 0044 _handle_error 0078 _handle_nan"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 0B 00 66 9E E0 0B 00 FD 68 F9 74 D3 0A FD 0F D1 69 F9 40 92 89 01 00 B5 ?? ?? ?? ?? E1 03 67 9E ?? ?? ?? ?? 26 00 80 52 45 04 80 52 84 00 80 52 43 00 80 52 02 FE FF D2 A1 04 80 52 ?? ?? ?? ?? 19 00 00 14 5F F9 0F B1 AB 00 00 54 5F FD 0F F1 AC 00 00 54 40 01 62 9E 13 00 00 14 5F FD 0F F1 CD 00 00 54 68 CD 40 92 E8 01 00 B4 60 01 00 91 ?? ?? ?? ?? 0C 00 00 14 68 CD 40 92 0A 02 E0 D2 1F 01 0A EB A9 7F 80 92 C2 00 00 54 08 F9 7F D3 0C 02 E0 D2 1F 01 0C EB 29 05 00 D1 83 FF FF 54 20 01 62 9E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_216_5_0 {
	meta:
		name = "_ismbchira_l"
		size = 100
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 08 05 40 B9 1F 91 0E 71 C1 00 00 54 E8 53 90 52 68 02 08 4B 1F 49 01 71 20 00 80 52 49 00 00 54 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_216_7_0 {
	meta:
		name = "_ismbckata_l"
		size = 112
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 08 05 40 B9 1F 91 0E 71 21 01 00 54 08 68 90 52 68 02 08 4B 1F 59 01 71 A8 00 00 54 E8 6F 90 52 7F 02 08 6B 20 00 80 52 41 00 00 54 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_216_9_0 {
	meta:
		name = "_ismbcsymbol_l"
		size = 112
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 08 05 40 B9 1F 91 0E 71 21 01 00 54 28 28 90 52 68 02 08 4B 1F AD 01 71 A8 00 00 54 E8 2F 90 52 7F 02 08 6B 20 00 80 52 41 00 00 54 00 00 80 52 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_217_6_0 {
	meta:
		name = "_rmdir"
		size = 88
		refs = "0014 _wrmdir 0024 __acrt_copy_path_to_wide_string 0044 _free_base"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 80 00 00 B5 00 00 80 D2 ?? ?? ?? ?? 0D 00 00 14 E1 43 00 91 FF 0B 00 F9 ?? ?? ?? ?? 60 00 00 35 13 00 80 12 04 00 00 14 E0 0B 40 F9 ?? ?? ?? ?? 13 00 00 11 E0 0B 40 F9 ?? ?? ?? ?? 60 02 00 11 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_270_6_0 {
	meta:
		name = "_mkdir"
		size = 88
		refs = "0014 _wmkdir 0024 __acrt_copy_path_to_wide_string 0044 _free_base"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 80 00 00 B5 00 00 80 D2 ?? ?? ?? ?? 0D 00 00 14 E1 43 00 91 FF 0B 00 F9 ?? ?? ?? ?? 60 00 00 35 13 00 80 12 04 00 00 14 E0 0B 40 F9 ?? ?? ?? ?? 13 00 00 11 E0 0B 40 F9 ?? ?? ?? ?? 60 02 00 11 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_428_7_0 {
	meta:
		name = "remove"
		size = 88
		refs = "0014 _wremove 0024 __acrt_copy_path_to_wide_string 0044 _free_base"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 80 00 00 B5 00 00 80 D2 ?? ?? ?? ?? 0D 00 00 14 E1 43 00 91 FF 0B 00 F9 ?? ?? ?? ?? 60 00 00 35 13 00 80 12 04 00 00 14 E0 0B 40 F9 ?? ?? ?? ?? 13 00 00 11 E0 0B 40 F9 ?? ?? ?? ?? 60 02 00 11 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_318_9_0 {
	meta:
		name = "uninitialize_allocated_memory"
		size = 108
		refs = "000c __acrt_current_multibyte_data 0018 ??$uninitialize@V<lambda_af42a3ee9806e9a7305d451646e05244>@@@?$dual_state_global@PEAU__crt_multibyte_data@@@__crt_state_management@@QEAAX$$QEAV<lambda_af42a3ee9806e9a7305d451646e05244>@@@Z 001c __acrt_stdout_buffer 0024 _free_base 002c __acrt_stderr_buffer 003c __argv 004c __wargv"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? E1 43 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 20 00 80 52 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_218_0_0 {
	meta:
		name = "_frnd"
		size = 424
	strings:
		$1 = { FF 43 00 D1 E0 03 00 FD EA 07 40 B9 48 79 14 53 09 FD 0F 51 3F 51 00 71 CA 02 00 54 A9 00 F8 36 48 01 01 12 FF 23 00 29 F1 03 40 FD 21 00 00 14 08 FE BF 12 0B 29 C9 1A E8 03 40 B9 FF 03 00 B9 49 01 0B 0A 28 01 08 2A C8 00 00 35 48 01 01 12 11 40 60 1E E8 07 00 B9 E0 03 40 FD 15 00 00 14 E8 03 2B 2A 08 01 0A 0A E8 07 00 B9 0F 00 00 14 3F CD 00 71 6D 00 00 54 FF 03 00 B9 F4 FF FF 17 28 51 00 51 E9 03 40 B9 0B 00 80 12 6B 25 C8 1A 28 01 0B 0A 28 FF FF 34 E8 03 2B 2A EA 07 00 B9 08 01 09 0A E8 03 00 B9 F1 03 40 FD 00 38 71 1E 08 44 3B D5 0A 05 0A 12 CA 02 00 34 08 08 A0 52 5F 01 08 6B A0 01 00 54 08 10 A0 52 5F 01 08 6B 60 00 00 54 08 18 A0 52 31 00 00 14 08 20 60 1E E0 05 00 54 08 20 60 1E AC 05 00 54 12 10 6E 1E 20 3A 72 1E 2B 00 00 14 08 20 60 1E 00 05 00 54 08 20 60 1E CD 04 00 54 12 10 6E 1E 14 00 00 14 08 20 60 1E 40 04 00 54 10 10 6C 1E 08 20 60 1E 6D 00 00 54 00 20 70 1E A3 03 00 54 00 20 70 1E 12 10 6E 1E C1 00 00 54 30 2A 72 1E 28 02 78 9E 1F 01 40 F2 00 1E 71 1E 16 00 00 14 00 20 70 1E AD 00 00 54 00 20 72 1E 62 00 00 54 20 2A 72 1E 10 00 00 14 13 10 7C 1E 08 20 60 1E 62 00 00 54 00 20 73 1E 4C 01 00 54 00 20 73 1E 61 00 00 54 30 3A 72 1E EE FF FF 17 00 20 73 1E 82 00 00 54 10 10 7E 1E 00 20 70 1E CC FA FF 54 20 42 60 1E FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_218_1_0 {
	meta:
		name = "separate_fp"
		size = 168
	strings:
		$1 = { FF 43 00 D1 E0 03 00 FD EA 07 40 B9 48 79 14 53 09 FD 0F 51 3F 51 00 71 8A 02 00 54 89 00 F8 36 48 01 01 12 1F 20 00 29 1E 00 00 14 08 FE BF 12 0B 29 C9 1A E8 03 40 B9 49 01 0B 0A 28 01 08 2A C8 00 00 35 48 01 01 12 00 00 00 FD FF 23 00 29 E0 03 40 FD 13 00 00 14 E8 03 2B 2A 08 01 0A 0A 1F 20 00 29 0D 00 00 14 3F CD 00 71 CC FE FF 54 28 51 00 51 E9 03 40 B9 0B 00 80 12 6B 25 C8 1A 28 01 0B 0A 08 FE FF 34 E8 03 2B 2A 0A 04 00 B9 08 01 09 0A 08 00 00 B9 10 00 40 FD 00 38 70 1E FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_219_0_0 {
	meta:
		name = "??$common_localtime@J@@YAPEAUtm@@QEBJ@Z"
		size = 68
		refs = "0010 __getgmtimebuf 002c ??$common_localtime_s@J@@YAHQEAUtm@@QEBJ@Z"
		altNames = "_localtime32"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 00 00 80 D2 06 00 00 14 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_557_3_0 {
	meta:
		name = "??$common_gmtime@J@@YAPEAUtm@@QEBJ@Z"
		size = 68
		refs = "0010 __getgmtimebuf 002c ??$common_gmtime_s@J@@YAHQEAUtm@@QEBJ@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 00 00 80 D2 06 00 00 14 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_557_4_3 {
	meta:
		name = "??$common_gmtime@_J@@YAPEAUtm@@QEB_J@Z"
		size = 68
		refs = "0010 __getgmtimebuf 002c ??$common_gmtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 00 00 80 D2 06 00 00 14 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_219_1_0 {
	meta:
		name = "??$common_localtime@_J@@YAPEAUtm@@QEB_J@Z"
		size = 68
		refs = "0010 __getgmtimebuf 002c ??$common_localtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 00 00 80 D2 06 00 00 14 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_557_14_2 {
	meta:
		name = "_gmtime32"
		size = 68
		refs = "0010 __getgmtimebuf 002c ??$common_gmtime_s@J@@YAHQEAUtm@@QEBJ@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 00 00 80 D2 06 00 00 14 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_557_16_4 {
	meta:
		name = "_gmtime64"
		size = 68
		refs = "0010 __getgmtimebuf 002c ??$common_gmtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 00 00 80 D2 06 00 00 14 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_219_13_3 {
	meta:
		name = "_localtime64"
		size = 68
		refs = "0010 __getgmtimebuf 002c ??$common_localtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 00 00 80 D2 06 00 00 14 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 1F 00 00 71 E0 13 93 9A FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_219_2_0 {
	meta:
		name = "??$common_localtime_s@J@@YAHQEAUtm@@QEBJ@Z"
		size = 860
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 0070 __tzset 0080 _get_daylight 008c _get_dstbias 0098 _get_timezone 00cc _gmtime32_s 00e0 _isindst 0314 _invoke_watson"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 34 00 00 91 33 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 08 00 80 92 68 22 00 A9 68 22 01 A9 68 22 00 B9 94 FE FF B4 88 02 40 B9 A8 00 F8 36 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 F2 FF FF 17 29 17 00 18 1F 01 09 6B 4C FF FF 54 ?? ?? ?? ?? E0 63 00 91 FF 7F 03 29 FF 17 00 B9 ?? ?? ?? ?? 60 15 00 35 E0 73 00 91 ?? ?? ?? ?? 40 14 00 35 E0 53 00 91 ?? ?? ?? ?? 20 13 00 35 89 02 40 B9 48 15 00 18 4A 15 00 18 60 02 00 91 28 01 08 4B 1F 01 0A 6B E8 02 00 54 E8 17 40 B9 E1 43 00 91 29 01 08 4B E9 13 00 B9 ?? ?? ?? ?? E0 FA FF 35 E8 1B 40 B9 08 11 00 34 60 02 00 91 ?? ?? ?? ?? A0 10 00 34 E9 13 40 B9 E1 43 00 91 E8 1F 40 B9 60 02 00 91 29 01 08 4B E9 13 00 B9 ?? ?? ?? ?? 40 F9 FF 35 28 00 80 52 68 22 00 B9 7A 00 00 14 81 02 00 91 ?? ?? ?? ?? 80 F8 FF 35 74 02 40 B9 E8 1B 40 B9 68 01 00 34 60 02 00 91 ?? ?? ?? ?? 00 01 00 34 E8 17 40 B9 E9 1F 40 B9 8A 02 08 4B 28 00 80 52 68 22 00 B9 4C 01 09 4B 03 00 00 14 E8 17 40 B9 8C 02 08 4B CE 0F 00 18 88 7D 2E 9B 09 FD 60 D3 2B 01 0C 0B 68 7D 05 13 09 7D 48 0B 0A 7D 48 0B 28 6D 1C 53 09 01 0A 4B 8B 09 09 4B 6B 02 00 B9 8B 00 F8 36 68 F1 00 11 68 02 00 B9 8C F1 00 51 88 7D 2E 9B 09 FD 60 D3 2B 01 0C 0B 69 06 40 B9 68 7D 05 13 0C 7D 48 0B 8D 01 09 0B A8 7D 2E 9B 09 FD 60 D3 2B 01 0D 0B 68 7D 05 13 09 7D 48 0B 0A 7D 48 0B 28 6D 1C 53 09 01 0A 4B AB 09 09 4B 6B 06 00 B9 8B 00 F8 36 68 F1 00 11 68 06 00 B9 AD F1 00 51 A8 7D 2E 9B 4E 0B 00 18 09 FD 60 D3 2B 01 0D 0B 69 0A 40 B9 68 7D 05 13 0C 7D 48 0B 8D 01 09 0B A8 7D 2E 9B 09 FD 60 D3 2B 7D 02 13 6C 7D 4B 0B 68 7D 4B 0B 09 05 0C 0B AA 0D 09 4B 6A 0A 00 B9 8A 00 F8 36 48 61 00 11 68 0A 00 B9 AD 61 00 51 A8 7D 2E 9B 09 FD 60 D3 2B 7D 02 13 6C 7D 4B 0B 9F 01 00 71 CD 01 00 54 68 1A 40 B9 EB 00 80 52 8A 01 08 0B 49 0D CB 1A 28 A9 0B 1B 6A 0E 40 B9 68 1A 00 B9 68 1E 40 B9 49 01 0C 0B 69 0E 00 B9 0A 01 0C 0B 6A 1E 00 B9 1D 00 00 14 8C 03 F8 36 68 1A 40 B9 EB 00 80 52 89 01 08 0B 2A 1D 00 11 48 0D CB 1A 09 A9 0B 1B 6A 0E 40 B9 69 1A 00 B9 48 01 0C 0B 68 0E 00 B9 1F 01 00 71 AC 01 00 54 69 1E 40 B9 08 7D 00 11 68 0E 00 B9 2A 01 0C 0B 48 B5 05 11 68 1E 00 B9 68 16 40 B9 69 01 80 52 69 12 00 B9 09 05 00 51 69 16 00 B9 04 00 00 14 68 1E 40 B9 09 01 0C 0B 69 1E 00 B9 00 00 80 52 4C FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 7F D2 FF 7F 81 F4 03 00 7D E9 F7 7F 89 88 88 88 AB AA AA 2A }
	condition:
		$1
}

rule file_219_3_0 {
	meta:
		name = "??$common_localtime_s@_J@@YAHQEAUtm@@QEB_J@Z"
		size = 768
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 0070 __tzset 0080 _get_daylight 008c _get_dstbias 0098 _get_timezone 00cc _gmtime64_s 00e0 _isindst 02b4 _invoke_watson"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 33 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 08 00 80 92 68 22 00 A9 68 22 01 A9 68 22 00 B9 94 FE FF B4 88 02 40 F9 A8 00 F8 B6 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 F2 FF FF 17 29 14 00 58 1F 01 09 EB 4C FF FF 54 ?? ?? ?? ?? E0 53 00 91 FF FF 02 29 FF 13 00 B9 ?? ?? ?? ?? 60 12 00 35 E0 63 00 91 ?? ?? ?? ?? 40 11 00 35 E0 43 00 91 ?? ?? ?? ?? 20 10 00 35 89 02 40 F9 68 12 00 58 8A 12 00 58 60 02 00 91 28 01 08 8B 1F 01 0A EB E8 02 00 54 E8 13 40 B9 E1 83 00 91 29 C1 28 CB E9 13 00 F9 ?? ?? ?? ?? E0 FA FF 35 E8 17 40 B9 08 0E 00 34 60 02 00 91 ?? ?? ?? ?? A0 0D 00 34 E8 13 40 F9 E1 83 00 91 E9 1B 40 B9 60 02 00 91 09 C1 29 CB E9 13 00 F9 ?? ?? ?? ?? 40 F9 FF 35 28 00 80 52 68 22 00 B9 62 00 00 14 81 02 00 91 ?? ?? ?? ?? 80 F8 FF 35 74 02 80 B9 E8 17 40 B9 68 01 00 34 60 02 00 91 ?? ?? ?? ?? 00 01 00 34 E9 13 40 B9 E8 1B 40 B9 28 01 08 0B 8A C2 28 CB 28 00 80 52 68 22 00 B9 03 00 00 14 E8 13 40 B9 8A C2 28 CB 89 07 80 D2 48 0D C9 9A 09 A9 09 9B 69 02 00 B9 89 00 F8 36 28 F1 00 11 68 02 00 B9 4A F1 00 D1 88 07 80 D2 49 0D C8 9A 68 06 40 B9 8A 07 80 D2 2B C1 28 8B 69 0D CA 9A 28 AD 0A 9B 68 06 00 B9 88 00 F8 36 08 F1 00 11 68 06 00 B9 6B F1 00 D1 88 07 80 D2 69 0D C8 9A 68 0A 40 B9 0B 03 80 D2 2A C1 28 8B 49 0D CB 9A 28 A9 0B 9B 68 0A 00 B9 88 00 F8 36 08 61 00 11 68 0A 00 B9 4A 61 00 D1 08 03 80 D2 48 0D C8 9A 1F 01 00 F1 ED 01 00 54 0B 01 00 11 68 1A 40 B9 EC 00 80 52 0A 01 0B 0B 49 0D CC 1A 28 A9 0C 1B 6A 0E 40 B9 68 1A 00 B9 68 1E 40 B9 69 01 0A 0B 69 0E 00 B9 6A 01 08 0B 6A 1E 00 B9 1E 00 00 14 A8 03 F8 B6 0B 01 00 11 68 1A 40 B9 EC 00 80 52 09 01 0B 0B 2A 1D 00 11 48 0D CC 1A 09 A9 0C 1B 6A 0E 40 B9 69 1A 00 B9 68 01 0A 0B 68 0E 00 B9 1F 01 00 71 AC 01 00 54 69 1E 40 B9 08 7D 00 11 68 0E 00 B9 6A 01 09 0B 48 B5 05 11 68 1E 00 B9 68 16 40 B9 69 01 80 52 69 12 00 B9 09 05 00 51 69 16 00 B9 04 00 00 14 68 1E 40 B9 69 01 08 0B 69 1E 00 B9 00 00 80 52 64 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? FF 2A 58 93 07 00 00 00 7F 0B FC FF FF FF FF FF FD 41 50 93 07 00 00 00 }
	condition:
		$1
}

rule file_221_4_0 {
	meta:
		name = "_mbsncat_s_l"
		size = 668
		refs = "0050 _errno 005c _invalid_parameter_noinfo 0080 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00a0 strncat_s"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 13 00 00 91 35 00 00 91 56 00 00 91 74 00 00 91 17 00 80 52 B4 00 00 B5 B3 00 00 B5 15 01 00 B5 00 00 80 52 0B 00 00 14 B3 00 00 B4 95 00 00 B4 B4 01 00 B4 96 01 00 B5 7F 02 00 39 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 81 00 00 91 E0 43 00 91 ?? ?? ?? ?? EF 13 40 F9 E8 09 40 B9 E8 00 00 35 83 02 00 91 C2 02 00 91 A1 02 00 91 60 02 00 91 ?? ?? ?? ?? 77 00 00 14 6A 02 00 91 AD 02 00 91 48 01 40 39 88 00 00 34 4A 05 00 91 AD 05 00 D1 8D FF FF B5 0D 01 00 B5 7F 02 00 39 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 68 00 00 14 BF 01 15 EB 42 02 00 54 4C 05 00 D1 8B 01 00 91 9F 01 13 EB 03 01 00 54 68 01 40 39 08 01 0F 8B 09 65 40 39 89 00 10 36 6B 05 00 D1 7F 01 13 EB 42 FF FF 54 89 01 0B 4B A9 00 00 36 4A 05 00 D1 5F 01 00 39 AD 05 00 91 37 00 80 52 9F 06 00 B1 21 01 00 54 4E 01 16 CB CA 02 40 39 CA 69 36 38 D6 06 00 91 4A 04 00 34 AD 05 00 D1 6D FF FF B5 1F 00 00 14 94 03 00 B4 CB 16 40 38 68 01 0F 8B 09 65 40 39 A9 01 10 36 C9 02 40 39 89 02 00 34 BF 09 00 F1 09 02 00 54 4B 01 00 39 4B 05 00 91 CA 02 40 39 D6 06 00 91 AD 09 00 D1 6A 01 00 39 6A 05 00 91 06 00 00 14 4B 01 00 39 4A 05 00 91 2B 01 00 34 AD 05 00 D1 ED 00 00 B4 94 06 00 D1 E9 FF FF 17 0D 00 80 D2 03 00 00 14 5F 01 00 39 37 00 80 52 54 00 00 B5 5F 01 00 39 AD 04 00 B5 9F 06 00 B1 81 03 00 54 B7 00 00 34 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 EF 13 40 F9 BF 06 00 F1 29 02 00 54 6C 02 15 8B 8B 09 00 D1 6A 01 00 91 7F 01 13 EB 03 01 00 54 48 01 40 39 08 01 0F 8B 09 65 40 39 89 00 10 36 4A 05 00 D1 5F 01 13 EB 42 FF FF 54 69 01 0A 4B 69 00 00 36 9F E1 1F 38 03 00 00 14 68 02 15 8B 1F F1 1F 38 00 0A 80 52 0F 00 00 14 7F 02 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 08 00 00 14 D7 00 00 34 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 40 05 80 52 02 00 00 14 00 00 80 52 E8 A3 40 39 08 EF FF 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 73 FF FF 17 }
	condition:
		$1
}

rule file_222_3_0 {
	meta:
		name = "??$common_assert@D@@YAXQEBD0IQEAX@Z"
		size = 132
		refs = "0024 _set_error_mode 0034 _query_app_type 0050 ??$common_assert_to_message_box@D@@YAXQEBD0IQEAX@Z 0070 ??$common_assert_to_stderr@D@@YAXQEBD0I@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 00 80 52 34 00 00 91 55 00 00 11 76 00 00 91 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 80 00 00 35 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 C3 02 00 91 A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_4_0 {
	meta:
		name = "??$common_assert@_W@@YAXQEB_W0IQEAX@Z"
		size = 132
		refs = "0024 _set_error_mode 0034 _query_app_type 0050 ??$common_assert_to_message_box@_W@@YAXQEB_W0IQEAX@Z 0070 ??$common_assert_to_stderr@_W@@YAXQEB_W0I@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 00 80 52 34 00 00 91 55 00 00 11 76 00 00 91 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 80 00 00 35 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 C3 02 00 91 A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_5_0 {
	meta:
		name = "??$common_assert_to_message_box@D@@YAXQEBD0IQEAX@Z"
		size = 188
		refs = "0010 __security_push_cookie 0034 memset 0050 ??$common_assert_to_message_box_build_string@D@@YAXQEAD_KQEBD2IQEAX@Z 0054 ??_C@_0CF@GOGNBNAK@Microsoft?5Visual?5C?$CL?$CL?5Runtime?5Lib@ 0064 __acrt_show_narrow_message_box 008c __security_pop_cookie 00a0 abort 00a8 raise 00b0 _exit"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 09 D1 16 00 00 91 35 00 00 91 54 00 00 11 E0 03 00 91 02 48 80 D2 01 00 80 52 73 00 00 91 ?? ?? ?? ?? 65 02 00 91 84 02 00 11 A3 02 00 91 C2 02 00 91 01 48 80 D2 E0 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E2 02 00 18 E0 03 00 91 ?? ?? ?? ?? 1F 0C 00 71 C0 01 00 54 1F 10 00 71 80 00 00 54 1F 14 00 71 60 00 00 54 08 00 00 14 00 00 3E D4 FF 03 09 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 ?? ?? ?? ?? C0 02 80 52 ?? ?? ?? ?? 60 00 80 52 ?? ?? ?? ?? 1F 20 03 D5 12 20 01 00 }
	condition:
		$1
}

rule file_222_6_0 {
	meta:
		name = "??$common_assert_to_message_box@_W@@YAXQEB_W0IQEAX@Z"
		size = 188
		refs = "0010 __security_push_cookie 0034 memset 0050 ??$common_assert_to_message_box_build_string@_W@@YAXQEA_W_KQEB_W2IQEAX@Z 0054 ??_C@_1EK@MBDPDCGA@?$AAM?$AAi?$AAc?$AAr?$AAo?$AAs?$AAo?$AAf?$AAt?$AA?5?$AAV?$AAi?$AAs?$AAu?$AAa?$AAl?$AA?5?$AAC?$AA?$CL?$AA?$CL?$AA?5?$AAR?$AAu?$AAn?$AAt?$AAi?$AAm?$AAe?$AA?5?$AAL?$AAi?$AAb@ 0064 __acrt_show_wide_message_box 008c __security_pop_cookie 00a0 abort 00a8 raise 00b0 _exit"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 12 D1 16 00 00 91 35 00 00 91 54 00 00 11 E0 03 00 91 02 90 80 D2 01 00 80 52 73 00 00 91 ?? ?? ?? ?? 65 02 00 91 84 02 00 11 A3 02 00 91 C2 02 00 91 01 48 80 D2 E0 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? E2 02 00 18 E0 03 00 91 ?? ?? ?? ?? 1F 0C 00 71 C0 01 00 54 1F 10 00 71 80 00 00 54 1F 14 00 71 60 00 00 54 08 00 00 14 00 00 3E D4 FF 03 12 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 ?? ?? ?? ?? C0 02 80 52 ?? ?? ?? ?? 60 00 80 52 ?? ?? ?? ?? 1F 20 03 D5 12 20 01 00 }
	condition:
		$1
}

rule file_222_7_0 {
	meta:
		name = "??$common_assert_to_message_box_build_string@D@@YAXQEAD_KQEBD2IQEAX@Z"
		size = 2016
		refs = "001c __security_push_cookie 0024 ??_C@_0BC@LAIDCHCH@Assertion?5failed?$CB?$AA@ 0044 strcpy_s 004c ??_C@_02PHMGELLB@?6?6?$AA@ 005c strcat_s 0064 ??_C@_09KLGCKDOD@Program?3?5?$AA@ 0088 memset 008c __imp_GetModuleHandleExW 00c0 __imp_GetModuleFileNameA 00d8 ??_C@_0BH@DNAGHKFM@?$DMprogram?5name?5unknown?$DO?$AA@ 011c ??_C@_03KHICJKCI@?4?4?4?$AA@ 0150 memcpy_s 016c ??_C@_01EEMJAFIK@?6?$AA@ 0184 ??_C@_06IGPBOHMJ@File?3?5?$AA@ 0240 strncat_s 0354 ??_C@_06FIEBOLOH@Line?3?5?$AA@ 03a8 _itoa_s 03c4 ??_C@_0N@MEECIJGN@Expression?3?5?$AA@ 0474 ??_C@_0HA@OJHAGA@For?5information?5on?5how?5your?5prog@ 04a0 ??_C@_0DN@EBBNMLME@?$CIPress?5Retry?5to?5debug?5the?5applic@ 04c0 __security_pop_cookie 04f4 _invoke_watson"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 73 05 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 04 D1 ?? ?? ?? ?? 59 00 00 91 ?? ?? ?? ?? 13 00 00 91 34 00 00 91 75 00 00 91 9A 00 00 11 B6 00 00 91 ?? ?? ?? ?? 00 3C 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 3A 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 00 39 00 35 E0 23 00 91 A2 20 80 D2 01 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? FF 03 00 F9 ?? ?? ?? ?? 09 FD DF C8 E2 03 00 91 C1 02 00 91 C0 00 80 52 20 01 3F D6 E8 03 40 F9 A2 20 80 52 E1 23 00 91 1F 00 00 71 E0 03 88 9A ?? ?? ?? ?? E0 03 00 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? A1 20 80 D2 E0 23 00 91 ?? ?? ?? ?? A0 1F 00 35 EB 23 C0 39 F6 23 00 91 E9 23 00 91 8B 00 00 34 29 05 00 91 28 01 C0 39 C8 FF FF 35 E8 23 00 91 28 01 08 CB 08 2D 00 91 1F 01 01 F1 ?? ?? ?? ?? C9 01 00 54 EA 23 00 91 8B 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 56 D5 00 D1 E8 37 04 91 01 01 16 CB C0 02 00 91 63 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? 20 1D 00 35 C2 02 00 91 81 02 00 91 60 02 00 91 ?? ?? ?? ?? C0 30 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 40 2F 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? C0 2D 00 35 AA 02 C0 39 A9 02 00 91 8A 00 00 34 29 05 00 91 28 01 C0 39 C8 FF FF 35 28 01 15 CB 08 21 00 91 1F 01 01 F1 49 0B 00 54 B8 02 00 91 8A 00 00 34 18 07 00 91 09 03 C0 39 C9 FF FF 35 17 03 15 CB E8 02 15 8B 09 F1 DF 38 36 00 80 D2 3F 71 01 71 80 01 00 54 A8 02 17 8B A9 02 17 8B 0A F1 DF 38 2B 05 00 D1 5F BD 00 71 CE 12 57 FA A2 00 00 54 6A FD DF 38 D6 06 00 91 5F 71 01 71 41 FF FF 54 E8 02 16 CB 1F 99 00 F1 CE 8A 52 FA A2 02 00 91 81 02 00 91 60 02 00 91 22 02 00 54 A9 06 80 D2 23 01 16 CB ?? ?? ?? ?? E0 17 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 16 00 35 A8 02 16 CB 02 01 17 8B 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 60 06 00 34 A7 00 00 14 1F 99 00 F1 22 02 00 54 A8 06 80 D2 03 05 56 CB ?? ?? ?? ?? E0 17 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 16 00 35 A8 06 56 CB 81 02 00 91 60 02 00 91 02 01 17 8B ?? ?? ?? ?? 20 04 00 34 A7 00 00 14 63 04 80 D2 ?? ?? ?? ?? C0 19 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 60 18 00 35 A8 02 16 CB 02 01 17 8B 03 01 80 D2 81 02 00 91 60 02 00 91 ?? ?? ?? ?? C0 16 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 60 15 00 35 02 1F 00 D1 81 02 00 91 60 02 00 91 ?? ?? ?? ?? E0 00 00 34 9F 00 00 14 A2 02 00 91 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 00 20 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 1E 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 00 1D 00 35 6A 02 C0 39 69 02 00 91 8A 00 00 34 29 05 00 91 28 01 C0 39 C8 FF FF 35 28 01 13 CB 82 02 08 CB 61 02 00 91 8A 00 00 34 21 04 00 91 29 00 C0 39 C9 FF FF 35 43 01 80 52 40 03 00 11 ?? ?? ?? ?? 20 1A 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? C0 18 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 40 17 00 35 68 02 C0 39 6A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 13 CB 0C C1 02 91 28 03 C0 39 2B 03 00 91 88 00 00 34 6B 05 00 91 6A 01 C0 39 CA FF FF 35 68 01 19 CB 08 01 0C 8B 1F 01 14 EB 22 03 00 91 81 02 00 91 60 02 00 91 69 01 00 54 88 02 0C CB 03 0D 00 D1 ?? ?? ?? ?? A0 0F 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 00 00 34 71 00 00 14 ?? ?? ?? ?? 60 12 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 00 11 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 0F 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 20 0E 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 40 00 00 34 64 00 00 14 FF 43 04 91 ?? ?? ?? ?? FB 73 45 A9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_8_0 {
	meta:
		name = "??$common_assert_to_message_box_build_string@_W@@YAXQEA_W_KQEB_W2IQEAX@Z"
		size = 2060
		refs = "001c __security_push_cookie 0024 ??_C@_1CE@OJBNHDMO@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?$CB?$AA?$AA@ 0044 wcscpy_s 004c ??_C@_15IABLJNFO@?$AA?6?$AA?6?$AA?$AA@ 005c wcscat_s 0064 ??_C@_1BE@PHKBBGE@?$AAP?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?3?$AA?5?$AA?$AA@ 0088 memset 008c __imp_GetModuleHandleExW 00c0 __imp_GetModuleFileNameW 00d8 ??_C@_1CO@EAEJAADC@?$AA?$DM?$AAp?$AAr?$AAo?$AAg?$AAr?$AAa?$AAm?$AA?5?$AAn?$AAa?$AAm?$AAe?$AA?5?$AAu?$AAn?$AAk?$AAn?$AAo?$AAw?$AAn?$AA?$DO?$AA?$AA@ 0120 ??_C@_17LGKOMLJ@?$AA?4?$AA?4?$AA?4?$AA?$AA@ 0170 memcpy_s 018c ??_C@_13LBAGMAIH@?$AA?6?$AA?$AA@ 01a4 ??_C@_1O@HEMHKNDC@?$AAF?$AAi?$AAl?$AAe?$AA?3?$AA?5?$AA?$AA@ 0260 wcsncat_s 0370 ??_C@_1O@KCAFKHJE@?$AAL?$AAi?$AAn?$AAe?$AA?3?$AA?5?$AA?$AA@ 03d0 _itow_s 03ec ??_C@_1BK@PEDCIPMA@?$AAE?$AAx?$AAp?$AAr?$AAe?$AAs?$AAs?$AAi?$AAo?$AAn?$AA?3?$AA?5?$AA?$AA@ 04a0 ??_C@_1OA@EGMLFBHJ@?$AAF?$AAo?$AAr?$AA?5?$AAi?$AAn?$AAf?$AAo?$AAr?$AAm?$AAa?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAo?$AAn?$AA?5?$AAh?$AAo?$AAw?$AA?5?$AAy?$AAo?$AAu?$AAr?$AA?5?$AAp?$AAr?$AAo?$AAg@ 04cc ??_C@_1HK@POCJMFGK@?$AA?$CI?$AAP?$AAr?$AAe?$AAs?$AAs?$AA?5?$AAR?$AAe?$AAt?$AAr?$AAy?$AA?5?$AAt?$AAo?$AA?5?$AAd?$AAe?$AAb?$AAu?$AAg?$AA?5?$AAt?$AAh?$AAe?$AA?5?$AAa?$AAp?$AAp?$AAl?$AAi?$AAc@ 04ec __security_pop_cookie 0520 _invoke_watson"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 73 05 A9 FD 03 00 91 ?? ?? ?? ?? FF 43 08 D1 ?? ?? ?? ?? 58 00 00 91 ?? ?? ?? ?? 13 00 00 91 34 00 00 91 75 00 00 91 99 00 00 11 B6 00 00 91 ?? ?? ?? ?? 60 3D 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? E0 3B 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 60 3A 00 35 E0 23 00 91 42 41 80 D2 01 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? FF 03 00 F9 ?? ?? ?? ?? 09 FD DF C8 E2 03 00 91 C1 02 00 91 C0 00 80 52 20 01 3F D6 E8 03 40 F9 A2 20 80 52 E1 23 00 91 1F 00 00 71 E0 03 88 9A ?? ?? ?? ?? E0 03 00 F9 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? A1 20 80 D2 E0 23 00 91 ?? ?? ?? ?? 00 21 00 35 EB 13 C0 79 F6 23 00 91 E9 23 00 91 8B 00 00 34 29 09 00 91 28 01 C0 79 C8 FF FF 35 E8 23 00 91 28 01 08 CB 09 FD 41 93 2A 2D 00 91 5F 01 01 F1 ?? ?? ?? ?? A9 02 00 54 EC 23 00 91 8B 00 00 34 8C 09 00 91 8B 01 C0 79 CB FF FF 35 E8 23 00 91 88 01 08 CB 09 FD 41 93 2A D5 00 D1 4B F9 7F D3 E8 23 00 91 A9 20 80 D2 76 01 08 8B 28 05 8B CB C3 00 80 D2 01 F9 7F D3 ?? ?? ?? ?? C0 02 00 91 ?? ?? ?? ?? 80 1D 00 35 C2 02 00 91 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 20 31 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? A0 2F 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 20 2E 00 35 AB 02 C0 79 A9 02 00 91 8B 00 00 34 29 09 00 91 28 01 C0 79 C8 FF FF 35 28 01 15 CB 09 FD 41 93 2A 21 00 91 5F 01 01 F1 29 0B 00 54 AC 02 00 91 8B 00 00 34 8C 09 00 91 8B 01 C0 79 CB FF FF 35 88 01 15 CB 16 FD 41 93 A9 06 16 8B 2C 00 80 D2 2D E1 5F 78 BF 71 01 71 40 01 00 54 A8 06 16 8B 0A 09 00 D1 BF BD 00 71 8E 11 56 FA A2 00 00 54 4D ED 5F 78 8C 05 00 91 BF 71 01 71 41 FF FF 54 D7 02 0C CB FF 9A 00 F1 8E 89 52 FA A2 02 00 91 81 02 00 91 60 02 00 91 02 02 00 54 A8 06 80 D2 03 01 0C CB ?? ?? ?? ?? 40 18 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? E0 16 00 35 A2 06 17 8B 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 06 00 34 AB 00 00 14 FF 9A 00 F1 42 02 00 54 97 FD 41 D3 A8 06 80 D2 03 01 17 CB ?? ?? ?? ?? 40 18 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? E0 16 00 35 C8 02 17 CB A2 06 08 8B 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 20 04 00 34 AA 00 00 14 63 04 80 D2 ?? ?? ?? ?? 20 1A 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? C0 18 00 35 A2 06 17 8B 03 01 80 D2 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 40 17 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? E0 15 00 35 C8 1E 00 D1 A2 06 08 8B 81 02 00 91 60 02 00 91 ?? ?? ?? ?? E0 00 00 34 A2 00 00 14 A2 02 00 91 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 60 20 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 00 1F 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 1D 00 35 6B 02 C0 79 69 02 00 91 8B 00 00 34 29 09 00 91 28 01 C0 79 C8 FF FF 35 28 01 13 CB 82 06 88 CB 6A 02 00 91 8B 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 13 CB 09 FD 41 93 61 06 09 8B 43 01 80 52 20 03 00 11 ?? ?? ?? ?? 40 1A 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? E0 18 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 60 17 00 35 68 02 C0 79 6A 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 13 CB 09 FD 41 93 08 03 C0 79 2C C1 02 91 0B 03 00 91 88 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 68 01 18 CB 89 05 88 8B 02 03 00 91 81 02 00 91 3F 01 14 EB 60 02 00 91 69 01 00 54 88 02 0C CB 03 0D 00 D1 ?? ?? ?? ?? A0 0F 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 00 00 34 71 00 00 14 ?? ?? ?? ?? 60 12 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 00 11 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 0F 00 35 ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 20 0E 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 40 00 00 34 64 00 00 14 FF 43 08 91 ?? ?? ?? ?? FB 73 45 A9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_9_0 {
	meta:
		name = "??$common_assert_to_stderr@D@@YAXQEBD0I@Z"
		size = 132
		refs = "0014 __acrt_iob_func 0040 setvbuf 0048 ?get_assert_format@@YAPEBDD@Z 0070 ??$ftprintf@PEAU_iobuf@@PEBDAEBQEBDAEBQEBDAEBI@?$__crt_char_traits@D@@SAH$$QEAPEAU_iobuf@@$$QEAPEBDAEBQEBD2AEBI@Z 007c fflush 0080 abort"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 E1 83 01 A9 40 00 80 52 E2 13 00 B9 ?? ?? ?? ?? 08 14 40 B9 BF 3B 03 D5 09 98 80 52 08 01 09 0A E8 00 00 35 40 00 80 52 ?? ?? ?? ?? 03 00 80 D2 82 00 80 52 01 00 80 D2 ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? E0 17 00 F9 40 00 80 52 ?? ?? ?? ?? E4 43 00 91 E0 1B 00 F9 E3 63 00 91 E0 C3 00 91 E2 83 00 91 E1 A3 00 91 ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_10_0 {
	meta:
		name = "??$common_assert_to_stderr@_W@@YAXQEB_W0I@Z"
		size = 312
		refs = "0010 __imp_GetStdHandle 003c __imp_GetFileType 0058 ??_C@_1FE@LHBLIKM@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?3?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0@ 006c swprintf 009c __imp_WriteConsoleW 00c0 abort 00c8 __acrt_iob_func 00f4 setvbuf 00fc ?get_assert_format@@YAPEB_W_W@Z 0124 ??$ftprintf@PEAU_iobuf@@PEB_WAEBQEB_WAEBQEB_WAEBI@?$__crt_char_traits@_W@@SAH$$QEAPEAU_iobuf@@$$QEAPEB_WAEBQEB_W2AEBI@Z 0130 fflush"
	strings:
		$1 = { F3 0F 1F F8 FF 03 13 D1 FD 7B 00 A9 FD 03 00 91 ?? ?? ?? ?? E1 83 01 A9 ?? ?? ?? ?? E2 13 00 B9 09 FD DF C8 60 01 80 12 20 01 3F D6 13 00 00 91 68 06 00 D1 1F 0D 00 B1 68 04 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 1F 08 00 71 A1 03 00 54 E5 13 40 B9 ?? ?? ?? ?? E4 8F 41 A9 ?? ?? ?? ?? 01 48 80 D2 E0 E3 00 91 ?? ?? ?? ?? A0 02 F8 37 E8 73 C0 79 E9 E3 00 91 88 00 00 34 29 09 00 91 28 01 C0 79 C8 FF FF 35 E8 E3 00 91 FF 17 00 B9 28 01 08 CB 02 FD 41 93 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 04 00 80 D2 E3 53 00 91 E1 E3 00 91 60 02 00 91 20 01 3F D6 40 00 00 34 ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? 08 14 40 B9 BF 3B 03 D5 09 98 80 52 08 01 09 0A E8 00 00 35 40 00 80 52 ?? ?? ?? ?? 03 00 80 D2 82 00 80 52 01 00 80 D2 ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? E0 17 00 F9 40 00 80 52 ?? ?? ?? ?? E4 43 00 91 E0 1B 00 F9 E3 63 00 91 E0 C3 00 91 E2 83 00 91 E1 A3 00 91 ?? ?? ?? ?? 40 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_11_0 {
	meta:
		name = "??$ftprintf@PEAU_iobuf@@PEBDAEBQEBDAEBQEBDAEBI@?$__crt_char_traits@D@@SAH$$QEAPEAU_iobuf@@$$QEAPEBDAEBQEBD2AEBI@Z"
		size = 24
		refs = "0014 fprintf"
	strings:
		$1 = { 84 00 40 B9 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_12_0 {
	meta:
		name = "??$ftprintf@PEAU_iobuf@@PEB_WAEBQEB_WAEBQEB_WAEBI@?$__crt_char_traits@_W@@SAH$$QEAPEAU_iobuf@@$$QEAPEB_WAEBQEB_W2AEBI@Z"
		size = 24
		refs = "0014 fwprintf"
	strings:
		$1 = { 84 00 40 B9 63 00 40 F9 42 00 40 F9 21 00 40 F9 00 00 40 F9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_15_0 {
	meta:
		name = "??$itot_s@AEBIPEAD_KH@?$__crt_char_traits@D@@SAHAEBI$$QEAPEAD$$QEA_K$$QEAH@Z"
		size = 20
		refs = "0010 _itoa_s"
	strings:
		$1 = { 63 00 40 B9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_16_0 {
	meta:
		name = "??$itot_s@AEBIPEA_W_KH@?$__crt_char_traits@_W@@SAHAEBI$$QEAPEA_W$$QEA_K$$QEAH@Z"
		size = 20
		refs = "0010 _itow_s"
	strings:
		$1 = { 63 00 40 B9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_669_36_0 {
	meta:
		name = "??$ultot_s@AEAIAEBQEADAEB_KH@?$__crt_char_traits@D@@SAHAEAIAEBQEADAEB_K$$QEAH@Z"
		size = 20
		refs = "0010 _ultoa_s"
	strings:
		$1 = { 63 00 40 B9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_669_37_0 {
	meta:
		name = "??$ultot_s@AEAIAEBQEA_WAEB_KH@?$__crt_char_traits@_W@@SAHAEAIAEBQEA_WAEB_K$$QEAH@Z"
		size = 20
		refs = "0010 _ultow_s"
	strings:
		$1 = { 63 00 40 B9 42 00 40 F9 21 00 40 F9 00 00 40 B9 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_29_0 {
	meta:
		name = "??$tcslen@AEAY0BAF@D@?$__crt_char_traits@D@@SA_KAEAY0BAF@D@Z"
		size = 32
		altNames = "??$tcslen@AEAY04$$CBD@?$__crt_char_traits@D@@SA_KAEAY04$$CBD@Z ??$tcslen@AEAY0L@$$CBD@?$__crt_char_traits@D@@SA_KAEAY0L@$$CBD@Z"
	strings:
		$1 = { 08 00 C0 39 0A 00 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 40 01 00 CB C0 03 5F D6 }
	condition:
		$1
}

rule file_222_30_0 {
	meta:
		name = "??$tcslen@AEAY0BAF@_W@?$__crt_char_traits@_W@@SA_KAEAY0BAF@_W@Z"
		size = 36
		altNames = "??$tcslen@AEAY04$$CB_W@?$__crt_char_traits@_W@@SA_KAEAY04$$CB_W@Z ??$tcslen@AEAY0L@$$CB_W@?$__crt_char_traits@_W@@SA_KAEAY0L@$$CB_W@Z"
	strings:
		$1 = { 08 00 C0 79 0A 00 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 00 CB 00 FD 41 93 C0 03 5F D6 }
	condition:
		$1
}

rule file_222_44_0 {
	meta:
		name = "?common_assert_to_stderr_direct@@YAXQEB_W0I@Z"
		size = 236
		refs = "0010 __security_push_cookie 0018 __imp_GetStdHandle 0048 __imp_GetFileType 0060 ??_C@_1FE@LHBLIKM@?$AAA?$AAs?$AAs?$AAe?$AAr?$AAt?$AAi?$AAo?$AAn?$AA?5?$AAf?$AAa?$AAi?$AAl?$AAe?$AAd?$AA?3?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0?$AA?5?$AAf?$AAi?$AAl?$AAe?$AA?5?$AA?$CF?$AAT?$AAs?$AA?0@ 007c swprintf 00ac __imp_WriteConsoleW 00d4 __security_pop_cookie 00e8 abort"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 12 D1 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 15 00 00 91 60 01 80 12 36 00 00 91 54 00 00 11 20 01 3F D6 13 00 00 91 68 06 00 D1 1F 0D 00 B1 68 04 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 1F 08 00 71 A1 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 85 02 00 11 C4 02 00 91 A3 02 00 91 01 48 80 D2 E0 23 00 91 ?? ?? ?? ?? 80 02 F8 37 E8 13 C0 79 E9 23 00 91 88 00 00 34 29 09 00 91 28 01 C0 79 C8 FF FF 35 E8 23 00 91 FF 03 00 B9 28 01 08 CB 02 FD 41 93 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 04 00 80 D2 E3 03 00 91 E1 23 00 91 60 02 00 91 20 01 3F D6 E0 00 00 35 FF 03 12 91 ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_75_0 {
	meta:
		name = "_assert"
		size = 132
		refs = "0024 _set_error_mode 0034 _query_app_type 0050 ??$common_assert_to_message_box@D@@YAXQEBD0IQEAX@Z 0070 ??$common_assert_to_stderr@D@@YAXQEBD0I@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 F6 07 40 F9 60 00 80 52 34 00 00 91 55 00 00 11 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 80 00 00 35 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 C3 02 00 91 A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_80_0 {
	meta:
		name = "_wassert"
		size = 132
		refs = "0024 _set_error_mode 0034 _query_app_type 0050 ??$common_assert_to_message_box@_W@@YAXQEB_W0IQEAX@Z 0070 ??$common_assert_to_stderr@_W@@YAXQEB_W0I@Z"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 F6 07 40 F9 60 00 80 52 34 00 00 91 55 00 00 11 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 80 00 00 35 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 C3 02 00 91 A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? A2 02 00 11 81 02 00 91 60 02 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_222_77_0 {
	meta:
		name = "_vfprintf_l"
		size = 76
		refs = "0020 __local_stdio_printf_options 0038 __stdio_common_vfprintf"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 16 00 00 91 35 00 00 91 54 00 00 91 73 00 00 91 ?? ?? ?? ?? 00 00 40 F9 64 02 00 91 83 02 00 91 A2 02 00 91 C1 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_222_78_0 {
	meta:
		name = "_vfwprintf_l"
		size = 76
		refs = "0020 __local_stdio_printf_options 0038 __stdio_common_vfwprintf"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 16 00 00 91 35 00 00 91 54 00 00 91 73 00 00 91 ?? ?? ?? ?? 00 00 40 F9 64 02 00 91 83 02 00 91 A2 02 00 91 C1 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_222_79_0 {
	meta:
		name = "_vswprintf_c_l"
		size = 104
		refs = "0028 __local_stdio_printf_options 0044 __stdio_common_vswprintf"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 17 00 00 91 36 00 00 91 55 00 00 91 74 00 00 91 93 00 00 91 ?? ?? ?? ?? 00 00 40 F9 65 02 00 91 84 02 00 91 A3 02 00 91 C2 02 00 91 E1 02 00 91 ?? ?? ?? ?? 08 00 80 12 1F 00 00 71 00 B1 80 1A FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_222_81_0 {
	meta:
		name = "fprintf"
		size = 84
		refs = "0028 __local_stdio_printf_options 0040 __stdio_common_vfprintf"
	strings:
		$1 = { F3 53 BB A9 F5 0B 00 F9 E2 0F 02 A9 E4 17 03 A9 E6 1F 04 A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 33 00 00 91 F5 C3 00 91 ?? ?? ?? ?? 00 00 40 F9 A4 02 00 91 03 00 80 D2 62 02 00 91 81 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 0B 40 F9 F3 53 C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_222_82_0 {
	meta:
		name = "fwprintf"
		size = 84
		refs = "0028 __local_stdio_printf_options 0040 __stdio_common_vfwprintf"
	strings:
		$1 = { F3 53 BB A9 F5 0B 00 F9 E2 0F 02 A9 E4 17 03 A9 E6 1F 04 A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 33 00 00 91 F5 C3 00 91 ?? ?? ?? ?? 00 00 40 F9 A4 02 00 91 03 00 80 D2 62 02 00 91 81 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 0B 40 F9 F3 53 C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_222_84_0 {
	meta:
		name = "swprintf"
		size = 104
		refs = "002c __local_stdio_printf_options 0048 __stdio_common_vswprintf"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 E3 93 02 A9 E5 9B 03 A9 E7 27 00 F9 FD 7B BF A9 FD 03 00 91 15 00 00 91 34 00 00 91 53 00 00 91 F6 E3 00 91 ?? ?? ?? ?? 00 00 40 F9 C5 02 00 91 04 00 80 D2 63 02 00 91 82 02 00 91 A1 02 00 91 ?? ?? ?? ?? 08 00 80 12 1F 00 00 71 00 B1 80 1A FD 7B C1 A8 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_223_0_0 {
	meta:
		name = "strcat"
		size = 48
	strings:
		$1 = { 08 00 C0 39 0A 00 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4B 01 01 CB 2A 00 C0 39 6A 69 21 38 21 04 00 91 AA FF FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_223_1_0 {
	meta:
		name = "strcpy"
		size = 24
	strings:
		$1 = { 09 00 01 CB 28 00 C0 39 28 69 21 38 21 04 00 91 A8 FF FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_224_4_0 {
	meta:
		name = "_wcsncoll"
		size = 88
		refs = "0008 __acrt_locale_changed_data 0018 _errno 0024 _invalid_parameter_noinfo 0040 wcsncmp 004c _wcsncoll_l"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? C8 01 00 35 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 09 00 00 14 41 FF FF B4 E8 7B 40 B2 5F 00 08 EB E8 FE FF 54 ?? ?? ?? ?? 03 00 00 14 03 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_638_4_0 {
	meta:
		name = "_strncoll"
		size = 88
		refs = "0008 __acrt_locale_changed_data 0018 _errno 0024 _invalid_parameter_noinfo 0040 strncmp 004c _strncoll_l"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? C8 01 00 35 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 09 00 00 14 41 FF FF B4 E8 7B 40 B2 5F 00 08 EB E8 FE FF 54 ?? ?? ?? ?? 03 00 00 14 03 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_295_5_0 {
	meta:
		name = "_strnicmp"
		size = 88
		refs = "0008 __acrt_locale_changed_data 0018 _errno 0024 _invalid_parameter_noinfo 0040 __ascii_strnicmp 004c _strnicmp_l"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? C8 01 00 35 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 09 00 00 14 41 FF FF B4 E8 7B 40 B2 5F 00 08 EB E8 FE FF 54 ?? ?? ?? ?? 03 00 00 14 03 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_224_5_0 {
	meta:
		name = "_wcsncoll_l"
		size = 216
		refs = "0030 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0048 _errno 0054 _invalid_parameter_noinfo 0074 wcsncmp 0090 __acrt_CompareStringW"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BD A9 FD 03 00 91 15 00 00 91 34 00 00 91 53 00 00 91 73 00 00 B5 00 00 80 52 29 00 00 14 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? B5 00 00 B4 94 00 00 B4 E8 7B 40 B2 7F 02 08 EB C9 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 13 00 00 14 E8 0F 40 F9 00 99 40 F9 C0 00 00 B5 62 02 00 91 81 02 00 91 A0 02 00 91 ?? ?? ?? ?? 0E 00 00 14 63 02 00 11 65 00 00 11 84 02 00 91 A2 02 00 91 01 00 82 52 ?? ?? ?? ?? C0 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 B0 12 02 00 00 14 00 08 00 51 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_225_18_0 {
	meta:
		name = "?has_big_buffer@__crt_stdio_stream@@QEBA_NXZ"
		size = 24
	strings:
		$1 = { 08 00 40 F9 09 15 40 B9 BF 3B 03 D5 3F 05 1A 72 E0 07 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_225_22_0 {
	meta:
		name = "_fwrite_nolock"
		size = 528
		refs = "0034 _errno 0040 _invalid_parameter_noinfo 00d4 memcpy 011c __acrt_stdio_flush_nolock 0158 _fileno 0164 _write 01a8 __acrt_stdio_flush_and_write_narrow_nolock"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FD 7B BF A9 FD 03 00 91 18 00 00 91 36 00 00 91 59 00 00 91 75 00 00 91 F6 00 00 B4 D9 00 00 B4 95 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 FD 7B C1 A8 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 B8 FE FF B4 08 00 80 92 08 09 D6 9A 3F 03 08 EB 28 FE FF 54 A8 16 40 B9 BF 3B 03 D5 09 98 80 52 08 01 09 0A 68 00 00 34 BA 22 40 B9 02 00 00 14 1A 00 82 52 D7 7E 19 9B F4 02 00 91 97 09 00 B4 A9 16 40 B9 BF 3B 03 D5 28 05 1A 12 88 02 00 34 AA 12 40 B9 4A 02 00 34 EA 08 F8 37 49 7D 40 93 A0 02 40 F9 9F 02 09 EB 93 32 89 9A 62 02 00 91 01 03 00 91 ?? ?? ?? ?? A8 12 40 B9 94 02 13 CB 78 02 18 8B 09 01 13 4B A9 12 00 B9 AA 02 40 F9 4B 01 13 8B AB 02 00 F9 34 00 00 14 53 7F 40 D3 9F 02 13 EB E3 04 00 54 AC 16 40 B9 BF 3B 03 D5 8C 05 1A 12 8C 00 00 34 A0 02 00 91 ?? ?? ?? ?? 60 06 00 35 FA 00 00 34 53 00 00 B5 80 00 3E D4 88 0A D3 9A 09 D1 13 9B 8B 02 09 CB 02 00 00 14 8B 02 00 91 EC 7B 7F B2 7F 01 0C EB 2C 00 80 12 A0 02 00 91 73 31 8C 1A ?? ?? ?? ?? 62 02 00 11 01 03 00 91 ?? ?? ?? ?? 1F 04 00 31 60 04 00 54 1F 00 13 6B 68 82 80 1A 94 42 28 CB 1F 00 13 6B 18 43 28 8B 22 02 00 54 AB 52 00 91 6A FD 5F 88 4A 01 1C 32 6A FD 09 88 A9 FF FF 35 13 00 00 14 00 17 C0 38 A1 02 00 91 ?? ?? ?? ?? 1F 04 00 31 E0 01 00 54 A8 22 40 B9 29 00 80 52 94 06 00 D1 1F 01 00 71 1A C1 89 1A D4 F6 FF B5 20 03 00 91 9E FF FF 17 AA 52 00 91 49 FD 5F 88 29 01 1C 32 49 FD 08 88 A8 FF FF 35 BF 3B 03 D5 E8 02 14 CB 00 09 D6 9A 95 FF FF 17 AC 52 00 91 8B FD 5F 88 6B 01 1C 32 8B FD 0A 88 AA FF FF 35 F7 FF FF 17 }
	condition:
		$1
}

rule file_225_23_0 {
	meta:
		name = "fwrite"
		size = 112
		refs = "0020 _errno 002c _invalid_parameter_noinfo 0068 ??$?RV<lambda_bdbcead8b570fa3d5ec6d9679862a6e5>@@AEAV<lambda_96f4279ff90247a4c5c5d9824f56f8c1>@@V<lambda_4606be27f17b5e5579e09050fab91818>@@@?$__crt_seh_guarded_call@_K@@QEAA_K$$QEAV<lambda_bdbcead8b570fa3d5ec6d9679862a6e5>@@AEAV<lambda_96f4279ff90247a4c5c5d9824f56f8c1>@@$$QEAV<lambda_4606be27f17b5e5579e09050fab91818>@@@Z"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 07 02 A9 E2 1B 00 F9 E3 0F 00 F9 E1 00 00 B4 C2 00 00 B4 03 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 FD 7B C7 A8 C0 03 5F D6 E8 63 00 91 E3 8F 03 A9 E9 83 00 91 E8 A7 04 A9 E8 A3 00 91 E9 C3 00 91 E8 A7 05 A9 E3 E3 00 91 E2 23 01 91 E1 03 01 91 E0 43 00 91 ?? ?? ?? ?? F2 FF FF 17 }
	condition:
		$1
}

rule file_226_5_0 {
	meta:
		name = "__dcrt_multibyte_check_type"
		size = 140
		refs = "005c __acrt_GetStringTypeA"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 0A 00 00 11 20 00 00 91 09 04 40 F9 54 00 00 11 73 00 00 11 28 09 40 B9 68 00 00 35 00 00 80 52 15 00 00 14 25 05 40 B9 48 7D 08 53 EA 47 00 39 26 00 80 52 E8 43 00 39 E4 53 00 91 FF 2B 00 79 43 00 80 52 FF 2F 00 79 E2 43 00 91 21 00 80 52 ?? ?? ?? ?? 40 FE FF 34 E8 2F 40 79 08 FE FF 35 E8 2B 40 79 1F 01 14 6A E9 07 9F 1A 3F 01 13 6B E0 17 9F 1A FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_226_9_0 {
	meta:
		name = "_ismbcspace_l"
		size = 140
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 003c _isctype_l 0064 __dcrt_multibyte_check_type"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F FE 03 71 C8 01 00 54 E9 0F 40 F9 28 09 40 B9 1F 05 00 71 CD 00 00 54 E2 63 00 91 01 01 80 52 60 02 00 11 ?? ?? ?? ?? 0A 00 00 14 28 01 40 F9 09 D9 73 78 20 01 1D 12 06 00 00 14 23 00 80 52 02 01 80 52 E1 63 00 91 60 02 00 11 ?? ?? ?? ?? E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_227_5_0 {
	meta:
		name = "_mbbtombc_l"
		size = 192
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0034 ?mbbtable@@3QBGB 0060 ?mbctable@@3QBU<unnamed-type-mbctable>@@B"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 08 05 40 B9 1F 91 0E 71 A1 03 00 54 69 82 00 51 3F 79 01 71 A8 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 13 59 69 78 16 00 00 14 7F 72 03 71 61 00 00 54 F3 71 90 52 12 00 00 14 68 86 02 51 1F F9 00 71 E8 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 E9 14 80 52 7F 02 09 6B C0 00 00 54 4A 05 00 11 49 7D 7E 93 29 69 6B 38 69 FF FF 35 04 00 00 14 49 7D 7E 93 68 09 00 91 33 69 68 78 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_227_7_0 {
	meta:
		name = "_mbctombb_l"
		size = 228
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002c ?mbbtable@@3QBGB 0058 ?mbctable@@3QBU<unnamed-type-mbctable>@@B"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 08 05 40 B9 1F 91 0E 71 C1 04 00 54 0B 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 2A D9 6B 78 7F 02 0A 6B E0 03 00 54 6B 05 00 11 7F 79 01 71 4D FF FF 54 C8 72 90 52 7F 02 08 6B 48 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 0D 00 80 52 0C 00 80 D2 C8 09 00 91 89 69 68 78 6F 02 09 4B CF 01 00 34 29 01 13 4A 3F 1D 18 72 EE 09 40 7A AD 00 00 54 CB 05 00 91 8C 69 EB 38 EC 01 0C 4B CC 00 F8 37 AD 05 00 11 AC 7D 7E 93 88 69 6E 38 C8 00 00 34 F0 FF FF 17 A8 7D 7E 93 13 69 6E 38 02 00 00 14 73 81 00 11 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_228_0_0 {
	meta:
		name = "copysignf"
		size = 44
	strings:
		$1 = { FF 43 00 D1 E0 07 00 2D E8 07 40 79 EA 0F 40 79 08 01 0A 4A 09 39 00 12 28 01 0A 4A E8 07 00 79 E0 03 40 BD FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_229_1_0 {
	meta:
		name = "powf"
		size = 1036
		refs = "00a4 _handle_nanf 012c ??_C@_04MBFDLNIM@powf?$AA@ 0140 _handle_errorf 0170 _controlfp_s 034c log2 035c _exp2"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 06 00 26 1E 08 F0 A7 52 E1 13 00 BD 29 00 26 1E 11 40 20 1E CB 78 00 12 7F 01 06 6B 2D 79 00 12 F1 C7 02 2D EE 17 9F 1A E1 1B 00 BD BF 01 09 6B EC 17 9F 1A DF 00 08 6B 61 01 00 54 12 10 2E 1E 13 10 20 1E 30 28 32 1E 00 22 33 1E 81 00 00 54 28 00 80 52 F0 63 00 91 08 FE 9F 88 40 42 20 1E DF 00 00 14 CD 00 00 35 12 10 2E 1E 13 10 20 1E 31 2A 32 1E 20 22 33 1E F5 FF FF 17 6F 1D 09 12 08 F0 AF 52 FF 01 08 6B C1 00 00 54 68 59 00 12 88 00 00 34 C0 00 00 91 ?? ?? ?? ?? D0 00 00 14 AA 1D 09 12 08 F0 AF 52 5F 01 08 6B A1 00 00 54 A8 59 00 12 68 00 00 34 20 01 00 91 F7 FF FF 17 08 F0 A7 52 3F 01 08 6B 61 00 00 54 20 42 20 1E C3 00 00 14 08 E0 A9 52 5F 01 08 6B 09 08 00 54 08 F0 AF 52 BF 01 08 6B E8 17 9F 1A EC 04 00 34 6B 00 00 35 E0 03 27 1E B9 00 00 14 09 F0 A7 52 7F 01 09 6B C2 01 00 54 68 FF FF 35 44 02 80 52 83 00 80 52 02 00 80 D2 20 42 20 1E 45 04 80 52 ?? ?? ?? ?? 21 40 20 1E ?? ?? ?? ?? 46 00 80 52 A1 03 80 52 ?? ?? ?? ?? A9 00 00 14 09 F0 A7 52 7F 01 09 6B 61 00 00 54 00 10 2E 1E A4 00 00 14 48 01 00 34 02 00 80 52 FF 1B 00 B9 01 00 80 52 E0 63 00 91 ?? ?? ?? ?? 08 F0 AF 52 E8 1B 00 B9 00 01 27 1E 9A 00 00 14 24 02 80 52 63 00 80 52 02 F0 AF D2 E5 FF FF 17 8B 00 00 35 84 00 80 52 43 00 80 52 FB FF FF 17 09 F0 A7 52 7F 01 09 6B 62 01 00 54 A8 FE FF 34 02 00 80 52 FF 17 00 B9 01 00 80 52 E0 53 00 91 ?? ?? ?? ?? 08 F0 AF 52 E8 1B 00 B9 00 01 27 1E 85 00 00 14 09 F0 A7 52 7F 01 09 6B A1 F9 FF 54 DC FF FF 17 28 79 17 53 0A F9 01 51 5F 05 00 71 8B 01 00 54 5F 61 00 71 6D 00 00 54 48 00 80 52 11 00 00 14 07 03 80 52 E7 00 0A 4B 28 00 80 52 08 21 C7 1A 0A 05 00 51 48 01 09 0A 68 00 00 34 08 00 80 52 08 00 00 14 E8 03 2A 2A 08 01 09 0A 09 25 C7 1A 3F 01 00 72 27 00 80 52 48 00 80 52 E8 10 88 1A 09 F0 AF 52 FF 01 09 6B E1 01 00 54 AE 00 00 34 E0 03 27 1E 9F 01 00 71 20 1E 20 1E 61 00 00 14 1F 05 00 71 A1 00 00 54 D0 0C 00 1C 9F 01 00 71 20 1E 30 1E 5B 00 00 14 0C F4 FF 34 20 42 21 1E 58 00 00 14 6B 03 00 35 0E 01 00 34 20 42 20 1E 8C 0A 00 35 C9 00 61 92 22 1D 69 B2 84 00 80 52 43 00 80 52 9F FF FF 17 1F 05 00 71 6C 00 00 34 61 FE FF 54 87 FF FF 17 ?? ?? ?? ?? 21 40 20 1E ?? ?? ?? ?? 20 42 20 1E 46 00 80 52 45 04 80 52 84 00 80 52 43 00 80 52 A1 03 80 52 61 00 00 54 02 F0 BF D2 95 FF FF 17 02 F0 AF D2 93 FF FF 17 13 00 80 52 EE 00 00 35 88 01 00 34 71 01 27 1E 1F 05 00 71 EB 1B 00 B9 F3 17 9F 1A F1 17 00 BD 08 D0 A5 52 BF 01 08 6B 42 01 00 54 12 10 2E 1E 20 28 32 1E 2F 00 00 14 20 42 20 1E 25 04 80 52 04 01 80 52 23 00 80 52 02 F8 BF D2 7A FF FF 17 20 C2 22 1E ?? ?? ?? ?? F0 13 40 BD 10 C2 22 1E 00 0A 60 1E ?? ?? ?? ?? D0 04 00 5C 00 20 70 1E 6D 01 00 54 ?? ?? ?? ?? E1 03 42 2D ?? ?? ?? ?? 46 00 80 52 45 04 80 52 24 02 80 52 63 00 80 52 A1 03 80 52 33 FB FF 34 D6 FF FF 17 70 03 00 5C 00 20 70 1E C2 01 00 54 ?? ?? ?? ?? E1 03 42 2D ?? ?? ?? ?? 46 00 80 52 45 04 80 52 44 02 80 52 83 00 80 52 A1 03 80 52 73 00 00 34 02 00 B0 D2 5E FF FF 17 02 00 80 D2 5C FF FF 17 93 00 00 34 10 40 61 1E 00 42 62 1E 02 00 00 14 00 40 62 1E FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 00 00 00 E0 FF FF EF 47 00 00 00 00 00 00 A0 36 00 00 00 80 }
	condition:
		$1
}

rule file_230_0_0 {
	meta:
		name = "fmaxf"
		size = 96
		refs = "0010 _fdtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 02 2D ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 17 40 BD 0E 00 00 14 E0 53 00 91 ?? ?? ?? ?? E0 13 40 BD 1F 08 00 71 20 01 00 54 F0 17 40 BD 00 20 30 1E A3 00 00 54 00 20 30 1E 81 00 00 54 E8 27 40 79 48 00 78 36 00 42 20 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_231_0_0 {
	meta:
		name = "??$?B$$A6AH_K@Z@__crt_fast_encoded_nullptr_t@@QEBAP6AH_K@ZXZ"
		size = 36
		refs = "0000 __security_cookie"
		altNames = "??$?B$$A6AHPEA_WK_J@Z@__crt_fast_encoded_nullptr_t@@QEBAP6AHPEA_WK_J@ZXZ ??$?B$$A6AXH@Z@__crt_fast_encoded_nullptr_t@@QEBAP6AXH@ZXZ ??$?B$$A6AXPEAXK0@Z@__crt_fast_encoded_nullptr_t@@QEBAP6AXPEAXK0@ZXZ ??$?B$$A6AXXZ@__crt_fast_encoded_nullptr_t@@QEBAP6AXXZXZ ??$?BP6AXXZ@__crt_fast_encoded_nullptr_t@@QEBAPEAP6AXXZXZ ??$?BX@__crt_fast_encoded_nullptr_t@@QEBAPEAXXZ ?_set_new_handler@@YAP6AH_K@ZH@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 0A 08 80 52 08 00 80 D2 69 15 00 12 4A 01 09 4B 08 2D CA 9A 00 01 0B CA C0 03 5F D6 }
	condition:
		$1
}

rule file_231_1_0 {
	meta:
		name = "??$__crt_fast_decode_pointer@P6AH_K@Z@@YAP6AH_K@ZQ6AH0@Z@Z"
		size = 24
		refs = "0000 __security_cookie"
		altNames = "??$__crt_fast_decode_pointer@P6AHPEAU_exception@@@Z@@YAP6AHPEAU_exception@@@ZQ6AH0@Z@Z ??$__crt_fast_decode_pointer@P6AHPEA_WK_J@Z@@YAP6AHPEA_WK_J@ZQ6AH0K1@Z@Z ??$__crt_fast_decode_pointer@P6AXH@Z@@YAP6AXH@ZQ6AXH@Z@Z ??$__crt_fast_decode_pointer@P6AXPEAXK0@Z@@YAP6AXPEAXK0@ZQ6AX0K0@Z@Z ??$__crt_fast_decode_pointer@P6AXPEB_W00I_K@Z@@YAP6AXPEB_W00I_K@ZQ6AX000I1@Z@Z ??$__crt_fast_decode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_decode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z ??$__crt_fast_decode_pointer@PEAX@@YAPEAXQEAX@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 2A 15 00 12 29 01 00 CA 20 2D CA 9A C0 03 5F D6 }
	condition:
		$1
}

rule file_231_2_0 {
	meta:
		name = "??$__crt_fast_encode_pointer@P6AH_K@Z@@YAP6AH_K@ZQ6AH0@Z@Z"
		size = 32
		refs = "0000 __security_cookie"
		altNames = "??$__crt_fast_encode_pointer@P6AHPEAU_exception@@@Z@@YAP6AHPEAU_exception@@@ZQ6AH0@Z@Z ??$__crt_fast_encode_pointer@P6AHPEA_WK_J@Z@@YAP6AHPEA_WK_J@ZQ6AH0K1@Z@Z ??$__crt_fast_encode_pointer@P6AHXZ@@YAP6AHXZQ6AHXZ@Z ??$__crt_fast_encode_pointer@P6AXH@Z@@YAP6AXH@ZQ6AXH@Z@Z ??$__crt_fast_encode_pointer@P6AXPEAXK0@Z@@YAP6AXPEAXK0@ZQ6AX0K0@Z@Z ??$__crt_fast_encode_pointer@P6AXPEB_W00I_K@Z@@YAP6AXPEB_W00I_K@ZQ6AX000I1@Z@Z ??$__crt_fast_encode_pointer@P6AXXZ@@YAP6AXXZQ6AXXZ@Z ??$__crt_fast_encode_pointer@PEAP6AXXZ@@YAPEAP6AXXZQEAP6AXXZ@Z ??$__crt_fast_encode_pointer@PEAX@@YAPEAXQEAX@Z"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 0B 08 80 52 49 15 00 12 69 01 09 4B 08 2C C9 9A 00 01 0A CA C0 03 5F D6 }
	condition:
		$1
}

rule file_231_3_0 {
	meta:
		name = "?__crt_fast_encode_pointer@@YA?AU__crt_fast_encoded_nullptr_t@@$$T@Z"
		size = 16
	strings:
		$1 = { FF 43 00 D1 E0 03 40 39 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_231_10_0 {
	meta:
		name = "_callnewh"
		size = 80
		refs = "0010 _query_new_handler 001c __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 ?? ?? ?? ?? 13 00 00 91 53 01 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 6F 02 00 91 00 01 3F D6 80 02 00 91 60 02 3F D6 60 00 00 34 20 00 80 52 02 00 00 14 00 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_231_11_0 {
	meta:
		name = "_query_new_handler"
		size = 72
		refs = "0010 __acrt_lock 0014 __security_cookie 0020 ?__acrt_new_handler@@3V?$dual_state_global@P6AH_K@Z@__crt_state_management@@A 0034 __acrt_unlock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2B 15 00 12 ?? ?? ?? ?? ?? ?? ?? ?? 2A 01 08 CA 53 2D CB 9A 00 00 80 52 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_231_12_0 {
	meta:
		name = "_query_new_handler$fin$0"
		size = 32
		refs = "000c __acrt_unlock"
		altNames = "_set_new_handler$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 00 00 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_231_13_0 {
	meta:
		name = "_set_new_handler"
		size = 96
		refs = "0014 __acrt_lock 0018 __security_cookie 0024 ?__acrt_new_handler@@3V?$dual_state_global@P6AH_K@Z@__crt_state_management@@A 004c __acrt_unlock"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 8B 15 00 12 ?? ?? ?? ?? ?? ?? ?? ?? 8A 01 08 CA 54 2D CB 9A 08 08 80 52 08 01 0B 4B 69 2E C8 9A 28 01 0C CA ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_232_1_0 {
	meta:
		name = "??$__crt_time_elapsed_leap_years@_J@@YA_J_J@Z"
		size = 48
	strings:
		$1 = { 08 AC 04 91 09 32 80 D2 0A 04 00 D1 09 0D C9 9A 8B 0C 80 D2 48 0D CB 9A 2B 01 08 CB 49 FD 41 93 4A F9 49 8B 68 09 8A 8B 00 45 00 D1 C0 03 5F D6 }
	condition:
		$1
}

rule file_232_3_0 {
	meta:
		name = "??$__crt_time_is_leap_year@_J@@YA_N_J@Z"
		size = 72
	strings:
		$1 = { 08 FC 41 93 09 F8 48 8B 2A FD 42 93 0B 08 0A CB EB 00 00 B5 89 0C 80 D2 08 0C C9 9A 09 81 09 9B 69 00 00 B4 20 00 80 52 07 00 00 14 09 B0 1D 91 0A 32 80 D2 28 0D CA 9A 09 A5 0A 9B 3F 01 00 F1 E0 17 9F 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_232_4_0 {
	meta:
		name = "??$common_mktime@J@@YAJQEAUtm@@_N@Z"
		size = 812
		refs = "0014 __security_push_cookie 0028 _errno 0034 _invalid_parameter_noinfo 00a0 _days 00b0 ??$__crt_time_is_leap_year@J@@YA_NJ@Z 0140 __security_pop_cookie 0244 __tzset 0250 _get_dstbias 025c _get_timezone 0278 _localtime32_s 02c8 _gmtime32_s 0308 _invoke_watson"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 00 D1 15 00 00 91 37 00 00 11 D5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 40 00 00 14 B4 16 40 B9 F4 03 00 B9 9F 16 01 71 2B 07 00 54 9F 2E 02 71 E8 06 00 54 A9 12 40 B9 3F 2D 00 71 09 02 00 54 8A 01 80 52 28 0D CA 1A 0A A5 0A 1B 14 01 14 0B F4 03 00 B9 AA 12 00 B9 AA 00 F8 36 48 31 00 11 94 06 00 51 A8 12 00 B9 F4 03 00 B9 9F 16 01 71 EB 04 00 54 9F 2E 02 71 A8 04 00 54 B3 12 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 80 02 00 11 16 D9 73 B8 ?? ?? ?? ?? 1F 00 00 71 6E 1A 41 7A 4D 00 00 54 D6 06 00 11 2E 13 00 18 88 AE 04 11 08 7D 2E 9B 8D 06 00 51 09 FD 60 D3 A8 7D 2E 9B 2B 7D 07 13 09 FD 60 D3 6C 7D 4B 0B 2B 7D 05 13 68 7D 4B 0B A9 7D 01 13 AA 79 49 0B AB 2D 80 52 8C 01 08 4B 88 09 8A 0B EA 7B 8C 52 88 22 0B 1B 09 01 16 0B A8 0E 40 B9 2A 01 0A 4B 49 01 08 0B E9 03 00 B9 CA 01 F8 37 E8 01 F8 37 C9 01 F8 36 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 80 12 FF C3 00 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 48 00 F8 36 89 FE FF 36 28 05 09 0B 0B 71 1D 53 A9 00 00 34 68 0D C9 1A 1F 61 00 71 EA 07 9F 1A 02 00 00 14 0A 00 80 52 6A FD FF 35 A8 0A 40 B9 0A 01 0B 0B EA 03 00 B9 8B 00 F8 37 A8 00 F8 37 AA FC FF 37 03 00 00 14 48 00 F8 36 4A FC FF 36 48 6D 1C 53 09 01 0A 4B 2B 75 1E 53 AA 00 00 34 68 0D CA 1A 1F F1 00 71 E9 07 9F 1A 02 00 00 14 09 00 80 52 09 FB FF 35 A8 06 40 B9 0A 01 0B 0B EA 03 00 B9 8B 00 F8 37 A8 00 F8 37 4A FA FF 37 03 00 00 14 48 00 F8 36 EA F9 FF 36 48 6D 1C 53 09 01 0A 4B 2B 75 1E 53 AA 00 00 34 68 0D CA 1A 1F F1 00 71 E9 07 9F 1A 02 00 00 14 09 00 80 52 A9 F8 FF 35 A9 02 40 B9 28 01 0B 0B E8 03 00 B9 8B 00 F8 37 A9 00 F8 37 E8 F7 FF 37 03 00 00 14 49 00 F8 36 88 F7 FF 36 17 04 00 34 ?? ?? ?? ?? E0 23 00 91 FF FF 00 29 ?? ?? ?? ?? C0 05 00 35 E0 13 00 91 ?? ?? ?? ?? A0 04 00 35 E8 27 40 29 E1 03 00 91 E0 43 00 91 28 01 08 0B E8 03 00 B9 ?? ?? ?? ?? 80 F5 FF 35 A8 22 40 B9 1F 01 00 71 AC 00 00 54 28 02 F8 36 E8 33 40 B9 1F 01 00 71 CD 01 00 54 E8 03 40 B9 E1 03 00 91 E9 0B 40 B9 E0 43 00 91 28 01 08 0B E8 03 00 B9 ?? ?? ?? ?? C0 00 00 34 9C FF FF 17 E1 03 00 91 E0 43 00 91 ?? ?? ?? ?? 00 F3 FF 35 EC 43 00 91 E0 03 40 B9 88 25 40 A9 8A 2D 41 A9 A8 26 00 A9 88 21 40 B9 AA 2E 01 A9 A8 22 00 B9 93 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 1F 20 03 D5 1F 85 EB 51 }
	condition:
		$1
}

rule file_232_5_0 {
	meta:
		name = "??$common_mktime@_J@@YA_JQEAUtm@@_N@Z"
		size = 780
		refs = "0014 __security_push_cookie 0028 _errno 0034 _invalid_parameter_noinfo 00a0 _days 00b0 ??$__crt_time_is_leap_year@_J@@YA_N_J@Z 012c __security_pop_cookie 0228 __tzset 0234 _get_dstbias 0240 _get_timezone 0260 _localtime64_s 02b0 _gmtime64_s 02f0 _invoke_watson"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 00 D1 15 00 00 91 37 00 00 11 D5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 3B 00 00 14 B4 16 80 B9 F4 03 00 F9 9F 16 01 F1 8B 06 00 54 9F 3A 11 F1 48 06 00 54 A9 12 40 B9 3F 2D 00 71 09 02 00 54 8A 01 80 52 28 0D CA 1A 0A A5 0A 1B 94 C2 28 8B AA 12 00 B9 F4 03 00 F9 AA 00 F8 36 48 31 00 11 94 06 00 D1 A8 12 00 B9 F4 03 00 F9 9F 16 01 F1 4B 04 00 54 9F 3A 11 F1 08 04 00 54 B3 12 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 80 02 00 91 16 D9 B3 B8 ?? ?? ?? ?? 1F 00 00 71 6E 1A 41 7A 4D 00 00 54 D6 06 00 91 88 AE 04 91 09 32 80 D2 8A 06 00 D1 09 0D C9 9A 8B 0C 80 D2 48 0D CB 9A AC 2D 80 D2 2B 01 08 CB 49 FD 41 93 4A F9 49 8B 68 09 8A 8B AB 0E 80 B9 EA 7B 8C D2 88 22 0C 9B 09 01 16 8B 2A 01 0A CB 48 01 0B 8B E8 03 00 F9 CA 01 F8 B7 EB 01 F8 B7 C8 01 F8 B6 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 80 92 FF C3 00 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 4B 00 F8 B6 88 FE FF B6 09 03 80 D2 0A 7D 09 9B A8 00 00 B4 48 0D C8 9A 1F 61 00 F1 E9 07 9F 1A 02 00 00 14 09 00 80 52 69 FD FF 35 A9 0A 80 B9 28 01 0A 8B E8 03 00 F9 8A 00 F8 B7 A9 00 F8 B7 A8 FC FF B7 03 00 00 14 49 00 F8 B6 48 FC FF B6 89 07 80 D2 0A 7D 09 9B A8 00 00 B4 48 0D C8 9A 1F F1 00 F1 E9 07 9F 1A 02 00 00 14 09 00 80 52 29 FB FF 35 A9 06 80 B9 28 01 0A 8B E8 03 00 F9 8A 00 F8 B7 A9 00 F8 B7 68 FA FF B7 03 00 00 14 49 00 F8 B6 08 FA FF B6 89 07 80 D2 0A 7D 09 9B A8 00 00 B4 48 0D C8 9A 1F F1 00 F1 E9 07 9F 1A 02 00 00 14 09 00 80 52 E9 F8 FF 35 A9 02 80 B9 28 01 0A 8B E8 03 00 F9 8A 00 F8 B7 A9 00 F8 B7 28 F8 FF B7 03 00 00 14 49 00 F8 B6 C8 F7 FF B6 37 04 00 34 ?? ?? ?? ?? E0 33 00 91 FF 7F 01 29 ?? ?? ?? ?? E0 05 00 35 E0 23 00 91 ?? ?? ?? ?? C0 04 00 35 E8 03 40 F9 E1 03 00 91 E9 0B 40 B9 E0 43 00 91 08 C1 29 8B E8 03 00 F9 ?? ?? ?? ?? A0 F5 FF 35 A8 22 40 B9 1F 01 00 71 AC 00 00 54 28 02 F8 36 E8 33 40 B9 1F 01 00 71 CD 01 00 54 E8 03 40 F9 E1 03 00 91 E9 0F 40 B9 E0 43 00 91 08 C1 29 8B E8 03 00 F9 ?? ?? ?? ?? C0 00 00 34 9D FF FF 17 E1 03 00 91 E0 43 00 91 ?? ?? ?? ?? 20 F3 FF 35 EC 43 00 91 E0 03 40 F9 88 25 40 A9 8A 2D 41 A9 A8 26 00 A9 88 21 40 B9 AA 2E 01 A9 A8 22 00 B9 94 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_233_5_0 {
	meta:
		name = "_fcloseall"
		size = 224
		refs = "0020 __acrt_lock 0028 __imp_DeleteCriticalSection 002c __piob 0030 _nstream 006c fclose 00a0 _free_base 00c4 __acrt_unlock"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 14 00 80 52 BF 13 00 B9 00 01 80 52 ?? ?? ?? ?? 73 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? B3 17 00 B9 7F 02 09 6B E0 03 00 54 48 D9 73 F8 48 00 00 B5 1A 00 00 14 A8 0F 00 F9 08 15 40 B9 BF 3B 03 D5 08 01 68 36 ?? ?? ?? ?? 00 D9 73 F8 ?? ?? ?? ?? 1F 04 00 31 60 00 00 54 88 06 00 11 A8 13 00 B9 ?? ?? ?? ?? 2A D9 73 F8 40 C1 00 91 ?? ?? ?? ?? 6C FD DF C8 80 01 3F D6 ?? ?? ?? ?? 00 D9 73 F8 ?? ?? ?? ?? ?? ?? ?? ?? 1F D9 33 F8 B4 13 40 B9 ?? ?? ?? ?? ?? ?? ?? ?? 73 06 00 11 E0 FF FF 17 00 01 80 52 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_234_0_0 {
	meta:
		name = "_fpclass"
		size = 172
		refs = "0020 _sptype"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD 0A FE 8F 52 E9 2F 40 79 28 29 1C 12 1F 01 0A 6B E1 01 00 54 ?? ?? ?? ?? 1F 04 00 71 40 01 00 54 1F 08 00 71 C0 00 00 54 1F 0C 00 71 29 00 80 52 48 00 80 52 20 11 88 1A 18 00 00 14 80 00 80 52 16 00 00 14 00 40 80 52 14 00 00 14 29 01 11 72 28 01 00 35 E8 17 40 B9 08 4D 00 12 68 00 00 35 E8 13 40 B9 88 00 00 34 0A 02 80 52 08 10 80 52 09 00 00 14 08 20 60 1E 81 00 00 54 0A 04 80 52 08 08 80 52 03 00 00 14 0A 01 80 52 08 20 80 52 3F 01 00 71 40 11 88 1A FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_234_1_0 {
	meta:
		name = "_isnan"
		size = 80
	strings:
		$1 = { FF 43 00 D1 E0 03 00 FD 0A FE 8F 52 E8 0F 40 79 09 2D 1D 12 3F 01 0A 6B C1 00 00 54 E8 07 40 B9 08 49 00 12 C8 00 00 35 E8 03 40 B9 88 00 00 35 08 FF 8F 52 3F 01 08 6B 61 00 00 54 20 00 80 52 02 00 00 14 00 00 80 52 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_236_10_0 {
	meta:
		name = "__acrt_locale_free_monetary"
		size = 300
		refs = "0014 __acrt_lconv_c 002c _free_base"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 93 08 00 B4 ?? ?? ?? ?? 60 0E 40 F9 ?? ?? ?? ?? 88 0E 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 12 40 F9 88 12 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 16 40 F9 88 16 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 1A 40 F9 88 1A 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 1E 40 F9 88 1E 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 22 40 F9 88 22 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 26 40 F9 88 26 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 36 40 F9 88 36 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 3A 40 F9 88 3A 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 3E 40 F9 88 3E 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 42 40 F9 88 42 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 46 40 F9 88 46 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 60 4A 40 F9 88 4A 40 F9 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_236_11_0 {
	meta:
		name = "__acrt_locale_initialize_monetary"
		size = 1304
		refs = "003c __acrt_lconv_c 0054 _calloc_base 0064 _free_base 00f4 __acrt_GetLocaleInfoA 03b0 __acrt_locale_free_monetary"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 73 04 A9 FD 7B B9 A9 FD 03 00 91 13 00 00 91 F3 7F 01 A9 68 A2 40 F9 F3 33 00 F9 15 00 80 D2 E8 00 00 B5 68 A6 40 F9 A8 00 00 B5 ?? ?? ?? ?? ?? ?? ?? ?? 16 00 80 D2 04 01 00 14 01 13 80 D2 20 00 80 D2 ?? ?? ?? ?? 14 00 00 91 00 00 80 D2 F4 13 00 F9 ?? ?? ?? ?? 74 00 00 B5 20 00 80 52 10 01 00 14 81 00 80 D2 20 00 80 D2 ?? ?? ?? ?? 16 00 00 91 00 00 80 D2 F6 2F 00 F9 ?? ?? ?? ?? 96 00 00 B5 80 02 00 91 ?? ?? ?? ?? F4 FF FF 17 68 A2 40 F9 48 22 00 B4 81 00 80 D2 20 00 80 D2 ?? ?? ?? ?? 15 00 00 91 00 00 80 D2 F5 2B 00 F9 ?? ?? ?? ?? B5 00 00 B5 80 02 00 91 ?? ?? ?? ?? C0 02 00 91 F1 FF FF 17 73 A2 40 F9 84 62 00 91 A3 02 80 52 21 00 80 52 E0 43 00 91 62 02 00 91 F3 37 00 F9 ?? ?? ?? ?? 84 82 00 91 E0 4F 00 B9 83 02 80 52 E0 43 00 91 62 02 00 91 21 00 80 52 ?? ?? ?? ?? 84 A2 00 91 E0 4B 00 B9 C3 02 80 52 E0 43 00 91 62 02 00 91 21 00 80 52 ?? ?? ?? ?? 84 C2 00 91 E0 47 00 B9 E3 02 80 52 E0 43 00 91 62 02 00 91 21 00 80 52 ?? ?? ?? ?? 84 E2 00 91 E0 43 00 B9 03 03 80 52 E0 43 00 91 62 02 00 91 21 00 80 52 ?? ?? ?? ?? 84 02 01 91 E0 3F 00 B9 03 0A 80 52 E0 43 00 91 62 02 00 91 21 00 80 52 ?? ?? ?? ?? 84 22 01 91 E0 3B 00 B9 23 0A 80 52 E0 43 00 91 62 02 00 91 21 00 80 52 ?? ?? ?? ?? 84 42 01 91 E0 37 00 B9 43 03 80 52 E0 43 00 91 62 02 00 91 01 00 80 52 ?? ?? ?? ?? 84 46 01 91 E0 33 00 B9 23 03 80 52 E0 43 00 91 62 02 00 91 01 00 80 52 ?? ?? ?? ?? 84 4A 01 91 E0 2F 00 B9 83 0A 80 52 E0 43 00 91 62 02 00 91 01 00 80 52 ?? ?? ?? ?? 84 4E 01 91 E0 2B 00 B9 A3 0A 80 52 E0 43 00 91 62 02 00 91 01 00 80 52 ?? ?? ?? ?? 84 52 01 91 1C 00 00 11 C3 0A 80 52 62 02 00 91 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 84 56 01 91 1B 00 00 11 E0 43 00 91 E3 0A 80 52 62 02 00 91 01 00 80 52 ?? ?? ?? ?? 84 5A 01 91 1A 00 00 11 E0 43 00 91 43 0A 80 52 62 02 00 91 01 00 80 52 ?? ?? ?? ?? 84 5E 01 91 19 00 00 11 E0 43 00 91 63 0A 80 52 62 02 00 91 01 00 80 52 ?? ?? ?? ?? 84 A2 01 91 18 00 00 11 E0 43 00 91 A3 02 80 52 62 02 00 91 41 00 80 52 ?? ?? ?? ?? 84 C2 01 91 17 00 00 11 E0 43 00 91 83 02 80 52 62 02 00 91 41 00 80 52 ?? ?? ?? ?? 84 E2 01 91 16 00 00 11 E0 43 00 91 C3 02 80 52 62 02 00 91 41 00 80 52 ?? ?? ?? ?? 84 02 02 91 15 00 00 11 E0 43 00 91 E3 02 80 52 62 02 00 91 41 00 80 52 ?? ?? ?? ?? E8 13 40 F9 03 0A 80 52 14 00 00 11 62 02 00 91 41 00 80 52 04 21 02 91 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 23 0A 80 52 E2 37 40 F9 13 00 00 11 41 00 80 52 E0 43 00 91 04 41 02 91 ?? ?? ?? ?? 08 00 13 2A 09 01 14 2A 2A 01 15 2A 4B 01 16 2A 68 01 17 2A 09 01 18 2A 2A 01 19 2A 4B 01 1A 2A EA 2B 40 B9 68 01 1B 2A 09 01 1C 2A 2A 01 0A 2A EB A3 45 29 E9 37 40 B9 4B 01 0B 2A EA 3B 40 B9 68 01 08 2A EB 3F 40 B9 09 01 09 2A E8 43 40 B9 2A 01 0A 2A E9 47 40 B9 4B 01 0B 2A EA 4B 40 B9 68 01 08 2A EB 4F 40 B9 09 01 09 2A 2A 01 0A 2A 4B 01 0B 2A 4B 01 00 34 F3 13 40 F9 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? E0 2F 40 F9 ?? ?? ?? ?? E0 2B 40 F9 34 FF FF 17 F4 13 40 F9 8D 1E 40 F9 A8 01 C0 39 68 01 00 34 AB 01 C0 39 69 41 03 11 2A 1D 00 53 5F 25 00 71 08 07 00 54 6B C1 00 51 AB 01 00 39 AD 05 00 91 A9 01 C0 39 E9 FE FF 35 F5 5B 45 A9 F3 33 40 F9 68 7E 40 F9 09 01 40 F9 89 02 00 F9 6A 7E 40 F9 48 05 40 F9 88 06 00 F9 69 7E 40 F9 2A 09 40 F9 8A 0A 00 F9 68 7E 40 F9 09 2D 40 F9 89 2E 00 F9 6A 7E 40 F9 29 00 80 52 48 31 40 F9 88 32 00 F9 C9 02 00 B9 55 00 00 B4 A9 02 00 B9 6B 7A 40 F9 CB 00 00 B4 69 FD 5F 88 29 05 00 51 69 FD 08 88 A8 FF FF 35 BF 3B 03 D5 6A 72 40 F9 6A 01 00 B4 49 FD 5F 88 2C 05 00 51 4C FD 09 88 A9 FF FF 35 BF 3B 03 D5 AC 00 00 35 60 7E 40 F9 ?? ?? ?? ?? 60 72 40 F9 ?? ?? ?? ?? 75 52 0F A9 00 00 80 52 76 72 00 F9 FD 7B C7 A8 FB 73 44 A9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 7F ED 00 71 41 F9 FF 54 AE 01 00 91 C8 05 C0 39 C8 01 00 39 CC 1D C0 38 AC FF FF 35 C5 FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 6C 41 02 91 8F 02 00 91 68 29 C1 A8 E8 29 81 A8 7F 01 0C EB A1 FF FF 54 68 01 40 F9 E8 01 00 F9 BE FF FF 17 }
	condition:
		$1
}

rule file_236_12_0 {
	meta:
		name = "fix_grouping"
		size = 84
	strings:
		$1 = { 08 00 C0 39 68 01 00 34 0B 00 C0 39 69 41 03 11 2A 1D 00 53 5F 25 00 71 E8 00 00 54 6B C1 00 51 0B 00 00 39 00 04 00 91 09 00 C0 39 E9 FE FF 35 C0 03 5F D6 7F ED 00 71 61 FF FF 54 0D 00 00 91 A8 05 C0 39 A8 01 00 39 AC 1D C0 38 AC FF FF 35 F6 FF FF 17 }
	condition:
		$1
}

rule file_237_0_0 {
	meta:
		name = "??$common_getpath@D@@YAPEADQEBDQEAD_K@Z"
		size = 256
		refs = "000c _errno"
		altNames = "__acrt_getpath"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 C1 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 80 D2 37 00 00 14 42 00 00 B4 3F 00 00 39 5F 04 00 F1 09 FF FF 54 08 00 C0 39 1F ED 00 71 A1 00 00 54 00 04 00 91 09 00 C0 39 3F ED 00 71 A0 FF FF 54 28 00 02 8B 0B 05 00 D1 0C 00 00 91 0A 00 C0 39 AA 03 00 34 5F ED 00 71 C0 03 00 54 5F 89 00 71 00 04 00 91 01 02 00 54 09 00 C0 39 C9 02 00 34 3F 89 00 71 00 01 00 54 29 00 00 39 21 04 00 91 3F 00 0B EB 00 04 00 91 60 01 00 54 09 00 C0 39 09 FF FF 35 08 00 C0 39 68 01 00 34 00 04 00 91 EB FF FF 17 2A 00 00 39 21 04 00 91 3F 00 0B EB E1 FC FF 54 3F 00 00 39 ?? ?? ?? ?? 48 04 80 52 D2 FF FF 17 08 00 C0 39 1F ED 00 71 A1 00 00 54 00 04 00 91 09 00 C0 39 3F ED 00 71 A0 FF FF 54 1F 00 0C EB 3F 00 00 39 E0 03 80 9A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_237_1_0 {
	meta:
		name = "??$common_getpath@_W@@YAPEA_WQEB_WQEA_W_K@Z"
		size = 256
		refs = "000c _errno"
		altNames = "__acrt_wgetpath"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 C1 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 80 D2 37 00 00 14 42 00 00 B4 3F 00 00 79 5F 04 00 F1 09 FF FF 54 08 00 40 79 1F ED 00 71 A1 00 00 54 00 08 00 91 09 00 40 79 3F ED 00 71 A0 FF FF 54 28 04 02 8B 0C 00 00 91 0B 09 00 D1 0A 00 40 79 AA 03 00 34 5F ED 00 71 C0 03 00 54 5F 89 00 71 00 08 00 91 01 02 00 54 09 00 40 79 C9 02 00 34 3F 89 00 71 00 01 00 54 29 00 00 79 21 08 00 91 3F 00 0B EB 00 08 00 91 60 01 00 54 09 00 40 79 09 FF FF 35 08 00 40 79 68 01 00 34 00 08 00 91 EB FF FF 17 2A 00 00 79 21 08 00 91 3F 00 0B EB E1 FC FF 54 3F 00 00 79 ?? ?? ?? ?? 48 04 80 52 D2 FF FF 17 08 00 40 79 1F ED 00 71 A1 00 00 54 00 08 00 91 09 00 40 79 3F ED 00 71 A0 FF FF 54 1F 00 0C EB 3F 00 00 79 E0 03 80 9A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_238_0_0 {
	meta:
		name = "_fderfc"
		size = 124
		refs = "004c _fdexp"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 10 88 20 1E 01 00 80 52 91 02 00 1C E0 43 00 91 74 02 00 1C F0 13 00 BD 50 02 00 1C 12 C0 11 1F 31 02 00 1C 53 46 00 1F 12 02 00 1C 76 4A 00 1F F3 01 00 1C 15 4C 14 1F D4 01 00 1C B5 52 00 1F C0 1A 35 1E ?? ?? ?? ?? E0 13 40 BD FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 F6 AE 47 39 0B BE 3C 3F BB 89 5C 3B 8A EF C7 3E 66 C7 53 3F 6E 61 A3 3F 1A 8A 57 3F }
	condition:
		$1
}

rule file_238_1_0 {
	meta:
		name = "erff"
		size = 260
		refs = "0010 _fdtest 002c _fderf_small 0088 _fderf_one 0098 _fderfc"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 13 00 BD ?? ?? ?? ?? 20 06 00 34 1F 04 00 71 20 05 00 54 1F 08 00 71 A0 05 00 54 FB 13 40 BD ?? ?? ?? ?? ?? ?? ?? ?? 60 C3 20 1E 00 20 30 1E 62 02 00 54 79 0B 3B 1E 32 05 00 1C 31 05 00 1C 35 05 00 1C 1A 10 2E 1E 33 47 12 1F F2 04 00 1C 74 4A 19 1F D3 04 00 1C 98 4E 19 1F B4 04 00 1C 36 53 15 1F 95 04 00 1C D7 56 19 1F F0 6A 19 1F 17 1B 30 1E E0 0A 3B 1E 16 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 00 20 31 1E C2 00 00 54 ?? ?? ?? ?? 1A 10 2E 1E FB 13 40 BD 5A 3B 20 1E 02 00 00 14 1A 10 2E 1E 50 43 21 1E 68 23 20 1E 00 3E 3A 1E 08 00 00 14 E8 27 40 79 11 10 3E 1E 1A 10 2E 1E 1F 01 11 72 20 1E 3A 1E 02 00 00 14 E0 13 40 BD FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 C7 0D 89 39 A6 AB 13 3D 1F 7F D0 3B EE 78 06 3E BB 6E 90 3F 19 A2 A7 3D DE 40 E6 3E }
	condition:
		$1
}

rule file_239_15_0 {
	meta:
		name = "___lc_codepage_func"
		size = 44
		refs = "0008 __acrt_getptd 0018 __acrt_update_locale_info"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? E1 43 00 91 08 48 40 F9 E8 0B 00 F9 ?? ?? ?? ?? E8 0B 40 F9 00 0D 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_239_16_0 {
	meta:
		name = "___lc_collate_cp_func"
		size = 44
		refs = "0008 __acrt_getptd 0018 __acrt_update_locale_info"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? E1 43 00 91 08 48 40 F9 E8 0B 00 F9 ?? ?? ?? ?? E8 0B 40 F9 00 15 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_239_17_0 {
	meta:
		name = "___lc_locale_name_func"
		size = 44
		refs = "0008 __acrt_getptd 0018 __acrt_update_locale_info"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? E1 43 00 91 08 48 40 F9 E8 0B 00 F9 ?? ?? ?? ?? E8 0B 40 F9 00 A1 04 91 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_239_18_0 {
	meta:
		name = "___mb_cur_max_func"
		size = 44
		refs = "0008 __acrt_getptd 0018 __acrt_update_locale_info"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? E1 43 00 91 08 48 40 F9 E8 0B 00 F9 ?? ?? ?? ?? E8 0B 40 F9 00 09 40 B9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_239_19_0 {
	meta:
		name = "___mb_cur_max_l_func"
		size = 20
		refs = "0004 ___mb_cur_max_func"
	strings:
		$1 = { 40 00 00 B5 ?? ?? ?? ?? 08 00 40 F9 00 09 40 B9 C0 03 5F D6 }
	condition:
		$1
}

rule file_239_20_0 {
	meta:
		name = "__acrt_locale_initialize_ctype"
		size = 1132
		refs = "001c __security_push_cookie 0060 __acrt_GetLocaleInfoA 0070 _calloc_base 007c _free_base 010c __imp_GetCPInfo 015c __acrt_LCMapStringA 01fc __acrt_GetStringTypeA 0414 __newctype 0424 __newcumap 042c __newclmap 044c __security_pop_cookie"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 73 05 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 01 D1 13 00 00 91 F3 FF 01 A9 62 9E 40 F9 14 00 80 D2 17 00 80 D2 16 00 80 D2 15 00 80 D2 C2 1D 00 B4 68 0E 40 B9 18 00 80 D2 E8 00 00 35 64 32 00 91 83 00 82 52 01 00 80 52 E0 63 00 91 ?? ?? ?? ?? 20 1B 00 35 81 00 80 D2 20 00 80 D2 ?? ?? ?? ?? 18 00 00 91 00 00 80 D2 ?? ?? ?? ?? 41 00 80 D2 00 30 80 D2 ?? ?? ?? ?? 14 00 00 91 00 00 80 D2 ?? ?? ?? ?? 21 00 80 D2 00 30 80 D2 ?? ?? ?? ?? 17 00 00 91 00 00 80 D2 ?? ?? ?? ?? 21 00 80 D2 00 30 80 D2 ?? ?? ?? ?? 16 00 00 91 00 00 80 D2 ?? ?? ?? ?? 21 00 80 D2 20 20 80 D2 ?? ?? ?? ?? 15 00 00 91 00 00 80 D2 ?? ?? ?? ?? 58 17 00 B4 34 17 00 B4 15 17 00 B4 F7 16 00 B4 D6 16 00 B4 A9 02 00 91 08 00 80 52 28 15 00 38 08 05 00 11 1F 01 04 71 AB FF FF 54 ?? ?? ?? ?? 60 0E 40 B9 ?? ?? ?? ?? 09 FD DF C8 E1 A3 00 91 20 01 3F D6 20 15 00 34 E8 2B 40 B9 1F 15 00 71 C8 14 00 54 67 0E 40 B9 E6 1F 80 52 FF 03 00 F9 61 9E 40 F9 E5 06 02 91 E4 1F 80 52 A3 06 00 91 02 20 80 52 00 00 80 D2 19 3D 00 53 ?? ?? ?? ?? 40 13 00 34 67 0E 40 B9 E6 1F 80 52 FF 03 00 F9 61 9E 40 F9 C5 06 02 91 E4 1F 80 52 A3 06 00 91 02 40 80 52 00 00 80 D2 ?? ?? ?? ?? E0 11 00 34 3F 07 00 71 2D 02 00 54 E8 BB 40 39 E8 01 00 34 E9 BF 00 91 2B 25 40 38 8B 01 00 34 2A D1 5F 38 5F 01 0B 6B EC 00 00 54 08 04 80 52 A8 CA 2A 38 28 E1 5F 38 4A 05 00 11 5F 01 08 6B 6D FF FF 54 28 F1 5F 38 88 FE FF 35 65 0E 40 B9 88 02 04 91 06 00 80 52 E8 0B 00 F9 04 01 00 91 03 20 80 52 A2 02 00 91 21 00 80 52 00 00 80 D2 ?? ?? ?? ?? 40 0E 00 34 9A FA 03 91 5F 03 00 79 FB 02 02 91 FF FE 01 39 DC 02 02 91 DF FE 01 39 3F 07 00 71 7F 03 00 39 9F 03 00 39 6D 02 00 54 E8 BB 40 39 28 02 00 34 E9 BF 00 91 2B 25 40 38 CB 01 00 34 2A D1 5F 38 5F 01 0B 6B 2C 01 00 54 4B 01 02 11 08 00 90 52 88 DA 2B 78 28 E1 5F 38 4A 05 00 11 6B 05 00 11 5F 01 08 6B 4D FF FF 54 28 F1 5F 38 48 FE FF 35 8B 02 08 91 6C C1 03 91 69 29 C1 A8 89 2A 81 A8 7F 01 0C EB A1 FF FF 54 68 01 40 F9 69 09 40 B9 88 02 00 F9 68 19 C0 79 89 0A 00 B9 88 1A 00 79 E9 2A 50 A9 E8 2E 51 A9 E9 2A 00 A9 E9 2A 52 A9 E8 2E 01 A9 E8 2E 53 A9 E9 2A 02 A9 E9 2A 54 A9 E8 2E 03 A9 E8 2E 55 A9 E9 2A 04 A9 E9 2A 56 A9 E8 2E 05 A9 E8 BA 40 F9 E9 2A 06 A9 E9 7A 41 B9 E8 3A 00 F9 E8 FA C2 79 E9 7A 00 B9 E9 FA C5 39 E8 FA 00 79 E9 FA 01 39 C8 2A 50 A9 C9 2E 51 A9 C8 2A 00 A9 C8 2A 52 A9 C9 2E 01 A9 C9 2E 53 A9 C8 2A 02 A9 C8 2A 54 A9 C9 2E 03 A9 C9 2E 55 A9 C8 2A 04 A9 C8 2A 56 A9 C9 2E 05 A9 C9 BA 40 F9 C8 2A 06 A9 C8 7A 41 B9 C9 3A 00 F9 C9 FA C2 79 C8 7A 00 B9 C8 FA C5 39 C9 FA 00 79 C8 FA 01 39 6D 82 40 F9 4D 02 00 B4 AC FD 5F 88 8B 05 00 51 AB FD 0A 88 AA FF FF 35 BF 3B 03 D5 8B 01 00 35 68 86 40 F9 00 F9 03 D1 ?? ?? ?? ?? 68 8A 40 F9 00 01 02 D1 ?? ?? ?? ?? 68 8E 40 F9 00 01 02 D1 ?? ?? ?? ?? 60 82 40 F9 ?? ?? ?? ?? E9 0B 40 F9 28 00 80 52 08 03 00 B9 A0 02 00 91 78 6A 10 A9 7B 72 11 A9 69 02 00 F9 79 0A 00 B9 ?? ?? ?? ?? 20 00 00 14 00 03 00 91 ?? ?? ?? ?? 80 02 00 91 ?? ?? ?? ?? E0 02 00 91 ?? ?? ?? ?? C0 02 00 91 ?? ?? ?? ?? A0 02 00 91 ?? ?? ?? ?? 20 00 80 52 15 00 00 14 6A 82 40 F9 CA 00 00 B4 49 FD 5F 88 29 05 00 51 49 FD 08 88 A8 FF FF 35 BF 3B 03 D5 ?? ?? ?? ?? 7F 7E 10 A9 ?? ?? ?? ?? 68 02 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 68 8E 00 F9 28 00 80 52 ?? ?? ?? ?? 68 0A 00 B9 69 8A 00 F9 00 00 80 52 FF 03 01 91 ?? ?? ?? ?? FB 73 45 A9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_240_0_0 {
	meta:
		name = "copysign"
		size = 44
		altNames = "copysignl"
	strings:
		$1 = { FF 43 00 D1 E0 07 00 6D E8 0F 40 79 EA 1F 40 79 08 01 0A 4A 09 39 00 12 28 01 0A 4A E8 0F 00 79 E0 03 40 FD FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_241_0_0 {
	meta:
		name = "??$common_time@J@@YAJQEAJ@Z"
		size = 72
		refs = "0020 ??$common_timespec_get@U_timespec32@@@@YAHQEAU_timespec32@@H@Z"
		altNames = "_time32"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 91 E8 43 00 91 E0 43 00 91 1F 01 00 F9 21 00 80 52 ?? ?? ?? ?? E8 13 40 B9 09 00 80 12 1F 04 00 71 20 11 88 1A 53 00 00 B4 60 02 00 B9 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_241_1_0 {
	meta:
		name = "??$common_time@_J@@YA_JQEA_J@Z"
		size = 72
		refs = "0020 ??$common_timespec_get@U_timespec64@@@@YAHQEAU_timespec64@@H@Z"
		altNames = "_time64"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 91 E8 43 00 91 E0 43 00 91 1F 7D 00 A9 21 00 80 52 ?? ?? ?? ?? E8 0B 40 F9 09 00 80 92 1F 04 00 71 20 11 88 9A 53 00 00 B4 60 02 00 F9 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_241_2_0 {
	meta:
		name = "??$common_timespec_get@U_timespec32@@@@YAHQEAU_timespec32@@H@Z"
		size = 160
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 __acrt_GetSystemTimePreciseAsFileTime"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 15 00 00 14 3F 04 00 71 A1 FF FF 54 E8 43 00 91 E0 43 00 91 1F 01 00 F9 ?? ?? ?? ?? E8 0B 40 F9 09 02 00 58 2A 02 00 58 09 01 09 CB 3F 01 0A EB 6A FE FF 54 EA 01 00 58 28 0D CA 9A 20 00 80 52 09 A5 0A 9B 8A 0C 80 52 68 02 00 B9 28 7D 0A 1B 68 06 00 B9 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 00 80 3E D5 DE B1 9D 01 00 40 40 E1 24 4B 4C 00 80 96 98 00 00 00 00 00 }
	condition:
		$1
}

rule file_241_3_0 {
	meta:
		name = "??$common_timespec_get@U_timespec64@@@@YAHQEAU_timespec64@@H@Z"
		size = 160
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 __acrt_GetSystemTimePreciseAsFileTime"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 15 00 00 14 3F 04 00 71 A1 FF FF 54 E8 43 00 91 E0 43 00 91 1F 01 00 F9 ?? ?? ?? ?? E8 0B 40 F9 09 02 00 58 2A 02 00 58 09 01 09 CB 3F 01 0A EB 6A FE FF 54 EA 01 00 58 28 0D CA 9A 8B 0C 80 52 20 00 80 52 09 A5 0A 9B 68 02 00 F9 28 7D 0B 1B 68 0A 00 B9 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 00 80 3E D5 DE B1 9D 01 00 80 47 DD 78 F0 83 04 80 96 98 00 00 00 00 00 }
	condition:
		$1
}

rule file_242_0_0 {
	meta:
		name = "fegetenv"
		size = 48
		refs = "0010 _getfpcontrolword 0018 _getfpstatusword"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 ?? ?? ?? ?? 60 02 00 B9 ?? ?? ?? ?? 60 06 00 B9 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_243_3_0 {
	meta:
		name = "tanh"
		size = 760
		refs = "003c _controlfp_s 0058 _handle_nan 016c ?two_to_jby32_lead_table@?1??splitexp@@9@9 0184 ?two_to_jby32_trail_table@?1??splitexp@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 09 00 66 9E 0A C6 E7 D2 06 40 60 1E 28 F9 40 92 E6 1B 01 6D 1F 01 0A EB 42 01 00 54 48 00 00 B5 82 00 00 14 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? E0 0F 40 FD 7B 00 00 14 0A FE EF D2 1F 01 0A EB 89 00 00 54 20 01 00 91 ?? ?? ?? ?? 75 00 00 14 1F 01 09 EB EC 07 9F 9A 4C 00 00 B4 C6 40 61 1E 10 90 66 1E 00 10 6E 1E C0 20 70 1E 6C 0D 00 54 C0 20 60 1E 68 05 00 54 91 0D 00 5C C5 08 66 1E C0 20 71 1E 82 02 00 54 53 0D 00 5C 72 0D 00 5C 90 0D 00 5C B7 0D 00 5C B4 C8 53 1F B3 0D 00 5C 95 C2 65 1F B4 08 66 1E B6 CE 65 1F 75 0D 00 5C B8 54 57 1F 77 0D 00 5C DA 0A 74 1E 76 0D 00 5C 19 5B 45 1F 38 5F 45 1F 59 1B 78 1E 20 2B 66 1E 52 00 00 14 FA 0C 00 5C 11 0D 00 5C 3D 0D 00 5C 54 0D 00 5C B2 C4 5A 1F 50 0D 00 5C BE 50 5D 1F 55 0D 00 5C 76 0D 00 5C B3 08 66 1E 5B C2 65 1F 52 0D 00 5C DF 57 45 1F 7C CB 65 1F F7 5B 45 1F 87 0B 73 1E F8 18 77 1E 00 2B 66 1E 3F 00 00 14 04 10 60 1E 70 0C 00 5C 1B 10 6C 1E D9 08 64 1E 31 0B 70 1E 28 22 60 1E 8D 00 00 54 31 2A 7B 1E 2A 02 78 1E 03 00 00 14 32 3A 7B 1E 4A 02 78 1E 53 01 62 1E E8 03 0A 4B 14 01 62 1E ?? ?? ?? ?? D0 0A 00 5C ?? ?? ?? ?? D1 0A 00 5C 49 11 00 12 18 D9 69 FC ?? ?? ?? ?? ?? ?? ?? ?? 17 D9 69 FC 49 01 09 4B 28 7D 04 13 29 6D 48 0B 0D FE E7 D2 7A E6 50 1F 2B 7D 05 13 93 09 00 5C 68 7D 4B 0B 90 09 00 5C 0A 7D 01 13 99 0A 73 1E 49 7D 40 93 A8 D1 09 8B 69 01 0A 4B 2A 7D 40 93 E8 0F 00 F9 08 FE E7 D2 08 D1 0A 8B 36 2B 7A 1E E8 0B 00 F9 D2 42 51 1F 31 08 00 5C 53 46 56 1F 32 08 00 5C 74 4A 56 1F D3 0A 76 1E 95 6E 56 1F B4 66 53 1F F5 2A 78 1E 19 01 67 9E 96 2A 7A 1E D6 5E 55 1F F7 0F 40 FD D8 2A 78 1E 1A 0B 77 1E 50 03 59 1F 91 18 70 1E 00 38 71 1E 4C 00 00 B4 00 40 61 1E FD 7B C2 A8 C0 03 5F D6 CD CC CC CC CC CC EC 3F 81 AF 09 0D D1 82 4E 3E C9 79 F4 FA 7B 38 2A BF AE 02 03 B9 29 06 92 3F 84 D2 CA CE B3 68 2B 3F 58 77 00 E8 B6 89 D1 3F A9 88 7A CC D4 A3 94 3F 04 B3 00 5C 92 4E EA 3F 4C B9 4A 1C D0 6C D8 3F EC 6C 7E 84 5A CC 48 3E DD 35 98 C6 83 B4 25 BF 50 E7 34 F3 77 AF 26 3F 7F 48 EC BA 35 23 91 3F 18 21 21 6E AD EF 8D 3F F6 C5 BC 59 14 4D D4 3F FD 2A 44 1D 43 DE E5 3F 88 E2 5A 7C 59 28 CD 3F FE 82 2B 65 47 15 47 40 00 00 00 FE 42 2E 96 3F 65 97 73 8D 72 C1 56 3F 8E 27 AF E6 3D 47 CF 3D 5E 90 AA B7 15 11 81 3F 4E 5D 54 55 55 55 A5 3F 7C 8F 54 55 55 55 C5 3F }
	condition:
		$1
}

rule file_244_0_0 {
	meta:
		name = "remquol"
		size = 472
		refs = "0024 _ldtest 009c _ldunscale 00dc _ldscale 01b8 _fperrraise 01bc _LNan_C"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 16 00 00 91 E0 0F 00 FD E0 63 00 91 E1 17 00 FD ?? ?? ?? ?? 13 00 00 11 E0 A3 00 91 ?? ?? ?? ?? 56 00 00 B4 DF 02 00 B9 73 0A F8 36 40 0A F8 36 F1 17 40 FD 28 22 60 1E A2 00 00 54 31 42 61 1E 35 00 80 52 F1 17 00 FD 02 00 00 14 15 00 80 52 F0 0F 40 FD 08 22 60 1E 02 01 00 54 10 42 61 1E 28 00 80 52 08 01 15 4B 37 00 80 52 15 3D 00 13 F0 0F 00 FD 02 00 00 14 17 00 80 52 E1 83 00 91 F1 13 00 FD E0 4B 00 91 ?? ?? ?? ?? F0 0F 40 FD 14 00 80 52 F0 13 00 FD E1 83 00 91 E0 43 00 91 ?? ?? ?? ?? 60 03 00 34 EA 23 C0 79 E9 27 C0 79 53 01 09 4B F3 02 F8 37 F0 17 40 FD 61 02 00 11 E0 83 00 91 F0 13 00 FD ?? ?? ?? ?? F1 C3 41 6D 00 22 71 1E 89 00 00 54 73 06 00 51 F3 FE FF 36 09 00 00 14 31 3A 70 1E 68 7E 40 93 1F 81 00 F1 F1 0F 00 FD 82 00 00 54 29 00 80 52 29 21 D3 1A 34 01 14 0B F1 13 00 FD 93 FC FF 36 02 00 00 14 F1 0F 40 FD 28 22 60 1E AD 01 00 54 F3 17 40 FD 10 10 6C 1E 72 0A 70 1E 40 22 71 1E 62 00 00 54 48 22 60 1E 8C 00 00 54 40 22 71 1E 81 00 00 54 74 00 00 36 31 3A 73 1E 94 06 00 11 D6 00 00 B4 89 7A 00 12 E8 03 09 4B BF 02 00 71 08 11 89 1A C8 02 00 B9 30 42 61 1E FF 02 00 71 00 1E 71 1E 10 00 00 14 7F 0A 00 71 61 00 00 54 E0 0F 40 FD 0C 00 00 14 1F 08 00 71 61 00 00 54 E0 17 40 FD 08 00 00 14 7F 06 00 71 04 18 40 7A 01 FF FF 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_442_0_0 {
	meta:
		name = "remquo"
		size = 472
		refs = "0024 _dtest 009c _dunscale 00dc _dscale 01b8 _fperrraise 01bc _Nan_C"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 16 00 00 91 E0 0F 00 FD E0 63 00 91 E1 17 00 FD ?? ?? ?? ?? 13 00 00 11 E0 A3 00 91 ?? ?? ?? ?? 56 00 00 B4 DF 02 00 B9 73 0A F8 36 40 0A F8 36 F1 17 40 FD 28 22 60 1E A2 00 00 54 31 42 61 1E 35 00 80 52 F1 17 00 FD 02 00 00 14 15 00 80 52 F0 0F 40 FD 08 22 60 1E 02 01 00 54 10 42 61 1E 28 00 80 52 08 01 15 4B 37 00 80 52 15 3D 00 13 F0 0F 00 FD 02 00 00 14 17 00 80 52 E1 83 00 91 F1 13 00 FD E0 4B 00 91 ?? ?? ?? ?? F0 0F 40 FD 14 00 80 52 F0 13 00 FD E1 83 00 91 E0 43 00 91 ?? ?? ?? ?? 60 03 00 34 EA 23 C0 79 E9 27 C0 79 53 01 09 4B F3 02 F8 37 F0 17 40 FD 61 02 00 11 E0 83 00 91 F0 13 00 FD ?? ?? ?? ?? F1 C3 41 6D 00 22 71 1E 89 00 00 54 73 06 00 51 F3 FE FF 36 09 00 00 14 31 3A 70 1E 68 7E 40 93 1F 81 00 F1 F1 0F 00 FD 82 00 00 54 29 00 80 52 29 21 D3 1A 34 01 14 0B F1 13 00 FD 93 FC FF 36 02 00 00 14 F1 0F 40 FD 28 22 60 1E AD 01 00 54 F3 17 40 FD 10 10 6C 1E 72 0A 70 1E 40 22 71 1E 62 00 00 54 48 22 60 1E 8C 00 00 54 40 22 71 1E 81 00 00 54 74 00 00 36 31 3A 73 1E 94 06 00 11 D6 00 00 B4 89 7A 00 12 E8 03 09 4B BF 02 00 71 08 11 89 1A C8 02 00 B9 30 42 61 1E FF 02 00 71 00 1E 71 1E 10 00 00 14 7F 0A 00 71 61 00 00 54 E0 0F 40 FD 0C 00 00 14 1F 08 00 71 61 00 00 54 E0 17 40 FD 08 00 00 14 7F 06 00 71 04 18 40 7A 01 FF FF 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_245_0_0 {
	meta:
		name = "_clrfp"
		size = 20
	strings:
		$1 = { 28 44 3B D5 00 7D 40 D3 0A 00 80 D2 2A 44 1B D5 C0 03 5F D6 }
	condition:
		$1
}

rule file_245_1_0 {
	meta:
		name = "_ctrlfp"
		size = 56
	strings:
		$1 = { 08 44 3B D5 0A E0 93 52 0D 01 0A 4A E9 03 21 2A 2C 01 0D 8A 28 7C 40 D3 09 7C 40 D3 29 01 08 8A 8B 01 09 AA 08 E0 93 D2 68 01 08 CA 08 44 1B D5 A0 01 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_245_2_0 {
	meta:
		name = "_set_statfp"
		size = 20
	strings:
		$1 = { 28 44 3B D5 0A 7D 40 93 4B 01 00 AA 2B 44 1B D5 C0 03 5F D6 }
	condition:
		$1
}

rule file_246_0_0 {
	meta:
		name = "atanhl"
		size = 196
		refs = "0014 _ldtest 0050 _fperrraise 0054 _LNan_C 0070 _LInf_C 0098 log1pl"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? 08 78 1E 12 C8 04 00 34 F1 0B 40 FD 28 22 60 1E A2 00 00 54 31 42 61 1E 33 00 80 52 F1 0B 00 FD 02 00 00 14 13 00 80 52 13 10 6E 1E 60 22 71 1E C2 00 00 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 17 00 00 14 20 22 73 1E 21 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 00 71 30 42 61 1E 00 1E 71 1E 0D 00 00 14 10 10 60 1E 32 0A 70 1E 71 3A 71 1E 40 1A 71 1E ?? ?? ?? ?? 10 10 6C 1E 7F 02 00 71 12 08 70 1E 51 42 61 1E 20 1E 72 1E 02 00 00 14 E0 0B 40 FD FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_335_0_0 {
	meta:
		name = "atanh"
		size = 196
		refs = "0014 _dtest 0050 _fperrraise 0054 _Nan_C 0070 _Inf_C 0098 log1p"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? 08 78 1E 12 C8 04 00 34 F1 0B 40 FD 28 22 60 1E A2 00 00 54 31 42 61 1E 33 00 80 52 F1 0B 00 FD 02 00 00 14 13 00 80 52 13 10 6E 1E 60 22 71 1E C2 00 00 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 17 00 00 14 20 22 73 1E 21 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 00 71 30 42 61 1E 00 1E 71 1E 0D 00 00 14 10 10 60 1E 32 0A 70 1E 71 3A 71 1E 40 1A 71 1E ?? ?? ?? ?? 10 10 6C 1E 7F 02 00 71 12 08 70 1E 51 42 61 1E 20 1E 72 1E 02 00 00 14 E0 0B 40 FD FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_0_0 {
	meta:
		name = "??$common_tox_l@$1?internal_islower_l@@YA_NHQEAU__crt_locale_pointers@@@Z$1?internal_map_upper@@YAHH0@Z@@YAHHKQEAU__crt_locale_pointers@@@Z"
		size = 312
		refs = "0024 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0038 ?internal_islower_l@@YA_NHQEAU__crt_locale_pointers@@@Z 0078 _isleadbyte_l 0094 _errno 00e4 __acrt_LCMapStringA"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BC A9 FD 03 00 91 FF 43 00 D1 13 00 00 11 35 00 00 11 41 00 00 91 E0 A3 00 91 ?? ?? ?? ?? 7F 02 04 71 22 01 00 54 E1 C3 00 91 60 02 00 11 ?? ?? ?? ?? 60 06 00 34 E8 1B 40 F9 08 8D 40 F9 13 C9 73 38 2F 00 00 14 E8 1B 40 F9 FF 83 00 39 FF 87 00 39 FF 8B 00 39 08 09 40 B9 1F 05 00 71 6D 01 00 54 74 7E 08 13 80 1E 00 12 E1 C3 00 91 ?? ?? ?? ?? C0 00 00 34 F4 83 00 39 49 00 80 D2 F3 87 00 39 FF 8B 00 39 07 00 00 14 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 29 00 80 D2 F3 83 00 39 FF 87 00 39 E8 93 00 91 1F 01 00 79 2A 00 80 52 1F 09 00 39 E8 1B 40 F9 24 01 00 11 66 00 80 52 EA 03 00 B9 E5 93 00 91 E3 83 00 91 07 0D 40 B9 A2 02 00 11 01 9D 40 F9 E0 C3 00 91 ?? ?? ?? ?? 00 01 00 34 1F 04 00 71 61 00 00 54 F3 93 40 39 04 00 00 14 E9 93 40 39 E8 97 40 39 13 21 09 2A E8 03 41 39 A8 00 00 34 EA 17 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 00 91 FD 7B C4 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_1_0 {
	meta:
		name = "??$common_tox_l@$1?internal_isupper_l@@YA_NHQEAU__crt_locale_pointers@@@Z$1?internal_map_lower@@YAHH0@Z@@YAHHKQEAU__crt_locale_pointers@@@Z"
		size = 312
		refs = "0024 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0038 ?internal_isupper_l@@YA_NHQEAU__crt_locale_pointers@@@Z 0078 _isleadbyte_l 0094 _errno 00e4 __acrt_LCMapStringA"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BC A9 FD 03 00 91 FF 43 00 D1 13 00 00 11 35 00 00 11 41 00 00 91 E0 A3 00 91 ?? ?? ?? ?? 7F 02 04 71 22 01 00 54 E1 C3 00 91 60 02 00 11 ?? ?? ?? ?? 60 06 00 34 E8 1B 40 F9 08 89 40 F9 13 C9 73 38 2F 00 00 14 E8 1B 40 F9 FF 83 00 39 FF 87 00 39 FF 8B 00 39 08 09 40 B9 1F 05 00 71 6D 01 00 54 74 7E 08 13 80 1E 00 12 E1 C3 00 91 ?? ?? ?? ?? C0 00 00 34 F4 83 00 39 49 00 80 D2 F3 87 00 39 FF 8B 00 39 07 00 00 14 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 29 00 80 D2 F3 83 00 39 FF 87 00 39 E8 93 00 91 1F 01 00 79 2A 00 80 52 1F 09 00 39 E8 1B 40 F9 24 01 00 11 66 00 80 52 EA 03 00 B9 E5 93 00 91 E3 83 00 91 07 0D 40 B9 A2 02 00 11 01 9D 40 F9 E0 C3 00 91 ?? ?? ?? ?? 00 01 00 34 1F 04 00 71 61 00 00 54 F3 93 40 39 04 00 00 14 E9 93 40 39 E8 97 40 39 13 21 09 2A E8 03 41 39 A8 00 00 34 EA 17 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 00 91 FD 7B C4 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_5_0 {
	meta:
		name = "?internal_islower_l@@YA_NHQEAU__crt_locale_pointers@@@Z"
		size = 100
		refs = "002c _isctype_l 0044 __pctype_func"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 A1 01 00 B4 29 00 40 F9 28 09 40 B9 1F 05 00 71 AD 00 00 54 22 00 00 91 41 00 80 52 ?? ?? ?? ?? 08 00 00 14 28 01 40 F9 09 D9 73 78 20 01 1F 12 04 00 00 14 ?? ?? ?? ?? 08 D8 73 78 00 01 1F 12 1F 00 00 71 E0 07 9F 1A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_6_0 {
	meta:
		name = "?internal_isupper_l@@YA_NHQEAU__crt_locale_pointers@@@Z"
		size = 100
		refs = "002c _isctype_l 0044 __pctype_func"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 A1 01 00 B4 29 00 40 F9 28 09 40 B9 1F 05 00 71 AD 00 00 54 22 00 00 91 21 00 80 52 ?? ?? ?? ?? 08 00 00 14 28 01 40 F9 09 D9 73 78 20 01 00 12 04 00 00 14 ?? ?? ?? ?? 08 D8 73 78 00 01 00 12 1F 00 00 71 E0 07 9F 1A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_7_0 {
	meta:
		name = "?internal_map_lower@@YAHHQEAU__crt_locale_pointers@@@Z"
		size = 16
	strings:
		$1 = { 28 00 40 F9 09 89 40 F9 20 C9 60 38 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_8_0 {
	meta:
		name = "?internal_map_upper@@YAHHQEAU__crt_locale_pointers@@@Z"
		size = 16
	strings:
		$1 = { 28 00 40 F9 09 8D 40 F9 20 C9 60 38 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_14_0 {
	meta:
		name = "_tolower_l"
		size = 296
		refs = "0018 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002c ?internal_isupper_l@@YA_NHQEAU__crt_locale_pointers@@@Z 006c _isleadbyte_l 0088 _errno 00d8 __acrt_LCMapStringA"
	strings:
		$1 = { F3 53 BF A9 FD 7B BC A9 FD 03 00 91 FF 43 00 D1 13 00 00 11 E0 A3 00 91 ?? ?? ?? ?? 7F 02 04 71 22 01 00 54 E1 C3 00 91 60 02 00 11 ?? ?? ?? ?? 60 06 00 34 E8 1B 40 F9 08 89 40 F9 13 C9 73 38 2F 00 00 14 E8 1B 40 F9 FF 83 00 39 FF 87 00 39 FF 8B 00 39 08 09 40 B9 1F 05 00 71 6D 01 00 54 74 7E 08 13 80 1E 00 12 E1 C3 00 91 ?? ?? ?? ?? C0 00 00 34 F4 83 00 39 49 00 80 D2 F3 87 00 39 FF 8B 00 39 07 00 00 14 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 29 00 80 D2 F3 83 00 39 FF 87 00 39 E8 93 00 91 1F 01 00 79 2A 00 80 52 1F 09 00 39 E8 1B 40 F9 24 01 00 11 66 00 80 52 EA 03 00 B9 E5 93 00 91 E3 83 00 91 07 0D 40 B9 02 20 80 52 01 9D 40 F9 E0 C3 00 91 ?? ?? ?? ?? 00 01 00 34 1F 04 00 71 61 00 00 54 F3 93 40 39 04 00 00 14 E9 93 40 39 E8 97 40 39 13 21 09 2A E8 03 41 39 A8 00 00 34 EA 17 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 00 91 FD 7B C4 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_16_0 {
	meta:
		name = "_toupper_l"
		size = 296
		refs = "0018 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002c ?internal_islower_l@@YA_NHQEAU__crt_locale_pointers@@@Z 006c _isleadbyte_l 0088 _errno 00d8 __acrt_LCMapStringA"
	strings:
		$1 = { F3 53 BF A9 FD 7B BC A9 FD 03 00 91 FF 43 00 D1 13 00 00 11 E0 A3 00 91 ?? ?? ?? ?? 7F 02 04 71 22 01 00 54 E1 C3 00 91 60 02 00 11 ?? ?? ?? ?? 60 06 00 34 E8 1B 40 F9 08 8D 40 F9 13 C9 73 38 2F 00 00 14 E8 1B 40 F9 FF 83 00 39 FF 87 00 39 FF 8B 00 39 08 09 40 B9 1F 05 00 71 6D 01 00 54 74 7E 08 13 80 1E 00 12 E1 C3 00 91 ?? ?? ?? ?? C0 00 00 34 F4 83 00 39 49 00 80 D2 F3 87 00 39 FF 8B 00 39 07 00 00 14 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 29 00 80 D2 F3 83 00 39 FF 87 00 39 E8 93 00 91 1F 01 00 79 2A 00 80 52 1F 09 00 39 E8 1B 40 F9 24 01 00 11 66 00 80 52 EA 03 00 B9 E5 93 00 91 E3 83 00 91 07 0D 40 B9 02 40 80 52 01 9D 40 F9 E0 C3 00 91 ?? ?? ?? ?? 00 01 00 34 1F 04 00 71 61 00 00 54 F3 93 40 39 04 00 00 14 E9 93 40 39 E8 97 40 39 13 21 09 2A E8 03 41 39 A8 00 00 34 EA 17 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 00 91 FD 7B C4 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_17_0 {
	meta:
		name = "tolower"
		size = 40
		refs = "0000 __acrt_locale_changed_data 0010 _tolower_l"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? 08 04 01 51 1F 65 00 71 48 00 00 54 00 80 00 11 C0 03 5F D6 }
	condition:
		$1
}

rule file_247_18_0 {
	meta:
		name = "toupper"
		size = 40
		refs = "0000 __acrt_locale_changed_data 0010 _toupper_l"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 68 00 00 34 01 00 80 D2 ?? ?? ?? ?? 08 84 01 51 1F 65 00 71 48 00 00 54 00 80 00 51 C0 03 5F D6 }
	condition:
		$1
}

rule file_248_0_0 {
	meta:
		name = "?is_lfh_enabled@@YA_NXZ"
		size = 88
		refs = "0010 __acrt_heap 0014 __imp_HeapQueryInformation"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 08 00 80 12 E8 13 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 04 00 80 D2 83 00 80 D2 E2 43 00 91 01 00 80 52 20 01 3F D6 60 00 00 35 00 00 80 52 04 00 00 14 E8 13 40 B9 1F 09 00 71 E0 17 9F 1A FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_248_2_0 {
	meta:
		name = "_expand_base"
		size = 292
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0048 __imp_HeapSize 004c __acrt_heap 0074 __imp_HeapReAlloc 00b8 __imp_HeapQueryInformation 00f0 __imp_GetLastError 0100 __acrt_errno_from_os_error"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 34 00 00 91 D3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 39 00 00 14 9F 82 00 B1 A9 00 00 54 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 33 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 62 02 00 91 01 00 80 52 20 01 3F D6 9F 02 00 F1 28 00 80 D2 14 01 94 9A ?? ?? ?? ?? ?? ?? ?? ?? 15 00 00 91 ?? ?? ?? ?? 09 FD DF C8 83 02 00 91 62 02 00 91 01 02 80 52 20 01 3F D6 E0 03 00 B5 08 00 88 D2 BF 02 08 EB 8A 92 55 FA 48 02 00 54 08 00 80 12 ?? ?? ?? ?? E8 13 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 04 00 80 D2 83 00 80 D2 E2 43 00 91 01 00 80 52 20 01 3F D6 C0 00 00 34 E8 13 40 B9 1F 09 00 71 61 00 00 54 60 02 00 91 0A 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? 13 00 00 11 ?? ?? ?? ?? 13 00 00 B9 00 00 80 D2 FD 7B C2 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_252_0_0 {
	meta:
		name = "wcscpy"
		size = 24
	strings:
		$1 = { 09 00 01 CB 28 00 40 79 28 69 21 78 21 08 00 91 A8 FF FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_253_13_0 {
	meta:
		name = "?ctrlevent_capture@@YAHK@Z"
		size = 200
		refs = "0014 __acrt_lock 001c ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A 0024 __security_cookie 0084 __acrt_unlock 00a0 __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 11 60 00 80 52 ?? ?? ?? ?? 13 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 54 00 80 52 08 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 2D 21 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 28 05 40 F9 B4 02 80 52 6C 15 00 12 6A 01 08 CA 53 2D CC 9A 7F 0A 00 F1 E3 00 00 54 08 08 80 52 08 01 0C 4B 0A 00 80 D2 48 2D C8 9A 09 01 0B CA A9 01 00 F9 60 00 80 52 ?? ?? ?? ?? 73 00 00 B5 00 00 80 52 0A 00 00 14 7F 06 00 F1 E0 00 00 54 6F 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 80 02 00 11 60 02 3F D6 20 00 80 52 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_253_14_0 {
	meta:
		name = "?fin$0@?0??ctrlevent_capture@@YAHK@Z@4HA"
		size = 32
		refs = "000c __acrt_unlock"
		altNames = "signal$fin$0"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 60 00 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_253_16_0 {
	meta:
		name = "?get_global_action_nolock@@YAPEAP6AXH@ZH@Z"
		size = 96
		refs = "0010 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A"
	strings:
		$1 = { 1F 08 00 71 80 02 00 54 1F 18 00 71 E0 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 1F 3C 00 71 20 01 00 54 1F 54 00 71 A0 00 00 54 1F 58 00 71 09 41 00 91 E0 13 89 9A 0A 00 00 14 00 21 00 91 08 00 00 14 00 61 00 91 06 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 03 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? C0 03 5F D6 }
	condition:
		$1
}

rule file_253_18_0 {
	meta:
		name = "?siglookup@@YAPEAU__crt_signal_action_t@@HQEAU1@@Z"
		size = 56
		refs = "0000 __acrt_signal_action_table_count"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 2A 10 08 8B 05 00 00 14 29 04 40 B9 3F 01 00 6B C0 00 00 54 21 40 00 91 3F 00 0A EB 61 FF FF 54 00 00 80 D2 C0 03 5F D6 20 00 00 91 FE FF FF 17 }
	condition:
		$1
}

rule file_253_19_0 {
	meta:
		name = "?signal_failed@@YAP6AXH@ZH@Z"
		size = 60
		refs = "001c _errno"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 1F 44 00 71 88 00 00 54 48 01 00 18 08 25 C0 1A 88 00 00 37 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 80 92 FD 7B C1 A8 C0 03 5F D6 1F 20 03 D5 0A 20 03 00 }
	condition:
		$1
}

rule file_253_21_0 {
	meta:
		name = "__acrt_get_sigabrt_handler"
		size = 48
		refs = "0024 ??$?RV<lambda_450d765d439847d4c735a33c368b5fc0>@@AEAV<lambda_44731a7d0e6d81c3e6aa82d741081786>@@V<lambda_601a2a7da3b7a96e9554ac7215c4b07c>@@@?$__crt_seh_guarded_call@P6AXH@Z@@QEAAP6AXH@Z$$QEAV<lambda_450d765d439847d4c735a33c368b5fc0>@@AEAV<lambda_44731a7d0e6d81c3e6aa82d741081786>@@$$QEAV<lambda_601a2a7da3b7a96e9554ac7215c4b07c>@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E3 53 00 91 E2 43 00 91 E1 63 00 91 E0 43 00 91 68 00 80 52 69 00 80 52 E8 A7 02 29 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_253_22_0 {
	meta:
		name = "__acrt_initialize_signal_handlers"
		size = 20
		refs = "0000 ?ctrlc_action@@3V?$dual_state_global@P6AXH@Z@__crt_state_management@@A"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 00 01 00 A9 00 01 01 A9 C0 03 5F D6 }
	condition:
		$1
}

rule file_253_25_0 {
	meta:
		name = "raise"
		size = 656
		refs = "007c ?get_global_action_nolock@@YAPEAP6AXH@ZH@Z 0088 __acrt_getptd_noexit 00a0 __acrt_signal_action_table_count 00d0 _errno 00dc _invalid_parameter_noinfo 00fc __acrt_lock 0100 __security_cookie 0140 __acrt_unlock 0148 _exit 0174 __fpecode 0198 __acrt_signal_action_first_fpe_index 01a8 __acrt_signal_action_fpe_count 0208 __acrt_getptd 0214 __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 23 00 F9 FD 7B BD A9 FD 03 00 91 14 00 00 11 15 00 80 D2 1B 00 80 52 33 00 80 52 B3 43 00 39 9F 22 00 71 4C 01 00 54 9F 22 00 71 60 02 00 54 9F 0A 00 71 A0 01 00 54 9F 12 00 71 E0 01 00 54 9F 1A 00 71 20 01 00 54 1E 00 00 14 9F 2E 00 71 40 01 00 54 9F 3E 00 71 80 00 00 54 88 56 00 51 1F 05 00 71 E8 02 00 54 80 02 00 11 ?? ?? ?? ?? 18 00 00 91 1B 00 00 14 ?? ?? ?? ?? 15 00 00 91 75 00 00 B5 00 00 80 12 77 00 00 14 AA 02 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 4B 11 08 8B 05 00 00 14 49 05 40 B9 3F 01 14 6B A0 00 00 54 4A 41 00 91 5F 01 0B EB 61 FF FF 54 0A 00 80 D2 CA 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ED FF FF 17 58 21 00 91 13 00 80 52 BF 43 00 39 19 00 80 D2 73 00 00 34 60 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? EB 02 40 F9 D3 00 00 34 09 03 40 F9 6A 15 00 12 69 01 09 CA 36 2D CA 9A 02 00 00 14 16 03 40 F9 DF 06 00 F1 FA 17 9F 1A DA 05 00 35 D6 00 00 B5 73 00 00 34 60 00 80 52 ?? ?? ?? ?? 60 00 80 52 ?? ?? ?? ?? 9F 2E 00 71 08 02 00 54 08 22 81 52 08 25 D4 1A A8 01 00 36 B9 06 40 F9 B9 13 00 F9 BF 06 00 F9 9F 22 00 71 E1 00 00 54 ?? ?? ?? ?? 1B 00 40 B9 BB 17 00 B9 ?? ?? ?? ?? 88 11 80 52 08 00 00 B9 EB 02 40 F9 9F 22 00 71 C1 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? A8 02 40 F9 0A 11 09 8B ?? ?? ?? ?? ?? ?? ?? ?? 4C 11 09 8B AA 0F 00 F9 5F 01 0C EB 60 01 00 54 5F 05 00 F9 4A 41 00 91 FB FF FF 17 69 15 00 12 0A 08 80 52 4A 01 09 4B 09 00 80 D2 28 2D CA 9A 09 01 0B CA 09 03 00 F9 73 00 00 34 60 00 80 52 ?? ?? ?? ?? 7A 00 00 34 00 00 80 52 1E 00 00 14 9F 22 00 71 61 01 00 54 ?? ?? ?? ?? 13 00 00 91 CF 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 61 12 40 B9 00 01 80 52 C0 02 3F D6 07 00 00 14 CF 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 80 02 00 11 C0 02 3F D6 9F 2E 00 71 68 FD FF 54 08 22 81 52 08 25 D4 1A 08 FD 07 36 B9 06 00 F9 9F 22 00 71 A1 FC FF 54 ?? ?? ?? ?? 1B 10 00 B9 E2 FF FF 17 FD 7B C3 A8 FB 23 40 F9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_253_26_0 {
	meta:
		name = "raise$fin$0"
		size = 40
		refs = "0014 __acrt_unlock"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 A8 43 40 39 88 00 00 34 60 00 80 52 ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_253_27_0 {
	meta:
		name = "signal"
		size = 520
		refs = "0050 __acrt_lock 0060 ?console_ctrl_handler_installed@@3_NA 0070 ?ctrlevent_capture@@YAHK@Z 0078 __imp_SetConsoleCtrlHandler 009c __imp_GetLastError 00b0 __doserrno 00c4 ?get_global_action_nolock@@YAPEAP6AXH@ZH@Z 00d0 __security_cookie 0108 __acrt_unlock 012c __acrt_getptd_noexit 0138 __acrt_exception_action_table 014c __acrt_signal_action_table_size 0154 _malloc_base 0168 memcpy 0174 __acrt_signal_action_table_count 01e8 ?signal_failed@@YAP6AXH@ZH@Z"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 14 00 00 11 36 00 00 91 C8 0E 00 D1 1F 05 00 F1 09 0E 00 54 9F 5A 00 71 68 07 00 54 88 0E 00 18 08 25 D4 1A 08 07 00 36 15 00 80 52 BF 43 00 39 13 00 80 D2 BF 0F 00 F9 60 00 80 52 ?? ?? ?? ?? 9F 0A 00 71 84 1A 55 7A 21 03 00 54 ?? ?? ?? ?? ?? ?? ?? ?? C8 02 00 35 21 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 A0 00 00 34 28 00 80 52 ?? ?? ?? ?? B5 43 40 39 09 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 13 00 00 11 ?? ?? ?? ?? 13 00 00 B9 35 00 80 52 B3 0F 40 F9 80 02 00 11 ?? ?? ?? ?? E0 01 00 B4 09 00 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 4B 15 00 12 49 01 09 CA 33 2D CB 9A B3 0F 00 F9 DF 0A 00 F1 C0 00 00 54 08 08 80 52 08 01 0B 4B C9 2E C8 9A 2A 01 0A CA 0A 00 00 F9 60 00 80 52 ?? ?? ?? ?? D5 06 00 35 60 02 00 91 36 00 00 14 9F 2E 00 71 48 06 00 54 08 22 81 52 08 25 D4 1A E8 05 00 36 ?? ?? ?? ?? 13 00 00 91 93 05 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 68 02 40 F9 1F 01 09 EB 21 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 60 02 00 F9 40 04 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 6A 02 40 F9 49 01 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 4B 11 0C 8B 5F 01 0B EB E0 00 00 54 28 05 40 B9 1F 01 14 6B A0 00 00 54 29 41 00 91 3F 01 0B EB 61 FF FF 54 09 00 80 D2 09 02 00 B4 20 05 40 F9 DF 0A 00 F1 E0 01 00 54 4B 11 0C 8B 3F 01 0B EB 80 01 00 54 2A 21 00 91 48 C1 5F B8 1F 01 14 6B 01 01 00 54 56 05 01 F8 49 21 00 D1 3F 01 0B EB 41 FF FF 54 03 00 00 14 80 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 44 80 60 00 00 00 00 00 }
	condition:
		$1
}

rule file_254_6_0 {
	meta:
		name = "_ismbcalnum_l"
		size = 148
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c __dcrt_multibyte_check_type"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F FE 03 71 08 02 00 54 E8 0F 40 F9 6A 1E 00 53 EB 20 80 52 08 01 40 F9 09 D9 6A 78 28 01 0B 0A E8 00 00 35 E8 13 40 F9 08 C1 2A 8B 09 65 40 39 69 00 00 37 00 00 80 52 08 00 00 14 20 00 80 52 06 00 00 14 23 00 80 52 E2 20 80 52 E1 63 00 91 60 02 00 11 ?? ?? ?? ?? E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_255_0_0 {
	meta:
		name = "log10f"
		size = 368
		refs = "0034 _handle_nanf 0054 ??_C@_06KDGOKGLH@log10f?$AA@ 0068 _handle_errorf 00cc ?ln_tail_table@?1??log10f@@9@9 00f4 ?ln_lead_table@?1??log10f@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 10 C0 22 1E 09 FE EF D2 0E 02 66 9E F0 0B 00 FD C8 29 4C 92 1F 01 09 EB 81 02 00 54 C8 CD 40 92 A8 00 00 B4 00 00 26 1E E0 13 00 BD ?? ?? ?? ?? 41 00 00 14 C8 01 41 92 E8 07 00 B4 25 04 80 52 04 01 80 52 23 00 80 52 02 F8 BF D2 ?? ?? ?? ?? E1 03 27 1E ?? ?? ?? ?? 26 00 80 52 61 03 80 52 ?? ?? ?? ?? 34 00 00 14 C8 F9 40 92 C8 00 00 B5 45 04 80 52 84 00 80 52 43 00 80 52 02 F0 BF D2 F3 FF FF 17 C8 01 41 92 A8 FD FF B5 C8 01 00 91 90 05 00 5C C9 7F 80 D2 97 05 00 5C 28 2D 4C B3 E8 0B 00 F9 C8 FD 6E D3 0A 15 00 12 F2 0B 40 FD C8 FD 6D D3 4B 01 1A 32 0A 01 00 12 6C 01 0A 0B 91 01 62 1E ?? ?? ?? ?? ?? ?? ?? ?? 8D 01 01 51 34 0A 70 1E 10 D9 6D FC C8 FD 74 D3 11 10 6C 1E 0A 29 00 12 4B FD 0F 51 78 01 62 1E ?? ?? ?? ?? ?? ?? ?? ?? 53 3A 74 1E 72 52 51 1F 11 D9 6D FC 94 02 00 5C 76 1A 72 1E 93 02 00 5C 12 47 57 1F D5 0A 76 1E B4 4E 54 1F 95 0A 75 1E B6 5A 56 1F D9 2A 70 1E F6 01 00 5C 37 2B 72 1E F7 0A 76 1E E0 42 62 1E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 00 00 80 3F EF 39 FA FE 42 2E E6 3F DE 5E 86 99 99 99 89 3F 57 55 55 55 55 55 B5 3F 0E E5 26 15 7B CB DB 3F }
	condition:
		$1
}

rule file_256_0_0 {
	meta:
		name = "clog10f"
		size = 36
		refs = "000c clogf 0014 _FCmulcr"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 02 2D ?? ?? ?? ?? 82 00 00 1C ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 D9 5B DE 3E }
	condition:
		$1
}

rule file_259_4_0 {
	meta:
		name = "_mblen_l"
		size = 256
		refs = "002c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0038 _isleadbyte_l 0064 __imp_MultiByteToWideChar"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 F4 06 00 B4 88 02 C0 39 A8 06 00 34 93 06 00 B4 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 80 02 40 39 E1 63 00 91 ?? ?? ?? ?? E0 02 00 34 E9 0F 40 F9 23 09 40 B9 7F 04 00 71 ED 03 00 54 E8 7B 40 B2 7F 02 08 EB 88 03 00 54 7F 02 03 6B 4B 03 00 54 ?? ?? ?? ?? 20 0D 40 B9 ?? ?? ?? ?? 09 FD DF C8 05 00 80 52 04 00 80 D2 82 02 00 91 21 01 80 52 20 01 3F D6 00 02 00 34 E8 0F 40 F9 00 09 40 B9 10 00 00 14 E8 0F 40 F9 ?? ?? ?? ?? 05 00 80 52 04 00 80 D2 23 00 80 52 00 0D 40 B9 ?? ?? ?? ?? 09 FD DF C8 82 02 00 91 21 01 80 52 20 01 3F D6 60 00 00 35 00 00 80 12 02 00 00 14 20 00 80 52 E8 A3 40 39 E8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 02 00 00 14 00 00 80 52 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_260_0_0 {
	meta:
		name = "trunc"
		size = 36
		refs = "0014 _d_int"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 80 52 E0 0B 00 FD E0 43 00 91 ?? ?? ?? ?? E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_576_0_0 {
	meta:
		name = "truncl"
		size = 36
		refs = "0014 _ld_int"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 80 52 E0 0B 00 FD E0 43 00 91 ?? ?? ?? ?? E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_261_0_0 {
	meta:
		name = "??$common_difftime@J@@YANJJ@Z"
		size = 52
		refs = "001c _errno"
		altNames = "_difftime32"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 A1 00 F8 37 80 00 F8 37 08 00 01 4B 00 01 62 1E 05 00 00 14 ?? ?? ?? ?? C8 02 80 52 E0 03 67 9E 08 00 00 B9 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_261_1_0 {
	meta:
		name = "??$common_difftime@_J@@YAN_J0@Z"
		size = 52
		refs = "001c _errno"
		altNames = "_difftime64"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 A1 00 F8 B7 80 00 F8 B7 08 00 01 CB 00 01 62 9E 05 00 00 14 ?? ?? ?? ?? C8 02 80 52 E0 03 67 9E 08 00 00 B9 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_262_0_0 {
	meta:
		name = "log2"
		size = 640
		refs = "002c _handle_nan 004c ??_C@_04KGLCPMCP@log2?$AA@ 0060 _handle_error 0190 ?ln_lead_table@?1??log2@@9@9 01a0 ?ln_tail_table@?1??log2@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 0E 00 66 9E 09 FE EF D2 E0 0B 00 FD C8 29 4C 92 1F 01 09 EB 61 02 00 54 C8 CD 40 92 88 00 00 B4 C0 01 00 91 ?? ?? ?? ?? 77 00 00 14 C8 01 41 92 A8 0E 00 B4 25 04 80 52 04 01 80 52 23 00 80 52 02 FF FF D2 ?? ?? ?? ?? E1 03 67 9E ?? ?? ?? ?? 26 00 80 52 41 03 80 52 ?? ?? ?? ?? 6A 00 00 14 C8 F9 40 92 C8 00 00 B5 45 04 80 52 84 00 80 52 43 00 80 52 02 FE FF D2 F3 FF FF 17 C8 01 41 92 A8 FD FF B5 68 0C 00 58 C8 01 08 8B 69 0C 00 58 1F 01 09 EB 08 04 00 54 10 10 6E 1E 11 10 60 1E 14 0C 00 5C 1C 38 70 1E 10 0C 00 5C 3D 0C 00 5C 5E 0C 00 5C 92 2B 71 1E FC 0B 00 FD 88 03 66 9E 08 7D 60 92 93 1B 72 1E E8 0B 00 F9 1B 01 67 9E 92 3B 7B 1E 79 2A 73 1E 7A 0A 7C 1E 33 0B 00 5C 38 0B 79 1E 15 4F 54 1F 14 0B 00 5C 11 0B 79 1E B6 42 58 1F D7 52 58 1F F8 EA 71 1F 1A 2B 72 1E 58 0B 7D 1E 79 63 5D 1F 53 67 5E 1F 60 4F 5E 1F 3D 00 00 14 08 02 E0 D2 DF 01 08 EB 62 01 00 54 08 7A E0 D2 70 09 00 5C C8 01 08 AA 11 01 67 9E E8 0B 00 F9 8F 07 80 52 31 3A 70 1E F1 0B 00 FD 2E 02 66 9E 02 00 00 14 0F 00 80 52 C8 01 00 91 50 08 00 5C C9 7F 80 D2 1E 07 00 5C 28 2D 4C B3 9D 06 00 5C E8 0B 00 F9 C8 FD 6E D3 0A 15 00 12 F2 0B 40 FD C8 FD 6D D3 4B 01 1A 32 0A 01 00 12 6C 01 0A 0B 91 01 62 1E ?? ?? ?? ?? ?? ?? ?? ?? 8D 01 01 51 1A D9 6D FC ?? ?? ?? ?? ?? ?? ?? ?? 34 0A 70 1E 10 D9 6D FC C8 FD 74 D3 11 10 6C 1E 0A 29 00 12 4B 01 0F 4B 68 FD 0F 51 53 3A 74 1E 72 52 51 1F F4 04 00 5C 11 01 62 1E 77 1A 72 1E D3 04 00 5C 58 47 5E 1F F6 0A 77 1E D5 4E 54 1F 94 04 00 5C B5 52 56 1F B6 0A 76 1E D7 5E 57 1F F9 2A 70 1E 31 0B 7D 1E 52 47 5D 1F 31 4B 5E 1F 00 2B 71 1E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 56 F0 11 C0 00 00 00 00 82 F8 02 00 F0 FF 5D C8 34 80 3C 3F D4 C6 BA 99 99 99 89 3F BE BB F0 17 5C 29 CB 3E 00 00 00 00 44 15 F7 3F 9F 51 F1 07 23 49 62 3F E6 54 55 55 55 55 B5 3F 00 00 00 00 00 00 D0 03 00 00 00 00 00 00 80 3F 41 47 D9 3B 42 49 62 3F DE 5E 86 99 99 99 89 3F 57 55 55 55 55 55 B5 3F }
	condition:
		$1
}

rule file_263_73_0 {
	meta:
		name = "__acrt_copy_locale_name"
		size = 144
		refs = "0034 wcsnlen 004c _malloc_base 0068 wcsncpy_s 008c _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 13 00 00 91 D3 00 00 B5 00 00 80 D2 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 A1 0A 80 D2 60 02 00 91 ?? ?? ?? ?? 15 00 00 91 BF 56 01 F1 C2 FE FF 54 A8 06 00 91 00 F9 7F D3 ?? ?? ?? ?? 14 00 00 91 34 FE FF B4 A3 06 00 91 62 02 00 91 A1 06 00 91 80 02 00 91 ?? ?? ?? ?? 60 00 00 35 80 02 00 91 EA FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_74_0 {
	meta:
		name = "__acrt_set_locale_changed"
		size = 24
		refs = "0000 __acrt_locale_changed_data"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 29 00 80 52 09 FD 9F 88 BF 3B 03 D5 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_75_0 {
	meta:
		name = "__acrt_uninitialize_locale"
		size = 48
		refs = "0024 ??$?RV<lambda_410d79af7f07d98d83a3f525b3859a53>@@AEAV<lambda_3e16ef9562a7dcce91392c22ab16ea36>@@V<lambda_38119f0e861e05405d8a144b9b982f0a>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_410d79af7f07d98d83a3f525b3859a53>@@AEAV<lambda_3e16ef9562a7dcce91392c22ab16ea36>@@$$QEAV<lambda_38119f0e861e05405d8a144b9b982f0a>@@@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E3 53 00 91 E2 43 00 91 E1 63 00 91 E0 43 00 91 88 00 80 52 89 00 80 52 E8 A7 02 29 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_76_0 {
	meta:
		name = "__lc_lctowcs"
		size = 148
		refs = "001c wcscpy_s 002c ??_C@_13ENNFDPBH@?$AA_?$AA?$AA@ 0044 _wcscats 0050 ??_C@_13JOFGPIOO@?$AA?4?$AA?$AA@ 0090 _invoke_watson"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 35 00 00 91 53 00 00 91 ?? ?? ?? ?? E0 02 00 35 68 02 41 79 08 01 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 64 02 02 91 42 00 80 52 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 68 02 42 79 08 01 00 34 ?? ?? ?? ?? ?? ?? ?? ?? 64 02 04 91 42 00 80 52 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_77_0 {
	meta:
		name = "__lc_wcstolc"
		size = 428
		refs = "0024 memset 0058 wcsncpy_s 006c ??_C@_17MBJJLFDM@?$AA_?$AA?4?$AA?0?$AA?$AA@ 0078 wcscspn 0160 _invoke_watson"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BF A9 FD 03 00 91 34 00 00 91 01 00 80 52 42 39 80 D2 16 00 00 91 ?? ?? ?? ?? 88 02 40 79 68 00 00 35 00 00 80 52 41 00 00 14 1F B9 00 71 61 01 00 54 88 06 40 79 28 01 00 34 E3 01 80 D2 82 0A 00 91 01 02 80 D2 C0 02 04 91 ?? ?? ?? ?? 80 07 00 35 DF 3E 02 79 F3 FF FF 17 15 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 80 02 00 91 ?? ?? ?? ?? C0 05 00 B4 97 06 00 8B F3 02 40 79 95 01 00 35 1F 00 01 F1 22 05 00 54 7F BA 00 71 E0 04 00 54 03 00 00 91 C0 02 00 91 82 02 00 91 01 08 80 D2 ?? ?? ?? ?? 60 03 00 34 2C 00 00 14 BF 06 00 71 81 01 00 54 1F 00 01 F1 82 03 00 54 7F 7E 01 71 40 03 00 54 03 00 00 91 C0 02 02 91 82 02 00 91 01 08 80 D2 ?? ?? ?? ?? C0 01 00 34 25 00 00 14 BF 0A 00 71 0E 08 50 FA 02 02 00 54 73 00 00 34 7F B2 00 71 A1 01 00 54 03 00 00 91 C0 02 04 91 82 02 00 91 01 02 80 D2 ?? ?? ?? ?? E0 03 00 35 7F B2 00 71 64 1A 40 7A 60 F8 FF 54 F4 0A 00 91 B5 06 00 11 D0 FF FF 17 00 00 80 12 FD 7B C1 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_78_0 {
	meta:
		name = "_configthreadlocale"
		size = 140
		refs = "0010 __acrt_getptd 0044 _errno 0050 _invalid_parameter_noinfo 0070 __globallocalestatus"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 09 A8 43 B9 4B 00 80 52 2A 00 80 52 3F 01 1F 72 6A 01 8A 1A 7F 06 00 31 20 02 00 54 73 02 00 34 7F 06 00 71 60 01 00 54 7F 0A 00 71 E0 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 0A 00 00 14 28 79 1E 12 02 00 00 14 28 01 1F 32 08 A8 03 B9 04 00 00 14 ?? ?? ?? ?? 08 00 80 12 ?? ?? ?? ?? 40 01 00 11 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_79_0 {
	meta:
		name = "_copytlocinfo_nolock"
		size = 64
		refs = "0024 memcpy 0030 __acrt_add_locale_ref"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 21 01 00 B4 7F 02 00 F1 64 12 41 FA C0 00 00 54 02 2B 80 52 ?? ?? ?? ?? 60 02 00 91 7F 12 00 B9 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_80_0 {
	meta:
		name = "_create_locale"
		size = 120
		refs = "000c __security_push_cookie 0024 __imp_MultiByteToWideChar 0058 _wcreate_locale 0068 __security_pop_cookie"
	strings:
		$1 = { FD 7B BE A9 F3 0B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 03 04 D1 13 00 00 11 7F 16 00 71 24 98 40 FA 00 02 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 22 00 00 91 65 10 80 52 E4 03 00 91 03 00 80 12 01 00 80 52 00 00 80 52 20 01 3F D6 A0 00 00 34 E1 03 00 91 60 02 00 11 ?? ?? ?? ?? 02 00 00 14 00 00 80 D2 FF 03 04 91 ?? ?? ?? ?? F3 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_81_0 {
	meta:
		name = "_expandlocale"
		size = 924
		refs = "001c __security_push_cookie 0048 __security_pop_cookie 0068 __acrt_getptd 0084 wcsncpy_s 00a0 ??_C@_13FHBKNHDA@?$AAC?$AA?$AA@ 00b0 wcscpy_s 00f8 wcscmp 0110 __acrt_can_use_vista_locale_apis 0120 __lc_wcstolc 0138 __acrt_get_qualified_locale_downlevel 0140 __acrt_get_qualified_locale 0154 __lc_lctowcs 01a0 __acrt_IsValidLocaleName 01b8 __acrt_GetLocaleInfoEx 01c8 __imp_GetACP 02d4 _invoke_watson"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 2B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 07 D1 14 00 00 91 39 00 00 91 5B 00 00 91 75 00 00 91 9A 00 00 91 B7 00 00 91 74 01 00 B5 00 00 80 D2 FF 43 07 91 ?? ?? ?? ?? FB 2B 40 F9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 ?? ?? ?? ?? A3 0A 80 D2 FF 03 00 B9 13 00 00 91 62 C2 0B 91 41 03 00 91 A0 02 00 91 ?? ?? ?? ?? C0 17 00 35 89 02 40 79 3F 0D 01 71 A1 01 00 54 88 06 40 79 68 01 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 61 03 00 91 20 03 00 91 ?? ?? ?? ?? 60 10 00 35 57 00 00 B4 FF 02 00 B9 20 03 00 91 E0 FF FF 17 8A 02 00 91 28 3D 00 13 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 14 CB 16 FD 41 93 DF 0E 02 F1 22 01 00 54 81 02 00 91 60 0A 07 91 ?? ?? ?? ?? 00 0B 00 34 81 02 00 91 60 F2 02 91 ?? ?? ?? ?? 80 0A 00 34 ?? ?? ?? ?? 81 02 00 91 18 00 00 11 E0 23 00 91 ?? ?? ?? ?? C0 03 00 35 E2 23 00 91 61 E2 02 91 E0 23 00 91 78 00 00 35 ?? ?? ?? ?? 02 00 00 14 ?? ?? ?? ?? C0 02 00 34 E2 23 00 91 61 10 80 D2 60 0A 07 91 ?? ?? ?? ?? B5 06 00 B4 E8 53 C2 79 E9 A3 04 91 88 00 00 34 29 09 00 91 28 01 C0 79 C8 FF FF 35 E8 A3 04 91 28 01 08 CB 09 FD 41 93 23 05 00 91 E2 A3 04 91 41 03 00 91 A0 02 00 91 ?? ?? ?? ?? C0 04 00 34 50 00 00 14 80 02 00 91 ?? ?? ?? ?? 00 07 00 34 43 00 80 52 E2 03 00 91 41 0F 00 18 80 02 00 91 ?? ?? ?? ?? 60 00 00 34 E0 03 40 B9 C0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 03 00 B9 08 3C 00 53 60 0A 07 91 68 BA 00 B9 C3 06 00 91 82 02 00 91 61 10 80 D2 ?? ?? ?? ?? C0 0A 00 35 C3 06 00 91 82 02 00 91 41 03 00 91 A0 02 00 91 ?? ?? ?? ?? 40 09 00 35 C3 06 00 91 82 02 00 91 A1 0A 80 D2 60 C2 0B 91 ?? ?? ?? ?? C0 07 00 35 88 02 40 79 48 01 00 34 DF 0E 02 F1 02 01 00 54 C3 06 00 91 82 02 00 91 61 10 80 D2 60 F2 02 91 ?? ?? ?? ?? 60 00 00 34 27 00 00 14 7F 7A 01 79 77 00 00 B4 68 BA 40 B9 E8 02 00 B9 62 0A 07 91 61 03 00 91 20 03 00 91 ?? ?? ?? ?? 80 04 00 35 60 0A 07 91 71 FF FF 17 A8 02 C0 79 AA 02 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 15 CB 09 FD 41 93 23 05 00 91 A2 02 00 91 A1 0A 80 D2 60 C2 0B 91 ?? ?? ?? ?? 40 EC FF 34 2B 00 00 14 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 10 00 20 }
	condition:
		$1
}

rule file_263_82_0 {
	meta:
		name = "_free_locale"
		size = 184
		refs = "0018 __acrt_lock 0040 __acrt_initial_multibyte_data 0050 _free_base 0058 __acrt_unlock 0070 __acrt_release_locale_ref 0084 __acrt_initial_locale_data 0094 __acrt_free_locale"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 D3 04 00 B4 A0 00 80 52 ?? ?? ?? ?? 69 06 40 F9 A9 01 00 B4 28 FD 5F 88 0A 05 00 51 2A FD 08 88 A8 FF FF 35 BF 3B 03 D5 EA 00 00 35 60 06 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? A0 00 80 52 ?? ?? ?? ?? 68 02 40 F9 08 02 00 B4 80 00 80 52 ?? ?? ?? ?? 60 02 40 F9 ?? ?? ?? ?? 60 02 40 F9 00 01 00 B4 08 10 40 B9 C8 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 EB 40 00 00 54 ?? ?? ?? ?? 80 00 80 52 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_263_85_0 {
	meta:
		name = "_get_current_locale"
		size = 192
		refs = "000c __acrt_getptd 001c _calloc_base 0030 __acrt_update_thread_locale_data 0034 __acrt_update_thread_multibyte_data 0074 ??$?RV<lambda_0a55505eb881d180377eb1fc64ffb544>@@AEAV<lambda_862e9a3f04921db6ca1ce3faa2bf3edf>@@V<lambda_c91f0b5e4ab41df1063aa1a95f49bd71>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_0a55505eb881d180377eb1fc64ffb544>@@AEAV<lambda_862e9a3f04921db6ca1ce3faa2bf3edf>@@$$QEAV<lambda_c91f0b5e4ab41df1063aa1a95f49bd71>@@@Z 009c ??$?RV<lambda_a48fd90c2dacdd6561e44078457d03a7>@@AEAV<lambda_ebab98244f73a74f49db879bf13fa982>@@V<lambda_8b3bdacfa7480f205f16cb49964db269>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_a48fd90c2dacdd6561e44078457d03a7>@@AEAV<lambda_ebab98244f73a74f49db879bf13fa982>@@$$QEAV<lambda_8b3bdacfa7480f205f16cb49964db269>@@@Z 00ac _free_base"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 ?? ?? ?? ?? 01 02 80 D2 13 00 00 91 20 00 80 D2 ?? ?? ?? ?? E0 13 00 F9 60 00 00 B5 13 00 80 D2 1F 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 69 4A 40 F9 EA 83 00 91 E8 13 40 F9 E3 53 00 91 EA 17 00 F9 E2 A3 00 91 E1 63 00 91 E0 43 00 91 09 01 00 F9 E9 13 40 F9 68 46 40 F9 28 05 00 F9 88 00 80 52 89 00 80 52 E8 A7 02 29 ?? ?? ?? ?? E8 83 00 91 E8 17 00 F9 A9 00 80 52 A8 00 80 52 E9 A3 02 29 E3 63 00 91 E2 A3 00 91 E1 53 00 91 E0 43 00 91 ?? ?? ?? ?? F3 13 40 F9 FF 13 00 F9 00 00 80 D2 ?? ?? ?? ?? 60 02 00 91 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_87_0 {
	meta:
		name = "_wcreate_locale"
		size = 364
		refs = "0034 _calloc_base 0044 _errno 00ac __acrt_initial_locale_data 00c8 memcpy 00d4 __acrt_add_locale_ref 00e4 _wsetlocale_nolock 00f4 _setmbcp_nolock 011c __acrt_release_locale_ref 0128 __acrt_free_locale 0134 _free_base"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FD 7B BF A9 FD 03 00 91 19 00 00 11 3F 17 00 71 3A 00 00 91 44 9B 40 FA 40 09 00 54 01 02 80 D2 20 00 80 D2 ?? ?? ?? ?? 16 00 00 91 D5 02 00 91 D6 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 16 00 80 D2 3B 00 00 14 01 2B 80 D2 20 00 80 D2 ?? ?? ?? ?? 17 00 00 91 F3 02 00 91 D7 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 16 00 80 D2 2E 00 00 14 01 45 80 D2 20 00 80 D2 ?? ?? ?? ?? 18 00 00 91 14 03 00 91 B8 00 00 B5 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 21 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? FF 02 08 EB 00 01 00 54 02 2B 80 52 ?? ?? ?? ?? E0 02 00 91 ?? ?? ?? ?? E0 02 00 91 FF 12 00 B9 ?? ?? ?? ?? 42 03 00 91 21 03 00 11 E0 02 00 91 ?? ?? ?? ?? 80 01 00 B4 E0 0E 40 B9 01 03 00 91 ?? ?? ?? ?? 00 01 00 35 28 00 80 52 08 03 00 B9 13 00 80 D2 D7 62 00 A9 14 00 80 D2 15 00 80 D2 07 00 00 14 E0 02 00 91 ?? ?? ?? ?? E0 02 00 91 13 00 80 D2 ?? ?? ?? ?? 16 00 80 D2 80 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? A0 02 00 91 ?? ?? ?? ?? C0 02 00 91 02 00 00 14 00 00 80 D2 FD 7B C1 A8 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_88_0 {
	meta:
		name = "_wcscats"
		size = 148
		refs = "0054 wcscat_s 0090 _invoke_watson"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 E3 93 02 A9 E5 9B 03 A9 E7 27 00 F9 FD 7B BE A9 FD 03 00 91 15 00 00 91 E2 13 00 B9 36 00 00 91 F4 23 01 91 13 00 80 52 5F 00 00 71 CD 01 00 54 E8 03 14 CB 09 09 40 92 2A 01 14 8B 54 21 00 91 82 82 5F F8 C1 02 00 91 A0 02 00 91 ?? ?? ?? ?? 20 01 00 35 E8 13 40 B9 73 06 00 11 7F 02 08 6B 8B FE FF 54 FD 7B C2 A8 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_89_0 {
	meta:
		name = "_wsetlocale"
		size = 156
		refs = "001c _errno 0028 _invalid_parameter_noinfo 0034 __acrt_getptd 003c __acrt_eagerly_load_locale_apis 0040 __acrt_update_thread_locale_data 008c ??$?RV<lambda_d8a01803c7231904df012bb083be9e3a>@@AEAV<lambda_b163b37eafe0a13f2c371fafeb0365c9>@@AEAV<lambda_8dff2cf36a5417162780cd64fa2883ef>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_d8a01803c7231904df012bb083be9e3a>@@AEAV<lambda_b163b37eafe0a13f2c371fafeb0365c9>@@AEAV<lambda_8dff2cf36a5417162780cd64fa2883ef>@@@Z"
	strings:
		$1 = { FD 7B B9 A9 FD 03 00 91 E0 17 00 B9 1F 14 00 71 FF 87 02 A9 FF 13 00 F9 E9 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 19 00 00 14 ?? ?? ?? ?? E0 0F 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? EA 0F 40 F9 EB 63 00 91 E3 E3 00 91 EB 1F 00 F9 E2 03 01 91 E1 43 00 91 48 A9 43 B9 E0 43 00 91 09 01 1C 32 E8 A3 00 91 49 A9 03 B9 E8 23 00 F9 E9 63 00 91 E8 83 00 91 E9 A3 04 A9 E8 C3 00 91 E9 53 00 91 E9 A3 05 A9 ?? ?? ?? ?? E0 13 40 F9 FD 7B C7 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_263_90_0 {
	meta:
		name = "_wsetlocale_get_all"
		size = 492
		refs = "0028 _malloc_base 0064 __lc_category 0074 ??_C@_13NMPKAAJP@?$AA?$DN?$AA?$AA@ 008c _wcscats 0090 ??_C@_13PJJBFPED@?$AA?$DL?$AA?$AA@ 00a0 wcscat_s 00c4 wcscmp 0130 _free_base 01e8 _invoke_watson"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 23 00 F9 FD 7B BF A9 FD 03 00 91 14 00 00 91 C0 D4 80 D2 37 00 80 52 ?? ?? ?? ?? 15 00 00 91 35 01 00 B5 00 00 80 D2 FD 7B C1 A8 FB 23 40 F9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 B6 12 00 91 28 00 80 52 DF 02 00 79 A8 02 00 B9 ?? ?? ?? ?? 85 26 40 F9 ?? ?? ?? ?? 03 0F 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 62 00 80 52 21 6A 80 D2 C0 02 00 91 39 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 21 6A 80 D2 C0 02 00 91 ?? ?? ?? ?? 80 09 00 35 33 07 00 11 68 7E 40 93 29 7F 40 93 8B 16 08 8B 8A 16 09 8B 61 15 40 F9 40 15 40 F9 ?? ?? ?? ?? 79 02 00 11 28 7F 40 93 0A 03 80 D2 89 16 08 8B 0A 7D 0A 9B 1F 00 00 71 25 15 40 F9 ?? ?? ?? ?? 62 00 80 52 43 69 78 F8 21 6A 80 D2 C0 02 00 91 F7 13 97 1A ?? ?? ?? ?? 3F 17 00 71 8B FC FF 54 37 03 00 35 89 1E 40 F9 29 01 00 B4 28 FD 5F 88 0A 05 00 51 2A FD 08 88 A8 FF FF 35 BF 3B 03 D5 6A 00 00 35 80 1E 40 F9 ?? ?? ?? ?? 89 1A 40 F9 29 01 00 B4 28 FD 5F 88 0A 05 00 51 2A FD 08 88 A8 FF FF 35 BF 3B 03 D5 6A 00 00 35 80 1A 40 F9 ?? ?? ?? ?? 9F 56 03 A9 C0 02 00 91 9F 5A 02 A9 B4 FF FF 17 A0 02 00 91 ?? ?? ?? ?? 89 1E 40 F9 29 01 00 B4 28 FD 5F 88 0A 05 00 51 2A FD 08 88 A8 FF FF 35 BF 3B 03 D5 6A 00 00 35 80 1E 40 F9 ?? ?? ?? ?? 89 1A 40 F9 29 01 00 B4 28 FD 5F 88 0A 05 00 51 2A FD 08 88 A8 FF FF 35 BF 3B 03 D5 6A 00 00 35 80 1A 40 F9 ?? ?? ?? ?? 80 36 40 F9 9F 7E 03 A9 9F 7E 02 A9 9A FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_91_0 {
	meta:
		name = "_wsetlocale_nolock"
		size = 612
		refs = "001c __security_push_cookie 0034 _wsetlocale_set_cat 007c ??_C@_13PJJBFPED@?$AA?$DL?$AA?$AA@ 0080 ??_C@_15NBPDDFIP@?$AA?$DN?$AA?$DL?$AA?$AA@ 008c wcspbrk 00b4 __lc_category 00d4 wcsncmp 011c wcscspn 0150 wcsncpy_s 01c0 _expandlocale 01dc wcscmp 0220 _wsetlocale_get_all 0228 __security_pop_cookie 0248 __report_rangecheckfailure 0260 _invoke_watson"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 73 05 A9 FD 03 00 91 ?? ?? ?? ?? FF C3 06 D1 15 00 00 91 53 00 00 91 01 01 00 34 73 00 00 B4 ?? ?? ?? ?? 7B 00 00 14 28 7C 40 93 A9 16 08 8B 20 15 40 F9 77 00 00 14 37 00 80 52 14 00 80 52 53 0E 00 B4 68 02 40 79 1F 31 01 71 41 0A 00 54 68 06 40 79 1F 0D 01 71 E1 09 00 54 68 0A 40 79 1F 7D 01 71 81 09 00 54 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 17 00 00 91 77 08 00 B4 E8 02 13 CB 18 FD 41 93 18 08 00 B4 E9 02 40 79 3F ED 00 71 A0 07 00 54 36 00 80 52 ?? ?? ?? ?? CA 7E 40 93 0B 03 80 D2 59 7D 0B 9B ?? ?? ?? ?? 02 03 00 91 61 02 00 91 20 6B 7A F8 ?? ?? ?? ?? 60 01 00 35 2B 6B 7A F8 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0B CB 1F 07 8A EB 80 00 00 54 D6 06 00 11 DF 16 00 71 6D FD FF 54 F3 0A 00 91 60 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 17 00 00 91 97 00 00 B5 68 02 40 79 1F ED 00 71 61 03 00 54 DF 16 00 71 4C 02 00 54 E3 02 00 91 62 02 00 91 61 10 80 D2 E0 03 00 91 ?? ?? ?? ?? C0 07 00 35 E8 FA 7F D3 1F 19 04 F1 42 07 00 54 E9 03 00 91 E2 03 00 91 1F 69 29 78 C1 02 00 11 A0 02 00 91 ?? ?? ?? ?? 40 00 00 B4 94 06 00 11 69 06 17 8B 28 01 40 79 88 00 00 34 33 09 00 91 69 02 40 79 69 F7 FF 35 14 04 00 35 00 00 80 D2 20 00 00 14 05 00 80 D2 A4 0A 80 D2 E3 23 04 91 62 10 80 D2 E1 03 00 91 60 02 00 91 ?? ?? ?? ?? 00 03 00 B4 13 00 80 52 B6 A2 00 91 B3 01 00 34 C1 02 40 F9 E0 03 00 91 ?? ?? ?? ?? 00 01 00 34 E2 03 00 91 61 02 00 11 A0 02 00 91 ?? ?? ?? ?? 60 00 00 B5 17 00 80 52 02 00 00 14 94 06 00 11 73 06 00 11 7F 16 00 71 D6 82 00 91 0D FE FF 54 57 00 00 35 54 FC FF 34 A0 02 00 91 ?? ?? ?? ?? FF C3 06 91 ?? ?? ?? ?? FB 73 45 A9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_263_92_0 {
	meta:
		name = "_wsetlocale_set_cat"
		size = 792
		refs = "001c __security_push_cookie 0030 __acrt_getptd 0050 _expandlocale 0060 __security_pop_cookie 0094 wcscmp 00d0 _malloc_base 0104 wcscpy_s 0130 __acrt_copy_locale_name 01a0 _first_127char 01bc __acrt_GetStringTypeA 01e8 _ctype_loc_style 0200 memcmp 0254 __lc_category 0260 __guard_check_icall_fptr 0284 _free_base 02a4 __acrt_wide_c_locale_string 0314 _invoke_watson"
	strings:
		$1 = { FD 7B BA A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 6B 04 A9 FB 73 05 A9 FD 03 00 91 ?? ?? ?? ?? FF 03 0B D1 14 00 00 91 38 00 00 11 53 00 00 91 ?? ?? ?? ?? 15 20 0B 91 60 02 00 91 E5 03 00 91 A4 0A 80 D2 E3 63 04 91 62 10 80 D2 E1 43 00 91 ?? ?? ?? ?? 60 01 00 B5 00 00 80 D2 FF 03 0B 91 ?? ?? ?? ?? FB 73 45 A9 F9 6B 44 A9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C6 A8 C0 03 5F D6 1C 7F 40 93 96 16 1C 8B E0 43 00 91 D3 16 40 F9 61 02 00 91 ?? ?? ?? ?? 60 00 00 35 60 02 00 91 EF FF FF 17 E8 23 C0 79 EA 43 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 E8 43 00 91 48 01 08 CB 13 FD 41 93 69 0E 00 91 20 F9 7F D3 ?? ?? ?? ?? 19 00 00 91 19 FC FF B4 97 97 00 91 DB 16 40 F9 88 7A 77 F8 3A 13 00 91 E2 43 00 91 61 06 00 91 40 03 00 91 E8 07 00 F9 88 0E 40 B9 E8 07 00 B9 ?? ?? ?? ?? C0 0F 00 35 E8 23 40 79 DA 16 00 F9 1F 0D 01 71 A1 00 00 54 E8 27 40 79 68 00 00 35 9F 7A 37 F8 04 00 00 14 E0 63 04 91 ?? ?? ?? ?? 80 7A 37 F8 3A 00 80 52 1F 0B 00 71 41 07 00 54 E8 03 40 B9 0B 00 80 52 88 0E 00 B9 A9 12 40 F9 6C 7D 7D 93 88 0E 40 B9 8A 69 75 B8 1F 01 0A 6B 00 01 00 54 88 69 75 F8 6B 05 00 11 89 69 35 F8 7F 15 00 71 09 01 00 91 CB FE FF 54 05 00 00 14 8B 00 00 34 A8 DA 6B F8 A8 02 00 F9 A9 DA 2B F8 7F 15 00 71 21 04 00 54 85 0E 40 B9 ?? ?? ?? ?? 26 00 80 52 E4 23 07 91 E3 0F 80 52 ?? ?? ?? ?? 21 00 80 52 00 00 80 D2 ?? ?? ?? ?? 80 02 00 34 0A 00 80 52 E9 23 07 91 28 D9 6A 78 08 21 00 12 28 D9 2A 78 4A 05 00 11 49 7D 40 93 3F FD 01 F1 23 FF FF 54 ?? ?? ?? ?? ?? ?? ?? ?? 44 00 80 52 43 00 80 52 C2 1F 80 D2 E0 23 07 91 ?? ?? ?? ?? 60 00 00 35 BA 06 00 B9 02 00 00 14 BF 06 00 B9 88 0E 40 B9 A8 02 00 B9 A8 06 40 B9 88 1E 00 B9 0A 00 00 14 1F 07 00 71 81 00 00 54 E8 03 40 B9 88 16 00 B9 05 00 00 14 1F 17 00 71 61 00 00 54 E8 03 40 B9 88 1A 00 B9 08 03 80 D2 89 7F 08 9B ?? ?? ?? ?? ?? ?? ?? ?? 33 69 68 F8 ?? ?? ?? ?? ?? ?? ?? ?? 6F 02 00 91 00 01 3F D6 80 02 00 91 60 02 3F D6 60 01 00 34 DB 16 00 F9 80 7A 77 F8 ?? ?? ?? ?? E8 07 40 F9 20 03 00 91 88 7A 37 F8 ?? ?? ?? ?? E8 07 40 B9 88 0E 00 B9 6E FF FF 17 ?? ?? ?? ?? ?? ?? ?? ?? 7F 03 08 EB 00 02 00 54 CB 1E 40 F9 69 FD 5F 88 2A 05 00 51 6A FD 09 88 A9 FF FF 35 BF 3B 03 D5 2A 01 00 35 C0 1E 40 F9 ?? ?? ?? ?? C0 1A 40 F9 ?? ?? ?? ?? 80 7A 77 F8 ?? ?? ?? ?? DF 16 00 F9 9F 7A 37 F8 3A 03 00 B9 C0 16 40 F9 D9 1E 00 F9 58 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_264_0_0 {
	meta:
		name = "__strncnt"
		size = 40
	strings:
		$1 = { 0A 00 00 91 48 01 C0 39 00 00 80 D2 C8 00 00 34 1F 00 01 EB 80 00 00 54 00 04 00 91 09 68 EA 38 89 FF FF 35 C0 03 5F D6 }
	condition:
		$1
}

rule file_265_0_0 {
	meta:
		name = "ctanhl"
		size = 292
		refs = "0010 creall 0020 cimagl 002c _ldtest 0044 _LZero_C 00ac _LNan_C 00bc tan 00c8 sinh 00d4 _LInf_C 0114 _LCbuild"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 E0 87 02 6D ?? ?? ?? ?? E1 1B 40 FD E0 0F 00 FD E0 17 40 FD ?? ?? ?? ?? E0 63 00 91 E0 0B 00 FD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 06 00 71 C1 01 00 54 ?? ?? ?? ?? E8 2F 40 79 F4 03 67 9E ?? ?? ?? ?? 12 10 6E 1E 1F 01 11 72 11 42 61 1E 21 1E 74 1E F1 0F 40 FD 28 22 60 1E 13 10 7E 1E 60 3E 72 1E 28 00 00 14 1F 08 00 71 81 00 00 54 E0 0B 40 FD 01 40 60 1E 23 00 00 14 7F 0A 00 71 A1 00 00 54 F0 03 41 6D 08 22 60 1E 01 0E 60 1E 1D 00 00 14 1F 04 00 71 81 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F4 FF FF 17 E0 0B 40 FD ?? ?? ?? ?? E0 13 00 FD E0 0F 40 FD ?? ?? ?? ?? F3 13 40 FD 12 10 6E 1E ?? ?? ?? ?? ?? ?? ?? ?? 70 4A 53 1F 15 0A 60 1E B4 4A 40 1F 80 22 71 1E A1 00 00 54 F4 03 67 9E 08 20 60 1E 61 0A 74 1E DC FF FF 17 10 48 40 1F 61 1A 74 1E 11 C2 61 1E 32 0A 75 1E 40 1A 74 1E ?? ?? ?? ?? FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_675_0_0 {
	meta:
		name = "ctanh"
		size = 292
		refs = "0010 creal 0020 cimag 002c _dtest 0044 _Zero_C 00ac _Nan_C 00bc tan 00c8 sinh 00d4 _Inf_C 0114 _Cbuild"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 E0 87 02 6D ?? ?? ?? ?? E1 1B 40 FD E0 0F 00 FD E0 17 40 FD ?? ?? ?? ?? E0 63 00 91 E0 0B 00 FD ?? ?? ?? ?? 13 00 00 11 E0 43 00 91 ?? ?? ?? ?? 7F 06 00 71 C1 01 00 54 ?? ?? ?? ?? E8 2F 40 79 F4 03 67 9E ?? ?? ?? ?? 12 10 6E 1E 1F 01 11 72 11 42 61 1E 21 1E 74 1E F1 0F 40 FD 28 22 60 1E 13 10 7E 1E 60 3E 72 1E 28 00 00 14 1F 08 00 71 81 00 00 54 E0 0B 40 FD 01 40 60 1E 23 00 00 14 7F 0A 00 71 A1 00 00 54 F0 03 41 6D 08 22 60 1E 01 0E 60 1E 1D 00 00 14 1F 04 00 71 81 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? F4 FF FF 17 E0 0B 40 FD ?? ?? ?? ?? E0 13 00 FD E0 0F 40 FD ?? ?? ?? ?? F3 13 40 FD 12 10 6E 1E ?? ?? ?? ?? ?? ?? ?? ?? 70 4A 53 1F 15 0A 60 1E B4 4A 40 1F 80 22 71 1E A1 00 00 54 F4 03 67 9E 08 20 60 1E 61 0A 74 1E DC FF FF 17 10 48 40 1F 61 1A 74 1E 11 C2 61 1E 32 0A 75 1E 40 1A 74 1E ?? ?? ?? ?? FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_266_1_0 {
	meta:
		name = "tan"
		size = 632
		refs = "0058 _controlfp_s 0084 tan_piby4 00b0 _handle_nan 00b8 ??_C@_03IIINPABG@tan?$AA@ 00e0 _handle_error 01e8 __remainder_piby2"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 0A 00 66 9E C8 0F 00 58 13 40 60 1E 49 F9 40 92 F3 CF 01 6D 3F 01 08 EB 88 03 00 54 08 E4 E7 D2 3F 01 08 EB 42 02 00 54 08 C8 E7 D2 3F 01 08 EB 42 01 00 54 49 00 00 B5 11 00 00 14 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? E0 13 40 FD 0A 00 00 14 70 0A 73 1E 51 0D 00 5C 12 0A 73 1E 40 4E 51 1F 05 00 00 14 00 00 80 52 E1 03 67 9E 60 42 60 1E ?? ?? ?? ?? FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 48 29 4C 92 0B FE EF D2 1F 01 0B EB 41 02 00 54 48 CD 40 92 88 00 00 B4 40 01 00 91 ?? ?? ?? ?? F5 FF FF 17 ?? ?? ?? ?? E1 03 67 9E 60 42 60 1E ?? ?? ?? ?? 26 00 80 52 25 04 80 52 04 01 80 52 23 00 80 52 02 FF FF D2 01 04 80 52 ?? ?? ?? ?? E9 FF FF 17 3F 01 0A EB F3 07 9F 1A 53 00 00 34 73 42 61 1E 10 09 00 5C 60 22 70 1E C2 06 00 54 E8 08 00 58 3F 01 08 EB 2A FD 74 D3 A8 00 00 54 A8 08 00 58 4C 00 80 52 2B 00 80 52 07 00 00 14 68 08 00 58 3F 01 08 EB E8 00 00 54 48 08 00 58 8C 00 80 52 6B 00 80 52 3F 01 08 EB 89 81 8B 1A 05 00 00 14 D1 07 00 5C 10 10 6C 1E 71 42 51 1F 29 02 78 1E 3A 01 62 1E 72 07 00 5C 59 CF 52 1F 73 07 00 5C 54 0B 73 1E F9 13 00 FD E8 13 40 F9 08 F9 74 D3 4B 01 08 CB 7F 3D 00 F1 29 02 00 54 B0 06 00 5C 7F C1 00 F1 31 43 60 1E 94 06 00 5C 59 E7 50 1F 31 3A 79 1E 52 C7 50 1F 54 CB 74 1F 09 01 00 54 13 06 00 5C 38 43 60 1E 16 06 00 5C 59 E7 53 1F 14 3B 79 1E 55 D3 53 1F 54 D7 76 1F 20 3B 74 1E 28 05 00 12 30 3B 60 1E 01 3A 74 1E 08 00 00 14 60 42 60 1E E2 63 00 91 E1 C3 00 91 E0 A3 00 91 ?? ?? ?? ?? E0 87 42 6D E8 1B 40 B9 00 01 00 12 73 F4 FF 34 ?? ?? ?? ?? 00 40 61 1E A1 FF FF 17 18 2D 44 54 FB 21 E9 3F 55 55 55 55 55 55 D5 3F 00 00 00 00 80 84 1E 41 5E 38 55 29 7A 6A 0F 40 D2 21 33 7F 7C D9 02 40 BB B2 CC BE 3A 46 1C 40 75 A7 BB E9 BB FD 15 40 83 C8 C9 6D 30 5F E4 3F 00 00 40 54 FB 21 F9 3F 31 63 62 1A 61 B4 D0 3D 00 00 60 1A 61 B4 D0 3D 73 70 03 2E 8A 19 A3 3B 00 00 00 2E 8A 19 A3 3B C1 49 20 25 9A 83 7B 39 }
	condition:
		$1
}

rule file_266_2_0 {
	meta:
		name = "tan_piby4"
		size = 424
	strings:
		$1 = { FF 43 00 D1 70 0A 00 5C 08 00 80 52 00 20 70 1E 0D 01 00 54 31 0A 00 5C 28 00 80 52 34 0A 00 5C 32 3A 60 1E 91 3A 61 1E 40 2A 71 1E 0A 00 00 14 D2 09 00 5C 00 20 72 1E 02 01 00 54 F1 08 00 5C 08 00 80 12 F4 08 00 5C 13 28 71 1E 30 28 74 1E 60 2A 70 1E E1 03 67 9E 1D 10 60 1E B4 08 00 5C D2 08 00 5C 11 08 7D 1E D7 08 00 5C F0 08 00 5C 33 0A 61 1E 1B 4C 40 1F 75 CB 74 1F B4 08 00 5C B6 52 5B 1F 75 0B 60 1E DA 0A 75 1E 76 08 00 5C 78 DB 57 1F 77 08 00 5C 19 C3 7B 1F 38 5F 5B 1F 59 1B 78 1E 3C 2B 61 1E 48 02 00 34 91 2B 60 1E 15 10 6E 1E 00 01 00 34 32 0A 7D 1E 31 3A 75 1E 10 01 62 1E 52 1A 71 1E 53 3A 75 1E 60 0A 70 1E 1E 00 00 14 32 2A 75 1E 34 0A 7D 1E 13 01 62 1E 94 1A 72 1E B5 3A 74 1E A0 0A 73 1E 17 00 00 14 A0 02 00 34 91 2B 60 1E 10 10 7E 1E 15 10 6E 1E 16 1A 71 1E F1 03 00 FD 28 02 66 9E 08 7D 60 92 E8 07 00 F9 F2 07 40 FD 51 3A 60 1E 93 3B 71 1E C8 02 66 9E F6 03 00 FD 08 7D 60 92 14 01 67 9E E8 03 00 F9 92 56 52 1F 70 4A 54 1F 00 52 56 1F 02 00 00 14 80 2B 60 1E FF 43 00 91 C0 03 5F D6 C3 F5 28 5C 8F C2 E5 3F 18 2D 44 54 FB 21 E9 3F 06 5C 14 33 26 A6 81 3C C3 F5 28 5C 8F C2 E5 BF 5A 38 9C 28 AF 5D 2D 3F BB 9A 56 C7 24 7C 97 3F F8 98 6D EF 17 75 2E 3F 0F B9 9E 49 46 80 E0 3F 4A 56 38 66 0F D5 D7 3F CF 0A 0A F8 F4 B0 9A 3F B8 40 AA 8C CB DF F1 3F }
	condition:
		$1
}

rule file_267_0_0 {
	meta:
		name = "??$common_xtox@KD@@YAHKQEAD_KI_N@Z"
		size = 192
		refs = "007c _errno 0088 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 2A 00 00 91 0B 00 80 D2 C4 00 00 34 A8 05 80 52 28 00 00 39 2A 04 00 91 2B 00 80 D2 E0 03 00 4B 4C 01 00 91 43 00 00 35 80 00 3E D4 08 08 C3 1A 09 81 03 1B 00 01 00 11 3F 25 00 71 89 00 00 54 28 5D 01 11 48 01 00 39 03 00 00 14 29 C1 00 11 49 01 00 39 4A 05 00 91 6B 05 00 91 60 00 00 34 7F 01 02 EB 03 FE FF 54 7F 01 02 EB 03 01 00 54 3F 00 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 0A 00 00 14 5F 01 00 39 4B 05 00 D1 69 F5 DF 38 88 15 C0 38 68 05 00 39 9F 01 0B EB 89 F1 1F 38 63 FF FF 54 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_1_0 {
	meta:
		name = "??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
		size = 192
		refs = "007c _errno 0088 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 2C 00 00 91 0E 00 80 D2 C4 00 00 34 A8 05 80 52 28 00 00 79 2C 08 00 91 2E 00 80 D2 E0 03 00 4B 8D 01 00 91 43 00 00 35 80 00 3E D4 08 08 C3 1A 09 81 03 1B 00 01 00 11 3F 25 00 71 89 00 00 54 28 5D 01 11 88 01 00 79 03 00 00 14 2A C1 00 11 8A 01 00 79 8C 09 00 91 CE 05 00 91 60 00 00 34 DF 01 02 EB 03 FE FF 54 DF 01 02 EB 03 01 00 54 3F 00 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 0A 00 00 14 9F 01 00 79 8A 09 00 D1 49 E5 5F 78 A8 25 40 78 48 05 00 79 BF 01 0A EB A9 E1 1F 78 63 FF FF 54 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_2_0 {
	meta:
		name = "??$common_xtox@_KD@@YAH_KQEAD0I_N@Z"
		size = 196
		refs = "0080 _errno 008c _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 2B 00 00 91 0D 00 80 D2 C4 00 00 34 A8 05 80 52 28 00 00 39 2B 04 00 91 2D 00 80 D2 E0 03 00 CB 6C 01 00 91 6E 7C 40 D3 4E 00 00 B5 80 00 3E D4 09 08 CE 9A 28 81 0E 9B 20 01 00 91 1F 25 00 71 89 00 00 54 09 5D 01 11 69 01 00 39 03 00 00 14 0A C1 00 11 6A 01 00 39 6B 05 00 91 AD 05 00 91 60 00 00 B4 BF 01 02 EB 03 FE FF 54 BF 01 02 EB 03 01 00 54 3F 00 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 0A 00 00 14 7F 01 00 39 6A 05 00 D1 49 F5 DF 38 88 15 C0 38 48 05 00 39 9F 01 0A EB 89 F1 1F 38 63 FF FF 54 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_3_0 {
	meta:
		name = "??$common_xtox@_K_W@@YAH_KQEA_W0I_N@Z"
		size = 196
		refs = "0080 _errno 008c _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 2D 00 00 91 0F 00 80 D2 C4 00 00 34 A8 05 80 52 28 00 00 79 2D 08 00 91 2F 00 80 D2 E0 03 00 CB AE 01 00 91 67 7C 40 D3 47 00 00 B5 80 00 3E D4 09 08 C7 9A 28 81 07 9B 20 01 00 91 1F 25 00 71 89 00 00 54 09 5D 01 11 A9 01 00 79 03 00 00 14 0B C1 00 11 AB 01 00 79 AD 09 00 91 EF 05 00 91 60 00 00 B4 FF 01 02 EB 03 FE FF 54 FF 01 02 EB 03 01 00 54 3F 00 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 0A 00 00 14 BF 01 00 79 AA 09 00 D1 49 E5 5F 78 C8 25 40 78 48 05 00 79 DF 01 0A EB C9 E1 1F 78 63 FF FF 54 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_4_0 {
	meta:
		name = "??$common_xtox_s@KD@@YAHKQEAD_KI_N@Z"
		size = 136
		refs = "0010 _errno 001c _invalid_parameter_noinfo 0078 ??$common_xtox@KD@@YAHKQEAD_KI_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 E1 00 00 B5 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 16 00 00 14 C2 01 00 B4 9F 00 00 71 3F 00 00 39 49 00 80 D2 28 00 80 D2 28 11 88 9A 5F 00 08 EB 88 00 00 54 ?? ?? ?? ?? 53 04 80 52 06 00 00 14 68 08 00 51 1F 89 00 71 E9 00 00 54 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 02 00 00 14 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_6_0 {
	meta:
		name = "??$common_xtox_s@_KD@@YAH_KQEAD0I_N@Z"
		size = 136
		refs = "0010 _errno 001c _invalid_parameter_noinfo 0078 ??$common_xtox@_KD@@YAH_KQEAD0I_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 E1 00 00 B5 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 16 00 00 14 C2 01 00 B4 9F 00 00 71 3F 00 00 39 49 00 80 D2 28 00 80 D2 28 11 88 9A 5F 00 08 EB 88 00 00 54 ?? ?? ?? ?? 53 04 80 52 06 00 00 14 68 08 00 51 1F 89 00 71 E9 00 00 54 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 02 00 00 14 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_5_0 {
	meta:
		name = "??$common_xtox_s@K_W@@YAHKQEA_W_KI_N@Z"
		size = 136
		refs = "0010 _errno 001c _invalid_parameter_noinfo 0078 ??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 E1 00 00 B5 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 16 00 00 14 C2 01 00 B4 9F 00 00 71 3F 00 00 79 49 00 80 D2 28 00 80 D2 28 11 88 9A 5F 00 08 EB 88 00 00 54 ?? ?? ?? ?? 53 04 80 52 06 00 00 14 68 08 00 51 1F 89 00 71 E9 00 00 54 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 02 00 00 14 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_7_0 {
	meta:
		name = "??$common_xtox_s@_K_W@@YAH_KQEA_W0I_N@Z"
		size = 136
		refs = "0010 _errno 001c _invalid_parameter_noinfo 0078 ??$common_xtox@_K_W@@YAH_KQEA_W0I_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 E1 00 00 B5 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 16 00 00 14 C2 01 00 B4 9F 00 00 71 3F 00 00 79 49 00 80 D2 28 00 80 D2 28 11 88 9A 5F 00 08 EB 88 00 00 54 ?? ?? ?? ?? 53 04 80 52 06 00 00 14 68 08 00 51 1F 89 00 71 E9 00 00 54 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 02 00 00 14 ?? ?? ?? ?? FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_8_0 {
	meta:
		name = "_i64toa"
		size = 56
		refs = "0024 ??$common_xtox@_KD@@YAH_KQEAD0I_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 5F 28 00 71 04 08 40 FA 43 00 00 11 E4 A7 9F 1A 02 00 80 92 33 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_10_0 {
	meta:
		name = "_i64tow"
		size = 56
		refs = "0024 ??$common_xtox@_K_W@@YAH_KQEA_W0I_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 5F 28 00 71 04 08 40 FA 43 00 00 11 E4 A7 9F 1A 02 00 80 92 33 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_9_0 {
	meta:
		name = "_i64toa_s"
		size = 16
		refs = "000c ??$common_xtox_s@_KD@@YAH_KQEAD0I_N@Z"
	strings:
		$1 = { 7F 28 00 71 04 08 40 FA E4 A7 9F 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_11_0 {
	meta:
		name = "_i64tow_s"
		size = 16
		refs = "000c ??$common_xtox_s@_K_W@@YAH_KQEA_W0I_N@Z"
	strings:
		$1 = { 7F 28 00 71 04 08 40 FA E4 A7 9F 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_12_0 {
	meta:
		name = "_itoa"
		size = 56
		refs = "0024 ??$common_xtox@KD@@YAHKQEAD_KI_N@Z"
		altNames = "_ltoa"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 5F 28 00 71 04 08 40 7A 43 00 00 11 E4 A7 9F 1A 02 00 80 92 33 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_14_0 {
	meta:
		name = "_itow"
		size = 56
		refs = "0024 ??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 5F 28 00 71 04 08 40 7A 43 00 00 11 E4 A7 9F 1A 02 00 80 92 33 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_18_0 {
	meta:
		name = "_ltow"
		size = 56
		refs = "0024 ??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 5F 28 00 71 04 08 40 7A 43 00 00 11 E4 A7 9F 1A 02 00 80 92 33 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_13_0 {
	meta:
		name = "_itoa_s"
		size = 16
		refs = "000c ??$common_xtox_s@KD@@YAHKQEAD_KI_N@Z"
		altNames = "_ltoa_s"
	strings:
		$1 = { 7F 28 00 71 04 08 40 7A E4 A7 9F 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_15_0 {
	meta:
		name = "_itow_s"
		size = 16
		refs = "000c ??$common_xtox_s@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { 7F 28 00 71 04 08 40 7A E4 A7 9F 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_19_0 {
	meta:
		name = "_ltow_s"
		size = 16
		refs = "000c ??$common_xtox_s@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { 7F 28 00 71 04 08 40 7A E4 A7 9F 1A ?? ?? ?? ?? }
	condition:
		$1
}

rule file_267_20_0 {
	meta:
		name = "_ui64toa"
		size = 48
		refs = "001c ??$common_xtox@_KD@@YAH_KQEAD0I_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 43 00 00 11 02 00 80 92 04 00 80 52 33 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_22_0 {
	meta:
		name = "_ui64tow"
		size = 48
		refs = "001c ??$common_xtox@_K_W@@YAH_KQEA_W0I_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 43 00 00 11 02 00 80 92 04 00 80 52 33 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_24_0 {
	meta:
		name = "_ultoa"
		size = 48
		refs = "001c ??$common_xtox@KD@@YAHKQEAD_KI_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 43 00 00 11 02 00 80 92 04 00 80 52 33 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_267_26_0 {
	meta:
		name = "_ultow"
		size = 48
		refs = "001c ??$common_xtox@K_W@@YAHKQEA_W_KI_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 43 00 00 11 02 00 80 92 04 00 80 52 33 00 00 91 ?? ?? ?? ?? 60 02 00 91 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_268_9_0 {
	meta:
		name = "_fclose_nolock"
		size = 144
		refs = "0014 _errno 0020 _invalid_parameter_noinfo 0040 __acrt_stdio_flush_nolock 004c __acrt_stdio_free_buffer_nolock 0054 _fileno 0058 _close 0070 _free_base 007c ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 17 00 00 14 68 16 40 B9 14 00 80 12 BF 3B 03 D5 08 02 68 36 60 02 00 91 ?? ?? ?? ?? 14 00 00 11 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 60 00 F8 36 14 00 80 12 05 00 00 14 60 16 40 F9 60 00 00 B4 ?? ?? ?? ?? 7F 16 00 F9 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_268_10_0 {
	meta:
		name = "fclose"
		size = 112
		refs = "0018 _errno 0024 _invalid_parameter_noinfo 0040 ?__acrt_stdio_free_stream@@YAXV__crt_stdio_stream@@@Z 0048 _lock_file 0050 _fclose_nolock 005c _unlock_file"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 B3 0B 00 F9 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 0E 00 00 14 68 16 40 B9 BF 3B 03 D5 60 02 00 91 68 00 60 36 ?? ?? ?? ?? F9 FF FF 17 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 14 00 00 11 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_269_1_0 {
	meta:
		name = "__dcrt_terminate_console_output"
		size = 40
		refs = "0000 __dcrt_lowio_console_output_handle 0014 __imp_CloseHandle"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 08 08 00 91 1F 05 00 F1 A9 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 C0 03 5F D6 }
	condition:
		$1
}

rule file_606_1_0 {
	meta:
		name = "__dcrt_terminate_console_input"
		size = 40
		refs = "0000 __dcrt_lowio_console_input_handle 0014 __imp_CloseHandle"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 08 08 00 91 1F 05 00 F1 A9 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 C0 03 5F D6 }
	condition:
		$1
}

rule file_271_0_0 {
	meta:
		name = "_ldrint"
		size = 244
		refs = "000c fegetround 0034 _ld_int"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD ?? ?? ?? ?? E0 03 00 34 1F 00 04 71 A0 02 00 54 1F 00 08 71 20 01 00 54 1F 00 0C 71 81 00 00 54 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 40 FF FF 34 E8 2F 40 79 08 FF 7F 37 F0 0B 40 FD 12 10 6E 1E 00 2A 72 1E F5 FF FF 17 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 00 FE FF 34 E8 2F 40 79 C8 FD 7F 36 12 10 6E 1E 18 00 00 14 21 00 80 52 E0 43 00 91 ?? ?? ?? ?? 01 00 80 52 A0 01 00 35 E0 43 00 91 ?? ?? ?? ?? 80 FC FF 34 01 00 80 12 E0 43 00 91 ?? ?? ?? ?? 00 FC FF 34 12 10 60 1E 08 00 00 14 F1 0B 40 FD 20 2A 72 1E DC FF FF 17 E0 43 00 91 ?? ?? ?? ?? 00 FB FF 34 12 10 6E 1E E8 2F 40 79 08 FF 7F 36 F0 0B 40 FD 00 3A 72 1E D3 FF FF 17 }
	condition:
		$1
}

rule file_494_0_0 {
	meta:
		name = "_drint"
		size = 244
		refs = "000c fegetround 0034 _d_int"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 0B 00 FD ?? ?? ?? ?? E0 03 00 34 1F 00 04 71 A0 02 00 54 1F 00 08 71 20 01 00 54 1F 00 0C 71 81 00 00 54 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 40 FF FF 34 E8 2F 40 79 08 FF 7F 37 F0 0B 40 FD 12 10 6E 1E 00 2A 72 1E F5 FF FF 17 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 00 FE FF 34 E8 2F 40 79 C8 FD 7F 36 12 10 6E 1E 18 00 00 14 21 00 80 52 E0 43 00 91 ?? ?? ?? ?? 01 00 80 52 A0 01 00 35 E0 43 00 91 ?? ?? ?? ?? 80 FC FF 34 01 00 80 12 E0 43 00 91 ?? ?? ?? ?? 00 FC FF 34 12 10 60 1E 08 00 00 14 F1 0B 40 FD 20 2A 72 1E DC FF FF 17 E0 43 00 91 ?? ?? ?? ?? 00 FB FF 34 12 10 6E 1E E8 2F 40 79 08 FF 7F 36 F0 0B 40 FD 00 3A 72 1E D3 FF FF 17 }
	condition:
		$1
}

rule file_271_1_0 {
	meta:
		name = "rintl"
		size = 80
		refs = "0010 _ldtest 0020 _ldrint 003c _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? E0 0B 40 FD 1F 08 00 71 69 01 00 54 ?? ?? ?? ?? F0 0B 40 FD 11 40 60 1E F1 0F 00 FD 20 22 70 1E 80 00 00 54 00 04 80 52 ?? ?? ?? ?? F1 0F 40 FD 20 42 60 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_494_1_0 {
	meta:
		name = "rint"
		size = 80
		refs = "0010 _dtest 0020 _drint 003c _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? E0 0B 40 FD 1F 08 00 71 69 01 00 54 ?? ?? ?? ?? F0 0B 40 FD 11 40 60 1E F1 0F 00 FD 20 22 70 1E 80 00 00 54 00 04 80 52 ?? ?? ?? ?? F1 0F 40 FD 20 42 60 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_272_0_0 {
	meta:
		name = "?get_terminate_or_default@@YAP6AXXZQEBU__acrt_ptd@@@Z"
		size = 24
		refs = "0004 abort"
	strings:
		$1 = { 09 0C 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? 3F 01 00 F1 20 11 88 9A C0 03 5F D6 }
	condition:
		$1
}

rule file_272_1_0 {
	meta:
		name = "_get_terminate"
		size = 40
		refs = "0008 __acrt_getptd 000c abort"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 0C 40 F9 ?? ?? ?? ?? 3F 01 00 F1 20 11 88 9A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_272_2_0 {
	meta:
		name = "set_terminate"
		size = 60
		refs = "0010 __acrt_getptd 001c abort"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 ?? ?? ?? ?? 0A 00 00 91 49 0D 40 F9 ?? ?? ?? ?? 53 0D 00 F9 ?? ?? ?? ?? 3F 01 00 F1 20 11 88 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_272_3_0 {
	meta:
		name = "terminate"
		size = 52
		refs = "000c __acrt_getptd 001c __guard_check_icall_fptr 0030 abort"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 13 0C 40 F9 F3 00 00 B4 6F 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 00 01 3F D6 60 02 3F D6 01 00 00 14 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_273_0_0 {
	meta:
		name = "_fdpoly"
		size = 36
	strings:
		$1 = { 11 40 20 1E 28 04 00 51 00 00 40 BD A8 00 F8 37 10 4C 40 BC 08 05 00 51 00 40 11 1F A8 FF FF 36 C0 03 5F D6 }
	condition:
		$1
}

rule file_273_1_0 {
	meta:
		name = "erfcf"
		size = 620
		refs = "0010 _fdtest 003c erff 0068 s00 008c c00 00b8 s01 00dc c01 0104 approx 013c _fperrraise 01e0 _fd_int 01f4 expf 0218 _fdexp"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 53 00 91 E0 17 00 BD ?? ?? ?? ?? 80 11 00 34 1F 04 00 71 80 10 00 54 1F 08 00 71 00 10 00 54 F2 17 40 BD 30 11 00 1C 40 22 30 1E C2 00 00 54 40 42 20 1E ?? ?? ?? ?? 10 10 2E 1E 00 3A 20 1E 80 00 00 14 50 10 00 1C 40 22 30 1E 82 05 00 54 10 10 2E 1E 40 22 30 1E A2 02 00 54 10 10 2D 1E ?? ?? ?? ?? ?? ?? ?? ?? 54 0F 00 1C 68 00 80 52 55 3A 30 1E 31 4D 40 BC 08 05 00 51 94 46 15 1F A8 FF FF 36 ?? ?? ?? ?? 73 0E 00 1C ?? ?? ?? ?? 69 00 80 52 50 4D 40 BC 29 05 00 51 73 42 15 1F A9 FF FF 36 80 1A 33 1E 66 00 00 14 71 0D 00 1C ?? ?? ?? ?? ?? ?? ?? ?? 35 0D 00 1C 68 00 80 52 56 3A 31 1E 70 4D 40 BC 08 05 00 51 B5 42 16 1F A8 FF FF 36 ?? ?? ?? ?? 53 0C 00 1C ?? ?? ?? ?? 69 00 80 52 51 4D 40 BC 29 05 00 51 73 46 16 1F A9 FF FF 36 A0 1A 33 1E 52 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 48 7D 40 93 0C 05 80 D2 09 7D 0C 9B 30 69 6B BC 40 22 30 1E 23 01 00 54 4A 05 00 11 48 7D 40 93 1F 21 00 F1 E3 FE FF 54 00 02 80 52 ?? ?? ?? ?? E0 03 27 1E 41 00 00 14 10 10 2E 1E 48 7D 40 93 09 05 80 D2 0E 7D 09 9B 68 11 00 91 11 1A 32 1E D0 69 68 BC 68 21 00 91 CD 69 68 F8 68 41 00 91 C9 69 68 B8 2C 05 00 51 33 3A 30 1E F3 13 00 BD B0 01 40 BD F0 1F 00 BD CC 00 F8 37 B1 4D 40 BC 8C 05 00 51 10 46 13 1F AC FF FF 36 F0 1F 00 BD 68 61 00 91 CD 69 68 F8 68 81 00 91 C9 69 68 B8 B1 01 40 BD 2A 05 00 51 F1 1B 00 BD CA 00 F8 37 B0 4D 40 BC 4A 05 00 51 31 42 13 1F AA FF FF 36 F1 1B 00 BD 01 01 80 52 F2 13 00 BD E0 43 00 91 ?? ?? ?? ?? F2 43 42 2D 51 3A 30 1E 50 2A 30 1E 20 0A 30 1E ?? ?? ?? ?? F0 47 43 2D 01 00 80 52 E0 43 00 91 30 1A 30 1E F1 13 40 BD 31 8A 31 1E F1 13 00 BD 00 08 30 1E ?? ?? ?? ?? E0 13 40 BD 0A 00 00 14 E0 17 40 BD 08 00 00 14 E8 2F 40 79 10 10 20 1E F1 03 27 1E 1F 01 11 72 00 1E 31 1E 02 00 00 14 00 10 2E 1E FD 7B C2 A8 C0 03 5F D6 FE 30 F4 3E AA F1 C2 3F F9 2E A9 3C 6C D1 56 3D 00 00 A4 3F 54 21 8C 3C 46 01 37 3D }
	condition:
		$1
}

rule file_274_4_0 {
	meta:
		name = "_mbslwr"
		size = 56
		refs = "0020 _mbslwr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 02 00 F1 08 00 80 92 E1 03 88 9A 02 00 80 D2 ?? ?? ?? ?? 1F 00 00 71 60 02 9F 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_419_4_0 {
	meta:
		name = "_mbsupr"
		size = 56
		refs = "0020 _mbsupr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 02 00 F1 08 00 80 92 E1 03 88 9A 02 00 80 D2 ?? ?? ?? ?? 1F 00 00 71 60 02 9F 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_274_5_0 {
	meta:
		name = "_mbslwr_l"
		size = 56
		refs = "0020 _mbslwr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 02 00 F1 08 00 80 92 22 00 00 91 E1 03 88 9A ?? ?? ?? ?? 1F 00 00 71 60 02 9F 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_419_5_0 {
	meta:
		name = "_mbsupr_l"
		size = 56
		refs = "0020 _mbsupr_s_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 7F 02 00 F1 08 00 80 92 22 00 00 91 E1 03 88 9A ?? ?? ?? ?? 1F 00 00 71 60 02 9F 9A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_274_7_0 {
	meta:
		name = "_mbslwr_s_l"
		size = 368
		refs = "0038 _errno 0044 _invalid_parameter_noinfo 0058 strnlen 0074 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00c4 __acrt_LCMapStringA"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BC A9 FD 03 00 91 FF 43 00 D1 14 00 00 91 33 00 00 91 55 00 00 91 B4 00 00 B4 B3 00 00 B4 54 01 00 B5 00 00 80 52 44 00 00 14 B3 FF FF B4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 3D 00 00 14 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 1F 00 13 EB 63 00 00 54 9F 02 00 39 F4 FF FF 17 A1 02 00 91 E0 A3 00 91 ?? ?? ?? ?? 88 02 40 39 95 02 00 91 93 02 00 91 E8 04 00 34 EB 1F 40 F9 AC 02 40 39 8A 01 0B 8B 49 65 40 39 E9 02 10 36 67 05 40 B9 2D 00 80 52 61 11 41 F9 46 00 80 52 ED 03 00 B9 E5 83 00 91 44 00 80 52 A3 02 00 91 02 20 80 52 E0 C3 00 91 ?? ?? ?? ?? 60 04 00 34 E8 83 40 39 B5 06 00 91 EB 1F 40 F9 1F 04 00 71 68 16 00 38 CD 01 00 54 E9 87 40 39 69 02 00 39 73 06 00 91 0A 00 00 14 88 05 00 11 68 C1 28 8B 09 61 40 39 69 00 20 36 4A 65 04 91 02 00 00 14 AA 02 00 91 49 01 40 39 69 16 00 38 AA 1E 40 38 8A FB FF 35 7F 02 00 39 00 00 80 52 E8 03 41 39 A8 00 00 34 EA 17 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FF 43 00 91 FD 7B C4 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 ?? ?? ?? ?? 48 05 80 52 08 00 00 B9 9F 02 00 39 ?? ?? ?? ?? 00 00 40 B9 EF FF FF 17 }
	condition:
		$1
}

rule file_275_2_0 {
	meta:
		name = "_getwch_nolock"
		size = 336
		refs = "0014 __security_push_cookie 0024 ?wchbuf@@3GA 003c __dcrt_lowio_console_input_handle 004c __dcrt_lowio_initialize_console_input 0070 __imp_GetConsoleMode 0088 __imp_SetConsoleMode 0098 __imp_ReadConsoleInputW 00f8 _getextendedkeycode 0134 __security_pop_cookie"
	strings:
		$1 = { FD 7B BC A9 F3 53 01 A9 F5 5B 02 A9 F7 1B 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 00 D1 F7 03 00 91 E8 FF 9F 52 ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 6B 60 00 00 54 ?? ?? ?? ?? 3E 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 7F 0A 00 B1 61 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 7F 06 00 B1 61 00 00 54 E0 FF 9F 52 34 00 00 14 F3 0A 00 F9 E1 12 00 91 60 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 01 00 80 52 60 02 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? E3 22 00 91 22 00 80 52 E1 62 00 91 60 02 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 80 00 00 35 E8 FF 9F 52 E8 02 00 79 13 00 00 14 E8 0A 40 B9 88 FF FF 34 E9 32 40 79 3F 05 00 71 A1 02 00 54 EA 1E 40 B9 6A 02 00 34 EB 4E 40 79 6B 00 00 34 EB 02 00 79 08 00 00 14 E0 72 00 91 ?? ?? ?? ?? 80 01 00 B4 08 04 40 39 ?? ?? ?? ?? 09 00 40 39 E9 02 00 79 E1 06 40 B9 60 02 00 91 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 E0 02 40 79 02 00 00 14 DC FF FF 17 FF C3 00 91 ?? ?? ?? ?? F7 1B 40 F9 F5 5B 42 A9 F3 53 41 A9 FD 7B C4 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_275_6_0 {
	meta:
		name = "_getwche_nolock"
		size = 104
		refs = "000c ?wchbuf@@3GA 0028 _getwch_nolock 0048 _putwch_nolock"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? E8 FF 9F 52 1F 00 08 6B 60 00 00 54 ?? ?? ?? ?? 0E 00 00 14 ?? ?? ?? ?? E8 FF 9F 52 13 00 00 11 7F 02 08 6B 61 00 00 54 E0 FF 9F 52 07 00 00 14 60 02 00 11 ?? ?? ?? ?? E9 FF 9F 52 1F 00 09 6B EA FF 9F 52 40 01 93 1A FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_275_9_0 {
	meta:
		name = "_ungetwch_nolock"
		size = 52
		refs = "000c ?wchbuf@@3GA"
	strings:
		$1 = { E8 FF 9F 52 1F 00 08 6B 20 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? E9 FF 9F 52 1F 01 09 6B 81 00 00 54 00 1C 00 12 ?? ?? ?? ?? 02 00 00 14 E0 FF 9F 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_7_0 {
	meta:
		name = "_fputc_nolock"
		size = 48
		refs = "0010 __acrt_stdio_flush_and_write_narrow_nolock"
	strings:
		$1 = { 28 10 40 B9 09 05 00 51 29 10 00 B9 49 00 F8 36 ?? ?? ?? ?? 28 00 40 F9 00 01 00 39 29 00 40 F9 00 1C 00 53 2A 05 00 91 2A 00 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_276_10_0 {
	meta:
		name = "fputc"
		size = 288
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 0044 _lock_file 0058 _fileno 0064 __pioinfo 0084 __badioinfo 00dc $LN18 00e8 _local_unwind 0100 _fputc_nolock 010c _unlock_file"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 08 06 80 D2 E8 63 28 8B A8 0F 00 F9 14 00 00 11 33 00 00 91 B3 0B 00 F9 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 12 36 00 00 14 60 02 00 91 ?? ?? ?? ?? 68 16 40 B9 BF 3B 03 D5 48 05 60 37 60 02 00 91 ?? ?? ?? ?? 08 08 00 11 1F 05 00 71 ?? ?? ?? ?? ?? ?? ?? ?? 29 01 00 54 08 7C 40 93 0A FD 46 93 09 15 40 92 88 79 6A F8 0B 19 09 8B ?? ?? ?? ?? ?? ?? ?? ?? 04 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 4B 01 00 91 68 E5 C0 39 68 01 00 35 08 08 00 11 1F 05 00 71 C9 00 00 54 08 7C 40 93 0A FD 46 93 09 15 40 92 88 79 6A F8 0A 19 09 8B 48 F5 40 39 88 01 00 36 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 0F 40 F9 ?? ?? ?? ?? 1F 20 03 D5 00 00 80 12 08 00 00 14 61 02 00 91 80 02 00 11 ?? ?? ?? ?? 14 00 00 11 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_277_0_0 {
	meta:
		name = "_dclass"
		size = 28
		refs = "0010 _dtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_662_0_0 {
	meta:
		name = "_ldclass"
		size = 28
		refs = "0010 _ldtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 0B 00 FD ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_277_1_0 {
	meta:
		name = "_dpcomp"
		size = 96
		refs = "0010 _dtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 1F 08 00 71 E0 01 00 54 E0 63 00 91 ?? ?? ?? ?? 1F 08 00 71 60 01 00 54 F0 47 41 6D 00 22 71 1E 62 00 00 54 20 00 80 52 07 00 00 14 20 22 70 1E 89 00 80 52 48 00 80 52 20 31 88 1A 02 00 00 14 00 00 80 52 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_662_1_0 {
	meta:
		name = "_ldpcomp"
		size = 96
		refs = "0010 _ldtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 1F 08 00 71 E0 01 00 54 E0 63 00 91 ?? ?? ?? ?? 1F 08 00 71 60 01 00 54 F0 47 41 6D 00 22 71 1E 62 00 00 54 20 00 80 52 07 00 00 14 20 22 70 1E 89 00 80 52 48 00 80 52 20 31 88 1A 02 00 00 14 00 00 80 52 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_277_2_0 {
	meta:
		name = "_dsign"
		size = 24
		altNames = "_ldsign"
	strings:
		$1 = { FF 43 00 D1 E0 03 00 FD E8 0F 40 79 00 01 11 12 FF 43 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_278_0_0 {
	meta:
		name = "ilogb"
		size = 80
		refs = "0014 _dunscale"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E1 63 00 91 E0 0F 00 FD E0 43 00 91 ?? ?? ?? ?? 60 01 00 34 1F 04 00 71 E0 00 00 54 1F 08 00 71 A0 00 00 54 E8 23 C0 79 08 05 00 51 00 3D 00 13 04 00 00 14 00 00 B0 12 02 00 00 14 00 00 B0 52 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_427_0_0 {
	meta:
		name = "ilogbl"
		size = 80
		refs = "0014 _ldunscale"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E1 63 00 91 E0 0F 00 FD E0 43 00 91 ?? ?? ?? ?? 60 01 00 34 1F 04 00 71 E0 00 00 54 1F 08 00 71 A0 00 00 54 E8 23 C0 79 08 05 00 51 00 3D 00 13 04 00 00 14 00 00 B0 12 02 00 00 14 00 00 B0 52 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_279_1_0 {
	meta:
		name = "??$common_gets@D@@YAPEADQEAD_K_N@Z"
		size = 368
		refs = "002c _errno 0038 _invalid_parameter_noinfo 0050 __acrt_iob_func 0054 _lock_file 0060 ?validate_stream_is_ansi_if_required@?$__acrt_stdio_char_traits@D@@SA_NQEAU_iobuf@@@Z 007c _getc_nolock 012c $LN25 0138 _local_unwind 0154 _unlock_file"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BC A9 FD 03 00 91 08 0C 80 D2 E8 63 28 8B A8 1B 00 F9 15 00 00 91 33 00 00 91 54 00 00 11 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 47 00 00 14 53 FF FF B4 B6 02 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 80 00 00 35 16 00 80 D2 BF 0B 00 F9 37 00 00 14 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 31 81 00 00 54 16 00 80 D2 BF 0B 00 F9 F4 05 00 35 7F 06 00 B1 C1 01 00 54 B5 0F 00 F9 1F 28 00 71 20 01 00 54 1F 04 00 31 E0 00 00 54 A0 16 00 38 B5 0F 00 F9 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? F7 FF FF 17 BF 02 00 39 20 00 00 14 B3 13 00 F9 B4 02 00 91 B4 17 00 F9 1F 28 00 71 A0 01 00 54 1F 04 00 31 60 01 00 54 D3 00 00 B4 73 06 00 D1 B3 13 00 F9 80 02 00 39 94 06 00 91 B4 17 00 F9 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? F3 FF FF 17 B3 01 00 B5 BF 02 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 1B 40 F9 ?? ?? ?? ?? 1F 20 03 D5 00 00 80 D2 06 00 00 14 9F 02 00 39 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? C0 02 00 91 FD 7B C4 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 00 00 00 00 }
	condition:
		$1
}

rule file_279_2_0 {
	meta:
		name = "?fin$0@?0???$common_gets@D@@YAPEADQEAD_K_N@Z@4HA"
		size = 36
		refs = "000c __acrt_iob_func 0010 _unlock_file"
		altNames = "?fin$0@?0???$common_gets@_W@@YAPEA_WQEA_W_K_N@Z@4HA"
	strings:
		$1 = { FD 7B BF A9 3D 00 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 1F 20 03 D5 FD 7B C1 A8 C0 03 5F D6 61 00 00 D4 }
	condition:
		$1
}

rule file_279_3_0 {
	meta:
		name = "??$common_gets@_W@@YAPEA_WQEA_W_K_N@Z"
		size = 368
		refs = "002c _errno 0038 _invalid_parameter_noinfo 0050 __acrt_iob_func 0054 _lock_file 0068 _getwc_nolock 0130 $LN25 013c _local_unwind 0158 _unlock_file"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BC A9 FD 03 00 91 08 0C 80 D2 E8 63 28 8B A8 1B 00 F9 15 00 00 91 33 00 00 91 54 00 00 11 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 48 00 00 14 53 FF FF B4 B6 02 00 91 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 08 00 00 11 E9 FF 9F 52 1F 01 09 6B 81 00 00 54 16 00 80 D2 BF 17 00 F9 74 06 00 35 7F 06 00 B1 01 02 00 54 B5 0B 00 F9 1F 29 00 71 60 01 00 54 EA FF 9F 52 1F 01 0A 6B 00 01 00 54 A8 26 00 78 B5 0B 00 F9 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 08 00 00 11 F5 FF FF 17 BF 02 00 79 22 00 00 14 B3 0F 00 F9 B4 02 00 91 B4 13 00 F9 1F 29 00 71 E0 01 00 54 E9 FF 9F 52 1F 01 09 6B 80 01 00 54 D3 00 00 B4 73 06 00 D1 B3 0F 00 F9 88 02 00 79 94 0A 00 91 B4 13 00 F9 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 08 00 00 11 F1 FF FF 17 B3 01 00 B5 BF 02 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? A0 1B 40 F9 ?? ?? ?? ?? 1F 20 03 D5 00 00 80 D2 06 00 00 14 9F 02 00 79 00 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? C0 02 00 91 FD 7B C4 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_280_0_0 {
	meta:
		name = "atanf"
		size = 456
		refs = "00c0 _handle_nanf 00e8 _controlfp_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 19 C0 22 1E 28 03 66 9E F9 0B 00 FD 09 F9 40 92 0A 01 41 92 4A 00 00 B4 39 43 61 1E 88 FB E7 D2 3F 01 08 EB 62 00 00 54 F0 03 67 9E 36 00 00 14 C8 FC E7 D2 3F 01 08 EB 02 01 00 54 10 10 60 1E 11 10 6E 1E 31 C7 70 1F 30 2B 70 1E 39 1A 70 1E 50 08 00 5C 2C 00 00 14 68 FE E7 D2 3F 01 08 EB E2 00 00 54 11 10 6E 1E D0 07 00 5C 32 3B 71 1E 31 2B 71 1E 59 1A 71 1E 23 00 00 14 68 07 00 58 3F 01 08 EB 02 01 00 54 10 10 6F 1E 11 10 6E 1E 33 3B 70 1E 30 47 50 1F 79 1A 70 1E B0 06 00 5C 19 00 00 14 08 FE EF D2 3F 01 08 EB A9 00 00 54 00 00 26 1E E0 13 00 BD ?? ?? ?? ?? 25 00 00 14 D0 05 00 5C 20 23 70 1E 8D 01 00 54 FF 13 00 B9 02 02 80 52 01 02 80 52 E0 43 00 91 8A 00 00 B4 ?? ?? ?? ?? A0 06 00 1C 1A 00 00 14 ?? ?? ?? ?? 60 06 00 1C 17 00 00 14 10 10 7E 1E 19 1A 79 1E 10 04 00 5C 38 0B 79 1E 12 04 00 5C 31 04 00 5C 55 04 00 5C 13 47 52 1F 52 04 00 5C 74 4A 58 1F 13 0B 79 1E 97 0A 73 1E 14 04 00 5C 16 53 55 1F 15 04 00 5C D6 56 58 1F F7 1A 76 1E F8 3A 79 1E 1A 3A 78 1E 4A 00 00 B4 5A 43 61 1E 40 43 62 1E FD 7B C2 A8 C0 03 5F D6 4F BB 61 05 67 AC DD 3F 18 2D 44 54 FB 21 E9 3F 00 00 00 00 00 80 03 40 9B F6 81 D2 0B 73 EF 3F 00 00 00 00 00 20 D3 43 18 2D 44 54 FB 21 F9 3F 2A A2 8D 75 6A 47 73 3F 7F EE 81 3A 17 9E C8 3F AA F2 2C DF E3 27 D3 3F 34 78 90 16 53 FA D2 3F A4 6E DA 93 87 C5 F1 3F F0 53 10 A2 7C 77 EC 3F DB 0F C9 BF DB 0F C9 3F }
	condition:
		$1
}

rule file_281_5_0 {
	meta:
		name = "_mbsspnp_l"
		size = 308
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0034 strspn 0054 _errno 0060 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? EE 13 40 F9 C8 09 40 B9 28 01 00 35 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 08 68 73 38 09 00 13 8B 1F 01 00 71 20 11 9F 9A 32 00 00 14 53 00 00 B4 F4 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 2A 00 00 14 68 02 40 39 A8 04 00 34 8D 02 40 39 8C 02 00 91 CD 02 00 34 8B 01 40 39 69 01 0E 8B 2A 65 40 39 8A 01 10 36 68 02 40 39 7F 01 08 6B A1 00 00 54 6B 06 40 39 8A 05 40 39 5F 01 0B 6B 60 01 00 54 8B 05 40 39 2B 01 00 34 8C 05 00 91 04 00 00 14 69 02 40 39 7F 01 09 6B 80 00 00 54 8C 05 00 91 88 01 40 39 88 FD FF 35 8A 01 40 39 6A 01 00 34 6B 02 40 39 6B 01 0E 8B 6C 65 40 39 8C 00 10 36 73 06 00 91 69 02 40 39 89 00 00 34 73 06 00 91 68 02 40 39 C8 FB FF 35 68 02 40 39 1F 01 00 71 60 12 9F 9A E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_282_5_0 {
	meta:
		name = "_mbbtype_l"
		size = 168
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 11 33 00 00 11 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? E8 13 40 F9 7F 06 00 71 88 02 08 8B 20 02 00 54 0A 65 40 39 6A 00 10 36 20 00 80 52 12 00 00 14 E8 0F 40 F9 EB 2A 80 52 08 01 40 F9 09 79 74 78 28 01 0B 0A A8 00 00 35 48 05 00 12 68 00 00 35 00 00 80 12 08 00 00 14 00 00 80 52 06 00 00 14 09 65 40 39 0A 00 80 12 48 00 80 52 3F 01 1D 72 40 01 88 1A E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_283_12_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QEAA@XZ"
		size = 56
		refs = "0018 __imp_FreeLibrary"
		altNames = "?close@?$__crt_unique_handle_t@U__crt_hmodule_traits@@@@QEAAXXZ"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 C0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 7F 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_301_5_0 {
	meta:
		name = "??1?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QEAA@XZ"
		size = 56
		refs = "0018 __imp_FreeEnvironmentStringsW"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 C0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 7F 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_301_11_0 {
	meta:
		name = "?close@?$__crt_unique_handle_t@Uenvironment_strings_traits@?A0x1bf47908@@@@QEAAXXZ"
		size = 56
		refs = "0018 __imp_FreeEnvironmentStringsW"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 F9 C0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 7F 02 00 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_283_21_0 {
	meta:
		name = "?atexit_exception_filter@@YAHK@Z"
		size = 20
	strings:
		$1 = { 88 00 00 18 1F 00 08 6B E0 17 9F 1A C0 03 5F D6 63 73 6D E0 }
	condition:
		$1
}

rule file_283_24_0 {
	meta:
		name = "?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
		size = 212
		refs = "0018 __imp_GetModuleHandleW 007c ?try_cor_exit_process@@YAXI@Z 00b4 ??$?RV<lambda_d80eeec6fff315bfe5c115232f3240e3>@@AEAV<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@V<lambda_2358e3775559c9db80273638284d5e45>@@@?$__crt_seh_guarded_call@X@@QEAAX$$QEAV<lambda_d80eeec6fff315bfe5c115232f3240e3>@@AEAV<lambda_6e4b09c48022b2350581041d5f6b0c4c>@@$$QEAV<lambda_2358e3775559c9db80273638284d5e45>@@@Z 00d0 ?exit_or_terminate_process@@YAXI@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 13 00 00 11 E2 87 02 29 62 03 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 00 00 80 D2 20 01 3F D6 A0 02 00 B4 08 00 40 79 A9 49 8B 52 1F 01 09 6B 21 02 00 54 08 3C 40 B9 0B AA 88 52 0A C0 28 8B 49 01 40 B9 3F 01 0B 6B 61 01 00 54 48 31 40 79 1F 2D 08 71 01 01 00 54 48 85 40 B9 1F 39 00 71 A9 00 00 54 48 F9 40 B9 68 00 00 34 60 02 00 11 ?? ?? ?? ?? E8 63 00 91 FF 43 00 39 E8 17 00 F9 E9 53 00 91 E8 43 00 91 E9 23 03 A9 48 00 80 52 49 00 80 52 E9 A3 03 29 E3 73 00 91 E2 A3 00 91 E1 83 00 91 E0 47 00 91 ?? ?? ?? ?? E8 17 40 B9 88 00 00 34 FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 60 02 00 11 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_283_25_0 {
	meta:
		name = "?exit_or_terminate_process@@YAXI@Z"
		size = 108
		refs = "0010 __acrt_get_process_end_policy 002c __imp_GetCurrentProcess 003c __imp_TerminateProcess 0054 ?try_cor_exit_process@@YAXI@Z 0058 __imp_ExitProcess"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 11 ?? ?? ?? ?? 1F 04 00 71 C0 01 00 54 48 02 00 91 08 31 40 F9 09 BD 40 B9 49 01 40 37 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 61 02 00 11 20 01 3F D6 60 02 00 11 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 60 02 00 11 20 01 3F D6 }
	condition:
		$1
}

rule file_283_29_0 {
	meta:
		name = "?is_managed_app@@YA_NXZ"
		size = 124
		refs = "0008 __imp_GetModuleHandleW"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 00 00 80 D2 20 01 3F D6 60 00 00 B5 00 00 80 52 14 00 00 14 08 00 40 79 A9 49 8B 52 1F 01 09 6B 61 FF FF 54 08 3C 40 B9 0B AA 88 52 0A C0 28 8B 49 01 40 B9 3F 01 0B 6B A1 FE FF 54 48 31 40 79 1F 2D 08 71 41 FE FF 54 48 85 40 B9 1F 39 00 71 E9 FD FF 54 48 F9 40 B9 1F 01 00 71 E0 07 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_283_30_0 {
	meta:
		name = "?should_call_terminate_process@@YA_NXZ"
		size = 56
		refs = "0008 __acrt_get_process_end_policy"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 1F 04 00 71 61 00 00 54 00 00 80 52 06 00 00 14 48 02 00 91 08 31 40 F9 09 BD 40 B9 EA 23 69 2A 40 01 00 12 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_283_31_0 {
	meta:
		name = "?try_cor_exit_process@@YAXI@Z"
		size = 152
		refs = "000c ??_C@_1BI@BGOHAHKC@?$AAm?$AAs?$AAc?$AAo?$AAr?$AAe?$AAe?$AA?4?$AAd?$AAl?$AAl?$AA?$AA@ 0014 __imp_GetModuleHandleExW 0038 ??_C@_0P@MIGLKIOC@CorExitProcess?$AA@ 0044 __imp_GetProcAddress 005c __guard_check_icall_fptr 007c __imp_FreeLibrary"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? FF 0B 00 F9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 14 00 00 11 E2 43 00 91 00 00 80 52 20 01 3F D6 00 02 00 34 ?? ?? ?? ?? E0 0B 40 F9 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 13 00 00 91 F3 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 6F 02 00 91 00 01 3F D6 80 02 00 11 60 02 3F D6 E0 0B 40 F9 A0 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_283_35_0 {
	meta:
		name = "_c_exit"
		size = 16
		refs = "000c ?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
	strings:
		$1 = { 22 00 80 52 41 00 80 52 00 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_283_36_0 {
	meta:
		name = "_cexit"
		size = 16
		refs = "000c ?common_exit@@YAXHW4_crt_exit_cleanup_mode@@W4_crt_exit_return_mode@@@Z"
	strings:
		$1 = { 22 00 80 52 01 00 80 52 00 00 80 52 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_283_39_0 {
	meta:
		name = "_register_thread_local_exe_atexit_callback"
		size = 68
		refs = "0000 __security_cookie 000c ?thread_local_exit_callback_func@@3P6AXPEAXK0@ZEA 0040 terminate"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 0A 08 80 52 ?? ?? ?? ?? 0D 00 80 D2 69 15 00 12 4C 01 09 4B ?? ?? ?? ?? A8 2D CC 9A 0A 01 0B CA 3F 01 0A EB A1 00 00 54 09 2C CC 9A 2A 01 0B CA ?? ?? ?? ?? C0 03 5F D6 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_284_0_0 {
	meta:
		name = "_initterm"
		size = 112
		refs = "0034 __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 15 00 00 91 28 00 15 CB 09 1D 00 91 2A FD 43 D3 BF 02 01 EB F6 83 8A 9A 13 00 80 D2 76 01 00 B4 ?? ?? ?? ?? B4 86 40 F8 B4 00 00 B4 ?? ?? ?? ?? 8F 02 00 91 60 01 3F D6 80 02 3F D6 73 06 00 91 7F 02 16 EB 01 FF FF 54 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_284_1_0 {
	meta:
		name = "_initterm_e"
		size = 92
		refs = "0020 __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 13 00 00 91 34 00 00 91 7F 02 14 EB 60 01 00 54 ?? ?? ?? ?? 75 86 40 F8 D5 00 00 B4 ?? ?? ?? ?? AF 02 00 91 00 01 3F D6 A0 02 3F D6 80 00 00 35 7F 02 14 EB 01 FF FF 54 00 00 80 52 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_285_0_0 {
	meta:
		name = "_lfind"
		size = 180
		refs = "0028 _errno 0034 _invalid_parameter_noinfo 007c __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BF A9 FD 03 00 91 17 00 00 91 33 00 00 91 74 00 00 11 96 00 00 91 77 01 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 FD 7B C1 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 C2 FE FF B4 73 00 00 B5 48 00 40 B9 68 FE FF 35 54 FE FF 34 36 FE FF B4 48 00 40 B9 09 7D 14 1B 75 42 29 8B 7F 02 15 EB 00 FE FF 54 ?? ?? ?? ?? ?? ?? ?? ?? CF 02 00 91 40 01 3F D6 61 02 00 91 E0 02 00 91 C0 02 3F D6 A0 00 00 34 73 42 34 8B 7F 02 15 EB E1 FE FF 54 E4 FF FF 17 60 02 00 91 E3 FF FF 17 }
	condition:
		$1
}

rule file_288_5_0 {
	meta:
		name = "_mbsnextc_l"
		size = 136
		refs = "0018 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0020 _errno 002c _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 E0 43 00 91 14 00 80 52 ?? ?? ?? ?? F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 0C 00 00 14 6A 02 40 39 E8 13 40 F9 48 01 08 8B 09 65 40 39 A9 00 10 36 68 06 40 39 68 00 00 34 54 5D 18 53 73 06 00 91 68 02 40 39 00 01 14 0B E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_289_4_0 {
	meta:
		name = "??$common_capture_argv@D@@YAPEAPEADQEAPEADQEBD0_K@Z"
		size = 368
		refs = "0068 _calloc_base 0074 _free_base 0098 memcpy_s 00b0 _recalloc_base 0100 _errno 016c _invoke_watson"
		altNames = "??$common_capture_argv@_W@@YAPEAPEA_WQEAPEADQEB_WQEAPEA_W_K@Z"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 23 00 F9 FD 7B BF A9 FD 03 00 91 59 00 00 91 7A 00 00 91 34 03 00 91 55 03 00 91 1B 00 00 91 38 00 00 91 13 00 80 D2 16 00 80 D2 17 00 80 D2 DF 02 15 EB 63 04 00 54 08 00 F0 92 1F 01 15 EB 69 06 00 54 9F 02 19 EB B5 FA 7F D3 41 02 00 54 01 01 80 D2 A0 02 00 91 ?? ?? ?? ?? 14 00 00 91 60 02 00 91 ?? ?? ?? ?? 00 00 80 D2 93 02 00 91 ?? ?? ?? ?? D4 04 00 B4 43 03 00 91 22 03 00 91 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? A0 01 00 34 2E 00 00 14 02 01 80 D2 A1 02 00 91 60 02 00 91 ?? ?? ?? ?? 14 00 00 91 54 02 00 B4 00 00 80 D2 ?? ?? ?? ?? 00 00 80 D2 93 02 00 91 ?? ?? ?? ?? F8 6A 34 F8 D6 06 00 91 F7 22 00 91 98 02 00 B4 6A 03 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 03 00 F9 78 81 5F F8 D1 FF FF 17 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 ?? ?? ?? ?? 14 00 80 D2 06 00 00 14 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 FB FF FF 17 13 00 80 D2 60 02 00 91 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 FB 23 40 F9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_6_0 {
	meta:
		name = "??$common_pack_argv_and_envp@D@@YAHQEBQEBD0QEAPEAD1@Z"
		size = 400
		refs = "0078 _calloc_base 0088 __acrt_errno_map_os_error 008c _errno 009c _free_base 00c8 strcpy_s 0124 ??$construct_environment_block@D@@YAHQEBQEBDQEAPEAD@Z 018c _invoke_watson"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 37 00 00 91 0B 00 40 F9 58 00 00 91 79 00 00 91 13 00 80 D2 0C 00 80 D2 8B 01 00 B4 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4A 01 0B CB 0B 8C 40 F8 4A 01 0C 8B 4C 05 00 91 CB FE FF B5 9F 05 00 F1 28 00 80 D2 96 81 88 9A C0 02 00 91 21 00 80 D2 ?? ?? ?? ?? 14 00 00 91 54 01 00 B5 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 ?? ?? ?? ?? 14 00 80 12 2C 00 00 14 F3 0B 40 F9 95 02 00 91 68 02 40 F9 C8 02 00 B4 62 02 40 F9 88 02 15 CB 01 01 16 8B A0 02 00 91 ?? ?? ?? ?? 60 05 00 35 6B 02 40 F9 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4A 01 0B CB 0C 04 80 52 4B 01 15 8B 4C 69 35 38 6A 8E 40 F8 75 05 00 91 AA FD FF B5 BF F2 1F 38 00 00 80 D2 93 02 00 91 ?? ?? ?? ?? FF 0B 00 F9 E1 43 00 91 E0 02 00 91 ?? ?? ?? ?? 80 00 00 34 E0 0B 40 F9 14 00 80 12 07 00 00 14 E8 0B 40 F9 14 03 00 F9 13 00 80 D2 00 00 80 D2 14 00 80 52 28 03 00 F9 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_7_0 {
	meta:
		name = "??$common_pack_argv_and_envp@_W@@YAHQEBQEB_W0QEAPEA_W1@Z"
		size = 404
		refs = "0078 _calloc_base 0088 __acrt_errno_map_os_error 008c _errno 009c _free_base 00c8 wcscpy_s 0128 ??$construct_environment_block@_W@@YAHQEBQEB_WQEAPEA_W@Z 0190 _invoke_watson"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 37 00 00 91 0B 00 40 F9 58 00 00 91 79 00 00 91 13 00 80 D2 0C 00 80 D2 8B 01 00 B4 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0B CB 8B 05 8A 8B 6C 05 00 91 0B 8C 40 F8 CB FE FF B5 9F 05 00 F1 28 00 80 D2 96 81 88 9A C0 02 00 91 41 00 80 D2 ?? ?? ?? ?? 14 00 00 91 54 01 00 B5 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 ?? ?? ?? ?? 14 00 80 12 2D 00 00 14 F3 0B 40 F9 95 02 00 91 68 02 40 F9 E8 02 00 B4 A8 02 14 CB 62 02 40 F9 C1 06 88 CB A0 02 00 91 ?? ?? ?? ?? 80 05 00 35 6B 02 40 F9 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0B CB 4B FD 41 93 AC 06 0B 8B 0D 04 80 52 8D 01 00 79 95 09 00 91 6C 8E 40 F8 8C FD FF B5 BF E2 1F 78 00 00 80 D2 93 02 00 91 ?? ?? ?? ?? FF 0B 00 F9 E1 43 00 91 E0 02 00 91 ?? ?? ?? ?? 80 00 00 34 E0 0B 40 F9 14 00 80 12 07 00 00 14 E8 0B 40 F9 14 03 00 F9 13 00 80 D2 00 00 80 D2 14 00 80 52 28 03 00 F9 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 80 02 00 11 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_8_0 {
	meta:
		name = "??$construct_command_line@D@@YAHQEBQEBDQEAPEAD@Z"
		size = 312
		refs = "006c _calloc_base 007c __acrt_errno_map_os_error 0080 _errno 00b4 strcpy_s 0104 _free_base 0134 _invoke_watson"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 36 00 00 91 E0 0B 00 F9 DF 02 00 F9 0C 00 80 D2 0B 00 40 F9 8B 01 00 B4 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4A 01 0B CB 0B 8C 40 F8 4A 01 0C 8B 4C 05 00 91 CB FE FF B5 9F 05 00 F1 28 00 80 D2 97 81 88 9A E0 02 00 91 21 00 80 D2 ?? ?? ?? ?? 13 00 00 91 13 01 00 B5 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 93 01 80 52 1C 00 00 14 F4 0B 40 F9 75 02 00 91 88 02 40 F9 C8 02 00 B4 82 02 40 F9 69 02 15 CB 21 01 17 8B A0 02 00 91 ?? ?? ?? ?? 40 03 00 35 8B 02 40 F9 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4A 01 0B CB 0C 04 80 52 4B 01 15 8B 4C 69 35 38 8A 8E 40 F8 75 05 00 91 AA FD FF B5 BF F2 1F 38 D3 02 00 F9 13 00 80 52 00 00 80 D2 ?? ?? ?? ?? 60 02 00 11 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_9_0 {
	meta:
		name = "??$construct_command_line@_W@@YAHQEBQEB_WQEAPEA_W@Z"
		size = 316
		refs = "006c _calloc_base 007c __acrt_errno_map_os_error 0080 _errno 00b4 wcscpy_s 0108 _free_base 0138 _invoke_watson"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 34 00 00 91 E0 0B 00 F9 9F 02 00 F9 0C 00 80 D2 0B 00 40 F9 8B 01 00 B4 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0B CB 8B 05 8A 8B 6C 05 00 91 0B 8C 40 F8 CB FE FF B5 9F 05 00 F1 28 00 80 D2 97 81 88 9A E0 02 00 91 41 00 80 D2 ?? ?? ?? ?? 13 00 00 91 13 01 00 B5 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 93 01 80 52 1D 00 00 14 F5 0B 40 F9 76 02 00 91 A8 02 40 F9 E8 02 00 B4 C9 02 13 CB A2 02 40 F9 E1 06 89 CB C0 02 00 91 ?? ?? ?? ?? 60 03 00 35 AB 02 40 F9 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0B CB 4B FD 41 93 CC 06 0B 8B 0D 04 80 52 8D 01 00 79 96 09 00 91 AC 8E 40 F8 8C FD FF B5 DF E2 1F 78 93 02 00 F9 13 00 80 52 00 00 80 D2 ?? ?? ?? ?? 60 02 00 11 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_10_0 {
	meta:
		name = "??$construct_environment_block@D@@YAHQEBQEBDQEAPEAD@Z"
		size = 996
		refs = "0018 __security_push_cookie 0094 _dupenv_s 00a4 _errno 0120 __dcrt_get_narrow_environment_from_os 01f4 _strnicmp 0220 _calloc_base 0230 __acrt_errno_map_os_error 0264 memcpy 0288 strcpy_s 02dc ?equal_sign@?BD@???$construct_environment_block@D@@YAHQEBQEBDQEAPEAD@Z@4QBDB 02ec strcat_s 0330 _free_base 0350 __security_pop_cookie 0380 _invoke_watson"
	strings:
		$1 = { FD 7B BB A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 23 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 00 D1 39 00 00 91 E0 07 00 F9 3F 03 00 F9 60 00 00 B5 00 00 80 52 C6 00 00 14 68 0A 80 52 FF AB 00 39 E8 83 00 39 29 0F 80 52 68 0E 80 52 E9 87 00 39 E8 8B 00 39 A9 0D 80 52 A8 0C 80 52 E9 97 00 39 E8 93 00 39 8A 0E 80 52 E9 0D 80 52 EA 8F 00 39 48 0A 80 52 E9 9F 00 39 E2 83 00 91 E8 9B 00 39 01 00 80 D2 E9 A3 00 39 E0 03 00 91 EA A7 00 39 FF 03 00 F9 ?? ?? ?? ?? C0 00 00 34 1F 58 00 71 60 16 00 54 ?? ?? ?? ?? 13 00 40 B9 A5 00 00 14 E8 03 40 F9 48 01 00 B4 09 01 C0 39 0B 01 00 91 89 00 00 34 6B 05 00 91 6A 01 C0 39 CA FF FF 35 69 01 08 CB 2A 05 00 91 02 00 00 14 0A 00 80 D2 ED 07 40 F9 58 2D 00 91 54 00 80 D2 AC 01 40 F9 8C 01 00 B4 88 01 C0 39 8A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4A 01 0C CB AC 8D 40 F8 4A 01 14 8B 54 05 00 91 CC FE FF B5 ?? ?? ?? ?? E0 0B 00 F9 00 01 00 B5 D3 02 80 52 82 00 00 14 88 00 00 34 00 04 00 91 08 00 C0 39 C8 FF FF 35 00 04 00 91 08 00 C0 39 1F F5 00 71 21 FF FF 54 E0 0F 00 F9 08 00 C0 39 0D 00 00 91 1F F5 00 71 C1 02 00 54 A9 05 C0 39 89 02 00 34 AA 09 C0 39 5F E9 00 71 21 02 00 54 AB 0D C0 39 7F F5 00 71 C1 01 00 54 AF 11 00 91 EC 01 C0 39 EE 01 00 91 8C 00 00 34 CE 05 00 91 C8 01 C0 39 C8 FF FF 35 C9 01 0F CB 29 01 0D 8B 2D 15 00 91 AA 01 C0 39 5F F5 00 71 80 FD FF 54 F3 07 40 F9 B5 01 00 CB 68 02 40 F9 E8 01 00 B4 E9 83 C0 39 EB 83 00 91 89 00 00 34 6B 05 00 91 69 01 C0 39 C9 FF FF 35 60 02 40 F9 E8 83 00 91 62 01 08 CB E1 83 00 91 ?? ?? ?? ?? 80 02 00 34 68 8E 40 F8 68 FE FF B5 16 00 80 52 89 02 15 8B 28 01 18 8B DF 02 00 71 37 11 88 9A E0 02 00 91 21 00 80 D2 ?? ?? ?? ?? 14 00 00 91 54 01 00 B5 C0 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 93 01 80 52 3A 00 00 14 36 00 80 52 EF FF FF 17 93 02 00 91 F5 00 00 B4 E1 0F 40 F9 A2 02 00 91 80 02 00 91 ?? ?? ?? ?? 93 02 15 8B F7 02 15 CB F5 07 40 F9 A8 02 40 F9 68 02 00 B4 A2 02 40 F9 E1 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 08 00 35 AB 02 40 F9 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4A 01 0B CB 4B 05 00 91 AA 8E 40 F8 73 01 13 8B F7 02 0B CB EA FD FF B5 76 02 00 35 E2 83 00 91 01 03 00 91 60 02 00 91 ?? ?? ?? ?? A0 07 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 01 03 00 91 60 02 00 91 ?? ?? ?? ?? 20 06 00 35 E2 03 40 F9 A2 00 00 B4 01 03 00 91 60 02 00 91 ?? ?? ?? ?? E0 03 00 35 73 02 18 8B 7F 02 14 EB 61 00 00 54 7F 02 00 39 73 06 00 91 7F 02 00 39 13 00 80 52 34 03 00 F9 00 00 80 D2 ?? ?? ?? ?? E0 0B 40 F9 ?? ?? ?? ?? FF 0B 00 F9 E0 03 40 F9 ?? ?? ?? ?? 60 02 00 11 FF C3 00 91 ?? ?? ?? ?? F9 23 40 F9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C5 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_11_0 {
	meta:
		name = "??$construct_environment_block@_W@@YAHQEBQEB_WQEAPEA_W@Z"
		size = 1052
		refs = "0018 __security_push_cookie 0094 _wdupenv_s 00a4 _errno 0124 __dcrt_get_wide_environment_from_os 0228 _wcsnicmp 0254 _calloc_base 0264 __acrt_errno_map_os_error 0298 memcpy 02bc wcscpy_s 0314 ?equal_sign@?BD@???$construct_environment_block@_W@@YAHQEBQEB_WQEAPEA_W@Z@4QB_WB 0324 wcscat_s 0368 _free_base 0388 __security_pop_cookie 03b8 _invoke_watson"
	strings:
		$1 = { FD 7B BB A9 F3 53 01 A9 F5 5B 02 A9 F7 63 03 A9 F9 23 00 F9 FD 03 00 91 ?? ?? ?? ?? FF C3 00 D1 39 00 00 91 E0 07 00 F9 3F 03 00 F9 60 00 00 B5 00 00 80 52 D4 00 00 14 68 0A 80 52 FF 6B 00 79 E8 43 00 79 29 0F 80 52 68 0E 80 52 E9 47 00 79 E8 4B 00 79 A9 0D 80 52 A8 0C 80 52 E9 57 00 79 E8 53 00 79 8A 0E 80 52 E9 0D 80 52 EA 4F 00 79 48 0A 80 52 E9 5F 00 79 E2 83 00 91 E8 5B 00 79 01 00 80 D2 E9 63 00 79 E0 03 00 91 EA 67 00 79 FF 03 00 F9 ?? ?? ?? ?? C0 00 00 34 1F 58 00 71 20 18 00 54 ?? ?? ?? ?? 13 00 40 B9 B3 00 00 14 E8 03 40 F9 68 01 00 B4 09 01 C0 79 0B 01 00 91 89 00 00 34 6B 09 00 91 6A 01 C0 79 CA FF FF 35 69 01 08 CB 2A FD 41 93 4C 05 00 91 02 00 00 14 0C 00 80 D2 ED 07 40 F9 98 2D 00 91 54 00 80 D2 AC 01 40 F9 8C 01 00 B4 88 01 C0 79 8A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0C CB AC 8D 40 F8 8B 06 8A 8B 74 05 00 91 CC FE FF B5 ?? ?? ?? ?? E0 0B 00 F9 60 00 00 B5 D3 02 80 52 8F 00 00 14 08 00 40 79 1F F5 00 71 E0 01 00 54 08 3D 00 53 0A 00 00 91 08 3D 00 13 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 00 CB 4B FD 41 93 6C 05 00 91 00 04 0C 8B 08 00 40 79 1F F5 00 71 81 FE FF 54 E0 0F 00 F9 08 00 40 79 0E 00 00 91 1F F5 00 71 E1 02 00 54 C9 05 40 79 A9 02 00 34 CA 09 40 79 5F E9 00 71 41 02 00 54 CB 0D 40 79 7F F5 00 71 E1 01 00 54 CF 21 00 91 EC 01 C0 79 ED 01 00 91 8C 00 00 34 AD 09 00 91 A8 01 C0 79 C8 FF FF 35 A9 01 0F CB 2A FD 41 93 4D 15 00 91 CE 05 0D 8B CB 01 40 79 7F F5 00 71 60 FD FF 54 F3 07 40 F9 C8 01 00 CB 15 FD 41 93 68 02 40 F9 08 02 00 B4 E9 43 C0 79 EC 83 00 91 89 00 00 34 8C 09 00 91 8A 01 C0 79 CA FF FF 35 E8 83 00 91 60 02 40 F9 88 01 08 CB 02 FD 41 93 E1 83 00 91 ?? ?? ?? ?? 80 02 00 34 68 8E 40 F8 48 FE FF B5 16 00 80 52 89 02 15 8B 08 03 09 8B DF 02 00 71 37 11 88 9A E0 02 00 91 41 00 80 D2 ?? ?? ?? ?? 14 00 00 91 54 01 00 B5 C0 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 93 01 80 52 3B 00 00 14 36 00 80 52 EF FF FF 17 93 02 00 91 F5 00 00 B4 E1 0F 40 F9 A2 FA 7F D3 80 02 00 91 ?? ?? ?? ?? 93 06 15 8B F7 02 15 CB F5 07 40 F9 A8 02 40 F9 88 02 00 B4 A2 02 40 F9 E1 02 00 91 60 02 00 91 ?? ?? ?? ?? A0 08 00 35 AB 02 40 F9 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0B CB 4B FD 41 93 6C 05 00 91 73 06 0C 8B F7 02 0C CB AC 8E 40 F8 CC FD FF B5 76 02 00 35 E2 83 00 91 01 03 00 91 60 02 00 91 ?? ?? ?? ?? A0 07 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 01 03 00 91 60 02 00 91 ?? ?? ?? ?? 20 06 00 35 E2 03 40 F9 A2 00 00 B4 01 03 00 91 60 02 00 91 ?? ?? ?? ?? E0 03 00 35 73 06 18 8B 7F 02 14 EB 61 00 00 54 7F 02 00 79 73 0A 00 91 7F 02 00 79 13 00 80 52 34 03 00 F9 00 00 80 D2 ?? ?? ?? ?? E0 0B 40 F9 ?? ?? ?? ?? FF 0B 00 F9 E0 03 40 F9 ?? ?? ?? ?? 60 02 00 11 FF C3 00 91 ?? ?? ?? ?? F9 23 40 F9 F7 63 43 A9 F5 5B 42 A9 F3 53 41 A9 FD 7B C5 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_54_0 {
	meta:
		name = "??4?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z"
		size = 60
		refs = "0018 _free_base"
		altNames = "??4?$__crt_unique_heap_ptr@DU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z ??4?$__crt_unique_heap_ptr@EU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z ??4?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z ??4?$__crt_unique_heap_ptr@_WU__crt_internal_free_policy@@@@QEAAAEAV0@$$QEAV0@@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 80 02 40 F9 33 00 00 91 ?? ?? ?? ?? 9F 02 00 F9 68 02 40 F9 80 02 00 91 88 02 00 F9 7F 02 00 F9 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_289_68_0 {
	meta:
		name = "?attach@?$__crt_unique_heap_ptr@PEADU__crt_internal_free_policy@@@@QEAAXQEAPEAD@Z"
		size = 44
		refs = "0018 _free_base"
		altNames = "?attach@?$__crt_unique_heap_ptr@PEA_WU__crt_internal_free_policy@@@@QEAAXQEAPEA_W@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 80 02 40 F9 33 00 00 91 ?? ?? ?? ?? 93 02 00 F9 FD 7B C1 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_289_86_0 {
	meta:
		name = "__acrt_capture_narrow_argv"
		size = 392
		refs = "0068 _calloc_base 0074 _free_base 0098 memcpy_s 00b0 _recalloc_base 0100 _errno 0184 _invoke_watson"
		altNames = "__acrt_capture_wide_argv"
	strings:
		$1 = { F3 53 BB A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FB 23 00 F9 FD 7B BF A9 FD 03 00 91 59 00 00 91 7A 00 00 91 34 03 00 91 55 03 00 91 1B 00 00 91 38 00 00 91 13 00 80 D2 16 00 80 D2 17 00 80 D2 DF 02 15 EB 63 04 00 54 08 00 F0 92 1F 01 15 EB E9 06 00 54 9F 02 19 EB B5 FA 7F D3 41 02 00 54 01 01 80 D2 A0 02 00 91 ?? ?? ?? ?? 14 00 00 91 60 02 00 91 ?? ?? ?? ?? 00 00 80 D2 93 02 00 91 ?? ?? ?? ?? F4 03 00 B4 43 03 00 91 22 03 00 91 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? A0 01 00 34 34 00 00 14 02 01 80 D2 A1 02 00 91 60 02 00 91 ?? ?? ?? ?? 14 00 00 91 F4 02 00 B4 00 00 80 D2 ?? ?? ?? ?? 00 00 80 D2 93 02 00 91 ?? ?? ?? ?? F8 6A 34 F8 D6 06 00 91 F7 22 00 91 78 03 00 B4 6A 03 40 F9 E8 03 0A CB 09 09 40 92 2A 01 0A 8B 4B 21 00 91 6B 03 00 F9 78 81 5F F8 D1 FF FF 17 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 0B 00 00 14 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 ?? ?? ?? ?? 04 00 00 14 ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 60 02 00 91 ?? ?? ?? ?? 14 00 80 D2 03 00 00 14 00 00 80 D2 ?? ?? ?? ?? 80 02 00 91 FD 7B C1 A8 FB 23 40 F9 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C5 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_88_0 {
	meta:
		name = "__acrt_pack_narrow_command_line_and_environment"
		size = 396
		refs = "0074 _calloc_base 0084 __acrt_errno_map_os_error 0088 _errno 0098 _free_base 00e0 strcpy_s 0138 ??$construct_environment_block@D@@YAHQEBQEBDQEAPEAD@Z 0188 _invoke_watson"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 37 00 00 91 0B 00 40 F9 58 00 00 91 79 00 00 91 0C 00 80 D2 8B 01 00 B4 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4A 01 0B CB 0B 8C 40 F8 4A 01 0C 8B 4C 05 00 91 CB FE FF B5 9F 05 00 F1 28 00 80 D2 96 81 88 9A C0 02 00 91 21 00 80 D2 ?? ?? ?? ?? 13 00 00 91 33 02 00 B5 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 00 00 80 12 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 F4 0B 40 F9 75 02 00 91 88 02 40 F9 C8 02 00 B4 82 02 40 F9 68 02 15 CB 01 01 16 8B A0 02 00 91 ?? ?? ?? ?? 80 04 00 35 8B 02 40 F9 68 01 C0 39 6A 01 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 4A 01 0B CB 0C 04 80 52 4B 01 15 8B 4C 69 35 38 8A 8E 40 F8 75 05 00 91 AA FD FF B5 BF F2 1F 38 00 00 80 D2 ?? ?? ?? ?? E1 43 00 91 FF 0B 00 F9 E0 02 00 91 ?? ?? ?? ?? A0 00 00 34 E0 0B 40 F9 ?? ?? ?? ?? 60 02 00 91 D5 FF FF 17 E8 0B 40 F9 13 03 00 F9 00 00 80 D2 28 03 00 F9 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 00 00 80 52 CE FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_289_89_0 {
	meta:
		name = "__acrt_pack_wide_command_line_and_environment"
		size = 400
		refs = "0074 _calloc_base 0084 __acrt_errno_map_os_error 0088 _errno 0098 _free_base 00e0 wcscpy_s 013c ??$construct_environment_block@_W@@YAHQEBQEB_WQEAPEA_W@Z 018c _invoke_watson"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BE A9 FD 03 00 91 E0 0B 00 F9 37 00 00 91 0B 00 40 F9 58 00 00 91 79 00 00 91 0C 00 80 D2 8B 01 00 B4 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0B CB 8B 05 8A 8B 6C 05 00 91 0B 8C 40 F8 CB FE FF B5 9F 05 00 F1 28 00 80 D2 96 81 88 9A C0 02 00 91 41 00 80 D2 ?? ?? ?? ?? 13 00 00 91 33 02 00 B5 00 01 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 88 01 80 52 08 00 00 B9 00 00 80 D2 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 00 00 80 12 FD 7B C2 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 F4 0B 40 F9 75 02 00 91 88 02 40 F9 E8 02 00 B4 A8 02 13 CB 82 02 40 F9 C1 06 88 CB A0 02 00 91 ?? ?? ?? ?? A0 04 00 35 8B 02 40 F9 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0B CB 4B FD 41 93 AC 06 0B 8B 0D 04 80 52 8D 01 00 79 95 09 00 91 8C 8E 40 F8 8C FD FF B5 BF E2 1F 78 00 00 80 D2 ?? ?? ?? ?? E1 43 00 91 FF 0B 00 F9 E0 02 00 91 ?? ?? ?? ?? A0 00 00 34 E0 0B 40 F9 ?? ?? ?? ?? 60 02 00 91 D4 FF FF 17 E8 0B 40 F9 13 03 00 F9 00 00 80 D2 28 03 00 F9 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? 00 00 80 52 CD FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_290_4_0 {
	meta:
		name = "_wcscoll_l"
		size = 176
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0028 _errno 0034 _invalid_parameter_noinfo 0050 wcscmp 006c __acrt_CompareStringW"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 54 00 00 B4 D3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 12 00 00 14 E8 0F 40 F9 00 99 40 F9 A0 00 00 B5 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 0E 00 00 14 05 00 80 12 64 02 00 91 03 00 80 12 82 02 00 91 01 00 82 52 ?? ?? ?? ?? C0 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 00 00 B0 12 02 00 00 14 00 08 00 51 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_290_5_0 {
	meta:
		name = "wcscoll"
		size = 76
		refs = "0008 __acrt_locale_changed_data 0018 _errno 0024 _invalid_parameter_noinfo 0034 wcscmp 0040 _wcscoll_l"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 68 01 00 35 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 06 00 00 14 41 FF FF B4 ?? ?? ?? ?? 03 00 00 14 02 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_328_5_0 {
	meta:
		name = "_stricmp"
		size = 76
		refs = "0008 __acrt_locale_changed_data 0018 _errno 0024 _invalid_parameter_noinfo 0034 __ascii_stricmp 0040 _stricmp_l"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 68 01 00 35 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 06 00 00 14 41 FF FF B4 ?? ?? ?? ?? 03 00 00 14 02 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_293_0_0 {
	meta:
		name = "atan2f"
		size = 956
		refs = "0064 _handle_nanf 0098 _controlfp_s 02a0 ?atan_jby256@?1??atan2f@@9@9"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 18 C0 22 1E 39 C0 22 1E 08 03 66 9E F8 67 02 6D 2A 03 66 9E F8 67 01 6D 16 F9 40 92 13 01 41 92 08 FD 74 D3 0B 29 00 12 48 FD 74 D3 57 F9 40 92 54 01 41 92 0A 29 00 12 08 FE EF D2 FF 02 08 EB 75 01 0A 4B A9 00 00 54 E1 13 00 BD E0 13 40 B9 ?? ?? ?? ?? B5 00 00 14 08 FE EF D2 DF 02 08 EB 69 00 00 54 E0 13 00 BD F9 FF FF 17 D6 01 00 B5 74 01 00 B4 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 73 00 00 B4 C0 17 00 1C A6 00 00 14 A0 17 00 1C A4 00 00 14 00 43 62 1E A2 00 00 14 57 01 00 B5 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 73 00 00 B4 60 16 00 1C 99 00 00 14 F8 67 42 6D BF 6A 00 71 2D 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? D3 FE FF B5 20 15 00 1C 8E 00 00 14 BF 36 00 31 80 BA 40 FA A1 07 00 54 BF 5A 02 31 6A 01 00 54 42 02 80 52 FF 13 00 B9 41 02 80 52 E0 43 00 91 ?? ?? ?? ?? 73 00 00 B4 A0 13 00 1C 81 00 00 14 E0 03 27 1E 7F 00 00 14 BF FA 01 31 AA 05 00 54 08 C6 E8 D2 10 01 67 9E E8 17 00 F9 10 0A 78 1E 11 1A 79 1E 28 02 66 9E F1 17 00 FD 0A F9 40 92 0C 01 41 92 48 FD 74 D3 0B 91 01 51 7F 01 00 71 AD 00 00 54 69 7D 40 93 48 D1 41 92 0B D1 09 AA 0D 00 00 14 28 00 80 D2 0A 29 4C B3 28 00 80 52 08 01 0B 4B 1F D9 00 71 6D 00 00 54 0B 00 80 D2 05 00 00 14 08 05 00 51 4A 25 C8 9A 49 01 40 92 2B 05 4A 8B 68 01 0C AA E8 0F 00 F9 08 29 4C 92 28 01 00 B5 42 02 80 52 FF 13 00 B9 41 02 80 52 E0 43 00 91 ?? ?? ?? ?? F0 0F 40 FD 00 42 62 1E 54 00 00 14 F1 0F 40 FD 20 42 62 1E 51 00 00 14 10 1B 79 1E FA FF FF 17 BF 6A 00 31 84 BA 40 FA E1 F3 FF 54 08 FE EF D2 DF 02 08 EB 61 02 00 54 FF 02 08 EB 21 02 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? D4 00 00 B4 73 00 00 B4 60 0B 00 1C 3E 00 00 14 40 0B 00 1C 3C 00 00 14 73 00 00 B4 00 0B 00 1C 39 00 00 14 E0 0A 00 1C 37 00 00 14 54 00 00 B4 39 43 61 1E 53 00 00 B4 18 43 61 1E 20 23 78 1E EA 27 9F 1A 8A 00 00 34 30 43 60 1E 19 43 60 1E 18 42 60 1E 17 1B 79 1E 10 06 00 5C E0 22 70 1E AD 02 00 54 F6 05 00 5C ?? ?? ?? ?? 11 10 6C 1E 13 0B 76 1E F2 46 56 1F 48 02 78 1E 14 01 63 1E 09 41 00 51 ?? ?? ?? ?? 10 59 69 FC 95 CE 59 1F 94 0A 78 1E 34 53 56 1F B6 1A 74 1E D5 0A 76 1E 18 2A 76 1E B7 0A 76 1E 16 04 00 5C F7 E2 56 1F 0C 00 00 14 F1 03 00 5C E0 22 71 1E 23 01 00 54 F9 0A 77 1E B3 03 00 5C D2 03 00 5C F0 03 00 5C 34 CB 53 1F 33 0B 77 1E 95 C2 59 1F B7 DE 53 1F 6A 00 00 34 71 03 00 5C 37 3A 77 1E 74 00 00 B4 54 03 00 5C 97 3A 77 1E 53 00 00 B4 F7 42 61 1E E0 42 62 1E FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 00 00 00 00 00 00 B0 3F 00 00 00 00 00 00 70 40 77 08 55 55 55 55 D5 3F 2D 43 1C EB E2 36 1A 3F E1 6B BD 82 24 49 C2 3F A3 43 96 99 99 99 C9 3F 38 55 55 55 55 55 D5 3F 18 2D 44 54 FB 21 F9 3F 18 2D 44 54 FB 21 09 40 DB 0F 49 C0 DB 0F 49 40 DB 0F C9 BF DB 0F C9 3F 00 00 00 80 E4 CB 16 C0 E4 CB 16 40 DB 0F 49 BF DB 0F 49 3F }
	condition:
		$1
}

rule file_294_0_0 {
	meta:
		name = "__remainder_piby2f_inline"
		size = 588
		refs = "0008 __security_push_cookie 0040 ?pibits@?1??__remainder_piby2f_inline@@9@9 0230 __security_pop_cookie"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 43 01 D1 08 FC 74 D3 FF 17 00 F9 0A 29 00 12 08 58 63 92 09 01 4C B2 4C FD 0F 51 08 11 00 18 88 7D 28 9B 2F FD 5D D3 09 FD 60 D3 2B 7D 03 13 6E 7D 4B 0B ?? ?? ?? ?? C8 0D 0E 0B CD 0D 00 11 AA 05 00 51 86 09 08 4B ?? ?? ?? ?? 09 D9 6D F8 2B 7D 0F 9B ?? ?? ?? ?? 68 8D 40 92 E8 13 00 F9 28 D9 6A F8 0A 7D 0F 9B ?? ?? ?? ?? 4B 91 4B 8B AA 09 00 51 69 8D 40 92 E9 0F 00 F9 09 D9 6A F8 ?? ?? ?? ?? 27 00 80 52 2A 7D 0F 9B 09 D9 6E F8 4C 91 4B 8B 2A 7D 0F 9B 8D 8D 40 92 ED 0B 00 F9 4B 91 4C 8B 6A 04 80 52 68 8D 40 92 A9 91 08 AA E8 07 00 F9 48 01 06 4B 29 25 C8 9A 2B 09 00 12 65 01 00 12 C5 03 00 34 68 7D 01 53 09 05 00 11 88 04 80 52 2A 05 00 12 08 01 06 4B 4A 00 00 B9 29 00 80 D2 28 21 C8 9A 0A 05 00 D1 E9 03 2D AA 4E 01 09 8A 28 00 A0 D2 DF 01 08 EB 42 01 00 54 EC 23 00 91 E7 04 00 11 8B D9 67 F8 2F 00 A0 D2 EC 03 2B AA 8D 8D 40 92 AE 91 0E AA DF 01 0F EB 03 FF FF 54 E9 23 00 91 E8 04 00 11 28 D9 68 F8 E9 03 28 AA 2F 8D 40 92 16 00 00 14 68 7D 01 13 89 04 80 52 48 00 00 B9 28 00 80 D2 29 01 06 4B 08 21 C9 9A 0A 05 00 D1 4E 01 0D 8A 28 00 A0 D2 DF 01 08 EB 02 01 00 54 E7 04 00 11 EC 23 00 91 89 D9 67 F8 2B 00 A0 D2 2E 91 0E AA DF 01 0B EB 43 FF FF 54 E8 04 00 11 E9 23 00 91 2F D9 68 F8 08 00 C8 D2 DF 01 08 EB 0D 00 80 52 C2 00 00 54 CE E5 7A D3 0A 00 C8 D2 DF 01 0A EB AD 19 00 11 83 FF FF 54 08 02 E0 D2 DF 01 08 EB C2 00 00 54 CE F9 7F D3 09 02 E0 D2 DF 01 09 EB AD 05 00 11 83 FF FF 54 E8 0C 07 0B C9 08 08 4B 2A 01 0D 4B 4B D1 00 11 89 04 80 52 68 7D 40 93 29 01 0D 4B 0C FD 0F 91 E8 25 C9 9A 0A 01 0E AA 4B CD 40 92 69 D1 0C AA 45 00 00 34 29 01 41 B2 31 01 67 9E E9 03 00 F9 10 01 00 5C 31 0A 70 1E 31 00 00 FD FF 43 01 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 1F 20 03 D5 18 2D 44 54 FB 21 F9 3F 39 8E E3 38 }
	condition:
		$1
}

rule file_294_2_0 {
	meta:
		name = "tanf"
		size = 824
		refs = "005c _controlfp_s 00dc _handle_nanf 00e4 ??_C@_04MHPLPEIA@tanf?$AA@ 010c _handle_errorf 0200 __remainder_piby2f_inline"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 C0 22 1E 88 14 00 58 E0 1B 00 BD 69 02 66 9E F3 0B 00 FD 20 F9 40 92 1F 00 08 EB A8 04 00 54 08 F0 E7 D2 1F 00 08 EB 62 02 00 54 08 E4 E7 D2 1F 00 08 EB 42 01 00 54 40 00 00 B5 92 00 00 14 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? E0 1B 40 BD 8B 00 00 14 70 0A 73 1E F1 11 00 5C 12 0A 73 1E 52 4E 51 1F 40 42 62 1E 85 00 00 14 17 C0 22 1E 7A 11 00 5C 9C 11 00 5C B8 11 00 5C D9 11 00 5C F6 0A 77 1E D1 11 00 5C D0 F2 7A 1F D4 E6 58 1F D3 0A 77 1E 10 46 56 1F 95 0A 73 1E B1 1A 70 1E 32 2A 77 1E F0 FF FF 17 28 29 4C 92 0A FE EF D2 1F 01 0A EB 61 02 00 54 28 CD 40 92 A8 00 00 B4 00 00 26 1E E0 1B 00 BD ?? ?? ?? ?? 6C 00 00 14 ?? ?? ?? ?? E1 03 27 1E 00 40 20 1E ?? ?? ?? ?? 26 00 80 52 25 04 80 52 04 01 80 52 23 00 80 52 02 F8 BF D2 01 04 80 52 ?? ?? ?? ?? 60 00 00 14 33 FD 7F D3 53 00 00 34 73 42 61 1E D0 0D 00 5C 60 22 70 1E 82 06 00 54 A8 0D 00 58 1F 00 08 EB 0A FC 74 D3 A8 00 00 54 68 0D 00 58 4B 00 80 52 29 00 80 52 07 00 00 14 28 0D 00 58 1F 00 08 EB E8 00 00 54 08 0D 00 58 8B 00 80 52 69 00 80 52 1F 00 08 EB 69 81 89 1A 05 00 00 14 91 0C 00 5C 10 10 6C 1E 71 42 51 1F 29 02 78 1E 3A 01 62 1E 32 0C 00 5C 59 CF 52 1F 33 0C 00 5C 54 0B 73 1E 28 03 66 9E F9 0F 00 FD 08 F9 74 D3 4A 01 08 CB 5F 3D 00 F1 29 02 00 54 70 0B 00 5C 5F C1 00 F1 31 43 60 1E 54 0B 00 5C 59 E7 50 1F 31 3A 79 1E 52 C7 50 1F 54 CB 74 1F 09 01 00 54 D3 0A 00 5C 38 43 60 1E D6 0A 00 5C 59 E7 53 1F 14 3B 79 1E 55 D3 53 1F 54 D7 76 1F 3B 3B 74 1E 28 05 00 12 06 00 00 14 E2 63 00 91 E1 43 00 91 ?? ?? ?? ?? FB 0B 40 FD E8 1B 40 B9 B8 05 00 5C D9 05 00 5C FA 04 00 5C 1C 05 00 5C 13 02 00 34 74 0B 7B 1E 91 E6 58 1F 90 0A 7B 1E 92 F2 7A 1F 33 0A 70 1E F1 04 00 5C 51 46 54 1F 72 1A 71 1E 56 2A 7B 1E 68 00 00 36 15 10 7E 1E B6 1A 76 1E D0 42 61 1E 00 42 62 1E 0E 00 00 14 75 0B 7B 1E B2 E6 58 1F B1 0A 7B 1E B3 F2 7A 1F 54 0A 71 1E 11 03 00 5C 70 46 55 1F 92 1A 70 1E 56 2A 7B 1E 68 00 00 36 15 10 7E 1E B6 1A 76 1E C0 42 62 1E FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 1F 20 03 D5 18 2D 44 54 FB 21 E9 3F 55 55 55 55 55 55 D5 3F D9 92 C6 03 90 E2 92 3F 1B 51 B3 D7 66 72 E0 3F AD 6A FD 6E BA 9D 91 3F 17 CB 56 DA B0 A8 D8 3F 2E 3A E7 A3 84 7E F2 3F 00 00 00 00 80 84 1E 41 5E 38 55 29 7A 6A 0F 40 D2 21 33 7F 7C D9 02 40 BB B2 CC BE 3A 46 1C 40 75 A7 BB E9 BB FD 15 40 83 C8 C9 6D 30 5F E4 3F 00 00 40 54 FB 21 F9 3F 31 63 62 1A 61 B4 D0 3D 00 00 60 1A 61 B4 D0 3D 73 70 03 2E 8A 19 A3 3B 00 00 00 2E 8A 19 A3 3B C1 49 20 25 9A 83 7B 39 }
	condition:
		$1
}

rule file_294_3_0 {
	meta:
		name = "tanf_piby4"
		size = 112
	strings:
		$1 = { 16 08 60 1E 31 02 00 5C 50 02 00 5C 73 02 00 5C D2 C2 51 1F D1 0A 60 1E 55 0A 71 1E 32 02 00 5C D4 CA 73 1F 33 02 00 5C 94 4E 56 1F B5 1A 74 1E A0 2A 60 1E 60 00 00 34 16 10 7E 1E C0 1A 60 1E C0 03 5F D6 1F 20 03 D5 AD 6A FD 6E BA 9D 91 3F 17 CB 56 DA B0 A8 D8 3F D9 92 C6 03 90 E2 92 3F 1B 51 B3 D7 66 72 E0 3F 2E 3A E7 A3 84 7E F2 3F }
	condition:
		$1
}

rule file_295_4_0 {
	meta:
		name = "__ascii_strnicmp"
		size = 80
	strings:
		$1 = { 42 02 00 B4 0A 14 40 38 48 05 01 51 1F 65 00 71 48 00 00 54 4A 81 00 11 2B 14 40 38 69 05 01 51 3F 65 00 71 48 00 00 54 6B 81 00 11 42 04 00 D1 82 00 00 B4 5F 01 00 71 40 11 4B 7A 40 FE FF 54 40 01 0B 4B 02 00 00 14 00 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_295_6_0 {
	meta:
		name = "_strnicmp_l"
		size = 224
		refs = "0028 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0040 _errno 004c _invalid_parameter_noinfo 0070 __ascii_strnicmp 0084 _tolower_l"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 55 00 00 91 95 05 00 B4 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? B4 00 00 B4 93 00 00 B4 E8 7B 40 B2 BF 02 08 EB E9 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 17 00 00 14 E8 0F 40 F9 08 9D 40 F9 C8 00 00 B5 A2 02 00 91 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 0F 00 00 14 96 02 13 CB C0 6A 73 38 E1 63 00 91 ?? ?? ?? ?? E1 63 00 91 14 00 00 11 60 16 40 38 ?? ?? ?? ?? B5 06 00 D1 95 00 00 B4 9F 02 00 71 80 12 40 7A A0 FE FF 54 80 02 00 4B E8 A3 40 39 E8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 02 00 00 14 00 00 80 52 FD 7B C3 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_297_3_0 {
	meta:
		name = "?eof@__crt_stdio_stream@@QEBA_NXZ"
		size = 20
	strings:
		$1 = { 08 00 40 F9 09 15 40 B9 BF 3B 03 D5 20 0D 03 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_297_4_0 {
	meta:
		name = "?error@__crt_stdio_stream@@QEBA_NXZ"
		size = 20
	strings:
		$1 = { 08 00 40 F9 09 15 40 B9 BF 3B 03 D5 20 11 04 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_297_7_0 {
	meta:
		name = "feof"
		size = 56
		refs = "000c _errno 0018 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 04 00 00 14 08 14 40 B9 BF 3B 03 D5 00 0D 03 53 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_297_8_0 {
	meta:
		name = "ferror"
		size = 56
		refs = "000c _errno 0018 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 52 04 00 00 14 08 14 40 B9 BF 3B 03 D5 00 11 04 53 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_298_0_0 {
	meta:
		name = "roundf"
		size = 100
		refs = "0014 _fd_int"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 21 00 80 52 E0 13 00 BD E0 43 00 91 ?? ?? ?? ?? 08 04 00 51 1F 05 00 71 C9 01 00 54 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 40 01 00 34 E8 27 40 79 12 10 2E 1E 88 00 78 36 F0 13 40 BD 00 3A 32 1E 05 00 00 14 F1 13 40 BD 20 2A 32 1E 02 00 00 14 E0 13 40 BD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_299_0_0 {
	meta:
		name = "floor"
		size = 176
		refs = "0038 _handle_nan"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 0B 00 66 9E 09 68 E8 D2 E0 0B 00 FD 68 F9 40 92 7F 01 08 EB EC 07 9F 9A 1F 01 09 EB E3 00 00 54 09 FE EF D2 1F 01 09 EB C9 03 00 54 60 01 00 91 ?? ?? ?? ?? 1B 00 00 14 09 FE E7 D2 1F 01 09 EB E2 00 00 54 E8 02 00 B4 11 10 7E 1E 9F 01 00 F1 F0 03 67 9E 20 1E 70 1E 12 00 00 14 68 F9 74 D3 69 86 80 D2 29 01 08 CB 2A 00 80 D2 48 21 C9 9A 09 05 00 D1 EA 03 29 AA 48 01 0B 8A E8 0B 00 F9 EC 00 00 B4 1F 01 0B EB A0 00 00 54 11 01 67 9E 10 10 6E 1E 20 3A 70 1E 02 00 00 14 E0 0B 40 FD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_300_0_0 {
	meta:
		name = "_loaddll"
		size = 24
		refs = "0000 __imp_LoadLibraryExA"
	strings:
		$1 = { ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 02 00 80 52 01 00 80 D2 20 01 1F D6 }
	condition:
		$1
}

rule file_300_1_0 {
	meta:
		name = "_unloaddll"
		size = 60
		refs = "0008 __imp_FreeLibrary 001c __imp_GetLastError"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 C0 00 00 35 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 02 00 00 14 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_301_12_0 {
	meta:
		name = "?close@environment_strings_traits@?A0x1bf47908@@SA_NPEA_W@Z"
		size = 36
		refs = "0008 __imp_FreeEnvironmentStringsW"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 20 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_301_15_0 {
	meta:
		name = "?find_end_of_double_null_terminated_sequence@@YAPEB_WQEB_W@Z"
		size = 68
	strings:
		$1 = { 08 00 40 79 C8 01 00 34 09 3D 00 53 0A 00 00 91 28 3D 00 13 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 00 CB 4B FD 41 93 6C 05 00 91 00 04 0C 8B 09 00 40 79 A9 FE FF 35 00 08 00 91 C0 03 5F D6 }
	condition:
		$1
}

rule file_301_25_0 {
	meta:
		name = "__dcrt_get_narrow_environment_from_os"
		size = 320
		refs = "0014 __imp_GetEnvironmentStringsW 0070 __imp_WideCharToMultiByte 00b4 _malloc_base 0104 _free_base 0114 __imp_FreeEnvironmentStringsW"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 13 00 00 91 33 07 00 B4 68 02 40 79 6D 02 00 91 C8 01 00 34 08 3D 00 53 AA 01 00 91 08 3D 00 13 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0D CB 4B FD 41 93 6C 05 00 91 AD 05 0C 8B A8 01 40 79 A8 FE FF 35 A8 01 13 CB ?? ?? ?? ?? 09 09 00 91 ?? ?? ?? ?? 36 FD 41 93 09 FD DF C8 07 00 80 D2 06 00 80 D2 05 00 80 52 04 00 80 D2 C3 02 00 11 62 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 15 7C 40 93 15 03 00 B4 A0 02 00 91 ?? ?? ?? ?? 14 00 00 91 E0 0B 00 F9 14 02 00 B4 ?? ?? ?? ?? 09 FD DF C8 A5 02 00 11 07 00 80 D2 06 00 80 D2 84 02 00 91 C3 02 00 11 62 02 00 91 01 00 80 52 00 00 80 52 20 01 3F D6 60 00 00 34 00 00 80 D2 03 00 00 14 E0 0B 40 F9 14 00 80 D2 ?? ?? ?? ?? 02 00 00 14 14 00 80 D2 D3 00 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 60 02 00 91 20 01 3F D6 80 02 00 91 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_301_26_0 {
	meta:
		name = "__dcrt_get_wide_environment_from_os"
		size = 212
		refs = "0010 __imp_GetEnvironmentStringsW 0080 _malloc_base 00a0 memcpy 00a8 _free_base 00ac __imp_FreeEnvironmentStringsW"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 14 00 00 91 74 00 00 B5 13 00 80 D2 25 00 00 14 88 02 40 79 8D 02 00 91 C8 01 00 34 09 3D 00 53 AA 01 00 91 28 3D 00 13 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 4A 01 0D CB 4B FD 41 93 6C 05 00 91 AD 05 0C 8B A9 01 40 79 A9 FE FF 35 A8 01 14 CB 09 09 00 91 35 FD 41 93 A0 FA 7F D3 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 13 00 80 D2 05 00 00 14 A2 FA 7F D3 81 02 00 91 60 02 00 91 ?? ?? ?? ?? 00 00 80 D2 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 80 02 00 91 20 01 3F D6 60 02 00 91 FD 7B C1 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_302_0_0 {
	meta:
		name = "??$common_tcsset_s@D@@YAHQEAD_KD@Z"
		size = 100
		refs = "0014 _errno 0020 _invalid_parameter_noinfo"
		altNames = "_strset_s"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 1F 00 00 F1 24 18 40 FA E8 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 0D 00 00 14 08 00 C0 39 0A 00 00 91 C8 00 00 34 21 04 00 D1 81 00 00 B4 42 01 00 39 49 1D C0 38 89 FF FF 35 61 00 00 B5 1F 00 00 39 F0 FF FF 17 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_303_0_0 {
	meta:
		name = "logbl"
		size = 112
		refs = "0014 _ldunscale 0048 _LInf_C 0058 _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E1 63 00 91 E0 0F 00 FD E0 43 00 91 ?? ?? ?? ?? E0 01 00 34 1F 04 00 71 40 01 00 54 1F 08 00 71 C0 00 00 54 E8 23 C0 79 08 05 00 51 09 3D 00 13 20 01 62 1E 0B 00 00 14 E0 0F 40 FD 09 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 06 00 00 14 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 42 61 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_535_0_0 {
	meta:
		name = "logb"
		size = 112
		refs = "0014 _dunscale 0048 _Inf_C 0058 _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E1 63 00 91 E0 0F 00 FD E0 43 00 91 ?? ?? ?? ?? E0 01 00 34 1F 04 00 71 40 01 00 54 1F 08 00 71 C0 00 00 54 E8 23 C0 79 08 05 00 51 09 3D 00 13 20 01 62 1E 0B 00 00 14 E0 0F 40 FD 09 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 06 00 00 14 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 00 42 61 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_304_0_0 {
	meta:
		name = "_byteswap_uint64"
		size = 68
	strings:
		$1 = { 08 1C 78 92 0A 41 00 8B 09 1C 70 92 08 1C 68 92 2B 41 0A 8B 09 FC 68 D3 2A 1D 78 92 0C 41 0B 8B 08 FC 48 D3 09 1D 68 92 4B 21 0C 8B 0A FC 58 D3 48 1D 70 92 6C 01 09 8B 89 01 08 8B 20 E1 40 8B C0 03 5F D6 }
	condition:
		$1
}

rule file_304_1_0 {
	meta:
		name = "_byteswap_ulong"
		size = 28
	strings:
		$1 = { 08 1C 18 12 0A 41 00 0B 08 7C 08 53 09 1D 18 12 2A 21 0A 0B 40 61 40 0B C0 03 5F D6 }
	condition:
		$1
}

rule file_304_2_0 {
	meta:
		name = "_byteswap_ushort"
		size = 24
	strings:
		$1 = { 08 7C 08 53 0A 5C 18 53 09 3D 00 53 2A 21 2A 0B 40 3D 00 53 C0 03 5F D6 }
	condition:
		$1
}

rule file_306_5_0 {
	meta:
		name = "_mbctolower_l"
		size = 200
		refs = "0018 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 006c __acrt_LCMapStringA"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 FF 43 00 D1 13 00 00 11 E0 A3 00 91 ?? ?? ?? ?? EA 1F 40 F9 7F FE 03 71 09 03 00 54 68 7E 08 53 F3 87 00 39 09 1D 00 53 28 01 0A 8B E9 83 00 39 09 65 40 39 E9 02 10 36 47 05 40 B9 28 00 80 52 41 11 41 F9 46 00 80 52 E8 03 00 B9 E5 93 00 91 44 00 80 52 E3 83 00 91 02 20 80 52 E0 C3 00 91 ?? ?? ?? ?? 60 01 00 34 E9 93 40 39 E8 97 40 39 13 21 09 0B 07 00 00 14 68 06 00 11 48 C1 28 8B 09 61 40 39 69 00 20 36 48 C1 33 8B 13 65 44 39 E8 03 41 39 A8 00 00 34 EA 17 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 60 02 00 11 FF 43 00 91 FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_307_0_0 {
	meta:
		name = "_cgets"
		size = 116
		refs = "0014 __doserrno 001c _errno 0028 _invalid_parameter_noinfo 0054 _cgets_s"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 14 00 00 91 34 01 00 B5 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 0E 00 00 14 88 02 C0 39 1F 01 00 71 CD FE FF 54 93 0A 00 91 FF 0B 00 F9 60 02 00 91 E2 43 00 91 01 7D 40 93 ?? ?? ?? ?? E8 43 C0 39 1F 00 00 71 60 02 9F 9A 88 06 00 39 FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_307_1_0 {
	meta:
		name = "_cgets_s"
		size = 264
		refs = "0020 __doserrno 0028 _errno 0034 _invalid_parameter_noinfo 0050 __acrt_lock 0070 _cgetws_s 0094 wctomb_s 00c8 __console_wchar_buffer 00d4 __console_wchar_buffer_used 00e0 __acrt_unlock"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BD A9 FD 03 00 91 13 00 00 91 34 00 00 91 56 00 00 91 33 01 00 B5 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 2F 00 00 14 14 FF FF B4 7F 02 00 39 D6 FE FF B4 20 01 80 52 ?? ?? ?? ?? DF 02 00 F9 95 06 00 D1 B5 13 00 F9 BF 0F 00 F9 A2 63 00 91 41 00 80 D2 A0 53 00 91 ?? ?? ?? ?? 14 00 00 11 34 03 00 35 A3 2B 40 79 E3 02 00 34 BF 13 00 B9 A2 02 00 91 61 02 00 91 A0 43 00 91 ?? ?? ?? ?? 60 01 00 35 AA 13 40 B9 73 C2 2A 8B B3 17 00 F9 C8 02 40 F9 09 C1 2A 8B C9 02 00 F9 B5 C2 2A CB B5 13 00 F9 15 01 00 B4 E8 FF FF 17 A8 2B 40 79 ?? ?? ?? ?? ?? ?? ?? ?? 2B 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? 20 01 80 52 ?? ?? ?? ?? 7F 02 00 39 74 00 00 34 ?? ?? ?? ?? 14 00 00 B9 80 02 00 11 FD 7B C3 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_308_0_0 {
	meta:
		name = "llrintf"
		size = 136
		refs = "0010 _fdtest 0028 nearbyintf 0044 _fperrraise"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 13 00 BD ?? ?? ?? ?? 00 03 00 34 08 04 00 51 1F 05 00 71 69 02 00 54 E0 13 40 BD ?? ?? ?? ?? F0 13 40 BD 12 40 20 1E F2 17 00 BD 40 22 30 1E 80 00 00 54 00 04 80 52 ?? ?? ?? ?? F2 17 40 BD B0 01 00 1C 00 22 32 1E C8 00 00 54 71 01 00 1C 40 22 31 1E 68 00 00 54 40 02 38 9E 04 00 00 14 20 00 80 52 ?? ?? ?? ?? 00 00 80 D2 FD 7B C2 A8 C0 03 5F D6 00 00 00 DF 00 00 00 5F }
	condition:
		$1
}

rule file_309_5_0 {
	meta:
		name = "_mbsnccnt_l"
		size = 168
		refs = "001c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0028 _errno 0034 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 14 01 00 B5 F3 00 00 B4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 12 00 00 14 00 00 80 D2 13 02 00 B4 EA 13 40 F9 88 02 40 39 73 06 00 F1 88 01 00 34 08 01 0A 8B 09 65 40 39 C9 00 10 36 73 06 00 D1 E0 00 00 54 94 06 00 91 89 02 40 39 89 00 00 34 00 04 00 91 94 06 00 91 73 FE FF B5 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_310_0_0 {
	meta:
		name = "strpbrk"
		size = 172
		refs = "0008 __security_push_cookie 009c __security_pop_cookie 00a8 __report_rangecheckfailure"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? FF 83 00 D1 08 00 80 52 09 7D 40 93 3F 81 00 F1 62 04 00 54 EA 03 00 91 08 05 00 11 3F 69 2A 38 1F 81 00 71 2B FF FF 54 2A 00 40 39 6A 01 00 34 4B FD 43 D3 ED 03 00 91 69 69 6D 38 48 09 00 12 2C 00 80 52 8A 21 C8 1A 48 01 09 2A 2A 1C 40 38 68 69 2D 38 EA FE FF 35 0C 00 40 39 6C 01 00 34 88 FD 43 D3 E9 03 00 91 09 69 69 38 8A 09 00 12 2D 00 80 52 AB 21 CA 1A 68 01 09 0A 88 00 00 35 0C 1C 40 38 EC FE FF 35 00 00 80 D2 FF 83 00 91 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_311_5_0 {
	meta:
		name = "_mbslen_l"
		size = 156
		refs = "0014 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BD A9 FD 03 00 91 13 00 00 91 E0 43 00 91 ?? ?? ?? ?? EA 13 40 F9 48 09 40 B9 28 01 00 35 68 02 C0 39 6A 02 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 40 01 13 CB 0E 00 00 14 6B 02 40 39 0C 00 80 52 4B 01 00 34 68 01 0A 8B 09 65 40 39 89 00 10 36 73 06 00 91 69 02 40 39 89 00 00 34 6B 1E 40 38 8C 05 00 11 0B FF FF 35 80 7D 40 93 E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_312_0_0 {
	meta:
		name = "conjf"
		size = 48
		refs = "000c crealf 001c cimagf"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 07 03 2D ?? ?? ?? ?? E1 1F 40 BD E0 13 00 BD E0 1B 40 BD ?? ?? ?? ?? 01 40 21 1E E0 13 40 BD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_313_0_0 {
	meta:
		name = "cacosf"
		size = 692
		refs = "0010 crealf 0020 cimagf 002c _fdtest 0080 _FInf_C 0134 _FCbuild 0138 csqrtf 01b0 conjf 01c0 atan2f 0244 asinhf 026c logf"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 E0 07 07 2D ?? ?? ?? ?? E1 3F 40 BD E0 1B 00 BD E0 3B 40 BD ?? ?? ?? ?? E0 63 00 91 E0 17 00 BD ?? ?? ?? ?? 13 00 00 11 E0 53 00 91 ?? ?? ?? ?? 7F 0A 00 71 61 01 00 54 F0 1B 40 BD 1F 08 00 71 81 00 00 54 F0 13 00 BD F0 17 40 BD 8C 00 00 14 F0 13 00 BD 1F 04 00 71 21 11 00 54 2B 00 00 14 1F 08 00 71 C1 01 00 54 7F 06 00 71 C1 00 00 54 F0 17 40 BD ?? ?? ?? ?? F0 13 00 BD ?? ?? ?? ?? 7F 00 00 14 73 00 00 35 70 10 00 1C EE FF FF 17 F0 17 40 BD F0 13 00 BD 79 00 00 14 7F 06 00 71 C1 02 00 54 1F 04 00 71 01 01 00 54 F0 1B 40 BD 51 0F 00 1C 08 22 20 1E 30 0F 00 1C 21 3E 30 1E E1 13 00 BD 07 00 00 14 F2 1B 40 BD B3 0E 00 1C F0 03 27 1E 48 22 20 1E 70 3E 30 1E F0 13 00 BD ?? ?? ?? ?? ?? ?? ?? ?? E8 2F 40 79 70 42 21 1E 68 0C 78 36 06 00 00 14 1F 04 00 71 C1 00 00 54 B0 0C 00 1C F0 13 00 BD F0 17 40 BD 10 42 21 1E 5B 00 00 14 F1 C3 42 2D 21 42 21 1E 11 10 2E 1E 00 2A 31 1E F1 27 00 BD ?? ?? ?? ?? ?? ?? ?? ?? F0 17 40 BD E1 23 00 BD F1 27 40 BD E0 13 00 BD 01 42 21 1E F0 1B 40 BD 20 3A 30 1E ?? ?? ?? ?? ?? ?? ?? ?? E1 1F 00 BD E1 23 40 BD E0 2F 00 BD E0 13 40 BD ?? ?? ?? ?? E1 23 40 BD E0 33 00 BD E0 13 40 BD ?? ?? ?? ?? E1 1F 40 BD E0 27 00 BD E0 2F 40 BD ?? ?? ?? ?? E1 1F 40 BD E0 2B 00 BD E0 2F 40 BD ?? ?? ?? ?? E1 23 40 BD E0 1F 00 BD E0 13 40 BD ?? ?? ?? ?? ?? ?? ?? ?? 01 40 20 1E E0 1F 40 BD ?? ?? ?? ?? 10 10 20 1E F3 33 40 BD 31 07 00 1C F2 D3 44 2D 10 08 30 1E 20 22 33 1E F0 13 00 BD C2 00 00 54 F0 1F 40 BD F3 23 00 BD 11 1A 33 1E 20 52 12 1F 14 00 00 14 20 22 32 1E C2 00 00 54 F2 23 00 BD 92 1A 32 1E F0 1F 40 BD 40 42 13 1F 0D 00 00 14 50 42 21 1E F0 23 00 BD 20 22 30 1E A2 00 00 54 90 1A 30 1E F4 1F 40 BD 00 52 13 1F 05 00 00 14 F0 1F 40 BD FF 23 00 B9 11 0A 32 1E 80 46 13 1F ?? ?? ?? ?? F2 23 40 BD 10 40 20 1E F0 27 00 BD 48 22 20 1E 80 01 00 54 F1 13 40 BD 40 42 20 1E 28 22 20 1E AB 00 00 54 ?? ?? ?? ?? F0 27 40 BD 10 28 30 1E 04 00 00 14 ?? ?? ?? ?? F0 27 40 BD 10 3A 20 1E E0 13 40 BD 01 42 20 1E ?? ?? ?? ?? FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 DB 0F C9 3F E4 CB 16 40 DB 0F 49 3F DB 0F 49 40 0A E8 7F 5E }
	condition:
		$1
}

rule file_314_1_0 {
	meta:
		name = "_sleep"
		size = 28
		refs = "000c __imp_Sleep"
	strings:
		$1 = { 28 00 80 52 1F 00 00 71 00 01 80 1A ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 1F D6 }
	condition:
		$1
}

rule file_315_1_0 {
	meta:
		name = "_msize_base"
		size = 76
		refs = "000c _errno 0018 _invalid_parameter_noinfo 0024 __acrt_heap 0030 __imp_HeapSize"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 E0 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 92 09 00 00 14 ?? ?? ?? ?? 02 00 00 91 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 01 00 80 52 20 01 3F D6 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_316_5_0 {
	meta:
		name = "_mbsnbcmp_l"
		size = 352
		refs = "0030 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 004c strncmp 005c _errno 0068 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BD A9 FD 03 00 91 14 00 00 91 35 00 00 91 53 00 00 91 73 00 00 B5 00 00 80 52 4B 00 00 14 61 00 00 91 E0 43 00 91 ?? ?? ?? ?? ED 13 40 F9 A8 09 40 B9 C8 00 00 35 62 02 00 91 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? 3A 00 00 14 54 00 00 B4 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 32 00 00 14 8C 16 40 38 73 06 00 D1 88 1D 00 53 A8 C1 28 8B 09 65 40 39 29 02 10 36 33 01 00 B5 AB 02 40 39 0C 00 80 52 69 01 0D 8B 2A 65 40 39 4A 00 10 36 0B 00 80 52 6B 3D 00 53 19 00 00 14 88 02 40 39 68 00 00 35 08 00 80 52 03 00 00 14 08 21 0C 2A 94 06 00 91 0C 3D 00 53 AB 02 40 39 B5 06 00 91 68 1D 00 53 A8 C1 28 8B 09 65 40 39 89 01 10 36 73 00 00 B5 0B 00 80 52 09 00 00 14 AA 02 40 39 73 06 00 D1 6A 00 00 35 0A 00 80 52 03 00 00 14 4A 21 0B 2A B5 06 00 91 4B 3D 00 53 9F 01 0B 6B A1 00 00 54 4C 00 00 34 D3 FA FF B5 00 00 80 52 05 00 00 14 9F 01 0B 6B 29 00 80 52 08 00 80 12 20 81 88 1A E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_317_0_0 {
	meta:
		name = "_mbclen"
		size = 60
		refs = "0014 _ismbblead"
		altNames = "_mbclen_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 60 02 40 39 ?? ?? ?? ?? A0 00 00 34 68 06 40 39 68 00 00 34 40 00 80 D2 02 00 00 14 20 00 80 D2 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_318_7_0 {
	meta:
		name = "initialize_pointers"
		size = 100
		refs = "000c __security_cookie 0030 __acrt_initialize_invalid_parameter_handler 0038 __acrt_initialize_new_handler 0040 __acrt_initialize_signal_handlers 0048 __acrt_initialize_user_matherr 0050 __acrt_initialize_thread_local_exit_callback"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? 0A 08 80 52 08 00 80 D2 69 15 00 12 4A 01 09 4B 08 2D CA 9A 13 01 0B CA 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 60 02 00 91 ?? ?? ?? ?? 20 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_318_19_0 {
	meta:
		name = "__acrt_thread_attach"
		size = 28
		refs = "0008 __acrt_getptd_noexit"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 1F 00 00 F1 E0 07 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_319_0_0 {
	meta:
		name = "logf"
		size = 376
		refs = "0048 _handle_nanf 0068 ??_C@_04HIGFGEHP@logf?$AA@ 007c _handle_errorf 00e0 ?ln_tail_table@?1??logf@@9@9 0108 ?ln_lead_table@?1??logf@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 10 C0 22 1E 28 0A 00 58 0E 02 66 9E F0 0B 00 FD DF 01 08 EB 61 00 00 54 00 10 2E 1E 49 00 00 14 C8 29 4C 92 09 FE EF D2 1F 01 09 EB 81 02 00 54 C8 CD 40 92 A8 00 00 B4 00 00 26 1E E0 13 00 BD ?? ?? ?? ?? 3F 00 00 14 C8 01 41 92 A8 07 00 B4 25 04 80 52 04 01 80 52 23 00 80 52 02 F8 BF D2 ?? ?? ?? ?? E1 03 27 1E ?? ?? ?? ?? 26 00 80 52 41 03 80 52 ?? ?? ?? ?? 32 00 00 14 C8 F9 40 92 C8 00 00 B5 45 04 80 52 84 00 80 52 43 00 80 52 02 F0 BF D2 F3 FF FF 17 C8 01 41 92 A8 FD FF B5 C8 01 00 91 70 05 00 5C C9 7F 80 D2 77 05 00 5C 28 2D 4C B3 E8 0B 00 F9 C8 FD 6E D3 0A 15 00 12 F2 0B 40 FD C8 FD 6D D3 4B 01 1A 32 0A 01 00 12 6C 01 0A 0B 91 01 62 1E ?? ?? ?? ?? ?? ?? ?? ?? 8D 01 01 51 34 0A 70 1E 10 D9 6D FC C8 FD 74 D3 11 10 6C 1E 0A 29 00 12 4B FD 0F 51 78 01 62 1E ?? ?? ?? ?? ?? ?? ?? ?? 53 3A 74 1E 72 52 51 1F 11 D9 6D FC 74 02 00 5C 76 1A 72 1E 73 02 00 5C 12 47 57 1F D5 0A 76 1E B4 4E 54 1F 95 0A 75 1E B6 5A 56 1F D9 2A 70 1E 36 2B 72 1E C0 42 62 1E FD 7B C2 A8 C0 03 5F D6 00 00 00 80 0A BF 05 40 00 00 00 00 00 00 80 3F EF 39 FA FE 42 2E E6 3F DE 5E 86 99 99 99 89 3F 57 55 55 55 55 55 B5 3F }
	condition:
		$1
}

rule file_320_0_0 {
	meta:
		name = "??$is_overflow_condition@K@__crt_strtox@@YA_NIK@Z"
		size = 60
	strings:
		$1 = { 60 00 10 36 20 00 80 52 0C 00 00 14 40 01 00 36 A0 00 08 36 08 00 B0 52 3F 00 08 6B C9 00 00 54 F9 FF FF 17 08 00 B0 12 3F 00 08 6B 20 00 80 52 48 00 00 54 00 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_1_0 {
	meta:
		name = "??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
		size = 60
	strings:
		$1 = { 60 00 10 36 20 00 80 52 0C 00 00 14 40 01 00 36 A0 00 08 36 08 00 F0 D2 3F 00 08 EB C9 00 00 54 F9 FF FF 17 08 00 F0 92 3F 00 08 EB 20 00 80 52 48 00 00 54 00 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_4_0 {
	meta:
		name = "??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		size = 908
		refs = "002c _errno 0038 _invalid_parameter_noinfo 006c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00a4 _isctype_l 02c0 ??$is_overflow_condition@K@__crt_strtox@@YA_NIK@Z"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BD A9 FD 03 00 91 33 00 00 91 68 02 40 F9 56 00 00 11 75 00 00 11 68 01 00 B5 ?? ?? ?? ?? D8 02 80 52 18 00 00 B9 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 00 00 80 52 C9 00 00 14 96 00 00 34 C8 0A 00 51 1F 89 00 71 68 FE FF 54 01 00 00 91 E0 43 00 91 ?? ?? ?? ?? 79 02 40 F9 17 00 80 52 EB 0F 40 F9 28 07 00 91 34 03 C0 39 68 02 00 F9 69 09 40 B9 8A 1E 00 53 3F 05 00 71 ED 00 00 54 E2 63 00 91 01 01 80 52 40 01 00 11 ?? ?? ?? ?? EB 0F 40 F9 04 00 00 14 68 01 40 F9 09 D9 6A 78 20 01 1D 12 C0 00 00 34 6A 02 40 F9 49 05 00 91 54 01 C0 39 69 02 00 F9 EE FF FF 17 BF 02 00 71 F5 07 9F 1A 9F B6 00 71 61 00 00 54 B5 02 1F 32 03 00 00 14 9F AE 00 71 81 00 00 54 68 02 40 F9 14 15 C0 38 68 02 00 F9 C8 7A 1B 12 D8 02 80 52 48 06 00 35 88 42 03 11 09 1D 00 53 3F 25 00 71 68 00 00 54 88 C2 00 51 0D 00 00 14 88 7E 02 11 09 1D 00 53 3F 65 00 71 68 00 00 54 88 5E 01 51 07 00 00 14 88 FE 02 11 09 1D 00 53 3F 65 00 71 88 DE 00 51 49 00 00 54 08 00 80 12 88 00 00 34 D6 03 00 35 56 01 80 52 1C 00 00 14 68 02 40 F9 EC 1B 80 52 DF 02 00 71 0B 01 C0 39 0A 05 00 91 6A 02 00 F9 68 1D 00 53 09 61 01 51 29 01 0C 0A A9 01 00 34 08 01 80 52 16 01 96 1A 48 05 00 D1 68 02 00 F9 AB 01 00 34 08 01 C0 39 1F 01 0B 6B 40 01 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 06 00 00 14 08 02 80 52 54 01 C0 39 16 01 96 1A 48 05 00 91 68 02 00 F9 08 00 80 12 56 00 00 35 80 00 3E D4 0C 09 D6 1A 8D A1 16 1B 89 42 03 11 2A 1D 00 53 5F 25 00 71 68 00 00 54 8B C2 00 51 0D 00 00 14 88 7E 02 11 0B 1D 00 53 7F 65 00 71 68 00 00 54 8B 5E 01 51 07 00 00 14 89 FE 02 11 2A 1D 00 53 5F 65 00 71 8B DE 00 51 49 00 00 54 0B 00 80 12 7F 05 00 31 6E 11 56 7A C2 01 00 54 B5 02 1D 32 FF 02 0C 6B C3 00 00 54 FF 02 0C 6B 6A 01 4D 7A 69 00 00 54 B5 02 1E 32 02 00 00 14 F7 2E 16 1B 68 02 40 F9 14 15 C0 38 68 02 00 F9 DF FF FF 17 68 02 40 F9 09 05 00 D1 69 02 00 F9 F4 00 00 34 28 01 C0 39 1F 01 14 6B 80 00 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 35 01 18 37 E8 A3 40 39 79 02 00 F9 E8 EC FF 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 62 FF FF 17 E1 02 00 11 A0 02 00 11 ?? ?? ?? ?? E0 03 00 34 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 75 00 00 37 17 00 80 12 1B 00 00 14 E8 A3 40 39 95 01 08 36 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 00 00 B0 52 19 00 00 14 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 00 00 B0 12 0E 00 00 14 55 00 08 36 F7 03 17 4B E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 E0 02 00 11 FD 7B C3 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_5_0 {
	meta:
		name = "??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
		size = 1836
		refs = "002c _errno 0038 _invalid_parameter_noinfo 006c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0098 iswctype 0660 ??$is_overflow_condition@K@__crt_strtox@@YA_NIK@Z"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BD A9 FD 03 00 91 34 00 00 91 88 02 40 F9 56 00 00 11 75 00 00 11 68 01 00 B5 ?? ?? ?? ?? D8 02 80 52 18 00 00 B9 ?? ?? ?? ?? 89 06 40 F9 69 00 00 B4 88 02 40 F9 28 01 00 F9 00 00 80 52 B1 01 00 14 96 00 00 34 C8 0A 00 51 1F 89 00 71 68 FE FF 54 01 00 00 91 E0 43 00 91 ?? ?? ?? ?? 99 02 40 F9 17 00 80 52 33 03 40 79 28 0B 00 91 03 00 00 14 88 02 40 F9 13 25 40 78 60 02 00 11 88 02 00 F9 01 01 80 52 ?? ?? ?? ?? 40 FF FF 35 BF 02 00 71 F5 07 9F 1A 7F B6 00 71 61 00 00 54 B5 02 1F 32 03 00 00 14 7F AE 00 71 81 00 00 54 88 02 40 F9 13 25 40 78 88 02 00 F9 C8 7A 1B 12 D8 02 80 52 68 15 00 35 7F C2 00 71 E3 0E 00 54 7F EA 00 71 62 00 00 54 68 C2 00 51 71 00 00 14 09 E2 9F 52 7F 02 09 6B 02 0D 00 54 7F 82 19 71 C3 0D 00 54 7F AA 19 71 62 00 00 54 68 82 19 51 68 00 00 14 7F C2 1B 71 03 0D 00 54 7F EA 1B 71 62 00 00 54 68 C2 1B 51 62 00 00 14 7F 9A 25 71 43 0C 00 54 7F C2 25 71 62 00 00 54 68 9A 25 51 5C 00 00 14 7F 9A 27 71 83 0B 00 54 7F C2 27 71 62 00 00 54 68 9A 27 51 56 00 00 14 7F 9A 29 71 C3 0A 00 54 7F C2 29 71 62 00 00 54 68 9A 29 51 50 00 00 14 7F 9A 2B 71 03 0A 00 54 7F C2 2B 71 62 00 00 54 68 9A 2B 51 4A 00 00 14 7F 9A 2D 71 43 09 00 54 7F C2 2D 71 62 00 00 54 68 9A 2D 51 44 00 00 14 7F 9A 31 71 83 08 00 54 7F C2 31 71 62 00 00 54 68 9A 31 51 3E 00 00 14 7F 9A 33 71 C3 07 00 54 7F C2 33 71 62 00 00 54 68 9A 33 51 38 00 00 14 7F 9A 35 71 03 07 00 54 7F C2 35 71 62 00 00 54 68 9A 35 51 32 00 00 14 7F 42 39 71 43 06 00 54 7F 6A 39 71 62 00 00 54 68 42 39 51 2C 00 00 14 7F 42 3B 71 83 05 00 54 7F 6A 3B 71 62 00 00 54 68 42 3B 51 26 00 00 14 7F 82 3C 71 C3 04 00 54 7F AA 3C 71 62 00 00 54 68 82 3C 51 20 00 00 14 09 08 82 52 7F 02 09 6B E3 03 00 54 48 09 82 52 7F 02 08 6B 82 00 00 54 08 08 82 52 68 02 08 4B 17 00 00 14 09 FC 82 52 7F 02 09 6B C3 02 00 54 48 FD 82 52 7F 02 08 6B 62 00 00 54 08 FC 82 52 F7 FF FF 17 09 02 83 52 7F 02 09 6B C3 01 00 54 48 03 83 52 7F 02 08 6B 62 01 00 54 08 02 83 52 EF FF FF 17 49 E3 9F 52 7F 02 09 6B 62 00 00 54 08 E2 9F 52 EA FF FF 17 08 00 80 12 1F 05 00 31 A1 02 00 54 E8 F7 9F 52 68 02 08 0B 09 3D 00 53 3F 65 00 71 09 01 00 54 E8 F3 9F 52 68 02 08 0B 09 3D 00 53 3F 65 00 71 69 00 00 54 08 00 80 12 09 00 00 14 E8 F3 9F 52 68 02 08 0B 09 3D 00 53 3F 65 00 71 68 82 00 51 49 00 00 54 68 02 00 11 08 DD 00 51 88 00 00 34 B6 03 00 35 56 01 80 52 1B 00 00 14 88 02 40 F9 EB FB 9F 52 DF 02 00 71 0A 01 40 79 09 09 00 91 89 02 00 F9 48 61 01 51 08 01 0B 0A A8 01 00 34 08 01 80 52 16 01 96 1A 28 09 00 D1 88 02 00 F9 AA 01 00 34 08 01 40 79 1F 01 0A 6B 40 01 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 06 00 00 14 08 02 80 52 33 01 40 79 16 01 96 1A 28 09 00 91 88 02 00 F9 08 00 80 12 56 00 00 35 80 00 3E D4 0E 09 D6 1A CF A1 16 1B 7F C2 00 71 23 0F 00 54 7F EA 00 71 62 00 00 54 69 C2 00 51 73 00 00 14 08 E2 9F 52 7F 02 08 6B 42 0D 00 54 7F 82 19 71 03 0E 00 54 7F AA 19 71 62 00 00 54 69 82 19 51 6A 00 00 14 7F C2 1B 71 43 0D 00 54 7F EA 1B 71 62 00 00 54 69 C2 1B 51 64 00 00 14 7F 9A 25 71 83 0C 00 54 7F C2 25 71 62 00 00 54 69 9A 25 51 5E 00 00 14 7F 9A 27 71 C3 0B 00 54 7F C2 27 71 62 00 00 54 69 9A 27 51 58 00 00 14 7F 9A 29 71 03 0B 00 54 7F C2 29 71 62 00 00 54 69 9A 29 51 52 00 00 14 7F 9A 2B 71 43 0A 00 54 7F C2 2B 71 62 00 00 54 69 9A 2B 51 4C 00 00 14 7F 9A 2D 71 83 09 00 54 7F C2 2D 71 62 00 00 54 69 9A 2D 51 46 00 00 14 7F 9A 31 71 C3 08 00 54 7F C2 31 71 62 00 00 54 69 9A 31 51 40 00 00 14 7F 9A 33 71 03 08 00 54 7F C2 33 71 62 00 00 54 69 9A 33 51 3A 00 00 14 7F 9A 35 71 43 07 00 54 7F C2 35 71 62 00 00 54 69 9A 35 51 34 00 00 14 7F 42 39 71 83 06 00 54 7F 6A 39 71 62 00 00 54 69 42 39 51 2E 00 00 14 7F 42 3B 71 C3 05 00 54 7F 6A 3B 71 62 00 00 54 69 42 3B 51 28 00 00 14 7F 82 3C 71 03 05 00 54 7F AA 3C 71 62 00 00 54 69 82 3C 51 22 00 00 14 08 08 82 52 7F 02 08 6B 23 04 00 54 4A 09 82 52 7F 02 0A 6B 82 00 00 54 0B 08 82 52 69 02 0B 4B 19 00 00 14 0C FC 82 52 7F 02 0C 6B 03 03 00 54 4D FD 82 52 7F 02 0D 6B 82 00 00 54 08 FC 82 52 69 02 08 4B 10 00 00 14 0A 02 83 52 7F 02 0A 6B E3 01 00 54 4B 03 83 52 7F 02 0B 6B 82 01 00 54 0C 02 83 52 69 02 0C 4B 07 00 00 14 4D E3 9F 52 7F 02 0D 6B 62 00 00 54 08 E2 9F 52 F1 FF FF 17 09 00 80 12 3F 05 00 31 A1 02 00 54 EA F7 9F 52 68 02 0A 0B 09 3D 00 53 3F 65 00 71 09 01 00 54 EB F3 9F 52 6A 02 0B 0B 4B 3D 00 53 7F 65 00 71 69 00 00 54 09 00 80 12 09 00 00 14 EC F3 9F 52 6C 02 0C 0B 8D 3D 00 53 BF 65 00 71 68 82 00 51 49 00 00 54 68 02 00 11 09 DD 00 51 3F 05 00 31 2E 11 56 7A C2 01 00 54 B5 02 1D 32 FF 02 0E 6B C3 00 00 54 FF 02 0E 6B 2A 01 4F 7A 69 00 00 54 B5 02 1E 32 02 00 00 14 F7 26 16 1B 88 02 40 F9 13 25 40 78 88 02 00 F9 63 FF FF 17 88 02 40 F9 09 09 00 D1 89 02 00 F9 F3 00 00 34 28 01 40 79 1F 01 13 6B 80 00 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 35 01 18 37 E8 A3 40 39 99 02 00 F9 E8 CF FF 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 7A FE FF 17 E1 02 00 11 A0 02 00 11 ?? ?? ?? ?? E0 03 00 34 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 75 00 00 37 17 00 80 12 1B 00 00 14 E8 A3 40 39 95 01 08 36 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 89 06 40 F9 69 00 00 B4 88 02 40 F9 28 01 00 F9 00 00 B0 52 19 00 00 14 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 89 06 40 F9 69 00 00 B4 88 02 40 F9 28 01 00 F9 00 00 B0 12 0E 00 00 14 55 00 08 36 F7 03 17 4B E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 89 06 40 F9 69 00 00 B4 88 02 40 F9 28 01 00 F9 E0 02 00 11 FD 7B C3 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_6_0 {
	meta:
		name = "??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		size = 920
		refs = "002c _errno 0038 _invalid_parameter_noinfo 006c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 00a4 _isctype_l 02cc ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BD A9 FD 03 00 91 33 00 00 91 68 02 40 F9 56 00 00 11 75 00 00 11 68 01 00 B5 ?? ?? ?? ?? D8 02 80 52 18 00 00 B9 ?? ?? ?? ?? 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 00 00 80 D2 CC 00 00 14 96 00 00 34 C8 0A 00 51 1F 89 00 71 68 FE FF 54 01 00 00 91 E0 43 00 91 ?? ?? ?? ?? 79 02 40 F9 17 00 80 D2 EB 0F 40 F9 28 07 00 91 34 03 C0 39 68 02 00 F9 69 09 40 B9 8A 1E 00 53 3F 05 00 71 ED 00 00 54 E2 63 00 91 01 01 80 52 40 01 00 11 ?? ?? ?? ?? EB 0F 40 F9 04 00 00 14 68 01 40 F9 09 D9 6A 78 20 01 1D 12 C0 00 00 34 6A 02 40 F9 49 05 00 91 54 01 C0 39 69 02 00 F9 EE FF FF 17 BF 02 00 71 F5 07 9F 1A 9F B6 00 71 61 00 00 54 B5 02 1F 32 03 00 00 14 9F AE 00 71 81 00 00 54 68 02 40 F9 14 15 C0 38 68 02 00 F9 C8 7A 1B 12 D8 02 80 52 48 06 00 35 88 42 03 11 09 1D 00 53 3F 25 00 71 68 00 00 54 88 C2 00 51 0D 00 00 14 88 7E 02 11 09 1D 00 53 3F 65 00 71 68 00 00 54 88 5E 01 51 07 00 00 14 88 FE 02 11 09 1D 00 53 3F 65 00 71 88 DE 00 51 49 00 00 54 08 00 80 12 88 00 00 34 D6 03 00 35 56 01 80 52 1C 00 00 14 68 02 40 F9 EC 1B 80 52 DF 02 00 71 0B 01 C0 39 0A 05 00 91 6A 02 00 F9 68 1D 00 53 09 61 01 51 29 01 0C 0A A9 01 00 34 08 01 80 52 16 01 96 1A 48 05 00 D1 68 02 00 F9 AB 01 00 34 08 01 C0 39 1F 01 0B 6B 40 01 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 06 00 00 14 08 02 80 52 54 01 C0 39 16 01 96 1A 48 05 00 91 68 02 00 F9 CD 7E 40 93 08 00 80 92 4D 00 00 B5 80 00 3E D4 0C 09 CD 9A 8E A1 0D 9B 89 42 03 11 2A 1D 00 53 5F 25 00 71 68 00 00 54 8B C2 00 51 0D 00 00 14 88 7E 02 11 0B 1D 00 53 7F 65 00 71 68 00 00 54 8B 5E 01 51 07 00 00 14 89 FE 02 11 2A 1D 00 53 5F 65 00 71 8B DE 00 51 49 00 00 54 0B 00 80 12 7F 05 00 31 6E 11 56 7A 02 02 00 54 B5 02 1D 32 FF 02 0C EB E3 00 00 54 FF 02 0C EB 61 00 00 54 DF 41 2B EB 62 00 00 54 B5 02 1E 32 03 00 00 14 A8 7D 17 9B 17 41 2B 8B 69 02 40 F9 34 15 C0 38 69 02 00 F9 DD FF FF 17 68 02 40 F9 09 05 00 D1 69 02 00 F9 F4 00 00 34 28 01 C0 39 1F 01 14 6B 80 00 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 35 01 18 37 E8 A3 40 39 79 02 00 F9 88 EC FF 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 5F FF FF 17 E1 02 00 91 A0 02 00 11 ?? ?? ?? ?? E0 03 00 34 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 75 00 00 37 17 00 80 92 1B 00 00 14 E8 A3 40 39 95 01 08 36 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 00 00 F0 D2 19 00 00 14 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 00 00 F0 92 0E 00 00 14 55 00 08 36 F7 03 17 CB E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 69 06 40 F9 69 00 00 B4 68 02 40 F9 28 01 00 F9 E0 02 00 91 FD 7B C3 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_7_0 {
	meta:
		name = "??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
		size = 1848
		refs = "002c _errno 0038 _invalid_parameter_noinfo 006c ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0098 iswctype 066c ??$is_overflow_condition@_K@__crt_strtox@@YA_NI_K@Z"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 1B 00 F9 FD 7B BD A9 FD 03 00 91 34 00 00 91 88 02 40 F9 56 00 00 11 75 00 00 11 68 01 00 B5 ?? ?? ?? ?? D8 02 80 52 18 00 00 B9 ?? ?? ?? ?? 89 06 40 F9 69 00 00 B4 88 02 40 F9 28 01 00 F9 00 00 80 D2 B4 01 00 14 96 00 00 34 C8 0A 00 51 1F 89 00 71 68 FE FF 54 01 00 00 91 E0 43 00 91 ?? ?? ?? ?? 99 02 40 F9 17 00 80 D2 33 03 40 79 28 0B 00 91 03 00 00 14 88 02 40 F9 13 25 40 78 60 02 00 11 88 02 00 F9 01 01 80 52 ?? ?? ?? ?? 40 FF FF 35 BF 02 00 71 F5 07 9F 1A 7F B6 00 71 61 00 00 54 B5 02 1F 32 03 00 00 14 7F AE 00 71 81 00 00 54 88 02 40 F9 13 25 40 78 88 02 00 F9 C8 7A 1B 12 D8 02 80 52 68 15 00 35 7F C2 00 71 E3 0E 00 54 7F EA 00 71 62 00 00 54 68 C2 00 51 71 00 00 14 09 E2 9F 52 7F 02 09 6B 02 0D 00 54 7F 82 19 71 C3 0D 00 54 7F AA 19 71 62 00 00 54 68 82 19 51 68 00 00 14 7F C2 1B 71 03 0D 00 54 7F EA 1B 71 62 00 00 54 68 C2 1B 51 62 00 00 14 7F 9A 25 71 43 0C 00 54 7F C2 25 71 62 00 00 54 68 9A 25 51 5C 00 00 14 7F 9A 27 71 83 0B 00 54 7F C2 27 71 62 00 00 54 68 9A 27 51 56 00 00 14 7F 9A 29 71 C3 0A 00 54 7F C2 29 71 62 00 00 54 68 9A 29 51 50 00 00 14 7F 9A 2B 71 03 0A 00 54 7F C2 2B 71 62 00 00 54 68 9A 2B 51 4A 00 00 14 7F 9A 2D 71 43 09 00 54 7F C2 2D 71 62 00 00 54 68 9A 2D 51 44 00 00 14 7F 9A 31 71 83 08 00 54 7F C2 31 71 62 00 00 54 68 9A 31 51 3E 00 00 14 7F 9A 33 71 C3 07 00 54 7F C2 33 71 62 00 00 54 68 9A 33 51 38 00 00 14 7F 9A 35 71 03 07 00 54 7F C2 35 71 62 00 00 54 68 9A 35 51 32 00 00 14 7F 42 39 71 43 06 00 54 7F 6A 39 71 62 00 00 54 68 42 39 51 2C 00 00 14 7F 42 3B 71 83 05 00 54 7F 6A 3B 71 62 00 00 54 68 42 3B 51 26 00 00 14 7F 82 3C 71 C3 04 00 54 7F AA 3C 71 62 00 00 54 68 82 3C 51 20 00 00 14 09 08 82 52 7F 02 09 6B E3 03 00 54 48 09 82 52 7F 02 08 6B 82 00 00 54 08 08 82 52 68 02 08 4B 17 00 00 14 09 FC 82 52 7F 02 09 6B C3 02 00 54 48 FD 82 52 7F 02 08 6B 62 00 00 54 08 FC 82 52 F7 FF FF 17 09 02 83 52 7F 02 09 6B C3 01 00 54 48 03 83 52 7F 02 08 6B 62 01 00 54 08 02 83 52 EF FF FF 17 49 E3 9F 52 7F 02 09 6B 62 00 00 54 08 E2 9F 52 EA FF FF 17 08 00 80 12 1F 05 00 31 A1 02 00 54 E8 F7 9F 52 68 02 08 0B 09 3D 00 53 3F 65 00 71 09 01 00 54 E8 F3 9F 52 68 02 08 0B 09 3D 00 53 3F 65 00 71 69 00 00 54 08 00 80 12 09 00 00 14 E8 F3 9F 52 68 02 08 0B 09 3D 00 53 3F 65 00 71 68 82 00 51 49 00 00 54 68 02 00 11 08 DD 00 51 88 00 00 34 B6 03 00 35 56 01 80 52 1B 00 00 14 88 02 40 F9 EB FB 9F 52 DF 02 00 71 0A 01 40 79 09 09 00 91 89 02 00 F9 48 61 01 51 08 01 0B 0A A8 01 00 34 08 01 80 52 16 01 96 1A 28 09 00 D1 88 02 00 F9 AA 01 00 34 08 01 40 79 1F 01 0A 6B 40 01 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 06 00 00 14 08 02 80 52 33 01 40 79 16 01 96 1A 28 09 00 91 88 02 00 F9 CF 7E 40 93 08 00 80 92 4F 00 00 B5 80 00 3E D4 0E 09 CF 9A C7 A1 0F 9B 7F C2 00 71 23 0F 00 54 7F EA 00 71 62 00 00 54 69 C2 00 51 73 00 00 14 08 E2 9F 52 7F 02 08 6B 42 0D 00 54 7F 82 19 71 03 0E 00 54 7F AA 19 71 62 00 00 54 69 82 19 51 6A 00 00 14 7F C2 1B 71 43 0D 00 54 7F EA 1B 71 62 00 00 54 69 C2 1B 51 64 00 00 14 7F 9A 25 71 83 0C 00 54 7F C2 25 71 62 00 00 54 69 9A 25 51 5E 00 00 14 7F 9A 27 71 C3 0B 00 54 7F C2 27 71 62 00 00 54 69 9A 27 51 58 00 00 14 7F 9A 29 71 03 0B 00 54 7F C2 29 71 62 00 00 54 69 9A 29 51 52 00 00 14 7F 9A 2B 71 43 0A 00 54 7F C2 2B 71 62 00 00 54 69 9A 2B 51 4C 00 00 14 7F 9A 2D 71 83 09 00 54 7F C2 2D 71 62 00 00 54 69 9A 2D 51 46 00 00 14 7F 9A 31 71 C3 08 00 54 7F C2 31 71 62 00 00 54 69 9A 31 51 40 00 00 14 7F 9A 33 71 03 08 00 54 7F C2 33 71 62 00 00 54 69 9A 33 51 3A 00 00 14 7F 9A 35 71 43 07 00 54 7F C2 35 71 62 00 00 54 69 9A 35 51 34 00 00 14 7F 42 39 71 83 06 00 54 7F 6A 39 71 62 00 00 54 69 42 39 51 2E 00 00 14 7F 42 3B 71 C3 05 00 54 7F 6A 3B 71 62 00 00 54 69 42 3B 51 28 00 00 14 7F 82 3C 71 03 05 00 54 7F AA 3C 71 62 00 00 54 69 82 3C 51 22 00 00 14 08 08 82 52 7F 02 08 6B 23 04 00 54 4A 09 82 52 7F 02 0A 6B 82 00 00 54 0B 08 82 52 69 02 0B 4B 19 00 00 14 0C FC 82 52 7F 02 0C 6B 03 03 00 54 4D FD 82 52 7F 02 0D 6B 82 00 00 54 08 FC 82 52 69 02 08 4B 10 00 00 14 0A 02 83 52 7F 02 0A 6B E3 01 00 54 4B 03 83 52 7F 02 0B 6B 82 01 00 54 0C 02 83 52 69 02 0C 4B 07 00 00 14 4D E3 9F 52 7F 02 0D 6B 62 00 00 54 08 E2 9F 52 F1 FF FF 17 09 00 80 12 3F 05 00 31 A1 02 00 54 EA F7 9F 52 68 02 0A 0B 09 3D 00 53 3F 65 00 71 09 01 00 54 EB F3 9F 52 6A 02 0B 0B 4B 3D 00 53 7F 65 00 71 69 00 00 54 09 00 80 12 09 00 00 14 EC F3 9F 52 6C 02 0C 0B 8D 3D 00 53 BF 65 00 71 68 82 00 51 49 00 00 54 68 02 00 11 09 DD 00 51 3F 05 00 31 2E 11 56 7A 02 02 00 54 B5 02 1D 32 FF 02 0E EB E3 00 00 54 FF 02 0E EB 61 00 00 54 FF 40 29 EB 62 00 00 54 B5 02 1E 32 03 00 00 14 E8 7D 17 9B 17 41 29 8B 89 02 40 F9 33 25 40 78 89 02 00 F9 61 FF FF 17 88 02 40 F9 09 09 00 D1 89 02 00 F9 F3 00 00 34 28 01 40 79 1F 01 13 6B 80 00 00 54 ?? ?? ?? ?? 18 00 00 B9 ?? ?? ?? ?? 35 01 18 37 E8 A3 40 39 99 02 00 F9 88 CF FF 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 77 FE FF 17 E1 02 00 91 A0 02 00 11 ?? ?? ?? ?? E0 03 00 34 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 75 00 00 37 17 00 80 92 1B 00 00 14 E8 A3 40 39 95 01 08 36 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 89 06 40 F9 69 00 00 B4 88 02 40 F9 28 01 00 F9 00 00 F0 D2 19 00 00 14 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 89 06 40 F9 69 00 00 B4 88 02 40 F9 28 01 00 F9 00 00 F0 92 0E 00 00 14 55 00 08 36 F7 03 17 CB E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 89 06 40 F9 69 00 00 B4 88 02 40 F9 28 01 00 F9 E0 02 00 91 FD 7B C3 A8 F9 1B 40 F9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_8_0 {
	meta:
		name = "??$parse_integer_from_string@JD$$T@__crt_strtox@@YAJQEBD$$THQEAU__crt_locale_pointers@@@Z"
		size = 68
		refs = "0020 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0034 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_8_0 {
	meta:
		name = "??$parse_integer_from_string@JDPEAPEAD@__crt_strtox@@YAJQEBDQEAPEADHQEAU__crt_locale_pointers@@@Z"
		size = 68
		refs = "0020 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 0034 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_9_0 {
	meta:
		name = "??$parse_integer_from_string@J_W$$T@__crt_strtox@@YAJQEB_W$$THQEAU__crt_locale_pointers@@@Z"
		size = 68
		refs = "0020 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0034 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_9_4 {
	meta:
		name = "??$parse_integer_from_string@J_WPEAPEA_W@__crt_strtox@@YAJQEB_WQEAPEA_WHQEAU__crt_locale_pointers@@@Z"
		size = 68
		refs = "0020 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 0034 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_10_0 {
	meta:
		name = "??$parse_integer_from_string@_JD$$T@__crt_strtox@@YA_JQEBD$$THQEAU__crt_locale_pointers@@@Z"
		size = 68
		refs = "0020 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0034 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_12_3 {
	meta:
		name = "??$parse_integer_from_string@_JDPEAPEAD@__crt_strtox@@YA_JQEBDQEAPEADHQEAU__crt_locale_pointers@@@Z"
		size = 68
		refs = "0020 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 0034 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_11_0 {
	meta:
		name = "??$parse_integer_from_string@_J_W$$T@__crt_strtox@@YA_JQEB_W$$THQEAU__crt_locale_pointers@@@Z"
		size = 68
		refs = "0020 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0034 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_13_4 {
	meta:
		name = "??$parse_integer_from_string@_J_WPEAPEA_W@__crt_strtox@@YA_JQEB_WQEAPEA_WHQEAU__crt_locale_pointers@@@Z"
		size = 68
		refs = "0020 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 0034 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_47_2 {
	meta:
		name = "_strtoi64_l"
		size = 68
		refs = "0020 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 0034 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_48_3 {
	meta:
		name = "_strtoimax_l"
		size = 68
		refs = "0020 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 0034 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_49_0 {
	meta:
		name = "_strtol_l"
		size = 68
		refs = "0020 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 0034 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_50_3 {
	meta:
		name = "_strtoll_l"
		size = 68
		refs = "0020 ??$make_c_string_character_source@DPEAPEAD@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBDQEAPEAD@Z 0034 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_57_3 {
	meta:
		name = "_wcstoi64_l"
		size = 68
		refs = "0020 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 0034 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_58_4 {
	meta:
		name = "_wcstoimax_l"
		size = 68
		refs = "0020 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 0034 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_59_2 {
	meta:
		name = "_wcstol_l"
		size = 68
		refs = "0020 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 0034 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_479_60_2 {
	meta:
		name = "_wcstoll_l"
		size = 68
		refs = "0020 ??$make_c_string_character_source@_WPEAPEA_W@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_WQEAPEA_W@Z 0034 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 53 00 00 11 22 00 00 91 01 00 00 91 E0 43 00 91 74 00 00 91 ?? ?? ?? ?? 01 00 00 91 80 02 00 91 23 00 80 52 62 02 00 11 ?? ?? ?? ?? FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_20_0 {
	meta:
		name = "?get@?$c_string_character_source@_W@__crt_strtox@@QEAA_WXZ"
		size = 20
	strings:
		$1 = { 09 00 00 91 28 01 40 F9 00 25 40 78 28 01 00 F9 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_22_0 {
	meta:
		name = "?is_space@__crt_strtox@@YA_N_WPEAU__crt_locale_pointers@@@Z"
		size = 32
		refs = "000c iswctype"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 01 01 80 52 ?? ?? ?? ?? 1F 00 00 71 E0 07 9F 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_28_0 {
	meta:
		name = "?parse_digit@__crt_strtox@@YAI_W@Z"
		size = 568
	strings:
		$1 = { 1F C0 00 71 23 0F 00 54 1F E8 00 71 62 00 00 54 08 C0 00 51 71 00 00 14 09 E2 9F 52 1F 00 09 6B 02 0D 00 54 1F 80 19 71 03 0E 00 54 1F A8 19 71 62 00 00 54 08 80 19 51 68 00 00 14 1F C0 1B 71 43 0D 00 54 1F E8 1B 71 62 00 00 54 08 C0 1B 51 62 00 00 14 1F 98 25 71 83 0C 00 54 1F C0 25 71 62 00 00 54 08 98 25 51 5C 00 00 14 1F 98 27 71 C3 0B 00 54 1F C0 27 71 62 00 00 54 08 98 27 51 56 00 00 14 1F 98 29 71 03 0B 00 54 1F C0 29 71 62 00 00 54 08 98 29 51 50 00 00 14 1F 98 2B 71 43 0A 00 54 1F C0 2B 71 62 00 00 54 08 98 2B 51 4A 00 00 14 1F 98 2D 71 83 09 00 54 1F C0 2D 71 62 00 00 54 08 98 2D 51 44 00 00 14 1F 98 31 71 C3 08 00 54 1F C0 31 71 62 00 00 54 08 98 31 51 3E 00 00 14 1F 98 33 71 03 08 00 54 1F C0 33 71 62 00 00 54 08 98 33 51 38 00 00 14 1F 98 35 71 43 07 00 54 1F C0 35 71 62 00 00 54 08 98 35 51 32 00 00 14 1F 40 39 71 83 06 00 54 1F 68 39 71 62 00 00 54 08 40 39 51 2C 00 00 14 1F 40 3B 71 C3 05 00 54 1F 68 3B 71 62 00 00 54 08 40 3B 51 26 00 00 14 1F 80 3C 71 03 05 00 54 1F A8 3C 71 62 00 00 54 08 80 3C 51 20 00 00 14 09 08 82 52 1F 00 09 6B 23 04 00 54 48 09 82 52 1F 00 08 6B 82 00 00 54 08 08 82 52 08 00 08 4B 17 00 00 14 09 FC 82 52 1F 00 09 6B 03 03 00 54 48 FD 82 52 1F 00 08 6B 62 00 00 54 08 FC 82 52 F7 FF FF 17 09 02 83 52 1F 00 09 6B 03 02 00 54 48 03 83 52 1F 00 08 6B A2 01 00 54 08 02 83 52 EF FF FF 17 49 E3 9F 52 1F 00 09 6B 62 00 00 54 08 E2 9F 52 EA FF FF 17 08 00 80 12 1F 05 00 31 60 00 00 54 00 01 00 11 14 00 00 14 E8 F7 9F 52 08 00 08 0B 09 3D 00 53 3F 65 00 71 09 01 00 54 E8 F3 9F 52 08 00 08 0B 09 3D 00 53 3F 65 00 71 69 00 00 54 00 00 80 12 08 00 00 14 E8 F3 9F 52 08 00 08 0B 09 3D 00 53 3F 65 00 71 48 00 00 54 00 80 00 51 00 DC 00 51 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_34_0 {
	meta:
		name = "?unget@?$c_string_character_source@_W@__crt_strtox@@QEAAX_W@Z"
		size = 60
		refs = "0024 _errno 0030 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 08 00 40 F9 09 09 00 D1 09 00 00 F9 01 01 00 34 28 01 40 79 1F 01 01 6B A0 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_37_0 {
	meta:
		name = "?wide_character_to_digit@__crt_strtox@@YAH_W@Z"
		size = 476
	strings:
		$1 = { 1F C0 00 71 83 0E 00 54 1F E8 00 71 62 00 00 54 00 C0 00 51 71 00 00 14 08 E2 9F 52 1F 00 08 6B 02 0D 00 54 1F 80 19 71 63 0D 00 54 1F A8 19 71 62 00 00 54 00 80 19 51 68 00 00 14 1F C0 1B 71 A3 0C 00 54 1F E8 1B 71 62 00 00 54 00 C0 1B 51 62 00 00 14 1F 98 25 71 E3 0B 00 54 1F C0 25 71 62 00 00 54 00 98 25 51 5C 00 00 14 1F 98 27 71 23 0B 00 54 1F C0 27 71 62 00 00 54 00 98 27 51 56 00 00 14 1F 98 29 71 63 0A 00 54 1F C0 29 71 62 00 00 54 00 98 29 51 50 00 00 14 1F 98 2B 71 A3 09 00 54 1F C0 2B 71 62 00 00 54 00 98 2B 51 4A 00 00 14 1F 98 2D 71 E3 08 00 54 1F C0 2D 71 62 00 00 54 00 98 2D 51 44 00 00 14 1F 98 31 71 23 08 00 54 1F C0 31 71 62 00 00 54 00 98 31 51 3E 00 00 14 1F 98 33 71 63 07 00 54 1F C0 33 71 62 00 00 54 00 98 33 51 38 00 00 14 1F 98 35 71 A3 06 00 54 1F C0 35 71 62 00 00 54 00 98 35 51 32 00 00 14 1F 40 39 71 E3 05 00 54 1F 68 39 71 62 00 00 54 00 40 39 51 2C 00 00 14 1F 40 3B 71 23 05 00 54 1F 68 3B 71 62 00 00 54 00 40 3B 51 26 00 00 14 1F 80 3C 71 63 04 00 54 1F A8 3C 71 62 00 00 54 00 80 3C 51 20 00 00 14 08 08 82 52 1F 00 08 6B 83 03 00 54 48 09 82 52 1F 00 08 6B 82 00 00 54 08 08 82 52 00 00 08 4B 17 00 00 14 08 FC 82 52 1F 00 08 6B 63 02 00 54 48 FD 82 52 1F 00 08 6B 62 00 00 54 08 FC 82 52 F7 FF FF 17 08 02 83 52 1F 00 08 6B 63 01 00 54 48 03 83 52 1F 00 08 6B 02 01 00 54 08 02 83 52 EF FF FF 17 48 E3 9F 52 1F 00 08 6B 62 00 00 54 08 E2 9F 52 EA FF FF 17 00 00 80 12 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_40_0 {
	meta:
		name = "_atoi64"
		size = 52
		refs = "0014 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0028 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		altNames = "atoll"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 00 00 80 D2 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_47_0 {
	meta:
		name = "_wtoi"
		size = 52
		refs = "0014 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0028 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 00 00 80 D2 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_48_0 {
	meta:
		name = "_wtoi64"
		size = 52
		refs = "0014 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0028 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 00 00 80 D2 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_51_2 {
	meta:
		name = "_wtol"
		size = 52
		refs = "0014 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0028 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 00 00 80 D2 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_53_3 {
	meta:
		name = "_wtoll"
		size = 52
		refs = "0014 ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0028 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 00 00 80 D2 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_55_0 {
	meta:
		name = "atoi"
		size = 52
		refs = "0014 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0028 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 00 00 80 D2 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_56_3 {
	meta:
		name = "atol"
		size = 52
		refs = "0014 ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0028 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 00 00 80 D2 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_41_0 {
	meta:
		name = "_atoi64_l"
		size = 64
		refs = "001c ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0030 ??$parse_integer@_KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
		altNames = "_atoll_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 33 00 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 60 02 00 91 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_42_0 {
	meta:
		name = "_atoi_l"
		size = 64
		refs = "001c ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0030 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 33 00 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 60 02 00 91 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_43_0 {
	meta:
		name = "_atol_l"
		size = 64
		refs = "001c ??$make_c_string_character_source@D$$T@__crt_strtox@@YA?AV?$c_string_character_source@D@0@QEBD$$T@Z 0030 ??$parse_integer@KV?$c_string_character_source@D@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@D@0@H_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 33 00 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 60 02 00 91 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_49_2 {
	meta:
		name = "_wtoi64_l"
		size = 64
		refs = "001c ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0030 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 33 00 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 60 02 00 91 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_50_3 {
	meta:
		name = "_wtoi_l"
		size = 64
		refs = "001c ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0030 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 33 00 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 60 02 00 91 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_52_0 {
	meta:
		name = "_wtol_l"
		size = 64
		refs = "001c ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0030 ??$parse_integer@KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YAKQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 33 00 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 60 02 00 91 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_320_54_3 {
	meta:
		name = "_wtoll_l"
		size = 64
		refs = "001c ??$make_c_string_character_source@_W$$T@__crt_strtox@@YA?AV?$c_string_character_source@_W@0@QEB_W$$T@Z 0030 ??$parse_integer@_KV?$c_string_character_source@_W@__crt_strtox@@@__crt_strtox@@YA_KQEAU__crt_locale_pointers@@V?$c_string_character_source@_W@0@H_N@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 33 00 00 91 01 00 00 91 E0 43 00 91 02 00 80 D2 ?? ?? ?? ?? 23 00 80 52 01 00 00 91 60 02 00 91 42 01 80 52 ?? ?? ?? ?? FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_321_1_0 {
	meta:
		name = "_mbsninc_l"
		size = 52
		refs = "0020 _mbsnbcnt_l"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 73 00 00 B5 00 00 80 D2 04 00 00 14 60 02 00 91 ?? ?? ?? ?? 60 42 20 8B FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_322_1_0 {
	meta:
		name = "??$common_freopen@D@@YAHQEAPEAU_iobuf@@QEBD1V__crt_stdio_stream@@H@Z"
		size = 344
		refs = "002c _errno 0038 _invalid_parameter_noinfo 0088 _lock_file 00a0 _fclose_nolock 0108 _openfile 013c _unlock_file"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 15 00 00 91 34 00 00 91 56 00 00 91 A3 0B 00 F9 97 00 00 11 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 41 00 00 14 BF 02 00 F9 D4 00 00 B5 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 20 01 80 52 3A 00 00 14 76 FE FF B4 43 FE FF B4 88 02 C0 39 A8 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 F0 FF FF 17 13 00 80 52 60 00 00 91 ?? ?? ?? ?? A8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 69 00 68 36 A0 0B 40 F9 ?? ?? ?? ?? A8 0B 40 F9 1F 01 00 F9 A9 0B 40 F9 3F 05 00 F9 A8 0B 40 F9 1F 11 00 B9 A9 0B 40 F9 2C 51 00 91 8B FD 5F 88 0A 00 80 52 6B 01 0A 0A 8B FD 0A 88 8A FF FF 35 BF 3B 03 D5 A8 0B 40 F9 0C 51 00 91 8B FD 5F 88 6B 01 13 32 8B FD 09 88 A9 FF FF 35 BF 3B 03 D5 A3 0B 40 F9 E2 02 00 11 C1 02 00 91 80 02 00 91 ?? ?? ?? ?? A0 02 00 F9 40 01 00 B5 A8 0B 40 F9 0B 51 00 91 6A FD 5F 88 4A 79 12 12 6A FD 09 88 A9 FF FF 35 BF 3B 03 D5 ?? ?? ?? ?? 13 00 40 B9 A0 0B 40 F9 ?? ?? ?? ?? 60 02 00 11 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_322_3_0 {
	meta:
		name = "??$common_freopen@_W@@YAHQEAPEAU_iobuf@@QEB_W1V__crt_stdio_stream@@H@Z"
		size = 344
		refs = "002c _errno 0038 _invalid_parameter_noinfo 0088 _lock_file 00a0 _fclose_nolock 0108 _wopenfile 013c _unlock_file"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BE A9 FD 03 00 91 15 00 00 91 34 00 00 91 56 00 00 91 A3 0B 00 F9 97 00 00 11 F5 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 41 00 00 14 BF 02 00 F9 D4 00 00 B5 ?? ?? ?? ?? 28 01 80 52 08 00 00 B9 20 01 80 52 3A 00 00 14 76 FE FF B4 43 FE FF B4 88 02 40 79 A8 00 00 35 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 F0 FF FF 17 13 00 80 52 60 00 00 91 ?? ?? ?? ?? A8 0B 40 F9 09 15 40 B9 BF 3B 03 D5 69 00 68 36 A0 0B 40 F9 ?? ?? ?? ?? A8 0B 40 F9 1F 01 00 F9 A9 0B 40 F9 3F 05 00 F9 A8 0B 40 F9 1F 11 00 B9 A9 0B 40 F9 2C 51 00 91 8B FD 5F 88 0A 00 80 52 6B 01 0A 0A 8B FD 0A 88 8A FF FF 35 BF 3B 03 D5 A8 0B 40 F9 0C 51 00 91 8B FD 5F 88 6B 01 13 32 8B FD 09 88 A9 FF FF 35 BF 3B 03 D5 A3 0B 40 F9 E2 02 00 11 C1 02 00 91 80 02 00 91 ?? ?? ?? ?? A0 02 00 F9 40 01 00 B5 A8 0B 40 F9 0B 51 00 91 6A FD 5F 88 4A 79 12 12 6A FD 09 88 A9 FF FF 35 BF 3B 03 D5 ?? ?? ?? ?? 13 00 40 B9 A0 0B 40 F9 ?? ?? ?? ?? 60 02 00 11 FD 7B C2 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_322_16_0 {
	meta:
		name = "_wfreopen"
		size = 48
		refs = "0020 ??$common_freopen@_W@@YAHQEAPEAU_iobuf@@QEB_W1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 43 00 00 91 FF 0B 00 F9 22 00 00 91 01 00 00 91 E0 43 00 91 04 08 80 52 ?? ?? ?? ?? E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_322_18_0 {
	meta:
		name = "freopen"
		size = 48
		refs = "0020 ??$common_freopen@D@@YAHQEAPEAU_iobuf@@QEBD1V__crt_stdio_stream@@H@Z"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 43 00 00 91 FF 0B 00 F9 22 00 00 91 01 00 00 91 E0 43 00 91 04 08 80 52 ?? ?? ?? ?? E0 0B 40 F9 FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_323_0_0 {
	meta:
		name = "acosf"
		size = 520
		refs = "0034 _handle_nanf 0054 _controlfp_s 00a0 ??_C@_05FFFCHCED@acosf?$AA@ 00c4 _handle_errorf"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 0B 00 26 1E E0 13 00 BD F9 03 27 1E 68 79 17 53 0A FD 01 51 08 F0 AF 52 69 79 00 12 3F 01 08 6B 6C 01 01 12 89 00 00 54 60 01 00 91 ?? ?? ?? ?? 63 00 00 14 5F 69 00 31 0A 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? 80 0C 00 1C 5A 00 00 14 6A 03 F8 37 10 10 2E 1E 00 20 30 1E 61 00 00 54 E0 03 27 1E 54 00 00 14 10 10 3E 1E 00 20 30 1E 01 01 00 54 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? A0 0A 00 1C 4A 00 00 14 ?? ?? ?? ?? E1 03 27 1E ?? ?? ?? ?? 26 00 80 52 25 04 80 52 04 01 80 52 23 00 80 52 02 F8 BF D2 A1 01 80 52 ?? ?? ?? ?? 3F 00 00 14 6C 00 00 34 17 40 21 1E 02 00 00 14 17 40 20 1E 5F 05 00 31 0B 01 00 54 10 10 2E 1E 11 3A 37 1E 10 10 2C 1E 38 0A 30 1E 19 C3 21 1E 37 43 20 1E 02 00 00 14 F8 0A 37 1E 72 07 00 1C 71 07 00 1C 75 07 00 1C 70 07 00 1C 13 C7 12 1F 52 07 00 1C 15 C3 15 1F 74 CA 38 1F 13 07 00 1C 94 4E 18 1F 96 0A 38 1E DA 1A 35 1E 6B 03 00 54 8C 01 00 34 56 0B 37 1E 9A 04 00 5C 31 C3 22 1E 18 10 60 1E 72 04 00 5C D7 C2 22 1E F7 3A 7A 1E F9 2A 71 1E 33 CB 58 1F 60 42 62 1E 18 00 00 14 28 03 26 1E F9 13 00 BD 15 10 20 1E 08 3D 10 12 16 01 27 1E E8 13 00 B9 D4 E2 16 1F D0 2A 39 1E 91 1A 30 1E 32 0A 35 1E F1 0A 35 1E 33 4A 1A 1F C0 4E 15 1F 0A 00 00 14 52 0B 20 1E 7A 01 00 5C 16 C0 22 1E B0 01 00 5C 55 C2 22 1E 53 3B 75 1E D4 3A 73 1E 14 3A 74 1E 80 42 62 1E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 07 5C 14 33 26 A6 91 3C 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 F9 3F DB 0F C9 3F DB 0F 49 40 6B CE 81 3B E1 3F 5B BC 0D 1F 56 3F A5 6F 8D 3F DD 8B 67 3D DC 94 3C 3E }
	condition:
		$1
}

rule file_324_0_0 {
	meta:
		name = "atanhf"
		size = 196
		refs = "0014 _fdtest 0050 _fperrraise 0054 _FNan_C 0070 _FInf_C 0098 log1pf"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 13 00 BD ?? ?? ?? ?? 08 78 1E 12 C8 04 00 34 F1 13 40 BD 28 22 20 1E A2 00 00 54 31 42 21 1E 33 00 80 52 F1 13 00 BD 02 00 00 14 13 00 80 52 13 10 2E 1E 60 22 31 1E C2 00 00 54 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 17 00 00 14 20 22 33 1E 21 01 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 7F 02 00 71 30 42 21 1E 00 1E 31 1E 0D 00 00 14 10 10 20 1E 32 0A 30 1E 71 3A 31 1E 40 1A 31 1E ?? ?? ?? ?? 10 10 2C 1E 7F 02 00 71 12 08 30 1E 51 42 21 1E 20 1E 32 1E 02 00 00 14 E0 13 40 BD FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_325_0_0 {
	meta:
		name = "??$common_tcscat_s@_W@@YAHQEA_W_KQEB_W@Z"
		size = 176
		refs = "0018 _errno 0024 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 1F 00 00 F1 24 18 40 FA E8 00 00 54 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? C0 02 80 52 1E 00 00 14 62 00 00 B5 1F 00 00 79 F8 FF FF 17 09 00 00 91 28 01 40 79 88 00 00 34 29 09 00 91 21 04 00 D1 81 FF FF B5 A1 00 00 B5 1F 00 00 79 ?? ?? ?? ?? D3 02 80 52 0B 00 00 14 4A 00 09 CB 48 69 69 78 28 25 00 78 68 00 00 34 21 04 00 D1 81 FF FF B5 01 01 00 B5 1F 00 00 79 ?? ?? ?? ?? 53 04 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 02 00 00 14 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_325_1_0 {
	meta:
		name = "wcscat_s"
		size = 152
		refs = "0014 _errno 0020 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 1F 00 00 F1 24 18 40 FA E8 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 1A 00 00 14 62 00 00 B5 1F 00 00 79 F8 FF FF 17 09 00 00 91 28 01 40 79 88 00 00 34 29 09 00 91 21 04 00 D1 81 FF FF B5 01 FF FF B4 4A 00 09 CB 48 69 69 78 28 25 00 78 68 00 00 34 21 04 00 D1 81 FF FF B5 01 01 00 B5 1F 00 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 02 00 00 14 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_326_0_0 {
	meta:
		name = "??$common_splitpath@D@@YAXQEBDQEAD111@Z"
		size = 124
		refs = "0070 ??$common_splitpath_internal@DV<lambda_53a6356d19cc262edbc98b4248a685b4>@@V<lambda_040cbb5784310d69116e1bf4e70bcac8>@@@@YAHQEBDQEAU?$component_buffers@D@?A0x95109fda@@V<lambda_53a6356d19cc262edbc98b4248a685b4>@@V<lambda_040cbb5784310d69116e1bf4e70bcac8>@@@Z"
		altNames = "_splitpath"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 3F 00 00 F1 E2 17 00 F9 68 00 80 D2 E3 1F 00 F9 08 11 9F 9A E1 A3 01 A9 E1 63 00 91 E4 27 00 F9 5F 00 00 F1 08 20 80 D2 08 11 9F 9A E8 1B 00 F9 7F 00 00 F1 08 20 80 D2 08 11 9F 9A E8 23 00 F9 9F 00 00 F1 08 20 80 D2 08 11 9F 9A E8 2B 00 F9 E9 43 00 91 E8 47 00 91 3F 01 00 39 E3 43 40 39 1F 01 00 39 E2 47 40 39 ?? ?? ?? ?? FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_326_1_0 {
	meta:
		name = "??$common_splitpath@_W@@YAXQEB_WQEA_W111@Z"
		size = 124
		refs = "0070 ??$common_splitpath_internal@_WV<lambda_9fe510dc9fc28f0f48835de8b1506c83>@@V<lambda_215ce41ea8e549d39a53f9f91343d9df>@@@@YAHQEB_WQEAU?$component_buffers@_W@?A0x95109fda@@V<lambda_9fe510dc9fc28f0f48835de8b1506c83>@@V<lambda_215ce41ea8e549d39a53f9f91343d9df>@@@Z"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 3F 00 00 F1 E2 17 00 F9 68 00 80 D2 E3 1F 00 F9 08 11 9F 9A E1 A3 01 A9 E1 63 00 91 E4 27 00 F9 5F 00 00 F1 08 20 80 D2 08 11 9F 9A E8 1B 00 F9 7F 00 00 F1 08 20 80 D2 08 11 9F 9A E8 23 00 F9 9F 00 00 F1 08 20 80 D2 08 11 9F 9A E8 2B 00 F9 E9 43 00 91 E8 47 00 91 3F 01 00 39 E3 43 40 39 1F 01 00 39 E2 47 40 39 ?? ?? ?? ?? FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_326_28_0 {
	meta:
		name = "_wsplitpath"
		size = 124
		refs = "0070 ??$common_splitpath_internal@_WV<lambda_9fe510dc9fc28f0f48835de8b1506c83>@@V<lambda_215ce41ea8e549d39a53f9f91343d9df>@@@@YAHQEB_WQEAU?$component_buffers@_W@?A0x95109fda@@V<lambda_9fe510dc9fc28f0f48835de8b1506c83>@@V<lambda_215ce41ea8e549d39a53f9f91343d9df>@@@Z"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 3F 00 00 F1 E2 17 00 F9 68 00 80 D2 E3 1F 00 F9 08 11 9F 9A E1 A3 01 A9 E1 63 00 91 E4 27 00 F9 5F 00 00 F1 08 20 80 D2 08 11 9F 9A E8 1B 00 F9 7F 00 00 F1 08 20 80 D2 08 11 9F 9A E8 23 00 F9 9F 00 00 F1 08 20 80 D2 08 11 9F 9A E8 2B 00 F9 E9 43 00 91 E8 47 00 91 3F 01 00 39 E3 43 40 39 1F 01 00 39 E2 47 40 39 ?? ?? ?? ?? FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_326_6_0 {
	meta:
		name = "??$common_splitpath_s@D@@YAHQEBDQEAU?$component_buffers@D@?A0x95109fda@@@Z"
		size = 36
		refs = "0020 ??$common_splitpath_internal@DV<lambda_0a29fbdbce7e818b875cecd280c47f0b>@@V<lambda_7224c10e0d9cf27ffd5accaa7469d6af>@@@@YAHQEBDQEAU?$component_buffers@D@?A0x95109fda@@V<lambda_0a29fbdbce7e818b875cecd280c47f0b>@@V<lambda_7224c10e0d9cf27ffd5accaa7469d6af>@@@Z"
	strings:
		$1 = { FF 43 00 D1 E8 03 00 91 E9 07 00 91 1F 01 00 39 E3 03 40 39 3F 01 00 39 E2 07 40 39 FF 43 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_7_0 {
	meta:
		name = "??$common_splitpath_s@_W@@YAHQEB_WQEAU?$component_buffers@_W@?A0x95109fda@@@Z"
		size = 36
		refs = "0020 ??$common_splitpath_internal@_WV<lambda_f4d89ce576adf8640f5662d60a8d4afb>@@V<lambda_b90d8f84996fccaedfcae156869b1630>@@@@YAHQEB_WQEAU?$component_buffers@_W@?A0x95109fda@@V<lambda_f4d89ce576adf8640f5662d60a8d4afb>@@V<lambda_b90d8f84996fccaedfcae156869b1630>@@@Z"
	strings:
		$1 = { FF 43 00 D1 E8 03 00 91 E9 07 00 91 1F 01 00 39 E3 03 40 39 3F 01 00 39 E2 07 40 39 FF 43 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_326_27_0 {
	meta:
		name = "_splitpath_s"
		size = 72
		refs = "003c ??$common_splitpath_internal@DV<lambda_0a29fbdbce7e818b875cecd280c47f0b>@@V<lambda_7224c10e0d9cf27ffd5accaa7469d6af>@@@@YAHQEBDQEAU?$component_buffers@D@?A0x95109fda@@V<lambda_0a29fbdbce7e818b875cecd280c47f0b>@@V<lambda_7224c10e0d9cf27ffd5accaa7469d6af>@@@Z"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E8 33 40 F9 E9 43 00 91 E2 0F 02 A9 3F 01 00 39 E3 43 40 39 E1 0F 00 F9 E1 63 00 91 E4 17 03 A9 E7 A3 04 A9 E8 47 00 91 1F 01 00 39 E2 47 40 39 E6 23 00 F9 ?? ?? ?? ?? FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_326_29_0 {
	meta:
		name = "_wsplitpath_s"
		size = 72
		refs = "003c ??$common_splitpath_internal@_WV<lambda_f4d89ce576adf8640f5662d60a8d4afb>@@V<lambda_b90d8f84996fccaedfcae156869b1630>@@@@YAHQEB_WQEAU?$component_buffers@_W@?A0x95109fda@@V<lambda_f4d89ce576adf8640f5662d60a8d4afb>@@V<lambda_b90d8f84996fccaedfcae156869b1630>@@@Z"
	strings:
		$1 = { FD 7B BA A9 FD 03 00 91 E8 33 40 F9 E9 43 00 91 E2 0F 02 A9 3F 01 00 39 E3 43 40 39 E1 0F 00 F9 E1 63 00 91 E4 17 03 A9 E7 A3 04 A9 E8 47 00 91 1F 01 00 39 E2 47 40 39 E6 23 00 F9 ?? ?? ?? ?? FD 7B C6 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_327_9_0 {
	meta:
		name = "_putwch"
		size = 60
		refs = "0030 ??$?RV<lambda_0384895ae1aa6ccbfe369a30d6ca2ef7>@@AEAV<lambda_9e0b6ab72a5b3ae37ad997d08b519f50>@@V<lambda_7e22f70504d73c22058e5832bde5914f>@@@?$__crt_seh_guarded_call@G@@QEAAG$$QEAV<lambda_0384895ae1aa6ccbfe369a30d6ca2ef7>@@AEAV<lambda_9e0b6ab72a5b3ae37ad997d08b519f50>@@$$QEAV<lambda_7e22f70504d73c22058e5832bde5914f>@@@Z"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E3 53 00 91 E0 27 00 79 E2 83 00 91 E1 63 00 91 E0 43 00 91 E8 4B 00 91 E8 13 00 F9 29 01 80 52 28 01 80 52 E8 A7 02 29 ?? ?? ?? ?? FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_327_10_0 {
	meta:
		name = "_putwch_nolock"
		size = 116
		refs = "000c __dcrt_lowio_console_output_handle 0020 __dcrt_lowio_initialize_console_output 0038 __imp_WriteConsoleW"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? E0 23 00 79 ?? ?? ?? ?? 1F 08 00 B1 61 00 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 1F 04 00 B1 61 00 00 54 E0 FF 9F 52 0D 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 04 00 80 D2 E3 53 00 91 22 00 80 52 E1 43 00 91 20 01 3F D6 E8 23 40 79 E9 FF 9F 52 1F 00 00 71 20 01 88 1A FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_328_4_0 {
	meta:
		name = "__ascii_stricmp"
		size = 60
	strings:
		$1 = { 0A 14 40 38 48 05 01 51 1F 65 00 71 48 00 00 54 4A 81 00 11 2B 14 40 38 69 05 01 51 3F 65 00 71 48 00 00 54 6B 81 00 11 5F 01 00 71 40 11 4B 7A 80 FE FF 54 40 01 0B 4B C0 03 5F D6 }
	condition:
		$1
}

rule file_328_6_0 {
	meta:
		name = "_stricmp_l"
		size = 184
		refs = "0020 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 002c _errno 0038 _invalid_parameter_noinfo 0058 __ascii_stricmp 006c _tolower_l"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BD A9 FD 03 00 91 14 00 00 91 33 00 00 91 41 00 00 91 E0 43 00 91 ?? ?? ?? ?? 54 00 00 B4 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 14 00 00 14 E8 0F 40 F9 08 9D 40 F9 A8 00 00 B5 61 02 00 91 80 02 00 91 ?? ?? ?? ?? 0D 00 00 14 95 02 13 CB A0 6A 73 38 E1 63 00 91 ?? ?? ?? ?? E1 63 00 91 14 00 00 11 60 16 40 38 ?? ?? ?? ?? 9F 02 00 71 80 12 40 7A E0 FE FF 54 80 02 00 4B E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_329_0_0 {
	meta:
		name = "truncf"
		size = 36
		refs = "0014 _fd_int"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 01 00 80 52 E0 13 00 BD E0 43 00 91 ?? ?? ?? ?? E0 13 40 BD FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_330_0_0 {
	meta:
		name = "feholdexcept"
		size = 92
		refs = "0018 fegetenv 0040 fesetenv 0048 _clearfp"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 91 FF 7F 02 29 E0 43 00 91 ?? ?? ?? ?? 60 00 00 34 20 00 80 52 0B 00 00 14 E8 0B 40 F9 E0 43 00 91 E9 13 40 B9 68 02 00 F9 28 11 00 32 E8 13 00 B9 ?? ?? ?? ?? E0 FE FF 35 ?? ?? ?? ?? 00 00 80 52 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_331_0_0 {
	meta:
		name = "_ldquad"
		size = 1040
		refs = "0010 __security_push_cookie 0070 _ld_int 00dc _ldunscale 00f8 _ldxp_setw 0118 _ldscale 0130 __b 0170 _ldxp_mulh 01d0 _ldxp_addx 01d4 __c 0238 memcpy 025c get_acsize 0350 _ldxp_getw 0378 fmod 0388 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 03 03 D1 14 00 00 91 32 1C 00 5C 90 02 40 FD 31 1C 00 5C F2 C7 02 6D F0 0B 00 FD 40 22 70 1E C2 04 00 54 00 22 71 1E 82 04 00 54 91 1B 00 5C 11 0A 71 1E 10 10 6C 1E 28 22 60 1E 8B 00 00 54 30 2A 70 1E F0 07 00 FD 03 00 00 14 31 3A 70 1E F1 07 00 FD 01 00 80 52 E0 23 00 91 ?? ?? ?? ?? E0 07 40 FD 08 20 60 1E 20 02 00 54 10 10 6A 1E B3 19 00 5C D2 19 00 5C 11 08 70 1E 36 0A 73 1E F1 0B 40 FD D2 C6 52 1F 71 19 00 5C D3 CA 51 1F 72 19 00 5C D4 CE 52 1F 73 19 00 5C D5 D2 53 1F 74 19 00 5C D7 D6 54 1F 02 00 00 14 F7 0B 40 FD 97 02 00 FD A5 00 00 14 E1 23 00 91 F0 07 00 FD E0 03 00 91 D3 00 80 52 ?? ?? ?? ?? E8 03 C0 79 1F 59 01 71 CA 00 00 54 E0 0B 40 FD C1 00 80 52 E0 E3 00 91 ?? ?? ?? ?? 36 00 00 14 08 D9 00 51 09 7D 05 13 2A 3D 00 13 E1 17 0A 4B E0 43 00 91 EA 03 00 79 ?? ?? ?? ?? E0 0B 40 FD 41 00 80 52 E0 63 00 91 ?? ?? ?? ?? E8 03 C0 79 ?? ?? ?? ?? 0A 06 80 D2 E0 0F 40 FD ED E3 00 91 C1 00 80 52 08 05 00 51 09 7D 40 93 ?? ?? ?? ?? 2C 21 0A 9B E0 E3 00 91 88 25 40 A9 8A 2D 41 A9 A8 25 00 A9 88 25 42 A9 AA 2D 01 A9 A8 25 02 A9 ?? ?? ?? ?? E0 13 40 FD 08 20 60 1E C0 02 00 54 E8 03 C0 79 0B 06 80 D2 ?? ?? ?? ?? ED A3 01 91 C1 00 80 52 08 05 00 51 0A 7D 40 93 4C 25 0B 9B E0 A3 01 91 88 25 40 A9 8A 2D 41 A9 A8 25 00 A9 88 25 42 A9 AA 2D 01 A9 A8 25 02 A9 ?? ?? ?? ?? C3 00 80 52 E2 A3 01 91 C1 00 80 52 E0 E3 00 91 ?? ?? ?? ?? ?? ?? ?? ?? F1 1F 40 FD F0 17 40 FD 20 22 70 1E 83 00 00 54 F0 1B 40 FD 00 22 71 1E 02 06 00 54 F0 23 40 FD 01 00 80 52 E0 23 00 91 11 2A 71 1E 30 0F 00 5C 32 0A 70 1E F2 07 00 FD ?? ?? ?? ?? F0 07 40 FD D1 0E 00 5C 41 00 80 52 E0 63 00 91 00 0A 71 1E ?? ?? ?? ?? 62 7E 7D 93 ?? ?? ?? ?? E0 A3 01 91 ?? ?? ?? ?? E0 0F 40 FD 61 02 00 11 E0 A3 01 91 ?? ?? ?? ?? F0 13 40 FD 08 22 60 1E 20 02 00 54 E0 1F 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 62 7E 7D 93 E0 63 02 91 ?? ?? ?? ?? E0 13 40 FD 61 02 00 11 E0 63 02 91 ?? ?? ?? ?? 63 02 00 11 E2 63 02 91 61 02 00 11 E0 A3 01 91 ?? ?? ?? ?? 63 02 00 11 E2 A3 01 91 61 02 00 11 E0 E3 00 91 ?? ?? ?? ?? CB FF FF 17 F0 23 40 FD 10 2A 71 1E D1 07 00 5C 12 0A 71 1E 10 10 6C 1E 48 22 60 1E 8B 00 00 54 50 2A 70 1E F0 07 00 FD 03 00 00 14 51 3A 70 1E F1 07 00 FD 01 00 80 52 E0 23 00 91 ?? ?? ?? ?? F0 07 40 FD 08 22 60 1E A0 02 00 54 E0 1F 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 62 7E 7D 93 E0 63 02 91 ?? ?? ?? ?? F0 07 40 FD 11 10 7A 1E F3 04 00 5C 61 02 00 11 E0 63 02 91 12 0A 71 1E 40 0A 73 1E ?? ?? ?? ?? 63 02 00 11 E2 63 02 91 61 02 00 11 E0 E3 00 91 ?? ?? ?? ?? 61 02 00 11 E0 E3 00 91 ?? ?? ?? ?? 80 02 00 FD E0 07 40 FD F0 04 00 5C 00 20 70 1E 83 00 00 54 D1 04 00 5C 20 22 60 1E 62 00 00 54 A1 04 00 5C ?? ?? ?? ?? 08 00 78 1E 00 05 00 12 FF 03 03 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 1F 20 03 D5 83 C8 C9 6D 30 5F 94 C1 83 C8 C9 6D 30 5F 94 41 83 C8 C9 6D 30 5F E4 3F 00 00 00 00 00 00 50 3E 00 00 00 50 FB 21 B9 41 00 00 00 60 B4 10 11 40 00 00 00 20 26 A6 51 3E 00 00 00 00 5C 14 D3 3C 00 00 00 20 9A 83 3B 3B 83 C8 C9 6D 30 5F C4 3F 00 00 00 00 00 00 50 BE 00 00 C0 FF FF FF DF C1 00 00 C0 FF FF FF DF 41 00 00 00 00 00 00 E0 41 }
	condition:
		$1
}

rule file_602_0_0 {
	meta:
		name = "_dquad"
		size = 1040
		refs = "0010 __security_push_cookie 0070 _d_int 00dc _dunscale 00f8 _dxp_setw 0118 _dscale 0130 __b 0170 _dxp_mulh 01d0 _dxp_addx 01d4 __c 0238 memcpy 025c get_acsize 0350 _dxp_getw 0378 fmod 0388 __security_pop_cookie"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 03 03 D1 14 00 00 91 32 1C 00 5C 90 02 40 FD 31 1C 00 5C F2 C7 02 6D F0 0B 00 FD 40 22 70 1E C2 04 00 54 00 22 71 1E 82 04 00 54 91 1B 00 5C 11 0A 71 1E 10 10 6C 1E 28 22 60 1E 8B 00 00 54 30 2A 70 1E F0 07 00 FD 03 00 00 14 31 3A 70 1E F1 07 00 FD 01 00 80 52 E0 23 00 91 ?? ?? ?? ?? E0 07 40 FD 08 20 60 1E 20 02 00 54 10 10 6A 1E B3 19 00 5C D2 19 00 5C 11 08 70 1E 36 0A 73 1E F1 0B 40 FD D2 C6 52 1F 71 19 00 5C D3 CA 51 1F 72 19 00 5C D4 CE 52 1F 73 19 00 5C D5 D2 53 1F 74 19 00 5C D7 D6 54 1F 02 00 00 14 F7 0B 40 FD 97 02 00 FD A5 00 00 14 E1 23 00 91 F0 07 00 FD E0 03 00 91 D3 00 80 52 ?? ?? ?? ?? E8 03 C0 79 1F 59 01 71 CA 00 00 54 E0 0B 40 FD C1 00 80 52 E0 E3 00 91 ?? ?? ?? ?? 36 00 00 14 08 D9 00 51 09 7D 05 13 2A 3D 00 13 E1 17 0A 4B E0 43 00 91 EA 03 00 79 ?? ?? ?? ?? E0 0B 40 FD 41 00 80 52 E0 63 00 91 ?? ?? ?? ?? E8 03 C0 79 ?? ?? ?? ?? 0A 06 80 D2 E0 0F 40 FD ED E3 00 91 C1 00 80 52 08 05 00 51 09 7D 40 93 ?? ?? ?? ?? 2C 21 0A 9B E0 E3 00 91 88 25 40 A9 8A 2D 41 A9 A8 25 00 A9 88 25 42 A9 AA 2D 01 A9 A8 25 02 A9 ?? ?? ?? ?? E0 13 40 FD 08 20 60 1E C0 02 00 54 E8 03 C0 79 0B 06 80 D2 ?? ?? ?? ?? ED A3 01 91 C1 00 80 52 08 05 00 51 0A 7D 40 93 4C 25 0B 9B E0 A3 01 91 88 25 40 A9 8A 2D 41 A9 A8 25 00 A9 88 25 42 A9 AA 2D 01 A9 A8 25 02 A9 ?? ?? ?? ?? C3 00 80 52 E2 A3 01 91 C1 00 80 52 E0 E3 00 91 ?? ?? ?? ?? ?? ?? ?? ?? F1 1F 40 FD F0 17 40 FD 20 22 70 1E 83 00 00 54 F0 1B 40 FD 00 22 71 1E 02 06 00 54 F0 23 40 FD 01 00 80 52 E0 23 00 91 11 2A 71 1E 30 0F 00 5C 32 0A 70 1E F2 07 00 FD ?? ?? ?? ?? F0 07 40 FD D1 0E 00 5C 41 00 80 52 E0 63 00 91 00 0A 71 1E ?? ?? ?? ?? 62 7E 7D 93 ?? ?? ?? ?? E0 A3 01 91 ?? ?? ?? ?? E0 0F 40 FD 61 02 00 11 E0 A3 01 91 ?? ?? ?? ?? F0 13 40 FD 08 22 60 1E 20 02 00 54 E0 1F 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 62 7E 7D 93 E0 63 02 91 ?? ?? ?? ?? E0 13 40 FD 61 02 00 11 E0 63 02 91 ?? ?? ?? ?? 63 02 00 11 E2 63 02 91 61 02 00 11 E0 A3 01 91 ?? ?? ?? ?? 63 02 00 11 E2 A3 01 91 61 02 00 11 E0 E3 00 91 ?? ?? ?? ?? CB FF FF 17 F0 23 40 FD 10 2A 71 1E D1 07 00 5C 12 0A 71 1E 10 10 6C 1E 48 22 60 1E 8B 00 00 54 50 2A 70 1E F0 07 00 FD 03 00 00 14 51 3A 70 1E F1 07 00 FD 01 00 80 52 E0 23 00 91 ?? ?? ?? ?? F0 07 40 FD 08 22 60 1E A0 02 00 54 E0 1F 40 FD ?? ?? ?? ?? ?? ?? ?? ?? 13 00 00 11 62 7E 7D 93 E0 63 02 91 ?? ?? ?? ?? F0 07 40 FD 11 10 7A 1E F3 04 00 5C 61 02 00 11 E0 63 02 91 12 0A 71 1E 40 0A 73 1E ?? ?? ?? ?? 63 02 00 11 E2 63 02 91 61 02 00 11 E0 E3 00 91 ?? ?? ?? ?? 61 02 00 11 E0 E3 00 91 ?? ?? ?? ?? 80 02 00 FD E0 07 40 FD F0 04 00 5C 00 20 70 1E 83 00 00 54 D1 04 00 5C 20 22 60 1E 62 00 00 54 A1 04 00 5C ?? ?? ?? ?? 08 00 78 1E 00 05 00 12 FF 03 03 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 1F 20 03 D5 83 C8 C9 6D 30 5F 94 C1 83 C8 C9 6D 30 5F 94 41 83 C8 C9 6D 30 5F E4 3F 00 00 00 00 00 00 50 3E 00 00 00 50 FB 21 B9 41 00 00 00 60 B4 10 11 40 00 00 00 20 26 A6 51 3E 00 00 00 00 5C 14 D3 3C 00 00 00 20 9A 83 3B 3B 83 C8 C9 6D 30 5F C4 3F 00 00 00 00 00 00 50 BE 00 00 C0 FF FF FF DF C1 00 00 C0 FF FF FF DF 41 00 00 00 00 00 00 E0 41 }
	condition:
		$1
}

rule file_331_1_0 {
	meta:
		name = "_ldquadph"
		size = 256
		refs = "0014 _ldquad 002c _ld_int 0058 fmod"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 E0 0F 00 FD 13 00 00 91 ?? ?? ?? ?? F0 0F 40 FD 14 00 00 11 21 00 80 52 E0 43 00 91 F0 0B 00 FD ?? ?? ?? ?? E0 43 41 6D 16 3A 60 1E D0 04 00 5C 00 20 70 1E F6 0F 00 FD 83 00 00 54 91 04 00 5C 20 22 60 1E 82 00 00 54 61 04 00 5C ?? ?? ?? ?? F6 0F 40 FD 10 10 60 1E 74 02 40 FD 15 04 00 5C 32 04 00 5C 11 08 70 1E D3 52 55 1F 28 02 78 1E 40 22 73 1E 09 05 00 12 20 01 14 0B 28 01 00 54 13 10 6C 1E 00 04 00 11 D3 3A 73 1E 73 52 55 1F 73 02 00 FD FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 70 02 00 5C 60 22 70 1E 48 FF FF 54 13 10 6C 1E 00 04 00 51 D1 2A 73 1E 31 52 55 1F 71 02 00 FD F5 FF FF 17 00 00 80 FF FF FF CF C1 00 00 80 FF FF FF CF 41 00 00 00 00 00 00 D0 41 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 E9 BF }
	condition:
		$1
}

rule file_602_1_0 {
	meta:
		name = "_dquadph"
		size = 256
		refs = "0014 _dquad 002c _d_int 0058 fmod"
	strings:
		$1 = { F3 53 BF A9 FD 7B BE A9 FD 03 00 91 E0 0F 00 FD 13 00 00 91 ?? ?? ?? ?? F0 0F 40 FD 14 00 00 11 21 00 80 52 E0 43 00 91 F0 0B 00 FD ?? ?? ?? ?? E0 43 41 6D 16 3A 60 1E D0 04 00 5C 00 20 70 1E F6 0F 00 FD 83 00 00 54 91 04 00 5C 20 22 60 1E 82 00 00 54 61 04 00 5C ?? ?? ?? ?? F6 0F 40 FD 10 10 60 1E 74 02 40 FD 15 04 00 5C 32 04 00 5C 11 08 70 1E D3 52 55 1F 28 02 78 1E 40 22 73 1E 09 05 00 12 20 01 14 0B 28 01 00 54 13 10 6C 1E 00 04 00 11 D3 3A 73 1E 73 52 55 1F 73 02 00 FD FD 7B C2 A8 F3 53 C1 A8 C0 03 5F D6 70 02 00 5C 60 22 70 1E 48 FF FF 54 13 10 6C 1E 00 04 00 51 D1 2A 73 1E 31 52 55 1F 71 02 00 FD F5 FF FF 17 00 00 80 FF FF FF CF C1 00 00 80 FF FF FF CF 41 00 00 00 00 00 00 D0 41 18 2D 44 54 FB 21 09 40 18 2D 44 54 FB 21 E9 3F 18 2D 44 54 FB 21 E9 BF }
	condition:
		$1
}

rule file_331_2_0 {
	meta:
		name = "_ldsin"
		size = 400
		refs = "0018 _ldtest 0034 _ldquad 0038 _LRteps_C 00f8 _fperrraise 00fc _LNan_C"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 11 E0 0B 00 FD E0 43 00 91 ?? ?? ?? ?? 60 07 00 34 1F 04 00 71 80 06 00 54 1F 08 00 71 00 06 00 54 E0 43 00 91 ?? ?? ?? ?? ?? ?? ?? ?? FC 0B 40 FD ?? ?? ?? ?? 08 00 13 0B 30 42 61 1E 00 22 7C 1E C2 00 00 54 80 23 71 1E 82 00 00 54 08 04 00 36 1C 10 6E 1E 1E 00 00 14 9D 0B 7C 1E E8 01 00 36 11 06 00 5C 30 06 00 5C 1C 10 6E 1E B2 C3 71 1F 11 06 00 5C 53 46 5D 1F 12 06 00 5C 74 CA 7D 1F 13 06 00 5C 95 4E 5D 1F 14 06 00 5C B6 D2 7D 1F DC 72 5D 1F 0E 00 00 14 D6 05 00 5C F5 05 00 5C 10 06 00 5C 31 06 00 5C B7 D7 76 1F 36 06 00 5C 52 06 00 5C B3 0B 7C 1E F8 5A 5D 1F 19 C3 7D 1F 3A 47 5D 1F 5B CB 7D 1F 7C 73 53 1F 94 43 61 1E 1F 01 1F 72 80 1E 7C 1E 0F 00 00 14 E0 0B 40 FD 0D 00 00 14 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 00 14 F0 0B 40 FD 1C 10 6E 1E 7F 02 00 72 92 1F 70 1E 7F 02 1F 72 51 42 61 1E 20 1E 72 1E FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 09 26 0A 10 39 BA 21 3E 3B A8 61 C6 F9 7D 92 3E 63 AC 30 90 9F 01 FA 3E F6 FB 51 16 6C C1 56 3F B1 02 55 55 55 55 A5 3F AE FF FF FF FF FF DF 3F B0 8F 2F C3 10 D8 E5 3D 8F 0C 73 A1 E1 E5 5A 3E 3E E3 B5 19 A0 01 2A 3F FA F0 10 11 11 11 81 3F 4D AD E4 4F E3 1D C7 3E 42 55 55 55 55 55 C5 3F }
	condition:
		$1
}

rule file_602_2_0 {
	meta:
		name = "_dsin"
		size = 400
		refs = "0018 _dtest 0034 _dquad 0038 _Rteps_C 00f8 _fperrraise 00fc _Nan_C"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 13 00 00 11 E0 0B 00 FD E0 43 00 91 ?? ?? ?? ?? 60 07 00 34 1F 04 00 71 80 06 00 54 1F 08 00 71 00 06 00 54 E0 43 00 91 ?? ?? ?? ?? ?? ?? ?? ?? FC 0B 40 FD ?? ?? ?? ?? 08 00 13 0B 30 42 61 1E 00 22 7C 1E C2 00 00 54 80 23 71 1E 82 00 00 54 08 04 00 36 1C 10 6E 1E 1E 00 00 14 9D 0B 7C 1E E8 01 00 36 11 06 00 5C 30 06 00 5C 1C 10 6E 1E B2 C3 71 1F 11 06 00 5C 53 46 5D 1F 12 06 00 5C 74 CA 7D 1F 13 06 00 5C 95 4E 5D 1F 14 06 00 5C B6 D2 7D 1F DC 72 5D 1F 0E 00 00 14 D6 05 00 5C F5 05 00 5C 10 06 00 5C 31 06 00 5C B7 D7 76 1F 36 06 00 5C 52 06 00 5C B3 0B 7C 1E F8 5A 5D 1F 19 C3 7D 1F 3A 47 5D 1F 5B CB 7D 1F 7C 73 53 1F 94 43 61 1E 1F 01 1F 72 80 1E 7C 1E 0F 00 00 14 E0 0B 40 FD 0D 00 00 14 20 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 08 00 00 14 F0 0B 40 FD 1C 10 6E 1E 7F 02 00 72 92 1F 70 1E 7F 02 1F 72 51 42 61 1E 20 1E 72 1E FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 09 26 0A 10 39 BA 21 3E 3B A8 61 C6 F9 7D 92 3E 63 AC 30 90 9F 01 FA 3E F6 FB 51 16 6C C1 56 3F B1 02 55 55 55 55 A5 3F AE FF FF FF FF FF DF 3F B0 8F 2F C3 10 D8 E5 3D 8F 0C 73 A1 E1 E5 5A 3E 3E E3 B5 19 A0 01 2A 3F FA F0 10 11 11 11 81 3F 4D AD E4 4F E3 1D C7 3E 42 55 55 55 55 55 C5 3F }
	condition:
		$1
}

rule file_331_4_0 {
	meta:
		name = "get_acsize"
		size = 84
		refs = "0014 _ldunscale"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E1 63 00 91 E0 0F 00 FD E0 43 00 91 ?? ?? ?? ?? E8 23 C0 79 A9 01 00 18 08 7D 29 9B 09 FD 60 D3 2B 7D 04 13 68 7D 4B 0B 09 79 1F 53 2C 15 00 11 8A 7D 40 93 5F 19 00 F1 C8 00 80 52 80 91 88 1A FD 7B C2 A8 C0 03 5F D6 ED 73 48 4D }
	condition:
		$1
}

rule file_602_3_0 {
	meta:
		name = "get_acsize"
		size = 84
		refs = "0014 _dunscale"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E1 63 00 91 E0 0F 00 FD E0 43 00 91 ?? ?? ?? ?? E8 23 C0 79 A9 01 00 18 08 7D 29 9B 09 FD 60 D3 2B 7D 04 13 68 7D 4B 0B 09 79 1F 53 2C 15 00 11 8A 7D 40 93 5F 19 00 F1 C8 00 80 52 80 91 88 1A FD 7B C2 A8 C0 03 5F D6 ED 73 48 4D }
	condition:
		$1
}

rule file_331_5_0 {
	meta:
		name = "lgamma_big"
		size = 200
		refs = "001c _ldlog 003c _ldunscale 005c _ldscale 0098 _fperrraise"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 11 10 6E 1E 00 00 80 52 E0 13 00 FD 32 1A 60 1E F1 4B 03 6D ?? ?? ?? ?? F1 13 40 FD 10 10 6C 1E E1 63 00 91 E0 43 00 91 E0 17 00 FD 31 3A 70 1E F1 0F 00 FD ?? ?? ?? ?? F0 C7 42 6D E1 23 C0 79 E0 63 00 91 11 3A 71 1E F0 0F 40 FD 31 0A 70 1E F1 0F 00 FD ?? ?? ?? ?? A0 01 F8 36 F4 1F 40 FD 11 02 00 5C 30 02 00 5C 93 0A 74 1E 72 C2 71 1F 11 02 00 5C 53 46 53 1F 12 02 00 5C 75 4A 54 1F F4 0F 40 FD A0 2A 74 1E 04 00 00 14 00 01 80 52 ?? ?? ?? ?? E0 0F 40 FD FD 7B C4 A8 C0 03 5F D6 1A A0 01 1A A0 01 4A 3F 17 6C C1 16 6C C1 66 3F 55 55 55 55 55 55 B5 3F 69 7D C9 90 E3 CF DA 3F }
	condition:
		$1
}

rule file_602_5_0 {
	meta:
		name = "lgamma_big"
		size = 200
		refs = "001c _dlog 003c _dunscale 005c _dscale 0098 _fperrraise"
	strings:
		$1 = { FD 7B BC A9 FD 03 00 91 11 10 6E 1E 00 00 80 52 E0 13 00 FD 32 1A 60 1E F1 4B 03 6D ?? ?? ?? ?? F1 13 40 FD 10 10 6C 1E E1 63 00 91 E0 43 00 91 E0 17 00 FD 31 3A 70 1E F1 0F 00 FD ?? ?? ?? ?? F0 C7 42 6D E1 23 C0 79 E0 63 00 91 11 3A 71 1E F0 0F 40 FD 31 0A 70 1E F1 0F 00 FD ?? ?? ?? ?? A0 01 F8 36 F4 1F 40 FD 11 02 00 5C 30 02 00 5C 93 0A 74 1E 72 C2 71 1F 11 02 00 5C 53 46 53 1F 12 02 00 5C 75 4A 54 1F F4 0F 40 FD A0 2A 74 1E 04 00 00 14 00 01 80 52 ?? ?? ?? ?? E0 0F 40 FD FD 7B C4 A8 C0 03 5F D6 1A A0 01 1A A0 01 4A 3F 17 6C C1 16 6C C1 66 3F 55 55 55 55 55 55 B5 3F 69 7D C9 90 E3 CF DA 3F }
	condition:
		$1
}

rule file_331_6_0 {
	meta:
		name = "lgammal"
		size = 640
		refs = "0018 _ld_int 0048 _fperrraise 004c _LInf_C 0058 _ldgamma_big 0084 _ldsin 009c _ldlog 00ac lgamma_big 00d0 rootapprox 0158 _ldpoly 0178 approx 0208 _ldtgamma 0248 log1pl"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 01 00 80 52 E0 83 01 6D E0 83 00 91 ?? ?? ?? ?? F3 0F 40 FD E0 00 00 34 1F 04 00 71 20 01 00 54 1F 08 00 71 41 01 00 54 60 42 60 1E 87 00 00 14 68 22 60 1E C8 00 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 80 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 30 42 61 1E 60 22 70 1E A2 02 00 54 F1 13 40 FD 90 0F 00 5C 00 00 80 52 F0 17 00 FD 72 3A 71 1E 40 0A 70 1E ?? ?? ?? ?? F0 0F 40 FD 00 00 80 52 F2 17 40 FD 11 08 70 1E 40 1A 71 1E ?? ?? ?? ?? F0 0F 40 FD E0 17 00 FD 00 42 61 1E ?? ?? ?? ?? F0 17 40 FD 00 3A 60 1E 67 00 00 14 20 22 73 1E 88 00 00 54 60 42 60 1E ?? ?? ?? ?? 62 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 48 7D 40 93 09 06 80 D2 09 7D 09 9B 30 69 6B FC 00 22 73 1E A2 00 00 54 68 21 00 91 31 69 68 FC 60 22 71 1E A3 00 00 54 4A 05 00 11 49 7D 40 93 3F 2D 00 F1 63 FE FF 54 48 7D 40 93 1F 2D 00 F1 22 02 00 54 48 7D 40 93 09 06 80 D2 0A 7D 09 9B 68 41 00 91 69 61 00 91 50 69 68 FC 68 A1 00 91 51 69 69 FC 69 81 00 91 41 69 68 B8 40 69 69 F8 72 3A 70 1E 40 3A 71 1E E0 13 00 FD ?? ?? ?? ?? 3E 00 00 14 50 08 00 5C 00 22 73 1E C2 04 00 54 11 10 6F 1E 60 22 71 1E 62 04 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 48 7D 40 93 09 06 80 D2 09 7D 09 9B 32 69 74 FC 60 22 72 1E 83 00 00 54 4A 05 00 11 48 7D 40 93 08 FF FF B4 48 7D 40 93 09 06 80 D2 13 7D 09 9B 88 22 00 91 89 42 00 91 70 6A 68 FC 88 62 00 91 61 6A 68 B8 60 6A 69 F8 60 3A 70 1E E0 13 00 FD ?? ?? ?? ?? 88 A2 00 91 89 82 00 91 E0 17 00 FD 61 6A 68 B8 60 6A 69 F8 E0 13 40 FD ?? ?? ?? ?? F0 17 40 FD 00 1A 60 1E 16 00 00 14 E1 43 00 91 E0 63 00 91 ?? ?? ?? ?? F0 0F 40 FD 00 00 80 52 E0 13 00 FD 00 C2 60 1E ?? ?? ?? ?? E8 23 C0 79 71 02 00 5C 10 40 61 1E E0 13 40 FD E8 03 08 4B 13 01 62 1E 72 42 51 1F F1 01 00 5C 73 4A 51 1F F3 0F 00 FD ?? ?? ?? ?? F0 0F 40 FD 00 28 70 1E FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 18 2D 44 54 FB 21 09 40 33 33 33 33 33 33 F3 3F 9E BC 9A F7 1C 7D 7F 3E 00 00 00 C0 42 2E E6 3F }
	condition:
		$1
}

rule file_602_4_0 {
	meta:
		name = "lgamma"
		size = 640
		refs = "0018 _d_int 0048 _fperrraise 004c _Inf_C 0058 _dgamma_big 0084 _dsin 009c _dlog 00ac lgamma_big 00d0 rootapprox 0158 _dpoly 0178 approx 0208 _dtgamma 0248 log1p"
	strings:
		$1 = { F3 53 BF A9 FD 7B BD A9 FD 03 00 91 01 00 80 52 E0 83 01 6D E0 83 00 91 ?? ?? ?? ?? F3 0F 40 FD E0 00 00 34 1F 04 00 71 20 01 00 54 1F 08 00 71 41 01 00 54 60 42 60 1E 87 00 00 14 68 22 60 1E C8 00 00 54 80 00 80 52 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 80 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 30 42 61 1E 60 22 70 1E A2 02 00 54 F1 13 40 FD 90 0F 00 5C 00 00 80 52 F0 17 00 FD 72 3A 71 1E 40 0A 70 1E ?? ?? ?? ?? F0 0F 40 FD 00 00 80 52 F2 17 40 FD 11 08 70 1E 40 1A 71 1E ?? ?? ?? ?? F0 0F 40 FD E0 17 00 FD 00 42 61 1E ?? ?? ?? ?? F0 17 40 FD 00 3A 60 1E 67 00 00 14 20 22 73 1E 88 00 00 54 60 42 60 1E ?? ?? ?? ?? 62 00 00 14 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 48 7D 40 93 09 06 80 D2 09 7D 09 9B 30 69 6B FC 00 22 73 1E A2 00 00 54 68 21 00 91 31 69 68 FC 60 22 71 1E A3 00 00 54 4A 05 00 11 49 7D 40 93 3F 2D 00 F1 63 FE FF 54 48 7D 40 93 1F 2D 00 F1 22 02 00 54 48 7D 40 93 09 06 80 D2 0A 7D 09 9B 68 41 00 91 69 61 00 91 50 69 68 FC 68 A1 00 91 51 69 69 FC 69 81 00 91 41 69 68 B8 40 69 69 F8 72 3A 70 1E 40 3A 71 1E E0 13 00 FD ?? ?? ?? ?? 3E 00 00 14 50 08 00 5C 00 22 73 1E C2 04 00 54 11 10 6F 1E 60 22 71 1E 62 04 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 0A 00 80 52 48 7D 40 93 09 06 80 D2 09 7D 09 9B 32 69 74 FC 60 22 72 1E 83 00 00 54 4A 05 00 11 48 7D 40 93 08 FF FF B4 48 7D 40 93 09 06 80 D2 13 7D 09 9B 88 22 00 91 89 42 00 91 70 6A 68 FC 88 62 00 91 61 6A 68 B8 60 6A 69 F8 60 3A 70 1E E0 13 00 FD ?? ?? ?? ?? 88 A2 00 91 89 82 00 91 E0 17 00 FD 61 6A 68 B8 60 6A 69 F8 E0 13 40 FD ?? ?? ?? ?? F0 17 40 FD 00 1A 60 1E 16 00 00 14 E1 43 00 91 E0 63 00 91 ?? ?? ?? ?? F0 0F 40 FD 00 00 80 52 E0 13 00 FD 00 C2 60 1E ?? ?? ?? ?? E8 23 C0 79 71 02 00 5C 10 40 61 1E E0 13 40 FD E8 03 08 4B 13 01 62 1E 72 42 51 1F F1 01 00 5C 73 4A 51 1F F3 0F 00 FD ?? ?? ?? ?? F0 0F 40 FD 00 28 70 1E FD 7B C3 A8 F3 53 C1 A8 C0 03 5F D6 18 2D 44 54 FB 21 09 40 33 33 33 33 33 33 F3 3F 9E BC 9A F7 1C 7D 7F 3E 00 00 00 C0 42 2E E6 3F }
	condition:
		$1
}

rule file_332_3_0 {
	meta:
		name = "tanhf"
		size = 548
		refs = "0038 _controlfp_s 0058 _handle_nanf 0140 ?two_to_jby32_lead_table@?1??splitexpf@@9@9 0154 ?two_to_jby32_trail_table@?1??splitexpf@@9@9"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 09 00 26 1E 0A 20 A7 52 E0 03 02 2D 28 79 00 12 1F 01 0A 6B 42 01 00 54 48 00 00 35 6F 00 00 14 02 02 80 52 FF 13 00 B9 01 02 80 52 E0 43 00 91 ?? ?? ?? ?? E0 17 40 BD 68 00 00 14 0A F0 AF 52 1F 01 0A 6B A9 00 00 54 00 00 26 1E E0 17 00 BD ?? ?? ?? ?? 61 00 00 14 1F 01 09 6B 1A 10 20 1E E8 07 9F 1A 19 10 2E 1E 10 01 22 1E 07 E6 1A 1F 10 90 24 1E FD 08 20 1E A0 23 30 1E CC 0A 00 54 A0 23 39 1E E8 03 00 54 D1 0A 00 1C BE 0B 3D 1E A0 23 31 1E C2 01 00 54 73 0A 00 1C 72 0A 00 1C D0 0B 3D 1E 56 0A 00 1C D4 CB 33 1F 33 0A 00 1C 95 CE 3E 1F 14 0A 00 1C B7 0A 30 1E D5 53 16 1F F6 1A 35 1E D9 2A 3D 1E 43 00 00 14 78 09 00 1C 77 09 00 1C 71 09 00 1C 7B 09 00 1C D9 DF 38 1F 52 09 00 1C D8 0B 3D 1E D3 4B 1B 1F 3A C7 3E 1F 5C 0B 38 1E 99 1B 33 1E 39 2B 3D 1E 36 00 00 14 B5 0B 3A 1E 50 08 00 1C 1F 10 2C 1E B4 0A 30 1E 88 22 20 1E 8D 00 00 54 91 2A 3F 1E 2A 02 38 1E 03 00 00 14 92 3A 3F 1E 4A 02 38 1E 53 01 22 1E E8 03 0A 4B 14 01 22 1E ?? ?? ?? ?? B0 06 00 1C 49 11 00 12 ?? ?? ?? ?? 16 D9 69 BC ?? ?? ?? ?? ?? ?? ?? ?? 78 D6 10 1F 15 D9 69 BC 49 01 09 4B B3 05 00 1C 28 7D 04 13 90 05 00 1C 29 6D 48 0B 97 0A 33 1E 2C 7D 05 13 88 7D 4C 0B 0B 7D 01 13 69 FD 01 11 F2 2A 38 1E 2A 21 09 53 EA 17 00 B9 88 01 0B 4B F4 17 40 BD 09 FD 01 11 2A 21 09 53 EA 13 00 B9 51 7E 10 1F 50 0A 32 1E B2 2A 36 1E 31 5E 10 1F 33 2A 38 1E 73 56 12 1F 75 2A 36 1E 56 01 27 1E B7 0A 34 1E F4 66 16 1F 55 1B 34 1E 39 3B 35 1E 20 0B 27 1E FD 7B C2 A8 C0 03 5F D6 66 66 66 3F 7D 2B 4D 38 9E BC BF 3A 9C 76 AF 3E E0 58 90 3E 50 85 58 3F D8 89 20 38 00 8E A1 3A B1 79 76 3E 5F C6 95 3E 60 DB 38 3F 3B AA 38 42 00 70 B1 3C F4 FD 85 35 AB AA 2A 3E }
	condition:
		$1
}

rule file_333_0_0 {
	meta:
		name = "fmin"
		size = 96
		refs = "0010 _dtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0F 40 FD 0E 00 00 14 E0 63 00 91 ?? ?? ?? ?? E0 0B 40 FD 1F 08 00 71 20 01 00 54 F0 0F 40 FD 00 20 70 1E C3 00 00 54 00 20 70 1E 61 00 00 54 E8 2F 40 79 48 00 78 37 00 42 60 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_529_0_0 {
	meta:
		name = "fminl"
		size = 96
		refs = "0010 _ldtest"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 E0 07 01 6D ?? ?? ?? ?? 1F 08 00 71 61 00 00 54 E0 0F 40 FD 0E 00 00 14 E0 63 00 91 ?? ?? ?? ?? E0 0B 40 FD 1F 08 00 71 20 01 00 54 F0 0F 40 FD 00 20 70 1E C3 00 00 54 00 20 70 1E 61 00 00 54 E8 2F 40 79 48 00 78 37 00 42 60 1E FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_334_16_0 {
	meta:
		name = "_chsize"
		size = 36
		refs = "000c _chsize_s"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 21 7C 40 93 ?? ?? ?? ?? 08 00 80 12 1F 00 00 71 E0 03 88 1A FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_334_17_0 {
	meta:
		name = "_chsize_nolock"
		size = 416
		refs = "0024 _lseeki64_nolock 0034 _errno 006c _calloc_base 008c _setmode_nolock 00ac _write_nolock 00d4 _free_base 0108 __doserrno 015c _get_osfhandle 0160 __imp_SetEndOfFile 017c __imp_GetLastError"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 35 00 00 91 01 00 80 D2 22 00 80 52 14 00 00 11 ?? ?? ?? ?? 17 00 00 91 FF 06 00 B1 81 00 00 54 ?? ?? ?? ?? 00 00 40 B9 2E 00 00 14 42 00 80 52 01 00 80 D2 80 02 00 11 ?? ?? ?? ?? 1F 04 00 B1 00 FF FF 54 B3 02 00 CB 7F 02 00 F1 ED 06 00 54 21 00 80 D2 00 00 82 D2 ?? ?? ?? ?? 15 00 00 91 95 00 00 B5 ?? ?? ?? ?? 88 01 80 52 28 00 00 14 01 00 90 52 80 02 00 11 ?? ?? ?? ?? 16 00 00 11 09 00 82 D2 7F 02 09 EB 09 00 82 52 22 A1 93 1A A1 02 00 91 80 02 00 11 ?? ?? ?? ?? 1F 04 00 31 A0 02 00 54 73 C2 20 CB 7F 02 00 F1 AC FE FF 54 C1 02 00 11 80 02 00 11 ?? ?? ?? ?? A0 02 00 91 ?? ?? ?? ?? 02 00 80 52 E1 02 00 91 80 02 00 11 ?? ?? ?? ?? 1F 04 00 B1 40 FA FF 54 00 00 80 52 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 ?? ?? ?? ?? 08 00 40 B9 1F 15 00 71 81 00 00 54 ?? ?? ?? ?? A8 01 80 52 08 00 00 B9 ?? ?? ?? ?? 13 00 40 B9 A0 02 00 91 ?? ?? ?? ?? 60 02 00 11 EF FF FF 17 F3 FC FF B6 02 00 80 52 A1 02 00 91 80 02 00 11 ?? ?? ?? ?? 1F 04 00 B1 00 F7 FF 54 80 02 00 11 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 40 FB FF 35 ?? ?? ?? ?? A8 01 80 52 ?? ?? ?? ?? 08 00 00 B9 ?? ?? ?? ?? 09 FD DF C8 20 01 3F D6 13 00 00 11 ?? ?? ?? ?? 13 00 00 B9 A6 FF FF 17 }
	condition:
		$1
}

rule file_334_18_0 {
	meta:
		name = "_chsize_s"
		size = 232
		refs = "001c __doserrno 002c _nhandle 0040 __pioinfo 0068 _errno 008c _invalid_parameter_noinfo 00b8 ??$?RV<lambda_63911f43cc86614963252b1f423aad40>@@AEAV<lambda_522ac1b1e1a1180d6f374a882b81d1c8>@@V<lambda_6da5eaf298b4749753c721cc8c61e051>@@@?$__crt_seh_guarded_call@H@@QEAAH$$QEAV<lambda_63911f43cc86614963252b1f423aad40>@@AEAV<lambda_522ac1b1e1a1180d6f374a882b81d1c8>@@$$QEAV<lambda_6da5eaf298b4749753c721cc8c61e051>@@@Z"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BC A9 FD 03 00 91 E0 17 00 B9 1F 08 00 31 E1 13 00 F9 81 00 00 54 ?? ?? ?? ?? 1F 00 00 B9 2D 00 00 14 C0 04 F8 37 ?? ?? ?? ?? ?? ?? ?? ?? 1F 00 08 6B 42 04 00 54 09 7C 40 93 ?? ?? ?? ?? 2A FD 46 93 ?? ?? ?? ?? 08 79 6A F8 29 15 40 92 09 19 09 8B 2A E1 40 39 CA 00 00 37 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 33 01 80 52 06 00 00 14 21 01 F8 B6 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 ?? ?? ?? ?? 60 02 00 11 12 00 00 14 E8 53 00 91 E0 03 03 29 E9 83 00 91 E8 A7 02 A9 E0 43 00 91 E3 63 00 91 E2 A3 00 91 E1 73 00 91 ?? ?? ?? ?? 08 00 00 14 ?? ?? ?? ?? 1F 00 00 B9 ?? ?? ?? ?? 33 01 80 52 13 00 00 B9 ?? ?? ?? ?? 20 01 80 52 FD 7B C4 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_336_0_0 {
	meta:
		name = "norm"
		size = 52
		refs = "000c creal 001c cimag"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F1 0B 40 FD 10 08 60 1E 20 42 51 1F FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_657_0_0 {
	meta:
		name = "norml"
		size = 52
		refs = "000c creall 001c cimagl"
	strings:
		$1 = { FD 7B BD A9 FD 03 00 91 E0 87 01 6D ?? ?? ?? ?? E1 13 40 FD E0 0B 00 FD E0 0F 40 FD ?? ?? ?? ?? F1 0B 40 FD 10 08 60 1E 20 42 51 1F FD 7B C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_337_1_0 {
	meta:
		name = "_lsearch_s"
		size = 216
		refs = "0034 _errno 0040 _invalid_parameter_noinfo 006c __guard_check_icall_fptr 00a8 memcpy"
	strings:
		$1 = { F3 53 BC A9 F5 5B 01 A9 F7 63 02 A9 F9 6B 03 A9 FD 7B BF A9 FD 03 00 91 17 00 00 91 33 00 00 91 56 00 00 91 75 00 00 91 98 00 00 91 B9 00 00 91 F7 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 80 D2 1E 00 00 14 56 FF FF B4 33 FF FF B4 15 FF FF B4 F8 FE FF B4 C8 02 40 B9 14 4D 15 9B 7F 02 14 EB A0 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 0F 03 00 91 20 01 3F D6 62 02 00 91 E1 02 00 91 20 03 00 91 00 03 3F D6 80 01 00 34 73 02 15 8B 7F 02 14 EB C1 FE FF 54 A2 02 00 91 E1 02 00 91 80 02 00 91 ?? ?? ?? ?? C8 02 40 B9 93 02 00 91 09 05 00 11 C9 02 00 B9 60 02 00 91 FD 7B C1 A8 F9 6B 43 A9 F7 63 42 A9 F5 5B 41 A9 F3 53 C4 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_341_0_0 {
	meta:
		name = "_hypot"
		size = 472
		refs = "013c ??_C@_06MEIMCGCF@_hypot?$AA@ 015c _handle_error 01ac _controlfp_s"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 08 00 66 9E E0 0F 00 FD E1 0F 00 FD 0C F9 40 92 28 00 66 9E 8D FD 74 D3 BF FD 1F F1 0B F9 40 92 6A FD 74 D3 60 0A 00 54 5F FD 1F F1 A0 0A 00 54 EC 2F 01 A9 AF 01 0A 4B 0E 00 80 52 6C 00 00 B5 60 01 67 9E 5C 00 00 14 6B 00 00 B5 E0 0B 40 FD 59 00 00 14 E8 D9 00 11 1F B1 01 71 48 08 00 54 BF CD 17 F1 E8 03 00 54 5F CD 17 F1 A8 03 00 54 BF 2D 08 F1 63 00 00 54 5F 2D 08 F1 02 04 00 54 EE 4A 80 12 F2 09 00 5C ED 00 00 B5 08 B2 E4 D2 88 01 08 8B 10 01 67 9E E8 0B 00 F9 00 3A 72 1E 05 00 00 14 08 B0 E4 D2 88 01 08 8B E8 0B 00 F9 00 01 67 9E EA 00 00 B5 08 B2 E4 D2 68 01 08 8B 11 01 67 9E E8 0F 00 F9 21 3A 72 1E 0E 00 00 14 08 B0 E4 D2 68 01 08 8B E8 0F 00 F9 09 00 00 14 08 50 FB D2 88 01 08 8B 09 50 FB D2 E8 0B 00 F9 68 01 09 8B E8 0F 00 F9 0E 4B 80 52 E0 0B 40 FD E1 0F 40 FD 10 08 60 1E C8 7D 40 93 09 FE E7 D2 28 D1 08 8B 11 01 67 9E E8 0F 00 F9 30 40 41 1F 12 C2 61 1E 53 0A 71 1E 11 05 00 5C 60 22 71 1E 6D 01 00 54 ?? ?? ?? ?? ?? ?? ?? ?? 46 00 80 52 45 04 80 52 24 02 80 52 63 00 80 52 02 FE EF D2 01 03 80 52 ?? ?? ?? ?? 17 00 00 14 60 42 60 1E 15 00 00 14 F1 43 41 6D 20 2A 70 1E 12 00 00 14 88 CD 40 92 08 01 00 B4 5F FD 1F F1 61 00 00 54 68 CD 40 92 88 00 00 B4 10 08 60 1E 20 40 41 1F 09 00 00 14 02 00 80 52 FF 13 00 B9 01 00 80 52 E0 43 00 91 ?? ?? ?? ?? 08 FE EF D2 E8 0F 00 F9 00 01 67 9E FD 7B C2 A8 C0 03 5F D6 1F 20 03 D5 00 00 00 00 00 00 90 25 FF FF FF FF FF FF EF 7F }
	condition:
		$1
}

rule file_342_1_0 {
	meta:
		name = "??$get_cached_win_policy@Ubegin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@@@YA?AW4begin_thread_init_policy@@W4AppPolicyThreadInitializationType@@@Z"
		size = 88
		refs = "000c ?state_cache@?1???$get_cached_win_policy@Ubegin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@@@YA?AW4begin_thread_init_policy@@W4AppPolicyThreadInitializationType@@@Z@4JA 0028 __acrt_AppPolicyGetThreadInitializationTypeInternal"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? 08 00 00 11 ?? ?? ?? ?? BF 3B 03 D5 80 01 00 35 E0 43 00 91 E8 13 00 B9 ?? ?? ?? ?? E8 13 40 B9 4A 00 80 52 29 00 80 52 1F 05 00 71 40 01 89 1A ?? ?? ?? ?? 00 FD 9F 88 BF 3B 03 D5 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_342_2_0 {
	meta:
		name = "??$get_cached_win_policy@Udeveloper_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@@@YA?AW4developer_information_policy@@W4AppPolicyShowDeveloperDiagnostic@@@Z"
		size = 88
		refs = "000c ?state_cache@?1???$get_cached_win_policy@Udeveloper_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@@@YA?AW4developer_information_policy@@W4AppPolicyShowDeveloperDiagnostic@@@Z@4JA 0028 __acrt_AppPolicyGetShowDeveloperDiagnosticInternal"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? 08 00 00 11 ?? ?? ?? ?? BF 3B 03 D5 80 01 00 35 E0 43 00 91 E8 13 00 B9 ?? ?? ?? ?? E8 13 40 B9 4A 00 80 52 29 00 80 52 1F 05 00 71 40 01 89 1A ?? ?? ?? ?? 00 FD 9F 88 BF 3B 03 D5 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_342_3_0 {
	meta:
		name = "??$get_cached_win_policy@Uwindowing_model_policy_properties@?1??__acrt_get_windowing_model_policy@@YA?AW4windowing_model_policy@@XZ@@@YA?AW4windowing_model_policy@@W4AppPolicyWindowingModel@@@Z"
		size = 120
		refs = "000c ?state_cache@?1???$get_cached_win_policy@Uwindowing_model_policy_properties@?1??__acrt_get_windowing_model_policy@@YA?AW4windowing_model_policy@@XZ@@@YA?AW4windowing_model_policy@@W4AppPolicyWindowingModel@@@Z@4JA 0028 __acrt_AppPolicyGetWindowingModelInternal"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? 08 00 00 11 ?? ?? ?? ?? BF 3B 03 D5 80 02 00 35 E0 43 00 91 E8 13 00 B9 ?? ?? ?? ?? E8 13 40 B9 1F 05 00 71 40 01 00 54 1F 09 00 71 C0 00 00 54 1F 0D 00 71 8A 00 80 52 69 00 80 52 40 11 89 1A 04 00 00 14 20 00 80 52 02 00 00 14 40 00 80 52 ?? ?? ?? ?? 00 FD 9F 88 BF 3B 03 D5 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_342_4_0 {
	meta:
		name = "??$get_win_policy@Uprocess_end_policy_properties@?1??__acrt_get_process_end_policy@@YA?AW4process_end_policy@@XZ@@@YA?AW4process_end_policy@@W4AppPolicyProcessTerminationMethod@@@Z"
		size = 40
		refs = "0010 __acrt_AppPolicyGetProcessTerminationMethodInternal"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 13 00 B9 E0 43 00 91 ?? ?? ?? ?? E8 13 40 B9 1F 05 00 71 E0 07 9F 1A FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_342_10_0 {
	meta:
		name = "?appmodel_policy_to_policy_type@begin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@SA?AW43@J@Z"
		size = 20
		altNames = "?appmodel_policy_to_policy_type@developer_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@SA?AW43@J@Z"
	strings:
		$1 = { 1F 04 00 71 49 00 80 52 28 00 80 52 20 01 88 1A C0 03 5F D6 }
	condition:
		$1
}

rule file_342_13_0 {
	meta:
		name = "?appmodel_policy_to_policy_type@windowing_model_policy_properties@?1??__acrt_get_windowing_model_policy@@YA?AW4windowing_model_policy@@XZ@SA?AW43@J@Z"
		size = 52
	strings:
		$1 = { 1F 04 00 71 40 01 00 54 1F 08 00 71 C0 00 00 54 1F 0C 00 71 89 00 80 52 68 00 80 52 20 11 88 1A 04 00 00 14 20 00 80 52 02 00 00 14 40 00 80 52 C0 03 5F D6 }
	condition:
		$1
}

rule file_342_14_0 {
	meta:
		name = "__acrt_get_begin_thread_init_policy"
		size = 84
		refs = "000c ?state_cache@?1???$get_cached_win_policy@Ubegin_thread_init_policy_properties@?1??__acrt_get_begin_thread_init_policy@@YA?AW4begin_thread_init_policy@@XZ@@@YA?AW4begin_thread_init_policy@@W4AppPolicyThreadInitializationType@@@Z@4JA 0024 __acrt_AppPolicyGetThreadInitializationTypeInternal"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? BF 3B 03 D5 80 01 00 35 E0 43 00 91 FF 13 00 B9 ?? ?? ?? ?? E8 13 40 B9 4A 00 80 52 29 00 80 52 1F 05 00 71 40 01 89 1A ?? ?? ?? ?? 00 FD 9F 88 BF 3B 03 D5 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_342_15_0 {
	meta:
		name = "__acrt_get_developer_information_policy"
		size = 84
		refs = "000c ?state_cache@?1???$get_cached_win_policy@Udeveloper_information_policy_properties@?1??__acrt_get_developer_information_policy@@YA?AW4developer_information_policy@@XZ@@@YA?AW4developer_information_policy@@W4AppPolicyShowDeveloperDiagnostic@@@Z@4JA 0024 __acrt_AppPolicyGetShowDeveloperDiagnosticInternal"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? BF 3B 03 D5 80 01 00 35 E0 43 00 91 FF 13 00 B9 ?? ?? ?? ?? E8 13 40 B9 4A 00 80 52 29 00 80 52 1F 05 00 71 40 01 89 1A ?? ?? ?? ?? 00 FD 9F 88 BF 3B 03 D5 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_342_16_0 {
	meta:
		name = "__acrt_get_process_end_policy"
		size = 40
		refs = "0010 __acrt_AppPolicyGetProcessTerminationMethodInternal"
	strings:
		$1 = { FD 7B BE A9 FD 03 00 91 E0 43 00 91 FF 13 00 B9 ?? ?? ?? ?? E8 13 40 B9 1F 05 00 71 E0 07 9F 1A FD 7B C2 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_342_17_0 {
	meta:
		name = "__acrt_get_windowing_model_policy"
		size = 120
		refs = "000c ?state_cache@?1???$get_cached_win_policy@Uwindowing_model_policy_properties@?1??__acrt_get_windowing_model_policy@@YA?AW4windowing_model_policy@@XZ@@@YA?AW4windowing_model_policy@@W4AppPolicyWindowingModel@@@Z@4JA 0028 __acrt_AppPolicyGetWindowingModelInternal"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BE A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? BF 3B 03 D5 A0 02 00 35 48 00 80 52 E0 43 00 91 E8 13 00 B9 ?? ?? ?? ?? E8 13 40 B9 1F 05 00 71 40 01 00 54 1F 09 00 71 C0 00 00 54 1F 0D 00 71 8A 00 80 52 69 00 80 52 40 11 89 1A 04 00 00 14 20 00 80 52 02 00 00 14 40 00 80 52 ?? ?? ?? ?? 00 FD 9F 88 BF 3B 03 D5 FD 7B C2 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_343_2_0 {
	meta:
		name = "??$common_strerror@D@@YAPEADQEBD@Z"
		size = 416
		refs = "0014 _errno 001c __acrt_getptd_noexit 004c _calloc_base 0058 _free_base 0098 strncat_s 00ac strcat_s 00b4 __sys_nerr 00c4 __sys_errlist 0154 _invoke_watson"
		altNames = "_strerror"
	strings:
		$1 = { F3 53 BE A9 F5 0B 00 F9 FD 7B BE A9 FD 03 00 91 13 00 00 91 ?? ?? ?? ?? 15 00 80 B9 ?? ?? ?? ?? 14 00 00 91 D4 00 00 B5 00 00 80 D2 FD 7B C2 A8 F5 0B 40 F9 F3 53 C2 A8 C0 03 5F D6 88 3E 40 F9 28 01 00 B5 21 00 80 D2 C0 10 80 D2 ?? ?? ?? ?? 80 3E 00 F9 00 00 80 D2 ?? ?? ?? ?? 88 3E 40 F9 48 FE FF B4 1F 01 00 39 73 02 00 B4 68 02 C0 39 28 02 00 34 80 3E 40 F9 48 07 80 52 FF 5B 00 39 09 04 80 52 E8 53 00 39 43 10 80 D2 E9 57 00 39 62 02 00 91 C1 10 80 D2 ?? ?? ?? ?? E0 05 00 35 80 3E 40 F9 E2 53 00 91 C1 10 80 D2 ?? ?? ?? ?? 80 04 00 35 ?? ?? ?? ?? 08 00 40 B9 BF C2 28 EB E3 00 00 54 ?? ?? ?? ?? 13 00 00 91 ?? ?? ?? ?? 08 00 40 B9 62 DA 68 F8 03 00 00 14 ?? ?? ?? ?? 02 78 75 F8 80 3E 40 F9 08 00 C0 39 0A 00 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 00 CB 89 10 80 D2 23 01 08 CB C1 10 80 D2 ?? ?? ?? ?? A0 03 00 35 48 01 80 52 FF 47 00 39 E8 43 00 39 80 3E 40 F9 E2 43 00 91 C1 10 80 D2 ?? ?? ?? ?? E0 01 00 35 80 3E 40 F9 BC FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_3_0 {
	meta:
		name = "??$common_strerror@_W@@YAPEA_WQEB_W@Z"
		size = 448
		refs = "0010 __security_push_cookie 001c _errno 0024 __acrt_getptd_noexit 0038 __security_pop_cookie 005c _calloc_base 0068 _free_base 00a8 wcsncat_s 00bc wcscat_s 00c4 __sys_nerr 00d4 __sys_errlist 0130 mbstowcs_s 0174 _invoke_watson"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 13 00 F9 FD 03 00 91 ?? ?? ?? ?? FF 43 00 D1 13 00 00 91 ?? ?? ?? ?? 15 00 80 B9 ?? ?? ?? ?? 14 00 00 91 14 01 00 B5 00 00 80 D2 FF 43 00 91 ?? ?? ?? ?? F5 13 40 F9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 88 42 40 F9 28 01 00 B5 41 00 80 D2 C0 10 80 D2 ?? ?? ?? ?? 80 42 00 F9 00 00 80 D2 ?? ?? ?? ?? 88 42 40 F9 08 FE FF B4 1F 01 00 79 73 02 00 B4 68 02 40 79 28 02 00 34 80 42 40 F9 48 07 80 52 FF 1B 00 79 09 04 80 52 E8 13 00 79 43 10 80 D2 E9 17 00 79 62 02 00 91 C1 10 80 D2 ?? ?? ?? ?? 60 06 00 35 80 42 40 F9 E2 23 00 91 C1 10 80 D2 ?? ?? ?? ?? 00 05 00 35 ?? ?? ?? ?? 08 00 40 B9 BF C2 28 EB E3 00 00 54 ?? ?? ?? ?? 13 00 00 91 ?? ?? ?? ?? 08 00 40 B9 63 DA 68 F8 03 00 00 14 ?? ?? ?? ?? 03 78 75 F8 8B 42 40 F9 68 01 C0 79 6A 01 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 0B CB 09 FD 41 93 C8 10 80 D2 61 05 09 8B 8C 10 80 D2 02 01 09 CB 84 01 09 CB 00 00 80 D2 ?? ?? ?? ?? A0 03 00 35 48 01 80 52 FF 07 00 79 E8 03 00 79 80 42 40 F9 E2 03 00 91 C1 10 80 D2 ?? ?? ?? ?? E0 01 00 35 80 42 40 F9 B6 FF FF 17 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_4_0 {
	meta:
		name = "??$common_strerror_s@D@@YAHQEAD_KQEBD@Z"
		size = 300
		refs = "001c _errno 0034 _invalid_parameter_noinfo 0090 strcpy_s 00a4 strcat_s 00e8 strerror_s 0110 _invoke_watson"
		altNames = "_strerror_s"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BE A9 FD 03 00 91 13 00 00 91 35 00 00 91 54 00 00 91 ?? ?? ?? ?? 16 00 40 B9 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 2C 00 00 14 55 FF FF B4 7F 02 00 39 54 03 00 B4 88 02 C0 39 08 03 00 34 8A 02 00 91 49 1D C0 38 E9 FF FF 35 49 01 14 CB A8 1E 00 D1 3F 01 08 EB 22 02 00 54 48 07 80 52 FF 4B 00 39 09 04 80 52 E8 43 00 39 82 02 00 91 E9 47 00 39 A1 02 00 91 60 02 00 91 ?? ?? ?? ?? 00 04 00 35 E2 43 00 91 A1 02 00 91 60 02 00 91 ?? ?? ?? ?? 40 00 00 34 14 00 00 14 6A 02 C0 39 69 02 00 91 8A 00 00 34 29 05 00 91 28 01 C0 39 C8 FF FF 35 28 01 13 CB A1 02 08 CB 8A 00 00 34 73 06 00 91 69 02 C0 39 C9 FF FF 35 C2 02 00 11 60 02 00 91 ?? ?? ?? ?? FD 7B C2 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_5_0 {
	meta:
		name = "??$common_strerror_s@_W@@YAHQEA_W_KQEB_W@Z"
		size = 320
		refs = "0010 __security_push_cookie 0020 _errno 0038 _invalid_parameter_noinfo 0094 wcscpy_s 00a8 wcscat_s 00f8 _wcserror_s 00fc __security_pop_cookie 0124 _invoke_watson"
		altNames = "__wcserror_s"
	strings:
		$1 = { FD 7B BD A9 F3 53 01 A9 F5 5B 02 A9 FD 03 00 91 ?? ?? ?? ?? 13 00 00 91 35 00 00 91 54 00 00 91 ?? ?? ?? ?? 16 00 40 B9 F3 00 00 B5 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 2F 00 00 14 55 FF FF B4 7F 02 00 79 54 03 00 B4 88 02 40 79 08 03 00 34 8A 02 00 91 49 2D C0 78 E9 FF FF 35 49 01 14 CB A8 1E 00 D1 1F 05 89 EB 29 02 00 54 48 07 80 52 FF 0B 00 79 09 04 80 52 E8 03 00 79 82 02 00 91 E9 07 00 79 A1 02 00 91 60 02 00 91 ?? ?? ?? ?? 80 04 00 35 E2 03 00 91 A1 02 00 91 60 02 00 91 ?? ?? ?? ?? 40 00 00 34 18 00 00 14 6B 02 C0 79 69 02 00 91 8B 00 00 34 29 09 00 91 28 01 C0 79 C8 FF FF 35 28 01 13 CB A1 06 88 CB 6A 02 00 91 8B 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 13 CB 09 FD 41 93 60 06 09 8B C2 02 00 11 ?? ?? ?? ?? ?? ?? ?? ?? F5 5B 42 A9 F3 53 41 A9 FD 7B C3 A8 C0 03 5F D6 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_26_0 {
	meta:
		name = "?append_message@@YAHQEAD_KQEBD@Z"
		size = 40
		refs = "0024 strncat_s"
	strings:
		$1 = { 08 00 C0 39 0A 00 00 91 88 00 00 34 4A 05 00 91 49 01 C0 39 C9 FF FF 35 48 01 00 CB 28 00 08 CB 03 09 00 D1 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_343_27_0 {
	meta:
		name = "?append_message@@YAHQEA_W_KQEBD@Z"
		size = 56
		refs = "0034 mbstowcs_s"
	strings:
		$1 = { 08 00 C0 79 43 00 00 91 0A 00 00 91 88 00 00 34 4A 09 00 91 49 01 C0 79 C9 FF FF 35 48 01 00 CB 09 FD 41 93 22 00 09 CB 01 04 09 8B 44 08 00 D1 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_345_4_0 {
	meta:
		name = "__ascii_memicmp"
		size = 104
	strings:
		$1 = { 09 00 80 52 08 00 80 52 C2 02 00 B4 0D 00 01 CB AA 69 61 38 42 04 00 D1 2C 14 40 38 5F 01 0C 6B E0 01 00 54 48 FD 02 11 09 1D 00 53 3F 65 00 71 49 81 00 11 49 00 00 54 49 01 00 11 8A FD 02 11 4B 1D 00 53 7F 65 00 71 88 81 00 11 49 00 00 54 88 01 00 11 3F 01 08 6B 41 00 00 54 A2 FD FF B5 20 01 08 4B C0 03 5F D6 }
	condition:
		$1
}

rule file_345_5_0 {
	meta:
		name = "_memicmp"
		size = 84
		refs = "0008 __acrt_locale_changed_data 001c _errno 0028 _invalid_parameter_noinfo 003c __ascii_memicmp 0048 _memicmp_l"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? ?? ?? ?? ?? A8 01 00 35 00 01 00 B5 E2 00 00 B4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 07 00 00 14 41 00 00 B5 22 FF FF B5 ?? ?? ?? ?? 03 00 00 14 03 00 80 D2 ?? ?? ?? ?? FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_345_6_0 {
	meta:
		name = "_memicmp_l"
		size = 224
		refs = "0030 ??0_LocaleUpdate@@QEAA@QEAU__crt_locale_pointers@@@Z 0044 _errno 0050 _invalid_parameter_noinfo 0074 __ascii_memicmp 0094 _tolower_l"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BD A9 FD 03 00 91 17 00 00 91 36 00 00 91 61 00 00 91 E0 43 00 91 53 00 00 91 14 00 80 52 15 00 80 52 ?? ?? ?? ?? 57 00 00 B5 73 00 00 B5 16 01 00 B5 F3 00 00 B4 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? 00 00 B0 12 17 00 00 14 E8 0F 40 F9 08 9D 40 F9 C8 00 00 B5 62 02 00 91 C1 02 00 91 E0 02 00 91 ?? ?? ?? ?? 0F 00 00 14 B3 01 00 B4 73 06 00 D1 9F 02 15 6B 41 01 00 54 E0 16 40 38 E1 63 00 91 ?? ?? ?? ?? E1 63 00 91 14 00 00 11 C0 16 40 38 ?? ?? ?? ?? 15 00 00 11 B3 FE FF B5 80 02 15 4B E8 A3 40 39 A8 00 00 34 EA 0B 40 F9 48 A9 43 B9 09 79 1E 12 49 A9 03 B9 FD 7B C3 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_346_0_0 {
	meta:
		name = "?xcptlookup@@YAPEAU__crt_signal_action_t@@KQEAU1@@Z"
		size = 44
	strings:
		$1 = { 29 00 03 91 04 00 00 14 28 04 41 B8 1F 01 00 6B A0 00 00 54 3F 00 09 EB 81 FF FF 54 00 00 80 D2 C0 03 5F D6 20 40 00 D1 FE FF FF 17 }
	condition:
		$1
}

rule file_346_1_0 {
	meta:
		name = "_seh_filter_dll"
		size = 36
		refs = "0018 _seh_filter_exe"
	strings:
		$1 = { 08 01 00 18 1F 00 08 6B 60 00 00 54 00 00 80 52 03 00 00 14 00 01 00 11 ?? ?? ?? ?? C0 03 5F D6 63 73 6D E0 }
	condition:
		$1
}

rule file_346_2_0 {
	meta:
		name = "_seh_filter_exe"
		size = 508
		refs = "0018 __acrt_getptd_noexit 017c __guard_check_icall_fptr"
	strings:
		$1 = { F3 53 BE A9 F5 5B 01 A9 FD 7B BF A9 FD 03 00 91 14 00 00 11 35 00 00 91 ?? ?? ?? ?? 13 00 00 91 73 00 00 B5 00 00 80 52 67 00 00 14 6A 02 40 F9 4B 01 03 91 5F 01 0B EB 49 01 00 91 C0 00 00 54 28 05 41 B8 1F 01 14 6B 80 01 00 54 3F 01 0B EB 81 FF FF 54 09 00 80 D2 69 FE FF B4 34 05 40 F9 34 FE FF B4 9F 16 00 F1 C1 00 00 54 3F 05 00 F9 20 00 80 52 54 00 00 14 29 41 00 D1 F7 FF FF 17 9F 06 00 F1 E0 09 00 54 76 06 40 F9 75 06 00 F9 35 05 40 B9 BF 22 00 71 41 08 00 54 48 C1 00 91 0B 41 02 91 03 00 00 14 1F 05 00 F9 08 41 00 91 1F 01 0B EB A1 FF FF 54 28 01 40 B9 EA 08 00 18 75 12 40 B9 1F 01 0A 6B 28 03 00 54 1F 01 0A 6B A0 02 00 54 49 08 00 18 1F 01 09 6B 00 02 00 54 09 08 00 18 1F 01 09 6B 60 01 00 54 C9 07 00 18 1F 01 09 6B C0 00 00 54 89 07 00 18 1F 01 09 6B E1 03 00 54 28 10 80 52 1C 00 00 14 C8 10 80 52 1A 00 00 14 68 10 80 52 18 00 00 14 48 10 80 52 16 00 00 14 88 10 80 52 14 00 00 14 09 06 00 18 1F 01 09 6B 00 02 00 54 C9 05 00 18 1F 01 09 6B 60 01 00 54 89 05 00 18 1F 01 09 6B C0 00 00 54 49 05 00 18 1F 01 09 6B 21 01 00 54 A8 11 80 52 06 00 00 14 C8 11 80 52 04 00 00 14 A8 10 80 52 02 00 00 14 48 11 80 52 68 12 00 B9 ?? ?? ?? ?? ?? ?? ?? ?? 8F 02 00 91 00 01 3F D6 61 12 40 B9 00 01 80 52 80 02 3F D6 75 12 00 B9 08 00 00 14 ?? ?? ?? ?? 3F 05 00 F9 ?? ?? ?? ?? 8F 02 00 91 00 01 3F D6 A0 02 00 11 80 02 3F D6 76 06 00 F9 00 00 80 12 FD 7B C1 A8 F5 5B 41 A9 F3 53 C2 A8 C0 03 5F D6 1F 20 03 D5 91 00 00 C0 8D 00 00 C0 8E 00 00 C0 8F 00 00 C0 90 00 00 C0 92 00 00 C0 93 00 00 C0 B4 02 00 C0 B5 02 00 C0 }
	condition:
		$1
}

rule file_347_0_0 {
	meta:
		name = "??$cleanup_after_error@D@@YAHQEAD_K@Z"
		size = 40
		refs = "000c _errno 0018 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 1F 00 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_347_1_0 {
	meta:
		name = "??$cleanup_after_error@_W@@YAHQEA_W_K@Z"
		size = 40
		refs = "000c _errno 0018 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 1F 00 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_347_2_0 {
	meta:
		name = "??$common_makepath_s@D@@YAHQEAD_KQEBD222@Z"
		size = 416
		refs = "002c _errno 00a8 _mbsdec 0178 _invalid_parameter_noinfo"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 15 00 00 91 BF 02 00 F1 24 18 40 FA 97 00 00 91 B6 00 00 91 A8 00 00 54 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 50 00 00 14 A8 02 01 8B 3F 04 00 B1 14 11 9F 9A B3 02 00 91 62 01 00 B4 49 00 C0 39 29 01 00 34 94 00 00 B4 88 02 15 CB 1F 09 00 F1 0B 08 00 54 48 07 80 52 A9 02 00 39 A8 06 00 39 B3 0A 00 91 03 03 00 B4 68 00 C0 39 C8 02 00 34 61 00 00 91 9F 02 00 F1 60 12 54 FA A2 06 00 54 29 00 C0 39 69 16 00 38 2A 1C C0 38 4A FF FF 35 60 00 00 91 ?? ?? ?? ?? 08 00 C0 39 1F BD 00 71 20 01 00 54 1F 71 01 71 E0 00 00 54 9F 02 00 F1 60 12 54 FA E2 04 00 54 88 0B 80 52 68 02 00 39 73 06 00 91 77 01 00 B4 E8 02 C0 39 28 01 00 34 EB 02 13 CB 9F 02 00 F1 60 12 54 FA A2 03 00 54 69 69 F3 38 69 16 00 38 6A 69 F3 38 4A FF FF 35 B6 02 00 B4 C8 02 C0 39 28 01 00 34 1F B9 00 71 E0 00 00 54 9F 02 00 F1 60 12 54 FA 22 02 00 54 C8 05 80 52 68 02 00 39 73 06 00 91 C8 02 C0 39 28 01 00 34 CB 02 13 CB 9F 02 00 F1 60 12 54 FA 02 01 00 54 69 69 F3 38 69 16 00 38 6A 69 F3 38 4A FF FF 35 9F 02 00 F1 60 12 54 FA 23 01 00 54 BF 02 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 13 01 00 11 ?? ?? ?? ?? 60 02 00 11 03 00 00 14 7F 02 00 39 00 00 80 52 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_347_3_0 {
	meta:
		name = "??$common_makepath_s@_W@@YAHQEA_W_KQEB_W222@Z"
		size = 380
		refs = "0018 _errno 015c _invalid_parameter_noinfo"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 1F 00 00 F1 24 18 40 FA A8 00 00 54 ?? ?? ?? ?? D3 02 80 52 13 00 00 B9 4E 00 00 14 08 04 01 8B 3F 04 00 B1 0B 00 00 91 0C 11 9F 9A 82 01 00 B4 4A 00 40 79 4A 01 00 34 AC 00 00 B4 88 01 00 CB 09 F9 7F 92 3F 11 00 F1 AB 07 00 54 48 07 80 52 0A 00 00 79 08 04 00 79 0B 10 00 91 A3 02 00 B4 68 00 40 79 68 02 00 34 9F 01 00 F1 60 11 4C FA 62 06 00 54 69 00 40 79 69 25 00 78 6A 2C 40 78 4A FF FF 35 69 E0 5F 78 3F BD 00 71 20 01 00 54 3F 71 01 71 E0 00 00 54 9F 01 00 F1 60 11 4C FA E2 04 00 54 88 0B 80 52 68 01 00 79 6B 09 00 91 64 01 00 B4 88 00 40 79 28 01 00 34 8D 00 0B CB 9F 01 00 F1 60 11 4C FA A2 03 00 54 A9 69 6B 78 69 25 00 78 AA 69 6B 78 4A FF FF 35 A5 02 00 B4 A8 00 40 79 28 01 00 34 1F B9 00 71 E0 00 00 54 9F 01 00 F1 60 11 4C FA 22 02 00 54 C8 05 80 52 68 01 00 79 6B 09 00 91 A8 00 40 79 28 01 00 34 AD 00 0B CB 9F 01 00 F1 60 11 4C FA 02 01 00 54 A9 69 6B 78 69 25 00 78 AA 69 6B 78 4A FF FF 35 9F 01 00 F1 60 11 4C FA 23 01 00 54 1F 00 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 13 01 00 11 ?? ?? ?? ?? 60 02 00 11 03 00 00 14 7F 01 00 79 00 00 80 52 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_347_6_0 {
	meta:
		name = "_makepath"
		size = 24
		refs = "0014 _makepath_s"
	strings:
		$1 = { 85 00 00 91 64 00 00 91 43 00 00 91 22 00 00 91 01 00 80 92 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_8_0 {
	meta:
		name = "_wmakepath"
		size = 24
		refs = "0014 _wmakepath_s"
	strings:
		$1 = { 85 00 00 91 64 00 00 91 43 00 00 91 22 00 00 91 01 00 80 92 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_347_7_0 {
	meta:
		name = "_makepath_s"
		size = 420
		refs = "002c _errno 0038 _invalid_parameter_noinfo 00cc _mbsdec"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 13 00 F9 FD 7B BF A9 FD 03 00 91 15 00 00 91 BF 02 00 F1 24 18 40 FA 97 00 00 91 B6 00 00 91 E8 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 54 00 00 14 A8 02 01 8B 3F 04 00 B1 14 11 9F 9A B3 02 00 91 42 02 00 B4 49 00 C0 39 09 02 00 34 74 01 00 B4 88 02 15 CB 1F 09 00 F1 0A 01 00 54 BF 02 00 39 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 42 00 00 14 48 07 80 52 A9 02 00 39 A8 06 00 39 B3 0A 00 91 03 03 00 B4 68 00 C0 39 C8 02 00 34 61 00 00 91 9F 02 00 F1 60 12 54 FA E2 FD FF 54 29 00 C0 39 69 16 00 38 2A 1C C0 38 4A FF FF 35 60 00 00 91 ?? ?? ?? ?? 08 00 C0 39 1F BD 00 71 20 01 00 54 1F 71 01 71 E0 00 00 54 9F 02 00 F1 60 12 54 FA 22 FC FF 54 88 0B 80 52 68 02 00 39 73 06 00 91 77 01 00 B4 E8 02 C0 39 28 01 00 34 EB 02 13 CB 9F 02 00 F1 60 12 54 FA E2 FA FF 54 69 69 F3 38 69 16 00 38 6A 69 F3 38 4A FF FF 35 B6 02 00 B4 C8 02 C0 39 28 01 00 34 1F B9 00 71 E0 00 00 54 9F 02 00 F1 60 12 54 FA 62 F9 FF 54 C8 05 80 52 68 02 00 39 73 06 00 91 C8 02 C0 39 28 01 00 34 CB 02 13 CB 9F 02 00 F1 60 12 54 FA 42 F8 FF 54 69 69 F3 38 69 16 00 38 6A 69 F3 38 4A FF FF 35 9F 02 00 F1 60 12 54 FA 62 F7 FF 54 7F 02 00 39 00 00 80 52 FD 7B C1 A8 F7 13 40 F9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_347_9_0 {
	meta:
		name = "_wmakepath_s"
		size = 376
		refs = "0014 _errno 0020 _invalid_parameter_noinfo"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 1F 00 00 F1 24 18 40 FA E8 00 00 54 ?? ?? ?? ?? C8 02 80 52 08 00 00 B9 ?? ?? ?? ?? C0 02 80 52 52 00 00 14 08 04 01 8B 3F 04 00 B1 0B 00 00 91 0C 11 9F 9A 62 02 00 B4 4A 00 40 79 2A 02 00 34 8C 01 00 B4 88 01 00 CB 09 F9 7F 92 3F 11 00 F1 0A 01 00 54 1F 00 00 79 ?? ?? ?? ?? 48 04 80 52 08 00 00 B9 ?? ?? ?? ?? 40 04 80 52 3F 00 00 14 48 07 80 52 0A 00 00 79 08 04 00 79 0B 10 00 91 A3 02 00 B4 68 00 40 79 68 02 00 34 9F 01 00 F1 60 11 4C FA 02 FE FF 54 69 00 40 79 69 25 00 78 6A 2C 40 78 4A FF FF 35 69 E0 5F 78 3F BD 00 71 20 01 00 54 3F 71 01 71 E0 00 00 54 9F 01 00 F1 60 11 4C FA 82 FC FF 54 88 0B 80 52 68 01 00 79 6B 09 00 91 64 01 00 B4 88 00 40 79 28 01 00 34 8D 00 0B CB 9F 01 00 F1 60 11 4C FA 42 FB FF 54 A9 69 6B 78 69 25 00 78 AA 69 6B 78 4A FF FF 35 A5 02 00 B4 A8 00 40 79 28 01 00 34 1F B9 00 71 E0 00 00 54 9F 01 00 F1 60 11 4C FA C2 F9 FF 54 C8 05 80 52 68 01 00 79 6B 09 00 91 A8 00 40 79 28 01 00 34 AD 00 0B CB 9F 01 00 F1 60 11 4C FA A2 F8 FF 54 A9 69 6B 78 69 25 00 78 AA 69 6B 78 4A FF FF 35 9F 01 00 F1 60 11 4C FA C2 F7 FF 54 7F 01 00 79 00 00 80 52 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_348_9_0 {
	meta:
		name = "_get_thread_local_invalid_parameter_handler"
		size = 36
		refs = "0008 __acrt_getptd_noexit"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 ?? ?? ?? ?? 60 00 00 B5 00 00 80 D2 02 00 00 14 00 DC 41 F9 FD 7B C1 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_348_10_0 {
	meta:
		name = "_invalid_parameter"
		size = 172
		refs = "0028 __acrt_getptd_noexit 0038 __guard_check_icall_fptr 0074 __security_cookie 0078 ?__acrt_invalid_parameter_handler@@3V?$dual_state_global@P6AXPEB_W00I_K@Z@__crt_state_management@@A 00a8 _invoke_watson"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BF A9 FD 03 00 91 14 00 00 91 35 00 00 91 56 00 00 91 77 00 00 11 98 00 00 91 ?? ?? ?? ?? 40 02 00 B4 13 DC 41 F9 13 02 00 B4 ?? ?? ?? ?? ?? ?? ?? ?? 6F 02 00 91 00 01 3F D6 04 03 00 91 E3 02 00 11 C2 02 00 91 A1 02 00 91 80 02 00 91 60 02 3F D6 FD 7B C1 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? ?? 2A 15 00 12 29 01 08 CA 33 2D CA 9A 53 FD FF B5 04 03 00 91 E3 02 00 11 C2 02 00 91 A1 02 00 91 80 02 00 91 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_11_0 {
	meta:
		name = "_invalid_parameter_noinfo"
		size = 24
		refs = "0014 _invalid_parameter"
	strings:
		$1 = { 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_12_0 {
	meta:
		name = "_invalid_parameter_noinfo_noreturn"
		size = 56
		refs = "001c _invalid_parameter 0034 _invoke_watson"
	strings:
		$1 = { FD 7B BF A9 FD 03 00 91 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? 04 00 80 D2 03 00 80 52 02 00 80 D2 01 00 80 D2 00 00 80 D2 ?? ?? ?? ?? }
	condition:
		$1
}

rule file_348_15_0 {
	meta:
		name = "_set_thread_local_invalid_parameter_handler"
		size = 44
		refs = "0010 __acrt_getptd"
	strings:
		$1 = { F3 0F 1F F8 FD 7B BF A9 FD 03 00 91 13 00 00 91 ?? ?? ?? ?? 08 00 00 91 00 DD 41 F9 13 DD 01 F9 FD 7B C1 A8 F3 07 41 F8 C0 03 5F D6 }
	condition:
		$1
}

rule file_349_0_0 {
	meta:
		name = "__acrt_CompareStringW"
		size = 196
		refs = "0040 wcsnlen 008c __acrt_CompareStringEx"
	strings:
		$1 = { F3 53 BD A9 F5 5B 01 A9 F7 63 02 A9 FD 7B BF A9 FD 03 00 91 FF 43 00 D1 74 00 00 11 9F 02 00 71 17 00 00 91 38 00 00 11 55 00 00 91 96 00 00 91 B3 00 00 11 AD 00 00 54 81 7E 40 93 A0 02 00 91 ?? ?? ?? ?? 14 00 00 11 7F 02 00 71 AD 00 00 54 61 7E 40 93 C0 02 00 91 ?? ?? ?? ?? 13 00 00 11 B4 01 00 34 93 01 00 34 07 00 80 D2 FF 03 00 F9 06 00 80 D2 65 02 00 11 C4 02 00 91 83 02 00 11 A2 02 00 91 01 03 00 11 E0 02 00 91 ?? ?? ?? ?? 07 00 00 14 8B 02 13 6B 68 7D 1F 13 09 79 1F 12 2A 0D 00 11 48 00 80 52 00 01 8A 1A FF 43 00 91 FD 7B C1 A8 F7 63 42 A9 F5 5B 41 A9 F3 53 C3 A8 C0 03 5F D6 }
	condition:
		$1
}

rule file_350_0_0 {
	meta:
		name = "_d_int"
		size = 300
		refs = "00ac ?mask@?3??_d_int@@9@9 00c0 ?sub@?3??_d_int