/* safestr.h.  Generated from safestr.h.in by configure.  */
/*
** (c) Copyright 2003-2005 Matt Messier and John Viega
** All rights reserved.
** 
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions are
** met:
** 
** Redistributions of source code must retain the above copyright notice,
** this list of conditions and the following disclaimer.
** 
** Redistributions in binary form must reproduce the above copyright
** notice, this list of conditions and the following disclaimer in the
** documentation and/or other materials provided with the distribution.
** 
** Neither the name of the primary nor the names of the contributors may
** be used to endorse or promote products derived from this software
** without specific prior written permission.
** 
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
** "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
** LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR
** A PARTICULAR PURPOSE ARE DISCLAIMED.  IN NO EVENT SHALL THE COPYRIGHT
** OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
** SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
** LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
** DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
** THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE
** OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#ifndef SAFESTR_H
#define SAFESTR_H

#ifndef WIN32
/* BEGIN:   autoconf substitutions */
#define STDC_HEADERS 1
#define HAVE_SYS_TYPES_H 1
/* #undef size_t */
/* #undef const */
/* #undef volatile */
/* END:     autoconf substitutions */

#ifdef HAVE_SYS_TYPES_H
#include <sys/types.h>
#endif
#ifdef STDC_HEADERS
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <errno.h>
#endif
#else
#include <stdio.h>
#include <stdarg.h>
#include <stddef.h>
#include <errno.h>
#endif

#ifndef WIN32
#define SAFESTR_API
#else
#ifdef SAFESTR_EXPORTS
#define SAFESTR_API __declspec(dllexport)
#else
#define SAFESTR_API __declspec(dllimport)
#endif
#endif

#ifndef WIN32
#include "safestr-c99.h"
#else
typedef signed char         int8_t;
typedef unsigned char       u_int8_t;
typedef signed short        int16_t;
typedef unsigned short      u_int16_t;
typedef signed long         int32_t, ssize_t;
typedef unsigned long       u_int32_t, uptrdiff_t;
typedef signed __int64      int64_t, intmax_t;
typedef unsigned __int64    u_int64_t, uintmax_t;
#endif

#define SAFESTR_ERROR_NONE                  0
#define SAFESTR_ERROR_OUT_OF_MEMORY         ENOMEM
#define SAFESTR_ERROR_INVALID_PARAMETER     EINVAL
#define SAFESTR_ERROR_BAD_ADDRESS           EFAULT
#define SAFESTR_ERROR_INVALID_FORMAT_STRING E2BIG
#define SAFESTR_ERROR_IMMUTABLE_STRING      0x80000001
#define SAFESTR_ERROR_INDEX_OUT_OF_RANGE    0x80000002
#define SAFESTR_ERROR_PRNG_FAILURE          0x80000003
#define SAFESTR_ERROR_TOO_MANY_FORMAT_ARGS  0x80000004
#define SAFESTR_ERROR_ILLEGAL_PERCENT_N     0x80000005
#define SAFESTR_ERROR_INVALID_FORMAT_ARG    0x80000006
#define SAFESTR_ERROR_STRING_TOO_LONG       0x80000007
#define SAFESTR_ERROR_INVALID_FORMAT        0x80000008
#define SAFESTR_ERROR_TOO_MANY_REFERENCES   0x80000009
#define SAFESTR_ERROR_NOTFOUND              0xFFFFFFFF

#define SAFESTR_COMPARE_NOCASE      0x1 /* do NOT consider case in compares */
#define SAFESTR_COMPARE_LIMIT       0x2 /* restrict comparison to length */

#define SAFESTR_TEMPORARY           0x1
#define SAFESTR_IMMUTABLE           0x2
#define SAFESTR_TRUSTED             0x4 
#define SAFESTR_ASSET_PERMANENT     0x00
#define SAFESTR_ASSET_TEMPORARY     0x10
#define SAFESTR_ASSET_PROMOTE       0x20
#define SAFESTR_ASSET_DEMOTE        0x30

#define SAFESTR_COPY_LIMIT          0x1

#define SAFESTR_FIND_REVERSE        0x01 /* start search from end of string */
#define SAFESTR_FIND_FROMCHAR       0x02 /* start search from specified position */
#define SAFESTR_FIND_FROMNTH        0x04 /* start search from nth occurrence */
#define SAFESTR_FIND_NTH            0x08 /* find the nth occurrence */
#define SAFESTR_FIND_NOMATCHCASE    0x10 /* search case insensitively */
#define SAFESTR_FIND_CHARACTER      0x20 /* search for a single character */

#define SAFESTR_TRIM_LEADING        0x01
#define SAFESTR_TRIM_TRAILING       0x02
#define SAFESTR_TRIM_BOTH           (SAFESTR_TRIM_LEADING | SAFESTR_TRIM_TRAILING)

#define SAFESTR_CONVERT_UPPERCASE   0x00000001
#define SAFESTR_CONVERT_LOWERCASE   0x00000002
#define SAFESTR_CONVERT_TITLECASE   0x00000004

/* Convenience Macros */
#define SAFESTR_ALLOC(x)            safestr_do_alloc((x), 0, __FILE__, __LINE__)
#define SAFESTR_CLONE(x)            safestr_do_clone((x), 0, __FILE__, __LINE__)
#define SAFESTR_CREATE(x)           safestr_do_create((x), 0, __FILE__, __LINE__)
#define SAFESTR_TEMP(x)             safestr_do_create((x), SAFESTR_TEMPORARY | \
                                                           SAFESTR_IMMUTABLE,  \
                                                           __FILE__, __LINE__)
#define SAFESTR_TEMP_TRUSTED(x)     safestr_do_create((x), SAFESTR_TEMPORARY | \
                                                           SAFESTR_IMMUTABLE | \
                                                           SAFESTR_TRUSTED,    \
                                                           __FILE__, __LINE__)
#define safestr_release(x)          safestr_free((x))

#define safestr_append(x, y)        safestr_concatenate((x), (y), 0)
#define safestr_nappend(x, y, z)    safestr_concatenate((x), (y), SAFESTR_COPY_LIMIT, (z))

#define safestr_find(x, y)          safestr_search((x), (y), 0)
#define safestr_findchar(x, y)      safestr_search((x), NULL, SAFESTR_FIND_CHARACTER, (y))
#define safestr_rfind(x, y)         safestr_search((x), (y), SAFESTR_FIND_REVERSE)
#define safestr_rfindchar(x, y)     safestr_search((x), NULL, SAFESTR_FIND_REVERSE | SAFESTR_FIND_CHARACTER, (y))

#define safestr_copy(x, y)          safestr_duplicate((x), (y), 0)
#define safestr_ncopy(x, y, z)      safestr_duplicate((x), (y), SAFESTR_COPY_LIMIT, (z))

#define safestr_ncompare(x, y, z)   safestr_compare((x), (y), SAFESTR_COMPARE_LIMIT, (z))

#define safestr_alloc(x, y)         safestr_do_alloc((x), (y), __FILE__, __LINE__)
#define safestr_clone(x, y)         safestr_do_clone((x), (y), __FILE__, __LINE__)
#define safestr_convertarray(x, y)  safestr_do_convertarray((x), (y), __FILE__, __LINE__)
#define safestr_create(x, y)        safestr_do_create((x), (y), __FILE__, __LINE__)
#define safestr_getpassword(x, y)   safestr_do_getpassword((x), (y), __FILE__, __LINE__)
#define safestr_join(x, y)          safestr_do_join((x), (y), __FILE__, __LINE__)
#define safestr_readline(x)         safestr_do_readline((x), __FILE__, __LINE__)
#define safestr_slice(x, y, z)      safestr_do_slice((x), (y), (z), __FILE__, __LINE__)
#define safestr_split(x, y)         safestr_do_split((x), (y), __FILE__, __LINE__)
#define safestr_strdup(x)           safestr_do_strdup((x), __FILE__, __LINE__)

#ifdef __cplusplus
extern "C" {
#endif

typedef struct safestr_struct_t
{
    char s;
} *safestr_t;

typedef void *  (*safestr_malloc_t) (size_t, const char *, unsigned int);
typedef void *  (*safestr_realloc_t)(void *, size_t, const char *, unsigned int);
typedef void    (*safestr_free_t)   (void *, const char *, unsigned int);

extern SAFESTR_API safestr_t        safestr_do_alloc        (u_int32_t, u_int32_t, const char *, unsigned int);
extern SAFESTR_API safestr_t        safestr_do_clone        (safestr_t, u_int32_t, const char *, unsigned int);
extern SAFESTR_API safestr_t *      safestr_do_convertarray (char **, u_int32_t, const char *, unsigned int);
extern SAFESTR_API safestr_t        safestr_do_create       (char *, u_int32_t, const char *, unsigned int);
extern SAFESTR_API safestr_t        safestr_do_join         (safestr_t *, safestr_t, const char *, unsigned int);
extern SAFESTR_API safestr_t        safestr_do_slice        (safestr_t, u_int32_t, u_int32_t, const char *, unsigned int);
extern SAFESTR_API safestr_t *      safestr_do_split        (safestr_t, safestr_t, const char *, unsigned int);
extern SAFESTR_API char *           safestr_do_strdup       (char *, const char *, unsigned int);

extern SAFESTR_API u_int32_t        safestr_asprintf        (safestr_t *, safestr_t, ...);
extern SAFESTR_API char             safestr_charat          (safestr_t, u_int32_t);
extern SAFESTR_API void             safestr_cleanup_asset   (void *, void *);
extern SAFESTR_API int              safestr_compare         (safestr_t, safestr_t, u_int32_t, ...);
extern SAFESTR_API void             safestr_concatenate     (safestr_t *, safestr_t, u_int32_t, ...);
extern SAFESTR_API void             safestr_delete          (safestr_t *, u_int32_t, u_int32_t);
extern SAFESTR_API void             safestr_duplicate       (safestr_t *, safestr_t, u_int32_t, ...);
extern SAFESTR_API int              safestr_endswith        (safestr_t, safestr_t);
extern SAFESTR_API int              safestr_equal           (safestr_t, safestr_t, u_int32_t, ...);
extern SAFESTR_API u_int32_t        safestr_fprintf         (FILE *, safestr_t, ...);
extern SAFESTR_API void             safestr_free            (safestr_t);
extern SAFESTR_API void             safestr_freelist        (safestr_t *);
extern SAFESTR_API void             safestr_insert          (safestr_t *, u_int32_t, safestr_t);
extern SAFESTR_API u_int32_t        safestr_length          (safestr_t);
extern SAFESTR_API void             safestr_memzero         (volatile void *, u_int32_t);
extern SAFESTR_API u_int32_t        safestr_printf          (safestr_t, ...);
extern SAFESTR_API safestr_t        safestr_reference       (safestr_t);
extern SAFESTR_API void             safestr_replace         (safestr_t *, safestr_t, safestr_t);
extern SAFESTR_API u_int32_t        safestr_search          (safestr_t, safestr_t, u_int32_t, ...);
extern SAFESTR_API void             safestr_setcharat       (safestr_t, u_int32_t, char, int);
extern SAFESTR_API void             safestr_setmemfns       (safestr_malloc_t, safestr_realloc_t, safestr_free_t);
extern SAFESTR_API u_int32_t        safestr_sprintf         (safestr_t *, safestr_t, ...);
extern SAFESTR_API int              safestr_startswith      (safestr_t, safestr_t);
extern SAFESTR_API void             safestr_truncate        (safestr_t *, u_int32_t);
extern SAFESTR_API u_int32_t        safestr_vasprintf       (safestr_t *, safestr_t, va_list);
extern SAFESTR_API u_int32_t        safestr_vfprintf        (FILE *, safestr_t fmt, va_list);
extern SAFESTR_API u_int32_t        safestr_vprintf         (safestr_t, va_list);
extern SAFESTR_API u_int32_t        safestr_vsprintf        (safestr_t *, safestr_t, va_list);

extern SAFESTR_API void             safestr_trust           (safestr_t);
extern SAFESTR_API void             safestr_untrust         (safestr_t);
extern SAFESTR_API int              safestr_istrusted       (safestr_t);
extern SAFESTR_API void             safestr_makereadonly    (safestr_t);
extern SAFESTR_API void             safestr_makewritable    (safestr_t);
extern SAFESTR_API int              safestr_isreadonly      (safestr_t);

extern SAFESTR_API void             safestr_convert         (safestr_t, u_int32_t);
extern SAFESTR_API safestr_t        safestr_do_getpassword  (FILE *, safestr_t, const char *file, unsigned int lineno);
extern SAFESTR_API safestr_t        safestr_do_readline     (FILE *f, const char *file, unsigned int lineno);
extern SAFESTR_API double           safestr_todouble        (safestr_t);
extern SAFESTR_API int32_t          safestr_toint32         (safestr_t, int);
extern SAFESTR_API int64_t          safestr_toint64         (safestr_t, int);
extern SAFESTR_API u_int32_t        safestr_touint32        (safestr_t, int);
extern SAFESTR_API u_int64_t        safestr_touint64        (safestr_t, int);
extern SAFESTR_API void             safestr_trim            (safestr_t, u_int32_t);

extern SAFESTR_API void *           safestr_default_malloc  (size_t, const char *, unsigned int);
extern SAFESTR_API void *           safestr_default_realloc (void *, size_t, const char *, unsigned int);
extern SAFESTR_API void             safestr_default_free    (void *, const char *, unsigned int);

#ifdef __cplusplus
}
#endif

#endif /* SAFESTR_H */
