# ag

> Silver Searcher と呼ばれます。`ack` コマンドに似ていますが、より高速化を目指したコマンドです。
> もっと詳しく: <https://manned.org/ag>。

- "foo"という文字列が含まれるファイルを検索し、コンテキスト内でマッチした行を出力する:

`ag {{foo}}`

- 特定のディレクトリ内で、"foo"という文字列が含まれるファイルを検索する:

`ag {{foo}} {{ディレクトリパス}}`

- "foo"という文字列が含まれるファイルの一覧をリストアップする:

`ag -l {{foo}}`

- 大文字と小文字を区別せずに、"FOO"という文字列が含まれるファイルを検索し、マッチした行のみ出力する:

`ag -i -o {{FOO}}`

- "bar"という名前にマッチするファイルから、"foo"という文字列を検索する:

`ag {{foo}} -G {{bar}}`

- 正規表現にマッチするコンテンツが含まれるファイルを検索する:

`ag '{{^ba(r|z)$}}'`

- ファイル名が "foo" に一致するファイルを検索する:

`ag -g {{foo}}`
