# ssh

> Secure Shell は、リモートシステムに安全にログオンするために使用されるプロトコルです。
> これは、リモート・サーバー上でのロギングやコマンド実行に使用できます。
> もっと詳しく: <https://man.openbsd.org/ssh>。

- リモートサーバに接続する:

`ssh {{ユーザ名}}@{{リモートホスト}}`

- 特定のID(秘密鍵)でリモートサーバに接続する:

`ssh -i {{path/to/key_file}} {{ユーザ名}}@{{リモートホスト}}`

- 特定のポート([p]ort)を使ってリモートサーバに接続する:

`ssh {{ユーザ名}}@{{リモートホスト}} -p {{2222}}`

- リモートコマンドとのやり取りを許可する[t]ty割当を使って、リモートサーバ上でコマンドを実行する:

`ssh {{ユーザ名}}@{{リモートホスト}} -t {{コマンド}} {{コマンド引数}}`

- SSHトンネリング： [D]ynamic port forwarding (`localhost:1080` の SOCKSプロキシ):

`ssh -D {{1080}} {{ユーザ名}}@{{リモートホスト}}`

- SSHトンネリング： 特定のポート(`localhost:9999`から`example.org:80`)を転送し、擬似[T]tyの割当とリモートコマンドの実行(executio[N])を無効にする:

`ssh -L {{9999}}:{{example.org}}:{{80}} -N -T {{ユーザ名}}@{{リモートホスト}}`

- SSH [J]umping： ジャンプホストを経由して、リモートサーバーに接続する (カンマ区切りで複数のジャンプホップを指定できる):

`ssh -J {{ユーザ名}}@{{ジャンプホスト}} {{ユーザ名}}@{{リモートホスト}}`

- ハングしたセッションを閉じる:

`<Enter><~><.>`
