# g++

> C++ 소스 파일을 컴파일합니다.
> GCC (GNU 컴파일로 모음)의 일부입니다.
> 더 많은 정보: <https://gcc.gnu.org/onlinedocs/gcc/C_002b_002b-Dialect-Options.html>.

- 소스 코드 파일을 실행 가능한 바이너리로 컴파일합니다:

`g++ {{소스/파일/경로.cpp}} {{[-o|--output]}} {{출력/실행파일/경로}}`

- 일반적인 경고를 표시합니다:

`g++ {{소스/파일/경로.cpp}} -Wall {{[-o|--output]}} {{출력/실행파일/경로}}`

- 컴파일할 때 사용할 언어 표준을 선택합니다 (C++98/C++11/C++14/C++17):

`g++ {{소스/파일/경로.cpp}} -std={{c++98|c++11|c++14|c++17}} {{[-o|--output]}} {{출력/실행파일/경로}}`

- 소스 파일과 다른 경로에 위치한 라이브러리들을 포함합니다:

`g++ {{소스/파일/경로.cpp}} {{[-o|--output]}} {{출력/실행파일/경로}} -I{{헤더/경로}} -L{{라이브러리/경로}} -l{{라이브러리명}}`

- 다수의 소스 코드 파일을 실행 가능한 바이너리로 컴파일하고 링킹합니다:

`g++ -c {{소스/파일/경로1.cpp 소스/파일/경로2.cpp ...}} && g++ {{[-o|--output]}} {{출력/실행파일/경로}} {{소스/파일/경로1.o 소스/파일/경로2.o ...}}`

- 버전을 표시합니다:

`g++ --version`
