# kill

> 보통 프로세스를 정지시키는 것과 관련된 시그널을 전송합니다.
> SIGKILL과 SIGSTOP을 제외한 모든 시그널들은 깔끔한 종료를 위해 프로세스에게 뺏길 수 있습니다.
> 더 많은 정보: <https://manned.org/kill.1posix>.

- 기본 SIGTERM ("terminate") 시그널을 보내 프로그램을 종료:

`kill {{프로세스_아이디}}`

- 사용 가능한 시그널 이름을 출력 (`SIG` 접두사는 없이 출력):

`kill -l`

- 백그라운드 job 종료:

`kill %{{job_아이디}}`

- SIGHUP ("hang up") 시그널을 사용해서 프로그램을 종료. 대다수의 데몬(백그라운드 프로세스)은 종료하는 대신 리로드 함:

`kill -{{1|HUP}} {{프로세스_아이디}}`

- SIGINT ("interrupt") 시그널을 사용해서 프로그램을 종료. 이건 일반적으로 사용자가 `<Ctrl c>`를 누를 때 일어나는 일과 같음:

`kill -{{2|INT}} {{프로세스_아이디}}`

- 운영체제에게 즉시 프로그램을 종료하라는 시그널을 전송 (프로세스가 신호를 받지 못하고 종료됨):

`kill -{{9|KILL}} {{프로세스_아이디}}`

- 운영체제에게 SIGCONT ("continue") 시그널을 받기 전까지 프로그램을 일시정지하라는 시그널을 전송:

`kill -{{17|STOP}} {{프로세스_아이디}}`

- 주어진 GID (그룹 아이디)를 가진 모든 프로세스에게 `SIGUSR1` 시그널을 전송:

`kill -{{SIGUSR1}} -{{그룹_아이디}}`
