# git bundle

> ஒரு காப்பக கோப்பில் பொருள்கள் மற்றும் குறிப்புகளை தொகுக்கவும்.
> மேலும் விவரத்திற்கு: <https://git-scm.com/docs/git-bundle>.

- ஒரு குறிப்பிட்ட கிளையின் அனைத்து பொருள்கள் மற்றும் குறிப்புகளைக் கொண்ட ஒரு மூட்டை கோப்பை உருவாக்கவும்:

`git bundle create {{கோப்பு.bundle/பாதை}} {{கிளையின்_பெயர்}}`

- அனைத்து கிளைகளின் மூட்டை கோப்பை உருவாக்கவும்:

`git bundle create {{கோப்பு.bundle/பாதை}} --all`

- தற்போதைய கிளையின் கடைசி 5 கமிட்டுகளின் மூட்டை கோப்பை உருவாக்கவும்:

`git bundle create {{கோப்பு.bundle/பாதை}} -5 {{HEAD}}`

- சமீபத்திய 7 நாட்களின் மூட்டை கோப்பை உருவாக்கவும்:

`git bundle create {{கோப்பு.bundle/பாதை}} --since=7.days {{HEAD}}`

- ஒரு மூட்டை கோப்பு தற்போதைய களஞ்சியத்தில் செல்லுபடியாகும் மற்றும் பயன்படுத்தலாம் என்பதை சரிபார்க்கவும்:

`git bundle verify {{கோப்பு.bundle/பாதை}}`

- ஒரு மூட்டையில் உள்ள குறிப்புகளின் பட்டியலை நிலையான வெளியீட்டில் அச்சிடுக:

`git bundle unbundle {{கோப்பு.bundle/பாதை}}`

- ஒரு மூட்டை கோப்பிலிருந்து ஒரு குறிப்பிட்ட கிளையை தற்போதைய களஞ்சியத்தில் இணைக்கவும்:

`git pull {{கோப்பு.bundle/பாதை}} {{கிளையின்_பெயர்}}`
