# cp

> 复制文件和目录。
> 更多信息：<https://www.gnu.org/software/coreutils/manual/html_node/cp-invocation.html>.

- 将文件复制到另一个位置：

`cp {{路径/到/源_文件.ext}} {{路径/到/目标文件.ext}}`

- 将文件复制到另一个文件夹，并保留原来的文件名：

`cp {{路径/到/源文件.ext}} {{路径/到/目标的目录}}`

- 以递归方式将文件夹内的内容复制到另一个位置（如果目标文件夹存在，则将此文件夹复制到目标文件夹中）：

`cp {{[-r|--recursive]}} {{路径/到/源目录}} {{路径/到/目标目录}}`

- 以详细模式递归复制目录（在复制文件时显示文件信息）：

`cp {{[-vr|--verbose --recursive]}} {{路径/到/源目录}} {{路径/到/目标目录}}`

- 一次将多个文件复制到一个目录：

`cp {{[-t|--target-directory]}} {{路径/到/目标_目录}} {{路径/到/文件1 路径/到/文件2 ...}}`

- 以交互方式将文本文件复制到另一个位置（覆盖之前会提示用户）：

`cp {{[-i|--interactive]}} {{*.txt}} {{路径/到/目标_目录}}`

- 复制之前遵循符号链接：

`cp {{[-L|--dereference]}} {{链接}} {{路径/到/目标_目录}}`

- 使用第一个参数作为目标目录（对于 `xargs ... | cp -t <目标_目录>` 这样的命令非常有用）：

`cp {{[-t|--target-directory]}} {{路径/到/目标目录}} {{路径/到/文件或目录1 路径/到/文件或目录2 ...}}`
