# clamdscan

> Scan for viruses using the ClamAV Daemon.
> More information: <https://docs.clamav.net/manual/Usage/Scanning.html#clamdscan>.

- Scan a file or directory for vulnerabilities:

`clamdscan {{path/to/file_or_directory}}`

- Scan data from `stdin`:

`{{command}} | clamdscan -`

- Scan the current directory and output only infected files:

`clamdscan --infected`

- Print the scan report to a log file:

`clamdscan --log {{path/to/log_file}}`

- Move infected files to a specific directory:

`clamdscan --move {{path/to/quarantine_directory}}`

- Remove infected files:

`clamdscan --remove`

- Use multiple threads to scan a directory:

`clamdscan --multiscan`

- Pass the file descriptor instead of streaming the file to the daemon:

`clamdscan --fdpass`
