# node

> Server-side JavaScript platform (Node.js).
> More information: <https://nodejs.org/docs/latest/api/cli.html#options>.

- Run a JavaScript file:

`node {{path/to/file}}`

- Start a REPL (interactive shell):

`node`

- Execute the specified file restarting the process when an imported file is changed (requires Node.js version 18.11+):

`node --watch {{path/to/file}}`

- Evaluate JavaScript code by passing it as an argument:

`node {{[-e|--eval]}} "{{code}}"`

- Evaluate and print the result, useful to print node's dependencies versions:

`node {{[-p|--print]}} "process.versions"`

- Activate inspector, pausing execution until a debugger is connected once source code is fully parsed:

`node --no-lazy --inspect-brk {{path/to/file}}`
