# x8

> A hidden parameters discovery suite for identifying vulnerable or interesting web parameters.
> More information: <https://github.com/Sh1Yo/x8/blob/main/docs.md>.

- Check hidden parameters in a URL query:

`x8 {{[-u|--url]}} {{https://example.com/}} {{[-w|--wordlist]}} {{path/to/wordlist.txt}}`

- Check parameters with a custom query injection point (`%s`):

`x8 {{[-u|--url]}} {{https://example.com/?something=1%26%s}} {{[-w|--wordlist]}} {{path/to/wordlist.txt}}`

- Send parameters via POST body with JSON format:

`x8 {{[-u|--url]}} {{https://example.com/}} {{[-X|--method]}} {{POST}} {{[-b|--body]}} '{{{"x":{%s\}\}}}' {{[-w|--wordlist]}} {{path/to/wordlist.txt}}`

- Check parameters with a custom template (`%k` for key, `%v` for value):

`x8 {{[-u|--url]}} {{https://example.com/}} {{[-P|--param-template]}} {{user[%k]=%v}} {{[-w|--wordlist]}} {{path/to/wordlist.txt}}`

- Encode parameters for special characters in queries:

`x8 {{[-u|--url]}} {{https://example.com/?path=..%2faction.php%3f%s%23}} --encode {{[-w|--wordlist]}} {{path/to/wordlist.txt}}`

- Discover hidden headers for a URL:

`x8 {{[-u|--url]}} {{https://example.com/}} --headers {{[-w|--wordlist]}} {{path/to/headers.txt}}`

- Check multiple URLs in parallel with high concurrency and verify found parameters:

`x8 {{[-u|--url]}} {{https://example.com/}} {{https://4rt.one/}} {{[-W|--workers]}} {{0}} -c {{3}} --verify`

- Save request and response data for found parameters to a directory:

`x8 {{[-u|--url]}} {{https://example.com/}} {{[-w|--wordlist]}} {{path/to/wordlist.txt}} --save-responses {{path/to/output_directory}}`
