# git commit

> リポジトリにファイルをコミットします。
> もっと詳しく: <https://git-scm.com/docs/git-commit>。

- メッセージと共に、ステージ済のファイルをリポジトリにコミットする:

`git commit {{[-m|--message]}} "{{メッセージ}}"`

- ファイルから読みとったメッセージと共に、ステージ済のファイルをコミットする:

`git commit {{[-F|--file]}} {{コミットメッセージが書かれたファイルへのパス}}`

- 変更されたファイルを全て自動的にステージし、メッセージと共にコミットする:

`git commit {{[-a|--all]}} {{[-m|--message]}} "{{メッセージ}}"`

- 今のステージ済の変更を最後のコミットに付け足し、コミットハッシュを変更する:

`git commit --amend`

- 特定のファイル(ステージ済)だけをコミットする:

`git commit {{ファイルパス1 ファイルパス2 ...}}`

- ステージ済のファイルが無くても、コミットを作る:

`git commit {{[-m|--message]}} "{{メッセージ}}" --allow-empty`
