# rgrep

> 정규 표현식을 사용하여 파일에서 패턴을 재귀적으로 찾기.
> `grep -r`와 동일합니다.
> 더 많은 정보: <https://www.gnu.org/software/grep/manual/grep.html#Command_002dline-Options>.

- 현재 작업 디렉토리에서 패턴을 재귀적으로 검색:

`rgrep "{{검색_패턴}}"`

- 현재 작업 디렉토리에서 대소문자를 구분하지 않고 패턴을 재귀적으로 검색:

`rgrep --ignore-case "{{검색_패턴}}"`

- 현재 작업 디렉토리에서 확장 정규 표현식 패턴 (지원 기능: `?`, `+`, `{}`, `()` 및 `|`)을 재귀적으로 검색:

`rgrep --extended-regexp "{{검색_패턴}}"`

- 현재 작업 디렉토리에서 정확한 문자열(정규 표현식 비활성화)을 재귀적으로 검색:

`rgrep --fixed-strings "{{정확한_문자열}}"`

- 지정된 디렉토리(또는 파일)에서 패턴을 재귀적으로 검색:

`rgrep "{{검색_패턴}}" {{경로/대상/파일_또는_디렉토리}}`
