# gcc

> C மற்றும் C++ மூலக் கோப்புகளை முன் செயலாக்கம் செய்து தொகுத்து, பின்னர் அவற்றைச் சேகரித்து இணைக்கவும்.
> GCC (GNU கம்பைலர் சேகரிப்பு) இன் ஒரு பகுதி.
> மேலும் விவரத்திற்கு: <https://gcc.gnu.org/onlinedocs/gcc/>.

- பல மூல கோப்புகளை இயங்கக்கூடியதாகத் தொகுக்கவும்:

`gcc {{மூலம்1.c/பாதை மூலம்2.c/பாதை ...}} {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}}`

- அனைத்து பிழைகள் மற்றும் எச்சரிக்கைகளின் வெளியீட்டைச் செயல்படுத்தவும்:

`gcc {{மூலம்.c/பாதை}} -Wall {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}}`

- பொதுவான எச்சரிக்கைகளைக் காட்டு, வெளியீட்டில் சின்னங்களைப் பிழைத்திருத்தம் செய், பின்னர் பிழைத்திருத்தத்தைப் பாதிக்காமல் மேம்படுத்து:

`gcc {{மூலம்.c/பாதை}} -Wall {{[-g|--debug]}} -Og {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}}`

- வேறு பாதையிலிருந்து நூலகங்களைச் சேர்க்கவும்:

`gcc {{மூலம்.c/பாதை}} {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}} -I{{தலைப்பிற்கு/பாதை}} -L{{நூலகத்திற்கு/பாதை}} -l{{நூலகம்_பெயர்}}`

- மூலக் குறியீட்டை அசெம்பிளர் வழிமுறைகளில் தொகுக்கவும்:

`gcc {{[-S|--assemble]}} {{மூலம்.c/பாதை}}`

- இணைக்காமல் மூலக் குறியீட்டை தொகுக்கவும்:

`gcc {{[-c|--compile]}} {{மூலம்.c/பாதை}}`

- செயல்திறனுக்காக தொகுக்கப்பட்ட நிரலை மேம்படுத்தவும்:

`gcc {{மூலம்.c/பாதை}} -O{{1|2|3|fast}} {{[-o|--output]}} {{வெளியீடு_இயங்கக்கூடியது/பாதை}}`

- பதிப்பைக் காட்டு:

`gcc --version`
