# git push

> 推送提交到远程仓库。
> 更多信息：<https://git-scm.com/docs/git-push>.

- 将当前分支的本地更改推送到其默认的远程对应分支：

`git push`

- 将指定本地分支的更改推送到其远程对应分支：

`git push {{远程仓库名}} {{本地分支名}}`

- 将指定本地分支的更改推送到其远程对应分支，并将该远程分支设为该本地分支 push/pull 的默认目标分支：

`git push {{[-u|--set-upstream]}} {{远程仓库名}} {{本地分支名}}`

- 将指定本地分支的更改推送到指定的远程分支：

`git push {{远程仓库名}} {{本地分支名}}:{{远程分支名}}`

- 将所有本地分支的更改推送到指定远程仓库中各个对应分支：

`git push --all {{远程仓库名}}`

- 删除远程仓库中的分支：

`git push {{远程仓库名}} {{[-d|--delete]}} {{远程分支名}}`

- 删除没有本地对应分支的远程分支：

`git push --prune {{远程仓库名}}`

- 推送本地的新标签到远程仓库：

`git push --tags`
