############################################################################
# Copyright (c) 2016, Johan Mabille and Sylvain Corlay                     #
#                                                                          #
# Distributed under the terms of the BSD 3-Clause License.                 #
#                                                                          #
# The full license is in the file LICENSE, distributed with this software. #
############################################################################

# xproperty cmake module
# This module sets the following variables in your project::
#
#   xproperty_FOUND - true if xproperty found on the system
#   xproperty_INCLUDE_DIR - the directory containing xproperty headers
#   xproperty_LIBRARY - empty


####### Expanded from @PACKAGE_INIT@ by configure_package_config_file() #######
####### Any changes to this file will be overwritten by the next CMake run ####
####### The input file was xpropertyConfig.cmake.in                            ########

get_filename_component(PACKAGE_PREFIX_DIR "${CMAKE_CURRENT_LIST_DIR}/../../../" ABSOLUTE)

macro(set_and_check _var _file)
  set(${_var} "${_file}")
  if(NOT EXISTS "${_file}")
    message(FATAL_ERROR "File or directory ${_file} referenced by variable ${_var} does not exist !")
  endif()
endmacro()

macro(check_required_components _NAME)
  foreach(comp ${${_NAME}_FIND_COMPONENTS})
    if(NOT ${_NAME}_${comp}_FOUND)
      if(${_NAME}_FIND_REQUIRED_${comp})
        set(${_NAME}_FOUND FALSE)
      endif()
    endif()
  endforeach()
endmacro()

####################################################################################

set(CMAKE_MODULE_PATH "${CMAKE_CURRENT_LIST_DIR};${CMAKE_MODULE_PATH}")



include(CMakeFindDependencyMacro)
# nlohmann_json requires libraries that exchange json objects to be linked
# with the same version of nlohmann_json. 
find_dependency(nlohmann_json 3.12.0 EXACT)

if(NOT TARGET xproperty)
    include("${CMAKE_CURRENT_LIST_DIR}/xpropertyTargets.cmake")
    get_target_property(xproperty_INCLUDE_DIR xproperty INTERFACE_INCLUDE_DIRECTORIES)
endif()

set(xproperty_LIBRARY "")
